/*************************************************************
 *
 *  MathJax/fonts/HTML-CSS/TeX/png/imagedata.js
 *  
 *  Copyright (c) 2009-2013 by The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

(function (HTMLCSS,AJAX) {

  HTMLCSS.defineImageData({

    "MathJax_Caligraphic": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x30: [  // DIGIT ZERO
        [4,4,0],[4,4,0],[5,5,0],[6,6,0],[7,7,0],[8,8,0],[9,9,0],[11,11,1],
        [13,13,1],[16,16,1],[18,19,1],[22,22,1],[26,26,1],[31,32,1]
      ],
      0x31: [  // DIGIT ONE
        [3,3,0],[4,4,0],[5,5,0],[5,6,0],[6,7,0],[8,8,0],[9,9,0],[10,12,1],
        [12,14,1],[15,15,0],[17,18,0],[20,21,0],[24,25,0],[29,30,0]
      ],
      0x32: [  // DIGIT TWO
        [4,3,0],[4,4,0],[5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],
        [13,13,0],[15,15,0],[18,18,0],[21,21,0],[25,25,0],[30,30,0]
      ],
      0x33: [  // DIGIT THREE
        [4,5,2],[4,6,2],[5,7,2],[6,8,3],[7,10,3],[8,11,4],[9,13,4],[11,16,5],
        [13,19,7],[15,24,8],[18,26,8],[22,31,10],[26,37,12],[30,44,14]
      ],
      0x34: [  // DIGIT FOUR
        [4,5,2],[4,6,2],[5,7,2],[6,9,3],[7,10,3],[8,11,3],[10,13,4],[11,16,5],
        [14,19,6],[16,22,6],[19,26,8],[22,31,9],[27,36,11],[31,43,13]
      ],
      0x35: [  // DIGIT FIVE
        [4,5,2],[4,6,2],[5,7,2],[6,9,3],[7,10,3],[8,11,4],[9,13,4],[11,17,6],
        [13,19,7],[15,23,8],[18,26,8],[21,31,10],[25,37,12],[30,44,14]
      ],
      0x36: [  // DIGIT SIX
        [4,5,0],[4,6,0],[5,7,0],[6,8,0],[7,10,0],[8,12,0],[9,13,0],[11,16,1],
        [13,19,1],[15,22,1],[18,28,1],[22,32,1],[26,38,1],[30,45,1]
      ],
      0x37: [  // DIGIT SEVEN
        [4,6,2],[5,7,2],[5,8,3],[6,9,3],[7,10,3],[9,11,3],[10,14,4],[12,16,5],
        [14,20,7],[16,23,8],[19,27,9],[23,32,10],[27,38,12],[32,45,14]
      ],
      0x38: [  // DIGIT EIGHT
        [4,5,0],[4,6,0],[5,7,0],[6,8,0],[7,10,0],[8,12,0],[9,13,0],[11,16,1],
        [13,19,1],[15,23,1],[18,27,1],[22,32,1],[26,38,1],[30,45,1]
      ],
      0x39: [  // DIGIT NINE
        [4,5,2],[4,6,2],[5,7,2],[6,8,3],[7,10,3],[8,11,4],[9,13,4],[11,16,5],
        [13,19,7],[16,24,8],[18,26,8],[22,31,10],[26,37,12],[31,44,14]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [6,5,0],[7,6,0],[9,8,1],[10,9,1],[12,11,1],[14,12,0],[16,15,1],[20,18,2],
        [23,22,2],[27,26,2],[33,31,2],[39,36,2],[46,43,2],[54,51,3]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [5,5,0],[6,6,0],[7,7,0],[8,8,0],[10,10,0],[11,12,0],[13,14,0],[16,17,1],
        [19,21,1],[22,24,1],[26,29,1],[31,34,1],[37,40,1],[44,48,1]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [4,5,0],[5,6,0],[6,7,0],[7,8,0],[8,10,0],[9,12,0],[11,14,0],[13,17,1],
        [15,21,1],[18,24,1],[21,29,1],[25,34,1],[30,40,1],[36,48,1]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [6,5,0],[7,6,0],[8,7,0],[9,8,0],[11,9,0],[13,12,1],[15,15,1],[18,16,0],
        [22,19,0],[26,23,0],[30,27,0],[36,32,0],[43,37,0],[51,45,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [4,5,0],[5,6,0],[6,7,0],[7,8,0],[8,10,0],[10,12,0],[11,14,0],[14,17,1],
        [16,21,1],[19,24,1],[23,29,1],[27,34,1],[32,40,1],[38,48,1]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [6,5,0],[7,6,0],[9,7,0],[10,8,0],[12,10,0],[14,12,0],[17,15,0],[20,17,1],
        [23,20,1],[28,24,1],[33,28,1],[39,34,1],[46,40,2],[55,47,2]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [5,6,1],[5,7,1],[6,8,1],[8,10,2],[9,11,1],[10,14,2],[12,17,3],[14,19,3],
        [17,23,3],[20,27,4],[24,32,4],[28,39,6],[34,46,7],[40,54,7]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [6,5,0],[7,6,0],[8,7,0],[10,8,0],[12,10,0],[14,12,0],[16,14,0],[19,17,1],
        [23,21,1],[27,24,1],[32,29,2],[38,34,2],[45,41,2],[53,48,3]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [6,5,0],[7,6,0],[8,7,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[16,16,0],
        [19,19,0],[23,23,0],[28,27,0],[32,32,0],[38,38,0],[45,45,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [6,6,1],[7,7,1],[9,8,1],[10,10,1],[12,11,2],[14,14,3],[17,17,3],[20,19,3],
        [24,22,3],[28,27,4],[33,32,5],[40,38,6],[47,44,7],[56,53,8]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [6,5,0],[7,6,0],[8,7,0],[9,8,0],[11,10,0],[13,12,0],[15,14,0],[17,17,1],
        [21,21,1],[25,24,1],[29,29,1],[34,34,1],[41,40,1],[49,48,1]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,5,0],[6,6,0],[7,7,0],[8,8,0],[10,10,0],[11,12,0],[13,14,0],[16,17,1],
        [19,21,1],[22,24,1],[26,29,1],[31,34,1],[37,40,1],[44,48,1]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [8,5,0],[10,7,1],[12,8,1],[14,8,0],[16,10,0],[19,13,1],[23,15,1],[27,18,2],
        [32,22,2],[38,25,2],[45,30,2],[53,35,2],[63,41,2],[75,50,3]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [8,6,0],[10,7,0],[11,9,1],[13,12,1],[15,13,1],[18,14,0],[21,17,1],[24,20,2],
        [29,24,2],[34,28,2],[40,33,2],[48,39,2],[57,46,2],[67,56,3]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [6,5,0],[7,6,0],[8,7,0],[10,8,0],[11,10,0],[13,12,0],[16,14,0],[19,17,1],
        [22,21,1],[26,24,1],[31,29,1],[37,34,1],[43,40,1],[52,48,1]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [6,6,1],[7,6,0],[8,8,1],[9,9,1],[11,11,1],[13,13,1],[15,16,2],[17,18,1],
        [21,21,2],[24,25,2],[29,29,3],[34,35,3],[41,41,3],[48,49,4]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,7,1],[8,8,1],[10,9,1],[11,11,1],[14,14,2],[16,17,3],[19,19,3],
        [22,24,4],[26,28,5],[31,33,5],[37,39,6],[44,46,7],[52,55,8]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [6,5,0],[7,6,0],[9,7,0],[10,8,0],[12,10,0],[14,12,0],[17,15,0],[20,17,1],
        [24,19,1],[28,23,1],[33,28,1],[39,33,1],[47,39,1],[56,46,1]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [5,5,0],[6,6,0],[7,7,0],[8,8,0],[9,10,0],[11,12,0],[13,14,0],[15,17,1],
        [18,21,1],[22,24,1],[26,29,1],[30,34,1],[36,40,1],[43,48,1]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,11,1],[14,13,1],[17,15,1],[20,18,2],
        [23,22,2],[28,26,3],[33,31,3],[39,37,4],[46,44,4],[55,52,5]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [6,5,0],[7,6,0],[8,7,0],[10,8,0],[11,10,0],[13,12,0],[15,14,0],[17,17,1],
        [20,20,1],[24,24,1],[28,28,1],[33,33,1],[40,39,1],[48,47,1]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [5,6,1],[6,7,1],[7,8,1],[8,9,1],[10,11,1],[11,13,1],[13,15,1],[16,18,1],
        [19,21,2],[22,25,2],[26,30,3],[31,34,2],[37,41,3],[44,49,3]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [8,6,1],[9,7,1],[11,8,1],[13,9,1],[15,11,1],[18,13,1],[21,15,1],[25,18,1],
        [29,21,2],[35,26,3],[41,30,3],[49,35,3],[58,42,4],[69,50,4]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [6,5,0],[7,6,0],[8,7,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,0],
        [23,19,0],[27,23,0],[32,27,0],[38,32,0],[45,38,0],[54,45,0]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [5,6,1],[6,7,1],[8,8,1],[9,11,3],[10,12,2],[12,14,2],[14,16,2],[17,20,3],
        [20,23,4],[24,28,5],[29,33,6],[34,39,7],[40,46,8],[48,55,9]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [6,5,0],[7,6,0],[8,7,0],[10,8,0],[11,10,0],[13,12,0],[15,14,0],[18,16,0],
        [22,19,0],[26,23,0],[31,27,0],[36,32,0],[43,38,0],[51,45,0]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ]
    },

    "MathJax_Fraktur-bold": {
  
    },

    "MathJax_Fraktur": {
  
    },

    "MathJax_Main-bold": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x21: [  // EXCLAMATION MARK
        [2,5,0],[3,6,0],[3,8,0],[4,8,0],[4,9,0],[5,12,0],[6,14,0],[7,17,0],
        [8,20,0],[9,23,0],[11,28,0],[13,32,0],[15,39,0],[18,47,0]
      ],
      0x22: [  // QUOTATION MARK
        [4,3,-2],[5,4,-2],[5,4,-4],[6,4,-4],[7,5,-4],[9,7,-5],[10,8,-6],[12,9,-8],
        [14,11,-9],[17,13,-10],[20,15,-13],[23,17,-15],[28,20,-18],[33,25,-21]
      ],
      0x23: [  // NUMBER SIGN
        [7,6,1],[8,8,2],[9,10,2],[11,10,2],[13,12,3],[15,15,3],[18,18,4],[21,22,5],
        [25,26,6],[30,29,6],[35,36,8],[42,41,9],[50,49,11],[59,59,13]
      ],
      0x24: [  // DOLLAR SIGN
        [4,6,1],[5,8,1],[5,9,1],[6,9,1],[8,11,1],[9,15,1],[10,17,2],[12,20,1],
        [15,24,2],[17,27,2],[20,33,3],[24,38,3],[29,45,3],[34,54,4]
      ],
      0x25: [  // PERCENT SIGN
        [7,6,1],[8,8,1],[9,9,1],[11,9,1],[13,11,1],[15,14,1],[18,16,1],[21,21,2],
        [25,24,2],[30,27,2],[35,32,2],[42,38,3],[50,45,3],[59,54,4]
      ],
      0x26: [  // AMPERSAND
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[33,28,0],[39,32,0],[47,38,0],[55,46,0]
      ],
      0x27: [  // APOSTROPHE
        [2,3,-2],[3,4,-2],[3,4,-4],[4,4,-4],[4,5,-4],[5,7,-5],[6,8,-6],[7,9,-8],
        [8,11,-9],[9,13,-10],[11,15,-13],[13,17,-15],[15,20,-18],[18,25,-21]
      ],
      0x28: [  // LEFT PARENTHESIS
        [3,7,2],[4,9,2],[4,12,3],[5,12,3],[6,14,3],[7,18,4],[8,20,5],[9,25,6],
        [11,29,7],[13,34,8],[15,40,10],[18,47,12],[22,56,14],[25,67,17]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [3,7,2],[3,9,2],[4,12,3],[5,12,3],[5,14,3],[6,18,4],[7,20,5],[8,25,6],
        [10,29,7],[12,34,8],[14,40,10],[16,47,12],[19,56,14],[23,67,17]
      ],
      0x2A: [  // ASTERISK
        [4,3,-2],[5,4,-3],[5,5,-3],[6,5,-3],[7,6,-4],[9,8,-5],[10,9,-6],[12,11,-7],
        [14,13,-9],[17,15,-10],[20,18,-12],[24,21,-14],[28,25,-17],[33,30,-20]
      ],
      0x2B: [  // PLUS SIGN
        [6,6,1],[7,7,1],[9,9,1],[10,9,1],[12,11,2],[14,14,2],[17,16,3],[20,19,3],
        [23,22,4],[28,26,4],[33,31,5],[39,36,6],[46,43,7],[55,51,9]
      ],
      0x2C: [  // COMMA
        [2,3,1],[3,4,2],[3,4,2],[4,4,2],[4,6,3],[5,7,3],[6,8,4],[6,10,5],
        [8,11,6],[9,12,6],[11,15,8],[12,17,9],[15,21,11],[17,25,13]
      ],
      0x2D: [  // HYPHEN-MINUS
        [3,1,-1],[3,1,-1],[4,3,-1],[4,3,-1],[5,3,-2],[6,2,-3],[7,3,-3],[8,3,-4],
        [9,4,-5],[11,4,-6],[13,5,-7],[15,6,-8],[18,7,-9],[21,8,-11]
      ],
      0x2E: [  // FULL STOP
        [2,2,0],[3,2,0],[3,2,0],[3,2,0],[4,3,0],[5,4,0],[5,4,0],[6,5,0],
        [7,5,0],[9,6,0],[10,7,0],[12,8,0],[14,10,0],[17,12,0]
      ],
      0x2F: [  // SOLIDUS
        [4,7,2],[5,9,2],[5,11,3],[6,11,3],[8,14,3],[9,18,4],[10,20,5],[12,25,6],
        [15,29,7],[17,33,8],[20,40,10],[24,47,12],[29,56,14],[34,67,17]
      ],
      0x30: [  // DIGIT ZERO
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,13,0],[13,17,0],
        [15,20,0],[18,22,0],[21,26,0],[25,31,0],[30,37,0],[35,44,0]
      ],
      0x31: [  // DIGIT ONE
        [4,5,0],[5,6,0],[5,7,0],[6,8,0],[7,9,0],[9,12,0],[10,13,0],[12,16,0],
        [14,19,0],[17,22,0],[20,26,0],[23,31,0],[28,36,0],[33,44,0]
      ],
      0x32: [  // DIGIT TWO
        [4,5,0],[5,6,0],[6,7,0],[7,7,0],[8,9,0],[9,12,0],[11,14,0],[12,16,0],
        [15,19,0],[18,22,0],[21,26,0],[25,30,0],[29,36,0],[35,44,0]
      ],
      0x33: [  // DIGIT THREE
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,13,0],[13,17,0],
        [15,19,0],[18,22,0],[21,27,0],[25,31,0],[30,37,0],[35,44,0]
      ],
      0x34: [  // DIGIT FOUR
        [4,5,0],[5,7,1],[6,8,1],[7,9,1],[8,10,1],[9,13,1],[11,14,1],[13,17,1],
        [15,20,1],[18,23,1],[22,27,1],[26,32,1],[30,37,1],[36,45,1]
      ],
      0x35: [  // DIGIT FIVE
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,14,0],[12,16,0],
        [15,19,0],[18,23,0],[21,27,0],[25,31,0],[29,37,0],[35,45,0]
      ],
      0x36: [  // DIGIT SIX
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,13,0],[13,17,0],
        [15,19,0],[18,22,0],[21,27,0],[25,31,0],[30,37,0],[35,44,0]
      ],
      0x37: [  // DIGIT SEVEN
        [4,5,0],[5,7,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[11,14,0],[13,17,0],
        [16,20,0],[19,23,0],[22,27,0],[26,32,0],[31,38,0],[37,45,0]
      ],
      0x38: [  // DIGIT EIGHT
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,13,0],[13,17,0],
        [15,19,0],[18,22,0],[21,27,0],[25,31,0],[30,37,0],[35,44,0]
      ],
      0x39: [  // DIGIT NINE
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,13,0],[13,17,0],
        [15,20,0],[18,22,0],[21,27,0],[25,31,0],[30,37,0],[35,44,0]
      ],
      0x3A: [  // COLON
        [2,3,0],[3,4,0],[3,5,0],[3,5,0],[4,6,0],[5,8,0],[5,9,0],[6,11,0],
        [7,13,0],[9,15,0],[10,18,0],[12,21,0],[14,25,0],[17,30,0]
      ],
      0x3B: [  // SEMICOLON
        [2,4,1],[3,6,2],[3,7,2],[3,7,2],[4,9,3],[5,11,3],[5,13,4],[6,16,5],
        [7,19,6],[9,21,6],[10,26,8],[12,30,9],[14,36,11],[17,43,13]
      ],
      0x3C: [  // LESS-THAN SIGN
        [6,5,1],[7,6,1],[8,8,1],[10,8,1],[12,9,1],[14,12,1],[16,14,2],[19,17,2],
        [23,20,2],[27,23,3],[32,27,3],[38,32,4],[45,38,5],[53,45,6]
      ],
      0x3D: [  // EQUALS SIGN
        [6,2,0],[7,3,-1],[9,3,-1],[10,3,-1],[12,4,-1],[14,6,-1],[17,6,-1],[20,8,-2],
        [23,8,-3],[28,9,-4],[33,12,-4],[39,13,-5],[46,16,-6],[55,19,-7]
      ],
      0x3E: [  // GREATER-THAN SIGN
        [6,5,1],[7,6,1],[8,8,1],[10,8,1],[11,9,1],[14,12,1],[16,14,2],[19,17,2],
        [22,20,2],[27,23,3],[32,27,3],[37,32,4],[45,38,5],[53,45,6]
      ],
      0x3F: [  // QUESTION MARK
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[10,14,0],[11,17,0],
        [14,20,0],[16,23,0],[19,28,0],[23,32,0],[27,38,0],[32,46,0]
      ],
      0x40: [  // COMMERCIAL AT
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [21,20,0],[25,23,0],[30,28,0],[36,32,0],[42,38,0],[50,46,0]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [22,20,0],[26,23,0],[30,28,0],[36,32,0],[43,38,0],[51,46,0]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[46,38,0],[54,45,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,17,0],
        [20,20,0],[24,23,0],[29,28,0],[34,32,0],[40,38,0],[48,46,0]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[14,14,0],[16,17,0],
        [19,20,0],[23,23,0],[27,28,0],[32,32,0],[38,38,0],[45,46,0]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[34,28,0],[40,33,1],[47,39,1],[56,47,1]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,28,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [3,5,0],[4,6,0],[5,8,0],[5,8,0],[6,9,0],[7,12,0],[8,14,0],[10,17,0],
        [12,20,0],[14,23,0],[17,28,0],[20,32,0],[23,38,0],[27,46,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,14,0],[13,17,0],
        [15,20,0],[18,23,0],[21,28,0],[25,32,0],[30,38,0],[35,46,0]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,28,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[16,17,0],
        [18,20,0],[22,23,0],[26,28,0],[31,32,0],[36,38,0],[43,46,0]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [8,6,0],[9,7,0],[11,9,0],[13,9,0],[15,10,0],[18,13,0],[21,15,0],[25,18,0],
        [29,21,0],[35,24,0],[42,29,0],[49,33,0],[58,39,0],[70,47,0]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,28,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[45,38,0],[53,46,0]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,17,0],
        [20,20,0],[24,23,0],[29,28,0],[34,32,0],[40,38,0],[48,46,0]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,8,2],[8,10,2],[10,10,2],[12,12,3],[14,15,3],[16,18,4],[19,22,5],
        [23,26,6],[27,29,6],[32,36,8],[38,41,9],[45,49,11],[53,59,13]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,28,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[12,14,0],[14,17,0],
        [16,20,0],[19,23,0],[23,28,0],[27,32,0],[32,38,0],[38,46,0]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [21,19,0],[25,23,0],[30,27,0],[36,31,0],[42,38,0],[50,45,0]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [6,5,0],[8,6,0],[9,8,0],[10,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[34,28,0],[40,32,0],[47,39,1],[56,47,1]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [6,6,1],[7,7,1],[9,9,1],[10,9,1],[12,10,1],[14,13,1],[17,15,1],[20,18,1],
        [24,21,1],[28,24,1],[33,29,1],[40,33,1],[47,40,1],[56,47,1]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [8,6,0],[10,7,0],[12,9,0],[14,9,0],[17,10,0],[20,13,0],[23,15,0],[27,18,0],
        [33,21,0],[39,24,0],[46,29,0],[54,33,0],[65,39,0],[77,47,0]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[33,28,0],[39,32,0],[47,38,0],[55,46,0]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [6,5,0],[8,6,0],[9,8,0],[10,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[34,28,0],[40,32,0],[47,38,0],[56,46,0]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[22,23,0],[26,28,0],[30,32,0],[36,38,0],[43,46,0]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [3,7,2],[3,9,2],[3,11,3],[4,11,3],[5,13,3],[5,19,5],[6,22,6],[7,26,7],
        [9,29,7],[10,34,8],[12,40,10],[14,47,12],[17,56,14],[20,67,17]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [4,7,2],[5,9,2],[5,11,3],[6,11,3],[8,14,3],[9,18,4],[10,20,5],[12,25,6],
        [15,29,7],[17,33,8],[20,40,10],[24,47,12],[29,56,14],[34,67,17]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [2,7,2],[2,9,2],[2,11,3],[3,11,3],[3,13,3],[4,19,5],[4,22,6],[5,26,7],
        [6,29,7],[7,34,8],[8,40,10],[9,47,12],[11,56,14],[13,67,17]
      ],
      0x5E: [  // CIRCUMFLEX ACCENT
        [4,2,-3],[4,2,-5],[5,2,-6],[6,2,-6],[7,3,-7],[8,4,-9],[9,4,-10],[11,5,-13],
        [13,5,-15],[15,6,-17],[18,7,-21],[21,9,-24],[25,10,-29],[30,12,-35]
      ],
      0x5F: [  // LOW LINE
        [4,2,1],[5,2,1],[6,2,1],[7,2,1],[8,2,1],[10,2,1],[12,3,2],[14,3,2],
        [16,3,2],[19,3,2],[23,3,2],[27,4,3],[32,4,3],[38,5,4]
      ],
      0x60: [  // GRAVE ACCENT
        [3,2,-3],[3,2,-4],[4,3,-5],[4,3,-5],[5,3,-6],[6,4,-8],[7,5,-9],[8,5,-12],
        [10,6,-14],[12,7,-16],[14,9,-19],[16,10,-23],[19,12,-27],[23,14,-33]
      ],
      0x61: [  // LATIN SMALL LETTER A
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],
        [16,13,0],[19,15,0],[22,18,0],[26,21,0],[31,25,0],[37,30,0]
      ],
      0x62: [  // LATIN SMALL LETTER B
        [5,5,0],[5,6,0],[6,8,0],[8,8,0],[9,9,0],[10,12,0],[12,14,0],[14,17,0],
        [17,20,0],[20,23,0],[24,28,0],[28,32,0],[34,38,0],[40,46,0]
      ],
      0x63: [  // LATIN SMALL LETTER C
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[10,9,0],[12,11,0],
        [14,13,0],[16,15,0],[19,18,0],[23,21,0],[27,25,0],[32,30,0]
      ],
      0x64: [  // LATIN SMALL LETTER D
        [5,5,0],[6,6,0],[6,8,0],[8,8,0],[9,9,0],[11,12,0],[12,14,0],[15,17,0],
        [17,20,0],[20,23,0],[24,28,0],[29,32,0],[34,38,0],[40,46,0]
      ],
      0x65: [  // LATIN SMALL LETTER E
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],
        [14,13,0],[17,15,0],[20,18,0],[23,21,0],[28,25,0],[33,30,0]
      ],
      0x66: [  // LATIN SMALL LETTER F
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,17,0],
        [13,20,0],[15,23,0],[18,28,0],[21,32,0],[25,38,0],[30,46,0]
      ],
      0x67: [  // LATIN SMALL LETTER G
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[8,9,3],[10,11,3],[11,13,4],[13,16,5],
        [16,19,6],[19,21,6],[22,26,8],[26,30,9],[31,36,11],[37,43,13]
      ],
      0x68: [  // LATIN SMALL LETTER H
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[21,23,0],[25,28,0],[29,32,0],[35,38,0],[41,46,0]
      ],
      0x69: [  // LATIN SMALL LETTER I
        [3,5,0],[3,6,0],[3,8,0],[4,8,0],[5,9,0],[5,12,0],[6,14,0],[7,17,0],
        [9,20,0],[10,23,0],[12,28,0],[14,32,0],[17,38,0],[20,46,0]
      ],
      0x6A: [  // LATIN SMALL LETTER J
        [3,6,1],[4,8,2],[4,10,2],[5,10,2],[5,12,3],[7,15,3],[8,18,4],[9,22,5],
        [10,26,6],[13,29,6],[14,36,8],[17,41,9],[20,49,11],[24,59,13]
      ],
      0x6B: [  // LATIN SMALL LETTER K
        [5,5,0],[5,6,0],[6,8,0],[7,8,0],[9,9,0],[10,12,0],[12,14,0],[14,17,0],
        [17,20,0],[20,23,0],[23,28,0],[28,32,0],[33,38,0],[39,46,0]
      ],
      0x6C: [  // LATIN SMALL LETTER L
        [3,5,0],[3,6,0],[3,8,0],[4,8,0],[5,9,0],[5,12,0],[6,14,0],[7,17,0],
        [9,20,0],[10,23,0],[12,28,0],[14,32,0],[17,38,0],[20,46,0]
      ],
      0x6D: [  // LATIN SMALL LETTER M
        [7,3,0],[8,4,0],[10,5,0],[12,5,0],[14,6,0],[16,8,0],[19,9,0],[22,11,0],
        [27,13,0],[31,15,0],[37,18,0],[44,21,0],[53,25,0],[62,30,0]
      ],
      0x6E: [  // LATIN SMALL LETTER N
        [5,3,0],[6,5,0],[7,5,0],[8,5,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],
        [18,13,0],[21,15,0],[25,18,0],[29,21,0],[35,25,0],[41,30,0]
      ],
      0x6F: [  // LATIN SMALL LETTER O
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],
        [15,13,0],[18,15,0],[22,18,0],[26,21,0],[30,25,0],[36,30,0]
      ],
      0x70: [  // LATIN SMALL LETTER P
        [5,4,1],[5,6,2],[6,7,2],[7,7,2],[9,9,3],[10,11,3],[12,13,4],[14,16,5],
        [17,19,6],[20,21,6],[24,26,8],[28,30,9],[33,36,11],[40,43,13]
      ],
      0x71: [  // LATIN SMALL LETTER Q
        [5,4,1],[6,6,2],[6,7,2],[8,7,2],[9,9,3],[11,11,3],[12,13,4],[15,16,5],
        [17,19,6],[21,21,6],[24,26,8],[29,30,9],[34,36,11],[41,43,13]
      ],
      0x72: [  // LATIN SMALL LETTER R
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],
        [13,13,0],[15,15,0],[18,18,0],[21,21,0],[25,25,0],[29,30,0]
      ],
      0x73: [  // LATIN SMALL LETTER S
        [3,3,0],[4,4,0],[5,5,0],[5,5,0],[6,6,0],[7,8,0],[9,9,0],[10,11,0],
        [12,13,0],[14,15,0],[17,18,0],[20,21,0],[23,25,0],[28,30,0]
      ],
      0x74: [  // LATIN SMALL LETTER T
        [3,5,0],[4,6,0],[4,7,0],[5,7,0],[6,9,0],[7,12,0],[8,13,0],[9,16,0],
        [11,19,0],[13,22,0],[15,26,0],[18,30,0],[22,36,0],[26,43,0]
      ],
      0x75: [  // LATIN SMALL LETTER U
        [5,3,0],[6,4,0],[7,5,0],[8,5,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],
        [18,13,0],[21,15,0],[25,18,0],[29,21,0],[35,25,0],[41,30,0]
      ],
      0x76: [  // LATIN SMALL LETTER V
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],
        [16,13,0],[19,15,0],[23,18,0],[27,21,0],[32,25,0],[38,30,0]
      ],
      0x77: [  // LATIN SMALL LETTER W
        [6,3,0],[7,4,0],[8,5,0],[10,5,0],[12,6,0],[14,8,0],[16,9,0],[19,11,0],
        [23,13,0],[27,15,0],[32,18,0],[38,21,0],[45,25,0],[53,30,0]
      ],
      0x78: [  // LATIN SMALL LETTER X
        [5,3,0],[5,4,0],[6,5,0],[7,5,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],
        [17,13,0],[20,15,0],[23,18,0],[28,21,0],[33,25,0],[39,30,0]
      ],
      0x79: [  // LATIN SMALL LETTER Y
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[9,9,3],[10,11,3],[12,13,4],[14,16,5],
        [17,19,6],[20,21,6],[23,26,8],[27,30,9],[33,36,11],[39,43,13]
      ],
      0x7A: [  // LATIN SMALL LETTER Z
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],
        [13,13,0],[16,15,0],[19,18,0],[22,21,0],[26,25,0],[31,30,0]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [4,7,2],[5,9,2],[5,11,3],[6,11,3],[7,14,3],[9,18,4],[10,21,6],[12,25,7],
        [14,30,7],[17,33,8],[20,40,10],[24,47,12],[28,55,14],[34,66,17]
      ],
      0x7C: [  // VERTICAL LINE
        [2,7,2],[2,9,2],[2,12,3],[3,12,3],[3,14,3],[4,18,4],[4,20,5],[5,25,6],
        [6,29,7],[7,34,8],[8,40,10],[9,47,12],[11,56,14],[13,67,17]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [4,7,2],[5,9,2],[5,11,3],[6,11,3],[7,14,3],[9,18,4],[10,21,6],[12,26,7],
        [14,29,7],[17,33,8],[20,40,10],[24,47,11],[28,56,14],[34,66,16]
      ],
      0x7E: [  // TILDE
        [4,1,-1],[4,1,-2],[5,3,-1],[6,3,-1],[7,4,-2],[8,3,-4],[10,3,-4],[12,4,-5],
        [14,5,-6],[16,6,-7],[19,6,-8],[23,7,-9],[27,9,-11],[32,10,-13]
      ],
      0x393: [  // GREEK CAPITAL LETTER GAMMA
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[22,23,0],[26,27,0],[30,32,0],[36,38,0],[43,46,0]
      ],
      0x394: [  // GREEK CAPITAL LETTER DELTA
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[30,23,0],[36,28,0],[42,32,0],[50,38,0],[60,46,0]
      ],
      0x398: [  // GREEK CAPITAL LETTER THETA
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x39B: [  // GREEK CAPITAL LETTER LAMDA
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [22,20,0],[26,23,0],[30,28,0],[36,32,0],[43,38,0],[51,46,0]
      ],
      0x39E: [  // GREEK CAPITAL LETTER XI
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,17,0],
        [20,20,0],[24,23,0],[28,27,0],[34,31,0],[40,37,0],[48,45,0]
      ],
      0x3A0: [  // GREEK CAPITAL LETTER PI
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,27,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x3A3: [  // GREEK CAPITAL LETTER SIGMA
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [22,20,0],[26,23,0],[30,28,0],[36,32,0],[43,38,0],[51,46,0]
      ],
      0x3A5: [  // GREEK CAPITAL LETTER UPSILON
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x3A6: [  // GREEK CAPITAL LETTER PHI
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [22,20,0],[26,23,0],[30,28,0],[36,32,0],[43,38,0],[51,46,0]
      ],
      0x3A8: [  // GREEK CAPITAL LETTER PSI
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x3A9: [  // GREEK CAPITAL LETTER OMEGA
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[11,9,0],[13,12,0],[16,14,0],[18,17,0],
        [22,20,0],[26,23,0],[31,28,0],[36,32,0],[43,38,0],[51,46,0]
      ]
    },

    "MathJax_Main-italic": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x21: [  // EXCLAMATION MARK
        [3,5,0],[4,6,0],[4,6,0],[5,8,0],[6,9,0],[7,11,0],[8,14,0],[9,15,0],
        [11,20,0],[13,24,0],[15,28,0],[18,34,0],[22,41,0],[25,47,0]
      ],
      0x22: [  // QUOTATION MARK
        [4,3,-2],[5,3,-3],[6,3,-3],[7,4,-4],[8,5,-4],[9,5,-6],[11,7,-7],[13,8,-8],
        [15,9,-10],[18,11,-12],[22,13,-14],[25,15,-18],[30,18,-21],[36,21,-24]
      ],
      0x23: [  // NUMBER SIGN
        [6,6,1],[7,8,2],[9,8,2],[10,10,2],[12,12,3],[14,14,3],[17,18,4],[20,20,4],
        [23,24,5],[28,29,6],[33,34,7],[39,42,9],[46,50,11],[55,58,13]
      ],
      0x25: [  // PERCENT SIGN
        [6,6,1],[8,8,1],[9,8,1],[10,10,1],[12,11,1],[15,13,1],[17,17,1],[20,18,1],
        [24,23,2],[28,29,3],[34,33,3],[40,38,3],[47,46,3],[56,53,4]
      ],
      0x26: [  // AMPERSAND
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,17,1],
        [23,21,1],[27,25,1],[32,29,0],[38,35,1],[45,43,2],[53,49,2]
      ],
      0x27: [  // APOSTROPHE
        [3,3,-2],[4,3,-3],[4,3,-3],[5,4,-4],[6,5,-4],[7,5,-6],[8,7,-7],[9,8,-8],
        [11,9,-10],[13,11,-12],[15,13,-14],[18,15,-18],[21,18,-21],[25,21,-24]
      ],
      0x28: [  // LEFT PARENTHESIS
        [4,8,3],[5,10,3],[6,10,3],[7,13,4],[8,15,4],[9,17,5],[11,22,6],[12,24,7],
        [15,28,8],[18,35,9],[21,40,11],[25,49,13],[29,58,15],[35,67,17]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [3,7,2],[4,9,2],[4,9,2],[5,12,3],[6,14,3],[7,16,4],[8,21,5],[10,23,6],
        [11,27,7],[13,34,8],[16,39,10],[19,48,12],[22,57,14],[26,66,16]
      ],
      0x2A: [  // ASTERISK
        [5,3,-2],[5,5,-2],[6,5,-2],[7,6,-3],[9,6,-4],[10,8,-4],[12,9,-6],[14,10,-7],
        [17,12,-9],[20,15,-11],[23,17,-12],[28,21,-15],[33,25,-18],[39,28,-21]
      ],
      0x2B: [  // PLUS SIGN
        [6,5,1],[7,7,1],[8,7,1],[9,7,1],[11,9,1],[13,11,2],[15,13,1],[18,15,2],
        [21,18,3],[25,21,2],[30,24,2],[35,30,3],[42,35,3],[50,41,4]
      ],
      0x2C: [  // COMMA
        [2,2,1],[2,3,2],[3,3,2],[3,4,2],[4,5,3],[4,5,3],[5,7,4],[6,7,4],
        [7,9,5],[8,10,6],[10,12,7],[11,15,9],[13,18,11],[16,21,13]
      ],
      0x2D: [  // HYPHEN-MINUS
        [3,1,-1],[3,1,-1],[4,1,-1],[4,1,-2],[5,1,-2],[6,2,-2],[7,3,-3],[8,3,-3],
        [10,2,-5],[12,3,-6],[14,3,-7],[16,4,-9],[19,5,-10],[23,5,-12]
      ],
      0x2E: [  // FULL STOP
        [2,1,0],[2,2,0],[3,2,0],[3,2,0],[4,2,0],[4,2,0],[5,3,0],[6,3,0],
        [7,4,0],[8,5,0],[10,5,0],[11,6,0],[13,7,0],[16,8,0]
      ],
      0x2F: [  // SOLIDUS
        [5,7,2],[6,9,2],[7,9,2],[8,12,3],[9,14,3],[11,16,4],[12,21,5],[15,23,6],
        [18,27,7],[21,34,8],[25,39,10],[29,48,12],[35,57,14],[41,66,16]
      ],
      0x30: [  // DIGIT ZERO
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[14,16,1],
        [16,19,1],[19,24,1],[22,27,0],[27,33,1],[32,39,1],[37,45,1]
      ],
      0x31: [  // DIGIT ONE
        [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[10,14,0],[11,15,0],
        [13,19,0],[16,23,0],[19,26,0],[22,32,0],[26,38,0],[31,44,0]
      ],
      0x32: [  // DIGIT TWO
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
        [16,20,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
      ],
      0x33: [  // DIGIT THREE
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[14,15,0],
        [16,19,0],[19,23,0],[22,26,0],[27,33,1],[32,39,1],[37,45,1]
      ],
      0x34: [  // DIGIT FOUR
        [4,6,1],[4,8,2],[5,8,2],[6,10,2],[7,12,3],[8,14,3],[10,18,4],[12,19,4],
        [14,24,5],[16,29,6],[19,33,7],[23,41,9],[27,49,11],[32,57,13]
      ],
      0x35: [  // DIGIT FIVE
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,10,0],[10,11,0],[12,14,0],[14,16,1],
        [16,20,1],[19,23,1],[23,27,0],[27,33,1],[32,39,1],[38,45,1]
      ],
      0x36: [  // DIGIT SIX
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[12,14,0],[14,16,1],
        [16,19,1],[19,24,1],[23,28,1],[27,33,1],[32,39,1],[38,45,2]
      ],
      0x37: [  // DIGIT SEVEN
        [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,1],
        [18,20,1],[21,24,1],[25,27,0],[30,33,1],[36,40,2],[42,46,2]
      ],
      0x38: [  // DIGIT EIGHT
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
        [16,20,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
      ],
      0x39: [  // DIGIT NINE
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,1],
        [16,19,1],[19,24,1],[22,27,0],[26,33,1],[31,39,1],[37,45,1]
      ],
      0x3A: [  // COLON
        [3,3,0],[3,4,0],[4,4,0],[4,5,0],[5,6,0],[6,7,0],[6,9,0],[8,10,0],
        [9,12,0],[11,15,0],[13,17,0],[15,21,0],[18,24,0],[21,28,0]
      ],
      0x3B: [  // SEMICOLON
        [3,4,1],[3,6,2],[4,6,2],[4,7,2],[5,9,3],[6,10,3],[6,13,4],[8,14,4],
        [9,17,5],[11,21,6],[13,24,7],[15,30,9],[18,35,11],[21,41,13]
      ],
      0x3D: [  // EQUALS SIGN
        [6,2,-1],[7,3,-1],[8,3,-1],[10,3,-1],[11,4,-2],[13,4,-2],[16,5,-3],[19,5,-3],
        [22,7,-3],[26,10,-4],[31,9,-5],[37,11,-6],[43,14,-8],[52,16,-9]
      ],
      0x3F: [  // QUESTION MARK
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,15,0],
        [16,20,0],[19,24,0],[22,28,0],[26,34,0],[31,41,0],[37,47,0]
      ],
      0x40: [  // COMMERCIAL AT
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,15,0],
        [22,20,0],[26,24,0],[31,27,0],[37,34,1],[44,41,1],[52,47,1]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [5,5,0],[6,7,0],[7,7,0],[9,8,0],[10,10,0],[12,12,0],[14,15,0],[17,16,0],
        [20,20,0],[23,24,0],[28,28,0],[33,34,0],[39,41,0],[46,47,0]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
        [21,19,0],[25,23,0],[29,26,0],[34,33,0],[41,39,0],[49,45,0]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,1],
        [23,21,1],[27,25,1],[32,27,0],[38,35,1],[45,41,1],[54,48,1]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],[16,14,0],[18,15,0],
        [22,19,0],[26,23,0],[31,26,0],[36,33,0],[43,39,0],[51,45,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
        [21,19,0],[25,23,0],[30,26,0],[35,33,0],[42,39,0],[50,46,1]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
        [21,19,0],[24,23,0],[29,26,0],[34,33,0],[41,38,0],[48,45,0]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,1],
        [23,21,1],[27,25,1],[32,27,0],[38,35,1],[45,41,1],[54,48,1]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,15,0],
        [24,19,0],[29,23,0],[34,26,0],[40,33,0],[48,39,0],[57,45,0]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [4,5,0],[5,6,0],[5,6,0],[6,8,0],[8,9,0],[9,11,0],[10,14,0],[12,15,0],
        [15,19,0],[17,23,0],[20,26,0],[24,33,0],[29,39,0],[34,45,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,1],
        [18,20,1],[21,24,1],[25,26,0],[29,34,1],[35,40,1],[41,46,1]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [6,5,0],[8,7,1],[9,7,1],[11,9,1],[12,10,1],[15,12,1],[17,15,1],[20,16,1],
        [24,20,1],[29,24,1],[34,27,1],[40,33,0],[48,39,0],[57,46,1]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,6,1],[6,7,1],[7,7,1],[8,9,1],[9,10,1],[11,12,1],[13,15,1],[15,16,1],
        [18,20,1],[21,24,1],[25,27,1],[30,33,1],[35,40,1],[42,46,1]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [7,5,0],[9,6,0],[10,6,0],[12,8,0],[14,9,0],[17,11,0],[20,14,0],[24,15,0],
        [28,19,0],[34,23,0],[40,26,0],[47,33,0],[56,39,0],[67,46,1]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,10,0],[15,11,0],[17,14,0],[20,16,0],
        [24,19,0],[29,24,0],[34,27,0],[40,34,0],[48,40,0],[57,45,0]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,1],
        [22,21,1],[26,25,1],[31,27,0],[37,35,1],[44,41,1],[52,48,1]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [6,5,0],[7,7,1],[8,7,1],[9,9,1],[11,10,1],[13,12,1],[15,15,1],[17,16,1],
        [21,20,1],[24,24,1],[29,27,1],[34,34,1],[41,40,1],[48,46,1]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,8,2],[8,8,2],[10,10,2],[11,12,3],[14,14,3],[16,18,4],[19,19,4],
        [22,25,5],[26,30,6],[31,34,7],[37,43,9],[44,51,11],[52,59,13]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [5,6,0],[6,7,0],[8,7,0],[9,9,0],[10,10,0],[12,12,0],[15,15,0],[17,17,1],
        [20,21,1],[24,25,1],[29,27,0],[34,35,1],[40,41,1],[48,47,1]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [5,5,0],[6,7,0],[7,7,0],[8,8,0],[9,10,0],[11,12,0],[13,15,0],[15,17,1],
        [18,21,1],[21,25,1],[25,28,0],[30,35,1],[35,41,1],[42,48,1]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,15,0],
        [23,19,0],[27,23,0],[32,26,0],[38,32,0],[45,38,0],[54,45,0]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,16,1],
        [24,20,1],[29,24,1],[34,26,0],[40,34,1],[48,40,1],[57,47,2]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[21,17,1],
        [24,20,1],[29,24,1],[34,27,0],[41,34,1],[48,40,1],[58,47,2]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [8,5,0],[10,6,0],[12,6,0],[14,8,0],[16,9,0],[19,11,0],[22,14,0],[27,17,1],
        [32,20,1],[37,24,1],[44,27,0],[53,34,1],[63,41,2],[74,47,2]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [6,5,0],[7,7,1],[9,7,1],[10,9,1],[12,10,1],[14,12,1],[16,15,1],[20,16,1],
        [23,20,1],[28,24,1],[33,27,1],[39,34,1],[46,39,0],[55,45,0]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [7,5,0],[8,6,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],[18,14,0],[21,15,0],
        [25,19,0],[29,23,0],[35,26,0],[41,33,0],[49,39,0],[58,45,0]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
        [20,19,0],[24,23,0],[28,26,0],[33,33,0],[39,39,0],[47,45,0]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [4,8,2],[4,10,3],[5,10,3],[6,12,3],[7,14,4],[8,16,4],[9,21,5],[11,23,6],
        [13,28,8],[15,36,9],[18,39,10],[21,47,12],[25,57,14],[30,66,16]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [4,8,2],[4,10,3],[5,10,3],[6,12,3],[6,14,4],[7,16,4],[8,21,5],[10,23,6],
        [11,28,8],[13,36,9],[15,39,10],[18,48,12],[21,57,14],[25,66,16]
      ],
      0x5E: [  // CIRCUMFLEX ACCENT
        [4,1,-4],[5,2,-4],[6,2,-4],[7,2,-6],[8,2,-7],[9,3,-8],[11,4,-10],[13,4,-12],
        [15,5,-14],[18,6,-17],[21,7,-20],[25,8,-25],[30,10,-29],[35,11,-34]
      ],
      0x5F: [  // LOW LINE
        [4,2,1],[5,2,1],[6,2,1],[7,2,1],[8,2,1],[10,2,1],[11,2,1],[14,2,1],
        [16,3,2],[19,4,3],[22,4,3],[27,5,4],[32,5,4],[37,6,5]
      ],
      0x61: [  // LATIN SMALL LETTER A
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[11,9,0],[13,10,0],
        [16,12,0],[18,15,0],[22,17,0],[26,22,1],[31,26,1],[36,30,1]
      ],
      0x62: [  // LATIN SMALL LETTER B
        [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[10,14,0],[11,16,0],
        [13,19,0],[16,23,0],[19,27,0],[22,34,1],[26,40,1],[31,46,1]
      ],
      0x63: [  // LATIN SMALL LETTER C
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
        [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
      ],
      0x64: [  // LATIN SMALL LETTER D
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[12,14,0],[14,15,0],
        [16,19,0],[19,23,0],[23,26,0],[27,34,1],[32,40,1],[38,46,1]
      ],
      0x65: [  // LATIN SMALL LETTER E
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
        [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
      ],
      0x66: [  // LATIN SMALL LETTER F
        [5,6,1],[5,8,2],[6,8,2],[7,10,2],[8,12,3],[9,14,3],[10,18,4],[12,19,4],
        [14,25,5],[16,30,6],[19,35,8],[23,44,10],[27,52,12],[32,60,13]
      ],
      0x67: [  // LATIN SMALL LETTER G
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,14,4],
        [14,17,5],[17,21,6],[20,25,8],[23,31,10],[28,37,12],[33,43,14]
      ],
      0x68: [  // LATIN SMALL LETTER H
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,0],
        [16,19,0],[18,23,0],[22,27,0],[26,34,1],[31,40,1],[36,46,1]
      ],
      0x69: [  // LATIN SMALL LETTER I
        [3,5,0],[3,6,0],[4,6,0],[4,8,0],[5,10,0],[6,11,0],[7,14,0],[8,15,0],
        [10,18,0],[12,23,0],[14,26,0],[16,32,1],[19,38,1],[23,44,1]
      ],
      0x6A: [  // LATIN SMALL LETTER J
        [4,6,1],[5,8,2],[5,8,2],[6,10,2],[7,13,3],[8,14,3],[9,18,4],[10,20,4],
        [12,24,5],[14,30,6],[17,34,8],[19,42,10],[23,49,12],[27,57,14]
      ],
      0x6B: [  // LATIN SMALL LETTER K
        [4,5,0],[5,6,0],[5,6,0],[6,8,0],[7,9,0],[9,11,0],[10,14,0],[12,16,0],
        [14,19,0],[17,23,0],[20,27,0],[24,34,1],[28,40,1],[33,46,1]
      ],
      0x6C: [  // LATIN SMALL LETTER L
        [3,5,0],[3,6,0],[4,6,0],[4,8,0],[5,9,0],[6,11,0],[7,14,0],[8,16,0],
        [9,19,0],[11,23,0],[13,27,0],[15,34,1],[18,40,1],[21,46,1]
      ],
      0x6D: [  // LATIN SMALL LETTER M
        [6,3,0],[8,4,0],[9,4,0],[10,5,0],[12,6,0],[15,7,0],[17,9,0],[20,10,0],
        [24,12,0],[28,15,0],[34,17,0],[40,22,1],[48,26,1],[56,30,1]
      ],
      0x6E: [  // LATIN SMALL LETTER N
        [5,3,0],[5,4,0],[6,4,0],[7,5,0],[9,6,0],[10,7,0],[12,9,0],[14,10,0],
        [17,12,0],[20,15,0],[24,17,0],[28,22,1],[33,26,1],[39,30,1]
      ],
      0x6F: [  // LATIN SMALL LETTER O
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[11,9,0],[12,10,0],
        [15,12,0],[18,15,0],[21,17,0],[25,22,1],[29,26,1],[35,30,1]
      ],
      0x70: [  // LATIN SMALL LETTER P
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[8,9,3],[9,10,3],[10,13,4],[12,14,4],
        [15,17,5],[17,21,6],[20,24,7],[24,30,9],[29,36,11],[34,43,14]
      ],
      0x71: [  // LATIN SMALL LETTER Q
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,14,4],
        [14,17,5],[17,21,6],[20,24,7],[24,30,9],[28,36,11],[34,42,13]
      ],
      0x72: [  // LATIN SMALL LETTER R
        [4,3,0],[5,4,0],[5,4,0],[6,5,0],[7,6,0],[9,7,0],[10,9,0],[12,10,0],
        [14,12,0],[16,15,0],[19,17,0],[23,22,1],[27,26,1],[32,30,1]
      ],
      0x73: [  // LATIN SMALL LETTER S
        [3,3,0],[4,4,0],[5,4,0],[5,5,0],[6,6,0],[7,7,0],[9,9,0],[10,11,1],
        [12,13,1],[14,16,1],[17,17,0],[20,22,1],[24,26,1],[28,30,1]
      ],
      0x74: [  // LATIN SMALL LETTER T
        [3,5,0],[4,6,0],[4,6,0],[5,7,0],[6,9,0],[7,10,0],[8,13,0],[9,15,0],
        [11,17,0],[13,22,0],[15,25,0],[18,30,1],[21,36,1],[25,42,1]
      ],
      0x75: [  // LATIN SMALL LETTER U
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[12,9,0],[14,10,0],
        [16,12,0],[19,15,0],[23,17,0],[27,22,1],[32,26,1],[38,30,1]
      ],
      0x76: [  // LATIN SMALL LETTER V
        [4,3,0],[5,4,0],[5,4,0],[6,5,0],[7,6,0],[9,7,0],[10,9,0],[12,10,0],
        [14,12,0],[17,15,0],[20,17,0],[23,22,1],[28,26,1],[33,30,1]
      ],
      0x77: [  // LATIN SMALL LETTER W
        [5,3,0],[6,4,0],[7,4,0],[9,5,0],[10,6,0],[12,7,0],[14,9,0],[17,10,0],
        [20,12,0],[23,15,0],[28,17,0],[33,22,1],[39,26,1],[46,30,1]
      ],
      0x78: [  // LATIN SMALL LETTER X
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[10,9,0],[12,10,0],
        [15,12,0],[17,15,0],[21,17,0],[24,22,1],[29,26,1],[34,30,1]
      ],
      0x79: [  // LATIN SMALL LETTER Y
        [4,4,1],[5,6,2],[6,6,2],[7,7,2],[8,9,3],[9,10,3],[11,13,4],[13,14,4],
        [15,17,5],[18,21,6],[21,25,8],[25,31,10],[29,37,12],[35,43,14]
      ],
      0x7A: [  // LATIN SMALL LETTER Z
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
        [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
      ],
      0x7E: [  // TILDE
        [4,1,-1],[5,1,-2],[6,1,-2],[7,2,-2],[8,2,-3],[10,2,-3],[12,3,-3],[14,4,-4],
        [16,3,-6],[19,4,-7],[23,5,-8],[27,5,-10],[32,7,-12],[38,7,-14]
      ],
      0xA3: [  // POUND SIGN
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
        [20,20,0],[24,24,0],[28,27,0],[33,34,1],[39,41,1],[47,48,1]
      ],
      0x131: [  // LATIN SMALL LETTER DOTLESS I
        [3,3,0],[3,4,0],[4,4,0],[4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],
        [10,12,0],[12,15,0],[14,17,0],[16,22,1],[19,26,1],[23,30,1]
      ],
      0x237: [  // LATIN SMALL LETTER DOTLESS J
        [4,4,1],[4,6,2],[5,6,2],[5,7,2],[6,9,3],[7,10,3],[8,13,4],[9,14,4],
        [11,17,5],[12,21,6],[15,25,8],[18,31,10],[21,37,12],[24,43,14]
      ],
      0x393: [  // GREEK CAPITAL LETTER GAMMA
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,15,0],
        [20,19,0],[24,23,0],[28,26,0],[33,33,0],[39,38,0],[47,45,0]
      ],
      0x394: [  // GREEK CAPITAL LETTER DELTA
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
        [21,20,0],[25,24,0],[30,28,0],[35,34,0],[42,41,0],[50,47,0]
      ],
      0x398: [  // GREEK CAPITAL LETTER THETA
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,1],
        [22,21,1],[26,25,1],[31,27,0],[37,35,1],[44,42,1],[52,48,1]
      ],
      0x39B: [  // GREEK CAPITAL LETTER LAMDA
        [5,5,0],[6,7,1],[7,7,1],[8,9,1],[9,10,1],[11,12,1],[13,15,1],[15,16,1],
        [18,21,1],[22,25,1],[26,28,1],[31,35,1],[36,42,1],[43,48,1]
      ],
      0x39E: [  // GREEK CAPITAL LETTER XI
        [6,6,1],[7,7,1],[8,7,1],[9,9,1],[11,10,1],[13,12,1],[15,15,1],[18,16,1],
        [21,20,1],[25,24,1],[30,27,1],[36,33,0],[42,40,1],[50,46,1]
      ],
      0x3A0: [  // GREEK CAPITAL LETTER PI
        [6,5,0],[8,6,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],[17,14,0],[20,15,0],
        [24,19,0],[29,23,0],[34,26,0],[40,33,0],[48,39,0],[57,45,0]
      ],
      0x3A3: [  // GREEK CAPITAL LETTER SIGMA
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],[16,14,0],[19,15,0],
        [22,19,0],[26,23,0],[31,26,0],[37,33,0],[44,39,0],[52,45,0]
      ],
      0x3A5: [  // GREEK CAPITAL LETTER UPSILON
        [6,5,0],[7,6,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],[17,14,0],[20,15,0],
        [23,20,0],[28,24,0],[33,27,0],[39,33,0],[46,40,0],[55,46,0]
      ],
      0x3A6: [  // GREEK CAPITAL LETTER PHI
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,15,0],
        [21,19,0],[24,23,0],[29,26,0],[34,33,0],[41,39,0],[48,45,0]
      ],
      0x3A8: [  // GREEK CAPITAL LETTER PSI
        [6,5,0],[7,6,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],[17,14,0],[20,15,0],
        [23,19,0],[28,23,0],[33,26,0],[39,33,0],[46,39,0],[55,45,0]
      ],
      0x3A9: [  // GREEK CAPITAL LETTER OMEGA
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,15,0],
        [21,20,0],[25,24,0],[30,27,0],[36,34,0],[42,40,0],[50,47,0]
      ]
    },

    "MathJax_Main": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x21: [  // EXCLAMATION MARK
        [2,5,0],[2,6,0],[2,8,0],[3,8,0],[3,9,0],[4,12,0],[4,14,0],[5,18,0],
        [6,21,0],[7,24,0],[8,29,0],[10,34,0],[11,40,0],[14,48,0]
      ],
      0x22: [  // QUOTATION MARK
        [3,3,-2],[4,3,-3],[4,4,-4],[5,4,-4],[6,5,-4],[7,6,-6],[8,7,-7],[9,8,-9],
        [11,10,-10],[13,11,-12],[15,13,-15],[18,15,-18],[21,18,-21],[25,22,-25]
      ],
      0x23: [  // NUMBER SIGN
        [6,6,1],[7,8,2],[8,10,2],[10,10,2],[11,12,3],[13,16,4],[16,18,4],[19,22,5],
        [22,26,6],[26,30,7],[31,35,8],[37,42,9],[43,50,11],[52,60,13]
      ],
      0x24: [  // DOLLAR SIGN
        [4,6,1],[4,8,1],[5,10,1],[6,9,1],[7,11,1],[8,15,1],[9,17,1],[11,20,1],
        [13,24,2],[15,27,2],[18,33,2],[21,38,2],[25,45,3],[30,54,3]
      ],
      0x25: [  // PERCENT SIGN
        [6,6,1],[7,8,1],[8,10,1],[10,10,1],[11,11,1],[13,15,1],[16,16,1],[19,20,1],
        [22,24,2],[26,29,3],[31,33,3],[37,38,3],[43,46,3],[52,54,4]
      ],
      0x26: [  // AMPERSAND
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,19,1],
        [21,22,1],[24,25,1],[29,30,0],[34,35,2],[41,41,1],[48,49,1]
      ],
      0x27: [  // APOSTROPHE
        [2,3,-2],[2,3,-3],[3,4,-4],[3,4,-4],[3,5,-4],[4,6,-6],[5,7,-7],[5,8,-9],
        [6,10,-10],[7,11,-12],[9,13,-15],[10,15,-18],[12,18,-21],[14,22,-25]
      ],
      0x28: [  // LEFT PARENTHESIS
        [3,7,2],[3,9,2],[4,12,3],[4,12,3],[5,14,3],[6,18,4],[7,21,5],[8,25,6],
        [10,29,7],[11,34,8],[13,41,10],[16,47,12],[19,56,14],[22,67,17]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [3,7,2],[3,9,2],[3,12,3],[4,12,3],[5,14,3],[5,18,4],[6,21,5],[7,25,6],
        [9,29,7],[10,34,8],[12,41,10],[14,47,12],[17,56,14],[20,67,17]
      ],
      0x2A: [  // ASTERISK
        [3,3,-3],[4,4,-3],[5,5,-4],[6,5,-4],[6,6,-4],[8,8,-6],[9,9,-7],[10,11,-8],
        [12,13,-9],[15,15,-11],[17,18,-13],[20,21,-15],[24,25,-18],[29,29,-21]
      ],
      0x2B: [  // PLUS SIGN
        [5,5,1],[6,6,1],[8,8,1],[9,8,1],[10,9,1],[12,12,1],[14,14,2],[17,17,2],
        [20,20,2],[24,23,3],[28,27,3],[34,32,4],[40,38,5],[48,45,5]
      ],
      0x2C: [  // COMMA
        [2,2,1],[2,4,2],[3,4,2],[3,4,2],[3,5,3],[4,7,4],[5,7,4],[5,8,5],
        [6,10,6],[7,12,7],[9,13,8],[10,15,9],[12,18,11],[14,22,13]
      ],
      0x2D: [  // HYPHEN-MINUS
        [2,1,-1],[3,1,-1],[3,1,-2],[4,1,-2],[4,1,-2],[5,3,-2],[6,3,-3],[7,2,-4],
        [8,3,-5],[10,3,-6],[11,3,-7],[13,4,-8],[16,5,-10],[19,5,-12]
      ],
      0x2E: [  // FULL STOP
        [2,1,0],[2,2,0],[2,2,0],[3,2,0],[3,2,0],[4,3,0],[4,3,0],[5,3,0],
        [6,4,0],[7,5,0],[8,5,0],[10,6,0],[11,7,0],[14,9,0]
      ],
      0x2F: [  // SOLIDUS
        [4,7,2],[4,9,2],[5,11,3],[6,11,3],[7,14,3],[8,18,4],[9,20,5],[11,25,6],
        [13,29,7],[15,34,8],[18,40,10],[21,47,12],[25,56,14],[30,67,17]
      ],
      0x30: [  // DIGIT ZERO
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,18,1],
        [13,21,1],[16,25,1],[18,28,0],[22,32,1],[26,39,1],[31,46,1]
      ],
      0x31: [  // DIGIT ONE
        [3,5,0],[4,6,0],[5,8,0],[6,8,0],[6,9,0],[8,12,0],[9,14,0],[10,17,0],
        [12,20,0],[15,23,0],[17,27,0],[20,31,0],[24,37,0],[29,45,0]
      ],
      0x32: [  // DIGIT TWO
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,17,0],
        [13,20,0],[15,23,0],[18,27,0],[21,32,0],[25,37,0],[30,45,0]
      ],
      0x33: [  // DIGIT THREE
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,18,1],
        [13,21,1],[15,24,1],[18,28,0],[22,32,0],[26,39,0],[30,46,0]
      ],
      0x34: [  // DIGIT FOUR
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[10,14,0],[11,17,0],
        [14,20,0],[16,23,0],[19,27,0],[22,32,0],[27,38,0],[31,46,0]
      ],
      0x35: [  // DIGIT FIVE
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,10,0],[8,12,0],[9,14,0],[11,18,1],
        [13,21,1],[15,24,1],[18,28,1],[21,32,1],[25,39,1],[30,47,2]
      ],
      0x36: [  // DIGIT SIX
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,18,1],
        [13,21,1],[15,24,1],[18,28,0],[22,33,2],[26,39,1],[30,46,1]
      ],
      0x37: [  // DIGIT SEVEN
        [4,5,0],[5,6,0],[5,8,0],[6,8,0],[7,10,0],[9,12,0],[10,14,0],[12,18,1],
        [14,21,1],[16,24,1],[19,27,0],[23,33,1],[27,39,1],[32,47,1]
      ],
      0x38: [  // DIGIT EIGHT
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,18,1],
        [13,21,1],[16,24,1],[18,28,0],[22,32,1],[26,39,1],[31,46,1]
      ],
      0x39: [  // DIGIT NINE
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[9,14,0],[11,18,1],
        [13,20,1],[16,23,1],[18,28,0],[22,32,1],[26,38,1],[31,46,1]
      ],
      0x3A: [  // COLON
        [2,3,0],[2,4,0],[2,5,0],[3,5,0],[3,6,0],[4,8,0],[4,9,0],[5,11,0],
        [6,13,0],[7,14,0],[8,17,0],[10,20,0],[11,24,0],[14,29,0]
      ],
      0x3B: [  // SEMICOLON
        [2,4,1],[2,6,2],[2,7,2],[3,7,2],[3,9,3],[4,12,4],[4,13,4],[5,16,5],
        [6,19,6],[7,21,7],[8,25,8],[10,29,9],[12,35,11],[14,42,13]
      ],
      0x3C: [  // LESS-THAN SIGN
        [5,4,0],[6,6,0],[7,7,0],[9,7,0],[10,8,0],[12,11,0],[14,12,0],[17,15,1],
        [20,17,1],[23,20,1],[28,24,2],[33,28,2],[39,33,2],[46,39,3]
      ],
      0x3D: [  // EQUALS SIGN
        [5,2,-1],[6,3,-1],[8,3,-1],[9,3,-1],[10,4,-2],[12,4,-2],[15,5,-3],[17,6,-3],
        [20,8,-3],[24,10,-4],[29,10,-5],[34,11,-6],[40,13,-7],[48,16,-9]
      ],
      0x3E: [  // GREATER-THAN SIGN
        [5,4,0],[6,6,0],[7,7,0],[9,7,0],[10,8,1],[12,11,1],[14,12,1],[17,15,1],
        [20,17,1],[23,20,1],[28,24,2],[33,28,2],[39,33,2],[46,39,3]
      ],
      0x3F: [  // QUESTION MARK
        [3,5,0],[4,6,0],[5,8,0],[5,8,0],[6,9,0],[7,12,0],[9,14,0],[10,18,0],
        [12,21,0],[14,24,0],[17,29,0],[20,33,0],[23,40,0],[28,47,0]
      ],
      0x40: [  // COMMERCIAL AT
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,18,0],
        [20,21,0],[24,24,0],[29,30,0],[34,34,0],[40,40,0],[48,48,0]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,18,0],
        [20,21,0],[24,24,0],[29,29,0],[34,34,0],[40,40,0],[48,48,0]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[16,17,0],
        [18,20,0],[22,23,0],[26,27,0],[31,32,0],[36,38,0],[43,46,0]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[13,14,0],[16,19,1],
        [19,22,1],[22,25,1],[27,29,0],[31,34,1],[37,41,1],[44,49,1]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [5,5,0],[6,6,0],[7,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,17,0],
        [20,20,0],[24,23,0],[28,28,0],[33,32,0],[40,38,0],[47,46,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[16,17,0],
        [18,20,0],[22,23,0],[26,27,0],[31,32,0],[36,38,0],[43,46,0]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [5,5,0],[6,6,0],[6,8,0],[8,8,0],[9,9,0],[11,12,0],[12,14,0],[15,17,0],
        [17,20,0],[20,23,0],[24,27,0],[29,32,0],[34,38,0],[40,46,0]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,19,1],
        [21,22,1],[25,25,1],[29,29,0],[34,35,2],[41,42,2],[49,49,2]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,17,0],
        [21,20,0],[24,23,0],[29,27,0],[34,32,0],[41,38,0],[48,46,0]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [3,5,0],[3,6,0],[4,8,0],[4,8,0],[5,9,0],[6,12,0],[7,14,0],[8,17,0],
        [10,20,0],[12,23,0],[14,27,0],[16,32,0],[19,38,0],[23,46,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [4,5,0],[4,6,0],[5,8,0],[6,8,0],[7,9,0],[8,12,0],[10,14,0],[11,18,1],
        [13,21,1],[16,24,1],[19,27,0],[22,32,0],[26,39,1],[31,47,1]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [21,20,0],[25,23,0],[29,27,0],[35,32,0],[41,38,0],[49,46,0]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,5,0],[5,6,0],[6,8,0],[7,8,0],[9,9,0],[10,12,0],[12,14,0],[14,17,0],
        [17,20,0],[20,23,0],[23,27,0],[28,32,0],[33,38,0],[39,46,0]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[30,23,0],[35,28,0],[42,32,0],[50,38,0],[59,46,0]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,17,0],
        [21,20,0],[24,23,0],[29,27,0],[34,32,0],[41,38,0],[48,46,0]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,19,1],
        [20,22,1],[24,25,1],[29,29,0],[34,34,1],[40,41,1],[48,49,1]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[21,23,0],[25,27,0],[29,32,0],[35,38,0],[42,46,0]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,8,2],[8,10,2],[9,10,2],[11,12,3],[13,16,4],[15,18,4],[17,23,5],
        [21,27,6],[24,31,7],[29,36,8],[34,42,9],[41,51,11],[48,60,13]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,18,1],
        [21,21,1],[25,24,1],[29,27,0],[34,32,0],[41,39,1],[49,48,2]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [4,5,0],[5,6,0],[5,8,0],[6,8,0],[7,9,0],[9,12,0],[10,14,0],[12,19,1],
        [14,22,1],[17,25,1],[20,29,0],[24,34,1],[28,41,1],[33,49,1]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[14,14,0],[16,17,0],
        [19,20,0],[23,23,0],[27,27,0],[32,32,0],[38,38,0],[45,46,0]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,18,1],
        [21,21,1],[24,24,1],[29,27,0],[34,33,1],[41,40,2],[48,48,2]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,18,1],
        [21,21,1],[24,24,1],[29,27,0],[34,34,2],[41,40,2],[48,48,2]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [7,5,0],[9,6,0],[10,8,0],[12,8,0],[14,9,0],[17,12,0],[20,14,0],[24,18,1],
        [28,21,1],[34,24,1],[40,27,0],[47,34,2],[56,40,2],[67,48,2]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [5,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,17,0],
        [21,20,0],[24,23,0],[29,27,0],[34,32,0],[41,38,0],[48,46,0]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [6,6,1],[7,7,1],[8,9,1],[9,9,1],[11,10,1],[13,13,1],[15,15,1],[18,18,1],
        [21,21,1],[25,24,1],[29,28,1],[35,33,1],[41,39,1],[49,47,1]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [4,6,1],[5,7,1],[6,9,1],[7,9,1],[8,10,1],[10,13,1],[11,15,1],[13,18,1],
        [16,21,1],[19,24,1],[22,27,0],[26,32,0],[31,38,0],[37,46,0]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [2,7,2],[3,10,3],[3,12,3],[3,12,3],[4,14,4],[5,18,5],[5,20,5],[6,25,6],
        [8,30,8],[9,35,9],[10,40,10],[12,47,12],[15,56,14],[17,67,17]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [4,7,2],[4,9,2],[5,11,3],[6,11,3],[7,14,3],[8,18,4],[9,20,5],[11,25,6],
        [13,29,7],[15,34,8],[18,40,10],[21,47,12],[25,56,14],[30,67,17]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [2,7,2],[2,10,3],[2,12,3],[2,12,3],[3,14,4],[3,18,5],[4,20,5],[4,25,6],
        [5,30,8],[6,35,9],[7,40,10],[8,47,12],[9,56,14],[11,67,17]
      ],
      0x5E: [  // CIRCUMFLEX ACCENT
        [3,2,-3],[4,3,-4],[4,3,-5],[5,3,-5],[6,3,-7],[7,4,-9],[8,4,-10],[9,5,-13],
        [11,6,-15],[13,7,-17],[16,7,-21],[18,9,-24],[22,10,-29],[26,12,-35]
      ],
      0x5F: [  // LOW LINE
        [4,2,1],[5,2,1],[5,2,1],[6,2,1],[7,2,1],[9,2,1],[10,2,1],[12,3,2],
        [14,4,3],[17,4,3],[20,4,3],[24,4,3],[28,4,3],[33,5,4]
      ],
      0x60: [  // GRAVE ACCENT
        [3,2,-3],[3,2,-4],[3,3,-5],[4,3,-5],[5,3,-6],[5,4,-8],[6,4,-10],[7,6,-12],
        [9,7,-14],[10,7,-17],[12,8,-20],[14,10,-23],[17,11,-28],[20,13,-34]
      ],
      0x61: [  // LATIN SMALL LETTER A
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],
        [14,13,0],[17,15,0],[20,18,0],[23,21,0],[28,26,0],[33,31,0]
      ],
      0x62: [  // LATIN SMALL LETTER B
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,14,0],[13,17,0],
        [15,20,0],[18,23,0],[21,29,0],[25,33,0],[29,40,0],[35,47,0]
      ],
      0x63: [  // LATIN SMALL LETTER C
        [3,3,0],[4,4,0],[5,5,0],[5,5,0],[6,6,0],[7,8,0],[9,9,0],[10,11,0],
        [12,13,0],[14,15,0],[17,18,0],[20,21,0],[23,26,0],[28,31,0]
      ],
      0x64: [  // LATIN SMALL LETTER D
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[11,14,0],[13,17,0],
        [15,20,0],[18,23,0],[21,29,0],[25,33,0],[30,40,0],[36,47,0]
      ],
      0x65: [  // LATIN SMALL LETTER E
        [3,3,0],[4,4,0],[5,5,0],[5,5,0],[6,6,0],[7,8,0],[9,9,0],[10,11,0],
        [12,13,0],[14,15,0],[17,18,0],[20,21,0],[23,26,0],[28,31,0]
      ],
      0x66: [  // LATIN SMALL LETTER F
        [3,5,0],[4,6,0],[4,8,0],[5,8,0],[6,9,0],[7,12,0],[8,14,0],[9,18,0],
        [11,21,0],[13,24,0],[15,29,0],[18,33,0],[21,40,0],[25,47,0]
      ],
      0x67: [  // LATIN SMALL LETTER G
        [4,4,1],[5,6,2],[5,7,2],[6,7,2],[7,9,3],[9,12,4],[10,13,4],[12,16,5],
        [14,19,6],[16,22,7],[19,26,8],[23,30,9],[27,37,11],[32,44,13]
      ],
      0x68: [  // LATIN SMALL LETTER H
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[11,14,0],[13,17,0],
        [16,20,0],[18,23,0],[22,27,0],[26,32,0],[31,38,0],[36,46,0]
      ],
      0x69: [  // LATIN SMALL LETTER I
        [2,5,0],[3,6,0],[3,8,0],[3,8,0],[4,9,0],[5,12,0],[5,14,0],[6,17,0],
        [8,20,0],[9,23,0],[10,27,0],[12,32,0],[15,37,0],[17,45,0]
      ],
      0x6A: [  // LATIN SMALL LETTER J
        [3,6,1],[3,8,2],[4,10,2],[4,10,2],[5,12,3],[5,16,4],[7,18,4],[8,22,5],
        [9,26,6],[10,30,7],[12,35,8],[14,41,9],[17,49,11],[19,59,13]
      ],
      0x6B: [  // LATIN SMALL LETTER K
        [4,5,0],[5,6,0],[6,8,0],[6,8,0],[8,9,0],[9,12,0],[10,14,0],[12,18,0],
        [15,21,0],[17,24,0],[20,28,0],[24,33,0],[29,39,0],[34,47,0]
      ],
      0x6C: [  // LATIN SMALL LETTER L
        [2,5,0],[3,6,0],[3,8,0],[4,8,0],[4,9,0],[5,12,0],[6,14,0],[7,17,0],
        [8,20,0],[9,23,0],[11,28,0],[13,33,0],[15,39,0],[18,47,0]
      ],
      0x6D: [  // LATIN SMALL LETTER M
        [6,3,0],[7,4,0],[9,5,0],[10,5,0],[12,6,0],[14,8,0],[16,9,0],[20,11,0],
        [23,13,0],[27,14,0],[33,17,0],[39,20,0],[46,25,0],[54,30,0]
      ],
      0x6E: [  // LATIN SMALL LETTER N
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],
        [16,13,0],[18,14,0],[22,17,0],[26,20,0],[31,24,0],[36,30,0]
      ],
      0x6F: [  // LATIN SMALL LETTER O
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[10,9,0],[11,11,0],
        [14,13,0],[16,15,0],[19,18,0],[22,21,0],[27,26,0],[31,31,0]
      ],
      0x70: [  // LATIN SMALL LETTER P
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[8,9,3],[9,12,4],[11,13,4],[13,16,5],
        [15,19,6],[18,21,7],[21,25,8],[25,29,9],[29,36,11],[35,43,13]
      ],
      0x71: [  // LATIN SMALL LETTER Q
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[8,9,3],[9,12,4],[11,13,4],[13,16,5],
        [15,19,6],[18,22,7],[21,26,8],[25,30,9],[30,36,11],[36,43,13]
      ],
      0x72: [  // LATIN SMALL LETTER R
        [3,3,0],[4,5,1],[4,6,1],[5,6,1],[6,7,1],[7,9,1],[8,10,1],[9,12,1],
        [11,14,1],[12,15,1],[15,18,1],[17,21,1],[21,26,1],[24,30,1]
      ],
      0x73: [  // LATIN SMALL LETTER S
        [3,3,0],[3,4,0],[4,5,0],[5,5,0],[5,6,0],[6,8,0],[7,9,0],[9,11,0],
        [10,13,0],[12,15,0],[14,18,0],[17,21,0],[20,26,0],[24,31,0]
      ],
      0x74: [  // LATIN SMALL LETTER T
        [3,4,0],[3,6,0],[4,7,0],[4,7,0],[5,9,0],[6,11,0],[7,13,0],[8,16,0],
        [10,18,0],[11,21,0],[13,25,0],[16,29,0],[19,35,0],[22,42,0]
      ],
      0x75: [  // LATIN SMALL LETTER U
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],
        [15,13,0],[18,15,0],[22,18,0],[26,21,0],[30,26,0],[36,31,1]
      ],
      0x76: [  // LATIN SMALL LETTER V
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[8,6,0],[9,8,0],[10,9,0],[12,11,0],
        [15,13,0],[17,14,0],[20,17,0],[24,20,0],[29,25,0],[34,30,0]
      ],
      0x77: [  // LATIN SMALL LETTER W
        [5,3,0],[6,4,0],[7,5,0],[9,5,0],[10,6,0],[12,8,0],[14,9,0],[17,11,0],
        [20,13,0],[23,14,0],[28,17,0],[33,20,0],[39,25,0],[46,30,0]
      ],
      0x78: [  // LATIN SMALL LETTER X
        [4,4,1],[5,5,1],[6,6,1],[7,6,1],[8,7,1],[9,9,1],[11,10,1],[12,12,1],
        [15,14,1],[17,15,1],[21,18,1],[24,21,1],[29,25,1],[34,30,1]
      ],
      0x79: [  // LATIN SMALL LETTER Y
        [4,4,1],[5,6,2],[5,7,2],[6,7,2],[8,9,3],[9,12,4],[10,13,4],[12,16,5],
        [15,19,6],[17,21,7],[20,25,8],[24,29,9],[29,36,11],[34,43,13]
      ],
      0x7A: [  // LATIN SMALL LETTER Z
        [3,3,0],[4,4,0],[4,5,0],[5,5,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],
        [12,13,0],[14,14,0],[16,17,0],[19,20,0],[23,25,0],[27,29,0]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [3,7,2],[4,10,3],[5,12,3],[6,12,3],[6,14,4],[8,18,5],[9,20,5],[11,25,6],
        [12,30,8],[15,35,9],[17,41,11],[21,47,12],[24,56,14],[29,67,17]
      ],
      0x7C: [  // VERTICAL LINE
        [2,7,2],[2,9,2],[2,12,3],[2,12,3],[3,14,3],[3,18,4],[4,21,5],[4,25,6],
        [5,29,7],[6,34,8],[7,41,10],[8,47,12],[9,56,14],[11,67,17]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [3,7,2],[4,10,3],[5,12,3],[6,12,3],[6,14,4],[8,18,5],[9,20,5],[11,25,6],
        [12,30,8],[15,34,9],[17,42,11],[21,47,12],[24,56,14],[29,67,17]
      ],
      0x7E: [  // TILDE
        [3,1,-1],[4,1,-2],[5,1,-2],[5,1,-2],[6,1,-3],[7,3,-3],[9,4,-4],[10,3,-5],
        [12,3,-6],[14,4,-7],[17,4,-9],[20,5,-10],[23,6,-12],[28,7,-14]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0xA8: [  // DIAERESIS
        [3,1,-4],[4,2,-4],[4,2,-6],[5,2,-6],[6,2,-7],[7,3,-9],[8,3,-11],[10,3,-14],
        [12,4,-16],[14,4,-19],[16,5,-22],[19,6,-26],[23,7,-31],[27,8,-37]
      ],
      0xAC: [  // NOT SIGN
        [5,3,0],[6,3,0],[6,4,0],[8,4,0],[9,4,-1],[11,5,-2],[12,6,-1],[15,7,-2],
        [17,8,-2],[21,10,-3],[24,11,-4],[29,13,-4],[34,16,-5],[41,18,-6]
      ],
      0xAF: [  // MACRON
        [3,1,-3],[4,1,-5],[5,1,-6],[6,1,-6],[6,1,-7],[8,1,-10],[9,1,-11],[10,2,-13],
        [12,3,-15],[15,2,-18],[17,2,-22],[20,3,-26],[24,3,-30],[29,4,-36]
      ],
      0xB0: [  // DEGREE SIGN
        [3,2,-3],[3,2,-4],[4,2,-6],[5,2,-6],[5,3,-6],[6,3,-9],[7,4,-10],[9,5,-13],
        [10,6,-15],[12,7,-17],[14,8,-22],[17,8,-25],[20,10,-30],[24,12,-36]
      ],
      0xB1: [  // PLUS-MINUS SIGN
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,17,0],
        [20,20,0],[24,23,0],[29,27,0],[34,31,0],[40,37,0],[48,45,0]
      ],
      0xB4: [  // ACUTE ACCENT
        [3,2,-3],[4,2,-4],[4,3,-5],[5,3,-5],[6,3,-6],[7,4,-8],[8,5,-9],[10,6,-12],
        [11,7,-14],[13,7,-17],[16,9,-19],[19,10,-23],[22,12,-28],[26,13,-34]
      ],
      0xD7: [  // MULTIPLICATION SIGN
        [5,4,0],[6,5,0],[7,6,0],[8,6,0],[9,7,0],[11,9,0],[13,10,0],[15,12,0],
        [18,14,0],[21,17,0],[25,20,0],[30,23,0],[36,27,-1],[42,33,-1]
      ],
      0xF7: [  // DIVISION SIGN
        [5,4,0],[6,6,0],[8,7,0],[9,7,0],[10,8,0],[12,10,0],[15,12,0],[17,15,1],
        [20,18,1],[24,19,1],[29,23,1],[34,27,2],[40,32,2],[48,39,2]
      ],
      0x131: [  // LATIN SMALL LETTER DOTLESS I
        [2,3,0],[3,4,0],[3,5,0],[3,5,0],[4,6,0],[5,8,0],[5,9,0],[6,11,0],
        [8,13,0],[9,15,0],[10,18,0],[12,21,0],[15,25,0],[17,30,0]
      ],
      0x237: [  // LATIN SMALL LETTER DOTLESS J
        [3,4,1],[3,6,2],[4,7,2],[4,7,2],[5,9,3],[5,12,4],[7,13,4],[8,16,5],
        [9,19,6],[10,22,7],[12,26,8],[14,30,9],[17,36,11],[19,44,13]
      ],
      0x2C6: [  // MODIFIER LETTER CIRCUMFLEX ACCENT
        [3,2,-3],[4,3,-4],[4,3,-5],[5,3,-5],[6,3,-7],[7,4,-9],[8,4,-10],[9,5,-13],
        [11,6,-15],[13,7,-17],[16,7,-21],[18,9,-24],[22,10,-29],[26,12,-35]
      ],
      0x2C7: [  // CARON
        [3,1,-3],[4,1,-5],[4,2,-6],[5,2,-6],[6,2,-7],[7,3,-9],[8,3,-10],[9,3,-13],
        [11,4,-15],[13,5,-17],[16,6,-21],[18,6,-24],[22,8,-29],[26,9,-34]
      ],
      0x2C9: [  // MODIFIER LETTER MACRON
        [3,1,-3],[4,1,-5],[5,1,-6],[6,1,-6],[6,1,-7],[8,1,-10],[9,1,-11],[10,2,-13],
        [12,3,-15],[15,2,-18],[17,2,-22],[20,3,-26],[24,3,-30],[29,4,-36]
      ],
      0x2CA: [  // MODIFIER LETTER ACUTE ACCENT
        [3,2,-3],[4,2,-4],[4,3,-5],[5,3,-5],[6,3,-6],[7,4,-8],[8,5,-9],[10,6,-12],
        [11,7,-14],[13,7,-17],[16,9,-19],[19,10,-23],[22,12,-28],[26,13,-34]
      ],
      0x2CB: [  // MODIFIER LETTER GRAVE ACCENT
        [3,2,-3],[3,2,-4],[3,3,-5],[4,3,-5],[5,3,-6],[5,4,-8],[6,4,-10],[7,6,-12],
        [9,7,-14],[10,7,-17],[12,8,-20],[14,10,-23],[17,11,-28],[20,13,-34]
      ],
      0x2D8: [  // BREVE
        [3,2,-3],[4,2,-4],[4,2,-6],[5,2,-6],[6,3,-6],[7,3,-9],[8,4,-10],[10,5,-12],
        [12,5,-15],[14,6,-17],[16,7,-21],[19,9,-24],[23,10,-29],[27,12,-34]
      ],
      0x2D9: [  // DOT ABOVE
        [3,1,-4],[3,2,-4],[4,2,-6],[4,2,-6],[5,2,-7],[6,3,-9],[7,3,-11],[8,3,-14],
        [9,4,-16],[11,5,-18],[13,5,-22],[15,6,-26],[18,7,-31],[21,9,-37]
      ],
      0x2DC: [  // SMALL TILDE
        [3,1,-4],[4,1,-5],[5,1,-7],[5,1,-7],[6,1,-8],[7,3,-9],[9,3,-11],[10,3,-14],
        [12,3,-17],[14,4,-19],[17,4,-23],[20,5,-26],[23,6,-32],[28,7,-38]
      ],
      0x393: [  // GREEK CAPITAL LETTER GAMMA
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[12,14,0],[14,17,0],
        [16,20,0],[20,23,0],[23,27,0],[27,32,0],[32,38,0],[39,46,0]
      ],
      0x394: [  // GREEK CAPITAL LETTER DELTA
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[11,9,0],[14,12,0],[16,14,0],[19,18,0],
        [22,21,0],[26,24,0],[31,29,0],[37,34,0],[44,40,0],[52,48,0]
      ],
      0x398: [  // GREEK CAPITAL LETTER THETA
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[15,14,0],[17,19,1],
        [20,22,1],[24,25,1],[29,29,0],[34,34,1],[40,41,1],[48,49,1]
      ],
      0x39B: [  // GREEK CAPITAL LETTER LAMDA
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[11,12,0],[13,14,0],[16,18,0],
        [19,21,0],[22,24,0],[26,29,0],[31,34,0],[37,40,0],[44,48,0]
      ],
      0x39E: [  // GREEK CAPITAL LETTER XI
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[21,23,0],[25,27,0],[29,32,0],[35,38,0],[42,46,0]
      ],
      0x3A0: [  // GREEK CAPITAL LETTER PI
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,17,0],
        [21,20,0],[24,23,0],[29,27,0],[34,32,0],[41,38,0],[48,46,0]
      ],
      0x3A3: [  // GREEK CAPITAL LETTER SIGMA
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[13,14,0],[16,17,0],
        [19,20,0],[22,23,0],[27,27,0],[31,32,0],[37,38,0],[44,46,0]
      ],
      0x3A5: [  // GREEK CAPITAL LETTER UPSILON
        [5,5,0],[6,6,0],[8,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,18,0],
        [20,21,0],[24,24,0],[29,28,0],[34,33,0],[40,40,0],[48,47,0]
      ],
      0x3A6: [  // GREEK CAPITAL LETTER PHI
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[13,14,0],[16,17,0],
        [19,20,0],[22,23,0],[27,27,0],[31,32,0],[37,38,0],[44,46,0]
      ],
      0x3A8: [  // GREEK CAPITAL LETTER PSI
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[17,17,0],
        [21,20,0],[24,23,0],[29,27,0],[34,32,0],[41,38,0],[48,46,0]
      ],
      0x3A9: [  // GREEK CAPITAL LETTER OMEGA
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[10,9,0],[12,12,0],[14,14,0],[16,18,0],
        [19,21,0],[23,24,0],[27,29,0],[32,33,0],[38,40,0],[45,47,0]
      ],
      0x2002: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2003: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2004: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2005: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2006: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2009: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x200A: [  // ??
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2013: [  // EN DASH
        [4,1,-1],[5,1,-2],[5,1,-2],[6,1,-2],[7,1,-3],[9,1,-4],[10,1,-5],[12,1,-6],
        [14,2,-6],[17,3,-8],[20,3,-9],[24,2,-12],[28,3,-14],[33,3,-17]
      ],
      0x2014: [  // EM DASH
        [7,1,-1],[9,1,-2],[10,1,-2],[12,1,-2],[14,1,-3],[17,1,-4],[20,1,-5],[24,1,-6],
        [28,2,-6],[33,3,-8],[40,3,-9],[47,2,-12],[56,3,-14],[66,3,-17]
      ],
      0x2018: [  // LEFT SINGLE QUOTATION MARK
        [2,2,-3],[2,4,-2],[2,4,-4],[3,4,-4],[3,4,-5],[4,6,-6],[4,7,-7],[5,8,-9],
        [6,9,-11],[7,11,-12],[8,13,-15],[10,15,-18],[11,18,-21],[14,21,-25]
      ],
      0x2019: [  // RIGHT SINGLE QUOTATION MARK
        [2,3,-2],[2,3,-3],[3,4,-4],[3,4,-4],[3,5,-4],[4,6,-6],[5,7,-7],[5,8,-9],
        [6,10,-10],[7,11,-12],[9,13,-15],[10,15,-18],[12,18,-21],[14,22,-25]
      ],
      0x201C: [  // LEFT DOUBLE QUOTATION MARK
        [4,2,-3],[4,4,-2],[5,4,-4],[6,4,-4],[7,4,-5],[8,6,-6],[10,7,-7],[11,8,-9],
        [13,9,-11],[16,11,-12],[19,13,-15],[22,15,-18],[26,18,-21],[31,21,-25]
      ],
      0x201D: [  // RIGHT DOUBLE QUOTATION MARK
        [3,3,-2],[4,3,-3],[4,4,-4],[5,4,-4],[6,5,-4],[7,6,-6],[8,7,-7],[9,8,-9],
        [11,10,-10],[13,11,-12],[15,13,-15],[18,15,-18],[21,18,-21],[25,22,-25]
      ],
      0x2020: [  // DAGGER
        [3,6,1],[4,8,2],[4,10,2],[5,10,2],[6,12,3],[7,16,4],[8,18,4],[9,23,5],
        [11,27,6],[13,31,7],[16,37,8],[18,44,11],[22,52,12],[26,62,15]
      ],
      0x2021: [  // DOUBLE DAGGER
        [3,6,1],[4,8,2],[4,10,2],[5,10,2],[6,12,3],[7,16,4],[8,18,4],[10,23,5],
        [11,27,6],[13,31,7],[16,37,8],[19,43,9],[22,51,11],[26,61,13]
      ],
      0x2026: [  // HORIZONTAL ELLIPSIS
        [8,1,0],[10,2,0],[11,2,0],[13,2,0],[16,2,0],[19,3,0],[22,3,0],[26,3,0],
        [31,4,0],[36,5,0],[43,5,0],[51,6,0],[61,7,0],[72,9,0]
      ],
      0x2032: [  // PRIME
        [2,4,0],[3,5,0],[3,6,0],[4,6,0],[4,7,-1],[5,9,-1],[6,11,-1],[7,13,-1],
        [8,15,-1],[9,18,-1],[11,21,-2],[13,24,-2],[15,29,-2],[18,35,-3]
      ],
      0x20D7: [  // COMBINING RIGHT ARROW ABOVE
        [4,2,-3],[4,2,-4],[5,3,-5],[6,3,-6],[7,3,-7],[8,4,-8],[10,5,-9],[11,5,-12],
        [14,6,-14],[16,7,-17],[18,9,-20],[21,10,-24],[26,12,-28],[30,14,-33]
      ],
      0x210F: [  // stix-/hbar - Planck's over 2pi
        [4,6,1],[5,7,1],[6,7,0],[7,10,1],[8,11,1],[10,13,1],[11,15,1],[13,18,1],
        [16,21,1],[19,25,1],[22,29,1],[26,34,1],[31,40,1],[37,47,1]
      ],
      0x2111: [  // BLACK-LETTER CAPITAL I
        [5,6,1],[6,7,1],[7,8,1],[8,9,0],[10,11,1],[12,13,1],[14,15,1],[17,18,1],
        [20,21,1],[23,25,1],[28,29,1],[33,34,1],[39,40,1],[46,48,1]
      ],
      0x2113: [  // SCRIPT SMALL L
        [4,5,0],[4,7,1],[4,8,1],[5,10,1],[6,11,1],[7,13,1],[8,15,1],[10,18,1],
        [12,21,1],[14,25,1],[16,29,1],[19,34,1],[23,41,2],[27,49,2]
      ],
      0x2118: [  // SCRIPT CAPITAL P
        [5,5,2],[5,6,2],[6,7,2],[8,9,3],[9,10,3],[11,12,4],[13,13,4],[15,16,5],
        [18,19,6],[21,23,8],[25,27,9],[29,32,11],[35,37,12],[41,45,15]
      ],
      0x211C: [  // BLACK-LETTER CAPITAL R
        [6,5,0],[6,6,0],[7,8,0],[9,9,0],[11,11,1],[13,13,1],[15,16,1],[17,18,1],
        [21,22,1],[24,25,1],[29,30,1],[34,35,1],[40,41,1],[48,50,2]
      ],
      0x2135: [  // ALEF SYMBOL
        [4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],[10,12,0],[11,14,0],[13,17,0],
        [16,20,0],[19,23,0],[22,28,0],[26,33,0],[31,39,0],[37,46,0]
      ],
      0x2190: [  // LEFTWARDS ARROW
        [7,5,1],[8,5,0],[10,6,1],[12,7,1],[14,9,1],[16,9,0],[19,11,1],[22,13,1],
        [27,15,1],[32,18,1],[37,22,1],[44,25,1],[53,30,1],[63,35,1]
      ],
      0x2191: [  // UPWARDS ARROW
        [4,7,2],[5,8,2],[5,9,2],[6,12,3],[7,13,3],[9,16,4],[10,18,4],[11,22,5],
        [13,26,6],[16,30,7],[19,36,8],[22,42,9],[27,50,11],[32,59,13]
      ],
      0x2192: [  // RIGHTWARDS ARROW
        [7,5,1],[8,5,0],[10,7,1],[12,7,1],[14,9,1],[16,9,0],[19,11,1],[22,13,1],
        [27,15,1],[32,18,1],[37,22,1],[44,25,1],[53,30,1],[63,35,1]
      ],
      0x2193: [  // DOWNWARDS ARROW
        [4,7,2],[5,8,2],[5,9,2],[6,12,3],[7,13,3],[9,16,4],[10,18,4],[12,22,5],
        [14,26,6],[16,30,7],[19,36,8],[23,42,9],[27,50,11],[32,59,13]
      ],
      0x2194: [  // LEFT RIGHT ARROW
        [7,5,1],[8,5,0],[10,7,1],[12,7,1],[14,9,1],[16,9,0],[19,11,1],[22,13,1],
        [27,15,1],[32,18,1],[37,22,1],[44,25,1],[53,30,1],[63,35,1]
      ],
      0x2195: [  // UP DOWN ARROW
        [4,8,2],[5,10,3],[5,11,3],[6,14,4],[7,15,4],[9,18,5],[10,22,6],[12,25,7],
        [14,30,8],[16,35,9],[19,42,11],[23,49,13],[27,59,16],[32,69,18]
      ],
      0x2196: [  // NORTH WEST ARROW
        [7,7,2],[8,8,2],[10,10,2],[12,12,3],[14,13,3],[16,16,4],[19,19,4],[22,22,5],
        [27,26,6],[32,31,7],[38,37,8],[45,44,10],[53,52,12],[63,61,13]
      ],
      0x2197: [  // NORTH EAST ARROW
        [7,7,2],[9,8,2],[10,10,2],[12,12,3],[14,13,3],[16,16,4],[19,19,4],[23,22,5],
        [27,26,6],[32,31,7],[38,37,8],[46,44,10],[54,52,11],[64,61,13]
      ],
      0x2198: [  // SOUTH EAST ARROW
        [7,7,2],[9,8,2],[10,10,3],[12,12,3],[14,13,3],[17,16,4],[19,19,5],[23,23,6],
        [27,26,6],[32,31,8],[38,37,9],[46,44,11],[54,52,13],[64,61,15]
      ],
      0x2199: [  // SOUTH WEST ARROW
        [7,7,2],[8,8,2],[10,10,3],[12,12,3],[14,13,3],[16,16,4],[19,19,5],[22,23,6],
        [26,26,6],[32,31,8],[37,37,9],[44,44,11],[53,52,13],[63,61,15]
      ],
      0x21A6: [  // RIGHTWARDS ARROW FROM BAR
        [7,5,1],[8,5,0],[10,7,1],[11,7,1],[14,9,1],[16,9,0],[19,11,1],[22,13,1],
        [27,15,1],[32,18,1],[37,22,1],[44,25,1],[53,30,1],[63,35,1]
      ],
      0x21A9: [  // LEFTWARDS ARROW WITH HOOK
        [8,5,1],[9,5,0],[11,7,1],[13,7,1],[15,9,1],[18,9,0],[21,11,1],[25,13,1],
        [30,15,1],[36,18,1],[42,21,1],[50,25,1],[60,30,1],[71,35,1]
      ],
      0x21AA: [  // RIGHTWARDS ARROW WITH HOOK
        [8,5,1],[9,5,0],[11,7,1],[13,7,1],[15,9,1],[18,9,0],[21,11,1],[25,13,1],
        [30,15,1],[36,18,1],[42,22,1],[50,25,1],[60,30,1],[71,35,1]
      ],
      0x21BC: [  // LEFTWARDS HARPOON WITH BARB UPWARDS
        [7,3,-1],[8,3,-2],[10,4,-2],[12,4,-2],[14,5,-3],[16,5,-4],[19,6,-4],[22,7,-5],
        [27,8,-6],[32,10,-7],[37,11,-9],[44,14,-10],[53,17,-12],[63,19,-15]
      ],
      0x21BD: [  // LEFTWARDS HARPOON WITH BARB DOWNWARDS
        [7,3,1],[8,3,0],[10,4,1],[12,4,1],[14,5,1],[16,5,0],[19,7,1],[22,8,1],
        [27,9,1],[32,10,1],[37,12,1],[44,14,1],[53,16,1],[63,19,1]
      ],
      0x21C0: [  // RIGHTWARDS HARPOON WITH BARB UPWARDS
        [7,3,-1],[8,3,-2],[10,4,-2],[12,4,-2],[14,5,-3],[16,5,-4],[19,6,-4],[22,7,-5],
        [27,8,-6],[32,10,-7],[37,11,-9],[44,14,-10],[53,17,-12],[63,19,-15]
      ],
      0x21C1: [  // RIGHTWARDS HARPOON WITH BARB DOWNWARDS
        [7,3,1],[8,3,0],[10,4,1],[12,4,1],[14,5,1],[16,5,0],[19,7,1],[22,8,1],
        [27,9,1],[32,10,1],[37,12,1],[44,14,1],[53,16,1],[63,19,1]
      ],
      0x21CC: [  // RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
        [7,6,1],[8,6,0],[10,8,1],[12,9,1],[14,11,1],[16,11,0],[19,14,1],[22,17,1],
        [27,20,1],[32,24,1],[37,28,1],[44,33,1],[53,39,1],[63,45,1]
      ],
      0x21D0: [  // LEFTWARDS DOUBLE ARROW
        [7,5,1],[8,6,1],[10,7,1],[12,8,1],[14,9,1],[16,10,1],[19,11,1],[22,14,1],
        [27,16,1],[32,20,2],[37,23,2],[44,27,2],[53,31,2],[63,38,3]
      ],
      0x21D1: [  // UPWARDS DOUBLE ARROW
        [4,7,2],[5,8,2],[6,9,2],[7,12,3],[8,13,3],[10,16,4],[12,18,4],[14,22,5],
        [17,26,6],[20,30,7],[23,36,8],[28,43,10],[32,50,11],[38,59,13]
      ],
      0x21D2: [  // RIGHTWARDS DOUBLE ARROW
        [7,5,1],[8,6,1],[10,7,1],[12,8,1],[14,9,1],[16,10,1],[19,12,1],[22,14,1],
        [27,16,1],[32,19,1],[37,22,1],[44,26,1],[53,32,2],[63,37,2]
      ],
      0x21D3: [  // DOWNWARDS DOUBLE ARROW
        [5,7,2],[5,8,2],[6,9,2],[7,12,3],[8,13,3],[10,16,4],[12,18,4],[14,22,5],
        [17,26,6],[20,30,7],[23,36,8],[28,43,10],[32,50,11],[39,59,13]
      ],
      0x21D4: [  // LEFT RIGHT DOUBLE ARROW
        [7,5,1],[9,6,1],[10,7,1],[12,8,1],[14,9,1],[17,10,1],[19,12,1],[23,14,1],
        [27,16,1],[32,19,1],[38,23,2],[45,27,2],[54,31,2],[64,37,2]
      ],
      0x21D5: [  // UP DOWN DOUBLE ARROW
        [4,8,2],[5,10,3],[6,11,3],[7,14,4],[8,15,4],[10,18,5],[12,22,6],[14,26,7],
        [17,30,8],[20,35,9],[23,42,11],[28,50,13],[32,58,15],[39,70,18]
      ],
      0x2200: [  // FOR ALL
        [4,6,1],[5,7,1],[6,8,1],[7,10,1],[8,11,1],[10,13,1],[11,15,1],[13,18,1],
        [16,20,1],[19,24,1],[22,29,1],[26,35,2],[31,41,2],[37,48,2]
      ],
      0x2202: [  // PARTIAL DIFFERENTIAL
        [4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,11,1],[10,13,1],[11,15,1],[14,18,1],
        [16,21,1],[19,25,1],[23,30,1],[27,35,1],[32,42,2],[38,50,2]
      ],
      0x2203: [  // THERE EXISTS
        [4,5,0],[4,6,0],[5,7,0],[6,8,0],[7,10,0],[9,12,0],[10,14,0],[12,16,0],
        [14,20,0],[17,23,0],[20,28,0],[24,33,0],[28,39,0],[33,46,0]
      ],
      0x2205: [  // EMPTY SET
        [4,7,1],[4,8,1],[5,9,1],[6,12,2],[7,13,2],[8,15,2],[9,18,2],[11,22,3],
        [13,25,3],[16,29,3],[18,35,4],[22,40,4],[26,48,5],[31,57,6]
      ],
      0x2207: [  // NABLA
        [6,6,1],[7,7,1],[8,8,1],[10,10,1],[11,11,1],[14,13,1],[16,15,1],[19,17,1],
        [22,20,1],[26,24,1],[31,29,2],[37,34,2],[44,40,2],[52,48,3]
      ],
      0x2208: [  // ELEMENT OF
        [5,5,1],[5,6,1],[6,7,1],[7,8,1],[9,9,1],[10,10,1],[12,12,1],[14,14,1],
        [16,17,2],[20,20,2],[23,24,2],[27,28,2],[33,33,3],[39,39,3]
      ],
      0x2209: [  // stix-negated (vert) set membership, variant
        [4,7,2],[5,8,2],[6,11,3],[7,12,3],[8,13,3],[10,16,4],[12,20,5],[14,23,6],
        [16,27,7],[20,32,8],[23,37,9],[27,44,11],[33,52,13],[39,62,15]
      ],
      0x220B: [  // CONTAINS AS MEMBER
        [4,5,1],[5,6,1],[6,7,1],[7,8,1],[8,9,1],[10,10,1],[12,12,1],[14,14,1],
        [17,17,2],[20,20,2],[23,24,2],[28,28,2],[33,33,3],[39,39,3]
      ],
      0x2212: [  // MINUS SIGN
        [5,1,-1],[6,1,-2],[7,1,-2],[9,1,-2],[10,1,-3],[12,1,-4],[14,2,-4],[17,2,-5],
        [20,2,-6],[23,2,-7],[28,2,-9],[33,3,-10],[39,3,-12],[46,3,-15]
      ],
      0x2213: [  // MINUS-OR-PLUS SIGN
        [5,6,2],[6,6,2],[8,7,2],[9,8,2],[10,10,3],[12,12,3],[15,14,4],[17,16,4],
        [20,19,5],[24,23,6],[29,27,7],[34,32,8],[40,38,10],[48,44,11]
      ],
      0x2215: [  // DIVISION SLASH
        [4,8,2],[4,10,3],[5,11,3],[6,12,3],[7,15,4],[8,18,5],[9,20,5],[11,24,6],
        [13,28,7],[15,34,9],[18,40,10],[21,47,12],[25,56,14],[30,67,17]
      ],
      0x2216: [  // SET MINUS
        [4,8,2],[4,10,3],[5,11,3],[6,12,3],[7,15,4],[8,18,5],[9,20,5],[11,24,6],
        [13,28,7],[15,34,9],[18,40,10],[21,47,12],[25,56,14],[30,67,17]
      ],
      0x2217: [  // ASTERISK OPERATOR
        [3,4,0],[4,4,0],[5,5,0],[6,6,0],[6,7,0],[8,8,0],[9,10,0],[11,11,0],
        [12,13,0],[15,15,-1],[17,18,-1],[21,21,-1],[24,25,-1],[29,29,-2]
      ],
      0x2218: [  // RING OPERATOR
        [3,3,0],[4,4,0],[5,5,0],[5,5,0],[7,6,0],[8,7,-1],[9,8,-1],[11,10,-1],
        [13,12,-1],[15,14,-1],[18,16,-2],[21,19,-2],[25,22,-3],[30,27,-3]
      ],
      0x2219: [  // BULLET OPERATOR
        [4,4,0],[4,4,0],[5,5,0],[6,6,0],[7,7,0],[8,8,0],[9,8,-1],[11,10,-1],
        [13,12,-1],[15,14,-1],[18,16,-2],[21,19,-2],[25,22,-3],[30,27,-3]
      ],
      0x221A: [  // SQUARE ROOT
        [6,8,2],[8,9,2],[9,10,2],[11,13,3],[12,15,3],[15,18,4],[17,20,4],[20,24,5],
        [24,29,6],[29,34,7],[34,40,8],[40,48,10],[48,57,12],[57,67,14]
      ],
      0x221D: [  // PROPORTIONAL TO
        [5,3,0],[6,4,0],[8,5,0],[9,5,0],[11,6,0],[13,8,0],[15,9,0],[17,12,1],
        [21,14,1],[24,16,1],[29,19,1],[34,22,1],[40,26,1],[48,30,1]
      ],
      0x221E: [  // INFINITY
        [7,3,0],[8,4,0],[10,5,0],[11,5,0],[14,6,0],[16,9,1],[19,10,1],[22,12,1],
        [27,14,1],[32,16,1],[37,19,1],[44,22,1],[53,26,1],[63,31,1]
      ],
      0x2220: [  // ANGLE
        [5,5,0],[6,6,0],[7,7,0],[8,9,0],[10,10,0],[12,12,0],[13,14,0],[16,17,0],
        [19,20,0],[22,23,0],[27,28,0],[31,33,0],[37,39,0],[44,46,0]
      ],
      0x2223: [  // DIVIDES
        [1,8,2],[2,10,3],[2,11,3],[2,12,3],[2,15,4],[3,18,5],[3,20,5],[4,24,6],
        [5,28,7],[6,34,9],[7,40,10],[8,47,12],[9,56,14],[11,67,17]
      ],
      0x2225: [  // PARALLEL TO
        [3,8,2],[4,10,3],[4,11,3],[5,14,4],[6,16,5],[7,18,5],[8,22,6],[9,25,7],
        [11,30,8],[13,36,10],[15,42,11],[18,50,13],[21,59,16],[25,70,19]
      ],
      0x2227: [  // LOGICAL AND
        [5,6,1],[6,6,1],[6,7,1],[8,9,1],[9,10,1],[11,11,1],[12,13,1],[15,15,1],
        [17,18,1],[21,21,1],[24,25,1],[29,30,2],[34,36,2],[41,42,2]
      ],
      0x2228: [  // LOGICAL OR
        [5,6,1],[6,6,1],[6,7,1],[8,9,1],[9,10,1],[11,11,1],[12,13,1],[15,15,1],
        [17,18,1],[21,21,1],[24,25,1],[29,30,2],[34,36,2],[41,42,2]
      ],
      0x2229: [  // stix-intersection, serifs
        [5,5,1],[5,6,1],[6,7,1],[7,8,1],[9,10,1],[10,11,1],[12,13,1],[14,15,1],
        [17,18,1],[21,21,1],[24,25,1],[29,30,2],[34,36,2],[41,42,2]
      ],
      0x222A: [  // stix-union, serifs
        [5,5,1],[6,6,1],[6,7,1],[8,8,1],[9,10,1],[11,11,1],[12,13,1],[14,15,1],
        [18,18,1],[21,21,1],[24,25,1],[29,29,1],[34,36,2],[41,42,2]
      ],
      0x222B: [  // INTEGRAL
        [3,7,2],[4,8,2],[5,9,2],[6,12,3],[7,13,3],[8,16,4],[10,18,4],[11,23,6],
        [13,26,6],[16,32,8],[19,38,9],[22,45,11],[26,52,12],[31,63,15]
      ],
      0x223C: [  // TILDE OPERATOR
        [5,2,-1],[6,2,-1],[7,3,-1],[9,4,-1],[10,3,-2],[12,5,-2],[14,6,-2],[17,6,-3],
        [20,8,-3],[24,9,-4],[29,10,-5],[34,12,-6],[40,14,-7],[48,17,-8]
      ],
      0x2240: [  // WREATH PRODUCT
        [2,5,1],[2,6,1],[2,7,1],[3,8,1],[4,9,1],[4,12,2],[5,14,2],[6,16,2],
        [7,19,3],[8,23,3],[9,27,4],[11,32,4],[13,38,5],[15,45,6]
      ],
      0x2243: [  // ASYMPTOTICALLY EQUAL TO
        [5,4,0],[6,4,0],[8,5,0],[9,6,0],[10,7,0],[12,8,0],[15,10,0],[17,10,-1],
        [20,12,-1],[24,15,-1],[29,18,-1],[34,21,-1],[40,25,-1],[48,29,-2]
      ],
      0x2245: [  // APPROXIMATELY EQUAL TO
        [5,4,0],[6,5,0],[8,6,0],[9,7,0],[10,8,0],[12,10,0],[15,12,0],[17,14,0],
        [20,17,0],[24,20,0],[29,24,0],[34,27,-1],[40,32,-1],[48,38,-1]
      ],
      0x2248: [  // ALMOST EQUAL TO
        [5,4,0],[6,4,0],[7,5,0],[9,6,0],[10,6,-1],[12,9,0],[14,9,-1],[17,11,-1],
        [20,13,-1],[24,15,-1],[29,17,-2],[34,21,-2],[40,24,-3],[48,29,-3]
      ],
      0x224D: [  // EQUIVALENT TO
        [5,4,0],[6,5,0],[8,5,0],[9,6,0],[10,7,0],[12,9,0],[15,10,0],[17,12,0],
        [20,14,0],[24,16,0],[29,19,0],[34,23,0],[40,27,0],[48,31,-1]
      ],
      0x2250: [  // APPROACHES THE LIMIT
        [5,4,-1],[6,5,-1],[8,6,-1],[9,7,-1],[10,8,-2],[12,10,-2],[15,12,-2],[17,13,-3],
        [20,16,-3],[24,19,-4],[29,22,-5],[34,26,-6],[40,31,-7],[48,37,-8]
      ],
      0x2260: [  // stix-not (vert) equals
        [5,7,2],[6,8,2],[8,10,3],[9,12,3],[10,13,3],[12,16,4],[15,19,5],[17,23,6],
        [20,26,6],[24,32,8],[29,38,9],[34,45,11],[40,53,13],[48,62,15]
      ],
      0x2261: [  // IDENTICAL TO
        [5,4,0],[6,4,0],[8,5,0],[9,6,0],[10,7,0],[12,8,0],[15,9,0],[17,10,-1],
        [20,12,-1],[24,15,-1],[29,18,-1],[34,21,-1],[40,25,-1],[48,29,-2]
      ],
      0x2264: [  // LESS-THAN OR EQUAL TO
        [5,6,1],[6,7,1],[8,9,2],[9,10,2],[10,11,2],[12,14,3],[15,16,3],[17,18,3],
        [20,22,4],[24,26,5],[28,31,6],[34,37,7],[40,44,8],[48,52,10]
      ],
      0x2265: [  // GREATER-THAN OR EQUAL TO
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,18,3],
        [20,22,4],[23,26,5],[28,31,6],[33,37,7],[39,44,8],[46,52,10]
      ],
      0x226A: [  // MUCH LESS-THAN
        [7,5,1],[8,6,1],[10,7,1],[12,8,1],[14,9,1],[16,12,2],[19,14,2],[22,16,2],
        [27,18,2],[31,22,3],[37,26,3],[44,31,4],[53,36,4],[62,43,5]
      ],
      0x226B: [  // MUCH GREATER-THAN
        [7,5,1],[8,6,1],[10,7,1],[12,8,1],[14,9,1],[16,12,2],[19,14,2],[23,16,2],
        [27,18,2],[32,22,3],[38,26,3],[45,31,4],[53,36,4],[63,43,5]
      ],
      0x227A: [  // PRECEDES
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,10,1],[14,12,1],[17,14,1],
        [20,17,2],[23,20,2],[28,24,2],[33,28,2],[39,33,3],[46,39,3]
      ],
      0x227B: [  // SUCCEEDS
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,10,1],[14,12,1],[17,14,1],
        [20,17,2],[23,20,2],[28,24,2],[33,27,2],[39,33,3],[46,39,3]
      ],
      0x2282: [  // SUBSET OF
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,10,1],[14,12,1],[17,14,1],
        [19,17,2],[23,20,2],[27,23,2],[33,27,2],[39,33,3],[46,39,3]
      ],
      0x2283: [  // SUPERSET OF
        [5,5,1],[6,6,1],[7,7,1],[8,8,1],[10,9,1],[12,10,1],[14,12,1],[17,14,1],
        [20,17,2],[23,20,2],[28,24,2],[33,28,2],[39,33,3],[46,39,3]
      ],
      0x2286: [  // SUBSET OF OR EQUAL TO
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,19,4],
        [19,22,4],[23,26,5],[27,31,6],[33,37,7],[39,44,8],[46,52,10]
      ],
      0x2287: [  // SUPERSET OF OR EQUAL TO
        [5,6,1],[6,7,1],[7,9,2],[8,10,2],[10,11,2],[12,14,3],[14,16,3],[17,18,3],
        [20,22,4],[23,26,5],[28,31,6],[33,37,7],[39,44,8],[46,51,9]
      ],
      0x228E: [  // MULTISET UNION
        [5,6,1],[6,6,1],[6,7,1],[8,9,1],[9,10,1],[11,11,1],[12,13,1],[14,16,1],
        [18,18,1],[21,21,1],[24,25,1],[29,29,1],[34,36,2],[41,42,2]
      ],
      0x2291: [  // SQUARE IMAGE OF OR EQUAL TO
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,18,3],
        [20,22,4],[24,26,5],[28,31,6],[34,37,7],[40,44,8],[47,52,10]
      ],
      0x2292: [  // SQUARE ORIGINAL OF OR EQUAL TO
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,18,3],
        [20,22,4],[23,26,5],[28,31,6],[33,37,7],[39,44,8],[46,52,10]
      ],
      0x2293: [  // stix-square intersection, serifs
        [5,5,1],[5,5,0],[6,6,0],[7,8,1],[9,10,1],[10,10,0],[12,12,0],[14,14,0],
        [17,18,1],[20,20,0],[24,24,0],[29,28,0],[34,34,0],[40,40,0]
      ],
      0x2294: [  // stix-square union, serifs
        [5,5,0],[5,5,0],[6,6,0],[7,8,0],[9,9,0],[10,10,0],[12,12,0],[14,14,0],
        [17,17,0],[20,20,0],[24,24,0],[29,28,0],[34,34,0],[40,40,0]
      ],
      0x2295: [  // stix-circled plus (with rim)
        [5,5,1],[6,6,1],[8,7,1],[9,8,1],[11,9,1],[13,12,2],[15,14,2],[17,16,2],
        [20,20,3],[24,23,3],[29,27,4],[34,32,4],[40,38,5],[48,45,6]
      ],
      0x2296: [  // CIRCLED MINUS
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,12,2],[14,14,2],[17,16,2],
        [21,20,3],[24,23,3],[29,27,4],[34,32,4],[40,38,5],[48,45,6]
      ],
      0x2297: [  // stix-circled times (with rim)
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,12,2],[15,14,2],[17,16,2],
        [21,20,3],[24,23,3],[29,27,4],[34,32,4],[40,38,5],[48,45,6]
      ],
      0x2298: [  // CIRCLED DIVISION SLASH
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,12,2],[15,14,2],[17,16,2],
        [21,20,3],[24,23,3],[29,27,4],[34,32,4],[40,38,5],[48,45,6]
      ],
      0x2299: [  // CIRCLED DOT OPERATOR
        [5,5,1],[6,6,1],[7,7,1],[9,8,1],[10,9,1],[12,12,2],[15,14,2],[17,16,2],
        [21,20,3],[24,23,3],[29,27,4],[34,32,4],[40,38,5],[48,45,6]
      ],
      0x22A2: [  // RIGHT TACK
        [4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],[10,12,0],[11,14,0],[13,17,0],
        [16,20,0],[19,23,0],[22,28,0],[26,33,0],[31,39,0],[37,46,0]
      ],
      0x22A3: [  // LEFT TACK
        [4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],[9,12,0],[11,14,0],[13,17,0],
        [16,20,0],[19,23,0],[22,28,0],[26,33,0],[31,39,0],[37,46,0]
      ],
      0x22A4: [  // DOWN TACK
        [5,5,0],[6,6,0],[8,7,0],[9,8,0],[10,11,1],[12,12,1],[15,14,1],[17,16,0],
        [20,20,1],[24,22,0],[29,27,0],[34,32,0],[40,37,0],[48,44,0]
      ],
      0x22A5: [  // UP TACK
        [5,5,0],[6,6,0],[8,7,0],[9,8,0],[10,10,0],[12,12,0],[15,14,0],[17,16,0],
        [20,19,0],[24,22,0],[29,27,0],[34,32,0],[40,37,0],[48,44,0]
      ],
      0x22A8: [  // TRUE
        [6,8,2],[7,10,3],[8,11,3],[10,12,3],[12,15,4],[14,18,5],[16,20,5],[19,24,6],
        [23,28,7],[27,34,9],[32,40,10],[38,47,12],[45,56,14],[54,67,17]
      ],
      0x22C4: [  // DIAMOND OPERATOR
        [4,4,0],[5,5,0],[5,5,0],[6,6,0],[7,7,0],[9,9,0],[10,10,0],[12,12,0],
        [14,14,0],[17,17,0],[20,20,0],[23,23,0],[27,27,0],[33,33,0]
      ],
      0x22C5: [  // DOT OPERATOR
        [2,1,-1],[2,2,-1],[2,3,-1],[3,2,-2],[3,3,-2],[4,3,-3],[4,4,-3],[5,4,-4],
        [6,4,-5],[7,5,-6],[8,6,-7],[10,7,-8],[11,8,-10],[14,9,-12]
      ],
      0x22C6: [  // STAR OPERATOR
        [4,4,0],[5,5,0],[5,5,0],[6,6,0],[7,7,0],[9,9,0],[10,10,0],[12,12,0],
        [14,14,0],[17,16,0],[20,20,0],[24,23,0],[28,27,0],[33,31,-1]
      ],
      0x22C8: [  // BOWTIE
        [7,5,1],[8,6,1],[9,6,1],[11,7,1],[13,8,1],[15,10,1],[17,11,1],[21,13,1],
        [25,15,1],[29,18,1],[35,21,1],[41,25,1],[49,29,1],[58,35,1]
      ],
      0x22EE: [  // VERTICAL ELLIPSIS
        [2,6,0],[2,9,1],[2,10,1],[3,12,1],[3,14,1],[4,16,1],[4,19,1],[5,22,1],
        [6,26,1],[7,31,1],[8,38,2],[10,44,2],[11,52,2],[14,62,2]
      ],
      0x22EF: [  // MIDLINE HORIZONTAL ELLIPSIS
        [8,1,-1],[9,2,-1],[11,3,-1],[13,2,-2],[16,3,-2],[19,3,-3],[22,4,-3],[26,4,-4],
        [31,4,-5],[36,5,-6],[43,6,-7],[51,7,-8],[61,8,-10],[73,9,-12]
      ],
      0x22F1: [  // DOWN RIGHT DIAGONAL ELLIPSIS
        [8,6,0],[10,7,0],[12,9,0],[14,9,-1],[16,11,-1],[20,13,-1],[23,15,-1],[27,18,-2],
        [32,21,-2],[38,24,-3],[46,30,-3],[54,35,-4],[64,41,-5],[76,48,-6]
      ],
      0x2308: [  // LEFT CEILING
        [3,8,2],[4,9,2],[5,11,3],[5,12,3],[6,15,4],[8,17,4],[9,20,5],[10,25,7],
        [12,28,7],[14,34,9],[17,40,10],[20,47,12],[24,56,14],[28,67,17]
      ],
      0x2309: [  // RIGHT CEILING
        [2,8,2],[3,9,2],[3,11,3],[3,12,3],[4,15,4],[5,17,4],[5,20,5],[7,24,6],
        [8,28,7],[9,34,9],[11,40,10],[13,47,12],[15,56,14],[18,67,17]
      ],
      0x230A: [  // LEFT FLOOR
        [3,8,2],[4,9,2],[5,11,3],[5,12,3],[6,15,4],[8,17,4],[8,20,5],[10,24,6],
        [12,28,7],[14,34,9],[17,40,10],[20,47,12],[24,56,14],[28,67,17]
      ],
      0x230B: [  // RIGHT FLOOR
        [2,8,2],[3,9,2],[3,11,3],[3,12,3],[4,15,4],[5,17,4],[5,20,5],[6,24,6],
        [8,28,7],[9,34,9],[11,40,10],[13,47,12],[15,56,14],[18,67,17]
      ],
      0x2322: [  // stix-small down curve
        [7,3,0],[8,4,0],[10,3,-1],[12,4,-1],[14,5,-1],[16,6,-1],[19,6,-2],[22,8,-2],
        [27,8,-3],[32,9,-4],[37,12,-4],[44,13,-5],[53,16,-6],[63,19,-7]
      ],
      0x2323: [  // stix-small up curve
        [7,2,-1],[8,3,-1],[10,3,-1],[12,4,-1],[14,4,-2],[16,5,-2],[19,6,-2],[22,6,-3],
        [27,8,-3],[32,9,-4],[38,10,-5],[44,12,-6],[53,15,-7],[63,17,-8]
      ],
      0x23B0: [  // UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
        [3,8,2],[3,9,2],[4,11,3],[5,12,3],[5,15,4],[6,17,4],[7,20,5],[9,24,6],
        [10,28,7],[12,33,8],[14,40,10],[17,46,11],[20,55,13],[24,65,16]
      ],
      0x23B1: [  // UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
        [3,8,2],[3,9,2],[4,11,3],[5,12,3],[5,15,4],[6,17,4],[7,20,5],[9,24,6],
        [10,28,7],[12,33,8],[14,39,10],[17,47,12],[20,55,14],[24,65,16]
      ],
      0x27E8: [  // MATHEMATICAL LEFT ANGLE BRACKET
        [3,8,2],[3,10,3],[4,11,3],[4,12,3],[5,15,4],[6,18,5],[7,20,5],[8,24,6],
        [10,28,7],[11,34,9],[14,40,10],[16,47,12],[19,56,14],[22,67,17]
      ],
      0x27E9: [  // MATHEMATICAL RIGHT ANGLE BRACKET
        [2,8,2],[3,10,3],[3,11,3],[4,12,3],[4,15,4],[5,18,5],[6,20,5],[7,24,6],
        [8,28,7],[10,34,9],[11,40,10],[13,47,12],[16,56,14],[19,67,17]
      ],
      0x27EE: [  // MATHEMATICAL LEFT FLATTENED PARENTHESIS
        [3,8,2],[3,9,2],[4,11,3],[5,12,3],[5,15,4],[6,17,4],[8,20,5],[9,24,6],
        [10,28,7],[12,33,8],[14,40,10],[17,47,12],[20,56,14],[24,65,16]
      ],
      0x27EF: [  // MATHEMATICAL RIGHT FLATTENED PARENTHESIS
        [2,8,2],[2,9,2],[3,11,3],[3,12,3],[4,15,4],[4,17,4],[5,20,5],[6,24,6],
        [7,28,7],[8,33,8],[10,40,10],[12,46,11],[14,55,13],[16,65,16]
      ],
      0x27F5: [  // LONG LEFTWARDS ARROW
        [11,5,1],[13,5,0],[15,6,1],[18,7,1],[22,9,1],[26,9,0],[30,11,1],[36,13,1],
        [43,15,1],[51,18,1],[60,21,1],[71,25,1],[85,30,1],[101,35,1]
      ],
      0x27F6: [  // LONG RIGHTWARDS ARROW
        [11,5,1],[13,5,0],[16,7,1],[19,7,1],[22,9,1],[26,9,0],[31,11,1],[37,13,1],
        [43,15,1],[52,18,1],[61,22,1],[73,25,1],[86,30,1],[103,35,1]
      ],
      0x27F7: [  // LONG LEFT RIGHT ARROW
        [13,5,1],[15,5,0],[18,6,1],[22,7,1],[25,9,1],[30,9,0],[36,11,1],[42,13,1],
        [50,15,1],[60,18,1],[71,22,1],[84,25,1],[100,30,1],[119,35,1]
      ],
      0x27F8: [  // LONG LEFTWARDS DOUBLE ARROW
        [11,5,1],[13,6,1],[16,7,1],[19,8,1],[22,9,1],[26,10,1],[31,11,1],[37,14,1],
        [43,16,1],[52,20,2],[61,23,2],[73,27,2],[86,31,2],[103,37,2]
      ],
      0x27F9: [  // LONG RIGHTWARDS DOUBLE ARROW
        [11,5,1],[14,6,1],[16,7,1],[19,8,1],[22,9,1],[27,10,1],[31,12,1],[37,14,1],
        [44,16,1],[52,19,1],[62,22,1],[74,26,1],[88,32,2],[104,37,2]
      ],
      0x27FA: [  // LONG LEFT RIGHT DOUBLE ARROW
        [13,5,1],[15,6,1],[18,7,1],[22,8,1],[25,9,1],[30,10,1],[36,12,1],[42,14,1],
        [50,16,1],[60,20,2],[71,23,2],[84,27,2],[100,31,2],[119,37,2]
      ],
      0x27FC: [  // LONG RIGHTWARDS ARROW FROM BAR
        [11,5,1],[13,5,0],[16,7,1],[19,7,1],[22,9,1],[26,9,0],[31,11,1],[37,13,1],
        [44,15,1],[52,18,1],[61,22,1],[73,25,1],[86,30,1],[103,35,1]
      ],
      0x2A3F: [  // AMALGAMATION OR COPRODUCT
        [5,5,0],[6,6,0],[8,7,0],[9,9,0],[10,10,0],[12,12,0],[15,14,0],[17,16,0],
        [20,19,0],[24,23,0],[29,27,0],[34,32,0],[40,38,0],[48,45,0]
      ],
      0x2AAF: [  // PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,18,3],
        [20,22,4],[23,26,5],[28,31,6],[33,37,7],[39,44,8],[46,52,10]
      ],
      0x2AB0: [  // SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
        [5,6,1],[6,7,1],[7,9,2],[9,10,2],[10,11,2],[12,14,3],[14,16,3],[17,19,4],
        [20,22,4],[23,26,5],[28,31,6],[33,37,7],[39,44,8],[46,52,10]
      ]
    },

    "MathJax_Math-bold-italic": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2F: [  // SOLIDUS
        [6,6,1],[7,8,2],[8,10,2],[9,10,2],[11,12,3],[13,16,4],[15,18,4],[18,22,5],
        [21,26,6],[25,31,7],[29,37,8],[35,43,9],[41,51,11],[49,62,14]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,23,0],[33,29,0],[40,33,0],[47,40,0],[56,47,0]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,28,0],[40,32,0],[48,38,0],[57,46,0]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,24,1],[34,29,1],[40,33,1],[48,40,0],[57,49,2]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[16,12,0],[18,14,0],[22,17,0],
        [26,20,0],[31,23,0],[36,28,0],[43,32,0],[51,38,0],[61,46,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [23,20,0],[28,23,0],[33,28,0],[39,32,0],[46,38,0],[55,46,0]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[45,38,0],[54,46,0]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,24,1],[34,29,1],[40,33,1],[48,40,0],[57,48,1]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [8,5,0],[9,6,0],[11,8,0],[13,8,0],[15,9,0],[18,12,0],[21,14,0],[24,17,0],
        [29,20,0],[34,23,0],[41,28,0],[48,32,0],[58,38,0],[68,46,0]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[12,14,0],[14,17,0],
        [16,20,0],[19,23,0],[23,28,0],[27,32,0],[32,38,0],[38,46,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [5,5,0],[6,6,0],[7,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,17,0],
        [20,20,0],[23,24,1],[28,29,1],[33,33,1],[39,39,1],[46,47,1]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [7,5,0],[9,6,0],[10,8,0],[12,8,0],[14,9,0],[17,12,0],[20,14,0],[24,17,0],
        [28,20,0],[34,23,0],[40,28,0],[47,32,0],[56,38,0],[67,46,0]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,5,0],[6,6,0],[7,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,17,0],
        [20,20,0],[24,23,0],[28,28,0],[34,32,0],[40,38,0],[47,46,0]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [9,6,0],[11,7,0],[12,9,0],[15,9,0],[17,10,0],[21,13,0],[24,15,0],[29,18,0],
        [34,21,0],[41,24,0],[48,29,0],[57,33,0],[68,39,0],[81,47,0]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [8,5,0],[9,6,0],[11,8,0],[13,8,0],[15,9,0],[18,12,0],[20,14,0],[24,17,0],
        [29,20,0],[34,23,0],[41,28,0],[48,32,0],[57,38,0],[68,46,0]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,24,1],[32,29,1],[38,33,1],[46,40,1],[54,48,2]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [6,5,0],[8,7,0],[9,9,0],[10,9,0],[12,10,0],[15,13,0],[17,15,0],[20,18,0],
        [24,21,0],[28,24,0],[34,29,0],[40,33,0],[48,39,0],[56,47,0]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,8,2],[8,10,2],[10,10,2],[12,12,3],[14,16,4],[16,18,4],[19,22,5],
        [23,26,6],[27,30,7],[32,36,8],[38,41,9],[46,50,11],[54,60,14]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[30,24,1],[35,29,1],[42,33,1],[49,39,0],[59,47,1]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [5,5,0],[6,6,0],[7,8,0],[9,8,0],[10,9,0],[12,12,0],[14,14,0],[17,17,0],
        [20,20,0],[24,24,1],[28,29,1],[34,33,1],[40,41,2],[47,48,2]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [22,19,0],[26,22,0],[30,27,0],[36,31,0],[43,38,0],[51,45,0]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[29,24,1],[35,29,1],[41,33,1],[49,39,0],[58,47,1]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[29,24,1],[35,29,1],[41,33,1],[49,39,0],[58,47,1]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [9,5,0],[10,6,0],[12,8,0],[15,8,0],[17,9,0],[20,12,0],[24,14,0],[28,17,0],
        [34,20,0],[40,24,1],[48,29,1],[56,33,1],[67,39,0],[80,48,1]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [7,5,0],[8,6,0],[10,8,0],[12,8,0],[14,9,0],[16,12,0],[19,14,0],[23,17,0],
        [27,20,0],[32,23,0],[38,28,0],[45,32,0],[53,39,1],[63,46,0]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[29,23,0],[35,28,0],[41,32,0],[49,38,0],[58,45,0]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[45,38,0],[54,46,0]
      ],
      0x61: [  // LATIN SMALL LETTER A
        [5,3,0],[6,4,0],[6,5,0],[8,5,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],
        [17,13,0],[20,15,0],[24,18,0],[29,21,0],[34,25,0],[40,31,1]
      ],
      0x62: [  // LATIN SMALL LETTER B
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[9,12,0],[10,14,0],[12,17,0],
        [15,20,0],[17,23,0],[21,28,0],[24,32,0],[29,38,0],[34,47,1]
      ],
      0x63: [  // LATIN SMALL LETTER C
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[8,6,0],[9,8,0],[10,9,0],[12,11,0],
        [15,13,0],[17,15,0],[20,18,0],[24,21,0],[29,25,0],[34,31,1]
      ],
      0x64: [  // LATIN SMALL LETTER D
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[12,14,0],[15,17,0],
        [17,20,0],[21,23,0],[25,28,0],[29,32,0],[34,38,0],[41,47,1]
      ],
      0x65: [  // LATIN SMALL LETTER E
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[8,6,0],[9,8,0],[10,9,0],[12,11,0],
        [15,13,0],[17,15,0],[20,18,0],[24,21,0],[29,25,0],[34,31,1]
      ],
      0x66: [  // LATIN SMALL LETTER F
        [5,6,1],[6,8,2],[7,10,2],[8,10,2],[9,12,3],[11,16,4],[13,18,4],[15,22,5],
        [18,26,6],[21,30,7],[25,36,8],[30,41,9],[35,50,11],[42,59,13]
      ],
      0x67: [  // LATIN SMALL LETTER G
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[8,9,3],[9,12,4],[11,13,4],[13,16,5],
        [15,19,6],[18,22,7],[22,26,8],[26,30,9],[30,36,11],[36,43,13]
      ],
      0x68: [  // LATIN SMALL LETTER H
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[15,17,0],
        [18,20,0],[21,23,0],[25,28,0],[30,33,1],[36,39,0],[42,47,1]
      ],
      0x69: [  // LATIN SMALL LETTER I
        [3,5,0],[4,6,0],[4,8,0],[5,8,0],[6,9,0],[7,12,0],[8,14,0],[9,17,0],
        [11,20,0],[12,23,0],[15,28,0],[17,32,0],[21,38,0],[24,47,1]
      ],
      0x6A: [  // LATIN SMALL LETTER J
        [5,6,1],[5,8,2],[6,10,2],[7,10,2],[8,12,3],[9,16,4],[10,18,4],[12,22,5],
        [14,26,6],[16,30,7],[19,36,8],[23,41,9],[27,49,11],[31,59,13]
      ],
      0x6B: [  // LATIN SMALL LETTER K
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[12,14,0],[14,17,0],
        [16,20,0],[19,23,0],[23,28,0],[27,32,0],[32,38,0],[38,47,1]
      ],
      0x6C: [  // LATIN SMALL LETTER L
        [3,5,0],[3,6,0],[3,8,0],[4,8,0],[5,9,0],[5,12,0],[6,14,0],[7,17,0],
        [9,20,0],[10,23,0],[12,28,0],[14,32,0],[17,38,0],[20,47,1]
      ],
      0x6D: [  // LATIN SMALL LETTER M
        [7,3,0],[9,4,0],[10,5,0],[12,5,0],[14,6,0],[17,8,0],[20,9,0],[24,11,0],
        [28,13,0],[33,15,0],[40,18,0],[47,21,0],[56,25,0],[66,31,1]
      ],
      0x6E: [  // LATIN SMALL LETTER N
        [5,3,0],[6,4,0],[7,5,0],[9,5,0],[10,6,0],[12,8,0],[14,9,0],[16,11,0],
        [19,13,0],[23,15,0],[27,18,0],[32,21,0],[38,25,0],[45,31,1]
      ],
      0x6F: [  // LATIN SMALL LETTER O
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],
        [16,13,0],[19,15,0],[23,18,0],[27,21,0],[32,25,0],[38,31,1]
      ],
      0x70: [  // LATIN SMALL LETTER P
        [6,4,1],[6,6,2],[7,7,2],[8,7,2],[10,9,3],[11,12,4],[13,13,4],[15,16,5],
        [18,19,6],[21,22,7],[25,26,8],[30,30,9],[35,36,11],[42,44,14]
      ],
      0x71: [  // LATIN SMALL LETTER Q
        [4,4,1],[5,6,2],[6,7,2],[7,7,2],[8,9,3],[10,12,4],[11,13,4],[13,16,5],
        [16,19,6],[19,22,7],[22,26,8],[26,30,9],[31,36,11],[37,44,14]
      ],
      0x72: [  // LATIN SMALL LETTER R
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],
        [14,13,0],[17,15,0],[20,18,0],[24,21,0],[28,25,0],[33,31,1]
      ],
      0x73: [  // LATIN SMALL LETTER S
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[10,9,0],[12,11,0],
        [14,13,0],[16,15,0],[19,18,0],[23,21,0],[27,25,0],[32,31,1]
      ],
      0x74: [  // LATIN SMALL LETTER T
        [3,5,0],[4,6,0],[4,7,0],[5,7,0],[6,9,0],[7,12,0],[8,13,0],[9,16,0],
        [11,19,0],[13,22,0],[16,26,0],[18,30,0],[22,36,0],[26,43,1]
      ],
      0x75: [  // LATIN SMALL LETTER U
        [5,3,0],[6,4,0],[7,5,0],[8,5,0],[9,6,0],[11,8,0],[13,9,0],[16,11,0],
        [18,13,0],[22,15,0],[26,18,0],[31,21,0],[36,25,0],[43,31,1]
      ],
      0x76: [  // LATIN SMALL LETTER V
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],
        [15,13,0],[18,15,0],[22,18,0],[25,21,0],[30,25,0],[36,31,1]
      ],
      0x77: [  // LATIN SMALL LETTER W
        [6,3,0],[7,4,0],[8,5,0],[10,5,0],[11,6,0],[14,8,0],[16,9,0],[19,11,0],
        [22,13,0],[27,15,0],[32,18,0],[37,21,0],[44,25,0],[53,31,1]
      ],
      0x78: [  // LATIN SMALL LETTER X
        [5,3,0],[5,4,0],[6,5,0],[8,5,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],
        [17,13,0],[20,15,0],[24,18,0],[28,21,0],[34,25,0],[40,31,1]
      ],
      0x79: [  // LATIN SMALL LETTER Y
        [5,4,1],[5,6,2],[6,7,2],[7,7,2],[9,9,3],[10,12,4],[12,13,4],[14,16,5],
        [17,19,6],[20,22,7],[23,26,8],[28,30,9],[33,36,11],[39,43,13]
      ],
      0x7A: [  // LATIN SMALL LETTER Z
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],
        [15,13,0],[18,15,0],[22,18,0],[25,21,0],[30,25,0],[36,31,1]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x393: [  // GREEK CAPITAL LETTER GAMMA
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[11,9,0],[13,12,0],[16,14,0],[19,17,0],
        [22,20,0],[26,23,0],[31,28,0],[37,32,0],[43,38,0],[52,46,0]
      ],
      0x394: [  // GREEK CAPITAL LETTER DELTA
        [7,5,0],[8,7,1],[9,9,1],[11,9,1],[13,10,1],[15,13,1],[18,15,1],[21,18,1],
        [25,21,1],[30,24,1],[36,30,1],[42,34,1],[50,41,1],[60,48,1]
      ],
      0x398: [  // GREEK CAPITAL LETTER THETA
        [6,5,0],[7,6,0],[9,8,0],[10,8,0],[12,9,0],[14,12,0],[17,14,0],[20,17,0],
        [24,20,0],[28,24,1],[34,29,1],[40,33,1],[47,39,1],[56,47,1]
      ],
      0x39B: [  // GREEK CAPITAL LETTER LAMDA
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[11,9,0],[13,12,0],[16,14,0],[18,17,0],
        [22,20,0],[26,24,0],[31,29,0],[36,33,0],[43,40,0],[51,47,0]
      ],
      0x39E: [  // GREEK CAPITAL LETTER XI
        [6,5,0],[8,6,0],[9,8,0],[11,8,0],[12,9,0],[15,12,0],[17,14,0],[20,17,0],
        [24,20,0],[29,23,0],[34,27,0],[40,31,0],[48,38,0],[57,45,0]
      ],
      0x3A0: [  // GREEK CAPITAL LETTER PI
        [8,5,0],[9,6,0],[11,8,0],[13,8,0],[15,9,0],[18,12,0],[21,14,0],[24,17,0],
        [29,20,0],[34,23,0],[41,27,0],[48,32,0],[57,38,0],[68,46,0]
      ],
      0x3A3: [  // GREEK CAPITAL LETTER SIGMA
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[30,23,0],[36,28,0],[42,32,0],[50,38,0],[60,46,0]
      ],
      0x3A5: [  // GREEK CAPITAL LETTER UPSILON
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[45,39,0],[53,47,0]
      ],
      0x3A6: [  // GREEK CAPITAL LETTER PHI
        [6,5,0],[7,6,0],[8,8,0],[9,8,0],[11,9,0],[13,12,0],[15,14,0],[18,17,0],
        [21,20,0],[25,23,0],[29,28,0],[35,32,0],[41,38,0],[49,46,0]
      ],
      0x3A8: [  // GREEK CAPITAL LETTER PSI
        [6,5,0],[7,6,0],[8,8,0],[10,8,0],[12,9,0],[14,12,0],[16,14,0],[19,17,0],
        [23,20,0],[27,23,0],[32,28,0],[38,32,0],[45,38,0],[53,45,0]
      ],
      0x3A9: [  // GREEK CAPITAL LETTER OMEGA
        [7,5,0],[8,6,0],[9,8,0],[11,8,0],[13,9,0],[15,12,0],[18,14,0],[21,17,0],
        [25,20,0],[29,23,0],[35,28,0],[41,32,0],[49,39,0],[58,47,0]
      ],
      0x3B1: [  // GREEK SMALL LETTER ALPHA
        [5,3,0],[6,4,0],[7,5,0],[9,5,0],[10,6,0],[12,8,0],[14,9,0],[17,11,0],
        [20,13,0],[24,15,0],[28,18,0],[34,21,0],[40,25,0],[47,31,1]
      ],
      0x3B2: [  // GREEK SMALL LETTER BETA
        [5,6,1],[6,8,2],[7,10,2],[8,10,2],[9,12,3],[11,16,4],[13,18,4],[15,22,5],
        [18,26,6],[21,30,7],[25,36,8],[30,41,9],[36,50,11],[42,60,14]
      ],
      0x3B3: [  // GREEK SMALL LETTER GAMMA
        [5,4,1],[6,6,2],[7,7,2],[8,7,2],[9,9,3],[11,12,4],[13,13,4],[15,16,5],
        [18,19,6],[21,22,7],[25,26,8],[29,30,9],[35,37,12],[41,45,15]
      ],
      0x3B4: [  // GREEK SMALL LETTER DELTA
        [4,5,0],[5,7,0],[6,8,0],[7,8,0],[8,10,0],[9,13,0],[10,16,0],[12,18,0],
        [15,21,0],[17,25,0],[21,29,0],[24,34,0],[29,41,0],[34,49,1]
      ],
      0x3B5: [  // GREEK SMALL LETTER EPSILON
        [4,3,0],[5,4,0],[5,5,0],[6,5,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],
        [14,13,0],[17,16,1],[20,19,1],[23,22,1],[28,27,1],[33,32,1]
      ],
      0x3B6: [  // GREEK SMALL LETTER ZETA
        [4,6,1],[5,8,2],[6,10,2],[7,10,2],[8,12,3],[9,16,4],[11,18,4],[13,22,5],
        [15,26,6],[18,31,7],[21,37,8],[25,43,9],[30,51,11],[35,61,13]
      ],
      0x3B7: [  // GREEK SMALL LETTER ETA
        [5,4,1],[5,6,2],[6,7,2],[7,7,2],[9,9,3],[10,12,4],[12,13,4],[14,16,5],
        [17,19,6],[20,22,7],[24,26,8],[28,30,9],[33,36,11],[39,45,15]
      ],
      0x3B8: [  // GREEK SMALL LETTER THETA
        [4,5,0],[5,6,0],[6,8,0],[7,8,0],[8,9,0],[10,12,0],[11,14,0],[13,17,0],
        [16,20,0],[19,23,0],[22,28,0],[26,32,0],[31,39,0],[37,47,1]
      ],
      0x3B9: [  // GREEK SMALL LETTER IOTA
        [3,3,0],[4,4,0],[4,5,0],[5,5,0],[6,6,0],[7,8,0],[8,9,0],[9,11,0],
        [11,13,0],[13,15,0],[16,18,0],[18,21,0],[22,25,0],[26,31,1]
      ],
      0x3BA: [  // GREEK SMALL LETTER KAPPA
        [5,3,0],[6,4,0],[7,5,0],[8,5,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],
        [18,13,0],[22,15,0],[26,18,0],[30,21,0],[36,25,0],[43,31,1]
      ],
      0x3BB: [  // GREEK SMALL LETTER LAMDA
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[16,17,0],
        [18,20,0],[22,24,1],[26,29,1],[31,33,1],[36,38,0],[43,47,1]
      ],
      0x3BC: [  // GREEK SMALL LETTER MU
        [5,4,1],[6,6,2],[7,7,2],[8,7,2],[10,9,3],[12,12,4],[14,13,4],[16,16,5],
        [19,19,6],[23,22,7],[27,26,8],[32,31,10],[38,37,12],[45,45,15]
      ],
      0x3BD: [  // GREEK SMALL LETTER NU
        [5,3,0],[6,4,0],[6,5,0],[8,5,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],
        [17,13,0],[20,15,0],[24,18,0],[29,21,0],[34,25,0],[40,31,1]
      ],
      0x3BE: [  // GREEK SMALL LETTER XI
        [4,6,1],[5,8,2],[5,10,2],[6,10,2],[7,12,3],[9,16,4],[10,18,4],[12,22,5],
        [14,26,6],[17,30,7],[20,36,8],[23,43,9],[28,51,11],[33,61,13]
      ],
      0x3BF: [  // GREEK SMALL LETTER OMICRON
        [4,3,0],[5,4,0],[6,5,0],[7,5,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],
        [16,13,0],[19,15,0],[23,18,0],[27,21,0],[32,25,0],[38,31,1]
      ],
      0x3C0: [  // GREEK SMALL LETTER PI
        [5,3,0],[6,4,0],[7,5,0],[8,5,0],[10,6,0],[12,8,0],[14,9,0],[16,11,0],
        [19,13,0],[23,15,0],[27,18,0],[32,21,0],[38,25,0],[45,31,1]
      ],
      0x3C1: [  // GREEK SMALL LETTER RHO
        [5,4,1],[5,6,2],[6,7,2],[8,7,2],[9,9,3],[10,12,4],[12,13,4],[14,16,5],
        [17,19,6],[20,22,7],[24,26,8],[29,30,9],[34,37,12],[40,45,15]
      ],
      0x3C2: [  // GREEK SMALL LETTER FINAL SIGMA
        [4,4,1],[4,5,1],[5,6,1],[6,6,1],[7,7,1],[8,10,2],[9,12,3],[11,14,3],
        [13,16,3],[16,18,3],[18,22,4],[22,26,5],[26,31,6],[31,37,7]
      ],
      0x3C3: [  // GREEK SMALL LETTER SIGMA
        [5,3,0],[6,4,0],[7,5,0],[8,5,0],[10,6,0],[12,8,0],[14,9,0],[16,11,0],
        [19,13,0],[23,15,0],[27,18,0],[32,21,0],[38,25,0],[45,30,1]
      ],
      0x3C4: [  // GREEK SMALL LETTER TAU
        [5,3,0],[6,4,0],[6,5,0],[8,5,0],[9,6,0],[11,8,0],[12,9,0],[15,11,0],
        [17,13,0],[20,16,1],[24,19,1],[29,22,1],[34,25,0],[40,31,1]
      ],
      0x3C5: [  // GREEK SMALL LETTER UPSILON
        [5,3,0],[5,4,0],[6,5,0],[8,5,0],[9,6,0],[10,8,0],[12,9,0],[14,11,0],
        [17,13,0],[20,15,0],[24,18,0],[28,21,0],[34,25,0],[40,31,1]
      ],
      0x3C6: [  // GREEK SMALL LETTER PHI
        [5,4,1],[6,6,2],[7,7,2],[9,7,2],[10,9,3],[12,12,4],[14,13,4],[17,16,5],
        [20,19,6],[24,22,7],[28,26,8],[33,31,10],[39,37,12],[47,44,14]
      ],
      0x3C7: [  // GREEK SMALL LETTER CHI
        [5,4,1],[6,6,2],[7,7,2],[9,7,2],[10,9,3],[12,12,4],[14,13,4],[17,16,5],
        [20,19,6],[23,22,7],[28,26,8],[33,30,9],[39,36,11],[46,43,13]
      ],
      0x3C8: [  // GREEK SMALL LETTER PSI
        [6,6,1],[7,8,2],[8,10,2],[9,10,2],[11,12,3],[13,16,4],[15,18,4],[17,22,5],
        [21,26,6],[24,30,7],[29,36,8],[34,41,9],[41,50,11],[48,59,13]
      ],
      0x3C9: [  // GREEK SMALL LETTER OMEGA
        [5,3,0],[6,4,0],[7,5,0],[9,5,0],[10,6,0],[12,8,0],[14,9,0],[17,11,0],
        [20,13,0],[23,15,0],[28,18,0],[33,21,0],[39,25,0],[46,31,1]
      ],
      0x3D1: [  // GREEK THETA SYMBOL
        [5,5,0],[6,6,0],[7,8,0],[8,8,0],[9,9,0],[11,12,0],[13,14,0],[16,17,0],
        [18,20,0],[22,23,0],[26,28,0],[31,32,0],[36,39,0],[43,47,1]
      ],
      0x3D5: [  // GREEK PHI SYMBOL
        [5,6,1],[6,8,2],[7,10,2],[9,10,2],[10,12,3],[12,16,4],[14,18,4],[16,22,5],
        [20,26,6],[23,30,7],[27,36,8],[32,41,9],[39,49,11],[46,59,13]
      ],
      0x3D6: [  // GREEK PI SYMBOL
        [7,3,0],[8,4,0],[10,5,0],[12,5,0],[14,6,0],[16,8,0],[19,9,0],[23,11,0],
        [27,13,0],[32,15,0],[38,18,0],[45,21,0],[53,25,0],[63,31,1]
      ],
      0x3F1: [  // GREEK RHO SYMBOL
        [5,4,1],[5,6,2],[6,7,2],[8,7,2],[9,9,3],[10,12,4],[12,13,4],[14,16,5],
        [17,19,6],[20,22,7],[24,26,8],[28,30,9],[34,36,11],[40,44,14]
      ],
      0x3F5: [  // GREEK LUNATE EPSILON SYMBOL
        [4,3,0],[4,4,0],[5,5,0],[6,5,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],
        [13,13,0],[15,15,0],[18,18,0],[22,21,0],[26,25,0],[30,30,1]
      ]
    },

    "MathJax_Math-italic": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2F: [  // SOLIDUS
        [5,6,1],[6,8,2],[7,8,2],[8,10,2],[9,12,3],[11,14,3],[13,18,4],[15,21,5],
        [18,25,6],[21,31,7],[25,36,8],[30,45,10],[36,53,12],[42,61,14]
      ],
      0x41: [  // LATIN CAPITAL LETTER A
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[17,16,0],
        [21,19,0],[24,24,0],[29,28,0],[34,34,1],[41,41,1],[48,47,1]
      ],
      0x42: [  // LATIN CAPITAL LETTER B
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,19,0],[25,23,0],[30,27,0],[36,33,0],[42,39,0],[50,45,0]
      ],
      0x43: [  // LATIN CAPITAL LETTER C
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,20,1],[25,25,1],[30,29,1],[36,35,1],[42,41,1],[50,48,1]
      ],
      0x44: [  // LATIN CAPITAL LETTER D
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,10,0],[14,11,0],[16,14,0],[19,16,0],
        [23,19,0],[27,23,0],[32,27,0],[38,33,0],[45,39,0],[53,45,0]
      ],
      0x45: [  // LATIN CAPITAL LETTER E
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [22,19,0],[26,23,0],[30,27,0],[36,33,0],[43,39,0],[51,46,0]
      ],
      0x46: [  // LATIN CAPITAL LETTER F
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,19,0],[25,23,0],[30,27,0],[35,33,0],[42,39,0],[50,45,-1]
      ],
      0x47: [  // LATIN CAPITAL LETTER G
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,20,1],[25,25,1],[30,29,1],[36,35,1],[42,41,1],[50,48,1]
      ],
      0x48: [  // LATIN CAPITAL LETTER H
        [7,5,0],[8,7,0],[9,7,0],[11,9,0],[13,10,0],[15,12,0],[18,15,0],[21,17,0],
        [25,20,0],[30,24,0],[35,28,0],[42,34,0],[50,40,0],[59,46,0]
      ],
      0x49: [  // LATIN CAPITAL LETTER I
        [4,5,0],[5,6,0],[5,6,0],[6,8,0],[7,9,0],[9,11,0],[10,14,0],[12,16,0],
        [14,19,0],[17,23,0],[20,27,0],[24,33,0],[28,39,0],[34,45,0]
      ],
      0x4A: [  // LATIN CAPITAL LETTER J
        [5,5,0],[6,7,0],[7,6,0],[8,9,0],[9,10,0],[11,12,0],[13,15,0],[15,17,0],
        [18,21,1],[21,25,1],[25,29,1],[30,35,1],[35,41,1],[42,47,1]
      ],
      0x4B: [  // LATIN CAPITAL LETTER K
        [7,5,0],[8,6,0],[9,6,0],[11,8,0],[13,10,0],[15,11,0],[18,14,0],[21,16,0],
        [25,19,0],[30,23,0],[35,27,0],[42,33,0],[50,39,0],[59,45,0]
      ],
      0x4C: [  // LATIN CAPITAL LETTER L
        [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,0],
        [18,19,0],[22,23,0],[26,27,0],[30,33,0],[36,39,0],[43,45,-1]
      ],
      0x4D: [  // LATIN CAPITAL LETTER M
        [8,5,0],[9,6,0],[11,6,0],[13,8,0],[15,10,0],[18,11,0],[21,14,0],[25,16,0],
        [29,19,0],[35,24,0],[42,27,0],[49,33,0],[58,39,0],[70,45,-1]
      ],
      0x4E: [  // LATIN CAPITAL LETTER N
        [7,5,0],[8,7,0],[9,6,0],[11,9,0],[13,10,0],[15,12,0],[18,15,0],[21,17,0],
        [25,20,0],[30,24,0],[35,28,0],[42,34,0],[50,39,0],[59,46,0]
      ],
      0x4F: [  // LATIN CAPITAL LETTER O
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,20,1],[25,25,1],[29,29,1],[35,35,2],[41,41,1],[49,48,1]
      ],
      0x50: [  // LATIN CAPITAL LETTER P
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,19,0],[25,23,0],[30,27,0],[35,33,0],[42,39,0],[50,45,0]
      ],
      0x51: [  // LATIN CAPITAL LETTER Q
        [6,6,1],[7,8,2],[8,8,2],[9,10,2],[11,12,3],[13,14,3],[15,18,4],[18,21,5],
        [21,25,6],[25,31,7],[29,36,8],[35,44,10],[41,51,11],[49,59,13]
      ],
      0x52: [  // LATIN CAPITAL LETTER R
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,20,1],[25,24,1],[30,28,1],[35,34,1],[42,40,1],[50,46,1]
      ],
      0x53: [  // LATIN CAPITAL LETTER S
        [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,0],
        [18,20,1],[22,25,1],[26,29,1],[31,35,2],[36,41,1],[43,48,2]
      ],
      0x54: [  // LATIN CAPITAL LETTER T
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,16,0],
        [20,19,0],[24,23,0],[28,26,0],[33,32,0],[40,38,0],[47,44,0]
      ],
      0x55: [  // LATIN CAPITAL LETTER U
        [6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],[13,12,0],[15,15,0],[18,17,0],
        [22,21,1],[26,25,1],[31,29,1],[36,35,1],[43,41,1],[51,48,1]
      ],
      0x56: [  // LATIN CAPITAL LETTER V
        [6,6,1],[7,7,1],[8,7,1],[10,9,1],[11,10,1],[13,12,1],[15,15,1],[18,17,1],
        [22,20,1],[26,24,1],[31,28,1],[36,35,2],[43,41,2],[51,47,1]
      ],
      0x57: [  // LATIN CAPITAL LETTER W
        [8,5,0],[9,6,0],[11,6,0],[13,8,0],[15,9,0],[18,11,0],[21,14,0],[25,16,0],
        [29,20,1],[35,24,1],[41,28,1],[49,34,1],[58,41,2],[69,48,2]
      ],
      0x58: [  // LATIN CAPITAL LETTER X
        [6,5,0],[8,7,1],[9,7,1],[10,9,1],[12,10,1],[15,12,1],[17,15,1],[20,17,1],
        [24,20,1],[28,24,1],[34,28,1],[40,34,1],[48,40,1],[56,46,1]
      ],
      0x59: [  // LATIN CAPITAL LETTER Y
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [22,19,0],[26,23,0],[30,27,0],[36,33,0],[43,39,0],[51,45,-1]
      ],
      0x5A: [  // LATIN CAPITAL LETTER Z
        [5,5,0],[6,6,0],[8,6,0],[9,8,0],[10,9,0],[12,11,0],[15,14,0],[17,16,0],
        [20,19,0],[24,23,0],[29,27,0],[34,33,0],[40,39,0],[48,45,0]
      ],
      0x61: [  // LATIN SMALL LETTER A
        [4,3,0],[5,4,0],[5,4,0],[6,5,0],[7,6,0],[9,7,0],[10,9,0],[12,10,0],
        [14,12,0],[17,15,0],[20,17,0],[24,22,1],[28,26,1],[34,30,1]
      ],
      0x62: [  // LATIN SMALL LETTER B
        [3,5,0],[4,6,0],[5,6,0],[5,8,0],[6,9,0],[7,11,0],[9,14,0],[10,16,0],
        [12,19,0],[14,24,0],[17,27,0],[20,34,1],[24,40,1],[28,47,1]
      ],
      0x63: [  // LATIN SMALL LETTER C
        [3,3,0],[4,4,0],[5,4,0],[6,5,0],[6,6,0],[8,7,0],[9,9,0],[10,10,0],
        [12,12,0],[15,15,0],[17,17,0],[21,22,1],[24,26,1],[29,30,1]
      ],
      0x64: [  // LATIN SMALL LETTER D
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[9,11,0],[11,14,0],[13,16,0],
        [15,19,0],[18,24,0],[21,27,0],[25,34,1],[30,40,1],[35,47,1]
      ],
      0x65: [  // LATIN SMALL LETTER E
        [3,3,0],[4,4,0],[5,4,0],[6,5,0],[6,6,0],[8,7,0],[9,9,0],[10,10,0],
        [12,12,0],[15,15,0],[17,17,0],[20,22,1],[24,26,1],[29,30,1]
      ],
      0x66: [  // LATIN SMALL LETTER F
        [4,6,1],[5,8,2],[6,8,2],[7,10,2],[8,12,3],[10,14,3],[11,18,4],[13,21,5],
        [16,25,6],[19,31,7],[22,36,8],[26,43,10],[31,51,12],[37,60,13]
      ],
      0x67: [  // LATIN SMALL LETTER G
        [4,4,1],[4,6,2],[5,6,2],[6,7,2],[7,9,3],[8,10,3],[10,13,4],[12,15,5],
        [14,18,6],[16,22,7],[19,25,8],[23,31,10],[27,37,12],[32,42,13]
      ],
      0x68: [  // LATIN SMALL LETTER H
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,0],
        [16,19,0],[19,24,0],[22,27,0],[26,34,1],[31,40,1],[37,47,1]
      ],
      0x69: [  // LATIN SMALL LETTER I
        [3,5,0],[3,6,0],[3,6,0],[4,8,0],[5,10,0],[5,11,0],[6,14,0],[7,16,0],
        [9,18,0],[10,23,0],[12,26,0],[14,32,1],[17,38,1],[20,44,1]
      ],
      0x6A: [  // LATIN SMALL LETTER J
        [4,6,1],[5,8,2],[5,8,2],[6,10,2],[7,13,3],[8,14,3],[9,18,4],[11,20,5],
        [13,24,6],[15,30,7],[17,33,8],[20,41,10],[24,49,12],[28,57,13]
      ],
      0x6B: [  // LATIN SMALL LETTER K
        [4,5,0],[5,6,0],[5,6,0],[6,8,0],[7,9,0],[9,11,0],[10,14,0],[12,16,0],
        [14,19,0],[17,24,0],[20,27,0],[24,34,1],[28,40,1],[33,47,1]
      ],
      0x6C: [  // LATIN SMALL LETTER L
        [2,6,0],[3,7,0],[3,7,0],[4,9,0],[4,10,0],[5,12,0],[6,15,0],[7,17,0],
        [8,20,0],[9,24,0],[11,28,0],[13,35,1],[15,40,1],[18,47,1]
      ],
      0x6D: [  // LATIN SMALL LETTER M
        [6,3,0],[8,4,0],[9,4,0],[10,5,0],[12,6,0],[15,7,0],[17,9,0],[20,10,0],
        [24,12,0],[28,15,0],[34,17,0],[40,22,1],[48,26,1],[56,30,1]
      ],
      0x6E: [  // LATIN SMALL LETTER N
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[12,9,0],[14,10,0],
        [16,12,0],[19,15,0],[23,17,0],[27,22,1],[32,26,1],[38,30,1]
      ],
      0x6F: [  // LATIN SMALL LETTER O
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[12,10,0],
        [14,12,0],[16,15,0],[19,17,0],[23,22,1],[27,26,1],[32,30,1]
      ],
      0x70: [  // LATIN SMALL LETTER P
        [5,4,1],[6,6,2],[6,6,2],[7,7,2],[8,9,3],[10,10,3],[11,13,4],[13,15,5],
        [16,18,6],[19,22,7],[22,25,8],[26,31,10],[31,37,12],[36,43,14]
      ],
      0x71: [  // LATIN SMALL LETTER Q
        [4,4,1],[4,6,2],[5,6,2],[6,7,2],[7,9,3],[8,10,3],[9,13,4],[11,15,5],
        [13,18,6],[16,22,7],[18,24,7],[22,31,10],[26,37,12],[31,42,13]
      ],
      0x72: [  // LATIN SMALL LETTER R
        [3,3,0],[4,4,0],[5,4,0],[6,5,0],[6,6,0],[8,7,0],[9,9,0],[10,10,0],
        [12,12,0],[15,15,0],[17,17,0],[20,22,1],[24,26,1],[29,30,1]
      ],
      0x73: [  // LATIN SMALL LETTER S
        [3,3,0],[4,4,0],[5,4,0],[5,5,0],[6,6,0],[7,7,0],[9,9,0],[10,10,0],
        [12,12,0],[14,15,0],[17,17,0],[20,22,1],[24,26,1],[28,30,1]
      ],
      0x74: [  // LATIN SMALL LETTER T
        [3,5,0],[3,6,0],[4,6,0],[4,7,0],[5,9,0],[6,10,0],[7,13,0],[8,15,0],
        [10,18,0],[11,22,0],[13,25,0],[16,30,1],[19,36,1],[22,42,1]
      ],
      0x75: [  // LATIN SMALL LETTER U
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[11,9,0],[13,10,0],
        [16,12,0],[19,15,0],[22,17,0],[26,22,1],[31,26,1],[37,30,1]
      ],
      0x76: [  // LATIN SMALL LETTER V
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
        [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
      ],
      0x77: [  // LATIN SMALL LETTER W
        [5,3,0],[6,4,0],[7,4,0],[9,5,0],[10,6,0],[12,7,0],[14,9,0],[16,10,0],
        [20,12,0],[23,15,0],[27,17,0],[32,22,1],[39,26,1],[46,30,1]
      ],
      0x78: [  // LATIN SMALL LETTER X
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[11,9,0],[13,10,0],
        [15,12,0],[18,15,0],[21,17,0],[25,22,1],[29,26,1],[35,30,1]
      ],
      0x79: [  // LATIN SMALL LETTER Y
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,15,5],
        [14,18,6],[17,22,7],[20,25,8],[23,31,10],[28,37,12],[33,42,13]
      ],
      0x7A: [  // LATIN SMALL LETTER Z
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[11,10,0],
        [13,12,0],[16,15,0],[19,17,0],[22,22,1],[26,26,1],[31,30,1]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x393: [  // GREEK CAPITAL LETTER GAMMA
        [5,5,0],[6,6,0],[8,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,16,0],
        [20,19,0],[24,23,0],[29,27,0],[34,33,0],[40,39,0],[48,45,0]
      ],
      0x394: [  // GREEK CAPITAL LETTER DELTA
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,0],
        [22,19,0],[26,24,0],[31,28,0],[37,34,0],[44,41,0],[52,47,0]
      ],
      0x398: [  // GREEK CAPITAL LETTER THETA
        [6,5,0],[7,6,0],[8,6,0],[9,8,0],[11,9,0],[13,11,0],[15,14,0],[18,16,0],
        [21,20,1],[25,25,1],[29,29,1],[35,35,2],[41,41,1],[49,48,1]
      ],
      0x39B: [  // GREEK CAPITAL LETTER LAMDA
        [5,5,0],[6,7,0],[7,7,0],[8,8,0],[10,10,0],[12,12,0],[14,15,0],[16,16,0],
        [19,20,0],[23,24,0],[27,28,0],[32,34,1],[38,41,1],[45,47,0]
      ],
      0x39E: [  // GREEK CAPITAL LETTER XI
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[13,11,0],[16,14,0],[19,16,0],
        [22,19,0],[26,23,0],[31,27,0],[37,32,0],[43,38,0],[52,45,0]
      ],
      0x3A0: [  // GREEK CAPITAL LETTER PI
        [7,5,0],[8,6,0],[9,6,0],[11,8,0],[13,9,0],[15,11,0],[18,14,0],[21,16,0],
        [25,19,0],[30,23,0],[35,27,0],[42,33,0],[50,39,0],[59,45,0]
      ],
      0x3A3: [  // GREEK CAPITAL LETTER SIGMA
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[12,9,0],[14,11,0],[16,14,0],[19,16,0],
        [23,19,0],[27,23,0],[32,27,0],[38,33,0],[45,39,0],[54,46,0]
      ],
      0x3A5: [  // GREEK CAPITAL LETTER UPSILON
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,16,0],
        [20,19,0],[23,24,0],[28,28,0],[33,34,0],[39,40,0],[46,46,0]
      ],
      0x3A6: [  // GREEK CAPITAL LETTER PHI
        [5,5,0],[6,6,0],[7,6,0],[8,8,0],[9,9,0],[11,11,0],[13,14,0],[15,16,0],
        [18,19,0],[22,23,0],[26,27,0],[30,32,-1],[36,39,0],[43,45,-1]
      ],
      0x3A8: [  // GREEK CAPITAL LETTER PSI
        [5,5,0],[6,6,0],[7,6,0],[9,8,0],[10,9,0],[12,11,0],[14,14,0],[17,16,0],
        [20,19,0],[23,23,0],[28,27,0],[33,32,-1],[39,39,0],[46,45,-1]
      ],
      0x3A9: [  // GREEK CAPITAL LETTER OMEGA
        [6,5,0],[7,6,0],[8,6,0],[10,8,0],[11,9,0],[14,11,0],[16,14,0],[19,16,0],
        [22,19,0],[26,24,0],[31,28,0],[37,34,0],[44,40,0],[52,47,0]
      ],
      0x3B1: [  // GREEK SMALL LETTER ALPHA
        [5,3,0],[5,4,0],[6,4,0],[8,5,0],[9,6,0],[10,7,0],[12,9,0],[14,10,0],
        [17,12,0],[20,15,0],[24,17,0],[28,22,1],[34,26,1],[40,30,1]
      ],
      0x3B2: [  // GREEK SMALL LETTER BETA
        [4,6,1],[5,8,2],[6,8,2],[7,10,2],[8,12,3],[10,14,3],[12,18,4],[14,21,5],
        [16,25,6],[19,31,7],[23,36,8],[27,43,10],[32,52,12],[38,59,13]
      ],
      0x3B3: [  // GREEK SMALL LETTER GAMMA
        [4,4,1],[5,6,2],[6,6,2],[7,7,2],[8,9,3],[10,10,3],[11,13,4],[13,15,5],
        [16,18,6],[18,22,7],[22,25,8],[26,32,11],[31,38,13],[36,44,15]
      ],
      0x3B4: [  // GREEK SMALL LETTER DELTA
        [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[9,14,0],[11,16,0],
        [13,19,0],[15,24,0],[18,28,0],[21,35,1],[25,41,1],[30,48,1]
      ],
      0x3B5: [  // GREEK SMALL LETTER EPSILON
        [3,3,0],[4,4,0],[5,4,0],[6,5,0],[6,6,0],[8,7,0],[9,9,0],[10,10,0],
        [12,13,1],[15,16,1],[17,18,1],[20,22,1],[24,27,2],[29,31,1]
      ],
      0x3B6: [  // GREEK SMALL LETTER ZETA
        [4,6,1],[4,8,2],[5,8,2],[6,10,2],[7,12,3],[8,14,3],[10,18,4],[11,21,5],
        [13,25,6],[16,31,7],[19,36,8],[22,43,10],[26,52,12],[31,60,13]
      ],
      0x3B7: [  // GREEK SMALL LETTER ETA
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,15,5],
        [14,18,6],[17,22,7],[20,25,8],[24,32,11],[28,38,13],[33,44,15]
      ],
      0x3B8: [  // GREEK SMALL LETTER THETA
        [4,5,0],[4,6,0],[5,6,0],[6,8,0],[7,9,0],[8,11,0],[9,14,0],[11,16,0],
        [13,19,0],[16,24,0],[19,28,0],[22,34,1],[26,41,1],[31,47,1]
      ],
      0x3B9: [  // GREEK SMALL LETTER IOTA
        [3,3,0],[3,4,0],[4,4,0],[4,5,0],[5,6,0],[6,7,0],[7,9,0],[8,10,0],
        [10,12,0],[11,15,0],[13,17,0],[16,22,1],[19,26,1],[22,30,1]
      ],
      0x3BA: [  // GREEK SMALL LETTER KAPPA
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[11,9,0],[13,10,0],
        [16,12,0],[19,15,0],[22,17,0],[26,22,1],[31,26,1],[37,30,1]
      ],
      0x3BB: [  // GREEK SMALL LETTER LAMDA
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[13,16,0],
        [16,19,0],[19,24,0],[22,27,0],[26,34,1],[31,40,1],[37,47,1]
      ],
      0x3BC: [  // GREEK SMALL LETTER MU
        [4,4,1],[5,6,2],[6,6,2],[7,7,2],[8,9,3],[10,10,3],[12,13,4],[14,15,5],
        [16,18,6],[20,22,7],[23,25,8],[27,32,11],[33,38,13],[39,44,15]
      ],
      0x3BD: [  // GREEK SMALL LETTER NU
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[11,9,0],[13,10,0],
        [15,12,0],[18,15,0],[21,17,0],[25,22,1],[30,25,0],[35,29,0]
      ],
      0x3BE: [  // GREEK SMALL LETTER XI
        [4,6,1],[4,8,2],[5,8,2],[6,10,2],[7,12,3],[8,14,3],[9,18,4],[11,21,5],
        [13,25,6],[15,31,7],[18,36,8],[21,43,10],[25,52,12],[30,60,13]
      ],
      0x3BF: [  // GREEK SMALL LETTER OMICRON
        [4,3,0],[4,4,0],[5,4,0],[6,5,0],[7,6,0],[8,7,0],[10,9,0],[12,10,0],
        [14,12,0],[16,15,0],[19,17,0],[23,22,1],[27,26,1],[32,30,1]
      ],
      0x3C0: [  // GREEK SMALL LETTER PI
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[12,9,0],[14,10,0],
        [16,12,0],[19,15,0],[23,17,0],[27,22,1],[32,25,1],[38,29,1]
      ],
      0x3C1: [  // GREEK SMALL LETTER RHO
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[7,9,3],[9,10,3],[10,13,4],[12,15,5],
        [14,18,6],[17,22,7],[20,25,8],[24,32,11],[28,38,13],[34,44,15]
      ],
      0x3C2: [  // GREEK SMALL LETTER FINAL SIGMA
        [3,4,1],[4,5,1],[5,5,1],[5,7,2],[6,8,2],[7,9,2],[8,11,2],[10,13,3],
        [12,15,3],[14,19,4],[17,22,5],[20,26,5],[23,32,7],[27,36,7]
      ],
      0x3C3: [  // GREEK SMALL LETTER SIGMA
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[10,7,0],[12,9,0],[14,10,0],
        [16,12,0],[19,15,0],[23,17,0],[27,22,1],[32,25,1],[38,29,1]
      ],
      0x3C4: [  // GREEK SMALL LETTER TAU
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[10,9,0],[12,10,0],
        [15,12,0],[17,15,0],[21,17,0],[24,21,1],[29,26,1],[34,29,1]
      ],
      0x3C5: [  // GREEK SMALL LETTER UPSILON
        [4,3,0],[5,4,0],[6,4,0],[7,5,0],[8,6,0],[9,7,0],[11,9,0],[13,10,0],
        [15,12,0],[18,15,0],[21,17,0],[25,22,1],[29,26,1],[35,30,1]
      ],
      0x3C6: [  // GREEK SMALL LETTER PHI
        [5,4,1],[6,6,2],[7,6,2],[8,7,2],[9,9,3],[11,10,3],[13,13,4],[15,15,5],
        [18,18,6],[21,22,7],[25,25,8],[29,32,11],[35,38,13],[41,44,15]
      ],
      0x3C7: [  // GREEK SMALL LETTER CHI
        [5,4,1],[5,6,2],[6,6,2],[8,7,2],[9,9,3],[10,10,3],[12,13,4],[14,15,5],
        [17,18,6],[20,22,7],[24,25,8],[28,31,10],[34,37,12],[40,42,13]
      ],
      0x3C8: [  // GREEK SMALL LETTER PSI
        [5,6,1],[6,8,2],[7,8,2],[8,10,2],[9,12,3],[11,14,3],[13,18,4],[15,21,5],
        [18,25,6],[21,31,7],[25,35,8],[30,43,10],[35,51,12],[42,59,13]
      ],
      0x3C9: [  // GREEK SMALL LETTER OMEGA
        [5,3,0],[6,4,0],[6,4,0],[8,5,0],[9,6,0],[11,7,0],[12,9,0],[15,10,0],
        [17,12,0],[20,15,0],[24,17,0],[29,22,1],[34,26,1],[40,30,1]
      ],
      0x3D1: [  // GREEK THETA SYMBOL
        [4,5,0],[5,6,0],[6,6,0],[7,8,0],[8,9,0],[10,11,0],[11,14,0],[14,16,0],
        [16,19,0],[19,24,0],[23,28,0],[27,34,1],[32,41,1],[38,47,1]
      ],
      0x3D5: [  // GREEK PHI SYMBOL
        [4,6,1],[5,8,2],[6,8,2],[7,10,2],[8,12,3],[10,14,3],[12,18,4],[14,21,5],
        [16,25,6],[20,31,7],[23,35,8],[27,43,10],[32,51,12],[39,59,13]
      ],
      0x3D6: [  // GREEK PI SYMBOL
        [6,3,0],[7,4,0],[9,4,0],[10,5,0],[12,6,0],[14,7,0],[17,9,0],[20,10,0],
        [23,12,0],[28,15,0],[33,17,0],[39,22,1],[46,25,1],[55,29,1]
      ],
      0x3F1: [  // GREEK RHO SYMBOL
        [4,4,1],[5,6,2],[5,6,2],[6,7,2],[8,9,3],[9,10,3],[10,13,4],[12,15,5],
        [15,18,6],[17,22,7],[20,25,8],[24,31,10],[29,37,12],[34,42,13]
      ],
      0x3F5: [  // GREEK LUNATE EPSILON SYMBOL
        [3,3,0],[4,4,0],[4,4,0],[5,5,0],[6,6,0],[7,7,0],[8,9,0],[9,10,0],
        [11,12,0],[13,15,0],[15,17,0],[18,21,1],[21,25,1],[25,30,1]
      ]
    },

    "MathJax_Size1": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x28: [  // LEFT PARENTHESIS
        [3,9,2],[4,10,3],[5,12,3],[5,15,4],[6,17,5],[7,20,6],[9,24,7],[10,28,8],
        [12,34,10],[14,40,11],[17,47,14],[20,56,16],[24,67,19],[28,79,23]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [3,9,2],[3,10,3],[3,12,3],[4,15,4],[5,17,5],[6,20,6],[6,24,7],[8,28,8],
        [9,34,10],[11,40,11],[12,47,14],[15,56,16],[17,67,19],[21,79,23]
      ],
      0x2F: [  // SOLIDUS
        [4,9,2],[5,10,3],[6,12,3],[7,14,4],[8,17,5],[9,20,6],[11,24,7],[13,28,8],
        [15,33,10],[18,40,11],[21,47,14],[25,56,16],[29,67,19],[35,79,23]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [3,9,3],[4,11,3],[4,12,4],[5,15,4],[6,17,5],[7,20,6],[8,24,7],[10,28,8],
        [11,34,10],[13,41,12],[16,47,14],[19,56,16],[22,67,19],[26,79,23]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [4,9,2],[5,10,3],[6,12,3],[7,14,4],[8,17,5],[9,20,6],[11,24,7],[13,28,8],
        [15,33,10],[18,40,11],[21,47,14],[25,56,16],[29,67,19],[35,79,23]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [2,9,3],[2,11,3],[3,12,4],[3,15,4],[3,17,5],[4,20,6],[5,24,7],[5,28,8],
        [6,34,10],[8,41,12],[9,47,14],[10,56,16],[12,67,19],[15,79,23]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [4,9,2],[4,10,3],[5,12,3],[6,15,4],[7,17,5],[8,20,6],[10,24,7],[12,28,8],
        [14,34,10],[16,40,12],[19,47,14],[23,56,16],[27,67,20],[32,79,23]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [4,9,2],[4,10,3],[5,12,3],[6,15,4],[7,17,5],[8,20,6],[10,24,7],[12,28,8],
        [14,34,10],[16,40,11],[19,47,13],[23,56,16],[27,67,19],[32,79,23]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2C6: [  // MODIFIER LETTER CIRCUMFLEX ACCENT
        [5,3,-3],[6,3,-4],[7,3,-5],[8,3,-6],[9,4,-7],[11,4,-9],[12,4,-10],[15,5,-13],
        [17,7,-14],[20,7,-17],[24,8,-21],[28,10,-25],[33,12,-30],[39,14,-36]
      ],
      0x2DC: [  // SMALL TILDE
        [4,1,-4],[5,2,-5],[6,2,-6],[7,2,-7],[8,2,-8],[10,3,-9],[11,4,-11],[13,4,-13],
        [16,4,-17],[19,5,-20],[22,5,-23],[26,6,-28],[31,7,-33],[37,9,-39]
      ],
      0x302: [  // COMBINING CIRCUMFLEX ACCENT
        [5,3,-3],[6,3,-4],[7,3,-5],[8,3,-6],[9,4,-7],[11,4,-9],[12,4,-10],[15,5,-13],
        [17,7,-14],[20,7,-17],[24,8,-21],[28,10,-25],[33,12,-30],[39,14,-36]
      ],
      0x303: [  // COMBINING TILDE
        [4,1,-4],[5,2,-5],[6,2,-6],[7,2,-7],[8,2,-8],[10,3,-9],[11,4,-11],[13,4,-13],
        [16,4,-17],[19,5,-20],[22,5,-23],[26,6,-28],[31,7,-33],[37,9,-39]
      ],
      0x2016: [  // DOUBLE VERTICAL LINE
        [4,5,0],[5,5,0],[6,6,0],[7,8,0],[8,9,0],[9,10,0],[11,12,0],[13,14,0],
        [15,17,0],[18,20,0],[21,24,0],[25,28,0],[29,34,0],[35,40,0]
      ],
      0x2191: [  // UPWARDS ARROW
        [4,5,0],[5,5,0],[6,6,0],[7,8,0],[8,9,0],[10,10,0],[11,12,0],[13,14,0],
        [16,17,0],[19,20,0],[22,24,0],[26,28,0],[31,34,0],[37,40,0]
      ],
      0x2193: [  // DOWNWARDS ARROW
        [4,5,0],[5,5,0],[6,6,0],[7,8,0],[8,9,0],[10,10,0],[11,12,0],[13,14,0],
        [16,17,0],[19,20,0],[22,24,0],[26,28,0],[31,34,0],[37,40,0]
      ],
      0x21D1: [  // UPWARDS DOUBLE ARROW
        [5,5,0],[7,5,0],[7,6,0],[9,8,0],[10,9,0],[13,10,0],[14,12,0],[17,14,0],
        [20,17,0],[24,20,0],[29,24,0],[34,28,0],[40,34,0],[48,40,0]
      ],
      0x21D3: [  // DOWNWARDS DOUBLE ARROW
        [5,5,0],[7,5,0],[7,6,0],[9,8,0],[10,9,0],[13,10,0],[14,12,0],[17,14,0],
        [20,17,0],[24,20,0],[29,24,0],[34,28,0],[40,34,0],[48,40,0]
      ],
      0x220F: [  // N-ARY PRODUCT
        [7,8,2],[8,9,2],[9,11,3],[11,12,3],[13,15,4],[15,17,4],[18,20,5],[21,24,6],
        [25,28,7],[30,34,9],[35,40,10],[42,47,12],[50,56,14],[59,67,17]
      ],
      0x2210: [  // N-ARY COPRODUCT
        [7,8,2],[8,9,2],[9,11,3],[11,12,3],[13,15,4],[15,17,4],[18,20,5],[21,24,6],
        [25,28,7],[30,34,9],[35,40,10],[42,47,12],[50,56,14],[59,67,17]
      ],
      0x2211: [  // N-ARY SUMMATION
        [7,8,2],[9,9,2],[10,11,3],[12,12,3],[14,15,4],[17,18,5],[20,20,5],[24,24,6],
        [28,28,7],[33,34,9],[40,40,10],[47,47,12],[56,56,14],[66,67,17]
      ],
      0x221A: [  // SQUARE ROOT
        [8,9,3],[9,11,3],[11,13,4],[12,15,5],[15,17,5],[17,21,6],[20,24,7],[24,29,9],
        [29,34,10],[34,40,12],[40,48,14],[48,57,17],[57,67,20],[68,80,24]
      ],
      0x2223: [  // DIVIDES
        [2,6,1],[2,7,1],[2,8,1],[2,9,1],[3,10,1],[3,12,1],[4,14,1],[5,16,1],
        [6,19,1],[7,22,1],[8,26,1],[9,31,1],[11,36,1],[13,43,1]
      ],
      0x2225: [  // PARALLEL TO
        [3,6,1],[4,7,1],[4,8,1],[5,9,1],[6,10,1],[7,12,1],[8,14,1],[10,16,1],
        [12,19,1],[14,22,1],[17,26,1],[20,31,1],[23,36,1],[27,43,1]
      ],
      0x222B: [  // INTEGRAL
        [5,8,2],[5,10,3],[6,11,3],[7,14,4],[9,16,4],[11,19,5],[12,22,6],[15,26,7],
        [17,32,9],[21,38,11],[24,44,12],[29,53,15],[34,62,17],[41,74,21]
      ],
      0x222C: [  // DOUBLE INTEGRAL
        [7,8,2],[8,10,3],[10,11,3],[11,14,4],[14,16,4],[16,19,5],[19,22,6],[23,26,7],
        [27,32,9],[32,38,11],[38,44,12],[45,53,15],[53,62,17],[64,74,21]
      ],
      0x222D: [  // TRIPLE INTEGRAL
        [9,8,2],[11,10,3],[13,11,3],[15,14,4],[19,16,4],[22,19,5],[26,22,6],[31,26,7],
        [37,32,9],[43,38,11],[52,44,12],[61,53,15],[73,62,17],[86,74,21]
      ],
      0x222E: [  // CONTOUR INTEGRAL
        [5,8,2],[5,10,3],[6,11,3],[7,14,4],[9,16,4],[11,19,5],[12,22,6],[15,26,7],
        [17,32,9],[21,38,11],[24,44,12],[29,53,15],[34,62,17],[41,74,21]
      ],
      0x22C0: [  // N-ARY LOGICAL AND
        [6,8,2],[7,10,3],[8,11,3],[10,12,3],[11,15,4],[13,18,5],[16,20,5],[19,24,6],
        [22,28,7],[26,34,9],[31,40,10],[37,47,12],[43,56,14],[52,67,17]
      ],
      0x22C1: [  // N-ARY LOGICAL OR
        [6,8,2],[7,10,3],[8,11,3],[10,13,4],[11,15,4],[13,18,5],[16,21,6],[19,25,7],
        [22,29,8],[26,34,9],[31,41,11],[37,48,13],[43,57,15],[52,68,18]
      ],
      0x22C2: [  // N-ARY INTERSECTION
        [6,7,2],[7,10,3],[8,11,3],[10,12,3],[11,15,4],[13,18,5],[16,20,5],[18,25,7],
        [22,29,8],[26,34,9],[31,40,10],[36,47,12],[43,57,15],[51,67,17]
      ],
      0x22C3: [  // N-ARY UNION
        [6,8,2],[7,10,3],[8,11,3],[10,12,3],[11,15,4],[13,18,5],[16,20,5],[18,24,6],
        [22,28,7],[26,34,9],[31,40,10],[36,47,12],[43,56,14],[51,67,17]
      ],
      0x2308: [  // LEFT CEILING
        [4,9,3],[4,10,3],[5,13,4],[6,15,5],[7,17,5],[8,20,6],[9,24,7],[11,28,8],
        [13,34,10],[15,40,12],[18,48,14],[21,56,16],[25,67,20],[30,79,23]
      ],
      0x2309: [  // RIGHT CEILING
        [2,9,3],[3,10,3],[3,13,4],[3,15,5],[4,17,5],[5,20,6],[6,24,7],[7,28,8],
        [8,34,10],[9,40,12],[11,48,14],[13,56,16],[15,67,20],[18,79,23]
      ],
      0x230A: [  // LEFT FLOOR
        [4,9,3],[4,11,3],[5,13,4],[6,15,4],[7,17,5],[8,21,6],[9,24,7],[11,28,8],
        [13,34,10],[15,41,12],[18,48,14],[21,57,17],[25,68,20],[30,79,23]
      ],
      0x230B: [  // RIGHT FLOOR
        [2,9,3],[3,11,3],[3,13,4],[3,15,4],[4,17,5],[5,21,6],[6,24,7],[7,28,8],
        [8,34,10],[9,41,12],[11,48,14],[13,57,17],[15,68,20],[18,79,23]
      ],
      0x23D0: [  // VERTICAL LINE EXTENSION (used to extend arrows)
        [3,5,0],[3,5,0],[4,6,0],[4,8,0],[5,9,0],[6,10,0],[7,12,0],[9,14,0],
        [10,17,0],[12,20,0],[14,24,0],[17,28,0],[20,34,0],[24,40,0]
      ],
      0x27E8: [  // MATHEMATICAL LEFT ANGLE BRACKET
        [3,9,3],[4,11,3],[4,13,4],[5,15,5],[6,17,5],[7,21,6],[8,24,7],[10,29,9],
        [11,34,10],[13,40,12],[16,48,14],[19,57,17],[22,67,20],[26,80,24]
      ],
      0x27E9: [  // MATHEMATICAL RIGHT ANGLE BRACKET
        [3,9,3],[4,11,3],[4,13,4],[5,15,5],[6,17,5],[7,21,6],[8,24,7],[9,29,9],
        [11,34,10],[13,40,12],[15,48,14],[18,57,17],[21,67,20],[25,80,24]
      ],
      0x2A00: [  // N-ARY CIRCLED DOT OPERATOR
        [8,8,2],[9,9,2],[11,11,3],[13,12,3],[15,15,4],[18,18,5],[21,20,5],[25,24,6],
        [30,28,7],[35,34,9],[42,40,10],[50,47,12],[59,56,14],[70,67,17]
      ],
      0x2A01: [  // N-ARY CIRCLED PLUS OPERATOR
        [8,8,2],[9,8,2],[11,11,3],[13,12,3],[15,15,4],[18,18,5],[21,20,5],[25,24,6],
        [30,28,7],[35,34,9],[42,40,10],[49,47,12],[59,56,14],[70,67,17]
      ],
      0x2A02: [  // N-ARY CIRCLED TIMES OPERATOR
        [8,8,2],[9,9,2],[11,11,3],[13,12,3],[15,15,4],[18,18,5],[21,20,5],[25,24,6],
        [30,28,7],[35,34,9],[42,40,10],[50,47,12],[59,56,14],[70,67,17]
      ],
      0x2A04: [  // N-ARY UNION OPERATOR WITH PLUS
        [6,8,2],[7,10,3],[8,11,3],[10,12,3],[11,15,4],[13,18,5],[16,20,5],[18,24,6],
        [22,28,7],[26,34,9],[31,40,10],[36,47,12],[43,56,14],[51,67,17]
      ],
      0x2A06: [  // N-ARY SQUARE UNION OPERATOR
        [6,8,2],[7,9,2],[8,11,3],[10,12,3],[11,15,4],[13,18,5],[16,20,5],[19,24,6],
        [22,28,7],[26,34,9],[31,40,10],[37,47,12],[43,56,14],[52,67,17]
      ]
    },

    "MathJax_Size2": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x28: [  // LEFT PARENTHESIS
        [4,13,4],[5,15,5],[6,18,6],[7,22,8],[8,25,9],[10,30,11],[11,36,13],[14,42,15],
        [16,50,18],[19,60,21],[22,71,25],[27,84,30],[32,100,36],[37,119,43]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [3,13,4],[4,15,5],[5,18,6],[5,22,8],[6,25,9],[7,30,11],[9,36,13],[10,42,15],
        [12,50,18],[14,60,21],[17,71,25],[20,84,30],[23,100,36],[28,119,43]
      ],
      0x2F: [  // SOLIDUS
        [6,13,4],[7,15,5],[8,18,6],[9,21,8],[11,25,9],[13,30,11],[15,35,13],[18,42,15],
        [21,50,18],[25,59,21],[30,71,25],[36,84,30],[42,100,36],[50,119,43]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [4,13,5],[4,16,6],[5,18,7],[6,22,8],[7,25,9],[8,30,11],[9,35,13],[11,43,16],
        [13,51,19],[15,59,21],[18,70,25],[22,84,30],[26,100,36],[30,119,43]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [6,13,4],[7,15,5],[8,18,6],[9,21,8],[11,25,9],[13,30,11],[15,35,13],[18,42,15],
        [21,50,18],[25,59,21],[30,71,25],[35,84,30],[42,100,36],[50,119,43]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [2,13,5],[3,16,6],[3,18,7],[3,22,8],[4,25,9],[5,30,11],[5,35,13],[6,43,16],
        [7,51,19],[9,59,21],[10,70,25],[12,84,30],[14,100,36],[17,119,43]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [4,13,4],[5,15,5],[6,18,6],[7,22,8],[8,25,9],[10,30,11],[11,36,13],[13,42,15],
        [16,50,18],[18,60,21],[22,71,25],[26,84,30],[31,100,36],[36,119,43]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [4,13,4],[5,15,5],[6,18,6],[7,22,8],[8,25,9],[10,30,11],[11,36,13],[13,42,15],
        [16,50,18],[18,60,21],[22,71,25],[26,84,30],[31,100,36],[36,119,43]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2C6: [  // MODIFIER LETTER CIRCUMFLEX ACCENT
        [8,2,-4],[10,2,-5],[11,3,-6],[13,3,-7],[15,3,-8],[18,4,-9],[21,4,-11],[25,5,-13],
        [29,6,-16],[35,8,-19],[41,9,-22],[48,10,-26],[57,12,-31],[68,14,-37]
      ],
      0x2DC: [  // SMALL TILDE
        [7,2,-4],[9,2,-5],[10,2,-6],[12,2,-7],[14,2,-8],[17,2,-10],[20,4,-11],[24,5,-13],
        [28,4,-17],[33,5,-20],[40,6,-24],[47,7,-28],[56,8,-34],[66,9,-40]
      ],
      0x302: [  // COMBINING CIRCUMFLEX ACCENT
        [8,2,-4],[10,2,-5],[11,3,-6],[13,3,-7],[15,3,-8],[18,4,-9],[21,4,-11],[25,5,-13],
        [29,6,-16],[35,8,-19],[41,9,-22],[48,10,-26],[57,12,-31],[68,14,-37]
      ],
      0x303: [  // COMBINING TILDE
        [7,2,-4],[9,2,-5],[10,2,-6],[12,2,-7],[14,2,-8],[17,2,-10],[20,4,-11],[24,5,-13],
        [28,4,-17],[33,5,-20],[40,6,-24],[47,7,-28],[56,8,-34],[66,9,-40]
      ],
      0x220F: [  // N-ARY PRODUCT
        [9,10,3],[11,12,4],[12,15,5],[15,17,6],[17,19,6],[21,24,8],[24,28,9],[29,34,11],
        [34,40,13],[41,47,15],[48,56,18],[57,66,21],[68,78,25],[81,93,30]
      ],
      0x2210: [  // N-ARY COPRODUCT
        [9,10,3],[11,12,4],[12,15,5],[15,17,6],[17,19,6],[21,24,8],[24,28,9],[29,34,11],
        [34,40,13],[41,47,15],[48,56,18],[57,66,21],[68,78,25],[81,93,30]
      ],
      0x2211: [  // N-ARY SUMMATION
        [10,10,3],[12,12,4],[14,15,5],[17,17,6],[20,20,7],[24,24,8],[28,28,9],[33,34,11],
        [39,40,13],[46,47,15],[55,56,18],[65,66,21],[77,78,25],[92,93,30]
      ],
      0x221A: [  // SQUARE ROOT
        [8,13,5],[9,16,6],[11,19,7],[12,22,8],[15,25,9],[17,31,11],[20,36,13],[24,43,16],
        [29,50,18],[34,60,22],[40,71,26],[48,85,31],[57,100,36],[68,119,43]
      ],
      0x222B: [  // INTEGRAL
        [7,16,6],[8,19,7],[10,23,9],[12,26,10],[14,31,12],[16,38,15],[19,44,17],[22,53,21],
        [27,62,24],[32,74,29],[37,88,34],[44,105,41],[53,124,48],[63,147,57]
      ],
      0x222C: [  // DOUBLE INTEGRAL
        [10,16,6],[13,19,7],[15,23,9],[18,26,10],[21,31,12],[25,38,15],[29,44,17],[35,53,21],
        [41,62,24],[49,74,29],[58,88,34],[69,105,41],[82,124,48],[98,147,57]
      ],
      0x222D: [  // TRIPLE INTEGRAL
        [14,16,6],[17,19,7],[20,23,9],[24,26,10],[28,31,12],[33,38,15],[39,44,17],[47,53,21],
        [56,62,24],[66,74,29],[78,88,34],[93,105,41],[110,124,48],[131,147,57]
      ],
      0x222E: [  // CONTOUR INTEGRAL
        [7,16,6],[8,19,7],[10,23,9],[12,26,10],[14,31,12],[16,38,15],[19,44,17],[22,53,21],
        [27,62,24],[32,74,29],[37,88,34],[44,105,41],[53,124,48],[63,147,57]
      ],
      0x22C0: [  // N-ARY LOGICAL AND
        [8,11,4],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [30,40,13],[35,47,15],[42,56,18],[50,66,21],[59,78,25],[70,93,30]
      ],
      0x22C1: [  // N-ARY LOGICAL OR
        [8,11,4],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [30,40,13],[35,47,15],[42,56,18],[50,66,21],[59,78,25],[70,93,30]
      ],
      0x22C2: [  // N-ARY INTERSECTION
        [8,10,3],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [30,40,13],[35,47,15],[42,56,18],[50,66,21],[59,78,25],[70,93,30]
      ],
      0x22C3: [  // N-ARY UNION
        [8,10,3],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [30,40,13],[35,47,15],[42,56,18],[50,66,21],[59,78,25],[70,93,30]
      ],
      0x2308: [  // LEFT CEILING
        [4,13,5],[5,16,6],[6,19,7],[6,22,8],[8,25,9],[9,30,11],[10,36,13],[12,42,15],
        [15,50,18],[17,60,22],[21,71,26],[24,85,31],[29,100,36],[34,119,43]
      ],
      0x2309: [  // RIGHT CEILING
        [2,13,5],[3,16,6],[3,19,7],[4,22,8],[4,25,9],[5,30,11],[6,36,13],[8,42,15],
        [9,50,18],[10,60,22],[12,71,26],[15,85,31],[17,100,36],[20,119,43]
      ],
      0x230A: [  // LEFT FLOOR
        [4,13,5],[5,16,6],[6,19,7],[6,22,8],[8,25,9],[9,30,11],[10,36,13],[12,43,16],
        [15,50,18],[17,60,22],[21,72,26],[24,85,31],[29,100,36],[34,119,43]
      ],
      0x230B: [  // RIGHT FLOOR
        [2,13,5],[3,16,6],[3,19,7],[4,22,8],[4,25,9],[5,30,11],[6,36,13],[8,43,16],
        [9,50,18],[10,60,22],[12,72,26],[15,85,31],[17,100,36],[20,119,43]
      ],
      0x27E8: [  // MATHEMATICAL LEFT ANGLE BRACKET
        [4,13,5],[5,16,6],[6,19,7],[7,22,8],[8,25,9],[9,31,11],[11,36,13],[13,43,16],
        [15,50,18],[18,60,22],[21,71,26],[25,85,31],[29,100,36],[35,119,43]
      ],
      0x27E9: [  // MATHEMATICAL RIGHT ANGLE BRACKET
        [4,13,5],[4,16,6],[5,19,7],[6,22,8],[7,25,9],[9,31,11],[10,36,13],[12,43,16],
        [14,50,18],[17,60,22],[20,71,26],[24,85,31],[28,100,36],[33,119,43]
      ],
      0x2A00: [  // N-ARY CIRCLED DOT OPERATOR
        [10,10,3],[13,12,4],[15,15,5],[18,18,6],[21,21,7],[25,24,8],[29,28,9],[34,34,11],
        [41,40,13],[48,47,15],[57,56,18],[68,66,21],[81,78,25],[96,93,30]
      ],
      0x2A01: [  // N-ARY CIRCLED PLUS OPERATOR
        [10,10,3],[12,13,4],[15,15,5],[18,17,6],[21,21,7],[25,24,8],[29,28,9],[34,34,11],
        [41,40,13],[48,47,15],[57,56,18],[68,66,21],[81,78,25],[96,93,30]
      ],
      0x2A02: [  // N-ARY CIRCLED TIMES OPERATOR
        [10,10,3],[13,12,4],[15,15,5],[18,18,6],[21,21,7],[25,24,8],[29,28,9],[34,34,11],
        [41,40,13],[48,47,15],[57,56,18],[68,66,21],[81,78,25],[96,93,30]
      ],
      0x2A04: [  // N-ARY UNION OPERATOR WITH PLUS
        [8,10,3],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [30,40,13],[35,47,15],[42,56,18],[50,65,21],[59,78,25],[70,93,30]
      ],
      0x2A06: [  // N-ARY SQUARE UNION OPERATOR
        [7,10,3],[9,12,4],[11,15,5],[13,18,6],[15,21,7],[18,24,8],[21,28,9],[25,34,11],
        [29,40,13],[35,47,15],[42,55,18],[49,66,21],[59,78,25],[70,93,30]
      ]
    },

    "MathJax_Size3": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x28: [  // LEFT PARENTHESIS
        [5,17,7],[6,20,8],[7,24,9],[9,29,11],[10,34,13],[12,40,16],[14,47,18],[17,56,22],
        [20,67,26],[24,79,31],[28,94,37],[33,112,44],[39,133,52],[47,158,62]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [4,17,7],[5,20,8],[6,24,9],[7,29,11],[8,34,13],[9,40,16],[11,47,18],[13,56,22],
        [15,67,26],[18,79,31],[21,94,37],[25,112,44],[30,133,52],[35,158,62]
      ],
      0x2F: [  // SOLIDUS
        [7,17,7],[9,20,8],[10,24,9],[12,28,11],[14,33,13],[17,40,16],[20,47,18],[23,56,22],
        [28,67,26],[33,79,31],[39,94,37],[46,112,44],[55,133,52],[66,158,62]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [4,17,7],[5,20,8],[6,24,10],[7,28,11],[8,33,13],[9,41,17],[11,48,19],[12,57,23],
        [15,66,26],[17,79,31],[21,94,37],[24,111,44],[29,133,52],[34,158,62]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [7,17,7],[9,20,8],[10,24,9],[12,28,11],[14,33,13],[17,40,16],[20,47,18],[23,56,22],
        [28,67,26],[33,79,31],[39,94,37],[46,112,44],[55,133,52],[65,158,62]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [2,17,7],[3,20,8],[3,24,10],[4,28,11],[4,33,13],[5,41,17],[6,48,19],[7,57,23],
        [8,66,26],[10,79,31],[11,94,37],[13,111,44],[16,133,52],[19,158,62]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [5,17,7],[6,20,8],[7,24,9],[8,29,11],[9,34,13],[11,40,16],[13,47,18],[15,56,22],
        [18,67,26],[21,79,31],[25,94,37],[29,112,44],[35,133,52],[41,158,62]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [5,17,7],[6,20,8],[7,24,9],[8,29,11],[9,34,13],[11,40,16],[13,47,18],[15,56,22],
        [18,67,26],[21,79,31],[25,94,37],[29,112,44],[35,133,52],[41,158,62]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2C6: [  // MODIFIER LETTER CIRCUMFLEX ACCENT
        [11,2,-4],[13,2,-5],[16,2,-6],[18,3,-7],[22,3,-8],[26,4,-9],[30,4,-11],[35,5,-13],
        [41,6,-16],[49,7,-19],[58,8,-22],[69,10,-26],[82,12,-31],[97,14,-37]
      ],
      0x2DC: [  // SMALL TILDE
        [10,2,-4],[12,2,-5],[15,2,-6],[17,2,-7],[20,2,-8],[24,2,-10],[29,4,-11],[34,4,-13],
        [40,5,-16],[48,5,-20],[57,6,-24],[67,7,-28],[80,8,-34],[95,9,-40]
      ],
      0x302: [  // COMBINING CIRCUMFLEX ACCENT
        [11,2,-4],[14,2,-5],[16,2,-6],[19,3,-7],[22,3,-8],[26,4,-9],[30,4,-11],[35,5,-13],
        [42,6,-16],[49,7,-19],[58,8,-22],[69,10,-26],[82,12,-31],[97,14,-37]
      ],
      0x303: [  // COMBINING TILDE
        [10,2,-4],[12,2,-5],[15,2,-6],[17,2,-7],[20,2,-8],[24,2,-10],[29,4,-11],[34,4,-13],
        [40,5,-16],[48,5,-20],[57,6,-24],[68,7,-28],[80,8,-34],[95,9,-40]
      ],
      0x221A: [  // SQUARE ROOT
        [8,17,7],[9,21,8],[10,25,10],[12,30,12],[15,35,14],[17,41,16],[20,48,19],[24,57,23],
        [29,68,27],[34,80,32],[40,95,38],[48,113,45],[57,134,53],[67,159,63]
      ],
      0x2308: [  // LEFT CEILING
        [4,17,7],[5,20,8],[6,25,10],[7,29,12],[8,34,14],[10,41,16],[12,48,19],[14,57,23],
        [16,68,27],[19,80,32],[23,94,37],[27,113,45],[32,134,53],[38,159,63]
      ],
      0x2309: [  // RIGHT CEILING
        [3,17,7],[3,20,8],[5,25,10],[4,29,12],[5,34,14],[6,41,16],[7,48,19],[8,57,23],
        [10,68,27],[12,80,32],[14,94,37],[16,113,45],[19,134,53],[23,159,63]
      ],
      0x230A: [  // LEFT FLOOR
        [4,18,7],[5,21,8],[6,25,10],[7,29,11],[8,34,13],[10,40,16],[12,48,19],[14,57,23],
        [16,68,27],[19,80,32],[23,95,38],[27,113,45],[32,134,53],[38,159,63]
      ],
      0x230B: [  // RIGHT FLOOR
        [3,18,7],[3,21,8],[5,25,10],[4,29,11],[5,34,13],[6,40,16],[7,48,19],[8,57,23],
        [10,68,27],[12,80,32],[14,95,38],[16,113,45],[19,134,53],[23,159,63]
      ],
      0x27E8: [  // MATHEMATICAL LEFT ANGLE BRACKET
        [5,18,7],[6,21,8],[7,25,10],[8,30,12],[10,35,14],[11,41,16],[13,48,19],[16,57,23],
        [19,68,27],[22,80,32],[26,95,38],[31,113,45],[37,134,53],[44,159,63]
      ],
      0x27E9: [  // MATHEMATICAL RIGHT ANGLE BRACKET
        [5,17,7],[6,21,8],[7,25,10],[8,30,12],[9,35,14],[11,41,16],[13,48,19],[15,57,23],
        [18,68,27],[21,80,32],[25,95,38],[29,113,45],[35,134,53],[41,159,63]
      ]
    },

    "MathJax_Size4": {
      0x20: [  // SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x28: [  // LEFT PARENTHESIS
        [6,21,9],[7,25,10],[8,30,12],[9,36,15],[11,42,17],[13,50,21],[15,59,24],[18,70,29],
        [21,83,35],[25,99,41],[30,118,49],[36,140,58],[42,166,69],[50,198,82]
      ],
      0x29: [  // RIGHT PARENTHESIS
        [4,22,9],[5,25,10],[6,30,12],[7,36,15],[8,42,17],[10,50,21],[11,59,24],[13,70,29],
        [16,84,35],[19,99,41],[22,118,49],[26,140,58],[31,166,69],[37,198,82]
      ],
      0x2F: [  // SOLIDUS
        [9,21,9],[11,25,10],[12,30,12],[15,35,15],[17,42,17],[21,50,21],[24,59,24],[29,70,29],
        [34,83,35],[41,99,41],[48,118,49],[57,140,58],[68,166,69],[81,198,82]
      ],
      0x5B: [  // LEFT SQUARE BRACKET
        [4,21,9],[5,25,11],[6,30,12],[7,35,15],[8,42,17],[10,51,22],[12,60,25],[14,70,29],
        [16,83,35],[19,99,41],[23,117,49],[27,140,58],[32,166,69],[38,197,82]
      ],
      0x5C: [  // REVERSE SOLIDUS
        [9,21,9],[11,25,10],[12,30,12],[15,35,15],[17,42,17],[21,50,21],[24,59,24],[29,70,29],
        [34,83,35],[41,99,41],[48,118,49],[57,140,58],[68,166,69],[81,198,82]
      ],
      0x5D: [  // RIGHT SQUARE BRACKET
        [3,21,9],[3,25,11],[4,30,12],[4,35,15],[5,42,17],[6,51,22],[7,60,25],[8,70,29],
        [9,83,35],[11,99,41],[13,117,49],[15,140,58],[18,166,69],[21,197,82]
      ],
      0x7B: [  // LEFT CURLY BRACKET
        [5,21,9],[6,25,10],[7,30,12],[8,36,15],[10,42,17],[11,50,21],[13,59,24],[16,70,29],
        [19,83,35],[22,99,41],[26,118,49],[31,140,58],[37,166,69],[44,198,82]
      ],
      0x7D: [  // RIGHT CURLY BRACKET
        [5,21,9],[6,25,10],[7,30,12],[8,36,15],[10,42,17],[11,50,21],[13,59,24],[16,70,29],
        [19,83,35],[22,99,41],[26,118,49],[31,140,58],[37,166,69],[44,198,82]
      ],
      0xA0: [  // NO-BREAK SPACE
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],
        [1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0],[1,1,0]
      ],
      0x2C6: [  // MODIFIER LETTER CIRCUMFLEX ACCENT
        [15,2,-4],[17,3,-5],[20,3,-6],[24,4,-7],[28,4,-8],[33,5,-9],[39,6,-11],[46,7,-13],
        [54,8,-16],[64,10,-18],[76,11,-22],[90,13,-26],[107,16,-31],[127,19,-37]
      ],
      0x2DC: [  // SMALL TILDE
        [14,2,-4],[17,2,-5],[20,3,-5],[24,5,-6],[28,4,-8],[33,4,-10],[38,5,-11],[45,6,-14],
        [54,7,-16],[63,8,-19],[75,10,-23],[89,12,-27],[106,14,-32],[125,16,-38]
      ],
      0x302: [  // COMBINING CIRCUMFLEX ACCENT
        [15,2,-4],[17,3,-5],[20,3,-6],[24,4,-7],[28,4,-8],[33,5,-9],[39,6,-11],[46,7,-13],
        [54,8,-16],[64,10,-18],[76,11,-22],[90,13,-26],[107,16,-31],[127,19,-37]
      ],
      0x303: [  // COMBINING TILDE
        [14,2,-4],[16,2,-5],[19,3,-5],[23,5,-6],[27,4,-8],[32,4,-10],[37,5,-11],[44,6,-14],
        [53,7,-16],[63,8,-19],[74,10,-23],[88,12,-27],[105,14,-32],[125,16,-38]
      ],
      0x221A: [  // SQUARE ROOT
        [8,22,9],[9,26,11],[10,31,13],[12,36,15],[15,43,18],[17,51,21],[20,60,25],[24,71,30],
        [29,84,35],[34,100,42],[40,118,49],[48,141,59],[57,167,70],[67,199,83]
      ],
      0x2308: [  // LEFT CEILING
        [5,21,9],[6,26,11],[7,30,13],[8,36,15],[9,43,18],[11,51,21],[13,60,25],[15,70,29],
        [18,84,35],[21,100,42],[25,118,49],[30,141,59],[36,166,69],[42,199,83]
      ],
      0x2309: [  // RIGHT CEILING
        [3,21,9],[4,26,11],[4,30,13],[6,36,15],[6,43,18],[7,51,21],[8,60,25],[9,70,29],
        [11,84,35],[13,100,42],[15,118,49],[18,141,59],[21,166,69],[25,199,83]
      ],
      0x230A: [  // LEFT FLOOR
        [5,22,9],[6,26,11],[7,31,13],[8,36,15],[9,43,18],[11,50,21],[13,60,25],[15,70,29],
        [18,84,35],[21,100,42],[25,118,49],[30,140,58],[36,167,70],[42,199,83]
      ],
      0x230B: [  // RIGHT FLOOR
        [3,22,9],[4,26,11],[4,31,13],[6,36,15],[6,43,18],[7,50,21],[8,60,25],[9,70,29],
        [11,84,35],[13,100,42],[15,118,49],[18,140,58],[21,167,70],[25,199,83]
      ],
      0x239B: [  // LEFT PARENTHESIS UPPER HOOK
        [6,13,5],[7,16,6],[9,19,7],[10,22,8],[12,26,10],[14,31,11],[17,36,13],[20,43,16],
        [24,51,19],[28,60,22],[33,72,26],[40,85,31],[47,101,37],[56,120,44]
      ],
      0x239C: [  // LEFT PARENTHESIS EXTENSION
        [3,6,1],[4,7,1],[5,7,1],[5,9,1],[6,10,1],[7,12,1],[9,13,1],[10,16,1],
        [12,18,1],[14,22,1],[17,25,1],[20,31,2],[24,36,2],[28,43,2]
      ],
      0x239D: [  // LEFT PARENTHESIS LOWER HOOK
        [6,14,5],[7,16,6],[9,19,7],[10,22,8],[12,26,9],[14,31,11],[17,36,13],[20,43,15],
        [24,51,18],[28,61,22],[33,72,26],[40,85,30],[47,101,36],[56,120,43]
      ],
      0x239E: [  // RIGHT PARENTHESIS UPPER HOOK
        [5,13,5],[5,16,6],[6,19,7],[7,22,8],[9,26,10],[10,31,11],[12,36,13],[14,43,16],
        [17,51,19],[20,60,22],[23,72,26],[28,85,31],[33,101,37],[39,120,44]
      ],
      0x239F: [  // RIGHT PARENTHESIS EXTENSION
        [5,6,1],[5,7,1],[6,7,1],[7,9,1],[9,10,1],[10,12,1],[12,13,1],[14,16,1],
        [17,18,1],[20,22,1],[23,25,1],[28,31,2],[33,36,2],[39,43,2]
      ],
      0x23A0: [  // RIGHT PARENTHESIS LOWER HOOK
        [5,14,5],[5,16,6],[6,19,7],[7,22,8],[9,26,9],[10,31,11],[12,36,13],[14,43,15],
        [17,51,18],[20,61,22],[23,72,26],[28,85,30],[33,101,36],[39,120,43]
      ],
      0x23A1: [  // LEFT SQUARE BRACKET UPPER CORNER
        [5,13,5],[6,16,6],[7,19,7],[8,22,8],[9,25,9],[11,31,11],[14,36,13],[16,42,15],
        [19,50,18],[22,60,22],[27,72,26],[32,84,30],[37,100,36],[44,119,43]
      ],
      0x23A2: [  // LEFT SQUARE BRACKET EXTENSION
        [3,5,0],[4,5,0],[4,6,0],[5,8,0],[6,9,0],[7,10,0],[8,12,0],[10,14,0],
        [12,17,0],[14,20,0],[16,24,0],[19,28,0],[23,34,0],[27,40,0]
      ],
      0x23A3: [  // LEFT SQUARE BRACKET LOWER CORNER
        [5,13,5],[6,16,6],[7,19,7],[8,22,8],[9,25,9],[11,31,11],[14,36,13],[16,42,15],
        [19,50,18],[22,61,22],[27,72,26],[32,84,30],[37,100,36],[44,119,43]
      ],
      0x23A4: [  // RIGHT SQUARE BRACKET UPPER CORNER
        [3,13,5],[3,16,6],[5,19,7],[5,22,8],[5,25,9],[6,31,11],[8,36,13],[9,42,15],
        [11,50,18],[12,60,22],[15,72,26],[18,84,30],[21,100,36],[23,119,43]
      ],
      0x23A5: [  // RIGHT SQUARE BRACKET EXTENSION
        [3,5,0],[3,5,0],[4,6,0],[5,8,0],[5,9,0],[6,10,0],[7,12,0],[9,14,0],
        [10,17,0],[12,20,0],[14,24,0],[17,28,0],[20,34,0],[23,40,0]
      ],
      0x23A6: [  // RIGHT SQUARE BRACKET LOWER CORNER
        [3,13,5],[3,16,6],[5,19,7],[5,22,8],[5,25,9],[6,31,11],[8,36,13],[9,42,15],
        [11,50,18],[12,61,22],[15,72,26],[18,84,30],[21,100,36],[23,119,43]
      ],
      0x23A7: [  // LEFT CURLY BRACKET UPPER HOOK
        [5,8,1],[6,9,1],[8,10,1],[9,12,1],[10,14,1],[12,16,1],[14,19,1],[17,22,1],
        [20,26,1],[24,31,1],[29,37,1],[34,44,2],[40,52,2],[48,62,2]
      ],
      0x23A8: [  // LEFT CURLY BRACKET MIDDLE PIECE
        [4,14,5],[5,16,6],[5,19,7],[6,23,9],[7,27,10],[9,32,12],[10,37,14],[12,44,16],
        [15,52,19],[17,62,23],[20,73,27],[24,87,32],[28,103,38],[34,123,45]
      ],
      0x23A9: [  // LEFT CURLY BRACKET LOWER HOOK
        [6,8,7],[6,9,8],[8,10,9],[9,12,11],[10,14,13],[12,16,15],[14,19,18],[17,22,21],
        [20,26,25],[24,31,30],[29,37,36],[34,43,42],[40,51,50],[48,61,60]
      ],
      0x23AA: [  // CURLY BRACKET EXTENSION
        [4,4,1],[5,4,1],[5,5,1],[6,5,1],[7,6,1],[9,7,1],[10,8,1],[12,9,1],
        [14,10,1],[17,12,1],[20,14,1],[24,17,2],[28,19,1],[34,23,2]
      ],
      0x23AB: [  // RIGHT CURLY BRACKET UPPER HOOK
        [4,8,1],[5,9,1],[5,10,1],[6,12,1],[7,14,1],[9,16,1],[10,19,1],[12,22,1],
        [14,26,1],[17,31,1],[20,37,1],[24,43,1],[28,52,2],[34,62,2]
      ],
      0x23AC: [  // RIGHT CURLY BRACKET MIDDLE PIECE
        [6,14,5],[6,16,6],[8,19,7],[9,23,9],[10,27,10],[13,32,12],[14,37,14],[17,44,16],
        [20,52,19],[24,62,23],[29,73,27],[34,87,32],[40,103,38],[48,123,45]
      ],
      0x23AD: [  // RIGHT CURLY BRACKET LOWER HOOK
        [4,8,7],[5,9,8],[5,10,9],[6,12,11],[7,14,13],[9,16,15],[10,19,18],[12,22,21],
        [14,26,25],[17,31,30],[20,37,36],[24,44,42],[28,52,50],[34,62,60]
      ],
      0x23B7: [  // RADICAL SYMBOL BOTTOM
        [5,14,7],[6,16,8],[8,19,9],[9,22,11],[11,26,13],[13,31,15],[15,37,18],[18,43,21],
        [21,51,25],[25,61,30],[30,72,35],[35,86,42],[42,101,49],[49,121,59]
      ],
      0x27E8: [  // MATHEMATICAL LEFT ANGLE BRACKET
        [5,22,9],[6,26,11],[7,31,13],[9,36,15],[10,43,18],[12,51,21],[14,60,25],[17,70,29],
        [20,84,35],[24,100,42],[28,118,49],[33,140,58],[39,166,69],[47,199,83]
      ],
      0x27E9: [  // MATHEMATICAL RIGHT ANGLE BRACKET
        [5,22,9],[6,26,11],[7,31,13],[8,36,15],[10,43,18],[11,51,21],[13,60,25],[16,70,29],
        [19,84,35],[22,100,42],[26,118,49],[31,140,58],[37,167,70],[44,199,83]
      ],
      0xE000: [  // MJ-TeX: radical symbol vertical extender
        [5,6,1],[6,7,1],[8,8,1],[9,9,1],[11,10,1],[13,12,1],[15,14,1],[18,16,1],
        [21,19,1],[25,22,1],[29,26,1],[35,30,1],[41,36,1],[49,43,1]
      ],
      0xE001: [  // MJ-TeX: radical symbol top corner piece
        [8,5,0],[9,6,1],[11,7,1],[13,8,1],[15,9,0],[18,11,1],[22,13,1],[25,15,1],
        [30,18,1],[36,21,1],[42,25,1],[50,30,1],[60,35,1],[71,41,1]
      ],
      0xE150: [  // MJ-TeX: horizontal brace, down left piece
        [5,3,2],[5,3,2],[6,5,3],[7,5,3],[8,5,3],[9,6,4],[10,8,5],[12,8,5],
        [14,10,6],[17,12,8],[19,14,9],[24,16,10],[28,19,12],[33,23,15]
      ],
      0xE151: [  // MJ-TeX: horizontal brace, down right piece
        [5,3,2],[5,4,2],[6,5,3],[7,5,3],[8,5,3],[9,7,4],[11,8,5],[12,8,5],
        [15,10,6],[17,12,7],[20,14,9],[23,16,10],[28,19,12],[33,23,14]
      ],
      0xE152: [  // MJ-TeX: horizontal brace, upper left piece
        [5,3,0],[5,3,0],[6,4,0],[7,4,0],[8,5,0],[9,6,0],[10,7,0],[12,8,0],
        [14,10,0],[17,11,0],[19,13,0],[24,16,0],[28,19,0],[33,22,0]
      ],
      0xE153: [  // MJ-TeX: horizontal brace, upper right piece
        [5,3,0],[5,3,0],[6,4,0],[7,4,0],[8,5,0],[9,6,0],[11,7,0],[12,8,0],
        [15,10,0],[17,12,0],[20,14,0],[24,16,0],[28,19,0],[33,23,0]
      ],
      0xE154: [  // MJ-TeX: horizontal brace, extender
        [4,1,0],[5,1,0],[6,2,0],[6,2,0],[7,2,0],[8,2,0],[9,3,0],[11,3,0],
        [13,4,0],[15,4,0],[18,5,0],[21,6,0],[24,7,0],[28,8,0]
      ]
    }

  });

  AJAX.loadComplete(HTMLCSS.imgDir+HTMLCSS.imgPacked+"/imagedata.js");

})(MathJax.OutputJax["HTML-CSS"],MathJax.Ajax);
