//=====-- AMDILSubtarget.h - Define Subtarget for the AMDIL ----*- C++ -*-====//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//==-----------------------------------------------------------------------===//
//
// This file declares the AMDIL specific subclass of TargetSubtarget.
//
//===----------------------------------------------------------------------===//

#ifndef _AMDILSUBTARGET_H_
#define _AMDILSUBTARGET_H_

#include "AMDILDevice.h"
#include "llvm/ADT/BitVector.h"
#include "llvm/Target/TargetSubtargetInfo.h"

#include <cstdlib>
#include <string>

#define GET_SUBTARGETINFO_HEADER
#include "AMDGPUGenSubtargetInfo.inc"

#define MAX_CB_SIZE (1 << 16)
namespace llvm {
  class Module;
  class AMDILKernelManager;
  class AMDILGlobalManager;
  class AMDILDevice;
  class AMDILSubtarget : public AMDILGenSubtargetInfo {
    private:
      bool CapsOverride[AMDILDeviceInfo::MaxNumberCapabilities];
      mutable AMDILGlobalManager *mGM;
      mutable AMDILKernelManager *mKM;
      const AMDILDevice *mDevice;
      size_t mDefaultSize[3];
      size_t mMinimumSize[3];
      std::string mDevName;
      uint32_t mVersion;
      bool mIs64bit;
      bool mIs32on64bit;
      bool mDumpCode;
    public:
      AMDILSubtarget(llvm::StringRef TT, llvm::StringRef CPU, llvm::StringRef FS);
      virtual ~AMDILSubtarget();
      bool isOverride(AMDILDeviceInfo::Caps) const;
      bool is64bit() const;

      // Helper functions to simplify if statements
      bool isTargetELF() const;
      AMDILGlobalManager* getGlobalManager() const;
      void setGlobalManager(AMDILGlobalManager *gm) const;
      AMDILKernelManager* getKernelManager() const;
      void setKernelManager(AMDILKernelManager *gm) const;
      const AMDILDevice* device() const;
      std::string getDataLayout() const;
      std::string getDeviceName() const;
      virtual size_t getDefaultSize(uint32_t dim) const;
      // Return the version of CAL that the backend should target.
      uint32_t calVersion() const;
      // ParseSubtargetFeatures - Parses features string setting specified
      // subtarget options.  Definition of function is
      //auto generated by tblgen.
      void
        ParseSubtargetFeatures(
            llvm::StringRef CPU,
            llvm::StringRef FS);
      bool dumpCode() const { return mDumpCode; }

  };

} // end namespace llvm

#endif // AMDILSUBTARGET_H_
