#!/usr/bin/env python

# Mesa 3-D graphics library
# Version:  7.12
#
# Copyright (C) 2011 LunarG Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#
# Authors:
#    Chia-I Wu <olv@lunarg.com>

# These info should be part of GLAPI XML.  Until that is possible, scripts have
# to use tables here to filter gl_api.

es1_core = (
        # OpenGL ES 1.1
        'ActiveTexture',
        'AlphaFunc',
        'AlphaFuncx',
        'BindBuffer',
        'BindTexture',
        'BlendFunc',
        'BufferData',
        'BufferSubData',
        'Clear',
        'ClearColor',
        'ClearColorx',
        'ClearDepthf',
        'ClearDepthx',
        'ClearStencil',
        'ClientActiveTexture',
        'ClipPlanef',
        'ClipPlanex',
        'Color4f',
        'Color4ub',
        'Color4x',
        'ColorMask',
        'ColorPointer',
        'CompressedTexImage2D',
        'CompressedTexSubImage2D',
        'CopyTexImage2D',
        'CopyTexSubImage2D',
        'CullFace',
        'DeleteBuffers',
        'DeleteTextures',
        'DepthFunc',
        'DepthMask',
        'DepthRangef',
        'DepthRangex',
        'Disable',
        'DisableClientState',
        'DrawArrays',
        'DrawElements',
        'Enable',
        'EnableClientState',
        'Finish',
        'Flush',
        'Fogf',
        'Fogfv',
        'Fogx',
        'Fogxv',
        'FrontFace',
        'Frustumf',
        'Frustumx',
        'GenBuffers',
        'GenTextures',
        'GetBooleanv',
        'GetBufferParameteriv',
        'GetClipPlanef',
        'GetClipPlanex',
        'GetError',
        'GetFixedv',
        'GetFloatv',
        'GetIntegerv',
        'GetLightfv',
        'GetLightxv',
        'GetMaterialfv',
        'GetMaterialxv',
        'GetPointerv',
        'GetString',
        'GetTexEnvfv',
        'GetTexEnviv',
        'GetTexEnvxv',
        'GetTexParameterfv',
        'GetTexParameteriv',
        'GetTexParameterxv',
        'Hint',
        'IsBuffer',
        'IsEnabled',
        'IsTexture',
        'Lightf',
        'Lightfv',
        'LightModelf',
        'LightModelfv',
        'LightModelx',
        'LightModelxv',
        'Lightx',
        'Lightxv',
        'LineWidth',
        'LineWidthx',
        'LoadIdentity',
        'LoadMatrixf',
        'LoadMatrixx',
        'LogicOp',
        'Materialf',
        'Materialfv',
        'Materialx',
        'Materialxv',
        'MatrixMode',
        'MultiTexCoord4f',
        'MultiTexCoord4x',
        'MultMatrixf',
        'MultMatrixx',
        'Normal3f',
        'Normal3x',
        'NormalPointer',
        'Orthof',
        'Orthox',
        'PixelStorei',
        'PointParameterf',
        'PointParameterfv',
        'PointParameterx',
        'PointParameterxv',
        'PointSize',
        'PointSizex',
        'PolygonOffset',
        'PolygonOffsetx',
        'PopMatrix',
        'PushMatrix',
        'ReadPixels',
        'Rotatef',
        'Rotatex',
        'SampleCoverage',
        'SampleCoveragex',
        'Scalef',
        'Scalex',
        'Scissor',
        'ShadeModel',
        'StencilFunc',
        'StencilMask',
        'StencilOp',
        'TexCoordPointer',
        'TexEnvf',
        'TexEnvfv',
        'TexEnvi',
        'TexEnviv',
        'TexEnvx',
        'TexEnvxv',
        'TexImage2D',
        'TexParameterf',
        'TexParameterfv',
        'TexParameteri',
        'TexParameteriv',
        'TexParameterx',
        'TexParameterxv',
        'TexSubImage2D',
        'Translatef',
        'Translatex',
        'VertexPointer',
        'Viewport',
)

es1_api = es1_core + (
        # GL_OES_EGL_image
        'EGLImageTargetTexture2DOES',
        'EGLImageTargetRenderbufferStorageOES',
        # GL_OES_mapbuffer
        'GetBufferPointervOES',
        'MapBufferOES',
        'UnmapBufferOES',
        # GL_EXT_multi_draw_arrays
        'MultiDrawArraysEXT',
        'MultiDrawElementsEXT',
        # GL_OES_blend_equation_separate
        'BlendEquationSeparateOES',
        # GL_OES_blend_func_separate
        'BlendFuncSeparateOES',
        # GL_OES_blend_subtract
        'BlendEquationOES',
        # GL_OES_draw_texture
        'DrawTexiOES',
        'DrawTexivOES',
        'DrawTexfOES',
        'DrawTexfvOES',
        'DrawTexsOES',
        'DrawTexsvOES',
        'DrawTexxOES',
        'DrawTexxvOES',
        # GL_OES_fixed_point
        'AlphaFuncxOES',
        'ClearColorxOES',
        'ClearDepthxOES',
        'Color4xOES',
        'DepthRangexOES',
        'FogxOES',
        'FogxvOES',
        'FrustumxOES',
        'LightModelxOES',
        'LightModelxvOES',
        'LightxOES',
        'LightxvOES',
        'LineWidthxOES',
        'LoadMatrixxOES',
        'MaterialxOES',
        'MaterialxvOES',
        'MultiTexCoord4xOES',
        'MultMatrixxOES',
        'Normal3xOES',
        'OrthoxOES',
        'PointSizexOES',
        'PolygonOffsetxOES',
        'RotatexOES',
        'SampleCoveragexOES',
        'ScalexOES',
        'TexEnvxOES',
        'TexEnvxvOES',
        'TexParameterxOES',
        'TranslatexOES',
        'ClipPlanexOES',
        'GetClipPlanexOES',
        'GetFixedvOES',
        'GetLightxvOES',
        'GetMaterialxvOES',
        'GetTexEnvxvOES',
        'GetTexParameterxvOES',
        'PointParameterxOES',
        'PointParameterxvOES',
        'TexParameterxvOES',
        # GL_OES_framebuffer_object
        'BindFramebufferOES',
        'BindRenderbufferOES',
        'CheckFramebufferStatusOES',
        'DeleteFramebuffersOES',
        'DeleteRenderbuffersOES',
        'FramebufferRenderbufferOES',
        'FramebufferTexture2DOES',
        'GenerateMipmapOES',
        'GenFramebuffersOES',
        'GenRenderbuffersOES',
        'GetFramebufferAttachmentParameterivOES',
        'GetRenderbufferParameterivOES',
        'IsFramebufferOES',
        'IsRenderbufferOES',
        'RenderbufferStorageOES',
        # GL_OES_point_size_array
        'PointSizePointerOES',
        # GL_OES_query_matrix
        'QueryMatrixxOES',
        # GL_OES_single_precision
        'ClearDepthfOES',
        'DepthRangefOES',
        'FrustumfOES',
        'OrthofOES',
        'ClipPlanefOES',
        'GetClipPlanefOES',
        # GL_OES_texture_cube_map
        'GetTexGenfvOES',
        'GetTexGenivOES',
        'GetTexGenxvOES',
        'TexGenfOES',
        'TexGenfvOES',
        'TexGeniOES',
        'TexGenivOES',
        'TexGenxOES',
        'TexGenxvOES',
)

es2_core = (
        # OpenGL ES 2.0
        "ActiveTexture",
        "AttachShader",
        "BindAttribLocation",
        "BindBuffer",
        "BindFramebuffer",
        "BindRenderbuffer",
        "BindTexture",
        "BlendColor",
        "BlendEquation",
        "BlendEquationSeparate",
        "BlendFunc",
        "BlendFuncSeparate",
        "BufferData",
        "BufferSubData",
        "CheckFramebufferStatus",
        "Clear",
        "ClearColor",
        "ClearDepthf",
        "ClearStencil",
        "ColorMask",
        "CompileShader",
        "CompressedTexImage2D",
        "CompressedTexSubImage2D",
        "CopyTexImage2D",
        "CopyTexSubImage2D",
        "CreateProgram",
        "CreateShader",
        "CullFace",
        "DeleteBuffers",
        "DeleteFramebuffers",
        "DeleteProgram",
        "DeleteRenderbuffers",
        "DeleteShader",
        "DeleteTextures",
        "DepthFunc",
        "DepthMask",
        "DepthRangef",
        "DetachShader",
        "Disable",
        "DisableVertexAttribArray",
        "DrawArrays",
        "DrawElements",
        "Enable",
        "EnableVertexAttribArray",
        "Finish",
        "Flush",
        "FramebufferRenderbuffer",
        "FramebufferTexture2D",
        "FrontFace",
        "GenBuffers",
        "GenerateMipmap",
        "GenFramebuffers",
        "GenRenderbuffers",
        "GenTextures",
        "GetActiveAttrib",
        "GetActiveUniform",
        "GetAttachedShaders",
        "GetAttribLocation",
        "GetBooleanv",
        "GetBufferParameteriv",
        "GetError",
        "GetFloatv",
        "GetFramebufferAttachmentParameteriv",
        "GetIntegerv",
        "GetProgramInfoLog",
        "GetProgramiv",
        "GetRenderbufferParameteriv",
        "GetShaderInfoLog",
        "GetShaderiv",
        "GetShaderPrecisionFormat",
        "GetShaderSource",
        "GetString",
        "GetTexParameterfv",
        "GetTexParameteriv",
        "GetUniformfv",
        "GetUniformiv",
        "GetUniformLocation",
        "GetVertexAttribfv",
        "GetVertexAttribiv",
        "GetVertexAttribPointerv",
        "Hint",
        "IsBuffer",
        "IsEnabled",
        "IsFramebuffer",
        "IsProgram",
        "IsRenderbuffer",
        "IsShader",
        "IsTexture",
        "LineWidth",
        "LinkProgram",
        "PixelStorei",
        "PolygonOffset",
        "ReadPixels",
        "ReleaseShaderCompiler",
        "RenderbufferStorage",
        "SampleCoverage",
        "Scissor",
        "ShaderBinary",
        "ShaderSource",
        "StencilFunc",
        "StencilFuncSeparate",
        "StencilMask",
        "StencilMaskSeparate",
        "StencilOp",
        "StencilOpSeparate",
        "TexImage2D",
        "TexParameterf",
        "TexParameterfv",
        "TexParameteri",
        "TexParameteriv",
        "TexSubImage2D",
        "Uniform1f",
        "Uniform1fv",
        "Uniform1i",
        "Uniform1iv",
        "Uniform2f",
        "Uniform2fv",
        "Uniform2i",
        "Uniform2iv",
        "Uniform3f",
        "Uniform3fv",
        "Uniform3i",
        "Uniform3iv",
        "Uniform4f",
        "Uniform4fv",
        "Uniform4i",
        "Uniform4iv",
        "UniformMatrix2fv",
        "UniformMatrix3fv",
        "UniformMatrix4fv",
        "UseProgram",
        "ValidateProgram",
        "VertexAttrib1f",
        "VertexAttrib1fv",
        "VertexAttrib2f",
        "VertexAttrib2fv",
        "VertexAttrib3f",
        "VertexAttrib3fv",
        "VertexAttrib4f",
        "VertexAttrib4fv",
        "VertexAttribPointer",
        "Viewport",
)

es2_api = es2_core + (
        # GL_OES_EGL_image
        'EGLImageTargetTexture2DOES',
        'EGLImageTargetRenderbufferStorageOES',
        # GL_OES_mapbuffer
        'GetBufferPointervOES',
        'MapBufferOES',
        'UnmapBufferOES',
        # GL_EXT_multi_draw_arrays
        'MultiDrawArraysEXT',
        'MultiDrawElementsEXT',
        # GL_OES_texture_3D
        'CompressedTexImage3DOES',
        'CompressedTexSubImage3DOES',
        'CopyTexSubImage3DOES',
        'FramebufferTexture3DOES',
        'TexImage3DOES',
        'TexSubImage3DOES',
        # GL_OES_get_program_binary
        'GetProgramBinaryOES',
        'ProgramBinaryOES',
        # GL_NV_draw_buffers
        'DrawBuffersNV',
        # GL_NV_read_buffer
        'ReadBufferNV',
)
