; =================================================================
; MikeOS -- The Mike Operating System kernel
; Copyright (C) 2006, 2007 MikeOS Developers -- see LICENSE.TXT
;
; This is loaded from floppy, by BOOTLOAD.BIN, as MIKEKERN.BIN.
; First section is 32K of empty space for program data (which we
; can load from disk and execute). Then we have the system call
; vectors, which start at a static point for programs to jump to.
; Following that is the main kernel code and system calls.
; =================================================================


	BITS 16

	%DEFINE MIKEOS_VER '1.0.0'
	%DEFINE MIKEOS_API_VER 1


; -----------------------------------------------------------------
; Program data section -- Pad out for app space (DO NOT CHANGE)

os_app_data:
	; This is a temporary fix for DOS programs
	db 0xCD, 0x20   ; PSP: CD 20 = 'int 20h', return to DOS
	db 0xA0, 0x00	; PSP: Always A000h for COM executables

	times 32768-($-$$)	db 0		; 32K of program space


; -----------------------------------------------------------------
; OS call vectors -- Static locations for system calls
; NOTE: THESE CANNOT BE MOVED -- it'll break the calls!
; Comments show exact locations of instructions in this section.

os_call_vectors:
	jmp os_main			; 0x8000 -- Called from bootloader

	call os_print_string		; 0x8003
	ret

	call os_move_cursor		; 0x8007
	ret

	call os_clear_screen		; 0x800B
	ret

	call os_print_horiz_line	; 0x800F
	ret

	call os_print_newline		; 0x8013
	ret

	call os_wait_for_key		; 0x8017
	ret

	call os_check_for_key		; 0x801B
	ret

	call os_int_to_string		; 0x801F
	ret

	call os_speaker_tone		; 0x8023
	ret

	call os_speaker_off		; 0x8027
	ret

	call os_program_load		; 0x802B
	ret

	call os_pause			; 0x802F
	ret

	call os_fatal_error		; 0x8033
	ret

	call os_draw_background		; 0x8037
	ret

	call os_string_length		; 0x803B
	ret

	call os_string_uppercase	; 0x803F
	ret

	call os_string_lowercase	; 0x8043
	ret

	call os_input_string		; 0x8047
	ret

	call os_string_copy		; 0x804B
	ret

	call os_dialog_box		; 0x804F
	ret

	call os_string_join		; 0x8053
	ret

	call os_modify_int_handler	; 0x8057
	ret

	call os_get_file_list		; 0x805B
	ret

	call os_string_compare		; 0x805F
	ret

	call os_string_chomp		; 0x8063
	ret

	call os_string_strip		; 0x8067
	ret

	call os_string_truncate		; 0x806B
	ret

	call os_bcd_to_int		; 0x806F
	ret

	call os_get_time_string		; 0x8073
	ret

	call os_get_api_version		; 0x8077
	ret

	call os_file_selector		; 0x807B
	ret


; =================================================================
; START OF KERNEL CODE

os_main:
	cli
	mov ax, 0
	mov ss, ax			; Set stack segment and pointer
	mov sp, 0xF000
	sti

	mov ax, 0x2000
	mov ds, ax			; Set data segment to where we loaded

	mov cx, 00h                     ; Divide by 0 error handler
	mov si, os_compat_int00
	call os_modify_int_handler

	mov cx, 20h			; Set up DOS compatibility...
	mov si, os_compat_int20		; ...for interrupts 20h and 21h
	call os_modify_int_handler

	mov cx, 21h
	mov si, os_compat_int21
	call os_modify_int_handler

	mov ax, 3			; Set to normal (80x25 text) video mode
	int 10h

	mov ch, 0			; Set cursor to solid block
	mov cl, 7
	mov ah, 1
	mov al, 3			; Must be video mode for buggy BIOSes!
	int 10h

	mov ax, os_init_msg		; Set up screen
	mov bx, os_version_msg
	mov cx, 10011111b		; White text on light blue
	call os_draw_background

	mov ax, dialog_string_1		; Ask if user wants app selector or CLI
	mov bx, dialog_string_2
	mov cx, dialog_string_3
	mov dx, 1
	call os_dialog_box

	cmp ax, 0			; If OK selected, start app selector
	je near app_selector

	call os_command_line		; Otherwise start CLI

	jmp os_int_reboot		; When user exits from CLI, reboot


	os_init_msg		db 'Welcome to MikeOS', 0
	os_version_msg		db 'Version ', MIKEOS_VER, 0

	dialog_string_1		db 'Thanks for trying out MikeOS!', 0
	dialog_string_2		db 'Contact okachi@gmail.com for more info.', 0
	dialog_string_3		db 'OK for app selector, Cancel for CLI.', 0


app_selector:
	mov ax, os_init_msg		; Redraw screen to remove dialog box
	mov bx, os_version_msg
	mov cx, 10011111b
	call os_draw_background

	call os_file_selector		; Get user to select a file, and store
					; the resulting string in AX

	mov bx, 1			; Clear screen before running!

	call os_program_load		; Run our program in AX

	mov si, prog_finished_string	; When finished, print a message
	call os_print_string
	call os_wait_for_key

	jmp app_selector		; And go back to the prog list


	prog_finished_string	db 10, 13, '>>> Program has terminated - press a key', 10, 13, 0


; =================================================================
; SYSTEM CALL SECTION -- Accessible to user programs


        %INCLUDE "syscalls.asm"


; =================================================================
; COMMAND LINE INTERFACE


	%INCLUDE "os_cli.asm"


; =================================================================
; DOS COMPATIBILITY INTERRUPT HANDLERS


	%INCLUDE "os_dos.asm"


; =================================================================
; END OF KERNEL

	times 57344-($-$$)	db 0		; Pad up to 56K

os_buffer:
	times 8192		db 0		; Last 8K is generic buffer


; =================================================================

