// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

[assembly:System.Runtime.CompilerServices.ReferenceAssemblyAttribute]
[assembly:System.Reflection.AssemblyVersionAttribute("0.0.0.0")]
[assembly:System.CLSCompliantAttribute(false)]

namespace System
{
    public struct nfloat
    {
        public static readonly System.nfloat MaxValue;
        public nfloat(double v) { throw null; }
        public nfloat(float v) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static System.nfloat operator +(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator --(System.nfloat v) { throw null; }
        public static System.nfloat operator /(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator ==(System.nfloat l, System.nfloat r) { throw null; }
        public static explicit operator System.nfloat (decimal v) { throw null; }
        public static explicit operator System.nfloat (double v) { throw null; }
        public static explicit operator System.nfloat (System.IntPtr v) { throw null; }
        public static explicit operator byte (System.nfloat v) { throw null; }
        public static explicit operator char (System.nfloat v) { throw null; }
        public static explicit operator decimal (System.nfloat v) { throw null; }
        public static explicit operator short (System.nfloat v) { throw null; }
        public static explicit operator int (System.nfloat v) { throw null; }
        public static explicit operator long (System.nfloat v) { throw null; }
        public static explicit operator System.IntPtr (System.nfloat v) { throw null; }
        public static explicit operator sbyte (System.nfloat v) { throw null; }
        public static explicit operator float (System.nfloat v) { throw null; }
        public static explicit operator ushort (System.nfloat v) { throw null; }
        public static explicit operator uint (System.nfloat v) { throw null; }
        public static explicit operator ulong (System.nfloat v) { throw null; }
        public static bool operator >(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator >=(System.nfloat l, System.nfloat r) { throw null; }
        public static implicit operator System.nfloat (byte v) { throw null; }
        public static implicit operator System.nfloat (char v) { throw null; }
        public static implicit operator System.nfloat (short v) { throw null; }
        public static implicit operator System.nfloat (int v) { throw null; }
        public static implicit operator System.nfloat (long v) { throw null; }
        public static implicit operator double (System.nfloat v) { throw null; }
        public static implicit operator System.nfloat (sbyte v) { throw null; }
        public static implicit operator System.nfloat (float v) { throw null; }
        public static implicit operator System.nfloat (ushort v) { throw null; }
        public static implicit operator System.nfloat (uint v) { throw null; }
        public static implicit operator System.nfloat (ulong v) { throw null; }
        public static System.nfloat operator ++(System.nfloat v) { throw null; }
        public static bool operator !=(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator <(System.nfloat l, System.nfloat r) { throw null; }
        public static bool operator <=(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator %(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator *(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator -(System.nfloat l, System.nfloat r) { throw null; }
        public static System.nfloat operator -(System.nfloat v) { throw null; }
        public static System.nfloat operator +(System.nfloat v) { throw null; }
    }
    public partial struct nint
    {
        public nint(int v) { throw null; }
        public nint(long v) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static System.nint operator +(System.nint l, System.nint r) { throw null; }
        public static System.nint operator &(System.nint l, System.nint r) { throw null; }
        public static System.nint operator |(System.nint l, System.nint r) { throw null; }
        public static System.nint operator --(System.nint v) { throw null; }
        public static System.nint operator /(System.nint l, System.nint r) { throw null; }
        public static bool operator ==(System.nint l, System.nint r) { throw null; }
        public static System.nint operator ^(System.nint l, System.nint r) { throw null; }
        public static explicit operator System.nint (decimal v) { throw null; }
        public static explicit operator System.nint (double v) { throw null; }
        public static explicit operator System.nint (long v) { throw null; }
        public static explicit operator System.nint (System.IntPtr v) { throw null; }
        public static explicit operator System.nint (System.nfloat v) { throw null; }
        public static explicit operator byte (System.nint v) { throw null; }
        public static explicit operator char (System.nint v) { throw null; }
        public static explicit operator short (System.nint v) { throw null; }
        public static explicit operator int (System.nint v) { throw null; }
        public static explicit operator System.IntPtr (System.nint v) { throw null; }
        public static explicit operator sbyte (System.nint v) { throw null; }
        public static explicit operator ushort (System.nint v) { throw null; }
        public static explicit operator uint (System.nint v) { throw null; }
        public static explicit operator ulong (System.nint v) { throw null; }
        public static explicit operator System.nint (float v) { throw null; }
        public static explicit operator System.nint (ushort v) { throw null; }
        public static explicit operator System.nint (uint v) { throw null; }
        public static explicit operator System.nint (ulong v) { throw null; }
        public static bool operator >(System.nint l, System.nint r) { throw null; }
        public static bool operator >=(System.nint l, System.nint r) { throw null; }
        public static implicit operator System.nint (byte v) { throw null; }
        public static implicit operator System.nint (char v) { throw null; }
        public static implicit operator System.nint (short v) { throw null; }
        public static implicit operator System.nint (int v) { throw null; }
        public static implicit operator decimal (System.nint v) { throw null; }
        public static implicit operator double (System.nint v) { throw null; }
        public static implicit operator long (System.nint v) { throw null; }
        public static implicit operator System.nfloat (System.nint v) { throw null; }
        public static implicit operator float (System.nint v) { throw null; }
        public static implicit operator System.nint (sbyte v) { throw null; }
        public static System.nint operator ++(System.nint v) { throw null; }
        public static bool operator !=(System.nint l, System.nint r) { throw null; }
        public static System.nint operator <<(System.nint l, int r) { throw null; }
        public static bool operator <(System.nint l, System.nint r) { throw null; }
        public static bool operator <=(System.nint l, System.nint r) { throw null; }
        public static System.nint operator %(System.nint l, System.nint r) { throw null; }
        public static System.nint operator *(System.nint l, System.nint r) { throw null; }
        public static System.nint operator ~(System.nint v) { throw null; }
        public static System.nint operator >>(System.nint l, int r) { throw null; }
        public static System.nint operator -(System.nint l, System.nint r) { throw null; }
        public static System.nint operator -(System.nint v) { throw null; }
        public static System.nint operator +(System.nint v) { throw null; }
    }
    public class NMath
    {
        public static readonly System.nfloat PI;
        public static System.nfloat Ceiling(System.nfloat value) { throw null; }
    }
}

namespace System.Drawing
{
    public struct Point
    {
        public static readonly System.Drawing.Point Empty;
        public Point(int x, int y) { throw null; }
        public int X { get { throw null; } set { } }
        public int Y { get { throw null; } set { } }
        public static implicit operator System.Drawing.PointF (System.Drawing.Point p) { throw null; }        
    }
    public struct PointF
    {
        public static readonly System.Drawing.PointF Empty;
        public PointF(float x, float y) { throw null; }
        public float X { get { throw null; } set { } }
        public float Y { get { throw null; } set { } }        
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(System.Drawing.PointF left, System.Drawing.PointF right) { throw null; }
        public static bool operator !=(System.Drawing.PointF left, System.Drawing.PointF right) { throw null; }
    }
    public struct Rectangle
    {
        public static readonly System.Drawing.Rectangle Empty;
        public Rectangle(int x, int y, int width, int height) { throw null; }
        public int X { get { throw null; } set { } }
        public int Y { get { throw null; } set { } }        
        public int Bottom { get { throw null; } }
        public int Right { get { throw null; } }        
        public int Width { get { throw null; } set { } }        
        public int Height { get { throw null; } set { } }
    }
    public struct RectangleF
    {
        public static readonly System.Drawing.RectangleF Empty;
        public RectangleF(System.Drawing.PointF location, System.Drawing.SizeF size) { throw null; }
        public RectangleF(float x, float y, float width, float height) { throw null; }
        public float Bottom { get { throw null; } }
        public float Height { get { throw null; } set { } }
        public float Left { get { throw null; } }
        public System.Drawing.PointF Location { get { throw null; } set { } }
        public float Right { get { throw null; } }
        public System.Drawing.SizeF Size { get { throw null; } set { } }
        public float Top { get { throw null; } }
        public float Width { get { throw null; } set { } }
        public float X { get { throw null; } set { } }
        public float Y { get { throw null; } set { } }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(System.Drawing.RectangleF left, System.Drawing.RectangleF right) { throw null; }
        public static implicit operator System.Drawing.RectangleF (System.Drawing.Rectangle r) { throw null; }
        public static bool operator !=(System.Drawing.RectangleF left, System.Drawing.RectangleF right) { throw null; }
    }
    public struct Size
    {
        public static readonly System.Drawing.Size Empty;
        public Size(int width, int height) { throw null; }
        public int Height { get { throw null; } set { } }
        public int Width { get { throw null; } set { } }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static implicit operator System.Drawing.SizeF (System.Drawing.Size p) { throw null; }        
        public static bool operator ==(System.Drawing.Size sz1, System.Drawing.Size sz2) { throw null; }
        public static bool operator !=(System.Drawing.Size sz1, System.Drawing.Size sz2) { throw null; }
    }
    public struct SizeF
    {
        public static readonly System.Drawing.SizeF Empty;
        public SizeF(float width, float height) { throw null; }
        public float Height { get { throw null; } set { } }
        public float Width { get { throw null; } set { } }        
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(System.Drawing.SizeF sz1, System.Drawing.SizeF sz2) { throw null; }
        public static bool operator !=(System.Drawing.SizeF sz1, System.Drawing.SizeF sz2) { throw null; }
    }
}

namespace CoreGraphics
{
    public enum CGInterpolationQuality
    {
        Default = 0,
        High = 3,
        Low = 2,
        Medium = 4,
        None = 1,
    }
    public enum CGPathDrawingMode
    {
        EOFill = 1,
        EOFillStroke = 4,
        Fill = 0,
        FillStroke = 3,
        Stroke = 2,
    }
    public enum CGBlendMode
    {
        Clear = 16,
        Color = 14,
        ColorBurn = 7,
        ColorDodge = 6,
        Copy = 17,
        Darken = 4,
        DestinationAtop = 24,
        DestinationIn = 22,
        DestinationOut = 23,
        DestinationOver = 21,
        Difference = 10,
        Exclusion = 11,
        HardLight = 9,
        Hue = 12,
        Lighten = 5,
        Luminosity = 15,
        Multiply = 1,
        Normal = 0,
        Overlay = 3,
        PlusDarker = 26,
        PlusLighter = 27,
        Saturation = 13,
        Screen = 2,
        SoftLight = 8,
        SourceAtop = 20,
        SourceIn = 18,
        SourceOut = 19,
        XOR = 25,
    }
    public enum CGLineCap
    {
        Butt = 0,
        Round = 1,
        Square = 2,
    }
    public enum CGBitmapFlags : uint
    {
        AlphaInfoMask = (uint)31,
        ByteOrder16Big = (uint)12288,
        ByteOrder16Little = (uint)4096,
        ByteOrder32Big = (uint)16384,
        ByteOrder32Little = (uint)8192,
        ByteOrderDefault = (uint)0,
        ByteOrderMask = (uint)28672,
        First = (uint)4,
        FloatComponents = (uint)256,
        FloatInfoMask = (uint)3840,
        Last = (uint)3,
        None = (uint)0,
        NoneSkipFirst = (uint)6,
        NoneSkipLast = (uint)5,
        Only = (uint)7,
        PremultipliedFirst = (uint)2,
        PremultipliedLast = (uint)1,
    }
    public enum CGColorRenderingIntent
    {
        AbsoluteColorimetric = 1,
        Default = 0,
        Perceptual = 3,
        RelativeColorimetric = 2,
        Saturation = 4,
    }
    public enum CGImageAlphaInfo : uint
    {
        First = (uint)4,
        Last = (uint)3,
        None = (uint)0,
        NoneSkipFirst = (uint)6,
        NoneSkipLast = (uint)5,
        Only = (uint)7,
        PremultipliedFirst = (uint)2,
        PremultipliedLast = (uint)1,
    }
    public enum CGColorSpaceModel
    {
        CMYK = 2,
        DeviceN = 4,
        Indexed = 5,
        Lab = 3,
        Monochrome = 0,
        Pattern = 6,
        RGB = 1,
        Unknown = -1,
        Xyz = 7,
    }
    public enum CGPDFBox
    {
        Art = 4,
        Bleed = 2,
        Crop = 1,
        Media = 0,
        Trim = 3,
    }
    public enum CGPatternTiling
    {
        ConstantSpacing = 2,
        ConstantSpacingMinimalDistortion = 1,
        NoDistortion = 0,
    }
    public enum CGPathElementType
    {
        AddCurveToPoint = 3,
        AddLineToPoint = 1,
        AddQuadCurveToPoint = 2,
        CloseSubpath = 4,
        MoveToPoint = 0,
    }

    public struct CGAffineTransform
    {
        public System.nfloat x0;
        public System.nfloat xx;
        public System.nfloat xy;
        public System.nfloat y0;
        public System.nfloat yx;
        public System.nfloat yy;        
        public CGAffineTransform(System.nfloat xx, System.nfloat yx, System.nfloat xy, System.nfloat yy, System.nfloat x0, System.nfloat y0) { throw null; }
        public bool IsIdentity { get { throw null; } }
        public static CoreGraphics.CGAffineTransform CGAffineTransformInvert(CoreGraphics.CGAffineTransform t) { throw null; }
        public CoreGraphics.CGAffineTransform Invert() { throw null; }
        public static CoreGraphics.CGAffineTransform MakeIdentity() { throw null; }
        public static CoreGraphics.CGAffineTransform MakeRotation(System.nfloat angle) { throw null; }
        public static CoreGraphics.CGAffineTransform MakeScale(System.nfloat sx, System.nfloat sy) { throw null; }
        public static CoreGraphics.CGAffineTransform MakeTranslation(System.nfloat tx, System.nfloat ty) { throw null; }
        public void Multiply(CoreGraphics.CGAffineTransform b) { }
        public static CoreGraphics.CGAffineTransform Multiply(CoreGraphics.CGAffineTransform a, CoreGraphics.CGAffineTransform b) { throw null; }
        public static CoreGraphics.CGAffineTransform Rotate(CoreGraphics.CGAffineTransform transform, System.nfloat angle) { throw null; }
        public void Rotate(System.nfloat angle) { }
        public static CoreGraphics.CGAffineTransform Scale(CoreGraphics.CGAffineTransform transform, System.nfloat sx, System.nfloat sy) { throw null; }
        public void Scale(System.nfloat sx, System.nfloat sy) { }
        public CoreGraphics.CGPoint TransformPoint(CoreGraphics.CGPoint point) { throw null; }
        public static CoreGraphics.CGAffineTransform Translate(CoreGraphics.CGAffineTransform transform, System.nfloat tx, System.nfloat ty) { throw null; }
        public void Translate(System.nfloat tx, System.nfloat ty) { }
    }
    public struct CGPathElement
    {
        public CoreGraphics.CGPoint Point1;
        public CoreGraphics.CGPoint Point2;
        public CoreGraphics.CGPoint Point3;
        public CoreGraphics.CGPathElementType Type;
    }
    public struct CGPoint
    {
        public CGPoint(float x, float y) { throw null; }
        public System.nfloat X { get { throw null; } set { } }
        public System.nfloat Y { get { throw null; } set { } }
        public static explicit operator System.Drawing.PointF (CoreGraphics.CGPoint point) { throw null; }        
        public static implicit operator CoreGraphics.CGPoint (System.Drawing.PointF point) { throw null; }
    }
    public struct CGRect
    {
        public static readonly CoreGraphics.CGRect Empty;
        public CGRect(CoreGraphics.CGPoint location, CoreGraphics.CGSize size) { throw null; }
        public CGRect(double x, double y, double width, double height) { throw null; }
        public CGRect(System.nfloat x, System.nfloat y, System.nfloat width, System.nfloat height) { throw null; }
        public CGRect(float x, float y, float width, float height) { throw null; }
        public System.nfloat Bottom { get { throw null; } }
        public System.nfloat Height { get { throw null; } set { } }
        public System.nfloat Left { get { throw null; } }
        public System.nfloat Top { get { throw null; } }
        public System.nfloat Width { get { throw null; } set { } }
        public System.nfloat X { get { throw null; } set { } }
        public System.nfloat Y { get { throw null; } set { } }
        public System.nfloat Right { get { throw null; } }
        public CoreGraphics.CGSize Size { get { throw null; } set { } }
        public bool Equals(CoreGraphics.CGRect rect) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(CoreGraphics.CGRect left, CoreGraphics.CGRect right) { throw null; }
        public static explicit operator System.Drawing.RectangleF (CoreGraphics.CGRect rect) { throw null; }
        public static implicit operator CoreGraphics.CGRect (System.Drawing.Rectangle rect) { throw null; }
        public static implicit operator CoreGraphics.CGRect (System.Drawing.RectangleF rect) { throw null; }        
        public static bool operator !=(CoreGraphics.CGRect left, CoreGraphics.CGRect right) { throw null; }
    }
    public struct CGSize
    {
        public CGSize(float width, float height) { throw null; }        
        public CGSize(System.nfloat width, System.nfloat height) { throw null; }
        public System.nfloat Height { get { throw null; } set { } }
        public System.nfloat Width { get { throw null; } set { } }
        public static explicit operator System.Drawing.SizeF (CoreGraphics.CGSize size) { throw null; }
        public static implicit operator CoreGraphics.CGSize (System.Drawing.SizeF size) { throw null; }
    }

    public class CGColor
    {
        public CGColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }        
    }
    public partial class CGContext
    {
        public CGContext(System.IntPtr handle) { }
        public System.IntPtr Handle { get { throw null; } }
        public CoreGraphics.CGInterpolationQuality InterpolationQuality { get { throw null; } set { } }
        public CoreGraphics.CGAffineTransform TextMatrix { get { throw null; } set { } }
        public void AddCurveToPoint(System.nfloat cp1x, System.nfloat cp1y, System.nfloat cp2x, System.nfloat cp2y, System.nfloat x, System.nfloat y) { }
        public void AddEllipseInRect(CoreGraphics.CGRect rect) { }
        public void AddLineToPoint(System.nfloat x, System.nfloat y) { }
        public void AddPath(CoreGraphics.CGPath path) { }
        public void BeginPage(System.Nullable<CoreGraphics.CGRect> rect) { }
        public void BeginTransparencyLayer(Foundation.NSDictionary auxiliaryInfo = null) { }
        public void ClearRect(CoreGraphics.CGRect rect) { }
        public void Clip() { }
        public void ClipToRect(CoreGraphics.CGRect rect) { }
        public void ClosePath() { }
        public void ConcatCTM(CoreGraphics.CGAffineTransform transform) { }
        public CoreGraphics.CGRect ConvertRectToUserSpace(CoreGraphics.CGRect rect) { throw null; }
        public CoreGraphics.CGSize ConvertSizeToDeviceSpace(CoreGraphics.CGSize size) { throw null; }
        public void Dispose() { }
        protected virtual void Dispose(bool disposing) { }
        public void DrawImage(CoreGraphics.CGRect rect, CoreGraphics.CGImage image) { }
        public void DrawPath(CoreGraphics.CGPathDrawingMode mode) { }
        public void DrawPDFPage(CoreGraphics.CGPDFPage page) { }
        public void DrawShading(CoreGraphics.CGShading shading) { }
        public void EndPage() { }
        public void EndTransparencyLayer() { }
        public void EOFillPath() { }
        public void FillEllipseInRect(CoreGraphics.CGRect rect) { }
        public void FillPath() { }
        public void FillRect(CoreGraphics.CGRect rect) { }
        public void Flush() { }
        public CoreGraphics.CGRect GetClipBoundingBox() { throw null; }
        public CoreGraphics.CGAffineTransform GetCTM() { throw null; }
        public bool IsPathEmpty() { throw null; }
        public void MoveTo(System.nfloat x, System.nfloat y) { }
        public void RestoreState() { }
        public void SaveState() { }
        public void ScaleCTM(System.nfloat sx, System.nfloat sy) { }
        public void SetBlendMode(CoreGraphics.CGBlendMode mode) { }
        public void SetFillColor(CoreGraphics.CGColor color) { }
        public void SetFillColor(System.nfloat gray, System.nfloat alpha) { }
        public void SetFillColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }
        public void SetFillColorSpace(CoreGraphics.CGColorSpace space) { }
        public void SetFillPattern(CoreGraphics.CGPattern pattern, System.nfloat[] components) { }
        public void SetLineCap(CoreGraphics.CGLineCap cap) { }
        public void SetLineDash(System.nfloat phase, System.nfloat[] lengths) { }
        public void SetLineWidth(System.nfloat w) { }
        public void SetShouldAntialias(bool shouldAntialias) { }
        public void SetStrokeColor(CoreGraphics.CGColor color) { }
        public void SetStrokeColor(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { }
        public void SetStrokeColorSpace(CoreGraphics.CGColorSpace space) { }
        public void SetStrokePattern(CoreGraphics.CGPattern pattern, System.nfloat[] components) { }
        public void StrokePath() { }
        public void StrokeRect(CoreGraphics.CGRect rect) { }
        public void Synchronize() { }
        public void TranslateCTM(System.nfloat tx, System.nfloat ty) { }
    }
    public class CGPDFDocument
    {
        public CGPDFDocument(CoreGraphics.CGDataProvider provider) { }
        public System.nint Pages { get { throw null; } }
        public CoreGraphics.CGPDFPage GetPage(System.nint page) { throw null; }
    }
    public class CGPDFPage
    {
        public CoreGraphics.CGRect GetBoxRect(CoreGraphics.CGPDFBox box) { throw null; }
        public CoreGraphics.CGAffineTransform GetDrawingTransform(CoreGraphics.CGPDFBox box, CoreGraphics.CGRect rect, int rotate, bool preserveAspectRatio) { throw null; }
    }
    public class CGPDFPageInfo {}
    public class CGImage : System.IDisposable
    {
        public CGImage(int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGBitmapFlags bitmapFlags, CoreGraphics.CGDataProvider provider, System.nfloat[] decode, bool shouldInterpolate, CoreGraphics.CGColorRenderingIntent intent) { }
        public CGImage(int width, int height, int bitsPerComponent, int bitsPerPixel, int bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGImageAlphaInfo alphaInfo, CoreGraphics.CGDataProvider provider, System.nfloat[] decode, bool shouldInterpolate, CoreGraphics.CGColorRenderingIntent intent) { }
        public CoreGraphics.CGImageAlphaInfo AlphaInfo { get { throw null; } }
        public CoreGraphics.CGBitmapFlags BitmapInfo { get { throw null; } }
        public System.nint BitsPerComponent { get { throw null; } }
        public System.nint BitsPerPixel { get { throw null; } }
        public System.nint BytesPerRow { get { throw null; } }
        public CoreGraphics.CGColorSpace ColorSpace { get { throw null; } }
        public CoreGraphics.CGDataProvider DataProvider { get { throw null; } }
        public System.nint Height { get { throw null; } }
        public CoreGraphics.CGColorRenderingIntent RenderingIntent { get { throw null; } }
        public System.nint Width { get { throw null; } }
        public CoreGraphics.CGImage Clone() { throw null; }
        public void Dispose() { }
        public CoreGraphics.CGImage WithColorSpace(CoreGraphics.CGColorSpace cs) { throw null; }
        public CoreGraphics.CGImage WithImageInRect(CoreGraphics.CGRect rect) { throw null; }
    }
    public class CGContextPDF : CoreGraphics.CGContext
    {
        public CGContextPDF(CoreGraphics.CGDataConsumer dataConsumer) : base (default(System.IntPtr)) { }
        public void BeginPage(CoreGraphics.CGPDFPageInfo info) { }
        protected override void Dispose(bool disposing) { }
        public new void EndPage() { }        
    }
    public class CGBitmapContext : CoreGraphics.CGContext
    {
        public CGBitmapContext(System.IntPtr data, System.nint width, System.nint height, System.nint bitsPerComponent, System.nint bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGBitmapFlags bitmapInfo) : base (default(System.IntPtr)) { }
        public CGBitmapContext(System.IntPtr data, System.nint width, System.nint height, System.nint bitsPerComponent, System.nint bytesPerRow, CoreGraphics.CGColorSpace colorSpace, CoreGraphics.CGImageAlphaInfo bitmapInfo) : base (default(System.IntPtr)) { }
        public CoreGraphics.CGImage ToImage() { throw null; }
    }
    public class CGDataConsumer
    {
        public CGDataConsumer(Foundation.NSMutableData data) { }
    }
    public class CGFunction
    {
        public CGFunction(System.nfloat[] domain, System.nfloat[] range, CoreGraphics.CGFunction.CGFunctionEvaluate callback) { }
        public void Dispose() { }
        public unsafe delegate void CGFunctionEvaluate(System.nfloat* data, System.nfloat* outData);
    }
    public class CGDataProvider
    {
        public CGDataProvider(Foundation.NSData data) { }
        public CGDataProvider(System.IntPtr memoryBlock, int size) { }
        public CGDataProvider(System.IntPtr memoryBlock, int size, bool ownBuffer) { }
        public CGDataProvider(string file) { }
        public Foundation.NSData CopyData() { throw null; }
        public void Dispose() { }
    }
    public class CGPath
    {
        public CGPath() { }
        public CGPath(CoreGraphics.CGPath basePath) { }
        public CoreGraphics.CGRect BoundingBox { get { throw null; } }
        public bool IsEmpty { get { throw null; } }
        public void AddCurveToPoint(System.nfloat cp1x, System.nfloat cp1y, System.nfloat cp2x, System.nfloat cp2y, System.nfloat x, System.nfloat y) { }
        public void AddLineToPoint(CoreGraphics.CGPoint point) { }
        public void AddLineToPoint(System.nfloat x, System.nfloat y) { }
        public void Apply(CoreGraphics.CGPath.ApplierFunction func) { }
        public void CloseSubpath() { }
        public bool ContainsPoint(CoreGraphics.CGPoint point, bool eoFill) { throw null; }
        public override bool Equals(object o) { throw null; }
        public override int GetHashCode() { throw null; }
        public void MoveToPoint(CoreGraphics.CGPoint point) { }
        public void MoveToPoint(System.nfloat x, System.nfloat y) { }
        public static bool operator ==(CoreGraphics.CGPath path1, CoreGraphics.CGPath path2) { throw null; }
        public static bool operator !=(CoreGraphics.CGPath path1, CoreGraphics.CGPath path2) { throw null; }
        public delegate void ApplierFunction(CoreGraphics.CGPathElement element);
    }
    public class CGShading
    {
        public static CoreGraphics.CGShading CreateAxial(CoreGraphics.CGColorSpace colorspace, CoreGraphics.CGPoint start, CoreGraphics.CGPoint end, CoreGraphics.CGFunction function, bool extendStart, bool extendEnd) { throw null; }
        public void Dispose() { }
    }
    public class CGColorSpace
    {
        public CoreGraphics.CGColorSpaceModel Model { get { throw null; } }
        public static CoreGraphics.CGColorSpace CreateDeviceRGB() { throw null; }
        public static CoreGraphics.CGColorSpace CreateIndexed(CoreGraphics.CGColorSpace baseSpace, int lastIndex, byte[] colorTable) { throw null; }
        public static CoreGraphics.CGColorSpace CreatePattern(CoreGraphics.CGColorSpace baseSpace) { throw null; }
        public void Dispose() { }
    }
    public class CGPattern
    {
        public CGPattern(CoreGraphics.CGRect bounds, CoreGraphics.CGAffineTransform matrix, System.nfloat xStep, System.nfloat yStep, CoreGraphics.CGPatternTiling tiling, bool isColored, CoreGraphics.CGPattern.DrawPattern drawPattern) { }
        public delegate void DrawPattern(CoreGraphics.CGContext ctx);
    }
    public class CGImageProperties
    {
        public System.Nullable<float> DPIHeightF { get { throw null; } set { } }
        public System.Nullable<float> DPIWidthF { get { throw null; } set { } }
        public System.Nullable<int> PixelHeight { get { throw null; } set { } }
        public System.Nullable<int> PixelWidth { get { throw null; } set { } }
    }
    public class CGFont
    {
        public static CoreGraphics.CGFont CreateFromProvider(CoreGraphics.CGDataProvider provider) { throw null; }
    }
}

namespace CoreImage
{
    public class CIContext
    {
        public virtual CoreGraphics.CGImage CreateCGImage(CoreImage.CIImage image, CoreGraphics.CGRect fromRectangle) { throw null; }
        public static CoreImage.CIContext FromOptions(CoreImage.CIContextOptions options) { throw null; }
    }
    public class CIContextOptions {}
    public class CIImage : Foundation.NSObject
    {
        public static implicit operator CoreImage.CIImage (CoreGraphics.CGImage image) { throw null; }
        public virtual CoreGraphics.CGRect Extent { get { throw null; } }
    }
    public class CIFilter : Foundation.NSObject
    {
        public static CoreImage.CIFilter FromName(string name) { throw null; }
        public virtual void SetDefaults() { }
    }
    public class CIVector : Foundation.NSObject
    {
        public CIVector(System.nfloat x, System.nfloat y, System.nfloat z, System.nfloat w) { }
    }
}

namespace CoreText
{
    public enum CTFontSymbolicTraits : uint
    {
        Bold = (uint)2,
        ColorGlyphs = (uint)8192,
        Composite = (uint)16384,
        Condensed = (uint)64,
        Expanded = (uint)32,
        Italic = (uint)1,
        Mask = (uint)4026531840,
        MonoSpace = (uint)1024,
        None = (uint)0,
        UIOptimized = (uint)4096,
        Vertical = (uint)2048,
    }
    public enum CTTextAlignment : byte
    {
        Center = (byte)2,
        Justified = (byte)3,
        Left = (byte)0,
        Natural = (byte)4,
        Right = (byte)1,
    }
    public enum CTLineTruncation : uint
    {
        End = (uint)1,
        Middle = (uint)2,
        Start = (uint)0,
    }
    public enum CTUnderlineStyle
    {
        Double = 9,
        None = 0,
        Single = 1,
        Thick = 2,
    }
    public enum CTFontUIFontType : uint
    {
        AlertHeader = (uint)18,
        Application = (uint)9,
        ControlContent = (uint)26,
        EmphasizedSystem = (uint)3,
        EmphasizedSystemDetail = (uint)20,
        Label = (uint)10,
        MenuItem = (uint)12,
        MenuItemCmdKey = (uint)14,
        MenuItemMark = (uint)13,
        MenuTitle = (uint)11,
        Message = (uint)23,
        MiniEmphasizedSystem = (uint)7,
        MiniSystem = (uint)6,
        None = (uint)4294967295,
        Palette = (uint)24,
        PushButton = (uint)16,
        SmallEmphasizedSystem = (uint)5,
        SmallSystem = (uint)4,
        SmallToolbar = (uint)22,
        System = (uint)2,
        SystemDetail = (uint)19,
        Toolbar = (uint)21,
        ToolTip = (uint)25,
        User = (uint)0,
        UserFixedPitch = (uint)1,
        UtilityWindowTitle = (uint)17,
        Views = (uint)8,
        WindowTitle = (uint)15,
    }

    public class CTFont
    {
        public CTFont(CoreGraphics.CGFont font, System.nfloat size, CoreGraphics.CGAffineTransform transform) { }
        public CTFont(CoreGraphics.CGFont font, System.nfloat size, CoreText.CTFontDescriptor descriptor) { }
        public CTFont(CoreText.CTFontDescriptor descriptor, System.nfloat size) { }
        public CTFont(CoreText.CTFontUIFontType uiType, System.nfloat size, string language) { }
        public System.nfloat AscentMetric { get { throw null; } }
        public System.nfloat DescentMetric { get { throw null; } }
        public string FamilyName { get { throw null; } }
        public System.IntPtr Handle { get { throw null; } }
        public System.nfloat LeadingMetric { get { throw null; } }
        public System.nfloat Size { get { throw null; } }
        public CoreText.CTFontSymbolicTraits SymbolicTraits { get { throw null; } }
        public System.nfloat UnderlineThickness { get { throw null; } }
        public uint UnitsPerEmMetric { get { throw null; } }
        public System.nfloat XHeightMetric { get { throw null; } }
        public void Dispose() { }
        public CoreText.CTFontDescriptor GetFontDescriptor() { throw null; }
        public CoreGraphics.CGPath GetPathForGlyph(ushort glyph) { throw null; }
        public CoreText.CTFontTraits GetTraits() { throw null; }
        public CoreText.CTFont WithSymbolicTraits(System.nfloat size, CoreText.CTFontSymbolicTraits symTraitValue, CoreText.CTFontSymbolicTraits symTraitMask) { throw null; }
    }
    public class CTFontDescriptor
    {
        public CTFontDescriptor(CoreText.CTFontDescriptorAttributes attributes) { }
        public CTFontDescriptor(string name, System.nfloat size) { }
        public Foundation.NSObject GetAttribute(Foundation.NSString attribute) { throw null; }
        public CoreText.CTFontDescriptorAttributes GetAttributes() { throw null; }
        public CoreText.CTFontDescriptor[] GetMatchingFontDescriptors(Foundation.NSSet mandatoryAttributes) { throw null; }
    }
    public class CTFontDescriptorAttributes
    {
        public CTFontDescriptorAttributes(Foundation.NSDictionary dictionary) { }
        public string FamilyName { get { throw null; } set { } }
    }
    public class CTFontDescriptorAttributeKey
    {
        public static readonly Foundation.NSString FamilyName;
        public static readonly Foundation.NSString Traits;
    }
    public class CTLine : System.IDisposable
    {
        public CTLine(Foundation.NSAttributedString value) { }
        public Foundation.NSRange StringRange { get { throw null; } }
        public double TrailingWhitespaceWidth { get { throw null; } }
        public void Dispose() { }
        public void Draw(CoreGraphics.CGContext context) { }
        public CoreText.CTRun[] GetGlyphRuns() { throw null; }
        public double GetPenOffsetForFlush(System.nfloat flushFactor, double flushWidth) { throw null; }
        public CoreText.CTLine GetTruncatedLine(double width, CoreText.CTLineTruncation truncationType, CoreText.CTLine truncationToken) { throw null; }
        public double GetTypographicBounds(out System.nfloat ascent, out System.nfloat descent, out System.nfloat leading) { throw null; }
    }
    public class CTRun
    {
        public ushort[] GetGlyphs() { throw null; }
        public CoreGraphics.CGPoint[] GetPositions() { throw null; }
    }
    public class CTFontCollection
    {
        public CTFontCollection(CoreText.CTFontCollectionOptions options) { }
        public void Dispose() { }
        public CoreText.CTFontDescriptor[] GetMatchingFontDescriptors() { throw null; }
    }
    public class CTFontTraitKey
    {
        public static readonly Foundation.NSString Symbolic;
        public static readonly Foundation.NSString Weight;
    }
    public class CTFontTraits
    {
        public System.Nullable<CoreText.CTFontSymbolicTraits> SymbolicTraits { get { throw null; } set { } }
    }
    public class CTFontManager
    {
        public static bool RegisterGraphicsFont(CoreGraphics.CGFont font, out Foundation.NSError error) { throw null; }
    }
    public class CTFontCollectionOptions
    {
        public bool RemoveDuplicates { get { throw null; } set { } }
    }
    public class CTStringAttributes
    {
        public Foundation.NSDictionary Dictionary { get { throw null; } }
        public CoreText.CTFont Font { get { throw null; } set { } }
        public CoreGraphics.CGColor ForegroundColor { get { throw null; } set { } }
        public bool ForegroundColorFromContext { get { throw null; } set { } }
        public CoreText.CTParagraphStyle ParagraphStyle { get { throw null; } set { } }
        public System.Nullable<CoreText.CTUnderlineStyle> UnderlineStyle { get { throw null; } set { } }
        public System.Nullable<int> UnderlineStyleValue { get { throw null; } set { } }
    }
    public class CTParagraphStyle
    {
        public CTParagraphStyle(CoreText.CTParagraphStyleSettings settings) { }
    }
    public class CTTypesetter : System.IDisposable
    {
        public CTTypesetter(Foundation.NSAttributedString value) { }
        public void Dispose() { }
        public CoreText.CTLine GetLine(Foundation.NSRange stringRange) { throw null; }
        public System.nint SuggestLineBreak(int startIndex, double width) { throw null; }
    }
    public class CTParagraphStyleSettings
    {
        public System.Nullable<CoreText.CTTextAlignment> Alignment { get { throw null; } set { } }
    }
}

namespace Foundation
{
    public struct NSRange
    {
        public System.nint Length;
        public NSRange(System.nint start, System.nint len) { throw null; }        
    }

    public class NSAttributedString
    {
        public NSAttributedString() { }
        public NSAttributedString(string str, Foundation.NSDictionary attributes) { }
        public virtual System.nint Length { get { throw null; } }        
    }
    public class NSBundle
    {
        public static Foundation.NSBundle MainBundle { get { throw null; } }        
        public virtual string PathForResource(string name, string ofType) { throw null; }
    }
    public class NSData : Foundation.NSObject, System.IDisposable
    {
        public virtual byte this[System.nint idx] { get { throw null; } set { } }
        public virtual System.IO.Stream AsStream() { throw null; }
        public static Foundation.NSData FromArray(byte[] buffer) { throw null; }
        public static Foundation.NSData FromStream(System.IO.Stream stream) { throw null; }        
    }
    public class NSDictionary : Foundation.NSObject
    {
        public virtual Foundation.NSObject this[Foundation.NSString key] { get { throw null; } set { } }
    }
    public class NSError
    {
        public virtual System.nint Code { get { throw null; } }        
    }
    public class NSLocale
    {
        public static string[] PreferredLanguages { get { throw null; } }        
    }
    public class NSMutableAttributedString : Foundation.NSAttributedString
    {
        public NSMutableAttributedString(string str) { }
        public NSMutableAttributedString(string str, Foundation.NSDictionary attributes) { }
        public virtual void AddAttributes(Foundation.NSDictionary attrs, Foundation.NSRange range) { }
        public void AddAttributes(CoreText.CTStringAttributes attrs, Foundation.NSRange range) { }
    }
    public class NSMutableData : Foundation.NSData {}
    public class NSMutableDictionary : Foundation.NSDictionary {}
    public class NSNotification {}
    public class NSNotificationCenter
    {
        public static Foundation.NSNotificationCenter DefaultCenter { get { throw null; } }
        public Foundation.NSObject AddObserver(Foundation.NSString aName, System.Action<Foundation.NSNotification> notify) { throw null; }
    }
    public class NSNumber : Foundation.NSValue
    {
        public static Foundation.NSNumber FromFloat(float value) { throw null; }        
        public static Foundation.NSNumber FromUInt32(uint value) { throw null; }
    }
    public class NSObject : System.IDisposable
    {
        public System.IntPtr Handle { get { throw null; } set { } }
        public void Dispose() { }
        public virtual void SetValueForKey(Foundation.NSObject value, Foundation.NSString key) { }
        public virtual Foundation.NSObject ValueForKey(Foundation.NSString key) { throw null; }
    }
    public class NSValue : Foundation.NSObject {}
    public class NSSet {}
    public class NSString : Foundation.NSObject
    {
        public NSString(string str) { }
        public static explicit operator Foundation.NSString (string str) { throw null; }
    }
    public class NSUrl
    {
        public static Foundation.NSUrl FromFilename(string url) { throw null; }
        public virtual string Path { get { throw null; } }
    }
}

namespace ImageIO
{
    public class CGImageSource : System.IDisposable
    {
        public System.nint ImageCount { get { throw null; } }
        public string TypeIdentifier { get { throw null; } }
        public CoreGraphics.CGImage CreateImage(int index, ImageIO.CGImageOptions options) { throw null; }
        public void Dispose() { }
        public static ImageIO.CGImageSource FromData(Foundation.NSData data) { throw null; }
        public static ImageIO.CGImageSource FromUrl(Foundation.NSUrl url) { throw null; }
        public CoreGraphics.CGImageProperties GetProperties(int index, ImageIO.CGImageOptions options = null) { throw null; }
    }
    public class CGImageOptions {}
    public class CGImageDestination : System.IDisposable
    {
        public void AddImage(CoreGraphics.CGImage image, Foundation.NSDictionary properties) { }
        public bool Close() { throw null; }
        public void Dispose() { }
        public static ImageIO.CGImageDestination Create(Foundation.NSMutableData data, string typeIdentifier, int imageCount, ImageIO.CGImageDestinationOptions options = null) { throw null; }
        public static ImageIO.CGImageDestination Create(Foundation.NSUrl url, string typeIdentifier, int imageCount) { throw null; }
    }
    public class CGImageDestinationOptions {}
}

namespace UIKit
{
    public class UIColor
    {
        public static UIKit.UIColor FromRGBA(System.nfloat red, System.nfloat green, System.nfloat blue, System.nfloat alpha) { throw null; }
    }
    public class UIFont : Foundation.NSObject {}
    public class UIGraphics
    {
        public static CoreGraphics.CGContext GetCurrentContext() { throw null; }
    }
    public class UIScreen
    {
        public static UIKit.UIScreen MainScreen { get { throw null; } }
        public virtual System.nfloat Scale { get { throw null; } }
    }
}

namespace ObjCRuntime
{
    public static partial class Runtime
    {
        public static Foundation.NSObject GetNSObject(System.IntPtr ptr) { throw null; }
    }
}
