#!/user/local/bin/perl
# -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
#
# The contents of this file are subject to the Netscape Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/NPL/
# 
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is Mozilla Communicator client code.
#
# The Initial Developer of the Original Code is Netscape Communications
# Corporation.  Portions created by Netscape are
# Copyright (C) 1998 Netscape Communications Corporation. All
# Rights Reserved.
#
# Contributor(s): 
#

$name = "ucvlatin";
$dir = "./";

sub printnpl()
{
$npl = <<END_OF_NPL;
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITH WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is Netscape Communications
 * Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */
END_OF_NPL
print   $npl;
}

sub finddefine()
{
  my($classname, $definename) = (@_);
  $cmd = 'egrep ' . $classname .  ' ' . $dir . '*.h ' . $dir . '*.cpp | egrep "public" | egrep -v "Support[.]"' . '&> /dev/null';
  if( system($cmd)) {
    print   "\/\/ ";
  }
  print   "#define " . $definename . "\n";
}



&printnpl();
print   "\n";
print   "#ifndef " . $name . "config_h__\n";
print   "#define " . $name . "config_h__\n";
print   "\n";
print   "\/* This file is generated by running mozilla/intl/uconv/tools/genimpldefine.pl on unix */\n";

&finddefine( "nsBasicDecoderSupport", "IMPL_NSBASICDECODER");
&finddefine( "nsBufferDecoderSupport", "IMPL_NSBUFFERDECODER");
&finddefine( "nsTableDecoderSupport", "IMPL_NSTABLEDECODER");
&finddefine( "nsMultiTableDecoderSupport", "IMPL_NSMULTITABLEDECODER");
&finddefine( "nsOneByteDecoderSupport", "IMPL_NSONEBYTEDECODER");
&finddefine( "nsBasicEncoder", "IMPL_NSBASICENCODER");
&finddefine( "nsEncoderSupport", "IMPL_NSENCODER");
&finddefine( "nsTableEncoderSupport", "IMPL_NSTABLEENCODER");
&finddefine( "nsMultiTableEncoderSupport", "IMPL_NSMULTITABLEENCODER");
print   "\n";
print   "#include \"" . $name . "rules.h\"\n";
print   "\n";
print   "#endif \/*" . $name . "config_h__ *\/\n";
