// |reftest| skip -- class-fields-public is not supported
// Copyright (C) 2017 Valerie Young. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
description: Class construction should error if evaluation of field initializer errors
esid: sec-ecmascript-function-objects-construct-argumentslist-newtarget
info: |
  [[Construct]] ( argumentsList, newTarget)
    ...
    8. If kind is "base", then
      a. Perform OrdinaryCallBindThis(F, calleeContext, thisArgument).
      b. Let result be InitializeInstanceFields(thisArgument, F).
      c. If result is an abrupt completion, then
        i. Remove calleeContext from execution context stack and restore callerContext as the running execution context.
        ii. Return Completion(result).

  InitializeInstanceFields ( O, constructor )
    1. Assert: Type ( O ) is Object.
    2. Assert: Assert constructor is an ECMAScript function object.
    3. Let fieldRecords be the value of constructor's [[Fields]] internal slot.
    4. For each item fieldRecord in order from fieldRecords,
      a. If fieldRecord.[[static]] is false, then
        i. Perform ? DefineField(O, fieldRecord).

  DefineField(receiver, fieldRecord)
    1. Assert: Type(receiver) is Object.
    2. Assert: fieldRecord is a Record as created by ClassFieldDefinitionEvaluation.
    3. Let fieldName be fieldRecord.[[Name]].
    4. Let initializer be fieldRecord.[[Initializer]].
    5. If initializer is not empty, then
        a.Let initValue be ? Call(initializer, receiver).

features: [class, class-fields-public]
---*/

function f() {
  throw new Test262Error();
}

class C {
  x = f();
}

assert.throws(Test262Error, function() {
  new C();
})

reportCompare(0, 0);
