/*
 * Copyright 2003-2018 The Music Player Daemon Project
 * http://www.musicpd.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MPD_ICU_INIT_HXX
#define MPD_ICU_INIT_HXX

#include "config.h"

#ifdef HAVE_ICU

void
IcuInit();

void
IcuFinish() noexcept;

#else

static inline void IcuInit() noexcept {}
static inline void IcuFinish() noexcept {}

#endif

class ScopeIcuInit {
public:
	ScopeIcuInit() {
		IcuInit();
	}

	~ScopeIcuInit() noexcept {
		IcuFinish();
	}

	ScopeIcuInit(const ScopeIcuInit &) = delete;
	ScopeIcuInit &operator=(const ScopeIcuInit &) = delete;
};

#endif
