/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import base.drawable.Shadow;
import base.topology.StateBorder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.util.Arrays;

public class PreviewState {
    private static StateBorder BorderStyle = StateBorder.COLOR_XOR_BORDER;
    public static final String FIT_MOST_LEGENDS = "FitMostLegends";
    private static final int FIT_MOST_LEGENDS_ID = 0;
    public static final String OVERLAP_INCLUSION = "OverlapInclusionRatio";
    private static final int OVERLAP_INCLUSION_ID = 1;
    public static final String CUMULATIVE_INCLUSION = "CumulativeInclusionRatio";
    private static final int CUMULATIVE_INCLUSION_ID = 2;
    public static final String OVERLAP_EXCLUSION = "OverlapExclusionRatio";
    private static final int OVERLAP_EXCLUSION_ID = 3;
    public static final String CUMULATIVE_EXCLUSION = "CumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_ID = 4;
    public static final String CUMULATIVE_EXCLUSION_BASE = "BaseAlignedCumulativeExclusionRatio";
    private static final int CUMULATIVE_EXCLUSION_BASE_ID = 5;
    private static int DisplayType = 1;
    private static int MinCategoryHeight = 2;
    private static int MinCategorySeparation = 4;

    public static void setBorderStyle(StateBorder stateBorder) {
        BorderStyle = stateBorder;
    }

    public static void setDisplayType(String string) {
        DisplayType = string.equals(FIT_MOST_LEGENDS) ? 0 : (string.equals(OVERLAP_INCLUSION) ? 1 : (string.equals(CUMULATIVE_INCLUSION) ? 2 : (string.equals(OVERLAP_EXCLUSION) ? 3 : (string.equals(CUMULATIVE_EXCLUSION) ? 4 : (string.equals(CUMULATIVE_EXCLUSION_BASE) ? 5 : 1)))));
    }

    public static void setMinCategoryHeight(int n) {
        MinCategoryHeight = n;
    }

    private static int drawForward(Graphics2D graphics2D, Color color, Shadow shadow, Insets insets, CoordPixelXform coordPixelXform, DrawnBox drawnBox, double d, float f, double d2, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        int n6;
        int n7 = coordPixelXform.convertTimeToPixel(d);
        if (drawnBox.coversState(n7, n6 = coordPixelXform.convertTimeToPixel(d2))) {
            return 0;
        }
        drawnBox.set(n7, n6);
        int n8 = coordPixelXform.convertRowToPixel(f);
        int n9 = coordPixelXform.convertRowToPixel(f2);
        if (insets != null) {
            n7 += insets.left;
            n6 -= insets.right;
            n8 += insets.top;
            n9 -= insets.bottom;
        }
        int n10 = coordPixelXform.getPixelWidth();
        boolean bl2 = n7 >= 0;
        boolean bl3 = n6 < n10;
        int n11 = bl2 ? n7 : 0;
        int n12 = n8;
        int n13 = bl3 ? n6 : n10 - 1;
        int n14 = n9;
        int n15 = n6 - n7 + 1;
        int n16 = n13 - n11 + 1;
        int n17 = n14 - n12 + 1;
        CategoryWeight categoryWeight = null;
        int n18 = 0;
        CategoryWeight[] categoryWeightArray = shadow.arrayOfCategoryWeights();
        int n19 = categoryWeightArray.length;
        if (DisplayType == 2 || DisplayType == 4 || DisplayType == 5) {
            float f3;
            boolean bl4 = bl = DisplayType == 2;
            if (bl) {
                Arrays.sort(categoryWeightArray, CategoryWeight.INCL_RATIO_ORDER);
                float f4 = 0.0f;
                for (n5 = 0; n5 < n19; ++n5) {
                    categoryWeight = categoryWeightArray[n5];
                    if (!categoryWeight.getCategory().isVisible()) continue;
                    f4 += categoryWeight.getRatio(bl);
                }
                f3 = (float)n17 / f4;
            } else {
                Arrays.sort(categoryWeightArray, CategoryWeight.EXCL_RATIO_ORDER);
                f3 = n17;
            }
            n4 = n12 + n17;
            for (n5 = n19 - 1; n5 >= 0; --n5) {
                categoryWeight = categoryWeightArray[n5];
                if (categoryWeight.getCategory().isVisible()) {
                    n3 = (int)(f3 * categoryWeight.getRatio(bl) + 0.5f);
                    if (n3 > 0) {
                        if (n4 > n12) {
                            if (n4 - n3 >= n12) {
                                n4 -= n3;
                                categoryWeight.setPixelHeight(n3);
                            } else {
                                categoryWeight.setPixelHeight(n4 - n12);
                                n4 = n12;
                            }
                        } else {
                            categoryWeight.setPixelHeight(0);
                        }
                    } else {
                        categoryWeight.setPixelHeight(0);
                    }
                } else {
                    categoryWeight.setPixelHeight(0);
                }
                n18 += categoryWeight.getPixelHeight();
            }
            shadow.setTotalPixelHeight(n18);
        } else if (DisplayType == 1 || DisplayType == 3) {
            boolean bl5 = bl = DisplayType == 1;
            if (bl) {
                Arrays.sort(categoryWeightArray, CategoryWeight.INCL_RATIO_ORDER);
            } else {
                Arrays.sort(categoryWeightArray, CategoryWeight.EXCL_RATIO_ORDER);
            }
            n4 = Integer.MAX_VALUE;
            n2 = n15;
            for (n5 = n19 - 1; n5 >= 0; --n5) {
                categoryWeight = categoryWeightArray[n5];
                if (categoryWeight.getCategory().isVisible()) {
                    n3 = (int)(categoryWeight.getRatio(bl) * (float)n17 + 0.5f);
                    categoryWeight.setPixelHeight(n3);
                    if (n3 >= n4) {
                        n2 -= MinCategorySeparation;
                    }
                    categoryWeight.setPixelWidth(n2);
                    n4 = n3;
                    continue;
                }
                categoryWeight.setPixelHeight(0);
            }
        } else {
            Arrays.sort(categoryWeightArray, CategoryWeight.INCL_RATIO_ORDER);
            n = 0;
            for (n5 = 0; n5 < n19; ++n5) {
                if (!categoryWeightArray[n5].getCategory().isVisible()) continue;
                ++n;
            }
            n3 = (int)((float)n17 / (float)n);
            if (n3 < MinCategoryHeight) {
                n3 = MinCategoryHeight;
            }
            n4 = n12 + n17;
            for (n5 = n19 - 1; n5 >= 0; --n5) {
                categoryWeight = categoryWeightArray[n5];
                if (categoryWeight.getCategory().isVisible()) {
                    if (n4 > n12) {
                        if (n4 - n3 >= n12) {
                            n4 -= n3;
                            categoryWeight.setPixelHeight(n3);
                            continue;
                        }
                        categoryWeight.setPixelHeight(n4 - n12);
                        n4 = n12;
                        continue;
                    }
                    categoryWeight.setPixelHeight(0);
                    continue;
                }
                categoryWeight.setPixelHeight(0);
            }
        }
        n = 0;
        if (DisplayType == 1 || DisplayType == 3) {
            int n20 = n12 + n17 / 2;
            int n21 = n7 + n15 / 2;
            for (n5 = n19 - 1; n5 >= 0; --n5) {
                categoryWeight = categoryWeightArray[n5];
                n3 = categoryWeight.getPixelHeight();
                int n22 = categoryWeight.getPixelWidth();
                if (n3 <= 0 || n22 <= 0) continue;
                int n23 = n21 - n22 / 2;
                int n24 = n23 + n22;
                int n25 = n23 >= 0 ? n23 : 0;
                n2 = (n24 < n10 ? n24 : n10) - n25;
                graphics2D.setColor(categoryWeight.getCategory().getColor());
                graphics2D.fillRect(n25, n20 - n3 / 2, n2, n3);
                ++n;
            }
        } else {
            n4 = n12 + n17;
            if (DisplayType == 4) {
                n4 -= (n17 - n18) / 2;
            }
            for (n5 = n19 - 1; n5 >= 0; --n5) {
                categoryWeight = categoryWeightArray[n5];
                n3 = categoryWeight.getPixelHeight();
                if (n3 <= 0) continue;
                graphics2D.setColor(categoryWeight.getCategory().getColor());
                graphics2D.fillRect(n11, n4 -= n3, n16, n3);
                ++n;
            }
        }
        if (n > 0) {
            BorderStyle.paintStateBorder(graphics2D, color, n11, n12, bl2, n13, n14, bl3);
        }
        return 1;
    }

    private static Category isPixelIn(Shadow shadow, Insets insets, CoordPixelXform coordPixelXform, Point point, double d, float f, double d2, float f2) {
        int n = point.y;
        int n2 = coordPixelXform.convertRowToPixel(f);
        if (n < n2) {
            return null;
        }
        int n3 = coordPixelXform.convertRowToPixel(f2);
        if (n > n3) {
            return null;
        }
        int n4 = point.x;
        int n5 = coordPixelXform.convertTimeToPixel(d);
        if (n4 < n5) {
            return null;
        }
        int n6 = coordPixelXform.convertTimeToPixel(d2);
        if (n4 > n6) {
            return null;
        }
        if (insets != null) {
            n5 += insets.left;
            n6 -= insets.right;
            n2 += insets.top;
            n3 -= insets.bottom;
        }
        int n7 = n2;
        int n8 = n3;
        int n9 = n8 - n7 + 1;
        CategoryWeight categoryWeight = null;
        CategoryWeight[] categoryWeightArray = shadow.arrayOfCategoryWeights();
        int n10 = categoryWeightArray.length;
        if (DisplayType == 1 || DisplayType == 3) {
            int n11 = coordPixelXform.getPixelWidth();
            int n12 = n6 - n5 + 1;
            int n13 = n7 + n9 / 2;
            int n14 = n5 + n12 / 2;
            for (int i = 0; i < n10; ++i) {
                int n15;
                categoryWeight = categoryWeightArray[i];
                int n16 = categoryWeight.getPixelHeight();
                int n17 = categoryWeight.getPixelWidth();
                if (n16 <= 0 || n17 <= 0 || n < (n15 = n13 - n16 / 2) || n >= n15 + n16) continue;
                int n18 = n14 - n17 / 2;
                int n19 = n18 + n17;
                int n20 = n18 >= 0 ? n18 : 0;
                int n21 = (n19 < n11 ? n19 : n11) - n20;
                if (n4 < n20 || n4 >= n20 + n21) continue;
                return categoryWeight.getCategory();
            }
        } else {
            int n22 = n7 + n9;
            if (DisplayType == 4) {
                n22 -= (n9 - shadow.getTotalPixelHeight()) / 2;
            }
            for (int i = n10 - 1; i >= 0; --i) {
                categoryWeight = categoryWeightArray[i];
                int n23 = categoryWeight.getPixelHeight();
                if (n23 <= 0 || n < (n22 -= n23) || n >= n22 + n23) continue;
                return categoryWeight.getCategory();
            }
        }
        return null;
    }

    public static int draw(Graphics2D graphics2D, Color color, Shadow shadow, Insets insets, CoordPixelXform coordPixelXform, DrawnBox drawnBox, double d, float f, double d2, float f2) {
        if (d < d2) {
            if (f < f2) {
                return PreviewState.drawForward(graphics2D, color, shadow, insets, coordPixelXform, drawnBox, d, f, d2, f2);
            }
            return PreviewState.drawForward(graphics2D, color, shadow, insets, coordPixelXform, drawnBox, d, f2, d2, f);
        }
        if (f < f2) {
            return PreviewState.drawForward(graphics2D, color, shadow, insets, coordPixelXform, drawnBox, d2, f, d, f2);
        }
        return PreviewState.drawForward(graphics2D, color, shadow, insets, coordPixelXform, drawnBox, d2, f2, d, f);
    }

    public static Category containsPixel(Shadow shadow, Insets insets, CoordPixelXform coordPixelXform, Point point, double d, float f, double d2, float f2) {
        if (d < d2) {
            if (f < f2) {
                return PreviewState.isPixelIn(shadow, insets, coordPixelXform, point, d, f, d2, f2);
            }
            return PreviewState.isPixelIn(shadow, insets, coordPixelXform, point, d, f2, d2, f);
        }
        if (f < f2) {
            return PreviewState.isPixelIn(shadow, insets, coordPixelXform, point, d2, f, d, f2);
        }
        return PreviewState.isPixelIn(shadow, insets, coordPixelXform, point, d2, f2, d, f);
    }
}

