/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import base.drawable.NestingStacks;
import base.drawable.Shadow;
import base.topology.Arrow;
import base.topology.Event;
import base.topology.Line;
import base.topology.MarkerArrow;
import base.topology.MarkerEvent;
import base.topology.MarkerLine;
import base.topology.MarkerState;
import base.topology.Pointer;
import base.topology.PreviewEvent;
import base.topology.PreviewState;
import base.topology.State;
import base.topology.StateBorder;
import base.topology.SummaryArrow;
import base.topology.SummaryState;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import viewer.common.Alias;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.common.LabeledComboBox;
import viewer.common.LabeledTextField;
import viewer.common.TimeFormat;

public class Parameters {
    private static final String VERSION_INFO = "1.0.4.0";
    private static String setupfile_path = null;
    public static String Y_AXIS_ROOT_LABEL = "SLOG-2";
    public static short INIT_SLOG2_LEVEL_READ = (short)4;
    public static boolean AUTO_WINDOWS_LOCATION = true;
    public static float SCREEN_HEIGHT_RATIO = 0.5f;
    public static float TIME_SCROLL_UNIT_RATIO = 0.01f;
    public static boolean Y_AXIS_ROOT_VISIBLE = true;
    public static boolean ACTIVE_REFRESH = false;
    public static Alias BACKGROUND_COLOR = Const.COLOR_BLACK;
    public static float STATE_HEIGHT_FACTOR = 0.9f;
    public static float NESTING_HEIGHT_FACTOR = 0.8f;
    public static Alias ARROW_ANTIALIASING = Const.ANTIALIAS_DEFAULT;
    public static int Y_AXIS_MIN_ROW_HEIGHT = 4;
    public static int MIN_WIDTH_TO_DRAG = 4;
    public static int CLICK_RADIUS_TO_LINE = 3;
    public static boolean LEFTCLICK_INSTANT_ZOOM = true;
    public static boolean POPUP_BOX_MINIMAL_VIEW = true;
    public static String LARGE_DURATION_FORMAT = "hr, min, or sec";
    public static StateBorder STATE_BORDER = StateBorder.COLOR_RAISED_BORDER;
    public static int ARROW_HEAD_LENGTH = 10;
    public static int ARROW_HEAD_WIDTH = 6;
    public static int EVENT_BASE_WIDTH = 8;
    public static String PREVIEW_STATE_DISPLAY = "CumulativeExclusionRatio";
    public static StateBorder PREVIEW_STATE_BORDER = StateBorder.COLOR_XOR_BORDER;
    public static int PREVIEW_STATE_BORDER_WIDTH = 3;
    public static int PREVIEW_STATE_BORDER_HEIGHT = 0;
    public static int PREVIEW_STATE_LEGEND_HEIGHT = 2;
    public static int PREVIEW_ARROW_LOG_BASE = 5;
    public static boolean HIGHLIGHT_CLICKED_OBJECT = true;
    public static boolean POINTER_ON_CLICKED_OBJECT = true;
    public static int MARKER_POINTER_MIN_LENGTH = 20;
    public static int MARKER_POINTER_MAX_LENGTH = 30;
    public static boolean MARKER_STATE_STAYS_ON_TOP = false;
    public static int MARKER_STATE_BORDER_WIDTH = 3;
    public static int MARKER_ARROW_BORDER_WIDTH = 4;
    public static int MARKER_LINE_BORDER_WIDTH = 4;
    public static int MARKER_EVENT_BORDER_WIDTH = 4;
    public static boolean HISTOGRAM_ZERO_ORIGIN = true;
    public static StateBorder SUMMARY_STATE_BORDER = StateBorder.COLOR_RAISED_BORDER;
    public static int SUMMARY_ARROW_LOG_BASE = 5;
    public static boolean LEGEND_PREVIEW_ORDER = true;
    public static boolean LEGEND_TOPOLOGY_ORDER = true;

    public static final void initSetupFile() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        setupfile_path = string + string2 + ".jumpshot4.conf";
        System.out.println("Jumpshot-4 setup file : " + setupfile_path);
    }

    public static void initStaticClasses() {
        LabeledTextField.setDefaultFont(Const.FONT);
        LabeledComboBox.setDefaultFont(Const.FONT);
        Arrow.setHeadProperty(ARROW_HEAD_LENGTH, ARROW_HEAD_WIDTH);
        Event.setBaseWidth(EVENT_BASE_WIDTH);
        Line.setPixelClosenessTolerance(CLICK_RADIUS_TO_LINE);
        Event.setPixelClosenessTolerance(CLICK_RADIUS_TO_LINE);
        State.setBorderStyle(STATE_BORDER);
        PreviewState.setBorderStyle(PREVIEW_STATE_BORDER);
        PreviewState.setDisplayType(PREVIEW_STATE_DISPLAY);
        PreviewState.setMinCategoryHeight(PREVIEW_STATE_LEGEND_HEIGHT);
        PreviewEvent.setPixelClosenessTolerance(CLICK_RADIUS_TO_LINE);
        Shadow.setStateInsetsDimension(PREVIEW_STATE_BORDER_WIDTH, PREVIEW_STATE_BORDER_HEIGHT);
        Shadow.setBaseOfLogOfObjectNumToArrowWidth(PREVIEW_ARROW_LOG_BASE);
        NestingStacks.setInitialNestingHeight(STATE_HEIGHT_FACTOR);
        NestingStacks.setNestingHeightReduction(NESTING_HEIGHT_FACTOR);
        Pointer.setProperty(MARKER_POINTER_MIN_LENGTH, MARKER_POINTER_MAX_LENGTH);
        MarkerState.setProperty(MARKER_STATE_STAYS_ON_TOP, MARKER_STATE_BORDER_WIDTH);
        MarkerArrow.setHeadAndBorderProperty(ARROW_HEAD_LENGTH, ARROW_HEAD_WIDTH, MARKER_ARROW_BORDER_WIDTH);
        MarkerLine.setProperty(MARKER_LINE_BORDER_WIDTH);
        MarkerEvent.setBaseAndBorderProperty(EVENT_BASE_WIDTH, MARKER_EVENT_BORDER_WIDTH);
        SummaryArrow.setBaseOfLogOfObjectNumToArrowWidth(SUMMARY_ARROW_LOG_BASE);
        SummaryState.setBorderStyle(SUMMARY_STATE_BORDER);
        TimeFormat.setLargeDurationFormat(LARGE_DURATION_FORMAT);
    }

    public static final void writeToSetupFile(Component component) {
        if (!Dialogs.confirm(component, "Save preferred settings to the setup file ?")) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("VERSION_INFO", VERSION_INFO);
        properties.setProperty("Y_AXIS_ROOT_LABEL", Y_AXIS_ROOT_LABEL);
        properties.setProperty("INIT_SLOG2_LEVEL_READ", String.valueOf(INIT_SLOG2_LEVEL_READ));
        properties.setProperty("AUTO_WINDOWS_LOCATION", String.valueOf(AUTO_WINDOWS_LOCATION));
        properties.setProperty("SCREEN_HEIGHT_RATIO", String.valueOf(SCREEN_HEIGHT_RATIO));
        properties.setProperty("TIME_SCROLL_UNIT_RATIO", String.valueOf(TIME_SCROLL_UNIT_RATIO));
        properties.setProperty("Y_AXIS_ROOT_VISIBLE", String.valueOf(Y_AXIS_ROOT_VISIBLE));
        properties.setProperty("ACTIVE_REFRESH", String.valueOf(ACTIVE_REFRESH));
        properties.setProperty("BACKGROUND_COLOR", String.valueOf(BACKGROUND_COLOR));
        properties.setProperty("STATE_HEIGHT_FACTOR", String.valueOf(STATE_HEIGHT_FACTOR));
        properties.setProperty("NESTING_HEIGHT_FACTOR", String.valueOf(NESTING_HEIGHT_FACTOR));
        properties.setProperty("ARROW_ANTIALIASING", String.valueOf(ARROW_ANTIALIASING));
        properties.setProperty("Y_AXIS_MIN_ROW_HEIGHT", String.valueOf(Y_AXIS_MIN_ROW_HEIGHT));
        properties.setProperty("MIN_WIDTH_TO_DRAG", String.valueOf(MIN_WIDTH_TO_DRAG));
        properties.setProperty("CLICK_RADIUS_TO_LINE", String.valueOf(CLICK_RADIUS_TO_LINE));
        properties.setProperty("LEFTCLICK_INSTANT_ZOOM", String.valueOf(LEFTCLICK_INSTANT_ZOOM));
        properties.setProperty("POPUP_BOX_MINIMAL_VIEW", String.valueOf(POPUP_BOX_MINIMAL_VIEW));
        properties.setProperty("LARGE_DURATION_FORMAT", LARGE_DURATION_FORMAT);
        properties.setProperty("STATE_BORDER", String.valueOf(STATE_BORDER));
        properties.setProperty("ARROW_HEAD_LENGTH", String.valueOf(ARROW_HEAD_LENGTH));
        properties.setProperty("ARROW_HEAD_WIDTH", String.valueOf(ARROW_HEAD_WIDTH));
        properties.setProperty("EVENT_BASE_WIDTH", String.valueOf(EVENT_BASE_WIDTH));
        properties.setProperty("PREVIEW_STATE_DISPLAY", PREVIEW_STATE_DISPLAY);
        properties.setProperty("PREVIEW_STATE_BORDER", String.valueOf(PREVIEW_STATE_BORDER));
        properties.setProperty("PREVIEW_STATE_BORDER_WIDTH", String.valueOf(PREVIEW_STATE_BORDER_WIDTH));
        properties.setProperty("PREVIEW_STATE_BORDER_HEIGHT", String.valueOf(PREVIEW_STATE_BORDER_HEIGHT));
        properties.setProperty("PREVIEW_STATE_LEGEND_HEIGHT", String.valueOf(PREVIEW_STATE_LEGEND_HEIGHT));
        properties.setProperty("PREVIEW_ARROW_LOG_BASE", String.valueOf(PREVIEW_ARROW_LOG_BASE));
        properties.setProperty("HIGHLIGHT_CLICKED_OBJECT", String.valueOf(HIGHLIGHT_CLICKED_OBJECT));
        properties.setProperty("POINTER_ON_CLICKED_OBJECT", String.valueOf(POINTER_ON_CLICKED_OBJECT));
        properties.setProperty("MARKER_POINTER_MIN_LENGTH", String.valueOf(MARKER_POINTER_MIN_LENGTH));
        properties.setProperty("MARKER_POINTER_MAX_LENGTH", String.valueOf(MARKER_POINTER_MAX_LENGTH));
        properties.setProperty("MARKER_STATE_STAYS_ON_TOP", String.valueOf(MARKER_STATE_STAYS_ON_TOP));
        properties.setProperty("MARKER_STATE_BORDER_WIDTH", String.valueOf(MARKER_STATE_BORDER_WIDTH));
        properties.setProperty("MARKER_ARROW_BORDER_WIDTH", String.valueOf(MARKER_ARROW_BORDER_WIDTH));
        properties.setProperty("MARKER_STATE_BORDER_WIDTH", String.valueOf(MARKER_STATE_BORDER_WIDTH));
        properties.setProperty("MARKER_EVENT_BORDER_WIDTH", String.valueOf(MARKER_EVENT_BORDER_WIDTH));
        properties.setProperty("HISTOGRAM_ZERO_ORIGIN", String.valueOf(HISTOGRAM_ZERO_ORIGIN));
        properties.setProperty("SUMMARY_STATE_BORDER", String.valueOf(SUMMARY_STATE_BORDER));
        properties.setProperty("SUMMARY_ARROW_LOG_BASE", String.valueOf(SUMMARY_ARROW_LOG_BASE));
        properties.setProperty("LEGEND_PREVIEW_ORDER", String.valueOf(LEGEND_PREVIEW_ORDER));
        properties.setProperty("LEGEND_TOPOLOGY_ORDER", String.valueOf(LEGEND_TOPOLOGY_ORDER));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(setupfile_path);
            properties.store(fileOutputStream, " Jumpshot-4 setup file");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        System.out.println("Finalize Parameters: \n" + Parameters.toInOutString());
    }

    public static final void readFromSetupFile(Component component) {
        boolean bl = false;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(setupfile_path);
            properties.load(fileInputStream);
            fileInputStream.close();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Creating Jumpshot-4 setup file ...");
            Dialogs.info(component, "It seems this is your first time using Jumpshot-4,\na setup file will be created in your home directory\nwith the default settings.", null);
            Parameters.writeToSetupFile(component);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        String string = properties.getProperty("VERSION_INFO");
        if (!VERSION_INFO.equals(string) && bl) {
            Dialogs.warn(component, "Version mismatch! This Jumpshot-4 is of version 1.0.4.0 not version " + string + " that " + "is specified in your setup file.\n" + "You may want to SAVE your preferences again in the " + "Preference window to avoid this warning message.");
        }
        if ((string = properties.getProperty("Y_AXIS_ROOT_LABEL")) != null) {
            Y_AXIS_ROOT_LABEL = string;
        }
        if ((string = properties.getProperty("INIT_SLOG2_LEVEL_READ")) != null) {
            INIT_SLOG2_LEVEL_READ = Short.parseShort(string);
        }
        if ((string = properties.getProperty("AUTO_WINDOWS_LOCATION")) != null) {
            boolean bl2 = AUTO_WINDOWS_LOCATION = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("SCREEN_HEIGHT_RATIO")) != null) {
            SCREEN_HEIGHT_RATIO = Float.parseFloat(string);
        }
        if ((string = properties.getProperty("TIME_SCROLL_UNIT_RATIO")) != null) {
            TIME_SCROLL_UNIT_RATIO = Float.parseFloat(string);
        }
        if ((string = properties.getProperty("Y_AXIS_ROOT_VISIBLE")) != null) {
            boolean bl3 = Y_AXIS_ROOT_VISIBLE = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("BACKGROUND_COLOR")) != null) {
            BACKGROUND_COLOR = Const.parseBackgroundColor(string);
        }
        if ((string = properties.getProperty("STATE_HEIGHT_FACTOR")) != null) {
            STATE_HEIGHT_FACTOR = Float.parseFloat(string);
        }
        if ((string = properties.getProperty("NESTING_HEIGHT_FACTOR")) != null) {
            NESTING_HEIGHT_FACTOR = Float.parseFloat(string);
        }
        if ((string = properties.getProperty("ARROW_ANTIALIASING")) != null) {
            ARROW_ANTIALIASING = Const.parseAntiAliasing(string);
        }
        if ((string = properties.getProperty("Y_AXIS_MIN_ROW_HEIGHT")) != null) {
            Y_AXIS_MIN_ROW_HEIGHT = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MIN_WIDTH_TO_DRAG")) != null) {
            MIN_WIDTH_TO_DRAG = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("CLICK_RADIUS_TO_LINE")) != null) {
            CLICK_RADIUS_TO_LINE = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("LEFTCLICK_INSTANT_ZOOM")) != null) {
            boolean bl4 = LEFTCLICK_INSTANT_ZOOM = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("POPUP_BOX_MINIMAL_VIEW")) != null) {
            boolean bl5 = POPUP_BOX_MINIMAL_VIEW = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("LARGE_DURATION_FORMAT")) != null) {
            LARGE_DURATION_FORMAT = string;
        }
        if ((string = properties.getProperty("STATE_BORDER")) != null) {
            STATE_BORDER = StateBorder.parseString(string);
        }
        if ((string = properties.getProperty("ARROW_HEAD_LENGTH")) != null) {
            ARROW_HEAD_LENGTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("ARROW_HEAD_WIDTH")) != null) {
            ARROW_HEAD_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("EVENT_BASE_WIDTH")) != null) {
            EVENT_BASE_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("PREVIEW_STATE_DISPLAY")) != null) {
            PREVIEW_STATE_DISPLAY = string;
        }
        if ((string = properties.getProperty("PREVIEW_STATE_BORDER")) != null) {
            PREVIEW_STATE_BORDER = StateBorder.parseString(string);
        }
        if ((string = properties.getProperty("PREVIEW_STATE_BORDER_WIDTH")) != null) {
            PREVIEW_STATE_BORDER_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("PREVIEW_STATE_BORDER_HEIGHT")) != null) {
            PREVIEW_STATE_BORDER_HEIGHT = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("PREVIEW_STATE_LEGEND_HEIGHT")) != null) {
            PREVIEW_STATE_LEGEND_HEIGHT = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("PREVIEW_ARROW_LOG_BASE")) != null) {
            PREVIEW_ARROW_LOG_BASE = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("HIGHLIGHT_CLICKED_OBJECT")) != null) {
            boolean bl6 = HIGHLIGHT_CLICKED_OBJECT = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("POINTER_ON_CLICKED_OBJECT")) != null) {
            boolean bl7 = POINTER_ON_CLICKED_OBJECT = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("MARKER_POINTER_MIN_LENGTH")) != null) {
            MARKER_POINTER_MIN_LENGTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MARKER_POINTER_MAX_LENGTH")) != null) {
            MARKER_POINTER_MAX_LENGTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MARKER_STATE_STAYS_ON_TOP")) != null) {
            boolean bl8 = MARKER_STATE_STAYS_ON_TOP = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("MARKER_STATE_BORDER_WIDTH")) != null) {
            MARKER_STATE_BORDER_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MARKER_ARROW_BORDER_WIDTH")) != null) {
            MARKER_ARROW_BORDER_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MARKER_LINE_BORDER_WIDTH")) != null) {
            MARKER_LINE_BORDER_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("MARKER_EVENT_BORDER_WIDTH")) != null) {
            MARKER_EVENT_BORDER_WIDTH = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("HISTOGRAM_ZERO_ORIGIN")) != null) {
            boolean bl9 = HISTOGRAM_ZERO_ORIGIN = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("SUMMARY_STATE_BORDER")) != null) {
            SUMMARY_STATE_BORDER = StateBorder.parseString(string);
        }
        if ((string = properties.getProperty("SUMMARY_ARROW_LOG_BASE")) != null) {
            SUMMARY_ARROW_LOG_BASE = Integer.parseInt(string);
        }
        if ((string = properties.getProperty("LEGEND_PREVIEW_ORDER")) != null) {
            boolean bl10 = LEGEND_PREVIEW_ORDER = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if ((string = properties.getProperty("LEGEND_TOPOLOGY_ORDER")) != null) {
            LEGEND_TOPOLOGY_ORDER = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        System.out.println("Initialize Parameters: \n" + Parameters.toInOutString());
    }

    public static String toInOutString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Y_AXIS_ROOT_LABEL = " + Y_AXIS_ROOT_LABEL + "\n");
        stringBuffer.append("INIT_SLOG2_LEVEL_READ = " + INIT_SLOG2_LEVEL_READ + "\n");
        stringBuffer.append("AUTO_WINDOWS_LOCATION = " + AUTO_WINDOWS_LOCATION + "\n");
        stringBuffer.append("SCREEN_HEIGHT_RATIO = " + SCREEN_HEIGHT_RATIO + "\n");
        stringBuffer.append("TIME_SCROLL_UNIT_RATIO = " + TIME_SCROLL_UNIT_RATIO + "\n");
        stringBuffer.append("Y_AXIS_ROOT_VISIBLE = " + Y_AXIS_ROOT_VISIBLE + "\n");
        stringBuffer.append("ACTIVE_REFRESH = " + ACTIVE_REFRESH + "\n");
        stringBuffer.append("BACKGROUND_COLOR = " + BACKGROUND_COLOR + "\n");
        stringBuffer.append("STATE_HEIGHT_FACTOR = " + STATE_HEIGHT_FACTOR + "\n");
        stringBuffer.append("NESTING_HEIGHT_FACTOR = " + NESTING_HEIGHT_FACTOR + "\n");
        stringBuffer.append("ARROW_ANTIALIASING = " + ARROW_ANTIALIASING + "\n");
        stringBuffer.append("Y_AXIS_MIN_ROW_HEIGHT = " + Y_AXIS_MIN_ROW_HEIGHT + "\n");
        stringBuffer.append("MIN_WIDTH_TO_DRAG = " + MIN_WIDTH_TO_DRAG + "\n");
        stringBuffer.append("CLICK_RADIUS_TO_LINE = " + CLICK_RADIUS_TO_LINE + "\n");
        stringBuffer.append("LEFTCLICK_INSTANT_ZOOM = " + LEFTCLICK_INSTANT_ZOOM + "\n");
        stringBuffer.append("POPUP_BOX_MINIMAL_VIEW = " + POPUP_BOX_MINIMAL_VIEW + "\n");
        stringBuffer.append("LARGE_DURATION_FORMAT = " + LARGE_DURATION_FORMAT + "\n");
        stringBuffer.append("STATE_BORDER = " + STATE_BORDER + "\n");
        stringBuffer.append("ARROW_HEAD_LENGTH = " + ARROW_HEAD_LENGTH + "\n");
        stringBuffer.append("ARROW_HEAD_WIDTH = " + ARROW_HEAD_WIDTH + "\n");
        stringBuffer.append("EVENT_BASE_WIDTH = " + EVENT_BASE_WIDTH + "\n");
        stringBuffer.append("PREVIEW_STATE_DISPLAY = " + PREVIEW_STATE_DISPLAY + "\n");
        stringBuffer.append("PREVIEW_STATE_BORDER = " + PREVIEW_STATE_BORDER + "\n");
        stringBuffer.append("PREVIEW_STATE_BORDER_WIDTH = " + PREVIEW_STATE_BORDER_WIDTH + "\n");
        stringBuffer.append("PREVIEW_STATE_BORDER_HEIGHT = " + PREVIEW_STATE_BORDER_HEIGHT + "\n");
        stringBuffer.append("PREVIEW_STATE_LEGEND_HEIGHT = " + PREVIEW_STATE_LEGEND_HEIGHT + "\n");
        stringBuffer.append("PREVIEW_ARROW_LOG_BASE = " + PREVIEW_ARROW_LOG_BASE + "\n");
        stringBuffer.append("HIGHLIGHT_CLICKED_OBJECT = " + HIGHLIGHT_CLICKED_OBJECT + "\n");
        stringBuffer.append("POINTER_ON_CLICKED_OBJECT = " + POINTER_ON_CLICKED_OBJECT + "\n");
        stringBuffer.append("MARKER_POINTER_MIN_LENGTH = " + MARKER_POINTER_MIN_LENGTH + "\n");
        stringBuffer.append("MARKER_POINTER_MAX_LENGTH = " + MARKER_POINTER_MAX_LENGTH + "\n");
        stringBuffer.append("MARKER_STATE_STAYS_ON_TOP = " + MARKER_STATE_STAYS_ON_TOP + "\n");
        stringBuffer.append("MARKER_STATE_BORDER_WIDTH = " + MARKER_STATE_BORDER_WIDTH + "\n");
        stringBuffer.append("MARKER_ARROW_BORDER_WIDTH = " + MARKER_ARROW_BORDER_WIDTH + "\n");
        stringBuffer.append("MARKER_LINE_BORDER_WIDTH = " + MARKER_LINE_BORDER_WIDTH + "\n");
        stringBuffer.append("MARKER_EVENT_BORDER_WIDTH = " + MARKER_EVENT_BORDER_WIDTH + "\n");
        stringBuffer.append("HISTOGRAM_ZERO_ORIGIN = " + HISTOGRAM_ZERO_ORIGIN + "\n");
        stringBuffer.append("SUMMARY_STATE_BORDER = " + SUMMARY_STATE_BORDER + "\n");
        stringBuffer.append("SUMMARY_ARROW_LOG_BASE = " + SUMMARY_ARROW_LOG_BASE + "\n");
        stringBuffer.append("LEGEND_PREVIEW_ORDER = " + LEGEND_PREVIEW_ORDER + "\n");
        stringBuffer.append("LEGEND_TOPOLOGY_ORDER = " + LEGEND_TOPOLOGY_ORDER + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Parameters.initSetupFile();
        if (stringArray[0].trim().equals("write")) {
            Parameters.writeToSetupFile(null);
        }
        if (stringArray[0].trim().equals("read")) {
            Parameters.readFromSetupFile(null);
        }
    }
}

