/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.Coord_TimeRowID;
import base.drawable.DrawnBoxSet;
import base.drawable.InfoBox;
import base.drawable.NestingStacks;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.topology.MarkerState;
import base.topology.Pointer;
import cern.colt.map.OpenIntIntHashMap;
import java.awt.Graphics2D;
import java.awt.Point;

public abstract class Drawable
extends InfoBox {
    public static final float NON_NESTABLE = 1.0f;
    public static final int INVALID_ROW = Integer.MIN_VALUE;
    public static final Order INCRE_STARTTIME_ORDER = new Order(TimeBoundingBox.INCRE_STARTTIME_ORDER);
    public static final Order INCRE_FINALTIME_ORDER = new Order(TimeBoundingBox.INCRE_FINALTIME_ORDER);
    public static final Order DECRE_STARTTIME_ORDER = new Order(TimeBoundingBox.DECRE_STARTTIME_ORDER);
    public static final Order DECRE_FINALTIME_ORDER = new Order(TimeBoundingBox.DECRE_FINALTIME_ORDER);
    private double exclusion;
    private float nesting_ftr;
    private int row_ID;
    private Drawable parent;

    public Drawable() {
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Category category) {
        super(category);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public Drawable(Drawable drawable) {
        super(drawable);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = drawable.parent;
    }

    public Drawable(Category category, Drawable drawable) {
        super(category, drawable);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = drawable.parent;
    }

    public Drawable(int n, byte[] byArray) {
        super(n);
        super.setInfoBuffer(byArray);
        this.exclusion = 0.0;
        this.nesting_ftr = 1.0f;
        this.parent = null;
    }

    public void initExclusion(Object[] objectArray) {
        this.exclusion = super.getDuration();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            this.exclusion -= super.getIntersectionDuration((TimeBoundingBox)objectArray[i]);
        }
    }

    public void decrementExclusion(double d) {
        this.exclusion -= d;
    }

    public double getExclusion() {
        return this.exclusion;
    }

    public boolean isNestingFactorUninitialized() {
        return this.nesting_ftr == 1.0f;
    }

    public void setNestingFactor(float f) {
        this.nesting_ftr = f;
    }

    public float getNestingFactor() {
        return this.nesting_ftr;
    }

    public boolean isRowIDUninitialized() {
        return this.row_ID == Integer.MIN_VALUE;
    }

    public void setRowID(int n) {
        this.row_ID = n;
    }

    public int getRowID() {
        return this.row_ID;
    }

    public void setParent(Drawable drawable) {
        this.parent = drawable;
    }

    public Drawable getParent() {
        return this.parent;
    }

    public abstract int getNumOfPrimitives();

    public abstract Integer[] getArrayOfLineIDs();

    public abstract Coord getStartVertex();

    public abstract Coord getFinalVertex();

    public abstract int drawStateOnCanvas(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract int drawArrowOnCanvas(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract int drawEventOnCanvas(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, DrawnBoxSet var4, ColorAlpha var5);

    public abstract boolean isPixelInState(CoordPixelXform var1, OpenIntIntHashMap var2, Point var3);

    public abstract boolean isPixelOnArrow(CoordPixelXform var1, OpenIntIntHashMap var2, Point var3);

    public abstract boolean isPixelAtEvent(CoordPixelXform var1, OpenIntIntHashMap var2, Point var3);

    public abstract int drawStateOnViewport(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, ColorAlpha var4);

    public abstract int drawArrowOnViewport(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, ColorAlpha var4);

    public abstract int drawEventOnViewport(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3, ColorAlpha var4);

    public abstract boolean containSearchable();

    public abstract int drawSearchableOnViewport(Graphics2D var1, CoordPixelXform var2, OpenIntIntHashMap var3);

    private float getRowIDAtTimeOnEvent(OpenIntIntHashMap openIntIntHashMap, double d) {
        Coord coord = this.getStartVertex();
        return openIntIntHashMap.get(coord.lineID);
    }

    private float getRowIDAtTimeOnState(OpenIntIntHashMap openIntIntHashMap, double d) {
        Coord coord = this.getStartVertex();
        return openIntIntHashMap.get(coord.lineID);
    }

    private float getRowIDAtTimeOnArrow(OpenIntIntHashMap openIntIntHashMap, double d) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d2 = coord.time;
        double d3 = coord2.time;
        double d4 = openIntIntHashMap.get(coord.lineID);
        double d5 = openIntIntHashMap.get(coord2.lineID);
        boolean bl = false;
        double d6 = 0.0;
        if (d2 != d3) {
            d6 = (d5 - d4) / (d3 - d2);
        } else {
            bl = true;
            d6 = d4 != d5 ? (d5 > d4 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        double d7 = !bl ? d6 * (d - d2) + d4 : (d4 + d5) / 2.0;
        return (float)d7;
    }

    public float getRowIDAtTime(OpenIntIntHashMap openIntIntHashMap, double d) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            return this.getRowIDAtTimeOnEvent(openIntIntHashMap, d);
        }
        if (topology.isState()) {
            return this.getRowIDAtTimeOnState(openIntIntHashMap, d);
        }
        if (topology.isArrow()) {
            return this.getRowIDAtTimeOnArrow(openIntIntHashMap, d);
        }
        System.err.println("Non-recognized Primitive type! " + this);
        return 0.0f;
    }

    private int drawEventPointerOnViewport(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Coord_TimeRowID coord_TimeRowID) {
        ColorAlpha colorAlpha = super.getCategory().getColor();
        int n = Math.round(coord_TimeRowID.rowID);
        Pointer.drawLower(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, (float)n + 0.3f, 0);
        return 1;
    }

    private int drawStatePointerOnViewport(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Coord_TimeRowID coord_TimeRowID) {
        ColorAlpha colorAlpha = super.getCategory().getColor();
        int n = Math.round(coord_TimeRowID.rowID);
        float f = this.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        Pointer.drawUpper(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, f2, -MarkerState.Border_Width);
        Pointer.drawLower(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, f3, MarkerState.Border_Width);
        return 1;
    }

    private int drawArrowPointerOnViewport(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Coord_TimeRowID coord_TimeRowID) {
        ColorAlpha colorAlpha = super.getCategory().getColor();
        if (Math.abs(coord_TimeRowID.rowID - (float)((int)coord_TimeRowID.rowID)) < 0.01f) {
            Pointer.drawUpper(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, coord_TimeRowID.rowID - 0.3f, 0);
            Pointer.drawLower(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, coord_TimeRowID.rowID + 0.3f, 0);
        } else if (coord_TimeRowID.rowID - (float)Math.round(coord_TimeRowID.rowID) < 0.0f) {
            Pointer.drawUpper(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, coord_TimeRowID.rowID, 0);
        } else {
            Pointer.drawLower(graphics2D, colorAlpha, null, coordPixelXform, coord_TimeRowID.time, coord_TimeRowID.rowID, 0);
        }
        return 1;
    }

    public int drawPointerOnViewport(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Coord_TimeRowID coord_TimeRowID) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            return this.drawEventPointerOnViewport(graphics2D, coordPixelXform, coord_TimeRowID);
        }
        if (topology.isState()) {
            return this.drawStatePointerOnViewport(graphics2D, coordPixelXform, coord_TimeRowID);
        }
        if (topology.isArrow()) {
            return this.drawArrowPointerOnViewport(graphics2D, coordPixelXform, coord_TimeRowID);
        }
        System.err.println("Non-recognized Primitive type! " + this);
        return 0;
    }

    public void setStateRowAndNesting(CoordPixelXform coordPixelXform, OpenIntIntHashMap openIntIntHashMap, NestingStacks nestingStacks) {
        Coord coord = this.getStartVertex();
        this.row_ID = openIntIntHashMap.get(coord.lineID);
        this.nesting_ftr = nestingStacks.getNestingFactorFor(this);
    }

    public int drawOnCanvas(Graphics2D graphics2D, CoordPixelXform coordPixelXform, OpenIntIntHashMap openIntIntHashMap, DrawnBoxSet drawnBoxSet) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            return this.drawEventOnCanvas(graphics2D, coordPixelXform, openIntIntHashMap, drawnBoxSet, category.getColor());
        }
        if (topology.isState()) {
            return this.drawStateOnCanvas(graphics2D, coordPixelXform, openIntIntHashMap, drawnBoxSet, category.getColor());
        }
        if (topology.isArrow()) {
            return this.drawArrowOnCanvas(graphics2D, coordPixelXform, openIntIntHashMap, drawnBoxSet, category.getColor());
        }
        System.err.println("Non-recognized Primitive type! " + this);
        return 0;
    }

    public Drawable getDrawableAt(CoordPixelXform coordPixelXform, OpenIntIntHashMap openIntIntHashMap, Point point) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            if (this.isPixelAtEvent(coordPixelXform, openIntIntHashMap, point)) {
                return this;
            }
        } else if (topology.isState()) {
            if (this.isPixelInState(coordPixelXform, openIntIntHashMap, point)) {
                return this;
            }
        } else if (topology.isArrow()) {
            if (this.isPixelOnArrow(coordPixelXform, openIntIntHashMap, point)) {
                return this;
            }
        } else {
            System.err.println("Non-recognized Primitive type! " + this);
        }
        return null;
    }

    public int drawOnViewport(Graphics2D graphics2D, CoordPixelXform coordPixelXform, OpenIntIntHashMap openIntIntHashMap) {
        Category category = super.getCategory();
        Topology topology = category.getTopology();
        if (topology.isEvent()) {
            return this.drawEventOnViewport(graphics2D, coordPixelXform, openIntIntHashMap, category.getColor());
        }
        if (topology.isState()) {
            return this.drawStateOnViewport(graphics2D, coordPixelXform, openIntIntHashMap, category.getColor());
        }
        if (topology.isArrow()) {
            return this.drawArrowOnViewport(graphics2D, coordPixelXform, openIntIntHashMap, category.getColor());
        }
        System.err.println("Non-recognized Primitive type! " + this);
        return 0;
    }

    public static class Order
    implements TimeBoundingBox.Order {
        private TimeBoundingBox.Order timebox_order;

        public Order(TimeBoundingBox.Order order) {
            this.timebox_order = order;
        }

        public TimeBoundingBox.Order getTimeBoundingBoxOrder() {
            return this.timebox_order;
        }

        @Override
        public boolean isIncreasingTimeOrdered() {
            return this.timebox_order.isIncreasingTimeOrdered();
        }

        @Override
        public boolean isStartTimeOrdered() {
            return this.timebox_order.isStartTimeOrdered();
        }

        @Override
        public String toString() {
            return "Drawable." + ((Object)this.timebox_order).toString();
        }

        public int compare(Object object, Object object2) {
            int n;
            Drawable drawable = (Drawable)object;
            Drawable drawable2 = (Drawable)object2;
            int n2 = this.timebox_order.compare(drawable, drawable2);
            if (n2 != 0) {
                return n2;
            }
            if (drawable == drawable2) {
                return 0;
            }
            int n3 = drawable.getCategoryIndex();
            if (n3 != (n = drawable2.getCategoryIndex())) {
                return n3 - n;
            }
            int n4 = drawable.getStartVertex().lineID;
            int n5 = drawable2.getStartVertex().lineID;
            if (n4 != n5) {
                return n4 - n5;
            }
            n4 = drawable.getFinalVertex().lineID;
            n5 = drawable2.getFinalVertex().lineID;
            if (n4 != n5) {
                return n4 - n5;
            }
            System.err.println("Drawable.Order: WARNING! Equal Drawables?\n" + drawable + "\n" + drawable2);
            return 0;
        }
    }
}

