/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.CategoryTimeBox;
import base.statistics.CategoryWeightF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class TimeAveBox
extends TimeBoundingBox {
    private Map map_type2twgf = new HashMap();
    private List list_nestables;
    private SortedSet set_timeblocks;
    private CategoryTimeBox[] typebox_ary = null;
    private double num_real_objs = 0.0;
    private double box_duration = super.getDuration();
    private TimeBoundingBox curr_timebox = null;

    public TimeAveBox(TimeBoundingBox timeBoundingBox, boolean bl) {
        super(timeBoundingBox);
        if (bl) {
            this.list_nestables = new ArrayList();
            this.set_timeblocks = new TreeSet(TimeBoundingBox.INCRE_STARTTIME_ORDER);
        } else {
            this.list_nestables = null;
            this.set_timeblocks = null;
        }
    }

    public TimeAveBox(TimeAveBox timeAveBox) {
        this(timeAveBox, timeAveBox.list_nestables != null);
        this.mergeWithTimeAveBox(timeAveBox);
    }

    public void mergeWithReal(Drawable drawable) {
        double d = super.getIntersectionDuration(drawable);
        float f = (float)(d / this.box_duration);
        double d2 = d / drawable.getDuration() * (double)drawable.getNumOfPrimitives();
        Category category = drawable.getCategory();
        CategoryWeightF categoryWeightF = (CategoryWeightF)this.map_type2twgf.get(category);
        if (categoryWeightF == null) {
            categoryWeightF = new CategoryWeightF(category, f, 0.0f, d2);
            this.map_type2twgf.put(category, categoryWeightF);
        } else {
            categoryWeightF.addDrawableCount(d2);
            categoryWeightF.addInclusiveRatio(f);
        }
        this.num_real_objs += d2;
        if (this.list_nestables != null) {
            this.list_nestables.add(drawable);
        }
    }

    public void mergeWithShadow(Shadow shadow) {
        double d = super.getIntersectionDuration(shadow);
        float f = (float)(d / this.box_duration);
        double d2 = d / shadow.getDuration();
        double d3 = d2 * (double)shadow.getNumOfRealObjects();
        CategoryWeight[] categoryWeightArray = shadow.arrayOfCategoryWeights();
        for (int i = categoryWeightArray.length - 1; i >= 0; --i) {
            CategoryWeight categoryWeight = categoryWeightArray[i];
            Category category = categoryWeight.getCategory();
            CategoryWeightF categoryWeightF = (CategoryWeightF)this.map_type2twgf.get(category);
            if (categoryWeightF == null) {
                categoryWeightF = new CategoryWeightF(categoryWeight);
                categoryWeightF.rescaleAllRatios(f);
                categoryWeightF.rescaleDrawableCount(d2);
                this.map_type2twgf.put(category, categoryWeightF);
                continue;
            }
            categoryWeightF.addDrawableCount(d2 * (double)categoryWeight.getDrawableCount());
            categoryWeightF.addAllRatios(categoryWeight, f);
        }
        this.num_real_objs += d3;
        if (this.list_nestables != null) {
            this.set_timeblocks.add(shadow);
        }
    }

    public void mergeWithTimeAveBox(TimeAveBox timeAveBox) {
        double d = super.getIntersectionDuration(timeAveBox);
        float f = (float)(d / this.box_duration);
        double d2 = d / timeAveBox.getDuration();
        double d3 = d2 * timeAveBox.num_real_objs;
        for (CategoryWeightF categoryWeightF : timeAveBox.map_type2twgf.values()) {
            Category category = categoryWeightF.getCategory();
            CategoryWeightF categoryWeightF2 = (CategoryWeightF)this.map_type2twgf.get(category);
            if (categoryWeightF2 == null) {
                categoryWeightF2 = new CategoryWeightF(categoryWeightF);
                categoryWeightF2.rescaleAllRatios(f);
                categoryWeightF2.rescaleDrawableCount(d2);
                this.map_type2twgf.put(category, categoryWeightF2);
                continue;
            }
            categoryWeightF2.addDrawableCount(d2 * categoryWeightF.getDrawableCount());
            categoryWeightF2.addAllRatios(categoryWeightF, f);
        }
        this.num_real_objs += d3;
        if (this.list_nestables != null) {
            this.set_timeblocks.add(timeAveBox);
        }
    }

    public void rescaleAllRatios(float f) {
        for (CategoryWeightF categoryWeightF : this.map_type2twgf.values()) {
            categoryWeightF.rescaleAllRatios(f);
        }
    }

    private void patchSetOfTimeBlocks() {
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox timeBoundingBox2 = null;
        if (!this.set_timeblocks.isEmpty()) {
            timeBoundingBox2 = (TimeBoundingBox)this.set_timeblocks.first();
        }
        if (timeBoundingBox2 != null && timeBoundingBox2.contains(super.getEarliestTime())) {
            timeBoundingBox.setLatestTime(timeBoundingBox2.getEarliestTime());
        } else {
            timeBoundingBox.setLatestTime(super.getEarliestTime());
        }
        this.set_timeblocks.add(timeBoundingBox);
        timeBoundingBox = new TimeBoundingBox(TimeBoundingBox.ALL_TIMES);
        TimeBoundingBox timeBoundingBox3 = null;
        if (!this.set_timeblocks.isEmpty()) {
            timeBoundingBox3 = (TimeBoundingBox)this.set_timeblocks.last();
        }
        if (timeBoundingBox3 != null && timeBoundingBox3.contains(super.getLatestTime())) {
            timeBoundingBox.setEarliestTime(timeBoundingBox3.getLatestTime());
        } else {
            timeBoundingBox.setEarliestTime(super.getLatestTime());
        }
        this.set_timeblocks.add(timeBoundingBox);
    }

    private void setRealDrawableExclusion() {
        Object[] objectArray = this.set_timeblocks.toArray();
        Stack<Drawable> stack = new Stack<Drawable>();
        for (Drawable drawable : this.list_nestables) {
            drawable.initExclusion(objectArray);
            while (!stack.empty()) {
                Drawable drawable2 = (Drawable)stack.peek();
                if (drawable2.covers(drawable)) {
                    drawable2.decrementExclusion(drawable.getExclusion());
                    break;
                }
                stack.pop();
            }
            stack.push(drawable);
        }
        stack.clear();
        stack = null;
        objectArray = null;
        this.set_timeblocks.clear();
        this.set_timeblocks = null;
    }

    private void adjustMapOfCategoryWeightFs() {
        for (Drawable drawable : this.list_nestables) {
            float f = (float)(drawable.getExclusion() / this.box_duration);
            Category category = drawable.getCategory();
            CategoryWeightF categoryWeightF = (CategoryWeightF)this.map_type2twgf.get(category);
            categoryWeightF.addExclusiveRatio(f);
        }
        this.list_nestables.clear();
    }

    public void setNestingExclusion() {
        this.patchSetOfTimeBlocks();
        this.setRealDrawableExclusion();
        this.adjustMapOfCategoryWeightFs();
    }

    public double getAveNumOfRealObjects() {
        return this.num_real_objs;
    }

    public void initializeCategoryTimeBoxes() {
        if (this.typebox_ary == null) {
            this.typebox_ary = new CategoryTimeBox[this.map_type2twgf.size()];
            int n = 0;
            for (CategoryWeightF categoryWeightF : this.map_type2twgf.values()) {
                CategoryTimeBox categoryTimeBox;
                this.typebox_ary[n] = categoryTimeBox = new CategoryTimeBox(categoryWeightF);
                ++n;
            }
        }
    }

    public CategoryTimeBox[] arrayOfCategoryTimeBoxes() {
        return this.typebox_ary;
    }

    public TimeBoundingBox getCurrentTimeBoundingBox() {
        if (this.curr_timebox == null) {
            this.curr_timebox = new TimeBoundingBox();
        }
        return this.curr_timebox;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" Nrobjs=" + (float)this.num_real_objs);
        if (this.map_type2twgf.size() > 0) {
            CategoryWeightF[] categoryWeightFArray = this.map_type2twgf.values().toArray(new CategoryWeightF[0]);
            Arrays.sort(categoryWeightFArray, CategoryWeightF.INCL_RATIO_ORDER);
            int n = categoryWeightFArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\n" + categoryWeightFArray[i]);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

