/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MarkerArrow {
    private static int Head_Length = 20;
    private static int Head_Half_Width = 8;
    private static int layer_count = 3;
    private static Color[] colors;
    private static Stroke[] strokes;

    public static void setHeadAndBorderProperty(int n, int n2, int n3) {
        Head_Length = n;
        Head_Half_Width = n2 / 2;
        if (Head_Half_Width < 1) {
            Head_Half_Width = 1;
        }
        layer_count = n3;
        strokes = new Stroke[layer_count + 1];
        colors = new Color[layer_count + 1];
        MarkerArrow.colors[0] = Color.white;
        MarkerArrow.strokes[0] = new BasicStroke(1.0f, 1, 0);
        for (int i = 1; i <= layer_count; ++i) {
            MarkerArrow.colors[i] = i < layer_count ? colors[i - 1].darker().darker() : Color.white;
            MarkerArrow.strokes[i] = new BasicStroke(2 * i + 1, 1, 0);
        }
    }

    private static int drawForward(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        int n9 = coordPixelXform.getPixelWidth() - 1;
        int n10 = coordPixelXform.getPixelHeight() - 1;
        int n11 = coordPixelXform.convertTimeToPixel(d);
        int n12 = coordPixelXform.convertTimeToPixel(d2);
        int n13 = coordPixelXform.convertRowToPixel(f);
        int n14 = coordPixelXform.convertRowToPixel(f2);
        boolean bl3 = false;
        double d3 = 0.0;
        if (n11 != n12) {
            d3 = (double)(n14 - n13) / (double)(n12 - n11);
        } else {
            bl3 = true;
            d3 = n13 != n14 ? (n14 > n13 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        boolean bl4 = n11 >= 0;
        boolean bl5 = bl2 = n12 <= n9;
        if (bl4) {
            n8 = n11;
            n7 = n13;
        } else {
            if (bl3) {
                return 0;
            }
            n8 = 0;
            n7 = (int)Math.rint(d3 * (double)(n8 - n11) + (double)n13);
        }
        if (bl2) {
            n6 = n12;
            n5 = n14;
        } else {
            if (bl3) {
                return 0;
            }
            n6 = n9;
            n5 = (int)Math.rint(d3 * (double)(n6 - n12) + (double)n14);
        }
        boolean bl6 = n13 >= 0 && n13 <= n10;
        boolean bl7 = bl = n14 >= 0 && n14 <= n10;
        if (bl6) {
            n4 = n7;
            n3 = n8;
        } else {
            n4 = n13 < 0 ? 0 : n10;
            n3 = bl3 ? n8 : (int)Math.rint((double)(n4 - n7) / d3 + (double)n8);
        }
        if (bl) {
            n2 = n5;
            n = n6;
        } else {
            n2 = n14 < 0 ? 0 : n10;
            n = bl3 ? n6 : (int)Math.rint((double)(n2 - n5) / d3 + (double)n6);
        }
        if (n3 <= 0 && n <= 0 || n3 >= n9 && n >= n9 || n4 <= 0 && n2 <= 0 || n4 >= n10 && n2 >= n10) {
            return 0;
        }
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (bl2 && bl) {
            double d4;
            double d5;
            if (bl3) {
                if (d3 == Double.NaN) {
                    d5 = 1.0;
                    d4 = 0.0;
                } else if (d3 == Double.POSITIVE_INFINITY) {
                    d5 = 0.0;
                    d4 = 1.0;
                } else {
                    d5 = 0.0;
                    d4 = -1.0;
                }
            } else {
                d5 = 1.0 / Math.sqrt(1.0 + d3 * d3);
                d4 = d3 * d5;
            }
            double d6 = (double)n - (double)Head_Length * d5;
            double d7 = (double)n2 - (double)Head_Length * d4;
            double d8 = (double)Head_Half_Width * d4;
            double d9 = (double)Head_Half_Width * d5;
            n15 = (int)Math.round(d6 + d8);
            n16 = (int)Math.round(d7 - d9);
            n17 = (int)Math.round(d6 - d8);
            n18 = (int)Math.round(d7 + d9);
        }
        Stroke stroke2 = graphics2D.getStroke();
        for (int i = layer_count; i >= 1; --i) {
            graphics2D.setColor(colors[i]);
            graphics2D.setStroke(strokes[i]);
            graphics2D.drawLine(n3, n4, n, n2);
            if (!bl2 || !bl) continue;
            graphics2D.drawLine(n, n2, n15, n16);
            graphics2D.drawLine(n15, n16, n17, n18);
            graphics2D.drawLine(n17, n18, n, n2);
        }
        graphics2D.setColor(color);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.setStroke(stroke2);
        }
        graphics2D.drawLine(n3, n4, n, n2);
        if (bl2 && bl) {
            graphics2D.drawLine(n, n2, n15, n16);
            graphics2D.drawLine(n15, n16, n17, n18);
            graphics2D.drawLine(n17, n18, n, n2);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }

    private static int drawBackward(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        int n9 = coordPixelXform.getPixelWidth() - 1;
        int n10 = coordPixelXform.getPixelHeight() - 1;
        int n11 = coordPixelXform.convertTimeToPixel(d);
        int n12 = coordPixelXform.convertTimeToPixel(d2);
        int n13 = coordPixelXform.convertRowToPixel(f);
        int n14 = coordPixelXform.convertRowToPixel(f2);
        boolean bl3 = false;
        double d3 = 0.0;
        if (n11 != n12) {
            d3 = (double)(n13 - n14) / (double)(n11 - n12);
        } else {
            bl3 = true;
            d3 = n13 != n14 ? (n13 > n14 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        boolean bl4 = n11 <= n9;
        boolean bl5 = bl2 = n12 >= 0;
        if (bl4) {
            n8 = n11;
            n7 = n13;
        } else {
            if (bl3) {
                return 0;
            }
            n8 = n9;
            n7 = (int)Math.rint((double)n13 + d3 * (double)(n8 - n11));
        }
        if (bl2) {
            n6 = n12;
            n5 = n14;
        } else {
            if (bl3) {
                return 0;
            }
            n6 = 0;
            n5 = (int)Math.rint((double)n14 - d3 * (double)n12);
        }
        boolean bl6 = n13 >= 0 && n13 <= n10;
        boolean bl7 = bl = n14 >= 0 && n14 <= n10;
        if (bl6) {
            n4 = n7;
            n3 = n8;
        } else {
            n4 = n13 < 0 ? 0 : n10;
            n3 = bl3 ? n8 : (int)Math.rint((double)(n4 - n7) / d3 + (double)n8);
        }
        if (bl) {
            n2 = n5;
            n = n6;
        } else {
            n2 = n14 < 0 ? 0 : n10;
            n = bl3 ? n6 : (int)Math.rint((double)(n2 - n5) / d3 + (double)n6);
        }
        if (n3 <= 0 && n <= 0 || n3 >= n9 && n >= n9 || n4 <= 0 && n2 <= 0 || n4 >= n10 && n2 >= n10) {
            return 0;
        }
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (bl2 && bl) {
            double d4;
            double d5;
            if (bl3) {
                if (d3 == Double.NaN) {
                    d5 = -1.0;
                    d4 = 0.0;
                } else if (d3 == Double.POSITIVE_INFINITY) {
                    d5 = 0.0;
                    d4 = -1.0;
                } else {
                    d5 = 0.0;
                    d4 = 1.0;
                }
            } else {
                d5 = -1.0 / Math.sqrt(1.0 + d3 * d3);
                d4 = d3 * d5;
            }
            double d6 = (double)n - (double)Head_Length * d5;
            double d7 = (double)n2 - (double)Head_Length * d4;
            double d8 = (double)Head_Half_Width * d4;
            double d9 = (double)Head_Half_Width * d5;
            n15 = (int)Math.round(d6 + d8);
            n16 = (int)Math.round(d7 - d9);
            n17 = (int)Math.round(d6 - d8);
            n18 = (int)Math.round(d7 + d9);
        }
        Stroke stroke2 = graphics2D.getStroke();
        for (int i = layer_count; i >= 1; --i) {
            graphics2D.setColor(colors[i]);
            graphics2D.setStroke(strokes[i]);
            graphics2D.drawLine(n, n2, n3, n4);
            if (!bl2 || !bl) continue;
            graphics2D.drawLine(n, n2, n15, n16);
            graphics2D.drawLine(n15, n16, n17, n18);
            graphics2D.drawLine(n17, n18, n, n2);
        }
        graphics2D.setColor(color);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.setStroke(stroke2);
        }
        graphics2D.drawLine(n, n2, n3, n4);
        if (bl2 && bl) {
            graphics2D.drawLine(n, n2, n15, n16);
            graphics2D.drawLine(n15, n16, n17, n18);
            graphics2D.drawLine(n17, n18, n, n2);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }

    public static int draw(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        if (d < d2) {
            return MarkerArrow.drawForward(graphics2D, color, stroke, coordPixelXform, d, f, d2, f2);
        }
        return MarkerArrow.drawBackward(graphics2D, color, stroke, coordPixelXform, d, f, d2, f2);
    }
}

