/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MarkerEvent {
    private static int Base_Half_Width = 6;
    private static int Base_Width = 3;
    private static int layer_count = 3;
    private static Color[] colors;
    private static Stroke[] strokes;

    public static void setBaseAndBorderProperty(int n, int n2) {
        Base_Half_Width = n / 2;
        if (Base_Half_Width < 0) {
            Base_Half_Width = 0;
        }
        Base_Width = Base_Half_Width + Base_Half_Width;
        layer_count = n2;
        strokes = new Stroke[layer_count + 1];
        colors = new Color[layer_count + 1];
        MarkerEvent.colors[0] = Color.white;
        MarkerEvent.strokes[0] = new BasicStroke(1.0f, 1, 0);
        for (int i = 1; i <= layer_count; ++i) {
            MarkerEvent.colors[i] = i < layer_count ? colors[i - 1].darker() : Color.white;
            MarkerEvent.strokes[i] = new BasicStroke(2 * i + 1, 1, 0);
        }
    }

    public static int draw(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, float f2, float f3) {
        boolean bl;
        int n = coordPixelXform.convertTimeToPixel(d);
        int n2 = coordPixelXform.convertRowToPixel(f);
        boolean bl2 = n >= 0 && n < coordPixelXform.getPixelWidth();
        boolean bl3 = bl = n2 >= 0 && n2 < coordPixelXform.getPixelHeight();
        if (!bl2 || !bl) {
            return 0;
        }
        int n3 = coordPixelXform.convertRowToPixel(f2);
        int n4 = coordPixelXform.convertRowToPixel(f3);
        Stroke stroke2 = graphics2D.getStroke();
        int n5 = n - Base_Half_Width;
        int n6 = n2 - n3 + 1;
        for (int i = layer_count; i >= 1; --i) {
            graphics2D.setColor(colors[i]);
            graphics2D.setStroke(strokes[i]);
            graphics2D.drawLine(n, n2, n, n4);
            if (n2 != n4) {
                graphics2D.drawArc(n5, n3, Base_Width, n6, 0, 360);
                continue;
            }
            graphics2D.drawLine(n - Base_Half_Width, n3, n + Base_Half_Width, n3);
        }
        graphics2D.setColor(color);
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.setStroke(stroke2);
        }
        graphics2D.drawLine(n, n2, n, n4);
        if (n6 != 0) {
            graphics2D.fillArc(n5, n3, Base_Width, n6, 0, 360);
        }
        graphics2D.setColor(Color.white);
        if (n2 != n4) {
            graphics2D.drawArc(n5, n3, Base_Width, n6, 0, 360);
        } else {
            graphics2D.drawLine(n - Base_Half_Width, n3, n + Base_Half_Width, n3);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }
}

