/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class MarkerLine {
    private static int MLine_Count = 10;
    private static Stroke[][] MLine_Strokes = null;
    private static int MLine_ColorCount = 4;
    private static Color[] MLine_Colors = null;
    public static final int OPAQUE = 255;
    public static final int NEAR_OPAQUE = 191;
    public static final int HALF_OPAQUE = 127;
    public static final int NEAR_TRANSPARENT = 63;
    public static final int TRANSPARENT = 0;

    public static void setProperty(int n) {
        int n2;
        MLine_ColorCount = n;
        MLine_Strokes = new Stroke[MLine_Count][MLine_ColorCount];
        for (n2 = 0; n2 < MLine_Count; ++n2) {
            for (int i = 0; i < MLine_ColorCount; ++i) {
                float f = 2.0f * (float)(i + 1) + (float)(n2 + 1);
                MarkerLine.MLine_Strokes[n2][i] = new BasicStroke(f, 1, 0);
            }
        }
        MLine_Colors = new Color[MLine_ColorCount];
        MarkerLine.MLine_Colors[0] = Color.yellow.darker();
        for (n2 = 1; n2 < MLine_ColorCount; ++n2) {
            MarkerLine.MLine_Colors[n2] = MLine_Colors[n2 - 1].darker();
        }
    }

    private static int drawForward(Graphics2D graphics2D, Color color, BasicStroke basicStroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl2;
        int n9 = coordPixelXform.getPixelWidth() - 1;
        int n10 = coordPixelXform.getPixelHeight() - 1;
        int n11 = coordPixelXform.convertTimeToPixel(d);
        int n12 = coordPixelXform.convertTimeToPixel(d2);
        int n13 = coordPixelXform.convertRowToPixel(f);
        int n14 = coordPixelXform.convertRowToPixel(f2);
        boolean bl3 = false;
        double d3 = 0.0;
        if (n11 != n12) {
            d3 = (double)(n14 - n13) / (double)(n12 - n11);
        } else {
            bl3 = true;
            d3 = n13 != n14 ? (n14 > n13 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NaN;
        }
        boolean bl4 = n11 >= 0;
        boolean bl5 = bl2 = n12 <= n9;
        if (bl4) {
            n8 = n11;
            n7 = n13;
        } else {
            if (bl3) {
                return 0;
            }
            n8 = 0;
            n7 = (int)Math.rint(d3 * (double)(n8 - n11) + (double)n13);
        }
        if (bl2) {
            n6 = n12;
            n5 = n14;
        } else {
            if (bl3) {
                return 0;
            }
            n6 = n9;
            n5 = (int)Math.rint(d3 * (double)(n6 - n12) + (double)n14);
        }
        boolean bl6 = n13 >= 0 && n13 <= n10;
        boolean bl7 = bl = n14 >= 0 && n14 <= n10;
        if (bl6) {
            n4 = n7;
            n3 = n8;
        } else {
            n4 = n13 < 0 ? 0 : n10;
            n3 = bl3 ? n8 : (int)Math.rint((double)(n4 - n7) / d3 + (double)n8);
        }
        if (bl) {
            n2 = n5;
            n = n6;
        } else {
            n2 = n14 < 0 ? 0 : n10;
            n = bl3 ? n6 : (int)Math.rint((double)(n2 - n5) / d3 + (double)n6);
        }
        if (n3 <= 0 && n <= 0 || n3 >= n9 && n >= n9 || n4 <= 0 && n2 <= 0 || n4 >= n10 && n2 >= n10) {
            return 0;
        }
        Stroke stroke = graphics2D.getStroke();
        int n15 = basicStroke != null ? (int)basicStroke.getLineWidth() : (int)((BasicStroke)stroke).getLineWidth();
        for (int i = MLine_ColorCount - 1; i >= 1; --i) {
            graphics2D.setColor(MLine_Colors[i]);
            graphics2D.setStroke(MLine_Strokes[n15][i]);
            graphics2D.drawLine(n3, n4, n, n2);
        }
        graphics2D.setColor(color);
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        } else {
            graphics2D.setStroke(stroke);
        }
        graphics2D.drawLine(n3, n4, n, n2);
        if (basicStroke != null) {
            graphics2D.setStroke(stroke);
        }
        return 1;
    }

    public static int draw(Graphics2D graphics2D, Color color, BasicStroke basicStroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        if (d < d2) {
            return MarkerLine.drawForward(graphics2D, color, basicStroke, coordPixelXform, d, f, d2, f2);
        }
        return MarkerLine.drawForward(graphics2D, color, basicStroke, coordPixelXform, d2, f2, d, f);
    }
}

