/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class Pointer {
    private static final int POINTER_HALF_ANGLE_DEG = 20;
    private static final double POINTER_HALF_ANGLE_RAD = 0.3490658503988659;
    private static final double COS_POINTER_HALF_ANGLE = Math.cos(0.3490658503988659);
    private static final double SIN_POINTER_HALF_ANGLE = Math.sin(0.3490658503988659);
    private static int Pointer_Min_Length = 20;
    private static int Pointer_Max_Length = 40;

    public static void setProperty(int n, int n2) {
        Pointer_Min_Length = n;
        Pointer_Max_Length = n2;
    }

    public static int drawUpper(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, int n) {
        boolean bl;
        int n2 = coordPixelXform.convertTimeToPixel(d);
        int n3 = coordPixelXform.convertRowToPixel(f) + n;
        int n4 = coordPixelXform.convertRowToPixel((float)Math.round(f) - 0.5f);
        boolean bl2 = n2 >= 0 && n2 < coordPixelXform.getPixelWidth();
        boolean bl3 = bl = n3 >= 0 && n3 < coordPixelXform.getPixelHeight();
        if (!bl2 || !bl) {
            return 0;
        }
        Color color2 = color.brighter().brighter();
        Color color3 = color.darker().darker();
        int n5 = n3 - n4 + 1;
        if (n5 > Pointer_Max_Length) {
            n5 = Pointer_Max_Length;
        }
        if (n5 < Pointer_Min_Length) {
            n5 = Pointer_Min_Length;
        }
        int n6 = 2 * n5;
        int n7 = (int)((double)n5 * SIN_POINTER_HALF_ANGLE + 0.5);
        int n8 = (int)((double)n5 * COS_POINTER_HALF_ANGLE + 0.5);
        Stroke stroke2 = null;
        if (stroke != null) {
            stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
        }
        graphics2D.setColor(color3);
        graphics2D.fillArc(n2 - n5, n3 - n5, n6, n6, 90, -20);
        graphics2D.setColor(color2);
        graphics2D.fillArc(n2 - n5, n3 - n5, n6, n6, 90, 20);
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(n2, n3 - n5, n2 - n7, n3 - n8);
        graphics2D.drawLine(n2, n3, n2 - n7, n3 - n8);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(n2, n3 - n5, n2 + n7, n3 - n8);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(n2, n3, n2 + n7, n3 - n8);
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }

    public static int drawLower(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, int n) {
        boolean bl;
        int n2 = coordPixelXform.convertTimeToPixel(d);
        int n3 = coordPixelXform.convertRowToPixel(f) + n;
        int n4 = coordPixelXform.convertRowToPixel((float)Math.round(f) + 0.5f);
        boolean bl2 = n2 >= 0 && n2 < coordPixelXform.getPixelWidth();
        boolean bl3 = bl = n3 >= 0 && n3 < coordPixelXform.getPixelHeight();
        if (!bl2 || !bl) {
            return 0;
        }
        Color color2 = color.brighter().brighter();
        Color color3 = color.darker().darker();
        int n5 = n4 - n3 + 1;
        if (n5 > Pointer_Max_Length) {
            n5 = Pointer_Max_Length;
        }
        if (n5 < Pointer_Min_Length) {
            n5 = Pointer_Min_Length;
        }
        int n6 = 2 * n5;
        int n7 = (int)((double)n5 * SIN_POINTER_HALF_ANGLE + 0.5);
        int n8 = (int)((double)n5 * COS_POINTER_HALF_ANGLE + 0.5);
        Stroke stroke2 = null;
        if (stroke != null) {
            stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
        }
        graphics2D.setColor(color2);
        graphics2D.fillArc(n2 - n5, n3 - n5, n6, n6, 270, -20);
        graphics2D.setColor(color3);
        graphics2D.fillArc(n2 - n5, n3 - n5, n6, n6, 270, 20);
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(n2, n3, n2 - n7, n3 + n8);
        graphics2D.drawLine(n2, n3 + n5, n2 - n7, n3 + n8);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(n2, n3, n2 + n7, n3 + n8);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(n2, n3 + n5, n2 + n7, n3 + n8);
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }
}

