/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import viewer.common.Const;
import viewer.common.Parameters;
import viewer.common.PreferencePanel;
import viewer.common.Routines;
import viewer.common.TopWindow;

public class PreferenceFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1600L;
    private PreferencePanel pptys_panel;
    private JButton update_btn;
    private JButton save_btn;
    private JButton close_btn;

    public PreferenceFrame() {
        super("Preferences");
        super.setDefaultCloseOperation(0);
        TopWindow.Preference.disposeAll();
        TopWindow.Preference.setWindow(this);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        this.pptys_panel = new PreferencePanel();
        this.pptys_panel.updateAllFieldsFromParameters();
        this.pptys_panel.addSelfActionListeners();
        JScrollPane jScrollPane = new JScrollPane(this.pptys_panel);
        Dimension dimension = Routines.getScreenSize();
        jScrollPane.setMinimumSize(new Dimension(100, 100));
        jScrollPane.setMaximumSize(new Dimension(dimension.width / 2, dimension.height * 4 / 5));
        jScrollPane.setPreferredSize(new Dimension(this.pptys_panel.getPreferredSize().width * 10 / 9, dimension.height * 3 / 5));
        container.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        URL uRL = this.getURL("/images/SaveAll24.gif");
        this.save_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Save");
        this.save_btn.setMargin(Const.SQ_BTN2_INSETS);
        this.save_btn.setToolTipText("Save preference to Jumpshot-4 setup file");
        this.save_btn.setAlignmentX(0.0f);
        this.save_btn.addActionListener(this);
        jPanel.add(this.save_btn);
        jPanel.add(Box.createHorizontalGlue());
        uRL = this.getURL("/images/Stop24.gif");
        this.close_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Close");
        this.close_btn.setMargin(Const.SQ_BTN2_INSETS);
        this.close_btn.setToolTipText("Close this window");
        this.close_btn.setAlignmentX(1.0f);
        this.close_btn.addActionListener(this);
        jPanel.add(this.close_btn);
        jPanel.add(Box.createHorizontalGlue());
        container.add(jPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreferenceFrame.this.setVisible(false);
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        TopWindow.Control.setEditPreferenceButtonEnabled(!bl);
    }

    public void updateAllParametersFromFields() {
        this.pptys_panel.updateAllParametersFromFields();
    }

    public void updateAllFieldsFromParameters() {
        this.pptys_panel.updateAllFieldsFromParameters();
    }

    protected URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.save_btn) {
            this.pptys_panel.updateAllParametersFromFields();
            Parameters.initStaticClasses();
            Parameters.writeToSetupFile(this);
        } else if (actionEvent.getSource() == this.close_btn) {
            this.setVisible(false);
        }
    }
}

