/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeFormat {
    public static final String LARGE_DURATION_AUTO = "hr, min, or sec";
    private static final int LARGE_DURATION_AUTO_ID = 0;
    public static final String LARGE_DURATION_HHMMSS = "HH:MM:SS";
    private static final int LARGE_DURATION_HHMMSS_ID = 1;
    public static final String LARGE_DURATION_SEC = "sec";
    private static final int LARGE_DURATION_SEC_ID = 2;
    private static int LargeDurationFormat = 2;
    private static final double[] LIMITS = new double[]{Double.NEGATIVE_INFINITY, 0.0, 1.0E-10, 1.0E-7, 1.0E-4, 0.1, 300.0, 9000.0};
    private static final String[] UNITS = new String[]{"-ve", "ps", "ns", "us", "ms", "s", "min", "hr"};
    private static final String PATTERN = "#,##0.00###";
    private DecimalFormat decfmt = (DecimalFormat)NumberFormat.getInstance();
    private ChoiceFormat unitfmt = null;

    public static void setLargeDurationFormat(String string) {
        LargeDurationFormat = string.equals(LARGE_DURATION_AUTO) ? 0 : (string.equals(LARGE_DURATION_HHMMSS) ? 1 : (string.equals(LARGE_DURATION_SEC) ? 2 : 2));
    }

    public TimeFormat() {
        this.decfmt.applyPattern(PATTERN);
        this.unitfmt = new ChoiceFormat(LIMITS, UNITS);
    }

    private static final String HH_MM_SS(double d) {
        long l = (long)Math.floor(d / 3600.0);
        double d2 = d % 3600.0;
        long l2 = (long)Math.floor(d2 / 60.0);
        long l3 = Math.round(d2 % 60.0);
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 10L) {
            stringBuffer.append("0");
        }
        stringBuffer.append(l + ":");
        if (l2 < 10L) {
            stringBuffer.append("0");
        }
        stringBuffer.append(l2 + ":");
        if (l3 < 10L) {
            stringBuffer.append("0");
        }
        stringBuffer.append(l3);
        return stringBuffer.toString();
    }

    public String format(double d) {
        String string = this.unitfmt.format(Math.abs(d));
        if (string.equals("hr")) {
            switch (LargeDurationFormat) {
                case 0: {
                    return this.decfmt.format(d / 3600.0) + " hr";
                }
                case 1: {
                    return TimeFormat.HH_MM_SS(d);
                }
            }
            return this.decfmt.format(d) + " sec";
        }
        if (string.equals("min")) {
            switch (LargeDurationFormat) {
                case 0: {
                    return this.decfmt.format(d / 60.0) + " min";
                }
                case 1: {
                    return TimeFormat.HH_MM_SS(d);
                }
            }
            return this.decfmt.format(d) + " sec";
        }
        if (string.equals("s")) {
            return this.decfmt.format(d) + " sec";
        }
        if (string.equals("ms")) {
            return this.decfmt.format(d * 1000.0) + " msec";
        }
        if (string.equals("us")) {
            return this.decfmt.format(d * 1000000.0) + " usec";
        }
        if (string.equals("ns")) {
            return this.decfmt.format(d * 1.0E9) + " nsec";
        }
        if (string.equals("ps")) {
            return this.decfmt.format(d * 1.0E12) + " psec";
        }
        return this.decfmt.format(d) + " sec";
    }
}

