/*
 * Decompiled with CFR 0.152.
 */
package viewer.first;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.common.TopWindow;

public class HTMLviewer
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = 14000L;
    private JTextField input_fld;
    private JEditorPane html_panel;
    private JButton init_btn;
    private JButton backward_btn;
    private JButton forward_btn;
    private JButton refresh_btn;
    private JButton close_btn;
    private Stack url_undo_stack;
    private Stack url_redo_stack;

    public HTMLviewer(String string) {
        super(TopWindow.First.getWindow());
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setTitle("HTML viewer");
        }
        super.setSize(600, 400);
        super.setBackground(Color.gray);
        super.getContentPane().setLayout(new BorderLayout());
        this.url_undo_stack = new Stack();
        this.url_redo_stack = new Stack();
        super.getContentPane().add((Component)this.createToolBar(), "North");
        int n = 400;
        int n2 = 25;
        Dimension dimension = new Dimension(0, n2);
        Dimension dimension2 = new Dimension(Short.MAX_VALUE, n2);
        Dimension dimension3 = new Dimension(n, n2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel("    URL : ");
        jPanel2.add(jLabel);
        this.input_fld = new JTextField();
        this.input_fld.setMinimumSize(dimension);
        this.input_fld.setMaximumSize(dimension2);
        this.input_fld.setPreferredSize(dimension3);
        jPanel2.add(this.input_fld);
        jPanel.add(jPanel2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.html_panel = new JEditorPane();
        this.html_panel.setEditable(false);
        jScrollPane.getViewport().add(this.html_panel);
        jPanel.add(jScrollPane);
        super.getContentPane().add((Component)jPanel, "Center");
        this.input_fld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HTMLviewer.this.refresh_btn.doClick();
            }
        });
        this.html_panel.addHyperlinkListener(this);
        this.init_btn = null;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HTMLviewer.this.setVisible(false);
            }
        });
    }

    public HTMLviewer(String string, JButton jButton) {
        this(string);
        this.init_btn = jButton;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.init_btn != null) {
            this.init_btn.setEnabled(!bl);
        }
    }

    public void init(URL uRL) {
        URL uRL2 = uRL;
        if (uRL2 != null) {
            this.input_fld.setText(uRL2.toString());
            this.refresh_btn.doClick();
        }
    }

    protected URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        Dimension dimension = new Dimension(5, 5);
        Dimension dimension2 = new Dimension(10, 5);
        Dimension dimension3 = new Dimension(20, 5);
        URL uRL = this.getURL("/images/Backward24.gif");
        this.backward_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Backward");
        this.backward_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.backward_btn.setToolTipText("Go Backward one page");
        this.backward_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HTMLviewer.this.url_undo_stack.empty()) {
                    HTMLviewer.this.updateURLStack(HTMLviewer.this.url_redo_stack);
                    URL uRL = (URL)HTMLviewer.this.url_undo_stack.pop();
                    HTMLviewer.this.input_fld.setText(uRL.toString());
                    HTMLviewer.this.refresh_btn.doClick();
                }
            }
        });
        jToolBar.add(this.backward_btn);
        jToolBar.addSeparator(dimension);
        uRL = this.getURL("/images/Forward24.gif");
        this.forward_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Forward");
        this.forward_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.forward_btn.setToolTipText("Go Forward one page");
        this.forward_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HTMLviewer.this.url_redo_stack.empty()) {
                    HTMLviewer.this.updateURLStack(HTMLviewer.this.url_undo_stack);
                    URL uRL = (URL)HTMLviewer.this.url_redo_stack.pop();
                    HTMLviewer.this.input_fld.setText(uRL.toString());
                    HTMLviewer.this.refresh_btn.doClick();
                }
            }
        });
        jToolBar.add(this.forward_btn);
        jToolBar.addSeparator(dimension2);
        uRL = this.getURL("/images/Refresh24.gif");
        this.refresh_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Refresh");
        this.refresh_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.refresh_btn.setToolTipText("Refresh the current page");
        this.refresh_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL = null;
                try {
                    uRL = new URL(HTMLviewer.this.input_fld.getText());
                    HTMLviewer.this.html_panel.setPage(uRL);
                }
                catch (IOException iOException) {
                    Dialogs.error(HTMLviewer.this, "Invalid URL: " + uRL.toString());
                }
            }
        });
        jToolBar.add(this.refresh_btn);
        jToolBar.addSeparator(dimension3);
        uRL = this.getURL("/images/Stop24.gif");
        this.close_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Close");
        this.close_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.close_btn.setToolTipText("Close the HTMLviewer window");
        this.close_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HTMLviewer.this.setVisible(false);
            }
        });
        jToolBar.add(this.close_btn);
        return jToolBar;
    }

    private void updateURLStack(Stack stack) {
        String string = this.input_fld.getText();
        if (string != null) {
            try {
                URL uRL = new URL(string);
                stack.push(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Dialogs.error(this, "Malformed URL " + string);
            }
        }
    }

    @Override
    public void hyperlinkUpdate(final HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.html_panel.setCursor(new Cursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Document document = HTMLviewer.this.html_panel.getDocument();
                    URL uRL = null;
                    try {
                        uRL = hyperlinkEvent.getURL();
                        if (uRL != null) {
                            HTMLviewer.this.updateURLStack(HTMLviewer.this.url_undo_stack);
                            HTMLviewer.this.input_fld.setText(uRL.toString());
                            HTMLviewer.this.html_panel.setPage(uRL);
                        } else {
                            Dialogs.error(HTMLviewer.this, "Invalid Link: NULL pointer!");
                            HTMLviewer.this.html_panel.setDocument(document);
                        }
                    }
                    catch (IOException iOException) {
                        Dialogs.error(HTMLviewer.this, "Invalid Link: " + uRL.toString());
                    }
                    HTMLviewer.this.html_panel.setCursor(new Cursor(0));
                }
            });
        }
    }

    public static void main(String[] stringArray) {
        URL uRL = ClassLoader.getSystemResource("doc/html/index.html");
        HTMLviewer hTMLviewer = new HTMLviewer(null);
        hTMLviewer.init(uRL);
        hTMLviewer.setVisible(true);
    }
}

