/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import base.statistics.Summarizable;
import cern.colt.map.OpenIntIntHashMap;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Date;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.histogram.InfoDialogForSummary;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.Profile;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class CanvasStatline
extends ScrollableObject {
    private static final long serialVersionUID = 12400L;
    private BufForTimeAveBoxes buf4statboxes;
    private YaxisMaps y_maps;
    private YaxisTree tree_view;
    private BoundedRangeModel y_model;
    private String[] y_colnames;
    private Dialog root_dialog;
    private TimeBoundingBox timeframe4imgs;
    private ChangeListener change_listener;
    private ChangeEvent change_event;
    private int num_rows;
    private int row_height;
    private OpenIntIntHashMap map_line2row;
    private Date zero_time;
    private Date init_time;
    private Date final_time;

    public CanvasStatline(ModelTime modelTime, BufForTimeAveBoxes bufForTimeAveBoxes, BoundedRangeModel boundedRangeModel, YaxisMaps yaxisMaps, String[] stringArray) {
        super(modelTime);
        this.buf4statboxes = bufForTimeAveBoxes;
        this.y_maps = yaxisMaps;
        this.tree_view = this.y_maps.getTreeView();
        this.y_model = boundedRangeModel;
        this.y_colnames = stringArray;
        this.map_line2row = null;
        this.timeframe4imgs = null;
        this.root_dialog = null;
        this.change_event = null;
        this.change_listener = null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.change_event = new ChangeEvent(this);
        this.change_listener = changeListener;
    }

    @Override
    public Dimension getMinimumSize() {
        int n = 0;
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: min_size = (0," + n + ")");
        }
        return new Dimension(0, n);
    }

    @Override
    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: max_size = (32767,32767)");
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public int getJComponentHeight() {
        int n = this.tree_view.getRowCount() * this.tree_view.getRowHeight();
        int n2 = this.y_model.getMaximum() - this.y_model.getMinimum() + 1;
        if (n2 > n) {
            return n2;
        }
        return n;
    }

    private void fireChangeEvent() {
        if (this.change_event != null) {
            this.change_listener.stateChanged(this.change_event);
        }
    }

    @Override
    protected void initializeAllOffImages(TimeBoundingBox timeBoundingBox) {
        if (Profile.isActive()) {
            this.zero_time = new Date();
        }
        if (this.root_dialog == null) {
            this.root_dialog = (Dialog)SwingUtilities.windowForComponent(this);
        }
        if (this.timeframe4imgs == null) {
            this.timeframe4imgs = new TimeBoundingBox(timeBoundingBox);
        }
        Routines.setComponentAndChildrenCursors(this.root_dialog, CustomCursor.Wait);
        this.num_rows = this.tree_view.getRowCount();
        this.row_height = this.tree_view.getRowHeight();
        if (Profile.isActive()) {
            this.init_time = new Date();
        }
        this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (this.map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(this.root_dialog, "Error in updating YaxisMaps!");
            }
            this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
    }

    @Override
    protected void finalizeAllOffImages(TimeBoundingBox timeBoundingBox) {
        this.map_line2row = null;
        this.timeframe4imgs.setEarliestTime(timeBoundingBox.getEarliestTime());
        this.timeframe4imgs.setLatestTime(timeBoundingBox.getLatestTime());
        this.fireChangeEvent();
        Routines.setComponentAndChildrenCursors(this.root_dialog, CustomCursor.Normal);
        if (Profile.isActive()) {
            this.final_time = new Date();
        }
        if (Profile.isActive()) {
            Profile.println("CanvasStatline.finalizeAllOffImages(): init. time = " + (this.init_time.getTime() - this.zero_time.getTime()) + " msec.,   total time = " + (this.final_time.getTime() - this.zero_time.getTime()) + " msec.");
        }
    }

    @Override
    protected void drawOneOffImage(Image image, TimeBoundingBox timeBoundingBox) {
        if (Debug.isActive()) {
            Debug.println("CanvasStatline: drawOneOffImage()'s offImage = " + image);
        }
        if (image != null) {
            int n;
            int n2;
            int n3 = image.getWidth(this);
            int n4 = image.getHeight(this);
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            Color color = (Color)Parameters.BACKGROUND_COLOR.toValue();
            graphics2D.setPaint(color);
            graphics2D.fillRect(0, 0, n3, n4);
            CoordPixelImage coordPixelImage = new CoordPixelImage(this, this.row_height, timeBoundingBox);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (this.tree_view.isRootVisible()) {
                graphics2D.setColor(Color.red);
                n2 = 0;
                n = coordPixelImage.convertRowToPixel(n2);
                graphics2D.drawLine(0, n, n3 - 1, n);
            }
            graphics2D.setColor(Color.cyan);
            for (n2 = 0; n2 < this.num_rows; ++n2) {
                if (this.tree_view.isExpanded(n2)) continue;
                n = coordPixelImage.convertRowToPixel(n2);
                graphics2D.drawLine(0, n, n3 - 1, n);
            }
            if (Debug.isActive() || Profile.isActive()) {
                graphics2D.setColor(Color.gray);
                graphics2D.drawLine(0, 0, 0, this.getHeight());
            }
            this.buf4statboxes.initializeDrawing(this.map_line2row, color, this.tree_view.isRootVisible(), Parameters.HISTOGRAM_ZERO_ORIGIN, Parameters.STATE_HEIGHT_FACTOR, Parameters.NESTING_HEIGHT_FACTOR);
            int n5 = 0;
            int n6 = 0;
            n5 = this.buf4statboxes.drawAllStates(graphics2D, coordPixelImage);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Parameters.ARROW_ANTIALIASING.toValue());
            n6 = this.buf4statboxes.drawAllArrows(graphics2D, coordPixelImage);
            if (Profile.isActive()) {
                Profile.println("CanvasStatline.drawOneOffImage(): N_NestAble = " + n5 + ",  " + "R_NestLess = " + n6);
            }
            graphics2D.dispose();
        }
    }

    @Override
    public InfoDialog getPropertyAt(Point point, TimeBoundingBox timeBoundingBox) {
        CoordPixelImage coordPixelImage = new CoordPixelImage(this, this.row_height, super.getTimeBoundsOfImages());
        double d = coordPixelImage.convertPixelToTime(point.x);
        Summarizable summarizable = this.buf4statboxes.getSummarizableAt(coordPixelImage, point);
        if (summarizable != null) {
            return new InfoDialogForSummary(this.root_dialog, d, this.tree_view, this.y_colnames, summarizable);
        }
        return super.getTimePropertyAt(point);
    }
}

