/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import logformat.slog2.LineIDMap;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.histogram.CanvasStatline;
import viewer.histogram.StatBoxStatusPanel;
import viewer.histogram.StatlineToolBar;
import viewer.histogram.SummaryStateComboBox;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ModelTimePanel;
import viewer.zoomable.RowAdjustments;
import viewer.zoomable.RulerTime;
import viewer.zoomable.ScrollbarTime;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.ViewportTimePanel;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class StatlinePanel
extends JPanel {
    private static final long serialVersionUID = 12700L;
    private Window root_window;
    private TimeBoundingBox timebox;
    private BufForTimeAveBoxes buf4statboxes;
    private StatlineToolBar toolbar;
    private StatBoxStatusPanel status_panel;
    private BoundedRangeModel y_model;
    private YaxisMaps y_maps;
    private YaxisTree y_tree;
    private JScrollPane y_scroller;
    private JScrollBar y_scrollbar;
    private ModelTime time_model;
    private ScrollbarTime time_scrollbar;
    private ModelTimePanel time_display_panel;
    private RulerTime time_ruler;
    private ViewportTime time_ruler_vport;
    private ViewportTimePanel time_ruler_panel;
    private CanvasStatline stat_canvas;
    private ViewportTimeYaxis stat_canvas_vport;
    private ViewportTimePanel stat_canvas_panel;
    private SummaryStateComboBox summary_state_combobox;
    private RowAdjustments row_adjs;
    private String err_msg;

    public StatlinePanel(Window window, TimeBoundingBox timeBoundingBox, LineIDMap lineIDMap, BufForTimeAveBoxes bufForTimeAveBoxes) {
        this.root_window = window;
        this.timebox = timeBoundingBox;
        this.buf4statboxes = bufForTimeAveBoxes;
        String[] stringArray = lineIDMap.getColumnLabels();
        this.y_maps = new YaxisMaps(lineIDMap);
        this.y_tree = new YaxisTree(this.y_maps.getTreeRoot());
        this.y_maps.setTreeView(this.y_tree);
        this.y_scroller = new JScrollPane(this.y_tree, 22, 32);
        this.y_scrollbar = this.y_scroller.getVerticalScrollBar();
        this.y_model = this.y_scrollbar.getModel();
        this.time_model = Parameters.HISTOGRAM_ZERO_ORIGIN ? new ModelTime(this.root_window, 0.0, this.timebox.getDuration()) : new ModelTime(this.root_window, this.timebox.getEarliestTime(), this.timebox.getLatestTime());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.time_ruler = new RulerTime(this.time_model);
        this.time_ruler_vport = new ViewportTime(this.time_model);
        this.time_ruler_vport.setView(this.time_ruler);
        this.time_ruler_panel = new ViewportTimePanel(this.time_ruler_vport);
        if (Parameters.HISTOGRAM_ZERO_ORIGIN) {
            this.time_ruler_panel.setBorderTitle(" Duration (seconds) ", 3, 5, Const.FONT, Color.red);
        } else {
            this.time_ruler_panel.setBorderTitle(" Time (seconds) ", 3, 5, Const.FONT, Color.red);
        }
        this.time_ruler_vport.initLeftMouseToZoom(false);
        this.time_model.addTimeListener(this.time_ruler_vport);
        Insets insets = this.time_ruler_panel.getInsets();
        int n = insets.top + this.time_ruler.getJComponentHeight() + insets.bottom;
        this.time_ruler_panel.setPreferredSize(new Dimension(100, n));
        this.stat_canvas = new CanvasStatline(this.time_model, this.buf4statboxes, this.y_model, this.y_maps, stringArray);
        this.stat_canvas_vport = new ViewportTimeYaxis(this.time_model, this.y_scrollbar, this.y_maps);
        this.stat_canvas_vport.setView(this.stat_canvas);
        this.stat_canvas_panel = new ViewportTimePanel(this.stat_canvas_vport);
        this.stat_canvas_panel.setBorderTitle(" Statistics ", 3, 2, null, Color.blue);
        this.stat_canvas_vport.initLeftMouseToZoom(true);
        this.time_model.addTimeListener(this.stat_canvas_vport);
        this.time_display_panel = new ModelTimePanel(this.time_model);
        this.time_model.setParamDisplay(this.time_display_panel);
        this.time_display_panel.addViewportTime(this.time_ruler_vport);
        this.time_display_panel.addViewportTime(this.stat_canvas_vport);
        JPanel jPanel2 = this.stat_canvas_vport.createLeftMouseModePanel(0);
        jPanel2.setToolTipText("Operation for left mouse button click on Statistics canvas");
        this.time_display_panel.add(jPanel2);
        this.time_scrollbar = new ScrollbarTime(this.time_model);
        this.time_scrollbar.setEnabled(true);
        this.time_model.setScrollBar(this.time_scrollbar);
        jPanel.add(this.time_display_panel);
        jPanel.add(this.stat_canvas_panel);
        jPanel.add(this.time_scrollbar);
        jPanel.add(this.time_ruler_panel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.status_panel = new StatBoxStatusPanel(this.buf4statboxes);
        int n2 = this.time_display_panel.getPreferredSize().height;
        this.status_panel.setMinimumSize(new Dimension(85, n2));
        this.status_panel.setMaximumSize(new Dimension(Short.MAX_VALUE, n2));
        this.status_panel.setPreferredSize(new Dimension(85, n2));
        this.status_panel.setAlignmentX(0.5f);
        Insets insets2 = this.stat_canvas_panel.getInsets();
        this.summary_state_combobox = new SummaryStateComboBox();
        this.summary_state_combobox.setMinimumSize(new Dimension(0, insets2.top));
        this.summary_state_combobox.setMaximumSize(new Dimension(Short.MAX_VALUE, insets2.top));
        this.summary_state_combobox.setPreferredSize(new Dimension(20, insets2.top));
        this.summary_state_combobox.setAlignmentX(0.5f);
        this.y_scroller.setAlignmentX(0.5f);
        this.y_scrollbar.addAdjustmentListener(this.stat_canvas_vport);
        int n3 = n + insets2.bottom;
        JTextArea jTextArea = new JTextArea();
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            jTextArea.append(stringBuffer.toString() + "@ " + stringArray[i] + "\n");
            stringBuffer.append("    ");
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 32);
        jScrollPane.setMinimumSize(new Dimension(0, n3));
        jScrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, n3));
        jScrollPane.setPreferredSize(new Dimension(20, n3));
        jPanel3.add(this.status_panel);
        jPanel3.add(this.summary_state_combobox);
        jPanel3.add(this.y_scroller);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.row_adjs = new RowAdjustments(this.stat_canvas_vport, this.y_tree);
        JPanel jPanel5 = this.row_adjs.getComboBoxPanel();
        jPanel5.setMinimumSize(new Dimension(0, insets2.top));
        jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, insets2.top));
        jPanel5.setPreferredSize(new Dimension(20, insets2.top));
        jPanel5.setAlignmentX(0.5f);
        JPanel jPanel6 = this.row_adjs.getTextFieldPanel();
        jPanel6.setAlignmentX(0.5f);
        JPanel jPanel7 = this.row_adjs.getSliderPanel();
        JScrollPane jScrollPane2 = new JScrollPane(jPanel7, 21, 32);
        jScrollPane2.setAlignmentX(0.5f);
        JPanel jPanel8 = this.row_adjs.getMiscPanel();
        jPanel8.setAlignmentX(0.5f);
        JPanel jPanel9 = this.time_ruler_vport.createLeftMouseModePanel(0);
        jPanel9.setToolTipText("Operation for left mouse button click on Time Ruler");
        jPanel9.setAlignmentX(0.0f);
        jPanel8.add(jPanel9);
        JScrollPane jScrollPane3 = new JScrollPane(jPanel8, 20, 30);
        jScrollPane3.setMinimumSize(new Dimension(0, n3));
        jScrollPane3.setMaximumSize(new Dimension(Short.MAX_VALUE, n3));
        jScrollPane3.setPreferredSize(new Dimension(20, n3));
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel4.add(jScrollPane2);
        jPanel4.add(jScrollPane3);
        JSplitPane jSplitPane = new JSplitPane(1, false, jPanel3, jPanel);
        JSplitPane jSplitPane2 = new JSplitPane(1, false, jSplitPane, jPanel4);
        jSplitPane2.setOneTouchExpandable(true);
        this.err_msg = null;
        try {
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane2.setResizeWeight(1.0);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.err_msg = "Method JSplitPane.setResizeWeight() cannot be found.\nThis indicates you are running an older Java2 RunTime,\nlike the one in J2SDK 1.2.2 or older. If this is the case,\nsome features in Statline window may not work correctly,\nFor instance, automatic resize of the Statline canvas\nduring window resizing and auto-update of the canvas\nafter adjustment of the slider's knob may fail silently,\nmanuel refresh of the canvas will be needed.";
        }
        this.add((Component)jSplitPane2, "Center");
        this.toolbar = new StatlineToolBar(this.root_window, this.stat_canvas_vport, this.y_scrollbar, this.y_tree, this.y_maps, this.time_scrollbar, this.time_model, this.row_adjs);
        this.add((Component)this.toolbar, "North");
        this.y_tree.init();
        this.row_adjs.initYLabelTreeSize();
        this.status_panel.addRedrawListener(this.toolbar.getPropertyRefreshButton());
        this.summary_state_combobox.addRedrawListener(this.toolbar.getPropertyRefreshButton());
    }

    public void init() {
        this.toolbar.init();
        this.row_adjs.initSlidersAndTextFields();
        this.status_panel.init();
        this.summary_state_combobox.init();
        if (this.err_msg != null) {
            Dialogs.error(this.root_window, this.err_msg);
        }
        if (Debug.isActive()) {
            Debug.println("StatlinePanel.init(): time_model = " + this.time_model);
            Debug.println("StatlinePanel.init(): time_scrollbar = " + this.time_scrollbar);
            Debug.println("StatlinePanel.init(): time_ruler = " + this.time_ruler);
        }
    }
}

