/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.CoordPixelXform;
import base.drawable.TimeBoundingBox;
import viewer.zoomable.ScrollableObject;

public class CoordPixelImage
implements CoordPixelXform {
    private ScrollableObject img_obj;
    private int row_hgt;
    private int row_half_hgt;
    private TimeBoundingBox img_endtimes;
    private double img_starttime;
    private double img_finaltime;
    private int ipix_start;
    private int ipix_final;
    private int ipix_width;
    private int jpix_start;
    private int jpix_final;
    private int jpix_height;

    public CoordPixelImage(ScrollableObject scrollableObject) {
        this.img_obj = scrollableObject;
        this.row_hgt = 0;
        this.row_half_hgt = 0;
        this.resetXaxisPixelBounds(0, 0x7FFFFFFE);
        this.resetYaxisPixelBounds(0, 0x7FFFFFFE);
    }

    public CoordPixelImage(ScrollableObject scrollableObject, int n, TimeBoundingBox timeBoundingBox) {
        this(scrollableObject);
        this.resetRowHeight(n);
        this.resetTimeBounds(timeBoundingBox);
    }

    public void resetRowHeight(int n) {
        this.row_hgt = n;
        this.row_half_hgt = n / 2 + 1;
    }

    public void resetXaxisPixelBounds(int n, int n2) {
        this.ipix_start = n;
        this.ipix_final = n2;
        this.ipix_width = this.ipix_final - this.ipix_start + 1;
    }

    public void resetYaxisPixelBounds(int n, int n2) {
        this.jpix_start = n;
        this.jpix_final = n2;
        this.jpix_height = this.jpix_final - this.jpix_start + 1;
    }

    public void resetTimeBounds(TimeBoundingBox timeBoundingBox) {
        this.img_endtimes = timeBoundingBox;
        this.img_starttime = timeBoundingBox.getEarliestTime();
        this.img_finaltime = timeBoundingBox.getLatestTime();
        this.resetXaxisPixelBounds(this.img_obj.time2pixel(this.img_starttime), this.img_obj.time2pixel(this.img_finaltime));
    }

    @Override
    public int convertTimeToPixel(double d) {
        return this.img_obj.time2pixel(d) - this.ipix_start;
    }

    @Override
    public double convertPixelToTime(int n) {
        return this.img_obj.pixel2time(n + this.ipix_start);
    }

    @Override
    public int convertRowToPixel(float f) {
        return Math.round(f * (float)this.row_hgt + (float)this.row_half_hgt) - this.jpix_start;
    }

    @Override
    public float convertPixelToRow(int n) {
        return (float)(n + this.jpix_start - this.row_half_hgt) / (float)this.row_hgt;
    }

    @Override
    public boolean contains(double d) {
        return this.img_endtimes.contains(d);
    }

    @Override
    public boolean overlaps(TimeBoundingBox timeBoundingBox) {
        return this.img_endtimes.overlaps(timeBoundingBox);
    }

    @Override
    public int getPixelWidth() {
        return this.ipix_width;
    }

    @Override
    public int getPixelHeight() {
        return this.jpix_height;
    }
}

