/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.Coord;
import base.drawable.Coord_TimeRowID;
import base.drawable.Drawable;
import cern.colt.map.OpenIntIntHashMap;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoPanelForDrawable;
import viewer.zoomable.ModelTime;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class InfoDialogForDrawable
extends InfoDialog {
    private static final long serialVersionUID = 13200L;
    private ModelTime time_model;
    private YaxisMaps y_maps;
    private YaxisTree tree_view;
    private Drawable clk_dobj;
    private JButton left_btn;
    private JButton home_btn;
    private JButton right_btn;
    private Map map_line2treeleaf;
    private OpenIntIntHashMap map_line2row;
    private Coord_TimeRowID marker_vtx;

    public InfoDialogForDrawable(Frame frame, Drawable drawable, Coord_TimeRowID coord_TimeRowID, String[] stringArray, YaxisMaps yaxisMaps, ModelTime modelTime) {
        super(frame, "Drawable Info Box", coord_TimeRowID.time);
        URL uRL;
        this.clk_dobj = drawable;
        this.marker_vtx = new Coord_TimeRowID(coord_TimeRowID.time, coord_TimeRowID.rowID);
        this.time_model = modelTime;
        this.y_maps = yaxisMaps;
        this.tree_view = this.y_maps.getTreeView();
        this.map_line2treeleaf = this.y_maps.getMapOfLineIDToTreeLeaf();
        this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        if (this.map_line2row == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(SwingUtilities.windowForComponent(this), "Error in updating YaxisMaps!");
            }
            this.map_line2row = this.y_maps.getMapOfLineIDToRowID();
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(new InfoPanelForDrawable(this.map_line2treeleaf, stringArray, this.clk_dobj));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(InfoDialog.BOX_RIGID);
        jPanel.add(InfoDialog.BOX_GLUE);
        if (!this.clk_dobj.getCategory().getTopology().isEvent()) {
            uRL = this.getURL("/images/Backward24.gif");
            this.left_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("StartVertex");
            this.left_btn.setMargin(Const.SQ_BTN1_INSETS);
            this.left_btn.setToolTipText("Scroll to the Drawable's Starting Vertex.");
            this.left_btn.setAlignmentX(0.0f);
            this.left_btn.addActionListener(new ScrollLeftActionListener());
            jPanel.add(this.left_btn);
        } else {
            this.left_btn = null;
        }
        uRL = this.getURL("/images/Home24.gif");
        this.home_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Home");
        this.home_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.home_btn.setToolTipText("Scroll back to the Drawable's Right-Clicked Location.");
        this.home_btn.setAlignmentX(0.5f);
        this.home_btn.addActionListener(new ScrollHomeActionListener());
        jPanel.add(this.home_btn);
        if (!this.clk_dobj.getCategory().getTopology().isEvent()) {
            uRL = this.getURL("/images/Forward24.gif");
            this.right_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("FinalVertex");
            this.right_btn.setMargin(Const.SQ_BTN1_INSETS);
            this.right_btn.setToolTipText("Scroll to the Drawable's Ending Vertex.");
            this.right_btn.setAlignmentX(1.0f);
            this.right_btn.addActionListener(new ScrollRightActionListener());
            jPanel.add(this.right_btn);
        } else {
            this.right_btn = null;
        }
        jPanel.add(InfoDialog.BOX_GLUE);
        super.initCloseButton();
        jPanel.add(super.getCloseButton());
        jPanel.setAlignmentX(0.0f);
        super.finalizeCloseButtonPanel(jPanel);
        container.add(jPanel);
    }

    public Drawable getDrawable() {
        return this.clk_dobj;
    }

    public void updateMarkerVertex() {
        this.marker_vtx.rowID = this.clk_dobj.getRowIDAtTime(this.map_line2row, this.marker_vtx.time);
    }

    public Coord_TimeRowID getMarkerVertex() {
        return this.marker_vtx;
    }

    private class ScrollRightActionListener
    implements ActionListener {
        private ScrollRightActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Coord coord = InfoDialogForDrawable.this.clk_dobj.getFinalVertex();
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time = coord.time;
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID = InfoDialogForDrawable.this.map_line2row.get(coord.lineID);
            InfoDialogForDrawable.this.time_model.centerTimeViewPosition(((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time);
            InfoDialogForDrawable.this.tree_view.scrollRowToVisible((int)((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID);
        }
    }

    private class ScrollHomeActionListener
    implements ActionListener {
        private ScrollHomeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time = InfoDialogForDrawable.super.getClickedTime();
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID = InfoDialogForDrawable.this.clk_dobj.getRowIDAtTime(InfoDialogForDrawable.this.map_line2row, ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time);
            InfoDialogForDrawable.this.time_model.centerTimeViewPosition(((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time);
            InfoDialogForDrawable.this.tree_view.scrollRowToVisible((int)((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID);
        }
    }

    private class ScrollLeftActionListener
    implements ActionListener {
        private ScrollLeftActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Coord coord = InfoDialogForDrawable.this.clk_dobj.getStartVertex();
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time = coord.time;
            ((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID = InfoDialogForDrawable.this.map_line2row.get(coord.lineID);
            InfoDialogForDrawable.this.time_model.centerTimeViewPosition(((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.time);
            InfoDialogForDrawable.this.tree_view.scrollRowToVisible((int)((InfoDialogForDrawable)InfoDialogForDrawable.this).marker_vtx.rowID);
        }
    }
}

