/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import viewer.common.Const;
import viewer.common.Parameters;
import viewer.common.SwingWorker;
import viewer.zoomable.InitializableDialog;
import viewer.zoomable.SummarizableView;

public class OperationDurationButton
extends JButton {
    private static final long serialVersionUID = 4100L;
    private TimeBoundingBox timebox;
    private SummarizableView summarizable;
    private InitializableDialog summary_dialog;
    private Dialog root_dialog;

    public OperationDurationButton(TimeBoundingBox timeBoundingBox, SummarizableView summarizableView) {
        this.timebox = timeBoundingBox;
        this.summarizable = summarizableView;
        this.summary_dialog = null;
        this.root_dialog = null;
        URL uRL = this.getURL("/images/Stat110x40.gif");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            ImageIcon imageIcon2 = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
            super.setIcon(imageIcon);
            super.setPressedIcon(imageIcon2);
            Border border = BorderFactory.createRaisedBevelBorder();
            Border border2 = BorderFactory.createLoweredBevelBorder();
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
            CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(border, compoundBorder);
            super.setBorder(compoundBorder2);
        } else {
            super.setText("Sumary Statistics");
        }
        super.setMargin(Const.SQ_BTN2_INSETS);
        super.setToolTipText("Summary Statistics for the selected duration, timelines & legends");
        super.addActionListener(new StatBtnActionListener());
    }

    private URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private void createSummaryDialog() {
        this.root_dialog = (Dialog)SwingUtilities.windowForComponent(this);
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                OperationDurationButton.this.summary_dialog = OperationDurationButton.this.summarizable.createSummary(OperationDurationButton.this.root_dialog, OperationDurationButton.this.timebox);
                return null;
            }

            @Override
            public void finished() {
                OperationDurationButton.this.summary_dialog.pack();
                if (Parameters.AUTO_WINDOWS_LOCATION) {
                    Rectangle rectangle = OperationDurationButton.this.root_dialog.getBounds();
                    OperationDurationButton.this.summary_dialog.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                }
                OperationDurationButton.this.summary_dialog.setVisible(true);
                OperationDurationButton.this.summary_dialog.init();
            }
        };
        swingWorker.start();
    }

    private class StatBtnActionListener
    implements ActionListener {
        private StatBtnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OperationDurationButton.this.createSummaryDialog();
        }
    }
}

