/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.common.LabeledTextField;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.zoomable.Diagnosis;
import viewer.zoomable.ScaledSlider;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisTree;

public class RowAdjustments {
    private static final Font FONT = Const.FONT;
    private static final String ROW_COUNT_RESIZE = "COUNT";
    private static final String ROW_HEIGHT_RESIZE = "HEIGHT";
    private ViewportTimeYaxis canvas_vport;
    private YaxisTree tree_view;
    private JComboBox combo_ROW_RESIZE;
    private ScaledSlider slider_VIS_ROW_HEIGHT;
    private LabeledTextField fld_VIS_ROW_HEIGHT;
    private ScaledSlider slider_VIS_ROW_COUNT;
    private LabeledTextField fld_VIS_ROW_COUNT;
    private JButton fitmost_btn;
    private JPanel combo_panel;
    private JPanel txtfld_panel;
    private JPanel slider_panel;
    private JPanel misc_panel;
    private boolean hasMinHeightBeenTouched;
    private Diagnosis debug;

    public RowAdjustments(ViewportTimeYaxis viewportTimeYaxis, YaxisTree yaxisTree) {
        this.canvas_vport = viewportTimeYaxis;
        this.tree_view = yaxisTree;
        this.debug = new Diagnosis();
        this.debug.setActive(false);
        this.hasMinHeightBeenTouched = false;
        this.combo_ROW_RESIZE = new JComboBox();
        this.combo_ROW_RESIZE.setFont(FONT);
        this.combo_ROW_RESIZE.setEditable(false);
        this.combo_ROW_RESIZE.addItem(ROW_COUNT_RESIZE);
        this.combo_ROW_RESIZE.addItem(ROW_HEIGHT_RESIZE);
        this.combo_ROW_RESIZE.setToolTipText("Display mode for row adjustment control");
        this.combo_ROW_RESIZE.addActionListener(new ResizeModeActionListener());
        this.slider_VIS_ROW_HEIGHT = new ScaledSlider(1);
        this.slider_VIS_ROW_HEIGHT.setLabelFormat("0.0##");
        this.slider_VIS_ROW_HEIGHT.setInverted(true);
        this.slider_VIS_ROW_HEIGHT.addChangeListener(new RowHeightSliderListener());
        this.fld_VIS_ROW_HEIGHT = new LabeledTextField("Row Height", "#,##0");
        this.fld_VIS_ROW_HEIGHT.setToolTipText("Row height of timeline in pixel.");
        this.fld_VIS_ROW_HEIGHT.setHorizontalAlignment(0);
        this.fld_VIS_ROW_HEIGHT.setEditable(true);
        this.fld_VIS_ROW_HEIGHT.addActionListener(new RowHeightTextListener());
        this.slider_VIS_ROW_COUNT = new ScaledSlider(1);
        this.slider_VIS_ROW_COUNT.setLabelFormat("0.0##");
        this.slider_VIS_ROW_COUNT.setInverted(false);
        this.slider_VIS_ROW_COUNT.addChangeListener(new RowCountSliderListener());
        this.fld_VIS_ROW_COUNT = new LabeledTextField("Row Count", "###0.0#");
        this.fld_VIS_ROW_COUNT.setToolTipText("Visible row count in canvas during timeline window resizing.");
        this.fld_VIS_ROW_COUNT.setHorizontalAlignment(0);
        this.fld_VIS_ROW_COUNT.setEditable(true);
        this.fld_VIS_ROW_COUNT.addActionListener(new RowCountTextListener());
        this.combo_panel = new JPanel();
        this.combo_panel.setLayout(new BoxLayout(this.combo_panel, 0));
        this.combo_panel.add(this.combo_ROW_RESIZE);
        this.txtfld_panel = new JPanel();
        this.txtfld_panel.setLayout(new BoxLayout(this.txtfld_panel, 0));
        this.txtfld_panel.setBorder(BorderFactory.createEtchedBorder());
        this.slider_panel = new JPanel();
        this.slider_panel.setLayout(new BoxLayout(this.slider_panel, 0));
        this.slider_panel.addComponentListener(new SliderComponentListener());
        this.fitmost_btn = new JButton("Fit Most Rows");
        this.fitmost_btn.setFont(FONT);
        this.fitmost_btn.setBorder(BorderFactory.createRaisedBevelBorder());
        this.fitmost_btn.setToolTipText("Compute the optimal row height that fits MOST of the rows in the Timeline canvas");
        this.fitmost_btn.addActionListener(new ButtonActionListener());
        this.fitmost_btn.setAlignmentX(0.0f);
        this.misc_panel = new JPanel();
        this.misc_panel.setLayout(new BoxLayout(this.misc_panel, 1));
        this.misc_panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.misc_panel.add(this.fitmost_btn);
    }

    public void initYLabelTreeSize() {
        if (this.debug.isActive()) {
            this.debug.println("initYLabel: START");
        }
        this.tree_view.setRootVisible(Parameters.Y_AXIS_ROOT_VISIBLE);
        int n = (int)((float)Routines.getScreenSize().height * Parameters.SCREEN_HEIGHT_RATIO);
        int n2 = n / this.tree_view.getRowCount();
        if (n2 < Parameters.Y_AXIS_MIN_ROW_HEIGHT) {
            n2 = Parameters.Y_AXIS_MIN_ROW_HEIGHT;
            this.hasMinHeightBeenTouched = true;
        }
        this.tree_view.setRowHeight(n2);
        int n3 = n / n2;
        this.tree_view.setVisibleRowCount(n3);
        if (this.debug.isActive()) {
            this.debug.println("initYLabel: screenH= " + n + ", h=" + n2 + ", N=" + n3);
            this.debug.println("initYLabel: END");
        }
    }

    public void initSlidersAndTextFields() {
        int n = this.canvas_vport.getHeight();
        int n2 = this.tree_view.getRowCount();
        int n3 = this.tree_view.getRowHeight();
        if (this.debug.isActive()) {
            this.debug.println("initSliders: START");
            this.debug.println("initSliders: vportH=" + n + ", N=" + n2 + ", h=" + n3);
        }
        this.slider_VIS_ROW_HEIGHT.setMinLabel(Parameters.Y_AXIS_MIN_ROW_HEIGHT);
        this.slider_VIS_ROW_HEIGHT.setMaxLabel(n);
        if (n2 > 1) {
            this.slider_VIS_ROW_COUNT.setMinLabel(1);
            double d = (double)n / (double)Parameters.Y_AXIS_MIN_ROW_HEIGHT;
            if (d < (double)n2) {
                this.slider_VIS_ROW_COUNT.setMaxLabel(d);
            } else {
                this.slider_VIS_ROW_COUNT.setMaxLabel(n2);
            }
        } else {
            this.slider_VIS_ROW_COUNT.setMinLabel(0);
            this.slider_VIS_ROW_COUNT.setMaxLabel(1);
        }
        if (!this.hasMinHeightBeenTouched) {
            this.combo_ROW_RESIZE.setSelectedItem(ROW_COUNT_RESIZE);
            this.fld_VIS_ROW_COUNT.setDouble(n2);
            this.fld_VIS_ROW_COUNT.fireActionPerformed();
        } else {
            this.combo_ROW_RESIZE.setSelectedItem(ROW_HEIGHT_RESIZE);
            this.fld_VIS_ROW_HEIGHT.setDouble(n3);
            this.fld_VIS_ROW_HEIGHT.fireActionPerformed();
        }
        if (this.hasMinHeightBeenTouched) {
            Dialogs.warn(SwingUtilities.windowForComponent(this.slider_panel), "Y_AXIS_MIN_ROW_HEIGHT is reached, your logfile may contain too many timelines to fit into the timeline canvas.\nEach timeline can be enlarged by increasing row_height slowly. If row_height is set too big, heap memory will be exhausted.");
        }
        if (this.debug.isActive()) {
            this.debug.println("initSliders: END");
        }
    }

    public JPanel getComboBoxPanel() {
        return this.combo_panel;
    }

    public JPanel getTextFieldPanel() {
        return this.txtfld_panel;
    }

    public JPanel getSliderPanel() {
        return this.slider_panel;
    }

    public JPanel getMiscPanel() {
        return this.misc_panel;
    }

    private void initPanelsToRowHeightMode() {
        this.txtfld_panel.removeAll();
        this.txtfld_panel.add(this.fld_VIS_ROW_HEIGHT);
        this.txtfld_panel.revalidate();
        this.txtfld_panel.repaint();
        this.slider_panel.removeAll();
        this.slider_panel.add(this.slider_VIS_ROW_HEIGHT);
        this.slider_panel.revalidate();
        this.slider_panel.repaint();
    }

    private void initPanelsToRowCountMode() {
        this.txtfld_panel.removeAll();
        this.txtfld_panel.add(this.fld_VIS_ROW_COUNT);
        this.txtfld_panel.revalidate();
        this.txtfld_panel.repaint();
        this.slider_panel.removeAll();
        this.slider_panel.add(this.slider_VIS_ROW_COUNT);
        this.slider_panel.revalidate();
        this.slider_panel.repaint();
    }

    public void updateSlidersAfterTreeExpansion() {
        int n = this.tree_view.getRowCount();
        this.slider_VIS_ROW_COUNT.setMaxLabel(n);
        this.fld_VIS_ROW_COUNT.fireActionPerformed();
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = (double)RowAdjustments.this.canvas_vport.getHeight() / (double)RowAdjustments.this.tree_view.getRowCount();
            if (d < (double)Parameters.Y_AXIS_MIN_ROW_HEIGHT) {
                d = Parameters.Y_AXIS_MIN_ROW_HEIGHT;
            }
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(d);
            RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d);
        }
    }

    private class RowCountTextListener
    implements ActionListener {
        private RowCountTextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountTextListener: START");
            }
            double d = RowAdjustments.this.slider_VIS_ROW_COUNT.getMinLabel();
            double d2 = RowAdjustments.this.slider_VIS_ROW_COUNT.getMaxLabel();
            double d3 = -1.0;
            double d4 = RowAdjustments.this.fld_VIS_ROW_COUNT.getDouble();
            if (d4 > d2) {
                d4 = d2;
                RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d4);
            } else if (d4 < d) {
                d4 = d;
                RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d4);
            }
            RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(d4);
            d3 = (double)RowAdjustments.this.canvas_vport.getHeight() / d4;
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(d3);
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountTextListener: h=" + d3 + ",N=" + d4);
                RowAdjustments.this.debug.println("RowCountTextListener: END");
            }
        }
    }

    private class RowCountSliderListener
    implements ChangeListener {
        private RowCountSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountSliderListener: START");
            }
            double d = -1.0;
            double d2 = RowAdjustments.this.slider_VIS_ROW_COUNT.getValLabel();
            RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d2);
            if (!RowAdjustments.this.slider_VIS_ROW_COUNT.getValueIsAdjusting()) {
                double d3 = RowAdjustments.this.slider_VIS_ROW_COUNT.getMinLabel();
                double d4 = RowAdjustments.this.slider_VIS_ROW_COUNT.getMaxLabel();
                if (d2 > d4) {
                    d2 = d4;
                    RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d2);
                    RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabelFully(d2);
                } else if (d2 < d3) {
                    d2 = d3;
                    RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d2);
                    RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabelFully(d2);
                }
                d = (double)RowAdjustments.this.canvas_vport.getHeight() / d2;
                RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(d);
                if (RowAdjustments.this.debug.isActive()) {
                    RowAdjustments.this.debug.println("RowCountSliderListener: h=" + d + ",N=" + d2);
                }
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowCountSliderListener: END");
            }
        }
    }

    private class RowHeightTextListener
    implements ActionListener {
        private RowHeightTextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d;
            double d2;
            double d3;
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightTextListener: START");
            }
            if ((d3 = (d2 = (double)RowAdjustments.this.canvas_vport.getHeight()) / (d = (double)RowAdjustments.this.tree_view.getRowCount())) < (double)Parameters.Y_AXIS_MIN_ROW_HEIGHT) {
                d3 = Parameters.Y_AXIS_MIN_ROW_HEIGHT;
                RowAdjustments.this.hasMinHeightBeenTouched = true;
            }
            double d4 = d2;
            double d5 = -1.0;
            double d6 = RowAdjustments.this.fld_VIS_ROW_HEIGHT.getDouble();
            if (d6 > d4) {
                d6 = d4;
                d5 = 1.0;
                RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d6);
            } else if (d6 < d3) {
                d6 = d3;
                d5 = d2 / d6;
                RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d6);
            } else {
                d5 = d2 / d6;
            }
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(d6);
            RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(d5);
            RowAdjustments.this.tree_view.setRowHeight((int)Math.round(d6));
            RowAdjustments.this.canvas_vport.fireComponentResized();
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightTextListener: h=" + d6 + ",N=" + d5);
                RowAdjustments.this.debug.println("RowHeightTextListener: END");
            }
        }
    }

    private class RowHeightSliderListener
    implements ChangeListener {
        private RowHeightSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightSliderListener: START");
            }
            double d = -1.0;
            double d2 = RowAdjustments.this.slider_VIS_ROW_HEIGHT.getValLabel();
            RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d2);
            if (!RowAdjustments.this.slider_VIS_ROW_HEIGHT.getValueIsAdjusting()) {
                double d3;
                double d4;
                double d5 = RowAdjustments.this.canvas_vport.getHeight();
                double d6 = d5 / (d4 = (double)RowAdjustments.this.tree_view.getRowCount());
                if (d6 < (double)Parameters.Y_AXIS_MIN_ROW_HEIGHT) {
                    d6 = Parameters.Y_AXIS_MIN_ROW_HEIGHT;
                    RowAdjustments.this.hasMinHeightBeenTouched = true;
                }
                if (d2 > (d3 = d5)) {
                    d2 = d3;
                    d = 1.0;
                    RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d2);
                    RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabelFully(d2);
                } else if (d2 < d6) {
                    d2 = d6;
                    d = d5 / d2;
                    RowAdjustments.this.fld_VIS_ROW_HEIGHT.setDouble(d2);
                    RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabelFully(d2);
                } else {
                    d = d5 / d2;
                }
                RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabel(d);
                RowAdjustments.this.tree_view.setRowHeight((int)Math.round(d2));
                RowAdjustments.this.canvas_vport.fireComponentResized();
                if (RowAdjustments.this.debug.isActive()) {
                    RowAdjustments.this.debug.println("RowHeightSliderListener: h=" + d2 + ",N=" + d);
                }
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("RowHeightSliderListener: END");
            }
        }
    }

    private class SliderComponentListener
    extends ComponentAdapter {
        private SliderComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("SliderComponentListener: START");
                RowAdjustments.this.debug.println("HEIGHT: canvas_vport.height = " + RowAdjustments.this.canvas_vport.getHeight());
            }
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setMaxLabel(RowAdjustments.this.canvas_vport.getHeight());
            double d = RowAdjustments.this.fld_VIS_ROW_COUNT.getDouble();
            double d2 = (double)RowAdjustments.this.canvas_vport.getHeight() / d;
            if (d2 < (double)Parameters.Y_AXIS_MIN_ROW_HEIGHT) {
                d2 = Parameters.Y_AXIS_MIN_ROW_HEIGHT;
                RowAdjustments.this.hasMinHeightBeenTouched = true;
                d = (double)RowAdjustments.this.canvas_vport.getHeight() / d2;
            }
            RowAdjustments.this.tree_view.setRowHeight((int)Math.round(d2));
            RowAdjustments.this.canvas_vport.fireComponentResized();
            RowAdjustments.this.slider_VIS_ROW_HEIGHT.setValLabel(d2);
            RowAdjustments.this.fld_VIS_ROW_COUNT.setDouble(d);
            RowAdjustments.this.slider_VIS_ROW_COUNT.setValLabelFully(d);
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("ROW: row_height = " + d2);
                RowAdjustments.this.debug.println("SliderComponentListener: END");
            }
        }
    }

    private class ResizeModeActionListener
    implements ActionListener {
        private ResizeModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("ResizeModeActionListener: START");
            }
            if ((string = (String)RowAdjustments.this.combo_ROW_RESIZE.getSelectedItem()).equals(RowAdjustments.ROW_COUNT_RESIZE)) {
                RowAdjustments.this.initPanelsToRowCountMode();
            } else if (string.equals(RowAdjustments.ROW_HEIGHT_RESIZE)) {
                RowAdjustments.this.initPanelsToRowHeightMode();
            }
            if (RowAdjustments.this.debug.isActive()) {
                RowAdjustments.this.debug.println("display mode = " + string);
                RowAdjustments.this.debug.println("ResizeModeActionListener: END");
            }
        }
    }
}

