/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import viewer.common.Const;
import viewer.common.TopWindow;
import viewer.zoomable.ActionSearchBackward;
import viewer.zoomable.ActionSearchForward;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ViewportTimeYaxis;

public class SearchDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4400L;
    private Window root_window;
    private ViewportTimeYaxis viewport;
    private Container root_panel;
    private JPanel btn_panel;
    private JButton close_btn;
    private JButton searchBack_btn;
    private JButton searchFore_btn;

    public SearchDialog(Frame frame, ViewportTimeYaxis viewportTimeYaxis) {
        super(frame, "Search Box");
        this.root_window = frame;
        this.viewport = viewportTimeYaxis;
        this.init();
    }

    private URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private void init() {
        super.setDefaultCloseOperation(0);
        this.root_panel = super.getContentPane();
        this.root_panel.setLayout(new BoxLayout(this.root_panel, 1));
        this.btn_panel = new JPanel();
        this.btn_panel.setLayout(new BoxLayout(this.btn_panel, 0));
        this.btn_panel.add(InfoDialog.BOX_RIGID);
        this.btn_panel.add(InfoDialog.BOX_GLUE);
        URL uRL = this.getURL("/images/FindBack24.gif");
        this.searchBack_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("SearchBackward");
        this.searchBack_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.searchBack_btn.setToolTipText("Search Backward in time");
        this.searchBack_btn.setAlignmentX(0.0f);
        this.searchBack_btn.addActionListener(new ActionSearchBackward(this.viewport));
        this.btn_panel.add(this.searchBack_btn);
        uRL = this.getURL("/images/FindFore24.gif");
        this.searchFore_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("SearchForward");
        this.searchFore_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.searchFore_btn.setToolTipText("Search Forward in time");
        this.searchFore_btn.setAlignmentX(1.0f);
        this.searchFore_btn.addActionListener(new ActionSearchForward(this.viewport));
        this.btn_panel.add(this.searchFore_btn);
        this.btn_panel.add(InfoDialog.BOX_GLUE);
        uRL = this.getURL("/images/Stop24.gif");
        this.close_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Close");
        this.close_btn.setMargin(Const.SQ_BTN1_INSETS);
        this.close_btn.setToolTipText("Close this dialog box.");
        this.close_btn.setAlignmentX(0.5f);
        this.close_btn.addActionListener(this);
        this.btn_panel.add(this.close_btn);
        this.btn_panel.setAlignmentX(0.0f);
        Dimension dimension = this.btn_panel.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        this.btn_panel.setMaximumSize(dimension);
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SearchDialog.this.setVisible(false);
                SearchDialog.this.viewport.eraseSearchedDrawable();
                SearchDialog.this.viewport.repaint();
            }
        });
        super.setVisible(false);
    }

    private void setVisibleAtLocation(Point point) {
        this.setLocation(point);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    public void setVisibleAtDefaultLocation() {
        Rectangle rectangle = null;
        Point point = null;
        JFrame jFrame = TopWindow.First.getWindow();
        if (jFrame != null) {
            rectangle = jFrame.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.y);
        } else {
            rectangle = this.root_window.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.y);
        }
        this.setVisibleAtLocation(point);
    }

    public void replace(Component component) {
        this.root_panel.removeAll();
        this.root_panel.add(component);
        this.root_panel.add(this.btn_panel);
        super.invalidate();
        super.validate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close_btn) {
            super.setVisible(false);
            this.viewport.eraseSearchedDrawable();
            this.viewport.repaint();
        }
    }
}

