/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import viewer.common.CustomCursor;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoDialogForDuration;
import viewer.zoomable.InfoDialogForTime;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.ScrollableView;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;
import viewer.zoomable.ToolBarStatus;

public class ViewportTime
extends JViewport
implements TimeListener,
ComponentListener,
MouseInputListener,
KeyListener {
    private static final long serialVersionUID = 3700L;
    protected static final Color INFO_LINE_COLOR = Color.green;
    private static final Color INFO_AREA_COLOR = new Color(255, 255, 0, 64);
    private static final Color ZOOM_LINE_COLOR = Color.white;
    private static final Color ZOOM_AREA_COLOR = new Color(132, 112, 255, 96);
    private static final Color FOCUS_LINE_COLOR = Color.red;
    private Point view_pt;
    private ScrollableView view_img = null;
    private ModelTime time_model = null;
    private ToolBarStatus toolbar = null;
    private TimeBoundingBox vport_timebox = null;
    protected CoordPixelImage coord_xform = null;
    private TimeBoundingBox zoom_timebox = null;
    private TimeBoundingBox info_timebox = null;
    protected List info_dialogs;
    private InfoDialogActionListener info_action_listener;
    private InfoDialogWindowListener info_window_listener;
    protected boolean isLeftMouseClick4Zoom;
    private JRadioButton zoom_btn;
    private JRadioButton hand_btn;
    private double mouse_pressed_time;
    private int mouse_pressed_Xloc;
    private int mouse_last_Xloc;

    public ViewportTime(ModelTime modelTime) {
        this.time_model = modelTime;
        this.view_pt = new Point(0, 0);
        this.isLeftMouseClick4Zoom = false;
        this.zoom_btn = null;
        this.hand_btn = null;
        this.addComponentListener(this);
        this.vport_timebox = new TimeBoundingBox();
    }

    @Override
    public void setView(Component component) {
        Dimension dimension;
        Dimension dimension2;
        super.setView(component);
        Dimension dimension3 = component.getMinimumSize();
        if (dimension3 != null) {
            this.setMinimumSize(dimension3);
        }
        if ((dimension2 = component.getMaximumSize()) != null) {
            this.setMaximumSize(dimension2);
        }
        if ((dimension = component.getPreferredSize()) != null) {
            this.setPreferredSize(dimension);
        }
        this.view_img = (ScrollableView)((Object)component);
        this.coord_xform = new CoordPixelImage((ScrollableObject)this.view_img);
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
        super.addKeyListener(this);
        this.info_dialogs = new ArrayList();
        this.info_action_listener = new InfoDialogActionListener(this, this.info_dialogs);
        this.info_window_listener = new InfoDialogWindowListener(this, this.info_dialogs);
    }

    public void setToolBarStatus(ToolBarStatus toolBarStatus) {
        this.toolbar = toolBarStatus;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: min_size = " + dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: max_size = " + dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: pref_size = " + dimension);
        }
        return dimension;
    }

    protected void setYaxisViewPosition(int n) {
        this.view_pt.y = n;
    }

    protected int getXaxisViewPosition() {
        return this.view_pt.x;
    }

    @Override
    public void timeChanged(TimeEvent timeEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: timeChanged()'s START: ");
            Debug.println("time_evt = " + timeEvent);
        }
        if (this.view_img != null) {
            this.view_img.checkToZoomView();
            this.view_img.checkToScrollView();
            if (Debug.isActive()) {
                Debug.println("ViewportTime:timeChanged()'s view_img = " + this.view_img);
            }
            this.view_pt.x = this.view_img.getXaxisViewPosition();
            super.setViewPosition(this.view_pt);
            this.repaint();
        }
        if (Debug.isActive()) {
            if (this.view_img != null) {
                Debug.println("ViewportTime: view_img.getXaxisViewPosition() = " + this.view_pt.x);
                Debug.println("ViewportTime: [after] getViewPosition() = " + super.getViewPosition());
            }
            Debug.println("ViewportTime: timeChanged()'s END: ");
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentResized()'s START: ");
            Debug.println("comp_evt = " + componentEvent);
        }
        if (this.view_img != null) {
            this.view_img.componentResized(this);
            this.setPreferredSize(this.getSize());
            if (Debug.isActive()) {
                Debug.println("ViewportTime: componentResized()'s view_img = " + this.view_img);
            }
            this.view_pt.x = this.view_img.getXaxisViewPosition();
            super.setViewPosition(this.view_pt);
            this.repaint();
        }
        if (Debug.isActive()) {
            if (this.view_img != null) {
                Debug.println("ViewportTime: view_img.getXaxisViewPosition() = " + this.view_pt.x);
                Debug.println("ViewportTime: [after] getViewPosition() = " + super.getViewPosition());
            }
            Debug.println("ViewportTime: componentResized()'s END: ");
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentMoved()'s START: ");
            Debug.println("comp_evt = " + componentEvent);
            Debug.println("ViewportTime: componentMoved()'s END: ");
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentHidden()'s START: ");
            Debug.println("comp_evt = " + componentEvent);
            Debug.println("ViewportTime: componentHidden()'s END: ");
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentShown()'s START: ");
            Debug.println("comp_evt = " + componentEvent);
            Debug.println("ViewportTime: componentShown()'s END: ");
        }
    }

    private void drawShadyTimeBoundingBox(Graphics graphics, TimeBoundingBox timeBoundingBox, Color color, Color color2) {
        if (this.vport_timebox.overlaps(timeBoundingBox)) {
            int n;
            int n2;
            double d = timeBoundingBox.getEarliestTime();
            if (this.coord_xform.contains(d)) {
                n2 = this.coord_xform.convertTimeToPixel(d);
                graphics.setColor(color);
                graphics.drawLine(n2, 0, n2, this.getHeight());
            } else {
                n2 = 0;
            }
            d = timeBoundingBox.getLatestTime();
            if (this.coord_xform.contains(d)) {
                n = this.coord_xform.convertTimeToPixel(d);
                graphics.setColor(color);
                graphics.drawLine(n, 0, n, this.getHeight());
            } else {
                n = this.getWidth();
            }
            if (n > n2) {
                graphics.setColor(color2);
                graphics.fillRect(n2 + 1, 0, n - n2 - 1, this.getHeight());
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        double d;
        if (Debug.isActive()) {
            Debug.println("ViewportTime: paint()'s START: ");
        }
        super.paint(graphics);
        this.vport_timebox.setEarliestTime(this.time_model.getTimeViewPosition());
        this.vport_timebox.setLatestFromEarliest(this.time_model.getTimeViewExtent());
        this.coord_xform.resetTimeBounds(this.vport_timebox);
        if (!Parameters.LEFTCLICK_INSTANT_ZOOM && this.coord_xform.contains(d = this.time_model.getTimeZoomFocus())) {
            n = this.coord_xform.convertTimeToPixel(d);
            graphics.setColor(FOCUS_LINE_COLOR);
            graphics.drawLine(n, 0, n, this.getHeight());
        }
        if (this.zoom_timebox != null) {
            this.drawShadyTimeBoundingBox(graphics, this.zoom_timebox, ZOOM_LINE_COLOR, ZOOM_AREA_COLOR);
        }
        if (this.info_timebox != null) {
            this.drawShadyTimeBoundingBox(graphics, this.info_timebox, INFO_LINE_COLOR, INFO_AREA_COLOR);
        }
        for (InfoDialog infoDialog : this.info_dialogs) {
            double d2;
            if (infoDialog instanceof InfoDialogForDuration) {
                InfoDialogForDuration infoDialogForDuration = (InfoDialogForDuration)infoDialog;
                this.drawShadyTimeBoundingBox(graphics, infoDialogForDuration.getTimeBoundingBox(), INFO_LINE_COLOR, INFO_AREA_COLOR);
                continue;
            }
            if (!(infoDialog instanceof InfoDialogForTime) || !this.coord_xform.contains(d2 = infoDialog.getClickedTime())) continue;
            n = this.coord_xform.convertTimeToPixel(d2);
            graphics.setColor(INFO_LINE_COLOR);
            graphics.drawLine(n, 0, n, this.getHeight());
        }
        if (Debug.isActive()) {
            Debug.println("ViewportTime: paint()'s END: ");
        }
    }

    private URL getURL(String string) {
        return this.getClass().getResource(string);
    }

    public void initLeftMouseToZoom(boolean bl) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        this.isLeftMouseClick4Zoom = bl;
        ButtonGroup buttonGroup = new ButtonGroup();
        URL uRL = this.getURL("/images/ZoomBW16.gif");
        if (uRL != null) {
            imageIcon2 = new ImageIcon(uRL);
            imageIcon = new ImageIcon(GrayFilter.createDisabledImage(imageIcon2.getImage()));
            this.zoom_btn = new JRadioButton(imageIcon);
            this.zoom_btn.setSelectedIcon(imageIcon2);
            this.zoom_btn.setBorderPainted(true);
        } else {
            this.zoom_btn = new JRadioButton("zoom");
        }
        this.zoom_btn.setToolTipText("Left mouse button click to Zoom");
        this.zoom_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ViewportTime.this.zoom_btn.isSelected()) {
                    ViewportTime.this.isLeftMouseClick4Zoom = true;
                }
            }
        });
        if (this.isLeftMouseClick4Zoom) {
            this.zoom_btn.doClick();
        }
        buttonGroup.add(this.zoom_btn);
        uRL = this.getURL("/images/HandOpen16.gif");
        if (uRL != null) {
            imageIcon2 = new ImageIcon(uRL);
            imageIcon = new ImageIcon(GrayFilter.createDisabledImage(imageIcon2.getImage()));
            this.hand_btn = new JRadioButton(imageIcon);
            this.hand_btn.setSelectedIcon(imageIcon2);
            this.hand_btn.setBorderPainted(true);
        } else {
            this.hand_btn = new JRadioButton("hand");
        }
        this.hand_btn.setToolTipText("Left mouse button click to Scroll");
        this.hand_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ViewportTime.this.hand_btn.isSelected()) {
                    ViewportTime.this.isLeftMouseClick4Zoom = false;
                }
            }
        });
        if (!this.isLeftMouseClick4Zoom) {
            this.hand_btn.doClick();
        }
        buttonGroup.add(this.hand_btn);
    }

    public JPanel createLeftMouseModePanel(int n) {
        JPanel jPanel = null;
        jPanel = null;
        if (this.zoom_btn != null && this.hand_btn != null) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, n));
            jPanel.add(this.zoom_btn);
            jPanel.add(this.hand_btn);
            jPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        return jPanel;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor == CustomCursor.Normal) {
            if (this.isLeftMouseClick4Zoom) {
                super.setCursor(CustomCursor.ZoomPlus);
            } else {
                super.setCursor(CustomCursor.HandOpen);
            }
        } else {
            super.setCursor(cursor);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.requestFocus();
        if (this.isLeftMouseClick4Zoom) {
            super.setCursor(CustomCursor.ZoomPlus);
        } else {
            super.setCursor(CustomCursor.HandOpen);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (Routines.isLeftMouseButton(mouseEvent) && this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            double d = this.coord_xform.convertPixelToTime(point.x);
            this.time_model.setTimeZoomFocus(d);
            if (Parameters.LEFTCLICK_INSTANT_ZOOM) {
                if (mouseEvent.isShiftDown()) {
                    this.time_model.zoomOut();
                    super.setCursor(CustomCursor.ZoomMinus);
                } else {
                    this.time_model.zoomIn();
                    super.setCursor(CustomCursor.ZoomPlus);
                }
                super.requestFocus();
                if (this.toolbar != null) {
                    this.toolbar.resetZoomButtons();
                }
            } else {
                this.repaint();
            }
        }
        super.requestFocus();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.vport_timebox.setEarliestTime(this.time_model.getTimeViewPosition());
        this.vport_timebox.setLatestFromEarliest(this.time_model.getTimeViewExtent());
        this.coord_xform.resetTimeBounds(this.vport_timebox);
        Point point = mouseEvent.getPoint();
        double d = this.coord_xform.convertPixelToTime(point.x);
        if (Routines.isLeftMouseButton(mouseEvent)) {
            if (this.isLeftMouseClick4Zoom) {
                this.zoom_timebox = new TimeBoundingBox();
                this.zoom_timebox.setZeroDuration(d);
                this.repaint();
                super.setCursor(CustomCursor.ZoomPlus);
            } else {
                super.setCursor(CustomCursor.HandClose);
            }
        } else if (Routines.isRightMouseButton(mouseEvent)) {
            this.info_timebox = new TimeBoundingBox();
            this.info_timebox.setZeroDuration(d);
            this.repaint();
        }
        this.mouse_pressed_time = d;
        this.mouse_pressed_Xloc = point.x;
        this.mouse_last_Xloc = point.x;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() && super.getCursor() == CustomCursor.ZoomMinus) {
            super.setCursor(CustomCursor.ZoomPlus);
        }
        Point point = mouseEvent.getPoint();
        double d = this.coord_xform.convertPixelToTime(point.x);
        if (Routines.isLeftMouseButton(mouseEvent)) {
            if (this.isLeftMouseClick4Zoom) {
                if (this.zoom_timebox != null) {
                    if (d > this.mouse_pressed_time) {
                        this.zoom_timebox.setLatestTime(d);
                    } else {
                        this.zoom_timebox.setEarliestTime(d);
                    }
                    this.repaint();
                }
            } else if (point.x != this.mouse_last_Xloc) {
                this.time_model.scroll(this.mouse_last_Xloc - point.x);
                this.mouse_last_Xloc = point.x;
                super.setCursor(CustomCursor.HandClose);
            }
        } else if (Routines.isRightMouseButton(mouseEvent)) {
            if (d > this.mouse_pressed_time) {
                this.info_timebox.setLatestTime(d);
            } else {
                this.info_timebox.setEarliestTime(d);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        double d = this.coord_xform.convertPixelToTime(point.x);
        if (Routines.isLeftMouseButton(mouseEvent)) {
            if (this.isLeftMouseClick4Zoom) {
                if (this.zoom_timebox != null) {
                    if (d > this.mouse_pressed_time) {
                        this.zoom_timebox.setLatestTime(d);
                    } else {
                        this.zoom_timebox.setEarliestTime(d);
                    }
                    this.repaint();
                    if (Math.abs(point.x - this.mouse_pressed_Xloc) >= Parameters.MIN_WIDTH_TO_DRAG) {
                        this.time_model.zoomRapidly(this.zoom_timebox.getEarliestTime(), this.zoom_timebox.getDuration());
                        double d2 = (this.zoom_timebox.getEarliestTime() + this.zoom_timebox.getLatestTime()) / 2.0;
                        this.time_model.setTimeZoomFocus(d2);
                    }
                    this.zoom_timebox = null;
                    this.repaint();
                    super.setCursor(CustomCursor.ZoomPlus);
                    if (this.toolbar != null) {
                        this.toolbar.resetZoomButtons();
                    }
                }
            } else {
                if (point.x != this.mouse_last_Xloc) {
                    this.time_model.scroll(this.mouse_last_Xloc - point.x);
                    this.mouse_last_Xloc = point.x;
                }
                super.setCursor(CustomCursor.HandOpen);
            }
        } else if (Routines.isRightMouseButton(mouseEvent)) {
            InfoDialog infoDialog;
            if (d > this.mouse_pressed_time) {
                this.info_timebox.setLatestTime(d);
            } else {
                this.info_timebox.setEarliestTime(d);
            }
            ScrollableObject scrollableObject = (ScrollableObject)this.view_img;
            if (Math.abs(point.x - this.mouse_pressed_Xloc) >= Parameters.MIN_WIDTH_TO_DRAG) {
                Window window = SwingUtilities.windowForComponent(this);
                infoDialog = window instanceof Frame ? new InfoDialogForDuration((Frame)window, this.info_timebox, scrollableObject) : new InfoDialogForDuration((Dialog)window, this.info_timebox, scrollableObject);
            } else {
                Point point2 = SwingUtilities.convertPoint(this, point, scrollableObject);
                infoDialog = scrollableObject.getPropertyAt(point2, this.vport_timebox);
            }
            Point point3 = new Point(point);
            SwingUtilities.convertPointToScreen(point3, this);
            infoDialog.setVisibleAtLocation(point3);
            infoDialog.getCloseButton().addActionListener(this.info_action_listener);
            infoDialog.addWindowListener(this.info_window_listener);
            this.info_dialogs.add(infoDialog);
            this.info_timebox = null;
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16 && super.getCursor() == CustomCursor.ZoomMinus) {
            super.setCursor(CustomCursor.ZoomPlus);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            if (super.getCursor() == CustomCursor.ZoomPlus) {
                super.setCursor(CustomCursor.ZoomMinus);
            }
        } else if (keyEvent.getKeyCode() == 27 && this.zoom_timebox != null) {
            this.zoom_timebox = null;
            this.repaint();
        }
    }

    public void resetToolBarZoomButtons() {
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
    }

    protected InfoDialog getLastInfoDialog() {
        int n = this.info_dialogs.size();
        if (n > 0) {
            return (InfoDialog)this.info_dialogs.get(n - 1);
        }
        return null;
    }

    private class InfoDialogWindowListener
    extends WindowAdapter {
        private ViewportTime viewport;
        private List info_dialogs;

        public InfoDialogWindowListener(ViewportTime viewportTime2, List list) {
            this.viewport = viewportTime2;
            this.info_dialogs = list;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            for (InfoDialog infoDialog : this.info_dialogs) {
                if (object != infoDialog) continue;
                this.info_dialogs.remove(infoDialog);
                infoDialog.dispose();
                this.viewport.repaint();
                break;
            }
        }
    }

    private class InfoDialogActionListener
    implements ActionListener {
        private ViewportTime viewport;
        private List info_dialogs;

        public InfoDialogActionListener(ViewportTime viewportTime2, List list) {
            this.viewport = viewportTime2;
            this.info_dialogs = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            for (InfoDialog infoDialog : this.info_dialogs) {
                if (object != infoDialog.getCloseButton()) continue;
                this.info_dialogs.remove(infoDialog);
                infoDialog.dispose();
                this.viewport.repaint();
                break;
            }
        }
    }
}

