/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.Drawable;
import cern.colt.map.OpenIntIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoDialogForDrawable;
import viewer.zoomable.ModelTime;
import viewer.zoomable.SearchDialog;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.SearchableView;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class ViewportTimeYaxis
extends ViewportTime
implements AdjustmentListener,
MouseWheelListener {
    private static final long serialVersionUID = 4300L;
    private static final Color SEARCH_LINE_COLOR = Color.yellow;
    private ModelTime time_model = null;
    private YaxisMaps y_maps = null;
    private YaxisTree tree_view = null;
    private JScrollBar y_scrollbar = null;
    private Point view_pt = null;
    private ComponentEvent resize_evt = null;
    private SearchableView searchable = null;
    private SearchDialog search_dialog = null;
    private Drawable searched_dobj = null;
    private double searching_time;
    private static final double INVALID_TIME = Double.NEGATIVE_INFINITY;
    private double searched_time = Double.NEGATIVE_INFINITY;
    private int mouse_last_Yloc;
    private double ratio_ybar2vportH;

    public ViewportTimeYaxis(ModelTime modelTime, JScrollBar jScrollBar, YaxisMaps yaxisMaps) {
        super(modelTime);
        this.time_model = modelTime;
        this.y_maps = yaxisMaps;
        this.tree_view = this.y_maps.getTreeView();
        this.y_scrollbar = jScrollBar;
        this.view_pt = new Point(0, 0);
        this.resize_evt = new ComponentEvent(this, 101);
        this.searching_time = this.time_model.getTimeGlobalMinimum();
        this.addMouseWheelListener(this);
    }

    @Override
    public void setView(Component component) {
        super.setView(component);
        this.searchable = component instanceof SearchableView ? (SearchableView)((Object)component) : null;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s START: ");
            Debug.println("adj_evt = " + adjustmentEvent);
        }
        this.view_pt.x = super.getXaxisViewPosition();
        this.view_pt.y = adjustmentEvent.getValue();
        super.setYaxisViewPosition(this.view_pt.y);
        super.setViewPosition(this.view_pt);
        super.repaint();
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s END: ");
        }
    }

    public void fireComponentResized() {
        super.componentResized(this.resize_evt);
    }

    public void updateDrawableInfoDialogs() {
        for (InfoDialog infoDialog : this.info_dialogs) {
            if (!(infoDialog instanceof InfoDialogForDrawable)) continue;
            InfoDialogForDrawable infoDialogForDrawable = (InfoDialogForDrawable)infoDialog;
            infoDialogForDrawable.updateMarkerVertex();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s START: ");
        }
        super.paint(graphics);
        Rectangle rectangle = SwingUtilities.getLocalBounds(this);
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis.paint: local_bounds=" + rectangle);
        }
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, (Component)((Object)this.searchable));
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis.paint: vport_bounds=" + rectangle2);
        }
        this.coord_xform.resetYaxisPixelBounds(rectangle2.y, rectangle2.y + rectangle2.height - 1);
        this.coord_xform.resetRowHeight(this.tree_view.getRowHeight());
        OpenIntIntHashMap openIntIntHashMap = this.y_maps.getMapOfLineIDToRowID();
        if (openIntIntHashMap == null) {
            if (!this.y_maps.update()) {
                Dialogs.error(SwingUtilities.windowForComponent(this), "Error in updating YaxisMaps!");
            }
            openIntIntHashMap = this.y_maps.getMapOfLineIDToRowID();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (InfoDialog infoDialog : this.info_dialogs) {
            if (!(infoDialog instanceof InfoDialogForDrawable)) continue;
            InfoDialogForDrawable infoDialogForDrawable = (InfoDialogForDrawable)infoDialog;
            double d = infoDialogForDrawable.getClickedTime();
            if (this.coord_xform.contains(d)) {
                n = this.coord_xform.convertTimeToPixel(d);
                graphics.setColor(ViewportTime.INFO_LINE_COLOR);
                graphics.drawLine(n, 0, n, this.getHeight());
            }
            Drawable drawable = infoDialogForDrawable.getDrawable();
            if (Parameters.HIGHLIGHT_CLICKED_OBJECT) {
                drawable.drawOnViewport(graphics2D, this.coord_xform, openIntIntHashMap);
            }
            if (!Parameters.POINTER_ON_CLICKED_OBJECT) continue;
            drawable.drawPointerOnViewport(graphics2D, this.coord_xform, infoDialogForDrawable.getMarkerVertex());
        }
        if (this.coord_xform.contains(this.searching_time)) {
            n = this.coord_xform.convertTimeToPixel(this.searching_time);
            graphics.setColor(SEARCH_LINE_COLOR);
            graphics.drawLine(n, 0, n, this.getHeight());
        }
        if (this.searched_dobj != null) {
            this.searched_dobj.drawSearchableOnViewport(graphics2D, this.coord_xform, openIntIntHashMap);
        }
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s END: ");
        }
    }

    public void eraseSearchedDrawable() {
        this.searched_dobj = null;
    }

    public boolean searchBackward() {
        SearchPanel searchPanel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchBackward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((searchPanel = this.searching_time != this.searched_time ? this.searchable.searchPreviousComponent(this.searching_time) : this.searchable.searchPreviousComponent()) != null) {
            this.searched_dobj = searchPanel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(searchPanel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getEarliestTime() == this.time_model.getTimeGlobalMinimum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The FIRST drawable in the logfile has been reached.\n  Search backward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the logfile's beginning is not within view,\nSCROLL BACKWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchForward() {
        SearchPanel searchPanel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchForward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((searchPanel = this.searching_time != this.searched_time ? this.searchable.searchNextComponent(this.searching_time) : this.searchable.searchNextComponent()) != null) {
            this.searched_dobj = searchPanel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(searchPanel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getLatestTime() == this.time_model.getTimeGlobalMaximum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The LAST drawable in the logfile has been reached.\n  Search forward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the end of the logfile is not within view,\nSCROLL FORWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchInit() {
        InfoDialog infoDialog = super.getLastInfoDialog();
        if (infoDialog != null) {
            this.searching_time = infoDialog.getClickedTime();
            infoDialog.getCloseButton().doClick();
            this.repaint();
            return true;
        }
        Dialogs.warn(SwingUtilities.windowForComponent(this), "No info dialog box! Info dialog box can be set\nby right mouse clicking on the timeline canvas\n");
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (Routines.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            this.searching_time = this.coord_xform.convertPixelToTime(point.x);
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (Routines.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            this.mouse_last_Yloc = point.y;
            this.ratio_ybar2vportH = (double)this.y_scrollbar.getVisibleAmount() / (double)this.getHeight();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (Routines.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            int n = this.mouse_last_Yloc - point.y;
            int n2 = (int)Math.round(this.ratio_ybar2vportH * (double)n);
            this.y_scrollbar.setValue(this.y_scrollbar.getValue() + n2);
            this.mouse_last_Yloc = point.y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (Routines.isLeftMouseButton(mouseEvent)) {
            if (!this.isLeftMouseClick4Zoom) {
                Point point = mouseEvent.getPoint();
                int n = this.mouse_last_Yloc - point.y;
                int n2 = (int)Math.round(this.ratio_ybar2vportH * (double)n);
                this.y_scrollbar.setValue(this.y_scrollbar.getValue() + n2);
                this.mouse_last_Yloc = point.y;
            }
        } else if (Routines.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis:mouseWheelMoved() -- " + mouseWheelEvent);
        }
        int n = mouseWheelEvent.getScrollType() == 0 ? mouseWheelEvent.getUnitsToScroll() * this.y_scrollbar.getUnitIncrement(1) : (mouseWheelEvent.getWheelRotation() < 0 ? this.y_scrollbar.getBlockIncrement(-1) : this.y_scrollbar.getBlockIncrement(1));
        this.y_scrollbar.setValue(this.y_scrollbar.getValue() + n);
    }
}

