/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import cern.colt.function.IntIntProcedure;
import cern.colt.map.OpenIntIntHashMap;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import logformat.slog2.LineIDMap;
import viewer.common.Parameters;
import viewer.zoomable.IntegerArrayComparator;
import viewer.zoomable.YaxisTree;
import viewer.zoomable.YaxisTreeNode;

public class YaxisMaps {
    private LineIDMap lineIDmap;
    private YaxisTreeNode y_treeroot;
    private YaxisTree tree_view;
    private Map map_line2treeleaf;
    private Map map_treepath2row;
    private OpenIntIntHashMap map_line2row;

    public YaxisMaps(LineIDMap lineIDMap) {
        this.lineIDmap = lineIDMap;
        this.y_treeroot = null;
        this.tree_view = null;
        this.map_line2treeleaf = null;
        this.map_treepath2row = null;
        this.map_line2row = null;
    }

    public LineIDMap getLineIDMap() {
        return this.lineIDmap;
    }

    public YaxisTreeNode getTreeRoot() {
        if (this.y_treeroot == null) {
            this.y_treeroot = new YaxisTreeNode(Parameters.Y_AXIS_ROOT_LABEL);
            this.convertLineIDMapToTree();
        }
        return this.y_treeroot;
    }

    public void setTreeView(YaxisTree yaxisTree) {
        this.tree_view = yaxisTree;
        if (this.map_line2treeleaf == null) {
            this.map_line2treeleaf = new TreeMap();
            this.setMapOfLineIDToTreeLeaf();
        }
    }

    public YaxisTree getTreeView() {
        return this.tree_view;
    }

    public Map getMapOfLineIDToTreeLeaf() {
        return this.map_line2treeleaf;
    }

    public Map getMapOfTreePathToRowID() {
        return this.map_treepath2row;
    }

    public OpenIntIntHashMap getMapOfLineIDToRowID() {
        return this.map_line2row;
    }

    public boolean update() {
        this.updateMapOfTreePathToRowID();
        return this.updateMapOfLineIDToRowID();
    }

    private void convertLineIDMapToTree() {
        TreeSet treeSet = new TreeSet(new IntegerArrayComparator());
        treeSet.addAll(this.lineIDmap.values());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            YaxisTreeNode yaxisTreeNode = this.y_treeroot;
            Integer[] integerArray = (Integer[])iterator.next();
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                YaxisTreeNode yaxisTreeNode2 = yaxisTreeNode.getChild(n);
                if (yaxisTreeNode2 == null) {
                    yaxisTreeNode2 = new YaxisTreeNode(n);
                    yaxisTreeNode.add(yaxisTreeNode2);
                }
                yaxisTreeNode = yaxisTreeNode2;
            }
        }
    }

    private boolean setMapOfLineIDToTreeLeaf() {
        boolean bl = true;
        Iterator iterator = this.lineIDmap.entrySet().iterator();
        while (iterator.hasNext()) {
            YaxisTreeNode yaxisTreeNode = this.y_treeroot;
            Map.Entry entry = iterator.next();
            Integer[] integerArray = (Integer[])entry.getValue();
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n = integerArray[i];
                YaxisTreeNode yaxisTreeNode2 = yaxisTreeNode.getChild(n);
                if (yaxisTreeNode2 == null) {
                    yaxisTreeNode2 = new YaxisTreeNode(n);
                    yaxisTreeNode.add(yaxisTreeNode2);
                    System.err.println("YaxisMaps.setMapOfLineIDToTreeLeaf(): Unexpected Error!\n\t user object " + n + " is NOT found under the root! ");
                    bl = false;
                }
                yaxisTreeNode = yaxisTreeNode2;
            }
            this.map_line2treeleaf.put(entry.getKey(), yaxisTreeNode);
        }
        return bl;
    }

    private void updateMapOfTreePathToRowID() {
        if (this.map_treepath2row == null) {
            this.map_treepath2row = new HashMap();
        } else {
            this.map_treepath2row.clear();
        }
        int n = this.tree_view.getRowCount();
        for (int i = 0; i < n; ++i) {
            TreePath treePath = this.tree_view.getPathForRow(i);
            this.map_treepath2row.put(treePath, new Integer(i));
        }
    }

    private boolean updateMapOfLineIDToRowID() {
        if (this.map_line2row == null) {
            this.map_line2row = new OpenIntIntHashMap();
        } else {
            this.map_line2row.clear();
        }
        boolean bl = true;
        for (Map.Entry entry : this.map_line2treeleaf.entrySet()) {
            Integer n = (Integer)entry.getKey();
            YaxisTreeNode yaxisTreeNode = (YaxisTreeNode)entry.getValue();
            Integer n2 = null;
            for (TreePath treePath = new TreePath(yaxisTreeNode.getPath()); n2 == null && treePath != null; treePath = treePath.getParentPath()) {
                n2 = (Integer)this.map_treepath2row.get(treePath);
            }
            if (n2 == null) {
                bl = false;
            }
            this.map_line2row.put(n, n2);
        }
        return bl;
    }

    public static String stringFromYaxisRoot(YaxisTreeNode yaxisTreeNode) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = yaxisTreeNode.getLevel();
        Enumeration<TreeNode> enumeration = yaxisTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            YaxisTreeNode yaxisTreeNode2 = (YaxisTreeNode)enumeration.nextElement();
            if (n != yaxisTreeNode2.getLevel()) {
                n = yaxisTreeNode2.getLevel();
                stringBuffer.append("\n");
            }
            stringBuffer.append(" " + yaxisTreeNode2);
        }
        return stringBuffer.toString();
    }

    public String stringForYaxisTree() {
        return "YaxisTree:\n" + YaxisMaps.stringFromYaxisRoot(this.y_treeroot);
    }

    public static String stringForMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            stringBuffer.append(" [ " + entry.getKey() + " ] => " + entry.getValue() + "\n");
        }
        return stringBuffer.toString();
    }

    public static String stringForIntIntMap(OpenIntIntHashMap openIntIntHashMap) {
        final StringBuffer stringBuffer = new StringBuffer();
        openIntIntHashMap.forEachPair(new IntIntProcedure(){

            @Override
            public boolean apply(int n, int n2) {
                stringBuffer.append(" [ " + n + " ] => " + n2 + "\n");
                return true;
            }
        });
        return stringBuffer.toString();
    }

    public String stringForMapOfLineIDToTreeLeaf() {
        StringBuffer stringBuffer = new StringBuffer("MapOfLineIDToTreeLeaf:\n");
        for (Map.Entry entry : this.map_line2treeleaf.entrySet()) {
            stringBuffer.append(" [ " + entry.getKey() + " ] => { ");
            TreeNode[] treeNodeArray = ((YaxisTreeNode)entry.getValue()).getPath();
            int n = treeNodeArray.length - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(treeNodeArray[i] + " ");
            }
            stringBuffer.append("(" + treeNodeArray[n] + ") }\n");
        }
        return stringBuffer.toString();
    }

    public String stringForMapOfTreePathToRowID() {
        return "MapOfTreePathToRowID:\n" + YaxisMaps.stringForMap(this.map_treepath2row);
    }

    public String stringForMapOfLineIDToRowID() {
        return "MapOfLineIDToRowID:\n" + YaxisMaps.stringForIntIntMap(this.map_line2row);
    }

    public void printMaps(PrintStream printStream) {
        printStream.println(this.stringForMapOfLineIDToTreeLeaf());
        printStream.println(this.stringForMapOfTreePathToRowID());
        printStream.println(this.stringForMapOfLineIDToRowID());
    }
}

