/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ColorAlpha
extends Color
implements Comparable,
DataIO {
    private static final long serialVersionUID = 100L;
    public static final int BYTESIZE = 5;
    public static final int OPAQUE = 255;
    public static final int NEAR_OPAQUE = 191;
    public static final int HALF_OPAQUE = 127;
    public static final int NEAR_TRANSPARENT = 63;
    public static final int TRANSPARENT = 0;
    public static final ColorAlpha WHITE_NEAR_OPAQUE = new ColorAlpha(white, 191);
    public static final ColorAlpha WHITE_OPAQUE = new ColorAlpha(white, 255);
    public static final ColorAlpha YELLOW_OPAQUE = new ColorAlpha(yellow, 255);
    public static final ColorAlpha ORANGE_OPAQUE = new ColorAlpha(orange, 255);
    public static final ColorAlpha GRAY_OPAQUE = new ColorAlpha(gray, 255);
    private boolean isModifiable;
    private static ColorAlpha[] colors;
    private static int colors_step;
    private static int next_color_index;

    public ColorAlpha() {
        super(255, 192, 203, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3) {
        super(n, n2, n3, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(Color color, int n) {
        super(color.getRed(), color.getGreen(), color.getBlue(), n);
        this.isModifiable = true;
    }

    public ColorAlpha(Color color) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.isModifiable = bl;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(super.getRGB());
        dataOutput.writeBoolean(this.isModifiable);
    }

    public ColorAlpha(DataInput dataInput) throws IOException {
        super(dataInput.readInt(), true);
        this.isModifiable = dataInput.readBoolean();
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        System.err.println("ColorAlpha.readObject() should NOT called");
    }

    @Override
    public String toString() {
        return "(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "," + this.getAlpha() + "," + this.isModifiable + ")";
    }

    public int getLengthSq() {
        return super.getRed() * super.getRed() + super.getGreen() * super.getGreen() + super.getBlue() * super.getBlue();
    }

    public int getBrightness() {
        return (int)(0.299 * (double)super.getRed() + 0.587 * (double)super.getGreen() + 0.114 * (double)super.getBlue());
    }

    public int getBrightContrast(ColorAlpha colorAlpha) {
        return Math.abs(this.getBrightness() - colorAlpha.getBrightness());
    }

    public int getHueContrast(ColorAlpha colorAlpha) {
        return Math.abs(super.getRed() - colorAlpha.getRed()) + Math.abs(super.getGreen() - colorAlpha.getGreen()) + Math.abs(super.getBlue() - colorAlpha.getBlue());
    }

    public boolean equals(ColorAlpha colorAlpha) {
        return super.getRed() == colorAlpha.getRed() && super.getGreen() == colorAlpha.getGreen() && super.getBlue() == colorAlpha.getBlue();
    }

    public int compareTo(Object object) {
        ColorAlpha colorAlpha = (ColorAlpha)object;
        if (!this.equals(colorAlpha)) {
            return 4 * this.getBrightContrast(colorAlpha) + this.getHueContrast(colorAlpha);
        }
        return 0;
    }

    public ColorAlpha getHalfOpaque() {
        return new ColorAlpha(this, 127);
    }

    public ColorAlpha getDarkerContrast() {
        ColorAlpha colorAlpha = new ColorAlpha(this.darker().darker(), this.getAlpha());
        if (colorAlpha.equals(this)) {
            colorAlpha = new ColorAlpha(this.brighter().brighter(), this.getAlpha());
        }
        return colorAlpha;
    }

    public ColorAlpha getBrighterContrast() {
        ColorAlpha colorAlpha = new ColorAlpha(this.brighter().brighter(), this.getAlpha());
        if (colorAlpha.equals(this)) {
            colorAlpha = new ColorAlpha(this.darker().darker(), this.getAlpha());
        }
        return colorAlpha;
    }

    private static void initDefaultColors() {
        int[] nArray = new int[]{0, 51, 102, 153, 204, 255};
        int n = nArray.length;
        int n2 = n * n * n - 2;
        colors_step = n * n * n / 2;
        colors = new ColorAlpha[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    boolean bl;
                    boolean bl2 = i == 0 && j == 0 && k == 0;
                    boolean bl3 = bl = i == n - 1 && j == i && k == i;
                    if (bl2 || bl) continue;
                    ColorAlpha.colors[n3] = new ColorAlpha(nArray[i], nArray[j], nArray[k]);
                    ++n3;
                }
            }
        }
        Arrays.sort(colors);
        next_color_index = 10;
    }

    public static ColorAlpha getNextDefaultColor() {
        if (colors == null) {
            ColorAlpha.initDefaultColors();
        }
        int n = next_color_index % colors.length;
        next_color_index += colors_step;
        return colors[n];
    }

    public static final void main(String[] stringArray) {
        ColorAlpha colorAlpha = ColorAlpha.getNextDefaultColor();
        System.out.println(colorAlpha);
        ColorAlpha colorAlpha2 = colorAlpha;
        for (int i = 1; i < 214; ++i) {
            colorAlpha = ColorAlpha.getNextDefaultColor();
            int n = colorAlpha.getBrightContrast(colorAlpha2);
            int n2 = colorAlpha.getHueContrast(colorAlpha2);
            boolean bl = n > 125 && n2 > 500;
            System.out.println(i + ": \t" + colorAlpha + "\t" + n + "\t" + n2 + "\t" + bl);
            colorAlpha = colorAlpha2;
        }
    }
}

