/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.list.AbstractCollection;
import java.util.Collection;

public abstract class AbstractList
extends AbstractCollection {
    protected AbstractList() {
    }

    public void addAllOf(Collection collection) {
        this.beforeInsertAllOf(this.size(), collection);
    }

    public void beforeInsertAllOf(int n, Collection collection) {
        this.beforeInsertDummies(n, collection.size());
        this.replaceFromWith(n, collection);
    }

    protected abstract void beforeInsertDummies(int var1, int var2);

    protected static void checkRange(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    protected static void checkRangeFromTo(int n, int n2, int n3) {
        if (n2 == n - 1) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= n3) {
            throw new IndexOutOfBoundsException("from: " + n + ", to: " + n2 + ", size=" + n3);
        }
    }

    @Override
    public void clear() {
        this.removeFromTo(0, this.size() - 1);
    }

    public final void mergeSort() {
        this.mergeSortFromTo(0, this.size() - 1);
    }

    public abstract void mergeSortFromTo(int var1, int var2);

    public final void quickSort() {
        this.quickSortFromTo(0, this.size() - 1);
    }

    public abstract void quickSortFromTo(int var1, int var2);

    public void remove(int n) {
        this.removeFromTo(n, n);
    }

    public abstract void removeFromTo(int var1, int var2);

    public abstract void replaceFromWith(int var1, Collection var2);

    public abstract void reverse();

    public void setSize(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("newSize:" + n);
        }
        int n2 = this.size();
        if (n != n2) {
            if (n > n2) {
                this.beforeInsertDummies(n2, n - n2);
            } else if (n < n2) {
                this.removeFromTo(n, n2 - 1);
            }
        }
    }

    public final void shuffle() {
        this.shuffleFromTo(0, this.size() - 1);
    }

    public abstract void shuffleFromTo(int var1, int var2);

    public final void sort() {
        this.sortFromTo(0, this.size() - 1);
    }

    public void sortFromTo(int n, int n2) {
        this.quickSortFromTo(n, n2);
    }

    public void trimToSize() {
    }
}

