/*
 * @(#)$Id: RootState.java,v 1.6 2003/06/09 20:37:34 kk122374 Exp $
 *
 * Copyright 2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.msv.reader.xmlschema;

import com.sun.msv.reader.State;

/**
 * RootIncludedSchemaState + final wrap up.
 * 
 * @author <a href="mailto:kohsuke.kawaguchi@eng.sun.com">Kohsuke KAWAGUCHI</a>
 */
public class RootState extends RootIncludedSchemaState {
    
    protected RootState( State topLevelState ) {
        super(topLevelState);
    }
    
    protected void endSelf() {
        final XMLSchemaReader reader = (XMLSchemaReader)this.reader;
        // perform final wrap up.
        reader.wrapUp();
        super.endSelf();
    }
}
