#!/usr/bin/perl

# Copyright 2015-2021 The Mumble Developers. All rights reserved.
# Use of this source code is governed by a BSD-style license
# that can be found in the LICENSE file at the root of the
# Mumble source tree or at <https://www.mumble.info/LICENSE>.

# perl avail_mac.pl < overlay.c init_mac.c > avail_mac.h

%funcs = ();
while (<STDIN>) {
	foreach (split(/([ \t])/, $_)) {
		@glfunc = ($_ =~ /(gl[A-VY-Z0-9][a-zA-Z0-9]+)/);
		foreach $func(@glfunc) {
			$funcs{$func} = 1;
		}
	}
}

print "#ifndef MUMBLE_OVERLAY_AVAIL_MAC_H__\n";
print "#define MUMBLE_OVERLAY_AVAIL_MAC_H__\n";
print "\n";
print "// This file was auto-generated by 'avail_mac.pl'. Do not touch by hand.\n";
print "\n";
print "#define AVAIL_ALL_GLSYM ( \\\n";
foreach my $key (sort keys %funcs) {
	print "\tAVAIL($key) && \\\n";
}
print "\t1)\n";
print "\n";
print "#endif\n";
