/* Copyright (C) 2003 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef SIGNAL_DATA_H
#define SIGNAL_DATA_H

#include <ndb_global.h>
#include <kernel/ndb_limits.h>
#include <kernel/kernel_types.h>
#include <BaseString.hpp>

#define ASSERT_BOOL(flag, message) assert(flag<=1)
#define ASSERT_RANGE(value, min, max, message) \
 assert((value) >= (min) && (value) <= (max))
#define ASSERT_MAX(value, max, message) assert((value) <= (max))

#define SECTION(x) STATIC_CONST(x)

// defines for setter and getters on commonly used member data in signals

#define GET_SET_SENDERDATA \
  Uint32 getSenderData() { return senderData; }; \
  void setSenderData(Uint32 _s) { senderData = _s; };

#define GET_SET_SENDERREF \
  Uint32 getSenderRef() { return senderRef; }; \
  void setSenderRef(Uint32 _s) { senderRef = _s; };

#define GET_SET_PREPAREID \
  Uint32 getPrepareId() { return prepareId; }; \
  void setPrepareId(Uint32 _s) { prepareId = _s; };

#define GET_SET_ERRORCODE \
  Uint32 getErrorCode() { return errorCode; }; \
  void setErrorCode(Uint32 _s) { errorCode = _s; };

#define GET_SET_TCERRORCODE \
  Uint32 getTCErrorCode() { return TCErrorCode; }; \
  void setTCErrorCode(Uint32 _s) { TCErrorCode = _s; };

#define GSN_PRINT_SIGNATURE(f) bool f(FILE *, const Uint32 *, Uint32, Uint16)

GSN_PRINT_SIGNATURE(printTCKEYREQ);
GSN_PRINT_SIGNATURE(printTCKEYCONF);
GSN_PRINT_SIGNATURE(printTCKEYREF);
GSN_PRINT_SIGNATURE(printLQHKEYREQ);
GSN_PRINT_SIGNATURE(printLQHKEYCONF);
GSN_PRINT_SIGNATURE(printLQHKEYREF);
GSN_PRINT_SIGNATURE(printTUPKEYREQ);
GSN_PRINT_SIGNATURE(printTUPKEYCONF);
GSN_PRINT_SIGNATURE(printTUPKEYREF);
GSN_PRINT_SIGNATURE(printTUPCOMMITREQ);
GSN_PRINT_SIGNATURE(printCONTINUEB);
GSN_PRINT_SIGNATURE(printFSOPENREQ);
GSN_PRINT_SIGNATURE(printFSCLOSEREQ);
GSN_PRINT_SIGNATURE(printFSREADWRITEREQ);
GSN_PRINT_SIGNATURE(printFSREADWRITEREQ);
GSN_PRINT_SIGNATURE(printFSREF);
GSN_PRINT_SIGNATURE(printFSREF);
GSN_PRINT_SIGNATURE(printFSREF);
GSN_PRINT_SIGNATURE(printFSREF);
GSN_PRINT_SIGNATURE(printFSREF);
GSN_PRINT_SIGNATURE(printFSCONF);
GSN_PRINT_SIGNATURE(printFSCONF);
GSN_PRINT_SIGNATURE(printFSCONF);
GSN_PRINT_SIGNATURE(printFSCONF);
GSN_PRINT_SIGNATURE(printFSCONF);
GSN_PRINT_SIGNATURE(printCLOSECOMREQCONF);
GSN_PRINT_SIGNATURE(printCLOSECOMREQCONF);
GSN_PRINT_SIGNATURE(printPACKED_SIGNAL);
GSN_PRINT_SIGNATURE(printPREPFAILREQREF);
GSN_PRINT_SIGNATURE(printPREPFAILREQREF);
GSN_PRINT_SIGNATURE(printALTER_TABLE_REQ);
GSN_PRINT_SIGNATURE(printALTER_TABLE_CONF);
GSN_PRINT_SIGNATURE(printALTER_TABLE_REF);
GSN_PRINT_SIGNATURE(printALTER_TAB_REQ);
GSN_PRINT_SIGNATURE(printALTER_TAB_CONF);
GSN_PRINT_SIGNATURE(printALTER_TAB_REF);
GSN_PRINT_SIGNATURE(printCREATE_TRIG_REQ);
GSN_PRINT_SIGNATURE(printCREATE_TRIG_CONF);
GSN_PRINT_SIGNATURE(printCREATE_TRIG_REF);
GSN_PRINT_SIGNATURE(printALTER_TRIG_REQ);
GSN_PRINT_SIGNATURE(printALTER_TRIG_CONF);
GSN_PRINT_SIGNATURE(printALTER_TRIG_REF);
GSN_PRINT_SIGNATURE(printDROP_TRIG_REQ);
GSN_PRINT_SIGNATURE(printDROP_TRIG_CONF);
GSN_PRINT_SIGNATURE(printDROP_TRIG_REF);
GSN_PRINT_SIGNATURE(printFIRE_TRIG_ORD);
GSN_PRINT_SIGNATURE(printTRIG_ATTRINFO);
GSN_PRINT_SIGNATURE(printCREATE_INDX_REQ);
GSN_PRINT_SIGNATURE(printCREATE_INDX_CONF);
GSN_PRINT_SIGNATURE(printCREATE_INDX_REF);
GSN_PRINT_SIGNATURE(printDROP_INDX_REQ);
GSN_PRINT_SIGNATURE(printDROP_INDX_CONF);
GSN_PRINT_SIGNATURE(printDROP_INDX_REF);
GSN_PRINT_SIGNATURE(printALTER_INDX_REQ);
GSN_PRINT_SIGNATURE(printALTER_INDX_CONF);
GSN_PRINT_SIGNATURE(printALTER_INDX_REF);
GSN_PRINT_SIGNATURE(printTCINDXREQ);
GSN_PRINT_SIGNATURE(printTCINDXCONF);
GSN_PRINT_SIGNATURE(printTCINDXREF);
GSN_PRINT_SIGNATURE(printINDXKEYINFO);
GSN_PRINT_SIGNATURE(printINDXATTRINFO);
GSN_PRINT_SIGNATURE(printFSAPPENDREQ);
GSN_PRINT_SIGNATURE(printBACKUP_REQ);
GSN_PRINT_SIGNATURE(printBACKUP_DATA);
GSN_PRINT_SIGNATURE(printBACKUP_REF);
GSN_PRINT_SIGNATURE(printBACKUP_CONF);
GSN_PRINT_SIGNATURE(printABORT_BACKUP_ORD);
GSN_PRINT_SIGNATURE(printBACKUP_ABORT_REP);
GSN_PRINT_SIGNATURE(printBACKUP_COMPLETE_REP);
GSN_PRINT_SIGNATURE(printBACKUP_NF_COMPLETE_REP);
GSN_PRINT_SIGNATURE(printDEFINE_BACKUP_REQ);
GSN_PRINT_SIGNATURE(printDEFINE_BACKUP_REF);
GSN_PRINT_SIGNATURE(printDEFINE_BACKUP_CONF);
GSN_PRINT_SIGNATURE(printSTART_BACKUP_REQ);
GSN_PRINT_SIGNATURE(printSTART_BACKUP_REF);
GSN_PRINT_SIGNATURE(printSTART_BACKUP_CONF);
GSN_PRINT_SIGNATURE(printBACKUP_FRAGMENT_REQ);
GSN_PRINT_SIGNATURE(printBACKUP_FRAGMENT_REF);
GSN_PRINT_SIGNATURE(printBACKUP_FRAGMENT_CONF);
GSN_PRINT_SIGNATURE(printSTOP_BACKUP_REQ);
GSN_PRINT_SIGNATURE(printSTOP_BACKUP_REF);
GSN_PRINT_SIGNATURE(printSTOP_BACKUP_CONF);
GSN_PRINT_SIGNATURE(printBACKUP_STATUS_REQ);
GSN_PRINT_SIGNATURE(printBACKUP_STATUS_CONF);
GSN_PRINT_SIGNATURE(printUTIL_SEQUENCE_REQ);
GSN_PRINT_SIGNATURE(printUTIL_SEQUENCE_REF);
GSN_PRINT_SIGNATURE(printUTIL_SEQUENCE_CONF);
GSN_PRINT_SIGNATURE(printUTIL_PREPARE_REQ);
GSN_PRINT_SIGNATURE(printUTIL_PREPARE_REF);
GSN_PRINT_SIGNATURE(printUTIL_PREPARE_CONF);
GSN_PRINT_SIGNATURE(printUTIL_EXECUTE_REQ);
GSN_PRINT_SIGNATURE(printUTIL_EXECUTE_REF);
GSN_PRINT_SIGNATURE(printUTIL_EXECUTE_CONF);
GSN_PRINT_SIGNATURE(printSCANTABREQ);
GSN_PRINT_SIGNATURE(printSCANTABCONF);
GSN_PRINT_SIGNATURE(printSCANTABREF);
GSN_PRINT_SIGNATURE(printSCANNEXTREQ); 
GSN_PRINT_SIGNATURE(printLQH_FRAG_REQ);
GSN_PRINT_SIGNATURE(printLQH_FRAG_REF);
GSN_PRINT_SIGNATURE(printLQH_FRAG_CONF);
GSN_PRINT_SIGNATURE(printPREP_DROP_TAB_REQ);
GSN_PRINT_SIGNATURE(printPREP_DROP_TAB_REF);
GSN_PRINT_SIGNATURE(printPREP_DROP_TAB_CONF);
GSN_PRINT_SIGNATURE(printDROP_TAB_REQ);
GSN_PRINT_SIGNATURE(printDROP_TAB_REF);
GSN_PRINT_SIGNATURE(printDROP_TAB_CONF);
GSN_PRINT_SIGNATURE(printLCP_FRAG_ORD);
GSN_PRINT_SIGNATURE(printLCP_FRAG_REP);
GSN_PRINT_SIGNATURE(printLCP_COMPLETE_REP);
GSN_PRINT_SIGNATURE(printSTART_LCP_REQ);
GSN_PRINT_SIGNATURE(printSTART_LCP_CONF);
GSN_PRINT_SIGNATURE(printMASTER_LCP_REQ);
GSN_PRINT_SIGNATURE(printMASTER_LCP_REF);
GSN_PRINT_SIGNATURE(printMASTER_LCP_CONF);
GSN_PRINT_SIGNATURE(printCOPY_GCI_REQ);
GSN_PRINT_SIGNATURE(printSYSTEM_ERROR);
GSN_PRINT_SIGNATURE(printSTART_REC_REQ);
GSN_PRINT_SIGNATURE(printSTART_REC_CONF);
GSN_PRINT_SIGNATURE(printNF_COMPLETE_REP);
GSN_PRINT_SIGNATURE(printSIGNAL_DROPPED_REP);
GSN_PRINT_SIGNATURE(printFAIL_REP);
GSN_PRINT_SIGNATURE(printDISCONNECT_REP);
GSN_PRINT_SIGNATURE(printSUB_CREATE_REQ);
GSN_PRINT_SIGNATURE(printSUB_CREATE_CONF);
GSN_PRINT_SIGNATURE(printSUB_CREATE_REF);
GSN_PRINT_SIGNATURE(printSUB_REMOVE_REQ);
GSN_PRINT_SIGNATURE(printSUB_REMOVE_CONF);
GSN_PRINT_SIGNATURE(printSUB_REMOVE_REF);
GSN_PRINT_SIGNATURE(printSUB_START_REQ);
GSN_PRINT_SIGNATURE(printSUB_START_REF);
GSN_PRINT_SIGNATURE(printSUB_START_CONF);
GSN_PRINT_SIGNATURE(printSUB_STOP_REQ);
GSN_PRINT_SIGNATURE(printSUB_STOP_REF);
GSN_PRINT_SIGNATURE(printSUB_STOP_CONF);
GSN_PRINT_SIGNATURE(printSUB_SYNC_REQ);
GSN_PRINT_SIGNATURE(printSUB_SYNC_REF);
GSN_PRINT_SIGNATURE(printSUB_SYNC_CONF);
GSN_PRINT_SIGNATURE(printSUB_META_DATA);
GSN_PRINT_SIGNATURE(printSUB_TABLE_DATA);
GSN_PRINT_SIGNATURE(printSUB_SYNC_CONTINUE_REQ);
GSN_PRINT_SIGNATURE(printSUB_SYNC_CONTINUE_REF);
GSN_PRINT_SIGNATURE(printSUB_SYNC_CONTINUE_CONF);
GSN_PRINT_SIGNATURE(printSUB_GCP_COMPLETE_REP);
GSN_PRINT_SIGNATURE(printCREATE_FRAGMENTATION_REQ);
GSN_PRINT_SIGNATURE(printCREATE_FRAGMENTATION_REF);
GSN_PRINT_SIGNATURE(printCREATE_FRAGMENTATION_CONF);
GSN_PRINT_SIGNATURE(printUTIL_CREATE_LOCK_REQ);
GSN_PRINT_SIGNATURE(printUTIL_CREATE_LOCK_REF);
GSN_PRINT_SIGNATURE(printUTIL_CREATE_LOCK_CONF);
GSN_PRINT_SIGNATURE(printUTIL_DESTROY_LOCK_REQ);
GSN_PRINT_SIGNATURE(printUTIL_DESTROY_LOCK_REF);
GSN_PRINT_SIGNATURE(printUTIL_DESTROY_LOCK_CONF);
GSN_PRINT_SIGNATURE(printUTIL_LOCK_REQ);
GSN_PRINT_SIGNATURE(printUTIL_LOCK_REF);
GSN_PRINT_SIGNATURE(printUTIL_LOCK_CONF);
GSN_PRINT_SIGNATURE(printUTIL_UNLOCK_REQ);
GSN_PRINT_SIGNATURE(printUTIL_UNLOCK_REF);
GSN_PRINT_SIGNATURE(printUTIL_UNLOCK_CONF);
GSN_PRINT_SIGNATURE(printCNTR_START_REQ);
GSN_PRINT_SIGNATURE(printCNTR_START_REF);
GSN_PRINT_SIGNATURE(printCNTR_START_CONF);
GSN_PRINT_SIGNATURE(printREAD_NODES_CONF);
GSN_PRINT_SIGNATURE(printTUX_MAINT_REQ);
GSN_PRINT_SIGNATURE(printACC_LOCKREQ);
GSN_PRINT_SIGNATURE(printLQH_TRANSCONF);
GSN_PRINT_SIGNATURE(printSCAN_FRAGREQ);

GSN_PRINT_SIGNATURE(printCONTINUEB_NDBFS);
GSN_PRINT_SIGNATURE(printCONTINUEB_DBDIH);
GSN_PRINT_SIGNATURE(printSTART_FRAG_REQ);

#endif
