/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define YYERROR_UNLESS(A)                  \
  if (!(A))                             \
  {					\
    yyerror(ER(ER_SYNTAX_ERROR));	\
    YYABORT;				\
  }

/* Helper for parsing "IS [NOT] truth_value" */
inline Item *is_truth_value(Item *A, bool v1, bool v2)
{
  return new Item_func_if(create_func_ifnull(A,
	new Item_int((char *) (v2 ? "TRUE" : "FALSE"), v2, 1)),
	new Item_int((char *) (v1 ? "TRUE" : "FALSE"), v1, 1),
	new Item_int((char *) (v1 ? "FALSE" : "TRUE"),!v1, 1));
}

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 280 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1487 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 320 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1502 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  458
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   42845

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  667
/* YYNRULES -- Number of rules. */
#define YYNRULES  2015
/* YYNRULES -- Number of states. */
#define YYNSTATES  3655

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   458,   459,   461,   463,
     465,   467,   470,   472,   474,   478,   479,   482,   483,   486,
     487,   491,   492,   498,   500,   502,   503,   506,   509,   512,
     515,   516,   523,   526,   527,   530,   532,   534,   538,   539,
     540,   541,   549,   550,   553,   556,   558,   560,   561,   562,
     571,   572,   579,   581,   584,   586,   589,   590,   591,   598,
     599,   600,   607,   608,   611,   612,   618,   619,   621,   622,
     628,   633,   634,   635,   644,   645,   653,   655,   657,   659,
     661,   663,   666,   669,   672,   677,   682,   683,   688,   689,
     690,   696,   697,   705,   706,   707,   714,   715,   717,   718,
     720,   722,   725,   727,   729,   730,   732,   734,   737,   739,
     740,   744,   745,   747,   749,   752,   754,   757,   761,   765,
     769,   773,   777,   781,   785,   789,   793,   797,   801,   805,
     809,   813,   817,   821,   825,   831,   833,   835,   839,   844,
     849,   853,   858,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   894,   895,
     897,   899,   901,   903,   905,   907,   911,   913,   915,   918,
     921,   928,   936,   945,   948,   951,   952,   954,   957,   958,
     960,   963,   964,   969,   973,   977,   981,   983,   988,   990,
     992,   998,  1001,  1007,  1010,  1015,  1017,  1023,  1029,  1034,
    1038,  1040,  1042,  1045,  1047,  1049,  1052,  1054,  1056,  1058,
    1061,  1065,  1068,  1072,  1075,  1078,  1082,  1086,  1090,  1091,
    1098,  1099,  1106,  1109,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1134,  1137,  1139,  1142,  1144,
    1147,  1151,  1154,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1171,  1172,  1176,  1178,  1184,  1185,  1187,  1190,  1192,  1194,
    1196,  1198,  1199,  1203,  1204,  1206,  1207,  1209,  1212,  1214,
    1216,  1219,  1222,  1227,  1229,  1233,  1236,  1238,  1241,  1244,
    1247,  1250,  1252,  1255,  1257,  1259,  1261,  1263,  1265,  1267,
    1269,  1271,  1273,  1275,  1276,  1279,  1281,  1283,  1284,  1286,
    1287,  1290,  1292,  1295,  1299,  1302,  1303,  1305,  1306,  1308,
    1310,  1313,  1314,  1316,  1317,  1322,  1324,  1329,  1333,  1335,
    1336,  1338,  1341,  1343,  1347,  1351,  1354,  1357,  1360,  1362,
    1364,  1367,  1370,  1373,  1375,  1378,  1381,  1384,  1387,  1389,
    1391,  1392,  1394,  1396,  1398,  1400,  1401,  1403,  1405,  1407,
    1408,  1411,  1414,  1416,  1418,  1420,  1425,  1428,  1430,  1435,
    1436,  1438,  1439,  1442,  1444,  1448,  1449,  1456,  1457,  1463,
    1464,  1470,  1471,  1477,  1478,  1490,  1491,  1493,  1494,  1497,
    1500,  1502,  1506,  1509,  1513,  1516,  1521,  1522,  1529,  1530,
    1531,  1540,  1545,  1550,  1554,  1558,  1561,  1564,  1571,  1577,
    1581,  1587,  1589,  1591,  1593,  1594,  1596,  1597,  1599,  1600,
    1602,  1604,  1605,  1608,  1610,  1611,  1613,  1615,  1617,  1618,
    1624,  1628,  1629,  1635,  1639,  1643,  1644,  1648,  1649,  1652,
    1654,  1658,  1659,  1661,  1663,  1664,  1667,  1669,  1673,  1674,
    1681,  1682,  1689,  1690,  1696,  1697,  1699,  1701,  1702,  1709,
    1710,  1712,  1714,  1717,  1719,  1721,  1723,  1724,  1731,  1732,
    1738,  1739,  1741,  1743,  1746,  1748,  1750,  1752,  1754,  1756,
    1759,  1760,  1767,  1768,  1770,  1772,  1773,  1778,  1783,  1787,
    1793,  1795,  1799,  1803,  1809,  1811,  1815,  1818,  1820,  1822,
    1823,  1830,  1832,  1836,  1840,  1841,  1844,  1845,  1850,  1851,
    1854,  1856,  1859,  1864,  1867,  1871,  1872,  1876,  1877,  1878,
    1885,  1888,  1890,  1892,  1895,  1898,  1907,  1912,  1913,  1915,
    1918,  1920,  1922,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1941,  1944,  1949,  1953,  1955,  1957,  1962,  1963,
    1964,  1966,  1968,  1969,  1972,  1975,  1977,  1979,  1980,  1983,
    1984,  1988,  1989,  1993,  1997,  1998,  2002,  2003,  2007,  2010,
    2012,  2016,  2021,  2025,  2030,  2034,  2039,  2041,  2045,  2050,
    2054,  2058,  2065,  2067,  2073,  2080,  2086,  2094,  2101,  2110,
    2116,  2123,  2128,  2133,  2139,  2143,  2148,  2150,  2154,  2156,
    2160,  2162,  2166,  2170,  2172,  2176,  2180,  2185,  2190,  2192,
    2196,  2200,  2204,  2208,  2212,  2214,  2218,  2220,  2222,  2224,
    2226,  2228,  2230,  2232,  2234,  2236,  2238,  2240,  2242,  2244,
    2246,  2248,  2250,  2252,  2255,  2257,  2261,  2263,  2265,  2267,
    2269,  2273,  2276,  2279,  2282,  2285,  2289,  2293,  2299,  2306,
    2311,  2316,  2324,  2329,  2332,  2339,  2345,  2352,  2359,  2364,
    2369,  2373,  2378,  2385,  2394,  2401,  2410,  2417,  2422,  2429,
    2434,  2441,  2446,  2451,  2456,  2461,  2468,  2477,  2480,  2483,
    2488,  2491,  2499,  2507,  2511,  2516,  2521,  2528,  2535,  2540,
    2547,  2554,  2561,  2566,  2573,  2578,  2585,  2594,  2605,  2618,
    2625,  2630,  2637,  2644,  2646,  2653,  2658,  2667,  2678,  2683,
    2685,  2689,  2694,  2701,  2708,  2717,  2724,  2731,  2736,  2743,
    2750,  2759,  2764,  2769,  2776,  2781,  2784,  2789,  2794,  2799,
    2806,  2811,  2816,  2820,  2829,  2836,  2841,  2848,  2852,  2859,
    2868,  2873,  2882,  2889,  2898,  2905,  2914,  2917,  2922,  2927,
    2932,  2939,  2948,  2957,  2962,  2970,  2978,  2986,  2993,  3000,
    3007,  3014,  3021,  3028,  3029,  3035,  3046,  3050,  3055,  3059,
    3062,  3065,  3068,  3073,  3080,  3085,  3090,  3097,  3104,  3111,
    3118,  3123,  3130,  3135,  3142,  3147,  3152,  3157,  3162,  3169,
    3174,  3181,  3186,  3193,  3198,  3203,  3210,  3215,  3222,  3227,
    3234,  3239,  3244,  3251,  3256,  3263,  3264,  3268,  3272,  3273,
    3275,  3276,  3279,  3281,  3285,  3290,  3295,  3301,  3306,  3311,
    3316,  3322,  3327,  3328,  3329,  3337,  3348,  3353,  3359,  3364,
    3370,  3375,  3380,  3385,  3390,  3395,  3401,  3402,  3411,  3412,
    3416,  3420,  3422,  3427,  3428,  3430,  3431,  3434,  3435,  3437,
    3438,  3442,  3445,  3449,  3452,  3454,  3457,  3459,  3462,  3464,
    3466,  3468,  3471,  3472,  3474,  3475,  3478,  3480,  3484,  3486,
    3490,  3491,  3494,  3496,  3500,  3501,  3503,  3504,  3507,  3512,
    3518,  3520,  3522,  3524,  3526,  3530,  3534,  3538,  3539,  3546,
    3547,  3554,  3555,  3564,  3569,  3570,  3579,  3580,  3591,  3598,
    3599,  3608,  3609,  3620,  3627,  3629,  3632,  3635,  3636,  3641,
    3642,  3654,  3658,  3665,  3666,  3670,  3671,  3672,  3678,  3679,
    3681,  3682,  3684,  3685,  3688,  3691,  3694,  3695,  3701,  3702,
    3704,  3708,  3710,  3712,  3714,  3718,  3720,  3722,  3724,  3726,
    3728,  3730,  3732,  3734,  3736,  3738,  3740,  3742,  3744,  3746,
    3748,  3750,  3752,  3754,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3771,  3773,  3775,  3776,  3779,  3780,  3782,  3783,
    3784,  3788,  3789,  3790,  3794,  3797,  3798,  3799,  3804,  3809,
    3812,  3813,  3816,  3819,  3820,  3822,  3823,  3828,  3833,  3836,
    3837,  3839,  3841,  3842,  3844,  3845,  3847,  3850,  3852,  3856,
    3860,  3862,  3864,  3866,  3868,  3869,  3872,  3874,  3876,  3878,
    3880,  3882,  3884,  3886,  3888,  3890,  3892,  3894,  3895,  3896,
    3903,  3904,  3906,  3910,  3912,  3915,  3916,  3919,  3923,  3925,
    3928,  3930,  3931,  3935,  3936,  3942,  3945,  3947,  3948,  3952,
    3959,  3960,  3967,  3972,  3977,  3982,  3987,  3993,  3998,  4000,
    4004,  4006,  4007,  4010,  4011,  4013,  4014,  4015,  4024,  4025,
    4026,  4033,  4034,  4036,  4038,  4040,  4042,  4044,  4047,  4049,
    4051,  4053,  4057,  4062,  4063,  4067,  4071,  4073,  4076,  4079,
    4080,  4084,  4085,  4091,  4095,  4097,  4101,  4103,  4107,  4109,
    4111,  4112,  4114,  4115,  4120,  4121,  4123,  4127,  4129,  4131,
    4133,  4134,  4135,  4142,  4143,  4144,  4156,  4160,  4162,  4166,
    4170,  4172,  4176,  4177,  4179,  4180,  4185,  4186,  4193,  4194,
    4200,  4201,  4208,  4210,  4214,  4218,  4224,  4225,  4228,  4229,
    4232,  4234,  4236,  4238,  4242,  4243,  4245,  4246,  4250,  4253,
    4258,  4263,  4268,  4273,  4274,  4279,  4286,  4303,  4306,  4309,
    4310,  4317,  4323,  4326,  4329,  4332,  4334,  4340,  4346,  4349,
    4352,  4356,  4359,  4362,  4365,  4369,  4372,  4375,  4378,  4380,
    4382,  4386,  4391,  4395,  4399,  4402,  4405,  4409,  4413,  4417,
    4421,  4425,  4429,  4431,  4433,  4435,  4437,  4438,  4440,  4441,
    4444,  4445,  4447,  4449,  4451,  4452,  4455,  4456,  4459,  4460,
    4463,  4466,  4467,  4472,  4473,  4478,  4480,  4482,  4483,  4485,
    4486,  4488,  4490,  4491,  4496,  4500,  4502,  4503,  4507,  4512,
    4515,  4517,  4519,  4521,  4523,  4525,  4527,  4529,  4531,  4532,
    4534,  4535,  4539,  4543,  4545,  4547,  4549,  4552,  4553,  4557,
    4561,  4564,  4567,  4568,  4573,  4574,  4576,  4578,  4581,  4582,
    4587,  4593,  4594,  4595,  4596,  4613,  4616,  4617,  4619,  4620,
    4622,  4624,  4625,  4627,  4629,  4630,  4633,  4636,  4638,  4642,
    4647,  4651,  4655,  4656,  4659,  4662,  4664,  4668,  4672,  4673,
    4677,  4678,  4682,  4685,  4689,  4691,  4693,  4696,  4697,  4700,
    4702,  4704,  4707,  4710,  4712,  4714,  4716,  4718,  4720,  4723,
    4726,  4728,  4730,  4732,  4734,  4736,  4738,  4740,  4743,  4746,
    4749,  4752,  4755,  4757,  4759,  4761,  4763,  4765,  4767,  4769,
    4773,  4779,  4781,  4783,  4785,  4787,  4789,  4793,  4798,  4804,
    4806,  4812,  4816,  4819,  4821,  4825,  4828,  4830,  4832,  4834,
    4836,  4838,  4840,  4842,  4844,  4846,  4848,  4850,  4852,  4854,
    4856,  4860,  4863,  4865,  4867,  4869,  4871,  4873,  4875,  4877,
    4879,  4881,  4883,  4885,  4887,  4889,  4891,  4893,  4895,  4897,
    4899,  4901,  4903,  4905,  4907,  4909,  4911,  4913,  4915,  4917,
    4919,  4921,  4923,  4925,  4927,  4929,  4931,  4933,  4935,  4937,
    4939,  4941,  4943,  4945,  4947,  4949,  4951,  4953,  4955,  4957,
    4959,  4961,  4963,  4965,  4967,  4969,  4971,  4973,  4975,  4977,
    4979,  4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  4997,
    4999,  5001,  5003,  5005,  5007,  5009,  5011,  5013,  5015,  5017,
    5019,  5021,  5023,  5025,  5027,  5029,  5031,  5033,  5035,  5037,
    5039,  5041,  5043,  5045,  5047,  5049,  5051,  5053,  5055,  5057,
    5059,  5061,  5063,  5065,  5067,  5069,  5071,  5073,  5075,  5077,
    5079,  5081,  5083,  5085,  5087,  5089,  5091,  5093,  5095,  5097,
    5099,  5101,  5103,  5105,  5107,  5109,  5111,  5113,  5115,  5117,
    5119,  5121,  5123,  5125,  5127,  5129,  5131,  5133,  5135,  5137,
    5139,  5141,  5143,  5145,  5147,  5149,  5151,  5153,  5155,  5157,
    5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,
    5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,
    5199,  5201,  5203,  5205,  5207,  5209,  5211,  5213,  5215,  5217,
    5219,  5221,  5223,  5225,  5227,  5229,  5231,  5233,  5235,  5237,
    5239,  5241,  5243,  5245,  5247,  5249,  5251,  5253,  5255,  5257,
    5259,  5261,  5263,  5265,  5267,  5269,  5271,  5273,  5275,  5277,
    5279,  5281,  5283,  5285,  5287,  5289,  5291,  5293,  5295,  5297,
    5299,  5301,  5303,  5305,  5307,  5309,  5311,  5313,  5315,  5317,
    5319,  5321,  5323,  5325,  5327,  5329,  5331,  5333,  5335,  5337,
    5339,  5341,  5343,  5345,  5347,  5349,  5351,  5353,  5355,  5357,
    5359,  5361,  5362,  5367,  5368,  5370,  5372,  5376,  5377,  5380,
    5382,  5384,  5386,  5388,  5389,  5391,  5392,  5394,  5396,  5398,
    5399,  5402,  5405,  5408,  5410,  5413,  5418,  5424,  5429,  5436,
    5439,  5443,  5447,  5451,  5457,  5459,  5463,  5467,  5470,  5473,
    5476,  5478,  5480,  5485,  5490,  5492,  5494,  5496,  5498,  5500,
    5501,  5506,  5508,  5510,  5512,  5516,  5520,  5522,  5524,  5527,
    5530,  5531,  5535,  5540,  5544,  5545,  5553,  5555,  5558,  5560,
    5562,  5564,  5566,  5568,  5570,  5571,  5577,  5579,  5581,  5583,
    5585,  5587,  5591,  5598,  5605,  5612,  5620,  5624,  5633,  5642,
    5651,  5652,  5654,  5656,  5659,  5660,  5662,  5664,  5668,  5669,
    5673,  5674,  5678,  5679,  5683,  5684,  5688,  5690,  5692,  5694,
    5696,  5698,  5700,  5702,  5704,  5706,  5708,  5710,  5713,  5716,
    5718,  5722,  5725,  5728,  5731,  5734,  5737,  5740,  5743,  5746,
    5747,  5749,  5753,  5755,  5758,  5761,  5764,  5766,  5770,  5774,
    5776,  5778,  5782,  5784,  5788,  5793,  5799,  5801,  5802,  5806,
    5810,  5812,  5814,  5815,  5818,  5821,  5824,  5827,  5828,  5831,
    5834,  5836,  5839,  5842,  5845,  5848,  5851,  5852,  5856,  5857,
    5859,  5860,  5864,  5867,  5868,  5870,  5873,  5874,  5876,  5881,
    5886,  5892,  5895,  5899,  5900,  5902,  5903,  5908,  5909,  5911,
    5913,  5914,  5917,  5920,  5922,  5923,  5925,  5927,  5932,  5933,
    5941,  5943,  5944,  5945,  5948,  5952,  5954,  5956,  5958,  5959,
    5963,  5965,  5968,  5970,  5973,  5977,  5981,  5985,  5986,  5988,
    5989,  5993,  5997,  5998,  6007,  6008,  6012,  6014,  6018,  6019,
    6022,  6026,  6032,  6033,  6037,  6042,  6047,  6048,  6063,  6064,
    6071,  6072,  6073,  6074,  6075,  6088,  6093,  6098,  6102,  6107,
    6111,  6114,  6116,  6120,  6126,  6128,  6130,  6131,  6133,  6135,
    6136,  6139,  6140,  6141,  6145,  6146
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1182,    -1,   769,    -1,   810,    -1,   800,    -1,   608,    -1,
     585,    -1,   812,    -1,   802,    -1,  1188,    -1,   590,    -1,
     574,    -1,  1027,    -1,  1054,    -1,   983,    -1,   985,    -1,
     578,    -1,  1060,    -1,  1157,    -1,  1148,    -1,   583,    -1,
     991,    -1,  1074,    -1,  1078,    -1,  1140,    -1,   817,    -1,
     825,    -1,   829,    -1,   576,    -1,  1070,    -1,  1191,    -1,
     820,    -1,   805,    -1,   994,    -1,  1066,    -1,   798,    -1,
    1155,    -1,  1189,    -1,  1190,    -1,   837,    -1,  1123,    -1,
    1040,    -1,   787,    -1,   790,    -1,  1038,    -1,  1146,    -1,
    1019,    -1,  1077,    -1,  1229,    -1,   575,   362,  1117,    -1,
     103,    -1,   126,    -1,   362,  1117,   171,   577,    -1,  1114,
      -1,   566,  1119,    -1,    -1,   148,  1117,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1119,    -1,    -1,   198,   584,  1119,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1114,    -1,   282,   142,  1114,    -1,   271,
     142,  1114,    -1,   272,   142,   968,    -1,   267,   142,   968,
      -1,   280,   142,   968,    -1,   276,   142,  1114,    -1,   275,
     142,  1114,    -1,   277,   142,  1114,    -1,   278,   142,  1114,
      -1,   279,   142,  1114,    -1,   589,    -1,   269,   142,  1114,
      -1,   270,   142,   969,    -1,   386,   142,  1114,    -1,   387,
     142,   968,    -1,    -1,    84,   687,   472,   690,  1111,   591,
     674,    -1,    -1,    84,   761,   213,  1117,   762,   337,  1111,
     592,   560,   764,   561,    -1,    -1,    84,    91,   690,  1117,
     593,   684,    -1,    -1,    84,   594,  1205,    -1,    84,   514,
     595,  1173,    -1,    -1,  1117,   567,  1117,    -1,  1117,    -1,
     403,   703,   496,  1114,    -1,    -1,    -1,    -1,    -1,    -1,
     560,   598,   613,   561,   599,   403,   600,   714,   601,   604,
     602,   636,    -1,    -1,   603,   605,    -1,    -1,   604,   606,
      -1,    67,  1114,    -1,   235,   450,    -1,   328,   450,    -1,
      79,   450,    -1,   379,   450,    93,    -1,   304,   450,    93,
      -1,   607,    -1,   605,    -1,   118,    -1,   876,   118,    -1,
     450,   419,   109,    -1,   450,   419,   224,    -1,    -1,    47,
     596,   609,   610,    -1,    -1,   560,   611,   561,    -1,    -1,
     612,    -1,   612,   562,   858,    -1,   858,    -1,    -1,   614,
      -1,   614,   562,   616,    -1,   616,    -1,    -1,  1117,   615,
     714,    -1,    -1,   618,    -1,   618,   562,   619,    -1,   619,
      -1,   620,   615,  1117,   714,    -1,    -1,   225,    -1,   350,
      -1,   217,    -1,    -1,   621,   636,   568,    -1,   636,   568,
      -1,   622,   636,   568,    -1,    -1,   623,   624,   568,    -1,
      -1,   106,   634,   625,   714,   635,    -1,   106,  1117,    75,
     168,   631,    -1,    -1,   106,   629,   195,   168,   626,   630,
     636,    -1,   106,  1117,    89,   168,   627,    -1,    -1,   628,
     573,    -1,   150,    -1,    80,    -1,   633,    -1,   630,   562,
     633,    -1,   968,    -1,   442,   632,  1115,    -1,    -1,   523,
      -1,   631,    -1,  1117,    -1,   443,    -1,   876,   169,    -1,
     441,    -1,  1117,    -1,   634,   562,  1117,    -1,    -1,   108,
     858,    -1,    -1,   637,   573,    -1,    -1,   404,   638,   858,
      -1,    -1,   209,   639,   644,   138,   209,    -1,   649,    -1,
     664,    -1,    -1,   640,   667,    -1,   242,  1118,    -1,   229,
    1118,    -1,   340,  1117,    -1,    -1,   157,   642,  1117,   222,
     641,   643,    -1,    60,  1117,    -1,    -1,   323,   171,    -1,
     171,    -1,  1117,    -1,   643,   562,  1117,    -1,    -1,    -1,
      -1,   645,   858,   547,   646,   622,   647,   648,    -1,    -1,
     132,   644,    -1,   546,   622,    -1,   650,    -1,   653,    -1,
      -1,    -1,   548,   651,   858,   652,   655,   663,   138,   548,
      -1,    -1,   548,   654,   656,   663,   138,   548,    -1,   657,
      -1,   655,   657,    -1,   660,    -1,   656,   660,    -1,    -1,
      -1,   532,   658,   858,   659,   547,   622,    -1,    -1,    -1,
     532,   661,   858,   662,   547,   622,    -1,    -1,   546,   622,
      -1,    -1,  1118,   569,   665,   667,   666,    -1,    -1,  1118,
      -1,    -1,    28,   668,   623,   621,   138,    -1,   263,   622,
     138,   263,    -1,    -1,    -1,   534,   669,   858,   125,   670,
     622,   138,   534,    -1,    -1,   394,   622,   510,   671,   858,
     138,   394,    -1,    27,    -1,     8,    -1,   219,    -1,   511,
      -1,   112,    -1,   560,   675,    -1,   691,   677,    -1,   246,
    1111,    -1,   560,   246,  1111,   561,    -1,   704,   561,   691,
     677,    -1,    -1,   680,   561,   676,  1195,    -1,    -1,    -1,
    1086,   683,   680,   678,  1192,    -1,    -1,  1086,   683,   560,
     680,   561,   679,  1195,    -1,    -1,    -1,   420,   681,   847,
     851,   682,   701,    -1,    -1,    18,    -1,    -1,   685,    -1,
     686,    -1,   685,   686,    -1,   696,    -1,   695,    -1,    -1,
     688,    -1,   689,    -1,   689,   688,    -1,   473,    -1,    -1,
     209,   876,   149,    -1,    -1,   693,    -1,   694,    -1,   694,
     692,    -1,   694,    -1,   694,   693,    -1,   694,   562,   693,
      -1,   140,  1011,   697,    -1,   494,  1011,   697,    -1,   286,
    1011,   969,    -1,   300,  1011,   969,    -1,    24,  1011,   968,
      -1,   353,  1011,  1114,    -1,    67,  1011,  1114,    -1,    23,
    1011,   969,    -1,   351,  1011,   968,    -1,   351,  1011,   108,
      -1,    56,  1011,   968,    -1,   111,  1011,   968,    -1,   413,
    1011,   698,    -1,   377,  1011,   699,    -1,   374,  1011,   968,
      -1,   375,  1011,   968,    -1,   503,  1011,   560,   987,   561,
      -1,   695,    -1,   696,    -1,   220,  1011,   700,    -1,    93,
     119,  1011,  1114,    -1,   213,   119,  1011,  1114,    -1,    76,
    1011,  1114,    -1,   743,   735,  1011,   737,    -1,   743,    63,
    1011,   742,    -1,  1119,    -1,   108,    -1,   161,    -1,   130,
      -1,    71,    -1,   383,    -1,    70,    -1,   376,    -1,   373,
      -1,   968,    -1,   328,    -1,   160,    -1,   237,    -1,   963,
      -1,   846,   850,    -1,    -1,    10,    -1,   461,    -1,   381,
      -1,   105,    -1,   223,    -1,   705,    -1,   704,   562,   705,
      -1,   706,    -1,   707,    -1,   712,   708,    -1,   712,   748,
      -1,   756,   766,   762,   560,   764,   561,    -1,   710,   757,
     766,   762,   560,   764,   561,    -1,   710,   166,   232,   766,
     560,   764,   561,   748,    -1,   711,   708,    -1,   710,   709,
      -1,    -1,   709,    -1,    57,   858,    -1,    -1,   711,    -1,
      78,   766,    -1,    -1,  1110,   713,   714,   731,    -1,   722,
     729,   726,    -1,   723,   730,   726,    -1,   163,   724,   726,
      -1,    37,    -1,    37,   560,   331,   561,    -1,    41,    -1,
      40,    -1,   718,   560,   331,   561,   744,    -1,   718,   744,
      -1,   719,   560,   331,   561,   745,    -1,   719,   745,    -1,
      32,   560,   331,   561,    -1,    32,    -1,   720,   560,   331,
     561,   744,    -1,   721,   560,   331,   561,   745,    -1,   524,
     560,   331,   561,    -1,   543,   729,   726,    -1,    97,    -1,
     481,    -1,   478,   729,    -1,    94,    -1,   482,    -1,    39,
     729,    -1,   717,    -1,   290,    -1,   259,    -1,   262,   524,
      -1,   262,   720,   744,    -1,   484,   744,    -1,   477,   729,
     744,    -1,   292,   744,    -1,   260,   744,    -1,   105,   724,
     726,    -1,   332,   724,   726,    -1,   161,   724,   726,    -1,
      -1,   141,   715,   560,   768,   561,   744,    -1,    -1,   426,
     716,   560,   768,   561,   744,    -1,   262,   744,    -1,   424,
      -1,   183,    -1,   182,    -1,   357,    -1,   311,    -1,   250,
      -1,   310,    -1,   359,    -1,   312,    -1,    55,    -1,   319,
      -1,   316,    55,    -1,   718,   528,    -1,   525,    -1,   316,
     525,    -1,   333,    -1,   319,   525,    -1,   316,    55,   528,
      -1,   319,   528,    -1,   223,    -1,   483,    -1,   436,    -1,
     291,    -1,    31,    -1,   381,    -1,   124,    -1,   124,   361,
      -1,    -1,   560,   331,   561,    -1,   725,    -1,   560,   331,
     562,   331,   561,    -1,    -1,   727,    -1,   727,   728,    -1,
     728,    -1,   433,    -1,   509,    -1,   544,    -1,    -1,   560,
     331,   561,    -1,    -1,   725,    -1,    -1,   732,    -1,   732,
     733,    -1,   733,    -1,   330,    -1,   876,   330,    -1,   108,
     734,    -1,   337,   511,   327,   857,    -1,    23,    -1,   424,
     108,   523,    -1,   747,   232,    -1,   504,    -1,   504,   232,
      -1,    67,  1114,    -1,    63,   740,    -1,   327,   857,    -1,
    1101,    -1,    55,   426,    -1,    54,    -1,  1119,    -1,    32,
      -1,   736,    -1,   108,    -1,  1119,    -1,    32,    -1,   738,
      -1,   108,    -1,  1119,    -1,    -1,    63,   742,    -1,   740,
      -1,   108,    -1,    -1,   108,    -1,    -1,    20,   745,    -1,
      45,    -1,   502,   745,    -1,   735,   736,   745,    -1,    32,
     746,    -1,    -1,    32,    -1,    -1,    20,    -1,   502,    -1,
     735,   736,    -1,    -1,   364,    -1,    -1,   384,  1111,   749,
     750,    -1,   752,    -1,   560,   751,   561,   752,    -1,   751,
     562,  1117,    -1,  1117,    -1,    -1,   753,    -1,   753,   754,
      -1,   754,    -1,   337,   112,   755,    -1,   337,   511,   755,
      -1,   283,   173,    -1,   283,   352,    -1,   283,   434,    -1,
     401,    -1,    48,    -1,   426,   330,    -1,   328,     5,    -1,
     426,   108,    -1,   758,    -1,   174,   759,    -1,   439,   759,
      -1,   364,   232,    -1,   504,   759,    -1,   232,    -1,   213,
      -1,    -1,   758,    -1,   231,    -1,   213,    -1,   212,    -1,
      -1,   504,    -1,   174,    -1,   439,    -1,    -1,   517,   763,
      -1,   494,   763,    -1,    43,    -1,   415,    -1,   196,    -1,
     764,   562,   765,   961,    -1,   765,   961,    -1,  1117,    -1,
    1117,   560,   331,   561,    -1,    -1,  1110,    -1,    -1,   567,
    1117,    -1,  1099,    -1,   768,   562,  1099,    -1,    -1,    13,
     783,   472,  1111,   770,   776,    -1,    -1,    13,    91,   775,
     771,   684,    -1,    -1,    13,   366,   596,   772,   603,    -1,
      -1,    13,   175,   596,   773,   603,    -1,    -1,    13,  1211,
    1207,  1212,   529,  1111,   774,  1215,    18,  1217,  1220,    -1,
      -1,  1117,    -1,    -1,   121,   471,    -1,   211,   471,    -1,
     778,    -1,   776,   562,   778,    -1,     6,   782,    -1,   777,
     706,   785,    -1,     6,   707,    -1,   777,   560,   704,   561,
      -1,    -1,    52,   782,  1110,   779,   712,   785,    -1,    -1,
      -1,   305,   782,  1110,   780,   714,   731,   781,   785,    -1,
     126,   782,  1110,   784,    -1,   126,   166,   232,   766,    -1,
     126,   364,   232,    -1,   126,   758,  1110,    -1,   120,   231,
      -1,   134,   231,    -1,    13,   782,  1110,   426,   108,  1101,
      -1,    13,   782,  1110,   126,   108,    -1,   391,   786,  1111,
      -1,    81,   485,   735,   737,   741,    -1,   692,    -1,   165,
      -1,   958,    -1,    -1,    66,    -1,    -1,   210,    -1,    -1,
     401,    -1,    48,    -1,    -1,     8,  1117,    -1,   160,    -1,
      -1,   485,    -1,   142,    -1,    18,    -1,    -1,   454,   435,
     792,   788,   796,    -1,   458,   435,   792,    -1,    -1,   435,
     454,   792,   789,   796,    -1,   435,   458,   792,    -1,   454,
     487,   791,    -1,    -1,   535,    77,   437,    -1,    -1,   793,
     794,    -1,   795,    -1,   794,   562,   795,    -1,    -1,   451,
      -1,   388,    -1,    -1,   510,   797,    -1,   589,    -1,   797,
     562,   589,    -1,    -1,   400,  1142,   799,   987,   171,  1114,
      -1,    -1,    26,  1142,   801,   987,   485,  1114,    -1,    -1,
      56,  1142,   803,   987,   804,    -1,    -1,   372,    -1,   153,
      -1,    -1,   392,   819,  1142,   806,   987,   807,    -1,    -1,
     808,    -1,   809,    -1,   809,   808,    -1,   372,    -1,   153,
      -1,   515,    -1,    -1,    14,   819,  1142,   811,   987,   814,
      -1,    -1,    57,  1142,   813,   987,   814,    -1,    -1,   815,
      -1,   816,    -1,   816,   815,    -1,   372,    -1,   156,    -1,
     293,    -1,   153,    -1,    53,    -1,   168,   512,    -1,    -1,
     341,   819,  1142,   818,   987,   814,    -1,    -1,   329,    -1,
     252,    -1,    -1,   391,  1142,   821,   823,    -1,   391,   514,
     595,   822,    -1,  1120,   485,  1120,    -1,   822,   562,  1120,
     485,  1120,    -1,   824,    -1,   823,   562,   824,    -1,  1111,
     485,  1111,    -1,    46,   213,   826,   225,   828,    -1,   827,
      -1,   826,   562,   827,    -1,  1111,   833,    -1,  1117,    -1,
     108,    -1,    -1,   251,   213,   222,    46,   830,   831,    -1,
     832,    -1,   831,   562,   832,    -1,  1111,   833,   836,    -1,
      -1,   834,   835,    -1,    -1,   759,   560,   941,   561,    -1,
      -1,   210,   241,    -1,   838,    -1,   420,   840,    -1,   560,
     839,   561,  1195,    -1,   420,   842,    -1,   560,   839,   561,
      -1,    -1,   842,   841,  1192,    -1,    -1,    -1,   843,   847,
     851,   844,   845,   850,    -1,   957,   963,    -1,   979,    -1,
     846,    -1,   979,   846,    -1,   846,   979,    -1,   171,   915,
     949,   954,   951,   957,   963,   970,    -1,   171,   127,   949,
     963,    -1,    -1,   848,    -1,   848,   849,    -1,   849,    -1,
     460,    -1,   200,    -1,   122,    -1,   449,    -1,   444,    -1,
     445,    -1,   447,    -1,   448,    -1,   446,    -1,    12,    -1,
      -1,   168,   511,    -1,   256,   225,   428,   303,    -1,   851,
     562,   852,    -1,   852,    -1,   554,    -1,   853,   855,   854,
     856,    -1,    -1,    -1,  1105,    -1,   858,    -1,    -1,    18,
    1117,    -1,    18,  1114,    -1,  1117,    -1,  1114,    -1,    -1,
     560,   561,    -1,    -1,   861,   859,   860,    -1,    -1,   860,
     874,   861,    -1,   861,   540,   861,    -1,    -1,   864,   862,
     863,    -1,    -1,   863,   875,   864,    -1,   326,   864,    -1,
     865,    -1,   866,   226,   491,    -1,   866,   226,   876,   491,
      -1,   866,   226,   155,    -1,   866,   226,   876,   155,    -1,
     866,   226,   507,    -1,   866,   226,   876,   507,    -1,   866,
      -1,   866,   226,   330,    -1,   866,   226,   876,   330,    -1,
     866,   143,   867,    -1,   866,   878,   867,    -1,   866,   878,
     879,   560,  1200,   561,    -1,   867,    -1,   868,   225,   560,
    1200,   561,    -1,   868,   876,   225,   560,  1200,   561,    -1,
     868,   225,   560,   858,   561,    -1,   868,   225,   560,   858,
     562,   904,   561,    -1,   868,   876,   225,   560,   858,   561,
      -1,   868,   876,   225,   560,   858,   562,   904,   561,    -1,
     868,   549,   868,    16,   867,    -1,   868,   876,   549,   868,
      16,   867,    -1,   868,   438,   246,   868,    -1,   868,   246,
     881,   953,    -1,   868,   876,   246,   881,   953,    -1,   868,
     385,   868,    -1,   868,   876,   385,   868,    -1,   868,    -1,
     868,   550,   869,    -1,   869,    -1,   869,   551,   870,    -1,
     870,    -1,   870,   429,   871,    -1,   870,   430,   871,    -1,
     871,    -1,   871,   553,   872,    -1,   871,   552,   872,    -1,
     871,   553,   880,   943,    -1,   871,   552,   880,   943,    -1,
     872,    -1,   872,   554,   873,    -1,   872,   555,   873,    -1,
     872,   556,   873,    -1,   872,   123,   873,    -1,   872,   306,
     873,    -1,   873,    -1,   873,   557,   881,    -1,   881,    -1,
     347,    -1,   344,    -1,    16,    -1,    15,    -1,   326,    -1,
     325,    -1,   563,    -1,   325,    -1,   142,    -1,   180,    -1,
     194,    -1,   238,    -1,   265,    -1,   321,    -1,    12,    -1,
      17,    -1,   221,   858,    -1,  1107,    -1,   881,    63,  1119,
      -1,  1102,    -1,  1100,    -1,   894,    -1,   890,    -1,   881,
     346,   881,    -1,   553,   881,    -1,   552,   881,    -1,   558,
     881,    -1,   877,   881,    -1,   560,  1200,   561,    -1,   560,
     858,   561,    -1,   560,   858,   562,   904,   561,    -1,   414,
     560,   858,   562,   904,   561,    -1,   149,   560,  1200,   561,
      -1,   564,  1117,   858,   565,    -1,   283,   907,     9,   560,
     868,   884,   561,    -1,    20,   560,   858,   561,    -1,    32,
     881,    -1,    50,   560,   858,    18,   902,   561,    -1,   548,
     911,   913,   912,   138,    -1,    81,   560,   858,   562,   902,
     561,    -1,    81,   560,   858,   517,   736,   561,    -1,   108,
     560,  1107,   561,    -1,   522,   560,  1108,   561,    -1,   176,
     560,   561,    -1,   177,   560,   858,   561,    -1,   178,   560,
     858,   562,   858,   561,    -1,   179,   560,   858,   562,   858,
     562,   858,   561,    -1,     7,   560,   858,   562,   858,   561,
      -1,     7,   560,   858,   562,   221,   858,   943,   561,    -1,
     394,   560,   858,   562,   858,   561,    -1,    22,   560,   858,
     561,    -1,    22,   560,   858,   562,   858,   561,    -1,    55,
     560,   904,   561,    -1,    55,   560,   904,   517,   736,   561,
      -1,    54,   560,   858,   561,    -1,    61,   560,   904,   561,
      -1,    64,   560,   858,   561,    -1,    72,   560,   904,   561,
      -1,    73,   560,   858,   562,   904,   561,    -1,    82,   560,
     858,   562,   858,   562,   858,   561,    -1,    87,   857,    -1,
      90,   857,    -1,    90,   560,   858,   561,    -1,    88,   857,
      -1,    95,   560,   858,   562,   880,   943,   561,    -1,    96,
     560,   858,   562,   880,   943,   561,    -1,    91,   560,   561,
      -1,    97,   560,   858,   561,    -1,   102,   560,   858,   561,
      -1,   133,   560,   858,   562,   904,   561,    -1,   266,   560,
     858,   562,   904,   561,    -1,   137,   560,   858,   561,    -1,
     137,   560,   858,   562,   858,   561,    -1,   107,   560,   858,
     562,  1115,   561,    -1,   136,   560,   858,   562,  1115,   561,
      -1,   115,   560,   858,   561,    -1,   115,   560,   858,   562,
     858,   561,    -1,   116,   560,   858,   561,    -1,   116,   560,
     858,   562,   858,   561,    -1,   152,   560,   858,   562,   858,
     562,   858,   561,    -1,   152,   560,   858,   562,   858,   562,
     858,   562,   858,   561,    -1,   152,   560,   858,   562,   858,
     562,   858,   562,   858,   562,   858,   561,    -1,   167,   560,
     858,   562,   331,   561,    -1,   172,   560,   858,   561,    -1,
     172,   560,   858,   562,   858,   561,    -1,   158,   560,   858,
     562,   904,   561,    -1,   883,    -1,   186,   560,   945,   562,
     858,   561,    -1,   205,   560,   858,   561,    -1,   209,   560,
     858,   562,   858,   562,   858,   561,    -1,   219,   560,   858,
     562,   858,   562,   858,   562,   858,   561,    -1,   880,   943,
     553,   858,    -1,   880,    -1,   236,   560,   561,    -1,   236,
     560,   858,   561,    -1,   243,   560,   858,   562,   858,   561,
      -1,   253,   560,   858,   562,   858,   561,    -1,   253,   560,
     858,   562,   858,   562,   858,   561,    -1,   190,   560,   858,
     562,   904,   561,    -1,   240,   560,   858,   562,   904,   561,
      -1,   258,   560,   858,   561,    -1,   258,   560,   858,   562,
     858,   561,    -1,   273,   560,   858,   562,   858,   561,    -1,
     273,   560,   858,   562,   858,   562,   858,   561,    -1,   295,
     560,   858,   561,    -1,   299,   560,   858,   561,    -1,   306,
     560,   858,   562,   858,   561,    -1,   307,   560,   858,   561,
      -1,   327,   857,    -1,   327,   560,   858,   561,    -1,   353,
     560,   858,   561,    -1,   336,   560,   858,   561,    -1,   360,
     560,   868,   225,   858,   561,    -1,   370,   560,   858,   561,
      -1,   378,   560,   858,   561,    -1,   378,   560,   561,    -1,
     395,   560,   858,   562,   858,   562,   858,   561,    -1,   406,
     560,   858,   562,   858,   561,    -1,   409,   560,   858,   561,
      -1,   409,   560,   858,   562,   858,   561,    -1,   412,   560,
     561,    -1,   462,   560,   858,   562,   858,   561,    -1,   462,
     560,   858,   562,   221,   858,   943,   561,    -1,   418,   560,
     858,   561,    -1,   464,   560,   858,   562,   858,   562,   858,
     561,    -1,   464,   560,   858,   562,   858,   561,    -1,   464,
     560,   858,   171,   858,   168,   858,   561,    -1,   464,   560,
     858,   171,   858,   561,    -1,   465,   560,   858,   562,   858,
     562,   858,   561,    -1,   469,   857,    -1,   469,   560,   858,
     561,    -1,   481,   560,   858,   561,    -1,   478,   560,   858,
     561,    -1,   478,   560,   858,   562,   858,   561,    -1,   479,
     560,   944,   562,   858,   562,   858,   561,    -1,   480,   560,
     944,   562,   858,   562,   858,   561,    -1,   490,   560,   858,
     561,    -1,   490,   560,   239,   858,   171,   858,   561,    -1,
     490,   560,   486,   858,   171,   858,   561,    -1,   490,   560,
      42,   858,   171,   858,   561,    -1,   490,   560,   239,   171,
     858,   561,    -1,   490,   560,   486,   171,   858,   561,    -1,
     490,   560,    42,   171,   858,   561,    -1,   490,   560,   858,
     171,   858,   561,    -1,   492,   560,   858,   562,   858,   561,
      -1,  1117,   567,  1117,   560,   903,   561,    -1,    -1,  1113,
     560,   882,   885,   561,    -1,   505,   560,  1098,   562,   331,
     562,   331,   562,   904,   561,    -1,   506,   560,   561,    -1,
     506,   560,   858,   561,    -1,   514,   560,   561,    -1,   518,
     857,    -1,   520,   857,    -1,   519,   857,    -1,   531,   560,
     858,   561,    -1,   531,   560,   858,   562,   858,   561,    -1,
     543,   560,   858,   561,    -1,   541,   560,   858,   561,    -1,
     541,   560,   858,   562,   858,   561,    -1,    29,   560,   968,
     562,   858,   561,    -1,   154,   560,   943,   171,   858,   561,
      -1,    79,   560,   858,   562,   858,   561,    -1,   184,   560,
     858,   561,    -1,   184,   560,   858,   562,   858,   561,    -1,
     185,   560,   858,   561,    -1,   185,   560,   858,   562,   858,
     561,    -1,   182,   560,   904,   561,    -1,   250,   560,   904,
     561,    -1,   310,   560,   904,   561,    -1,   302,   560,   858,
     561,    -1,   302,   560,   858,   562,   858,   561,    -1,   308,
     560,   858,   561,    -1,   308,   560,   858,   562,   858,   561,
      -1,   309,   560,   858,   561,    -1,   309,   560,   858,   562,
     858,   561,    -1,   311,   560,   904,   561,    -1,   312,   560,
     904,   561,    -1,   357,   560,   858,   562,   858,   561,    -1,
     356,   560,   858,   561,    -1,   356,   560,   858,   562,   858,
     561,    -1,   358,   560,   858,   561,    -1,   358,   560,   858,
     562,   858,   561,    -1,   359,   560,   904,   561,    -1,   181,
     560,   858,   561,    -1,   181,   560,   858,   562,   858,   561,
      -1,   248,   560,   858,   561,    -1,   248,   560,   858,   562,
     858,   561,    -1,    -1,   535,   371,   151,    -1,   225,    40,
     303,    -1,    -1,   886,    -1,    -1,   887,   888,    -1,   889,
      -1,   888,   562,   889,    -1,   853,   858,   854,   856,    -1,
      25,   560,   900,   561,    -1,    25,   560,   122,   900,   561,
      -1,    35,   560,   900,   561,    -1,    36,   560,   900,   561,
      -1,    38,   560,   900,   561,    -1,    83,   560,   948,   554,
     561,    -1,    83,   560,   900,   561,    -1,    -1,    -1,    83,
     560,   122,   891,   904,   892,   561,    -1,   193,   560,  1098,
     562,   331,   562,   331,   562,   900,   561,    -1,   301,   560,
     900,   561,    -1,   301,   560,   122,   900,   561,    -1,   287,
     560,   900,   561,    -1,   287,   560,   122,   900,   561,    -1,
     456,   560,   900,   561,    -1,   527,   560,   900,   561,    -1,
     457,   560,   900,   561,    -1,   521,   560,   900,   561,    -1,
     466,   560,   900,   561,    -1,   466,   560,   122,   900,   561,
      -1,    -1,   192,   560,   897,   893,   904,   899,   898,   561,
      -1,    -1,   566,   895,   896,    -1,  1119,   427,   858,    -1,
    1119,    -1,   566,  1132,  1119,   767,    -1,    -1,   122,    -1,
      -1,   422,  1099,    -1,    -1,   958,    -1,    -1,   948,   901,
     858,    -1,    32,   729,    -1,    55,   729,   744,    -1,   319,
     729,    -1,   433,    -1,   433,   223,    -1,   509,    -1,   509,
     223,    -1,    97,    -1,   481,    -1,    94,    -1,   105,   724,
      -1,    -1,   904,    -1,    -1,   905,   906,    -1,   858,    -1,
     906,   562,   858,    -1,   908,    -1,   560,   908,   561,    -1,
      -1,   909,   910,    -1,  1107,    -1,   910,   562,  1107,    -1,
      -1,   858,    -1,    -1,   546,   858,    -1,   532,   858,   547,
     858,    -1,   913,   532,   858,   547,   858,    -1,   926,    -1,
     917,    -1,   916,    -1,   914,    -1,   916,   562,   914,    -1,
     914,   925,   914,    -1,   914,   460,   926,    -1,    -1,   914,
     925,   914,   337,   918,   858,    -1,    -1,   914,   460,   926,
     337,   919,   858,    -1,    -1,   914,   925,   914,   517,   920,
     560,   942,   561,    -1,   914,   317,   230,   926,    -1,    -1,
     914,   243,   936,   230,   914,   337,   921,   858,    -1,    -1,
     914,   243,   936,   230,   926,   922,   517,   560,   942,   561,
      -1,   914,   317,   243,   936,   230,   926,    -1,    -1,   914,
     406,   936,   230,   914,   337,   923,   858,    -1,    -1,   914,
     406,   936,   230,   926,   924,   517,   560,   942,   561,    -1,
     914,   317,   406,   936,   230,   926,    -1,   230,    -1,   215,
     230,    -1,    85,   230,    -1,    -1,   927,  1111,   947,   937,
      -1,    -1,   564,  1117,   914,   243,   348,   230,   914,   337,
     928,   858,   565,    -1,   935,   934,   931,    -1,   560,   934,
     929,  1195,   561,   947,    -1,    -1,   934,   930,   916,    -1,
      -1,    -1,   932,   847,   851,   933,   701,    -1,    -1,   420,
      -1,    -1,   348,    -1,    -1,   516,   938,    -1,   165,   938,
      -1,   210,   938,    -1,    -1,   758,   939,   560,   940,   561,
      -1,    -1,   941,    -1,   941,   562,  1117,    -1,  1117,    -1,
     364,    -1,  1117,    -1,   942,   562,  1117,    -1,   944,    -1,
      98,    -1,    99,    -1,   100,    -1,   101,    -1,   202,    -1,
     203,    -1,   204,    -1,   295,    -1,   297,    -1,   298,    -1,
     417,    -1,   542,    -1,   102,    -1,   531,    -1,   205,    -1,
     170,    -1,   299,    -1,   307,    -1,   370,    -1,   418,    -1,
     543,    -1,    97,    -1,   481,    -1,    94,    -1,   478,    -1,
      -1,    18,    -1,   142,    -1,    -1,   946,  1117,    -1,    -1,
      12,    -1,    -1,    -1,   533,   950,   858,    -1,    -1,    -1,
     197,   952,   858,    -1,   146,   881,    -1,    -1,    -1,   191,
      44,   955,   956,    -1,   955,   562,  1106,   961,    -1,  1106,
     961,    -1,    -1,   535,    86,    -1,   535,   408,    -1,    -1,
     958,    -1,    -1,   345,    44,   959,   960,    -1,   960,   562,
    1106,   961,    -1,  1106,   961,    -1,    -1,    19,    -1,   113,
      -1,    -1,   964,    -1,    -1,   964,    -1,   247,   965,    -1,
     966,    -1,   966,   562,   966,    -1,   966,   334,   966,    -1,
    1100,    -1,   497,    -1,   261,    -1,   331,    -1,    -1,   247,
     966,    -1,   331,    -1,   199,    -1,   261,    -1,   497,    -1,
     104,    -1,   162,    -1,   331,    -1,   497,    -1,   261,    -1,
     104,    -1,   162,    -1,    -1,    -1,   366,  1117,   971,   560,
     972,   561,    -1,    -1,   973,    -1,   973,   562,   974,    -1,
     974,    -1,   853,   858,    -1,    -1,   976,   977,    -1,   977,
     562,   978,    -1,   978,    -1,   566,  1119,    -1,  1119,    -1,
      -1,   222,   980,   981,    -1,    -1,   349,  1116,   982,  1087,
    1090,    -1,   128,  1116,    -1,   975,    -1,    -1,   125,   984,
     904,    -1,   126,   990,  1142,   989,   987,   784,    -1,    -1,
     126,   213,  1117,   337,  1111,   986,    -1,   126,    91,   989,
    1117,    -1,   126,   175,   989,   596,    -1,   126,   366,   989,
     596,    -1,   126,   514,   595,  1172,    -1,   126,   529,   989,
     987,   784,    -1,   126,   488,   989,   596,    -1,   988,    -1,
     987,   562,   988,    -1,  1111,    -1,    -1,   209,   149,    -1,
      -1,   473,    -1,    -1,    -1,   219,   992,   997,   783,   999,
     993,  1001,  1017,    -1,    -1,    -1,   395,   995,   998,   999,
     996,  1001,    -1,    -1,   264,    -1,   110,    -1,   200,    -1,
    1026,    -1,   110,    -1,   222,  1000,    -1,  1000,    -1,   988,
      -1,  1004,    -1,   560,   561,  1004,    -1,   560,  1003,   561,
    1004,    -1,    -1,   426,  1002,  1008,    -1,  1003,   562,  1104,
      -1,  1104,    -1,   522,  1007,    -1,   523,  1007,    -1,    -1,
     680,  1005,  1192,    -1,    -1,   560,   680,   561,  1006,  1195,
      -1,  1007,   562,  1012,    -1,  1012,    -1,  1008,   562,  1009,
      -1,  1009,    -1,  1108,  1010,  1016,    -1,   142,    -1,   427,
      -1,    -1,  1010,    -1,    -1,   560,  1013,  1014,   561,    -1,
      -1,  1015,    -1,  1015,   562,  1016,    -1,  1016,    -1,   858,
      -1,   108,    -1,    -1,    -1,   337,   129,  1018,   232,   511,
    1024,    -1,    -1,    -1,   511,  1020,  1026,   783,   915,   426,
    1022,  1021,   949,   957,   967,    -1,  1022,   562,  1023,    -1,
    1023,    -1,  1108,  1010,  1016,    -1,  1024,   562,  1025,    -1,
    1025,    -1,  1108,  1010,  1016,    -1,    -1,   264,    -1,    -1,
     112,  1028,  1036,  1029,    -1,    -1,   171,  1111,  1030,   949,
     957,   967,    -1,    -1,  1033,  1031,   171,   915,   949,    -1,
      -1,   171,  1033,  1032,   517,   915,   949,    -1,  1034,    -1,
    1033,   562,  1034,    -1,  1117,  1035,   947,    -1,  1117,   567,
    1117,  1035,   947,    -1,    -1,   567,   554,    -1,    -1,  1037,
    1036,    -1,   372,    -1,   264,    -1,   210,    -1,   492,  1039,
     988,    -1,    -1,   472,    -1,    -1,   431,  1041,  1042,    -1,
      92,  1053,    -1,  1049,   470,  1048,  1053,    -1,  1049,   489,
    1048,  1053,    -1,   472,   455,  1048,  1053,    -1,   340,   470,
    1048,  1053,    -1,    -1,   140,   697,  1043,  1045,    -1,  1049,
      65,  1050,  1111,  1048,  1053,    -1,   322,   281,   168,   435,
     535,   269,   142,  1114,    16,   270,   142,   969,    16,   274,
     142,   968,    -1,  1046,   257,    -1,   435,   201,    -1,    -1,
      33,   147,  1051,  1052,  1044,   962,    -1,   760,  1050,  1111,
    1048,   949,    -1,    66,   493,    -1,   472,   493,    -1,  1047,
     139,    -1,   365,    -1,    83,   560,   554,   561,   530,    -1,
      83,   560,   554,   561,   144,    -1,   530,   962,    -1,   144,
     962,    -1,  1131,   455,  1053,    -1,   216,   455,    -1,   313,
     455,    -1,  1049,   368,    -1,  1131,   526,  1053,    -1,   735,
    1053,    -1,    64,  1053,    -1,    30,   257,    -1,   257,    -1,
     189,    -1,   189,   168,  1120,    -1,    84,    91,   690,  1117,
      -1,    84,   472,  1111,    -1,    84,   529,  1111,    -1,   281,
     455,    -1,   435,   455,    -1,    84,   366,   596,    -1,    84,
     175,   596,    -1,   366,   455,  1053,    -1,   175,   455,  1053,
      -1,   366,    62,   596,    -1,   175,    62,   596,    -1,   455,
      -1,   257,    -1,   281,    -1,    32,    -1,    -1,   459,    -1,
      -1,  1050,  1117,    -1,    -1,   173,    -1,   171,    -1,   225,
      -1,    -1,   225,  1114,    -1,    -1,   171,   969,    -1,    -1,
     246,  1114,    -1,   533,   858,    -1,    -1,  1057,  1111,  1055,
    1059,    -1,    -1,  1057,  1058,  1056,   837,    -1,   113,    -1,
     114,    -1,    -1,   153,    -1,    -1,  1099,    -1,  1117,    -1,
      -1,   164,   819,  1061,  1062,    -1,  1062,   562,  1063,    -1,
    1063,    -1,    -1,  1142,  1064,  1065,    -1,   470,   535,   380,
     256,    -1,   371,    46,    -1,   201,    -1,   365,    -1,   257,
      -1,   455,    -1,   435,    -1,   281,    -1,   117,    -1,   399,
      -1,    -1,   987,    -1,    -1,   398,  1067,  1068,    -1,  1068,
     562,  1069,    -1,  1069,    -1,   435,    -1,   281,    -1,   371,
      46,    -1,    -1,   369,  1071,  1072,    -1,  1046,   257,  1073,
      -1,   485,  1114,    -1,    27,   858,    -1,    -1,   233,  1075,
    1076,   858,    -1,    -1,    76,    -1,   371,    -1,   516,  1117,
      -1,    -1,   251,    93,  1079,  1080,    -1,   251,   472,  1111,
     171,   281,    -1,    -1,    -1,    -1,  1085,  1084,   214,  1116,
    1081,  1086,   222,  1082,   472,  1111,  1083,  1087,  1090,  1093,
    1094,  1097,    -1,   171,   281,    -1,    -1,   252,    -1,    -1,
      74,    -1,   264,    -1,    -1,   395,    -1,   210,    -1,    -1,
      65,  1088,    -1,  1088,  1089,    -1,  1089,    -1,   475,    44,
    1099,    -1,   343,   135,    44,  1099,    -1,   135,    44,  1099,
      -1,   145,    44,  1099,    -1,    -1,   249,  1091,    -1,  1091,
    1092,    -1,  1092,    -1,   475,    44,  1099,    -1,   453,    44,
    1099,    -1,    -1,   210,   331,   249,    -1,    -1,   560,  1095,
     561,    -1,   560,   561,    -1,  1095,   562,  1096,    -1,  1096,
      -1,  1108,    -1,   566,  1119,    -1,    -1,   426,  1024,    -1,
    1115,    -1,   318,    -1,   500,   476,    -1,  1098,  1115,    -1,
    1115,    -1,   199,    -1,    34,    -1,   354,    -1,  1102,    -1,
     553,  1103,    -1,   552,  1103,    -1,  1098,    -1,  1103,    -1,
     330,    -1,   155,    -1,   491,    -1,   199,    -1,    34,    -1,
     500,   199,    -1,   500,    34,    -1,    97,  1098,    -1,   481,
    1098,    -1,   478,  1098,    -1,   331,    -1,   261,    -1,   497,
      -1,   104,    -1,   162,    -1,  1108,    -1,  1105,    -1,  1117,
     567,   554,    -1,  1117,   567,  1117,   567,   554,    -1,   858,
      -1,  1117,    -1,  1109,    -1,  1117,    -1,  1109,    -1,  1117,
     567,  1117,    -1,   567,  1117,   567,  1117,    -1,  1117,   567,
    1117,   567,  1117,    -1,  1117,    -1,  1117,   567,  1117,   567,
    1117,    -1,  1117,   567,  1117,    -1,   567,  1117,    -1,  1117,
      -1,  1117,   567,  1117,    -1,   567,  1117,    -1,  1117,    -1,
     206,    -1,   208,    -1,   476,    -1,   476,    -1,   476,    -1,
    1113,    -1,  1121,    -1,  1113,    -1,  1122,    -1,  1117,    -1,
    1114,    -1,   245,    -1,  1119,    -1,  1119,   566,  1119,    -1,
      88,   857,    -1,  1122,    -1,    20,    -1,    26,    -1,    28,
      -1,    45,    -1,    46,    -1,    54,    -1,    56,    -1,    60,
      -1,    67,    -1,    69,    -1,    79,    -1,   103,    -1,   125,
      -1,   138,    -1,   148,    -1,   164,    -1,   195,    -1,   198,
      -1,   235,    -1,   328,    -1,   340,    -1,   362,    -1,   392,
      -1,   398,    -1,   400,    -1,   407,    -1,   416,    -1,   419,
      -1,   433,    -1,   435,    -1,   454,    -1,   458,    -1,   492,
      -1,   502,    -1,   539,    -1,   512,    -1,     5,    -1,     7,
      -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,    17,
      -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,    33,
      -1,    37,    -1,    41,    -1,    40,    -1,    43,    -1,    49,
      -1,    51,    -1,    53,    -1,    58,    -1,    59,    -1,    62,
      -1,    64,    -1,    65,    -1,    68,    -1,    70,    -1,    71,
      -1,    74,    -1,    77,    -1,    86,    -1,    93,    -1,    94,
      -1,    97,    -1,   102,    -1,   109,    -1,   111,    -1,   117,
      -1,   119,    -1,   121,    -1,   128,    -1,   129,    -1,   130,
      -1,   141,    -1,   140,    -1,   139,    -1,   144,    -1,   146,
      -1,   147,    -1,   151,    -1,   153,    -1,   156,    -1,   169,
      -1,   120,    -1,   134,    -1,   173,    -1,   159,    -1,   160,
      -1,   161,    -1,   170,    -1,   183,    -1,   182,    -1,   186,
      -1,   189,    -1,   187,    -1,   196,    -1,   201,    -1,   205,
      -1,   207,    -1,   224,    -1,   211,    -1,   212,    -1,   227,
      -1,   228,    -1,   216,    -1,   220,    -1,   388,    -1,   237,
      -1,   241,    -1,   244,    -1,   250,    -1,   252,    -1,   255,
      -1,   257,    -1,   286,    -1,   281,    -1,   268,    -1,   272,
      -1,   269,    -1,   270,    -1,   282,    -1,   271,    -1,   274,
      -1,   267,    -1,   280,    -1,   276,    -1,   275,    -1,   277,
      -1,   278,    -1,   279,    -1,   284,    -1,   285,    -1,   288,
      -1,   289,    -1,   293,    -1,   294,    -1,   295,    -1,   296,
      -1,   299,    -1,   300,    -1,   305,    -1,   303,    -1,   307,
      -1,   310,    -1,   311,    -1,   312,    -1,   313,    -1,   315,
      -1,   314,    -1,   316,    -1,   319,    -1,   320,    -1,   323,
      -1,   322,    -1,   324,    -1,   333,    -1,   334,    -1,   336,
      -1,   338,    -1,   339,    -1,   351,    -1,   352,    -1,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,   363,    -1,   365,
      -1,   367,    -1,   368,    -1,   370,    -1,   371,    -1,   372,
      -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,   377,
      -1,   382,    -1,   383,    -1,   386,    -1,   387,    -1,   390,
      -1,   393,    -1,   396,    -1,   399,    -1,   402,    -1,   403,
      -1,   408,    -1,   410,    -1,   411,    -1,   413,    -1,   414,
      -1,   415,    -1,   418,    -1,   424,    -1,   423,    -1,   425,
      -1,   434,    -1,   428,    -1,   432,    -1,   437,    -1,   438,
      -1,   446,    -1,   445,    -1,   448,    -1,   451,    -1,   455,
      -1,   459,    -1,   461,    -1,   462,    -1,   463,    -1,   467,
      -1,   468,    -1,   470,    -1,   471,    -1,   473,    -1,   474,
      -1,   477,    -1,   487,    -1,   489,    -1,   478,    -1,   479,
      -1,   480,    -1,   481,    -1,   493,    -1,   494,    -1,   495,
      -1,   175,    -1,   498,    -1,   499,    -1,   507,    -1,   510,
      -1,   514,    -1,   515,    -1,   526,    -1,   529,    -1,   523,
      -1,   530,    -1,   531,    -1,   536,    -1,   538,    -1,   543,
      -1,    -1,   426,  1125,  1124,  1126,    -1,    -1,   342,    -1,
    1127,    -1,  1126,   562,  1127,    -1,    -1,  1128,  1133,    -1,
    1130,    -1,   187,    -1,   252,    -1,   425,    -1,    -1,   338,
      -1,    -1,   187,    -1,   252,    -1,   425,    -1,    -1,   187,
     567,    -1,   252,   567,    -1,   425,   567,    -1,  1134,    -1,
    1130,  1135,    -1,  1129,  1136,  1010,  1139,    -1,  1129,   487,
     227,   244,  1137,    -1,   566,  1119,  1010,   858,    -1,   566,
     566,  1132,  1136,  1010,  1139,    -1,   735,   739,    -1,   314,
    1010,   858,    -1,   314,   737,   741,    -1,   353,  1010,  1138,
      -1,   353,   168,  1120,  1010,  1138,    -1,  1117,    -1,  1117,
     567,  1117,    -1,   108,   567,  1117,    -1,   380,   498,    -1,
     380,    68,    -1,   393,   380,    -1,   423,    -1,   476,    -1,
     353,   560,   476,   561,    -1,   336,   560,   476,   561,    -1,
     858,    -1,   108,    -1,   337,    -1,    12,    -1,    32,    -1,
      -1,   256,  1142,  1141,  1143,    -1,   472,    -1,   470,    -1,
    1144,    -1,  1143,   562,  1144,    -1,  1111,   947,  1145,    -1,
     380,    -1,   537,    -1,   264,   537,    -1,   380,   252,    -1,
      -1,   508,  1147,  1142,    -1,   195,  1111,   340,   947,    -1,
     195,  1112,    60,    -1,    -1,   195,  1112,   380,  1149,  1150,
     949,   963,    -1,  1151,    -1,  1117,  1152,    -1,   160,    -1,
     323,    -1,   160,    -1,   323,    -1,   363,    -1,   237,    -1,
      -1,  1154,  1153,   560,  1015,   561,    -1,   142,    -1,   180,
      -1,   238,    -1,   194,    -1,   265,    -1,   405,   595,  1156,
      -1,  1160,   337,  1159,  1171,   171,  1173,    -1,  1160,   337,
     175,  1171,   171,  1173,    -1,  1160,   337,   366,  1171,   171,
    1173,    -1,    12,  1161,   562,   188,   342,   171,  1173,    -1,
     188,   595,  1158,    -1,  1160,   337,  1159,  1171,   485,  1173,
    1178,  1179,    -1,  1160,   337,   175,  1171,   485,  1173,  1178,
    1179,    -1,  1160,   337,   366,  1171,   485,  1173,  1178,  1179,
      -1,    -1,   472,    -1,  1162,    -1,    12,  1161,    -1,    -1,
     365,    -1,  1163,    -1,  1162,   562,  1163,    -1,    -1,   420,
    1164,  1175,    -1,    -1,   219,  1165,  1175,    -1,    -1,   511,
    1166,  1175,    -1,    -1,   384,  1167,  1175,    -1,   112,    -1,
     513,    -1,   213,    -1,    13,    -1,    84,    -1,   126,    -1,
     148,    -1,   390,    -1,   432,    -1,   367,    -1,   159,    -1,
     188,   342,    -1,   431,    92,    -1,   467,    -1,    84,   473,
     470,    -1,   256,   470,    -1,   396,   435,    -1,   396,    59,
      -1,    84,   529,    -1,   431,   529,    -1,    84,   410,    -1,
      13,   410,    -1,    84,   514,    -1,    -1,    16,    -1,  1170,
    1168,  1169,    -1,  1170,    -1,   463,   476,    -1,   228,   476,
      -1,    58,   476,    -1,   554,    -1,  1117,   567,   554,    -1,
     554,   567,   554,    -1,  1111,    -1,  1120,    -1,  1172,   562,
    1120,    -1,  1174,    -1,  1173,   562,  1174,    -1,  1120,   207,
      44,   476,    -1,  1120,   207,    44,   353,   476,    -1,  1120,
      -1,    -1,   560,  1176,   561,    -1,  1176,   562,  1177,    -1,
    1177,    -1,  1117,    -1,    -1,   397,  1169,    -1,   397,   452,
      -1,   397,   538,    -1,   397,   324,    -1,    -1,   535,  1180,
      -1,  1180,  1181,    -1,  1181,    -1,   188,   342,    -1,   285,
     968,    -1,   288,   968,    -1,   284,   968,    -1,   289,   968,
      -1,    -1,    28,  1183,  1184,    -1,    -1,   536,    -1,    -1,
      16,   328,    51,    -1,    16,    51,    -1,    -1,   389,    -1,
     328,   389,    -1,    -1,   416,    -1,    69,  1184,  1185,  1186,
      -1,   407,  1184,  1185,  1186,    -1,   407,  1184,   485,  1187,
    1117,    -1,   416,  1117,    -1,   389,   416,  1117,    -1,    -1,
    1193,    -1,    -1,   503,  1199,  1194,   838,    -1,    -1,  1193,
      -1,  1196,    -1,    -1,  1197,  1198,    -1,   958,   962,    -1,
     964,    -1,    -1,   122,    -1,    12,    -1,   420,  1203,  1202,
    1204,    -1,    -1,   560,  1203,  1200,   561,  1201,  1192,  1204,
      -1,   840,    -1,    -1,    -1,  1207,  1206,    -1,  1208,  1207,
    1213,    -1,  1213,    -1,  1221,    -1,  1223,    -1,    -1,   109,
     142,  1120,    -1,  1209,    -1,  1209,  1210,    -1,  1210,    -1,
     347,   395,    -1,    11,   142,   499,    -1,    11,   142,   294,
      -1,    11,   142,   474,    -1,    -1,  1210,    -1,    -1,   450,
     419,   109,    -1,   450,   419,   224,    -1,    -1,  1212,   529,
    1111,  1214,  1215,    18,  1217,  1220,    -1,    -1,   560,  1216,
     561,    -1,  1117,    -1,  1216,   562,  1117,    -1,    -1,  1218,
    1219,    -1,   420,   853,   840,    -1,   560,   853,   839,   561,
    1195,    -1,    -1,   535,    57,   342,    -1,   535,    49,    57,
     342,    -1,   535,   252,    57,   342,    -1,    -1,   488,   853,
     596,   672,   673,   337,   853,  1111,   168,   853,   131,   414,
    1222,   636,    -1,    -1,   702,   853,   175,   596,  1224,   597,
      -1,    -1,    -1,    -1,    -1,   366,   853,   596,  1225,   560,
    1226,   617,   561,  1227,   604,  1228,   636,    -1,   539,  1231,
    1230,  1232,    -1,   539,   138,  1230,  1234,    -1,   539,   362,
    1230,    -1,   539,    69,  1230,  1233,    -1,   539,   407,  1230,
      -1,   539,   382,    -1,  1099,    -1,  1099,   562,  1099,    -1,
    1099,   562,  1099,   562,   968,    -1,    28,    -1,   454,    -1,
      -1,   230,    -1,   402,    -1,    -1,   339,   355,    -1,    -1,
      -1,   468,  1235,  1236,    -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1061,  1061,  1075,  1078,  1079,  1084,  1085,  1086,  1087,
    1088,  1089,  1090,  1091,  1092,  1093,  1094,  1095,  1096,  1097,
    1098,  1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,  1107,
    1108,  1109,  1110,  1111,  1112,  1113,  1114,  1115,  1116,  1117,
    1118,  1119,  1120,  1121,  1122,  1123,  1124,  1125,  1126,  1127,
    1128,  1129,  1130,  1134,  1148,  1149,  1154,  1168,  1175,  1185,
    1184,  1200,  1202,  1206,  1207,  1210,  1223,  1222,  1241,  1240,
    1251,  1252,  1255,  1260,  1265,  1270,  1275,  1279,  1284,  1288,
    1292,  1296,  1300,  1305,  1309,  1313,  1329,  1333,  1345,  1344,
    1368,  1367,  1387,  1386,  1399,  1398,  1406,  1414,  1428,  1443,
    1461,  1481,  1518,  1524,  1532,  1544,  1480,  1573,  1574,  1578,
    1579,  1584,  1586,  1588,  1590,  1592,  1594,  1596,  1602,  1603,
    1604,  1608,  1612,  1620,  1619,  1632,  1634,  1637,  1639,  1643,
    1647,  1654,  1656,  1660,  1661,  1666,  1685,  1711,  1713,  1717,
    1718,  1722,  1748,  1749,  1750,  1751,  1755,  1756,  1760,  1761,
    1766,  1769,  1796,  1795,  1851,  1866,  1865,  1905,  1929,  1929,
    1960,  1961,  1966,  1987,  2011,  2017,  2032,  2033,  2037,  2041,
    2050,  2055,  2060,  2068,  2083,  2101,  2102,  2106,  2106,  2152,
    2151,  2175,  2174,  2178,  2179,  2181,  2181,  2192,  2221,  2249,
    2265,  2264,  2281,  2298,  2300,  2301,  2305,  2326,  2349,  2351,
    2365,  2349,  2383,  2385,  2386,  2390,  2391,  2396,  2402,  2395,
    2421,  2420,  2436,  2437,  2441,  2442,  2447,  2451,  2446,  2468,
    2472,  2467,  2487,  2495,  2500,  2499,  2537,  2538,  2543,  2542,
    2569,  2580,  2582,  2579,  2606,  2605,  2623,  2625,  2630,  2632,
    2634,  2639,  2640,  2641,  2653,  2668,  2669,  2669,  2673,  2675,
    2674,  2677,  2676,  2682,  2698,  2681,  2712,  2713,  2716,  2717,
    2720,  2721,  2724,  2725,  2728,  2729,  2732,  2733,  2736,  2739,
    2740,  2742,  2744,  2747,  2748,  2751,  2752,  2753,  2756,  2757,
    2758,  2759,  2760,  2761,  2762,  2763,  2764,  2779,  2785,  2786,
    2787,  2788,  2793,  2798,  2803,  2818,  2819,  2820,  2821,  2822,
    2823,  2827,  2844,  2860,  2870,  2871,  2872,  2873,  2874,  2875,
    2878,  2879,  2880,  2883,  2884,  2885,  2888,  2889,  2892,  2893,
    2896,  2897,  2898,  2899,  2902,  2903,  2907,  2908,  2912,  2913,
    2920,  2926,  2934,  2948,  2952,  2958,  2960,  2964,  2968,  2969,
    2973,  2978,  2977,  2999,  3000,  3001,  3002,  3004,  3006,  3008,
    3010,  3012,  3014,  3017,  3020,  3023,  3026,  3028,  3031,  3034,
    3035,  3036,  3037,  3050,  3051,  3053,  3055,  3067,  3069,  3071,
    3073,  3074,  3075,  3076,  3077,  3078,  3080,  3082,  3084,  3084,
    3086,  3086,  3088,  3089,  3098,  3099,  3100,  3103,  3104,  3105,
    3106,  3107,  3111,  3115,  3116,  3120,  3121,  3125,  3126,  3127,
    3128,  3129,  3133,  3134,  3135,  3136,  3137,  3140,  3142,  3143,
    3147,  3148,  3149,  3152,  3159,  3160,  3163,  3164,  3167,  3168,
    3169,  3172,  3173,  3176,  3177,  3180,  3181,  3184,  3185,  3188,
    3189,  3190,  3191,  3193,  3194,  3200,  3206,  3212,  3218,  3219,
    3235,  3236,  3240,  3241,  3245,  3253,  3257,  3258,  3262,  3271,
    3275,  3276,  3279,  3289,  3290,  3294,  3295,  3298,  3299,  3302,
    3303,  3304,  3305,  3314,  3315,  3318,  3319,  3322,  3323,  3324,
    3333,  3335,  3337,  3342,  3341,  3353,  3354,  3357,  3358,  3362,
    3363,  3366,  3367,  3370,  3371,  3372,  3373,  3374,  3377,  3378,
    3379,  3380,  3381,  3384,  3385,  3386,  3398,  3399,  3402,  3403,
    3406,  3407,  3411,  3412,  3413,  3416,  3417,  3418,  3419,  3432,
    3433,  3434,  3437,  3438,  3442,  3445,  3446,  3449,  3450,  3461,
    3462,  3465,  3466,  3469,  3470,  3478,  3477,  3504,  3503,  3518,
    3517,  3536,  3535,  3555,  3553,  3568,  3569,  3571,  3572,  3573,
    3574,  3575,  3578,  3586,  3587,  3591,  3596,  3595,  3603,  3612,
    3602,  3624,  3631,  3635,  3642,  3649,  3655,  3661,  3667,  3674,
    3693,  3714,  3719,  3723,  3730,  3731,  3734,  3735,  3739,  3740,
    3741,  3745,  3746,  3747,  3750,  3751,  3752,  3753,  3761,  3760,
    3771,  3779,  3778,  3788,  3798,  3807,  3808,  3815,  3815,  3821,
    3822,  3826,  3827,  3828,  3832,  3833,  3850,  3851,  3856,  3855,
    3866,  3865,  3876,  3875,  3885,  3886,  3887,  3892,  3891,  3903,
    3904,  3907,  3908,  3911,  3912,  3913,  3917,  3916,  3929,  3928,
    3945,  3946,  3949,  3950,  3953,  3954,  3955,  3956,  3957,  3958,
    3962,  3961,  3973,  3974,  3975,  3980,  3979,  3985,  3992,  3997,
    4005,  4006,  4009,  4021,  4030,  4031,  4034,  4047,  4048,  4053,
    4052,  4062,  4063,  4066,  4079,  4079,  4089,  4090,  4099,  4100,
    4109,  4118,  4120,  4123,  4145,  4149,  4148,  4168,  4176,  4168,
    4182,  4183,  4184,  4185,  4186,  4189,  4191,  4198,  4200,  4211,
    4212,  4215,  4216,  4222,  4223,  4224,  4225,  4231,  4237,  4243,
    4253,  4256,  4258,  4264,  4274,  4275,  4276,  4289,  4307,  4310,
    4313,  4314,  4317,  4318,  4319,  4320,  4321,  4325,  4326,  4330,
    4330,  4347,  4349,  4354,  4355,  4355,  4372,  4374,  4379,  4380,
    4383,  4384,  4385,  4386,  4387,  4388,  4389,  4392,  4393,  4394,
    4395,  4397,  4399,  4402,  4404,  4406,  4410,  4416,  4420,  4428,
    4430,  4436,  4439,  4441,  4443,  4444,  4446,  4449,  4450,  4453,
    4454,  4457,  4459,  4461,  4464,  4465,  4466,  4468,  4470,  4473,
    4474,  4475,  4476,  4477,  4478,  4481,  4482,  4484,  4484,  4485,
    4485,  4486,  4486,  4487,  4487,  4489,  4490,  4491,  4492,  4493,
    4494,  4497,  4498,  4502,  4506,  4507,  4514,  4515,  4516,  4517,
    4518,  4520,  4521,  4522,  4523,  4524,  4528,  4529,  4534,  4539,
    4543,  4544,  4548,  4549,  4553,  4563,  4565,  4574,  4576,  4587,
    4589,  4600,  4611,  4622,  4633,  4635,  4637,  4639,  4641,  4643,
    4645,  4647,  4649,  4651,  4653,  4655,  4657,  4663,  4665,  4667,
    4672,  4677,  4679,  4681,  4686,  4688,  4690,  4692,  4694,  4699,
    4700,  4702,  4704,  4706,  4708,  4710,  4712,  4714,  4716,  4718,
    4720,  4722,  4726,  4728,  4738,  4740,  4742,  4744,  4746,  4749,
    4758,  4763,  4768,  4770,  4772,  4774,  4776,  4778,  4780,  4782,
    4787,  4792,  4794,  4796,  4798,  4800,  4802,  4804,  4810,  4812,
    4814,  4816,  4818,  4820,  4822,  4824,  4826,  4827,  4832,  4834,
    4836,  4838,  4840,  4842,  4844,  4846,  4848,  4855,  4862,  4864,
    4866,  4868,  4870,  4872,  4874,  4876,  4878,  4880,  4882,  4884,
    4886,  4888,  4890,  4904,  4903,  5021,  5025,  5030,  5032,  5034,
    5036,  5038,  5040,  5045,  5047,  5049,  5051,  5053,  5058,  5062,
    5064,  5066,  5068,  5070,  5072,  5076,  5079,  5082,  5084,  5086,
    5088,  5090,  5092,  5094,  5097,  5100,  5102,  5104,  5106,  5108,
    5110,  5113,  5115,  5117,  5119,  5124,  5125,  5126,  5130,  5131,
    5135,  5135,  5141,  5145,  5152,  5183,  5185,  5187,  5189,  5191,
    5193,  5195,  5198,  5200,  5197,  5203,  5205,  5212,  5214,  5216,
    5218,  5220,  5222,  5224,  5226,  5228,  5231,  5230,  5245,  5244,
    5259,  5265,  5271,  5284,  5285,  5288,  5289,  5294,  5297,  5309,
    5308,  5324,  5325,  5326,  5327,  5328,  5329,  5330,  5331,  5332,
    5333,  5334,  5338,  5339,  5343,  5343,  5348,  5349,  5352,  5353,
    5356,  5356,  5361,  5362,  5365,  5366,  5369,  5370,  5373,  5379,
    5389,  5390,  5399,  5404,  5405,  5425,  5427,  5431,  5429,  5446,
    5444,  5462,  5460,  5468,  5477,  5475,  5493,  5492,  5499,  5510,
    5508,  5527,  5526,  5538,  5548,  5549,  5550,  5555,  5555,  5574,
    5572,  5591,  5613,  5661,  5660,  5683,  5700,  5683,  5707,  5711,
    5737,  5738,  5741,  5742,  5748,  5755,  5763,  5763,  5769,  5770,
    5774,  5778,  5782,  5788,  5796,  5805,  5806,  5807,  5808,  5809,
    5810,  5811,  5812,  5813,  5814,  5815,  5816,  5817,  5820,  5821,
    5822,  5823,  5824,  5825,  5826,  5827,  5828,  5832,  5833,  5834,
    5835,  5838,  5840,  5841,  5844,  5845,  5848,  5850,  5854,  5856,
    5855,  5869,  5872,  5871,  5886,  5892,  5905,  5907,  5910,  5912,
    5916,  5917,  5930,  5947,  5949,  5953,  5952,  5984,  5986,  5990,
    5991,  5992,  5997,  6003,  6007,  6008,  6012,  6016,  6023,  6030,
    6039,  6040,  6041,  6042,  6047,  6051,  6059,  6060,  6061,  6062,
    6063,  6064,  6068,  6069,  6070,  6071,  6072,  6075,  6078,  6077,
    6106,  6107,  6110,  6111,  6114,  6127,  6127,  6137,  6138,  6142,
    6154,  6187,  6186,  6199,  6198,  6207,  6219,  6230,  6229,  6246,
    6253,  6253,  6264,  6271,  6283,  6295,  6299,  6305,  6315,  6316,
    6319,  6327,  6328,  6332,  6333,  6341,  6350,  6340,  6360,  6367,
    6359,  6377,  6389,  6390,  6391,  6395,  6396,  6399,  6400,  6403,
    6412,  6413,  6414,  6416,  6415,  6425,  6426,  6429,  6430,  6431,
    6431,  6432,  6432,  6436,  6437,  6440,  6442,  6445,  6453,  6454,
    6458,  6459,  6464,  6463,  6476,  6477,  6480,  6485,  6493,  6494,
    6497,  6499,  6499,  6507,  6516,  6506,  6538,  6539,  6542,  6549,
    6550,  6553,  6562,  6563,  6569,  6568,  6582,  6581,  6590,  6589,
    6597,  6596,  6606,  6607,  6610,  6617,  6630,  6631,  6635,  6636,
    6639,  6640,  6641,  6644,  6654,  6656,  6661,  6660,  6674,  6682,
    6691,  6700,  6709,  6719,  6718,  6721,  6731,  6741,  6745,  6750,
    6749,  6754,  6764,  6769,  6775,  6780,  6785,  6787,  6789,  6791,
    6793,  6802,  6804,  6806,  6808,  6817,  6825,  6833,  6835,  6837,
    6847,  6854,  6860,  6868,  6876,  6880,  6884,  6891,  6898,  6908,
    6918,  6928,  6941,  6955,  6968,  6969,  6971,  6973,  6976,  6977,
    6980,  6981,  6984,  6985,  6988,  6989,  6992,  6993,  6995,  6997,
    7000,  7012,  7011,  7026,  7025,  7035,  7036,  7039,  7040,  7044,
    7045,  7046,  7054,  7053,  7065,  7066,  7069,  7069,  7070,  7071,
    7072,  7073,  7074,  7075,  7076,  7077,  7078,  7079,  7082,  7083,
    7087,  7086,  7095,  7096,  7099,  7100,  7101,  7105,  7104,  7113,
    7117,  7122,  7134,  7134,  7142,  7143,  7144,  7149,  7159,  7158,
    7171,  7189,  7200,  7205,  7188,  7218,  7227,  7228,  7231,  7232,
    7244,  7248,  7249,  7250,  7252,  7254,  7257,  7258,  7261,  7266,
    7273,  7278,  7284,  7286,  7289,  7290,  7293,  7298,  7304,  7306,
    7313,  7314,  7315,  7318,  7320,  7325,  7326,  7331,  7332,  7338,
    7343,  7345,  7347,  7352,  7354,  7365,  7378,  7398,  7399,  7400,
    7409,  7410,  7411,  7413,  7414,  7415,  7416,  7417,  7431,  7445,
    7446,  7447,  7450,  7451,  7452,  7453,  7461,  7476,  7477,  7480,
    7486,  7497,  7500,  7534,  7538,  7546,  7550,  7618,  7633,  7657,
    7658,  7674,  7684,  7687,  7688,  7689,  7693,  7697,  7698,  7723,
    7735,  7748,  7760,  7761,  7770,  7771,  7780,  7781,  7782,  7785,
    7798,  7811,  7825,  7826,  7827,  7828,  7829,  7830,  7831,  7832,
    7833,  7834,  7835,  7836,  7837,  7838,  7839,  7840,  7841,  7842,
    7843,  7844,  7845,  7846,  7847,  7848,  7849,  7850,  7851,  7852,
    7853,  7854,  7855,  7856,  7857,  7858,  7859,  7860,  7861,  7871,
    7872,  7873,  7874,  7875,  7876,  7877,  7878,  7879,  7880,  7881,
    7882,  7883,  7884,  7885,  7886,  7887,  7888,  7889,  7890,  7891,
    7892,  7893,  7894,  7895,  7896,  7897,  7898,  7899,  7900,  7901,
    7902,  7903,  7904,  7905,  7906,  7907,  7908,  7909,  7910,  7911,
    7912,  7913,  7914,  7915,  7916,  7917,  7918,  7919,  7920,  7921,
    7922,  7923,  7924,  7925,  7926,  7927,  7928,  7929,  7930,  7931,
    7932,  7933,  7934,  7935,  7936,  7937,  7938,  7939,  7940,  7941,
    7942,  7943,  7944,  7945,  7946,  7947,  7948,  7949,  7950,  7951,
    7952,  7953,  7954,  7955,  7956,  7957,  7958,  7959,  7960,  7961,
    7962,  7963,  7964,  7965,  7966,  7967,  7968,  7969,  7970,  7971,
    7972,  7973,  7974,  7975,  7976,  7977,  7978,  7979,  7980,  7981,
    7982,  7983,  7984,  7985,  7986,  7987,  7988,  7989,  7990,  7991,
    7992,  7993,  7994,  7995,  7996,  7997,  7998,  7999,  8000,  8001,
    8002,  8003,  8004,  8005,  8006,  8007,  8008,  8009,  8010,  8011,
    8012,  8013,  8014,  8015,  8016,  8017,  8018,  8019,  8020,  8021,
    8022,  8023,  8024,  8025,  8026,  8027,  8028,  8029,  8030,  8031,
    8032,  8033,  8034,  8035,  8036,  8037,  8038,  8039,  8040,  8041,
    8042,  8043,  8044,  8045,  8046,  8047,  8048,  8049,  8050,  8051,
    8052,  8053,  8054,  8055,  8056,  8057,  8058,  8059,  8060,  8061,
    8062,  8063,  8064,  8065,  8066,  8067,  8068,  8069,  8070,  8071,
    8072,  8073,  8074,  8075,  8076,  8077,  8078,  8079,  8080,  8081,
    8082,  8089,  8088,  8102,  8103,  8106,  8107,  8110,  8110,  8182,
    8183,  8184,  8185,  8189,  8190,  8194,  8195,  8196,  8197,  8201,
    8202,  8203,  8204,  8208,  8209,  8212,  8292,  8305,  8309,  8314,
    8321,  8336,  8349,  8370,  8377,  8415,  8458,  8472,  8473,  8474,
    8475,  8479,  8480,  8487,  8496,  8497,  8498,  8499,  8500,  8508,
    8507,  8523,  8524,  8527,  8528,  8531,  8539,  8540,  8541,  8542,
    8547,  8546,  8567,  8579,  8592,  8591,  8610,  8611,  8615,  8616,
    8620,  8621,  8622,  8623,  8625,  8624,  8635,  8636,  8637,  8638,
    8639,  8645,  8650,  8657,  8670,  8682,  8689,  8694,  8702,  8715,
    8729,  8731,  8734,  8735,  8742,  8744,  8748,  8749,  8752,  8752,
    8753,  8753,  8754,  8754,  8755,  8755,  8756,  8757,  8758,  8759,
    8760,  8761,  8762,  8763,  8764,  8765,  8766,  8767,  8768,  8769,
    8770,  8771,  8772,  8773,  8774,  8775,  8776,  8777,  8778,  8783,
    8784,  8788,  8789,  8793,  8803,  8813,  8826,  8841,  8854,  8867,
    8879,  8880,  8889,  8890,  8899,  8924,  8926,  8933,  8937,  8940,
    8941,  8944,  8965,  8966,  8970,  8974,  8978,  8985,  8986,  8989,
    8990,  8994,  8995,  9001,  9007,  9013,  9023,  9022,  9032,  9033,
    9037,  9038,  9039,  9043,  9044,  9045,  9049,  9050,  9054,  9064,
    9071,  9081,  9090,  9104,  9105,  9110,  9109,  9144,  9145,  9146,
    9150,  9150,  9174,  9175,  9179,  9180,  9181,  9185,  9190,  9189,
    9210,  9216,  9236,  9252,  9254,  9259,  9261,  9263,  9275,  9285,
    9298,  9300,  9302,  9307,  9312,  9314,  9316,  9322,  9323,  9329,
    9330,  9332,  9338,  9337,  9352,  9353,  9357,  9362,  9370,  9370,
    9388,  9397,  9410,  9411,  9413,  9415,  9428,  9426,  9501,  9500,
    9510,  9539,  9546,  9553,  9509,  9575,  9579,  9583,  9587,  9591,
    9595,  9601,  9608,  9615,  9624,  9625,  9629,  9630,  9631,  9635,
    9636,  9640,  9641,  9641,  9646,  9647
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_cond", "opt_value",
  "sp_hcond", "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "@17",
  "@18", "@19", "@20", "@21", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "@22", "@23", "@24", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "@25", "@26", "searched_case_stmt", "@27",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "@28", "@29", "searched_when_clause", "@30", "@31",
  "else_clause_opt", "sp_labeled_control", "@32", "sp_opt_label",
  "sp_unlabeled_control", "@33", "@34", "@35", "@36", "trg_action_time",
  "trg_event", "create2", "create2a", "@37", "create3", "@38", "@39",
  "create_select", "@40", "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "opt_binary", "opt_bin_mod",
  "opt_bin_charset", "opt_primary", "references", "@45", "opt_ref_list",
  "ref_list", "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_ignore_lines", "opt_field_or_var_spec",
  "fields_or_vars", "field_or_var", "opt_load_data_set_spec",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "keyword", "keyword_sp", "set", "@132",
  "opt_option", "option_value_list", "option_type_value", "@133",
  "option_type", "option_type2", "opt_var_type", "opt_var_ident_type",
  "ext_option_value", "sys_option_value", "option_value",
  "internal_variable_name", "isolation_types", "text_or_password",
  "set_expr_or_default", "lock", "@134", "table_or_tables",
  "table_lock_list", "table_lock", "lock_option", "unlock", "@135",
  "handler", "@136", "handler_read_or_scan", "handler_scan_function",
  "handler_rkey_function", "@137", "handler_rkey_mode", "revoke",
  "revoke_command", "grant", "grant_command", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "@138", "@139", "@140", "@141", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "grant_user", "opt_column_list", "column_list",
  "column_list_id", "require_clause", "grant_options", "grant_option_list",
  "grant_option", "begin", "@142", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "@143", "union_opt",
  "union_order_or_limit", "@144", "order_or_limit", "union_option",
  "subselect", "@145", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@146", "view_list_opt",
  "view_list", "view_select", "@147", "view_select_aux",
  "view_check_option", "trigger_tail", "@148", "sp_tail", "@149", "@150",
  "@151", "@152", "@153", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@154",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   598,   599,   600,   601,   602,   597,   603,   603,   604,
     604,   605,   605,   605,   605,   605,   605,   605,   606,   606,
     606,   607,   607,   609,   608,   610,   610,   611,   611,   612,
     612,   613,   613,   614,   614,   615,   616,   617,   617,   618,
     618,   619,   620,   620,   620,   620,   621,   621,   622,   622,
     623,   623,   625,   624,   624,   626,   624,   624,   628,   627,
     629,   629,   630,   630,   631,   631,   632,   632,   633,   633,
     633,   633,   633,   634,   634,   635,   635,   637,   636,   638,
     636,   639,   636,   636,   636,   640,   636,   636,   636,   636,
     641,   636,   636,   642,   642,   642,   643,   643,   645,   646,
     647,   644,   648,   648,   648,   649,   649,   651,   652,   650,
     654,   653,   655,   655,   656,   656,   658,   659,   657,   661,
     662,   660,   663,   663,   665,   664,   666,   666,   668,   667,
     667,   669,   670,   667,   671,   667,   672,   672,   673,   673,
     673,   674,   674,   674,   674,   675,   676,   675,   677,   678,
     677,   679,   677,   681,   682,   680,   683,   683,   684,   684,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   690,
     690,   691,   691,   692,   692,   693,   693,   693,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   695,   696,   697,   698,   698,   698,   698,   698,   698,
     699,   699,   699,   700,   700,   700,   701,   701,   702,   702,
     703,   703,   703,   703,   704,   704,   705,   705,   706,   706,
     707,   707,   707,   707,   707,   708,   708,   709,   710,   710,
     711,   713,   712,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   715,   714,
     716,   714,   714,   714,   717,   717,   717,   717,   717,   717,
     717,   717,   718,   719,   719,   720,   720,   721,   721,   721,
     721,   721,   722,   722,   722,   722,   722,   723,   723,   723,
     724,   724,   724,   725,   726,   726,   727,   727,   728,   728,
     728,   729,   729,   730,   730,   731,   731,   732,   732,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     734,   734,   735,   735,   736,   736,   737,   737,   738,   738,
     739,   739,   740,   741,   741,   742,   742,   743,   743,   744,
     744,   744,   744,   744,   744,   745,   745,   746,   746,   746,
     746,   747,   747,   749,   748,   750,   750,   751,   751,   752,
     752,   753,   753,   754,   754,   754,   754,   754,   755,   755,
     755,   755,   755,   756,   756,   756,   757,   757,   758,   758,
     759,   759,   760,   760,   760,   761,   761,   761,   761,   762,
     762,   762,   763,   763,   763,   764,   764,   765,   765,   766,
     766,   767,   767,   768,   768,   770,   769,   771,   769,   772,
     769,   773,   769,   774,   769,   775,   775,   776,   776,   776,
     776,   776,   777,   778,   778,   778,   779,   778,   780,   781,
     778,   778,   778,   778,   778,   778,   778,   778,   778,   778,
     778,   778,   778,   778,   782,   782,   783,   783,   784,   784,
     784,   785,   785,   785,   786,   786,   786,   786,   788,   787,
     787,   789,   787,   787,   790,   791,   791,   793,   792,   794,
     794,   795,   795,   795,   796,   796,   797,   797,   799,   798,
     801,   800,   803,   802,   804,   804,   804,   806,   805,   807,
     807,   808,   808,   809,   809,   809,   811,   810,   813,   812,
     814,   814,   815,   815,   816,   816,   816,   816,   816,   816,
     818,   817,   819,   819,   819,   821,   820,   820,   822,   822,
     823,   823,   824,   825,   826,   826,   827,   828,   828,   830,
     829,   831,   831,   832,   834,   833,   835,   835,   836,   836,
     837,   838,   838,   839,   839,   841,   840,   843,   844,   842,
     845,   845,   845,   845,   845,   846,   846,   847,   847,   848,
     848,   849,   849,   849,   849,   849,   849,   849,   849,   849,
     849,   850,   850,   850,   851,   851,   851,   852,   853,   854,
     855,   855,   856,   856,   856,   856,   856,   857,   857,   859,
     858,   860,   860,   861,   862,   861,   863,   863,   864,   864,
     865,   865,   865,   865,   865,   865,   865,   866,   866,   866,
     866,   866,   866,   867,   867,   867,   867,   867,   867,   867,
     867,   867,   867,   867,   867,   867,   867,   868,   868,   869,
     869,   870,   870,   870,   871,   871,   871,   871,   871,   872,
     872,   872,   872,   872,   872,   873,   873,   874,   874,   875,
     875,   876,   876,   877,   877,   878,   878,   878,   878,   878,
     878,   879,   879,   880,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   882,   881,   881,   881,   881,   881,   881,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   884,   884,   884,   885,   885,
     887,   886,   888,   888,   889,   890,   890,   890,   890,   890,
     890,   890,   891,   892,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   893,   890,   895,   894,
     896,   896,   896,   897,   897,   898,   898,   899,   899,   901,
     900,   902,   902,   902,   902,   902,   902,   902,   902,   902,
     902,   902,   903,   903,   905,   904,   906,   906,   907,   907,
     909,   908,   910,   910,   911,   911,   912,   912,   913,   913,
     914,   914,   915,   916,   916,   917,   917,   918,   917,   919,
     917,   920,   917,   917,   921,   917,   922,   917,   917,   923,
     917,   924,   917,   917,   925,   925,   925,   927,   926,   928,
     926,   926,   926,   930,   929,   932,   933,   931,   934,   935,
     936,   936,   937,   937,   937,   937,   939,   938,   940,   940,
     941,   941,   941,   942,   942,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   945,   945,   945,
     945,   946,   946,   946,   947,   947,   948,   948,   949,   950,
     949,   951,   952,   951,   953,   953,   954,   954,   955,   955,
     956,   956,   956,   957,   957,   959,   958,   960,   960,   961,
     961,   961,   962,   962,   963,   963,   964,   965,   965,   965,
     966,   966,   966,   966,   967,   967,   968,   968,   968,   968,
     968,   968,   969,   969,   969,   969,   969,   970,   971,   970,
     972,   972,   973,   973,   974,   976,   975,   977,   977,   978,
     978,   980,   979,   982,   981,   981,   981,   984,   983,   985,
     986,   985,   985,   985,   985,   985,   985,   985,   987,   987,
     988,   989,   989,   990,   990,   992,   993,   991,   995,   996,
     994,   997,   997,   997,   997,   998,   998,   999,   999,  1000,
    1001,  1001,  1001,  1002,  1001,  1003,  1003,  1004,  1004,  1005,
    1004,  1006,  1004,  1007,  1007,  1008,  1008,  1009,  1010,  1010,
    1011,  1011,  1013,  1012,  1014,  1014,  1015,  1015,  1016,  1016,
    1017,  1018,  1017,  1020,  1021,  1019,  1022,  1022,  1023,  1024,
    1024,  1025,  1026,  1026,  1028,  1027,  1030,  1029,  1031,  1029,
    1032,  1029,  1033,  1033,  1034,  1034,  1035,  1035,  1036,  1036,
    1037,  1037,  1037,  1038,  1039,  1039,  1041,  1040,  1042,  1042,
    1042,  1042,  1042,  1043,  1042,  1042,  1042,  1042,  1042,  1044,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,  1042,
    1042,  1042,  1045,  1045,  1046,  1046,  1047,  1047,  1048,  1048,
    1049,  1049,  1050,  1050,  1051,  1051,  1052,  1052,  1053,  1053,
    1053,  1055,  1054,  1056,  1054,  1057,  1057,  1058,  1058,  1059,
    1059,  1059,  1061,  1060,  1062,  1062,  1064,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1065,  1065,
    1067,  1066,  1068,  1068,  1069,  1069,  1069,  1071,  1070,  1072,
    1073,  1073,  1075,  1074,  1076,  1076,  1076,  1077,  1079,  1078,
    1078,  1081,  1082,  1083,  1080,  1080,  1084,  1084,  1085,  1085,
    1085,  1086,  1086,  1086,  1087,  1087,  1088,  1088,  1089,  1089,
    1089,  1089,  1090,  1090,  1091,  1091,  1092,  1092,  1093,  1093,
    1094,  1094,  1094,  1095,  1095,  1096,  1096,  1097,  1097,  1098,
    1098,  1098,  1098,  1099,  1099,  1099,  1100,  1101,  1101,  1101,
    1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,  1102,
    1102,  1102,  1103,  1103,  1103,  1103,  1103,  1104,  1104,  1105,
    1105,  1106,  1107,  1107,  1108,  1108,  1109,  1109,  1109,  1110,
    1110,  1110,  1110,  1111,  1111,  1111,  1112,  1113,  1113,  1114,
    1115,  1116,  1117,  1117,  1118,  1118,  1119,  1119,  1119,  1120,
    1120,  1120,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,
    1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1121,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1124,  1123,  1125,  1125,  1126,  1126,  1128,  1127,  1129,
    1129,  1129,  1129,  1130,  1130,  1131,  1131,  1131,  1131,  1132,
    1132,  1132,  1132,  1133,  1133,  1134,  1134,  1135,  1135,  1135,
    1135,  1135,  1135,  1135,  1136,  1136,  1136,  1137,  1137,  1137,
    1137,  1138,  1138,  1138,  1139,  1139,  1139,  1139,  1139,  1141,
    1140,  1142,  1142,  1143,  1143,  1144,  1145,  1145,  1145,  1145,
    1147,  1146,  1148,  1148,  1149,  1148,  1150,  1150,  1151,  1151,
    1152,  1152,  1152,  1152,  1153,  1152,  1154,  1154,  1154,  1154,
    1154,  1155,  1156,  1156,  1156,  1156,  1157,  1158,  1158,  1158,
    1159,  1159,  1160,  1160,  1161,  1161,  1162,  1162,  1164,  1163,
    1165,  1163,  1166,  1163,  1167,  1163,  1163,  1163,  1163,  1163,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1163,  1168,
    1168,  1169,  1169,  1170,  1170,  1170,  1171,  1171,  1171,  1171,
    1172,  1172,  1173,  1173,  1174,  1174,  1174,  1175,  1175,  1176,
    1176,  1177,  1178,  1178,  1178,  1178,  1178,  1179,  1179,  1180,
    1180,  1181,  1181,  1181,  1181,  1181,  1183,  1182,  1184,  1184,
    1185,  1185,  1185,  1186,  1186,  1186,  1187,  1187,  1188,  1189,
    1189,  1190,  1191,  1192,  1192,  1194,  1193,  1195,  1195,  1195,
    1197,  1196,  1198,  1198,  1199,  1199,  1199,  1200,  1201,  1200,
    1202,  1203,  1204,  1205,  1205,  1206,  1206,  1206,  1207,  1207,
    1208,  1208,  1208,  1209,  1210,  1210,  1210,  1211,  1211,  1212,
    1212,  1212,  1214,  1213,  1215,  1215,  1216,  1216,  1218,  1217,
    1219,  1219,  1220,  1220,  1220,  1220,  1222,  1221,  1224,  1223,
    1225,  1226,  1227,  1228,  1223,  1229,  1229,  1229,  1229,  1229,
    1229,  1230,  1230,  1230,  1231,  1231,  1232,  1232,  1232,  1233,
    1233,  1234,  1235,  1234,  1236,  1236
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     3,     0,     1,     1,     1,
       1,     2,     1,     1,     3,     0,     2,     0,     2,     0,
       3,     0,     5,     1,     1,     0,     2,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       4,     0,     0,     8,     0,     7,     1,     1,     1,     1,
       1,     2,     2,     2,     4,     4,     0,     4,     0,     0,
       5,     0,     7,     0,     0,     6,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     1,     1,     3,     4,     4,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     2,     2,
       6,     7,     8,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     4,     3,     3,     3,     1,     4,     1,     1,
       5,     2,     5,     2,     4,     1,     5,     5,     4,     3,
       1,     1,     2,     1,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     3,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     0,     3,     0,     1,     0,     1,     2,     1,     1,
       2,     2,     4,     1,     3,     2,     1,     2,     2,     2,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     0,
       2,     1,     2,     3,     2,     0,     1,     0,     1,     1,
       2,     0,     1,     0,     4,     1,     4,     3,     1,     0,
       1,     2,     1,     3,     3,     2,     2,     2,     1,     1,
       2,     2,     2,     1,     2,     2,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       2,     2,     1,     1,     1,     4,     2,     1,     4,     0,
       1,     0,     2,     1,     3,     0,     6,     0,     5,     0,
       5,     0,     5,     0,    11,     0,     1,     0,     2,     2,
       1,     3,     2,     3,     2,     4,     0,     6,     0,     0,
       8,     4,     4,     3,     3,     2,     2,     6,     5,     3,
       5,     1,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     1,     0,     1,     1,     1,     0,     5,
       3,     0,     5,     3,     3,     0,     3,     0,     2,     1,
       3,     0,     1,     1,     0,     2,     1,     3,     0,     6,
       0,     6,     0,     5,     0,     1,     1,     0,     6,     0,
       1,     1,     2,     1,     1,     1,     0,     6,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     6,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     5,     1,     3,     2,     1,     1,     0,
       6,     1,     3,     3,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     0,     3,     0,     0,     6,
       2,     1,     1,     2,     2,     8,     4,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     4,     3,     1,     1,     4,     0,     0,
       1,     1,     0,     2,     2,     1,     1,     0,     2,     0,
       3,     0,     3,     3,     0,     3,     0,     3,     2,     1,
       3,     4,     3,     4,     3,     4,     1,     3,     4,     3,
       3,     6,     1,     5,     6,     5,     7,     6,     8,     5,
       6,     4,     4,     5,     3,     4,     1,     3,     1,     3,
       1,     3,     3,     1,     3,     3,     4,     4,     1,     3,
       3,     3,     3,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     3,     1,     1,     1,     1,
       3,     2,     2,     2,     2,     3,     3,     5,     6,     4,
       4,     7,     4,     2,     6,     5,     6,     6,     4,     4,
       3,     4,     6,     8,     6,     8,     6,     4,     6,     4,
       6,     4,     4,     4,     4,     6,     8,     2,     2,     4,
       2,     7,     7,     3,     4,     4,     6,     6,     4,     6,
       6,     6,     4,     6,     4,     6,     8,    10,    12,     6,
       4,     6,     6,     1,     6,     4,     8,    10,     4,     1,
       3,     4,     6,     6,     8,     6,     6,     4,     6,     6,
       8,     4,     4,     6,     4,     2,     4,     4,     4,     6,
       4,     4,     3,     8,     6,     4,     6,     3,     6,     8,
       4,     8,     6,     8,     6,     8,     2,     4,     4,     4,
       6,     8,     8,     4,     7,     7,     7,     6,     6,     6,
       6,     6,     6,     0,     5,    10,     3,     4,     3,     2,
       2,     2,     4,     6,     4,     4,     6,     6,     6,     6,
       4,     6,     4,     6,     4,     4,     4,     4,     6,     4,
       6,     4,     6,     4,     4,     6,     4,     6,     4,     6,
       4,     4,     6,     4,     6,     0,     3,     3,     0,     1,
       0,     2,     1,     3,     4,     4,     5,     4,     4,     4,
       5,     4,     0,     0,     7,    10,     4,     5,     4,     5,
       4,     4,     4,     4,     4,     5,     0,     8,     0,     3,
       3,     1,     4,     0,     1,     0,     2,     0,     1,     0,
       3,     2,     3,     2,     1,     2,     1,     2,     1,     1,
       1,     2,     0,     1,     0,     2,     1,     3,     1,     3,
       0,     2,     1,     3,     0,     1,     0,     2,     4,     5,
       1,     1,     1,     1,     3,     3,     3,     0,     6,     0,
       6,     0,     8,     4,     0,     8,     0,    10,     6,     0,
       8,     0,    10,     6,     1,     2,     2,     0,     4,     0,
      11,     3,     6,     0,     3,     0,     0,     5,     0,     1,
       0,     1,     0,     2,     2,     2,     0,     5,     0,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     2,     2,     0,     1,     0,     4,     4,     2,     0,
       1,     1,     0,     1,     0,     1,     2,     1,     3,     3,
       1,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     0,     6,
       0,     1,     3,     1,     2,     0,     2,     3,     1,     2,
       1,     0,     3,     0,     5,     2,     1,     0,     3,     6,
       0,     6,     4,     4,     4,     4,     5,     4,     1,     3,
       1,     0,     2,     0,     1,     0,     0,     8,     0,     0,
       6,     0,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     3,     4,     0,     3,     3,     1,     2,     2,     0,
       3,     0,     5,     3,     1,     3,     1,     3,     1,     1,
       0,     1,     0,     4,     0,     1,     3,     1,     1,     1,
       0,     0,     6,     0,     0,    11,     3,     1,     3,     3,
       1,     3,     0,     1,     0,     4,     0,     6,     0,     5,
       0,     6,     1,     3,     3,     5,     0,     2,     0,     2,
       1,     1,     1,     3,     0,     1,     0,     3,     2,     4,
       4,     4,     4,     0,     4,     6,    16,     2,     2,     0,
       6,     5,     2,     2,     2,     1,     5,     5,     2,     2,
       3,     2,     2,     2,     3,     2,     2,     2,     1,     1,
       3,     4,     3,     3,     2,     2,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     0,     1,     0,     2,
       0,     1,     1,     1,     0,     2,     0,     2,     0,     2,
       2,     0,     4,     0,     4,     1,     1,     0,     1,     0,
       1,     1,     0,     4,     3,     1,     0,     3,     4,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     3,     3,     1,     1,     1,     2,     0,     3,     3,
       2,     2,     0,     4,     0,     1,     1,     2,     0,     4,
       5,     0,     0,     0,    16,     2,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     3,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     0,     1,     1,     3,     0,     2,     1,
       1,     1,     1,     0,     1,     0,     1,     1,     1,     0,
       2,     2,     2,     1,     2,     4,     5,     4,     6,     2,
       3,     3,     3,     5,     1,     3,     3,     2,     2,     2,
       1,     1,     4,     4,     1,     1,     1,     1,     1,     0,
       4,     1,     1,     1,     3,     3,     1,     1,     2,     2,
       0,     3,     4,     3,     0,     7,     1,     2,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     1,     1,     1,
       1,     3,     6,     6,     6,     7,     3,     8,     8,     8,
       0,     1,     1,     2,     0,     1,     1,     3,     0,     3,
       0,     3,     0,     3,     0,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       3,     2,     2,     2,     2,     2,     2,     2,     2,     0,
       1,     3,     1,     2,     2,     2,     1,     3,     3,     1,
       1,     3,     1,     3,     4,     5,     1,     0,     3,     3,
       1,     1,     0,     2,     2,     2,     2,     0,     2,     2,
       1,     2,     2,     2,     2,     2,     0,     3,     0,     1,
       0,     3,     2,     0,     1,     2,     0,     1,     4,     4,
       5,     2,     3,     0,     1,     0,     4,     0,     1,     1,
       0,     2,     2,     1,     0,     1,     1,     4,     0,     7,
       1,     0,     0,     2,     3,     1,     1,     1,     0,     3,
       1,     2,     1,     2,     3,     3,     3,     0,     1,     0,
       3,     3,     0,     8,     0,     3,     1,     3,     0,     2,
       3,     5,     0,     3,     4,     4,     0,    14,     0,     6,
       0,     0,     0,     0,    12,     4,     4,     3,     4,     3,
       2,     1,     3,     5,     1,     1,     0,     1,     1,     0,
       2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1967,   632,     0,  1916,     0,     0,     0,     0,
       0,  1918,    94,    54,  1264,  1355,  1356,  1187,  1203,     0,
     632,    97,     0,    66,  1205,  1392,     0,     0,   632,     0,
    1387,     0,     0,   632,  1208,  1380,     0,    97,  1918,     0,
     667,  1753,  1286,     0,     0,     0,  1284,  1810,  1253,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   660,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1357,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   535,     0,   567,
       0,     0,  1968,  1958,   634,   633,     0,  1802,  1801,   600,
    1918,     0,  1539,  1540,  1541,  1542,  1543,  1544,  1545,  1503,
    1546,  1547,  1548,  1504,  1505,  1549,  1550,  1551,  1553,  1552,
    1554,  1506,  1507,  1555,  1556,  1557,  1508,  1509,  1558,  1559,
    1510,  1560,  1561,  1562,  1511,  1563,  1512,  1564,  1565,  1566,
    1567,  1513,  1568,  1569,  1570,  1571,  1572,  1514,  1573,  1574,
    1575,  1576,  1591,  1577,  1515,  1578,  1579,  1580,  1592,  1516,
    1583,  1582,  1581,  1584,  1585,  1586,  1517,  1587,  1588,  1589,
    1594,  1595,  1596,  1518,  1590,  1597,  1593,  1736,  1599,  1598,
    1600,  1602,  1601,  1519,  1603,  1520,  1604,  1605,  1487,  1606,
    1488,  1608,  1609,  1612,  1613,  1607,  1610,  1611,  1521,  1615,
    1616,  1617,  1618,  1619,  1620,  1621,  1631,  1624,  1626,  1627,
    1629,  1625,  1630,  1634,  1633,  1635,  1636,  1637,  1632,  1623,
    1628,  1638,  1639,  1622,  1640,  1641,  1642,  1643,  1644,  1645,
    1646,  1647,  1649,  1648,  1650,  1651,  1652,  1653,  1654,  1656,
    1655,  1657,  1658,  1659,  1661,  1660,  1662,  1522,  1663,  1664,
    1665,  1666,  1667,  1523,  1668,  1669,  1670,  1671,  1672,  1673,
    1524,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1681,  1682,
    1683,  1684,  1685,  1686,  1687,  1688,  1689,  1614,  1690,  1525,
    1691,  1692,  1526,  1693,  1527,  1694,  1695,  1528,  1696,  1697,
    1698,  1699,  1700,  1701,  1529,  1702,  1530,  1704,  1703,  1705,
    1707,  1708,  1531,  1706,  1532,  1709,  1710,  1712,  1711,  1713,
    1714,  1533,  1715,  1534,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,  1726,  1729,  1730,  1731,  1732,  1727,
    1728,  1535,  1733,  1734,  1735,  1737,  1738,  1536,  1739,  1740,
    1538,  1741,  1742,  1745,  1743,  1744,  1746,  1747,  1748,  1749,
    1537,  1750,   123,  1492,    99,  1493,  1502,     0,   602,   618,
    1919,  1920,   269,   507,   508,   268,   506,    97,  1958,     0,
     265,   266,     0,  1278,  1014,  1201,  1201,     0,  1201,  1204,
    1201,    97,  1201,     0,    59,  1362,     0,     0,     0,     0,
    1486,     0,  1211,  1394,  1398,     0,     0,  1799,     0,     0,
       0,     0,    97,   635,     0,  1262,     0,   598,     0,  1920,
    1931,   661,   665,   677,  1754,  1751,  1340,   587,   587,   587,
     585,   587,  1285,     0,     0,  1262,  1397,  2004,     0,     0,
       0,  2000,     0,  2005,     0,   667,     0,     0,     1,     3,
       0,  1588,  1353,  1351,  1483,     0,   527,   536,   531,   529,
       0,     0,  1969,   616,     0,  1917,     0,   644,   654,   125,
       0,    68,     0,     0,     0,  1923,     0,     0,     0,     0,
      95,   318,  1958,  1960,  1962,   269,   267,     0,  1282,  1281,
    1280,     0,  1278,  1188,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1201,    61,     0,  1844,  1859,  1860,  1856,
    1861,  1862,  1866,     0,  1858,  1850,     0,  1865,  1854,  1863,
       0,  1848,     0,  1864,  1869,  1852,  1857,  1836,     0,  1842,
    1846,  1485,  1111,  1813,  1814,     0,  1498,  1489,  1497,  1496,
      67,  1213,  1214,  1212,   566,  1395,  1396,     0,  1408,     0,
       0,     0,   630,     0,  1335,  1334,     0,  1388,  1932,     0,
       0,   607,  1216,  1263,     0,  1215,  1385,     0,  1384,  1381,
    1383,     0,  1844,  1831,     0,  1926,  1923,  1933,   690,   683,
     682,   685,   686,   689,   687,   688,   684,   681,   698,   678,
     680,  1757,     0,     0,   443,     0,  1348,     0,     0,     0,
    1348,     0,  1142,  1341,     0,  1766,  1319,   504,   503,     0,
     502,  1767,  1318,  1334,     0,     0,     0,  1305,     0,  1768,
       0,  1337,     0,  1142,  1348,     0,  1287,     0,     0,     0,
       0,   581,   591,   583,   578,     0,   584,   580,  1283,  1200,
    1811,   566,  1445,  1444,  1490,  2001,  1443,  2009,  2011,  1997,
    1999,  2006,   663,     0,  1937,    53,     0,  1359,  1965,  1966,
    1964,   457,   107,   107,   525,     0,     0,     0,     0,     0,
    1198,     0,     0,   646,   656,   127,   124,    98,     0,   604,
     620,  1922,     0,     0,  1924,  1928,   772,   771,     0,    92,
     707,  1499,  1896,    96,  1892,  1963,   319,   698,   698,   698,
    1953,     0,  1955,  1956,  1957,  1969,  1961,     0,   509,     0,
    1265,  1268,  1272,  1276,  1279,  1540,  1503,     0,  1548,     0,
       0,  1456,     0,     0,     0,     0,  1508,     0,     0,  1561,
       0,     0,  1513,     0,     0,     0,   707,   707,   707,     0,
       0,     0,  1571,  1572,  1465,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1453,     0,  1466,     0,     0,
       0,     0,     0,     0,     0,  1599,     0,     0,  1600,     0,
       0,     0,  1455,  1605,     0,     0,     0,     0,     0,     0,
       0,  1618,     0,     0,  1463,     0,     0,  1020,     0,  1644,
    1646,     0,     0,     0,  1650,     0,     0,  1651,  1652,  1653,
    1440,   774,     0,   707,  1452,  1462,  1665,  1670,  1446,     0,
    1672,     0,  1673,     0,  1678,     0,     0,     0,     0,     0,
       0,  1700,  1702,     0,     0,  1718,     0,     0,     0,   707,
    1729,  1730,  1731,  1732,     0,  1454,  1535,  1464,     0,     0,
       0,  1741,   707,   707,   707,     0,     0,     0,  1747,     0,
    1750,  1024,     0,     0,     0,     0,   773,     0,   988,     0,
    1016,   709,   714,   719,   726,   732,   746,   748,   750,   753,
     758,   764,     0,   859,   766,   853,   789,   788,  1015,  1450,
     787,   786,  1451,   784,  1473,  1492,  1439,  1472,  1202,  1192,
    1193,     0,  1194,  1197,  1890,  1195,   568,     0,     0,    60,
    1376,  1370,  1372,  1375,  1371,     0,  1377,  1374,  1373,  1802,
    1363,  1365,  1366,  1845,  1843,  1877,  1876,     0,  1878,  1874,
    1867,  1897,  1871,  1897,  1873,  1872,  1897,  1868,  1875,  1897,
    1840,     0,  1112,  1113,     0,  1812,     0,  1484,     0,  1393,
    1409,     0,  1410,  1399,  1406,   649,     0,  1111,  1800,  1803,
       0,     0,    56,    57,     0,   637,     0,   636,   640,     0,
       0,     0,  1219,  1209,  1218,  1386,     0,     0,  1843,  1840,
    1927,     0,  1929,  1944,   666,  1934,   696,   668,   695,     0,
     679,  1752,  1755,  1763,  1317,  1344,   442,     0,     0,  1316,
    1302,     0,   269,     0,     0,     0,     0,  1288,  1293,   303,
       0,  1309,  1143,     0,  1348,     0,  1311,  1324,  1312,     0,
    1338,     0,  1348,  1298,  1325,  1338,  1303,  1308,  1315,  1342,
    1343,     0,  1297,  1304,     0,  1313,  1338,  1338,  1348,  1348,
     594,   593,   592,   588,   589,   594,     0,  1057,     0,     0,
    1998,  2012,  1996,  2007,  2008,  1995,   664,  1938,   662,  1939,
       0,  1354,  1352,  1360,  1361,   458,   528,   457,   260,   263,
     262,     0,   532,   530,   457,  1959,     0,     0,   620,     0,
       0,   648,   643,   647,   645,   499,   498,   501,     0,   655,
       0,   128,   130,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    69,    70,
      83,   606,   605,   603,   628,   627,   625,     0,   626,   624,
     619,   621,   622,  1921,  1925,   270,   457,     0,  1501,     0,
       0,     0,     0,     0,     0,     0,  1954,    88,     0,     0,
       0,  1270,  1266,  1276,     0,     0,     0,  1111,     0,     0,
       0,  1116,     0,   803,  1116,  1116,  1116,     0,     0,  1014,
    1014,     0,  1014,     0,     0,     0,     0,  1116,   827,   830,
       0,   828,     0,     0,     0,     0,     0,  1459,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1014,     0,     0,
       0,     0,   993,     0,     0,     0,     0,   783,     0,     0,
       0,     0,  1014,     0,     0,     0,     0,  1020,     0,  1018,
       0,  1116,     0,     0,  1116,     0,     0,     0,     0,     0,
    1014,  1014,  1014,   718,     0,   875,     0,     0,     0,     0,
       0,  1014,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1116,  1116,     0,     0,     0,  1116,     0,   896,
       0,  1461,     0,     0,     0,  1460,     0,     0,  1458,  1457,
    1441,     0,     0,     0,   919,   921,   920,  1116,     0,  1116,
       0,     0,     0,  1025,     0,   792,   791,   793,  1951,     0,
       0,     0,     0,     0,     0,     0,   711,   716,   775,     0,
     776,   777,     0,   778,   779,   780,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   794,  1086,  1087,  1088,  1089,
    1098,  1101,  1090,  1091,  1092,  1100,  1093,  1094,  1095,  1102,
    1103,  1104,  1096,  1105,  1099,  1097,  1106,     0,  1085,     0,
       0,     0,  1442,   913,     0,  1190,     0,   570,   569,  1196,
     568,     0,    62,    64,  1369,     0,     0,  1378,  1870,     0,
    1851,  1855,  1849,  1853,     0,     0,  1841,     0,  1847,  1115,
    1595,  1660,     0,  1118,  1816,  1206,  1405,  1407,     0,     0,
    1400,     0,     0,   620,    58,     0,     0,  1389,     0,     0,
       0,     0,   609,  1217,     0,  1382,     0,     0,     0,     0,
       0,  1930,  1946,  1945,  1935,   698,  1133,   699,   701,   700,
    1472,  1757,  1760,  1761,  1764,  1762,     0,  1759,  1758,  1773,
       0,  1346,  1349,  1350,     0,     0,  1327,  1326,  1322,  1323,
       0,  1152,  1153,  1151,  1146,  1147,  1150,  1331,  1329,  1320,
       0,  1348,     0,  1330,  1328,  1348,  1338,     0,  1348,  1348,
    1310,  1314,     0,   582,   591,   579,   586,  1069,  1068,     0,
    1033,     0,  1032,  1031,  1030,     0,  1068,  2002,  2010,  2014,
       0,  1142,  1943,  1941,   261,  1240,  1240,     0,     0,     0,
       0,     0,     0,     0,   108,   117,   564,   564,  1240,  1240,
     564,  1240,  1240,  1240,     0,     0,  1240,     0,     0,   564,
       0,  1240,   562,     0,     0,  1240,  1240,  1240,   564,  1240,
    1240,  1240,  1240,  1240,   574,  1240,  1240,  1240,   561,   273,
     295,   296,   526,     0,   540,   563,  1970,  1971,   533,   617,
     601,  1199,     0,   126,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   629,   623,    93,   708,  1500,     0,  1893,  1990,     0,
       0,  1972,   271,   512,   514,   513,   511,   510,     0,     0,
    1118,     0,  1273,  1057,  1277,  1276,  1274,     0,     0,     0,
    1117,  1116,     0,   999,  1160,  1161,  1157,  1158,  1156,  1159,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   972,     0,   999,     0,   833,     0,
       0,     0,     0,     0,     0,  1472,     0,     0,     0,     0,
       0,  1951,     0,     0,     0,     0,     0,     0,   810,     0,
       0,     0,     0,     0,     0,     0,  1109,  1107,  1110,  1108,
       0,     0,   994,   986,     0,     0,     0,     0,   860,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1021,  1022,  1116,     0,     0,     0,  1116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   882,     0,     0,     0,     0,
       0,   887,     0,     0,     0,     0,     0,     0,     0,  1116,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   916,     0,   918,     0,     0,  1475,  1474,     0,
       0,     0,     0,     0,  1026,   667,     0,   796,  1014,   795,
       0,  1769,   989,   991,     0,   713,   710,   715,   729,   722,
     727,   720,   724,     0,   781,  1545,   730,     0,     0,  1125,
     744,     0,     0,   747,     0,     0,     0,     0,   749,   751,
     752,   755,   859,   754,   859,   762,   763,   759,   760,   761,
     765,     0,   785,   790,  1017,   960,  1476,  1191,  1891,  1189,
      65,     0,     0,  1364,  1379,  1367,  1901,     0,  1900,  1886,
    1889,  1483,     0,     0,     0,  1826,  1820,  1827,  1829,  1823,
    1828,  1830,  1821,  1822,  1817,  1824,  1119,  1144,     0,     0,
     650,   651,   654,     0,  1806,  1807,  1805,  1804,   631,  1391,
    1390,     0,   638,   641,   642,   614,   613,   615,   608,   610,
     611,   253,  1223,     0,     0,     0,  1229,  1210,  1220,   599,
       0,     0,     0,     0,     0,   694,  1057,  1181,   691,   672,
    1144,  1134,   671,   702,     0,  1756,     0,  1727,  1784,     0,
       0,     0,     0,     0,  1774,  1345,     0,  1299,     0,  1321,
    1333,  1332,  1294,     0,     0,     0,  1292,  1339,  1291,  1118,
    1338,  1289,  1290,   596,   595,   590,  1068,  1057,     0,     0,
    1054,  1070,     0,  1070,  1057,  1057,     0,  1057,  1111,  1065,
       0,     0,  2013,  1135,  1942,  1238,  1239,  1241,     0,     0,
     111,   114,   112,     0,   113,     0,     0,   565,   519,   500,
     500,   544,     0,   335,   519,   493,   542,     0,     0,     0,
       0,     0,     0,     0,     0,  1240,     0,   555,   538,     0,
       0,     0,     0,   556,     0,   539,  1240,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   577,   576,   575,     0,
       0,     0,     0,   274,   457,   338,     0,   571,   335,   341,
    1479,  1974,  1082,     0,  1081,   129,    76,    72,    84,  1165,
    1166,  1164,  1162,  1163,    85,    74,    75,    79,    78,    80,
      81,    82,    77,    73,    86,    87,    71,     0,  1894,     0,
     237,   236,     0,  1988,  1974,     0,   338,    89,  1411,   272,
     275,    90,  1057,  1133,  1276,  1118,     0,  1111,     0,   802,
     817,     0,     0,   965,     0,     0,   967,   968,   969,     0,
     821,     0,   819,   822,   823,   824,  1014,     0,     0,     0,
       0,  1014,   971,     0,   829,     0,     0,   834,   835,     0,
     808,     0,   842,     0,   844,     0,  1014,     0,   838,     0,
     799,     0,     0,  1014,     0,   850,     0,   811,     0,     0,
     951,     0,   934,   930,     0,   932,     0,     0,  1014,  1014,
       0,   855,     0,     0,   861,  1014,     0,   953,     0,   935,
       0,   867,     0,  1014,     0,  1019,     0,     0,     0,   978,
     871,   872,     0,   976,   937,     0,     0,   874,   939,     0,
     941,     0,   936,   943,   944,   876,   878,   877,   946,     0,
       0,   948,     0,   950,     0,   880,   881,     0,     0,     0,
     885,     0,  1014,   890,   980,   982,     0,     0,     0,     0,
       0,   984,   897,   899,     0,     0,     0,   898,     0,     0,
       0,     0,     0,     0,     0,   903,     0,     0,   917,   983,
     809,   981,   922,     0,   925,     0,   924,     0,     0,     0,
       0,  1950,  1952,     0,     0,   800,     0,     0,     0,     0,
       0,  1477,   768,   767,     0,   770,   769,     0,   723,   728,
     721,   725,     0,     0,     0,     0,   742,   741,     0,     0,
    1125,   745,     0,   757,   756,   858,     0,   959,   698,  1014,
       0,    63,  1368,  1898,     0,     0,     0,     0,     0,     0,
       0,     0,  1815,  1145,  1250,  1491,  1401,     0,   658,  1808,
    1809,     0,   612,   677,     0,  1242,  1227,  1234,  1228,     0,
       0,     0,  1226,  1468,  1467,  1474,  1933,     0,     0,     0,
       0,  1936,  1118,  1118,  1175,     0,     0,   669,   674,   670,
     673,     0,   697,   706,   705,  1469,  1476,     0,     0,     0,
       0,   445,   447,   446,   453,     0,   444,     0,     0,  1769,
       0,   449,   451,   450,  1779,   448,  1347,  1142,  1307,  1306,
    1149,  1148,     0,  1301,  1348,     0,  1940,  1063,     0,  1056,
    1055,  1071,     0,  1057,  1070,  1070,     0,  1036,  1035,  1254,
    1257,     0,  1034,  1072,  1061,   677,  2003,  2015,     0,   456,
     455,   302,   452,   301,   116,   115,   121,   122,   340,   520,
     494,   495,     0,     0,     0,   500,   334,   519,   333,   336,
     509,     0,   285,   282,   546,   288,   284,   300,     0,     0,
     289,   519,   553,   554,   568,   278,     0,   314,   315,   313,
     297,   280,   281,   548,   287,   286,   283,   292,   293,   311,
     310,   291,   312,   559,   309,   307,   304,   306,   305,   308,
     290,   279,     0,   541,     0,   324,   326,   327,  1482,     0,
     573,   543,     0,   328,   329,     0,     0,     0,     0,   657,
       0,  1895,  1991,   240,   238,   239,     0,     0,     0,   243,
       0,   241,     0,     0,  1413,  1412,   242,   256,   457,   276,
       0,  1118,  1154,  1269,  1275,     0,     0,     0,   966,  1000,
       0,   421,   421,  1010,  1008,   410,   421,  1004,  1009,  1006,
       0,     0,     0,     0,     0,     0,     0,   973,   970,     0,
       0,     0,  1476,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     997,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   955,  1023,   979,   977,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   985,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1027,   805,  1947,  1948,   797,  1770,  1771,  1772,   521,   990,
     712,   717,     0,   735,  1014,   733,  1124,   739,     0,     0,
     743,     0,   914,     0,   961,   962,     0,  1013,  1478,  1899,
    1888,  1887,  1902,  1902,  1902,     0,  1120,     0,  1207,  1411,
     652,     0,   653,   639,   698,  1224,  1236,     0,  1244,     0,
       0,  1221,  1231,     0,     0,     0,  1230,     0,  1833,  1834,
    1832,  1144,  1126,     0,     0,  1186,     0,  1182,   692,     0,
     704,   703,     0,  1786,     0,  1785,  1797,  1798,  1795,  1796,
    1794,  1775,     0,  1781,  1780,     0,     0,     0,  1791,  1782,
       0,     0,  1300,     0,  1295,   597,     0,  1057,  1070,  1057,
    1043,     0,     0,  1057,  1039,  1037,  1041,     0,  1118,     0,
       0,     0,     0,  1058,   698,  1471,  1136,  1139,   337,   519,
     496,   497,   509,     0,     0,     0,     0,   453,   298,   552,
     551,   299,     0,     0,   545,   338,   572,   473,   406,   355,
     346,   421,   349,   348,   392,   363,   360,   410,   408,   378,
     410,   410,   385,   384,   402,   388,   368,   459,   459,   367,
     405,   459,   389,   387,   391,     0,   393,   410,   398,   386,
     390,   407,   383,   380,   404,   421,   421,   361,   364,   403,
     459,     0,   396,   421,   425,   366,   459,   465,     0,     0,
     421,   423,  1481,  1976,     0,  1978,  1080,   142,   698,     0,
     101,  1989,  1978,     0,   246,   271,   257,     0,   277,     0,
    1271,     0,  1267,   783,   814,   818,   927,     0,  1001,   459,
       0,  1011,   412,  1003,  1005,  1007,   804,   820,   825,   929,
     807,   806,     0,     0,     0,     0,   840,   843,   845,   836,
     841,   839,     0,   928,   852,   849,   851,   812,     0,   952,
     931,   933,   854,   865,   995,   998,     0,     0,     0,   866,
     862,   954,   863,     0,   868,   837,   869,     0,     0,     0,
       0,   938,   873,   940,   942,   947,   945,   949,   879,   816,
       0,   884,   886,   798,   783,   888,     0,   894,   892,     0,
       0,   900,     0,     0,   909,     0,   907,     0,   908,     0,
     910,   911,     0,   923,   926,  1028,     0,  1933,     0,   992,
     731,     0,   737,  1014,   734,   740,   699,   698,   912,     0,
    1907,  1907,  1907,  1249,  1248,     0,  1247,  1251,     0,   659,
     254,     0,     0,     0,  1245,  1233,  1937,  1222,  1225,  1476,
    1835,   676,     0,  1121,  1185,  1183,     0,  1176,  1178,  1180,
       0,  1470,     0,     0,  1790,  1776,   454,     0,     0,     0,
       0,  1777,     0,  1111,  1064,     0,     0,  1030,  1057,  1057,
       0,  1030,     0,     0,     0,  1256,  1133,  1258,  1076,  1074,
    1075,  1073,  1066,     0,  1140,  1141,  1138,     0,     0,     0,
     558,     0,   571,   560,   425,   294,   325,   479,     0,     0,
     365,   414,   409,     0,   414,   414,   465,   467,   461,   465,
       0,   374,   392,   369,     0,   459,   382,   373,   394,   397,
     399,   401,   414,     0,   459,   362,   371,     0,   414,   433,
       0,     0,     0,   429,     0,   472,     0,   436,   342,   426,
     428,     0,     0,   395,     0,   351,   466,     0,   353,     0,
       0,   414,     0,   424,   414,     0,  1975,     0,  1982,     0,
     145,   143,   144,     0,   138,   140,   135,     0,   322,   323,
     321,   320,     0,   131,  1982,   244,  1937,  1411,     0,   249,
       0,  1139,   517,  1155,     0,     0,  1002,     0,     0,   974,
     831,   832,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   801,     0,     0,     0,     0,     0,     0,
       0,   906,   904,   905,     0,  1029,  1952,   522,   736,     0,
     702,   963,     0,     0,  1906,  1904,     0,  1905,  1903,  1879,
       0,  1838,  1839,  1837,  1825,     0,     0,  1402,  1144,  1235,
    1237,  1243,  1232,     0,  1122,  1133,  1414,  1179,     0,   693,
    1788,  1787,  1789,  1783,     0,     0,     0,     0,  1062,  1057,
    1044,     0,  1048,  1053,  1049,     0,  1040,  1038,     0,  1154,
       0,  1144,  1139,     0,     0,     0,     0,     0,     0,     0,
       0,   557,  1447,   547,   549,     0,     0,     0,   474,   475,
     480,   482,     0,     0,   418,   419,   420,   375,   415,   417,
       0,   377,   345,   460,   468,   469,     0,   464,   462,   465,
     370,   400,   376,     0,   372,     0,   359,   439,   438,   707,
     431,   441,     0,     0,   437,   427,   435,   430,     0,     0,
       0,     0,   343,     0,   344,  1480,  1977,     0,   534,   698,
     698,  1979,  1992,   142,     0,     0,     0,     0,   132,   134,
     135,  1973,   247,   245,     0,  1933,    91,     0,   516,     0,
     815,   422,   411,     0,   826,   846,     0,   813,   996,   987,
    1116,   856,     0,   864,   870,   957,   956,   883,   889,   893,
     891,   895,   901,   902,  1014,  1949,   738,   964,  1885,  1884,
    1883,  1880,     0,     0,     0,     0,     0,     0,  1908,  1910,
    1246,     0,     0,   255,   691,   316,  1130,  1139,     0,  1144,
       0,  1422,  1177,  1793,  1792,  1778,     0,     0,     0,     0,
       0,     0,     0,  1083,  1255,  1078,  1067,  1137,     0,     0,
     330,  1449,  1448,   571,   485,   486,   487,     0,     0,     0,
     478,   481,   354,   347,   416,     0,   523,   470,   463,     0,
     358,   440,   707,   434,   459,   465,   459,   465,     0,     0,
       0,   667,     0,   109,   139,     0,   698,   100,   102,     0,
       0,   251,   250,  1139,     0,     0,     0,     0,     0,     0,
    1881,  1911,  1914,  1912,  1913,  1915,  1909,     0,     0,   317,
       0,     0,  1127,  1129,  1123,  1167,     0,     0,     0,     0,
    1415,  1417,     0,  1184,     0,  1059,  1045,     0,  1050,     0,
    1042,     0,     0,  1079,     0,   331,   550,   489,     0,   488,
       0,   483,   484,   479,     0,   459,     0,   459,   432,   350,
     352,   356,   357,     0,  1983,     0,  1980,     0,  1993,   141,
       0,     0,   133,   136,  1937,   515,   518,   413,   847,     0,
     975,   857,   915,  1252,  1260,     0,  1403,  1131,  1132,  1139,
       0,   675,     0,     0,     0,     0,  1416,     0,     0,  1423,
    1425,     0,     0,     0,     0,  1084,  1077,   332,   491,   492,
     490,   476,   477,   379,   524,   381,  1984,  1985,  1937,   119,
     118,   110,     0,   177,     0,   103,   252,     0,     0,     0,
    1414,  1128,  1168,  1420,  1421,     0,  1418,     0,     0,  1424,
       0,     0,  1047,  1052,  1981,   120,     0,   193,   181,     0,
       0,     0,   179,   207,  1994,     0,     0,   183,   205,   206,
     184,  1494,     0,  1495,  1986,     0,   848,  1259,  1261,  1422,
       0,  1419,  1427,  1426,     0,  1060,   192,   195,     0,     0,
     198,   188,   187,   189,     0,     0,     0,   178,   228,   177,
     177,   231,   186,   224,   177,   104,  1428,   698,     0,   194,
       0,     0,     0,   180,   208,   219,   222,   214,   150,   177,
       0,   177,     0,     0,  1987,   109,     0,  1430,     0,     0,
    1171,  1173,     0,   190,     0,     0,     0,     0,   177,   215,
       0,   146,     0,     0,   148,   234,     0,   226,   105,     0,
       0,  1437,  1174,  1169,   698,  1296,     0,   182,   199,   216,
     222,   212,   220,   177,     0,     0,   177,     0,   230,   149,
       0,   232,   225,   227,   177,  1429,  1432,     0,     0,  1434,
    1435,     0,  1404,  1172,   191,   196,   177,     0,   213,     0,
       0,   211,   161,   160,     0,   152,   173,   229,     0,   151,
       0,   177,   106,  1436,  1431,     0,  1438,     0,   177,   217,
       0,   177,     0,     0,     0,     0,     0,   147,     0,   177,
    1433,   197,   202,     0,   209,   177,   155,   174,   175,     0,
     158,   235,     0,   198,   177,   201,   177,     0,     0,   153,
     166,   154,   164,   157,     0,   233,   203,   177,   177,   172,
     170,   177,   168,   162,     0,   169,   176,   167,     0,   159,
       0,   156,   171,   165,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   962,    58,   514,
     909,  1362,  1363,    59,   411,    60,   688,  1108,  1109,  1110,
      61,  1572,  2430,  1126,   388,   406,   372,  2731,  3003,  3371,
    3465,  3515,  3564,  1072,  3368,  1494,  3421,  1495,    62,   479,
     686,  1090,  1091,  3177,  3178,  3174,  3179,  2993,  2994,  2995,
    2996,  3556,  3509,  3531,  3557,  3604,  3627,  3633,  3634,  3584,
    3641,  3642,  3648,  3643,  3585,  3629,  3510,  3455,  3484,  3480,
    3456,  3546,  3479,  3574,  3501,  3502,  3576,  3612,  3625,  3457,
    3458,  3485,  3526,  3459,  3486,  3550,  3506,  3551,  3577,  3613,
    3507,  3527,  3580,  3530,  3460,  3513,  3562,  3492,  3508,  3512,
    3591,  3560,  2012,  2416,  2017,  2421,  3006,  2426,  3185,  3374,
    1846,  2243,  3068,  2737,  1066,  1067,  1068,   389,   390,   391,
     487,  2018,  1528,  2019,  2020,  1530,  1531,  1008,  2390,  2381,
    2370,  3233,   709,  3002,  2394,  2395,  2396,  2397,  2348,  2349,
    1932,  1933,  1978,  2405,  2714,  2933,  2953,  2715,  2716,  2717,
    2718,  2719,  2720,  2721,  2751,  2752,  3127,  3128,  3129,  2748,
    2984,  2968,  2969,  2970,  3150,  2940,  2283,  2284,  2293,  2294,
    2330,  2613,  2331,  1071,  2941,  2978,  3137,  2971,  2404,  2927,
    3118,  3269,  3119,  3120,  3121,  3351,  1934,  2347,  1087,  1088,
     635,   392,  1140,  1576,  3010,  3011,  2338,  2839,  3275,    63,
    1074,   671,   673,   672,  1981,   466,  1532,  1533,  1534,  2656,
    2662,  3263,  1936,   111,  1359,  2401,  1969,    64,  1045,  1040,
      65,   646,   641,   642,  1043,  1044,  1463,  1894,    66,   581,
      67,   474,    68,   482,  1113,    69,   970,  1838,  1839,  1840,
      70,   678,    71,   483,  1120,  1121,  1122,    72,   960,   116,
      73,   570,   965,   967,   968,    74,   476,   477,  1082,    75,
    1389,  1820,  1821,   683,   684,  1089,  2572,    76,    77,   457,
     431,   587,   432,   433,  1416,  1858,  3234,   598,   599,   600,
    2267,   987,   988,   989,  1863,  1417,  2272,  1128,  2854,  1296,
    1746,   871,  1297,  1747,   872,   873,   874,   875,   876,   877,
     878,   879,   880,   881,  2194,  2197,  2972,   882,  1306,  1757,
     883,   884,  1785,   885,  2800,  2216,  2217,  2218,  2554,  2555,
     886,  2051,  2763,  2089,   887,  1293,  1742,  1653,  3025,  2784,
    1592,  2034,  2450,  2556,   503,   504,   888,  1218,  1219,  1220,
    1670,  1284,  2180,  1734,  1470,  1471,  1472,  1473,  2903,  2902,
    2904,  3248,  3091,  3250,  3095,  1905,  1474,  1475,  3402,  2306,
    2627,  2324,  2325,  3101,  1896,  1476,  2312,  2643,  2909,  3100,
    3342,  1983,  3252,  1347,  1348,  1650,   944,   945,  1593,  1817,
    2231,  3075,  3238,  2206,  2873,  3236,  3322,  1860,  1861,  2328,
    2646,  2916,  1011,  3235,  2233,  1444,  1445,  2742,  3632,  1994,
    3391,  3470,  3519,  3520,  3521,  2595,  2596,  2877,  2878,  1862,
    2264,  2597,  3076,    78,   394,    79,  1787,   679,   680,   506,
     403,    80,   412,  1818,    81,   425,  1404,   554,   574,   973,
     974,  1847,  2244,  2251,  1848,  2256,  2866,  2246,  2575,  2576,
    1917,  1918,  2247,  2578,  2863,  2855,  2856,  2568,  3066,    82,
     445,  2638,  2319,  2320,  3383,  3384,   575,    83,   393,   720,
    1580,  1145,  1579,   721,   722,  1147,   501,   502,    84,   443,
      85,   436,   636,  1440,  2297,  1882,   566,   638,  1451,   639,
    1452,  1431,  1877,   999,    86,   667,   666,    87,   462,  1062,
      88,   515,   920,   921,  1367,  1795,    89,   426,   579,   580,
      90,   420,   567,  1397,    91,   413,   557,    92,    93,   558,
     953,  2569,  3232,  3430,  1388,   954,  2427,  3241,  3330,  3331,
    3333,  3399,  3400,  3517,  3541,  3568,  3569,  3572,   889,   655,
     890,  3111,   891,   892,  2252,  2253,  2647,   893,  3385,   894,
    1979,   649,   409,   895,   548,   896,  2236,   897,  3462,   701,
     702,   375,   376,    94,   601,   435,   991,   992,   993,  1426,
    1427,   640,  2189,  1428,  1429,  1874,  1869,  2885,  2619,  2611,
      95,   561,   922,   958,   959,  1826,    96,   444,    97,   946,
    1383,  1384,  1814,  2230,  1815,    98,   583,    99,   537,  1377,
     538,   924,   539,   540,   936,   931,   939,   933,  3222,  3058,
    3059,  1802,   905,   703,   704,  1370,  1797,  1798,  2850,  3061,
    3228,  3229,   100,   120,   381,   485,   695,   981,   101,   102,
     103,   104,   984,  1057,  1854,  1058,  1059,  1060,  1483,  1414,
    1291,  2837,  2182,  1736,  2532,   490,   710,   472,   492,   493,
     112,   113,   711,   712,  2014,  2408,  2724,  2988,  2989,  3171,
    3168,   713,  3494,   714,  2417,  2009,  2727,  3293,  3423,   105,
     657,   454,  1055,  1050,  1052,  1479,  1912
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3185
static const int yypact[] =
{
    2746, -3185,   159,   819,   775, -3185,   134, 41228,    81,   775,
     775,  -158,   628, -3185, -3185, -3185, -3185, -3185,   657, 41228,
     819, -3185, 20208, -3185, -3185, -3185,   107,   775,   819, 41228,
   -3185,   -21,  -120,   819, -3185, -3185,   775, -3185,  -158, 41228,
   -3185,   323, -3185,   812,   -90,   -23,   264, -3185, -3185, 41228,
     304,   365,   833,   864, -3185, -3185,   565, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, 20748, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185,   791, 41228, 41228, -3185,
   41228,   470, -3185,   873, -3185, -3185,   775, -3185, -3185, -3185,
    -158, 20208, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185,   502, -3185, -3185,   544, -3185, -3185,
   -3185,  1058,   901, -3185, -3185, -3185, -3185, -3185,   370,   666,
   -3185,   647,   969,    63, -3185,   978,   978, 41228,   978, -3185,
     978, -3185,   978,   775, -3185, -3185,  1229, 41228,   829,   180,
     444, 36395,   207,   364, -3185,  1043, 20208, -3185,   775,  1033,
     236, 41228, -3185, -3185,   775,   190,    49, -3185,  2424,   116,
   -3185, -3185, -3185,   316, -3185, -3185,  3724, -3185, -3185, -3185,
     680, -3185, -3185, 20208,   775,  1015, -3185, -3185,   140,   140,
     140, -3185,   140, -3185,   140, -3185,   365,   720, -3185, -3185,
   41228,   418, -3185, -3185,   727,   533, -3185, -3185, -3185, -3185,
   20208,  1172,   868, -3185, 20208, -3185,   -17, -3185, -3185,   778,
   41228, -3185, 20208, 20208,   200,   769,   902, 41228, 34247,   935,
   -3185,   121,   873,  1339, -3185,   901, -3185, 41228, -3185, -3185,
   -3185, 38006,    63, -3185, 12495,  1209, 41228, 41228,  1035, 41228,
   41228, 34247, 20208,   978,   852,  1016,  1025,   970,   648, -3185,
   -3185, -3185, -3185,  1074, -3185, -3185,   927, -3185, -3185, -3185,
     259, -3185,    86, -3185, -3185, -3185, -3185, -3185,  1081,   865,
   -3185, -3185,    91, -3185, -3185, 41228, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185,  1222, -3185, -3185, 12495,   201,  1403,
    1285, 20208, -3185,  -155, -3185, -3185,  1201, -3185, -3185, 34247,
   20208, -3185, -3185, -3185, 18038, -3185, -3185,  1414, -3185,   905,
   -3185, 20208,  1025, -3185,  1140,  1071,   769,   992, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,   965,   316,
   -3185, -3185,  1241,  1376, -3185,  1126,    20,  1034,   980,   154,
      20, 36395,  1309, -3185,   143, -3185,  1392, -3185, -3185,  1110,
   -3185, -3185, -3185,  1112,  1131,  1311,  1128, -3185,   169, -3185,
      52, -3185,  -117,  1309,    20,   672, -3185,  1345,  1465,   225,
    -118, -3185,   -48, -3185, -3185,  1531, -3185, -3185, -3185, -3185,
   -3185,  1222, -3185, -3185, -3185,  1049, -3185,  1279,  1152, -3185,
   -3185,    66, -3185,  1067,    29, -3185,   435, 34784, -3185, -3185,
   -3185,   113, -3185, -3185, -3185, 34247,  1214,  1109, 20208,  -161,
   -3185, 38543, 20208, -3185,   148, 12495, -3185, -3185,  2039,    34,
     126, -3185,  1589,  1254, -3185, -3185, -3185, -3185,  1496, -3185,
    1099,  1104,  1458,  1105, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185,  1147, -3185, -3185, -3185,   868, -3185, 20208,   646, 20208,
   -3185,  1127, -3185,  1138, -3185,  1150,  1153,  1163,  1165,  1166,
   15310, -3185,  1167,  1168,  1169,  1170,  1171,  1175,  1176,  1179,
    1183,  1185,  1186,  1188,  1189,  1193,  1099,  1099,  1194,  1195,
    1197,  1198,   674,  1203, -3185,  1205,  1207,  1208,  1210,  1211,
    1219,  1221,  1225,  1226,  1230, -3185,  1232, -3185,  1233,  1234,
    1236,  1237,  1238,  1239,  1240,  1242,  1243,  1244,  1245,  1248,
    1249,  1250, -3185,  1251,  1252,  1253, 12495,  1255,  1256,  1257,
    1258,  1259,  1260,  1261, -3185,  1263,  1264,  1265,  1266,  1267,
    1268,  1269,  1272,  1273,  1274,  1276,  1277,  1280,  1281,  1282,
   -3185, -3185, 12495,  1283, -3185, -3185,  1284,  1289, -3185,  1290,
    1291,  1293,  1295,  1298,  1299,  1300,  1302,  1304,  1307,  1310,
    1312,  1313,  1314,  1317,  1319,  1320,  1321,  1322,  1323,  1324,
     723,  1325,  1326,   725,  1327, -3185,  1328, -3185,   157,  1329,
    1330,  1331,  1099,  1099,  1099,  1333,  1335,  1336,  1337,  1338,
    1340, 12495, 15310, 15310, 15310,  7991, -3185, 41228, -3185, 41228,
   -3185,  1192, -3185, -3185,  1526, -3185,   966,  1218,   429,   640,
     191,  1204, 15310,  1235,   403, -3185, -3185, -3185,  1212,  1306,
   -3185, -3185, -3185, -3185, -3185,  1341, -3185,  1228, -3185, -3185,
   -3185, 20208, -3185, -3185, -3185,  1342,   125, 20208,  1303, -3185,
   -3185, -3185, -3185, -3185, -3185,  1799, -3185, -3185, -3185,  1367,
    1343, -3185, -3185, -3185, -3185, -3185, -3185,  1401, -3185, -3185,
   -3185,  1346, -3185,  1346, -3185, -3185,  1346, -3185, -3185,  1346,
      62,  3094, -3185, -3185, 41228, -3185, 41765, -3185, 18038, -3185,
   -3185,  1622, -3185, -3185,  1655, -3185,  1627,   115,  1351, -3185,
   20208, 36395, -3185, -3185,    83,  1353,  1431,  1355, -3185,  1433,
   20208, 20208, -3185, -3185, -3185, -3185,    49,    38,  1358,   515,
   -3185, 41228, -3185,   867, -3185, -3185, -3185,  1360, -3185, 12495,
   -3185,  1361, -3185,   596, -3185,  1699, -3185,  1449, 12495, -3185,
   -3185,  1374,   901, 41228, 41228, 20208, 20208, -3185, -3185, -3185,
     562, -3185, -3185, 41228,    20, 34247, -3185, -3185, -3185,  1763,
     672, 41228,    20, -3185, -3185,   672, -3185, -3185, -3185, -3185,
   -3185, 20208, -3185, -3185,   672, -3185,   672,   672,    20,    20,
    1422, -3185, -3185,  1373, -3185,  1422,  1499,   415,   140,  1583,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
     610, -3185, -3185, -3185, -3185, -3185, -3185,   117, -3185, -3185,
   -3185,  1156,   634,   634,  1501, -3185,   644, 20208,   126,  1449,
   20208, -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1379, -3185,
    1380,  1388, -3185,  1800,  1804,  1809,  1810,  1812,  1813,  1814,
    1815,  1817,  1818,  1819,  1821,  1823,  1824,  1825,  1408, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1459, -3185, -3185,
   -3185, -3185,   719, -3185, -3185, -3185,   113,  1411, -3185, 36395,
    1929, 34247, 41228, 41228,  1801, 20208, -3185, -3185,   315,   315,
    1637,  1127, -3185,    89, 41228,  1806, 24523,    70, 12495, 12495,
   12495,   933,   595,  1912,  1966,  1966,  1966, 12495, 12495, -3185,
   -3185, 12495, -3185, 12495, 12495, 12495, 12495,   939, -3185, -3185,
    8554, -3185,  1418, 12495, 12495,  1504, 12495,  1306, 12495, 12495,
   21288, 12495, 12495, 12495, 12495, 12495,   460, 12495,  1235, 12495,
   12495, 12495,  1420, 12495, 12495, 12495, 12495, -3185, 12495, 12495,
      99, 12495,  1860,   448, 12495, 12495, 12495, -3185,  9117, 12495,
   12495, 12495, -3185, 12495, 12495, 12495, 12495, -3185,  1974, -3185,
   21288,   974, 12495, 12495,  1030, 12495, 12495, 12495, 12495, 12495,
   -3185, -3185, -3185, -3185,  8554, -3185, 12495, 12495, 12495, 12495,
   12495, -3185, 15310, 12495,  9680, 12495, 12495, 12495, 12495,  1423,
   12495, 12495,  1966,  1966, 12495, 12495, 12495,  1032,  8554, -3185,
   12495,  1306,   474,   474, 12495,  1306,  6865, 12495, -3185, -3185,
   -3185,   448, 10243,  1425, -3185, -3185, -3185,  1966, 21288,  1966,
   12495, 12495, 12495, -3185,  1455,  1912,  1912,  1912, -3185,  7991,
     726,  1427, 12495, 22368,  1424, 12495, -3185, -3185, -3185, 15310,
   -3185, -3185,   709, -3185, -3185, -3185, 13058,  1429, 15310, 15310,
    1746, 15310, 15310,     2, 15310, 15310, 15310, 15310, 15310, 15310,
   15310, 15310, 15310, 15310, 15310,  1912, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1440, -3185, 36395,
   15310, 12495, -3185, -3185, 41228, -3185, 34247, -3185, -3185, -3185,
     125, 36395,  1432, -3185, -3185,  1616,  1016, 20208, -3185, 41228,
   -3185, -3185, -3185, -3185, 18578, 18578, -3185, 18578, -3185, -3185,
     108,   110,  1399,  1464, -3185, -3185, -3185, -3185,  1786, 20208,
   -3185,   527, 20208,   126, -3185, 12495,  1449, -3185, 34247, 34247,
   20208, 20208,    41, -3185,   804, -3185,  1449,  1822, 18578, 18578,
   18578, -3185, -3185, -3185, -3185, -3185,   632, -3185, -3185, -3185,
    1435, -3185, -3185, -3185, -3185, -3185, 39080,   104, -3185, -3185,
    1449,  1832, -3185, -3185,  1444, 41228, -3185, -3185, -3185, -3185,
     -10, -3185, -3185, -3185, -3185,   387, -3185, -3185, -3185, -3185,
    1571,    20, 41228, -3185, -3185,    20,   672, 20208,    20,    20,
   -3185, -3185,    72, -3185,   -48, -3185, -3185, -3185, -3185, 41228,
     946,  1581,  1450, -3185, -3185, 20208, -3185,  1451, -3185,  1843,
    1970,  1309, -3185, -3185, -3185,   305,   305,  1449,  1565,  1567,
    1569,  1570,  1574,  1602, -3185, -3185,   744,  1960,   305,   305,
    1960,   305,   305,   305,  1542,  1909,   305,  1798,  1560,  1077,
    1802,   305, -3185,  1561,  1916,   305,   305,   305,  1960,   305,
     305,   305,   305,   305,   135,   305,   305,   305, -3185,  3012,
   -3185, -3185,  1475, 19118, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, 39617, -3185, 12495,   595,  1449,  1449,   630,  1449,
     595,  1449,  1449,  1449,  1449,  1449,   595,  1449,  1449,   595,
    2039, -3185, -3185, -3185, -3185, -3185,   -60, -3185, -3185,  1143,
   41228, -3185,  1648, -3185, -3185, -3185, -3185, -3185, 20208,  1521,
    1464, 24523, -3185,   415, -3185,  1472, -3185,  1478,  1481,   770,
   -3185,  1966,  1482, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
    1484,  1483,  1486,  1488,  2032,  1490,   606,  1492,  1495,  1497,
    1498,  1500,  -169,  1502, -3185,  1506,  1503,  1507, -3185,  1508,
    1509,  1511,  1512,  1513,  1515,  1510,   822,   846,  1518,  1520,
     874, -3185,  1523,  1525,  1888,  1532,  1534,   882, -3185,  1524,
    1535,  1537,   885,  1540,   891,   893, -3185, -3185, -3185, -3185,
    1541,  1543, -3185, -3185,  -160,  1546,  1548,  1549, -3185,  1551,
    1552,  1553,   908,  1555,  1556,   918,  1557,  1558,  1562,  1505,
    1559, -3185,  1966,  1563,  1568,  1572,  1966,  1573,   920,  1564,
    1575,   922,   928,  1577,  1578,  1579,  1580,  1582,  1584,   930,
    1566,   932,  1586,   -11,  1587, -3185,  1591,  1593,  1595,  1596,
     944, -3185,  1597,  1600,  1601,  1604,  1606,   120,  1608,  1966,
    1610,  1611,   950,  1612,  1613,  1615, 10806, 11369, 11932,   144,
    1621,   540, -3185,  1617, -3185,  1623,  1624, -3185,  1510,  1625,
     956,   967,  1628, 12495,   557, -3185,   460, -3185, -3185, -3185,
    1528,   590, -3185,  1647, 41228, -3185,  1012,  1384, -3185, -3185,
   -3185, -3185, -3185,   216, -3185,  1544, -3185,  1603,  7991,   704,
    1585, 15310,   101,  1218,  1630, 15310, 15310, 15310,   429,   640,
     640,   191,  1235,   191,  1235,  1204,  1204,  1204,  1204,  1204,
    1912, 12495, -3185,  1912, -3185,  1631,   679, -3185, -3185, -3185,
   -3185,  1303,  1846, -3185,  1626, -3185, -3185,   975, -3185,  1550,
   -3185,  1629,  1645,  1646,  1688, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1309,   804,  1656,
    1632, -3185, -3185,  1640,  1870, -3185, -3185, -3185, -3185, -3185,
   -3185,  1706, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
      51, -3185, -3185,  1633,  1633, 16953, -3185, -3185, -3185, -3185,
    1853,  2026,  2027,  2028,   435, -3185,   129, -3185,   629,  1978,
    1309, -3185,  2031, 36932, 25062, -3185,  1638,  1977,  1639,   305,
   32636,   328, 22905, 33173, -3185, -3185,   630, -3185,   119, -3185,
   -3185, -3185, -3185,   562,   562,  1672, -3185, -3185, -3185,  1464,
     672, -3185, -3185, -3185,  1649, -3185, -3185,   415,  1979,  1980,
   -3185,  1866,    56,  1866,   415,   415, 21288,   415,  2161, -3185,
     595,  1919, -3185, -3185, -3185, -3185, -3185, -3185, 35321, 33710,
   -3185, -3185, -3185,  2123, -3185,  2125,   722, -3185, 21828,   940,
     940, -3185,    80,   114, 21828, -3185, -3185, 21828,   630,   595,
   21828,   595,  1449,  1449,  1446,   305,   595, -3185, -3185,  1991,
    1992, 21828, 21828, -3185, 36395, -3185,   305,   728,   630,   630,
   21828,   227,  1449,   595,   595,   652, -3185, -3185, -3185, 20208,
    1114, 36395,  1665, -3185,  4618, 16413, 41228,   273,   186, -3185,
    1659,  1667, -3185,   977, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1752, -3185,  1669,
   -3185, -3185,   127, -3185,  1667, 20208, 15873, -3185,    94, -3185,
    1213, -3185,   415,  1886,    96,  1464,  1678,    70, 13621, -3185,
   -3185, 12495,  1674, -3185, 12495, 12495, -3185, -3185, -3185,   228,
   -3185, 35858, -3185, -3185, -3185, -3185, -3185, 12495, 35858,   228,
   12495, -3185, -3185,  1675, -3185,  2012,  2012, -3185, -3185,  1306,
   -3185, 41228, -3185, 12495, -3185, 12495, -3185,  1306, -3185, 12495,
   -3185, 12495, 12495, -3185,  1907, -3185, 12495, -3185, 12495, 12495,
   -3185, 12495, -3185, -3185, 12495, -3185, 12495, 12495, -3185, -3185,
    1908, -3185, 12495, 12495, -3185, -3185, 12495, -3185, 12495, -3185,
   12495, -3185, 12495, -3185, 12495, -3185, 15310, 21288,  1679, -3185,
   -3185, -3185,  1680, -3185, -3185, 12495, 12495, -3185, -3185, 12495,
   -3185, 12495, -3185, -3185, -3185, -3185, -3185, -3185, -3185, 12495,
   12495, -3185, 12495, -3185, 12495, -3185, -3185, 12495, 12495, 12495,
   -3185, 12495, -3185, -3185, -3185, -3185, 14184, 12495, 12495, 12495,
    1681, -3185, -3185, -3185, 12495, 12495, 12495, -3185, 12495,  2073,
   12495,  2074, 12495,  2076, 12495, -3185, 12495,  1917, -3185, -3185,
   -3185, -3185, -3185, 12495, -3185, 12495, -3185,  1702, 12495, 12495,
    2112, -3185, -3185,  1694,  1695, -3185,  1690,  1692,  1693, 36395,
   12495, -3185, -3185, -3185, 12495, -3185, -3185, 12495, -3185, -3185,
   -3185, -3185,   460,   982,  1700, 15310, -3185,  1585, 15310,  7991,
     704,  1585,   105, -3185, -3185, -3185,  1701, -3185, -3185,  1704,
   41228, -3185, -3185, -3185, 41228,  1709, 25601, 34247, 34247, 34247,
    1707, 12495, -3185, -3185,  1934, -3185, -3185, 20208,  2056, -3185,
   -3185, 34247, -3185,   316, 21288, -3185,  1711, -3185,  1711,   462,
    1713,   985, -3185, -3185, -3185,  1708,   992,  2106, 34247, 34247,
   34247, -3185,  1464,  1464,   661,  1768,  2058, -3185, -3185, -3185,
   -3185, 40154, -3185, -3185, -3185, -3185,   695, 41228,  2040, 41228,
    7428, -3185, -3185, -3185,  2222, 12495, -3185, 34247,   484,   590,
     305, -3185, -3185, -3185, -3185, -3185, -3185,  1309, -3185, -3185,
   -3185, -3185,  2017, -3185,    20,    72,   583, -3185,   960, -3185,
   -3185, -3185,  2057,   415,  1866,  1866,  2060,  1952,   546,  1726,
   -3185,   305,   946,   217, -3185,   316, -3185, -3185, 12495, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, 12495,  2061,  2062,   940, -3185, 21828, -3185, -3185,
     646,    97, -3185, -3185, -3185, -3185, -3185, -3185, 33710,  1449,
   -3185, 21828, -3185, -3185,   187, -3185,  1449, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, 20208, -3185,   987, -3185, -3185, -3185, -3185, 41228,
   -3185, -3185, 20208, -3185, -3185,  4598, 41228, 41228,  2273, -3185,
   41228, -3185, -3185, -3185, -3185, -3185,  1955,  -108,  2277, -3185,
   20208, -3185,  1735,   989, -3185, -3185, -3185,  2279,  3609, -3185,
    1738,  1464,  2054, -3185, -3185, 12495,  1741,  1743, -3185, -3185,
    1744,  1760,  1760, -3185, -3185,  1762,  1760,  2101, -3185,  2102,
    1766,  1767,  1769,  1771,  1772,  1773,  1774, -3185, -3185,  1235,
    1235,  1776,  1775,  1777,  1778,  1780,  1782,  1783,  1784,  1787,
    1788,  1789,  1792,  1794,  1785,  1795,  1796,  1803,  1805,  1807,
    1886,  1808,  1811,  1816,  1820,  1827,  1828,   993,  1829,  1833,
    1008,   284, -3185, -3185, -3185,  1835,  1836,  1837,  1840,  1841,
    1844,  1845,  1848,  1849,  1831,  1850,  1851,  1854, 12495,  1855,
      76,  1011,  1852, -3185,  1857,  1858,  1859,  1863, 12495,  1867,
   12495,  1869, 12495,  1872,  1873,  1876,  1874,  1878, 12495,  1830,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1864, -3185,
    1192, -3185,  1879, -3185, -3185, -3185,   403, -3185,  1014,  1882,
   -3185, 15310, -3185, 12495,  1883, -3185,  1885, -3185, -3185, -3185,
   -3185, -3185,  -132,  -132,  -132, 14747, -3185,  2206, -3185,    44,
   -3185,  2104, -3185, -3185,   965,  1887, -3185,   305, 14747,  1633,
    1942, -3185, -3185,   462, 21288, 25062, -3185, 34247,  1105,  1105,
    1105,  1309,  2172,  1656,  1656, -3185, 23442, -3185, -3185,  1937,
   -3185, -3185, 26140, -3185,   838, -3185, -3185, 15310,  1207, -3185,
   -3185, -3185, 35321, -3185, -3185,   305,  1826,  1847, -3185, -3185,
   40691, 12495, -3185,  2225, -3185, -3185,  1889,   415,  2021,   415,
   -3185,  2142,  2144,   415, -3185, -3185, -3185, 21288,  1464, 14747,
     940,   940,   940, -3185,   965, -3185,  1891,   760, -3185, 21828,
   -3185, -3185,   646,  1884,  2271,  2272, 21828,  2222, -3185, -3185,
   -3185, -3185,  4598,  1019, -3185, 16413, -3185, -3185, -3185,  1894,
    1895,  1760, -3185, -3185, -3185, -3185, -3185,  1762,  2023, -3185,
    1762,  1762, -3185, -3185, -3185, -3185, -3185,   175,   204, -3185,
   -3185,   175, -3185, -3185, -3185,    40,   779,  1762, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185,  1760,  1760, -3185, -3185, -3185,
     175,  1897, -3185,  1760,   211, -3185,   156,    57,  1899,  1901,
    1760,  1902,  1880, -3185,  1023, -3185, -3185,   573, -3185,   346,
   -3185, -3185, -3185,  1903, -3185,  3012, -3185,   488, -3185, 41228,
   -3185,   562, -3185,  1235, -3185, -3185, -3185,  2051, -3185,   175,
    2088, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, 12495,  1904,  1913,  1915, -3185, -3185, -3185, -3185,
   -3185, -3185, 12495, -3185, -3185, -3185, -3185, -3185, 12495, -3185,
   -3185, -3185, -3185, -3185,  2046, -3185,  2138, 12495, 12495, -3185,
   -3185, -3185, -3185, 12495, -3185, -3185, -3185, 12495,  2437,  2113,
    1922, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   12495, -3185, -3185, -3185,  1235, -3185, 12495, -3185, -3185, 12495,
   12495, -3185, 12495, 12495, -3185,  1924, -3185,  1925, -3185,  1926,
   -3185, -3185,  2157, -3185, -3185, -3185, 12495,   992, 41228, -3185,
   -3185,  1928, -3185, -3185, -3185, -3185, -3185, -3185, -3185,    98,
    1956,  1956,  1956,  1207, -3185,  1039, -3185, -3185,  2268, -3185,
    1360, 21288, 14747,  1931,  1933, -3185,    29, -3185, -3185,  1930,
    1105, -3185,  2449,  2299, -3185, -3185, 36395,  1938, -3185, -3185,
    2196, -3185,    87,  2121, -3185, -3185, -3185,   484,  2029,  2033,
     305, -3185,  1449,  1592,  1450,  2280,   656,  1990,   415,   415,
     851,  1994, 12495, 12495,  1953, -3185,  1886, -3185, -3185, -3185,
   -3185, -3185,  1360, 12495, -3185, -3185, -3185,  1957,  1958, 41228,
   -3185,  1982,   273, -3185,   211, -3185, -3185,   -68,  2181,  2184,
   -3185,   -84, -3185,  1962,   -84,   -84,  2484,   128, -3185,  2484,
   35858, -3185,  1126, -3185,  1995,   175, -3185, -3185,  1996, -3185,
   -3185, -3185,   -84,  1965,   175, -3185, -3185,  2189,   -84, -3185,
   36395,  1449,  1951, -3185,  2015, -3185,  2420,  2298, -3185,   211,
   -3185,  2300,  2207, -3185,  2209, -3185, -3185,  2212, -3185,  2213,
    2214,   -84,  2217, -3185,   -84, 41228, -3185, 41228,  2003,   489,
   -3185, -3185, -3185,  1988,  1997, -3185, -3185, 20208, -3185, -3185,
   -3185, -3185,  2065, 41228,  2003, -3185,    29,    94,  1942, -3185,
    1045,   760,  1993, -3185,  2001,  2002, -3185,  1053,  2013, -3185,
   -3185, -3185,  1055,  2014,   140,  2018,  2011,  2020,  2022,  2024,
    2025,  2249,  2403, -3185,  2030,  2035,  2036,  2042,  2045,  2047,
    2048, -3185, -3185, -3185,  2038, -3185, -3185, -3185, -3185,  2050,
   36932, -3185,  2081,  2082, -3185, -3185,  2100, -3185, -3185,   112,
    1090, -3185, -3185, -3185, -3185, 14747,  2332, -3185,   139, -3185,
   -3185, -3185, -3185, 12495, -3185,  1886,  2517, -3185, 23442, -3185,
   -3185, -3185, -3185, -3185,  2053,  2055,  7428,  2572, -3185,   415,
   -3185,  2075, -3185, -3185, -3185,  2077, -3185, -3185, 41228,  2054,
    2041,   139,   760, 41228, 41228,  1062,   448,   448,   448,   650,
     650, -3185, -3185, -3185, -3185,    79,   158, 41228, -3185, -3185,
     768, -3185,  2063,  2064, -3185, -3185, -3185, -3185,   -84, -3185,
     140, -3185, -3185, -3185, -3185, -3185, 35858, -3185, -3185,  2484,
   -3185, -3185, -3185,   140, -3185,  2066, -3185, -3185, -3185,  1099,
   -3185, -3185,  2263,  2070, -3185, -3185, -3185, -3185,  2071,  2078,
    2080,  2083, -3185,  2069, -3185, -3185, -3185,   739, -3185, -3185,
   -3185, -3185, -3185,   870, 41228,  2439,  1449,  2084,  2072, -3185,
   -3185, -3185, -3185, -3185,  2085,   992, -3185, 41228, -3185,  2284,
   -3185, -3185, -3185,  2286, -3185, -3185, 12495, -3185, -3185, -3185,
    1966, -3185, 12495, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185,   123,  2276,   595,   595,   595,   595,  1090, -3185,
   -3185,  2108,  2150, -3185,   629, -3185,   290,   760, 12495,  1309,
     660,  2374, -3185, -3185, -3185, -3185,  2356,   916, 12495,  2087,
   12495,  2090,  1069, -3185, -3185, 39617, -3185, -3185,  1086,  1089,
   -3185, -3185, -3185,   273, -3185, -3185, -3185,   398,   398,  1094,
   -3185, -3185, -3185, -3185, -3185,  1096, -3185, -3185, -3185,  1101,
   -3185, -3185,  1099, -3185,   175,  2484,   175,  2484,  2578,  2294,
    2581, -3185,   365, -3185, -3185,  4598, -3185, -3185, -3185, 41228,
    4598, -3185, -3185,   760,  2091,  2092,  1113,  2093,  2094,  2095,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, 21288, 20208, -3185,
     343, 12495, -3185, -3185, -3185,  2282,  2607,  2613,  2524,  2616,
     660, -3185,  -100, -3185,  2519, -3185, -3185, 41228, -3185, 41228,
   -3185, 41228,  2105,  2103,  2278, -3185, -3185, -3185,  2658, -3185,
     147, -3185, -3185,   768, 41228,   175,   140,   175, -3185, -3185,
   -3185, -3185, -3185,  2325, -3185,  2326, -3185,  2110,   853, -3185,
    2541,  2270, -3185, -3185,    29, -3185, -3185, -3185, -3185, 12495,
   -3185, -3185, -3185,  2114, -3185,   305, -3185, -3185, -3185,   760,
   41228, -3185,   140,   140,  2630,   140, -3185,  2631,  2635,  -100,
   -3185,   630, 12495,  1117,  1119, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,    29, -3185,
   -3185, -3185,  2563, 31015,  2269, -3185, -3185,  2124, 21288, 14747,
    2517, -3185, -3185, -3185, -3185,   140, -3185,   140,   140, -3185,
    2666,  2119, -3185, -3185, -3185, -3185, 41228,   206, -3185, 42302,
   42302, 41228, -3185,  2154, -3185,  3647,   133, -3185, -3185, -3185,
   -3185, -3185,  2118, -3185, -3185,  4598, -3185, -3185, -3185,  2374,
    2128, -3185, -3185, -3185,  2415, -3185, -3185, -3185,  2520, 41228,
   -3185, -3185, -3185, -3185, 12495, 12495,  2158, -3185, -3185, 31015,
   31015, -3185, -3185, -3185, 31015, -3185,  2482,  2132,  2553, -3185,
    2475,  2560, 12495, -3185, -3185, -3185,   609, -3185, -3185, 28305,
    2131, 31557, 12495,   133, -3185, -3185,  2369,  2141, 12495,  2143,
    2140, -3185,   595, -3185,  2494,  2159,  2176, 12495, 31015, -3185,
    2571,  2604,  2448,  2145, -3185,  2146,  2587, 42302,   853,  2465,
   17493,  2290, -3185, -3185, -3185, -3185, 41228, -3185, -3185, -3185,
     694, -3185, -3185, 28847,  2169, 37469, 29389,  2151, -3185, -3185,
   12495, -3185, -3185, -3185, 31015, -3185, -3185, 36395,  1121, -3185,
   -3185, 21288, -3185, -3185,  2162, -3185, 31015, 12495, -3185,  2582,
    2174, -3185, -3185, -3185,  2530,  2166,  1160, -3185,  2163, -3185,
    2592, 31015, -3185, -3185, -3185, 19663,  2114, 41228, 26679, -3185,
    2185, 31015,  2567, 41228,  4598,  2570,  2574, -3185,  2345, 29931,
   -3185, -3185,    60,  2198, -3185, 27221, -3185, -3185,  2639,   588,
   -3185, -3185,  2216, -3185, 31015, -3185, 31015, 32099, 12495, -3185,
    2228, -3185, -3185, -3185,  3647, -3185, -3185, 30473, 27763, -3185,
   -3185, 23979, -3185, -3185,  2579, -3185, -3185, -3185,  1306, -3185,
   32099, -3185, -3185, -3185, -3185
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3185, -3185, -3185, -3184, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185,   961, -3185, -3185, -3185, -3185, -3185,  1196, -1388,
   -3185, -3185, -3185, -3185, -3185,   317,    33, -3185, -3185, -3185,
   -3185, -3185, -3185,  2089,  -762, -3106, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185,  -426,  -544, -3185, -3185,  -416,
   -3185, -3185, -2167, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185,  -861, -3185,  -889, -3185, -3185, -1865, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185,  -860, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  -786, -3185, -3185,
    -741, -3185, -3185,  -784, -3185, -3185, -3185,  -746, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  -239, -3185, -3185,
   -1794, -3185, -3185, -3185,  1643, -3185,  1703, -3185,  2380, -3185,
    -357,    42,  1246, -1788, -1007,  -537,  -532, -1587, -3185, -3185,
   -3185,  -328, -3185, -3185,   763,   118,  1247,  1286,   803,   855,
   -3185, -3185,   138, -3185, -2604, -3185, -3185, -3185,   102, -3185,
     109, -3185, -3185, -3185, -1352,    64, -1595, -3185,  -344, -1511,
   -3185,  -129, -3185,  -173, -3185,  -423, -1972, -1739, -3185, -3185,
    -159,   149,   188, -3185, -2586, -2035, -3185, -3185,  -540, -3185,
   -3185, -3185,  -548, -3185,  -313,  -459, -3185, -3185, -1444, -1740,
   -3185, -3185, -2137,  1671, -2655,  -376, -1828, -3185,  -331, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,   839, -3185,
   -3185, -3185,  -199,  -287, -1307, -2719, -3185, -3185, -3185, -3185,
   -3185, -3185,   973, -3185, -3185,  1352,  1779, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,   979, -3185,
   -3185, -3185, -3185, -3185,  -872,  1696, -3185, -3185, -3185,  1231,
   -3185, -3185, -3185, -3185,  1417, -3185, -3185,  2139, -3185, -3185,
   -3185, -3185,   585,  1001, -3185, -3185, -3185,  2160,   971,  -453,
   -1700, -3185,  2372, -3185, -3185, -3185, -1252, -1920, -3185,  2229,
    -405, -1604,  1419,  -698,   -14, -3185,  -217,  -727,  3336, -3185,
   -3185, -1225, -3185, -3185,  -772, -3185, -3185, -1258, -1159,  1529,
    1522,   371,   367,   153, -3185, -3185,  -485, -3185, -3185, -3185,
   -1240,  -697, -3185, -3185, -3185, -3185, -3185, -3185, -3185,   -12,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -1117, -3185,   788, -3185, -1013, -3185, -3185, -3185,  1634, -3185,
   -3185, -3185, -3185, -3185, -1851, -1439,   213, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -1820, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -1301, -3185, -1642, -3185,  -949, -3185,
   -3185,  -417, -2065, -1160,   432, -3185, -3185,  -950,  1676, -1519,
   -3185, -3185, -3185,   635, -3185, -3185, -3185, -1976, -1015, -3185,
   -3185, -2309,  -607, -1773,  -578, -3185, -1812,  -257, -1135, -1840,
   -3185, -3185, -3185, -3185,  -696, -3185, -3185, -3185,  -231,   991,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185,  -452,  -358,   858,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1905,
    1881,  1044, -3185, -3185, -1886, -3185, -3185,  1013, -3185,     0,
   -1807, -1214,   285, -3185, -3185,   287, -2564, -3185, -3185, -3185,
   -3185, -3185, -3185,   226,  -705,  -561,  2423, -3185, -3185, -3185,
   -3185, -3185, -3185,  2155,  1729, -1399,  2368, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185,  2440, -3185,  -946, -3185,
    -437, -3185, -3185,  -553, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185,  1514, -3185, -3185, -3185, -3185, -3185,  1906,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185,   306,  -552, -3185,  -451,
    -592, -3185,  -518, -3185, -3185, -3185,  -711, -3185,  -747,  -649,
    -994,   -77, -2577, -1412,   302,  1898, -2675, -1098, -1264, -1272,
   -1783,    21, -3185,    -7,  -440,  -425,  -893,  2059, -2242,  -409,
    -503, -3185,   608, -3185, -3185, -3185, -3185,  1467, -3185, -3185,
   -3185, -3185,   601, -3185, -3185, -3185,   269, -3185,     5,  -193,
   -3185, -3185,   356, -3185,  1516, -3185, -3185, -3185, -3185, -3185,
   -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,  1918,
    2467,  2314, -3185,  1959, -3185, -3185, -3185, -3185, -3185,  -324,
   -3185,   -93, -3185, -1382,  1770,   369, -3185,   675,  -855, -1134,
   -3185,  -326, -3185, -3185,   801,  2474,  2318, -3185, -3185, -3185,
   -3185, -3185, -2183,  -583, -3185, -2238, -3185, -3185, -3185, -3185,
   -1137, -3185, -3185,  1618,  -141, -3185, -3185,   526, -3185, -3185,
     600, -3185,  2435,  2194, -3185,   897, -3185,   181, -3185, -3185,
     -89, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185, -3185,
     894, -3185, -3185, -3185, -3185, -3185, -3185
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1970
static const short int yytable[] =
{
     373,   698,   550,   663,   985,  1177,  1727,  1391,   904,  1132,
    1133,  1134,   373,   634,  1726,   373,  1446,  1600,  1063,  1168,
    1169,  1171,   373,   656,   656,   656,  1027,   656,  1634,   656,
     689,   690,   373,  1153,  1012,  2181,  2296,  1601,  1602,  1603,
    1233,  1748,   373,   408,  2232,  1481,  2308,  2432,  1756,  1632,
    1615,  2250,  1935,  1789,  2318,  1012,  2322,  1007,  2924,  1535,
     906,  2023,  2280,  2285,  2288,  1951,   966,  1529,  2626,  2451,
    1745,  2300,  2301,  2586,  1893,  2907,  2454,  1772,  1774,  1455,
     373,  1028,  1624,  1693,  2317,   648,  1235,  2269,   942,  2976,
    1458,  1459, -1483,  1261, -1114,  2948,  1265,  -248,  2352, -1484,
     373,   373,  2946,   373,  1673,  2947,  2350,  1677,   463,   942,
    1395, -1818,  1259, -1819,   373, -1882,  -258,  2208,  2371,  2372,
    -259,  2551,  1671,   963,  2956,  1274,  1275,  1276,  3221,   977,
    2975,   706,   484,   942,  1069,  1704,  1705,  2342,   717,  1070,
    1710,   468,   478,   469,  2025,  2339,  1606,  1607,  3134,  1609,
    1760,  2339,  1762,  1966,  2351,  3080,  3052,  2354,   604,   605,
    1725,  3488,  1729,  3016,  1859,  1285,  1286,  1287,  2363,  2364,
     106,  2342,  1075,  1357,   652,  1909,  2936,  2373,   937,  1114,
    2333,  3052,   604,   605,  1643,  1325,  2027,  1111,  2937,  2340,
    2341,  1268,  3623,  1646,  1835,  2936,  1647,  1586,  1031,  1663,
     414,  2938,  1009,  3113,  1835,  1013,  1539,  2937,   681,  1406,
     604,   605,   943,  2653,  2134,  3115,   972,  1683,  1684,  1685,
    2938,  1065,  2422,  2654,  2936,  1065,  1078,  1764,  1692,   604,
     605,  1021,  2429,   943,  2959,  1357,  2937,  1374,  3102,  2413,
     543, -1114,   656,  2342,  2816,  1002,  2343,  1880,  1765,  2938,
     107,   691,  3264,  1023,  2424,  3409,  2262,   943,   604,  2942,
    2441,  2316,  3420,  2298,  3105,  2849,   997,   948,   564,  3116,
    3267,  3487,  1919,   498,  2960,   950, -1940,  1967,  2961,  1115,
    -339,  2399,  1116,  2442,  1938,  1939,  2313,  1941,  1942,  1943,
    1034,  2147,  1946,  2007,  1117,  2729,  1053,  1954,  3070,  2314,
     572,  1957,  1958,  1959,  2424,  1961,  1962,  1963,  1964,  1965,
    1856,  1970,  1971,  1972,  1319,  2164,   654,   551,   934,  2962,
     415,   547,  2443,  2574,  1079,  2444,  3053,   499,   588,  1003,
     576,  1594,   447,  2445,   108,  2374, -1483,  1038,  1025,   653,
    1041,  1095,  1096, -1484,  3112,   439,  2414,   121,  2048,  3124,
     117,  3053,   118,  3397,   428, -1818,  1269, -1819,  1573,  3140,
     119,  1085,   377,  2581,  1047,   378,   379,  2365,  3144,   109,
    2303,  2198,   951,   448, -1940,  3398,  1026,  3477,   380, -1114,
    1086,   106,  2640,   417,  2391,  3112,  1010,  1766,   423,  1595,
     373,  1313,   427,  2049,   422,   421,  3489,   440,  3237,  1477,
     373,  1080,  2090,  1042,   373,  2644,  1112,   552,  1039,   373,
    1986,   961,   441,  1836,   373,  1996,  2008,  2263,  1870,  1118,
     577,  2002,  3054,  1836,  2005,  3125,  1596,  2641,  1375,  3387,
    1131,  3265,  3420,  2400, -1483,   500,   373,   560,   589,  2425,
     555, -1484,   449,  -471,  2344,  1881,  3347,  1915,  3258,  3259,
    3649,  2998,  2730,   373,   573,  1360,  1654,  1871,  1106,  1107,
    3126,  1448,  2315,   373,  1352,   952,  1349,   373,  1054,  1454,
    1915,   553,   473,   373,  2032,   373,   373,  3410,  -339,   471,
     373,   373,  1482,  2621,   578,  1460,  1461,   707,  1597,  2425,
     373,   674,  3117,  2630,   373, -1114,  2287,  1320,  1119,   373,
     373,  3230,   373,   373,   373,   373,  2433,  1024,  1393,  2798,
    1889,  1574,  1449,  3266,  2639,  2918,   590,   565,  1402,  2652,
    1004,  1828,  1529,  2655,  1721,   110,  1358,  3490,   692,  3478,
    1069,  1935,   983,  2659,  1376,  1070,   696,   697,   373,  1312,
     900,  2963,   902,   903,  3346,   682,  2199,  2446,  2964,  1467,
    3055,  1767,  1394,   998,   373,  2108,  1837,  1432,  1598,  2112,
     544,  3056,   373,   373,  2339,  2949,  1837,   373,  1396,  2999,
    2402,   676,  1935,  1727,   373,  2965,  1330,  1648,  2339,   416,
    1649,  2254,   957,  2431,  2345,  3081,  3056, -1114,  1358,  1069,
     972,   969,  2150,  1035,  1070,  2307,  1080,  1457,  1014,  2183,
    1080,   585,  2207,  1080,   373,  2651,  3624,  2211,  2212,   708,
    2270,  1759,  2213,   972,  2214,   938,   654,  2977,  -339,  2657,
    1968,  2204, -1483,   656,  1022,  2027,  1005,  1780,  3072, -1484,
    3135,  -566, -1114,  1270,  1727,  2966,  3057,  2817,  2415,  1540,
    2738, -1818,  2321, -1819,  1331,  1435,  3389, -1882,  1486,  2299,
   -1969,  1312, -1114,  1783,  3046,  1312,  1581, -1483,  2939, -1114,
     373,  2447,  -248,  2026, -1484,   434,   450,  3491,   373,  3268,
    1872,   373,  2631,  2632,   373,   373, -1818,  2939, -1819,  1335,
   -1882,  -258,  2148,  1006,  2973,  -259,   451,  1080,  1080,  1468,
    1408,  3369,  1594,  1469,   935,  1036,  3373,  2867,  3359,  1594,
    3361,  1487,  3188,   478,   488,  2165,  2939,  2200,  -500,  2448,
     373,   452,   373,  1488,  1037,  2967,  2974,   489,   511,   382,
    1565,  1883,  1541,  2201,  1599,  2184,  3348,  3000,  2943,  2712,
    1575,  2359,  1916,  2642,  1989,   556,   442,  2449,  1137,   569,
    1142,  1898,  2366,  2591,  2592,  1321,  1322,  1323,   395,  1350,
    1595,  3388,  1352,  1536,   754,  1916,  1594,  1595,   453,   513,
     591,   592,   593,   594,   595,   596,   810,  1349,  3182,  3413,
    2862,  3415,  1114,  1339,   562,  2326,   597,  2186,  2896,  2914,
     571,  1340,  2900,  1422, -1483,   455,  2250,  1596,  3288,  2593,
    2990,  1823,  1990,  3257,  1596,  3326,  3289,  2265,  2991,  3349,
     650,  -338,   383,  1856,  2353,  3327,  2355,  3001,  2887,  2897,
    1927,  2360,   767,  2901,  1595,  2459,  2460,  1753,  2871,  2799,
    2616,  2917,  1928,  1441,  3350,  3320,  2375,   668,  2377,  2378,
    2382,  2336,   396,   458,  1312,  1467,  1352,  2617, -1358,   429,
    1352,  -505,  2187,  1029,  1341,  2562,  2563,  2564,  1423,  1597,
    2205,  1596,  3321,  1788,  1857,    40,  1597,  1010,  1315,  1316,
     373,  3495,   373,  1902,  1749,  3468,  2339,   459,  1537,  1489,
     397,  1899,  1115,  2915,  1914,  1116,  2588,  2589,  2590,  1412,
    1288,  1409,  1841,  2635,  1743,  2266,  1900,  1117,  2367,  1446,
    1446,  1991,  1343,  1442,   373,  1831,  1832,  1030,  1886,  1901,
     373,  3133,  1888,  1012,  3138,  1891,  1892,  1824,  1841,  3169,
    -338,   794,  2740,  1597,   491,  1794,   818,  2625,  1929,  1598,
    1487,   475,  1355,  2992,   654,   456,  1598,   460,  3323,  3013,
    3099,  2749,  1488,   465,  1424,  2753,  1898,   373,  1490,   373,
    1782,   373,   470,  3009,  2304,  1590,  2337,  2491,  1175,  1884,
    2547,  1590,  1790,   373,   373,  1480,  1830,  1085,  2323,  1535,
    2618,  1992,  1491,   373,   373,  2368,  1849,  1529,  3139,  2540,
    2860,  3419,  1727,  1902,   373,  1468,  1086,  1480, -1358,  1469,
    2577,   815,   471,  1598,  1843,  1844,  1590,  1376,   494,  1413,
    1875,  3290,   810,  3090,  3375,    51,   373,   373,   373,   373,
    3618,  1898,  3302,  3328,  1873,  1344,   373,   669,   373,  2492,
    2594,   545,  1118,  1492,   373,  2188,   654,  1346,   715,   -55,
    1631,  1425,  2580,   398,   373,  2379,  1438,  1439,  2380,   481,
    3630,  1898,   670,  2452,   696,   697,  1436,  1437,  2457,  1750,
    2912,   810,  1590,   810,  1590,  1898,  1447,  1920,  3008,  3170,
    1350,  3115,  1456,  2465,  1453,  1591,  2369,  2660,   926,  1443,
    2470,  1614,  1903,  2636,  1825,  2542,  1899,   384,  2210,   480,
     373,   114,  2549,   373,   484,  2479,  2480,  2434,  3092,  3093,
    3431,  1900,  2484,  3086,  1493,  1599,   983,  2990,  1489,  2178,
    2489,  1119,  1599,   716,  1901,  2991,  1672,   693,  1538,  3239,
    -264,   385,  2167,  2179,  3278,  3116,  1987,  1988,  -338,  1995,
     486,  1997,  1998,  1999,  2000,  2001,  1904,  2003,  2004,  2906,
     385,   927,   373,  2041,   373,   373,   373,  1993,   373,  2507,
     399,  1899,   386,   910,  -137,  3329,  3426,   373,   495,   373,
    1138,  3505,   387,  1927, -1937,   400,  1900,   847,   115,  1599,
     654,  2010,  1676,  1085,  1709,  3528,  1571,  1490,   694,  1901,
    2930,  1899,   928,  1139,  3277,  1568,  1569,  2042,  1902,   542,
    2011,   401,  1086,   373,  1175,  1899,  1900,   929,   696,   697,
    3444,  1491,   497,  1930,  2384,  2385,   402,   505,  3094,  1901,
    1900,  1307,  1317,  1318,  2954,  2955,  2908,  2908,  2908,   654,
    1751,   654,  2958,  2628,   563,  2870,  2557,  3481,  3482,  2981,
     604,   605,  1308,   373,  3184,   645,  1752,   911,  2882,  1485,
    2992,  1935,  2386,  1175,  1841,  1175,  3549,   696,   697,  1352,
    1842,  2883,  1492,  1902,  1176,  3605,  1498,  1499,  3247,  2219,
    3528,   516,   517,  1949,  2387,   117,  2220,   118,  -338,  3606,
    3360,   405,  3362,  3335,   507,  2219,   509,  1903,   510,   418,
     512,  2884,  2602,  1902,   424,   559,   437,  -457,  -457,  1501,
     438,   373,  3403,   912,  3404,  2388,  -457,  1902,  3223,   573,
    1502,   664,  1803,  1260,  1804,  1264,   373,  1737,  1738,  1503,
    1085,   696,   697,  2845,   545,  3563,  1352,   913,  1937,  2764,
    2765,  1940,  1371,  1493,  2950,  1372,  1505,  2951,  1373,  1086,
    1952,  1904,  1727,   518,   675,  1851,  1852,  1853,   676,  1960,
    2254,  1065,  1903,  3511,  1506,  2931,  1843,  1844,  2934,  2935,
     705,  2030,  2031,  1326,  1327,  1328,  1329,  1330,   685,  3131,
    3132,   519,   373,   658,   659,  2952,   660,   373,   661,   373,
     106,  1309,  1903,  1511,   373,   520,  2192,  3142,   898,  2193,
     373,  3553,   373,  3146,  1845,  1727,  1903,   373,   373,   908,
     373,   907,   901,  2321,  3224,  3225,  1904,   521,  3226,  3227,
     925,   914,   373,  2062,  2063,   373,  3162,   915,   522,  3164,
     923,   373,   373,   373,   373,  1800,  1800,   932,  1800,  2195,
    2196,   373,   373,   373,  1310,  1331,  1904,  2064,  2065,  3598,
    1822,   643,   644,   957,   647,   916,   930,   523,   940,   373,
    1904,   969,  1834,  2273,  3609,  2541,  1514,   941,   373,  1800,
    1800,  1800,   109,  1515,  3615,  2068,  2069,  1332,  1333,  1334,
    1335,  1950,   524,  2075,  2076,   373,  2080,  2081,   525,   955,
     373,   917,  2083,  2084,  2085,  2086,   956,  3637,   964,  3638,
     975,  2286,   373,  2290,  2295,  2785,  3325,   976,   373,  2097,
    2098,   918,  1775,  1776,  1777,  1778,  1779,   979,  1890,  2101,
    2102,  2114,  2115,  2118,  2119,   526,   919,   980,   118,  2120,
    2121,  2128,  2129,  2131,  2132,   983,  1908,  2389,   994,  1516,
     604,   605,  2356,  2357,  -537,  2140,  2141,  1496,  2546,  2332,
    2286,  2153,  2154,  1517,  1497,  1311,  1312,  2172,  2173,   986,
    2553,  2358,  2376,   995,  1498,  1499,   373,  1000,  2174,  2175,
    1336,  2841,  1337,  1338,  1339,   373,  2223,  2224,  2409,  2410,
    1001,  1805,  1340,  2543,  2544,  1009,  2583,  2584,  2664,  2665,
    2735,  2665,   996,  1500,  2792,  2793,  1010,  1501,  3454,  1806,
    1015,  3440,  1009,   373,  1519,  1016,  1520,  1017,  1502,  2796,
    2797,   373,  2818,  2819,   373,  2842,  2843,  1503,  3429,  1807,
    2925,  1080,  1504,  3014,  2986,  2987,  1018,  1521,  1522,  1727,
    1523,  3366,  1019,  1808,  1505, -1114,   527,  2577,  1020,  2021,
    3064,  3065,  1032,  2013,  1033,  1341,  3186,  3187,  1046,  1065,
     942,  1048,  1506,   528,  3192,  3193,  3195,  3196,  1049,   529,
    1051,  1507,  1508,  3260,  3187,   530,  1525,  1509,  1056,  3514,
    3340,  3341,  2286,  1076,  2461,  1510,  1809,  1810,  1077,  2286,
    1123,  1511,  2466,  1124,  3533,  1125,  3533,  3344,  3187,   531,
    3345,  3187,  1342,  1343,  3035,  3353,  3354,  3355,  3356,  1127,
     532,   533,  3357,  3356,  1811,  1130,  1512,  1131,  1298,  1299,
    1129,  1498,  1499,   985,  3378,  3379,  1135, -1114,  3442,  3341,
    3443,  3341,  3594,  3595,  1771,  1773,  1769,  1770,  3533,  1144,
    2622,  3588,  2910,  2911,  1713,  1714,   534,  3261,  3262,  3592,
    2874,  2875,  -457,  -457,  1501,  1146,  1300,  1526,  2851,  2852,
    1148,  -457,  1513,  1149,  1514,  1502,  1527,  3062,  3063,  1012,
    1301,  1515,  1812,  1150,  1503,  1151,  1152,  1154,  1155,  1156,
    1157,  1158,  1295,  3533,   943,  1159,  1160,   373,  2573,  1161,
     535,  1505,   536,  1162,  3533,  1163,  1164,  1446,  1165,  1166,
    3533,  2624,  1302,  1167,  1170,  1172,  1065,  1173,  1174,  1506,
   -1114,  1324,  1813,  1178,  1303,  1179,  1344,  1180,  1181,  1314,
    1182,  1183,  3533,  3533,  1351,  2428,  3651,  1345,  1346,  1184,
    2538,  1185,   654, -1114,  2615,  1186,  1187,  1516,  1511, -1114,
    1188,  1304,  1189,  1190,  1191,  1354,  1192,  1193,  1194,  1195,
    1196,  1517,  1197,  1198,  1199,  1200,  1518, -1114,  1201,  1202,
    1203,  1204,  1205,  1206, -1114,  1208,  1209,  1210,  1211,  1212,
    1213,  1214, -1114,  1215,  1216,  1217,  1221,  1222,  1223,  1224,
    3049,  2600,  1225,  1226,  1227, -1114,  1228,  1229,   373, -1114,
    1230,  1231,  1232,  1234,  1236,  1364,  1480,  1305, -1114,  1237,
    1238,  1239,  1519,  1240,  1520,  1241,   373,   373,  1242,  1243,
    1244,  1514,  1245,   373,  1246,   373,   373,  1247,  1515,  1361,
    1248,  1368,  1249,  1250,  1251,  1521,  1522,  1252,  1523,  1253,
    1254,  1255,  1256,  1257,  1258,  1262,  1263,  1266,  1267,  1271,
    1272,  1273,  1524,  1277,  2015,  1278,  1279,  1280,  1281,   373,
    1282,  1353,  1365,  1386,  1356,  1366,  1369,  1387,  1390, -1114,
    1153,   373,   373,  1392,  1525,  1398,  1399,  1400,  1401,  2658,
    1407,   373,  1415,  1421,  1430,   547,  2661,   373,  1434, -1114,
     373,  1450,  1462,   373,  1516,  1464,  1466, -1114,  1478,  1542,
    2663,  1543,  1545,  3088,   373,   373,  1546,   373,  1517,  2286,
    1544,  1547,  1548,   373,  1549,  1550,  1551,  1552, -1114,  1553,
    1554,  1555,   373,  1556,   373,  1557,  1558,  1559,   373,   373,
    1560,  1561,  1564,  1566,  1578,  1349,  1570,  1583,  1590,  1618,
    1270,  1638,  1652,  1669,  1701,   731,  1724,  1733,  1739,  1758,
    2383,  1744,  1761,  1781,  1791,  1526,  1792,  1816, -1114,  1519,
    1819,  1520,  1864,  1876,  1527,  1878,  1885,  1906,   373,   373,
    1850,  1911,  1907,  1910,  1913,  1921,   731,  1922, -1114,  1923,
    1924,  1926,  1521,  1522,  1925,  1523,  1927,  1944,  1945,  1947,
    2997,  1948,  1955,  1953,   373,  1956,  2419,  1974,  2022,  2026,
    2028,   373,  2029,  2033,  2036,  1727,  2035,  2037,  3106,  2038,
    2039,  2040, -1114,  2043,   373,   754,  2044,  2053,  2045,  2072,
    2046,  1525,  2047,  -537,  2050,  2106,   374,  2052,  2054,  -537,
    2055,  2056,  2057,  2058,  2190,  2059,  2060,  2061,   404,  3106,
    2066,   410,  2067,  3307,  2070,  2077,   754,  2071,   419,  3312,
    3313,  3314,  3315,  2185,  2073, -1114,  2074,  2078,   430,  2079,
     373,  2082,  2222,  2087,  -782,  2088,   765,  2091,   446, -1114,
    2092,  2093,  2094,   767,  2095,  2096,  2099,  2225,  2100,  2103,
    2104,  2107,  2240,  2105,  2109, -1114,  2116, -1114,  2130,  2110,
    2227,  2228,  2235,  2111,  2113,  1312,  2117,   765,  2122,  2123,
    2124,  2125,  1526,  2126,   767,  2127,   464,  2133,  2135,  2553,
     782,  1527,  2136, -1114, -1114,  2137,  1727,  2138,  2139,  2142,
   -1114,  2143,  2144,  2202, -1114,  2145,   467,   374,  2146,   374,
    2149,  2151,  2152,  2229,  2155,  2156,  2157,  2239,  2168,   942,
     464,   782,   373,  2166,  2169,  2170,  2171,  2879,  1080,  2176,
    2209,  2241,  -958,  2245,  2237,  2257,  2226,  2258,  2259,  2260,
    1857,  3309,  1856,  2332,  2278,  2277,  2279,  2302,  2016,  2309,
    2310,  2305,   794,   373,  2311,  2327,  2334,   373,  2335,   373,
     373,   373,   373,  2361,  2362,  2392,  2406,  2407,  2411,  2412,
     373,  1480,  1584,   786,   373,  2438,  2458,   373,  2471,  2481,
    2493,  2494,  2513,   794,  2518,  2520, -1114,  2522,  2525,  2528,
    2531,   373,   373,   373,   985,  2533,  2534,  2535,  1822,  2536,
    2537,  2545,  2552,  2560,   373, -1012,  2571,  2565,  1727,   810,
     373,  2567,   373,  2579,  2582,  2585,  3570,  2587,  3149,  2598,
     373,   814,   815,  2599,  2604,  2612,  2623,  2629,  2637,  2634,
    2633,  2725,  2728,  2649,  2650,  2732,  2734,  2736,  2739,  1727,
     810,  2741,  2744,   943,  2745,  2746,  1093,  1094,  1095,  1096,
    1097,  1098,   814,   815,  1099,  1100,  1101,  1102,  1103,  1104,
    2747,  1105,  2750,  1727,  2754,  2755, -1114,  2756,  2757, -1114,
    2758,  3570,  2759,  2760,  2761,  2857,  2762,  2766,  2767,  2768,
     373,  2769,  2220,  2770,  2771,  2859,  2772,  2778,  2773,  2774,
    2775,   373, -1114,  2776,   373,  2777,  2779,  2780, -1114,  1177,
    1261,  1265,  1841,  2872,  2781,  2880,  2782,  2892,  2783,  2895,
    2786, -1114,  2898,  2787,  2899,  3198, -1114,  2836,  2788,  2920,
    2921,  2789,  3015, -1114,  2932,   373,  2888,  3545,  2790,  2791,
    2794, -1114,   373,  2810,  2795,   373,  2801,  2802,  2803,   373,
     373,  2804,  2805,   373, -1114,  2806,  2807,  2889, -1114,  2808,
    2809,  2811,  2812,   373,  2820,  2813,  2815, -1114,  2821,  3017,
    2822,  2823,  3281,  2667,  2824,  1106,  1107,   654,  2826,  3107,
    2828,  2838,  3108,  2830,  2831,  2833,   582,   517,  2832,  2834,
    2840,  2733,   845,  2844,  2919,  2847,  2848,  2985,   847,  2861,
    2893,   848,  3087,  2913,  2928,  2929,   508,  2957,   654,  2979,
    3107,  2980,  2982,  3108,  3005,  3019,   541,  3077,  3024,  3026,
     549,  3291,  3292,   845,  3020,   464,  3021,  3031, -1114,   847,
     568,  3276,   848,  3033,  3032,  3041,  3042,  3043,  3044,  3048,
    3067,  3060,  3071,  3073,  3276,  3065,  3074,  2602, -1114,  3079,
    3078,  3082,   464,  3109,  3110,  3084, -1114, -1046,   518,  3085,
    3089, -1051,  3122,  3098,  3136,  3123,  2976,  3103,  3104,   665,
    3145,  3148,  3130,  2973,  3141,  3143,  3152, -1114,  3153,   464,
    3154,  2286,  3156,   464,  3109,  3110,   519,  3157,  3167,   687,
    3158,   464,   464,  3159,  3160,  3161,   699,   549,  3163,  3172,
     520,  2332,  3205,  3189,  3206,  3358,   718,  3218,  3219,  3173,
     723,  3176,  3190,  3191,  3231,   899,   374, -1114,   374,   374,
     549,   464,   521,  3200,  3194,  3197,  3220,   373,   373,  3199,
     373,  3201,  3240,   522,  3202,  3203,  3204, -1114,  3246,   373,
    3282,  3207,  3249,  3283,  3251,   373,  3208,  3209,  3370,   656,
    3214,  3255,   985,  3210,   947,   373,  3211,  3296,  3212,  3213,
    2273,  3216,   523,   373,  3243,  3304,  3244,  3305,  3311,  3317,
     464, -1114,  3318,  3332,  3272,  3273,  3334,  3280,   549,   464,
     373,  3193,  3284,   464,  3299,  3363,  3364,   524,  3365,  3285,
     464,  3286,   373,   525,  3287,  3298,  3301,  3337,  3390,   373,
    3339,  3392,  3376,  3377,  3380,  3381,  3382,  3393,   373,  3394,
    3395,  3401,  2402,  3408, -1114,  2410,  3406,  3416,  3417,  2879,
     549,  3418,  3424,  3425,  3435,  3437,  3428, -1114, -1114,  3438,
     526,  3445,  3474,  3464,  3475,  3466,  -210,  3493,  3497,  3498,
    3505,  3499,  3516, -1170, -1114,  3522, -1114,  3523,  3524,  3534,
    3539,  3540,  3544,  3547,  3543,   656,  3548,  3414,  3549,  3554,
    3555,  3558,  3561,  3559,  3565, -1740,  3571,  3581,   656,  3589,
    3600,  3601, -1114, -1114,  3597,  3602,  1064,  2286,  3603, -1114,
    3608,  3607,   373,  3614,   549,  3616,  3297,   464,  3619,  3621,
    1083,   464,  3620,  3433,  3434,  3626,  3436,  3628,  3652,     1,
    3635,  3647,  2221,  3538,  3300,  3372,  2006,  3294,  3631,     2,
       3,  3654,  1073,  3636,  3578,  3529,  3579,  3537,  3183,  1563,
    1484,   496,     4,  3256,     5,  1973,   464,  3007,  1143,  2423,
    1977,  2403,  1931,  2926,  3274,  2983,  3471,  2346,  3472,  3473,
    2944,   527,     6,     7,  2922,  3114,  3155,  2945,     8,  3518,
    2886,  3147,     9,    10,  3407,  3411,  2923,  3271,   528,  3352,
    1577,  3303,  3279,  2393,   529,    11,  1895,  1833,  1562,  2242,
     530,  1084,  2570,  2238,  1465,  2261,  1061,   662,   990,  3319,
      12,   373,  3050,  3217,  1855,  3051,  1768,  2455,  3343,  3367,
    2894,  1763,  3254,  1616,   531,  2550,  3518,  3242,  3573,    13,
    2268,  1668,  1403,  1385,   373,   532,   533,  2248,    14,    15,
      16,  3069,  2234,  2905,  2865,  2864,  3596,  3467,   651,   373,
     724,    17,    18,  1582,  1141,  2858,   637,  3496,  3469,  3396,
    1793,  3439,  1405,  3422,  3610,  3151,  2868,  1419,  1865,  2890,
    2620,   534,  3083,  3245,    19,   584,   978,  1410,  3310,  2559,
    1378,  1567,  3316,   586,   982,  3215,  1735,   677,  1827,  1136,
      20,  2418,   373,  3004,     0,  3181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1292,     0,  1294,     0,
       0,   656,     0,   373,    21,   535,     0,   536,     0,     0,
       0,    22,     0,     0,    23,     0,     0,     0,     0,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
     464,     0,     0,     0,     0,    24,   464,   656,   656,     0,
     656,     0,     0,     0,     0,     0,     0,     0,   373,    25,
     373,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,   373,    26,     0,     0,
       0,     0,    27,  1379,     0,  1382,     0,   464,     0,     0,
     656,     0,   656,   656,     0,     0,     0,     0,  3175,   464,
     549,     0,     0,     0,     0,     0,     0,     0,     0,   464,
     464,     0,     0,     0,     0,  1498,  1499,     0,     0,     0,
    1411,     0,     0,   373,     0,     0,     0,     0,  1420,     0,
       0,     0,     0,  3422,     0,     0,     0,     0,     0,     0,
       0,     0,   374,   374,   464,   464,  -457,  -457,  1501,     0,
       0,   373,   374,     0,   549,  -457,     0,     0,     0,  1502,
     374,     0,     0,     0,     0,     0,     0,    28,  1503,     0,
     464,   373,     0,     0,     0,     0,   373,   373,     0,     0,
       0,     0,     0,     0,     0,  1505,     0,   517,    29,     0,
     373,     0,     0,     0,     0,    30,     0,     0,     0,     0,
    1065,     0,     0,  1506,     0,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,    31,   464,    32,    33,   464,
       0,    34,  3644,     0,    35,     0,    36,     0,     0,     0,
       0,    37,  1511,    38,     0,     0,     0,     0,  3593,     0,
       0,     0,    39,     0,     0,  3644,    40,   373,     0,     0,
       0,     0,    41,     0,     0,     0,     0,    42,   518,     0,
     373,    43,     0,     0,     0,     0,     0,     0,   549,     0,
     549,   374,   374,     0,   464,     0,     0,     0,     0,     0,
      44,     0,     0,   723,    45,  1585,   519,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     520,     0,     0,  3653,     0,  1514,     0,     0,     0,     0,
       0,     0,  1515,     0,     0,     0,     0,     0,    46,  1625,
       0,     0,   521,     0,     0,     0,     0,     0,   373,     0,
       0,     0,     0,   522,    47,     0,     0,    48,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1625,
       0,     0,   523,     0,     0,    50,     0,     0,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,  1516,     0,
       0,     0,     0,     0,     0,     0,    51,   524,     0,     0,
     373,   373,  1517,   525,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     373,     0,   373,     0,   373,     0,     0,  1728,     0,  3386,
       0,     0,     0,     0,     0,     0,     0,   373,     0,     0,
     526,     0,   549,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1519,     0,  1520,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   373,     0,     0,  1521,  1522,     0,  1523,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   549,     0,
       0,     0,     0,  1786,     0,   549,  3461,     0,     0,     0,
     549,   373,     0,     0,     0,  1525,   464,     0,  1796,     0,
       0,     0,     0,  1801,  1801,     0,  1801,     0,     0,   373,
       0,     0,  3461,  3461,   373,     0,     0,     0,   464,     0,
       0,   464,     0,     0,     0,     0,     0,   549,   549,   464,
     464,   527,     0,     0,     0,     0,     0,  1801,  1801,  1801,
       0,     0,   373,     0,     0,     0,     0,     0,   528,     0,
       0,     0,  3461,  3461,   529,  1868,     0,  3461,     0,     0,
     530,     0,     0,     0,  1879,     0,     0,     0,     0,     0,
       0,     0,  3461,     0,  3461,     0,  1526,     0,     0,     0,
       0,  1887,     0,     0,   531,  1527,   464,     0,     0,     0,
       0,  3461,     0,     0,     0,   532,   533,     0,  1897,     0,
    3461,     0,     0,   373,   464,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,  3461,     0,   373,  3461,
       0,     0,     0,     0,     0,     0,     0,  3461,     0,     0,
     373,   534,     0,     0,   373,     0,     0,     0,     0,  3461,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3461,     0,     0,     0,   373,     0,
     373,  3461,  1980,     0,  3461,     0,   373,     0,     0,     0,
       0,  1984,  3461,     0,     0,   535,     0,   536,  3461,     0,
       0,     0,     0,     0,     0,     0,     0,  3461,     0,  3461,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
    3461,  3461,  1498,  1499,  3461,     0,     0,   464,     0,     0,
    2024,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       2,     3,     0,     0,     0,  1501,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,  1502,     0,     0,     0,
       0,     0,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     8,
       0,     0,  1505,     9,    10,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    11,  1065,     0,     0,
    1506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    12,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1511,
      13,     0,     0,     0,   602,     0,   564,   603,     0,    14,
      15,    16,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    17,    18,     0,     0,     0,     0,   604,   605,
       0,     0,     0,     0,     0,     0,     0,     0,   606,     0,
     607,     0,     0,     0,     0,    19,     0,     0,     0,     0,
       0,     0,     0,  2191,     0,     0,     0,   608,   609,     0,
       0,    20,     0,     0,     0,     0,   610,     0,     0,     0,
       0,     0,  1514,     0,     0,     0,     0,     0,     0,  1515,
       0,     0,     0,     0,     0,    21,     0,     0,     0,     0,
     870,     0,    22,     0,     0,    23,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -1336,   611,     0,    24,     0,   612,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      25,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   949,     0,  1516,     0,   613,    26,   614,
       0,     0,     0,    27,  2255,     0,     0,     0,     0,  1517,
       0,   615,     0,   616,     0,     0,     0,     0,     0,     0,
       0,     0,  2274,  2276,     0,     0,     0,     0,     0,   549,
       0,   549,   549,     0,     0,     0,   617,   618,     0,     0,
     619,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   620,     0,     0,     0,     0,
    1519,     0,  1520,     0,     0,  1728,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   621,   549,   549,     0,
       0,   622,     0,  1521,  1522,     0,  1523,  1980,    28,     0,
       0,     0,     0,  1980,     0,     0,  1980,     0,     0,  1980,
       0,     0,     0,     0,     0,   623,     0,     0,     0,    29,
    1980,  1980,     0,   549,     0,     0,    30,     0,     0,  1980,
       0,  1092,  1525,     0,     0,     0,     0,     0,   464,     0,
     549,  3463,     0,     0,  1980,  2398,    31,   624,    32,    33,
       0,     0,    34,     0,     0,    35,   625,    36,     0,     0,
       0,     0,    37,     0,    38,     0,     0,  3463,  3463,     0,
       0,     0,     0,    39,   626,     0,     0,    40,     0,     0,
       0,     0,     0,    41,   464,  1980,     0,     0,    42,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,   627,
     628,     0,     0,     0,     0,     0,     0,  3463,  3463,     0,
     549,    44,  3463,  1526,     0,    45,     0,   549,     0,     0,
       0,     0,  1527,     0,     0,     0,     0,  3463,     0,  3463,
    2462,     0,  1207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3463,     0,     0,    46,
       0,     0,     0,     0,     0,  3463,     0,     0,     0,   629,
       0,     0,     0,     0,     0,    47,     0,     0,    48,   630,
       0,  3463,     0,    49,  3463,     0,  1625,     0,     0,     0,
       0,     0,  3463,     0,     0,     0,     0,     0,     0, -1765,
       0,     0,     0,   631,  3463,     0,    50,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   632,  1283,     0,  3463,
       0,  1290,     0,     0,     0,     0,  3463,    51,     0,  3463,
       0,     0,     0,     0,     0,     0,     0,  3463,     0,     0,
       0,     0,     0,  3463,     0,     0,     0,     0,     0,     0,
       0,     0,  3463,     0,  3463,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3463,  3463,     0,   549,  3463,
   -1765,     0,     0,     0,   633,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2558,
       0,     0,     0,  1796,     0,   947,   549,   549,   549,     0,
       0,     0,     0,     0,     0,     0,   464,     0,     0,     0,
     549,     0,     0,  1728,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   549,   549,   549,
       0,     0,     0,     0,     0,  1418,     0,     0,     0,     0,
    2601,     0,     0,     0,  1433,     0,  2603,     0,  2605,     0,
       0,     0,     0,     0,     0,     0,   549,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1980,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   549,     0,     0,
    1980,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   464,     0,     0,     0,     0,     0,     0,  2666,     0,
       0,   464,     0,     0,     0,  2722,  2723,     0,     0,  2726,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   464,
       0,     0,     0,     0,  1587,  1588,  1589,     0,     0,     0,
       0,     0,     0,  1604,  1605,     0,     0,  1608,     0,  1610,
    1611,  1612,  1613,     0,     0,     0,  1617,     0,     0,  1619,
    1620,     0,  1621,     0,  1622,  1623,     0,  1626,  1627,  1628,
    1629,  1630,     0,  1633,     0,  1635,  1636,  1637,     0,  1639,
    1640,  1641,  1642,     0,  1644,  1645,     0,  1651,     0,     0,
    1655,  1656,  1657,     0,  1659,  1660,  1661,  1662,     0,  1664,
    1665,  1666,  1667,     0,     0,     0,     0,     0,  1674,  1675,
       0,  1678,  1679,  1680,  1681,  1682,     0,     0,     0,     0,
    1686,     0,  1687,  1688,  1689,  1690,  1691,     0,     0,  1694,
    1696,  1697,  1698,  1699,  1700,     0,  1702,  1703,     0,     0,
    1706,  1707,  1708,     0,  1711,     0,  1712,     0,     0,     0,
    1715,     0,  1719,  1720,     0,     0,     0,     0,  1723,     0,
       0,     0,     0,     0,     0,     0,  1730,  1731,  1732,     0,
       0,     0,     0,     0,  1496,  1290,     0,     0,  1740,  2668,
    2669,  1497,     0,     0,     0,  2670,     0,  2671,  2672,  2673,
       0,  1498,  1499,  2255,  2869,     0,   549,     0,     0,     0,
       0,     0,     0,  2674,     0,   549,     0,     0,     0,     0,
       0,  2558,     0,     0,     0,     0,     0,     0,     0,     0,
    1500,   549,     0,     0,  1501,     0,     0,     0,     0,  1868,
       0,     0,     0,     0,     0,  1502,     0,  1784,     0,     0,
       0,     0,  2675,     0,  1503,  2676,  1728,     0,     0,  1504,
       0,     0,     0,  2677,     0,     0,     0,     0,  1980,     0,
       0,  1505,     0,     0,     0,  1980,     0,     0,     0,     0,
       0,     0,  2678,     0,  1980,     0,  1065,     0,     0,  1506,
       0,  1829,     0,     0,     0,     0,     0,     0,  1507,  2679,
       0,     0,     0,     0,  1509,     0,     0,     0,     0,     0,
       0,     0,  1510,     0,     0,     0,     0,     0,  1511,  2680,
       0,  2681,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2682,  2683,     0,  1512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3012,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2684,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1514,     0,     0,     0,     0,     0,     0,  1515,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2685,     0,
       0,     0,     0,     0,     0,     0,     0,  2686,  2687,     0,
    2688,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1985,     0,     0,     0,     0,     0,     0,     0,  2689,  2690,
    2691,     0,     0,     0,     0,     0,     0,  3047,     0,     0,
       0,     0,     0,     0,  1516,     0,     0,     0,  2692,  2693,
    2694,     0,     0,     0,  2695,     0,     0,  2696,  1517,     0,
    1728,     0,     0,  1518,     0,     0,     0,     0,     0,     0,
    2697,  2698,     0,     0,     0,   549,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2699,     0,  2700,     0,     0,
       0,     0,     0,  1480,     0,     0,     0,     0,     0,  1519,
       0,  1520,     0,     0,     0,     0,     0,     0,  3012,  2701,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1521,  1522,     0,  1523,     0,     0,     0,   549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1524,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   549,
       0,     0,  2702,     0,  2703,     0,     0,     0,     0,     0,
       0,  1525,     0,     0,  2704,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3165,     0,  3166,     0,     0,     0,
       0,     0,  2159,  2161,  2163,     0,   464,     0,     0,     0,
       0,     0,  3180,     0,     0,     0,     0,     0,     0,  2177,
       0,     0,     0,     0,     0,  2705,  2706,     0,     0,  2707,
    2708,  2709,  2710,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2274,
       0,     0,  1526,     0,     0,     0,     0,  2215,     0,     0,
       0,  1527,  2711,  2712,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   549,     0,     0,
       0,  2713,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3253,     0,     0,
       0,     0,  3012,  3012,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3270,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   549,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3295,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3012,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1984,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3180,     0,
       0,     0,     0,     0,  2436,     0,     0,  2437,     0,     0,
    2439,  2440,     0,     0,     0,     0,  1728,   464,     0,     0,
       0,     0,     0,  2453,     0,     0,  2456,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3253,     0,  3253,  2463,
    3405,  2464,     0,     0,     0,  2467,     0,  2468,  2469,     0,
       0,     0,  2472,  3412,  2473,  2474,     0,  2475,     0,     0,
    2476,     0,  2477,  2478,     0,     0,     0,     0,  2482,  2483,
       0,     0,  2485,     0,  2486,     0,  2487,     0,  2488,     0,
    2490,     0,     0,     0,     0,     0,     0,     0,     0,  3432,
       0,  2495,  2496,     0,     0,  2497,     0,  2498,     0,     0,
       0,     0,     0,     0,     0,  2499,  2500,     0,  2501,     0,
    2502,     0,     0,  2503,  2504,  2505,     0,  2506,     0,     0,
       0,     0,  2509,  2510,  2511,  2512,     0,  1728,     0,     0,
    2514,  2515,  2516,     0,  2517,     0,  2519,     0,  2521,     0,
    2523,     0,  2524,     0,     0,  3476,     0,     0,     0,  2526,
    3483,  2527,     0,     0,  2529,  2530,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3500,     0,
       0,     0,     0,     0,     0,  2548,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2566,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1728,
       0,     0,     0,     0,     0,  3575,     0,     0,     0,     0,
       0,     0,     0,     0,  3586,     0,  2610,     0,     0,     0,
       0,  2614,     0,     0,     0,     0,   549,     0,     0,     0,
    1728,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1728,     0,  3611,     0,     0,     0,
       0,     0,  3617,     0,  2645,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2648,     0,
       0,     0,     0,     0,     0,     0,  3645,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2743,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2825,     0,  2827,     0,  2829,     0,
       0,     0,     0,     0,  2835,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2846,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2891,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3018,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3022,     0,
       0,     0,     0,     0,  3023,     0,     0,     0,     0,     0,
       0,     0,     0,  3027,  3028,     0,     0,     0,     0,  3029,
       0,     0,     0,  3030,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3034,     0,     0,     0,
       0,     0,  3036,     0,     0,  3037,  3038,     0,  3039,  3040,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3045,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3096,  3097,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2645,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2610,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3306,     0,     0,     0,     0,     0,  3308,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3324,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3336,     0,  3338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2645,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3427,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3441,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3503,  3504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3525,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3536,     0,
       0,     0,     0,     0,  3542,     0,     0,     0,     0,     0,
       0,     0,     0,  3552,     0,     0,     0,     0,     0,     0,
     122,     0,   725,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   726,     0,   727,   130,   131,
     728,   133,     0,   134,   729,   135,  3590,   730,   136,   731,
     732,   733,   137,   734,     0,   138,   139,  1716,   140,     0,
     141,   142,     0,  3599,   143,   735,   144,     0,   145,   736,
     737,   147,     0,   148,   149,   150,   738,   151,     0,   739,
     153,     0,   154,   155,   156,   157,   158,   740,   741,   159,
       0,     0,   160,     0,   742,     0,   743,   744,   745,     0,
       0,   162,   746,   747,     0,   748,   749,     0,   163,   164,
     750,   751,   752,     0,  3646,     0,     0,   753,   167,   754,
       0,     0,   755,   756,   168,     0,   169,     0,     0,     0,
     757,   758,   170,     0,   171,   172,   173,     0,     0,     0,
     174,     0,     0,   175,   176,   177,     0,     0,   759,   178,
       0,   760,   761,   179,   180,   181,   182,     0,     0,   183,
       0,   184,   185,   186,   762,     0,   187,   763,   188,   764,
     765,   189,     0,   766,   190,   191,   192,   767,     0,   193,
       0,     0,   768,     0,   194,   195,     0,   769,   196,     0,
     197,   770,   771,   772,   773,     0,   774,   775,   199,   776,
     777,   778,   201,     0,   202,   779,     0,   780,   781,     0,
     203,   204,     0,   205,   782,     0,   206,     0,     0,     0,
     783,   208,   209,   210,   784,     0,   211,   212,     0,     0,
       0,   213,     0,     0,   785,   214,   786,     0,     0,   215,
       0,     0,   216,   217,     0,     0,     0,     0,     0,     0,
     218,   787,   219,     0,  1717,   788,   220,     0,   789,   221,
       0,     0,     0,   790,     0,   791,     0,   223,   792,     0,
     224,     0,   225,   793,     0,     0,   794,     0,     0,     0,
       0,   795,   226,   227,   228,   229,   230,   231,   796,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   797,   241,
     242,   243,   798,   244,   245,     0,     0,     0,   246,   247,
     799,   249,     0,     0,   800,   251,   801,   802,   252,     0,
     253,   803,   804,   805,   806,   807,   808,   809,   258,   259,
     260,   261,     0,   810,   262,   263,     0,   264,   265,   266,
     811,   812,   813,   267,     0,   814,   815,     0,   268,   269,
       0,   816,     0,   271,   272,   273,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   817,   818,
     277,   819,   820,   821,   822,   823,     0,   280,   281,     0,
     282,     0,   283,   284,     0,   824,   286,   287,   288,   289,
     290,   291,   292,   825,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,   299,   300,   826,
     827,   301,     0,   302,   303,   304,     0,   305,   306,     0,
       0,   828,   307,   308,   829,   309,   310,   830,   311,   831,
     313,   314,     0,   832,   316,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,   331,
     332,   833,   834,   333,   334,     0,   335,   835,   337,   836,
     837,   838,   338,   339,   839,   340,   341,     0,   342,   343,
       0,   654,   344,   840,   841,   842,   843,     0,     0,     0,
       0,  1718,   349,     0,   350,   844,   845,   846,   352,   353,
     354,     0,   847,   355,   356,   848,     0,   357,     0,     0,
     849,   850,   358,     0,     0,   359,     0,   360,     0,   851,
     362,     0,     0,   852,   853,   854,   855,   856,   363,     0,
       0,   364,   857,     0,   365,   366,   858,     0,     0,     0,
       0,   368,     0,   369,   370,     0,   859,     0,   860,     0,
       0,     0,     0,   861,     0,     0,     0,   862,   863,     0,
       0,     0,     0,   864,     0,   865,     0,     0,   866,   867,
       0,   868,   869,   122,     0,   725,   124,   125,   126,   127,
    2606,     0,     0,     0,     0,   128,     0,     0,   726,     0,
     727,   130,   131,   728,   133,     0,   134,   729,   135,     0,
    2607,   136,   731,   732,   733,   137,   734,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   735,   144,
       0,   145,   736,   737,   147,     0,   148,   149,   150,   738,
     151,     0,   739,   153,     0,   154,   155,   156,   157,   158,
     740,   741,   159,     0,     0,   160,     0,   742,     0,   743,
     744,   745,     0,     0,   162,   746,   747,     0,   748,   749,
       0,   163,   164,   750,   751,   752,     0,     0,     0,     0,
     753,   167,   754,     0,     0,   755,  2608,   168,     0,   169,
       0,     0,     0,   757,   758,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,   759,   178,     0,   760,   761,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,   762,     0,   187,
     763,   188,   764,   765,   189,     0,   766,   190,   191,   192,
     767,     0,   193,     0,     0,   768,     0,   194,   195,     0,
     769,   196,     0,   197,   770,   771,   772,   773,     0,   774,
     775,   199,   776,   777,   778,   201,     0,   202,   779,     0,
     780,   781,     0,   203,   204,     0,   205,   782,     0,   206,
       0,     0,     0,   783,   208,   209,   210,   784,     0,   211,
     212,     0,     0,     0,   213,     0,     0,   785,   214,   786,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,   787,   219,     0,     0,   788,   220,
       0,   789,   221,     0,     0,     0,   790,     0,   791,     0,
     223,   792,     0,   224,     0,   225,   793,     0,     0,   794,
       0,     0,     0,     0,   795,   226,   227,   228,   229,   230,
     231,   796,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   797,   241,   242,   243,   798,   244,   245,     0,     0,
       0,   246,   247,   799,   249,     0,     0,   800,   251,   801,
     802,   252,     0,   253,   803,   804,   805,   806,   807,   808,
     809,   258,   259,   260,   261,     0,   810,   262,   263,     0,
     264,   265,   266,   811,   812,   813,   267,     0,   814,   815,
       0,   268,   269,     0,   816,  2609,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   817,   818,   277,   819,   820,   821,   822,   823,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   824,   286,
     287,   288,   289,   290,   291,   292,   825,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,   826,   827,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,   828,   307,   308,   829,   309,   310,
     830,   311,   831,   313,   314,     0,   832,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,   833,   834,   333,   334,     0,   335,
     835,   337,   836,   837,   838,   338,   339,   839,   340,   341,
       0,   342,   343,     0,   654,   344,   840,   841,   842,   843,
       0,     0,     0,     0,     0,   349,     0,   350,   844,   845,
     846,   352,   353,   354,     0,   847,   355,   356,   848,     0,
     357,     0,     0,   849,   850,   358,     0,     0,   359,     0,
     360,     0,   851,   362,     0,     0,   852,   853,   854,   855,
     856,   363,     0,     0,   364,   857,     0,   365,   366,   858,
       0,     0,     0,     0,   368,     0,   369,   370,     0,   859,
       0,   860,     0,     0,     0,     0,   861,     0,     0,     0,
     862,   863,     0,     0,     0,     0,   864,     0,   865,     0,
       0,   866,   867,     0,   868,   869,   122,     0,   725,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   726,     0,   727,   130,   131,   728,   133,     0,   134,
     729,   135,     0,   730,   136,   731,   732,   733,   137,   734,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   735,   144,     0,   145,   736,   737,   147,     0,   148,
     149,   150,   738,   151,     0,   739,   153,     0,   154,   155,
     156,   157,   158,   740,   741,   159,     0,     0,   160,     0,
     742,     0,   743,   744,   745,     0,     0,   162,   746,   747,
       0,   748,   749,     0,   163,   164,   750,   751,   752,     0,
       0,     0,     0,   753,   167,   754,     0,     0,   755,   756,
     168,     0,   169,     0,     0,     0,   757,   758,   170,     0,
     171,   172,   173,     0,     0,     0,   174,     0,     0,   175,
     176,   177,     0,     0,   759,   178,     0,   760,   761,   179,
     180,   181,   182,     0,     0,   183,     0,   184,   185,   186,
     762,     0,   187,   763,   188,   764,   765,   189,     0,   766,
     190,   191,   192,   767,     0,   193,     0,     0,   768,     0,
     194,   195,     0,   769,   196,     0,   197,   770,   771,   772,
     773,     0,   774,   775,   199,   776,   777,   778,   201,     0,
     202,   779,     0,   780,   781,     0,   203,   204,     0,   205,
     782,     0,   206,     0,     0,     0,   783,   208,   209,   210,
     784,     0,   211,   212,     0,     0,     0,   213,     0,     0,
     785,   214,   786,     0,     0,   215,     0,     0,   216,   217,
       0,     0,     0,     0,     0,     0,   218,   787,   219,     0,
       0,   788,   220,     0,   789,   221,     0,     0,     0,   790,
       0,   791,     0,   223,   792,     0,   224,     0,   225,   793,
       0,     0,   794,     0,     0,     0,     0,   795,   226,   227,
     228,   229,   230,   231,   796,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   797,   241,   242,   243,   798,   244,
     245,     0,     0,     0,   246,   247,   799,   249,     0,     0,
     800,   251,   801,   802,   252,     0,   253,   803,   804,   805,
     806,   807,   808,   809,   258,   259,   260,   261,     0,   810,
     262,   263,     0,   264,   265,   266,   811,   812,   813,   267,
       0,   814,   815,     0,   268,   269,     0,   816,     0,   271,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   817,   818,   277,   819,   820,   821,
     822,   823,     0,   280,   281,     0,   282,     0,   283,   284,
       0,   824,   286,   287,   288,   289,   290,   291,   292,   825,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,   299,   300,   826,   827,   301,     0,   302,
     303,   304,     0,   305,   306,     0,     0,   828,   307,   308,
     829,   309,   310,   830,   311,   831,   313,   314,     0,   832,
     316,  1288,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,   331,   332,   833,   834,   333,
     334,     0,   335,   835,   337,   836,   837,   838,   338,   339,
     839,   340,   341,     0,   342,   343,     0,   654,   344,   840,
     841,   842,   843,     0,     0,     0,     0,     0,   349,     0,
     350,   844,   845,   846,   352,   353,   354,     0,   847,   355,
     356,   848,     0,   357,     0,     0,   849,   850,   358,     0,
       0,   359,     0,   360,     0,   851,   362,     0,     0,   852,
     853,   854,   855,   856,   363,     0,     0,   364,   857,     0,
     365,   366,   858,     0,     0,     0,     0,   368,     0,   369,
     370,     0,   859,     0,   860,     0,     0,     0,     0,   861,
       0,     0,     0,   862,   863,     0,     0,     0,     0,   864,
       0,  1289,     0,     0,   866,   867,     0,   868,   869,   122,
       0,   725,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   726,     0,   727,   130,   131,   728,
     133,     0,   134,   729,   135,     0,   730,   136,   731,   732,
     733,   137,   734,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   735,   144,     0,   145,   736,   737,
     147,     0,   148,   149,   150,   738,   151,     0,   739,   153,
       0,   154,   155,   156,   157,   158,   740,   741,   159,     0,
       0,   160,     0,   742,     0,   743,   744,   745,     0,     0,
     162,   746,   747,     0,   748,   749,     0,   163,   164,   750,
     751,   752,     0,     0,     0,     0,   753,   167,   754,     0,
       0,   755,   756,   168,     0,   169,     0,     0,     0,   757,
     758,   170,     0,   171,   172,   173,     0,     0,     0,   174,
       0,     0,   175,   176,   177,     0,     0,   759,   178,     0,
     760,   761,   179,   180,   181,   182,     0,     0,   183,     0,
     184,   185,   186,   762,     0,   187,   763,   188,   764,   765,
     189,     0,   766,   190,   191,   192,   767,     0,   193,     0,
       0,   768,     0,   194,   195,     0,   769,   196,     0,   197,
     770,   771,   772,   773,     0,   774,   775,   199,   776,   777,
     778,   201,     0,   202,   779,     0,   780,   781,     0,   203,
     204,     0,   205,   782,     0,   206,     0,     0,     0,   783,
     208,   209,   210,   784,     0,   211,   212,     0,     0,     0,
     213,     0,     0,   785,   214,   786,     0,     0,   215,     0,
       0,   216,   217,     0,     0,     0,     0,     0,     0,   218,
     787,   219,     0,     0,   788,   220,     0,   789,   221,     0,
       0,     0,   790,     0,   791,     0,   223,   792,     0,   224,
       0,   225,   793,     0,     0,   794,     0,     0,     0,     0,
     795,   226,   227,   228,   229,   230,   231,   796,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   797,   241,   242,
     243,   798,   244,   245,     0,     0,     0,   246,   247,   799,
     249,     0,     0,   800,   251,   801,   802,   252,     0,   253,
     803,   804,   805,   806,   807,   808,   809,   258,   259,   260,
     261,     0,   810,   262,   263,     0,   264,   265,   266,   811,
     812,   813,   267,     0,   814,   815,     0,   268,   269,     0,
     816,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   274,   275,   817,   818,   277,
     819,   820,   821,   822,   823,     0,   280,   281,     0,   282,
       0,   283,   284,     0,   824,   286,   287,   288,   289,   290,
     291,   292,   825,     0,     0,     0,   293,   294,     0,     0,
     295,   296,   297,     0,   298,     0,   299,   300,   826,   827,
     301,     0,   302,   303,   304,     0,   305,   306,     0,     0,
     828,   307,   308,   829,   309,   310,   830,   311,   831,   313,
     314,     0,   832,   316,     0,     0,     0,   317,   318,   319,
       0,     0,   320,     0,     0,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,     0,     0,   327,
     328,     0,   329,     0,     0,   330,     0,     0,   331,   332,
     833,   834,   333,   334,     0,   335,   835,   337,   836,   837,
     838,   338,   339,   839,   340,   341,     0,   342,   343,     0,
     654,   344,   840,   841,   842,   843,     0,     0,     0,     0,
       0,   349,     0,   350,   844,   845,   846,   352,   353,   354,
       0,   847,   355,   356,   848,     0,   357,     0,     0,   849,
     850,   358,     0,     0,   359,     0,   360,     0,   851,   362,
       0,     0,   852,   853,   854,   855,   856,   363,     0,     0,
     364,   857,     0,   365,   366,   858,     0,     0,     0,     0,
     368,     0,   369,   370,     0,   859,     0,   860,     0,     0,
       0,     0,   861,     0,     0,     0,   862,   863,     0,     0,
       0,     0,   864,     0,   865,  1564,     0,   866,   867,     0,
     868,   869,   122,     0,   725,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   726,     0,   727,
     130,   131,   728,   133,     0,   134,   729,   135,     0,   730,
     136,   731,   732,   733,   137,   734,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   735,   144,     0,
     145,   736,   737,   147,     0,   148,   149,   150,   738,   151,
       0,   739,   153,     0,   154,   155,   156,   157,   158,   740,
     741,   159,     0,     0,   160,     0,   742,     0,   743,   744,
     745,     0,     0,   162,   746,   747,     0,   748,   749,     0,
     163,   164,   750,   751,   752,     0,     0,     0,     0,   753,
     167,   754,     0,     0,   755,   756,   168,     0,   169,     0,
       0,     0,   757,   758,   170,     0,   171,   172,   173,     0,
       0,     0,   174,     0,     0,   175,   176,   177,     0,     0,
     759,   178,     0,   760,   761,   179,   180,   181,   182,     0,
       0,   183,     0,   184,   185,   186,   762,     0,   187,   763,
     188,   764,   765,   189,     0,   766,   190,   191,   192,   767,
       0,   193,     0,     0,   768,     0,   194,   195,     0,   769,
     196,     0,   197,   770,   771,   772,   773,     0,   774,   775,
     199,   776,   777,   778,   201,     0,   202,   779,     0,   780,
     781,     0,   203,   204,     0,   205,   782,     0,   206,     0,
       0,     0,   783,   208,   209,   210,   784,     0,   211,   212,
       0,     0,     0,   213,     0,     0,   785,   214,   786,     0,
       0,   215,     0,     0,   216,   217,     0,     0,     0,     0,
       0,     0,   218,   787,   219,     0,     0,   788,   220,     0,
     789,   221,     0,     0,     0,   790,     0,   791,     0,   223,
     792,     0,   224,     0,   225,   793,     0,     0,   794,     0,
       0,     0,     0,   795,   226,   227,   228,   229,   230,   231,
     796,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     797,   241,   242,   243,   798,   244,   245,     0,     0,     0,
     246,   247,   799,   249,     0,     0,   800,   251,   801,   802,
     252,     0,   253,   803,   804,   805,   806,   807,   808,   809,
     258,   259,   260,   261,     0,   810,   262,   263,     0,   264,
     265,   266,   811,   812,   813,   267,     0,   814,   815,     0,
     268,   269,     0,   816,     0,   271,   272,   273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     817,   818,   277,   819,   820,   821,   822,   823,     0,   280,
     281,     0,   282,     0,   283,   284,     0,   824,   286,   287,
     288,   289,   290,   291,   292,   825,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,   299,
     300,   826,   827,   301,     0,   302,   303,   304,     0,   305,
     306,     0,     0,   828,   307,   308,   829,   309,   310,   830,
     311,   831,   313,   314,     0,   832,   316,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,   331,   332,   833,   834,   333,   334,     0,   335,   835,
     337,   836,   837,   838,   338,   339,   839,   340,   341,     0,
     342,   343,     0,   654,   344,   840,   841,   842,   843,     0,
       0,     0,     0,     0,   349,     0,   350,   844,   845,   846,
     352,   353,   354,     0,   847,   355,   356,   848,     0,   357,
       0,     0,   849,   850,   358,     0,     0,   359,     0,   360,
       0,   851,   362,     0,     0,   852,   853,   854,   855,   856,
     363,     0,     0,   364,   857,     0,   365,   366,   858,     0,
       0,     0,     0,   368,     0,   369,   370,     0,   859,     0,
     860,     0,     0,     0,     0,   861,     0,     0,     0,   862,
     863,     0,     0,     0,     0,   864,     0,   865,  1658,     0,
     866,   867,     0,   868,   869,   122,     0,   725,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     726,     0,   727,   130,   131,   728,   133,     0,   134,   729,
     135,     0,   730,   136,   731,   732,   733,   137,   734,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     735,   144,     0,   145,   736,   737,   147,     0,   148,   149,
     150,   738,   151,     0,   739,   153,     0,   154,   155,   156,
     157,   158,   740,   741,   159,     0,     0,   160,     0,   742,
       0,   743,   744,   745,     0,     0,   162,   746,   747,     0,
     748,   749,     0,   163,   164,   750,   751,   752,     0,     0,
       0,     0,   753,   167,   754,     0,     0,   755,   756,   168,
       0,   169,     0,     0,     0,   757,   758,   170,     0,   171,
     172,   173,     0,     0,     0,   174,     0,     0,   175,   176,
     177,     0,     0,   759,   178,     0,   760,   761,   179,   180,
     181,   182,     0,     0,   183,     0,   184,   185,   186,   762,
       0,   187,   763,   188,   764,   765,   189,     0,   766,   190,
     191,   192,   767,     0,   193,     0,     0,   768,     0,   194,
     195,     0,   769,   196,     0,   197,   770,   771,   772,   773,
       0,   774,   775,   199,   776,   777,   778,   201,     0,   202,
     779,     0,   780,   781,     0,   203,   204,     0,   205,   782,
       0,   206,     0,     0,     0,   783,   208,   209,   210,   784,
       0,   211,   212,     0,     0,     0,   213,     0,     0,   785,
     214,   786,     0,     0,   215,     0,     0,   216,   217,     0,
       0,     0,     0,     0,     0,   218,   787,   219,     0,     0,
     788,   220,     0,   789,   221,     0,     0,     0,   790,     0,
     791,     0,   223,   792,     0,   224,     0,   225,   793,     0,
       0,   794,     0,     0,     0,     0,   795,   226,   227,   228,
     229,   230,   231,   796,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   797,   241,   242,   243,   798,   244,   245,
       0,     0,     0,   246,   247,   799,   249,     0,     0,   800,
     251,   801,   802,   252,     0,   253,   803,   804,   805,   806,
     807,   808,   809,   258,   259,   260,   261,     0,   810,   262,
     263,     0,   264,   265,   266,   811,   812,   813,   267,     0,
     814,   815,     0,   268,   269,     0,   816,     0,   271,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   274,   275,   817,   818,   277,   819,   820,   821,   822,
     823,     0,   280,   281,     0,   282,     0,   283,   284,     0,
     824,   286,   287,   288,   289,   290,   291,   292,   825,     0,
       0,     0,   293,   294,     0,     0,   295,   296,   297,     0,
     298,     0,   299,   300,   826,   827,   301,     0,   302,   303,
     304,     0,   305,   306,     0,     0,   828,   307,   308,   829,
     309,   310,   830,   311,   831,   313,   314,     0,   832,   316,
       0,     0,     0,   317,   318,   319,     0,     0,   320,     0,
       0,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,     0,     0,   327,   328,     0,   329,     0,
       0,   330,     0,     0,   331,   332,   833,   834,   333,   334,
       0,   335,   835,   337,   836,   837,   838,   338,   339,   839,
     340,   341,     0,   342,   343,     0,   654,   344,   840,   841,
     842,   843,     0,     0,     0,     0,     0,   349,     0,   350,
     844,   845,   846,   352,   353,   354,     0,   847,   355,   356,
     848,     0,   357,     0,     0,   849,   850,   358,     0,     0,
     359,     0,   360,     0,   851,   362,     0,     0,   852,   853,
     854,   855,   856,   363,     0,     0,   364,   857,     0,   365,
     366,   858,     0,     0,     0,     0,   368,     0,   369,   370,
       0,   859,     0,   860,     0,     0,     0,     0,   861,     0,
       0,     0,   862,   863,     0,     0,     0,     0,   864,     0,
     865,  1695,     0,   866,   867,     0,   868,   869,   122,     0,
     725,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   726,     0,   727,   130,   131,   728,   133,
       0,   134,   729,   135,     0,   730,   136,   731,   732,   733,
     137,   734,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   735,   144,     0,   145,   736,   737,   147,
       0,   148,   149,   150,   738,   151,     0,   739,   153,     0,
     154,   155,   156,   157,   158,   740,   741,   159,     0,     0,
     160,     0,   742,     0,   743,   744,   745,     0,     0,   162,
     746,   747,     0,   748,   749,     0,   163,   164,   750,   751,
     752,     0,     0,     0,     0,   753,   167,   754,     0,     0,
     755,   756,   168,     0,   169,     0,     0,     0,   757,   758,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,   759,   178,     0,   760,
     761,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,   762,     0,   187,   763,   188,   764,   765,   189,
       0,   766,   190,   191,   192,   767,     0,   193,     0,     0,
     768,     0,   194,   195,     0,   769,   196,     0,   197,   770,
     771,   772,   773,     0,   774,   775,   199,   776,   777,   778,
     201,     0,   202,   779,     0,   780,   781,     0,   203,   204,
       0,   205,   782,     0,   206,     0,     0,     0,   783,   208,
     209,   210,   784,     0,   211,   212,     0,     0,     0,   213,
       0,     0,   785,   214,   786,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,   787,
     219,     0,     0,   788,   220,     0,   789,   221,     0,     0,
       0,   790,     0,   791,     0,   223,   792,     0,   224,     0,
     225,   793,     0,     0,   794,     0,     0,     0,     0,   795,
     226,   227,   228,   229,   230,   231,   796,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   797,   241,   242,   243,
     798,   244,   245,     0,     0,     0,   246,   247,   799,   249,
       0,     0,   800,   251,   801,   802,   252,     0,   253,   803,
     804,   805,   806,   807,   808,   809,   258,   259,   260,   261,
       0,   810,   262,   263,     0,   264,   265,   266,   811,   812,
     813,   267,     0,   814,   815,     0,   268,   269,     0,   816,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   817,   818,   277,   819,
     820,   821,   822,   823,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   824,   286,   287,   288,   289,   290,   291,
     292,   825,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,   826,   827,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,   828,
     307,   308,   829,   309,   310,   830,   311,   831,   313,   314,
       0,   832,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,   833,
     834,   333,   334,     0,   335,   835,   337,   836,   837,   838,
     338,   339,   839,   340,   341,     0,   342,   343,     0,   654,
     344,   840,   841,   842,   843,     0,     0,     0,     0,     0,
     349,     0,   350,   844,   845,   846,   352,   353,   354,     0,
     847,   355,   356,   848,     0,   357,     0,     0,   849,   850,
     358,     0,     0,   359,     0,   360,     0,   851,   362,     0,
       0,   852,   853,   854,   855,   856,   363,     0,     0,   364,
     857,     0,   365,   366,   858,     0,     0,     0,     0,   368,
       0,   369,   370,     0,   859,     0,   860,     0,     0,     0,
       0,   861,     0,     0,     0,   862,   863,     0,     0,     0,
       0,   864,     0,   865,  1722,     0,   866,   867,     0,   868,
     869,   122,     0,   725,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   726,     0,   727,   130,
     131,   728,   133,     0,   134,   729,   135,     0,   730,   136,
     731,   732,   733,   137,   734,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   735,   144,     0,   145,
     736,   737,   147,     0,   148,   149,   150,   738,   151,     0,
     739,   153,     0,   154,   155,   156,   157,   158,   740,   741,
     159,     0,     0,   160,     0,   742,     0,   743,   744,   745,
       0,     0,   162,   746,   747,     0,   748,   749,     0,   163,
     164,   750,   751,   752,     0,     0,     0,     0,   753,   167,
     754,     0,     0,   755,   756,   168,     0,   169,     0,     0,
       0,   757,   758,   170,     0,   171,   172,   173,     0,     0,
       0,   174,     0,     0,   175,   176,   177,     0,     0,   759,
     178,     0,   760,   761,   179,   180,   181,   182,     0,     0,
     183,     0,   184,   185,   186,   762,     0,   187,   763,   188,
     764,   765,   189,     0,   766,   190,   191,   192,   767,     0,
     193,     0,     0,   768,     0,   194,   195,  2158,   769,   196,
       0,   197,   770,   771,   772,   773,     0,   774,   775,   199,
     776,   777,   778,   201,     0,   202,   779,     0,   780,   781,
       0,   203,   204,     0,   205,   782,     0,   206,     0,     0,
       0,   783,   208,   209,   210,   784,     0,   211,   212,     0,
       0,     0,   213,     0,     0,   785,   214,   786,     0,     0,
     215,     0,     0,   216,   217,     0,     0,     0,     0,     0,
       0,   218,   787,   219,     0,     0,   788,   220,     0,   789,
     221,     0,     0,     0,   790,     0,   791,     0,   223,   792,
       0,   224,     0,   225,   793,     0,     0,   794,     0,     0,
       0,     0,   795,   226,   227,   228,   229,   230,   231,   796,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   797,
     241,   242,   243,   798,   244,   245,     0,     0,     0,   246,
     247,   799,   249,     0,     0,   800,   251,   801,   802,   252,
       0,   253,   803,   804,   805,   806,   807,   808,   809,   258,
     259,   260,   261,     0,   810,   262,   263,     0,   264,   265,
     266,   811,   812,   813,   267,     0,   814,   815,     0,   268,
     269,     0,   816,     0,   271,   272,   273,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   274,   275,   817,
     818,   277,   819,   820,   821,   822,   823,     0,   280,   281,
       0,   282,     0,   283,   284,     0,   824,   286,   287,   288,
     289,   290,   291,   292,   825,     0,     0,     0,   293,   294,
       0,     0,   295,   296,   297,     0,   298,     0,   299,   300,
     826,   827,   301,     0,   302,   303,   304,     0,   305,   306,
       0,     0,   828,   307,   308,   829,   309,   310,   830,   311,
     831,   313,   314,     0,   832,   316,     0,     0,     0,   317,
     318,   319,     0,     0,   320,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,     0,
       0,   327,   328,     0,   329,     0,     0,   330,     0,     0,
     331,   332,   833,   834,   333,   334,     0,   335,   835,   337,
     836,   837,   838,   338,   339,   839,   340,   341,     0,   342,
     343,     0,   654,   344,   840,   841,   842,   843,     0,     0,
       0,     0,     0,   349,     0,   350,   844,   845,   846,   352,
     353,   354,     0,   847,   355,   356,   848,     0,   357,     0,
       0,   849,   850,   358,     0,     0,   359,     0,   360,     0,
     851,   362,     0,     0,   852,   853,   854,   855,   856,   363,
       0,     0,   364,   857,     0,   365,   366,   858,     0,     0,
       0,     0,   368,     0,   369,   370,     0,   859,     0,   860,
       0,     0,     0,     0,   861,     0,     0,     0,   862,   863,
       0,     0,     0,     0,   864,     0,   865,     0,     0,   866,
     867,     0,   868,   869,   122,     0,   725,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   726,
       0,   727,   130,   131,   728,   133,     0,   134,   729,   135,
       0,   730,   136,   731,   732,   733,   137,   734,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   735,
     144,     0,   145,   736,   737,   147,     0,   148,   149,   150,
     738,   151,     0,   739,   153,     0,   154,   155,   156,   157,
     158,   740,   741,   159,     0,     0,   160,     0,   742,     0,
     743,   744,   745,     0,     0,   162,   746,   747,     0,   748,
     749,     0,   163,   164,   750,   751,   752,     0,     0,     0,
       0,   753,   167,   754,     0,     0,   755,   756,   168,     0,
     169,     0,     0,     0,   757,   758,   170,     0,   171,   172,
     173,     0,     0,     0,   174,     0,     0,   175,   176,   177,
       0,     0,   759,   178,     0,   760,   761,   179,   180,   181,
     182,     0,     0,   183,     0,   184,   185,   186,   762,     0,
     187,   763,   188,   764,   765,   189,     0,   766,   190,   191,
     192,   767,     0,   193,     0,     0,   768,     0,   194,   195,
    2160,   769,   196,     0,   197,   770,   771,   772,   773,     0,
     774,   775,   199,   776,   777,   778,   201,     0,   202,   779,
       0,   780,   781,     0,   203,   204,     0,   205,   782,     0,
     206,     0,     0,     0,   783,   208,   209,   210,   784,     0,
     211,   212,     0,     0,     0,   213,     0,     0,   785,   214,
     786,     0,     0,   215,     0,     0,   216,   217,     0,     0,
       0,     0,     0,     0,   218,   787,   219,     0,     0,   788,
     220,     0,   789,   221,     0,     0,     0,   790,     0,   791,
       0,   223,   792,     0,   224,     0,   225,   793,     0,     0,
     794,     0,     0,     0,     0,   795,   226,   227,   228,   229,
     230,   231,   796,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   797,   241,   242,   243,   798,   244,   245,     0,
       0,     0,   246,   247,   799,   249,     0,     0,   800,   251,
     801,   802,   252,     0,   253,   803,   804,   805,   806,   807,
     808,   809,   258,   259,   260,   261,     0,   810,   262,   263,
       0,   264,   265,   266,   811,   812,   813,   267,     0,   814,
     815,     0,   268,   269,     0,   816,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   817,   818,   277,   819,   820,   821,   822,   823,
       0,   280,   281,     0,   282,     0,   283,   284,     0,   824,
     286,   287,   288,   289,   290,   291,   292,   825,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,   299,   300,   826,   827,   301,     0,   302,   303,   304,
       0,   305,   306,     0,     0,   828,   307,   308,   829,   309,
     310,   830,   311,   831,   313,   314,     0,   832,   316,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,     0,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,   331,   332,   833,   834,   333,   334,     0,
     335,   835,   337,   836,   837,   838,   338,   339,   839,   340,
     341,     0,   342,   343,     0,   654,   344,   840,   841,   842,
     843,     0,     0,     0,     0,     0,   349,     0,   350,   844,
     845,   846,   352,   353,   354,     0,   847,   355,   356,   848,
       0,   357,     0,     0,   849,   850,   358,     0,     0,   359,
       0,   360,     0,   851,   362,     0,     0,   852,   853,   854,
     855,   856,   363,     0,     0,   364,   857,     0,   365,   366,
     858,     0,     0,     0,     0,   368,     0,   369,   370,     0,
     859,     0,   860,     0,     0,     0,     0,   861,     0,     0,
       0,   862,   863,     0,     0,     0,     0,   864,     0,   865,
       0,     0,   866,   867,     0,   868,   869,   122,     0,   725,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   726,     0,   727,   130,   131,   728,   133,     0,
     134,   729,   135,     0,   730,   136,   731,   732,   733,   137,
     734,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   735,   144,     0,   145,   736,   737,   147,     0,
     148,   149,   150,   738,   151,     0,   739,   153,     0,   154,
     155,   156,   157,   158,   740,   741,   159,     0,     0,   160,
       0,   742,     0,   743,   744,   745,     0,     0,   162,   746,
     747,     0,   748,   749,     0,   163,   164,   750,   751,   752,
       0,     0,     0,     0,   753,   167,   754,     0,     0,   755,
     756,   168,     0,   169,     0,     0,     0,   757,   758,   170,
       0,   171,   172,   173,     0,     0,     0,   174,     0,     0,
     175,   176,   177,     0,     0,   759,   178,     0,   760,   761,
     179,   180,   181,   182,     0,     0,   183,     0,   184,   185,
     186,   762,     0,   187,   763,   188,   764,   765,   189,     0,
     766,   190,   191,   192,   767,     0,   193,     0,     0,   768,
       0,   194,   195,  2162,   769,   196,     0,   197,   770,   771,
     772,   773,     0,   774,   775,   199,   776,   777,   778,   201,
       0,   202,   779,     0,   780,   781,     0,   203,   204,     0,
     205,   782,     0,   206,     0,     0,     0,   783,   208,   209,
     210,   784,     0,   211,   212,     0,     0,     0,   213,     0,
       0,   785,   214,   786,     0,     0,   215,     0,     0,   216,
     217,     0,     0,     0,     0,     0,     0,   218,   787,   219,
       0,     0,   788,   220,     0,   789,   221,     0,     0,     0,
     790,     0,   791,     0,   223,   792,     0,   224,     0,   225,
     793,     0,     0,   794,     0,     0,     0,     0,   795,   226,
     227,   228,   229,   230,   231,   796,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   797,   241,   242,   243,   798,
     244,   245,     0,     0,     0,   246,   247,   799,   249,     0,
       0,   800,   251,   801,   802,   252,     0,   253,   803,   804,
     805,   806,   807,   808,   809,   258,   259,   260,   261,     0,
     810,   262,   263,     0,   264,   265,   266,   811,   812,   813,
     267,     0,   814,   815,     0,   268,   269,     0,   816,     0,
     271,   272,   273,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   274,   275,   817,   818,   277,   819,   820,
     821,   822,   823,     0,   280,   281,     0,   282,     0,   283,
     284,     0,   824,   286,   287,   288,   289,   290,   291,   292,
     825,     0,     0,     0,   293,   294,     0,     0,   295,   296,
     297,     0,   298,     0,   299,   300,   826,   827,   301,     0,
     302,   303,   304,     0,   305,   306,     0,     0,   828,   307,
     308,   829,   309,   310,   830,   311,   831,   313,   314,     0,
     832,   316,     0,     0,     0,   317,   318,   319,     0,     0,
     320,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,     0,     0,   327,   328,     0,
     329,     0,     0,   330,     0,     0,   331,   332,   833,   834,
     333,   334,     0,   335,   835,   337,   836,   837,   838,   338,
     339,   839,   340,   341,     0,   342,   343,     0,   654,   344,
     840,   841,   842,   843,     0,     0,     0,     0,     0,   349,
       0,   350,   844,   845,   846,   352,   353,   354,     0,   847,
     355,   356,   848,     0,   357,     0,     0,   849,   850,   358,
       0,     0,   359,     0,   360,     0,   851,   362,     0,     0,
     852,   853,   854,   855,   856,   363,     0,     0,   364,   857,
       0,   365,   366,   858,     0,     0,     0,     0,   368,     0,
     369,   370,     0,   859,     0,   860,     0,     0,     0,     0,
     861,     0,     0,     0,   862,   863,     0,     0,     0,     0,
     864,     0,   865,     0,     0,   866,   867,     0,   868,   869,
     122,     0,   725,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   726,     0,   727,   130,   131,
     728,   133,     0,   134,   729,   135,     0,   730,   136,   731,
     732,   733,   137,   734,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   735,   144,     0,   145,   736,
     737,   147,     0,   148,   149,   150,   738,   151,     0,   739,
     153,     0,   154,   155,   156,   157,   158,   740,   741,   159,
       0,     0,   160,     0,   742,     0,   743,   744,   745,     0,
       0,   162,   746,   747,     0,   748,   749,     0,   163,   164,
     750,   751,   752,     0,     0,     0,     0,   753,   167,   754,
       0,     0,   755,   756,   168,     0,   169,     0,     0,     0,
     757,   758,   170,     0,   171,   172,   173,     0,     0,     0,
     174,     0,     0,   175,   176,   177,     0,     0,   759,   178,
       0,   760,   761,   179,   180,   181,   182,     0,     0,   183,
       0,   184,   185,   186,   762,     0,   187,   763,   188,   764,
     765,   189,     0,   766,   190,   191,   192,   767,     0,   193,
       0,     0,   768,     0,   194,   195,     0,   769,   196,     0,
     197,   770,   771,   772,   773,     0,   774,   775,   199,   776,
     777,   778,   201,     0,   202,   779,     0,   780,   781,     0,
     203,   204,     0,   205,   782,     0,   206,     0,     0,     0,
     783,   208,   209,   210,   784,     0,   211,   212,     0,     0,
       0,   213,     0,     0,   785,   214,   786,     0,     0,   215,
       0,     0,   216,   217,     0,     0,     0,     0,     0,     0,
     218,   787,   219,     0,     0,   788,   220,     0,   789,   221,
       0,     0,     0,   790,     0,   791,     0,   223,   792,     0,
     224,     0,   225,   793,     0,     0,   794,     0,     0,     0,
       0,   795,   226,   227,   228,   229,   230,   231,   796,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   797,   241,
     242,   243,   798,   244,   245,     0,     0,     0,   246,   247,
     799,   249,     0,     0,   800,   251,   801,   802,   252,     0,
     253,   803,   804,   805,   806,   807,   808,   809,   258,   259,
     260,   261,     0,   810,   262,   263,     0,   264,   265,   266,
     811,   812,   813,   267,     0,   814,   815,     0,   268,   269,
       0,   816,     0,   271,   272,   273,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   817,   818,
     277,   819,   820,   821,   822,   823,     0,   280,   281,     0,
     282,     0,   283,   284,     0,   824,   286,   287,   288,   289,
     290,   291,   292,   825,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,   299,   300,   826,
     827,   301,     0,   302,   303,   304,     0,   305,   306,     0,
       0,   828,   307,   308,   829,   309,   310,   830,   311,   831,
     313,   314,     0,   832,   316,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,   331,
     332,   833,   834,   333,   334,     0,   335,   835,   337,   836,
     837,   838,   338,   339,   839,   340,   341,     0,   342,   343,
       0,   654,   344,   840,   841,   842,   843,     0,     0,     0,
       0,     0,   349,     0,   350,   844,   845,   846,   352,   353,
     354,     0,   847,   355,   356,   848,     0,   357,     0,     0,
     849,   850,   358,     0,     0,   359,     0,   360,     0,   851,
     362,     0,     0,   852,   853,   854,   855,   856,   363,     0,
       0,   364,   857,     0,   365,   366,   858,     0,     0,     0,
       0,   368,     0,   369,   370,     0,   859,     0,   860,     0,
       0,     0,     0,   861,     0,     0,     0,   862,   863,     0,
       0,     0,     0,   864,     0,   865,     0,     0,   866,   867,
       0,   868,   869,   122,     0,   725,   124,   125,   126,   127,
    1754,     0,     0,     0,     0,  1755,     0,     0,   726,     0,
     727,   130,   131,   728,   133,     0,   134,   729,   135,     0,
     730,   136,   731,   732,   733,   137,   734,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   735,   144,
       0,   145,   736,   737,   147,     0,   148,   149,   150,   738,
     151,     0,   739,   153,     0,   154,   155,   156,   157,   158,
     740,   741,   159,     0,     0,   160,     0,   742,     0,   743,
     744,   745,     0,     0,   162,   746,   747,     0,   748,   749,
       0,   163,   164,   750,   751,   752,     0,     0,     0,     0,
     753,   167,   754,     0,     0,   755,   756,   168,     0,   169,
       0,     0,     0,   757,   758,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,   759,   178,     0,   760,   761,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,   762,     0,   187,
     763,   188,   764,   765,   189,     0,   766,   190,   191,   192,
     767,     0,   193,     0,     0,   768,     0,   194,   195,     0,
     769,   196,     0,   197,   770,   771,   772,   773,     0,   774,
     775,   199,   776,   777,   778,   201,     0,   202,   779,     0,
     780,   781,     0,   203,   204,     0,   205,   782,     0,   206,
       0,     0,     0,   783,   208,   209,   210,   784,     0,   211,
     212,     0,     0,     0,   213,     0,     0,   785,   214,   786,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,   787,   219,     0,     0,   788,   220,
       0,   789,   221,     0,     0,     0,   790,     0,   791,     0,
     223,   792,     0,   224,     0,   225,   793,     0,     0,   794,
       0,     0,     0,     0,   795,   226,   227,   228,   229,   230,
     231,   796,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   797,   241,   242,   243,   798,   244,   245,     0,     0,
       0,   246,   247,   799,   249,     0,     0,   800,   251,   801,
     802,   252,     0,   253,   803,   804,   805,   806,   807,   808,
     809,   258,   259,   260,   261,     0,   810,   262,   263,     0,
     264,   265,   266,   811,     0,   813,   267,     0,   814,   815,
       0,   268,   269,     0,   816,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   817,   818,   277,   819,   820,   821,   822,   823,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   824,   286,
     287,   288,   289,   290,   291,   292,   825,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,   826,   827,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,   828,   307,   308,   829,   309,   310,
     830,   311,   831,   313,   314,     0,   832,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,   833,   834,   333,   334,     0,   335,
     835,   337,   836,   837,   838,   338,   339,   839,   340,   341,
       0,   342,   343,     0,   654,   344,   840,   841,   842,   843,
       0,     0,     0,     0,     0,   349,     0,   350,   844,   845,
     846,   352,   353,   354,     0,   847,   355,   356,   848,     0,
     357,     0,     0,   849,   850,   358,     0,     0,   359,     0,
     360,     0,   851,   362,     0,     0,   852,   853,   854,   855,
     856,   363,     0,     0,   364,   857,     0,   365,   366,   858,
       0,     0,     0,     0,   368,     0,   369,   370,     0,   859,
       0,   860,     0,     0,     0,     0,   861,     0,     0,     0,
     862,   863,     0,     0,     0,     0,   864,     0,   865,     0,
       0,   866,   867,     0,   868,   869,   122,     0,   725,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   726,     0,   727,   130,   131,   728,   133,     0,   134,
     729,   135,     0,   730,   136,   731,   732,   733,   137,   734,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   735,   144,     0,   145,   736,   737,   147,     0,   148,
     149,   150,   738,   151,     0,   739,   153,     0,   154,   155,
     156,   157,   158,   740,   741,   159,     0,     0,   160,     0,
     742,     0,   743,   744,   745,     0,     0,   162,   746,   747,
       0,   748,   749,     0,   163,   164,   750,   751,   752,     0,
       0,     0,     0,   753,   167,   754,     0,     0,   755,   756,
     168,     0,   169,     0,     0,     0,   757,   758,   170,     0,
     171,   172,   173,     0,     0,     0,   174,     0,     0,   175,
     176,   177,     0,     0,   759,   178,     0,   760,   761,   179,
     180,   181,   182,     0,     0,   183,     0,   184,   185,   186,
     762,     0,   187,   763,   188,   764,   765,   189,     0,   766,
     190,   191,   192,   767,     0,   193,     0,     0,   768,     0,
     194,   195,     0,   769,   196,     0,   197,   770,   771,   772,
     773,     0,   774,   775,   199,   776,   777,   778,   201,     0,
     202,   779,     0,   780,   781,     0,   203,   204,     0,   205,
     782,     0,   206,     0,     0,     0,   783,   208,   209,   210,
     784,     0,   211,   212,     0,     0,     0,   213,     0,     0,
     785,   214,  2435,     0,     0,   215,     0,     0,   216,   217,
       0,     0,     0,     0,     0,     0,   218,   787,   219,     0,
       0,   788,   220,     0,   789,   221,     0,     0,     0,   790,
       0,   791,     0,   223,   792,     0,   224,     0,   225,   793,
       0,     0,   794,     0,     0,     0,     0,   795,   226,   227,
     228,   229,   230,   231,   796,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   797,   241,   242,   243,   798,   244,
     245,     0,     0,     0,   246,   247,   799,   249,     0,     0,
     800,   251,   801,   802,   252,     0,   253,   803,   804,   805,
     806,   807,   808,   809,   258,   259,   260,   261,     0,   810,
     262,   263,     0,   264,   265,   266,   811,   812,   813,   267,
       0,   814,   815,     0,   268,   269,     0,   816,     0,   271,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   817,   818,   277,   819,   820,   821,
     822,   823,     0,   280,   281,     0,   282,     0,   283,   284,
       0,   824,   286,   287,   288,   289,   290,   291,   292,   825,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,   299,   300,   826,   827,   301,     0,   302,
     303,   304,     0,   305,   306,     0,     0,   828,   307,   308,
     829,   309,   310,   830,   311,   831,   313,   314,     0,   832,
     316,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,   331,   332,   833,   834,   333,
     334,     0,   335,   835,   337,   836,   837,   838,   338,   339,
     839,   340,   341,     0,   342,   343,     0,   654,   344,   840,
     841,   842,   843,     0,     0,     0,     0,     0,   349,     0,
     350,   844,   845,   846,   352,   353,   354,     0,   847,   355,
     356,   848,     0,   357,     0,     0,   849,   850,   358,     0,
       0,   359,     0,   360,     0,   851,   362,     0,     0,   852,
     853,   854,   855,   856,   363,     0,     0,   364,   857,     0,
     365,   366,   858,     0,     0,     0,     0,   368,     0,   369,
     370,     0,   859,     0,   860,     0,     0,     0,     0,   861,
       0,     0,     0,   862,   863,     0,     0,     0,     0,   864,
       0,   865,     0,     0,   866,   867,     0,   868,   869,   122,
       0,   725,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   726,     0,   727,   130,   131,   728,
     133,     0,   134,   729,   135,     0,   730,   136,   731,   732,
     733,   137,   734,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   735,   144,     0,   145,   736,   737,
     147,     0,   148,   149,   150,   738,   151,     0,   739,   153,
       0,   154,   155,   156,   157,   158,   740,   741,   159,     0,
       0,   160,     0,   742,     0,   743,   744,   745,     0,     0,
     162,   746,   747,     0,   748,   749,     0,   163,   164,   750,
     751,   752,     0,     0,     0,     0,   753,   167,   754,     0,
       0,   755,   756,   168,     0,   169,     0,     0,     0,   757,
     758,   170,     0,   171,   172,   173,     0,     0,     0,   174,
       0,     0,   175,   176,   177,     0,     0,   759,   178,     0,
     760,   761,   179,   180,   181,   182,     0,     0,   183,     0,
     184,   185,   186,   762,     0,   187,   763,   188,   764,   765,
     189,     0,   766,   190,   191,   192,   767,     0,   193,     0,
       0,   768,     0,   194,   195,     0,   769,   196,     0,   197,
     770,   771,   772,   773,     0,   774,   775,   199,   776,   777,
     778,   201,     0,   202,   779,     0,   780,   781,     0,   203,
     204,     0,   205,   782,     0,   206,     0,     0,     0,   783,
     208,   209,   210,   784,     0,   211,   212,     0,     0,     0,
     213,     0,     0,   785,   214,  2508,     0,     0,   215,     0,
       0,   216,   217,     0,     0,     0,     0,     0,     0,   218,
     787,   219,     0,     0,   788,   220,     0,   789,   221,     0,
       0,     0,   790,     0,   791,     0,   223,   792,     0,   224,
       0,   225,   793,     0,     0,   794,     0,     0,     0,     0,
     795,   226,   227,   228,   229,   230,   231,   796,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   797,   241,   242,
     243,   798,   244,   245,     0,     0,     0,   246,   247,   799,
     249,     0,     0,   800,   251,   801,   802,   252,     0,   253,
     803,   804,   805,   806,   807,   808,   809,   258,   259,   260,
     261,     0,   810,   262,   263,     0,   264,   265,   266,   811,
     812,   813,   267,     0,   814,   815,     0,   268,   269,     0,
     816,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   274,   275,   817,   818,   277,
     819,   820,   821,   822,   823,     0,   280,   281,     0,   282,
       0,   283,   284,     0,   824,   286,   287,   288,   289,   290,
     291,   292,   825,     0,     0,     0,   293,   294,     0,     0,
     295,   296,   297,     0,   298,     0,   299,   300,   826,   827,
     301,     0,   302,   303,   304,     0,   305,   306,     0,     0,
     828,   307,   308,   829,   309,   310,   830,   311,   831,   313,
     314,     0,   832,   316,     0,     0,     0,   317,   318,   319,
       0,     0,   320,     0,     0,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,     0,     0,   327,
     328,     0,   329,     0,     0,   330,     0,     0,   331,   332,
     833,   834,   333,   334,     0,   335,   835,   337,   836,   837,
     838,   338,   339,   839,   340,   341,     0,   342,   343,     0,
     654,   344,   840,   841,   842,   843,     0,     0,     0,     0,
       0,   349,     0,   350,   844,   845,   846,   352,   353,   354,
       0,   847,   355,   356,   848,     0,   357,     0,     0,   849,
     850,   358,     0,     0,   359,     0,   360,     0,   851,   362,
       0,     0,   852,   853,   854,   855,   856,   363,     0,     0,
     364,   857,     0,   365,   366,   858,     0,     0,     0,     0,
     368,     0,   369,   370,     0,   859,     0,   860,     0,     0,
       0,     0,   861,     0,     0,     0,   862,   863,     0,     0,
       0,     0,   864,     0,   865,     0,     0,   866,   867,     0,
     868,   869,   122,     0,   725,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   726,     0,   727,
     130,   131,   728,   133,     0,   134,   729,   135,     0,   730,
     136,   731,   732,   733,   137,   734,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   735,   144,     0,
     145,   736,   737,   147,     0,   148,   149,   150,   738,   151,
       0,   739,   153,     0,   154,   155,   156,   157,   158,   740,
     741,   159,     0,     0,   160,     0,   742,     0,   743,   744,
     745,     0,     0,   162,   746,   747,     0,   748,   749,     0,
     163,   164,   750,   751,   752,     0,     0,     0,     0,   753,
     167,   754,     0,     0,   755,  2853,   168,     0,   169,     0,
       0,     0,   757,   758,   170,     0,   171,   172,   173,     0,
       0,     0,   174,     0,     0,   175,   176,   177,     0,     0,
     759,   178,     0,   760,   761,   179,   180,   181,   182,     0,
       0,   183,     0,   184,   185,   186,   762,     0,   187,   763,
     188,   764,   765,   189,     0,   766,   190,   191,   192,   767,
       0,   193,     0,     0,   768,     0,   194,   195,     0,   769,
     196,     0,   197,   770,   771,   772,   773,     0,   774,   775,
     199,   776,   777,   778,   201,     0,   202,   779,     0,   780,
     781,     0,   203,   204,     0,   205,   782,     0,   206,     0,
       0,     0,   783,   208,   209,   210,   784,     0,   211,   212,
       0,     0,     0,   213,     0,     0,   785,   214,   786,     0,
       0,   215,     0,     0,   216,   217,     0,     0,     0,     0,
       0,     0,   218,   787,   219,     0,     0,   788,   220,     0,
     789,   221,     0,     0,     0,   790,     0,   791,     0,   223,
     792,     0,   224,     0,   225,   793,     0,     0,   794,     0,
       0,     0,     0,   795,   226,   227,   228,   229,   230,   231,
     796,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     797,   241,   242,   243,   798,   244,   245,     0,     0,     0,
     246,   247,   799,   249,     0,     0,   800,   251,   801,   802,
     252,     0,   253,   803,   804,   805,   806,   807,   808,   809,
     258,   259,   260,   261,     0,   810,   262,   263,     0,   264,
     265,   266,   811,   812,   813,   267,     0,   814,   815,     0,
     268,   269,     0,   816,     0,   271,   272,   273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     817,   818,   277,   819,   820,   821,   822,   823,     0,   280,
     281,     0,   282,     0,   283,   284,     0,   824,   286,   287,
     288,   289,   290,   291,   292,   825,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,   299,
     300,   826,   827,   301,     0,   302,   303,   304,     0,   305,
     306,     0,     0,   828,   307,   308,   829,   309,   310,   830,
     311,   831,   313,   314,     0,   832,   316,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,   331,   332,   833,   834,   333,   334,     0,   335,   835,
     337,   836,   837,   838,   338,   339,   839,   340,   341,     0,
     342,   343,     0,   654,   344,   840,   841,   842,   843,     0,
       0,     0,     0,     0,   349,     0,   350,   844,   845,   846,
     352,   353,   354,     0,   847,   355,   356,   848,     0,   357,
       0,     0,   849,   850,   358,     0,     0,   359,     0,   360,
       0,   851,   362,     0,     0,   852,   853,   854,   855,   856,
     363,     0,     0,   364,   857,     0,   365,   366,   858,     0,
       0,     0,     0,   368,     0,   369,   370,     0,   859,     0,
     860,     0,     0,     0,     0,   861,     0,     0,     0,   862,
     863,     0,     0,     0,     0,   864,     0,   865,     0,     0,
     866,   867,     0,   868,   869,   122,     0,   725,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     726,     0,   727,   130,   131,   728,   133,     0,   134,   729,
     135,     0,   730,   136,   731,   732,   733,   137,   734,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     735,   144,     0,   145,   736,   737,   147,     0,   148,   149,
     150,   738,   151,     0,   739,   153,     0,   154,   155,   156,
     157,   158,   740,   741,   159,     0,     0,   160,     0,   742,
       0,   743,   744,   745,     0,     0,   162,   746,   747,     0,
     748,   749,     0,   163,   164,   750,   751,   752,     0,     0,
       0,     0,   753,   167,   754,     0,     0,   755,   756,   168,
       0,   169,     0,     0,     0,   757,   758,   170,     0,   171,
     172,   173,     0,     0,     0,   174,     0,     0,   175,   176,
     177,     0,     0,   759,   178,     0,   760,   761,   179,   180,
     181,   182,     0,     0,   183,     0,   184,   185,   186,   762,
       0,   187,   763,   188,   764,   765,   189,     0,   766,   190,
     191,   192,   767,     0,   193,     0,     0,   768,     0,   194,
     195,     0,   769,   196,     0,   197,   770,   771,   772,   773,
       0,   774,   775,   199,   776,   777,   778,   201,     0,   202,
     779,     0,   780,   781,     0,   203,   204,     0,   205,   782,
       0,   206,     0,     0,     0,   783,   208,   209,   210,   784,
       0,   211,   212,     0,     0,     0,   213,     0,     0,   785,
     214,   786,     0,     0,   215,     0,     0,   216,   217,     0,
       0,     0,     0,     0,     0,   218,   787,   219,     0,     0,
     788,   220,     0,   789,   221,     0,     0,     0,   790,     0,
     791,     0,   223,   792,     0,   224,     0,   225,   793,     0,
       0,   794,     0,     0,     0,     0,   795,   226,   227,   228,
     229,   230,   231,   796,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   797,   241,   242,   243,   798,   244,   245,
       0,     0,     0,   246,   247,   799,   249,     0,     0,   800,
     251,   801,   802,   252,     0,   253,   803,   804,   805,   806,
     807,   808,   809,   258,   259,   260,   261,     0,   810,   262,
     263,     0,   264,   265,   266,   811,     0,   813,   267,     0,
     814,   815,     0,   268,   269,     0,   816,     0,   271,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   274,   275,   817,   818,   277,   819,   820,   821,   822,
     823,     0,   280,   281,     0,   282,     0,   283,   284,     0,
     824,   286,   287,   288,   289,   290,   291,   292,   825,     0,
       0,     0,   293,   294,     0,     0,   295,   296,   297,     0,
     298,     0,   299,   300,   826,   827,   301,     0,   302,   303,
     304,     0,   305,   306,     0,     0,   828,   307,   308,   829,
     309,   310,   830,   311,   831,   313,   314,     0,   832,   316,
       0,     0,     0,   317,   318,   319,     0,     0,   320,     0,
       0,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,     0,     0,   327,   328,     0,   329,     0,
       0,   330,     0,     0,   331,   332,   833,   834,   333,   334,
       0,   335,   835,   337,   836,   837,   838,   338,   339,   839,
     340,   341,     0,   342,   343,     0,   654,   344,   840,   841,
     842,   843,     0,     0,     0,     0,     0,   349,     0,   350,
     844,   845,   846,   352,   353,   354,     0,   847,   355,   356,
     848,     0,   357,     0,     0,   849,   850,   358,     0,     0,
     359,     0,   360,     0,   851,   362,     0,     0,   852,   853,
     854,   855,   856,   363,     0,     0,   364,   857,     0,   365,
     366,   858,     0,     0,     0,     0,   368,     0,   369,   370,
       0,   859,     0,   860,     0,     0,     0,     0,   861,     0,
       0,     0,   862,   863,     0,     0,     0,     0,   864,     0,
     865,     0,     0,   866,   867,     0,   868,   869,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,  1928,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,  1929,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,  1085,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,  1086,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,  2420,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,  1841,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,  1930,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
    1976,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,  1928,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,  1929,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,  1085,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,  1086,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,  1930,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
    1976,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,  1841,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,  2249,     0,   130,   131,   132,   133,
     869,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,     0,     0,     0,
       0,     0,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,  3566,   128,     0,     0,   129,  3567,
     869,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
     971,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   407,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,  1799,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   407,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,     0,     0,     0,     0,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,  1975,     0,
     128,     0,     0,   129,     0,  1976,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,     0,     0,     0,
       0,     0,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,  3567,
     869,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   407,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   461,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   407,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,   869,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
       0,   371,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,  1976,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,   546,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,   547,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
     122,   371,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,  1741,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   163,   164,
       0,     0,   165,     0,     0,     0,     0,   166,   167,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,     0,
       0,     0,   170,     0,   171,   172,   173,     0,     0,     0,
     174,     0,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,     0,   179,   180,   181,   182,     0,     0,   183,
       0,   184,   185,   186,     0,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,   191,   192,     0,     0,   193,
       0,     0,     0,     0,   194,   195,     0,     0,   196,     0,
     197,     0,     0,     0,     0,     0,     0,   198,   199,     0,
       0,   200,   201,     0,   202,     0,     0,     0,     0,     0,
     203,   204,     0,   205,     0,     0,   206,     0,     0,     0,
     207,   208,   209,   210,     0,     0,   211,   212,     0,     0,
       0,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,   216,   217,     0,     0,     0,     0,     0,     0,
     218,     0,   219,     0,     0,     0,   220,     0,     0,   221,
     546,     0,     0,     0,     0,   222,     0,   223,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   226,   227,   228,   229,   230,   231,     0,   232,
     233,   234,   235,   236,   237,   238,   239,   240,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,   247,
     248,   249,     0,     0,   250,   251,     0,     0,   252,     0,
     253,     0,   254,     0,     0,   255,   256,   257,   258,   259,
     260,   261,     0,     0,   262,   263,     0,   264,   265,   266,
       0,     0,     0,   267,     0,     0,     0,     0,   268,   269,
       0,   270,     0,   271,   272,   273,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,   279,     0,     0,   280,   281,     0,
     282,     0,   283,   284,     0,   285,   286,   287,   288,   289,
     290,   291,   292,     0,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,   299,   300,     0,
       0,   301,     0,   302,   303,   304,     0,   305,   306,     0,
       0,     0,   307,   308,     0,   309,   310,     0,   311,   312,
     313,   314,     0,   315,   316,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,   331,
     332,     0,     0,   333,   334,     0,   335,   336,   337,     0,
       0,     0,   338,   339,     0,   340,   341,     0,   342,   343,
       0,   547,   344,   345,   346,   347,   348,     0,     0,     0,
       0,     0,   349,     0,   350,     0,     0,   351,   352,   353,
     354,     0,     0,   355,   356,     0,     0,   357,     0,     0,
       0,     0,   358,     0,     0,   359,     0,   360,     0,   361,
     362,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,   364,     0,     0,   365,   366,   367,     0,     0,     0,
       0,   368,     0,   369,   370,     0,     0,   122,   371,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,  2289,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   163,   164,     0,     0,   165,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,     0,     0,   170,
       0,   171,   172,   173,     0,     0,     0,   174,     0,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,     0,
     179,   180,   181,   182,     0,     0,   183,     0,   184,   185,
     186,     0,     0,   187,     0,   188,     0,     0,   189,     0,
       0,   190,   191,   192,     0,     0,   193,     0,     0,     0,
       0,   194,   195,     0,     0,   196,     0,   197,     0,     0,
       0,     0,     0,     0,   198,   199,     0,     0,   200,   201,
       0,   202,     0,     0,     0,     0,     0,   203,   204,     0,
     205,     0,     0,   206,     0,     0,     0,   207,   208,   209,
     210,     0,     0,   211,   212,     0,     0,     0,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,   216,
     217,     0,     0,     0,     0,     0,     0,   218,     0,   219,
       0,     0,     0,   220,     0,     0,   221,   546,     0,     0,
       0,     0,   222,     0,   223,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
     227,   228,   229,   230,   231,     0,   232,   233,   234,   235,
     236,   237,   238,   239,   240,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,   247,   248,   249,     0,
       0,   250,   251,     0,     0,   252,     0,   253,     0,   254,
       0,     0,   255,   256,   257,   258,   259,   260,   261,     0,
       0,   262,   263,     0,   264,   265,   266,     0,     0,     0,
     267,     0,     0,     0,     0,   268,   269,     0,   270,     0,
     271,   272,   273,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,   279,     0,     0,   280,   281,     0,   282,     0,   283,
     284,     0,   285,   286,   287,   288,   289,   290,   291,   292,
       0,     0,     0,     0,   293,   294,     0,     0,   295,   296,
     297,     0,   298,     0,   299,   300,     0,     0,   301,     0,
     302,   303,   304,     0,   305,   306,     0,     0,     0,   307,
     308,     0,   309,   310,     0,   311,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,   319,     0,     0,
     320,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,     0,     0,   327,   328,     0,
     329,     0,     0,   330,     0,     0,   331,   332,     0,     0,
     333,   334,     0,   335,   336,   337,     0,     0,     0,   338,
     339,     0,   340,   341,     0,   342,   343,     0,   547,   344,
     345,   346,   347,   348,     0,     0,     0,     0,     0,   349,
       0,   350,     0,     0,   351,   352,   353,   354,     0,     0,
     355,   356,     0,     0,   357,     0,     0,     0,     0,   358,
       0,     0,   359,     0,   360,     0,   361,   362,     0,     0,
       0,     0,     0,     0,     0,   363,     0,     0,   364,     0,
       0,   365,   366,   367,     0,     0,     0,     0,   368,     0,
     369,   370,     0,     0,   122,   371,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -185,  2876,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3446,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,     0,   160,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   163,   164,     0,     0,   165,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   168,     0,
     169,     0,     0,     0,     0,     0,   170,     0,   171,   172,
     173,     0,     0,     0,     0,     0,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,     0,     0,   180,   181,
     182,     0,     0,   183,     0,   184,   185,     0,     0,     0,
     187,     0,   188,     0,     0,   189,  3447,     0,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,   194,   195,
       0,     0,   196,     0,   197,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
     206,     0,     0,     0,   207,   208,   209,   210,  3448,     0,
     211,   212,     0,     0,     0,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,   216,   217,  3449,     0,
       0,     0,     0,     0,     0,     0,   219,     0,     0,     0,
     220,  3450,     0,   221,     0,     0,     0,     0,     0,   222,
       0,   223,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   226,   227,   228,   229,
     230,   231,     0,   232,   233,   234,   235,   236,   237,   238,
     239,   240,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,   247,   248,   249,     0,     0,   250,   251,
       0,     0,   252,     0,   253,     0,   254,     0,     0,   255,
     256,   257,   258,   259,   260,   261,     0,     0,   262,   263,
       0,   264,   265,   266,     0,     0,     0,     0,     0,     0,
       0,     0,   268,   269,     0,   270,     0,   271,   272,  3451,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,   279,     0,
       0,     0,   281,     0,   282,     0,   283,   284,     0,   285,
     286,   287,   288,   289,   290,   291,   292,     0,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,     0,   300,  -185,     0,   301,     0,     0,   303,     0,
       0,   305,   306,  3452,     0,     0,     0,   308,     0,   309,
     310,     0,   311,   312,   313,     0,     0,   315,     0,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,     0,   323,     0,     0,   325,   326,     0,     0,
       0,     0,     0,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,     0,   332,     0,     0,     0,   334,     0,
     335,   336,   337,     0,     0,     0,   338,   339,     0,   340,
     341,     0,   342,   343,     0,     0,   344,   345,   346,   347,
     348,     0,     0,     0,     0,     0,   349,     0,   350,     0,
       0,     0,   352,   353,   354,     0,     0,   355,   356,     0,
       0,     0,     0,     0,     0,     0,   358,     0,     0,   359,
       0,     0,     0,   361,   362,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,   364,     0,     0,   365,   366,
     367,     0,     0,  -185,     0,   368,     0,   369,     0,     0,
       0,     0,   371,     0,     0,     0,     0,  3453,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  3650,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,     0,   371,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,  1584,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   163,   164,     0,     0,   165,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,     0,     0,   170,
       0,   171,   172,   173,     0,     0,     0,   174,     0,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,     0,
     179,   180,   181,   182,     0,     0,   183,     0,   184,   185,
     186,     0,     0,   187,     0,   188,     0,     0,   189,     0,
       0,   190,   191,   192,     0,     0,   193,     0,     0,     0,
       0,   194,   195,     0,     0,   196,     0,   197,     0,     0,
       0,     0,     0,     0,   198,   199,     0,     0,   200,   201,
       0,   202,     0,     0,     0,     0,     0,   203,   204,     0,
     205,     0,     0,   206,     0,     0,     0,   207,   208,   209,
     210,     0,     0,   211,   212,     0,     0,     0,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,   216,
     217,     0,     0,     0,     0,     0,     0,   218,     0,   219,
       0,     0,     0,   220,     0,     0,   221,     0,     0,     0,
       0,     0,   222,     0,   223,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
     227,   228,   229,   230,   231,     0,   232,   233,   234,   235,
     236,   237,   238,   239,   240,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,   247,   248,   249,     0,
       0,   250,   251,     0,     0,   252,     0,   253,     0,   254,
       0,     0,   255,   256,   257,   258,   259,   260,   261,     0,
       0,   262,   263,     0,   264,   265,   266,     0,     0,     0,
     267,     0,     0,     0,     0,   268,   269,     0,   270,     0,
     271,   272,   273,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,   279,     0,     0,   280,   281,     0,   282,     0,   283,
     284,     0,   285,   286,   287,   288,   289,   290,   291,   292,
       0,     0,     0,     0,   293,   294,     0,     0,   295,   296,
     297,     0,   298,     0,   299,   300,     0,     0,   301,     0,
     302,   303,   304,     0,   305,   306,     0,     0,     0,   307,
     308,     0,   309,   310,     0,   311,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,   319,     0,     0,
     320,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,     0,     0,   327,   328,     0,
     329,     0,     0,   330,     0,     0,   331,   332,     0,     0,
     333,   334,     0,   335,   336,   337,     0,     0,     0,   338,
     339,     0,   340,   341,     0,   342,   343,     0,     0,   344,
     345,   346,   347,   348,     0,     0,     0,     0,     0,   349,
       0,   350,     0,     0,   351,   352,   353,   354,     0,     0,
     355,   356,     0,     0,   357,     0,     0,     0,     0,   358,
       0,     0,   359,     0,   360,     0,   361,   362,     0,     0,
       0,     0,     0,     0,     0,   363,     0,     0,   364,     0,
       0,   365,   366,   367,     0,     0,     0,     0,   368,     0,
     369,   370,     0,     0,     0,   371,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  2275,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   163,   164,     0,     0,   165,     0,
       0,     0,     0,   166,   167,     0,     0,     0,     0,     0,
     168,     0,   169,     0,     0,     0,     0,     0,   170,     0,
     171,   172,   173,     0,     0,     0,   174,     0,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,     0,   179,
     180,   181,   182,     0,     0,   183,     0,   184,   185,   186,
       0,     0,   187,     0,   188,     0,     0,   189,     0,     0,
     190,   191,   192,     0,     0,   193,     0,     0,     0,     0,
     194,   195,     0,     0,   196,     0,   197,     0,     0,     0,
       0,     0,     0,   198,   199,     0,     0,   200,   201,     0,
     202,     0,     0,     0,     0,     0,   203,   204,     0,   205,
       0,     0,   206,     0,     0,     0,   207,   208,   209,   210,
       0,     0,   211,   212,     0,     0,     0,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,   216,   217,
       0,     0,     0,     0,     0,     0,   218,     0,   219,     0,
       0,     0,   220,     0,     0,   221,     0,     0,     0,     0,
       0,   222,     0,   223,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   226,   227,
     228,   229,   230,   231,     0,   232,   233,   234,   235,   236,
     237,   238,   239,   240,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,   247,   248,   249,     0,     0,
     250,   251,     0,     0,   252,     0,   253,     0,   254,     0,
       0,   255,   256,   257,   258,   259,   260,   261,     0,     0,
     262,   263,     0,   264,   265,   266,     0,     0,     0,   267,
       0,     0,     0,     0,   268,   269,     0,   270,     0,   271,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
     279,     0,     0,   280,   281,     0,   282,     0,   283,   284,
       0,   285,   286,   287,   288,   289,   290,   291,   292,     0,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,   299,   300,     0,     0,   301,     0,   302,
     303,   304,     0,   305,   306,     0,     0,     0,   307,   308,
       0,   309,   310,     0,   311,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,   331,   332,     0,     0,   333,
     334,     0,   335,   336,   337,     0,     0,     0,   338,   339,
       0,   340,   341,     0,   342,   343,     0,     0,   344,   345,
     346,   347,   348,     0,     0,     0,     0,     0,   349,     0,
     350,     0,     0,   351,   352,   353,   354,     0,     0,   355,
     356,     0,     0,   357,     0,     0,     0,     0,   358,     0,
       0,   359,     0,   360,     0,   361,   362,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,   364,     0,     0,
     365,   366,   367,     0,     0,     0,     0,   368,     0,   369,
     370,     0,     0,     0,   371,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2561,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   163,   164,     0,     0,   165,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,     0,   168,
       0,   169,     0,     0,     0,     0,     0,   170,     0,   171,
     172,   173,     0,     0,     0,   174,     0,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,     0,   179,   180,
     181,   182,     0,     0,   183,     0,   184,   185,   186,     0,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
     191,   192,     0,     0,   193,     0,     0,     0,     0,   194,
     195,     0,     0,   196,     0,   197,     0,     0,     0,     0,
       0,     0,   198,   199,     0,     0,   200,   201,     0,   202,
       0,     0,     0,     0,     0,   203,   204,     0,   205,     0,
       0,   206,     0,     0,     0,   207,   208,   209,   210,     0,
       0,   211,   212,     0,     0,     0,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,   216,   217,     0,
       0,     0,     0,     0,     0,   218,     0,   219,     0,     0,
       0,   220,     0,     0,   221,     0,     0,     0,     0,     0,
     222,     0,   223,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   226,   227,   228,
     229,   230,   231,     0,   232,   233,   234,   235,   236,   237,
     238,   239,   240,     0,   241,   242,   243,     0,   244,   245,
       0,     0,     0,   246,   247,   248,   249,     0,     0,   250,
     251,     0,     0,   252,     0,   253,     0,   254,     0,     0,
     255,   256,   257,   258,   259,   260,   261,     0,     0,   262,
     263,     0,   264,   265,   266,     0,     0,     0,   267,     0,
       0,     0,     0,   268,   269,     0,   270,     0,   271,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,   279,
       0,     0,   280,   281,     0,   282,     0,   283,   284,     0,
     285,   286,   287,   288,   289,   290,   291,   292,     0,     0,
       0,     0,   293,   294,     0,     0,   295,   296,   297,     0,
     298,     0,   299,   300,     0,     0,   301,     0,   302,   303,
     304,     0,   305,   306,     0,     0,     0,   307,   308,     0,
     309,   310,     0,   311,   312,   313,   314,     0,   315,   316,
       0,     0,     0,   317,   318,   319,     0,     0,   320,     0,
       0,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,     0,     0,   327,   328,     0,   329,     0,
       0,   330,     0,     0,   331,   332,     0,     0,   333,   334,
       0,   335,   336,   337,     0,     0,     0,   338,   339,     0,
     340,   341,     0,   342,   343,     0,     0,   344,   345,   346,
     347,   348,     0,     0,     0,     0,     0,   349,     0,   350,
       0,     0,   351,   352,   353,   354,     0,     0,   355,   356,
       0,     0,   357,     0,     0,     0,     0,   358,     0,     0,
     359,     0,   360,     0,   361,   362,     0,     0,     0,     0,
       0,     0,     0,   363,     0,     0,   364,     0,     0,   365,
     366,   367,     0,     0,     0,     0,   368,     0,   369,   370,
       0,     0,     0,   371,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2881,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -185,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3446,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,     0,   160,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   163,   164,     0,     0,   165,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   168,     0,
     169,     0,     0,     0,     0,     0,   170,     0,   171,   172,
     173,     0,     0,     0,     0,     0,     0,   175,   176,   177,
       0,  -200,     0,   178,     0,     0,     0,  -200,   180,   181,
     182,     0,     0,   183,     0,   184,   185,     0,     0,     0,
     187,     0,   188,     0,     0,   189,  3447,     0,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,   194,   195,
       0,     0,   196,     0,   197,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
     206,     0,     0,     0,   207,   208,   209,   210,  3448,     0,
     211,   212,     0,     0,     0,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,   216,   217,  3449,     0,
       0,     0,     0,     0,     0,     0,   219,     0,     0,     0,
     220,  3450,     0,   221,     0,     0,     0,     0,     0,   222,
       0,   223,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   226,   227,   228,   229,
     230,   231,     0,   232,   233,   234,   235,   236,   237,   238,
     239,   240,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,   247,   248,   249,     0,     0,   250,   251,
       0,     0,   252,     0,   253,     0,   254,     0,     0,   255,
     256,   257,   258,   259,   260,   261,     0,     0,   262,   263,
       0,   264,   265,   266,     0,     0,     0,     0,     0,     0,
       0,     0,   268,   269,     0,   270,     0,   271,   272,  3451,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,   279,     0,
       0,     0,   281,     0,   282,     0,   283,   284,     0,   285,
     286,   287,   288,   289,   290,   291,   292,     0,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,     0,   300,  -185,     0,   301,     0,     0,   303,     0,
       0,   305,   306,  3452,     0,     0,     0,   308,     0,   309,
     310,     0,   311,   312,   313,     0,     0,   315,     0,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,     0,   323,     0,     0,   325,   326,     0,     0,
       0,     0,     0,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,     0,   332,     0,     0,     0,   334,     0,
     335,   336,   337,     0,     0,     0,   338,   339,     0,   340,
     341,     0,   342,   343,     0,     0,   344,   345,   346,   347,
     348,     0,     0,     0,     0,     0,   349,     0,   350,     0,
       0,     0,   352,   353,   354,     0,     0,   355,   356,     0,
       0,     0,     0,     0,     0,     0,   358,     0,     0,   359,
       0,     0,     0,   361,   362,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,   364,     0,     0,   365,   366,
     367,     0,     0,  -185,     0,   368,     0,   369,     0,     0,
       0,     0,   371,     0,     0,  -200,   122,  3453,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -185,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3446,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,     0,   160,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   163,   164,     0,     0,   165,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     168,     0,   169,     0,     0,     0,     0,     0,   170,     0,
     171,   172,   173,     0,     0,     0,     0,     0,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,     0,  -221,
     180,   181,   182,     0,     0,   183,     0,   184,   185,     0,
       0,     0,   187,     0,   188,     0,     0,   189,  3447,     0,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
     194,   195,     0,     0,   196,     0,   197,     0,     0,     0,
       0,     0,     0,   198,   199,     0,     0,   200,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,   206,     0,     0,     0,   207,   208,   209,   210,
    3448,     0,   211,   212,     0,     0,     0,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,   216,   217,
    3449,     0,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,   220,  3450,     0,   221,     0,     0,     0,     0,
       0,   222,     0,   223,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,  -185,     0,     0,     0,   226,   227,
     228,   229,   230,   231,     0,   232,   233,   234,   235,   236,
     237,   238,   239,   240,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,   247,   248,   249,     0,     0,
     250,   251,     0,     0,   252,     0,   253,     0,   254,     0,
       0,   255,   256,   257,   258,   259,   260,   261,     0,     0,
     262,   263,     0,   264,   265,   266,     0,     0,     0,     0,
       0,     0,     0,     0,   268,   269,     0,   270,     0,   271,
     272,  3451,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
     279,     0,     0,     0,   281,     0,   282,     0,   283,   284,
       0,   285,   286,   287,   288,   289,   290,   291,   292,     0,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,     0,   300,  -185,     0,   301,     0,     0,
     303,     0,     0,   305,   306,  3452,     0,     0,     0,   308,
       0,   309,   310,     0,   311,   312,   313,     0,     0,   315,
       0,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,     0,   323,     0,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,     0,   332,     0,     0,     0,
     334,     0,   335,   336,   337,     0,     0,     0,   338,   339,
       0,   340,   341,     0,   342,   343,     0,     0,   344,   345,
     346,   347,   348,     0,     0,     0,     0,     0,   349,     0,
     350,     0,     0,     0,   352,   353,   354,     0,     0,   355,
     356,     0,     0,     0,     0,     0,     0,     0,   358,     0,
       0,   359,     0,     0,     0,   361,   362,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,   364,     0,     0,
     365,   366,   367,  -221,     0,  -185,     0,   368,     0,   369,
       0,     0,     0,     0,   371,     0,     0,  -221,   122,  3453,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3446,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,     0,
     160,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,     0,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,  -218,   180,   181,   182,     0,     0,   183,     0,   184,
     185,     0,     0,     0,   187,     0,   188,     0,     0,   189,
    3447,     0,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,  3448,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,  3449,     0,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,   220,  3450,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,  -185,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,     0,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,  3451,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,     0,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,     0,   300,  -185,     0,   301,
       0,     0,   303,     0,     0,   305,   306,  3452,     0,     0,
       0,   308,     0,   309,   310,     0,   311,   312,   313,     0,
       0,   315,     0,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,     0,   323,     0,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,     0,   332,     0,
       0,     0,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,     0,   352,   353,   354,     0,
       0,   355,   356,     0,     0,     0,     0,     0,     0,     0,
     358,     0,     0,   359,     0,     0,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,  -218,     0,  -185,     0,   368,
       0,   369,     0,     0,     0,     0,   371,     0,     0,  -218,
     122,  3453,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -185,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3446,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,     0,   160,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   163,   164,
       0,     0,   165,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,     0,
       0,     0,   170,     0,   171,   172,   173,     0,     0,     0,
       0,     0,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,     0,  3532,   180,   181,   182,     0,     0,   183,
       0,   184,   185,     0,     0,     0,   187,     0,   188,     0,
       0,   189,  3447,     0,   190,   191,   192,     0,     0,     0,
       0,     0,     0,     0,   194,   195,     0,     0,   196,     0,
     197,     0,     0,     0,     0,     0,     0,   198,   199,     0,
       0,   200,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,   206,     0,     0,     0,
     207,   208,   209,   210,  3448,     0,   211,   212,     0,     0,
       0,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,   216,   217,  3449,     0,     0,     0,     0,     0,
       0,     0,   219,     0,     0,     0,   220,  3450,     0,   221,
       0,     0,     0,     0,     0,   222,     0,   223,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,  -185,     0,
       0,     0,   226,   227,   228,   229,   230,   231,     0,   232,
     233,   234,   235,   236,   237,   238,   239,   240,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,   247,
     248,   249,     0,     0,   250,   251,     0,     0,   252,     0,
     253,     0,   254,     0,     0,   255,   256,   257,   258,   259,
     260,   261,     0,     0,   262,   263,     0,   264,   265,   266,
       0,     0,     0,     0,     0,     0,     0,     0,   268,   269,
       0,   270,     0,   271,   272,  3451,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,   279,     0,     0,     0,   281,     0,
     282,     0,   283,   284,     0,   285,   286,   287,   288,   289,
     290,   291,   292,     0,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,     0,   300,  -185,
       0,   301,     0,     0,   303,     0,     0,   305,   306,  3452,
       0,     0,     0,   308,     0,   309,   310,     0,   311,   312,
     313,     0,     0,   315,     0,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,     0,   323,
       0,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,     0,
     332,     0,     0,     0,   334,     0,   335,   336,   337,     0,
       0,     0,   338,   339,     0,   340,   341,     0,   342,   343,
       0,     0,   344,   345,   346,   347,   348,     0,     0,     0,
       0,     0,   349,     0,   350,     0,     0,     0,   352,   353,
     354,     0,     0,   355,   356,     0,     0,     0,     0,     0,
       0,     0,   358,     0,     0,   359,     0,     0,     0,   361,
     362,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,   364,     0,     0,   365,   366,   367,     0,     0,  -185,
       0,   368,     0,   369,     0,     0,     0,     0,   371,     0,
       0,     0,   122,  3453,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -185,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3446,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,     0,   160,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     163,   164,     0,     0,   165,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   170,     0,   171,   172,   173,     0,
       0,     0,     0,     0,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,     0,  -223,   180,   181,   182,     0,
       0,   183,     0,   184,   185,     0,     0,     0,   187,     0,
     188,     0,     0,   189,  3447,     0,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,   194,   195,     0,     0,
     196,     0,   197,     0,     0,     0,     0,     0,     0,   198,
     199,     0,     0,   200,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,   206,     0,
       0,     0,   207,   208,   209,   210,  3448,     0,   211,   212,
       0,     0,     0,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,   216,   217,  3449,     0,     0,     0,
       0,     0,     0,     0,   219,     0,     0,     0,   220,  3450,
       0,   221,     0,     0,     0,     0,     0,   222,     0,   223,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
    -185,     0,     0,     0,   226,   227,   228,   229,   230,   231,
       0,   232,   233,   234,   235,   236,   237,   238,   239,   240,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,   247,   248,   249,     0,     0,   250,   251,     0,     0,
     252,     0,   253,     0,   254,     0,     0,   255,   256,   257,
     258,   259,   260,   261,     0,     0,   262,   263,     0,   264,
     265,   266,     0,     0,     0,     0,     0,     0,     0,     0,
     268,   269,     0,   270,     0,   271,   272,  3451,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,   279,     0,     0,     0,
     281,     0,   282,     0,   283,   284,     0,   285,   286,   287,
     288,   289,   290,   291,   292,     0,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,     0,
     300,  -185,     0,   301,     0,     0,   303,     0,     0,   305,
     306,  3452,     0,     0,     0,   308,     0,   309,   310,     0,
     311,   312,   313,     0,     0,   315,     0,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
       0,   323,     0,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,     0,   332,     0,     0,     0,   334,     0,   335,   336,
     337,     0,     0,     0,   338,   339,     0,   340,   341,     0,
     342,   343,     0,     0,   344,   345,   346,   347,   348,     0,
       0,     0,     0,     0,   349,     0,   350,     0,     0,     0,
     352,   353,   354,     0,     0,   355,   356,     0,     0,     0,
       0,     0,     0,     0,   358,     0,     0,   359,     0,     0,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,   365,   366,   367,     0,
       0,  -185,     0,   368,     0,   369,     0,     0,     0,     0,
     371,     0,     0,     0,   122,  3453,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -185,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3446,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,     0,   160,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   163,   164,     0,     0,   165,     0,     0,     0,
       0,   166,     0,     0,     0,     0,     0,     0,   168,     0,
     169,     0,     0,     0,     0,     0,   170,     0,   171,   172,
     173,     0,     0,     0,     0,     0,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,     0,  3587,   180,   181,
     182,     0,     0,   183,     0,   184,   185,     0,     0,     0,
     187,     0,   188,     0,     0,   189,  3447,     0,   190,   191,
     192,     0,     0,     0,     0,     0,     0,     0,   194,   195,
       0,     0,   196,     0,   197,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,   201,     0,   202,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
     206,     0,     0,     0,   207,   208,   209,   210,  3448,     0,
     211,   212,     0,     0,     0,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,   216,   217,  3449,     0,
       0,     0,     0,     0,     0,     0,   219,     0,     0,     0,
     220,  3450,     0,   221,     0,     0,     0,     0,     0,   222,
       0,   223,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,  -185,     0,     0,     0,   226,   227,   228,   229,
     230,   231,     0,   232,   233,   234,   235,   236,   237,   238,
     239,   240,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,   247,   248,   249,     0,     0,   250,   251,
       0,     0,   252,     0,   253,     0,   254,     0,     0,   255,
     256,   257,   258,   259,   260,   261,     0,     0,   262,   263,
       0,   264,   265,   266,     0,     0,     0,     0,     0,     0,
       0,     0,   268,   269,     0,   270,     0,   271,   272,  3451,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,   279,     0,
       0,     0,   281,     0,   282,     0,   283,   284,     0,   285,
     286,   287,   288,   289,   290,   291,   292,     0,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,     0,   300,  -185,     0,   301,     0,     0,   303,     0,
       0,   305,   306,  3452,     0,     0,     0,   308,     0,   309,
     310,     0,   311,   312,   313,     0,     0,   315,     0,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,     0,   323,     0,     0,   325,   326,     0,     0,
       0,     0,     0,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,     0,   332,     0,     0,     0,   334,     0,
     335,   336,   337,     0,     0,     0,   338,   339,     0,   340,
     341,     0,   342,   343,     0,     0,   344,   345,   346,   347,
     348,     0,     0,     0,     0,     0,   349,     0,   350,     0,
       0,     0,   352,   353,   354,     0,     0,   355,   356,     0,
       0,     0,     0,     0,     0,     0,   358,     0,     0,   359,
       0,     0,     0,   361,   362,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,   364,     0,     0,   365,   366,
     367,     0,     0,  -185,     0,   368,     0,   369,     0,     0,
       0,     0,   371,     0,     0,     0,   122,  3453,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -185,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3446,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,     0,   160,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   163,   164,     0,     0,   165,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
     168,     0,   169,     0,     0,     0,     0,     0,   170,     0,
     171,   172,   173,     0,     0,     0,     0,     0,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,     0,  3622,
     180,   181,   182,     0,     0,   183,     0,   184,   185,     0,
       0,     0,   187,     0,   188,     0,     0,   189,  3447,     0,
     190,   191,   192,     0,     0,     0,     0,     0,     0,     0,
     194,   195,     0,     0,   196,     0,   197,     0,     0,     0,
       0,     0,     0,   198,   199,     0,     0,   200,   201,     0,
     202,     0,     0,     0,     0,     0,     0,   204,     0,     0,
       0,     0,   206,     0,     0,     0,   207,   208,   209,   210,
    3448,     0,   211,   212,     0,     0,     0,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,   216,   217,
    3449,     0,     0,     0,     0,     0,     0,     0,   219,     0,
       0,     0,   220,  3450,     0,   221,     0,     0,     0,     0,
       0,   222,     0,   223,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,  -185,     0,     0,     0,   226,   227,
     228,   229,   230,   231,     0,   232,   233,   234,   235,   236,
     237,   238,   239,   240,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,   247,   248,   249,     0,     0,
     250,   251,     0,     0,   252,     0,   253,     0,   254,     0,
       0,   255,   256,   257,   258,   259,   260,   261,     0,     0,
     262,   263,     0,   264,   265,   266,     0,     0,     0,     0,
       0,     0,     0,     0,   268,   269,     0,   270,     0,   271,
     272,  3451,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
     279,     0,     0,     0,   281,     0,   282,     0,   283,   284,
       0,   285,   286,   287,   288,   289,   290,   291,   292,     0,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,     0,   300,  -185,     0,   301,     0,     0,
     303,     0,     0,   305,   306,  3452,     0,     0,     0,   308,
       0,   309,   310,     0,   311,   312,   313,     0,     0,   315,
       0,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,     0,   323,     0,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,     0,   332,     0,     0,     0,
     334,     0,   335,   336,   337,     0,     0,     0,   338,   339,
       0,   340,   341,     0,   342,   343,     0,     0,   344,   345,
     346,   347,   348,     0,     0,     0,     0,     0,   349,     0,
     350,     0,     0,     0,   352,   353,   354,     0,     0,   355,
     356,     0,     0,     0,     0,     0,     0,     0,   358,     0,
       0,   359,     0,     0,     0,   361,   362,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,   364,     0,     0,
     365,   366,   367,     0,     0,  -185,     0,   368,     0,   369,
       0,     0,     0,     0,   371,     0,     0,     0,   122,  3453,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -185,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3446,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,     0,
     160,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,     0,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,  -204,   180,   181,   182,     0,     0,   183,     0,   184,
     185,     0,     0,     0,   187,     0,   188,     0,     0,   189,
    3447,     0,   190,   191,   192,     0,     0,     0,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,     0,   204,
       0,     0,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,  3448,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,  3449,     0,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,   220,  3450,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,  -185,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,     0,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,  3451,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,     0,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,     0,   300,  -185,     0,   301,
       0,     0,   303,     0,     0,   305,   306,  3452,     0,     0,
       0,   308,     0,   309,   310,     0,   311,   312,   313,     0,
       0,   315,     0,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,     0,   323,     0,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,     0,   332,     0,
       0,     0,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,     0,   352,   353,   354,     0,
       0,   355,   356,     0,     0,     0,     0,     0,     0,     0,
     358,     0,     0,   359,     0,     0,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,  -185,     0,   368,
       0,   369,     0,     0,     0,     0,   371,     0,     0,     0,
     122,  3453,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -185,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3446,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,     0,   160,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   163,   164,
       0,     0,   165,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,     0,
       0,     0,   170,     0,   171,   172,   173,     0,     0,     0,
       0,     0,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,     0,     0,   180,   181,   182,     0,     0,   183,
       0,   184,   185,     0,     0,     0,   187,     0,   188,     0,
       0,   189,  3447,     0,   190,   191,   192,     0,     0,     0,
       0,     0,     0,     0,   194,   195,     0,     0,   196,     0,
     197,     0,     0,     0,     0,     0,     0,   198,   199,     0,
       0,   200,   201,     0,   202,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,   206,     0,     0,     0,
     207,   208,   209,   210,  3448,     0,   211,   212,     0,     0,
       0,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,   216,   217,  3449,     0,     0,     0,     0,     0,
       0,     0,   219,     0,     0,     0,   220,  3450,     0,   221,
       0,     0,     0,     0,     0,   222,     0,   223,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,  -185,     0,
       0,     0,   226,   227,   228,   229,   230,   231,     0,   232,
     233,   234,   235,   236,   237,   238,   239,   240,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,   247,
     248,   249,     0,     0,   250,   251,     0,     0,   252,     0,
     253,     0,   254,     0,     0,   255,   256,   257,   258,   259,
     260,   261,     0,     0,   262,   263,     0,   264,   265,   266,
       0,     0,     0,     0,     0,     0,     0,     0,   268,   269,
       0,   270,     0,   271,   272,  3451,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,   279,     0,     0,     0,   281,     0,
     282,     0,   283,   284,     0,   285,   286,   287,   288,   289,
     290,   291,   292,     0,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,     0,   300,  -185,
       0,   301,     0,     0,   303,     0,     0,   305,   306,  3452,
       0,     0,     0,   308,     0,   309,   310,     0,   311,   312,
     313,     0,     0,   315,     0,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,     0,   323,
       0,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,     0,
     332,     0,     0,     0,   334,     0,   335,   336,   337,     0,
       0,     0,   338,   339,     0,   340,   341,     0,   342,   343,
       0,     0,   344,   345,   346,   347,   348,     0,     0,     0,
       0,     0,   349,     0,   350,     0,     0,     0,   352,   353,
     354,     0,     0,   355,   356,     0,     0,     0,     0,     0,
       0,     0,   358,     0,     0,   359,     0,     0,     0,   361,
     362,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,   364,     0,     0,   365,   366,   367,     0,     0,  -185,
       0,   368,     0,   369,     0,     0,     0,     0,   371,     0,
       0,     0,   122,  3453,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -185,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3446,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,     0,   160,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     163,   164,     0,     0,   165,     0,     0,     0,     0,   166,
       0,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   170,     0,   171,   172,   173,     0,
       0,     0,     0,     0,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,     0,     0,   180,   181,   182,     0,
       0,   183,     0,   184,   185,     0,     0,     0,   187,     0,
     188,     0,     0,   189,  3447,     0,   190,   191,   192,     0,
       0,     0,     0,     0,     0,     0,   194,   195,     0,     0,
     196,     0,   197,     0,     0,     0,     0,     0,     0,   198,
     199,     0,     0,   200,   201,     0,   202,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,   206,     0,
       0,     0,   207,   208,   209,   210,  3448,     0,   211,   212,
       0,     0,     0,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,   216,   217,  3449,     0,     0,     0,
       0,     0,     0,     0,   219,     0,     0,     0,   220,  3450,
       0,   221,     0,     0,     0,     0,     0,   222,     0,   223,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
    -185,     0,     0,     0,   226,   227,   228,   229,   230,   231,
       0,   232,   233,   234,   235,   236,   237,   238,   239,   240,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,   247,   248,   249,     0,     0,   250,   251,     0,     0,
     252,     0,   253,     0,   254,     0,     0,   255,   256,   257,
     258,   259,   260,   261,     0,     0,   262,   263,     0,   264,
     265,   266,     0,     0,     0,     0,     0,     0,     0,     0,
     268,   269,     0,   270,     0,   271,   272,  3451,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,   279,     0,     0,     0,
     281,     0,   282,     0,   283,   284,     0,   285,   286,   287,
     288,   289,   290,   291,   292,     0,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,     0,
     300,  -185,     0,   301,     0,     0,   303,     0,     0,   305,
     306,  3452,     0,     0,     0,   308,     0,   309,   310,     0,
     311,   312,   313,     0,     0,   315,     0,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
       0,   323,     0,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,     0,   332,     0,     0,     0,   334,     0,   335,   336,
     337,     0,     0,     0,   338,   339,     0,   340,   341,     0,
     342,   343,     0,     0,   344,   345,   346,   347,   348,     0,
       0,     0,     0,     0,   349,     0,   350,     0,     0,     0,
     352,   353,   354,     0,     0,   355,   356,     0,     0,     0,
       0,     0,     0,     0,   358,     0,     0,  3535,     0,     0,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,   365,   366,   367,     0,
       0,  -185,     0,   368,     0,   369,     0,     0,     0,     0,
     371,     0,     0,     0,   122,  3453,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   163,   164,     0,     0,   165,     0,     0,     0,
       0,   166,   167,  1594,     0,     0,     0,     0,   168,     0,
     169,     0,     0,     0,     0,     0,   170,     0,   171,   172,
     173,     0,     0,     0,   174,     0,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,     0,   179,   180,   181,
     182,     0,     0,   183,     0,   184,   185,   186,     0,     0,
     187,     0,   188,     0,     0,   189,     0,     0,   190,   191,
     192,  1595,     0,   193,     0,     0,     0,     0,   194,   195,
       0,     0,   196,     0,   197,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,   201,     0,   202,     0,
       0,     0,     0,     0,   203,   204,     0,   205,  1596,     0,
     206,     0,     0,     0,   207,   208,   209,   210,     0,     0,
     211,   212,     0,     0,     0,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,   216,   217,     0,     0,
       0,     0,     0,     0,   218,     0,   219,     0,     0,     0,
     220,     0,     0,   221,     0,     0,     0,     0,     0,   222,
       0,   223,     0,     0,   224,     0,   225,     0,     0,     0,
    1597,     0,     0,     0,     0,     0,   226,   227,   228,   229,
     230,   231,     0,   232,   233,   234,   235,   236,   237,   238,
     239,   240,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,   247,   248,   249,     0,     0,   250,   251,
       0,     0,   252,     0,   253,     0,   254,     0,     0,   255,
     256,   257,   258,   259,   260,   261,     0,     0,   262,   263,
       0,   264,   265,   266,   696,   697,     0,   267,     0,     0,
    1598,     0,   268,   269,     0,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,   279,     0,
       0,   280,   281,     0,   282,     0,   283,   284,     0,   285,
     286,   287,   288,   289,   290,   291,   292,     0,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,   299,   300,     0,     0,   301,     0,   302,   303,   304,
       0,   305,   306,     0,     0,     0,   307,   308,     0,   309,
     310,     0,   311,   312,   313,   314,     0,   315,   316,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
    3639,  3630,  3640,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,   331,   332,     0,     0,   333,   334,     0,
     335,   336,   337,     0,     0,     0,   338,   339,     0,   340,
     341,     0,   342,   343,     0,     0,   344,   345,   346,   347,
     348,     0,     0,     0,     0,     0,   349,     0,   350,     0,
       0,   351,   352,   353,   354,     0,  1599,   355,   356,     0,
       0,   357,     0,     0,     0,     0,   358,     0,     0,   359,
       0,   360,     0,   361,   362,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,   364,     0,     0,   365,   366,
     367,     0,     0,     0,     0,   368,     0,   369,   370,     0,
       0,   122,   371,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,  2281,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   163,
     164,     0,     0,   165,     0,     0,     0,     0,   166,   167,
       0,     0,     0,     0,  2282,   168,     0,   169,     0,     0,
       0,     0,     0,   170,     0,   171,   172,   173,     0,     0,
       0,   174,     0,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,     0,   179,   180,   181,   182,  1915,     0,
     183,     0,   184,   185,   186,     0,     0,   187,     0,   188,
       0,     0,   189,     0,     0,   190,   191,   192,     0,     0,
     193,     0,     0,     0,     0,   194,   195,     0,     0,   196,
       0,   197,     0,     0,     0,     0,     0,     0,   198,   199,
       0,     0,   200,   201,     0,   202,     0,     0,     0,     0,
       0,   203,   204,     0,   205,     0,     0,   206,     0,     0,
       0,   207,   208,   209,   210,     0,     0,   211,   212,     0,
       0,     0,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,   216,   217,     0,     0,     0,     0,     0,
       0,   218,     0,   219,     0,     0,     0,   220,     0,     0,
     221,   546,     0,     0,     0,     0,   222,     0,   223,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   226,   227,   228,   229,   230,   231,     0,
     232,   233,   234,   235,   236,   237,   238,   239,   240,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
     247,   248,   249,     0,     0,   250,   251,     0,     0,   252,
       0,   253,     0,   254,     0,     0,   255,   256,   257,   258,
     259,   260,   261,     0,     0,   262,   263,     0,   264,   265,
     266,     0,     0,     0,   267,     0,     0,     0,     0,   268,
     269,     0,   270,     0,   271,   272,   273,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,   279,     0,     0,   280,   281,
       0,   282,     0,   283,   284,     0,   285,   286,   287,   288,
     289,   290,   291,   292,     0,     0,     0,     0,   293,   294,
       0,     0,   295,   296,   297,     0,   298,     0,   299,   300,
       0,     0,   301,     0,   302,   303,   304,     0,   305,   306,
       0,     0,     0,   307,   308,     0,   309,   310,     0,   311,
     312,   313,   314,     0,   315,   316,     0,     0,     0,   317,
     318,   319,     0,  1916,   320,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,     0,
       0,   327,   328,     0,   329,     0,     0,   330,     0,     0,
     331,   332,     0,     0,   333,   334,     0,   335,   336,   337,
       0,     0,     0,   338,   339,     0,   340,   341,     0,   342,
     343,     0,   547,   344,   345,   346,   347,   348,     0,     0,
       0,     0,     0,   349,     0,   350,     0,     0,   351,   352,
     353,   354,     0,     0,   355,   356,     0,     0,   357,     0,
       0,     0,     0,   358,     0,     0,   359,     0,   360,     0,
     361,   362,     0,     0,     0,     0,     0,     0,     0,   363,
       0,     0,   364,     0,     0,   365,   366,   367,     0,     0,
       0,     0,   368,     0,   369,   370,     0,     0,   122,   371,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2291,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,  2292,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,   546,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,   547,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,   122,   371,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2281,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   163,   164,     0,     0,   165,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,  2282,   168,
       0,   169,     0,     0,     0,     0,     0,   170,     0,   171,
     172,   173,     0,     0,     0,   174,     0,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,     0,   179,   180,
     181,   182,     0,     0,   183,     0,   184,   185,   186,     0,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
     191,   192,     0,     0,   193,     0,     0,     0,     0,   194,
     195,     0,     0,   196,     0,   197,     0,     0,     0,     0,
       0,     0,   198,   199,     0,     0,   200,   201,     0,   202,
       0,     0,     0,     0,     0,   203,   204,     0,   205,     0,
       0,   206,     0,     0,     0,   207,   208,   209,   210,     0,
       0,   211,   212,     0,     0,     0,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,   216,   217,     0,
       0,     0,     0,     0,     0,   218,     0,   219,     0,     0,
       0,   220,     0,     0,   221,   546,     0,     0,     0,     0,
     222,     0,   223,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   226,   227,   228,
     229,   230,   231,     0,   232,   233,   234,   235,   236,   237,
     238,   239,   240,     0,   241,   242,   243,     0,   244,   245,
       0,     0,     0,   246,   247,   248,   249,     0,     0,   250,
     251,     0,     0,   252,     0,   253,     0,   254,     0,     0,
     255,   256,   257,   258,   259,   260,   261,     0,     0,   262,
     263,     0,   264,   265,   266,     0,     0,     0,   267,     0,
       0,     0,     0,   268,   269,     0,   270,     0,   271,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,   279,
       0,     0,   280,   281,     0,   282,     0,   283,   284,     0,
     285,   286,   287,   288,   289,   290,   291,   292,     0,     0,
       0,     0,   293,   294,     0,     0,   295,   296,   297,     0,
     298,     0,   299,   300,     0,     0,   301,     0,   302,   303,
     304,     0,   305,   306,     0,     0,     0,   307,   308,     0,
     309,   310,     0,   311,   312,   313,   314,     0,   315,   316,
       0,     0,     0,   317,   318,   319,     0,     0,   320,     0,
       0,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,     0,     0,   327,   328,     0,   329,     0,
       0,   330,     0,     0,   331,   332,     0,     0,   333,   334,
       0,   335,   336,   337,     0,     0,     0,   338,   339,     0,
     340,   341,     0,   342,   343,     0,   547,   344,   345,   346,
     347,   348,     0,     0,     0,     0,     0,   349,     0,   350,
       0,     0,   351,   352,   353,   354,     0,     0,   355,   356,
       0,     0,   357,     0,     0,     0,     0,   358,     0,     0,
     359,     0,   360,     0,   361,   362,     0,     0,     0,     0,
       0,     0,     0,   363,     0,     0,   364,     0,     0,   365,
     366,   367,     0,     0,     0,     0,   368,     0,   369,   370,
       0,     0,   122,   371,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,   162,     0,   700,     0,     0,     0,     0,
     163,   164,     0,     0,   165,     0,     0,     0,     0,   166,
     167,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   170,     0,   171,   172,   173,     0,
       0,     0,   174,     0,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,     0,   179,   180,   181,   182,     0,
       0,   183,     0,   184,   185,   186,     0,     0,   187,     0,
     188,     0,     0,   189,     0,     0,   190,   191,   192,     0,
       0,   193,     0,     0,     0,     0,   194,   195,     0,     0,
     196,     0,   197,     0,     0,     0,     0,     0,     0,   198,
     199,     0,     0,   200,   201,     0,   202,     0,     0,     0,
       0,     0,   203,   204,     0,   205,     0,     0,   206,     0,
       0,     0,   207,   208,   209,   210,     0,     0,   211,   212,
       0,     0,     0,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,   216,   217,     0,     0,     0,     0,
       0,     0,   218,     0,   219,     0,     0,     0,   220,     0,
       0,   221,   546,     0,     0,     0,     0,   222,     0,   223,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   226,   227,   228,   229,   230,   231,
       0,   232,   233,   234,   235,   236,   237,   238,   239,   240,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,   247,   248,   249,     0,     0,   250,   251,     0,     0,
     252,     0,   253,     0,   254,     0,     0,   255,   256,   257,
     258,   259,   260,   261,     0,     0,   262,   263,     0,   264,
     265,   266,     0,     0,     0,   267,     0,     0,     0,     0,
     268,   269,     0,   270,     0,   271,   272,   273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,   279,     0,     0,   280,
     281,     0,   282,     0,   283,   284,     0,   285,   286,   287,
     288,   289,   290,   291,   292,     0,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,   299,
     300,     0,     0,   301,     0,   302,   303,   304,     0,   305,
     306,     0,     0,     0,   307,   308,     0,   309,   310,     0,
     311,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,   331,   332,     0,     0,   333,   334,     0,   335,   336,
     337,     0,     0,     0,   338,   339,     0,   340,   341,     0,
     342,   343,     0,   547,   344,   345,   346,   347,   348,     0,
       0,     0,     0,     0,   349,     0,   350,     0,     0,   351,
     352,   353,   354,     0,     0,   355,   356,     0,     0,   357,
       0,     0,     0,     0,   358,     0,     0,   359,     0,   360,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,   365,   366,   367,     0,
       0,     0,     0,   368,     0,   369,   370,     0,     0,   122,
     371,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,   652,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,   163,   164,     0,
       0,   165,     0,     0,     0,     0,   166,   167,     0,     0,
       0,     0,     0,   168,     0,   169,     0,     0,     0,     0,
       0,   170,     0,   171,   172,   173,     0,     0,     0,   174,
       0,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,     0,   179,   180,   181,   182,     0,     0,   183,     0,
     184,   185,   186,     0,     0,   187,     0,   188,     0,     0,
     189,     0,     0,   190,   191,   192,     0,     0,   193,     0,
       0,     0,     0,   194,   195,     0,     0,   196,     0,   197,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,   201,     0,   202,     0,     0,     0,     0,     0,   203,
     204,     0,   205,   653,     0,   206,     0,     0,     0,   207,
     208,   209,   210,     0,     0,   211,   212,     0,     0,     0,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,   216,   217,     0,     0,     0,     0,     0,     0,   218,
       0,   219,     0,     0,     0,   220,     0,     0,   221,     0,
       0,     0,     0,     0,   222,     0,   223,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   226,   227,   228,   229,   230,   231,     0,   232,   233,
     234,   235,   236,   237,   238,   239,   240,     0,   241,   242,
     243,     0,   244,   245,     0,     0,     0,   246,   247,   248,
     249,     0,     0,   250,   251,     0,     0,   252,     0,   253,
       0,   254,     0,     0,   255,   256,   257,   258,   259,   260,
     261,     0,     0,   262,   263,     0,   264,   265,   266,     0,
       0,     0,   267,     0,     0,     0,     0,   268,   269,     0,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,   279,     0,     0,   280,   281,     0,   282,
       0,   283,   284,     0,   285,   286,   287,   288,   289,   290,
     291,   292,     0,     0,     0,     0,   293,   294,     0,     0,
     295,   296,   297,     0,   298,     0,   299,   300,     0,     0,
     301,     0,   302,   303,   304,     0,   305,   306,     0,     0,
       0,   307,   308,     0,   309,   310,     0,   311,   312,   313,
     314,     0,   315,   316,     0,     0,     0,   317,   318,   319,
       0,     0,   320,     0,     0,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,     0,     0,   327,
     328,     0,   329,     0,     0,   330,     0,     0,   331,   332,
       0,     0,   333,   334,     0,   335,   336,   337,     0,     0,
       0,   338,   339,     0,   340,   341,     0,   342,   343,     0,
     654,   344,   345,   346,   347,   348,     0,     0,     0,     0,
       0,   349,     0,   350,     0,     0,   351,   352,   353,   354,
       0,     0,   355,   356,     0,     0,   357,     0,     0,     0,
       0,   358,     0,     0,   359,     0,   360,     0,   361,   362,
       0,     0,     0,     0,     0,     0,     0,   363,     0,     0,
     364,     0,     0,   365,   366,   367,     0,     0,     0,     0,
     368,     0,   369,   370,     0,     0,   122,   371,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   163,   164,     0,     0,   165,     0,
       0,     0,     0,   166,   167,     0,     0,     0,     0,  2329,
     168,     0,   169,     0,     0,     0,     0,     0,   170,     0,
     171,   172,   173,     0,     0,     0,   174,     0,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,     0,   179,
     180,   181,   182,     0,     0,   183,     0,   184,   185,   186,
       0,     0,   187,     0,   188,     0,     0,   189,     0,     0,
     190,   191,   192,     0,     0,   193,     0,     0,     0,     0,
     194,   195,     0,     0,   196,     0,   197,     0,     0,     0,
       0,     0,     0,   198,   199,     0,     0,   200,   201,     0,
     202,     0,     0,     0,     0,     0,   203,   204,     0,   205,
       0,     0,   206,     0,     0,     0,   207,   208,   209,   210,
       0,     0,   211,   212,     0,     0,     0,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,   216,   217,
       0,     0,     0,     0,     0,     0,   218,     0,   219,     0,
       0,     0,   220,     0,     0,   221,   546,     0,     0,     0,
       0,   222,     0,   223,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   226,   227,
     228,   229,   230,   231,     0,   232,   233,   234,   235,   236,
     237,   238,   239,   240,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,   247,   248,   249,     0,     0,
     250,   251,     0,     0,   252,     0,   253,     0,   254,     0,
       0,   255,   256,   257,   258,   259,   260,   261,     0,     0,
     262,   263,     0,   264,   265,   266,     0,     0,     0,   267,
       0,     0,     0,     0,   268,   269,     0,   270,     0,   271,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
     279,     0,     0,   280,   281,     0,   282,     0,   283,   284,
       0,   285,   286,   287,   288,   289,   290,   291,   292,     0,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,   299,   300,     0,     0,   301,     0,   302,
     303,   304,     0,   305,   306,     0,     0,     0,   307,   308,
       0,   309,   310,     0,   311,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,   331,   332,     0,     0,   333,
     334,     0,   335,   336,   337,     0,     0,     0,   338,   339,
       0,   340,   341,     0,   342,   343,     0,   547,   344,   345,
     346,   347,   348,     0,     0,     0,     0,     0,   349,     0,
     350,     0,     0,   351,   352,   353,   354,     0,     0,   355,
     356,     0,     0,   357,     0,     0,     0,     0,   358,     0,
       0,   359,     0,   360,     0,   361,   362,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,   364,     0,     0,
     365,   366,   367,     0,     0,     0,     0,   368,     0,   369,
     370,     0,     0,   122,   371,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
    2281,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,   546,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,   547,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
     122,   371,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   163,   164,
       0,     0,   165,     0,     0,     0,     0,   166,   167,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,     0,
       0,     0,   170,     0,   171,   172,   173,     0,     0,     0,
     174,     0,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,     0,   179,   180,   181,   182,     0,     0,   183,
       0,   184,   185,   186,     0,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,   191,   192,     0,     0,   193,
       0,     0,     0,     0,   194,   195,     0,     0,   196,     0,
     197,     0,     0,     0,     0,     0,     0,   198,   199,     0,
       0,   200,   201,     0,   202,     0,     0,     0,     0,     0,
     203,   204,     0,   205,     0,     0,   206,     0,     0,     0,
     207,   208,   209,   210,     0,     0,   211,   212,     0,     0,
       0,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,   216,   217,     0,     0,     0,     0,     0,     0,
     218,     0,   219,     0,     0,     0,   220,     0,     0,   221,
     546,     0,     0,     0,     0,   222,     0,   223,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   226,   227,   228,   229,   230,   231,     0,   232,
     233,   234,   235,   236,   237,   238,   239,   240,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,   247,
     248,   249,     0,     0,   250,   251,     0,     0,   252,     0,
     253,     0,   254,     0,     0,   255,   256,   257,   258,   259,
     260,   261,     0,     0,   262,   263,     0,   264,   265,   266,
       0,     0,     0,   267,     0,     0,     0,     0,   268,   269,
       0,   270,     0,   271,   272,   273,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,   279,     0,     0,   280,   281,     0,
     282,     0,   283,   284,     0,   285,   286,   287,   288,   289,
     290,   291,   292,     0,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,   299,   300,     0,
       0,   301,     0,   302,   303,   304,     0,   305,   306,     0,
       0,     0,   307,   308,     0,   309,   310,     0,   311,   312,
     313,   314,     0,   315,   316,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,   331,
     332,     0,     0,   333,   334,     0,   335,   336,   337,     0,
       0,     0,   338,   339,     0,   340,   341,     0,   342,   343,
       0,   547,   344,   345,   346,   347,   348,     0,     0,     0,
       0,     0,   349,     0,   350,     0,     0,   351,   352,   353,
     354,     0,     0,   355,   356,     0,     0,   357,     0,     0,
       0,     0,   358,     0,     0,   359,     0,   360,     0,   361,
     362,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,   364,     0,     0,   365,   366,   367,     0,     0,     0,
       0,   368,     0,   369,   370,     0,     0,   122,   371,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
    2271,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,     0,   160,
       0,   161,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   163,   164,     0,     0,   165,
       0,     0,     0,     0,   166,   167,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,     0,     0,   170,
       0,   171,   172,   173,     0,     0,     0,   174,     0,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,     0,
     179,   180,   181,   182,     0,     0,   183,     0,   184,   185,
     186,     0,     0,   187,     0,   188,     0,     0,   189,     0,
       0,   190,   191,   192,     0,     0,   193,     0,     0,     0,
       0,   194,   195,     0,     0,   196,     0,   197,     0,     0,
       0,     0,     0,     0,   198,   199,     0,     0,   200,   201,
       0,   202,     0,     0,     0,     0,     0,   203,   204,     0,
     205,     0,     0,   206,     0,     0,     0,   207,   208,   209,
     210,     0,     0,   211,   212,     0,     0,     0,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,   216,
     217,     0,     0,     0,     0,     0,     0,   218,     0,   219,
       0,     0,     0,   220,     0,     0,   221,     0,     0,     0,
       0,     0,   222,     0,   223,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
     227,   228,   229,   230,   231,     0,   232,   233,   234,   235,
     236,   237,   238,   239,   240,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,   247,   248,   249,     0,
       0,   250,   251,     0,     0,   252,     0,   253,     0,   254,
       0,     0,   255,   256,   257,   258,   259,   260,   261,     0,
       0,   262,   263,     0,   264,   265,   266,     0,     0,     0,
     267,     0,     0,     0,     0,   268,   269,     0,   270,     0,
     271,   272,   273,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,   279,     0,     0,   280,   281,     0,   282,     0,   283,
     284,     0,   285,   286,   287,   288,   289,   290,   291,   292,
       0,     0,     0,     0,   293,   294,     0,     0,   295,   296,
     297,     0,   298,     0,   299,   300,     0,     0,   301,     0,
     302,   303,   304,     0,   305,   306,     0,     0,     0,   307,
     308,     0,   309,   310,     0,   311,   312,   313,   314,     0,
     315,   316,     0,     0,     0,   317,   318,   319,     0,     0,
     320,     0,     0,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,     0,     0,   327,   328,     0,
     329,     0,     0,   330,     0,     0,   331,   332,     0,     0,
     333,   334,     0,   335,   336,   337,     0,     0,     0,   338,
     339,     0,   340,   341,     0,   342,   343,     0,   547,   344,
     345,   346,   347,   348,     0,     0,     0,     0,     0,   349,
       0,   350,     0,     0,   351,   352,   353,   354,     0,     0,
     355,   356,     0,     0,   357,     0,     0,     0,     0,   358,
       0,     0,   359,     0,   360,     0,   361,   362,     0,     0,
       0,     0,     0,     0,     0,   363,     0,     0,   364,     0,
       0,   365,   366,   367,     0,     0,     0,     0,   368,     0,
     369,   370,     0,     0,   122,   371,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,     0,   160,     0,   161,  3582,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   163,   164,     0,     0,   165,     0,     0,     0,
       0,   166,   167,     0,     0,     0,     0,     0,   168,     0,
     169,     0,     0,     0,     0,     0,   170,     0,   171,   172,
     173,     0,     0,     0,   174,     0,     0,   175,   176,   177,
       0,     0,     0,   178,     0,     0,     0,   179,   180,   181,
     182,     0,     0,   183,     0,   184,   185,   186,     0,  3583,
     187,     0,   188,     0,     0,   189,     0,     0,   190,   191,
     192,     0,     0,   193,     0,     0,     0,     0,   194,   195,
       0,     0,   196,     0,   197,     0,     0,     0,     0,     0,
       0,   198,   199,     0,     0,   200,   201,     0,   202,     0,
       0,     0,     0,     0,   203,   204,     0,   205,     0,     0,
     206,     0,     0,     0,   207,   208,   209,   210,     0,     0,
     211,   212,     0,     0,     0,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,   216,   217,     0,     0,
       0,     0,     0,     0,   218,     0,   219,     0,     0,     0,
     220,     0,     0,   221,     0,     0,     0,     0,     0,   222,
       0,   223,     0,     0,   224,     0,   225,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   226,   227,   228,   229,
     230,   231,     0,   232,   233,   234,   235,   236,   237,   238,
     239,   240,     0,   241,   242,   243,     0,   244,   245,     0,
       0,     0,   246,   247,   248,   249,     0,     0,   250,   251,
       0,     0,   252,     0,   253,     0,   254,     0,     0,   255,
     256,   257,   258,   259,   260,   261,     0,     0,   262,   263,
       0,   264,   265,   266,     0,     0,     0,   267,     0,     0,
       0,     0,   268,   269,     0,   270,     0,   271,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,   279,     0,
       0,   280,   281,     0,   282,     0,   283,   284,     0,   285,
     286,   287,   288,   289,   290,   291,   292,     0,     0,     0,
       0,   293,   294,     0,     0,   295,   296,   297,     0,   298,
       0,   299,   300,     0,     0,   301,     0,   302,   303,   304,
       0,   305,   306,     0,     0,     0,   307,   308,     0,   309,
     310,     0,   311,   312,   313,   314,     0,   315,   316,     0,
       0,     0,   317,   318,   319,     0,     0,   320,     0,     0,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,     0,     0,   327,   328,     0,   329,     0,     0,
     330,     0,     0,   331,   332,     0,     0,   333,   334,     0,
     335,   336,   337,     0,     0,     0,   338,   339,     0,   340,
     341,     0,   342,   343,     0,     0,   344,   345,   346,   347,
     348,     0,     0,     0,     0,     0,   349,     0,   350,     0,
       0,   351,   352,   353,   354,     0,     0,   355,   356,     0,
       0,   357,     0,     0,     0,     0,   358,     0,     0,   359,
       0,   360,     0,   361,   362,     0,     0,     0,     0,     0,
       0,     0,   363,     0,     0,   364,     0,     0,   365,   366,
     367,     0,     0,     0,     0,   368,     0,   369,   370,     0,
       0,   122,   371,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,     0,   160,     0,   161,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   163,
     164,     0,     0,   165,     0,     0,     0,     0,   166,   167,
       0,     0,     0,     0,     0,   168,     0,   169,     0,     0,
       0,     0,     0,   170,     0,   171,   172,   173,     0,     0,
       0,   174,     0,     0,   175,   176,   177,     0,     0,     0,
     178,     0,     0,     0,   179,   180,   181,   182,     0,     0,
     183,     0,   184,   185,   186,     0,     0,   187,     0,   188,
       0,     0,   189,     0,     0,   190,   191,   192,     0,     0,
     193,     0,     0,     0,     0,   194,   195,   719,     0,   196,
       0,   197,     0,     0,     0,     0,     0,     0,   198,   199,
       0,     0,   200,   201,     0,   202,     0,     0,     0,     0,
       0,   203,   204,     0,   205,     0,     0,   206,     0,     0,
       0,   207,   208,   209,   210,     0,     0,   211,   212,     0,
       0,     0,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,   216,   217,     0,     0,     0,     0,     0,
       0,   218,     0,   219,     0,     0,     0,   220,     0,     0,
     221,     0,     0,     0,     0,     0,   222,     0,   223,     0,
       0,   224,     0,   225,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   226,   227,   228,   229,   230,   231,     0,
     232,   233,   234,   235,   236,   237,   238,   239,   240,     0,
     241,   242,   243,     0,   244,   245,     0,     0,     0,   246,
     247,   248,   249,     0,     0,   250,   251,     0,     0,   252,
       0,   253,     0,   254,     0,     0,   255,   256,   257,   258,
     259,   260,   261,     0,     0,   262,   263,     0,   264,   265,
     266,     0,     0,     0,   267,     0,     0,     0,     0,   268,
     269,     0,   270,     0,   271,   272,   273,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,   279,     0,     0,   280,   281,
       0,   282,     0,   283,   284,     0,   285,   286,   287,   288,
     289,   290,   291,   292,     0,     0,     0,     0,   293,   294,
       0,     0,   295,   296,   297,     0,   298,     0,   299,   300,
       0,     0,   301,     0,   302,   303,   304,     0,   305,   306,
       0,     0,     0,   307,   308,     0,   309,   310,     0,   311,
     312,   313,   314,     0,   315,   316,     0,     0,     0,   317,
     318,   319,     0,     0,   320,     0,     0,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,     0,
       0,   327,   328,     0,   329,     0,     0,   330,     0,     0,
     331,   332,     0,     0,   333,   334,     0,   335,   336,   337,
       0,     0,     0,   338,   339,     0,   340,   341,     0,   342,
     343,     0,     0,   344,   345,   346,   347,   348,     0,     0,
       0,     0,     0,   349,     0,   350,     0,     0,   351,   352,
     353,   354,     0,     0,   355,   356,     0,     0,   357,     0,
       0,     0,     0,   358,     0,     0,   359,     0,   360,     0,
     361,   362,     0,     0,     0,     0,     0,     0,     0,   363,
       0,     0,   364,     0,     0,   365,   366,   367,     0,     0,
       0,     0,   368,     0,   369,   370,     0,     0,   122,   371,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   163,   164,     0,     0,
     165,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,  1081,   168,     0,   169,     0,     0,     0,     0,     0,
     170,     0,   171,   172,   173,     0,     0,     0,   174,     0,
       0,   175,   176,   177,     0,     0,     0,   178,     0,     0,
       0,   179,   180,   181,   182,     0,     0,   183,     0,   184,
     185,   186,     0,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,   191,   192,     0,     0,   193,     0,     0,
       0,     0,   194,   195,     0,     0,   196,     0,   197,     0,
       0,     0,     0,     0,     0,   198,   199,     0,     0,   200,
     201,     0,   202,     0,     0,     0,     0,     0,   203,   204,
       0,   205,     0,     0,   206,     0,     0,     0,   207,   208,
     209,   210,     0,     0,   211,   212,     0,     0,     0,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
     216,   217,     0,     0,     0,     0,     0,     0,   218,     0,
     219,     0,     0,     0,   220,     0,     0,   221,     0,     0,
       0,     0,     0,   222,     0,   223,     0,     0,   224,     0,
     225,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     226,   227,   228,   229,   230,   231,     0,   232,   233,   234,
     235,   236,   237,   238,   239,   240,     0,   241,   242,   243,
       0,   244,   245,     0,     0,     0,   246,   247,   248,   249,
       0,     0,   250,   251,     0,     0,   252,     0,   253,     0,
     254,     0,     0,   255,   256,   257,   258,   259,   260,   261,
       0,     0,   262,   263,     0,   264,   265,   266,     0,     0,
       0,   267,     0,     0,     0,     0,   268,   269,     0,   270,
       0,   271,   272,   273,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,   279,     0,     0,   280,   281,     0,   282,     0,
     283,   284,     0,   285,   286,   287,   288,   289,   290,   291,
     292,     0,     0,     0,     0,   293,   294,     0,     0,   295,
     296,   297,     0,   298,     0,   299,   300,     0,     0,   301,
       0,   302,   303,   304,     0,   305,   306,     0,     0,     0,
     307,   308,     0,   309,   310,     0,   311,   312,   313,   314,
       0,   315,   316,     0,     0,     0,   317,   318,   319,     0,
       0,   320,     0,     0,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,     0,     0,   327,   328,
       0,   329,     0,     0,   330,     0,     0,   331,   332,     0,
       0,   333,   334,     0,   335,   336,   337,     0,     0,     0,
     338,   339,     0,   340,   341,     0,   342,   343,     0,     0,
     344,   345,   346,   347,   348,     0,     0,     0,     0,     0,
     349,     0,   350,     0,     0,   351,   352,   353,   354,     0,
       0,   355,   356,     0,     0,   357,     0,     0,     0,     0,
     358,     0,     0,   359,     0,   360,     0,   361,   362,     0,
       0,     0,     0,     0,     0,     0,   363,     0,     0,   364,
       0,     0,   365,   366,   367,     0,     0,     0,     0,   368,
       0,   369,   370,     0,     0,   122,   371,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,     0,   160,     0,   161,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   163,   164,     0,     0,   165,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,  1866,   168,
       0,   169,     0,     0,     0,     0,     0,   170,     0,   171,
     172,   173,     0,     0,     0,   174,     0,     0,   175,   176,
     177,     0,     0,     0,   178,     0,     0,     0,   179,   180,
     181,   182,     0,     0,   183,     0,   184,   185,   186,     0,
       0,   187,     0,   188,     0,     0,   189,     0,     0,   190,
     191,   192,     0,     0,   193,     0,     0,     0,     0,   194,
     195,     0,     0,   196,     0,   197,     0,     0,     0,     0,
       0,     0,   198,   199,     0,     0,   200,   201,     0,   202,
       0,     0,     0,     0,     0,   203,   204,     0,   205,     0,
       0,   206,     0,     0,     0,   207,   208,   209,   210,     0,
       0,   211,   212,     0,     0,     0,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,   216,   217,     0,
       0,     0,     0,     0,     0,   218,     0,   219,     0,     0,
       0,   220,     0,     0,   221,     0,     0,     0,     0,     0,
     222,     0,   223,     0,     0,   224,     0,   225,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   226,   227,   228,
     229,   230,   231,     0,   232,   233,   234,   235,   236,   237,
     238,   239,   240,     0,   241,   242,   243,     0,   244,   245,
       0,     0,     0,   246,   247,   248,   249,     0,     0,   250,
     251,     0,     0,   252,     0,   253,     0,   254,     0,     0,
     255,   256,   257,   258,   259,   260,   261,     0,     0,   262,
     263,     0,   264,   265,   266,     0,     0,     0,   267,     0,
       0,     0,     0,   268,   269,     0,   270,     0,   271,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,   279,
       0,     0,   280,   281,     0,   282,     0,   283,   284,     0,
     285,   286,   287,   288,   289,   290,   291,   292,     0,     0,
       0,     0,   293,   294,     0,     0,   295,   296,   297,     0,
     298,     0,   299,   300,     0,     0,   301,     0,   302,   303,
     304,     0,   305,   306,     0,     0,     0,   307,   308,     0,
     309,   310,     0,   311,   312,   313,   314,     0,   315,   316,
       0,     0,     0,   317,   318,   319,     0,     0,   320,     0,
       0,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,     0,     0,   327,   328,     0,   329,     0,
       0,   330,     0,     0,   331,   332,     0,     0,   333,   334,
       0,   335,   336,   337,     0,     0,     0,   338,   339,     0,
     340,   341,     0,   342,   343,     0,     0,   344,   345,   346,
     347,   348,     0,     0,     0,     0,     0,  1867,     0,   350,
       0,     0,   351,   352,   353,   354,     0,     0,   355,   356,
       0,     0,   357,     0,     0,     0,     0,   358,     0,     0,
     359,     0,   360,     0,   361,   362,     0,     0,     0,     0,
       0,     0,     0,   363,     0,     0,   364,     0,     0,   365,
     366,   367,     0,     0,     0,     0,   368,     0,   369,   370,
       0,     0,   122,   371,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,     0,   160,     0,   161,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     163,   164,     0,     0,   165,     0,     0,     0,     0,   166,
     167,     0,     0,     0,     0,     0,   168,     0,   169,     0,
       0,     0,     0,     0,   170,     0,   171,   172,   173,     0,
       0,     0,   174,     0,     0,   175,   176,   177,     0,     0,
       0,   178,     0,     0,     0,   179,   180,   181,   182,     0,
       0,   183,     0,   184,   185,   186,     0,     0,   187,     0,
     188,     0,     0,   189,     0,     0,   190,   191,   192,     0,
       0,   193,     0,     0,     0,     0,   194,   195,     0,     0,
     196,     0,   197,     0,     0,     0,     0,     0,     0,   198,
     199,     0,     0,   200,   201,     0,   202,     0,     0,     0,
       0,     0,   203,   204,     0,   205,     0,     0,   206,     0,
       0,     0,   207,   208,   209,   210,     0,     0,   211,   212,
       0,     0,     0,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,   216,   217,     0,     0,     0,     0,
       0,     0,   218,     0,   219,     0,     0,     0,   220,     0,
       0,   221,     0,     0,     0,     0,     0,   222,     0,   223,
       0,     0,   224,     0,   225,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   226,   227,   228,   229,   230,   231,
       0,   232,   233,   234,   235,   236,   237,   238,   239,   240,
       0,   241,   242,   243,     0,   244,   245,     0,     0,     0,
     246,   247,   248,   249,     0,     0,   250,   251,     0,     0,
     252,     0,   253,     0,   254,     0,     0,   255,   256,   257,
     258,   259,   260,   261,     0,     0,   262,   263,     0,   264,
     265,   266,     0,     0,     0,   267,     0,     0,     0,     0,
     268,   269,     0,   270,     0,   271,   272,   273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,   279,     0,     0,   280,
     281,  1982,   282,     0,   283,   284,     0,   285,   286,   287,
     288,   289,   290,   291,   292,     0,     0,     0,     0,   293,
     294,     0,     0,   295,   296,   297,     0,   298,     0,   299,
     300,     0,     0,   301,     0,   302,   303,   304,     0,   305,
     306,     0,     0,     0,   307,   308,     0,   309,   310,     0,
     311,   312,   313,   314,     0,   315,   316,     0,     0,     0,
     317,   318,   319,     0,     0,   320,     0,     0,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
       0,     0,   327,   328,     0,   329,     0,     0,   330,     0,
       0,   331,   332,     0,     0,   333,   334,     0,   335,   336,
     337,     0,     0,     0,   338,   339,     0,   340,   341,     0,
     342,   343,     0,     0,   344,   345,   346,   347,   348,     0,
       0,     0,     0,     0,   349,     0,   350,     0,     0,   351,
     352,   353,   354,     0,     0,   355,   356,     0,     0,   357,
       0,     0,     0,     0,   358,     0,     0,   359,     0,   360,
       0,   361,   362,     0,     0,     0,     0,     0,     0,     0,
     363,     0,     0,   364,     0,     0,   365,   366,   367,     0,
       0,     0,     0,   368,     0,   369,   370,     0,     0,   122,
     371,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
       0,   160,     0,   161,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,   163,   164,     0,
       0,   165,     0,     0,     0,     0,   166,   167,     0,     0,
       0,     0,     0,   168,     0,   169,     0,     0,     0,     0,
       0,   170,     0,   171,   172,   173,     0,     0,     0,   174,
       0,     0,   175,   176,   177,     0,     0,     0,   178,     0,
       0,     0,   179,   180,   181,   182,     0,     0,   183,     0,
     184,   185,   186,     0,     0,   187,     0,   188,     0,     0,
     189,     0,     0,   190,   191,   192,     0,     0,   193,     0,
       0,     0,     0,   194,   195,     0,     0,   196,     0,   197,
       0,     0,     0,     0,     0,     0,   198,   199,     0,     0,
     200,   201,     0,   202,     0,     0,     0,     0,     0,   203,
     204,     0,   205,     0,     0,   206,     0,     0,     0,   207,
     208,   209,   210,     0,     0,   211,   212,     0,     0,     0,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,   216,   217,     0,     0,     0,     0,     0,     0,   218,
       0,   219,     0,     0,     0,   220,     0,     0,   221,     0,
       0,     0,     0,     0,   222,     0,   223,     0,     0,   224,
       0,   225,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   226,   227,   228,   229,   230,   231,     0,   232,   233,
     234,   235,   236,   237,   238,   239,   240,     0,   241,   242,
     243,     0,   244,   245,     0,     0,     0,   246,   247,   248,
     249,     0,     0,   250,   251,     0,     0,   252,     0,   253,
       0,   254,     0,     0,   255,   256,   257,   258,   259,   260,
     261,     0,     0,   262,   263,     0,   264,   265,   266,     0,
       0,     0,   267,     0,     0,     0,     0,   268,   269,     0,
     270,     0,   271,   272,   273,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,   279,     0,     0,   280,   281,     0,   282,
       0,   283,   284,     0,   285,   286,   287,   288,   289,   290,
     291,   292,     0,     0,     0,     0,   293,   294,     0,     0,
     295,   296,   297,     0,   298,     0,   299,   300,     0,     0,
     301,     0,   302,   303,   304,     0,   305,   306,     0,     0,
       0,   307,   308,     0,   309,   310,     0,   311,   312,   313,
     314,     0,   315,   316,     0,     0,     0,   317,   318,   319,
       0,     0,   320,     0,     0,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,     0,     0,   327,
     328,     0,   329,     0,     0,   330,     0,     0,   331,   332,
       0,     0,   333,   334,     0,   335,   336,   337,     0,     0,
       0,   338,   339,     0,   340,   341,     0,   342,   343,     0,
     547,   344,   345,   346,   347,   348,     0,     0,     0,     0,
       0,   349,     0,   350,     0,     0,   351,   352,   353,   354,
       0,     0,   355,   356,     0,     0,   357,     0,     0,     0,
       0,   358,     0,     0,   359,     0,   360,     0,   361,   362,
       0,     0,     0,     0,     0,     0,     0,   363,     0,     0,
     364,     0,     0,   365,   366,   367,     0,     0,     0,     0,
     368,     0,   369,   370,     0,     0,   122,   371,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,     0,   160,     0,
     161,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,   163,   164,     0,     0,   165,     0,
       0,     0,     0,   166,   167,     0,     0,     0,     0,  1866,
     168,     0,   169,     0,     0,     0,     0,     0,   170,     0,
     171,   172,   173,     0,     0,     0,   174,     0,     0,   175,
     176,   177,     0,     0,     0,   178,     0,     0,     0,   179,
     180,   181,   182,     0,     0,   183,     0,   184,   185,   186,
       0,     0,   187,     0,   188,     0,     0,   189,     0,     0,
     190,   191,   192,     0,     0,   193,     0,     0,     0,     0,
     194,   195,     0,     0,   196,     0,   197,     0,     0,     0,
       0,     0,     0,   198,   199,     0,     0,   200,   201,     0,
     202,     0,     0,     0,     0,     0,   203,   204,     0,   205,
       0,     0,   206,     0,     0,     0,   207,   208,   209,   210,
       0,     0,   211,   212,     0,     0,     0,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,   216,   217,
       0,     0,     0,     0,     0,     0,   218,     0,   219,     0,
       0,     0,   220,     0,     0,   221,     0,     0,     0,     0,
       0,   222,     0,   223,     0,     0,   224,     0,   225,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   226,   227,
     228,   229,   230,   231,     0,   232,   233,   234,   235,   236,
     237,   238,   239,   240,     0,   241,   242,   243,     0,   244,
     245,     0,     0,     0,   246,   247,   248,   249,     0,     0,
     250,   251,     0,     0,   252,     0,   253,     0,   254,     0,
       0,   255,   256,   257,   258,   259,   260,   261,     0,     0,
     262,   263,     0,   264,   265,   266,     0,     0,     0,   267,
       0,     0,     0,     0,   268,   269,     0,   270,     0,   271,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
     279,     0,     0,   280,   281,     0,   282,     0,   283,   284,
       0,   285,   286,   287,   288,   289,   290,   291,   292,     0,
       0,     0,     0,   293,   294,     0,     0,   295,   296,   297,
       0,   298,     0,   299,   300,     0,     0,   301,     0,   302,
     303,   304,     0,   305,   306,     0,     0,     0,   307,   308,
       0,   309,   310,     0,   311,   312,   313,   314,     0,   315,
     316,     0,     0,     0,   317,   318,   319,     0,     0,   320,
       0,     0,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,     0,     0,   327,   328,     0,   329,
       0,     0,   330,     0,     0,   331,   332,     0,     0,   333,
     334,     0,   335,   336,   337,     0,     0,     0,   338,   339,
       0,   340,   341,     0,   342,   343,     0,     0,   344,   345,
     346,   347,   348,     0,     0,     0,     0,     0,   349,     0,
     350,     0,     0,   351,   352,   353,   354,     0,     0,   355,
     356,     0,     0,   357,     0,     0,     0,     0,   358,     0,
       0,   359,     0,   360,     0,   361,   362,     0,     0,     0,
       0,     0,     0,     0,   363,     0,     0,   364,     0,     0,
     365,   366,   367,     0,     0,     0,     0,   368,     0,   369,
     370,     0,     0,   122,   371,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,     0,   160,     0,   161,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   163,   164,     0,     0,   165,     0,     0,     0,     0,
     166,   167,     0,     0,     0,     0,     0,   168,     0,   169,
       0,     0,     0,     0,     0,   170,     0,   171,   172,   173,
       0,     0,     0,   174,     0,     0,   175,   176,   177,     0,
       0,     0,   178,     0,     0,     0,   179,   180,   181,   182,
       0,     0,   183,     0,   184,   185,   186,     0,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,   191,   192,
       0,     0,   193,     0,     0,     0,     0,   194,   195,     0,
       0,   196,     0,   197,     0,     0,     0,     0,     0,     0,
     198,   199,     0,     0,   200,   201,     0,   202,     0,     0,
       0,     0,     0,   203,   204,     0,   205,     0,     0,   206,
       0,     0,     0,   207,   208,   209,   210,     0,     0,   211,
     212,     0,     0,     0,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,   216,   217,     0,     0,     0,
       0,     0,     0,   218,     0,   219,     0,     0,     0,   220,
       0,     0,   221,     0,     0,     0,     0,     0,   222,     0,
     223,     0,     0,   224,     0,   225,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,   227,   228,   229,   230,
     231,     0,   232,   233,   234,   235,   236,   237,   238,   239,
     240,     0,   241,   242,   243,     0,   244,   245,     0,     0,
       0,   246,   247,   248,   249,     0,     0,   250,   251,     0,
       0,   252,     0,   253,     0,   254,     0,     0,   255,   256,
     257,   258,   259,   260,   261,     0,     0,   262,   263,     0,
     264,   265,   266,     0,     0,     0,   267,     0,     0,     0,
       0,   268,   269,     0,   270,     0,   271,   272,   273,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,   279,     0,     0,
     280,   281,     0,   282,     0,   283,   284,     0,   285,   286,
     287,   288,   289,   290,   291,   292,     0,     0,     0,     0,
     293,   294,     0,     0,   295,   296,   297,     0,   298,     0,
     299,   300,     0,     0,   301,     0,   302,   303,   304,     0,
     305,   306,     0,     0,     0,   307,   308,     0,   309,   310,
       0,   311,   312,   313,   314,     0,   315,   316,     0,     0,
       0,   317,   318,   319,     0,     0,   320,     0,     0,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,     0,     0,   327,   328,     0,   329,     0,     0,   330,
       0,     0,   331,   332,     0,     0,   333,   334,     0,   335,
     336,   337,     0,     0,     0,   338,   339,     0,   340,   341,
       0,   342,   343,     0,     0,   344,   345,   346,   347,   348,
       0,     0,     0,     0,     0,   349,     0,   350,     0,     0,
     351,   352,   353,   354,     0,     0,   355,   356,     0,     0,
     357,     0,     0,     0,     0,   358,     0,     0,   359,     0,
     360,     0,   361,   362,     0,     0,     0,     0,     0,     0,
       0,   363,     0,     0,   364,     0,     0,   365,   366,   367,
       0,     0,     0,     0,   368,     0,   369,   370,     0,     0,
     122,   371,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   163,   164,
       0,     0,   165,     0,     0,     0,     0,   166,   167,     0,
       0,     0,     0,     0,   168,     0,   169,     0,     0,     0,
       0,     0,   170,     0,   171,   172,   173,     0,     0,     0,
     174,     0,     0,   175,   176,   177,     0,     0,     0,   178,
       0,     0,     0,   179,   180,   181,   182,     0,     0,   183,
       0,   184,   185,   186,     0,     0,   187,     0,   188,     0,
       0,   189,     0,     0,   190,  1380,   192,     0,     0,   193,
       0,     0,     0,     0,   194,   195,     0,     0,   196,     0,
     197,     0,     0,     0,     0,     0,     0,   198,   199,     0,
       0,   200,   201,     0,   202,     0,     0,     0,     0,     0,
     203,   204,     0,   205,     0,     0,   206,     0,     0,     0,
     207,   208,   209,   210,     0,     0,   211,   212,     0,     0,
       0,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,   216,   217,     0,     0,     0,     0,     0,     0,
     218,     0,   219,     0,     0,     0,   220,     0,     0,   221,
       0,     0,     0,     0,     0,   222,     0,   223,     0,     0,
     224,     0,   225,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   226,   227,   228,   229,   230,   231,     0,   232,
     233,   234,   235,   236,   237,   238,   239,   240,     0,   241,
     242,   243,     0,   244,   245,     0,     0,     0,   246,   247,
     248,   249,     0,     0,   250,   251,     0,     0,   252,     0,
     253,     0,   254,     0,     0,   255,   256,   257,   258,   259,
     260,   261,     0,     0,   262,   263,     0,   264,  1381,   266,
       0,     0,     0,   267,     0,     0,     0,     0,   268,   269,
       0,   270,     0,   271,   272,   273,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,   279,     0,     0,   280,   281,     0,
     282,     0,   283,   284,     0,   285,   286,   287,   288,   289,
     290,   291,   292,     0,     0,     0,     0,   293,   294,     0,
       0,   295,   296,   297,     0,   298,     0,   299,   300,     0,
       0,   301,     0,   302,   303,   304,     0,   305,   306,     0,
       0,     0,   307,   308,     0,   309,   310,     0,   311,   312,
     313,   314,     0,   315,   316,     0,     0,     0,   317,   318,
     319,     0,     0,   320,     0,     0,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,     0,     0,
     327,   328,     0,   329,     0,     0,   330,     0,     0,   331,
     332,     0,     0,   333,   334,     0,   335,   336,   337,     0,
       0,     0,   338,   339,     0,   340,   341,     0,   342,   343,
       0,     0,   344,   345,   346,   347,   348,     0,     0,     0,
       0,     0,   349,     0,   350,     0,     0,   351,   352,   353,
     354,     0,     0,   355,   356,     0,     0,   357,     0,     0,
       0,     0,   358,     0,     0,   359,     0,   360,     0,   361,
     362,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,   364,     0,     0,   365,   366,   367,     0,     0,     0,
       0,   368,     0,   369,   370,     0,     0,   122,   371,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
       0,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,     0,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,     0,   160,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   163,   164,     0,     0,   165,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,   168,     0,   169,     0,     0,     0,     0,     0,   170,
       0,   171,   172,   173,     0,     0,     0,     0,     0,     0,
     175,   176,   177,     0,     0,     0,   178,     0,     0,     0,
       0,   180,   181,   182,     0,     0,   183,     0,   184,   185,
       0,     0,     0,   187,     0,   188,     0,     0,   189,     0,
       0,   190,   191,   192,     0,     0,     0,     0,     0,     0,
       0,   194,   195,     0,     0,   196,     0,   197,     0,     0,
       0,     0,     0,     0,   198,   199,     0,     0,   200,   201,
       0,   202,     0,     0,     0,     0,     0,     0,   204,     0,
       0,     0,     0,   206,     0,     0,     0,   207,   208,   209,
     210,     0,     0,   211,   212,     0,     0,     0,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,   216,
     217,     0,     0,     0,     0,     0,     0,     0,     0,   219,
       0,     0,     0,   220,     0,     0,   221,     0,     0,     0,
       0,     0,   222,     0,   223,     0,     0,   224,     0,   225,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   226,
     227,   228,   229,   230,   231,     0,   232,   233,   234,   235,
     236,   237,   238,   239,   240,     0,   241,   242,   243,     0,
     244,   245,     0,     0,     0,   246,   247,   248,   249,     0,
       0,   250,   251,     0,     0,   252,     0,   253,     0,   254,
       0,     0,   255,   256,   257,   258,   259,   260,   261,     0,
       0,   262,   263,     0,   264,   265,   266,     0,     0,     0,
       0,     0,     0,     0,     0,   268,   269,     0,   270,     0,
     271,   272,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,   279,     0,     0,     0,   281,     0,   282,     0,   283,
     284,     0,   285,   286,   287,   288,   289,   290,   291,   292,
       0,     0,     0,     0,   293,   294,     0,     0,   295,   296,
     297,     0,   298,     0,     0,   300,     0,     0,   301,     0,
       0,   303,     0,     0,   305,   306,     0,     0,     0,     0,
     308,     0,   309,   310,     0,   311,   312,   313,     0,     0,
     315,     0,     0,     0,     0,   317,   318,   319,     0,     0,
     320,     0,     0,     0,   321,     0,   323,     0,     0,   325,
     326,     0,     0,     0,     0,     0,     0,   327,   328,     0,
     329,     0,     0,   330,     0,     0,     0,   332,     0,     0,
       0,   334,     0,   335,   336,   337,     0,     0,     0,   338,
     339,     0,   340,   341,     0,   342,   343,     0,     0,   344,
     345,   346,   347,   348,     0,     0,     0,     0,     0,   349,
       0,   350,     0,     0,     0,   352,   353,   354,     0,     0,
     355,   356,     0,     0,     0,     0,     0,     0,     0,   358,
       0,     0,   359,     0,     0,     0,   361,   362,     0,     0,
       0,     0,     0,     0,     0,   363,     0,     0,   364,     0,
       0,   365,   366,   367,     0,     0,     0,     0,   368,     0,
     369,     0,     0,     0,     0,   371
};

static const short int yycheck[] =
{
       7,   486,   411,   456,   587,   752,  1278,   957,   511,   707,
     708,   709,    19,   436,  1278,    22,  1010,  1152,   667,   746,
     747,   748,    29,   448,   449,   450,   633,   452,  1188,   454,
     482,   483,    39,   730,   612,  1735,  1876,  1154,  1155,  1156,
     812,  1299,    49,    22,  1817,  1060,  1897,  2023,  1306,  1186,
    1167,  1845,  1496,  1360,  1905,   633,  1907,   610,  2662,  1074,
     512,  1580,  1869,  1870,  1871,  1509,   569,  1074,  2306,  2041,
    1295,  1883,  1884,  2256,  1462,  2639,  2048,  1317,  1318,  1025,
      87,   634,  1180,  1242,  1904,   443,   813,  1860,    18,    32,
    1036,  1037,     3,   840,     3,    55,   843,     3,  1938,     3,
     107,   108,  2688,   110,  1221,  2691,  1934,  1224,    87,    18,
      27,     3,   839,     3,   121,     3,     3,    16,  1958,  1959,
       3,    16,  1220,   563,  2710,   852,   853,   854,    16,   581,
    2716,    10,    16,    18,   671,  1252,  1253,    57,   495,   671,
    1257,   108,   121,   110,  1583,  1928,  1159,  1160,    20,  1162,
    1309,  1934,  1311,    18,  1937,    68,    58,  1940,    54,    55,
    1277,    28,  1279,  2749,  1416,   862,   863,   864,  1951,  1952,
      11,    57,   675,    48,    34,  1476,    20,  1960,    92,    53,
    1919,    58,    54,    55,  1197,   882,  1585,   153,    32,  1929,
    1930,    34,   132,    94,   153,    20,    97,  1147,   635,  1212,
      93,    45,   611,  2922,   153,    62,  1078,    32,   225,   171,
      54,    55,   142,  2350,   225,   283,   574,  1230,  1231,  1232,
      45,   108,  2016,   126,    20,   108,   678,   225,  1241,    54,
      55,    62,  2020,   142,    23,    48,    32,   175,  2913,   112,
      60,   171,   667,    57,   168,    91,   166,   257,   246,    45,
      91,    51,   173,   201,   210,   108,   127,   142,    54,    55,
      32,  1903,  3368,   144,  2919,   397,   246,   554,    32,   337,
     112,  3455,  1486,   210,    63,    74,   247,   142,    67,   153,
     166,     8,   156,    55,  1498,  1499,   230,  1501,  1502,  1503,
      65,   171,  1506,   353,   168,   403,   230,  1511,  2862,   243,
     110,  1515,  1516,  1517,   210,  1519,  1520,  1521,  1522,  1523,
     171,  1525,  1526,  1527,   123,   171,   476,   110,    59,   108,
     213,   476,    94,  2243,   485,    97,   228,   264,    12,   175,
     281,   104,    28,   105,   175,   108,   247,   455,   455,   199,
     388,   269,   270,   247,  2921,   435,   219,   213,   517,   433,
     470,   228,   472,   453,    37,   247,   199,   247,    43,  2945,
       4,   213,   281,  2249,   651,     9,    10,  1954,  2954,   210,
    1889,   155,   171,    69,   345,   475,   493,   171,   536,   264,
     232,    11,   165,    27,  1971,  2962,   247,   385,    32,   162,
     397,   876,    36,   562,   514,   416,   263,   487,  3073,  1048,
     407,   562,   562,   451,   411,  2325,   372,   200,   526,   416,
    1545,   566,   435,   372,   421,  1550,   476,  1856,   314,   293,
     371,  1556,   324,   372,  1559,   509,   199,   210,   366,    86,
     562,   352,  3538,   160,   345,   372,   443,   416,   122,   395,
      76,   345,   138,   232,   364,   455,    48,   142,  3103,  3104,
    3634,   105,   560,   460,   264,   907,  1203,   353,   386,   387,
     544,  1014,   406,   470,   889,   264,    63,   474,   402,  1022,
     142,   264,   116,   480,  1591,   482,   483,   330,   364,   109,
     487,   488,  1060,  2290,   435,  1038,  1039,   366,   261,   395,
     497,   470,   560,  2313,   501,   380,   168,   306,   372,   506,
     507,  3065,   509,   510,   511,   512,  2025,   455,   960,   225,
    1456,   196,  1015,   434,  2321,  2652,   200,   281,   970,  2347,
     366,  1393,  1529,   426,  1271,   366,   401,   394,   328,   323,
    1067,  1975,   503,  2361,   472,  1067,   325,   326,   545,   550,
     507,   330,   509,   510,  3263,   562,   330,   319,   337,   420,
     452,   549,   961,   533,   561,  1672,   515,   997,   331,  1676,
     380,   463,   569,   570,  2347,   525,   515,   574,   485,   223,
     384,   450,  2016,  1845,   581,   364,   102,   478,  2361,   472,
     481,  1845,   561,  2022,   504,   498,   463,   517,   401,  1126,
     948,   570,  1709,   368,  1126,  1896,   562,  1034,   455,  1736,
     562,   485,  1761,   562,   611,  2345,   546,  1766,  1767,   488,
    1862,  1308,  1772,   971,  1774,   529,   476,   560,   504,  2358,
     485,  1758,   533,  1048,   455,  2024,   472,  1324,  2866,   533,
     502,   472,   562,   476,  1906,   424,   538,   561,   511,  1079,
    2428,   533,  1906,   533,   170,  1002,  3321,   535,  1071,   530,
     529,   550,   537,  1350,  2837,   550,   567,   568,   502,   568,
     667,   433,   568,   567,   568,   342,   362,   534,   675,   511,
     566,   678,  2314,  2315,   681,   682,   568,   502,   568,   205,
     568,   568,   562,   529,   528,   568,   382,   562,   562,   560,
     175,  3295,   104,   564,   435,   470,  3300,  2583,  3284,   104,
    3286,    67,  3011,   682,   387,   561,   502,   491,   560,   481,
     717,   407,   719,    79,   489,   504,   560,   347,   401,    91,
    1129,   334,  1080,   507,   497,  1738,   328,   381,   524,   525,
     415,  1945,   427,   516,   104,   371,   472,   509,   717,   422,
     719,    85,  1956,  2262,  2263,   554,   555,   556,    91,   346,
     162,   408,  1177,   109,   104,   427,   104,   162,   454,   403,
     444,   445,   446,   447,   448,   449,   318,    63,  3006,  3355,
    2577,  3357,    53,   299,   418,  1910,   460,   187,  2629,    19,
     424,   307,  2633,   187,   340,   420,  2580,   199,    49,   128,
     217,   264,   162,  3102,   199,   135,    57,   168,   225,   401,
     444,    57,   174,   171,  1939,   145,  1941,   461,  2615,  2629,
      66,  1946,   162,  2633,   162,  2055,  2056,  1302,  2591,   535,
     336,  2649,    78,   261,   426,   535,  1961,   294,  1963,  1964,
    1965,   109,   175,     0,   550,   420,  1261,   353,   420,    38,
    1265,   213,   252,   171,   370,  2227,  2228,  2229,   252,   261,
     146,   199,   562,  1356,   222,   420,   261,   247,   429,   430,
     867,  3465,   869,   317,   155,  3429,  2649,     3,   224,   235,
     213,   215,   153,   113,  1481,   156,  2258,  2259,  2260,    12,
     420,   366,   420,   337,  1293,   256,   230,   168,   160,  1883,
    1884,   261,   418,   331,   901,  1398,  1399,   225,  1451,   243,
     907,  2936,  1455,  1481,  2939,  1458,  1459,   380,   420,   420,
     166,   261,  2431,   261,   388,  1367,   354,  2305,   174,   331,
      67,   120,   901,   350,   476,   560,   331,   362,  3237,  2741,
    2906,  2442,    79,   142,   338,  2446,    85,   944,   304,   946,
    1349,   948,   472,  2737,  1890,    12,   224,  2106,   500,   562,
    2208,    12,  1361,   960,   961,   345,  1396,   213,  1908,  1974,
     476,   331,   328,   970,   971,   237,  1406,  1974,  2940,  2194,
    2574,   118,  2244,   317,   981,   560,   232,   345,   560,   564,
    2244,   331,   109,   331,   522,   523,    12,   472,   388,   122,
    1430,   252,   318,   337,  3303,   560,  1003,  1004,  1005,  1006,
    3604,    85,  3185,   343,  1427,   531,  1013,   474,  1015,  2107,
     349,   567,   293,   379,  1021,   425,   476,   543,   492,   362,
     560,   425,   560,   366,  1031,   373,  1005,  1006,   376,   485,
     442,    85,   499,  2046,   325,   326,  1003,  1004,  2051,   330,
    2644,   318,    12,   318,    12,    85,  1013,  1487,   560,   560,
     346,   283,  1031,  2066,  1021,   122,   328,  2364,   410,   497,
    2073,   122,   406,   517,   537,  2202,   215,   439,  1765,   567,
    1077,   252,  2209,  1080,    16,  2088,  2089,  2027,  2898,  2899,
    3389,   230,  2095,  2890,   450,   497,   503,   217,   235,   532,
    2103,   372,   497,   493,   243,   225,   122,   328,  1077,  3075,
     472,   473,   562,   546,  3139,   337,  1546,  1547,   364,  1549,
     209,  1551,  1552,  1553,  1554,  1555,   460,  1557,  1558,  2638,
     473,   473,  1129,   517,  1131,  1132,  1133,   497,  1135,  2142,
     473,   215,   504,   117,   561,   475,  3374,  1144,   472,  1146,
     494,   532,   514,    66,   561,   488,   230,   497,   329,   497,
     476,     8,   122,   213,   122,   546,  1135,   304,   389,   243,
    2671,   215,   514,   517,  3136,  1132,  1133,   561,   317,   340,
      27,   514,   232,  1180,   500,   215,   230,   529,   325,   326,
    3418,   328,   213,   439,    70,    71,   529,   209,   337,   243,
     230,   225,   552,   553,  2705,  2706,  2640,  2641,  2642,   476,
     491,   476,  2713,   243,   171,  2587,  2219,  3449,  3450,  2720,
      54,    55,   246,  1220,  3008,   535,   507,   201,   380,    63,
     350,  2665,   108,   500,   420,   500,   532,   325,   326,  1654,
     426,   393,   379,   317,   560,    75,    23,    24,  3089,   560,
     546,    12,    13,   166,   130,   470,   567,   472,   504,    89,
    3285,    20,  3287,   337,   396,   560,   398,   406,   400,    28,
     402,   423,   567,   317,    33,   222,   454,    54,    55,    56,
     458,  1278,  3337,   257,  3339,   161,    63,   317,   188,   264,
      67,   561,  1375,   560,  1377,   560,  1293,   561,   562,    76,
     213,   325,   326,  2551,   567,  3537,  1721,   281,  1497,  2459,
    2460,  1500,   933,   450,   525,   936,    93,   528,   939,   232,
    1509,   460,  2584,    84,   142,  1408,  1409,  1410,   450,  1518,
    2584,   108,   406,  3490,   111,  2677,   522,   523,  2680,  2681,
     395,   561,   562,    98,    99,   100,   101,   102,   560,  2934,
    2935,   112,  1349,   449,   450,  2697,   452,  1354,   454,  1356,
      11,   385,   406,   140,  1361,   126,   344,  2952,   149,   347,
    1367,  3528,  1369,  2958,   560,  2637,   406,  1374,  1375,   517,
    1377,   513,   337,  2637,   284,   285,   460,   148,   288,   289,
     410,   365,  1389,   561,   562,  1392,  2981,   371,   159,  2984,
     365,  1398,  1399,  1400,  1401,  1374,  1375,   470,  1377,    15,
      16,  1408,  1409,  1410,   438,   170,   460,   561,   562,  3576,
    1389,   438,   439,  1392,   441,   399,   342,   188,   337,  1426,
     460,  1400,  1401,  1863,  3591,  2197,   213,   562,  1435,  1408,
    1409,  1410,   210,   220,  3601,   561,   562,   202,   203,   204,
     205,   364,   213,   561,   562,  1452,   561,   562,   219,    46,
    1457,   435,   561,   562,   561,   562,   171,  3624,   257,  3626,
      46,  1870,  1469,  1872,  1873,  2480,  3239,   562,  1475,   561,
     562,   455,  1319,  1320,  1321,  1322,  1323,   337,  1457,   561,
     562,   561,   562,   561,   562,   256,   470,   416,   472,   561,
     562,   561,   562,   561,   562,   503,  1475,   383,   257,   286,
      54,    55,  1942,  1943,     3,   561,   562,     6,  2205,  1918,
    1919,   561,   562,   300,    13,   549,   550,   561,   562,   554,
    2218,  1944,  1962,   147,    23,    24,  1533,   493,   561,   562,
     295,  2544,   297,   298,   299,  1542,   561,   562,   561,   562,
     560,   142,   307,   561,   562,  1954,   561,   562,   561,   562,
     561,   562,   426,    52,   561,   562,   247,    56,  3423,   160,
     168,  3401,  1971,  1570,   351,   455,   353,   455,    67,   561,
     562,  1578,   561,   562,  1581,   561,   562,    76,  3385,   180,
     561,   562,    81,  2743,   561,   562,   455,   374,   375,  2861,
     377,  3291,   281,   194,    93,     3,   367,  2861,   470,  1578,
     561,   562,   257,  1570,   139,   370,   561,   562,    77,   108,
      18,   562,   111,   384,   561,   562,   561,   562,   339,   390,
     468,   120,   121,   561,   562,   396,   413,   126,   561,  3494,
     561,   562,  2041,   419,  2059,   134,   237,   238,   529,  2048,
      51,   140,  2067,   389,  3509,   149,  3511,   561,   562,   420,
     561,   562,   417,   418,  2814,   561,   562,   561,   562,   560,
     431,   432,   561,   562,   265,   207,   165,   562,   142,   143,
     566,    23,    24,  2256,   561,   562,   529,    85,   561,   562,
     561,   562,   561,   562,  1317,  1318,  1315,  1316,  3553,   562,
    2297,  3556,  2641,  2642,  1262,  1263,   467,  3109,  3110,  3564,
    2593,  2594,    54,    55,    56,   567,   180,   494,  2563,  2564,
     560,    63,   211,   560,   213,    67,   503,  2851,  2852,  2297,
     194,   220,   323,   560,    76,   560,   560,   560,   560,   560,
     560,   560,   540,  3598,   142,   560,   560,  1744,  2241,   560,
     511,    93,   513,   560,  3609,   560,   560,  2741,   560,   560,
    3615,  2304,   226,   560,   560,   560,   108,   560,   560,   111,
     168,   557,   363,   560,   238,   560,   531,   560,   560,   551,
     560,   560,  3637,  3638,   562,   562,  3641,   542,   543,   560,
    2189,   560,   476,   191,  2287,   560,   560,   286,   140,   197,
     560,   265,   560,   560,   560,   567,   560,   560,   560,   560,
     560,   300,   560,   560,   560,   560,   305,   215,   560,   560,
     560,   560,   560,   560,   222,   560,   560,   560,   560,   560,
     560,   560,   230,   560,   560,   560,   560,   560,   560,   560,
    2843,  2271,   560,   560,   560,   243,   560,   560,  1845,   247,
     560,   560,   560,   560,   560,    46,   345,   321,   256,   560,
     560,   560,   351,   560,   353,   560,  1863,  1864,   560,   560,
     560,   213,   560,  1870,   560,  1872,  1873,   560,   220,   566,
     560,   470,   560,   560,   560,   374,   375,   560,   377,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   391,   560,   246,   560,   560,   560,   560,  1906,
     560,   560,   535,   281,   562,   562,   560,   252,   281,   317,
    2607,  1918,  1919,   562,   413,   562,   485,   562,   485,  2359,
     562,  1928,   562,   562,   225,   476,  2366,  1934,   554,   337,
    1937,   168,   510,  1940,   286,   562,   437,   345,   355,   560,
    2392,   561,   142,  2893,  1951,  1952,   142,  1954,   300,  2358,
     562,   142,   142,  1960,   142,   142,   142,   142,   366,   142,
     142,   142,  1969,   142,  1971,   142,   142,   142,  1975,  1976,
     562,   512,   561,    44,   337,    63,   175,   171,    12,   561,
     476,   561,   122,     9,   561,    34,   561,   532,   561,   560,
    1969,   567,   246,   553,   562,   494,   380,   533,   406,   351,
     214,   353,   567,   171,   503,   561,   435,   426,  2015,  2016,
     188,   168,   562,   562,    44,   450,    34,   450,   426,   450,
     450,   419,   374,   375,   450,   377,    66,   485,   119,   231,
    2728,   471,   471,   231,  2041,   119,  2015,   562,   517,   567,
     562,  2048,   561,   561,   561,  3317,   562,   561,    97,   561,
      18,   561,   460,   561,  2061,   104,   561,   554,   561,   171,
     562,   413,   562,   562,   562,   560,     7,   561,   561,   568,
     562,   562,   561,   561,   427,   562,   561,   567,    19,    97,
     562,    22,   562,  3200,   561,   561,   104,   562,    29,  3224,
    3225,  3226,  3227,   565,   562,   503,   562,   562,    39,   562,
    2107,   561,   256,   562,   560,   562,   155,   561,    49,   517,
     562,   562,   561,   162,   562,   562,   561,   567,   562,   562,
     562,   562,   252,   561,   561,   533,   562,   535,   562,   561,
     485,   485,   476,   561,   561,   550,   561,   155,   561,   561,
     561,   561,   494,   561,   162,   561,    87,   561,   561,  2847,
     199,   503,   561,   561,   562,   562,  3428,   562,   562,   562,
     568,   561,   561,   560,     3,   561,   107,   108,   562,   110,
     562,   561,   561,   485,   562,   562,   561,   537,   561,    18,
     121,   199,  2189,   562,   561,   561,   561,  2596,   562,   561,
     560,   485,   561,   560,   562,   342,   567,   171,   171,   171,
     222,  3214,   171,  2612,   227,   567,   567,   535,   560,   230,
     230,   562,   261,  2220,   348,   296,    93,  2224,    93,  2226,
    2227,  2228,  2229,   232,   232,   560,   567,   560,   476,   560,
    2237,   345,   554,   221,  2241,   561,   561,  2244,   331,   331,
     561,   561,   561,   261,   171,   171,    85,   171,   331,   547,
     138,  2258,  2259,  2260,  2837,   561,   561,   567,  2237,   567,
     567,   561,   561,   554,  2271,   561,   210,   560,  3540,   318,
    2277,   337,  2279,   562,   561,   567,  3540,   171,   327,   511,
    2287,   330,   331,   225,   244,    63,   269,   230,   562,   337,
     230,    18,   337,   232,   232,    18,   561,    18,   560,  3571,
     318,   247,   561,   142,   561,   561,   267,   268,   269,   270,
     271,   272,   330,   331,   275,   276,   277,   278,   279,   280,
     560,   282,   560,  3595,   223,   223,   165,   561,   561,   168,
     561,  3595,   561,   561,   561,   129,   562,   561,   561,   561,
    2347,   561,   567,   561,   561,   241,   562,   562,   561,   561,
     561,  2358,   191,   561,  2361,   561,   561,   561,   197,  3106,
    3107,  3108,   420,   191,   561,   428,   561,   142,   561,   348,
     562,   210,   230,   562,   230,  3024,   215,   547,   562,   108,
     108,   561,   331,   222,   361,  2392,   560,  3522,   561,   561,
     561,   230,  2399,   562,   561,  2402,   561,   561,   561,  2406,
    2407,   561,   561,  2410,   243,   561,   561,   560,   247,   561,
     561,   561,   561,  2420,   562,   561,   561,   256,   561,   331,
     562,   562,  3149,  2402,   561,   386,   387,   476,   561,   478,
     561,   567,   481,   561,   561,   561,    12,    13,   562,   561,
     561,  2420,   491,   561,   560,   562,   561,   567,   497,   562,
     561,   500,  2892,   562,   560,   560,   397,   560,   476,   560,
     478,   560,   560,   481,   561,   561,   407,  2876,   422,   331,
     411,  3169,  3170,   491,   561,   416,   561,    40,   317,   497,
     421,  3130,   500,   561,   371,   561,   561,   561,   331,   561,
     222,   535,   561,    44,  3143,   562,   197,   567,   337,   303,
     562,   380,   443,   552,   553,   476,   345,   517,    84,   476,
     230,   517,   331,   560,  2937,   331,    32,   560,   560,   460,
     331,  2961,   560,   528,   528,   560,   511,   366,   108,   470,
     232,  2940,   232,   474,   552,   553,   112,   330,   535,   480,
     331,   482,   483,   331,   331,   331,   487,   488,   331,   561,
     126,  2960,   303,   560,   151,  3282,   497,   476,   476,   562,
     501,   496,   561,   561,   232,   506,   507,   406,   509,   510,
     511,   512,   148,   562,   561,   561,   476,  2584,  2585,   561,
    2587,   561,    65,   159,   562,   561,   561,   426,    16,  2596,
     327,   561,   517,   523,   517,  2602,   561,   561,  3296,  3024,
     562,   560,  3185,   561,   545,  2612,   561,   168,   561,   561,
    3050,   561,   188,  2620,   561,   331,   561,   331,   342,   511,
     561,   460,   472,   249,   561,   561,   270,   561,   569,   570,
    2637,   562,   561,   574,   562,    57,   342,   213,    57,   561,
     581,   561,  2649,   219,   561,   561,   561,   560,   366,  2656,
     560,    44,   561,   561,   561,   561,   561,    44,  2665,   135,
      44,   142,   384,     5,   503,   562,   561,   342,   342,  3078,
     611,   561,   131,   403,    44,    44,   562,   516,   517,    44,
     256,   118,    16,   414,   565,   561,   532,   569,   560,   274,
     532,   171,   210,   561,   533,   142,   535,   222,   138,   568,
     331,   560,   562,   209,   561,  3130,   547,  3356,   532,   138,
     106,   263,   125,   568,   249,   569,   426,   548,  3143,   568,
     138,   547,   561,   562,   562,   195,   667,  3136,   562,   568,
     138,   568,  2739,   548,   675,   168,  3176,   678,   168,   394,
     681,   682,   168,  3392,  3393,   547,  3395,   108,   169,     3,
     534,   523,  1791,  3515,  3180,  3299,  1560,  3173,  3619,    13,
      14,  3650,   673,  3623,  3550,  3506,  3550,  3513,  3007,  1126,
    1067,   391,    26,  3101,    28,  1529,   717,  2735,   719,  2016,
    1533,  1978,  1496,  2665,  3128,  2721,  3435,  1932,  3437,  3438,
    2688,   367,    46,    47,  2656,  2924,  2969,  2688,    52,  3497,
    2612,  2960,    56,    57,  3344,  3353,  2657,  3120,   384,  3268,
    1139,  3187,  3143,  1974,   390,    69,  1464,  1400,  1122,  1840,
     396,   682,  2237,  1822,  1045,  1854,   666,   455,   599,  3234,
      84,  2838,  2846,  3050,  1415,  2847,  1314,  2049,  3255,  3292,
    2627,  1312,  3099,  1167,   420,  2210,  3544,  3078,  3544,   103,
    1859,  1217,   971,   948,  2861,   431,   432,  1844,   112,   113,
     114,  2861,  1818,  2637,  2579,  2578,  3571,  3428,   445,  2876,
     502,   125,   126,  1144,   719,  2569,   436,  3469,  3430,  3330,
    1366,  3399,   976,  3368,  3595,  2962,  2584,   989,  1421,  2620,
    2289,   467,  2887,  3086,   148,   428,   582,   979,  3222,  2224,
     941,  1131,  3228,   429,   586,  3046,  1288,   472,  1392,   715,
     164,  2014,  2919,  2732,    -1,  3004,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   867,    -1,   869,    -1,
      -1,  3356,    -1,  2940,   188,   511,    -1,   513,    -1,    -1,
      -1,   195,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2960,    -1,    -1,    -1,    -1,    -1,    -1,
     901,    -1,    -1,    -1,    -1,   219,   907,  3392,  3393,    -1,
    3395,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2985,   233,
    2987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2997,    -1,    -1,    -1,    -1,    -1,  3003,   251,    -1,    -1,
      -1,    -1,   256,   944,    -1,   946,    -1,   948,    -1,    -1,
    3435,    -1,  3437,  3438,    -1,    -1,    -1,    -1,  2997,   960,
     961,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,
     971,    -1,    -1,    -1,    -1,    23,    24,    -1,    -1,    -1,
     981,    -1,    -1,  3050,    -1,    -1,    -1,    -1,   989,    -1,
      -1,    -1,    -1,  3538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1003,  1004,  1005,  1006,    54,    55,    56,    -1,
      -1,  3078,  1013,    -1,  1015,    63,    -1,    -1,    -1,    67,
    1021,    -1,    -1,    -1,    -1,    -1,    -1,   341,    76,    -1,
    1031,  3098,    -1,    -1,    -1,    -1,  3103,  3104,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    -1,    13,   362,    -1,
    3117,    -1,    -1,    -1,    -1,   369,    -1,    -1,    -1,    -1,
     108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,  3136,
      -1,    -1,    -1,    -1,    -1,   389,  1077,   391,   392,  1080,
      -1,   395,  3627,    -1,   398,    -1,   400,    -1,    -1,    -1,
      -1,   405,   140,   407,    -1,    -1,    -1,    -1,  3567,    -1,
      -1,    -1,   416,    -1,    -1,  3650,   420,  3174,    -1,    -1,
      -1,    -1,   426,    -1,    -1,    -1,    -1,   431,    84,    -1,
    3187,   435,    -1,    -1,    -1,    -1,    -1,    -1,  1129,    -1,
    1131,  1132,  1133,    -1,  1135,    -1,    -1,    -1,    -1,    -1,
     454,    -1,    -1,  1144,   458,  1146,   112,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,  3648,    -1,   213,    -1,    -1,    -1,    -1,
      -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,   492,  1180,
      -1,    -1,   148,    -1,    -1,    -1,    -1,    -1,  3255,    -1,
      -1,    -1,    -1,   159,   508,    -1,    -1,   511,    -1,    -1,
      -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1220,
      -1,    -1,   188,    -1,    -1,   539,    -1,    -1,    -1,    -1,
      -1,    -1,  3299,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   560,   213,    -1,    -1,
    3317,  3318,   300,   219,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3337,    -1,  3339,    -1,  3341,    -1,    -1,  1278,    -1,  3318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3354,    -1,    -1,
     256,    -1,  1293,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,    -1,   353,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3390,    -1,    -1,   374,   375,    -1,   377,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1349,    -1,
      -1,    -1,    -1,  1354,    -1,  1356,  3423,    -1,    -1,    -1,
    1361,  3428,    -1,    -1,    -1,   413,  1367,    -1,  1369,    -1,
      -1,    -1,    -1,  1374,  1375,    -1,  1377,    -1,    -1,  3446,
      -1,    -1,  3449,  3450,  3451,    -1,    -1,    -1,  1389,    -1,
      -1,  1392,    -1,    -1,    -1,    -1,    -1,  1398,  1399,  1400,
    1401,   367,    -1,    -1,    -1,    -1,    -1,  1408,  1409,  1410,
      -1,    -1,  3479,    -1,    -1,    -1,    -1,    -1,   384,    -1,
      -1,    -1,  3489,  3490,   390,  1426,    -1,  3494,    -1,    -1,
     396,    -1,    -1,    -1,  1435,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3509,    -1,  3511,    -1,   494,    -1,    -1,    -1,
      -1,  1452,    -1,    -1,   420,   503,  1457,    -1,    -1,    -1,
      -1,  3528,    -1,    -1,    -1,   431,   432,    -1,  1469,    -1,
    3537,    -1,    -1,  3540,  1475,    -1,    -1,    -1,    -1,  3546,
      -1,    -1,    -1,    -1,    -1,    -1,  3553,    -1,  3555,  3556,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3564,    -1,    -1,
    3567,   467,    -1,    -1,  3571,    -1,    -1,    -1,    -1,  3576,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3591,    -1,    -1,    -1,  3595,    -1,
    3597,  3598,  1533,    -1,  3601,    -1,  3603,    -1,    -1,    -1,
      -1,  1542,  3609,    -1,    -1,   511,    -1,   513,  3615,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3624,    -1,  3626,
    3627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1570,
    3637,  3638,    23,    24,  3641,    -1,    -1,  1578,    -1,    -1,
    1581,    -1,    -1,  3650,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      13,    14,    -1,    -1,    -1,    56,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    26,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    47,    -1,    -1,    -1,    -1,    52,
      -1,    -1,    93,    56,    57,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,   108,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,
     103,    -1,    -1,    -1,    30,    -1,    32,    33,    -1,   112,
     113,   114,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   125,   126,    -1,    -1,    -1,    -1,    54,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    -1,
      66,    -1,    -1,    -1,    -1,   148,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1744,    -1,    -1,    -1,    83,    84,    -1,
      -1,   164,    -1,    -1,    -1,    -1,    92,    -1,    -1,    -1,
      -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,   220,
      -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,
     504,    -1,   195,    -1,    -1,   198,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,   140,    -1,   219,    -1,   144,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   557,    -1,   286,    -1,   173,   251,   175,
      -1,    -1,    -1,   256,  1845,    -1,    -1,    -1,    -1,   300,
      -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1863,  1864,    -1,    -1,    -1,    -1,    -1,  1870,
      -1,  1872,  1873,    -1,    -1,    -1,   212,   213,    -1,    -1,
     216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,
     351,    -1,   353,    -1,    -1,  1906,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   252,  1918,  1919,    -1,
      -1,   257,    -1,   374,   375,    -1,   377,  1928,   341,    -1,
      -1,    -1,    -1,  1934,    -1,    -1,  1937,    -1,    -1,  1940,
      -1,    -1,    -1,    -1,    -1,   281,    -1,    -1,    -1,   362,
    1951,  1952,    -1,  1954,    -1,    -1,   369,    -1,    -1,  1960,
      -1,   685,   413,    -1,    -1,    -1,    -1,    -1,  1969,    -1,
    1971,  3423,    -1,    -1,  1975,  1976,   389,   313,   391,   392,
      -1,    -1,   395,    -1,    -1,   398,   322,   400,    -1,    -1,
      -1,    -1,   405,    -1,   407,    -1,    -1,  3449,  3450,    -1,
      -1,    -1,    -1,   416,   340,    -1,    -1,   420,    -1,    -1,
      -1,    -1,    -1,   426,  2015,  2016,    -1,    -1,   431,    -1,
      -1,    -1,   435,    -1,    -1,    -1,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,    -1,    -1,    -1,  3489,  3490,    -1,
    2041,   454,  3494,   494,    -1,   458,    -1,  2048,    -1,    -1,
      -1,    -1,   503,    -1,    -1,    -1,    -1,  3509,    -1,  3511,
    2061,    -1,   786,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3528,    -1,    -1,   492,
      -1,    -1,    -1,    -1,    -1,  3537,    -1,    -1,    -1,   425,
      -1,    -1,    -1,    -1,    -1,   508,    -1,    -1,   511,   435,
      -1,  3553,    -1,   516,  3556,    -1,  2107,    -1,    -1,    -1,
      -1,    -1,  3564,    -1,    -1,    -1,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,  3576,    -1,   539,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   472,   861,    -1,  3591,
      -1,   865,    -1,    -1,    -1,    -1,  3598,   560,    -1,  3601,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3609,    -1,    -1,
      -1,    -1,    -1,  3615,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3624,    -1,  3626,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3637,  3638,    -1,  2189,  3641,
     526,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2220,
      -1,    -1,    -1,  2224,    -1,  2226,  2227,  2228,  2229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2237,    -1,    -1,    -1,
    2241,    -1,    -1,  2244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2258,  2259,  2260,
      -1,    -1,    -1,    -1,    -1,   989,    -1,    -1,    -1,    -1,
    2271,    -1,    -1,    -1,   998,    -1,  2277,    -1,  2279,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2287,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2358,    -1,    -1,
    2361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2392,    -1,    -1,    -1,    -1,    -1,    -1,  2399,    -1,
      -1,  2402,    -1,    -1,    -1,  2406,  2407,    -1,    -1,  2410,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2420,
      -1,    -1,    -1,    -1,  1148,  1149,  1150,    -1,    -1,    -1,
      -1,    -1,    -1,  1157,  1158,    -1,    -1,  1161,    -1,  1163,
    1164,  1165,  1166,    -1,    -1,    -1,  1170,    -1,    -1,  1173,
    1174,    -1,  1176,    -1,  1178,  1179,    -1,  1181,  1182,  1183,
    1184,  1185,    -1,  1187,    -1,  1189,  1190,  1191,    -1,  1193,
    1194,  1195,  1196,    -1,  1198,  1199,    -1,  1201,    -1,    -1,
    1204,  1205,  1206,    -1,  1208,  1209,  1210,  1211,    -1,  1213,
    1214,  1215,  1216,    -1,    -1,    -1,    -1,    -1,  1222,  1223,
      -1,  1225,  1226,  1227,  1228,  1229,    -1,    -1,    -1,    -1,
    1234,    -1,  1236,  1237,  1238,  1239,  1240,    -1,    -1,  1243,
    1244,  1245,  1246,  1247,  1248,    -1,  1250,  1251,    -1,    -1,
    1254,  1255,  1256,    -1,  1258,    -1,  1260,    -1,    -1,    -1,
    1264,    -1,  1266,  1267,    -1,    -1,    -1,    -1,  1272,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1280,  1281,  1282,    -1,
      -1,    -1,    -1,    -1,     6,  1289,    -1,    -1,  1292,    31,
      32,    13,    -1,    -1,    -1,    37,    -1,    39,    40,    41,
      -1,    23,    24,  2584,  2585,    -1,  2587,    -1,    -1,    -1,
      -1,    -1,    -1,    55,    -1,  2596,    -1,    -1,    -1,    -1,
      -1,  2602,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      52,  2612,    -1,    -1,    56,    -1,    -1,    -1,    -1,  2620,
      -1,    -1,    -1,    -1,    -1,    67,    -1,  1351,    -1,    -1,
      -1,    -1,    94,    -1,    76,    97,  2637,    -1,    -1,    81,
      -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,  2649,    -1,
      -1,    93,    -1,    -1,    -1,  2656,    -1,    -1,    -1,    -1,
      -1,    -1,   124,    -1,  2665,    -1,   108,    -1,    -1,   111,
      -1,  1395,    -1,    -1,    -1,    -1,    -1,    -1,   120,   141,
      -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,   140,   161,
      -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2739,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   259,   260,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   290,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,  2838,    -1,    -1,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,   310,   311,
     312,    -1,    -1,    -1,   316,    -1,    -1,   319,   300,    -1,
    2861,    -1,    -1,   305,    -1,    -1,    -1,    -1,    -1,    -1,
     332,   333,    -1,    -1,    -1,  2876,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   357,    -1,   359,    -1,    -1,
      -1,    -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,   351,
      -1,   353,    -1,    -1,    -1,    -1,    -1,    -1,  2919,   381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   374,   375,    -1,   377,    -1,    -1,    -1,  2940,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2960,
      -1,    -1,   424,    -1,   426,    -1,    -1,    -1,    -1,    -1,
      -1,   413,    -1,    -1,   436,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2985,    -1,  2987,    -1,    -1,    -1,
      -1,    -1,  1716,  1717,  1718,    -1,  2997,    -1,    -1,    -1,
      -1,    -1,  3003,    -1,    -1,    -1,    -1,    -1,    -1,  1733,
      -1,    -1,    -1,    -1,    -1,   477,   478,    -1,    -1,   481,
     482,   483,   484,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1758,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3050,
      -1,    -1,   494,    -1,    -1,    -1,    -1,  1781,    -1,    -1,
      -1,   503,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3078,    -1,    -1,
      -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3098,    -1,    -1,
      -1,    -1,  3103,  3104,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3117,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3174,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3255,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3299,    -1,
      -1,    -1,    -1,    -1,  2028,    -1,    -1,  2031,    -1,    -1,
    2034,  2035,    -1,    -1,    -1,    -1,  3317,  3318,    -1,    -1,
      -1,    -1,    -1,  2047,    -1,    -1,  2050,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3337,    -1,  3339,  2063,
    3341,  2065,    -1,    -1,    -1,  2069,    -1,  2071,  2072,    -1,
      -1,    -1,  2076,  3354,  2078,  2079,    -1,  2081,    -1,    -1,
    2084,    -1,  2086,  2087,    -1,    -1,    -1,    -1,  2092,  2093,
      -1,    -1,  2096,    -1,  2098,    -1,  2100,    -1,  2102,    -1,
    2104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3390,
      -1,  2115,  2116,    -1,    -1,  2119,    -1,  2121,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2129,  2130,    -1,  2132,    -1,
    2134,    -1,    -1,  2137,  2138,  2139,    -1,  2141,    -1,    -1,
      -1,    -1,  2146,  2147,  2148,  2149,    -1,  3428,    -1,    -1,
    2154,  2155,  2156,    -1,  2158,    -1,  2160,    -1,  2162,    -1,
    2164,    -1,  2166,    -1,    -1,  3446,    -1,    -1,    -1,  2173,
    3451,  2175,    -1,    -1,  2178,  2179,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2190,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3479,    -1,
      -1,    -1,    -1,    -1,    -1,  2209,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2231,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3540,
      -1,    -1,    -1,    -1,    -1,  3546,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3555,    -1,  2280,    -1,    -1,    -1,
      -1,  2285,    -1,    -1,    -1,    -1,  3567,    -1,    -1,    -1,
    3571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3595,    -1,  3597,    -1,    -1,    -1,
      -1,    -1,  3603,    -1,  2328,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2342,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3627,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3650,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2435,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2508,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2518,    -1,  2520,    -1,  2522,    -1,
      -1,    -1,    -1,    -1,  2528,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2553,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2621,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2762,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2772,    -1,
      -1,    -1,    -1,    -1,  2778,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2787,  2788,    -1,    -1,    -1,    -1,  2793,
      -1,    -1,    -1,  2797,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2810,    -1,    -1,    -1,
      -1,    -1,  2816,    -1,    -1,  2819,  2820,    -1,  2822,  2823,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2836,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2902,  2903,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3073,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3086,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3196,    -1,    -1,    -1,    -1,    -1,  3202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3238,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3248,    -1,  3250,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3321,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3379,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3402,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3484,  3485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3502,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3512,    -1,
      -1,    -1,    -1,    -1,  3518,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3527,    -1,    -1,    -1,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,  3560,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    42,    43,    -1,
      45,    46,    -1,  3577,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    -1,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,  3628,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,   239,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,   486,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    -1,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,   337,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    -1,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      -1,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    -1,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    -1,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    -1,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    -1,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,   171,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    -1,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
     171,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    -1,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,   171,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    -1,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    -1,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,    -1,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    -1,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      -1,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    -1,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    -1,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,    -1,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,   174,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,   213,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,   246,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,   420,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,   174,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,   213,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,   232,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,   439,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,   420,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   561,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,   561,    17,    -1,    -1,    20,   566,
     567,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
     222,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,   554,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,   560,    -1,
      17,    -1,    -1,    20,    -1,   567,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   566,
     567,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,   566,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,   566,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,   566,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,    -1,   548,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,   562,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,   554,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,   132,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,   532,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,   546,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,   532,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,   546,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    -1,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,   162,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
     261,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,   325,   326,    -1,   328,    -1,    -1,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
     441,   442,   443,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,   497,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    32,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,   142,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,   427,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    88,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      18,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    -1,    77,    -1,    79,    80,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,   150,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,   171,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    -1,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,   364,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    -1,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    -1,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      -1,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    -1,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,    -1,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   608,   769,   787,   790,   798,   800,   802,   805,
     810,   812,   817,   820,   825,   829,   837,   838,   983,   985,
     991,   994,  1019,  1027,  1038,  1040,  1054,  1057,  1060,  1066,
    1070,  1074,  1077,  1078,  1123,  1140,  1146,  1148,  1155,  1157,
    1182,  1188,  1189,  1190,  1191,  1229,    11,    91,   175,   210,
     366,   783,  1210,  1211,   252,   329,   819,   470,   472,  1142,
    1183,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      77,    79,    86,    93,    94,    97,   102,   103,   109,   111,
     117,   119,   120,   121,   125,   128,   129,   130,   134,   138,
     139,   140,   141,   144,   146,   147,   148,   151,   153,   156,
     159,   160,   161,   164,   169,   170,   173,   175,   182,   183,
     186,   187,   189,   195,   196,   198,   201,   205,   206,   207,
     208,   211,   212,   216,   220,   224,   227,   228,   235,   237,
     241,   244,   250,   252,   255,   257,   267,   268,   269,   270,
     271,   272,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   284,   285,   286,   288,   289,   293,   294,   295,   296,
     299,   300,   303,   305,   307,   310,   311,   312,   313,   314,
     315,   316,   319,   320,   322,   323,   324,   328,   333,   334,
     336,   338,   339,   340,   351,   352,   353,   355,   357,   359,
     362,   363,   365,   367,   368,   370,   371,   372,   373,   374,
     375,   376,   377,   382,   383,   386,   387,   388,   390,   392,
     393,   396,   398,   399,   400,   402,   403,   407,   408,   410,
     411,   413,   414,   415,   416,   418,   419,   423,   424,   425,
     428,   432,   433,   434,   435,   437,   438,   445,   446,   448,
     451,   454,   455,   458,   459,   461,   462,   463,   467,   468,
     470,   471,   473,   474,   477,   478,   479,   480,   481,   487,
     489,   492,   493,   494,   495,   498,   499,   502,   507,   510,
     512,   514,   515,   523,   526,   529,   530,   531,   536,   538,
     539,   543,   596,  1113,  1117,  1121,  1122,   281,  1142,  1142,
     536,  1184,    91,   174,   439,   473,   504,   514,   594,   687,
     688,   689,   761,  1028,   984,    91,   175,   213,   366,   473,
     488,   514,   529,   990,  1117,   819,   595,   567,  1111,  1112,
    1117,   584,   992,  1075,    93,   213,   472,  1142,   819,  1117,
    1071,   416,   514,  1142,   819,   995,  1067,  1142,   595,  1184,
    1117,   840,   842,   843,   342,  1125,  1041,   454,   458,   435,
     487,   435,   472,  1039,  1147,  1020,  1117,    28,    69,   138,
     362,   382,   407,   454,  1231,   420,   560,   839,     0,     3,
     362,   153,  1058,  1111,  1117,   142,   775,  1117,   596,   596,
     472,   109,  1207,  1142,   801,  1184,   826,   827,  1111,   609,
     567,   485,   803,   813,    16,  1185,   209,   690,   595,   347,
    1205,  1207,  1208,  1209,  1210,   472,   688,   213,   210,   264,
     372,  1036,  1037,   904,   905,   209,   989,   989,  1117,   989,
     989,   595,   989,  1142,   579,  1061,    12,    13,    84,   112,
     126,   148,   159,   188,   213,   219,   256,   367,   384,   390,
     396,   420,   431,   432,   467,   511,   513,  1158,  1160,  1162,
    1163,  1117,   340,    60,   380,   567,   245,   476,  1114,  1117,
    1119,   110,   200,   264,   997,    76,   371,  1076,  1079,   222,
    1111,  1141,  1142,   171,    32,   281,  1046,  1072,  1117,   595,
     821,  1142,   110,   264,   998,  1026,   281,   371,   435,  1068,
    1069,   799,    12,  1156,  1160,   485,  1185,   841,    12,   122,
     200,   444,   445,   446,   447,   448,   449,   460,   847,   848,
     849,  1124,    30,    33,    54,    55,    64,    66,    83,    84,
      92,   140,   144,   173,   175,   187,   189,   212,   213,   216,
     231,   252,   257,   281,   313,   322,   340,   365,   366,   425,
     435,   459,   472,   530,   735,   760,  1042,  1046,  1047,  1049,
    1131,   792,   793,   792,   792,   535,   791,   792,   988,  1111,
    1142,  1026,    34,   199,   476,  1099,  1115,  1230,  1230,  1230,
    1230,  1230,   842,   839,   561,  1117,  1056,  1055,   294,   474,
     499,   771,   773,   772,  1111,   142,   450,  1212,   811,   987,
     988,   225,   562,   833,   834,   560,   610,  1117,   586,   987,
     987,    51,   328,   328,   389,  1186,   325,   326,   876,  1117,
      88,  1119,  1120,  1173,  1174,   395,    10,   366,   488,   702,
    1206,  1212,  1213,  1221,  1223,  1207,  1210,   690,  1117,   171,
    1029,  1033,  1034,  1117,  1036,     7,    20,    22,    25,    29,
      32,    34,    35,    36,    38,    50,    54,    55,    61,    64,
      72,    73,    79,    81,    82,    83,    87,    88,    90,    91,
      95,    96,    97,   102,   104,   107,   108,   115,   116,   133,
     136,   137,   149,   152,   154,   155,   158,   162,   167,   172,
     176,   177,   178,   179,   181,   182,   184,   185,   186,   190,
     192,   193,   199,   205,   209,   219,   221,   236,   240,   243,
     248,   250,   253,   258,   261,   266,   273,   283,   287,   295,
     299,   301,   302,   306,   307,   308,   309,   310,   311,   312,
     318,   325,   326,   327,   330,   331,   336,   353,   354,   356,
     357,   358,   359,   360,   370,   378,   394,   395,   406,   409,
     412,   414,   418,   456,   457,   462,   464,   465,   466,   469,
     478,   479,   480,   481,   490,   491,   492,   497,   500,   505,
     506,   514,   518,   519,   520,   521,   522,   527,   531,   541,
     543,   548,   552,   553,   558,   560,   563,   564,   566,   567,
     858,   861,   864,   865,   866,   867,   868,   869,   870,   871,
     872,   873,   877,   880,   881,   883,   890,   894,   906,  1098,
    1100,  1102,  1103,  1107,  1109,  1113,  1115,  1117,   149,  1117,
     596,   337,   596,   596,  1120,  1172,   987,   989,   517,   580,
     117,   201,   257,   281,   365,   371,   399,   435,   455,   470,
    1062,  1063,  1142,   365,  1161,   410,   410,   473,   514,   529,
     342,  1165,   470,  1167,    59,   435,  1164,    92,   529,  1166,
     337,   562,    18,   142,   946,   947,  1149,  1117,   783,   858,
      74,   171,   264,  1080,  1085,    46,   171,  1111,  1143,  1144,
     818,   566,   577,  1114,   257,   822,  1120,   823,   824,  1111,
     806,   222,   988,   999,  1000,    46,   562,   987,  1161,   337,
     416,  1187,  1186,   503,  1192,  1193,   554,   851,   852,   853,
     849,  1126,  1127,  1128,   257,   147,   426,   246,   533,  1053,
     493,   560,    91,   175,   366,   472,   529,  1053,   697,  1119,
     247,   962,   964,    62,   455,   168,   455,   455,   455,   281,
     470,    62,   455,   201,   455,   455,   493,   962,  1053,   171,
     225,  1050,   257,   139,    65,   368,   470,   489,   455,   526,
     789,   388,   451,   794,   795,   788,    77,   783,   562,   339,
    1233,   468,  1234,   230,   402,  1232,   561,  1193,  1195,  1196,
    1197,   837,  1059,  1099,  1117,   108,   684,   685,   686,   695,
     696,   743,   603,   603,   770,  1120,   419,   529,   987,   485,
     562,   108,   828,  1117,   827,   213,   232,   758,   759,   835,
     611,   612,   858,   267,   268,   269,   270,   271,   272,   275,
     276,   277,   278,   279,   280,   282,   386,   387,   587,   588,
     589,   153,   372,   804,    53,   153,   156,   168,   293,   372,
     814,   815,   816,    51,   389,   149,   593,   560,   857,   566,
     207,   562,   853,   853,   853,   529,  1213,  1111,   494,   517,
     762,  1033,  1111,  1117,   562,  1031,   567,  1035,   560,   560,
     560,   560,   560,   881,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   857,   857,
     560,   857,   560,   560,   560,   500,   560,  1098,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   858,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   907,   908,
     909,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   864,   560,   857,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   857,
     560,  1098,   560,   560,   560,  1098,   560,   560,    34,   199,
     476,   560,   560,   560,   857,   857,   857,   560,   560,   560,
     560,   560,   560,   858,   911,   881,   881,   881,   420,   560,
     858,  1200,  1117,   895,  1117,   540,   859,   862,   142,   143,
     180,   194,   226,   238,   265,   321,   878,   225,   246,   385,
     438,   549,   550,   876,   551,   429,   430,   552,   553,   123,
     306,   554,   555,   556,   557,   881,    98,    99,   100,   101,
     102,   170,   202,   203,   204,   205,   295,   297,   298,   299,
     307,   370,   417,   418,   531,   542,   543,   943,   944,    63,
     346,   562,  1115,   560,   567,  1111,   562,    48,   401,   784,
     987,   566,   581,   582,    46,   535,   562,  1064,   470,   560,
    1175,  1175,  1175,  1175,   175,   366,   472,  1159,  1163,  1117,
     160,   323,  1117,  1150,  1151,   999,   281,   252,  1084,   830,
     281,   947,   562,   987,  1119,    27,   485,  1073,   562,   485,
     562,   485,   987,  1000,   996,  1069,   171,   562,   175,   366,
    1159,  1117,    12,   122,  1199,   562,   844,   855,   858,  1105,
    1117,   562,   187,   252,   338,   425,  1129,  1130,  1133,  1134,
     225,  1051,  1114,   858,   554,   690,   596,   596,  1111,  1111,
    1043,   261,   331,   497,   965,   966,  1100,   596,  1053,  1120,
     168,  1048,  1050,   596,  1053,  1048,  1111,  1050,  1048,  1048,
    1053,  1053,   510,   796,   562,   796,   437,   420,   560,   564,
     914,   915,   916,   917,   926,   927,   935,  1099,   355,  1235,
     345,   958,   964,  1198,   686,    63,   735,    67,    79,   235,
     304,   328,   379,   450,   605,   607,     6,    13,    23,    24,
      52,    56,    67,    76,    81,    93,   111,   120,   121,   126,
     134,   140,   165,   211,   213,   220,   286,   300,   305,   351,
     353,   374,   375,   377,   391,   413,   494,   503,   692,   694,
     695,   696,   776,   777,   778,   958,   109,   224,  1111,   814,
    1114,   988,   560,   561,   562,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     562,   512,   815,   684,   561,  1119,    44,  1174,   596,   596,
     175,  1111,   591,    43,   196,   415,   763,   763,   337,  1032,
    1030,   567,  1034,   171,   554,  1117,   947,   858,   858,   858,
      12,   122,   900,   948,   104,   162,   199,   261,   331,   497,
     968,   900,   900,   900,   858,   858,   904,   904,   858,   904,
     858,   858,   858,   858,   122,   900,   948,   858,   561,   858,
     858,   858,   858,   858,  1107,  1117,   858,   858,   858,   858,
     858,   560,  1200,   858,   943,   858,   858,   858,   561,   858,
     858,   858,   858,   904,   858,   858,    94,    97,   478,   481,
     945,   858,   122,   897,  1098,   858,   858,   858,   561,   858,
     858,   858,   858,   904,   858,   858,   858,   858,   908,     9,
     910,  1107,   122,   900,   858,   858,   122,   900,   858,   858,
     858,   858,   858,   904,   904,   904,   858,   858,   858,   858,
     858,   858,   904,   868,   858,   561,   858,   858,   858,   858,
     858,   561,   858,   858,   900,   900,   858,   858,   858,   122,
     900,   858,   858,   944,   944,   858,    42,   239,   486,   858,
     858,  1098,   561,   858,   561,   900,  1108,  1109,  1117,   900,
     858,   858,   858,   532,   913,  1203,  1203,   561,   562,   561,
     858,   566,   896,  1119,   567,   861,   860,   863,   867,   155,
     330,   491,   507,   876,    12,    17,   867,   879,   560,   881,
     868,   246,   868,   869,   225,   246,   385,   549,   870,   871,
     871,   872,   880,   872,   880,   873,   873,   873,   873,   873,
     881,   553,  1119,   881,   858,   882,  1117,   986,  1120,   784,
    1119,   562,   380,  1063,   987,  1065,  1117,  1176,  1177,   554,
    1111,  1117,  1171,  1171,  1171,   142,   160,   180,   194,   237,
     238,   265,   323,   363,  1152,  1154,   533,   949,   993,   214,
     831,   832,  1111,   264,   380,   537,  1145,  1144,   814,   858,
    1114,  1120,  1120,   824,  1111,   153,   372,   515,   807,   808,
     809,   420,   426,   522,   523,   560,   680,  1001,  1004,  1114,
     188,  1171,  1171,  1171,  1194,   852,   171,   222,   845,   846,
     957,   958,   979,   854,   567,  1127,   108,   487,  1117,  1136,
     314,   353,   566,   735,  1135,  1114,   171,  1052,   561,  1117,
     257,   455,  1045,   334,   562,   435,  1053,  1117,  1053,  1048,
    1111,  1053,  1053,   589,   797,   795,   934,  1117,    85,   215,
     230,   243,   317,   406,   460,   925,   426,   562,  1111,   934,
     562,   168,  1236,    44,   962,   142,   427,  1010,  1011,  1011,
    1114,   450,   450,   450,   450,   450,   419,    66,    78,   174,
     439,   707,   710,   711,   756,   758,   782,   782,  1011,  1011,
     782,  1011,  1011,  1011,   485,   119,  1011,   231,   471,   166,
     364,   758,   782,   231,  1011,   471,   119,  1011,  1011,  1011,
     782,  1011,  1011,  1011,  1011,  1011,    18,   142,   485,   786,
    1011,  1011,  1011,   692,   562,   560,   567,   706,   712,  1110,
    1117,   774,   364,   941,  1117,   858,   968,  1114,  1114,   104,
     162,   261,   331,   497,   969,  1114,   968,  1114,  1114,  1114,
    1114,  1114,   968,  1114,  1114,   968,   588,   353,   476,  1225,
       8,    27,   672,   596,  1214,   246,   560,   674,   691,   693,
     694,  1111,   517,   949,  1117,   915,   567,  1035,   562,   561,
     561,   562,   900,   561,   901,   562,   561,   561,   561,    18,
     561,   517,   561,   561,   561,   561,   562,   562,   517,   562,
     562,   891,   561,   554,   561,   562,   562,   561,   561,   562,
     561,   567,   561,   562,   561,   562,   562,   562,   561,   562,
     561,   562,   171,   562,   562,   561,   562,   561,   562,   562,
     561,   562,   561,   561,   562,   561,   562,   562,   562,   893,
     562,   561,   562,   562,   561,   562,   562,   561,   562,   561,
     562,   561,   562,   562,   562,   561,   560,   562,   900,   561,
     561,   561,   900,   561,   561,   562,   562,   561,   561,   562,
     561,   562,   561,   561,   561,   561,   561,   561,   561,   562,
     562,   561,   562,   561,   225,   561,   561,   562,   562,   562,
     561,   562,   562,   561,   561,   561,   562,   171,   562,   562,
     900,   561,   561,   561,   562,   562,   562,   561,   171,   858,
     171,   858,   171,   858,   171,   561,   562,   562,   561,   561,
     561,   561,   561,   562,   561,   562,   561,   858,   532,   546,
     912,   840,  1202,  1200,   904,   565,   187,   252,   425,  1132,
     427,  1117,   344,   347,   874,    15,    16,   875,   155,   330,
     491,   507,   560,   858,  1200,   146,   953,   868,    16,   560,
     881,   868,   868,   943,   943,   858,   885,   886,   887,   560,
     567,   582,   256,   561,   562,   567,   567,   485,   485,   485,
    1153,   950,   963,   964,  1001,   476,  1116,   562,   833,   537,
     252,   485,   808,   681,  1002,   560,  1007,  1012,  1007,   561,
     680,  1003,  1104,  1105,  1108,  1117,  1005,   342,   171,   171,
     171,   838,   127,   915,   980,   168,   256,   850,   979,   963,
     846,    18,   856,  1114,  1117,   554,  1117,   567,   227,   567,
    1010,    32,   108,   736,   737,  1010,  1119,   168,  1010,   566,
    1119,    32,   108,   738,   739,  1119,   969,  1044,   144,   530,
     966,   966,   535,   949,  1048,   562,   929,   934,   914,   230,
     230,   348,   936,   230,   243,   406,   936,   926,   914,  1022,
    1023,  1108,   914,   947,   931,   932,   968,   296,   959,   108,
     740,   742,  1119,   737,    93,    93,   109,   224,   766,  1110,
     759,   759,    57,   166,   364,   504,   709,   757,   708,   709,
     766,  1110,   969,   968,  1110,   968,  1114,  1114,   735,  1011,
     968,   232,   232,  1110,  1110,   697,  1011,   160,   237,   328,
     700,   969,   969,  1110,   108,   968,  1114,   968,   968,   373,
     376,   699,   968,  1111,    70,    71,   108,   130,   161,   383,
     698,   697,   560,   778,   704,   705,   706,   707,  1117,     8,
     160,   785,   384,   708,   748,   713,   567,   560,  1215,   561,
     562,   476,   560,   112,   219,   511,   673,  1224,  1215,  1111,
     246,   675,   680,   704,   210,   395,   677,  1086,   562,   693,
     592,   915,   957,   949,   947,   221,   858,   858,   561,   858,
     858,    32,    55,    94,    97,   105,   319,   433,   481,   509,
     902,   736,   904,   858,   736,   902,   858,   904,   561,   880,
     880,  1115,  1117,   858,   858,   904,  1115,   858,   858,   858,
     904,   331,   858,   858,   858,   858,   858,   858,   858,   904,
     904,   331,   858,   858,   904,   858,   858,   858,   858,   904,
     858,   868,  1107,   561,   561,   858,   858,   858,   858,   858,
     858,   858,   858,   858,   858,   858,   858,   904,   221,   858,
     858,   858,   858,   561,   858,   858,   858,   858,   171,   858,
     171,   858,   171,   858,   858,   331,   858,   858,   547,   858,
     858,   138,  1204,   561,   561,   567,   567,   567,  1119,   858,
     861,   864,  1200,   561,   562,   561,   881,   867,   858,  1200,
     953,    16,   561,   853,   888,   889,   903,   904,  1117,  1177,
     554,   554,  1173,  1173,  1173,   560,   858,   337,  1017,  1081,
     832,   210,   836,  1120,   847,  1008,  1009,  1108,  1013,   562,
     560,  1004,   561,   561,   562,   567,  1192,   171,  1173,  1173,
    1173,   949,   949,   128,   349,   975,   976,   981,   511,   225,
    1114,  1117,   567,  1117,   244,  1117,    12,    32,   108,   337,
     858,  1139,    63,   741,   858,  1120,   336,   353,   476,  1138,
    1132,  1010,   962,   269,  1053,   589,  1195,   930,   243,   230,
     926,   936,   936,   230,   337,   337,   517,   562,  1021,  1010,
     165,   210,   516,   937,   847,   858,   960,  1106,   858,   232,
     232,   759,   766,   762,   126,   426,   779,   737,  1114,   766,
     784,  1114,   780,   987,   561,   562,  1117,  1111,    31,    32,
      37,    39,    40,    41,    55,    94,    97,   105,   124,   141,
     161,   163,   182,   183,   223,   250,   259,   260,   262,   290,
     291,   292,   310,   311,   312,   316,   319,   332,   333,   357,
     359,   381,   424,   426,   436,   477,   478,   481,   482,   483,
     484,   524,   525,   543,   714,   717,   718,   719,   720,   721,
     722,   723,  1117,  1117,  1216,    18,  1117,  1226,   337,   403,
     560,   597,    18,  1111,   561,   561,    18,   683,   693,   560,
     949,   247,   967,   858,   561,   561,   561,   560,   729,   729,
     560,   724,   725,   729,   223,   223,   561,   561,   561,   561,
     561,   561,   562,   892,   943,   943,   561,   561,   561,   561,
     561,   561,   562,   561,   561,   561,   561,   561,   562,   561,
     561,   561,   561,   561,   899,   958,   562,   562,   562,   561,
     561,   561,   561,   562,   561,   561,   561,   562,   225,   535,
     884,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     562,   561,   561,   561,   858,   561,   168,   561,   561,   562,
     562,   561,   562,   562,   561,   858,   561,   858,   561,   858,
     561,   561,   562,   561,   561,   858,   547,  1201,   567,   767,
     561,   904,   561,   562,   561,   867,   858,   562,   561,   397,
    1178,  1178,  1178,   108,   858,  1015,  1016,   129,  1086,   241,
     851,   562,  1010,  1014,  1015,  1012,  1006,  1004,  1104,  1117,
    1173,   963,   191,   954,  1116,  1116,   566,   977,   978,  1119,
     428,   554,   380,   393,   423,  1137,   742,  1010,   560,   560,
    1136,   858,   142,   561,   916,   348,   914,   926,   230,   230,
     914,   926,   919,   918,   920,  1023,   949,  1016,   758,   938,
     938,   938,   851,   562,    19,   113,   961,   766,   762,   560,
     108,   108,   712,   741,   714,   561,   705,   749,   560,   560,
     729,   724,   361,   715,   724,   724,    20,    32,    45,   502,
     735,   744,    55,   524,   718,   720,   744,   744,    55,   525,
     525,   528,   724,   716,   729,   729,   744,   560,   729,    23,
      63,    67,   108,   330,   337,   364,   424,   504,   731,   732,
     733,   747,   876,   528,   560,   744,    32,   560,   745,   560,
     560,   729,   560,   725,   730,   567,   561,   562,  1217,  1218,
     217,   225,   350,   617,   618,   619,   620,   853,   105,   223,
     381,   461,   703,   598,  1217,   561,   676,   691,   560,   680,
     764,   765,  1117,   966,   943,   331,   744,   331,   858,   561,
     561,   561,   858,   858,   422,   898,   331,   858,   858,   858,
     858,    40,   371,   561,   858,   943,   858,   858,   858,   858,
     858,   561,   561,   561,   331,   858,  1192,  1117,   561,   904,
     854,   889,    58,   228,   324,   452,   463,   538,  1169,  1170,
     535,  1179,  1179,  1179,   561,   562,  1018,   222,   682,  1009,
    1016,   561,  1195,    44,   197,   951,   982,  1119,   562,   303,
      68,   498,   380,  1138,   476,   476,  1010,  1114,   947,   230,
     337,   922,   926,   926,   337,   924,   858,   858,   560,   957,
     939,   933,  1106,   560,   560,   764,    97,   478,   481,   552,
     553,  1101,  1102,   785,   731,   283,   337,   560,   750,   752,
     753,   754,   331,   331,   433,   509,   544,   726,   727,   728,
     560,   726,   726,   745,    20,   502,   735,   746,   745,   736,
     744,   528,   726,   560,   744,   331,   726,   740,  1114,   327,
     734,  1101,   511,   108,   232,   733,   232,   330,   331,   331,
     331,   331,   726,   331,   726,  1117,  1117,   535,  1220,   420,
     560,  1219,   561,   562,   615,  1111,   496,   613,   614,   616,
    1117,  1220,  1195,   677,   680,   678,   561,   562,   961,   560,
     561,   561,   561,   562,   561,   561,   562,   561,  1099,   561,
     562,   561,   562,   561,   561,   303,   151,   561,   561,   561,
     561,   561,   561,   561,   562,  1204,   561,   856,   476,   476,
     476,    16,  1168,   188,   284,   285,   288,   289,  1180,  1181,
    1016,   232,  1082,   701,   846,   963,   955,  1106,   952,   957,
      65,  1087,   978,   561,   561,  1139,    16,   914,   921,   517,
     923,   517,   942,  1117,   967,   560,   701,   961,   764,   764,
     561,  1103,  1103,   781,   173,   352,   434,   112,   511,   751,
    1117,   754,   561,   561,   728,   768,  1099,   736,   745,   768,
     561,   857,   327,   523,   561,   561,   561,   561,    49,    57,
     252,   853,   853,  1227,   619,  1117,   168,  1114,   561,   562,
     615,   561,  1192,   765,   331,   331,   858,   900,   858,   904,
    1169,   342,   968,   968,   968,   968,  1181,   511,   472,   850,
     535,   562,   956,   961,   858,   963,   135,   145,   343,   475,
    1088,  1089,   249,  1090,   270,   337,   858,   560,   858,   560,
     561,   562,   940,   941,   561,   561,   785,    48,   328,   401,
     426,   755,   755,   561,   562,   561,   562,   561,   857,   744,
     745,   744,   745,    57,   342,    57,   840,   839,   604,   714,
     853,   599,   616,   714,   679,   961,   561,   561,   561,   562,
     561,   561,   561,  1024,  1025,  1108,  1111,    86,   408,  1106,
     366,   970,    44,    44,   135,    44,  1089,   453,   475,  1091,
    1092,   142,   928,   942,   942,  1117,   561,   748,     5,   108,
     330,   752,  1117,   744,  1099,   744,   342,   342,   561,   118,
     605,   606,   876,  1228,   131,   403,  1195,   858,   562,  1010,
    1083,   961,  1117,  1099,  1099,    44,  1099,    44,    44,  1092,
     969,   858,   561,   561,  1195,   118,    60,   157,   209,   229,
     242,   340,   404,   548,   636,   637,   640,   649,   650,   653,
     664,  1113,  1118,  1122,   414,   600,   561,  1025,  1016,  1087,
     971,  1099,  1099,  1099,    16,   565,  1117,   171,   323,   642,
     639,  1118,  1118,  1117,   638,   651,   654,   573,    28,   263,
     394,   534,   667,   569,  1222,   714,  1090,   560,   274,   171,
    1117,   644,   645,   858,   858,   532,   656,   660,   668,   622,
     636,   622,   669,   665,   636,   601,   210,  1093,   853,   972,
     973,   974,   142,   222,   138,   858,   652,   661,   546,   660,
     663,   623,   138,   636,   568,   510,   858,   667,   604,   331,
     560,  1094,   858,   561,   562,   968,   641,   209,   547,   532,
     655,   657,   858,   622,   138,   106,   621,   624,   263,   568,
     671,   125,   666,  1118,   602,   249,   561,   566,  1095,  1096,
    1108,   426,  1097,   974,   643,  1117,   646,   658,   657,   663,
     662,   548,    80,   150,   629,   634,  1117,   138,   636,   568,
     858,   670,   636,  1119,   561,   562,  1024,   562,   622,   858,
     138,   547,   195,   562,   625,    75,    89,   568,   138,   622,
    1096,  1117,   647,   659,   548,   622,   168,  1117,   714,   168,
     168,   394,   138,   132,   546,   648,   547,   626,   108,   635,
     442,   631,   968,   627,   628,   534,   644,   622,   622,   441,
     443,   630,   631,   633,   876,  1117,   858,   523,   632,   573,
     562,   636,   169,  1115,   633
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1062 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1075 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1135 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1155 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1169 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1176 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1185 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            yyerror(ER(ER_SYNTAX_ERROR));
            YYABORT;
          }
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1197 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1211 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              YYABORT;
        }
    break;

  case 66:
#line 1223 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           YYABORT;
         }
       }
    break;

  case 67:
#line 1231 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1241 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1247 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1256 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1261 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1266 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1271 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1276 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1280 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1285 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1289 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1293 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1297 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1301 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1310 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1314 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1330 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1334 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1345 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 (using_update_log ?
						  TL_READ_NO_INSERT:
						  TL_READ)))
	    YYABORT;
	  lex->create_list.empty();
	  lex->key_list.empty();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	  lex->name=0;
	}
    break;

  case 89:
#line 1366 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1368 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      YYABORT;
	    lex->create_list.empty();
	    lex->key_list.empty();
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1380 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->key_list.push_back(new Key((yyvsp[-9].key_type),(yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list));
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1387 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1392 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1399 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1405 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1407 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1414 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1429 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str));
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1444 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str));
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1462 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1481 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(YYTHD);
	    sp->init(lex);
            sp->init_sp_name(YYTHD, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
	    YYTHD->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lex->tok_start+1;
	  }
    break;

  case 102:
#line 1518 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_param_end= lex->tok_start;
	  }
    break;

  case 103:
#line 1524 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1532 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1544 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lex->tok_start;
	  }
    break;

  case 106:
#line 1551 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1573 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1574 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1578 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1579 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1585 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1587 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1589 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1591 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1593 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1595 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1597 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1602 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1603 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1604 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1609 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1613 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1620 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1628 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1644 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1648 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1666 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1686 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1723 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1748 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1749 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1750 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1751 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1755 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1760 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1766 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1770 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1796 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1804 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1852 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 1866 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	    sp->m_flags|= sp_head::IN_HANDLER;
	  }
    break;

  case 156:
#line 1879 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);
	    sp->m_flags&= ~sp_head::IN_HANDLER;
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    ctx->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 1906 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 1929 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 1938 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 1960 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 1961 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 1967 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= 1;
	    }
	  }
    break;

  case 163:
#line 1988 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
	        (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= (yyvsp[-2].num) + 1;
	    }
	  }
    break;

  case 164:
#line 2012 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 165:
#line 2018 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 166:
#line 2032 "sql_yacc.yy"
    {}
    break;

  case 167:
#line 2033 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2038 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 169:
#line 2042 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	  }
    break;

  case 170:
#line 2051 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 171:
#line 2056 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 172:
#line 2061 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 173:
#line 2069 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 174:
#line 2084 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 175:
#line 2101 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 176:
#line 2102 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 177:
#line 2106 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->reset_lex(YYTHD);
	    lex->sphead->m_tmp_query= lex->tok_start;
	  }
    break;

  case 178:
#line 2113 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lex->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lex->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(YYTHD->mem_root,
                                           (char *)sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(YYTHD);
          }
    break;

  case 179:
#line 2152 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 180:
#line 2154 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 181:
#line 2175 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 182:
#line 2177 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 184:
#line 2180 "sql_yacc.yy"
    {}
    break;

  case 185:
#line 2181 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 186:
#line 2187 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 187:
#line 2193 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 188:
#line 2222 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2250 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2265 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2280 "sql_yacc.yy"
    { }
    break;

  case 192:
#line 2282 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 196:
#line 2306 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:
#line 2327 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2349 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 199:
#line 2351 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:
#line 2365 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:
#line 2376 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:
#line 2396 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 208:
#line 2402 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2413 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:
#line 2421 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:
#line 2429 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:
#line 2447 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 217:
#line 2451 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2460 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 219:
#line 2468 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 220:
#line 2472 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2479 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 222:
#line 2487 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 224:
#line 2500 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:
#line 2518 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 226:
#line 2537 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 227:
#line 2538 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 228:
#line 2543 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context();
	  }
    break;

  case 229:
#line 2555 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 230:
#line 2571 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 231:
#line 2580 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 232:
#line 2582 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 233:
#line 2596 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 234:
#line 2606 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 235:
#line 2608 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 236:
#line 2624 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 237:
#line 2626 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 238:
#line 2631 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 239:
#line 2633 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 240:
#line 2635 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 241:
#line 2639 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2640 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2642 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[0].table)))
              YYABORT;
            if ((yyvsp[0].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[0].table)->db.str), &((yyvsp[0].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 244:
#line 2654 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[-1].table)))
              YYABORT;
            if ((yyvsp[-1].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[-1].table)->db.str), &((yyvsp[-1].table)->db.length)))
            {
              YYABORT;
            }
          }
    break;

  case 245:
#line 2668 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2669 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 247:
#line 2669 "sql_yacc.yy"
    {}
    break;

  case 248:
#line 2673 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2675 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 250:
#line 2675 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2677 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 252:
#line 2677 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2682 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 254:
#line 2698 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 255:
#line 2702 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 256:
#line 2712 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2713 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2716 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2717 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2720 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2721 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2724 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2725 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2728 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 265:
#line 2729 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 266:
#line 2732 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 267:
#line 2733 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 268:
#line 2736 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 269:
#line 2739 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 270:
#line 2740 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 278:
#line 2756 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 279:
#line 2757 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2758 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 281:
#line 2759 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 282:
#line 2760 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 283:
#line 2761 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 284:
#line 2762 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 285:
#line 2763 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 286:
#line 2765 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                yyerror(ER(ER_SYNTAX_ERROR));
                YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 287:
#line 2780 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2785 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 289:
#line 2786 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 290:
#line 2787 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 291:
#line 2789 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    YYABORT;
	  }
    break;

  case 292:
#line 2794 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    YYABORT;
	  }
    break;

  case 293:
#line 2799 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    YYABORT;
	  }
    break;

  case 294:
#line 2804 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 297:
#line 2820 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 298:
#line 2821 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 299:
#line 2822 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 300:
#line 2823 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 301:
#line 2828 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 302:
#line 2845 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2861 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 304:
#line 2870 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 305:
#line 2871 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 306:
#line 2872 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 307:
#line 2873 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 308:
#line 2874 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 309:
#line 2875 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 310:
#line 2878 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 311:
#line 2879 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 2880 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 313:
#line 2883 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 314:
#line 2884 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 315:
#line 2885 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 316:
#line 2888 "sql_yacc.yy"
    {}
    break;

  case 318:
#line 2892 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 319:
#line 2893 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 320:
#line 2896 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 321:
#line 2897 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 322:
#line 2898 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 323:
#line 2899 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 329:
#line 2914 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 2921 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->key_list.push_back(new Key((yyvsp[-5].key_type),(yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list));
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 2927 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
	    lex->key_list.push_back(new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0,
				    lex->col_list));
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 2935 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->key_list.push_back(new foreign_key((yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-7].simple_string), lex->col_list,
				    (yyvsp[0].table),
				    lex->ref_list,
				    lex->fk_delete_opt,
				    lex->fk_update_opt,
				    lex->fk_match_option));
	    lex->key_list.push_back(new Key(Key::MULTIPLE, (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string),
					    HA_KEY_ALG_UNDEF, 1,
					    lex->col_list));
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 2949 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 2953 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 338:
#line 2968 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 339:
#line 2969 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 340:
#line 2973 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 341:
#line 2978 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 342:
#line 2986 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    YYABORT;
	}
    break;

  case 343:
#line 2999 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 344:
#line 3000 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 345:
#line 3001 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 346:
#line 3002 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 347:
#line 3004 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3006 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 349:
#line 3008 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3010 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 351:
#line 3012 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3014 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 353:
#line 3017 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3020 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 355:
#line 3023 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3026 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 357:
#line 3028 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 358:
#line 3031 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 359:
#line 3034 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 360:
#line 3035 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 361:
#line 3036 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 362:
#line 3038 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 363:
#line 3050 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 364:
#line 3051 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 365:
#line 3053 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 366:
#line 3056 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            YYABORT;
#endif
          }
    break;

  case 367:
#line 3067 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 368:
#line 3069 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 369:
#line 3071 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 370:
#line 3073 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 371:
#line 3074 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 372:
#line 3075 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 373:
#line 3076 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 374:
#line 3077 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 375:
#line 3079 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 376:
#line 3081 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 377:
#line 3083 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3084 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 379:
#line 3085 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 380:
#line 3086 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 381:
#line 3087 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 382:
#line 3088 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 383:
#line 3090 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 384:
#line 3098 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 385:
#line 3099 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 386:
#line 3100 "sql_yacc.yy"
    { Lex->length= (char*)"21";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 387:
#line 3103 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 388:
#line 3104 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 389:
#line 3105 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 390:
#line 3106 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 391:
#line 3107 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 392:
#line 3111 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3115 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3116 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3120 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3121 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3125 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3126 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3127 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3128 "sql_yacc.yy"
    {}
    break;

  case 401:
#line 3129 "sql_yacc.yy"
    {}
    break;

  case 402:
#line 3133 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 403:
#line 3134 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 404:
#line 3135 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 405:
#line 3136 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 406:
#line 3137 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 407:
#line 3140 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 408:
#line 3142 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 409:
#line 3143 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 410:
#line 3147 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 411:
#line 3148 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 412:
#line 3149 "sql_yacc.yy"
    {}
    break;

  case 413:
#line 3153 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 414:
#line 3159 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3160 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3163 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3164 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3167 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3168 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 420:
#line 3169 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 421:
#line 3172 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 422:
#line 3173 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 423:
#line 3176 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3177 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3180 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3181 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3184 "sql_yacc.yy"
    {}
    break;

  case 429:
#line 3188 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 430:
#line 3189 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 431:
#line 3190 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 432:
#line 3192 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 433:
#line 3193 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 434:
#line 3195 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 435:
#line 3201 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3207 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 437:
#line 3213 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 438:
#line 3218 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 439:
#line 3220 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 440:
#line 3235 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 441:
#line 3236 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 442:
#line 3240 "sql_yacc.yy"
    {}
    break;

  case 443:
#line 3241 "sql_yacc.yy"
    {}
    break;

  case 444:
#line 3246 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 445:
#line 3253 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 446:
#line 3257 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 447:
#line 3258 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 448:
#line 3263 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 449:
#line 3271 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 450:
#line 3275 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 451:
#line 3276 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 452:
#line 3280 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    YYABORT;
	  }
	}
    break;

  case 453:
#line 3289 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 454:
#line 3290 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 455:
#line 3294 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 456:
#line 3295 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 457:
#line 3298 "sql_yacc.yy"
    {}
    break;

  case 458:
#line 3299 "sql_yacc.yy"
    {}
    break;

  case 459:
#line 3302 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 460:
#line 3303 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 461:
#line 3304 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 462:
#line 3306 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    YYABORT;
	  }
	}
    break;

  case 463:
#line 3314 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 464:
#line 3315 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 465:
#line 3318 "sql_yacc.yy"
    { }
    break;

  case 466:
#line 3319 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 467:
#line 3322 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 468:
#line 3323 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 469:
#line 3325 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    YYABORT;
	  }
	}
    break;

  case 470:
#line 3333 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 473:
#line 3342 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 474:
#line 3348 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 475:
#line 3353 "sql_yacc.yy"
    {}
    break;

  case 476:
#line 3354 "sql_yacc.yy"
    {}
    break;

  case 477:
#line 3357 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 478:
#line 3358 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 479:
#line 3362 "sql_yacc.yy"
    {}
    break;

  case 480:
#line 3363 "sql_yacc.yy"
    {}
    break;

  case 481:
#line 3366 "sql_yacc.yy"
    {}
    break;

  case 482:
#line 3367 "sql_yacc.yy"
    {}
    break;

  case 483:
#line 3370 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 484:
#line 3371 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 485:
#line 3372 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 486:
#line 3373 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 487:
#line 3374 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 488:
#line 3377 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 489:
#line 3378 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 490:
#line 3379 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 491:
#line 3380 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 492:
#line 3381 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 493:
#line 3384 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 494:
#line 3385 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 495:
#line 3387 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    YYABORT;
#endif
	  }
    break;

  case 496:
#line 3398 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 497:
#line 3399 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 498:
#line 3402 "sql_yacc.yy"
    {}
    break;

  case 499:
#line 3403 "sql_yacc.yy"
    {}
    break;

  case 500:
#line 3406 "sql_yacc.yy"
    {}
    break;

  case 502:
#line 3411 "sql_yacc.yy"
    {}
    break;

  case 503:
#line 3412 "sql_yacc.yy"
    {}
    break;

  case 504:
#line 3413 "sql_yacc.yy"
    {}
    break;

  case 505:
#line 3416 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 506:
#line 3417 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 507:
#line 3418 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 508:
#line 3420 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    YYABORT;
#endif
	  }
    break;

  case 509:
#line 3432 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 510:
#line 3433 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 511:
#line 3434 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 512:
#line 3437 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 513:
#line 3439 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 514:
#line 3442 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 515:
#line 3445 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 516:
#line 3446 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 517:
#line 3449 "sql_yacc.yy"
    { (yyval.key_part)=new key_part_spec((yyvsp[0].lex_str).str); }
    break;

  case 518:
#line 3451 "sql_yacc.yy"
    {
          int key_part_len= atoi((yyvsp[-1].lex_str).str);
          if (!key_part_len)
          {
            my_error(ER_KEY_PART_0, MYF(0), (yyvsp[-3].lex_str).str);
          }
          (yyval.key_part)=new key_part_spec((yyvsp[-3].lex_str).str,(uint) key_part_len);
        }
    break;

  case 519:
#line 3461 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 520:
#line 3462 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].lex_str).str; }
    break;

  case 521:
#line 3465 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 522:
#line 3466 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 523:
#line 3469 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 524:
#line 3470 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 525:
#line 3478 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex= thd->lex;
	  lex->sql_command= SQLCOM_ALTER_TABLE;
	  lex->name= 0;
	  lex->duplicates= DUP_ERROR; 
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING))
	    YYABORT;
	  lex->create_list.empty();
	  lex->key_list.empty();
	  lex->col_list.empty();
          lex->select_lex.init_order();
	  lex->select_lex.db=
            ((TABLE_LIST*) lex->select_lex.table_list.first)->db;
          lex->name=0;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.db_type= DB_TYPE_DEFAULT;
	  lex->create_info.default_table_charset= NULL;
	  lex->create_info.row_type= ROW_TYPE_NOT_USED;
	  lex->alter_info.reset();
	  lex->alter_info.flags= 0;
	}
    break;

  case 526:
#line 3502 "sql_yacc.yy"
    {}
    break;

  case 527:
#line 3504 "sql_yacc.yy"
    {
            Lex->create_info.default_table_charset= NULL;
            Lex->create_info.used_fields= 0;
          }
    break;

  case 528:
#line 3509 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            THD *thd= Lex->thd;
	    lex->sql_command=SQLCOM_ALTER_DB;
	    lex->name= (yyvsp[-2].simple_string);
            if (lex->name == NULL && thd->copy_db_to(&lex->name, NULL))
              YYABORT;
	  }
    break;

  case 529:
#line 3518 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "PROCEDURE");
	      YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 530:
#line 3529 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_PROCEDURE;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 531:
#line 3536 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "FUNCTION");
	      YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 532:
#line 3547 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_FUNCTION;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 533:
#line 3555 "sql_yacc.yy"
    {
	    THD *thd= YYTHD;
	    LEX *lex= thd->lex;
	    lex->sql_command= SQLCOM_CREATE_VIEW;
	    lex->create_view_mode= VIEW_ALTER;
	    /* first table in list is target VIEW name */
	    lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL, TL_OPTION_UPDATING);
	  }
    break;

  case 534:
#line 3564 "sql_yacc.yy"
    {}
    break;

  case 535:
#line 3568 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 536:
#line 3569 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].lex_str).str; }
    break;

  case 538:
#line 3572 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= DISCARD_TABLESPACE; }
    break;

  case 539:
#line 3573 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= IMPORT_TABLESPACE; }
    break;

  case 542:
#line 3579 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->change=0;
	  lex->alter_info.flags|= ALTER_ADD_COLUMN;
	}
    break;

  case 543:
#line 3586 "sql_yacc.yy"
    { }
    break;

  case 544:
#line 3588 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_INDEX;
	  }
    break;

  case 545:
#line 3592 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_COLUMN | ALTER_ADD_INDEX;
          }
    break;

  case 546:
#line 3596 "sql_yacc.yy"
    {
	     LEX *lex=Lex;
	     lex->change= (yyvsp[0].lex_str).str;
	     lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
	  }
    break;

  case 548:
#line 3603 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->length=lex->dec=0; lex->type=0;
            lex->default_value= lex->on_update_value= 0;
            lex->comment=null_lex_str;
	    lex->charset= NULL;
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
          }
    break;

  case 549:
#line 3612 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (add_field_to_list(lex->thd,(yyvsp[-3].lex_str).str,
                                  (enum enum_field_types) (yyvsp[-1].num),
                                  lex->length,lex->dec,lex->type,
                                  lex->default_value, lex->on_update_value,
                                  &lex->comment,
				  (yyvsp[-3].lex_str).str, &lex->interval_list, lex->charset,
				  lex->uint_geom_type))
	       YYABORT;
          }
    break;

  case 551:
#line 3625 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
                                                               (yyvsp[-1].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_COLUMN;
	  }
    break;

  case 552:
#line 3632 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_DROP_INDEX;
          }
    break;

  case 553:
#line 3636 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
				               primary_key_name));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 554:
#line 3643 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
					                       (yyvsp[0].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 555:
#line 3650 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= DISABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 556:
#line 3656 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= ENABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 557:
#line 3662 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.alter_list.push_back(new Alter_column((yyvsp[-3].lex_str).str,(yyvsp[0].item)));
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN_DEFAULT;
	  }
    break;

  case 558:
#line 3668 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.alter_list.push_back(new Alter_column((yyvsp[-2].lex_str).str,
                                                                  (Item*) 0));
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN_DEFAULT;
	  }
    break;

  case 559:
#line 3675 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            THD *thd= lex->thd;
	    lex->select_lex.db=(yyvsp[0].table)->db.str;
            if (lex->select_lex.db == NULL &&
                thd->copy_db_to(&lex->select_lex.db, NULL))
            {
              YYABORT;
            }
            if (check_table_name((yyvsp[0].table)->table.str,(yyvsp[0].table)->table.length) ||
                (yyvsp[0].table)->db.str && check_db_name((yyvsp[0].table)->db.str))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[0].table)->table.str);
              YYABORT;
            }
	    lex->name= (yyvsp[0].table)->table.str;
	    lex->alter_info.flags|= ALTER_RENAME;
	  }
    break;

  case 560:
#line 3694 "sql_yacc.yy"
    {
	    if (!(yyvsp[-1].charset))
	    {
	      THD *thd= YYTHD;
	      (yyvsp[-1].charset)= thd->variables.collation_database;
	    }
	    (yyvsp[0].charset)= (yyvsp[0].charset) ? (yyvsp[0].charset) : (yyvsp[-1].charset);
	    if (!my_charset_same((yyvsp[-1].charset),(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, (yyvsp[-1].charset)->csname);
	      YYABORT;
	    }
	    LEX *lex= Lex;
	    lex->create_info.table_charset=
	      lex->create_info.default_table_charset= (yyvsp[0].charset);
	    lex->create_info.used_fields|= (HA_CREATE_USED_CHARSET |
					    HA_CREATE_USED_DEFAULT_CHARSET);
	    lex->alter_info.flags|= ALTER_CONVERT;
	  }
    break;

  case 561:
#line 3715 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.flags|= ALTER_OPTIONS;
	  }
    break;

  case 562:
#line 3720 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_FORCE;
	   }
    break;

  case 563:
#line 3724 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.flags|= ALTER_ORDER;
	  }
    break;

  case 564:
#line 3730 "sql_yacc.yy"
    {}
    break;

  case 565:
#line 3731 "sql_yacc.yy"
    {}
    break;

  case 566:
#line 3734 "sql_yacc.yy"
    { Lex->ignore= 0;}
    break;

  case 567:
#line 3735 "sql_yacc.yy"
    { Lex->ignore= 1;}
    break;

  case 568:
#line 3739 "sql_yacc.yy"
    { Lex->drop_mode= DROP_DEFAULT; }
    break;

  case 569:
#line 3740 "sql_yacc.yy"
    { Lex->drop_mode= DROP_RESTRICT; }
    break;

  case 570:
#line 3741 "sql_yacc.yy"
    { Lex->drop_mode= DROP_CASCADE; }
    break;

  case 571:
#line 3745 "sql_yacc.yy"
    {}
    break;

  case 572:
#line 3746 "sql_yacc.yy"
    { store_position_for_column((yyvsp[0].lex_str).str); }
    break;

  case 573:
#line 3747 "sql_yacc.yy"
    { store_position_for_column(first_keyword); }
    break;

  case 574:
#line 3750 "sql_yacc.yy"
    {}
    break;

  case 575:
#line 3751 "sql_yacc.yy"
    {}
    break;

  case 576:
#line 3752 "sql_yacc.yy"
    {}
    break;

  case 577:
#line 3753 "sql_yacc.yy"
    {}
    break;

  case 578:
#line 3761 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->sql_command = SQLCOM_SLAVE_START;
	    lex->type = 0;
	    /* We'll use mi structure for UNTIL options */
	    bzero((char*) &lex->mi, sizeof(lex->mi));
            /* If you change this code don't forget to update SLAVE START too */
          }
    break;

  case 579:
#line 3770 "sql_yacc.yy"
    {}
    break;

  case 580:
#line 3772 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->sql_command = SQLCOM_SLAVE_STOP;
	    lex->type = 0;
            /* If you change this code don't forget to update SLAVE STOP too */
          }
    break;

  case 581:
#line 3779 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
           lex->sql_command = SQLCOM_SLAVE_START;
	   lex->type = 0;
	    /* We'll use mi structure for UNTIL options */
	    bzero((char*) &lex->mi, sizeof(lex->mi));
          }
    break;

  case 582:
#line 3787 "sql_yacc.yy"
    {}
    break;

  case 583:
#line 3789 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
           lex->sql_command = SQLCOM_SLAVE_STOP;
	   lex->type = 0;
         }
    break;

  case 584:
#line 3799 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          lex->sql_command= SQLCOM_BEGIN;
          lex->start_transaction_opt= (yyvsp[0].num);
        }
    break;

  case 585:
#line 3807 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 586:
#line 3809 "sql_yacc.yy"
    {
           (yyval.num)= MYSQL_START_TRANS_OPT_WITH_CONS_SNAPSHOT;
        }
    break;

  case 587:
#line 3815 "sql_yacc.yy"
    { Lex->slave_thd_opt= 0; }
    break;

  case 588:
#line 3817 "sql_yacc.yy"
    {}
    break;

  case 591:
#line 3826 "sql_yacc.yy"
    {}
    break;

  case 592:
#line 3827 "sql_yacc.yy"
    { Lex->slave_thd_opt|=SLAVE_SQL; }
    break;

  case 593:
#line 3828 "sql_yacc.yy"
    { Lex->slave_thd_opt|=SLAVE_IO; }
    break;

  case 594:
#line 3832 "sql_yacc.yy"
    {}
    break;

  case 595:
#line 3834 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if ((lex->mi.log_file_name || lex->mi.pos) &&
                (lex->mi.relay_log_name || lex->mi.relay_log_pos) ||
                !((lex->mi.log_file_name && lex->mi.pos) ||
                  (lex->mi.relay_log_name && lex->mi.relay_log_pos)))
            {
               my_message(ER_BAD_SLAVE_UNTIL_COND,
                          ER(ER_BAD_SLAVE_UNTIL_COND), MYF(0));
               YYABORT;
            }

          }
    break;

  case 598:
#line 3856 "sql_yacc.yy"
    {
	   Lex->sql_command = SQLCOM_RESTORE_TABLE;
	}
    break;

  case 599:
#line 3860 "sql_yacc.yy"
    {
	  Lex->backup_dir = (yyvsp[0].lex_str).str;
        }
    break;

  case 600:
#line 3866 "sql_yacc.yy"
    {
	   Lex->sql_command = SQLCOM_BACKUP_TABLE;
	}
    break;

  case 601:
#line 3870 "sql_yacc.yy"
    {
	  Lex->backup_dir = (yyvsp[0].lex_str).str;
        }
    break;

  case 602:
#line 3876 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->sql_command = SQLCOM_CHECKSUM;
	}
    break;

  case 603:
#line 3881 "sql_yacc.yy"
    {}
    break;

  case 604:
#line 3885 "sql_yacc.yy"
    { Lex->check_opt.flags= 0; }
    break;

  case 605:
#line 3886 "sql_yacc.yy"
    { Lex->check_opt.flags= T_QUICK; }
    break;

  case 606:
#line 3887 "sql_yacc.yy"
    { Lex->check_opt.flags= T_EXTEND; }
    break;

  case 607:
#line 3892 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->sql_command = SQLCOM_REPAIR;
           lex->no_write_to_binlog= (yyvsp[-1].num);
	   lex->check_opt.init();
	}
    break;

  case 608:
#line 3899 "sql_yacc.yy"
    {}
    break;

  case 609:
#line 3903 "sql_yacc.yy"
    { Lex->check_opt.flags = T_MEDIUM; }
    break;

  case 610:
#line 3904 "sql_yacc.yy"
    {}
    break;

  case 611:
#line 3907 "sql_yacc.yy"
    {}
    break;

  case 612:
#line 3908 "sql_yacc.yy"
    {}
    break;

  case 613:
#line 3911 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_QUICK; }
    break;

  case 614:
#line 3912 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_EXTEND; }
    break;

  case 615:
#line 3913 "sql_yacc.yy"
    { Lex->check_opt.sql_flags|= TT_USEFRM; }
    break;

  case 616:
#line 3917 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->sql_command = SQLCOM_ANALYZE;
           lex->no_write_to_binlog= (yyvsp[-1].num);
	   lex->check_opt.init();
	}
    break;

  case 617:
#line 3924 "sql_yacc.yy"
    {}
    break;

  case 618:
#line 3929 "sql_yacc.yy"
    {
	  LEX *lex=Lex;

	  if (lex->sphead)
	  {
	    my_error(ER_SP_BADSTATEMENT, MYF(0), "CHECK");
	    YYABORT;
	  }
	  lex->sql_command = SQLCOM_CHECK;
	  lex->check_opt.init();
	}
    break;

  case 619:
#line 3941 "sql_yacc.yy"
    {}
    break;

  case 620:
#line 3945 "sql_yacc.yy"
    { Lex->check_opt.flags = T_MEDIUM; }
    break;

  case 621:
#line 3946 "sql_yacc.yy"
    {}
    break;

  case 622:
#line 3949 "sql_yacc.yy"
    {}
    break;

  case 623:
#line 3950 "sql_yacc.yy"
    {}
    break;

  case 624:
#line 3953 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_QUICK; }
    break;

  case 625:
#line 3954 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_FAST; }
    break;

  case 626:
#line 3955 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_MEDIUM; }
    break;

  case 627:
#line 3956 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_EXTEND; }
    break;

  case 628:
#line 3957 "sql_yacc.yy"
    { Lex->check_opt.flags|= T_CHECK_ONLY_CHANGED; }
    break;

  case 629:
#line 3958 "sql_yacc.yy"
    { Lex->check_opt.sql_flags|= TT_FOR_UPGRADE; }
    break;

  case 630:
#line 3962 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->sql_command = SQLCOM_OPTIMIZE;
           lex->no_write_to_binlog= (yyvsp[-1].num);
	   lex->check_opt.init();
	}
    break;

  case 631:
#line 3969 "sql_yacc.yy"
    {}
    break;

  case 632:
#line 3973 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 633:
#line 3974 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 634:
#line 3975 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 635:
#line 3980 "sql_yacc.yy"
    {
          Lex->sql_command= SQLCOM_RENAME_TABLE;
	}
    break;

  case 636:
#line 3984 "sql_yacc.yy"
    {}
    break;

  case 637:
#line 3986 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_RENAME_USER;
          }
    break;

  case 638:
#line 3993 "sql_yacc.yy"
    {
          if (Lex->users_list.push_back((yyvsp[-2].lex_user)) || Lex->users_list.push_back((yyvsp[0].lex_user)))
            YYABORT;
        }
    break;

  case 639:
#line 3998 "sql_yacc.yy"
    {
            if (Lex->users_list.push_back((yyvsp[-2].lex_user)) || Lex->users_list.push_back((yyvsp[0].lex_user)))
              YYABORT;
          }
    break;

  case 642:
#line 4010 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  SELECT_LEX *sl= lex->current_select;
	  if (!sl->add_table_to_list(lex->thd, (yyvsp[-2].table),NULL,TL_OPTION_UPDATING,
				     TL_IGNORE) ||
	      !sl->add_table_to_list(lex->thd, (yyvsp[0].table),NULL,TL_OPTION_UPDATING,
				     TL_IGNORE))
	    YYABORT;
	}
    break;

  case 643:
#line 4022 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->sql_command= SQLCOM_ASSIGN_TO_KEYCACHE;
	  lex->ident= (yyvsp[0].lex_str);
        }
    break;

  case 646:
#line 4035 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          SELECT_LEX *sel= &lex->select_lex;
          if (!sel->add_table_to_list(lex->thd, (yyvsp[-1].table), NULL, 0,
                                      TL_READ,
                                      sel->get_use_index(),
                                      (List<String> *)0))
            YYABORT;
        }
    break;

  case 647:
#line 4047 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 648:
#line 4048 "sql_yacc.yy"
    { (yyval.lex_str) = default_key_cache_base; }
    break;

  case 649:
#line 4053 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->sql_command=SQLCOM_PRELOAD_KEYS;
	}
    break;

  case 650:
#line 4058 "sql_yacc.yy"
    {}
    break;

  case 653:
#line 4067 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  SELECT_LEX *sel= &lex->select_lex;
	  if (!sel->add_table_to_list(lex->thd, (yyvsp[-2].table), NULL, (yyvsp[0].num),
                                      TL_READ,
                                      sel->get_use_index(),
                                      (List<String> *)0))
            YYABORT;
	}
    break;

  case 654:
#line 4079 "sql_yacc.yy"
    { Select->interval_list.empty(); }
    break;

  case 655:
#line 4081 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          SELECT_LEX *sel= &lex->select_lex;
          sel->use_index= sel->interval_list;
        }
    break;

  case 656:
#line 4089 "sql_yacc.yy"
    { Lex->select_lex.use_index_ptr= 0; }
    break;

  case 657:
#line 4091 "sql_yacc.yy"
    {
            SELECT_LEX *sel= &Lex->select_lex;
	    sel->use_index_ptr= &sel->use_index;
	  }
    break;

  case 658:
#line 4099 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 659:
#line 4100 "sql_yacc.yy"
    { (yyval.num)= TL_OPTION_IGNORE_LEAVES; }
    break;

  case 660:
#line 4110 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_SELECT;
	}
    break;

  case 663:
#line 4124 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            SELECT_LEX * sel= lex->current_select;
	    if (sel->set_braces(1))
	    {
	      yyerror(ER(ER_SYNTAX_ERROR));
	      YYABORT;
	    }
            if (sel->linkage == UNION_TYPE &&
                !sel->master_unit()->first_select()->braces &&
                sel->master_unit()->first_select()->linkage ==
                UNION_TYPE)
            {
              yyerror(ER(ER_SYNTAX_ERROR));
              YYABORT;
            }
            /* select in braces, can't contain global parameters */
	    if (sel->master_unit()->fake_select_lex)
              sel->master_unit()->global_parameters=
                 sel->master_unit()->fake_select_lex;
          }
    break;

  case 665:
#line 4149 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
          SELECT_LEX * sel= lex->current_select;
          if (lex->current_select->set_braces(0))
	  {
	    yyerror(ER(ER_SYNTAX_ERROR));
	    YYABORT;
	  }
	  if (sel->linkage == UNION_TYPE &&
	      sel->master_unit()->first_select()->braces)
	  {
	    yyerror(ER(ER_SYNTAX_ERROR));
	    YYABORT;
	  }
	}
    break;

  case 667:
#line 4168 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  SELECT_LEX *sel= lex->current_select;
	  if (sel->linkage != UNION_TYPE)
	    mysql_init_select(lex);
	  lex->current_select->parsing_place= SELECT_LIST;
	}
    break;

  case 668:
#line 4176 "sql_yacc.yy"
    {
	  Select->parsing_place= NO_MATTER;
	}
    break;

  case 670:
#line 4182 "sql_yacc.yy"
    {}
    break;

  case 678:
#line 4201 "sql_yacc.yy"
    {
	    if (test_all_bits(Select->options, SELECT_ALL | SELECT_DISTINCT))
	    {
	      my_error(ER_WRONG_USAGE, MYF(0), "ALL", "DISTINCT");
              YYABORT;
	    }
          }
    break;

  case 681:
#line 4215 "sql_yacc.yy"
    { Select->options|= SELECT_STRAIGHT_JOIN; }
    break;

  case 682:
#line 4217 "sql_yacc.yy"
    {
	    if (check_simple_select())
	      YYABORT;
	    Lex->lock_option= TL_READ_HIGH_PRIORITY;
	  }
    break;

  case 683:
#line 4222 "sql_yacc.yy"
    { Select->options|= SELECT_DISTINCT; }
    break;

  case 684:
#line 4223 "sql_yacc.yy"
    { Select->options|= SELECT_SMALL_RESULT; }
    break;

  case 685:
#line 4224 "sql_yacc.yy"
    { Select->options|= SELECT_BIG_RESULT; }
    break;

  case 686:
#line 4226 "sql_yacc.yy"
    {
	    if (check_simple_select())
	      YYABORT;
	    Select->options|= OPTION_BUFFER_RESULT;
	  }
    break;

  case 687:
#line 4232 "sql_yacc.yy"
    {
	    if (check_simple_select())
	      YYABORT;
	    Select->options|= OPTION_FOUND_ROWS;
	  }
    break;

  case 688:
#line 4238 "sql_yacc.yy"
    {
            Lex->safe_to_cache_query=0;
	    Lex->select_lex.options&= ~OPTION_TO_QUERY_CACHE;
            Lex->select_lex.sql_cache= SELECT_LEX::SQL_NO_CACHE;
          }
    break;

  case 689:
#line 4244 "sql_yacc.yy"
    {
            /* Honor this flag only if SQL_NO_CACHE wasn't specified. */
            if (Lex->select_lex.sql_cache != SELECT_LEX::SQL_NO_CACHE)
            {
              Lex->safe_to_cache_query=1;
	      Lex->select_lex.options|= OPTION_TO_QUERY_CACHE;
              Lex->select_lex.sql_cache= SELECT_LEX::SQL_CACHE;
            }
	  }
    break;

  case 690:
#line 4253 "sql_yacc.yy"
    { Select->options|= SELECT_ALL; }
    break;

  case 692:
#line 4259 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->current_select->set_lock_for_tables(TL_WRITE);
	    lex->safe_to_cache_query