/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;

  char *yytext= (char*) thd->lex->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? (char*) yytext : ""),
                  thd->lex->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 414 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1621 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 454 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1636 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43114

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  674
/* YYNRULES -- Number of rules. */
#define YYNRULES  2026
/* YYNRULES -- Number of states. */
#define YYNSTATES  3672

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   456,   460,   461,   463,
     465,   467,   469,   472,   474,   476,   480,   481,   484,   485,
     488,   489,   493,   494,   500,   502,   504,   505,   508,   511,
     514,   517,   518,   525,   528,   529,   532,   534,   536,   540,
     541,   542,   543,   551,   552,   555,   558,   560,   562,   563,
     564,   573,   574,   581,   583,   586,   588,   591,   592,   593,
     600,   601,   602,   609,   610,   613,   614,   620,   621,   623,
     624,   630,   635,   636,   637,   646,   647,   655,   657,   659,
     661,   663,   665,   668,   671,   674,   679,   684,   685,   690,
     691,   692,   698,   699,   707,   708,   709,   716,   717,   719,
     720,   722,   724,   727,   729,   731,   732,   734,   736,   739,
     741,   742,   746,   747,   749,   751,   754,   756,   759,   763,
     767,   771,   775,   779,   783,   787,   791,   795,   799,   803,
     807,   811,   815,   819,   823,   827,   833,   835,   837,   841,
     846,   851,   855,   860,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   893,   896,
     897,   899,   901,   903,   905,   907,   909,   913,   915,   917,
     920,   923,   930,   938,   947,   950,   953,   954,   956,   959,
     960,   962,   965,   966,   971,   975,   979,   983,   985,   990,
     992,   994,  1000,  1003,  1009,  1012,  1017,  1019,  1025,  1031,
    1036,  1040,  1042,  1044,  1047,  1049,  1051,  1054,  1056,  1058,
    1060,  1063,  1067,  1070,  1074,  1077,  1080,  1084,  1088,  1092,
    1093,  1100,  1101,  1108,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1133,  1136,  1139,  1141,  1144,
    1146,  1149,  1153,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1170,  1173,  1174,  1178,  1180,  1186,  1187,  1189,  1192,  1194,
    1196,  1198,  1200,  1201,  1205,  1206,  1208,  1209,  1211,  1214,
    1216,  1218,  1221,  1224,  1229,  1231,  1235,  1238,  1240,  1243,
    1246,  1249,  1252,  1254,  1257,  1259,  1261,  1263,  1265,  1267,
    1268,  1271,  1273,  1275,  1277,  1279,  1281,  1282,  1285,  1287,
    1289,  1290,  1292,  1293,  1296,  1298,  1301,  1305,  1308,  1309,
    1311,  1312,  1314,  1316,  1319,  1320,  1322,  1323,  1328,  1330,
    1335,  1339,  1341,  1342,  1344,  1347,  1349,  1353,  1357,  1360,
    1363,  1366,  1368,  1370,  1373,  1376,  1379,  1381,  1384,  1387,
    1390,  1393,  1395,  1397,  1398,  1400,  1402,  1404,  1406,  1407,
    1409,  1411,  1413,  1414,  1417,  1420,  1422,  1424,  1426,  1431,
    1434,  1436,  1441,  1442,  1444,  1445,  1448,  1450,  1454,  1455,
    1462,  1463,  1469,  1470,  1476,  1477,  1483,  1484,  1496,  1497,
    1499,  1500,  1503,  1506,  1508,  1512,  1515,  1519,  1522,  1527,
    1528,  1535,  1536,  1537,  1546,  1551,  1556,  1560,  1564,  1567,
    1570,  1577,  1583,  1587,  1593,  1595,  1597,  1599,  1600,  1602,
    1603,  1605,  1606,  1608,  1610,  1611,  1614,  1616,  1617,  1619,
    1621,  1623,  1624,  1630,  1634,  1635,  1641,  1645,  1649,  1650,
    1654,  1655,  1658,  1660,  1664,  1665,  1667,  1669,  1670,  1673,
    1675,  1679,  1680,  1687,  1688,  1695,  1696,  1702,  1703,  1705,
    1707,  1708,  1715,  1716,  1718,  1720,  1723,  1725,  1727,  1729,
    1730,  1737,  1738,  1744,  1745,  1747,  1749,  1752,  1754,  1756,
    1758,  1760,  1762,  1765,  1766,  1773,  1774,  1776,  1778,  1779,
    1784,  1789,  1793,  1799,  1801,  1805,  1809,  1815,  1817,  1821,
    1824,  1826,  1828,  1829,  1836,  1838,  1842,  1846,  1847,  1850,
    1851,  1856,  1857,  1860,  1862,  1865,  1870,  1873,  1877,  1878,
    1882,  1883,  1884,  1891,  1894,  1896,  1898,  1901,  1904,  1913,
    1918,  1919,  1921,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1942,  1944,  1946,  1947,  1950,  1955,  1959,  1961,
    1963,  1968,  1969,  1970,  1972,  1974,  1975,  1978,  1981,  1983,
    1985,  1986,  1989,  1990,  1994,  1995,  1999,  2003,  2004,  2008,
    2009,  2013,  2016,  2018,  2022,  2027,  2031,  2036,  2040,  2045,
    2047,  2051,  2056,  2060,  2064,  2071,  2073,  2079,  2086,  2092,
    2100,  2107,  2116,  2122,  2129,  2134,  2139,  2145,  2149,  2154,
    2156,  2160,  2162,  2166,  2168,  2172,  2176,  2178,  2182,  2186,
    2191,  2196,  2198,  2202,  2206,  2210,  2214,  2218,  2220,  2224,
    2226,  2228,  2230,  2232,  2234,  2236,  2238,  2240,  2242,  2244,
    2246,  2248,  2250,  2252,  2254,  2256,  2258,  2261,  2263,  2267,
    2269,  2271,  2273,  2275,  2279,  2282,  2285,  2288,  2291,  2295,
    2299,  2305,  2312,  2317,  2322,  2330,  2335,  2338,  2345,  2351,
    2358,  2365,  2370,  2375,  2379,  2384,  2391,  2400,  2407,  2416,
    2423,  2428,  2435,  2440,  2447,  2452,  2457,  2462,  2467,  2474,
    2483,  2486,  2489,  2494,  2497,  2505,  2513,  2517,  2522,  2527,
    2534,  2541,  2546,  2553,  2560,  2567,  2572,  2579,  2584,  2591,
    2600,  2611,  2624,  2631,  2636,  2643,  2650,  2652,  2659,  2664,
    2673,  2684,  2689,  2691,  2695,  2700,  2707,  2714,  2723,  2730,
    2737,  2742,  2749,  2756,  2765,  2770,  2775,  2782,  2787,  2790,
    2795,  2800,  2805,  2812,  2817,  2822,  2826,  2835,  2842,  2847,
    2854,  2858,  2865,  2874,  2879,  2888,  2895,  2904,  2911,  2920,
    2923,  2928,  2933,  2938,  2945,  2954,  2963,  2968,  2976,  2984,
    2992,  2999,  3006,  3013,  3020,  3027,  3034,  3035,  3041,  3052,
    3056,  3061,  3065,  3068,  3071,  3074,  3079,  3086,  3091,  3096,
    3103,  3110,  3117,  3124,  3129,  3136,  3141,  3148,  3153,  3158,
    3163,  3168,  3175,  3180,  3187,  3192,  3199,  3204,  3209,  3216,
    3221,  3228,  3233,  3240,  3245,  3250,  3257,  3262,  3269,  3270,
    3274,  3278,  3279,  3281,  3282,  3285,  3287,  3291,  3296,  3301,
    3307,  3312,  3317,  3322,  3328,  3333,  3334,  3335,  3343,  3354,
    3359,  3365,  3370,  3376,  3381,  3386,  3391,  3396,  3401,  3407,
    3408,  3417,  3418,  3422,  3426,  3428,  3433,  3434,  3436,  3437,
    3440,  3441,  3443,  3444,  3448,  3451,  3455,  3458,  3460,  3463,
    3465,  3468,  3470,  3472,  3474,  3477,  3478,  3480,  3481,  3484,
    3486,  3490,  3492,  3496,  3497,  3500,  3502,  3506,  3507,  3509,
    3510,  3513,  3518,  3524,  3526,  3528,  3530,  3532,  3536,  3540,
    3544,  3545,  3552,  3553,  3560,  3561,  3570,  3575,  3576,  3585,
    3586,  3597,  3604,  3605,  3614,  3615,  3626,  3633,  3635,  3638,
    3641,  3642,  3647,  3648,  3660,  3664,  3671,  3672,  3676,  3677,
    3678,  3684,  3685,  3687,  3688,  3690,  3691,  3694,  3695,  3698,
    3701,  3704,  3705,  3712,  3713,  3715,  3719,  3721,  3723,  3725,
    3729,  3731,  3733,  3735,  3737,  3739,  3741,  3743,  3745,  3747,
    3749,  3751,  3753,  3755,  3757,  3759,  3761,  3763,  3765,  3767,
    3769,  3771,  3773,  3775,  3777,  3779,  3781,  3782,  3784,  3786,
    3787,  3790,  3791,  3793,  3794,  3795,  3799,  3800,  3801,  3805,
    3808,  3809,  3810,  3815,  3820,  3823,  3824,  3827,  3830,  3834,
    3838,  3840,  3843,  3844,  3846,  3847,  3852,  3857,  3860,  3861,
    3863,  3865,  3866,  3868,  3869,  3871,  3874,  3876,  3880,  3884,
    3886,  3888,  3890,  3892,  3893,  3896,  3898,  3900,  3902,  3904,
    3906,  3908,  3910,  3912,  3914,  3916,  3918,  3919,  3920,  3927,
    3928,  3930,  3934,  3936,  3939,  3940,  3943,  3947,  3949,  3952,
    3954,  3955,  3959,  3960,  3966,  3969,  3971,  3972,  3976,  3983,
    3984,  3991,  3996,  4001,  4006,  4011,  4017,  4022,  4024,  4028,
    4030,  4031,  4034,  4035,  4037,  4038,  4039,  4048,  4049,  4050,
    4057,  4058,  4060,  4062,  4064,  4066,  4068,  4071,  4073,  4075,
    4077,  4081,  4086,  4087,  4091,  4095,  4097,  4100,  4103,  4104,
    4108,  4109,  4115,  4119,  4121,  4125,  4127,  4131,  4133,  4135,
    4136,  4138,  4139,  4144,  4145,  4147,  4151,  4153,  4155,  4157,
    4158,  4159,  4166,  4167,  4168,  4180,  4184,  4186,  4190,  4194,
    4196,  4200,  4201,  4203,  4204,  4209,  4210,  4217,  4218,  4224,
    4225,  4232,  4234,  4238,  4242,  4248,  4249,  4252,  4253,  4256,
    4258,  4260,  4262,  4266,  4267,  4269,  4270,  4274,  4277,  4282,
    4287,  4292,  4297,  4298,  4303,  4310,  4327,  4330,  4333,  4334,
    4341,  4347,  4350,  4353,  4356,  4358,  4364,  4370,  4373,  4376,
    4380,  4383,  4386,  4389,  4393,  4396,  4399,  4402,  4404,  4406,
    4410,  4415,  4419,  4423,  4426,  4429,  4433,  4437,  4441,  4445,
    4449,  4453,  4455,  4457,  4459,  4461,  4462,  4464,  4465,  4468,
    4469,  4471,  4473,  4475,  4476,  4479,  4480,  4483,  4484,  4487,
    4490,  4491,  4496,  4497,  4502,  4504,  4506,  4507,  4509,  4510,
    4512,  4514,  4515,  4520,  4524,  4526,  4527,  4531,  4536,  4539,
    4541,  4543,  4545,  4547,  4549,  4551,  4553,  4555,  4556,  4558,
    4559,  4563,  4567,  4569,  4571,  4573,  4576,  4577,  4581,  4585,
    4588,  4591,  4592,  4597,  4598,  4600,  4602,  4605,  4606,  4611,
    4617,  4618,  4619,  4620,  4621,  4640,  4643,  4644,  4646,  4647,
    4649,  4651,  4652,  4654,  4656,  4657,  4660,  4663,  4665,  4669,
    4674,  4678,  4682,  4683,  4686,  4689,  4691,  4695,  4699,  4700,
    4704,  4705,  4709,  4712,  4716,  4718,  4720,  4723,  4724,  4727,
    4729,  4731,  4734,  4737,  4739,  4741,  4743,  4745,  4747,  4750,
    4753,  4755,  4757,  4759,  4761,  4763,  4765,  4767,  4770,  4773,
    4776,  4779,  4782,  4784,  4786,  4788,  4790,  4792,  4794,  4796,
    4800,  4806,  4808,  4810,  4812,  4814,  4816,  4820,  4825,  4831,
    4833,  4839,  4843,  4846,  4848,  4852,  4855,  4857,  4859,  4861,
    4863,  4865,  4867,  4869,  4871,  4873,  4875,  4877,  4879,  4881,
    4883,  4887,  4890,  4892,  4894,  4896,  4898,  4900,  4902,  4904,
    4906,  4908,  4910,  4912,  4914,  4916,  4918,  4920,  4922,  4924,
    4926,  4928,  4930,  4932,  4934,  4936,  4938,  4940,  4942,  4944,
    4946,  4948,  4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,
    4966,  4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,
    4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,  5004,
    5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,  5024,
    5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,  5044,
    5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,  5064,
    5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,  5084,
    5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,  5104,
    5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,  5124,
    5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,  5144,
    5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,  5164,
    5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,  5184,
    5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,  5204,
    5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,  5224,
    5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,  5244,
    5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,  5264,
    5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,  5284,
    5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,  5304,
    5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,  5324,
    5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,  5344,
    5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5362,  5364,
    5366,  5368,  5370,  5372,  5374,  5376,  5378,  5380,  5382,  5384,
    5386,  5388,  5390,  5391,  5396,  5397,  5399,  5401,  5405,  5406,
    5409,  5411,  5413,  5415,  5417,  5418,  5420,  5421,  5423,  5425,
    5427,  5428,  5431,  5434,  5437,  5439,  5442,  5447,  5453,  5458,
    5465,  5468,  5472,  5476,  5480,  5486,  5488,  5492,  5496,  5499,
    5502,  5505,  5507,  5509,  5514,  5519,  5521,  5523,  5525,  5527,
    5529,  5530,  5535,  5537,  5539,  5541,  5545,  5549,  5551,  5553,
    5556,  5559,  5560,  5564,  5569,  5573,  5574,  5582,  5584,  5587,
    5589,  5591,  5593,  5595,  5597,  5599,  5600,  5606,  5608,  5610,
    5612,  5614,  5616,  5620,  5627,  5634,  5641,  5649,  5653,  5662,
    5671,  5680,  5681,  5683,  5685,  5688,  5689,  5691,  5693,  5697,
    5698,  5702,  5703,  5707,  5708,  5712,  5713,  5717,  5719,  5721,
    5723,  5725,  5727,  5729,  5731,  5733,  5735,  5737,  5739,  5742,
    5745,  5747,  5751,  5754,  5757,  5760,  5763,  5766,  5769,  5772,
    5775,  5776,  5778,  5782,  5784,  5787,  5790,  5793,  5795,  5799,
    5803,  5805,  5807,  5811,  5813,  5817,  5822,  5828,  5830,  5831,
    5835,  5839,  5841,  5843,  5844,  5847,  5850,  5853,  5856,  5857,
    5860,  5863,  5865,  5868,  5871,  5874,  5877,  5880,  5881,  5885,
    5886,  5888,  5889,  5893,  5896,  5897,  5899,  5902,  5903,  5905,
    5910,  5915,  5921,  5924,  5928,  5929,  5931,  5932,  5937,  5938,
    5940,  5942,  5943,  5946,  5949,  5951,  5952,  5954,  5956,  5961,
    5962,  5970,  5972,  5973,  5974,  5977,  5981,  5983,  5985,  5987,
    5988,  5992,  5994,  5997,  5999,  6002,  6006,  6010,  6014,  6015,
    6017,  6018,  6022,  6026,  6027,  6036,  6037,  6041,  6043,  6047,
    6048,  6051,  6055,  6061,  6062,  6066,  6071,  6076,  6077,  6092,
    6093,  6100,  6101,  6102,  6103,  6104,  6117,  6122,  6127,  6131,
    6136,  6140,  6143,  6145,  6149,  6155,  6157,  6159,  6160,  6162,
    6164,  6165,  6168,  6169,  6170,  6174,  6175
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1189,    -1,   771,    -1,   812,    -1,   802,    -1,   608,    -1,
     585,    -1,   814,    -1,   804,    -1,  1195,    -1,   590,    -1,
     574,    -1,  1033,    -1,  1060,    -1,   989,    -1,   991,    -1,
     578,    -1,  1066,    -1,  1164,    -1,  1155,    -1,   583,    -1,
     997,    -1,  1080,    -1,  1084,    -1,  1147,    -1,   819,    -1,
     827,    -1,   831,    -1,   576,    -1,  1076,    -1,  1198,    -1,
     822,    -1,   807,    -1,  1000,    -1,  1072,    -1,   800,    -1,
    1162,    -1,  1196,    -1,  1197,    -1,   839,    -1,  1130,    -1,
    1046,    -1,   789,    -1,   792,    -1,  1044,    -1,  1153,    -1,
    1025,    -1,  1083,    -1,  1236,    -1,   575,   362,  1124,    -1,
     103,    -1,   126,    -1,   362,  1124,   171,   577,    -1,  1121,
      -1,   566,  1126,    -1,    -1,   148,  1124,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1126,    -1,    -1,   198,   584,  1126,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1121,    -1,   282,   142,  1121,    -1,   271,
     142,  1121,    -1,   272,   142,   974,    -1,   267,   142,   974,
      -1,   280,   142,   974,    -1,   276,   142,  1121,    -1,   275,
     142,  1121,    -1,   277,   142,  1121,    -1,   278,   142,  1121,
      -1,   279,   142,  1121,    -1,   589,    -1,   269,   142,  1121,
      -1,   270,   142,   975,    -1,   386,   142,  1121,    -1,   387,
     142,   974,    -1,    -1,    84,   688,   472,   691,  1118,   591,
     675,    -1,    -1,    84,   763,   213,  1124,   764,   337,  1118,
     592,   560,   766,   561,    -1,    -1,    84,    91,   691,  1124,
     593,   685,    -1,    -1,    84,   594,  1212,    -1,    84,   514,
     595,  1180,    -1,    -1,  1124,   567,  1124,    -1,  1124,    -1,
     403,   704,   496,  1121,    -1,    -1,    -1,    -1,    -1,    -1,
     560,   598,   613,   561,   599,   403,   600,   715,   601,   604,
     602,   637,    -1,    -1,   603,   605,    -1,    -1,   604,   606,
      -1,    67,  1121,    -1,   235,   450,    -1,   328,   450,    -1,
      79,   450,    -1,   379,   450,    93,    -1,   304,   450,    93,
      -1,   607,    -1,   605,    -1,   118,    -1,   878,   118,    -1,
     450,   419,   109,    -1,   450,   419,   224,    -1,    -1,    47,
     596,   609,   610,    -1,    -1,   560,   611,   561,    -1,    -1,
     612,    -1,   612,   562,   860,    -1,   860,    -1,    -1,   614,
      -1,   614,   562,   616,    -1,   616,    -1,    -1,  1124,   615,
     715,    -1,    -1,   618,    -1,   618,   562,   619,    -1,   619,
      -1,   620,   615,  1124,   715,    -1,    -1,   225,    -1,   350,
      -1,   217,    -1,    -1,   621,   637,   568,    -1,   637,   568,
      -1,   622,   637,   568,    -1,    -1,   623,   624,   568,    -1,
      -1,   106,   635,   625,   715,   636,    -1,   106,  1124,    75,
     168,   632,    -1,    -1,   106,   629,   195,   168,   626,   630,
     637,    -1,   106,  1124,    89,   168,   627,    -1,    -1,   628,
     573,    -1,   150,    -1,    80,    -1,   631,    -1,   630,   562,
     631,    -1,   634,    -1,   974,    -1,   442,   633,  1122,    -1,
      -1,   523,    -1,   632,    -1,  1124,    -1,   443,    -1,   878,
     169,    -1,   441,    -1,  1124,    -1,   635,   562,  1124,    -1,
      -1,   108,   860,    -1,    -1,   638,   573,    -1,    -1,   404,
     639,   860,    -1,    -1,   209,   640,   645,   138,   209,    -1,
     650,    -1,   665,    -1,    -1,   641,   668,    -1,   242,  1125,
      -1,   229,  1125,    -1,   340,  1124,    -1,    -1,   157,   643,
    1124,   222,   642,   644,    -1,    60,  1124,    -1,    -1,   323,
     171,    -1,   171,    -1,  1124,    -1,   644,   562,  1124,    -1,
      -1,    -1,    -1,   646,   860,   547,   647,   622,   648,   649,
      -1,    -1,   132,   645,    -1,   546,   622,    -1,   651,    -1,
     654,    -1,    -1,    -1,   548,   652,   860,   653,   656,   664,
     138,   548,    -1,    -1,   548,   655,   657,   664,   138,   548,
      -1,   658,    -1,   656,   658,    -1,   661,    -1,   657,   661,
      -1,    -1,    -1,   532,   659,   860,   660,   547,   622,    -1,
      -1,    -1,   532,   662,   860,   663,   547,   622,    -1,    -1,
     546,   622,    -1,    -1,  1125,   569,   666,   668,   667,    -1,
      -1,  1125,    -1,    -1,    28,   669,   623,   621,   138,    -1,
     263,   622,   138,   263,    -1,    -1,    -1,   534,   670,   860,
     125,   671,   622,   138,   534,    -1,    -1,   394,   622,   510,
     672,   860,   138,   394,    -1,    27,    -1,     8,    -1,   219,
      -1,   511,    -1,   112,    -1,   560,   676,    -1,   692,   678,
      -1,   246,  1118,    -1,   560,   246,  1118,   561,    -1,   705,
     561,   692,   678,    -1,    -1,   681,   561,   677,  1202,    -1,
      -1,    -1,  1093,   684,   681,   679,  1199,    -1,    -1,  1093,
     684,   560,   681,   561,   680,  1202,    -1,    -1,    -1,   420,
     682,   849,   853,   683,   702,    -1,    -1,    18,    -1,    -1,
     686,    -1,   687,    -1,   686,   687,    -1,   697,    -1,   696,
      -1,    -1,   689,    -1,   690,    -1,   690,   689,    -1,   473,
      -1,    -1,   209,   878,   149,    -1,    -1,   694,    -1,   695,
      -1,   695,   693,    -1,   695,    -1,   695,   694,    -1,   695,
     562,   694,    -1,   140,  1017,   698,    -1,   494,  1017,   698,
      -1,   286,  1017,   975,    -1,   300,  1017,   975,    -1,    24,
    1017,   974,    -1,   353,  1017,  1121,    -1,    67,  1017,  1121,
      -1,    23,  1017,   975,    -1,   351,  1017,   974,    -1,   351,
    1017,   108,    -1,    56,  1017,   974,    -1,   111,  1017,   974,
      -1,   413,  1017,   699,    -1,   377,  1017,   700,    -1,   374,
    1017,   974,    -1,   375,  1017,   974,    -1,   503,  1017,   560,
     993,   561,    -1,   696,    -1,   697,    -1,   220,  1017,   701,
      -1,    93,   119,  1017,  1121,    -1,   213,   119,  1017,  1121,
      -1,    76,  1017,  1121,    -1,   745,   736,  1017,   738,    -1,
     745,    63,  1017,   744,    -1,  1126,    -1,   108,    -1,   161,
      -1,   130,    -1,    71,    -1,   383,    -1,    70,    -1,   376,
      -1,   373,    -1,   974,    -1,   328,    -1,   160,    -1,   237,
      -1,   969,    -1,   848,   852,    -1,    -1,    10,    -1,   461,
      -1,   381,    -1,   105,    -1,   223,    -1,   706,    -1,   705,
     562,   706,    -1,   707,    -1,   708,    -1,   713,   709,    -1,
     713,   750,    -1,   758,   768,   764,   560,   766,   561,    -1,
     711,   759,   768,   764,   560,   766,   561,    -1,   711,   166,
     232,   768,   560,   766,   561,   750,    -1,   712,   709,    -1,
     711,   710,    -1,    -1,   710,    -1,    57,   860,    -1,    -1,
     712,    -1,    78,   768,    -1,    -1,  1117,   714,   715,   732,
      -1,   723,   730,   727,    -1,   724,   731,   727,    -1,   163,
     725,   727,    -1,    37,    -1,    37,   560,   331,   561,    -1,
      41,    -1,    40,    -1,   719,   560,   331,   561,   746,    -1,
     719,   746,    -1,   720,   560,   331,   561,   747,    -1,   720,
     747,    -1,    32,   560,   331,   561,    -1,    32,    -1,   721,
     560,   331,   561,   746,    -1,   722,   560,   331,   561,   747,
      -1,   524,   560,   331,   561,    -1,   543,   730,   727,    -1,
      97,    -1,   481,    -1,   478,   730,    -1,    94,    -1,   482,
      -1,    39,   730,    -1,   718,    -1,   290,    -1,   259,    -1,
     262,   524,    -1,   262,   721,   746,    -1,   484,   746,    -1,
     477,   730,   746,    -1,   292,   746,    -1,   260,   746,    -1,
     105,   725,   727,    -1,   332,   725,   727,    -1,   161,   725,
     727,    -1,    -1,   141,   716,   560,   770,   561,   746,    -1,
      -1,   426,   717,   560,   770,   561,   746,    -1,   262,   746,
      -1,   424,    -1,   183,    -1,   182,    -1,   357,    -1,   311,
      -1,   250,    -1,   310,    -1,   359,    -1,   312,    -1,    55,
      -1,   319,    -1,   316,    55,    -1,   719,   528,    -1,   525,
      -1,   316,   525,    -1,   333,    -1,   319,   525,    -1,   316,
      55,   528,    -1,   319,   528,    -1,   223,    -1,   483,    -1,
     436,    -1,   291,    -1,    31,    -1,   381,    -1,   124,    -1,
     124,   361,    -1,    -1,   560,   331,   561,    -1,   726,    -1,
     560,   331,   562,   331,   561,    -1,    -1,   728,    -1,   728,
     729,    -1,   729,    -1,   433,    -1,   509,    -1,   544,    -1,
      -1,   560,   331,   561,    -1,    -1,   726,    -1,    -1,   733,
      -1,   733,   734,    -1,   734,    -1,   330,    -1,   878,   330,
      -1,   108,   735,    -1,   337,   511,   327,   859,    -1,    23,
      -1,   424,   108,   523,    -1,   749,   232,    -1,   504,    -1,
     504,   232,    -1,    67,  1121,    -1,    63,   742,    -1,   327,
     859,    -1,  1108,    -1,    55,   426,    -1,    54,    -1,  1126,
      -1,    32,    -1,   737,    -1,   108,    -1,    -1,   736,   738,
      -1,  1126,    -1,    32,    -1,   740,    -1,   108,    -1,  1126,
      -1,    -1,    63,   744,    -1,   742,    -1,   108,    -1,    -1,
     108,    -1,    -1,    20,   747,    -1,    45,    -1,   502,   747,
      -1,   736,   737,   747,    -1,    32,   748,    -1,    -1,    32,
      -1,    -1,    20,    -1,   502,    -1,   736,   737,    -1,    -1,
     364,    -1,    -1,   384,  1118,   751,   752,    -1,   754,    -1,
     560,   753,   561,   754,    -1,   753,   562,  1124,    -1,  1124,
      -1,    -1,   755,    -1,   755,   756,    -1,   756,    -1,   337,
     112,   757,    -1,   337,   511,   757,    -1,   283,   173,    -1,
     283,   352,    -1,   283,   434,    -1,   401,    -1,    48,    -1,
     426,   330,    -1,   328,     5,    -1,   426,   108,    -1,   760,
      -1,   174,   761,    -1,   439,   761,    -1,   364,   232,    -1,
     504,   761,    -1,   232,    -1,   213,    -1,    -1,   760,    -1,
     231,    -1,   213,    -1,   212,    -1,    -1,   504,    -1,   174,
      -1,   439,    -1,    -1,   517,   765,    -1,   494,   765,    -1,
      43,    -1,   415,    -1,   196,    -1,   766,   562,   767,   967,
      -1,   767,   967,    -1,  1124,    -1,  1124,   560,   331,   561,
      -1,    -1,  1117,    -1,    -1,   567,  1124,    -1,  1106,    -1,
     770,   562,  1106,    -1,    -1,    13,   785,   472,  1118,   772,
     778,    -1,    -1,    13,    91,   777,   773,   685,    -1,    -1,
      13,   366,   596,   774,   603,    -1,    -1,    13,   175,   596,
     775,   603,    -1,    -1,    13,  1218,  1214,  1219,   529,  1118,
     776,  1222,    18,  1224,  1227,    -1,    -1,  1124,    -1,    -1,
     121,   471,    -1,   211,   471,    -1,   780,    -1,   778,   562,
     780,    -1,     6,   784,    -1,   779,   707,   787,    -1,     6,
     708,    -1,   779,   560,   705,   561,    -1,    -1,    52,   784,
    1117,   781,   713,   787,    -1,    -1,    -1,   305,   784,  1117,
     782,   715,   732,   783,   787,    -1,   126,   784,  1117,   786,
      -1,   126,   166,   232,   768,    -1,   126,   364,   232,    -1,
     126,   760,  1117,    -1,   120,   231,    -1,   134,   231,    -1,
      13,   784,  1117,   426,   108,  1108,    -1,    13,   784,  1117,
     126,   108,    -1,   391,   788,  1118,    -1,    81,   485,   736,
     738,   743,    -1,   693,    -1,   165,    -1,   960,    -1,    -1,
      66,    -1,    -1,   210,    -1,    -1,   401,    -1,    48,    -1,
      -1,     8,  1124,    -1,   160,    -1,    -1,   485,    -1,   142,
      -1,    18,    -1,    -1,   454,   435,   794,   790,   798,    -1,
     458,   435,   794,    -1,    -1,   435,   454,   794,   791,   798,
      -1,   435,   458,   794,    -1,   454,   487,   793,    -1,    -1,
     535,    77,   437,    -1,    -1,   795,   796,    -1,   797,    -1,
     796,   562,   797,    -1,    -1,   451,    -1,   388,    -1,    -1,
     510,   799,    -1,   589,    -1,   799,   562,   589,    -1,    -1,
     400,  1149,   801,   993,   171,  1121,    -1,    -1,    26,  1149,
     803,   993,   485,  1121,    -1,    -1,    56,  1149,   805,   993,
     806,    -1,    -1,   372,    -1,   153,    -1,    -1,   392,   821,
    1149,   808,   993,   809,    -1,    -1,   810,    -1,   811,    -1,
     811,   810,    -1,   372,    -1,   153,    -1,   515,    -1,    -1,
      14,   821,  1149,   813,   993,   816,    -1,    -1,    57,  1149,
     815,   993,   816,    -1,    -1,   817,    -1,   818,    -1,   818,
     817,    -1,   372,    -1,   156,    -1,   293,    -1,   153,    -1,
      53,    -1,   168,   512,    -1,    -1,   341,   821,  1149,   820,
     993,   816,    -1,    -1,   329,    -1,   252,    -1,    -1,   391,
    1149,   823,   825,    -1,   391,   514,   595,   824,    -1,  1127,
     485,  1127,    -1,   824,   562,  1127,   485,  1127,    -1,   826,
      -1,   825,   562,   826,    -1,  1118,   485,  1118,    -1,    46,
     213,   828,   225,   830,    -1,   829,    -1,   828,   562,   829,
      -1,  1118,   835,    -1,  1124,    -1,   108,    -1,    -1,   251,
     213,   222,    46,   832,   833,    -1,   834,    -1,   833,   562,
     834,    -1,  1118,   835,   838,    -1,    -1,   836,   837,    -1,
      -1,   761,   560,   944,   561,    -1,    -1,   210,   241,    -1,
     840,    -1,   420,   842,    -1,   560,   841,   561,  1202,    -1,
     420,   844,    -1,   560,   841,   561,    -1,    -1,   844,   843,
    1199,    -1,    -1,    -1,   845,   849,   853,   846,   847,   852,
      -1,   963,   969,    -1,   985,    -1,   848,    -1,   985,   848,
      -1,   848,   985,    -1,   171,   917,   952,   957,   954,   963,
     969,   976,    -1,   171,   127,   952,   969,    -1,    -1,   850,
      -1,   850,   851,    -1,   851,    -1,   460,    -1,   200,    -1,
     122,    -1,   449,    -1,   444,    -1,   445,    -1,   447,    -1,
     448,    -1,   446,    -1,    12,    -1,    -1,   168,   511,    -1,
     256,   225,   428,   303,    -1,   853,   562,   854,    -1,   854,
      -1,   554,    -1,   855,   857,   856,   858,    -1,    -1,    -1,
    1112,    -1,   860,    -1,    -1,    18,  1124,    -1,    18,  1121,
      -1,  1124,    -1,  1121,    -1,    -1,   560,   561,    -1,    -1,
     863,   861,   862,    -1,    -1,   862,   876,   863,    -1,   863,
     540,   863,    -1,    -1,   866,   864,   865,    -1,    -1,   865,
     877,   866,    -1,   326,   866,    -1,   867,    -1,   868,   226,
     491,    -1,   868,   226,   878,   491,    -1,   868,   226,   155,
      -1,   868,   226,   878,   155,    -1,   868,   226,   507,    -1,
     868,   226,   878,   507,    -1,   868,    -1,   868,   226,   330,
      -1,   868,   226,   878,   330,    -1,   868,   143,   869,    -1,
     868,   880,   869,    -1,   868,   880,   881,   560,  1207,   561,
      -1,   869,    -1,   870,   225,   560,  1207,   561,    -1,   870,
     878,   225,   560,  1207,   561,    -1,   870,   225,   560,   860,
     561,    -1,   870,   225,   560,   860,   562,   906,   561,    -1,
     870,   878,   225,   560,   860,   561,    -1,   870,   878,   225,
     560,   860,   562,   906,   561,    -1,   870,   549,   870,    16,
     869,    -1,   870,   878,   549,   870,    16,   869,    -1,   870,
     438,   246,   870,    -1,   870,   246,   883,   956,    -1,   870,
     878,   246,   883,   956,    -1,   870,   385,   870,    -1,   870,
     878,   385,   870,    -1,   870,    -1,   870,   550,   871,    -1,
     871,    -1,   871,   551,   872,    -1,   872,    -1,   872,   429,
     873,    -1,   872,   430,   873,    -1,   873,    -1,   873,   553,
     874,    -1,   873,   552,   874,    -1,   873,   553,   882,   946,
      -1,   873,   552,   882,   946,    -1,   874,    -1,   874,   554,
     875,    -1,   874,   555,   875,    -1,   874,   556,   875,    -1,
     874,   123,   875,    -1,   874,   306,   875,    -1,   875,    -1,
     875,   557,   883,    -1,   883,    -1,   347,    -1,   344,    -1,
      16,    -1,    15,    -1,   326,    -1,   325,    -1,   563,    -1,
     325,    -1,   142,    -1,   180,    -1,   194,    -1,   238,    -1,
     265,    -1,   321,    -1,    12,    -1,    17,    -1,   221,   860,
      -1,  1114,    -1,   883,    63,  1126,    -1,  1109,    -1,  1107,
      -1,   896,    -1,   892,    -1,   883,   346,   883,    -1,   553,
     883,    -1,   552,   883,    -1,   558,   883,    -1,   879,   883,
      -1,   560,  1207,   561,    -1,   560,   860,   561,    -1,   560,
     860,   562,   906,   561,    -1,   414,   560,   860,   562,   906,
     561,    -1,   149,   560,  1207,   561,    -1,   564,  1124,   860,
     565,    -1,   283,   909,     9,   560,   870,   886,   561,    -1,
      20,   560,   860,   561,    -1,    32,   883,    -1,    50,   560,
     860,    18,   904,   561,    -1,   548,   913,   915,   914,   138,
      -1,    81,   560,   860,   562,   904,   561,    -1,    81,   560,
     860,   517,   737,   561,    -1,   108,   560,  1114,   561,    -1,
     522,   560,  1115,   561,    -1,   176,   560,   561,    -1,   177,
     560,   860,   561,    -1,   178,   560,   860,   562,   860,   561,
      -1,   179,   560,   860,   562,   860,   562,   860,   561,    -1,
       7,   560,   860,   562,   860,   561,    -1,     7,   560,   860,
     562,   221,   860,   946,   561,    -1,   394,   560,   860,   562,
     860,   561,    -1,    22,   560,   860,   561,    -1,    22,   560,
     860,   562,   860,   561,    -1,    55,   560,   906,   561,    -1,
      55,   560,   906,   517,   737,   561,    -1,    54,   560,   860,
     561,    -1,    61,   560,   906,   561,    -1,    64,   560,   860,
     561,    -1,    72,   560,   906,   561,    -1,    73,   560,   860,
     562,   906,   561,    -1,    82,   560,   860,   562,   860,   562,
     860,   561,    -1,    87,   859,    -1,    90,   859,    -1,    90,
     560,   860,   561,    -1,    88,   859,    -1,    95,   560,   860,
     562,   882,   946,   561,    -1,    96,   560,   860,   562,   882,
     946,   561,    -1,    91,   560,   561,    -1,    97,   560,   860,
     561,    -1,   102,   560,   860,   561,    -1,   133,   560,   860,
     562,   906,   561,    -1,   266,   560,   860,   562,   906,   561,
      -1,   137,   560,   860,   561,    -1,   137,   560,   860,   562,
     860,   561,    -1,   107,   560,   860,   562,  1122,   561,    -1,
     136,   560,   860,   562,  1122,   561,    -1,   115,   560,   860,
     561,    -1,   115,   560,   860,   562,   860,   561,    -1,   116,
     560,   860,   561,    -1,   116,   560,   860,   562,   860,   561,
      -1,   152,   560,   860,   562,   860,   562,   860,   561,    -1,
     152,   560,   860,   562,   860,   562,   860,   562,   860,   561,
      -1,   152,   560,   860,   562,   860,   562,   860,   562,   860,
     562,   860,   561,    -1,   167,   560,   860,   562,   331,   561,
      -1,   172,   560,   860,   561,    -1,   172,   560,   860,   562,
     860,   561,    -1,   158,   560,   860,   562,   906,   561,    -1,
     885,    -1,   186,   560,   948,   562,   860,   561,    -1,   205,
     560,   860,   561,    -1,   209,   560,   860,   562,   860,   562,
     860,   561,    -1,   219,   560,   860,   562,   860,   562,   860,
     562,   860,   561,    -1,   882,   946,   553,   860,    -1,   882,
      -1,   236,   560,   561,    -1,   236,   560,   860,   561,    -1,
     243,   560,   860,   562,   860,   561,    -1,   253,   560,   860,
     562,   860,   561,    -1,   253,   560,   860,   562,   860,   562,
     860,   561,    -1,   190,   560,   860,   562,   906,   561,    -1,
     240,   560,   860,   562,   906,   561,    -1,   258,   560,   860,
     561,    -1,   258,   560,   860,   562,   860,   561,    -1,   273,
     560,   860,   562,   860,   561,    -1,   273,   560,   860,   562,
     860,   562,   860,   561,    -1,   295,   560,   860,   561,    -1,
     299,   560,   860,   561,    -1,   306,   560,   860,   562,   860,
     561,    -1,   307,   560,   860,   561,    -1,   327,   859,    -1,
     327,   560,   860,   561,    -1,   353,   560,   860,   561,    -1,
     336,   560,   860,   561,    -1,   360,   560,   870,   225,   860,
     561,    -1,   370,   560,   860,   561,    -1,   378,   560,   860,
     561,    -1,   378,   560,   561,    -1,   395,   560,   860,   562,
     860,   562,   860,   561,    -1,   406,   560,   860,   562,   860,
     561,    -1,   409,   560,   860,   561,    -1,   409,   560,   860,
     562,   860,   561,    -1,   412,   560,   561,    -1,   462,   560,
     860,   562,   860,   561,    -1,   462,   560,   860,   562,   221,
     860,   946,   561,    -1,   418,   560,   860,   561,    -1,   464,
     560,   860,   562,   860,   562,   860,   561,    -1,   464,   560,
     860,   562,   860,   561,    -1,   464,   560,   860,   171,   860,
     168,   860,   561,    -1,   464,   560,   860,   171,   860,   561,
      -1,   465,   560,   860,   562,   860,   562,   860,   561,    -1,
     469,   859,    -1,   469,   560,   860,   561,    -1,   481,   560,
     860,   561,    -1,   478,   560,   860,   561,    -1,   478,   560,
     860,   562,   860,   561,    -1,   479,   560,   947,   562,   860,
     562,   860,   561,    -1,   480,   560,   947,   562,   860,   562,
     860,   561,    -1,   490,   560,   860,   561,    -1,   490,   560,
     239,   860,   171,   860,   561,    -1,   490,   560,   486,   860,
     171,   860,   561,    -1,   490,   560,    42,   860,   171,   860,
     561,    -1,   490,   560,   239,   171,   860,   561,    -1,   490,
     560,   486,   171,   860,   561,    -1,   490,   560,    42,   171,
     860,   561,    -1,   490,   560,   860,   171,   860,   561,    -1,
     492,   560,   860,   562,   860,   561,    -1,  1124,   567,  1124,
     560,   905,   561,    -1,    -1,  1120,   560,   884,   887,   561,
      -1,   505,   560,  1105,   562,   331,   562,   331,   562,   906,
     561,    -1,   506,   560,   561,    -1,   506,   560,   860,   561,
      -1,   514,   560,   561,    -1,   518,   859,    -1,   520,   859,
      -1,   519,   859,    -1,   531,   560,   860,   561,    -1,   531,
     560,   860,   562,   860,   561,    -1,   543,   560,   860,   561,
      -1,   541,   560,   860,   561,    -1,   541,   560,   860,   562,
     860,   561,    -1,    29,   560,   974,   562,   860,   561,    -1,
     154,   560,   946,   171,   860,   561,    -1,    79,   560,   860,
     562,   860,   561,    -1,   184,   560,   860,   561,    -1,   184,
     560,   860,   562,   860,   561,    -1,   185,   560,   860,   561,
      -1,   185,   560,   860,   562,   860,   561,    -1,   182,   560,
     906,   561,    -1,   250,   560,   906,   561,    -1,   310,   560,
     906,   561,    -1,   302,   560,   860,   561,    -1,   302,   560,
     860,   562,   860,   561,    -1,   308,   560,   860,   561,    -1,
     308,   560,   860,   562,   860,   561,    -1,   309,   560,   860,
     561,    -1,   309,   560,   860,   562,   860,   561,    -1,   311,
     560,   906,   561,    -1,   312,   560,   906,   561,    -1,   357,
     560,   860,   562,   860,   561,    -1,   356,   560,   860,   561,
      -1,   356,   560,   860,   562,   860,   561,    -1,   358,   560,
     860,   561,    -1,   358,   560,   860,   562,   860,   561,    -1,
     359,   560,   906,   561,    -1,   181,   560,   860,   561,    -1,
     181,   560,   860,   562,   860,   561,    -1,   248,   560,   860,
     561,    -1,   248,   560,   860,   562,   860,   561,    -1,    -1,
     535,   371,   151,    -1,   225,    40,   303,    -1,    -1,   888,
      -1,    -1,   889,   890,    -1,   891,    -1,   890,   562,   891,
      -1,   855,   860,   856,   858,    -1,    25,   560,   902,   561,
      -1,    25,   560,   122,   902,   561,    -1,    35,   560,   902,
     561,    -1,    36,   560,   902,   561,    -1,    38,   560,   902,
     561,    -1,    83,   560,   951,   554,   561,    -1,    83,   560,
     902,   561,    -1,    -1,    -1,    83,   560,   122,   893,   906,
     894,   561,    -1,   193,   560,  1105,   562,   331,   562,   331,
     562,   902,   561,    -1,   301,   560,   902,   561,    -1,   301,
     560,   122,   902,   561,    -1,   287,   560,   902,   561,    -1,
     287,   560,   122,   902,   561,    -1,   456,   560,   902,   561,
      -1,   527,   560,   902,   561,    -1,   457,   560,   902,   561,
      -1,   521,   560,   902,   561,    -1,   466,   560,   902,   561,
      -1,   466,   560,   122,   902,   561,    -1,    -1,   192,   560,
     899,   895,   906,   901,   900,   561,    -1,    -1,   566,   897,
     898,    -1,  1126,   427,   860,    -1,  1126,    -1,   566,  1139,
    1126,   769,    -1,    -1,   122,    -1,    -1,   422,  1106,    -1,
      -1,   964,    -1,    -1,   951,   903,   860,    -1,    32,   730,
      -1,    55,   730,   746,    -1,   319,   730,    -1,   433,    -1,
     433,   223,    -1,   509,    -1,   509,   223,    -1,    97,    -1,
     481,    -1,    94,    -1,   105,   725,    -1,    -1,   906,    -1,
      -1,   907,   908,    -1,   860,    -1,   908,   562,   860,    -1,
     910,    -1,   560,   910,   561,    -1,    -1,   911,   912,    -1,
    1114,    -1,   912,   562,  1114,    -1,    -1,   860,    -1,    -1,
     546,   860,    -1,   532,   860,   547,   860,    -1,   915,   532,
     860,   547,   860,    -1,   928,    -1,   919,    -1,   918,    -1,
     916,    -1,   918,   562,   916,    -1,   916,   927,   916,    -1,
     916,   460,   928,    -1,    -1,   916,   927,   916,   337,   920,
     860,    -1,    -1,   916,   460,   928,   337,   921,   860,    -1,
      -1,   916,   927,   916,   517,   922,   560,   945,   561,    -1,
     916,   317,   230,   928,    -1,    -1,   916,   243,   938,   230,
     916,   337,   923,   860,    -1,    -1,   916,   243,   938,   230,
     928,   924,   517,   560,   945,   561,    -1,   916,   317,   243,
     938,   230,   928,    -1,    -1,   916,   406,   938,   230,   916,
     337,   925,   860,    -1,    -1,   916,   406,   938,   230,   928,
     926,   517,   560,   945,   561,    -1,   916,   317,   406,   938,
     230,   928,    -1,   230,    -1,   215,   230,    -1,    85,   230,
      -1,    -1,   929,  1118,   950,   940,    -1,    -1,   564,  1124,
     916,   243,   348,   230,   916,   337,   930,   860,   565,    -1,
     937,   936,   933,    -1,   560,   936,   931,  1202,   561,   950,
      -1,    -1,   936,   932,   918,    -1,    -1,    -1,   934,   849,
     853,   935,   702,    -1,    -1,   420,    -1,    -1,   348,    -1,
      -1,   168,   230,    -1,    -1,   516,   941,    -1,   165,   941,
      -1,   210,   941,    -1,    -1,   760,   939,   942,   560,   943,
     561,    -1,    -1,   944,    -1,   944,   562,  1124,    -1,  1124,
      -1,   364,    -1,  1124,    -1,   945,   562,  1124,    -1,   947,
      -1,    98,    -1,    99,    -1,   100,    -1,   101,    -1,   202,
      -1,   203,    -1,   204,    -1,   295,    -1,   297,    -1,   298,
      -1,   417,    -1,   542,    -1,   102,    -1,   531,    -1,   205,
      -1,   170,    -1,   299,    -1,   307,    -1,   370,    -1,   418,
      -1,   543,    -1,    97,    -1,   481,    -1,    94,    -1,   478,
      -1,    -1,    18,    -1,   142,    -1,    -1,   949,  1124,    -1,
      -1,    12,    -1,    -1,    -1,   533,   953,   860,    -1,    -1,
      -1,   197,   955,   860,    -1,   146,   883,    -1,    -1,    -1,
     191,    44,   958,   959,    -1,   958,   562,  1113,   967,    -1,
    1113,   967,    -1,    -1,   535,    86,    -1,   535,   408,    -1,
     345,    44,   961,    -1,   961,   562,   962,    -1,   962,    -1,
    1115,   967,    -1,    -1,   964,    -1,    -1,   345,    44,   965,
     966,    -1,   966,   562,  1113,   967,    -1,  1113,   967,    -1,
      -1,    19,    -1,   113,    -1,    -1,   970,    -1,    -1,   970,
      -1,   247,   971,    -1,   972,    -1,   972,   562,   972,    -1,
     972,   334,   972,    -1,  1107,    -1,   497,    -1,   261,    -1,
     331,    -1,    -1,   247,   972,    -1,   331,    -1,   199,    -1,
     261,    -1,   497,    -1,   104,    -1,   162,    -1,   331,    -1,
     497,    -1,   261,    -1,   104,    -1,   162,    -1,    -1,    -1,
     366,  1124,   977,   560,   978,   561,    -1,    -1,   979,    -1,
     979,   562,   980,    -1,   980,    -1,   855,   860,    -1,    -1,
     982,   983,    -1,   983,   562,   984,    -1,   984,    -1,   566,
    1126,    -1,  1126,    -1,    -1,   222,   986,   987,    -1,    -1,
     349,  1123,   988,  1094,  1097,    -1,   128,  1123,    -1,   981,
      -1,    -1,   125,   990,   906,    -1,   126,   996,  1149,   995,
     993,   786,    -1,    -1,   126,   213,  1124,   337,  1118,   992,
      -1,   126,    91,   995,  1124,    -1,   126,   175,   995,   596,
      -1,   126,   366,   995,   596,    -1,   126,   514,   595,  1179,
      -1,   126,   529,   995,   993,   786,    -1,   126,   488,   995,
     596,    -1,   994,    -1,   993,   562,   994,    -1,  1118,    -1,
      -1,   209,   149,    -1,    -1,   473,    -1,    -1,    -1,   219,
     998,  1003,   785,  1005,   999,  1007,  1023,    -1,    -1,    -1,
     395,  1001,  1004,  1005,  1002,  1007,    -1,    -1,   264,    -1,
     110,    -1,   200,    -1,  1032,    -1,   110,    -1,   222,  1006,
      -1,  1006,    -1,   994,    -1,  1010,    -1,   560,   561,  1010,
      -1,   560,  1009,   561,  1010,    -1,    -1,   426,  1008,  1014,
      -1,  1009,   562,  1111,    -1,  1111,    -1,   522,  1013,    -1,
     523,  1013,    -1,    -1,   681,  1011,  1199,    -1,    -1,   560,
     681,   561,  1012,  1202,    -1,  1013,   562,  1018,    -1,  1018,
      -1,  1014,   562,  1015,    -1,  1015,    -1,  1115,  1016,  1022,
      -1,   142,    -1,   427,    -1,    -1,  1016,    -1,    -1,   560,
    1019,  1020,   561,    -1,    -1,  1021,    -1,  1021,   562,  1022,
      -1,  1022,    -1,   860,    -1,   108,    -1,    -1,    -1,   337,
     129,  1024,   232,   511,  1030,    -1,    -1,    -1,   511,  1026,
    1032,   785,   917,   426,  1028,  1027,   952,   963,   973,    -1,
    1028,   562,  1029,    -1,  1029,    -1,  1115,  1016,  1022,    -1,
    1030,   562,  1031,    -1,  1031,    -1,  1115,  1016,  1022,    -1,
      -1,   264,    -1,    -1,   112,  1034,  1042,  1035,    -1,    -1,
     171,  1118,  1036,   952,   963,   973,    -1,    -1,  1039,  1037,
     171,   917,   952,    -1,    -1,   171,  1039,  1038,   517,   917,
     952,    -1,  1040,    -1,  1039,   562,  1040,    -1,  1124,  1041,
     950,    -1,  1124,   567,  1124,  1041,   950,    -1,    -1,   567,
     554,    -1,    -1,  1043,  1042,    -1,   372,    -1,   264,    -1,
     210,    -1,   492,  1045,   994,    -1,    -1,   472,    -1,    -1,
     431,  1047,  1048,    -1,    92,  1059,    -1,  1055,   470,  1054,
    1059,    -1,  1055,   489,  1054,  1059,    -1,   472,   455,  1054,
    1059,    -1,   340,   470,  1054,  1059,    -1,    -1,   140,   698,
    1049,  1051,    -1,  1055,    65,  1056,  1118,  1054,  1059,    -1,
     322,   281,   168,   435,   535,   269,   142,  1121,    16,   270,
     142,   975,    16,   274,   142,   974,    -1,  1052,   257,    -1,
     435,   201,    -1,    -1,    33,   147,  1057,  1058,  1050,   968,
      -1,   762,  1056,  1118,  1054,   952,    -1,    66,   493,    -1,
     472,   493,    -1,  1053,   139,    -1,   365,    -1,    83,   560,
     554,   561,   530,    -1,    83,   560,   554,   561,   144,    -1,
     530,   968,    -1,   144,   968,    -1,  1138,   455,  1059,    -1,
     216,   455,    -1,   313,   455,    -1,  1055,   368,    -1,  1138,
     526,  1059,    -1,   736,  1059,    -1,    64,  1059,    -1,    30,
     257,    -1,   257,    -1,   189,    -1,   189,   168,  1127,    -1,
      84,    91,   691,  1124,    -1,    84,   472,  1118,    -1,    84,
     529,  1118,    -1,   281,   455,    -1,   435,   455,    -1,    84,
     366,   596,    -1,    84,   175,   596,    -1,   366,   455,  1059,
      -1,   175,   455,  1059,    -1,   366,    62,   596,    -1,   175,
      62,   596,    -1,   455,    -1,   257,    -1,   281,    -1,    32,
      -1,    -1,   459,    -1,    -1,  1056,  1124,    -1,    -1,   173,
      -1,   171,    -1,   225,    -1,    -1,   225,  1121,    -1,    -1,
     171,   975,    -1,    -1,   246,  1121,    -1,   533,   860,    -1,
      -1,  1063,  1118,  1061,  1065,    -1,    -1,  1063,  1064,  1062,
     839,    -1,   113,    -1,   114,    -1,    -1,   153,    -1,    -1,
    1106,    -1,  1124,    -1,    -1,   164,   821,  1067,  1068,    -1,
    1068,   562,  1069,    -1,  1069,    -1,    -1,  1149,  1070,  1071,
      -1,   470,   535,   380,   256,    -1,   371,    46,    -1,   201,
      -1,   365,    -1,   257,    -1,   455,    -1,   435,    -1,   281,
      -1,   117,    -1,   399,    -1,    -1,   993,    -1,    -1,   398,
    1073,  1074,    -1,  1074,   562,  1075,    -1,  1075,    -1,   435,
      -1,   281,    -1,   371,    46,    -1,    -1,   369,  1077,  1078,
      -1,  1052,   257,  1079,    -1,   485,  1121,    -1,    27,   860,
      -1,    -1,   233,  1081,  1082,   860,    -1,    -1,    76,    -1,
     371,    -1,   516,  1124,    -1,    -1,   251,    93,  1085,  1086,
      -1,   251,   472,  1118,   171,   281,    -1,    -1,    -1,    -1,
      -1,  1092,  1091,   214,  1123,  1087,  1093,   222,  1088,   472,
    1118,  1089,   739,  1090,  1094,  1097,  1100,  1101,  1104,    -1,
     171,   281,    -1,    -1,   252,    -1,    -1,    74,    -1,   264,
      -1,    -1,   395,    -1,   210,    -1,    -1,    65,  1095,    -1,
    1095,  1096,    -1,  1096,    -1,   475,    44,  1106,    -1,   343,
     135,    44,  1106,    -1,   135,    44,  1106,    -1,   145,    44,
    1106,    -1,    -1,   249,  1098,    -1,  1098,  1099,    -1,  1099,
      -1,   475,    44,  1106,    -1,   453,    44,  1106,    -1,    -1,
     210,   331,   249,    -1,    -1,   560,  1102,   561,    -1,   560,
     561,    -1,  1102,   562,  1103,    -1,  1103,    -1,  1115,    -1,
     566,  1126,    -1,    -1,   426,  1030,    -1,  1122,    -1,   318,
      -1,   500,   476,    -1,  1105,  1122,    -1,  1122,    -1,   199,
      -1,    34,    -1,   354,    -1,  1109,    -1,   553,  1110,    -1,
     552,  1110,    -1,  1105,    -1,  1110,    -1,   330,    -1,   155,
      -1,   491,    -1,   199,    -1,    34,    -1,   500,   199,    -1,
     500,    34,    -1,    97,  1105,    -1,   481,  1105,    -1,   478,
    1105,    -1,   331,    -1,   261,    -1,   497,    -1,   104,    -1,
     162,    -1,  1115,    -1,  1112,    -1,  1124,   567,   554,    -1,
    1124,   567,  1124,   567,   554,    -1,   860,    -1,  1124,    -1,
    1116,    -1,  1124,    -1,  1116,    -1,  1124,   567,  1124,    -1,
     567,  1124,   567,  1124,    -1,  1124,   567,  1124,   567,  1124,
      -1,  1124,    -1,  1124,   567,  1124,   567,  1124,    -1,  1124,
     567,  1124,    -1,   567,  1124,    -1,  1124,    -1,  1124,   567,
    1124,    -1,   567,  1124,    -1,  1124,    -1,   206,    -1,   208,
      -1,   476,    -1,   476,    -1,   476,    -1,  1120,    -1,  1128,
      -1,  1120,    -1,  1129,    -1,  1124,    -1,  1121,    -1,   245,
      -1,  1126,    -1,  1126,   566,  1126,    -1,    88,   859,    -1,
    1129,    -1,    20,    -1,    26,    -1,    28,    -1,    45,    -1,
      46,    -1,    54,    -1,    56,    -1,    60,    -1,    67,    -1,
      69,    -1,    79,    -1,   103,    -1,   125,    -1,   138,    -1,
     148,    -1,   164,    -1,   195,    -1,   198,    -1,   235,    -1,
     328,    -1,   340,    -1,   362,    -1,   392,    -1,   398,    -1,
     400,    -1,   407,    -1,   416,    -1,   419,    -1,   433,    -1,
     435,    -1,   454,    -1,   458,    -1,   492,    -1,   502,    -1,
     539,    -1,   512,    -1,     5,    -1,     7,    -1,     8,    -1,
       9,    -1,    10,    -1,    11,    -1,    17,    -1,    23,    -1,
      24,    -1,    25,    -1,    30,    -1,    33,    -1,    37,    -1,
      41,    -1,    40,    -1,    43,    -1,    49,    -1,    51,    -1,
      53,    -1,    58,    -1,    59,    -1,    62,    -1,    64,    -1,
      65,    -1,    68,    -1,    70,    -1,    71,    -1,    74,    -1,
      76,    -1,    77,    -1,    86,    -1,    93,    -1,    94,    -1,
      97,    -1,   102,    -1,   109,    -1,   111,    -1,   117,    -1,
     119,    -1,   121,    -1,   128,    -1,   129,    -1,   130,    -1,
     141,    -1,   140,    -1,   139,    -1,   144,    -1,   146,    -1,
     147,    -1,   151,    -1,   153,    -1,   156,    -1,   169,    -1,
     120,    -1,   134,    -1,   173,    -1,   159,    -1,   160,    -1,
     161,    -1,   170,    -1,   183,    -1,   182,    -1,   186,    -1,
     189,    -1,   187,    -1,   196,    -1,   201,    -1,   205,    -1,
     207,    -1,   224,    -1,   211,    -1,   212,    -1,   227,    -1,
     228,    -1,   216,    -1,   220,    -1,   388,    -1,   237,    -1,
     241,    -1,   244,    -1,   250,    -1,   252,    -1,   255,    -1,
     257,    -1,   286,    -1,   281,    -1,   268,    -1,   272,    -1,
     269,    -1,   270,    -1,   282,    -1,   271,    -1,   274,    -1,
     267,    -1,   280,    -1,   276,    -1,   275,    -1,   277,    -1,
     278,    -1,   279,    -1,   284,    -1,   285,    -1,   288,    -1,
     289,    -1,   293,    -1,   294,    -1,   295,    -1,   296,    -1,
     299,    -1,   300,    -1,   305,    -1,   303,    -1,   307,    -1,
     310,    -1,   311,    -1,   312,    -1,   313,    -1,   315,    -1,
     314,    -1,   316,    -1,   319,    -1,   320,    -1,   323,    -1,
     322,    -1,   324,    -1,   333,    -1,   334,    -1,   336,    -1,
     338,    -1,   339,    -1,   351,    -1,   352,    -1,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,   363,    -1,   365,    -1,
     367,    -1,   368,    -1,   370,    -1,   371,    -1,   372,    -1,
     373,    -1,   374,    -1,   375,    -1,   376,    -1,   377,    -1,
     382,    -1,   383,    -1,   386,    -1,   387,    -1,   390,    -1,
     393,    -1,   396,    -1,   399,    -1,   402,    -1,   403,    -1,
     408,    -1,   410,    -1,   411,    -1,   413,    -1,   414,    -1,
     415,    -1,   418,    -1,   424,    -1,   423,    -1,   425,    -1,
     434,    -1,   428,    -1,   432,    -1,   437,    -1,   438,    -1,
     446,    -1,   445,    -1,   448,    -1,   451,    -1,   455,    -1,
     459,    -1,   461,    -1,   462,    -1,   463,    -1,   467,    -1,
     468,    -1,   470,    -1,   471,    -1,   473,    -1,   474,    -1,
     477,    -1,   487,    -1,   489,    -1,   478,    -1,   479,    -1,
     480,    -1,   481,    -1,   493,    -1,   494,    -1,   495,    -1,
     175,    -1,   498,    -1,   499,    -1,   507,    -1,   510,    -1,
     514,    -1,   515,    -1,   526,    -1,   529,    -1,   523,    -1,
     530,    -1,   531,    -1,   536,    -1,   538,    -1,   543,    -1,
      -1,   426,  1132,  1131,  1133,    -1,    -1,   342,    -1,  1134,
      -1,  1133,   562,  1134,    -1,    -1,  1135,  1140,    -1,  1137,
      -1,   187,    -1,   252,    -1,   425,    -1,    -1,   338,    -1,
      -1,   187,    -1,   252,    -1,   425,    -1,    -1,   187,   567,
      -1,   252,   567,    -1,   425,   567,    -1,  1141,    -1,  1137,
    1142,    -1,  1136,  1143,  1016,  1146,    -1,  1136,   487,   227,
     244,  1144,    -1,   566,  1126,  1016,   860,    -1,   566,   566,
    1139,  1143,  1016,  1146,    -1,   736,   741,    -1,   314,  1016,
     860,    -1,   314,   738,   743,    -1,   353,  1016,  1145,    -1,
     353,   168,  1127,  1016,  1145,    -1,  1124,    -1,  1124,   567,
    1124,    -1,   108,   567,  1124,    -1,   380,   498,    -1,   380,
      68,    -1,   393,   380,    -1,   423,    -1,   476,    -1,   353,
     560,   476,   561,    -1,   336,   560,   476,   561,    -1,   860,
      -1,   108,    -1,   337,    -1,    12,    -1,    32,    -1,    -1,
     256,  1149,  1148,  1150,    -1,   472,    -1,   470,    -1,  1151,
      -1,  1150,   562,  1151,    -1,  1118,   950,  1152,    -1,   380,
      -1,   537,    -1,   264,   537,    -1,   380,   252,    -1,    -1,
     508,  1154,  1149,    -1,   195,  1118,   340,   950,    -1,   195,
    1119,    60,    -1,    -1,   195,  1119,   380,  1156,  1157,   952,
     969,    -1,  1158,    -1,  1124,  1159,    -1,   160,    -1,   323,
      -1,   160,    -1,   323,    -1,   363,    -1,   237,    -1,    -1,
    1161,  1160,   560,  1021,   561,    -1,   142,    -1,   180,    -1,
     238,    -1,   194,    -1,   265,    -1,   405,   595,  1163,    -1,
    1167,   337,  1166,  1178,   171,  1180,    -1,  1167,   337,   175,
    1178,   171,  1180,    -1,  1167,   337,   366,  1178,   171,  1180,
      -1,    12,  1168,   562,   188,   342,   171,  1180,    -1,   188,
     595,  1165,    -1,  1167,   337,  1166,  1178,   485,  1180,  1185,
    1186,    -1,  1167,   337,   175,  1178,   485,  1180,  1185,  1186,
      -1,  1167,   337,   366,  1178,   485,  1180,  1185,  1186,    -1,
      -1,   472,    -1,  1169,    -1,    12,  1168,    -1,    -1,   365,
      -1,  1170,    -1,  1169,   562,  1170,    -1,    -1,   420,  1171,
    1182,    -1,    -1,   219,  1172,  1182,    -1,    -1,   511,  1173,
    1182,    -1,    -1,   384,  1174,  1182,    -1,   112,    -1,   513,
      -1,   213,    -1,    13,    -1,    84,    -1,   126,    -1,   148,
      -1,   390,    -1,   432,    -1,   367,    -1,   159,    -1,   188,
     342,    -1,   431,    92,    -1,   467,    -1,    84,   473,   470,
      -1,   256,   470,    -1,   396,   435,    -1,   396,    59,    -1,
      84,   529,    -1,   431,   529,    -1,    84,   410,    -1,    13,
     410,    -1,    84,   514,    -1,    -1,    16,    -1,  1177,  1175,
    1176,    -1,  1177,    -1,   463,   476,    -1,   228,   476,    -1,
      58,   476,    -1,   554,    -1,  1124,   567,   554,    -1,   554,
     567,   554,    -1,  1118,    -1,  1127,    -1,  1179,   562,  1127,
      -1,  1181,    -1,  1180,   562,  1181,    -1,  1127,   207,    44,
     476,    -1,  1127,   207,    44,   353,   476,    -1,  1127,    -1,
      -1,   560,  1183,   561,    -1,  1183,   562,  1184,    -1,  1184,
      -1,  1124,    -1,    -1,   397,  1176,    -1,   397,   452,    -1,
     397,   538,    -1,   397,   324,    -1,    -1,   535,  1187,    -1,
    1187,  1188,    -1,  1188,    -1,   188,   342,    -1,   285,   974,
      -1,   288,   974,    -1,   284,   974,    -1,   289,   974,    -1,
      -1,    28,  1190,  1191,    -1,    -1,   536,    -1,    -1,    16,
     328,    51,    -1,    16,    51,    -1,    -1,   389,    -1,   328,
     389,    -1,    -1,   416,    -1,    69,  1191,  1192,  1193,    -1,
     407,  1191,  1192,  1193,    -1,   407,  1191,   485,  1194,  1124,
      -1,   416,  1124,    -1,   389,   416,  1124,    -1,    -1,  1200,
      -1,    -1,   503,  1206,  1201,   840,    -1,    -1,  1200,    -1,
    1203,    -1,    -1,  1204,  1205,    -1,   964,   968,    -1,   970,
      -1,    -1,   122,    -1,    12,    -1,   420,  1210,  1209,  1211,
      -1,    -1,   560,  1210,  1207,   561,  1208,  1199,  1211,    -1,
     842,    -1,    -1,    -1,  1214,  1213,    -1,  1215,  1214,  1220,
      -1,  1220,    -1,  1228,    -1,  1230,    -1,    -1,   109,   142,
    1127,    -1,  1216,    -1,  1216,  1217,    -1,  1217,    -1,   347,
     395,    -1,    11,   142,   499,    -1,    11,   142,   294,    -1,
      11,   142,   474,    -1,    -1,  1217,    -1,    -1,   450,   419,
     109,    -1,   450,   419,   224,    -1,    -1,  1219,   529,  1118,
    1221,  1222,    18,  1224,  1227,    -1,    -1,   560,  1223,   561,
      -1,  1124,    -1,  1223,   562,  1124,    -1,    -1,  1225,  1226,
      -1,   420,   855,   842,    -1,   560,   855,   841,   561,  1202,
      -1,    -1,   535,    57,   342,    -1,   535,    49,    57,   342,
      -1,   535,   252,    57,   342,    -1,    -1,   488,   855,   596,
     673,   674,   337,   855,  1118,   168,   855,   131,   414,  1229,
     637,    -1,    -1,   703,   855,   175,   596,  1231,   597,    -1,
      -1,    -1,    -1,    -1,   366,   855,   596,  1232,   560,  1233,
     617,   561,  1234,   604,  1235,   637,    -1,   539,  1238,  1237,
    1239,    -1,   539,   138,  1237,  1241,    -1,   539,   362,  1237,
      -1,   539,    69,  1237,  1240,    -1,   539,   407,  1237,    -1,
     539,   382,    -1,  1106,    -1,  1106,   562,  1106,    -1,  1106,
     562,  1106,   562,   974,    -1,    28,    -1,   454,    -1,    -1,
     230,    -1,   402,    -1,    -1,   339,   355,    -1,    -1,    -1,
     468,  1242,  1243,    -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1201,  1201,  1215,  1218,  1219,  1224,  1225,  1226,  1227,
    1228,  1229,  1230,  1231,  1232,  1233,  1234,  1235,  1236,  1237,
    1238,  1239,  1240,  1241,  1242,  1243,  1244,  1245,  1246,  1247,
    1248,  1249,  1250,  1251,  1252,  1253,  1254,  1255,  1256,  1257,
    1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  1267,
    1268,  1269,  1270,  1274,  1288,  1289,  1294,  1308,  1315,  1325,
    1324,  1340,  1342,  1346,  1347,  1350,  1363,  1362,  1381,  1380,
    1391,  1392,  1395,  1400,  1405,  1410,  1415,  1419,  1424,  1428,
    1432,  1436,  1440,  1445,  1449,  1453,  1469,  1473,  1485,  1484,
    1507,  1506,  1527,  1526,  1539,  1538,  1546,  1554,  1568,  1583,
    1601,  1621,  1658,  1664,  1672,  1684,  1620,  1713,  1714,  1718,
    1719,  1724,  1726,  1728,  1730,  1732,  1734,  1736,  1742,  1743,
    1744,  1748,  1752,  1760,  1759,  1772,  1774,  1777,  1779,  1783,
    1787,  1794,  1796,  1800,  1801,  1806,  1825,  1851,  1853,  1857,
    1858,  1862,  1888,  1889,  1890,  1891,  1895,  1896,  1900,  1901,
    1906,  1909,  1936,  1935,  1991,  2006,  2005,  2049,  2073,  2073,
    2104,  2105,  2110,  2112,  2117,  2140,  2146,  2161,  2162,  2166,
    2170,  2179,  2184,  2189,  2197,  2212,  2230,  2231,  2235,  2235,
    2281,  2280,  2304,  2303,  2307,  2308,  2310,  2310,  2321,  2350,
    2378,  2394,  2393,  2410,  2427,  2429,  2430,  2434,  2455,  2478,
    2480,  2494,  2478,  2512,  2514,  2515,  2519,  2520,  2525,  2531,
    2524,  2550,  2549,  2565,  2566,  2570,  2571,  2576,  2580,  2575,
    2597,  2601,  2596,  2616,  2624,  2629,  2628,  2666,  2667,  2672,
    2671,  2698,  2709,  2711,  2708,  2735,  2734,  2752,  2754,  2759,
    2761,  2763,  2768,  2769,  2770,  2782,  2797,  2798,  2798,  2802,
    2804,  2803,  2806,  2805,  2811,  2827,  2810,  2841,  2842,  2845,
    2846,  2849,  2850,  2853,  2854,  2857,  2858,  2861,  2862,  2865,
    2868,  2869,  2871,  2873,  2876,  2877,  2880,  2881,  2882,  2885,
    2886,  2887,  2888,  2889,  2890,  2891,  2892,  2893,  2908,  2914,
    2915,  2916,  2917,  2922,  2927,  2932,  2947,  2948,  2949,  2950,
    2951,  2952,  2956,  2973,  2989,  2999,  3000,  3001,  3002,  3003,
    3004,  3007,  3008,  3009,  3012,  3013,  3014,  3017,  3018,  3021,
    3022,  3025,  3026,  3027,  3028,  3031,  3032,  3036,  3037,  3041,
    3042,  3049,  3057,  3065,  3082,  3086,  3092,  3094,  3098,  3102,
    3103,  3107,  3112,  3111,  3133,  3134,  3135,  3136,  3138,  3140,
    3142,  3144,  3146,  3148,  3151,  3154,  3157,  3160,  3162,  3165,
    3168,  3169,  3170,  3171,  3184,  3185,  3187,  3189,  3201,  3203,
    3205,  3207,  3208,  3209,  3210,  3211,  3212,  3214,  3216,  3218,
    3218,  3220,  3220,  3222,  3223,  3232,  3233,  3234,  3237,  3238,
    3239,  3240,  3241,  3245,  3249,  3250,  3254,  3255,  3259,  3260,
    3261,  3262,  3263,  3267,  3268,  3269,  3270,  3271,  3274,  3276,
    3277,  3281,  3282,  3283,  3286,  3293,  3294,  3297,  3298,  3301,
    3302,  3303,  3306,  3307,  3310,  3311,  3314,  3315,  3318,  3319,
    3322,  3323,  3324,  3325,  3327,  3328,  3334,  3340,  3346,  3352,
    3353,  3369,  3370,  3374,  3375,  3379,  3387,  3391,  3392,  3395,
    3396,  3400,  3409,  3413,  3414,  3417,  3427,  3428,  3432,  3433,
    3436,  3437,  3440,  3441,  3442,  3443,  3452,  3453,  3456,  3457,
    3460,  3461,  3462,  3471,  3473,  3475,  3480,  3479,  3491,  3492,
    3495,  3496,  3500,  3501,  3504,  3505,  3508,  3509,  3510,  3511,
    3512,  3515,  3516,  3517,  3518,  3519,  3522,  3523,  3524,  3536,
    3537,  3540,  3541,  3544,  3545,  3549,  3550,  3551,  3554,  3555,
    3556,  3557,  3570,  3571,  3572,  3575,  3576,  3580,  3583,  3584,
    3587,  3588,  3599,  3600,  3603,  3604,  3607,  3608,  3616,  3615,
    3639,  3638,  3653,  3652,  3671,  3670,  3690,  3688,  3703,  3704,
    3706,  3707,  3708,  3709,  3710,  3713,  3721,  3722,  3726,  3731,
    3730,  3738,  3747,  3737,  3759,  3766,  3770,  3777,  3784,  3790,
    3796,  3802,  3809,  3828,  3849,  3854,  3858,  3865,  3866,  3869,
    3870,  3874,  3875,  3876,  3880,  3881,  3882,  3885,  3886,  3887,
    3888,  3896,  3895,  3906,  3914,  3913,  3923,  3933,  3942,  3943,
    3950,  3950,  3956,  3957,  3961,  3962,  3963,  3967,  3968,  3985,
    3986,  3991,  3990,  4001,  4000,  4011,  4010,  4020,  4021,  4022,
    4027,  4026,  4038,  4039,  4042,  4043,  4046,  4047,  4048,  4052,
    4051,  4064,  4063,  4080,  4081,  4084,  4085,  4088,  4089,  4090,
    4091,  4092,  4093,  4097,  4096,  4108,  4109,  4110,  4115,  4114,
    4120,  4127,  4132,  4140,  4141,  4144,  4156,  4165,  4166,  4169,
    4182,  4183,  4188,  4187,  4197,  4198,  4201,  4214,  4214,  4224,
    4225,  4234,  4235,  4244,  4253,  4255,  4258,  4280,  4284,  4283,
    4303,  4311,  4303,  4317,  4318,  4319,  4320,  4321,  4324,  4331,
    4338,  4340,  4351,  4352,  4355,  4356,  4362,  4363,  4364,  4365,
    4371,  4377,  4383,  4393,  4396,  4398,  4404,  4414,  4415,  4416,
    4429,  4447,  4450,  4453,  4454,  4457,  4458,  4459,  4460,  4461,
    4465,  4466,  4470,  4470,  4487,  4489,  4494,  4495,  4495,  4512,
    4514,  4519,  4520,  4523,  4525,  4527,  4529,  4531,  4532,  4533,
    4537,  4538,  4539,  4540,  4542,  4544,  4547,  4551,  4557,  4561,
    4567,  4571,  4579,  4581,  4587,  4590,  4592,  4594,  4595,  4597,
    4600,  4601,  4604,  4605,  4608,  4610,  4612,  4615,  4616,  4617,
    4619,  4621,  4624,  4625,  4626,  4627,  4628,  4629,  4632,  4633,
    4635,  4635,  4636,  4636,  4637,  4637,  4638,  4638,  4640,  4641,
    4642,  4643,  4644,  4645,  4648,  4649,  4653,  4657,  4658,  4665,
    4666,  4667,  4668,  4669,  4671,  4672,  4673,  4674,  4675,  4679,
    4680,  4685,  4690,  4694,  4695,  4699,  4700,  4704,  4714,  4716,
    4725,  4727,  4738,  4740,  4751,  4762,  4773,  4784,  4786,  4788,
    4790,  4792,  4794,  4796,  4798,  4800,  4802,  4804,  4806,  4808,
    4814,  4816,  4818,  4823,  4828,  4830,  4832,  4837,  4839,  4841,
    4843,  4845,  4850,  4851,  4853,  4855,  4857,  4859,  4861,  4863,
    4865,  4867,  4869,  4871,  4873,  4877,  4879,  4889,  4891,  4893,
    4895,  4897,  4900,  4909,  4914,  4919,  4921,  4923,  4925,  4927,
    4929,  4931,  4933,  4938,  4943,  4945,  4947,  4949,  4951,  4953,
    4955,  4961,  4963,  4965,  4967,  4969,  4971,  4973,  4975,  4977,
    4978,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,
    5006,  5013,  5015,  5017,  5019,  5021,  5023,  5025,  5027,  5029,
    5031,  5033,  5035,  5037,  5039,  5041,  5055,  5054,  5171,  5175,
    5180,  5182,  5184,  5186,  5188,  5190,  5195,  5197,  5199,  5201,
    5203,  5208,  5212,  5214,  5216,  5218,  5220,  5222,  5226,  5229,
    5232,  5234,  5236,  5238,  5240,  5242,  5244,  5247,  5250,  5252,
    5254,  5256,  5258,  5260,  5263,  5265,  5267,  5269,  5274,  5275,
    5276,  5280,  5281,  5285,  5285,  5291,  5295,  5302,  5333,  5335,
    5337,  5339,  5341,  5343,  5345,  5348,  5350,  5347,  5353,  5355,
    5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,  5378,  5381,
    5380,  5395,  5394,  5409,  5415,  5421,  5434,  5435,  5438,  5439,
    5444,  5447,  5459,  5458,  5474,  5475,  5476,  5477,  5478,  5479,
    5480,  5481,  5482,  5483,  5484,  5488,  5489,  5493,  5493,  5498,
    5499,  5502,  5503,  5506,  5506,  5511,  5512,  5515,  5516,  5519,
    5520,  5523,  5529,  5539,  5540,  5549,  5554,  5555,  5575,  5577,
    5581,  5579,  5596,  5594,  5612,  5610,  5617,  5626,  5624,  5642,
    5641,  5651,  5662,  5660,  5679,  5678,  5689,  5699,  5700,  5701,
    5706,  5706,  5725,  5723,  5742,  5764,  5812,  5811,  5834,  5851,
    5834,  5858,  5862,  5888,  5889,  5891,  5893,  5896,  5897,  5903,
    5910,  5919,  5918,  5925,  5926,  5930,  5934,  5938,  5944,  5952,
    5961,  5962,  5963,  5964,  5965,  5966,  5967,  5968,  5969,  5970,
    5971,  5972,  5973,  5976,  5977,  5978,  5979,  5980,  5981,  5982,
    5983,  5984,  5988,  5989,  5990,  5991,  5994,  5996,  5997,  6000,
    6001,  6004,  6006,  6010,  6012,  6011,  6025,  6028,  6027,  6042,
    6048,  6061,  6063,  6066,  6068,  6072,  6073,  6086,  6104,  6108,
    6109,  6113,  6126,  6128,  6132,  6131,  6163,  6165,  6169,  6170,
    6171,  6176,  6182,  6186,  6187,  6191,  6195,  6202,  6209,  6218,
    6219,  6220,  6221,  6226,  6230,  6238,  6239,  6240,  6241,  6242,
    6243,  6247,  6248,  6249,  6250,  6251,  6254,  6257,  6256,  6285,
    6286,  6289,  6290,  6293,  6306,  6306,  6316,  6317,  6321,  6333,
    6366,  6365,  6378,  6377,  6386,  6398,  6409,  6408,  6425,  6432,
    6432,  6444,  6451,  6463,  6475,  6479,  6485,  6495,  6496,  6499,
    6507,  6508,  6512,  6513,  6521,  6530,  6520,  6540,  6547,  6539,
    6557,  6569,  6570,  6571,  6575,  6576,  6579,  6580,  6583,  6592,
    6593,  6594,  6596,  6595,  6605,  6606,  6609,  6610,  6611,  6611,
    6612,  6612,  6616,  6617,  6620,  6622,  6625,  6633,  6634,  6638,
    6639,  6644,  6643,  6656,  6657,  6660,  6665,  6673,  6674,  6677,
    6679,  6679,  6687,  6696,  6686,  6718,  6719,  6722,  6729,  6730,
    6733,  6742,  6743,  6749,  6748,  6762,  6761,  6770,  6769,  6777,
    6776,  6786,  6787,  6790,  6797,  6810,  6811,  6815,  6816,  6819,
    6820,  6821,  6824,  6834,  6836,  6841,  6840,  6854,  6862,  6871,
    6880,  6889,  6899,  6898,  6901,  6911,  6921,  6925,  6930,  6929,
    6934,  6944,  6949,  6955,  6960,  6965,  6967,  6969,  6971,  6973,
    6982,  6984,  6986,  6988,  6997,  7005,  7013,  7015,  7017,  7027,
    7034,  7040,  7048,  7056,  7060,  7064,  7071,  7078,  7088,  7098,
    7108,  7121,  7135,  7148,  7149,  7151,  7153,  7156,  7157,  7160,
    7161,  7164,  7165,  7168,  7169,  7172,  7173,  7175,  7177,  7180,
    7192,  7191,  7206,  7205,  7215,  7216,  7219,  7220,  7224,  7225,
    7226,  7234,  7233,  7245,  7246,  7249,  7249,  7250,  7251,  7252,
    7253,  7254,  7255,  7256,  7257,  7258,  7259,  7262,  7263,  7267,
    7266,  7275,  7276,  7279,  7280,  7281,  7285,  7284,  7293,  7297,
    7302,  7314,  7314,  7322,  7323,  7324,  7329,  7339,  7338,  7351,
    7369,  7380,  7385,  7395,  7368,  7400,  7409,  7410,  7413,  7414,
    7426,  7430,  7431,  7432,  7434,  7436,  7439,  7440,  7443,  7448,
    7455,  7460,  7466,  7468,  7471,  7472,  7475,  7480,  7486,  7488,
    7495,  7496,  7497,  7500,  7502,  7507,  7508,  7513,  7514,  7520,
    7525,  7527,  7529,  7534,  7536,  7547,  7560,  7580,  7581,  7582,
    7591,  7592,  7593,  7595,  7596,  7597,  7598,  7599,  7613,  7627,
    7628,  7629,  7632,  7633,  7634,  7635,  7643,  7658,  7659,  7662,
    7668,  7679,  7682,  7716,  7720,  7728,  7732,  7800,  7815,  7839,
    7840,  7856,  7866,  7869,  7870,  7871,  7875,  7879,  7880,  7905,
    7917,  7930,  7942,  7943,  7952,  7953,  7962,  7963,  7964,  7967,
    7980,  7993,  8007,  8008,  8009,  8010,  8011,  8012,  8013,  8014,
    8015,  8016,  8017,  8018,  8019,  8020,  8021,  8022,  8023,  8024,
    8025,  8026,  8027,  8028,  8029,  8030,  8031,  8032,  8033,  8034,
    8035,  8036,  8037,  8038,  8039,  8040,  8041,  8042,  8043,  8053,
    8054,  8055,  8056,  8057,  8058,  8059,  8060,  8061,  8062,  8063,
    8064,  8065,  8066,  8067,  8068,  8069,  8070,  8071,  8072,  8073,
    8074,  8075,  8076,  8077,  8078,  8079,  8080,  8081,  8082,  8083,
    8084,  8085,  8086,  8087,  8088,  8089,  8090,  8091,  8092,  8093,
    8094,  8095,  8096,  8097,  8098,  8099,  8100,  8101,  8102,  8103,
    8104,  8105,  8106,  8107,  8108,  8109,  8110,  8111,  8112,  8113,
    8114,  8115,  8116,  8117,  8118,  8119,  8120,  8121,  8122,  8123,
    8124,  8125,  8126,  8127,  8128,  8129,  8130,  8131,  8132,  8133,
    8134,  8135,  8136,  8137,  8138,  8139,  8140,  8141,  8142,  8143,
    8144,  8145,  8146,  8147,  8148,  8149,  8150,  8151,  8152,  8153,
    8154,  8155,  8156,  8157,  8158,  8159,  8160,  8161,  8162,  8163,
    8164,  8165,  8166,  8167,  8168,  8169,  8170,  8171,  8172,  8173,
    8174,  8175,  8176,  8177,  8178,  8179,  8180,  8181,  8182,  8183,
    8184,  8185,  8186,  8187,  8188,  8189,  8190,  8191,  8192,  8193,
    8194,  8195,  8196,  8197,  8198,  8199,  8200,  8201,  8202,  8203,
    8204,  8205,  8206,  8207,  8208,  8209,  8210,  8211,  8212,  8213,
    8214,  8215,  8216,  8217,  8218,  8219,  8220,  8221,  8222,  8223,
    8224,  8225,  8226,  8227,  8228,  8229,  8230,  8231,  8232,  8233,
    8234,  8235,  8236,  8237,  8238,  8239,  8240,  8241,  8242,  8243,
    8244,  8245,  8246,  8247,  8248,  8249,  8250,  8251,  8252,  8253,
    8254,  8255,  8256,  8257,  8258,  8259,  8260,  8261,  8262,  8263,
    8264,  8265,  8272,  8271,  8285,  8286,  8289,  8290,  8293,  8293,
    8365,  8366,  8367,  8368,  8372,  8373,  8377,  8378,  8379,  8380,
    8384,  8385,  8386,  8387,  8391,  8392,  8395,  8475,  8488,  8492,
    8497,  8504,  8519,  8532,  8553,  8560,  8598,  8641,  8655,  8656,
    8657,  8658,  8662,  8663,  8670,  8679,  8680,  8681,  8682,  8683,
    8691,  8690,  8706,  8707,  8710,  8711,  8714,  8722,  8723,  8724,
    8725,  8730,  8729,  8750,  8762,  8775,  8774,  8793,  8794,  8798,
    8799,  8803,  8804,  8805,  8806,  8808,  8807,  8818,  8819,  8820,
    8821,  8822,  8828,  8833,  8840,  8853,  8865,  8872,  8877,  8885,
    8898,  8912,  8914,  8917,  8918,  8925,  8927,  8931,  8932,  8935,
    8935,  8936,  8936,  8937,  8937,  8938,  8938,  8939,  8940,  8941,
    8942,  8943,  8944,  8945,  8946,  8947,  8948,  8949,  8950,  8951,
    8952,  8953,  8954,  8955,  8956,  8957,  8958,  8959,  8960,  8961,
    8966,  8967,  8971,  8972,  8976,  8986,  8996,  9009,  9024,  9037,
    9050,  9063,  9064,  9073,  9074,  9083,  9108,  9110,  9117,  9121,
    9124,  9125,  9128,  9149,  9150,  9154,  9158,  9162,  9169,  9170,
    9173,  9174,  9178,  9179,  9185,  9191,  9197,  9207,  9206,  9216,
    9217,  9221,  9222,  9223,  9227,  9228,  9229,  9233,  9234,  9238,
    9248,  9255,  9265,  9274,  9288,  9289,  9294,  9293,  9328,  9329,
    9330,  9334,  9334,  9358,  9359,  9363,  9364,  9365,  9369,  9374,
    9373,  9393,  9399,  9419,  9441,  9443,  9448,  9450,  9452,  9464,
    9474,  9487,  9489,  9491,  9496,  9501,  9503,  9505,  9511,  9512,
    9518,  9519,  9521,  9527,  9526,  9541,  9542,  9546,  9551,  9559,
    9559,  9577,  9586,  9599,  9600,  9602,  9604,  9617,  9615,  9690,
    9689,  9699,  9728,  9735,  9742,  9698,  9764,  9768,  9772,  9776,
    9780,  9784,  9790,  9797,  9804,  9813,  9814,  9818,  9819,  9820,
    9824,  9825,  9829,  9830,  9830,  9835,  9836
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@17", "@18", "@19", "@20", "@21", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@22", "@23", "@24", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@25", "@26",
  "searched_case_stmt", "@27", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@28", "@29",
  "searched_when_clause", "@30", "@31", "else_clause_opt",
  "sp_labeled_control", "@32", "sp_opt_label", "sp_unlabeled_control",
  "@33", "@34", "@35", "@36", "trg_action_time", "trg_event", "create2",
  "create2a", "@37", "create3", "@38", "@39", "create_select", "@40",
  "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   598,   599,   600,   601,   602,   597,   603,   603,   604,
     604,   605,   605,   605,   605,   605,   605,   605,   606,   606,
     606,   607,   607,   609,   608,   610,   610,   611,   611,   612,
     612,   613,   613,   614,   614,   615,   616,   617,   617,   618,
     618,   619,   620,   620,   620,   620,   621,   621,   622,   622,
     623,   623,   625,   624,   624,   626,   624,   624,   628,   627,
     629,   629,   630,   630,   631,   632,   632,   633,   633,   634,
     634,   634,   634,   634,   635,   635,   636,   636,   638,   637,
     639,   637,   640,   637,   637,   637,   641,   637,   637,   637,
     637,   642,   637,   637,   643,   643,   643,   644,   644,   646,
     647,   648,   645,   649,   649,   649,   650,   650,   652,   653,
     651,   655,   654,   656,   656,   657,   657,   659,   660,   658,
     662,   663,   661,   664,   664,   666,   665,   667,   667,   669,
     668,   668,   670,   671,   668,   672,   668,   673,   673,   674,
     674,   674,   675,   675,   675,   675,   676,   677,   676,   678,
     679,   678,   680,   678,   682,   683,   681,   684,   684,   685,
     685,   686,   686,   687,   687,   688,   688,   689,   689,   690,
     691,   691,   692,   692,   693,   693,   694,   694,   694,   695,
     695,   695,   695,   695,   695,   695,   695,   695,   695,   695,
     695,   695,   695,   695,   695,   695,   695,   695,   695,   695,
     695,   695,   696,   697,   698,   699,   699,   699,   699,   699,
     699,   700,   700,   700,   701,   701,   701,   702,   702,   703,
     703,   704,   704,   704,   704,   705,   705,   706,   706,   707,
     707,   708,   708,   708,   708,   708,   709,   709,   710,   711,
     711,   712,   714,   713,   715,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   716,
     715,   717,   715,   715,   715,   718,   718,   718,   718,   718,
     718,   718,   718,   719,   720,   720,   721,   721,   722,   722,
     722,   722,   722,   723,   723,   723,   723,   723,   724,   724,
     724,   725,   725,   725,   726,   727,   727,   728,   728,   729,
     729,   729,   730,   730,   731,   731,   732,   732,   733,   733,
     734,   734,   734,   734,   734,   734,   734,   734,   734,   734,
     734,   735,   735,   736,   736,   737,   737,   738,   738,   739,
     739,   740,   740,   741,   741,   742,   743,   743,   744,   744,
     745,   745,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   748,   748,   748,   749,   749,   751,   750,   752,   752,
     753,   753,   754,   754,   755,   755,   756,   756,   756,   756,
     756,   757,   757,   757,   757,   757,   758,   758,   758,   759,
     759,   760,   760,   761,   761,   762,   762,   762,   763,   763,
     763,   763,   764,   764,   764,   765,   765,   765,   766,   766,
     767,   767,   768,   768,   769,   769,   770,   770,   772,   771,
     773,   771,   774,   771,   775,   771,   776,   771,   777,   777,
     778,   778,   778,   778,   778,   779,   780,   780,   780,   781,
     780,   782,   783,   780,   780,   780,   780,   780,   780,   780,
     780,   780,   780,   780,   780,   780,   780,   784,   784,   785,
     785,   786,   786,   786,   787,   787,   787,   788,   788,   788,
     788,   790,   789,   789,   791,   789,   789,   792,   793,   793,
     795,   794,   796,   796,   797,   797,   797,   798,   798,   799,
     799,   801,   800,   803,   802,   805,   804,   806,   806,   806,
     808,   807,   809,   809,   810,   810,   811,   811,   811,   813,
     812,   815,   814,   816,   816,   817,   817,   818,   818,   818,
     818,   818,   818,   820,   819,   821,   821,   821,   823,   822,
     822,   824,   824,   825,   825,   826,   827,   828,   828,   829,
     830,   830,   832,   831,   833,   833,   834,   836,   835,   837,
     837,   838,   838,   839,   840,   840,   841,   841,   843,   842,
     845,   846,   844,   847,   847,   847,   847,   847,   848,   848,
     849,   849,   850,   850,   851,   851,   851,   851,   851,   851,
     851,   851,   851,   851,   852,   852,   852,   853,   853,   853,
     854,   855,   856,   857,   857,   858,   858,   858,   858,   858,
     859,   859,   861,   860,   862,   862,   863,   864,   863,   865,
     865,   866,   866,   867,   867,   867,   867,   867,   867,   867,
     868,   868,   868,   868,   868,   868,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     870,   870,   871,   871,   872,   872,   872,   873,   873,   873,
     873,   873,   874,   874,   874,   874,   874,   874,   875,   875,
     876,   876,   877,   877,   878,   878,   879,   879,   880,   880,
     880,   880,   880,   880,   881,   881,   882,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   884,   883,   883,   883,
     883,   883,   883,   883,   883,   883,   883,   883,   883,   883,
     883,   883,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   886,   886,
     886,   887,   887,   889,   888,   890,   890,   891,   892,   892,
     892,   892,   892,   892,   892,   893,   894,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   895,
     892,   897,   896,   898,   898,   898,   899,   899,   900,   900,
     901,   901,   903,   902,   904,   904,   904,   904,   904,   904,
     904,   904,   904,   904,   904,   905,   905,   907,   906,   908,
     908,   909,   909,   911,   910,   912,   912,   913,   913,   914,
     914,   915,   915,   916,   916,   917,   918,   918,   919,   919,
     920,   919,   921,   919,   922,   919,   919,   923,   919,   924,
     919,   919,   925,   919,   926,   919,   919,   927,   927,   927,
     929,   928,   930,   928,   928,   928,   932,   931,   934,   935,
     933,   936,   937,   938,   938,   939,   939,   940,   940,   940,
     940,   942,   941,   943,   943,   944,   944,   944,   945,   945,
     946,   946,   946,   946,   946,   946,   946,   946,   946,   946,
     946,   946,   946,   947,   947,   947,   947,   947,   947,   947,
     947,   947,   948,   948,   948,   948,   949,   949,   949,   950,
     950,   951,   951,   952,   953,   952,   954,   955,   954,   956,
     956,   957,   957,   958,   958,   959,   959,   959,   960,   961,
     961,   962,   963,   963,   965,   964,   966,   966,   967,   967,
     967,   968,   968,   969,   969,   970,   971,   971,   971,   972,
     972,   972,   972,   973,   973,   974,   974,   974,   974,   974,
     974,   975,   975,   975,   975,   975,   976,   977,   976,   978,
     978,   979,   979,   980,   982,   981,   983,   983,   984,   984,
     986,   985,   988,   987,   987,   987,   990,   989,   991,   992,
     991,   991,   991,   991,   991,   991,   991,   993,   993,   994,
     995,   995,   996,   996,   998,   999,   997,  1001,  1002,  1000,
    1003,  1003,  1003,  1003,  1004,  1004,  1005,  1005,  1006,  1007,
    1007,  1007,  1008,  1007,  1009,  1009,  1010,  1010,  1011,  1010,
    1012,  1010,  1013,  1013,  1014,  1014,  1015,  1016,  1016,  1017,
    1017,  1019,  1018,  1020,  1020,  1021,  1021,  1022,  1022,  1023,
    1024,  1023,  1026,  1027,  1025,  1028,  1028,  1029,  1030,  1030,
    1031,  1032,  1032,  1034,  1033,  1036,  1035,  1037,  1035,  1038,
    1035,  1039,  1039,  1040,  1040,  1041,  1041,  1042,  1042,  1043,
    1043,  1043,  1044,  1045,  1045,  1047,  1046,  1048,  1048,  1048,
    1048,  1048,  1049,  1048,  1048,  1048,  1048,  1048,  1050,  1048,
    1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,
    1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,
    1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,  1048,
    1048,  1051,  1051,  1052,  1052,  1053,  1053,  1054,  1054,  1055,
    1055,  1056,  1056,  1057,  1057,  1058,  1058,  1059,  1059,  1059,
    1061,  1060,  1062,  1060,  1063,  1063,  1064,  1064,  1065,  1065,
    1065,  1067,  1066,  1068,  1068,  1070,  1069,  1069,  1069,  1069,
    1069,  1069,  1069,  1069,  1069,  1069,  1069,  1071,  1071,  1073,
    1072,  1074,  1074,  1075,  1075,  1075,  1077,  1076,  1078,  1079,
    1079,  1081,  1080,  1082,  1082,  1082,  1083,  1085,  1084,  1084,
    1087,  1088,  1089,  1090,  1086,  1086,  1091,  1091,  1092,  1092,
    1092,  1093,  1093,  1093,  1094,  1094,  1095,  1095,  1096,  1096,
    1096,  1096,  1097,  1097,  1098,  1098,  1099,  1099,  1100,  1100,
    1101,  1101,  1101,  1102,  1102,  1103,  1103,  1104,  1104,  1105,
    1105,  1105,  1105,  1106,  1106,  1106,  1107,  1108,  1108,  1108,
    1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,
    1109,  1109,  1110,  1110,  1110,  1110,  1110,  1111,  1111,  1112,
    1112,  1113,  1114,  1114,  1115,  1115,  1116,  1116,  1116,  1117,
    1117,  1117,  1117,  1118,  1118,  1118,  1119,  1120,  1120,  1121,
    1122,  1123,  1124,  1124,  1125,  1125,  1126,  1126,  1126,  1127,
    1127,  1127,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1128,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,  1129,
    1129,  1129,  1131,  1130,  1132,  1132,  1133,  1133,  1135,  1134,
    1136,  1136,  1136,  1136,  1137,  1137,  1138,  1138,  1138,  1138,
    1139,  1139,  1139,  1139,  1140,  1140,  1141,  1141,  1142,  1142,
    1142,  1142,  1142,  1142,  1142,  1143,  1143,  1143,  1144,  1144,
    1144,  1144,  1145,  1145,  1145,  1146,  1146,  1146,  1146,  1146,
    1148,  1147,  1149,  1149,  1150,  1150,  1151,  1152,  1152,  1152,
    1152,  1154,  1153,  1155,  1155,  1156,  1155,  1157,  1157,  1158,
    1158,  1159,  1159,  1159,  1159,  1160,  1159,  1161,  1161,  1161,
    1161,  1161,  1162,  1163,  1163,  1163,  1163,  1164,  1165,  1165,
    1165,  1166,  1166,  1167,  1167,  1168,  1168,  1169,  1169,  1171,
    1170,  1172,  1170,  1173,  1170,  1174,  1170,  1170,  1170,  1170,
    1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,
    1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,
    1175,  1175,  1176,  1176,  1177,  1177,  1177,  1178,  1178,  1178,
    1178,  1179,  1179,  1180,  1180,  1181,  1181,  1181,  1182,  1182,
    1183,  1183,  1184,  1185,  1185,  1185,  1185,  1185,  1186,  1186,
    1187,  1187,  1188,  1188,  1188,  1188,  1188,  1190,  1189,  1191,
    1191,  1192,  1192,  1192,  1193,  1193,  1193,  1194,  1194,  1195,
    1196,  1196,  1197,  1198,  1199,  1199,  1201,  1200,  1202,  1202,
    1202,  1204,  1203,  1205,  1205,  1206,  1206,  1206,  1207,  1208,
    1207,  1209,  1210,  1211,  1212,  1212,  1213,  1213,  1213,  1214,
    1214,  1215,  1215,  1215,  1216,  1217,  1217,  1217,  1218,  1218,
    1219,  1219,  1219,  1221,  1220,  1222,  1222,  1223,  1223,  1225,
    1224,  1226,  1226,  1227,  1227,  1227,  1227,  1229,  1228,  1231,
    1230,  1232,  1233,  1234,  1235,  1230,  1236,  1236,  1236,  1236,
    1236,  1236,  1237,  1237,  1237,  1238,  1238,  1239,  1239,  1239,
    1240,  1240,  1241,  1242,  1241,  1243,  1243
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     1,     3,     0,     2,     0,     2,
       0,     3,     0,     5,     1,     1,     0,     2,     2,     2,
       2,     0,     6,     2,     0,     2,     1,     1,     3,     0,
       0,     0,     7,     0,     2,     2,     1,     1,     0,     0,
       8,     0,     6,     1,     2,     1,     2,     0,     0,     6,
       0,     0,     6,     0,     2,     0,     5,     0,     1,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     2,     2,     4,     4,     0,     4,     0,
       0,     5,     0,     7,     0,     0,     6,     0,     1,     0,
       1,     1,     2,     1,     1,     0,     1,     1,     2,     1,
       0,     3,     0,     1,     1,     2,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     5,     1,     1,     3,     4,
       4,     3,     4,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     0,
       1,     1,     1,     1,     1,     1,     3,     1,     1,     2,
       2,     6,     7,     8,     2,     2,     0,     1,     2,     0,
       1,     2,     0,     4,     3,     3,     3,     1,     4,     1,
       1,     5,     2,     5,     2,     4,     1,     5,     5,     4,
       3,     1,     1,     2,     1,     1,     2,     1,     1,     1,
       2,     3,     2,     3,     2,     2,     3,     3,     3,     0,
       6,     0,     6,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     2,     1,
       2,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     3,     1,     5,     0,     1,     2,     1,     1,
       1,     1,     0,     3,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       0,     1,     0,     2,     1,     2,     3,     2,     0,     1,
       0,     1,     1,     2,     0,     1,     0,     4,     1,     4,
       3,     1,     0,     1,     2,     1,     3,     3,     2,     2,
       2,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     2,     2,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     0,     2,     1,     3,     0,     6,
       0,     5,     0,     5,     0,     5,     0,    11,     0,     1,
       0,     2,     2,     1,     3,     2,     3,     2,     4,     0,
       6,     0,     0,     8,     4,     4,     3,     3,     2,     2,
       6,     5,     3,     5,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     1,     0,     2,     1,     0,     1,     1,
       1,     0,     5,     3,     0,     5,     3,     3,     0,     3,
       0,     2,     1,     3,     0,     1,     1,     0,     2,     1,
       3,     0,     6,     0,     6,     0,     5,     0,     1,     1,
       0,     6,     0,     1,     1,     2,     1,     1,     1,     0,
       6,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     6,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     5,     1,     3,     2,
       1,     1,     0,     6,     1,     3,     3,     0,     2,     0,
       4,     0,     2,     1,     2,     4,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       4,     0,     0,     1,     1,     0,     2,     2,     1,     1,
       0,     2,     0,     3,     0,     3,     3,     0,     3,     0,
       3,     2,     1,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     1,     3,     1,     3,     3,     1,     3,     3,     4,
       4,     1,     3,     3,     3,     3,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     1,     1,     3,     2,     2,     2,     2,     3,     3,
       5,     6,     4,     4,     7,     4,     2,     6,     5,     6,
       6,     4,     4,     3,     4,     6,     8,     6,     8,     6,
       4,     6,     4,     6,     4,     4,     4,     4,     6,     8,
       2,     2,     4,     2,     7,     7,     3,     4,     4,     6,
       6,     4,     6,     6,     6,     4,     6,     4,     6,     8,
      10,    12,     6,     4,     6,     6,     1,     6,     4,     8,
      10,     4,     1,     3,     4,     6,     6,     8,     6,     6,
       4,     6,     6,     8,     4,     4,     6,     4,     2,     4,
       4,     4,     6,     4,     4,     3,     8,     6,     4,     6,
       3,     6,     8,     4,     8,     6,     8,     6,     8,     2,
       4,     4,     4,     6,     8,     8,     4,     7,     7,     7,
       6,     6,     6,     6,     6,     6,     0,     5,    10,     3,
       4,     3,     2,     2,     2,     4,     6,     4,     4,     6,
       6,     6,     6,     4,     6,     4,     6,     4,     4,     4,
       4,     6,     4,     6,     4,     6,     4,     4,     6,     4,
       6,     4,     6,     4,     4,     6,     4,     6,     0,     3,
       3,     0,     1,     0,     2,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,    10,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     1,     0,     3,     2,     3,     2,     1,     2,     1,
       2,     1,     1,     1,     2,     0,     1,     0,     2,     1,
       3,     1,     3,     0,     2,     1,     3,     0,     1,     0,
       2,     4,     5,     1,     1,     1,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     0,    11,     3,     6,     0,     3,     0,     0,
       5,     0,     1,     0,     1,     0,     2,     0,     2,     2,
       2,     0,     6,     0,     1,     3,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     0,
       2,     0,     1,     0,     0,     3,     0,     0,     3,     2,
       0,     0,     4,     4,     2,     0,     2,     2,     3,     3,
       1,     2,     0,     1,     0,     4,     4,     2,     0,     1,
       1,     0,     1,     0,     1,     2,     1,     3,     3,     1,
       1,     1,     1,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     0,     6,     0,
       1,     3,     1,     2,     0,     2,     3,     1,     2,     1,
       0,     3,     0,     5,     2,     1,     0,     3,     6,     0,
       6,     4,     4,     4,     4,     5,     4,     1,     3,     1,
       0,     2,     0,     1,     0,     0,     8,     0,     0,     6,
       0,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       3,     4,     0,     3,     3,     1,     2,     2,     0,     3,
       0,     5,     3,     1,     3,     1,     3,     1,     1,     0,
       1,     0,     4,     0,     1,     3,     1,     1,     1,     0,
       0,     6,     0,     0,    11,     3,     1,     3,     3,     1,
       3,     0,     1,     0,     4,     0,     6,     0,     5,     0,
       6,     1,     3,     3,     5,     0,     2,     0,     2,     1,
       1,     1,     3,     0,     1,     0,     3,     2,     4,     4,
       4,     4,     0,     4,     6,    16,     2,     2,     0,     6,
       5,     2,     2,     2,     1,     5,     5,     2,     2,     3,
       2,     2,     2,     3,     2,     2,     2,     1,     1,     3,
       4,     3,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     0,     1,     0,     2,     0,
       1,     1,     1,     0,     2,     0,     2,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     0,     1,     0,     1,
       1,     0,     4,     3,     1,     0,     3,     4,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       3,     3,     1,     1,     1,     2,     0,     3,     3,     2,
       2,     0,     4,     0,     1,     1,     2,     0,     4,     5,
       0,     0,     0,     0,    18,     2,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     3,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     0,     1,     1,     3,     0,     2,
       1,     1,     1,     1,     0,     1,     0,     1,     1,     1,
       0,     2,     2,     2,     1,     2,     4,     5,     4,     6,
       2,     3,     3,     3,     5,     1,     3,     3,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     0,     3,     4,     3,     0,     7,     1,     2,     1,
       1,     1,     1,     1,     1,     0,     5,     1,     1,     1,
       1,     1,     3,     6,     6,     6,     7,     3,     8,     8,
       8,     0,     1,     1,     2,     0,     1,     1,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     1,     3,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     3,     1,     3,     4,     5,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       2,     1,     2,     2,     2,     2,     2,     0,     3,     0,
       1,     0,     3,     2,     0,     1,     2,     0,     1,     4,
       4,     5,     2,     3,     0,     1,     0,     4,     0,     1,
       1,     0,     2,     2,     1,     0,     1,     1,     4,     0,
       7,     1,     0,     0,     2,     3,     1,     1,     1,     0,
       3,     1,     2,     1,     2,     3,     3,     3,     0,     1,
       0,     3,     3,     0,     8,     0,     3,     1,     3,     0,
       2,     3,     5,     0,     3,     4,     4,     0,    14,     0,
       6,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1978,   635,     0,  1927,     0,     0,     0,     0,
       0,  1929,    94,    54,  1273,  1364,  1365,  1196,  1212,     0,
     635,    97,     0,    66,  1214,  1401,     0,     0,   635,     0,
    1396,     0,     0,   635,  1217,  1389,     0,    97,  1929,     0,
     670,  1764,  1295,     0,     0,     0,  1293,  1821,  1262,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   663,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1366,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   538,     0,   570,
       0,     0,  1979,  1969,   637,   636,     0,  1813,  1812,   603,
    1929,     0,  1549,  1550,  1551,  1552,  1553,  1554,  1555,  1513,
    1556,  1557,  1558,  1514,  1515,  1559,  1560,  1561,  1563,  1562,
    1564,  1516,  1517,  1565,  1566,  1567,  1518,  1519,  1568,  1569,
    1520,  1570,  1571,  1572,  1521,  1573,  1522,  1574,  1575,  1576,
    1577,  1578,  1523,  1579,  1580,  1581,  1582,  1583,  1524,  1584,
    1585,  1586,  1587,  1602,  1588,  1525,  1589,  1590,  1591,  1603,
    1526,  1594,  1593,  1592,  1595,  1596,  1597,  1527,  1598,  1599,
    1600,  1605,  1606,  1607,  1528,  1601,  1608,  1604,  1747,  1610,
    1609,  1611,  1613,  1612,  1529,  1614,  1530,  1615,  1616,  1497,
    1617,  1498,  1619,  1620,  1623,  1624,  1618,  1621,  1622,  1531,
    1626,  1627,  1628,  1629,  1630,  1631,  1632,  1642,  1635,  1637,
    1638,  1640,  1636,  1641,  1645,  1644,  1646,  1647,  1648,  1643,
    1634,  1639,  1649,  1650,  1633,  1651,  1652,  1653,  1654,  1655,
    1656,  1657,  1658,  1660,  1659,  1661,  1662,  1663,  1664,  1665,
    1667,  1666,  1668,  1669,  1670,  1672,  1671,  1673,  1532,  1674,
    1675,  1676,  1677,  1678,  1533,  1679,  1680,  1681,  1682,  1683,
    1684,  1534,  1685,  1686,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,  1696,  1697,  1698,  1699,  1700,  1625,  1701,
    1535,  1702,  1703,  1536,  1704,  1537,  1705,  1706,  1538,  1707,
    1708,  1709,  1710,  1711,  1712,  1539,  1713,  1540,  1715,  1714,
    1716,  1718,  1719,  1541,  1717,  1542,  1720,  1721,  1723,  1722,
    1724,  1725,  1543,  1726,  1544,  1727,  1728,  1729,  1730,  1731,
    1732,  1733,  1734,  1735,  1736,  1737,  1740,  1741,  1742,  1743,
    1738,  1739,  1545,  1744,  1745,  1746,  1748,  1749,  1546,  1750,
    1751,  1548,  1752,  1753,  1756,  1754,  1755,  1757,  1758,  1759,
    1760,  1547,  1761,   123,  1502,    99,  1503,  1512,     0,   605,
     621,  1930,  1931,   270,   510,   511,   269,   509,    97,  1969,
       0,   266,   267,     0,  1287,  1017,  1210,  1210,     0,  1210,
    1213,  1210,    97,  1210,     0,    59,  1371,     0,     0,     0,
       0,  1496,     0,  1220,  1403,  1407,     0,     0,  1810,     0,
       0,     0,     0,    97,   638,     0,  1271,     0,   601,     0,
    1931,  1942,   664,   668,   680,  1765,  1762,  1349,   590,   590,
     590,   588,   590,  1294,     0,     0,  1271,  1406,  2015,     0,
       0,     0,  2011,     0,  2016,     0,   670,     0,     0,     1,
       3,     0,  1599,  1362,  1360,  1493,     0,   530,   539,   534,
     532,     0,     0,  1980,   619,     0,  1928,     0,   647,   657,
     125,     0,    68,     0,     0,     0,  1934,     0,     0,     0,
       0,    95,   319,  1969,  1971,  1973,   270,   268,     0,  1291,
    1290,  1289,     0,  1287,  1197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1210,    61,     0,  1855,  1870,  1871,
    1867,  1872,  1873,  1877,     0,  1869,  1861,     0,  1876,  1865,
    1874,     0,  1859,     0,  1875,  1880,  1863,  1868,  1847,     0,
    1853,  1857,  1495,  1116,  1824,  1825,     0,  1508,  1499,  1507,
    1506,    67,  1222,  1223,  1221,   569,  1404,  1405,     0,  1418,
       0,     0,     0,   633,     0,  1344,  1343,     0,  1397,  1943,
       0,     0,   610,  1225,  1272,     0,  1224,  1394,     0,  1393,
    1390,  1392,     0,  1855,  1842,     0,  1937,  1934,  1944,   693,
     686,   685,   688,   689,   692,   690,   691,   687,   684,   701,
     681,   683,  1768,     0,     0,   444,     0,  1357,     0,     0,
       0,  1357,     0,  1151,  1350,     0,  1777,  1328,   507,   506,
       0,   505,  1778,  1327,  1343,     0,     0,     0,  1314,     0,
    1779,     0,  1346,     0,  1151,  1357,     0,  1296,     0,     0,
       0,     0,   584,   594,   586,   581,     0,   587,   583,  1292,
    1209,  1822,   569,  1455,  1454,  1500,  2012,  1453,  2020,  2022,
    2008,  2010,  2017,   666,     0,  1948,    53,     0,  1368,  1976,
    1977,  1975,   460,   107,   107,   528,     0,     0,     0,     0,
       0,  1207,     0,     0,   649,   659,   127,   124,    98,     0,
     607,   623,  1933,     0,     0,  1935,  1939,   775,   774,     0,
      92,   710,  1509,  1907,    96,  1903,  1974,   320,   701,   701,
     701,  1964,     0,  1966,  1967,  1968,  1980,  1972,     0,   512,
       0,  1274,  1277,  1281,  1285,  1288,  1550,  1513,     0,  1558,
       0,     0,  1466,     0,     0,     0,     0,  1518,     0,     0,
    1571,     0,     0,  1523,     0,     0,     0,   710,   710,   710,
       0,     0,     0,  1582,  1583,  1475,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1463,     0,  1476,     0,
       0,     0,     0,     0,     0,     0,  1610,     0,     0,  1611,
       0,     0,     0,  1465,  1616,     0,     0,     0,     0,     0,
       0,     0,  1629,     0,     0,  1473,     0,     0,  1023,     0,
    1655,  1657,     0,     0,     0,  1661,     0,     0,  1662,  1663,
    1664,  1450,   777,     0,   710,  1462,  1472,  1676,  1681,  1456,
       0,  1683,     0,  1684,     0,  1689,     0,     0,     0,     0,
       0,     0,  1711,  1713,     0,     0,  1729,     0,     0,     0,
     710,  1740,  1741,  1742,  1743,     0,  1464,  1545,  1474,     0,
       0,     0,  1752,   710,   710,   710,     0,     0,     0,  1758,
       0,  1761,  1027,     0,     0,     0,     0,   776,     0,   991,
       0,  1019,   712,   717,   722,   729,   735,   749,   751,   753,
     756,   761,   767,     0,   862,   769,   856,   792,   791,  1018,
    1460,   790,   789,  1461,   787,  1483,  1502,  1449,  1482,  1211,
    1201,  1202,     0,  1203,  1206,  1901,  1204,   571,     0,     0,
      60,  1385,  1379,  1381,  1384,  1380,     0,  1386,  1383,  1382,
    1813,  1372,  1374,  1375,  1856,  1854,  1888,  1887,     0,  1889,
    1885,  1878,  1908,  1882,  1908,  1884,  1883,  1908,  1879,  1886,
    1908,  1851,     0,  1117,  1118,     0,  1823,     0,  1494,     0,
    1402,  1419,     0,  1420,  1408,  1416,   652,     0,  1116,  1811,
    1814,     0,     0,    56,    57,     0,   640,     0,   639,   643,
       0,     0,     0,  1228,  1218,  1227,  1395,     0,     0,  1854,
    1851,  1938,     0,  1940,  1955,   669,  1945,   699,   671,   698,
       0,   682,  1763,  1766,  1774,  1326,  1353,   443,     0,     0,
    1325,  1311,     0,   270,     0,     0,     0,     0,  1297,  1302,
     304,     0,  1318,  1152,     0,  1357,     0,  1320,  1333,  1321,
       0,  1347,     0,  1357,  1307,  1334,  1347,  1312,  1317,  1324,
    1351,  1352,     0,  1306,  1313,     0,  1322,  1347,  1347,  1357,
    1357,   597,   596,   595,   591,   592,   597,     0,  1060,     0,
       0,  2009,  2023,  2007,  2018,  2019,  2006,   667,  1949,   665,
    1950,     0,  1363,  1361,  1369,  1370,   461,   531,   460,   261,
     264,   263,     0,   535,   533,   460,  1970,     0,     0,   623,
       0,     0,   651,   646,   650,   648,   502,   501,   504,     0,
     658,     0,   128,   130,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    69,
      70,    83,   609,   608,   606,   631,   630,   628,     0,   629,
     627,   622,   624,   625,  1932,  1936,   271,   460,     0,  1511,
       0,     0,     0,     0,     0,     0,     0,  1965,    88,     0,
       0,     0,  1279,  1275,  1285,     0,     0,     0,  1116,     0,
       0,     0,  1121,     0,   806,  1121,  1121,  1121,     0,     0,
    1017,  1017,     0,  1017,     0,     0,     0,     0,  1121,   830,
     833,     0,   831,     0,     0,     0,     0,     0,  1469,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1017,     0,
       0,     0,     0,   996,     0,     0,     0,     0,   786,     0,
       0,     0,     0,  1017,     0,     0,     0,     0,  1023,     0,
    1021,     0,  1121,     0,     0,  1121,     0,     0,     0,     0,
       0,  1017,  1017,  1017,   721,     0,   878,     0,     0,     0,
       0,     0,  1017,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1121,  1121,     0,     0,     0,  1121,     0,
     899,     0,  1471,     0,     0,     0,  1470,     0,     0,  1468,
    1467,  1451,     0,     0,     0,   922,   924,   923,  1121,     0,
    1121,     0,     0,     0,  1028,     0,   795,   794,   796,  1962,
       0,     0,     0,     0,     0,     0,     0,   714,   719,   778,
       0,   779,   780,     0,   781,   782,   783,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   797,  1091,  1092,  1093,
    1094,  1103,  1106,  1095,  1096,  1097,  1105,  1098,  1099,  1100,
    1107,  1108,  1109,  1101,  1110,  1104,  1102,  1111,     0,  1090,
       0,     0,     0,  1452,   916,     0,  1199,     0,   573,   572,
    1205,   571,     0,    62,    64,  1378,     0,     0,  1387,  1881,
       0,  1862,  1866,  1860,  1864,     0,     0,  1852,     0,  1858,
    1120,  1606,  1671,     0,  1123,  1827,  1215,  1415,  1417,     0,
       0,  1409,     0,     0,   623,    58,     0,     0,  1398,     0,
       0,     0,     0,   612,  1226,     0,  1391,     0,     0,     0,
       0,     0,  1941,  1957,  1956,  1946,   701,  1142,   702,   704,
     703,  1482,  1768,  1771,  1772,  1775,  1773,     0,  1770,  1769,
    1784,     0,  1355,  1358,  1359,     0,     0,  1336,  1335,  1331,
    1332,     0,  1161,  1162,  1160,  1155,  1156,  1159,  1340,  1338,
    1329,     0,  1357,     0,  1339,  1337,  1357,  1347,     0,  1357,
    1357,  1319,  1323,     0,   585,   594,   582,   589,  1072,  1071,
       0,  1036,     0,  1035,  1034,  1033,     0,  1071,  2013,  2021,
    2025,     0,  1151,  1954,  1952,   262,  1249,  1249,     0,     0,
       0,     0,     0,     0,     0,   108,   117,   567,   567,  1249,
    1249,   567,  1249,  1249,  1249,     0,     0,  1249,     0,     0,
     567,     0,  1249,   565,     0,     0,  1249,  1249,  1249,   567,
       0,  1249,  1249,  1249,  1249,  1249,   577,  1249,  1249,  1249,
     564,   274,   296,   297,   529,     0,   543,   566,  1981,  1982,
     536,   620,   604,  1208,     0,   126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   632,   626,    93,   711,  1510,     0,  1904,
    2001,     0,     0,  1983,   272,   515,   517,   516,   514,   513,
       0,     0,  1123,     0,  1282,  1060,  1286,  1285,  1283,     0,
       0,     0,  1122,  1121,     0,  1002,  1169,  1170,  1166,  1167,
    1165,  1168,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   975,     0,  1002,     0,
     836,     0,     0,     0,     0,     0,     0,  1482,     0,     0,
       0,     0,     0,  1962,     0,     0,     0,     0,     0,     0,
     813,     0,     0,     0,     0,     0,     0,     0,  1114,  1112,
    1115,  1113,     0,     0,   997,   989,     0,     0,     0,     0,
     863,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1024,  1025,  1121,     0,     0,     0,  1121,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   885,     0,     0,
       0,     0,     0,   890,     0,     0,     0,     0,     0,     0,
       0,  1121,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   919,     0,   921,     0,     0,  1485,
    1484,     0,     0,     0,     0,     0,  1029,   670,     0,   799,
    1017,   798,     0,  1780,   992,   994,     0,   716,   713,   718,
     732,   725,   730,   723,   727,     0,   784,  1555,   733,     0,
       0,  1130,   747,     0,     0,   750,     0,     0,     0,     0,
     752,   754,   755,   758,   862,   757,   862,   765,   766,   762,
     763,   764,   768,     0,   788,   793,  1020,   963,  1486,  1200,
    1902,  1198,    65,     0,     0,  1373,  1388,  1376,  1912,     0,
    1911,  1897,  1900,  1493,     0,     0,     0,  1837,  1831,  1838,
    1840,  1834,  1839,  1841,  1832,  1833,  1828,  1835,  1124,  1153,
       0,     0,   653,   654,   657,     0,  1817,  1818,  1816,  1815,
     634,  1400,  1399,     0,   641,   644,   645,   617,   616,   618,
     611,   613,   614,   254,  1232,     0,     0,     0,  1238,  1219,
    1229,   602,     0,     0,     0,     0,     0,   697,  1060,  1190,
     694,   675,  1153,  1143,   674,   705,     0,  1767,     0,  1738,
    1795,     0,     0,     0,     0,     0,  1785,  1354,     0,  1308,
       0,  1330,  1342,  1341,  1303,     0,     0,     0,  1301,  1348,
    1300,  1123,  1347,  1298,  1299,   599,   598,   593,  1071,  1060,
       0,     0,  1057,  1073,     0,  1073,  1060,  1060,     0,  1060,
    1116,  1068,     0,     0,  2024,  1144,  1953,  1247,  1248,  1250,
       0,     0,   111,   114,   112,     0,   113,     0,     0,   568,
     522,   503,   503,   547,     0,   336,   522,   496,   545,     0,
       0,     0,     0,     0,     0,     0,     0,  1249,     0,   558,
     541,     0,     0,     0,     0,   559,     0,   542,  1249,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   580,
     579,   578,     0,     0,     0,     0,   275,   460,   339,     0,
     574,   336,   342,  1489,  1985,  1087,     0,  1086,   129,    76,
      72,    84,  1174,  1175,  1173,  1171,  1172,    85,    74,    75,
      79,    78,    80,    81,    82,    77,    73,    86,    87,    71,
       0,  1905,     0,   238,   237,     0,  1999,  1985,     0,   339,
      89,  1421,   273,   276,    90,  1060,  1142,  1285,  1123,     0,
    1116,     0,   805,   820,     0,     0,   968,     0,     0,   970,
     971,   972,     0,   824,     0,   822,   825,   826,   827,  1017,
       0,     0,     0,     0,  1017,   974,     0,   832,     0,     0,
     837,   838,     0,   811,     0,   845,     0,   847,     0,  1017,
       0,   841,     0,   802,     0,     0,  1017,     0,   853,     0,
     814,     0,     0,   954,     0,   937,   933,     0,   935,     0,
       0,  1017,  1017,     0,   858,     0,     0,   864,  1017,     0,
     956,     0,   938,     0,   870,     0,  1017,     0,  1022,     0,
       0,     0,   981,   874,   875,     0,   979,   940,     0,     0,
     877,   942,     0,   944,     0,   939,   946,   947,   879,   881,
     880,   949,     0,     0,   951,     0,   953,     0,   883,   884,
       0,     0,     0,   888,     0,  1017,   893,   983,   985,     0,
       0,     0,     0,     0,   987,   900,   902,     0,     0,     0,
     901,     0,     0,     0,     0,     0,     0,     0,   906,     0,
       0,   920,   986,   812,   984,   925,     0,   928,     0,   927,
       0,     0,     0,     0,  1961,  1963,     0,     0,   803,     0,
       0,     0,     0,     0,  1487,   771,   770,     0,   773,   772,
       0,   726,   731,   724,   728,     0,     0,     0,     0,   745,
     744,     0,     0,  1130,   748,     0,   760,   759,   861,     0,
     962,   701,  1017,     0,    63,  1377,  1909,     0,     0,     0,
       0,     0,     0,     0,     0,  1826,  1154,  1259,  1501,  1410,
       0,   661,  1819,  1820,     0,   615,   680,     0,  1251,  1236,
    1243,  1237,     0,     0,     0,  1235,  1478,  1477,  1484,  1944,
       0,     0,     0,     0,  1947,  1123,  1123,  1184,     0,     0,
     672,   677,   673,   676,     0,   700,   709,   708,  1479,  1486,
       0,     0,     0,     0,   446,   448,   447,   456,     0,   445,
       0,     0,  1780,     0,   452,   454,   453,  1790,   451,  1356,
    1151,  1316,  1315,  1158,  1157,     0,  1310,  1357,     0,  1951,
    1066,     0,  1059,  1058,  1074,     0,  1060,  1073,  1073,     0,
    1039,  1038,  1263,  1266,     0,  1037,  1077,  1064,   680,  2014,
    2026,     0,   459,   458,   303,   455,   302,   116,   115,   121,
     122,   341,   523,   497,   498,     0,     0,     0,   503,   335,
     522,   334,   337,   512,     0,   286,   283,   549,   289,   285,
     301,     0,     0,   290,   522,   556,   557,   571,   279,     0,
     315,   316,   314,   298,   281,   282,   551,  1138,  1140,  1148,
     288,   287,   284,   293,   294,   312,   311,   292,   313,   562,
     310,   308,   305,   307,   306,   309,   291,   280,     0,   544,
       0,   325,   327,   328,  1492,     0,   576,   546,     0,   329,
     330,     0,     0,     0,     0,   660,     0,  1906,  2002,   241,
     239,   240,     0,     0,     0,   244,     0,   242,     0,     0,
    1423,  1422,   243,   257,   460,   277,     0,  1123,  1163,  1278,
    1284,     0,     0,     0,   969,  1003,     0,   422,   422,  1013,
    1011,   411,   422,  1007,  1012,  1009,     0,     0,     0,     0,
       0,     0,     0,   976,   973,     0,     0,     0,  1486,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1000,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   958,  1026,   982,
     980,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   988,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1030,   808,  1958,  1959,
     800,  1781,  1782,  1783,   524,   993,   715,   720,     0,   738,
    1017,   736,  1129,   742,     0,     0,   746,     0,   917,     0,
     964,   965,     0,  1016,  1488,  1910,  1899,  1898,  1913,  1913,
    1913,     0,  1125,     0,  1216,  1421,   655,     0,   656,   642,
     701,  1233,  1245,     0,  1253,     0,     0,  1230,  1240,     0,
       0,     0,  1239,     0,  1844,  1845,  1843,  1153,  1131,     0,
       0,  1195,     0,  1191,   695,     0,   707,   706,     0,  1797,
       0,  1796,  1808,  1809,  1806,  1807,  1805,  1786,     0,  1792,
    1791,     0,     0,     0,  1802,  1793,     0,     0,  1309,     0,
    1304,   600,     0,  1060,  1073,  1060,  1046,     0,     0,  1060,
    1042,  1040,  1044,     0,  1123,     0,     0,     0,     0,  1061,
     701,  1481,  1145,  1148,   338,   522,   499,   500,   512,     0,
       0,     0,     0,   456,   299,   555,   554,   300,     0,     0,
    1149,  1150,  1141,     0,   548,   339,   575,   476,   407,   356,
     347,   422,   350,   349,   393,   364,   361,   411,   409,   379,
     411,   411,   386,   385,   403,   389,   369,   462,   462,   368,
     406,   462,   390,   388,   392,     0,   394,   411,   399,   387,
     391,   408,   384,   381,   405,   422,   422,   362,   365,   404,
     462,     0,   397,   422,   426,   367,   462,   468,     0,     0,
     422,   424,  1491,  1987,     0,  1989,  1085,   142,   701,     0,
     101,  2000,  1989,     0,   247,   272,   258,     0,   278,     0,
    1280,     0,  1276,   786,   817,   821,   930,     0,  1004,   462,
       0,  1014,   413,  1006,  1008,  1010,   807,   823,   828,   932,
     810,   809,     0,     0,     0,     0,   843,   846,   848,   839,
     844,   842,     0,   931,   855,   852,   854,   815,     0,   955,
     934,   936,   857,   868,   998,  1001,     0,     0,     0,   869,
     865,   957,   866,     0,   871,   840,   872,     0,     0,     0,
       0,   941,   876,   943,   945,   950,   948,   952,   882,   819,
       0,   887,   889,   801,   786,   891,     0,   897,   895,     0,
       0,   903,     0,     0,   912,     0,   910,     0,   911,     0,
     913,   914,     0,   926,   929,  1031,     0,  1944,     0,   995,
     734,     0,   740,  1017,   737,   743,   702,   701,   915,     0,
    1918,  1918,  1918,  1258,  1257,     0,  1256,  1260,     0,   662,
     255,     0,     0,     0,  1254,  1242,  1948,  1231,  1234,  1486,
    1846,   679,     0,  1126,  1194,  1192,     0,  1185,  1187,  1189,
       0,  1480,     0,     0,  1801,  1787,   457,     0,     0,     0,
       0,  1788,     0,  1116,  1067,     0,     0,  1033,  1060,  1060,
       0,  1033,     0,     0,     0,  1265,  1142,  1267,  1075,  1079,
    1080,  1078,  1069,     0,  1147,     0,     0,     0,   561,     0,
     574,   563,   426,  1139,   295,   326,   482,     0,     0,   366,
     415,   410,     0,   415,   415,   468,   470,   464,   468,     0,
     375,   393,   370,     0,   462,   383,   374,   395,   398,   400,
     402,   415,     0,   462,   363,   372,     0,   415,   434,     0,
       0,     0,   430,     0,   475,     0,   437,   343,   427,   429,
       0,     0,   396,     0,   352,   469,     0,   354,     0,     0,
     415,     0,   425,   415,     0,  1986,     0,  1993,     0,   145,
     143,   144,     0,   138,   140,   135,     0,   323,   324,   322,
     321,     0,   131,  1993,   245,  1948,  1421,     0,   250,     0,
    1148,   520,  1164,     0,     0,  1005,     0,     0,   977,   834,
     835,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   804,     0,     0,     0,     0,     0,     0,     0,
     909,   907,   908,     0,  1032,  1963,   525,   739,     0,   705,
     966,     0,     0,  1917,  1915,     0,  1916,  1914,  1890,     0,
    1849,  1850,  1848,  1836,     0,     0,  1411,  1153,  1244,  1246,
    1252,  1241,     0,  1127,  1142,  1424,  1188,     0,   696,  1799,
    1798,  1800,  1794,     0,     0,     0,     0,  1065,  1060,  1047,
       0,  1051,  1056,  1052,     0,  1043,  1041,     0,  1163,     0,
    1081,  1153,  1148,     0,     0,     0,     0,     0,     0,     0,
       0,   560,  1457,   550,   552,     0,     0,     0,   477,   478,
     483,   485,     0,     0,   419,   420,   421,   376,   416,   418,
       0,   378,   346,   463,   471,   472,     0,   467,   465,   468,
     371,   401,   377,     0,   373,     0,   360,   440,   439,   710,
     432,   442,     0,     0,   438,   428,   436,   431,     0,     0,
       0,     0,   344,     0,   345,  1490,  1988,     0,   537,   701,
     701,  1990,  2003,   142,     0,     0,     0,     0,   132,   134,
     135,  1984,   248,   246,     0,  1944,    91,     0,   519,     0,
     818,   423,   412,     0,   829,   849,     0,   816,   999,   990,
    1121,   859,     0,   867,   873,   960,   959,   886,   892,   896,
     894,   898,   904,   905,  1017,  1960,   741,   967,  1896,  1895,
    1894,  1891,     0,     0,     0,     0,     0,     0,  1919,  1921,
    1255,     0,     0,   256,   694,   317,  1135,  1148,     0,  1153,
       0,  1432,  1186,  1804,  1803,  1789,     0,     0,     0,     0,
       0,     0,     0,  1088,  1264,  1076,     0,  1070,  1146,     0,
       0,   331,  1459,  1458,   574,   488,   489,   490,     0,     0,
       0,   481,   484,   355,   348,   417,     0,   526,   473,   466,
       0,   359,   441,   710,   435,   462,   468,   462,   468,     0,
       0,     0,   670,     0,   109,   139,     0,   701,   100,   102,
       0,     0,   252,   251,  1148,     0,     0,     0,     0,     0,
       0,  1892,  1922,  1925,  1923,  1924,  1926,  1920,     0,     0,
     318,     0,     0,  1132,  1134,  1128,  1176,     0,     0,     0,
       0,  1425,  1427,     0,  1193,     0,  1062,  1048,     0,  1053,
       0,  1045,     0,  1083,     0,   332,   553,   492,     0,   491,
       0,   486,   487,   482,     0,   462,     0,   462,   433,   351,
     353,   357,   358,     0,  1994,     0,  1991,     0,  2004,   141,
       0,     0,   133,   136,  1948,   518,   521,   414,   850,     0,
     978,   860,   918,  1261,  1269,     0,  1412,  1136,  1137,  1148,
       0,   678,     0,     0,     0,     0,  1426,     0,     0,  1433,
    1435,     0,     0,     0,     0,  1089,     0,  1084,   333,   494,
     495,   493,   479,   480,   380,   527,   382,  1995,  1996,  1948,
     119,   118,   110,     0,   178,     0,   103,   253,     0,     0,
       0,   449,  1133,  1177,  1430,  1431,     0,  1428,     0,     0,
    1434,     0,     0,  1050,  1055,  1082,  1992,   120,     0,   194,
     182,     0,     0,     0,   180,   208,  2005,     0,     0,   184,
     206,   207,   185,  1504,     0,  1505,  1997,     0,   851,  1268,
    1270,     0,  1413,     0,  1429,  1437,  1436,     0,  1063,   193,
     196,     0,     0,   199,   189,   188,   190,     0,     0,     0,
     179,   229,   178,   178,   232,   187,   225,   178,   104,   450,
    1424,   701,     0,   195,     0,     0,     0,   181,   209,   220,
     223,   215,   150,   178,     0,   178,     0,     0,  1998,   109,
    1432,     0,     0,  1180,  1182,     0,   191,     0,     0,     0,
       0,   178,   216,     0,   146,     0,     0,   148,   235,     0,
     227,   105,  1438,  1183,  1178,   701,  1305,     0,   183,   200,
     217,   223,   213,   221,   178,     0,     0,   178,     0,   231,
     149,     0,   233,   226,   228,   178,     0,  1440,  1181,   192,
     197,   178,     0,   214,     0,     0,   212,   161,   160,     0,
     152,   174,   230,     0,   151,     0,   178,   106,     0,     0,
    1447,     0,   178,   218,     0,   178,     0,     0,     0,     0,
       0,   147,     0,   178,  1439,  1442,     0,     0,  1444,  1445,
       0,  1414,   198,   203,     0,   210,   178,   155,   175,   176,
       0,   158,   236,     0,  1446,  1441,     0,  1448,   199,   178,
     202,   178,     0,     0,   153,   167,   154,   165,   157,     0,
     234,  1443,   204,   178,   178,   173,   171,   178,   162,   169,
     164,     0,   170,   177,   168,     0,   159,     0,   156,   172,
     166,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   963,    58,   515,
     910,  1363,  1364,    59,   412,    60,   689,  1109,  1110,  1111,
      61,  1574,  2436,  1127,   389,   407,   373,  2741,  3012,  3381,
    3477,  3529,  3575,  1073,  3378,  1495,  3432,  1496,    62,   480,
     687,  1091,  1092,  3187,  3188,  3184,  3189,  3002,  3003,  3004,
    3005,  3567,  3523,  3544,  3568,  3608,  3642,  3648,  3649,  3589,
    3657,  3658,  3659,  3665,  3660,  3590,  3644,  3524,  3467,  3497,
    3493,  3468,  3557,  3492,  3579,  3515,  3516,  3581,  3623,  3640,
    3469,  3470,  3498,  3539,  3471,  3499,  3561,  3520,  3562,  3582,
    3624,  3521,  3540,  3585,  3543,  3472,  3527,  3573,  3505,  3522,
    3526,  3596,  3571,  2015,  2422,  2020,  2427,  3015,  2432,  3195,
    3384,  1848,  2246,  3077,  2747,  1067,  1068,  1069,   390,   391,
     392,   488,  2021,  1530,  2022,  2023,  1532,  1533,  1009,  2396,
    2387,  2373,  3243,   710,  3011,  2400,  2401,  2402,  2403,  2351,
    2352,  1934,  1935,  1981,  2411,  2724,  2942,  2962,  2725,  2726,
    2727,  2728,  2729,  2730,  2731,  2761,  2762,  3137,  3138,  3139,
    2758,  2993,  2977,  2978,  2979,  3160,  2949,  2286,  2287,  3482,
    2296,  2297,  2333,  2619,  2334,  1072,  2950,  2987,  3147,  2980,
    2410,  2936,  3128,  3280,  3129,  3130,  3131,  3361,  1936,  2350,
    1088,  1089,   636,   393,  1141,  1578,  3019,  3020,  2341,  2849,
    3286,    63,  1075,   672,   674,   673,  1984,   467,  1534,  1535,
    1536,  2662,  2668,  3274,  1938,   111,  1360,  2407,  1972,    64,
    1046,  1041,    65,   647,   642,   643,  1044,  1045,  1464,  1896,
      66,   582,    67,   475,    68,   483,  1114,    69,   971,  1840,
    1841,  1842,    70,   679,    71,   484,  1121,  1122,  1123,    72,
     961,   116,    73,   571,   966,   968,   969,    74,   477,   478,
    1083,    75,  1390,  1822,  1823,   684,   685,  1090,  2578,    76,
      77,   458,   432,   588,   433,   434,  1417,  1860,  3244,   599,
     600,   601,  2270,   988,   989,   990,  1865,  1418,  2275,  1129,
    2864,  1297,  1748,   872,  1298,  1749,   873,   874,   875,   876,
     877,   878,   879,   880,   881,   882,  2197,  2200,  2981,   883,
    1307,  1759,   884,   885,  1787,   886,  2810,  2219,  2220,  2221,
    2560,  2561,   887,  2054,  2773,  2092,   888,  1294,  1744,  1655,
    3034,  2794,  1594,  2037,  2456,  2562,   504,   505,   889,  1219,
    1220,  1221,  1672,  1285,  2183,  1736,  1471,  1472,  1473,  1474,
    2913,  2912,  2914,  3258,  3100,  3260,  3104,  1907,  1475,  1476,
    3412,  2309,  2633,  2327,  2328,  3111,  1898,  1477,  2315,  3110,
    2649,  2919,  3266,  3416,  1986,  3262,  1348,  1349,  1652,   945,
     946,  1595,  1819,  2234,  3084,  3248,  2209,  2883,  3246,  3333,
    1537,  2377,  2378,  1862,  1863,  2331,  2652,  2672,  1012,  3245,
    2236,  1445,  1446,  2752,  3647,  1997,  3401,  3483,  3532,  3533,
    3534,  2601,  2602,  2887,  2888,  1864,  2267,  2603,  3085,    78,
     395,    79,  1789,   680,   681,   507,   404,    80,   413,  1820,
      81,   426,  1405,   555,   575,   974,   975,  1849,  2247,  2254,
    1850,  2259,  2876,  2249,  2581,  2582,  1919,  1920,  2250,  2584,
    2873,  2865,  2866,  2574,  3075,    82,   446,  2644,  2322,  2323,
    3393,  3394,   576,    83,   394,   721,  1582,  1146,  1581,   722,
     723,  1148,   502,   503,    84,   444,    85,   437,   637,  1441,
    2300,  1884,   567,   639,  1452,   640,  1453,  1432,  1879,  1000,
      86,   668,   667,    87,   463,  1063,    88,   516,   921,   922,
    1368,  1797,    89,   427,   580,   581,    90,   421,   568,  1398,
      91,   414,   558,    92,    93,   559,   954,  2575,  3242,  3441,
    3510,  1389,   955,  2433,  3251,  3341,  3342,  3344,  3409,  3410,
    3577,  3600,  3617,  3618,  3621,   890,   656,   891,  3121,   892,
     893,  2255,  2256,  2653,   894,  3395,   895,  1982,   650,   410,
     896,   549,   897,  2239,   898,  3474,   702,   703,   376,   377,
      94,   602,   436,   992,   993,   994,  1427,  1428,   641,  2192,
    1429,  1430,  1876,  1871,  2895,  2625,  2617,    95,   562,   923,
     959,   960,  1828,    96,   445,    97,   947,  1384,  1385,  1816,
    2233,  1817,    98,   584,    99,   538,  1378,   539,   925,   540,
     541,   937,   932,   940,   934,  3232,  3067,  3068,  1804,   906,
     704,   705,  1371,  1799,  1800,  2860,  3070,  3238,  3239,   100,
     120,   382,   486,   696,   982,   101,   102,   103,   104,   985,
    1058,  1856,  1059,  1060,  1061,  1484,  1415,  1292,  2847,  2185,
    1738,  2538,   491,   711,   473,   493,   494,   112,   113,   712,
     713,  2017,  2414,  2734,  2997,  2998,  3181,  3178,   714,  3507,
     715,  2423,  2012,  2737,  3304,  3434,   105,   658,   455,  1056,
    1051,  1053,  1480,  1914
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3163
static const int yypact[] =
{
    3650, -3163,   193,    65,   834, -3163,    94, 41497,    35,   834,
     834,  -214,   673, -3163, -3163, -3163, -3163, -3163,   946, 41497,
      65, -3163, 20477, -3163, -3163, -3163,   199,   834,    65, 41497,
   -3163,   -44,   711,    65, -3163, -3163,   834, -3163,  -214, 41497,
   -3163,   377, -3163,   396,   589,   300,   361, -3163, -3163, 41497,
     703,  -146,   849,   857, -3163, -3163,   710, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, 21017, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163,   940, 41497, 41497, -3163,
   41497,   616, -3163,  1061, -3163, -3163,   834, -3163, -3163, -3163,
    -214, 20477, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,   552, -3163, -3163,   680, -3163,
   -3163, -3163,  1166,   995, -3163, -3163, -3163, -3163, -3163,   205,
     743, -3163,   760,  1029,   143, -3163,  1046,  1046, 41497,  1046,
   -3163,  1046, -3163,  1046,   834, -3163, -3163,  1140, 41497,   986,
     327,  -117, 36664,   140,   166, -3163,  1043, 20477, -3163,   834,
    1129,   204, 41497, -3163, -3163,   834,   185,   446, -3163,  1555,
     145, -3163, -3163, -3163,   331, -3163, -3163,  4874, -3163, -3163,
   -3163,   762, -3163, -3163, 20477,   834,  1070, -3163, -3163,   162,
     162,   162, -3163,   162, -3163,   162, -3163,  -146,   783, -3163,
   -3163, 41497,  -119, -3163, -3163,   780,   -36, -3163, -3163, -3163,
   -3163, 20477,  1210,   916, -3163, 20477, -3163,   -19, -3163, -3163,
     813, 41497, -3163, 20477, 20477,   214,   -31,   633, 41497, 34516,
     981, -3163,   130,  1061,  1388, -3163,   995, -3163, 41497, -3163,
   -3163, -3163, 38275,   143, -3163, 12764,  1232, 41497, 41497,  1071,
   41497, 41497, 34516, 20477,  1046,   884,  1229,  1048,  1001,   712,
   -3163, -3163, -3163, -3163,  1075, -3163, -3163,   974, -3163, -3163,
   -3163,   125, -3163,    52, -3163, -3163, -3163, -3163, -3163,  1103,
     886, -3163, -3163,    89, -3163, -3163, 41497, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,  1240, -3163, -3163, 12764,   202,
    1408,  1286, 20477, -3163,  -190, -3163, -3163,  1208, -3163, -3163,
   34516, 20477, -3163, -3163, -3163, 18307, -3163, -3163,  1422, -3163,
     908, -3163, 20477,  1048, -3163,  1171,  1081,   -31,   989, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,   949,
     331, -3163, -3163,  1259,  1371, -3163,  1101,   179,  1030,   969,
     180,   179, 36664,  1291, -3163,   132, -3163,  1373, -3163, -3163,
    1094, -3163, -3163, -3163,  1096,  1111,  1273,  1086, -3163,   211,
   -3163,    43, -3163,  -118,  1291,   179,   163, -3163,  1301,  1441,
     313,   353, -3163,   -85, -3163, -3163,  1507, -3163, -3163, -3163,
   -3163, -3163,  1240, -3163, -3163, -3163,  1026, -3163,  1254,  1135,
   -3163, -3163,    27, -3163,  1047,   -13, -3163,   350, 35053, -3163,
   -3163, -3163,   112, -3163, -3163, -3163, 34516,  1196,  1092, 20477,
     419, -3163, 38812, 20477, -3163,    -3, 12764, -3163, -3163,  1919,
      10,   138, -3163,  1568,  1238, -3163, -3163, -3163, -3163,  1496,
   -3163,  1108,  1084,  1465,  1114, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,  1150, -3163, -3163, -3163,   916, -3163, 20477,   656,
   20477, -3163,  1121, -3163,  1130, -3163,  1131,  1142,  1158,  1170,
    1173, 15579, -3163,  1182,  1186,  1191,  1197,  1199,  1206,  1209,
    1211,  1228,  1234,  1243,  1248,  1249,  1252,  1108,  1108,  1253,
    1255,  1256,  1258,   -58,  1261, -3163,  1264,  1266,  1267,  1268,
    1270,  1274,  1276,  1277,  1278,  1279, -3163,  1281, -3163,  1283,
    1284,  1285,  1287,  1288,  1289,  1290,  1292,  1296,  1297,  1302,
    1303,  1309,  1310, -3163,  1311,  1312,  1313, 12764,  1314,  1315,
    1316,  1317,  1318,  1319,  1320, -3163,  1325,  1327,  1328,  1329,
    1330,  1331,  1332,  1333,  1335,  1336,  1337,  1339,  1340,  1343,
    1345, -3163, -3163, 12764,  1346, -3163, -3163,  1347,  1349, -3163,
    1350,  1355,  1356,  1357,  1358,  1359,  1360,  1361,  1364,  1365,
    1366,  1368,  1376,  1378,  1380,  1382,  1383,  1390,  1392,  1394,
    1398,   558,  1399,  1400,   723,  1401, -3163,  1402, -3163,   168,
    1403,  1404,  1406,  1108,  1108,  1108,  1409,  1414,  1416,  1417,
    1419,  1420, 12764, 15579, 15579, 15579,  8260, -3163, 41497, -3163,
   41497, -3163,  1181, -3163, -3163,  1410, -3163,   922,  1222,   674,
     640,   212,  1235, 15579,  2232,   333, -3163, -3163, -3163,  1236,
    1375, -3163, -3163, -3163, -3163, -3163,  1421, -3163,  1294, -3163,
   -3163, -3163, 20477, -3163, -3163, -3163,  1271,    78, 20477,  1280,
   -3163, -3163, -3163, -3163, -3163, -3163,  1835, -3163, -3163, -3163,
    1367,  1369, -3163, -3163, -3163, -3163, -3163, -3163,  1478, -3163,
   -3163, -3163,  1423, -3163,  1423, -3163, -3163,  1423, -3163, -3163,
    1423,   620,  1782, -3163, -3163, 41497, -3163, 42034, -3163, 18307,
   -3163, -3163,  1630, -3163, -3163,  1705, -3163,  1687,   136,  1427,
   -3163, 20477, 36664, -3163, -3163,   137,  1428,  1497,  1430, -3163,
    1499, 20477, 20477, -3163, -3163, -3163, -3163,   446,    11,  1434,
     635, -3163, 41497, -3163,   258, -3163, -3163, -3163,  1435, -3163,
   12764, -3163,  1436, -3163,    61, -3163,  1760, -3163,  1515, 12764,
   -3163, -3163,  1445,   995, 41497, 41497, 20477, 20477, -3163, -3163,
   -3163,    -5, -3163, -3163, 41497,   179, 34516, -3163, -3163, -3163,
    1834,   163, 41497,   179, -3163, -3163,   163, -3163, -3163, -3163,
   -3163, -3163, 20477, -3163, -3163,   163, -3163,   163,   163,   179,
     179,  1493, -3163, -3163,  1442, -3163,  1493,  1569,   506,   162,
    1650, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163,    53, -3163, -3163, -3163, -3163, -3163, -3163,   129, -3163,
   -3163, -3163,  1213,   827,   827,  3113, -3163,   184, 20477,   138,
    1515, 20477, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1447,
   -3163,  1448,  1446, -3163,  1871,  1873,  1874,  1876,  1877,  1878,
    1879,  1881,  1883,  1884,  1886,  1888,  1889,  1891,  1893,  1474,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1529, -3163,
   -3163, -3163, -3163,  1010, -3163, -3163, -3163,   112,  1481, -3163,
   36664,  1999, 34516, 41497, 41497,  1870, 20477, -3163, -3163,   275,
     275,  1709,  1121, -3163,   110, 41497,  1880, 24792,   141, 12764,
   12764, 12764,   267,   198,  1984,  2036,  2036,  2036, 12764, 12764,
   -3163, -3163, 12764, -3163, 12764, 12764, 12764, 12764,   299, -3163,
   -3163,  8823, -3163,  1489, 12764, 12764,  1576, 12764,  1375, 12764,
   12764, 21557, 12764, 12764, 12764, 12764, 12764,   367, 12764,  2232,
   12764, 12764, 12764,  1492, 12764, 12764, 12764, 12764, -3163, 12764,
   12764,   248, 12764,  1932,   -20, 12764, 12764, 12764, -3163,  9386,
   12764, 12764, 12764, -3163, 12764, 12764, 12764, 12764, -3163,  2046,
   -3163, 21557,   789, 12764, 12764,   795, 12764, 12764, 12764, 12764,
   12764, -3163, -3163, -3163, -3163,  8823, -3163, 12764, 12764, 12764,
   12764, 12764, -3163, 15579, 12764,  9949, 12764, 12764, 12764, 12764,
    1495, 12764, 12764,  2036,  2036, 12764, 12764, 12764,   797,  8823,
   -3163, 12764,  1375,   544,   544, 12764,  1375,  7134, 12764, -3163,
   -3163, -3163,   -20, 10512,  1500, -3163, -3163, -3163,  2036, 21557,
    2036, 12764, 12764, 12764, -3163,  1526,  1984,  1984,  1984, -3163,
    8260,   636,  1501, 12764, 22637,  1504, 12764, -3163, -3163, -3163,
   15579, -3163, -3163,   641, -3163, -3163, -3163, 13327,  1503, 15579,
   15579,  1814, 15579, 15579,   528, 15579, 15579, 15579, 15579, 15579,
   15579, 15579, 15579, 15579, 15579, 15579,  1984, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1511, -3163,
   36664, 15579, 12764, -3163, -3163, 41497, -3163, 34516, -3163, -3163,
   -3163,    78, 36664,  1510, -3163, -3163,  1693,  1229, 20477, -3163,
   41497, -3163, -3163, -3163, -3163, 18847, 18847, -3163, 18847, -3163,
   -3163,   117,   118,  1397,  1541, -3163, -3163, -3163, -3163,  1862,
   20477, -3163,   482, 20477,   138, -3163, 12764,  1515, -3163, 34516,
   34516, 20477, 20477,   127, -3163,   612, -3163,  1515,  1890, 18847,
   18847, 18847, -3163, -3163, -3163, -3163, -3163,   957, -3163, -3163,
   -3163,  1512, -3163, -3163, -3163, -3163, -3163, 39349,    81, -3163,
   -3163,  1515,  1909, -3163, -3163,  1520, 41497, -3163, -3163, -3163,
   -3163,    12, -3163, -3163, -3163, -3163,   384, -3163, -3163, -3163,
   -3163,  1647,   179, 41497, -3163, -3163,   179,   163, 20477,   179,
     179, -3163, -3163,   824, -3163,   -85, -3163, -3163, -3163, -3163,
   41497,   677,  1659,  1524, -3163, -3163, 20477, -3163,  1525, -3163,
    1924,  2049,  1291, -3163, -3163, -3163,   122,   122,  1515,  1644,
    1645,  1646,  1654,  1655,  1691, -3163, -3163,   366,  2045,   122,
     122,  2045,   122,   122,   122,  1627,  1994,   122,  1885,  1643,
     907,  1892,   122, -3163,  1648,  1996,   122,   122,   122,  2045,
    2077,   122,   122,   122,   122,   122,   148,   122,   122,   122,
   -3163,  1724, -3163, -3163,  1560, 19387, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, 39886, -3163, 12764,   198,  1515,  1515,
     368,  1515,   198,  1515,  1515,  1515,  1515,  1515,   198,  1515,
    1515,   198,  1919, -3163, -3163, -3163, -3163, -3163,   429, -3163,
   -3163,  1133, 41497, -3163,  1269, -3163, -3163, -3163, -3163, -3163,
   20477,  1607,  1541, 24792, -3163,   506, -3163,  1558, -3163,  1564,
    1571,   829, -3163,  2036,  1572, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,  1574,  1573,  1578,  1579,  2112,  1580,   588,  1581,
    1582,  1583,  1584,  1585,  -192,  1586, -3163,  1589,  1591,  1590,
   -3163,  1592,  1593,  1595,  1596,  1597,  1599,  1594,   844,   864,
    1600,  1601,   891, -3163,  1603,  1605,  1981,  1606,  1608,   900,
   -3163,  1604,  1609,  1611,   905,  1613,   912,   915, -3163, -3163,
   -3163, -3163,  1614,  1615, -3163, -3163,  -156,  1618,  1619,  1620,
   -3163,  1622,  1631,  1638,   917,  1623,  1641,   933,  1642,  1649,
    1651,  1598,  1653, -3163,  2036,  1658,  1660,  1665,  2036,  1667,
     952,  1668,  1670,   958,   960,  1671,  1673,  1674,  1675,  1677,
    1678,   970,  1679,   973,  1681,    16,  1682, -3163,  1683,  1684,
    1685,  1686,   982, -3163,  1688,  1690,  1692,  1696,  1697,    59,
    1698,  2036,  1700,  1702,   984,  1703,  1704,  1708, 11075, 11638,
   12201,    24,  1710,   328, -3163,  1713, -3163,  1715,  1716, -3163,
    1594,  1717,  1002,  1013,  1718, 12764,   699, -3163,   367, -3163,
   -3163, -3163,  1610,   644, -3163,  1742, 41497, -3163,   501,  1342,
   -3163, -3163, -3163, -3163, -3163,   626, -3163,  1632, -3163,  1711,
    8260,   751,  1656, 15579,    74,  1222,  1720, 15579, 15579, 15579,
     674,   640,   640,   212,  2232,   212,  2232,  1235,  1235,  1235,
    1235,  1235,  1984, 12764, -3163,  1984, -3163,  1721,   466, -3163,
   -3163, -3163, -3163,  1280,  1949, -3163,  1719, -3163, -3163,  1025,
   -3163,  1640, -3163,  1722,  1725,  1767,  1773, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1291,
     612,  1733,  1723, -3163, -3163,  1727,  2018, -3163, -3163, -3163,
   -3163, -3163, -3163,  1799, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,    98, -3163, -3163,  1726,  1726, 17222, -3163, -3163,
   -3163, -3163,  1945,  2117,  2119,  2120,   350, -3163,    42, -3163,
     586,  2070,  1291, -3163,  2123, 37201, 25331, -3163,  1729,  2071,
    1730,   122, 32905,    84, 23174, 33442, -3163, -3163,   368, -3163,
     164, -3163, -3163, -3163, -3163,    -5,    -5,  1764, -3163, -3163,
   -3163,  1541,   163, -3163, -3163, -3163,  1738, -3163, -3163,   506,
    2072,  2073, -3163,  1953,   103,  1953,   506,   506, 21557,   506,
    1567, -3163,   198,  2008, -3163, -3163, -3163, -3163, -3163, -3163,
   35590, 33979, -3163, -3163, -3163,  2214, -3163,  2215,   187, -3163,
   22097,   948,   948, -3163,   119,   170, 22097, -3163, -3163, 22097,
     368,   198, 22097,   198,  1515,  1515,  1429,   122,   198, -3163,
   -3163,  2078,  2079, 22097, 22097, -3163, 36664, -3163,   122,   652,
     368,   368, 22097, 21557,   560,  1515,   198,   198,   654, -3163,
   -3163, -3163, 20477,  1351, 36664,  1749, -3163,  5211, 16682, 41497,
     260,   317, -3163,  1745,  1753, -3163,  1034, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
    1838, -3163,  1755, -3163, -3163,    96, -3163,  1753, 20477, 16142,
   -3163,   128, -3163,   876, -3163,   506,  1971,   115,  1541,  1763,
     141, 13890, -3163, -3163, 12764,  1757, -3163, 12764, 12764, -3163,
   -3163, -3163,   234, -3163, 36127, -3163, -3163, -3163, -3163, -3163,
   12764, 36127,   234, 12764, -3163, -3163,  1758, -3163,  2099,  2099,
   -3163, -3163,  1375, -3163, 41497, -3163, 12764, -3163, 12764, -3163,
    1375, -3163, 12764, -3163, 12764, 12764, -3163,  1990, -3163, 12764,
   -3163, 12764, 12764, -3163, 12764, -3163, -3163, 12764, -3163, 12764,
   12764, -3163, -3163,  1991, -3163, 12764, 12764, -3163, -3163, 12764,
   -3163, 12764, -3163, 12764, -3163, 12764, -3163, 12764, -3163, 15579,
   21557,  1762, -3163, -3163, -3163,  1765, -3163, -3163, 12764, 12764,
   -3163, -3163, 12764, -3163, 12764, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, 12764, 12764, -3163, 12764, -3163, 12764, -3163, -3163,
   12764, 12764, 12764, -3163, 12764, -3163, -3163, -3163, -3163, 14453,
   12764, 12764, 12764,  1766, -3163, -3163, -3163, 12764, 12764, 12764,
   -3163, 12764,  2153, 12764,  2154, 12764,  2157, 12764, -3163, 12764,
    1998, -3163, -3163, -3163, -3163, -3163, 12764, -3163, 12764, -3163,
    1788, 12764, 12764,  2198, -3163, -3163,  1776,  1777, -3163,  1772,
    1774,  1775, 36664, 12764, -3163, -3163, -3163, 12764, -3163, -3163,
   12764, -3163, -3163, -3163, -3163,   367,  1037,  1784, 15579, -3163,
    1656, 15579,  8260,   751,  1656,    75, -3163, -3163, -3163,  1785,
   -3163, -3163,  1786, 41497, -3163, -3163, -3163, 41497,  1794, 25870,
   34516, 34516, 34516,  1789, 12764, -3163, -3163,  2013, -3163, -3163,
   20477,  2141, -3163, -3163, 34516, -3163,   331, 21557, -3163,  1790,
   -3163,  1790,   679,  1792,  1049, -3163, -3163, -3163,  1791,   989,
    2184, 34516, 34516, 34516, -3163,  1541,  1541,   662,  1845,  2134,
   -3163, -3163, -3163, -3163, 40423, -3163, -3163, -3163, -3163,   548,
   41497,  2116, 41497,  7697, -3163, -3163, -3163,  2299, 12764, -3163,
   34516,    18,   644,   122, -3163, -3163, -3163, -3163, -3163, -3163,
    1291, -3163, -3163, -3163, -3163,  2094, -3163,   179,   824,   283,
   -3163,  1099, -3163, -3163, -3163,  2135,   506,  1953,  1953,  2136,
    2027,   -70,  1805, -3163,   122,   677,    28, -3163,   331, -3163,
   -3163, 12764, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, 12764,  2137,  2142,   948, -3163,
   22097, -3163, -3163,   656,   107, -3163, -3163, -3163, -3163, -3163,
   -3163, 33979,  1515, -3163, 22097, -3163, -3163,   169, -3163,  1515,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1806, -3163,   371,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, 20477, -3163,
    1052, -3163, -3163, -3163, -3163, 41497, -3163, -3163, 20477, -3163,
   -3163,  4829, 41497, 41497,  2355, -3163, 41497, -3163, -3163, -3163,
   -3163, -3163,  2038,  -115,  2360, -3163, 20477, -3163,  1818,  1056,
   -3163, -3163, -3163,  2362,  1714, -3163,  1822,  1541,  2138, -3163,
   -3163, 12764,  1823,  1825, -3163, -3163,  1826,  1828,  1828, -3163,
   -3163,  1829,  1828,  2160, -3163,  2167,  1831,  1833,  1836,  1839,
    1842,  1843,  1837, -3163, -3163,  2232,  2232,  1849,  1844,  1851,
    1852,  1853,  1854,  1855,  1858,  1856,  1860,  1863,  1864,  1865,
    1861,  1867,  1872,  1882,  1894,  1895,  1971,  1869,  1887,  1896,
    1898,  1899,  1901,  1064,  1902,  1903,  1076,   253, -3163, -3163,
   -3163,  1904,  1905,  1906,  1907,  1908,  1911,  1912,  1913,  1916,
    1917,  1921,  1923,  1925, 12764,  1926,    39,  1093,  1918, -3163,
    1927,  1928,  1930,  1934, 12764,  1936, 12764,  1939, 12764,  1940,
    1941,  1942,  1944,  1946, 12764,  1848, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163,  1875, -3163,  1181, -3163,  1948, -3163,
   -3163, -3163,   333, -3163,  1095,  1954, -3163, 15579, -3163, 12764,
    1952, -3163,  1955, -3163, -3163, -3163, -3163, -3163,  -136,  -136,
    -136, 15016, -3163,  2267, -3163,    45, -3163,  2197, -3163, -3163,
     949,  1957, -3163,   122, 15016,  1726,  2019, -3163, -3163,   679,
   21557, 25331, -3163, 34516,  1114,  1114,  1114,  1291,  2249,  1733,
    1733, -3163, 23711, -3163, -3163,  2016, -3163, -3163, 26409, -3163,
     444, -3163, -3163, 15579,  1266, -3163, -3163, -3163, 35590, -3163,
   -3163,   122,  1897,  1910, -3163, -3163, 40960, 12764, -3163,  2303,
   -3163, -3163,  1963,   506,  2093,   506, -3163,  2216,  2217,   506,
   -3163, -3163, -3163, 21557,  1541, 15016,   948,   948,   948, -3163,
     949, -3163,  1964,   371, -3163, 22097, -3163, -3163,   656,  1929,
    2342,  2343, 22097,  2299, -3163, -3163, -3163, -3163,  4829, 21557,
   -3163, -3163, -3163,  1097, -3163, 16682, -3163, -3163, -3163,  1943,
    1950,  1828, -3163, -3163, -3163, -3163, -3163,  1829,  2091, -3163,
    1829,  1829, -3163, -3163, -3163, -3163, -3163,   158,   208, -3163,
   -3163,   158, -3163, -3163, -3163,   102,   718,  1829, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,  1828,  1828, -3163, -3163, -3163,
     158,  1965, -3163,  1828,   870, -3163,   160,    79,  1968,  1972,
    1828,  1973,  1967, -3163,  1104, -3163, -3163,   658, -3163,   629,
   -3163, -3163, -3163,  1974, -3163,  1724, -3163,   391, -3163, 41497,
   -3163,    -5, -3163,  2232, -3163, -3163, -3163,  2122, -3163,   158,
    2147, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, 12764,  1975,  1976,  1977, -3163, -3163, -3163, -3163,
   -3163, -3163, 12764, -3163, -3163, -3163, -3163, -3163, 12764, -3163,
   -3163, -3163, -3163, -3163,  2084, -3163,  2209, 12764, 12764, -3163,
   -3163, -3163, -3163, 12764, -3163, -3163, -3163, 12764,  2501,  2171,
    1982, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   12764, -3163, -3163, -3163,  2232, -3163, 12764, -3163, -3163, 12764,
   12764, -3163, 12764, 12764, -3163,  1983, -3163,  1985, -3163,  1986,
   -3163, -3163,  2218, -3163, -3163, -3163, 12764,   989, 41497, -3163,
   -3163,  1987, -3163, -3163, -3163, -3163, -3163, -3163, -3163,    93,
    2017,  2017,  2017,  1266, -3163,  1124, -3163, -3163,  2323, -3163,
    1435, 21557, 15016,  1992,  1989, -3163,   -13, -3163, -3163,  1988,
    1114, -3163,  2510,  2361, -3163, -3163, 36664,  1995, -3163, -3163,
    2256, -3163,   106,  2180, -3163, -3163, -3163,    18,  2085,  2086,
     122, -3163,  1515,  2748,  1524,  2334,   761,  2048,   506,   506,
     979,  2050, 12764, 12764,  2006, -3163,  1971, -3163,  2400, -3163,
   -3163, -3163,  1435, 12764, -3163,  2009,  2011, 41497, -3163,  1009,
     260, -3163,   870, -3163, -3163, -3163,   -38,  2239,  2242, -3163,
    -161, -3163,  2014,  -161,  -161,  2543,   133, -3163,  2543, 36127,
   -3163,  1101, -3163,  2051,   158, -3163, -3163,  2054, -3163, -3163,
   -3163,  -161,  2028,   158, -3163, -3163,  2246,  -161, -3163, 36664,
    1515,   247, -3163,  2067, -3163,  2479,  2357, -3163,   870, -3163,
    2359,  2263, -3163,  2266, -3163, -3163,  2268, -3163,  2269,  2273,
    -161,  2274, -3163,  -161, 41497, -3163, 41497,  2059,   412, -3163,
   -3163, -3163,  2037,  2044, -3163, -3163, 20477, -3163, -3163, -3163,
   -3163,  2111, 41497,  2059, -3163,   -13,   128,  2019, -3163,  1126,
     371,  2052, -3163,  2047,  2053, -3163,  1128,  2060, -3163, -3163,
   -3163,  1132,  2062,   162,  2063,  2058,  2064,  2065,  2068,  2069,
    2306,  2459, -3163,  2074,  2076,  2080,  2081,  2082,  2083,  2090,
   -3163, -3163, -3163,  2066, -3163, -3163, -3163, -3163,  2092, 37201,
   -3163,  2139,  2150, -3163, -3163,  2155, -3163, -3163,   149,   928,
   -3163, -3163, -3163, -3163, 15016,  2381, -3163,   774, -3163, -3163,
   -3163, -3163, 12764, -3163,  1971,  2567, -3163, 23711, -3163, -3163,
   -3163, -3163, -3163,  2095,  2096,  7697,  2617, -3163,   506, -3163,
    2121, -3163, -3163, -3163,  2128, -3163, -3163, 41497,  2138,  2404,
   -3163,   774,   371, 41497, 41497,  1144,   -20,   -20,   -20,   598,
     598, -3163, -3163, -3163, -3163,   650,   134, 41497, -3163, -3163,
      26, -3163,  2100,  2103, -3163, -3163, -3163, -3163,  -161, -3163,
     162, -3163, -3163, -3163, -3163, -3163, 36127, -3163, -3163,  2543,
   -3163, -3163, -3163,   162, -3163,  2104, -3163, -3163, -3163,  1108,
   -3163, -3163,  2312,  2124, -3163, -3163, -3163, -3163,  2105,  2106,
    2108,  2109, -3163,  2098, -3163, -3163, -3163,   904, -3163, -3163,
   -3163, -3163, -3163,   836, 41497,  2478,  1515,  2110,  2113, -3163,
   -3163, -3163, -3163, -3163,  2115,   989, -3163, 41497, -3163,  2321,
   -3163, -3163, -3163,  2341, -3163, -3163, 12764, -3163, -3163, -3163,
    2036, -3163, 12764, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,   229,  2331,   198,   198,   198,   198,   928, -3163,
   -3163,  2143,  2202, -3163,   586, -3163,   487,   371, 12764,  1291,
     966,  2431, -3163, -3163, -3163, -3163,  2412,  1090, 12764,  2125,
   12764,  2127,  1146, -3163, -3163, -3163,  2130, -3163, -3163,  1149,
    1151, -3163, -3163, -3163,   260, -3163, -3163, -3163,   502,   502,
    1155, -3163, -3163, -3163, -3163, -3163,  1161, -3163, -3163, -3163,
    1163, -3163, -3163,  1108, -3163,   158,  2543,   158,  2543,  2626,
    2346,  2627, -3163,  -146, -3163, -3163,  4829, -3163, -3163, -3163,
   41497,  4829, -3163, -3163,   371,  2133,  2140,  1165,  2144,  2146,
    2149, -3163, -3163, -3163, -3163, -3163, -3163, -3163, 21557, 20477,
   -3163,   298, 12764, -3163, -3163, -3163,  2325,  2651,  2652,  2563,
    2655,   966, -3163,  -134, -3163,  2558, -3163, -3163, 41497, -3163,
   41497, -3163, 41497, 39886,  2318, -3163, -3163, -3163,  2698, -3163,
     135, -3163, -3163,    26, 41497,   158,   162,   158, -3163, -3163,
   -3163, -3163, -3163,  2366, -3163,  2369, -3163,  2151,  1370, -3163,
    2573,  2310, -3163, -3163,   -13, -3163, -3163, -3163, -3163, 12764,
   -3163, -3163, -3163,  2156, -3163,   122, -3163, -3163, -3163,   371,
   41497, -3163,   162,   162,  2671,   162, -3163,  2672,  2673,  -134,
   -3163,   368, 12764,  1167,  1179, -3163,  2158,  2159, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,   -13,
   -3163, -3163, -3163,  2604, 31284,  2311, -3163, -3163,  2163, 21557,
   15016,  1429, -3163, -3163, -3163, -3163,   162, -3163,   162,   162,
   -3163,  2710,  2162, -3163, -3163, -3163, -3163, -3163, 41497,   621,
   -3163, 42571, 42571, 41497, -3163,  2200, -3163,  4080,   153, -3163,
   -3163, -3163, -3163, -3163,  2164, -3163, -3163,  4829, -3163, -3163,
   -3163, 33979, -3163,  2169, -3163, -3163, -3163,  2460, -3163, -3163,
   -3163,  2564, 41497, -3163, -3163, -3163, -3163, 12764, 12764,  2204,
   -3163, -3163, 31284, 31284, -3163, -3163, -3163, 31284, -3163, -3163,
    2567,  2177,  2597, -3163,  2518,  2603, 12764, -3163, -3163, -3163,
     708, -3163, -3163, 28574,  2175, 31826, 12764,   153, -3163, -3163,
    2431, 12764,  2183,  2187, -3163,   198, -3163,  2541,  2206,  2222,
   12764, 31284, -3163,  2618,  2649,  2494,  2191, -3163,  2193,  2639,
   42571,  1370,  2555, -3163, -3163, -3163, -3163, 41497, -3163, -3163,
   -3163,   805, -3163, -3163, 29116,  2219, 37738, 29658,  2203, -3163,
   -3163, 12764, -3163, -3163, -3163, 31284,  2437,  2210, -3163,  2221,
   -3163, 31284, 12764, -3163,  2634,  2229, -3163, -3163, -3163,  2582,
    2223,  1160, -3163,  2211, -3163,  2640, 31284, -3163,  2531, 17762,
    2358, 41497, 26948, -3163,  2233, 31284,  2619, 41497,  4829,  2620,
    2622, -3163,  2392, 30200, -3163, -3163, 36664,  1183, -3163, -3163,
   21557, -3163, -3163,    40,  2247, -3163, 27490, -3163, -3163,  2685,
     594, -3163, -3163,  2262, -3163, -3163, 19932,  2156, -3163, 31284,
   -3163, 31284, 32368, 12764, -3163,  2275, -3163, -3163, -3163,  4080,
   -3163, -3163, -3163, 30742, 28032, -3163, -3163, 24248, -3163, -3163,
   -3163,  2630, -3163, -3163, -3163,  1375, -3163, 32368, -3163, -3163,
   -3163, -3163
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3163, -3163, -3163, -3162, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,  1007, -3163, -3163, -3163, -3163, -3163,  1239, -1390,
   -3163, -3163, -3163, -3163, -3163,   348,     9, -3163, -3163, -3163,
   -3163, -3163, -3163,  2129,  -727, -3129, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,  -386,  -505, -3163, -3163,  -377,
   -3163, -3163, -1999, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163,  -859,  -819, -3163, -3163, -3163, -3163, -1771, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,  -826, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  -747, -3163,
   -3163,  -705, -3163, -3163,  -745, -3163, -3163, -3163,  -710, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  -198, -3163,
   -3163, -1797, -3163, -3163, -3163,  1694, -3163,  1751, -3163,  2428,
   -3163,  -400,    77,  1293, -1826, -1003,  -501,  -499,  -939, -3163,
   -3163, -3163,  -288, -3163, -3163,   806,   151,  1295,  1334,   846,
     894, -3163, -3163,   167, -3163, -2590, -3163, -3163, -3163,   139,
   -3163,   142, -3163, -3163, -3163, -1369,   101, -1320, -3163,  -304,
   -1190, -3163,   -97, -3163,  -142, -3163,  -435, -1992, -1892, -3163,
   -3163, -3163,  -131,   176,   224, -3163, -2604, -2068, -3163, -3163,
    -511, -3163, -3163, -3163,  -519, -3163,  -285,  -433, -3163, -3163,
   -1457, -1707, -3163, -3163, -2134,  1712, -2179,  -349, -1837, -3163,
    -303, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
     872, -3163, -3163, -3163,  -200,  -273, -1307, -2698, -3163, -3163,
   -3163, -3163, -3163, -3163,   925, -3163, -3163,  1389,  1807, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
    1014, -3163, -3163, -3163, -3163, -3163,  -858,  1732, -3163, -3163,
   -3163,  1321, -3163, -3163, -3163, -3163,  1456, -3163, -3163,  2176,
   -3163, -3163, -3163, -3163,   618,  1036, -3163, -3163, -3163,  2194,
    1006,  -456, -1710, -3163,  2407, -3163, -3163, -3163, -1250, -1942,
   -3163,  2265,  -378, -1668,  1451,  -704,    13, -3163,  -191,  -730,
    3566, -3163, -3163, -1227, -3163, -3163,  -782, -3163, -3163, -1262,
   -1173,  1557,  1556,   344,   437,   309, -3163, -3163,  -484, -3163,
   -3163, -3163, -1230,  -715, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163,    15, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -1120, -3163,   821, -3163, -1086, -3163, -3163, -3163,
    1657, -3163, -3163, -3163, -3163, -3163, -1866, -1410,   241, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -1841, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -1278, -3163, -1735, -3163,
   -3163,  -886, -3163, -3163,  -477, -1961, -1175,   512, -3163, -3163,
    -950,  1728, -1514, -3163, -3163, -3163,   664, -3163, -3163, -3163,
   -3163, -3163,   213, -1975, -1031, -3163, -3163, -2577,  -608, -1791,
    -600, -3163, -1804,  -227, -1128, -1832, -3163, -3163, -3163, -3163,
    -672, -3163, -3163, -3163,  -203,  1024, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163,  -420,  -340,   914, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163,  1937,  1915,  1068, -3163, -3163,
   -2041, -3163, -3163,  1045, -3163,    21, -1786,  -243,   304, -3163,
   -3163,   311, -2562, -3163, -3163, -3163, -3163, -3163, -3163,   250,
    -723,  -541,  2453, -3163, -3163, -3163, -3163, -3163, -3163,  2181,
    1759, -1408,  2397, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163,  2465, -3163,  -896, -3163,  -418, -3163, -3163,  -588,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,  1536,
   -3163, -3163, -3163, -3163, -3163,  1931, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163,   330,  -604, -3163,  -434,  -621, -3163,  -498,
   -3163, -3163, -3163,  -726, -3163,  -746,  -657, -1001,   -57, -2602,
   -1336,   323,  1933, -2669, -1115, -1255, -1259, -1753,    22, -3163,
      -7,  -509,  -393,  -814,  2010, -2406,  -373,  -491, -3163,  -844,
   -3163, -3163, -3163, -3163,  1502, -3163, -3163, -3163, -3163,   623,
   -3163, -3163, -3163,   291, -3163,    25,  -176, -3163, -3163,   320,
   -3163,  1528, -3163, -3163, -3163, -3163, -3163, -3163, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163,  1947,  2496,  2345, -3163,
    1993, -3163, -3163, -3163, -3163, -3163,  -306, -3163,  -173, -3163,
   -1405,  1797,   438, -3163,   704,  -768, -1056, -3163,  -308, -3163,
   -3163,   796,  2502,  2347, -3163, -3163, -3163, -3163, -3163, -2192,
    -579, -3163, -2260, -3163, -3163, -3163, -3163, -1126, -3163, -3163,
    1652,  -122, -3163, -3163,  -112, -3163, -3163,   -66, -3163,  2463,
    2224, -3163,   920, -3163,   196, -3163, -3163,   -69, -3163, -3163,
   -3163, -3163, -3163, -3163, -3163, -3163, -3163,   992, -3163, -3163,
   -3163, -3163, -3163, -3163
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1981
static const short int yytable[] =
{
     374,   664,   635,   699,  1133,  1134,  1135,  1178,  1392,   986,
    1447,  1064,   374,  1013,  1636,   374,  1154,  1169,  1170,  1172,
    1729,   905,   374,  1008,  1728,  1602,  1028,  2184,  2235,  2336,
    1482,  1234,   374,  2311,  1013,  1603,  1604,  1605,  1750,   551,
    1937,  2321,   374,  2325,   409,  1758,  2299,  1029,  1617,  2632,
    2253,  2438,  2457,  1953,  1791,   964,   657,   657,   657,  2460,
     657,  1634,   657,   690,   691,  2320,  1626,  2592,  2026,  1747,
    1695,  2272,  1531,  1895,  1608,  1609,  2924,  1611,  2932,   967,
     374,  2303,  2304,  2917,  1236,  2283,  2288,  2291,  1774,  1776,
    2211,  2557, -1119,   907,  2955,  1262,   718,  2956,  1266,  2353,
     374,   374,  1675,   374,   649,  1679,  1673,   943,  2355,   464,
    1260,  2985,  1645, -1493,   374,  -259,  2965,   469, -1494,   470,
   -1829, -1830,  2984,  1275,  1276,  1277,  1358,  1665,  2374,  2375,
    1456,  -249,  -260,  1706,  1707,   605,   606,  1762,  1712,  1764,
     707,  1459,  1460,   479,   938,  1685,  1686,  1687,  1286,  1287,
    1288,  3061, -1893,  3144,   943,  3025,  1694,  2957,  1727,   943,
    1731,   485,   978,  1112,  1396,  3231,  1969,  1861,  1326,  2265,
    2319,  1070,  3638,  1071,  3089,  2028,  2345,  2342,  2945,  2030,
    2945,  3501,  1407,  2342,   935,  1076,  2354,   605,   606,  2357,
    2946,  1115,  2946,  2646,  1014,  2167,   653,  2435,  1588,  1911,
    2366,  2367,  1269,  2947,   106,  2947,   682,  2826,  2419,  2376,
    1086,  2587,   605,   606,   605,   606,   106,  1358,  1032,  2659,
    1066,  1541,  2428, -1493,  2343,  2344,  1917,  2345,  2945,  1087,
    2150,   944,  3123,  2660, -1951,   973,   565,  1066,  2647,  1010,
    2946,  2137,   556,  3420,  1024,  3125,  3278,  1904,  1423,  3431,
     552,  1837,  2290,  2947,  3112,  2430,  1442,  1054,   669,  1079,
     811,  2859,   605,  2951,  1917,   692,  2447,  2641,  2405,  1882,
    1413,  1003,  3134,  1022,   456,   657,   951,   492,   944,  1592,
    1837,   732,   949,   944,   107,  2346,   548,  3061,  2739,  2448,
    1970,  1116,   415,  1538,  1117,   573,  2339,   694,   811,  3126,
    1011, -1367,  1596,  1042,  2580,  3500,  1118,   121,  2301,  3125,
    3079,  1592, -1119,  1424,   472,  2420,   378,   114,  1575,  3407,
     655,  3062,   381,   495,   119,  2051,  1443,  3122,  2449,   379,
     380,  2450, -1951,  2316,  1030,  1320,  -340,  1026,  2430,  2451,
     553,  3408,  1648,   589,  3116,  1649,  2317,   418,  3135,   819,
    3150,   755,   424,   499,  2622,  1004,   428, -1493,   695,  3154,
    1597,   654, -1494,  3126, -1829, -1830,  1043,  1270,   108,  3122,
    2052,  2623,   422,   952,  2345,  1027,   962,  2306,  1035,  1048,
    1414,   716,  1113,  3136,  3397,   429,  2650,   544,  1031,  1593,
    2670,   374,  1478,  1314,   115,  1872,  1350,  1598,  1481,  1425,
   -1119,   374,   766,   109,   554,   374,  2093,   500,  1539,   768,
     374,  2340,   416,  3247,   457,   374,  3502,  3063,   655,  1989,
    2406,  1616,  3431,  -339,  1999,   998,  1132,  1449,   717,  1055,
    2005,  1119,  1929,  2008,  1873,  1455,   474,   374,   670,   561,
    2431, -1367,  1176,  3198,  1930,  2740,   783,  2642,  2266,   574,
     546,  1461,  1462,   590,   374, -1493,   655,  3062,  1656,  1599,
   -1494,  1483,  1468,   671,   374,  3421,   953,  1883,   374,  2663,
    1838,  1576,  1992,  2035,   374,  2636,   374,   374,  2808,  1359,
    1176,   374,   374,  2347,  2671,   566,  1426,  3666,  1361,  1433,
     984,   374,  1444,   675,  2624,   374,   708,  1353,  1025,  1838,
     374,   374,  1177,   374,   374,   374,   374,  2627,   795,  2318,
    1120,  1918,  3240,  2658,  2439,   501, -1119,   901,  1321,   903,
     904,  1937,  3127,  2431,  2926,  1450,  1723,  2665,  1531,  1600,
    1993,   591,  -339,  2661,  -340,  3268,  1830,   557,  2645,   374,
    1931,  1394,   693,   683,  2648,  3064,  1005,  3503,  2877,  1918,
    3357,  1403,   490,  2452,  2111,   374,  3065,  -503,  2115,   110,
     936,  1891,  1937,   374,   374,   811,  1313,  1070,   374,  1071,
    1359,  1542,  1081,  1081,  3159,   374,  3356,   815,   816,  1086,
     677,   939,  2637,  2638,   958,  2168,  3639,  1015,  1729,  1395,
    2210,  2153,  2257,   970,  1761,  2214,  2215,  2342,  1087,  2216,
    2827,  2217,  1469,  1436,  3090,   374,  1470,  2421,  2748,   973,
    1782,  2342,  2186,  1839,  2273,  2437,  3081,  1458,   709,  2030,
    2310,  2151,  1397,  2348,  1313,  1313,  1070,  2958,  1071,  1994,
     586,  3066,   973,  1971,  2207,  3145,  1785,  1487,   655,  2986,
    1081,  2657,  1839, -1493,  1271,  3279,  1331,  1874, -1494,  1729,
   -1829, -1830,  1006,  2324,  2187,  3055,   657, -1119, -1119, -1980,
    2948,   374,  2948,  3399,  1596,  -569,  1023,  2453,  2380,   374,
    3334,   417,   374, -1119,  -340,   374,   374,  1583, -1493,  1351,
    -259,  1036,  2029, -1494, -1893, -1829, -1830,  3504,  2982,  1081,
    1577,  3369,  3065,  3371,  2302,  1601,  -249,  -260,  1596,  1995,
    1081,  2408,   755, -1119,  1729,   479,  3398,   545,  2379,  1007,
    2948,   374,   999,   374,  1332,  2454,  3379, -1893,  1885,   435,
    2983,  3383,  1597,   655,   514,  3117,  1650,   577,  3118,  1651,
    -339,   448,  2952,  2722,  3007,   442,   489,  3385,   846,   563,
    1138,  1543,  1143,  2455,   848,   572,  1825,   849,  3115,  1336,
     512,  2597,  2598,  1766,  2268,  3192,  1597,  1567,  1596,  1598,
     768,  3424,  1900,  3426,   383,   651,  1322,  1323,  1324,  2906,
      40,   570,   449,  2910,  1767,   592,   593,   594,   595,   596,
     597,  2201,  2010,  1037,  2329,  1353,   984,  1289,  2809,  2253,
    2599,   598,  3490,  1598,  2907,  1375,  1751,  2872,  2911,  3119,
    3120,  1592,  1038,  1313,   655,  1932,  2881,  1592,  1039,  1592,
    1409,  1843,  2370,  2356,  1350,  2358,  1597,   578,  2925,  1755,
    2363,  1599,  3442,  3275,  2892,  2568,  2569,  2570,  2465,  2466,
    3358,  2189,  3179,   443,   430,  2897,  2381,  2893,  2383,  2384,
    2388,   450,  2269,  1340, -1948,  2195,  1900,   384,  2196,   459,
     438,  1341,  3008,  1598,   439,  1599,  2594,  2595,  2596,   795,
     460,   374,  1826,   374,  1888,  1996,  1790,  2894,  1890,  1353,
    -339,  1893,  1894,  1353,  1916,  2999,   811,  3143,  3480,  1040,
    3148,   579,  1013,  3000,  1447,  1447,  -508,  3508,  1832,  2371,
    2170,  1600,  1901,  2968,  1488,   374,  2190,  2208,  1851,  1499,
    1500,   374,  2342,  3359,  1080,  2011,  1489,  1902,  1833,  1834,
      51,  1674,  2870,  1768,  1342,  1599,   476,  1678,  2631,  1711,
    1903,  1745,  1877,  2750,  1356,  1600,  1468,  1633,  3360,   816,
    -460,  -460,  1502,  2969,  3269,  3270,  2497,  2970,   374,  -460,
     374,  3108,   374,  1503,  3491,  1858,  1886,  3022,  1796,  2553,
    3018,  3017,  1504,  3299,   374,   374,  2202,  3149,   697,   698,
    2326,  3300,  1344,  2458,   374,   374,   697,   698,  2463,  1506,
    2546,  1752,  3180,  1929,  1531,   374,  1901,  1784,  2971,  1922,
    2372,  1081,  2922,  2471,  1066,  1600,  1376,  1507,  1729,  1792,
    2476,  1902,  2583,  1875,  1904,  2498,  2307,   374,   374,   374,
     374,  1410,  3276,  3313,  1903,  2485,  2486,   374,  3001,   374,
    3009,  2600,  2490,  1437,  1438,   374,  1512,  2368,  3629,  1827,
    2495,  1011,  3331,  1448,   440,   374,  2222,  2385,  1439,  1440,
    2386,  1454,  1843,  2223,   655,  2397,  3645,   396,  1844,  1990,
    1991,   811,  1998,   732,  2000,  2001,  2002,  2003,  2004,  3332,
    2006,  2007,  2213,  2999,  1457,  3494,  3495,  1601,  1176,  2513,
    2666,  3000,  1490,  1115,  1900,   451,  1469,  3101,  3102,  2191,
    1470,   374,   461,  1951,   374,  1345,   441,  1769,  1904,  2548,
    2440,  3289,   466,  1905,  3277,   452,  2555,  1347,   471,  1515,
    3010,  1601,  1377,  1096,  1097,   848,  1516,  1351,  3099,  1843,
    1540,  3337,  -474,  1316,  1317,  2044,  3116,  1377,  2222,  3249,
     453,  3338,   385,   755,  3095,  2608,  3233,  2203,  1261,   481,
    1086,   397,   927,   374,  3437,   374,   374,   374,  1858,   374,
    2916,  1491,  1753,  2204,  1845,  1846,  2563,  1906,   374,  1087,
     374,  2013,  1570,  1571,  3574,  -265,   386,  1308,  1754,  2045,
    1139,  1601,   517,   518,  3288,  1492,  3301,   454,  1573,   398,
    2014,  1086,  1517,  1116,   766,   482,  1117,  1905,  1309,  3456,
     472,   768,  1847,  1140,   374,  1900,  1518,   387,  1118,  1859,
    1087,   117,   485,   118,  1900,   928,  3001,   388,  2880,  2918,
    2918,  2918,  1318,  1319,  1901,   697,   698,  1739,  1740,   655,
    2972,  1845,  1846,  1805,   487,  1806,  1493,  2973,   783,  1902,
    1107,  1108,  3234,  3235,   374,   496,  3236,  3237,  1937,  -137,
    3194,  1906,  1903,  1176,   519,   423,   929,  1521,  3370,  1522,
    3372,  2181,  3257,   386,  2974,  3609,  1853,  1854,  1855,  2586,
    3519,   930,   498,  2959,  1921,  2182,  2960,   697,   698,  3610,
    1523,  1524,   520,  1525,  3541,   506,  1940,  1941,  2759,  1943,
    1944,  1945,  2763,  1353,  1948,   560,   521,   605,   606,  1956,
     795,  1952,   374,  1959,  1960,  1961,  1486,  1494,  1964,  1965,
    1966,  1967,  1968,  1265,  1973,  1974,  1975,   374,   522,  1527,
    2774,  2775,  1499,  1500,  2975,  2855,  1904,   646,  1939,   523,
     564,  1942,  1481,  1119,   117,  1901,   118,  1310,   -55,  3339,
    1954,   508,   399,   510,  1901,   511,  3103,   513,  2940,  1962,
    1902,  2943,  2944,  -460,  -460,  1502,   543,   811,   524,  1902,
    1353,  1729,  -460,  1903,   574,  2257,  1503,  3560,  2961,   815,
     816,   406,  2634,   374,   665,  1504,   911,   546,   374,   419,
     374,  3541,   676,   525,   425,   374,  2276,  2198,  2199,   526,
    1311,   374,  1506,   374,   644,   645,   677,   648,   374,   374,
    1528,   374,  1372,   686,  2976,  1373,   706,  1066,  1374,  1529,
    1507,   899,  1120,   374,  1729,  1905,   374,  3413,  2324,  3414,
    2033,  2034,   374,   374,   374,   374,   527,  1802,  1802,   106,
    1802,   909,   374,   374,   374,  2065,  2066,  1904,   902,  1512,
    1729,   926,  1824,   924,  2379,   958,  1904,   931,  2547,   400,
     374,  2390,  2391,   970,  1836,  2067,  2068,  3346,   908,   374,
     912,  1802,  1802,  1802,   401,  2359,  2360,  1488,  2434,  1906,
     941,  3340,   659,   660,   933,   661,   374,   662,   942,  1489,
     109,   374,  2071,  2072,   956,  2795,  2382,   957,  3336,  2392,
     402,  2078,  2079,   374,  2851,   965,  2083,  2084,   976,   374,
     977,  1312,  1313,  2086,  2087,   403,  2088,  2089,  2100,  2101,
    1892,  2393,  1515,   605,   606,   655,   913,  3117,  3430,  1516,
    3118,  2939,   984,  2552,  2104,  2105,  1905,   981,  1910,  2289,
     846,  2293,  2298,   987,  3525,  1905,   848,   528,   980,   849,
     914,  2361,  2394,  2117,  2118,  2018,   995,  2559,   996,  2121,
    2122,  2123,  2124,  1001,   529,  2963,  2964,   997,   374,  1002,
     530,  2131,  2132,  2967,  2134,  2135,   531,   374,  1011,  1807,
    2990,  1016,  3564,  2143,  2144,  2156,  2157,  2335,  2289,  1017,
    1906,  1018,  1299,  1300,  1020,  1517,  1021,  1808,  1033,  1906,
     532,  3119,  3120,  2175,  2176,   374,  1019,   583,   518,  1518,
   -1119,   533,   534,   374,  2177,  2178,   374,  1809,  3023,  3451,
    1034,  2016,  3602,  1010,  1047,   943,  2226,  2227,  1049,  3509,
    1301,  1810,  3376,  1050,   915,  2415,  2416,  3613,  2549,  2550,
     916,  1010,  2024,  1052,  1302,  1490,  3626,   535,  1057,  3440,
    2589,  2590,  1729,  2674,  2675,  1077,  2583,  2745,  2675,  1124,
    1521,  1078,  1522,  3141,  3142,  2802,  2803,  1125,   917,  1777,
    1778,  1779,  1780,  1781,  1811,  1812,  1303,  2806,  2807,   519,
    3653,  3152,  3654,  1523,  1524,  1126,  1525,  3156,  1304,  3044,
    1130,   536, -1119,   537,  2828,  2829,  2852,  2853,  2934,  1081,
    1771,  1772,  1813,  3466,   918,  2995,  2996,   520,  1128,  2467,
    3172,  2289,  1131,  3174,  1491,  1305,  1132,  2472,  2289,  1136,
     986,   521,  1527,  1145,   919,  3073,  3074,  3196,  3197,  3202,
    3203,  1149,  2628,  3205,  3206,   697,   698,  1147,  1492,   920,
    1013,   118,  1150,   522,  2362,  3271,  3197,  3351,  3352,   944,
    3354,  3197,  3355,  3197,   523,  2369,  3363,  3364,  1151,  2630,
    1814,  1296,  3365,  3366,  3367,  3366,  3388,  3389,  3453,  3352,
    1152,  1306, -1119,  1153,  2395, -1119,  3528,  1499,  1500,   374,
    3454,  3352,  1155,   524,  3635,  3636,  1156,  1499,  1500,  1493,
    1447,  1157,  3546,  2579,  3546,  1773,  1775,  1158, -1119,  1159,
    1815,  2920,  2921,  1528, -1119,  2606,  1160,  3058,   525,  1161,
    1502,  1162,  1529,  1315,   526,  1715,  1716, -1119,  -460,  -460,
    1502,  1503, -1119,  3272,  3273,  2884,  2885,  -460,  1163, -1119,
    1504,  1503,  1325,  3546,  1164,   518,  3593, -1119,  1352,  2621,
    1504,  2861,  2862,  1165,  3597,  3071,  3072,  1506,  1166,  1167,
   -1119,   527,  1168,  1171, -1119,  1173,  1174,  1506,  1175,  2544,
    1494,  1179,  1066, -1119,  1180,  1507,  1181,  1182,  1183,  2019,
    1184,  3546,  1066,  1357,  1185,  1507,  1186,  1187,  1188,  1189,
     374,  1190,  3546,  1191,  1192,  1193,  1362,  1194,  1195,  1196,
    1197,   655,  1198,  2664,  1512,  3546,  1199,  1200,   374,   374,
    2667,  1355,  1201,  1202,  1512,   374,   519,   374,   374,  1203,
    1204,  1205,  1206,  1207,  1209,  1210,  1211,  1212,  1213,  1214,
    1215,  1365,  3546,  3546, -1119,  1216,  3668,  1217,  1218,  1222,
    1223,  1224,  1225,  1226,   520,  1227,  1228,  1229,  1154,  1230,
    1231,   374,  1366,  1232, -1119,  1233,  1235,  1237,   521,  1238,
    1239,  1387, -1119,   374,   374,  1240,  1241,  1242,  1243,  1244,
    1245,  1246,   528,   374,  1247,  1248,  1249,  1515,  1250,   374,
     522,  1367,   374, -1119,  1516,   374,  1251,  1515,  1252,   529,
    1253,   523,  1254,  1255,  1516,   530,   374,   374,  1369,   374,
    1256,   531,  1257,  3097,  1258,   374,   374,  1388,  1259,  1263,
    1264,  1267,  1268,  1272,  1273,   374,  1274,   374,  1391,  1278,
     524,   374,   374, -1119,  1279,   532,  1280,  1281,  2673,  1282,
    1283,  1354,  1400,  1370,  1402,  1431,   533,   534,  2289,  1393,
    1399,   548,  1401, -1119,  2389,   525,  1408,  1416,  1422,  1435,
    1517,   526,  1451,  1463,  1465,  1479,  1467,  1544,  1546,  1545,
    1517,   374,   374,  1547,  1518,  1548,  1549,   375,  1550,  1551,
    1552,  1553,   535,  1554,  1518,  1555,  1556, -1119,  1557,   405,
    1558,  1559,   411,  1560,  3006,  1561,  1562,   374,   527,   420,
    2425,  1563,  1566,  1568,   374,  1572,  1580,  1350,  1592,   431,
    1620,  1585,  1271,  1640,  1654,  1671,  1703,   374,  1735,   447,
    1763,  1726,  1741,  1760,  1783,  1521,   536,  1522,   537,  1729,
   -1119,  1746,  1793,  1794,  1818,  1521,  1821,  1522,  1852,  1866,
    1878,  1880,  1887, -1119, -1119,  1908,  1909,  1912,  1523,  1524,
    3318,  1525,  1913,  1915,  1923,  1924,  1925,   465,  1523,  1524,
   -1119,  1525, -1119,   374,  1926,  1927,  3323,  3324,  3325,  3326,
    1928,  1929,  1946,  1947,  1950,  1958,  1949,   468,   375,  1957,
     375,  1963,  1977,  1955,  2025,  2029,  2031,  1527, -1119, -1119,
    2042,   465,  2032,  2036,  2039, -1119,  2038,  1527,  3320,  2040,
    2041,  2043,  2046,  2047,  2048,  2056,  2049,  2050,  2053,   528,
    2055,  2057,  2075,  2559,  2058,  2059,  2060,  2061,  2109,  2062,
    2063,  2064,  2069,  2070,  2073,  2080,   529,  2074,  2076,  2193,
    2077,  2081,   530,  2082,  2085,  2188,  2090,  2091,   531,  2094,
    1729,  2095,  2096,  2097,  2102,   374,  1094,  1095,  1096,  1097,
    1098,  1099,  -785,  2098,  1100,  1101,  1102,  1103,  1104,  1105,
    2099,  1106,   532,  2103,  2106,  2225,  1313,  2228,  1528,  2238,
    2230,  2107,  2108,   533,   534,  2110,   374,  1529,  1528,  2112,
     374,  2113,   374,   374,   374,   374,  2114,  1529,  2116,  2889,
    2119,  2120,  2125,   374,  2126,  2127,  2128,   374,  2129,  2130,
     374,  2133,  2136,  2138,  2139,  2335,  2140,  2141,  2142,   535,
    2145,  2146,  2231,  2147,   374,   374,   374,  2148,  2232,  2149,
    2152,  2154,  1824,  2155,  2242,  2158,  2159,   374,   986,  2160,
    2243,  2205,  2169,   374,  2171,   374,  2172,  2173,  2174,  2179,
    2212,  1081,  -961,   374,  2244,  2240,  2248,  2260,  2261,  2229,
    2262,  2263,  1859,   536,  1858,   537,  2280,  2282,  2281,  2305,
    2308,  2314,  2312,  2313,  2330,  1107,  1108,  2337,  2338,  2398,
    2364,  2365,  2412,  2413,  2417,  2418,  1481,  1586,  2444,  2464,
     787,  2477,  2487,  2499,  2524,  2526,  2500,  2519,  2528,  2531,
    1327,  1328,  1329,  1330,  1331,  2534,  2537,  2539,  2540,  2541,
    1729,  2542,  2543,   374,  3619,  2551,  2558, -1015,  2566,  2571,
    2573,  2577,  2585,  2588,   374,  2593,  2604,   374,  2591,  2605,
    2610,  1729,  2618,  2629,  2640,  2635,  2639,  2643,  2669,  2655,
    1178,  1262,  1266,  2735,  2656,  2738,  3208,  1729,  2742,  2744,
    2746,  3619,  2749,  2764,  2754,  2751,  2755,  2756,  2757,  2760,
    2765,   374,  2766,  3096,  2767,  2846,  2867,  2768,   374,  2772,
    2769,   374,  1332,  2770,  2771,   374,   374,  3556,   509,   374,
    2776,  2223,  2777,  2778,  2779,  2780,  2781,  2783,   542,   374,
    2782,  2784,   550,  2788,  2785,  2786,  2787,   465,  2789,  3292,
    2677,  2796,   569,  2790,  1333,  1334,  1335,  1336,  2869,  1843,
    2882,  2905,  2848,  2791,  2890,  2902,  2908,  2909,  2743,  2797,
    2928,  2929,  2941,  3024,   465,  2792,  2793,  2898,  2798,  2799,
    2800,  3158,  2801,  2804,  2805,  2811,  2812,  2813,  2814,  2815,
    2899,   666,  2816,  2817,  2818,  3302,  3303,  2819,  3026,  2820,
    2830,   465,  2821,  3287,  2822,   465,  2823,  2825,  2831,  2927,
    2832,   688,  2833,   465,   465,  2834,  3287,  2836,   700,   550,
    2838,  2840,  2841,  2937,  2842,  2843,  3033,  2844,   719,  2850,
    2938,  3146,   724,  3086,  2857,  2854,  2858,   900,   375,  2871,
     375,   375,   550,   465,  2903,  2966,  2923,  1337,  2988,  1338,
    1339,  1340,  2989,  2991,  2994,  3014,  3028,  3029,  3030,  1341,
    3035,  3040,  3041,  3042,  3050,  3076,  3051,  3052,  3057,  3053,
    2276,  3074,  3069,  3080,  3082,  2608,   948,  3087,  3083,  3088,
    3091,  3093,  3094,  3368,  3098, -1049,  3107, -1054,  3109,  3113,
    3132,  3114,   465,  3133,  3140,  2985,  2289,  3155,  3162,  2982,
     550,   465,  3151,   374,   374,   465,   374,  3163,  3153,  3164,
    3475,  3166,   465,  3167,  3177,   374,  2335,  3168,  3182,  3169,
    3170,   374,  1342,  3380,  3171,  3173,  3183,  3186,  3200,  3215,
    3216,   374,  3199,  3241,  3201,  3228,   986,  3475,  3475,   374,
    3210,  3204,   550,  3207,  3209,  3211,  3229,  3212,  3224,  3213,
    3214,  3230,  3250,  3256,  3265,  3217,   374,  3218,  3259,  3293,
     657,  3219,  3220,  3221,  3222,  3261,  3307,  3294,   374,  1343,
    1344,  3223,  3315,  3226,  3328,   374,  3253,  3254,  3475,  3475,
    3203,  3283,   374,  3475,  3284,  3291,  3295,  3296,   374,  3297,
    3298,  3309,  3316,  3322,  3329,  3310,  3312,  3308,  1065,  3475,
    3343,  3475,  3345,  3373,  3375,  3348,   550,  3350,  3374,   465,
    3353,  3400,  1084,   465,  3386,  3402,  3403,  3475,  3404,  3405,
    3411,  3387,  2408,  3419,  3435,  3390,  3475,  3391,  3427,  3425,
    3392,  3428,  3429,  3436,  2889,  3446,  3448,  3449,  3439,  3455,
    3475,  2416,  3457,  3475,  3478,  3476,  3487,  3488,   465,  3511,
    1144,  3475,  -211,  3506,  3512,  3513,  3519,  3475, -1179,  3535,
    3536,  3537,   374,  3547,  3554,  3444,  3445,   657,  3447,  3555,
    3558, -1119,  3475,  3559,  3560,  3566,  3565,  3569,  3475,  3570,
     657,  3475, -1751,  1345,  3572,  3576,   943,  3586,  3598,  3475,
    3599,  3594,  3604,  2289,  1346,  1347,  3605,  3606,  3612,  3611,
    3614,  3625,  3475,  3601,  3620,  3607,  3632,  3627,  3630,  3484,
    3631,  3485,  3486,  3643,  3641,  3475,  3650,  3475,  3664,  3669,
    2224,  2009,  3551,  1074,  3311,  3382,  3305,  3531,  3671,  3475,
    3475,  3646,  3652,  3475,  3583,  3542,  3584,  3550,  3193,  1485,
     497,  1565,  3016,  3267,  1976,  2429,  2935,  2409,  2349,  2930,
    1980,  1933,  2992, -1119,  3285,  3124,  3165,  2953,  3157,  2931,
    2954,   374,  2896,  3418,  3422,  3282,  3362,  3377,  3314,  2399,
    3290,  3531,  1579,  1466,  1897,  1564,  2245,  1835,  2576,  1085,
    2241,  1062,  2264,   663,   374,   991,  3330,  1857,  3227,  3059,
    1765,  1770,  3060,  2461,  2904,  1670,  3417,  2556,  1293,   374,
    1295,  3264,  2933,  3578,  3252,  2271,  1386,  1404,  2237,  2875,
     944,  2251,  3078,  2915,  3433,  2874,  1618,  3637,  3479,   652,
     725,  1142,   638,  1795,  1584,  2868,  3530,  3406,  1406,  3552,
    3651,  3450,   465,  2878,  3161,  2626, -1119,  2900,   465,  3255,
     374,  1829,  3092,  1420,  1867,   585,  3321,  1411,   979,  1569,
    3327,  2565,   587,  3225,   983,  1379,   678,  2424,  3013, -1119,
    1137,  1737,   374,     0,  3191, -1119,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1380,     0,  1383,     0,   465,
       0,     0,   374, -1119,     0,     0,     0,     0,     0,     0,
   -1119,   465,   550,   657,     0,     0,     0,     0, -1119,     0,
       0,   465,   465,     0,     0,     0,     0,   374,     0,   374,
       0, -1119,  1412,     0,     0, -1119,     0,     0,     0,   374,
    1421,     0,     0,     0, -1119,   374,  3481,     0,     0,   657,
     657,     0,   657,     0,   375,   375,   465,   465,     0,     0,
       0,     0,     0,     0,   375,     0,   550,     0,  3185,     0,
       0,     0,   375,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   465,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   374,   657,     0,   657,   657,     0,     0,     0,
       0,     0,     0,     0,     0, -1119,     0,  3433,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,     0,     0,     0, -1119,     0,     0,   465,     0,
       0,   465,     0, -1119,     0,     0,     0,     0,     0,     0,
     374,     0,     0,     0,     0,     0,   374,   374,  2289,     0,
       0,     0,     0,     0, -1119,     0,  -540,     0,     0,  1497,
     374,     0,     0,     0,     0,     0,  1498,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1499,  1500,     0,   374,
     550,     0,   550,   375,   375,     0,   465,     0,     0,     0,
       0,     0,     0,     0, -1119,   724,     0,  1587,  3661,     0,
       0,     0,     0,     0,     0,  1501,     0,     0,     0,  1502,
       0,     0,     0,     0, -1119,     0,     0,   374,     0,     0,
    1503,     0,     0,  3661,     0,     0,     0,     0,     0,  1504,
     374,  1627,     0,     0,  1505,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1506,     0, -1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1066,     0,     0,  1507,     0,     0,     0,     0,     0,
       0,  1627,     0,  1508,  1509,     0,     0,     0,     0,  1510,
       0,     0,     0,  3634,     0,     0,     0,  1511,     0,     0,
       0, -1119,     0,  1512,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1119,     0,     0,     0,     0,
       0,     0,  3670,     0,     0,     0,     0,     0,  1513,     0,
       0, -1119,     0, -1119,     0,     0,     0,     0,     0,  1730,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   374,   550,     0,     0,     0,     0, -1119,
   -1119,     0,     0,     0,     0,     0, -1119,     0,     0,     0,
       0,   374,   374,     0,  1514,     0,  1515,     0,     0,     0,
       0,     0,     0,  1516,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   374,     0,   374,   374,     0,     0,     0,
       0,  3396,     0,     0,     0,     0,     0,   374,     0,     0,
     550,     0,     0,     0,     0,  1788,     0,   550,     0,     0,
       0,     0,   550,     0,     0,     0,     0,     0,   465,     0,
    1798,     0,     0,     0,     0,  1803,  1803,     0,  1803,     0,
       0,     0,     0,   374,     0,     0,     0,     0,     0,  1517,
     465,     0,     0,   465,     0,     0,     0,     0,     0,   550,
     550,   465,   465,  1518,     0,     0,     0,     0,  1519,  1803,
    1803,  1803,     0,     0,     0,     0,     0,  3473,     0,     0,
       0,     0,   374,     0,     0,     0,     0,  1870,     0,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,     0,     0,
       0,   374,     0,     0,  3473,  3473,   374,     0,  1520,     0,
       0,     0,     0,  1889,  1521,     0,  1522,     0,   465,     0,
       0,     0,     0,     0,   374,     0,     0,     0,     0,     0,
    1899,     0,     0,     0,     0,   374,   465,  1523,  1524,     0,
    1525,     0,     0,     0,     0,  3473,  3473,     0,     0,     0,
    3473,     0,     0,     0,  1526,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3473,     0,  3473,     0,
       0,     0,     0,     0,     0,     0,  1527,     0,     0,     0,
       0,     0,     0,     0,  3473,     0,     0,     0,     0,     0,
       0,     0,     0,  3473,     0,  1983,     0,     0,     0,     0,
     374,     0,     0,     0,  1987,     0,     0,  3473,     0,   374,
    3473,     0,     0,     0,     0,     0,     0,     0,  3473,     0,
       0,     0,     0,     0,  3473,     0,     0,     0,     0,     0,
       0,     0,   375,     0,     0,     0,     0,     0,     0,  3473,
     465,     0,   374,  2027,   374,  3473,     0,     0,  3473,     0,
     374,     0,     0,     0,     0,     0,  3473,  1528,     0,   374,
       0,     0,     0,   374,     0,     0,  1529,     0,     0,  3473,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,     0,  3473,     0,  3473,   374,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3473,  3473,     0,     0,
    3473,     0,     0,     1,     0,     0,     0,     0,     0,     0,
     374,     0,     0,     2,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -540,     4,     0,     5,     0,
       0,  -540,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     7,     0,     0,
       0,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    11,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    13,     0,     0,  2194,     0,     0,     0,
       0,     0,    14,    15,    16,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    17,    18,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    20,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,     0,
       0,     0,     0,     0,     0,    22,     0,     0,    23,     0,
       0,     0,     0,     0,     0,     0,     0,  2258,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    24,
       0,     0,     0,     0,     0,  2277,  2279,     0,     0,     0,
       0,     0,   550,    25,   550,   550,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    26,     0,     0,     0,     0,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1730,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     550,   550,     0,     0,     0,     0,     0,     0,     0,     0,
    1983,     0,     0,     0,     0,     0,  1983,     0,     0,  1983,
       0,     0,  1983,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1983,  1983,     0,   550,     0,     0,     0,
       0,     0,  1983,  1730,     0,     0,     0,     0,     0,     0,
       0,     0,   465,     0,   550,     0,     0,     0,  1983,  2404,
       0,    28,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    29,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,   465,  1983,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,    32,    33,     0,     0,    34,     0,     0,    35,     0,
      36,     0,     0,     0,   550,    37,     0,    38,     0,     0,
       0,   550,     0,     0,     0,     0,    39,     0,     0,     0,
      40,   871,     0,     0,  2468,     0,    41,     0,     0,     0,
       0,    42,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     2,     3,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     4,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1627,     0,     0,     0,   950,     0,     6,     7,     0,     0,
       0,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,    11,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,     0,     0,    12,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    13,     0,     0,     0,     0,     0,    50,
       0,     0,    14,    15,    16,     0,     0,     0,     0,     0,
       0,     0,   550,     0,     0,    17,    18,     0,     0,     0,
      51,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,     0,     0,  2564,     0,     0,     0,  1798,     0,   948,
     550,   550,   550,     0,    20,     0,     0,     0,     0,     0,
     465,     0,  1093,     0,   550,     0,     0,  1730,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,     0,
       0,   550,   550,   550,     0,    22,     0,     0,    23,     0,
       0,     0,     0,     0,  2607,     0,     0,     0,     0,     0,
    2609,     0,  2611,     0,     0,     0,     0,     0,     0,    24,
     550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    25,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    26,     0,     0,     0,     0,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1208,     0,     0,     0,     0,     0,     0,
    1983,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   550,     0,     0,  1983,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   465,     0,
       0,     0,     0,     0,     0,  2676,     0,     0,   465,     0,
       0,    28,  2732,  2733,     0,     0,  2736,     0,  1284,     0,
       0,     0,  1291,     0,     0,     0,   465,     0,     0,     0,
       0,     0,    29,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,    32,    33,     0,     0,    34,     0,     0,    35,     0,
      36,     0,     0,     0,     0,    37,     0,    38,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
      40,     0,     0,     0,     0,     0,    41,     0,     0,     0,
       0,    42,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1419,     0,     0,     0,
       0,     0,     0,     0,     0,  1434,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,     0,     0,     0,     0,    49,     0,     0,     0,
    2258,  2879,     0,   550,     0,     0,     0,     0,     0,     0,
       0,     0,   550,     0,     0,     0,     0,     0,  2564,    50,
       0,     0,     0,     0,     0,     0,     0,     0,   550,     0,
       0,     0,     0,     0,     0,     0,  1870,     0,     0,     0,
      51,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1730,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1983,     0,     0,     0,     0,
       0,     0,  1983,     0,     0,     0,     0,     0,     0,  1730,
       0,     0,     0,     0,     0,  1983,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1589,  1590,  1591,     0,     0,
       0,     0,     0,     0,  1606,  1607,     0,     0,  1610,     0,
    1612,  1613,  1614,  1615,     0,     0,     0,  1619,     0,     0,
    1621,  1622,     0,  1623,     0,  1624,  1625,     0,  1628,  1629,
    1630,  1631,  1632,     0,  1635,     0,  1637,  1638,  1639,  3021,
    1641,  1642,  1643,  1644,     0,  1646,  1647,     0,  1653,     0,
       0,  1657,  1658,  1659,     0,  1661,  1662,  1663,  1664,     0,
    1666,  1667,  1668,  1669,     0,     0,     0,     0,     0,  1676,
    1677,     0,  1680,  1681,  1682,  1683,  1684,     0,     0,     0,
       0,  1688,     0,  1689,  1690,  1691,  1692,  1693,     0,     0,
    1696,  1698,  1699,  1700,  1701,  1702,     0,  1704,  1705,     0,
       0,  1708,  1709,  1710,     0,  1713,     0,  1714,     0,     0,
       0,  1717,     0,  1721,  1722,     0,     0,     0,     0,  1725,
       0,     0,     0,     0,     0,     0,     0,  1732,  1733,  1734,
       0,     0,     0,     0,     0,     0,  1291,     0,  3056,  1742,
    2678,  2679,     0,     0,     0,     0,  2680,     0,  2681,  2682,
    2683,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1730,     0,     0,  2684,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   550,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   565,   604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1786,     0,
       0,     0,     0,  2685,     0,     0,  2686,     0,   605,   606,
       0,     0,     0,     0,  2687,     0,     0,  3021,   607,     0,
     608,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2688,     0,     0,     0,   609,   610,   550,
       0,     0,  1831,     0,     0,     0,   611,     0,     0,     0,
    2689,     0,     0,     0,     0,     0,     0,     0,     0,   550,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2690,     0,  2691,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3175,     0,  3176,     0,     0,     0,
       0,  2692,  2693, -1345,   612,     0,   465,     0,   613,     0,
       0,     0,  3190,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   614,     0,   615,
       0,     0,  2694,     0,     0,     0,     0,     0,     0,     0,
       0,   616,     0,   617,     0,     0,     0,     0,     0,  2277,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2695,
       0,     0,     0,     0,     0,     0,   618,   619,  2696,  2697,
     620,  2698,     0,     0,     0,     0,     0,   550,     0,     0,
       0,     0,     0,     0,     0,   621,     0,     0,     0,     0,
       0,     0,  1988,     0,     0,     0,     0,  3263,     0,  2699,
    2700,  2701,     0,  3021,  3021,     0,   622,     0,     0,     0,
       0,   623,     0,     0,     0,     0,     0,  3281,     0,  2702,
    2703,  2704,     0,     0,     0,  2705,     0,     0,  2706,     0,
       0,     0,     0,     0,     0,   624,   550,     0,     0,     0,
       0,  2707,  2708,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2709,   625,  2710,     0,
       0,     0,     0,     0,  3306,     0,   626,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3021,     0,     0,
    2711,     0,     0,     0,   627,     0,     0,  1497,     0,     0,
       0,     0,     0,     0,  1498,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1499,  1500,     0,     0,     0,   628,
     629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2712,     0,  2713,     0,     0,     0,     0,
       0,     0,     0,  1501,     0,  2714,     0,  1502,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1503,     0,
       0,     0,     0,     0,  2162,  2164,  2166,  1504,     0,     0,
       0,     0,  1505,     0,     0,     0,     0,     0,     0,   630,
       0,  2180,     0,     0,  1506,     0,  2715,  2716,     0,   631,
    2717,  2718,  2719,  2720,     0,     0,     0,     0,     0,  1066,
    3190,     0,  1507,     0,     0,     0,  2206,     0,     0, -1776,
       0,  1508,     0,   632,     0,     0,     0,  1510,  1730,   465,
       0,     0,     0,     0,     0,  1511,   633,     0,     0,  2218,
       0,  1512,     0,  2721,  2722,     0,     0,     0,  3263,     0,
    3263,     0,  3415,  1987,     0,     0,     0,     0,     0,     0,
       0,     0,  2723,     0,  3423,     0,  1513,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1776,     0,     0,     0,   634,     0,     0,     0,     0,     0,
    3443,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1515,     0,     0,     0,     0,     0,
       0,  1516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1730,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3489,     0,
       0,     0,     0,  3496,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   550,     0,     0,     0,     0,     0,  1517,     0,     0,
       0,     0,  3514,     0,     0,     0,     0,     0,     0,     0,
       0,  1518,     0,     0,     0,     0,  1519,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1520,     0,     0,     0,
       0,     0,  1521,     0,  1522,     0,     0,  3580,     0,     0,
       0,     0,     0,     0,     0,     0,  3591,     0,     0,     0,
       0,     0,     0,     0,     0,  1523,  1524,     0,  1525,     0,
       0,     0,     0,     0,     0,     0,     0,  2442,     0,     0,
    2443,     0,  1526,  2445,  2446,     0,     0,     0,     0,  1730,
       0,  3622,     0,     0,     0,     0,  2459,  3628,     0,  2462,
       0,     0,     0,     0,  1527,     0,   550,     0,     0,     0,
    1730,     0,  2469,     0,  2470,     0,     0,     0,  2473,     0,
    2474,  2475,     0,     0,     0,  2478,  1730,  2479,  2480,     0,
    2481,     0,  3662,  2482,     0,  2483,  2484,     0,     0,     0,
       0,  2488,  2489,     0,     0,  2491,     0,  2492,     0,  2493,
       0,  2494,     0,  2496,     0,     0,     0,  3662,     0,     0,
       0,     0,     0,     0,  2501,  2502,     0,     0,  2503,     0,
    2504,     0,     0,     0,     0,     0,     0,     0,  2505,  2506,
       0,  2507,     0,  2508,     0,  1528,  2509,  2510,  2511,     0,
    2512,     0,     0,     0,  1529,  2515,  2516,  2517,  2518,     0,
       0,     0,     0,  2520,  2521,  2522,     0,  2523,     0,  2525,
       0,  2527,     0,  2529,     0,  2530,     0,     0,     0,     0,
       0,     0,  2532,     0,  2533,     0,     0,  2535,  2536,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2545,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2554,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2572,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2616,
       0,     0,     0,     0,  2620,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2651,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2654,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2753,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2835,     0,  2837,     0,  2839,     0,     0,     0,     0,     0,
    2845,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2856,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2901,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3027,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3031,     0,
       0,     0,     0,     0,  3032,     0,     0,     0,     0,     0,
       0,     0,     0,  3036,  3037,     0,     0,     0,     0,  3038,
       0,     0,     0,  3039,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3043,     0,     0,     0,
       0,     0,  3045,     0,     0,  3046,  3047,     0,  3048,  3049,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3054,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3105,  3106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2651,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2651,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2616,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3317,     0,     0,     0,     0,     0,  3319,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3335,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3347,     0,  3349,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2651,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3438,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3452,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3517,  3518,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3538,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3549,     0,     0,     0,     0,  3553,     0,     0,
       0,     0,     0,     0,     0,     0,  3563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3595,     0,   122,
       0,   726,   124,   125,   126,   127,     0,     0,  3603,     0,
       0,   128,     0,     0,   727,     0,   728,   130,   131,   729,
     133,     0,   134,   730,   135,     0,   731,   136,   732,   733,
     734,   137,   735,     0,   138,   139,  1718,   140,     0,   141,
     142,     0,     0,   143,   736,   144,     0,   145,   737,   738,
     147,     0,   148,   149,   150,   739,   151,     0,   740,   153,
       0,   154,   155,   156,   157,   158,   741,   742,   159,  3663,
     160,   161,     0,   743,     0,   744,   745,   746,     0,     0,
     163,   747,   748,     0,   749,   750,     0,   164,   165,   751,
     752,   753,     0,     0,     0,     0,   754,   168,   755,     0,
       0,   756,   757,   169,     0,   170,     0,     0,     0,   758,
     759,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   760,   179,     0,
     761,   762,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   763,     0,   188,   764,   189,   765,   766,
     190,     0,   767,   191,   192,   193,   768,     0,   194,     0,
       0,   769,     0,   195,   196,     0,   770,   197,     0,   198,
     771,   772,   773,   774,     0,   775,   776,   200,   777,   778,
     779,   202,     0,   203,   780,     0,   781,   782,     0,   204,
     205,     0,   206,   783,     0,   207,     0,     0,     0,   784,
     209,   210,   211,   785,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   786,   215,   787,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     788,   220,     0,  1719,   789,   221,     0,   790,   222,     0,
       0,     0,   791,     0,   792,     0,   224,   793,     0,   225,
       0,   226,   794,     0,     0,   795,     0,     0,     0,     0,
     796,   227,   228,   229,   230,   231,   232,   797,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   798,   242,   243,
     244,   799,   245,   246,     0,     0,     0,   247,   248,   800,
     250,     0,     0,   801,   252,   802,   803,   253,     0,   254,
     804,   805,   806,   807,   808,   809,   810,   259,   260,   261,
     262,     0,   811,   263,   264,     0,   265,   266,   267,   812,
     813,   814,   268,     0,   815,   816,     0,   269,   270,     0,
     817,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   818,   819,   278,
     820,   821,   822,   823,   824,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   825,   287,   288,   289,   290,   291,
     292,   293,   826,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   827,   828,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     829,   308,   309,   830,   310,   311,   831,   312,   832,   314,
     315,     0,   833,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     834,   835,   334,   335,     0,   336,   836,   338,   837,   838,
     839,   339,   340,   840,   341,   342,     0,   343,   344,     0,
     655,   345,   841,   842,   843,   844,     0,     0,     0,     0,
    1720,   350,     0,   351,   845,   846,   847,   353,   354,   355,
       0,   848,   356,   357,   849,     0,   358,     0,     0,   850,
     851,   359,     0,     0,   360,     0,   361,     0,   852,   363,
       0,     0,   853,   854,   855,   856,   857,   364,     0,     0,
     365,   858,     0,   366,   367,   859,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   860,     0,   861,     0,     0,
       0,     0,   862,     0,     0,     0,   863,   864,     0,     0,
       0,     0,   865,     0,   866,     0,     0,   867,   868,     0,
     869,   870,   122,     0,   726,   124,   125,   126,   127,  2612,
       0,     0,     0,     0,   128,     0,     0,   727,     0,   728,
     130,   131,   729,   133,     0,   134,   730,   135,     0,  2613,
     136,   732,   733,   734,   137,   735,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   736,   144,     0,
     145,   737,   738,   147,     0,   148,   149,   150,   739,   151,
       0,   740,   153,     0,   154,   155,   156,   157,   158,   741,
     742,   159,     0,   160,   161,     0,   743,     0,   744,   745,
     746,     0,     0,   163,   747,   748,     0,   749,   750,     0,
     164,   165,   751,   752,   753,     0,     0,     0,     0,   754,
     168,   755,     0,     0,   756,  2614,   169,     0,   170,     0,
       0,     0,   758,   759,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     760,   179,     0,   761,   762,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   763,     0,   188,   764,
     189,   765,   766,   190,     0,   767,   191,   192,   193,   768,
       0,   194,     0,     0,   769,     0,   195,   196,     0,   770,
     197,     0,   198,   771,   772,   773,   774,     0,   775,   776,
     200,   777,   778,   779,   202,     0,   203,   780,     0,   781,
     782,     0,   204,   205,     0,   206,   783,     0,   207,     0,
       0,     0,   784,   209,   210,   211,   785,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   786,   215,   787,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   788,   220,     0,     0,   789,   221,     0,
     790,   222,     0,     0,     0,   791,     0,   792,     0,   224,
     793,     0,   225,     0,   226,   794,     0,     0,   795,     0,
       0,     0,     0,   796,   227,   228,   229,   230,   231,   232,
     797,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     798,   242,   243,   244,   799,   245,   246,     0,     0,     0,
     247,   248,   800,   250,     0,     0,   801,   252,   802,   803,
     253,     0,   254,   804,   805,   806,   807,   808,   809,   810,
     259,   260,   261,   262,     0,   811,   263,   264,     0,   265,
     266,   267,   812,   813,   814,   268,     0,   815,   816,     0,
     269,   270,     0,   817,  2615,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     818,   819,   278,   820,   821,   822,   823,   824,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   825,   287,   288,
     289,   290,   291,   292,   293,   826,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   827,   828,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   829,   308,   309,   830,   310,   311,   831,
     312,   832,   314,   315,     0,   833,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   834,   835,   334,   335,     0,   336,   836,
     338,   837,   838,   839,   339,   340,   840,   341,   342,     0,
     343,   344,     0,   655,   345,   841,   842,   843,   844,     0,
       0,     0,     0,     0,   350,     0,   351,   845,   846,   847,
     353,   354,   355,     0,   848,   356,   357,   849,     0,   358,
       0,     0,   850,   851,   359,     0,     0,   360,     0,   361,
       0,   852,   363,     0,     0,   853,   854,   855,   856,   857,
     364,     0,     0,   365,   858,     0,   366,   367,   859,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   860,     0,
     861,     0,     0,     0,     0,   862,     0,     0,     0,   863,
     864,     0,     0,     0,     0,   865,     0,   866,     0,     0,
     867,   868,     0,   869,   870,   122,     0,   726,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     727,     0,   728,   130,   131,   729,   133,     0,   134,   730,
     135,     0,   731,   136,   732,   733,   734,   137,   735,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     736,   144,     0,   145,   737,   738,   147,     0,   148,   149,
     150,   739,   151,     0,   740,   153,     0,   154,   155,   156,
     157,   158,   741,   742,   159,     0,   160,   161,     0,   743,
       0,   744,   745,   746,     0,     0,   163,   747,   748,     0,
     749,   750,     0,   164,   165,   751,   752,   753,     0,     0,
       0,     0,   754,   168,   755,     0,     0,   756,   757,   169,
       0,   170,     0,     0,     0,   758,   759,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   760,   179,     0,   761,   762,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   763,
       0,   188,   764,   189,   765,   766,   190,     0,   767,   191,
     192,   193,   768,     0,   194,     0,     0,   769,     0,   195,
     196,     0,   770,   197,     0,   198,   771,   772,   773,   774,
       0,   775,   776,   200,   777,   778,   779,   202,     0,   203,
     780,     0,   781,   782,     0,   204,   205,     0,   206,   783,
       0,   207,     0,     0,     0,   784,   209,   210,   211,   785,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   786,
     215,   787,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   788,   220,     0,     0,
     789,   221,     0,   790,   222,     0,     0,     0,   791,     0,
     792,     0,   224,   793,     0,   225,     0,   226,   794,     0,
       0,   795,     0,     0,     0,     0,   796,   227,   228,   229,
     230,   231,   232,   797,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   798,   242,   243,   244,   799,   245,   246,
       0,     0,     0,   247,   248,   800,   250,     0,     0,   801,
     252,   802,   803,   253,     0,   254,   804,   805,   806,   807,
     808,   809,   810,   259,   260,   261,   262,     0,   811,   263,
     264,     0,   265,   266,   267,   812,   813,   814,   268,     0,
     815,   816,     0,   269,   270,     0,   817,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   818,   819,   278,   820,   821,   822,   823,
     824,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     825,   287,   288,   289,   290,   291,   292,   293,   826,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   827,   828,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   829,   308,   309,   830,
     310,   311,   831,   312,   832,   314,   315,     0,   833,   317,
    1289,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   834,   835,   334,   335,
       0,   336,   836,   338,   837,   838,   839,   339,   340,   840,
     341,   342,     0,   343,   344,     0,   655,   345,   841,   842,
     843,   844,     0,     0,     0,     0,     0,   350,     0,   351,
     845,   846,   847,   353,   354,   355,     0,   848,   356,   357,
     849,     0,   358,     0,     0,   850,   851,   359,     0,     0,
     360,     0,   361,     0,   852,   363,     0,     0,   853,   854,
     855,   856,   857,   364,     0,     0,   365,   858,     0,   366,
     367,   859,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   860,     0,   861,     0,     0,     0,     0,   862,     0,
       0,     0,   863,   864,     0,     0,     0,     0,   865,     0,
    1290,     0,     0,   867,   868,     0,   869,   870,   122,     0,
     726,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   727,     0,   728,   130,   131,   729,   133,
       0,   134,   730,   135,     0,   731,   136,   732,   733,   734,
     137,   735,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   736,   144,     0,   145,   737,   738,   147,
       0,   148,   149,   150,   739,   151,     0,   740,   153,     0,
     154,   155,   156,   157,   158,   741,   742,   159,     0,   160,
     161,     0,   743,     0,   744,   745,   746,     0,     0,   163,
     747,   748,     0,   749,   750,     0,   164,   165,   751,   752,
     753,     0,     0,     0,     0,   754,   168,   755,     0,     0,
     756,   757,   169,     0,   170,     0,     0,     0,   758,   759,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   760,   179,     0,   761,
     762,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   763,     0,   188,   764,   189,   765,   766,   190,
       0,   767,   191,   192,   193,   768,     0,   194,     0,     0,
     769,     0,   195,   196,     0,   770,   197,     0,   198,   771,
     772,   773,   774,     0,   775,   776,   200,   777,   778,   779,
     202,     0,   203,   780,     0,   781,   782,     0,   204,   205,
       0,   206,   783,     0,   207,     0,     0,     0,   784,   209,
     210,   211,   785,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   786,   215,   787,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   788,
     220,     0,     0,   789,   221,     0,   790,   222,     0,     0,
       0,   791,     0,   792,     0,   224,   793,     0,   225,     0,
     226,   794,     0,     0,   795,     0,     0,     0,     0,   796,
     227,   228,   229,   230,   231,   232,   797,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   798,   242,   243,   244,
     799,   245,   246,     0,     0,     0,   247,   248,   800,   250,
       0,     0,   801,   252,   802,   803,   253,     0,   254,   804,
     805,   806,   807,   808,   809,   810,   259,   260,   261,   262,
       0,   811,   263,   264,     0,   265,   266,   267,   812,   813,
     814,   268,     0,   815,   816,     0,   269,   270,     0,   817,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   818,   819,   278,   820,
     821,   822,   823,   824,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   825,   287,   288,   289,   290,   291,   292,
     293,   826,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   827,   828,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   829,
     308,   309,   830,   310,   311,   831,   312,   832,   314,   315,
       0,   833,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   834,
     835,   334,   335,     0,   336,   836,   338,   837,   838,   839,
     339,   340,   840,   341,   342,     0,   343,   344,     0,   655,
     345,   841,   842,   843,   844,     0,     0,     0,     0,     0,
     350,     0,   351,   845,   846,   847,   353,   354,   355,     0,
     848,   356,   357,   849,     0,   358,     0,     0,   850,   851,
     359,     0,     0,   360,     0,   361,     0,   852,   363,     0,
       0,   853,   854,   855,   856,   857,   364,     0,     0,   365,
     858,     0,   366,   367,   859,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   860,     0,   861,     0,     0,     0,
       0,   862,     0,     0,     0,   863,   864,     0,     0,     0,
       0,   865,     0,   866,  1566,     0,   867,   868,     0,   869,
     870,   122,     0,   726,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   727,     0,   728,   130,
     131,   729,   133,     0,   134,   730,   135,     0,   731,   136,
     732,   733,   734,   137,   735,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   736,   144,     0,   145,
     737,   738,   147,     0,   148,   149,   150,   739,   151,     0,
     740,   153,     0,   154,   155,   156,   157,   158,   741,   742,
     159,     0,   160,   161,     0,   743,     0,   744,   745,   746,
       0,     0,   163,   747,   748,     0,   749,   750,     0,   164,
     165,   751,   752,   753,     0,     0,     0,     0,   754,   168,
     755,     0,     0,   756,   757,   169,     0,   170,     0,     0,
       0,   758,   759,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   760,
     179,     0,   761,   762,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   763,     0,   188,   764,   189,
     765,   766,   190,     0,   767,   191,   192,   193,   768,     0,
     194,     0,     0,   769,     0,   195,   196,     0,   770,   197,
       0,   198,   771,   772,   773,   774,     0,   775,   776,   200,
     777,   778,   779,   202,     0,   203,   780,     0,   781,   782,
       0,   204,   205,     0,   206,   783,     0,   207,     0,     0,
       0,   784,   209,   210,   211,   785,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   786,   215,   787,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   788,   220,     0,     0,   789,   221,     0,   790,
     222,     0,     0,     0,   791,     0,   792,     0,   224,   793,
       0,   225,     0,   226,   794,     0,     0,   795,     0,     0,
       0,     0,   796,   227,   228,   229,   230,   231,   232,   797,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   798,
     242,   243,   244,   799,   245,   246,     0,     0,     0,   247,
     248,   800,   250,     0,     0,   801,   252,   802,   803,   253,
       0,   254,   804,   805,   806,   807,   808,   809,   810,   259,
     260,   261,   262,     0,   811,   263,   264,     0,   265,   266,
     267,   812,   813,   814,   268,     0,   815,   816,     0,   269,
     270,     0,   817,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   818,
     819,   278,   820,   821,   822,   823,   824,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   825,   287,   288,   289,
     290,   291,   292,   293,   826,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     827,   828,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   829,   308,   309,   830,   310,   311,   831,   312,
     832,   314,   315,     0,   833,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   834,   835,   334,   335,     0,   336,   836,   338,
     837,   838,   839,   339,   340,   840,   341,   342,     0,   343,
     344,     0,   655,   345,   841,   842,   843,   844,     0,     0,
       0,     0,     0,   350,     0,   351,   845,   846,   847,   353,
     354,   355,     0,   848,   356,   357,   849,     0,   358,     0,
       0,   850,   851,   359,     0,     0,   360,     0,   361,     0,
     852,   363,     0,     0,   853,   854,   855,   856,   857,   364,
       0,     0,   365,   858,     0,   366,   367,   859,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   860,     0,   861,
       0,     0,     0,     0,   862,     0,     0,     0,   863,   864,
       0,     0,     0,     0,   865,     0,   866,  1660,     0,   867,
     868,     0,   869,   870,   122,     0,   726,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   727,
       0,   728,   130,   131,   729,   133,     0,   134,   730,   135,
       0,   731,   136,   732,   733,   734,   137,   735,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   736,
     144,     0,   145,   737,   738,   147,     0,   148,   149,   150,
     739,   151,     0,   740,   153,     0,   154,   155,   156,   157,
     158,   741,   742,   159,     0,   160,   161,     0,   743,     0,
     744,   745,   746,     0,     0,   163,   747,   748,     0,   749,
     750,     0,   164,   165,   751,   752,   753,     0,     0,     0,
       0,   754,   168,   755,     0,     0,   756,   757,   169,     0,
     170,     0,     0,     0,   758,   759,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   760,   179,     0,   761,   762,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   763,     0,
     188,   764,   189,   765,   766,   190,     0,   767,   191,   192,
     193,   768,     0,   194,     0,     0,   769,     0,   195,   196,
       0,   770,   197,     0,   198,   771,   772,   773,   774,     0,
     775,   776,   200,   777,   778,   779,   202,     0,   203,   780,
       0,   781,   782,     0,   204,   205,     0,   206,   783,     0,
     207,     0,     0,     0,   784,   209,   210,   211,   785,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   786,   215,
     787,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   788,   220,     0,     0,   789,
     221,     0,   790,   222,     0,     0,     0,   791,     0,   792,
       0,   224,   793,     0,   225,     0,   226,   794,     0,     0,
     795,     0,     0,     0,     0,   796,   227,   228,   229,   230,
     231,   232,   797,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   798,   242,   243,   244,   799,   245,   246,     0,
       0,     0,   247,   248,   800,   250,     0,     0,   801,   252,
     802,   803,   253,     0,   254,   804,   805,   806,   807,   808,
     809,   810,   259,   260,   261,   262,     0,   811,   263,   264,
       0,   265,   266,   267,   812,   813,   814,   268,     0,   815,
     816,     0,   269,   270,     0,   817,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   818,   819,   278,   820,   821,   822,   823,   824,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   825,
     287,   288,   289,   290,   291,   292,   293,   826,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   827,   828,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   829,   308,   309,   830,   310,
     311,   831,   312,   832,   314,   315,     0,   833,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   834,   835,   334,   335,     0,
     336,   836,   338,   837,   838,   839,   339,   340,   840,   341,
     342,     0,   343,   344,     0,   655,   345,   841,   842,   843,
     844,     0,     0,     0,     0,     0,   350,     0,   351,   845,
     846,   847,   353,   354,   355,     0,   848,   356,   357,   849,
       0,   358,     0,     0,   850,   851,   359,     0,     0,   360,
       0,   361,     0,   852,   363,     0,     0,   853,   854,   855,
     856,   857,   364,     0,     0,   365,   858,     0,   366,   367,
     859,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     860,     0,   861,     0,     0,     0,     0,   862,     0,     0,
       0,   863,   864,     0,     0,     0,     0,   865,     0,   866,
    1697,     0,   867,   868,     0,   869,   870,   122,     0,   726,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   727,     0,   728,   130,   131,   729,   133,     0,
     134,   730,   135,     0,   731,   136,   732,   733,   734,   137,
     735,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   736,   144,     0,   145,   737,   738,   147,     0,
     148,   149,   150,   739,   151,     0,   740,   153,     0,   154,
     155,   156,   157,   158,   741,   742,   159,     0,   160,   161,
       0,   743,     0,   744,   745,   746,     0,     0,   163,   747,
     748,     0,   749,   750,     0,   164,   165,   751,   752,   753,
       0,     0,     0,     0,   754,   168,   755,     0,     0,   756,
     757,   169,     0,   170,     0,     0,     0,   758,   759,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   760,   179,     0,   761,   762,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   763,     0,   188,   764,   189,   765,   766,   190,     0,
     767,   191,   192,   193,   768,     0,   194,     0,     0,   769,
       0,   195,   196,     0,   770,   197,     0,   198,   771,   772,
     773,   774,     0,   775,   776,   200,   777,   778,   779,   202,
       0,   203,   780,     0,   781,   782,     0,   204,   205,     0,
     206,   783,     0,   207,     0,     0,     0,   784,   209,   210,
     211,   785,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   786,   215,   787,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   788,   220,
       0,     0,   789,   221,     0,   790,   222,     0,     0,     0,
     791,     0,   792,     0,   224,   793,     0,   225,     0,   226,
     794,     0,     0,   795,     0,     0,     0,     0,   796,   227,
     228,   229,   230,   231,   232,   797,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   798,   242,   243,   244,   799,
     245,   246,     0,     0,     0,   247,   248,   800,   250,     0,
       0,   801,   252,   802,   803,   253,     0,   254,   804,   805,
     806,   807,   808,   809,   810,   259,   260,   261,   262,     0,
     811,   263,   264,     0,   265,   266,   267,   812,   813,   814,
     268,     0,   815,   816,     0,   269,   270,     0,   817,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   818,   819,   278,   820,   821,
     822,   823,   824,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   825,   287,   288,   289,   290,   291,   292,   293,
     826,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   827,   828,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   829,   308,
     309,   830,   310,   311,   831,   312,   832,   314,   315,     0,
     833,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   834,   835,
     334,   335,     0,   336,   836,   338,   837,   838,   839,   339,
     340,   840,   341,   342,     0,   343,   344,     0,   655,   345,
     841,   842,   843,   844,     0,     0,     0,     0,     0,   350,
       0,   351,   845,   846,   847,   353,   354,   355,     0,   848,
     356,   357,   849,     0,   358,     0,     0,   850,   851,   359,
       0,     0,   360,     0,   361,     0,   852,   363,     0,     0,
     853,   854,   855,   856,   857,   364,     0,     0,   365,   858,
       0,   366,   367,   859,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   860,     0,   861,     0,     0,     0,     0,
     862,     0,     0,     0,   863,   864,     0,     0,     0,     0,
     865,     0,   866,  1724,     0,   867,   868,     0,   869,   870,
     122,     0,   726,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   727,     0,   728,   130,   131,
     729,   133,     0,   134,   730,   135,     0,   731,   136,   732,
     733,   734,   137,   735,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   736,   144,     0,   145,   737,
     738,   147,     0,   148,   149,   150,   739,   151,     0,   740,
     153,     0,   154,   155,   156,   157,   158,   741,   742,   159,
       0,   160,   161,     0,   743,     0,   744,   745,   746,     0,
       0,   163,   747,   748,     0,   749,   750,     0,   164,   165,
     751,   752,   753,     0,     0,     0,     0,   754,   168,   755,
       0,     0,   756,   757,   169,     0,   170,     0,     0,     0,
     758,   759,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   760,   179,
       0,   761,   762,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   763,     0,   188,   764,   189,   765,
     766,   190,     0,   767,   191,   192,   193,   768,     0,   194,
       0,     0,   769,     0,   195,   196,  2161,   770,   197,     0,
     198,   771,   772,   773,   774,     0,   775,   776,   200,   777,
     778,   779,   202,     0,   203,   780,     0,   781,   782,     0,
     204,   205,     0,   206,   783,     0,   207,     0,     0,     0,
     784,   209,   210,   211,   785,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   786,   215,   787,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   788,   220,     0,     0,   789,   221,     0,   790,   222,
       0,     0,     0,   791,     0,   792,     0,   224,   793,     0,
     225,     0,   226,   794,     0,     0,   795,     0,     0,     0,
       0,   796,   227,   228,   229,   230,   231,   232,   797,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   798,   242,
     243,   244,   799,   245,   246,     0,     0,     0,   247,   248,
     800,   250,     0,     0,   801,   252,   802,   803,   253,     0,
     254,   804,   805,   806,   807,   808,   809,   810,   259,   260,
     261,   262,     0,   811,   263,   264,     0,   265,   266,   267,
     812,   813,   814,   268,     0,   815,   816,     0,   269,   270,
       0,   817,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   818,   819,
     278,   820,   821,   822,   823,   824,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   825,   287,   288,   289,   290,
     291,   292,   293,   826,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   827,
     828,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   829,   308,   309,   830,   310,   311,   831,   312,   832,
     314,   315,     0,   833,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   834,   835,   334,   335,     0,   336,   836,   338,   837,
     838,   839,   339,   340,   840,   341,   342,     0,   343,   344,
       0,   655,   345,   841,   842,   843,   844,     0,     0,     0,
       0,     0,   350,     0,   351,   845,   846,   847,   353,   354,
     355,     0,   848,   356,   357,   849,     0,   358,     0,     0,
     850,   851,   359,     0,     0,   360,     0,   361,     0,   852,
     363,     0,     0,   853,   854,   855,   856,   857,   364,     0,
       0,   365,   858,     0,   366,   367,   859,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   860,     0,   861,     0,
       0,     0,     0,   862,     0,     0,     0,   863,   864,     0,
       0,     0,     0,   865,     0,   866,     0,     0,   867,   868,
       0,   869,   870,   122,     0,   726,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   727,     0,
     728,   130,   131,   729,   133,     0,   134,   730,   135,     0,
     731,   136,   732,   733,   734,   137,   735,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   736,   144,
       0,   145,   737,   738,   147,     0,   148,   149,   150,   739,
     151,     0,   740,   153,     0,   154,   155,   156,   157,   158,
     741,   742,   159,     0,   160,   161,     0,   743,     0,   744,
     745,   746,     0,     0,   163,   747,   748,     0,   749,   750,
       0,   164,   165,   751,   752,   753,     0,     0,     0,     0,
     754,   168,   755,     0,     0,   756,   757,   169,     0,   170,
       0,     0,     0,   758,   759,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   760,   179,     0,   761,   762,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   763,     0,   188,
     764,   189,   765,   766,   190,     0,   767,   191,   192,   193,
     768,     0,   194,     0,     0,   769,     0,   195,   196,  2163,
     770,   197,     0,   198,   771,   772,   773,   774,     0,   775,
     776,   200,   777,   778,   779,   202,     0,   203,   780,     0,
     781,   782,     0,   204,   205,     0,   206,   783,     0,   207,
       0,     0,     0,   784,   209,   210,   211,   785,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   786,   215,   787,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   788,   220,     0,     0,   789,   221,
       0,   790,   222,     0,     0,     0,   791,     0,   792,     0,
     224,   793,     0,   225,     0,   226,   794,     0,     0,   795,
       0,     0,     0,     0,   796,   227,   228,   229,   230,   231,
     232,   797,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   798,   242,   243,   244,   799,   245,   246,     0,     0,
       0,   247,   248,   800,   250,     0,     0,   801,   252,   802,
     803,   253,     0,   254,   804,   805,   806,   807,   808,   809,
     810,   259,   260,   261,   262,     0,   811,   263,   264,     0,
     265,   266,   267,   812,   813,   814,   268,     0,   815,   816,
       0,   269,   270,     0,   817,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   818,   819,   278,   820,   821,   822,   823,   824,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   825,   287,
     288,   289,   290,   291,   292,   293,   826,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   827,   828,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   829,   308,   309,   830,   310,   311,
     831,   312,   832,   314,   315,     0,   833,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   834,   835,   334,   335,     0,   336,
     836,   338,   837,   838,   839,   339,   340,   840,   341,   342,
       0,   343,   344,     0,   655,   345,   841,   842,   843,   844,
       0,     0,     0,     0,     0,   350,     0,   351,   845,   846,
     847,   353,   354,   355,     0,   848,   356,   357,   849,     0,
     358,     0,     0,   850,   851,   359,     0,     0,   360,     0,
     361,     0,   852,   363,     0,     0,   853,   854,   855,   856,
     857,   364,     0,     0,   365,   858,     0,   366,   367,   859,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   860,
       0,   861,     0,     0,     0,     0,   862,     0,     0,     0,
     863,   864,     0,     0,     0,     0,   865,     0,   866,     0,
       0,   867,   868,     0,   869,   870,   122,     0,   726,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   727,     0,   728,   130,   131,   729,   133,     0,   134,
     730,   135,     0,   731,   136,   732,   733,   734,   137,   735,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   736,   144,     0,   145,   737,   738,   147,     0,   148,
     149,   150,   739,   151,     0,   740,   153,     0,   154,   155,
     156,   157,   158,   741,   742,   159,     0,   160,   161,     0,
     743,     0,   744,   745,   746,     0,     0,   163,   747,   748,
       0,   749,   750,     0,   164,   165,   751,   752,   753,     0,
       0,     0,     0,   754,   168,   755,     0,     0,   756,   757,
     169,     0,   170,     0,     0,     0,   758,   759,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   760,   179,     0,   761,   762,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     763,     0,   188,   764,   189,   765,   766,   190,     0,   767,
     191,   192,   193,   768,     0,   194,     0,     0,   769,     0,
     195,   196,  2165,   770,   197,     0,   198,   771,   772,   773,
     774,     0,   775,   776,   200,   777,   778,   779,   202,     0,
     203,   780,     0,   781,   782,     0,   204,   205,     0,   206,
     783,     0,   207,     0,     0,     0,   784,   209,   210,   211,
     785,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     786,   215,   787,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   788,   220,     0,
       0,   789,   221,     0,   790,   222,     0,     0,     0,   791,
       0,   792,     0,   224,   793,     0,   225,     0,   226,   794,
       0,     0,   795,     0,     0,     0,     0,   796,   227,   228,
     229,   230,   231,   232,   797,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   798,   242,   243,   244,   799,   245,
     246,     0,     0,     0,   247,   248,   800,   250,     0,     0,
     801,   252,   802,   803,   253,     0,   254,   804,   805,   806,
     807,   808,   809,   810,   259,   260,   261,   262,     0,   811,
     263,   264,     0,   265,   266,   267,   812,   813,   814,   268,
       0,   815,   816,     0,   269,   270,     0,   817,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   818,   819,   278,   820,   821,   822,
     823,   824,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   825,   287,   288,   289,   290,   291,   292,   293,   826,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   827,   828,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   829,   308,   309,
     830,   310,   311,   831,   312,   832,   314,   315,     0,   833,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   834,   835,   334,
     335,     0,   336,   836,   338,   837,   838,   839,   339,   340,
     840,   341,   342,     0,   343,   344,     0,   655,   345,   841,
     842,   843,   844,     0,     0,     0,     0,     0,   350,     0,
     351,   845,   846,   847,   353,   354,   355,     0,   848,   356,
     357,   849,     0,   358,     0,     0,   850,   851,   359,     0,
       0,   360,     0,   361,     0,   852,   363,     0,     0,   853,
     854,   855,   856,   857,   364,     0,     0,   365,   858,     0,
     366,   367,   859,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   860,     0,   861,     0,     0,     0,     0,   862,
       0,     0,     0,   863,   864,     0,     0,     0,     0,   865,
       0,   866,     0,     0,   867,   868,     0,   869,   870,   122,
       0,   726,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   727,     0,   728,   130,   131,   729,
     133,     0,   134,   730,   135,     0,   731,   136,   732,   733,
     734,   137,   735,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   736,   144,     0,   145,   737,   738,
     147,     0,   148,   149,   150,   739,   151,     0,   740,   153,
       0,   154,   155,   156,   157,   158,   741,   742,   159,     0,
     160,   161,     0,   743,     0,   744,   745,   746,     0,     0,
     163,   747,   748,     0,   749,   750,     0,   164,   165,   751,
     752,   753,     0,     0,     0,     0,   754,   168,   755,     0,
       0,   756,   757,   169,     0,   170,     0,     0,     0,   758,
     759,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   760,   179,     0,
     761,   762,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   763,     0,   188,   764,   189,   765,   766,
     190,     0,   767,   191,   192,   193,   768,     0,   194,     0,
       0,   769,     0,   195,   196,     0,   770,   197,     0,   198,
     771,   772,   773,   774,     0,   775,   776,   200,   777,   778,
     779,   202,     0,   203,   780,     0,   781,   782,     0,   204,
     205,     0,   206,   783,     0,   207,     0,     0,     0,   784,
     209,   210,   211,   785,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   786,   215,   787,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     788,   220,     0,     0,   789,   221,     0,   790,   222,     0,
       0,     0,   791,     0,   792,     0,   224,   793,     0,   225,
       0,   226,   794,     0,     0,   795,     0,     0,     0,     0,
     796,   227,   228,   229,   230,   231,   232,   797,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   798,   242,   243,
     244,   799,   245,   246,     0,     0,     0,   247,   248,   800,
     250,     0,     0,   801,   252,   802,   803,   253,     0,   254,
     804,   805,   806,   807,   808,   809,   810,   259,   260,   261,
     262,     0,   811,   263,   264,     0,   265,   266,   267,   812,
     813,   814,   268,     0,   815,   816,     0,   269,   270,     0,
     817,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   818,   819,   278,
     820,   821,   822,   823,   824,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   825,   287,   288,   289,   290,   291,
     292,   293,   826,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   827,   828,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     829,   308,   309,   830,   310,   311,   831,   312,   832,   314,
     315,     0,   833,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     834,   835,   334,   335,     0,   336,   836,   338,   837,   838,
     839,   339,   340,   840,   341,   342,     0,   343,   344,     0,
     655,   345,   841,   842,   843,   844,     0,     0,     0,     0,
       0,   350,     0,   351,   845,   846,   847,   353,   354,   355,
       0,   848,   356,   357,   849,     0,   358,     0,     0,   850,
     851,   359,     0,     0,   360,     0,   361,     0,   852,   363,
       0,     0,   853,   854,   855,   856,   857,   364,     0,     0,
     365,   858,     0,   366,   367,   859,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   860,     0,   861,     0,     0,
       0,     0,   862,     0,     0,     0,   863,   864,     0,     0,
       0,     0,   865,     0,   866,     0,     0,   867,   868,     0,
     869,   870,   122,     0,   726,   124,   125,   126,   127,  1756,
       0,     0,     0,     0,  1757,     0,     0,   727,     0,   728,
     130,   131,   729,   133,     0,   134,   730,   135,     0,   731,
     136,   732,   733,   734,   137,   735,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   736,   144,     0,
     145,   737,   738,   147,     0,   148,   149,   150,   739,   151,
       0,   740,   153,     0,   154,   155,   156,   157,   158,   741,
     742,   159,     0,   160,   161,     0,   743,     0,   744,   745,
     746,     0,     0,   163,   747,   748,     0,   749,   750,     0,
     164,   165,   751,   752,   753,     0,     0,     0,     0,   754,
     168,   755,     0,     0,   756,   757,   169,     0,   170,     0,
       0,     0,   758,   759,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     760,   179,     0,   761,   762,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   763,     0,   188,   764,
     189,   765,   766,   190,     0,   767,   191,   192,   193,   768,
       0,   194,     0,     0,   769,     0,   195,   196,     0,   770,
     197,     0,   198,   771,   772,   773,   774,     0,   775,   776,
     200,   777,   778,   779,   202,     0,   203,   780,     0,   781,
     782,     0,   204,   205,     0,   206,   783,     0,   207,     0,
       0,     0,   784,   209,   210,   211,   785,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   786,   215,   787,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   788,   220,     0,     0,   789,   221,     0,
     790,   222,     0,     0,     0,   791,     0,   792,     0,   224,
     793,     0,   225,     0,   226,   794,     0,     0,   795,     0,
       0,     0,     0,   796,   227,   228,   229,   230,   231,   232,
     797,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     798,   242,   243,   244,   799,   245,   246,     0,     0,     0,
     247,   248,   800,   250,     0,     0,   801,   252,   802,   803,
     253,     0,   254,   804,   805,   806,   807,   808,   809,   810,
     259,   260,   261,   262,     0,   811,   263,   264,     0,   265,
     266,   267,   812,     0,   814,   268,     0,   815,   816,     0,
     269,   270,     0,   817,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     818,   819,   278,   820,   821,   822,   823,   824,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   825,   287,   288,
     289,   290,   291,   292,   293,   826,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   827,   828,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   829,   308,   309,   830,   310,   311,   831,
     312,   832,   314,   315,     0,   833,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   834,   835,   334,   335,     0,   336,   836,
     338,   837,   838,   839,   339,   340,   840,   341,   342,     0,
     343,   344,     0,   655,   345,   841,   842,   843,   844,     0,
       0,     0,     0,     0,   350,     0,   351,   845,   846,   847,
     353,   354,   355,     0,   848,   356,   357,   849,     0,   358,
       0,     0,   850,   851,   359,     0,     0,   360,     0,   361,
       0,   852,   363,     0,     0,   853,   854,   855,   856,   857,
     364,     0,     0,   365,   858,     0,   366,   367,   859,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   860,     0,
     861,     0,     0,     0,     0,   862,     0,     0,     0,   863,
     864,     0,     0,     0,     0,   865,     0,   866,     0,     0,
     867,   868,     0,   869,   870,   122,     0,   726,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     727,     0,   728,   130,   131,   729,   133,     0,   134,   730,
     135,     0,   731,   136,   732,   733,   734,   137,   735,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     736,   144,     0,   145,   737,   738,   147,     0,   148,   149,
     150,   739,   151,     0,   740,   153,     0,   154,   155,   156,
     157,   158,   741,   742,   159,     0,   160,   161,     0,   743,
       0,   744,   745,   746,     0,     0,   163,   747,   748,     0,
     749,   750,     0,   164,   165,   751,   752,   753,     0,     0,
       0,     0,   754,   168,   755,     0,     0,   756,   757,   169,
       0,   170,     0,     0,     0,   758,   759,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   760,   179,     0,   761,   762,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   763,
       0,   188,   764,   189,   765,   766,   190,     0,   767,   191,
     192,   193,   768,     0,   194,     0,     0,   769,     0,   195,
     196,     0,   770,   197,     0,   198,   771,   772,   773,   774,
       0,   775,   776,   200,   777,   778,   779,   202,     0,   203,
     780,     0,   781,   782,     0,   204,   205,     0,   206,   783,
       0,   207,     0,     0,     0,   784,   209,   210,   211,   785,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   786,
     215,  2441,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   788,   220,     0,     0,
     789,   221,     0,   790,   222,     0,     0,     0,   791,     0,
     792,     0,   224,   793,     0,   225,     0,   226,   794,     0,
       0,   795,     0,     0,     0,     0,   796,   227,   228,   229,
     230,   231,   232,   797,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   798,   242,   243,   244,   799,   245,   246,
       0,     0,     0,   247,   248,   800,   250,     0,     0,   801,
     252,   802,   803,   253,     0,   254,   804,   805,   806,   807,
     808,   809,   810,   259,   260,   261,   262,     0,   811,   263,
     264,     0,   265,   266,   267,   812,   813,   814,   268,     0,
     815,   816,     0,   269,   270,     0,   817,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   818,   819,   278,   820,   821,   822,   823,
     824,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     825,   287,   288,   289,   290,   291,   292,   293,   826,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   827,   828,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   829,   308,   309,   830,
     310,   311,   831,   312,   832,   314,   315,     0,   833,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   834,   835,   334,   335,
       0,   336,   836,   338,   837,   838,   839,   339,   340,   840,
     341,   342,     0,   343,   344,     0,   655,   345,   841,   842,
     843,   844,     0,     0,     0,     0,     0,   350,     0,   351,
     845,   846,   847,   353,   354,   355,     0,   848,   356,   357,
     849,     0,   358,     0,     0,   850,   851,   359,     0,     0,
     360,     0,   361,     0,   852,   363,     0,     0,   853,   854,
     855,   856,   857,   364,     0,     0,   365,   858,     0,   366,
     367,   859,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   860,     0,   861,     0,     0,     0,     0,   862,     0,
       0,     0,   863,   864,     0,     0,     0,     0,   865,     0,
     866,     0,     0,   867,   868,     0,   869,   870,   122,     0,
     726,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   727,     0,   728,   130,   131,   729,   133,
       0,   134,   730,   135,     0,   731,   136,   732,   733,   734,
     137,   735,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   736,   144,     0,   145,   737,   738,   147,
       0,   148,   149,   150,   739,   151,     0,   740,   153,     0,
     154,   155,   156,   157,   158,   741,   742,   159,     0,   160,
     161,     0,   743,     0,   744,   745,   746,     0,     0,   163,
     747,   748,     0,   749,   750,     0,   164,   165,   751,   752,
     753,     0,     0,     0,     0,   754,   168,   755,     0,     0,
     756,   757,   169,     0,   170,     0,     0,     0,   758,   759,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   760,   179,     0,   761,
     762,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   763,     0,   188,   764,   189,   765,   766,   190,
       0,   767,   191,   192,   193,   768,     0,   194,     0,     0,
     769,     0,   195,   196,     0,   770,   197,     0,   198,   771,
     772,   773,   774,     0,   775,   776,   200,   777,   778,   779,
     202,     0,   203,   780,     0,   781,   782,     0,   204,   205,
       0,   206,   783,     0,   207,     0,     0,     0,   784,   209,
     210,   211,   785,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   786,   215,  2514,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   788,
     220,     0,     0,   789,   221,     0,   790,   222,     0,     0,
       0,   791,     0,   792,     0,   224,   793,     0,   225,     0,
     226,   794,     0,     0,   795,     0,     0,     0,     0,   796,
     227,   228,   229,   230,   231,   232,   797,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   798,   242,   243,   244,
     799,   245,   246,     0,     0,     0,   247,   248,   800,   250,
       0,     0,   801,   252,   802,   803,   253,     0,   254,   804,
     805,   806,   807,   808,   809,   810,   259,   260,   261,   262,
       0,   811,   263,   264,     0,   265,   266,   267,   812,   813,
     814,   268,     0,   815,   816,     0,   269,   270,     0,   817,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   818,   819,   278,   820,
     821,   822,   823,   824,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   825,   287,   288,   289,   290,   291,   292,
     293,   826,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   827,   828,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   829,
     308,   309,   830,   310,   311,   831,   312,   832,   314,   315,
       0,   833,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   834,
     835,   334,   335,     0,   336,   836,   338,   837,   838,   839,
     339,   340,   840,   341,   342,     0,   343,   344,     0,   655,
     345,   841,   842,   843,   844,     0,     0,     0,     0,     0,
     350,     0,   351,   845,   846,   847,   353,   354,   355,     0,
     848,   356,   357,   849,     0,   358,     0,     0,   850,   851,
     359,     0,     0,   360,     0,   361,     0,   852,   363,     0,
       0,   853,   854,   855,   856,   857,   364,     0,     0,   365,
     858,     0,   366,   367,   859,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   860,     0,   861,     0,     0,     0,
       0,   862,     0,     0,     0,   863,   864,     0,     0,     0,
       0,   865,     0,   866,     0,     0,   867,   868,     0,   869,
     870,   122,     0,   726,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   727,     0,   728,   130,
     131,   729,   133,     0,   134,   730,   135,     0,   731,   136,
     732,   733,   734,   137,   735,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   736,   144,     0,   145,
     737,   738,   147,     0,   148,   149,   150,   739,   151,     0,
     740,   153,     0,   154,   155,   156,   157,   158,   741,   742,
     159,     0,   160,   161,     0,   743,     0,   744,   745,   746,
       0,     0,   163,   747,   748,     0,   749,   750,     0,   164,
     165,   751,   752,   753,     0,     0,     0,     0,   754,   168,
     755,     0,     0,   756,  2863,   169,     0,   170,     0,     0,
       0,   758,   759,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   760,
     179,     0,   761,   762,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   763,     0,   188,   764,   189,
     765,   766,   190,     0,   767,   191,   192,   193,   768,     0,
     194,     0,     0,   769,     0,   195,   196,     0,   770,   197,
       0,   198,   771,   772,   773,   774,     0,   775,   776,   200,
     777,   778,   779,   202,     0,   203,   780,     0,   781,   782,
       0,   204,   205,     0,   206,   783,     0,   207,     0,     0,
       0,   784,   209,   210,   211,   785,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   786,   215,   787,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   788,   220,     0,     0,   789,   221,     0,   790,
     222,     0,     0,     0,   791,     0,   792,     0,   224,   793,
       0,   225,     0,   226,   794,     0,     0,   795,     0,     0,
       0,     0,   796,   227,   228,   229,   230,   231,   232,   797,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   798,
     242,   243,   244,   799,   245,   246,     0,     0,     0,   247,
     248,   800,   250,     0,     0,   801,   252,   802,   803,   253,
       0,   254,   804,   805,   806,   807,   808,   809,   810,   259,
     260,   261,   262,     0,   811,   263,   264,     0,   265,   266,
     267,   812,   813,   814,   268,     0,   815,   816,     0,   269,
     270,     0,   817,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   818,
     819,   278,   820,   821,   822,   823,   824,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   825,   287,   288,   289,
     290,   291,   292,   293,   826,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     827,   828,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   829,   308,   309,   830,   310,   311,   831,   312,
     832,   314,   315,     0,   833,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   834,   835,   334,   335,     0,   336,   836,   338,
     837,   838,   839,   339,   340,   840,   341,   342,     0,   343,
     344,     0,   655,   345,   841,   842,   843,   844,     0,     0,
       0,     0,     0,   350,     0,   351,   845,   846,   847,   353,
     354,   355,     0,   848,   356,   357,   849,     0,   358,     0,
       0,   850,   851,   359,     0,     0,   360,     0,   361,     0,
     852,   363,     0,     0,   853,   854,   855,   856,   857,   364,
       0,     0,   365,   858,     0,   366,   367,   859,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   860,     0,   861,
       0,     0,     0,     0,   862,     0,     0,     0,   863,   864,
       0,     0,     0,     0,   865,     0,   866,     0,     0,   867,
     868,     0,   869,   870,   122,     0,   726,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   727,
       0,   728,   130,   131,   729,   133,     0,   134,   730,   135,
       0,   731,   136,   732,   733,   734,   137,   735,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   736,
     144,     0,   145,   737,   738,   147,     0,   148,   149,   150,
     739,   151,     0,   740,   153,     0,   154,   155,   156,   157,
     158,   741,   742,   159,     0,   160,   161,     0,   743,     0,
     744,   745,   746,     0,     0,   163,   747,   748,     0,   749,
     750,     0,   164,   165,   751,   752,   753,     0,     0,     0,
       0,   754,   168,   755,     0,     0,   756,   757,   169,     0,
     170,     0,     0,     0,   758,   759,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   760,   179,     0,   761,   762,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   763,     0,
     188,   764,   189,   765,   766,   190,     0,   767,   191,   192,
     193,   768,     0,   194,     0,     0,   769,     0,   195,   196,
       0,   770,   197,     0,   198,   771,   772,   773,   774,     0,
     775,   776,   200,   777,   778,   779,   202,     0,   203,   780,
       0,   781,   782,     0,   204,   205,     0,   206,   783,     0,
     207,     0,     0,     0,   784,   209,   210,   211,   785,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   786,   215,
     787,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   788,   220,     0,     0,   789,
     221,     0,   790,   222,     0,     0,     0,   791,     0,   792,
       0,   224,   793,     0,   225,     0,   226,   794,     0,     0,
     795,     0,     0,     0,     0,   796,   227,   228,   229,   230,
     231,   232,   797,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   798,   242,   243,   244,   799,   245,   246,     0,
       0,     0,   247,   248,   800,   250,     0,     0,   801,   252,
     802,   803,   253,     0,   254,   804,   805,   806,   807,   808,
     809,   810,   259,   260,   261,   262,     0,   811,   263,   264,
       0,   265,   266,   267,   812,     0,   814,   268,     0,   815,
     816,     0,   269,   270,     0,   817,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   818,   819,   278,   820,   821,   822,   823,   824,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   825,
     287,   288,   289,   290,   291,   292,   293,   826,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   827,   828,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   829,   308,   309,   830,   310,
     311,   831,   312,   832,   314,   315,     0,   833,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   834,   835,   334,   335,     0,
     336,   836,   338,   837,   838,   839,   339,   340,   840,   341,
     342,     0,   343,   344,     0,   655,   345,   841,   842,   843,
     844,     0,     0,     0,     0,     0,   350,     0,   351,   845,
     846,   847,   353,   354,   355,     0,   848,   356,   357,   849,
       0,   358,     0,     0,   850,   851,   359,     0,     0,   360,
       0,   361,     0,   852,   363,     0,     0,   853,   854,   855,
     856,   857,   364,     0,     0,   365,   858,     0,   366,   367,
     859,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     860,     0,   861,     0,     0,     0,     0,   862,     0,     0,
       0,   863,   864,     0,     0,     0,     0,   865,     0,   866,
       0,     0,   867,   868,     0,   869,   870,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
    1930,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,  1931,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,  1086,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,  1087,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,  2426,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,  1843,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,  1932,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,  1979,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
    1930,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,  1931,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,  1086,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,  1087,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,  1932,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,  1979,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,  1843,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,  2252,     0,   130,   131,   132,   133,   870,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,     0,     0,     0,     0,
       0,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,  3615,   128,     0,     0,   129,  3616,   870,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,   972,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   408,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,  1801,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   408,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,     0,     0,     0,     0,     0,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,  1978,     0,   128,
       0,     0,   129,     0,  1979,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,     0,     0,     0,     0,
       0,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,  3616,   870,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   408,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     462,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   408,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,   870,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,     0,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,  1979,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   547,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   548,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,  1743,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   547,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     548,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
    2292,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   547,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   548,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -186,  2886,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3458,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,     0,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3459,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3460,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3461,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3462,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -186,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3463,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -186,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3464,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,  -186,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,     0,     0,  3465,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
    3667,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  1586,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2278,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2567,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2891,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -186,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3458,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
    -201,     0,   179,     0,     0,     0,  -201,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3459,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3460,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3461,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3462,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -186,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3463,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -186,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3464,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,  -186,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,  -201,   122,  3465,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3458,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,  -222,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3459,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3460,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3461,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3462,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3463,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -186,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3464,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,  -222,     0,  -186,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,  -222,   122,  3465,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -186,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3458,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
    -219,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3459,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3460,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3461,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3462,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3463,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -186,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3464,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,  -219,     0,  -186,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,  -219,   122,
    3465,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3458,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,  3545,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3459,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3460,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3461,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3462,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -186,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3463,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -186,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3464,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -186,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,   122,  3465,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3458,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,  -224,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3459,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3460,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3461,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3462,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3463,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -186,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3464,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -186,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,     0,   122,  3465,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -186,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3458,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,  3592,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3459,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3460,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3461,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3462,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -186,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3463,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -186,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3464,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,  -186,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,     0,   122,  3465,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -186,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3458,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,  3633,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3459,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3460,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3461,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3462,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -186,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3463,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -186,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3464,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,  -186,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,     0,   122,  3465,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -186,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3458,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
    -205,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3459,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3460,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3461,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3462,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -186,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3463,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -186,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3464,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,  -186,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,     0,   122,
    3465,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -186,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3458,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,     0,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3459,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3460,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3461,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3462,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -186,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3463,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -186,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3464,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -186,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,   122,  3465,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -186,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3458,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,     0,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3459,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3460,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3461,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3462,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -186,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3463,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -186,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3464,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,  3548,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -186,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,     0,   122,  3465,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,  1596,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
    1597,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,  1598,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,  1599,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,   697,   698,     0,   268,     0,     0,  1600,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,  3655,
    3645,  3656,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,  1601,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,  2284,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,  2285,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,  1917,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     547,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,  1918,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   548,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,  2294,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
    2295,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,   547,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   548,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2284,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  2285,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   547,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   548,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,   701,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   547,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   548,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,   653,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,   654,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   655,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  2332,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   547,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   548,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,  2284,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   547,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   548,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   547,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     548,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,  2274,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   548,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,  3587,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,  3588,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,   720,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
    1082,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  1868,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,  1869,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
    1985,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   548,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  1868,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,  1381,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,  1382,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,     0,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,     0,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,     0,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,     0,     0,   302,     0,     0,
     304,     0,     0,   306,   307,     0,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
       0,     0,     0,     0,   372
};

static const short int yycheck[] =
{
       7,   457,   437,   487,   708,   709,   710,   753,   958,   588,
    1011,   668,    19,   613,  1189,    22,   731,   747,   748,   749,
    1279,   512,    29,   611,  1279,  1153,   634,  1737,  1819,  1921,
    1061,   813,    39,  1899,   634,  1155,  1156,  1157,  1300,   412,
    1497,  1907,    49,  1909,    22,  1307,  1878,   635,  1168,  2309,
    1847,  2026,  2044,  1510,  1361,   564,   449,   450,   451,  2051,
     453,  1187,   455,   483,   484,  1906,  1181,  2259,  1582,  1296,
    1243,  1862,  1075,  1463,  1160,  1161,  2653,  1163,  2668,   570,
      87,  1885,  1886,  2645,   814,  1871,  1872,  1873,  1318,  1319,
      16,    16,     3,   513,  2698,   841,   496,  2701,   844,  1936,
     107,   108,  1222,   110,   444,  1225,  1221,    18,  1940,    87,
     840,    32,  1198,     3,   121,     3,  2720,   108,     3,   110,
       3,     3,  2726,   853,   854,   855,    48,  1213,  1960,  1961,
    1026,     3,     3,  1253,  1254,    54,    55,  1310,  1258,  1312,
      10,  1037,  1038,   121,    92,  1231,  1232,  1233,   863,   864,
     865,    58,     3,    20,    18,  2759,  1242,    55,  1278,    18,
    1280,    16,   582,   153,    27,    16,    18,  1417,   883,   127,
    1905,   672,   132,   672,    68,  1585,    57,  1930,    20,  1587,
      20,    28,   171,  1936,    59,   676,  1939,    54,    55,  1942,
      32,    53,    32,   165,    62,   171,    34,  2023,  1148,  1477,
    1953,  1954,    34,    45,    11,    45,   225,   168,   112,  1962,
     213,  2252,    54,    55,    54,    55,    11,    48,   636,  2353,
     108,  1079,  2019,   340,  1931,  1932,   142,    57,    20,   232,
     171,   142,  2930,   126,   247,   575,    32,   108,   210,   612,
      32,   225,    76,   108,   201,   283,   112,   317,   187,  3378,
     110,   153,   168,    45,  2923,   210,   261,   230,   294,   679,
     318,   397,    54,    55,   142,    51,    32,   337,     8,   257,
      12,    91,   433,    62,   420,   668,    74,   389,   142,    12,
     153,    34,   555,   142,    91,   166,   476,    58,   403,    55,
     142,   153,    93,   109,   156,   110,   109,   328,   318,   337,
     247,   420,   104,   388,  2246,  3467,   168,   213,   144,   283,
    2872,    12,   171,   252,   109,   219,   281,   252,    43,   453,
     476,   228,   536,   389,     4,   517,   331,  2929,    94,     9,
      10,    97,   345,   230,   171,   123,   166,   455,   210,   105,
     200,   475,    94,    12,    97,    97,   243,    27,   509,   354,
    2954,   104,    32,   210,   336,   175,    36,   247,   389,  2963,
     162,   199,   247,   337,   247,   247,   451,   199,   175,  2971,
     562,   353,   416,   171,    57,   493,   566,  1891,    65,   652,
     122,   493,   372,   544,    86,    37,  2328,    60,   225,   122,
      19,   398,  1049,   877,   329,   314,    63,   199,   345,   338,
     264,   408,   155,   210,   264,   412,   562,   264,   224,   162,
     417,   224,   213,  3082,   560,   422,   263,   324,   476,  1547,
     160,   122,  3551,    57,  1552,   246,   562,  1015,   494,   402,
    1558,   293,    66,  1561,   353,  1023,   116,   444,   474,   417,
     395,   560,   500,  3020,    78,   560,   199,   517,  1858,   264,
     567,  1039,  1040,   122,   461,   345,   476,   228,  1204,   261,
     345,  1061,   420,   499,   471,   330,   264,   455,   475,  2361,
     372,   196,   104,  1593,   481,  2316,   483,   484,   225,   401,
     500,   488,   489,   364,   113,   281,   425,  3649,   908,   998,
     503,   498,   497,   471,   476,   502,   366,   890,   455,   372,
     507,   508,   560,   510,   511,   512,   513,  2293,   261,   406,
     372,   427,  3074,  2350,  2028,   372,   380,   508,   306,   510,
     511,  1978,   560,   395,  2658,  1016,  1272,  2364,  1531,   331,
     162,   200,   166,   426,   364,  3112,  1394,   371,  2324,   546,
     174,   961,   328,   562,   516,   452,   366,   394,  2589,   427,
      48,   971,   347,   319,  1674,   562,   463,   560,  1678,   366,
     435,  1457,  2019,   570,   571,   318,   550,  1068,   575,  1068,
     401,  1080,   562,   562,   327,   582,  3274,   330,   331,   213,
     450,   529,  2317,  2318,   562,   561,   546,   455,  1847,   962,
    1763,  1711,  1847,   571,  1309,  1768,  1769,  2350,   232,  1774,
     561,  1776,   560,  1003,   498,   612,   564,   511,  2434,   949,
    1325,  2364,  1738,   515,  1864,  2025,  2876,  1035,   488,  2027,
    1898,   562,   485,   504,   550,   550,  1127,   525,  1127,   261,
     485,   538,   972,   485,  1760,   502,  1351,  1072,   476,   560,
     562,  2348,   515,   533,   476,   511,   102,   566,   533,  1908,
     533,   533,   472,  1908,  1740,  2847,  1049,   568,   517,   529,
     502,   668,   502,  3332,   104,   472,   455,   433,   108,   676,
    3247,   472,   679,   537,   504,   682,   683,   567,   568,   346,
     568,   368,   567,   568,   535,   568,   568,   534,   528,   562,
     415,  3295,   463,  3297,   530,   497,   568,   568,   104,   331,
     562,   384,   104,   562,  1963,   683,   408,   380,  1963,   529,
     502,   718,   533,   720,   170,   481,  3306,   568,   334,   342,
     560,  3311,   162,   476,   404,   478,   478,   281,   481,   481,
     364,    28,   524,   525,   105,   435,   388,  3314,   491,   419,
     718,  1081,   720,   509,   497,   425,   264,   500,  2927,   205,
     402,  2265,  2266,   225,   168,  3015,   162,  1130,   104,   199,
     162,  3365,    85,  3367,    91,   445,   554,   555,   556,  2635,
     420,   423,    69,  2639,   246,   444,   445,   446,   447,   448,
     449,   155,   353,   470,  1912,  1178,   503,   420,   535,  2586,
     128,   460,   171,   199,  2635,   175,   155,  2583,  2639,   552,
     553,    12,   489,   550,   476,   439,  2597,    12,   455,    12,
     175,   420,   160,  1941,    63,  1943,   162,   371,  2655,  1303,
    1948,   261,  3399,   173,   380,  2230,  2231,  2232,  2058,  2059,
     328,   187,   420,   472,    38,  2621,  1964,   393,  1966,  1967,
    1968,   138,   256,   299,   561,   344,    85,   174,   347,     0,
     454,   307,   223,   199,   458,   261,  2261,  2262,  2263,   261,
       3,   868,   380,   870,  1452,   497,  1357,   423,  1456,  1262,
     504,  1459,  1460,  1266,  1482,   217,   318,  2945,  3440,   526,
    2948,   435,  1482,   225,  1885,  1886,   213,  3477,  1397,   237,
     562,   331,   215,    23,    67,   902,   252,   146,  1407,    23,
      24,   908,  2655,   401,   485,   476,    79,   230,  1399,  1400,
     560,   122,  2580,   385,   370,   261,   120,   122,  2308,   122,
     243,  1294,  1431,  2437,   902,   331,   420,   560,   426,   331,
      54,    55,    56,    63,  3113,  3114,  2109,    67,   945,    63,
     947,  2916,   949,    67,   323,   171,   562,  2751,  1368,  2211,
    2747,   560,    76,    49,   961,   962,   330,  2949,   325,   326,
    1910,    57,   418,  2049,   971,   972,   325,   326,  2054,    93,
    2197,   330,   560,    66,  1977,   982,   215,  1350,   108,  1488,
     328,   562,  2650,  2069,   108,   331,   366,   111,  2247,  1362,
    2076,   230,  2247,  1428,   317,  2110,  1892,  1004,  1005,  1006,
    1007,   366,   352,  3195,   243,  2091,  2092,  1014,   350,  1016,
     381,   349,  2098,  1004,  1005,  1022,   140,  1956,  3608,   537,
    2106,   247,   535,  1014,   435,  1032,   560,   373,  1006,  1007,
     376,  1022,   420,   567,   476,  1974,   442,    91,   426,  1548,
    1549,   318,  1551,    34,  1553,  1554,  1555,  1556,  1557,   562,
    1559,  1560,  1767,   217,  1032,  3461,  3462,   497,   500,  2145,
    2367,   225,   235,    53,    85,   362,   560,  2908,  2909,   425,
     564,  1078,   362,   166,  1081,   531,   487,   549,   317,  2205,
    2030,  3149,   142,   406,   434,   382,  2212,   543,   472,   213,
     461,   497,   472,   269,   270,   497,   220,   346,   337,   420,
    1078,   135,   232,   429,   430,   517,    97,   472,   560,  3084,
     407,   145,   439,   104,  2900,   567,   188,   491,   560,   567,
     213,   175,   410,  1130,  3384,  1132,  1133,  1134,   171,  1136,
    2644,   304,   491,   507,   522,   523,  2222,   460,  1145,   232,
    1147,     8,  1133,  1134,  3550,   472,   473,   225,   507,   561,
     494,   497,    12,    13,  3146,   328,   252,   454,  1136,   213,
      27,   213,   286,   153,   155,   485,   156,   406,   246,  3429,
     109,   162,   560,   517,  1181,    85,   300,   504,   168,   222,
     232,   470,    16,   472,    85,   473,   350,   514,  2593,  2646,
    2647,  2648,   552,   553,   215,   325,   326,   561,   562,   476,
     330,   522,   523,  1376,   209,  1378,   379,   337,   199,   230,
     386,   387,   284,   285,  1221,   472,   288,   289,  2675,   561,
    3017,   460,   243,   500,    84,   514,   514,   351,  3296,   353,
    3298,   532,  3098,   473,   364,    75,  1409,  1410,  1411,   560,
     532,   529,   213,   525,  1487,   546,   528,   325,   326,    89,
     374,   375,   112,   377,   546,   209,  1499,  1500,  2448,  1502,
    1503,  1504,  2452,  1656,  1507,   222,   126,    54,    55,  1512,
     261,   364,  1279,  1516,  1517,  1518,    63,   450,  1521,  1522,
    1523,  1524,  1525,   560,  1527,  1528,  1529,  1294,   148,   413,
    2465,  2466,    23,    24,   424,  2557,   317,   535,  1498,   159,
     171,  1501,   345,   293,   470,   215,   472,   385,   362,   343,
    1510,   397,   366,   399,   215,   401,   337,   403,  2687,  1519,
     230,  2690,  2691,    54,    55,    56,   340,   318,   188,   230,
    1723,  2590,    63,   243,   264,  2590,    67,   532,  2707,   330,
     331,    20,   243,  1350,   561,    76,   117,   567,  1355,    28,
    1357,   546,   142,   213,    33,  1362,  1865,    15,    16,   219,
     438,  1368,    93,  1370,   439,   440,   450,   442,  1375,  1376,
     494,  1378,   934,   560,   504,   937,   395,   108,   940,   503,
     111,   149,   372,  1390,  2643,   406,  1393,  3348,  2643,  3350,
     561,   562,  1399,  1400,  1401,  1402,   256,  1375,  1376,    11,
    1378,   517,  1409,  1410,  1411,   561,   562,   317,   337,   140,
    2669,   410,  1390,   365,  2669,  1393,   317,   342,  2200,   473,
    1427,    70,    71,  1401,  1402,   561,   562,   337,   514,  1436,
     201,  1409,  1410,  1411,   488,  1944,  1945,    67,   562,   460,
     337,   475,   450,   451,   470,   453,  1453,   455,   562,    79,
     210,  1458,   561,   562,    46,  2486,  1965,   171,  3249,   108,
     514,   561,   562,  1470,  2550,   257,   561,   562,    46,  1476,
     562,   549,   550,   561,   562,   529,   561,   562,   561,   562,
    1458,   130,   213,    54,    55,   476,   257,   478,   118,   220,
     481,  2681,   503,  2208,   561,   562,   406,   416,  1476,  1872,
     491,  1874,  1875,   554,  3503,   406,   497,   367,   337,   500,
     281,  1946,   161,   561,   562,   246,   257,  2221,   147,   561,
     562,   561,   562,   493,   384,  2715,  2716,   426,  1535,   560,
     390,   561,   562,  2723,   561,   562,   396,  1544,   247,   142,
    2730,   168,  3541,   561,   562,   561,   562,  1920,  1921,   455,
     460,   455,   142,   143,   281,   286,   470,   160,   257,   460,
     420,   552,   553,   561,   562,  1572,   455,    12,    13,   300,
       3,   431,   432,  1580,   561,   562,  1583,   180,  2753,  3411,
     139,  1572,  3581,  1956,    77,    18,   561,   562,   562,  3481,
     180,   194,  3302,   339,   365,   561,   562,  3596,   561,   562,
     371,  1974,  1580,   468,   194,   235,  3605,   467,   561,  3395,
     561,   562,  2871,   561,   562,   419,  2871,   561,   562,    51,
     351,   529,   353,  2943,  2944,   561,   562,   389,   399,  1320,
    1321,  1322,  1323,  1324,   237,   238,   226,   561,   562,    84,
    3639,  2961,  3641,   374,   375,   149,   377,  2967,   238,  2824,
     566,   511,    85,   513,   561,   562,   561,   562,   561,   562,
    1316,  1317,   265,  3434,   435,   561,   562,   112,   560,  2062,
    2990,  2044,   207,  2993,   304,   265,   562,  2070,  2051,   529,
    2259,   126,   413,   562,   455,   561,   562,   561,   562,   561,
     562,   560,  2300,   561,   562,   325,   326,   567,   328,   470,
    2300,   472,   560,   148,  1947,   561,   562,   561,   562,   142,
     561,   562,   561,   562,   159,  1958,   561,   562,   560,  2307,
     323,   540,   561,   562,   561,   562,   561,   562,   561,   562,
     560,   321,   165,   560,   383,   168,  3507,    23,    24,  1746,
     561,   562,   560,   188,   561,   562,   560,    23,    24,   379,
    2751,   560,  3523,  2244,  3525,  1318,  1319,   560,   191,   560,
     363,  2647,  2648,   494,   197,  2274,   560,  2853,   213,   560,
      56,   560,   503,   551,   219,  1263,  1264,   210,    54,    55,
      56,    67,   215,  3119,  3120,  2599,  2600,    63,   560,   222,
      76,    67,   557,  3564,   560,    13,  3567,   230,   562,  2290,
      76,  2569,  2570,   560,  3575,  2861,  2862,    93,   560,   560,
     243,   256,   560,   560,   247,   560,   560,    93,   560,  2192,
     450,   560,   108,   256,   560,   111,   560,   560,   560,   560,
     560,  3602,   108,   562,   560,   111,   560,   560,   560,   560,
    1847,   560,  3613,   560,   560,   560,   566,   560,   560,   560,
     560,   476,   560,  2362,   140,  3626,   560,   560,  1865,  1866,
    2369,   567,   560,   560,   140,  1872,    84,  1874,  1875,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,    46,  3653,  3654,   317,   560,  3657,   560,   560,   560,
     560,   560,   560,   560,   112,   560,   560,   560,  2613,   560,
     560,  1908,   535,   560,   337,   560,   560,   560,   126,   560,
     560,   281,   345,  1920,  1921,   560,   560,   560,   560,   560,
     560,   560,   367,  1930,   560,   560,   560,   213,   560,  1936,
     148,   562,  1939,   366,   220,  1942,   560,   213,   560,   384,
     560,   159,   560,   560,   220,   390,  1953,  1954,   470,  1956,
     560,   396,   560,  2903,   560,  1962,  1963,   252,   560,   560,
     560,   560,   560,   560,   560,  1972,   560,  1974,   281,   560,
     188,  1978,  1979,   406,   560,   420,   560,   560,  2398,   560,
     560,   560,   485,   560,   485,   225,   431,   432,  2361,   562,
     562,   476,   562,   426,  1972,   213,   562,   562,   562,   554,
     286,   219,   168,   510,   562,   355,   437,   560,   562,   561,
     286,  2018,  2019,   142,   300,   142,   142,     7,   142,   142,
     142,   142,   467,   142,   300,   142,   142,   460,   142,    19,
     142,   142,    22,   142,  2738,   142,   562,  2044,   256,    29,
    2018,   512,   561,    44,  2051,   175,   337,    63,    12,    39,
     561,   171,   476,   561,   122,     9,   561,  2064,   532,    49,
     246,   561,   561,   560,   553,   351,   511,   353,   513,  3328,
     503,   567,   562,   380,   533,   351,   214,   353,   188,   567,
     171,   561,   435,   516,   517,   426,   562,   562,   374,   375,
    3210,   377,   168,    44,   450,   450,   450,    87,   374,   375,
     533,   377,   535,  2110,   450,   450,  3234,  3235,  3236,  3237,
     419,    66,   485,   119,   471,   119,   231,   107,   108,   471,
     110,    44,   562,   231,   517,   567,   562,   413,   561,   562,
      18,   121,   561,   561,   561,   568,   562,   413,  3224,   561,
     561,   561,   561,   561,   561,   554,   562,   562,   562,   367,
     561,   561,   171,  2857,   562,   562,   561,   561,   560,   562,
     561,   567,   562,   562,   561,   561,   384,   562,   562,   427,
     562,   562,   390,   562,   561,   565,   562,   562,   396,   561,
    3439,   562,   562,   561,   561,  2192,   267,   268,   269,   270,
     271,   272,   560,   562,   275,   276,   277,   278,   279,   280,
     562,   282,   420,   562,   562,   256,   550,   567,   494,   476,
     485,   562,   561,   431,   432,   562,  2223,   503,   494,   561,
    2227,   561,  2229,  2230,  2231,  2232,   561,   503,   561,  2602,
     562,   561,   561,  2240,   561,   561,   561,  2244,   561,   561,
    2247,   562,   561,   561,   561,  2618,   562,   562,   562,   467,
     562,   561,   485,   561,  2261,  2262,  2263,   561,   485,   562,
     562,   561,  2240,   561,   537,   562,   562,  2274,  2847,   561,
     252,   560,   562,  2280,   561,  2282,   561,   561,   561,   561,
     560,   562,   561,  2290,   485,   562,   560,   342,   171,   567,
     171,   171,   222,   511,   171,   513,   567,   567,   227,   535,
     562,   348,   230,   230,   296,   386,   387,    93,    93,   560,
     232,   232,   567,   560,   476,   560,   345,   554,   561,   561,
     221,   331,   331,   561,   171,   171,   561,   561,   171,   331,
      98,    99,   100,   101,   102,   547,   138,   561,   561,   567,
    3599,   567,   567,  2350,  3599,   561,   561,   561,   554,   560,
     337,   210,   562,   561,  2361,   171,   511,  2364,   567,   225,
     244,  3620,    63,   269,   337,   230,   230,   562,   562,   232,
    3116,  3117,  3118,    18,   232,   337,  3033,  3636,    18,   561,
      18,  3636,   560,   223,   561,   247,   561,   561,   560,   560,
     223,  2398,   561,  2902,   561,   547,   129,   561,  2405,   562,
     561,  2408,   170,   561,   561,  2412,  2413,  3535,   398,  2416,
     561,   567,   561,   561,   561,   561,   561,   561,   408,  2426,
     562,   561,   412,   562,   561,   561,   561,   417,   561,  3159,
    2408,   562,   422,   561,   202,   203,   204,   205,   241,   420,
     191,   348,   567,   561,   428,   142,   230,   230,  2426,   562,
     108,   108,   361,   331,   444,   561,   561,   560,   562,   561,
     561,  2970,   561,   561,   561,   561,   561,   561,   561,   561,
     560,   461,   561,   561,   561,  3179,  3180,   561,   331,   562,
     562,   471,   561,  3140,   561,   475,   561,   561,   561,   560,
     562,   481,   562,   483,   484,   561,  3153,   561,   488,   489,
     561,   561,   561,   560,   562,   561,   422,   561,   498,   561,
     560,  2946,   502,  2886,   562,   561,   561,   507,   508,   562,
     510,   511,   512,   513,   561,   560,   562,   295,   560,   297,
     298,   299,   560,   560,   567,   561,   561,   561,   561,   307,
     331,    40,   371,   561,   561,   222,   561,   561,   561,   331,
    3059,   562,   535,   561,    44,   567,   546,   562,   197,   303,
     380,   476,   476,  3293,   230,   517,   560,   517,   168,   560,
     331,   560,   562,   331,   560,    32,  2949,   331,   511,   528,
     570,   571,   528,  2590,  2591,   575,  2593,   108,   560,   232,
    3434,   232,   582,   330,   535,  2602,  2969,   331,   561,   331,
     331,  2608,   370,  3307,   331,   331,   562,   496,   561,   303,
     151,  2618,   560,   232,   561,   476,  3195,  3461,  3462,  2626,
     562,   561,   612,   561,   561,   561,   476,   562,   562,   561,
     561,   476,    65,    16,   230,   561,  2643,   561,   517,   327,
    3033,   561,   561,   561,   561,   517,   168,   523,  2655,   417,
     418,   561,   331,   561,   511,  2662,   561,   561,  3502,  3503,
     562,   561,  2669,  3507,   561,   561,   561,   561,  2675,   561,
     561,   561,   331,   342,   472,   562,   561,  3186,   668,  3523,
     249,  3525,   270,    57,    57,   560,   676,   560,   342,   679,
     560,   366,   682,   683,   561,    44,    44,  3541,   135,    44,
     142,   561,   384,     5,   131,   561,  3550,   561,   342,  3366,
     561,   342,   561,   403,  3087,    44,    44,    44,   562,   561,
    3564,   562,   118,  3567,   561,   414,    16,   565,   718,   560,
     720,  3575,   532,   569,   274,   171,   532,  3581,   561,   142,
     222,   138,  2749,   568,   561,  3402,  3403,  3140,  3405,   562,
     209,     3,  3596,   547,   532,   106,   138,   263,  3602,   568,
    3153,  3605,   569,   531,   125,   210,    18,   548,   331,  3613,
     560,   568,   138,  3146,   542,   543,   547,   195,   138,   568,
     249,   548,  3626,   562,   426,   562,   394,   168,   168,  3446,
     168,  3448,  3449,   108,   547,  3639,   534,  3641,   523,   169,
    1793,  1562,  3529,   674,  3190,  3310,  3183,  3511,  3667,  3653,
    3654,  3630,  3638,  3657,  3561,  3520,  3561,  3527,  3016,  1068,
     392,  1127,  2745,  3111,  1531,  2019,  2675,  1981,  1934,  2662,
    1535,  1497,  2731,    85,  3138,  2932,  2978,  2698,  2969,  2663,
    2698,  2848,  2618,  3354,  3363,  3130,  3279,  3303,  3197,  1977,
    3153,  3555,  1140,  1046,  1465,  1123,  1842,  1401,  2240,   683,
    1824,   667,  1856,   456,  2871,   600,  3244,  1416,  3059,  2856,
    1313,  1315,  2857,  2052,  2633,  1218,  3353,  2213,   868,  2886,
     870,  3108,  2669,  3555,  3087,  1861,   949,   972,  1820,  2585,
     142,  1846,  2871,  2643,  3378,  2584,  1168,  3620,  3439,   446,
     503,   720,   437,  1367,  1145,  2575,  3510,  3341,   977,  3530,
    3636,  3409,   902,  2590,  2971,  2292,   168,  2626,   908,  3095,
    2927,  1393,  2897,   990,  1422,   429,  3232,   980,   583,  1132,
    3238,  2227,   430,  3055,   587,   942,   473,  2017,  2742,   191,
     716,  1289,  2949,    -1,  3013,   197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   945,    -1,   947,    -1,   949,
      -1,    -1,  2969,   215,    -1,    -1,    -1,    -1,    -1,    -1,
     222,   961,   962,  3366,    -1,    -1,    -1,    -1,   230,    -1,
      -1,   971,   972,    -1,    -1,    -1,    -1,  2994,    -1,  2996,
      -1,   243,   982,    -1,    -1,   247,    -1,    -1,    -1,  3006,
     990,    -1,    -1,    -1,   256,  3012,  3441,    -1,    -1,  3402,
    3403,    -1,  3405,    -1,  1004,  1005,  1006,  1007,    -1,    -1,
      -1,    -1,    -1,    -1,  1014,    -1,  1016,    -1,  3006,    -1,
      -1,    -1,  1022,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1032,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,  3446,    -1,  3448,  3449,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   317,    -1,  3551,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3087,    -1,    -1,    -1,    -1,   337,    -1,    -1,  1078,    -1,
      -1,  1081,    -1,   345,    -1,    -1,    -1,    -1,    -1,    -1,
    3107,    -1,    -1,    -1,    -1,    -1,  3113,  3114,  3481,    -1,
      -1,    -1,    -1,    -1,   366,    -1,     3,    -1,    -1,     6,
    3127,    -1,    -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    23,    24,    -1,  3146,
    1130,    -1,  1132,  1133,  1134,    -1,  1136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   406,  1145,    -1,  1147,  3642,    -1,
      -1,    -1,    -1,    -1,    -1,    52,    -1,    -1,    -1,    56,
      -1,    -1,    -1,    -1,   426,    -1,    -1,  3184,    -1,    -1,
      67,    -1,    -1,  3667,    -1,    -1,    -1,    -1,    -1,    76,
    3197,  1181,    -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    -1,   460,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,
      -1,  1221,    -1,   120,   121,    -1,    -1,    -1,    -1,   126,
      -1,    -1,    -1,  3616,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   503,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   517,    -1,    -1,    -1,    -1,
      -1,    -1,  3665,    -1,    -1,    -1,    -1,    -1,   165,    -1,
      -1,   533,    -1,   535,    -1,    -1,    -1,    -1,    -1,  1279,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3310,  1294,    -1,    -1,    -1,    -1,   561,
     562,    -1,    -1,    -1,    -1,    -1,   568,    -1,    -1,    -1,
      -1,  3328,  3329,    -1,   211,    -1,   213,    -1,    -1,    -1,
      -1,    -1,    -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3348,    -1,  3350,    -1,  3352,  3353,    -1,    -1,    -1,
      -1,  3329,    -1,    -1,    -1,    -1,    -1,  3364,    -1,    -1,
    1350,    -1,    -1,    -1,    -1,  1355,    -1,  1357,    -1,    -1,
      -1,    -1,  1362,    -1,    -1,    -1,    -1,    -1,  1368,    -1,
    1370,    -1,    -1,    -1,    -1,  1375,  1376,    -1,  1378,    -1,
      -1,    -1,    -1,  3400,    -1,    -1,    -1,    -1,    -1,   286,
    1390,    -1,    -1,  1393,    -1,    -1,    -1,    -1,    -1,  1399,
    1400,  1401,  1402,   300,    -1,    -1,    -1,    -1,   305,  1409,
    1410,  1411,    -1,    -1,    -1,    -1,    -1,  3434,    -1,    -1,
      -1,    -1,  3439,    -1,    -1,    -1,    -1,  1427,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1436,    -1,    -1,    -1,
      -1,  3458,    -1,    -1,  3461,  3462,  3463,    -1,   345,    -1,
      -1,    -1,    -1,  1453,   351,    -1,   353,    -1,  1458,    -1,
      -1,    -1,    -1,    -1,  3481,    -1,    -1,    -1,    -1,    -1,
    1470,    -1,    -1,    -1,    -1,  3492,  1476,   374,   375,    -1,
     377,    -1,    -1,    -1,    -1,  3502,  3503,    -1,    -1,    -1,
    3507,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3523,    -1,  3525,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3541,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3550,    -1,  1535,    -1,    -1,    -1,    -1,
    3557,    -1,    -1,    -1,  1544,    -1,    -1,  3564,    -1,  3566,
    3567,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3575,    -1,
      -1,    -1,    -1,    -1,  3581,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1572,    -1,    -1,    -1,    -1,    -1,    -1,  3596,
    1580,    -1,  3599,  1583,  3601,  3602,    -1,    -1,  3605,    -1,
    3607,    -1,    -1,    -1,    -1,    -1,  3613,   494,    -1,  3616,
      -1,    -1,    -1,  3620,    -1,    -1,   503,    -1,    -1,  3626,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3636,
      -1,    -1,  3639,    -1,  3641,  3642,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3653,  3654,    -1,    -1,
    3657,    -1,    -1,     3,    -1,    -1,    -1,    -1,    -1,    -1,
    3667,    -1,    -1,    13,    14,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   562,    26,    -1,    28,    -1,
      -1,   568,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    47,    -1,    -1,
      -1,    -1,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   103,    -1,    -1,  1746,    -1,    -1,    -1,
      -1,    -1,   112,   113,   114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   125,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    -1,    -1,   195,    -1,    -1,   198,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1847,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,
      -1,    -1,    -1,    -1,    -1,  1865,  1866,    -1,    -1,    -1,
      -1,    -1,  1872,   233,  1874,  1875,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   251,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1908,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1920,  1921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1930,    -1,    -1,    -1,    -1,    -1,  1936,    -1,    -1,  1939,
      -1,    -1,  1942,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1953,  1954,    -1,  1956,    -1,    -1,    -1,
      -1,    -1,  1962,  1963,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1972,    -1,  1974,    -1,    -1,    -1,  1978,  1979,
      -1,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2018,  2019,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,
      -1,   391,   392,    -1,    -1,   395,    -1,    -1,   398,    -1,
     400,    -1,    -1,    -1,  2044,   405,    -1,   407,    -1,    -1,
      -1,  2051,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
     420,   505,    -1,    -1,  2064,    -1,   426,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    13,    14,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   454,    -1,    26,    -1,   458,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2110,    -1,    -1,    -1,   558,    -1,    46,    47,    -1,    -1,
      -1,    -1,    52,    -1,    -1,    -1,    56,    57,    -1,    -1,
      -1,    -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,
      -1,   511,    -1,    -1,    84,    -1,   516,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,    -1,   539,
      -1,    -1,   112,   113,   114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2192,    -1,    -1,   125,   126,    -1,    -1,    -1,
     560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,
      -1,    -1,    -1,  2223,    -1,    -1,    -1,  2227,    -1,  2229,
    2230,  2231,  2232,    -1,   164,    -1,    -1,    -1,    -1,    -1,
    2240,    -1,   686,    -1,  2244,    -1,    -1,  2247,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,  2261,  2262,  2263,    -1,   195,    -1,    -1,   198,    -1,
      -1,    -1,    -1,    -1,  2274,    -1,    -1,    -1,    -1,    -1,
    2280,    -1,  2282,    -1,    -1,    -1,    -1,    -1,    -1,   219,
    2290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   233,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   251,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   787,    -1,    -1,    -1,    -1,    -1,    -1,
    2350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2361,    -1,    -1,  2364,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2398,    -1,
      -1,    -1,    -1,    -1,    -1,  2405,    -1,    -1,  2408,    -1,
      -1,   341,  2412,  2413,    -1,    -1,  2416,    -1,   862,    -1,
      -1,    -1,   866,    -1,    -1,    -1,  2426,    -1,    -1,    -1,
      -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,
      -1,   391,   392,    -1,    -1,   395,    -1,    -1,   398,    -1,
     400,    -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
     420,    -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   454,    -1,    -1,    -1,   458,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   990,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   999,    -1,    -1,    -1,    -1,
      -1,    -1,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,
      -1,   511,    -1,    -1,    -1,    -1,   516,    -1,    -1,    -1,
    2590,  2591,    -1,  2593,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2602,    -1,    -1,    -1,    -1,    -1,  2608,   539,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2618,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2626,    -1,    -1,    -1,
     560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2643,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2655,    -1,    -1,    -1,    -1,
      -1,    -1,  2662,    -1,    -1,    -1,    -1,    -1,    -1,  2669,
      -1,    -1,    -1,    -1,    -1,  2675,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1149,  1150,  1151,    -1,    -1,
      -1,    -1,    -1,    -1,  1158,  1159,    -1,    -1,  1162,    -1,
    1164,  1165,  1166,  1167,    -1,    -1,    -1,  1171,    -1,    -1,
    1174,  1175,    -1,  1177,    -1,  1179,  1180,    -1,  1182,  1183,
    1184,  1185,  1186,    -1,  1188,    -1,  1190,  1191,  1192,  2749,
    1194,  1195,  1196,  1197,    -1,  1199,  1200,    -1,  1202,    -1,
      -1,  1205,  1206,  1207,    -1,  1209,  1210,  1211,  1212,    -1,
    1214,  1215,  1216,  1217,    -1,    -1,    -1,    -1,    -1,  1223,
    1224,    -1,  1226,  1227,  1228,  1229,  1230,    -1,    -1,    -1,
      -1,  1235,    -1,  1237,  1238,  1239,  1240,  1241,    -1,    -1,
    1244,  1245,  1246,  1247,  1248,  1249,    -1,  1251,  1252,    -1,
      -1,  1255,  1256,  1257,    -1,  1259,    -1,  1261,    -1,    -1,
      -1,  1265,    -1,  1267,  1268,    -1,    -1,    -1,    -1,  1273,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1281,  1282,  1283,
      -1,    -1,    -1,    -1,    -1,    -1,  1290,    -1,  2848,  1293,
      31,    32,    -1,    -1,    -1,    -1,    37,    -1,    39,    40,
      41,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2871,    -1,    -1,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2886,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,
      -1,    -1,    -1,    94,    -1,    -1,    97,    -1,    54,    55,
      -1,    -1,    -1,    -1,   105,    -1,    -1,  2927,    64,    -1,
      66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   124,    -1,    -1,    -1,    83,    84,  2949,
      -1,    -1,  1396,    -1,    -1,    -1,    92,    -1,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2969,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     161,    -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2994,    -1,  2996,    -1,    -1,    -1,
      -1,   182,   183,   139,   140,    -1,  3006,    -1,   144,    -1,
      -1,    -1,  3012,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   173,    -1,   175,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,  3059,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,
      -1,    -1,    -1,    -1,    -1,    -1,   212,   213,   259,   260,
     216,   262,    -1,    -1,    -1,    -1,    -1,  3087,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,
      -1,    -1,  1546,    -1,    -1,    -1,    -1,  3107,    -1,   290,
     291,   292,    -1,  3113,  3114,    -1,   252,    -1,    -1,    -1,
      -1,   257,    -1,    -1,    -1,    -1,    -1,  3127,    -1,   310,
     311,   312,    -1,    -1,    -1,   316,    -1,    -1,   319,    -1,
      -1,    -1,    -1,    -1,    -1,   281,  3146,    -1,    -1,    -1,
      -1,   332,   333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   357,   313,   359,    -1,
      -1,    -1,    -1,    -1,  3184,    -1,   322,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3197,    -1,    -1,
     381,    -1,    -1,    -1,   340,    -1,    -1,     6,    -1,    -1,
      -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    23,    24,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   424,    -1,   426,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    52,    -1,   436,    -1,    56,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    -1,    -1,    -1,  1718,  1719,  1720,    76,    -1,    -1,
      -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,   425,
      -1,  1735,    -1,    -1,    93,    -1,   477,   478,    -1,   435,
     481,   482,   483,   484,    -1,    -1,    -1,    -1,    -1,   108,
    3310,    -1,   111,    -1,    -1,    -1,  1760,    -1,    -1,   455,
      -1,   120,    -1,   459,    -1,    -1,    -1,   126,  3328,  3329,
      -1,    -1,    -1,    -1,    -1,   134,   472,    -1,    -1,  1783,
      -1,   140,    -1,   524,   525,    -1,    -1,    -1,  3348,    -1,
    3350,    -1,  3352,  3353,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   543,    -1,  3364,    -1,   165,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     526,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,
    3400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3439,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3458,    -1,
      -1,    -1,    -1,  3463,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3481,    -1,    -1,    -1,    -1,    -1,   286,    -1,    -1,
      -1,    -1,  3492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   345,    -1,    -1,    -1,
      -1,    -1,   351,    -1,   353,    -1,    -1,  3557,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3566,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   374,   375,    -1,   377,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2031,    -1,    -1,
    2034,    -1,   391,  2037,  2038,    -1,    -1,    -1,    -1,  3599,
      -1,  3601,    -1,    -1,    -1,    -1,  2050,  3607,    -1,  2053,
      -1,    -1,    -1,    -1,   413,    -1,  3616,    -1,    -1,    -1,
    3620,    -1,  2066,    -1,  2068,    -1,    -1,    -1,  2072,    -1,
    2074,  2075,    -1,    -1,    -1,  2079,  3636,  2081,  2082,    -1,
    2084,    -1,  3642,  2087,    -1,  2089,  2090,    -1,    -1,    -1,
      -1,  2095,  2096,    -1,    -1,  2099,    -1,  2101,    -1,  2103,
      -1,  2105,    -1,  2107,    -1,    -1,    -1,  3667,    -1,    -1,
      -1,    -1,    -1,    -1,  2118,  2119,    -1,    -1,  2122,    -1,
    2124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2132,  2133,
      -1,  2135,    -1,  2137,    -1,   494,  2140,  2141,  2142,    -1,
    2144,    -1,    -1,    -1,   503,  2149,  2150,  2151,  2152,    -1,
      -1,    -1,    -1,  2157,  2158,  2159,    -1,  2161,    -1,  2163,
      -1,  2165,    -1,  2167,    -1,  2169,    -1,    -1,    -1,    -1,
      -1,    -1,  2176,    -1,  2178,    -1,    -1,  2181,  2182,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2193,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2283,
      -1,    -1,    -1,    -1,  2288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2524,    -1,  2526,    -1,  2528,    -1,    -1,    -1,    -1,    -1,
    2534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2559,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2627,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2772,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2782,    -1,
      -1,    -1,    -1,    -1,  2788,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2797,  2798,    -1,    -1,    -1,    -1,  2803,
      -1,    -1,    -1,  2807,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2820,    -1,    -1,    -1,
      -1,    -1,  2826,    -1,    -1,  2829,  2830,    -1,  2832,  2833,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2912,  2913,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2923,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3082,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3206,    -1,    -1,    -1,    -1,    -1,  3212,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3258,    -1,  3260,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3389,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3412,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3497,  3498,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3516,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3526,    -1,    -1,    -1,    -1,  3531,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3540,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3571,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,  3582,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    42,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,  3643,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,   239,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
     486,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,   337,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
     420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,   171,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,   171,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,   171,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,    -1,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,    -1,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,   174,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,   213,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,   232,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,   246,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,   439,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   567,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,   174,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,   213,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,   232,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,   439,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,   567,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   561,    -1,    23,    24,    25,    26,   567,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,   561,    17,    -1,    -1,    20,   566,   567,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,   222,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,   554,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,   560,    -1,    17,
      -1,    -1,    20,    -1,   567,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   566,   567,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,   567,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,   566,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
     566,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,   566,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,    -1,    -1,   548,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
     562,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
     132,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,   546,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,   532,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,   532,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,   546,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
     162,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,   261,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,   325,   326,    -1,   328,    -1,    -1,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,   441,
     442,   443,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,   497,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,   142,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,   427,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    88,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    32,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    80,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,   150,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,   171,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
     364,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    -1,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    -1,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,    -1,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,    -1,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   608,   771,   789,   792,   800,   802,   804,   807,
     812,   814,   819,   822,   827,   831,   839,   840,   989,   991,
     997,  1000,  1025,  1033,  1044,  1046,  1060,  1063,  1066,  1072,
    1076,  1080,  1083,  1084,  1130,  1147,  1153,  1155,  1162,  1164,
    1189,  1195,  1196,  1197,  1198,  1236,    11,    91,   175,   210,
     366,   785,  1217,  1218,   252,   329,   821,   470,   472,  1149,
    1190,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   596,  1120,  1124,  1128,  1129,   281,  1149,
    1149,   536,  1191,    91,   174,   439,   473,   504,   514,   594,
     688,   689,   690,   763,  1034,   990,    91,   175,   213,   366,
     473,   488,   514,   529,   996,  1124,   821,   595,   567,  1118,
    1119,  1124,   584,   998,  1081,    93,   213,   472,  1149,   821,
    1124,  1077,   416,   514,  1149,   821,  1001,  1073,  1149,   595,
    1191,  1124,   842,   844,   845,   342,  1132,  1047,   454,   458,
     435,   487,   435,   472,  1045,  1154,  1026,  1124,    28,    69,
     138,   362,   382,   407,   454,  1238,   420,   560,   841,     0,
       3,   362,   153,  1064,  1118,  1124,   142,   777,  1124,   596,
     596,   472,   109,  1214,  1149,   803,  1191,   828,   829,  1118,
     609,   567,   485,   805,   815,    16,  1192,   209,   691,   595,
     347,  1212,  1214,  1215,  1216,  1217,   472,   689,   213,   210,
     264,   372,  1042,  1043,   906,   907,   209,   995,   995,  1124,
     995,   995,   595,   995,  1149,   579,  1067,    12,    13,    84,
     112,   126,   148,   159,   188,   213,   219,   256,   367,   384,
     390,   396,   420,   431,   432,   467,   511,   513,  1165,  1167,
    1169,  1170,  1124,   340,    60,   380,   567,   245,   476,  1121,
    1124,  1126,   110,   200,   264,  1003,    76,   371,  1082,  1085,
     222,  1118,  1148,  1149,   171,    32,   281,  1052,  1078,  1124,
     595,   823,  1149,   110,   264,  1004,  1032,   281,   371,   435,
    1074,  1075,   801,    12,  1163,  1167,   485,  1192,   843,    12,
     122,   200,   444,   445,   446,   447,   448,   449,   460,   849,
     850,   851,  1131,    30,    33,    54,    55,    64,    66,    83,
      84,    92,   140,   144,   173,   175,   187,   189,   212,   213,
     216,   231,   252,   257,   281,   313,   322,   340,   365,   366,
     425,   435,   459,   472,   530,   736,   762,  1048,  1052,  1053,
    1055,  1138,   794,   795,   794,   794,   535,   793,   794,   994,
    1118,  1149,  1032,    34,   199,   476,  1106,  1122,  1237,  1237,
    1237,  1237,  1237,   844,   841,   561,  1124,  1062,  1061,   294,
     474,   499,   773,   775,   774,  1118,   142,   450,  1219,   813,
     993,   994,   225,   562,   835,   836,   560,   610,  1124,   586,
     993,   993,    51,   328,   328,   389,  1193,   325,   326,   878,
    1124,    88,  1126,  1127,  1180,  1181,   395,    10,   366,   488,
     703,  1213,  1219,  1220,  1228,  1230,  1214,  1217,   691,  1124,
     171,  1035,  1039,  1040,  1124,  1042,     7,    20,    22,    25,
      29,    32,    34,    35,    36,    38,    50,    54,    55,    61,
      64,    72,    73,    79,    81,    82,    83,    87,    88,    90,
      91,    95,    96,    97,   102,   104,   107,   108,   115,   116,
     133,   136,   137,   149,   152,   154,   155,   158,   162,   167,
     172,   176,   177,   178,   179,   181,   182,   184,   185,   186,
     190,   192,   193,   199,   205,   209,   219,   221,   236,   240,
     243,   248,   250,   253,   258,   261,   266,   273,   283,   287,
     295,   299,   301,   302,   306,   307,   308,   309,   310,   311,
     312,   318,   325,   326,   327,   330,   331,   336,   353,   354,
     356,   357,   358,   359,   360,   370,   378,   394,   395,   406,
     409,   412,   414,   418,   456,   457,   462,   464,   465,   466,
     469,   478,   479,   480,   481,   490,   491,   492,   497,   500,
     505,   506,   514,   518,   519,   520,   521,   522,   527,   531,
     541,   543,   548,   552,   553,   558,   560,   563,   564,   566,
     567,   860,   863,   866,   867,   868,   869,   870,   871,   872,
     873,   874,   875,   879,   882,   883,   885,   892,   896,   908,
    1105,  1107,  1109,  1110,  1114,  1116,  1120,  1122,  1124,   149,
    1124,   596,   337,   596,   596,  1127,  1179,   993,   995,   517,
     580,   117,   201,   257,   281,   365,   371,   399,   435,   455,
     470,  1068,  1069,  1149,   365,  1168,   410,   410,   473,   514,
     529,   342,  1172,   470,  1174,    59,   435,  1171,    92,   529,
    1173,   337,   562,    18,   142,   949,   950,  1156,  1124,   785,
     860,    74,   171,   264,  1086,  1092,    46,   171,  1118,  1150,
    1151,   820,   566,   577,  1121,   257,   824,  1127,   825,   826,
    1118,   808,   222,   994,  1005,  1006,    46,   562,   993,  1168,
     337,   416,  1194,  1193,   503,  1199,  1200,   554,   853,   854,
     855,   851,  1133,  1134,  1135,   257,   147,   426,   246,   533,
    1059,   493,   560,    91,   175,   366,   472,   529,  1059,   698,
    1126,   247,   968,   970,    62,   455,   168,   455,   455,   455,
     281,   470,    62,   455,   201,   455,   455,   493,   968,  1059,
     171,   225,  1056,   257,   139,    65,   368,   470,   489,   455,
     526,   791,   388,   451,   796,   797,   790,    77,   785,   562,
     339,  1240,   468,  1241,   230,   402,  1239,   561,  1200,  1202,
    1203,  1204,   839,  1065,  1106,  1124,   108,   685,   686,   687,
     696,   697,   745,   603,   603,   772,  1127,   419,   529,   993,
     485,   562,   108,   830,  1124,   829,   213,   232,   760,   761,
     837,   611,   612,   860,   267,   268,   269,   270,   271,   272,
     275,   276,   277,   278,   279,   280,   282,   386,   387,   587,
     588,   589,   153,   372,   806,    53,   153,   156,   168,   293,
     372,   816,   817,   818,    51,   389,   149,   593,   560,   859,
     566,   207,   562,   855,   855,   855,   529,  1220,  1118,   494,
     517,   764,  1039,  1118,  1124,   562,  1037,   567,  1041,   560,
     560,   560,   560,   560,   883,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   859,
     859,   560,   859,   560,   560,   560,   500,   560,  1105,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   860,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   909,
     910,   911,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   866,   560,   859,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     859,   560,  1105,   560,   560,   560,  1105,   560,   560,    34,
     199,   476,   560,   560,   560,   859,   859,   859,   560,   560,
     560,   560,   560,   560,   860,   913,   883,   883,   883,   420,
     560,   860,  1207,  1124,   897,  1124,   540,   861,   864,   142,
     143,   180,   194,   226,   238,   265,   321,   880,   225,   246,
     385,   438,   549,   550,   878,   551,   429,   430,   552,   553,
     123,   306,   554,   555,   556,   557,   883,    98,    99,   100,
     101,   102,   170,   202,   203,   204,   205,   295,   297,   298,
     299,   307,   370,   417,   418,   531,   542,   543,   946,   947,
      63,   346,   562,  1122,   560,   567,  1118,   562,    48,   401,
     786,   993,   566,   581,   582,    46,   535,   562,  1070,   470,
     560,  1182,  1182,  1182,  1182,   175,   366,   472,  1166,  1170,
    1124,   160,   323,  1124,  1157,  1158,  1005,   281,   252,  1091,
     832,   281,   950,   562,   993,  1126,    27,   485,  1079,   562,
     485,   562,   485,   993,  1006,  1002,  1075,   171,   562,   175,
     366,  1166,  1124,    12,   122,  1206,   562,   846,   857,   860,
    1112,  1124,   562,   187,   252,   338,   425,  1136,  1137,  1140,
    1141,   225,  1057,  1121,   860,   554,   691,   596,   596,  1118,
    1118,  1049,   261,   331,   497,   971,   972,  1107,   596,  1059,
    1127,   168,  1054,  1056,   596,  1059,  1054,  1118,  1056,  1054,
    1054,  1059,  1059,   510,   798,   562,   798,   437,   420,   560,
     564,   916,   917,   918,   919,   928,   929,   937,  1106,   355,
    1242,   345,   964,   970,  1205,   687,    63,   736,    67,    79,
     235,   304,   328,   379,   450,   605,   607,     6,    13,    23,
      24,    52,    56,    67,    76,    81,    93,   111,   120,   121,
     126,   134,   140,   165,   211,   213,   220,   286,   300,   305,
     345,   351,   353,   374,   375,   377,   391,   413,   494,   503,
     693,   695,   696,   697,   778,   779,   780,   960,   109,   224,
    1118,   816,  1121,   994,   560,   561,   562,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   562,   512,   817,   685,   561,  1126,    44,  1181,
     596,   596,   175,  1118,   591,    43,   196,   415,   765,   765,
     337,  1038,  1036,   567,  1040,   171,   554,  1124,   950,   860,
     860,   860,    12,   122,   902,   951,   104,   162,   199,   261,
     331,   497,   974,   902,   902,   902,   860,   860,   906,   906,
     860,   906,   860,   860,   860,   860,   122,   902,   951,   860,
     561,   860,   860,   860,   860,   860,  1114,  1124,   860,   860,
     860,   860,   860,   560,  1207,   860,   946,   860,   860,   860,
     561,   860,   860,   860,   860,   906,   860,   860,    94,    97,
     478,   481,   948,   860,   122,   899,  1105,   860,   860,   860,
     561,   860,   860,   860,   860,   906,   860,   860,   860,   860,
     910,     9,   912,  1114,   122,   902,   860,   860,   122,   902,
     860,   860,   860,   860,   860,   906,   906,   906,   860,   860,
     860,   860,   860,   860,   906,   870,   860,   561,   860,   860,
     860,   860,   860,   561,   860,   860,   902,   902,   860,   860,
     860,   122,   902,   860,   860,   947,   947,   860,    42,   239,
     486,   860,   860,  1105,   561,   860,   561,   902,  1115,  1116,
    1124,   902,   860,   860,   860,   532,   915,  1210,  1210,   561,
     562,   561,   860,   566,   898,  1126,   567,   863,   862,   865,
     869,   155,   330,   491,   507,   878,    12,    17,   869,   881,
     560,   883,   870,   246,   870,   871,   225,   246,   385,   549,
     872,   873,   873,   874,   882,   874,   882,   875,   875,   875,
     875,   875,   883,   553,  1126,   883,   860,   884,  1124,   992,
    1127,   786,  1126,   562,   380,  1069,   993,  1071,  1124,  1183,
    1184,   554,  1118,  1124,  1178,  1178,  1178,   142,   160,   180,
     194,   237,   238,   265,   323,   363,  1159,  1161,   533,   952,
     999,   214,   833,   834,  1118,   264,   380,   537,  1152,  1151,
     816,   860,  1121,  1127,  1127,   826,  1118,   153,   372,   515,
     809,   810,   811,   420,   426,   522,   523,   560,   681,  1007,
    1010,  1121,   188,  1178,  1178,  1178,  1201,   854,   171,   222,
     847,   848,   963,   964,   985,   856,   567,  1134,   108,   487,
    1124,  1143,   314,   353,   566,   736,  1142,  1121,   171,  1058,
     561,  1124,   257,   455,  1051,   334,   562,   435,  1059,  1124,
    1059,  1054,  1118,  1059,  1059,   589,   799,   797,   936,  1124,
      85,   215,   230,   243,   317,   406,   460,   927,   426,   562,
    1118,   936,   562,   168,  1243,    44,   968,   142,   427,  1016,
    1017,  1017,  1121,   450,   450,   450,   450,   450,   419,    66,
      78,   174,   439,   708,   711,   712,   758,   760,   784,   784,
    1017,  1017,   784,  1017,  1017,  1017,   485,   119,  1017,   231,
     471,   166,   364,   760,   784,   231,  1017,   471,   119,  1017,
    1017,  1017,   784,    44,  1017,  1017,  1017,  1017,  1017,    18,
     142,   485,   788,  1017,  1017,  1017,   693,   562,   560,   567,
     707,   713,  1117,  1124,   776,   364,   944,  1124,   860,   974,
    1121,  1121,   104,   162,   261,   331,   497,   975,  1121,   974,
    1121,  1121,  1121,  1121,  1121,   974,  1121,  1121,   974,   588,
     353,   476,  1232,     8,    27,   673,   596,  1221,   246,   560,
     675,   692,   694,   695,  1118,   517,   952,  1124,   917,   567,
    1041,   562,   561,   561,   562,   902,   561,   903,   562,   561,
     561,   561,    18,   561,   517,   561,   561,   561,   561,   562,
     562,   517,   562,   562,   893,   561,   554,   561,   562,   562,
     561,   561,   562,   561,   567,   561,   562,   561,   562,   562,
     562,   561,   562,   561,   562,   171,   562,   562,   561,   562,
     561,   562,   562,   561,   562,   561,   561,   562,   561,   562,
     562,   562,   895,   562,   561,   562,   562,   561,   562,   562,
     561,   562,   561,   562,   561,   562,   562,   562,   561,   560,
     562,   902,   561,   561,   561,   902,   561,   561,   562,   562,
     561,   561,   562,   561,   562,   561,   561,   561,   561,   561,
     561,   561,   562,   562,   561,   562,   561,   225,   561,   561,
     562,   562,   562,   561,   562,   562,   561,   561,   561,   562,
     171,   562,   562,   902,   561,   561,   561,   562,   562,   562,
     561,   171,   860,   171,   860,   171,   860,   171,   561,   562,
     562,   561,   561,   561,   561,   561,   562,   561,   562,   561,
     860,   532,   546,   914,   842,  1209,  1207,   906,   565,   187,
     252,   425,  1139,   427,  1124,   344,   347,   876,    15,    16,
     877,   155,   330,   491,   507,   560,   860,  1207,   146,   956,
     870,    16,   560,   883,   870,   870,   946,   946,   860,   887,
     888,   889,   560,   567,   582,   256,   561,   562,   567,   567,
     485,   485,   485,  1160,   953,   969,   970,  1007,   476,  1123,
     562,   835,   537,   252,   485,   810,   682,  1008,   560,  1013,
    1018,  1013,   561,   681,  1009,  1111,  1112,  1115,  1124,  1011,
     342,   171,   171,   171,   840,   127,   917,   986,   168,   256,
     852,   985,   969,   848,    18,   858,  1121,  1124,   554,  1124,
     567,   227,   567,  1016,    32,   108,   737,   738,  1016,  1126,
     168,  1016,   566,  1126,    32,   108,   740,   741,  1126,   975,
    1050,   144,   530,   972,   972,   535,   952,  1054,   562,   931,
     936,   916,   230,   230,   348,   938,   230,   243,   406,   938,
     928,   916,  1028,  1029,  1115,   916,   950,   933,   934,   974,
     296,   965,   108,   742,   744,  1126,   738,    93,    93,   109,
     224,   768,  1117,   761,   761,    57,   166,   364,   504,   710,
     759,   709,   710,   768,  1117,   975,   974,  1117,   974,  1121,
    1121,   736,  1017,   974,   232,   232,  1117,  1117,   698,  1017,
     160,   237,   328,   701,   975,   975,  1117,   961,   962,  1115,
     108,   974,  1121,   974,   974,   373,   376,   700,   974,  1118,
      70,    71,   108,   130,   161,   383,   699,   698,   560,   780,
     705,   706,   707,   708,  1124,     8,   160,   787,   384,   709,
     750,   714,   567,   560,  1222,   561,   562,   476,   560,   112,
     219,   511,   674,  1231,  1222,  1118,   246,   676,   681,   705,
     210,   395,   678,  1093,   562,   694,   592,   917,   963,   952,
     950,   221,   860,   860,   561,   860,   860,    32,    55,    94,
      97,   105,   319,   433,   481,   509,   904,   737,   906,   860,
     737,   904,   860,   906,   561,   882,   882,  1122,  1124,   860,
     860,   906,  1122,   860,   860,   860,   906,   331,   860,   860,
     860,   860,   860,   860,   860,   906,   906,   331,   860,   860,
     906,   860,   860,   860,   860,   906,   860,   870,  1114,   561,
     561,   860,   860,   860,   860,   860,   860,   860,   860,   860,
     860,   860,   860,   906,   221,   860,   860,   860,   860,   561,
     860,   860,   860,   860,   171,   860,   171,   860,   171,   860,
     860,   331,   860,   860,   547,   860,   860,   138,  1211,   561,
     561,   567,   567,   567,  1126,   860,   863,   866,  1207,   561,
     562,   561,   883,   869,   860,  1207,   956,    16,   561,   855,
     890,   891,   905,   906,  1124,  1184,   554,   554,  1180,  1180,
    1180,   560,   860,   337,  1023,  1087,   834,   210,   838,  1127,
     849,  1014,  1015,  1115,  1019,   562,   560,  1010,   561,   561,
     562,   567,  1199,   171,  1180,  1180,  1180,   952,   952,   128,
     349,   981,   982,   987,   511,   225,  1121,  1124,   567,  1124,
     244,  1124,    12,    32,   108,   337,   860,  1146,    63,   743,
     860,  1127,   336,   353,   476,  1145,  1139,  1016,   968,   269,
    1059,   589,  1202,   932,   243,   230,   928,   938,   938,   230,
     337,   337,   517,   562,  1027,  1016,   165,   210,   516,   940,
     849,   860,   966,  1113,   860,   232,   232,   761,   768,   764,
     126,   426,   781,   738,  1121,   768,   786,  1121,   782,   562,
      19,   113,   967,   993,   561,   562,  1124,  1118,    31,    32,
      37,    39,    40,    41,    55,    94,    97,   105,   124,   141,
     161,   163,   182,   183,   223,   250,   259,   260,   262,   290,
     291,   292,   310,   311,   312,   316,   319,   332,   333,   357,
     359,   381,   424,   426,   436,   477,   478,   481,   482,   483,
     484,   524,   525,   543,   715,   718,   719,   720,   721,   722,
     723,   724,  1124,  1124,  1223,    18,  1124,  1233,   337,   403,
     560,   597,    18,  1118,   561,   561,    18,   684,   694,   560,
     952,   247,   973,   860,   561,   561,   561,   560,   730,   730,
     560,   725,   726,   730,   223,   223,   561,   561,   561,   561,
     561,   561,   562,   894,   946,   946,   561,   561,   561,   561,
     561,   561,   562,   561,   561,   561,   561,   561,   562,   561,
     561,   561,   561,   561,   901,   964,   562,   562,   562,   561,
     561,   561,   561,   562,   561,   561,   561,   562,   225,   535,
     886,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     562,   561,   561,   561,   860,   561,   168,   561,   561,   562,
     562,   561,   562,   562,   561,   860,   561,   860,   561,   860,
     561,   561,   562,   561,   561,   860,   547,  1208,   567,   769,
     561,   906,   561,   562,   561,   869,   860,   562,   561,   397,
    1185,  1185,  1185,   108,   860,  1021,  1022,   129,  1093,   241,
     853,   562,  1016,  1020,  1021,  1018,  1012,  1010,  1111,  1124,
    1180,   969,   191,   957,  1123,  1123,   566,   983,   984,  1126,
     428,   554,   380,   393,   423,  1144,   744,  1016,   560,   560,
    1143,   860,   142,   561,   918,   348,   916,   928,   230,   230,
     916,   928,   921,   920,   922,  1029,   952,  1022,   760,   941,
     941,   941,   853,   562,   967,   768,   764,   560,   108,   108,
     713,   743,   715,   962,   561,   706,   751,   560,   560,   730,
     725,   361,   716,   725,   725,    20,    32,    45,   502,   736,
     746,    55,   524,   719,   721,   746,   746,    55,   525,   525,
     528,   725,   717,   730,   730,   746,   560,   730,    23,    63,
      67,   108,   330,   337,   364,   424,   504,   732,   733,   734,
     749,   878,   528,   560,   746,    32,   560,   747,   560,   560,
     730,   560,   726,   731,   567,   561,   562,  1224,  1225,   217,
     225,   350,   617,   618,   619,   620,   855,   105,   223,   381,
     461,   704,   598,  1224,   561,   677,   692,   560,   681,   766,
     767,  1124,   972,   946,   331,   746,   331,   860,   561,   561,
     561,   860,   860,   422,   900,   331,   860,   860,   860,   860,
      40,   371,   561,   860,   946,   860,   860,   860,   860,   860,
     561,   561,   561,   331,   860,  1199,  1124,   561,   906,   856,
     891,    58,   228,   324,   452,   463,   538,  1176,  1177,   535,
    1186,  1186,  1186,   561,   562,  1024,   222,   683,  1015,  1022,
     561,  1202,    44,   197,   954,   988,  1126,   562,   303,    68,
     498,   380,  1145,   476,   476,  1016,  1121,   950,   230,   337,
     924,   928,   928,   337,   926,   860,   860,   560,   963,   168,
     939,   935,  1113,   560,   560,   766,    97,   478,   481,   552,
     553,  1108,  1109,   787,   732,   283,   337,   560,   752,   754,
     755,   756,   331,   331,   433,   509,   544,   727,   728,   729,
     560,   727,   727,   747,    20,   502,   736,   748,   747,   737,
     746,   528,   727,   560,   746,   331,   727,   742,  1121,   327,
     735,  1108,   511,   108,   232,   734,   232,   330,   331,   331,
     331,   331,   727,   331,   727,  1124,  1124,   535,  1227,   420,
     560,  1226,   561,   562,   615,  1118,   496,   613,   614,   616,
    1124,  1227,  1202,   678,   681,   679,   561,   562,   967,   560,
     561,   561,   561,   562,   561,   561,   562,   561,  1106,   561,
     562,   561,   562,   561,   561,   303,   151,   561,   561,   561,
     561,   561,   561,   561,   562,  1211,   561,   858,   476,   476,
     476,    16,  1175,   188,   284,   285,   288,   289,  1187,  1188,
    1022,   232,  1088,   702,   848,   969,   958,  1113,   955,   963,
      65,  1094,   984,   561,   561,  1146,    16,   916,   923,   517,
     925,   517,   945,  1124,   973,   230,   942,   702,   967,   766,
     766,   561,  1110,  1110,   783,   173,   352,   434,   112,   511,
     753,  1124,   756,   561,   561,   729,   770,  1106,   737,   747,
     770,   561,   859,   327,   523,   561,   561,   561,   561,    49,
      57,   252,   855,   855,  1234,   619,  1124,   168,  1121,   561,
     562,   615,   561,  1199,   767,   331,   331,   860,   902,   860,
     906,  1176,   342,   974,   974,   974,   974,  1188,   511,   472,
     852,   535,   562,   959,   967,   860,   969,   135,   145,   343,
     475,  1095,  1096,   249,  1097,   270,   337,   860,   560,   860,
     560,   561,   562,   560,   561,   561,   787,    48,   328,   401,
     426,   757,   757,   561,   562,   561,   562,   561,   859,   746,
     747,   746,   747,    57,   342,    57,   842,   841,   604,   715,
     855,   599,   616,   715,   680,   967,   561,   561,   561,   562,
     561,   561,   561,  1030,  1031,  1115,  1118,    86,   408,  1113,
     366,   976,    44,    44,   135,    44,  1096,   453,   475,  1098,
    1099,   142,   930,   945,   945,  1124,   943,   944,   750,     5,
     108,   330,   754,  1124,   746,  1106,   746,   342,   342,   561,
     118,   605,   606,   878,  1235,   131,   403,  1202,   860,   562,
    1016,  1089,   967,  1124,  1106,  1106,    44,  1106,    44,    44,
    1099,   975,   860,   561,   561,   561,  1202,   118,    60,   157,
     209,   229,   242,   340,   404,   548,   637,   638,   641,   650,
     651,   654,   665,  1120,  1125,  1129,   414,   600,   561,  1031,
    1022,   736,   739,   977,  1106,  1106,  1106,    16,   565,  1124,
     171,   323,   643,   640,  1125,  1125,  1124,   639,   652,   655,
     573,    28,   263,   394,   534,   668,   569,  1229,   715,   738,
    1090,   560,   274,   171,  1124,   645,   646,   860,   860,   532,
     657,   661,   669,   622,   637,   622,   670,   666,   637,   601,
    1094,   855,   978,   979,   980,   142,   222,   138,   860,   653,
     662,   546,   661,   664,   623,   138,   637,   568,   510,   860,
     668,   604,  1097,   860,   561,   562,   974,   642,   209,   547,
     532,   656,   658,   860,   622,   138,   106,   621,   624,   263,
     568,   672,   125,   667,  1125,   602,   210,  1100,   980,   644,
    1124,   647,   659,   658,   664,   663,   548,    80,   150,   629,
     635,  1124,   138,   637,   568,   860,   671,   637,   331,   560,
    1101,   562,   622,   860,   138,   547,   195,   562,   625,    75,
      89,   568,   138,   622,   249,   561,   566,  1102,  1103,  1115,
     426,  1104,  1124,   648,   660,   548,   622,   168,  1124,   715,
     168,   168,   394,   138,  1126,   561,   562,  1030,   132,   546,
     649,   547,   626,   108,   636,   442,   632,   974,   627,   628,
     534,  1103,   645,   622,   622,   441,   443,   630,   631,   632,
     634,   878,  1124,   860,   523,   633,   573,   562,   637,   169,
    1122,   631
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1202 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1215 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1275 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1295 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1309 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1316 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1325 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1337 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1351 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1363 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1371 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1381 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1387 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1396 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1401 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1406 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1411 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1416 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1420 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1425 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1429 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1433 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1437 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1441 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1450 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1454 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1470 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1474 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1485 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 (using_update_log ?
						  TL_READ_NO_INSERT:
						  TL_READ)))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	  lex->name=0;
	}
    break;

  case 89:
#line 1505 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1507 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1519 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1527 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1532 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1539 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1545 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1547 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1554 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1569 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1584 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1602 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1621 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(YYTHD);
	    sp->init(lex);
            sp->init_sp_name(YYTHD, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
	    YYTHD->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lex->tok_start+1;
	  }
    break;

  case 102:
#line 1658 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_param_end= lex->tok_start;
	  }
    break;

  case 103:
#line 1664 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1672 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1684 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lex->tok_start;
	  }
    break;

  case 106:
#line 1691 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1713 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1714 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1718 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1719 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1725 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1727 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1729 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1731 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1733 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1735 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1737 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1742 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1743 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1744 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1749 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1753 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1760 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1768 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1784 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1788 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1806 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1826 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1863 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1888 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1889 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1890 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1891 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1895 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1900 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1906 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1910 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1936 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1944 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1992 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 2006 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 156:
#line 2021 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    lex->spcont->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 2050 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 2073 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2082 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2104 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2105 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2111 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 163:
#line 2113 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 164:
#line 2118 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	    }
	  }
    break;

  case 165:
#line 2141 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 166:
#line 2147 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 167:
#line 2161 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2162 "sql_yacc.yy"
    {}
    break;

  case 169:
#line 2167 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 170:
#line 2171 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 171:
#line 2180 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 172:
#line 2185 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 173:
#line 2190 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 174:
#line 2198 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 175:
#line 2213 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 176:
#line 2230 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 177:
#line 2231 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 178:
#line 2235 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->reset_lex(YYTHD);
	    lex->sphead->m_tmp_query= lex->tok_start;
	  }
    break;

  case 179:
#line 2242 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lex->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lex->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(YYTHD->mem_root,
                                           (char *)sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(YYTHD);
          }
    break;

  case 180:
#line 2281 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 181:
#line 2283 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 182:
#line 2304 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 183:
#line 2306 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 185:
#line 2309 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2310 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 187:
#line 2316 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 188:
#line 2322 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2351 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 190:
#line 2379 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2394 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2409 "sql_yacc.yy"
    { }
    break;

  case 193:
#line 2411 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 197:
#line 2435 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2456 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 199:
#line 2478 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 200:
#line 2480 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 201:
#line 2494 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 202:
#line 2505 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 208:
#line 2525 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2531 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 210:
#line 2542 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 211:
#line 2550 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 212:
#line 2558 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 217:
#line 2576 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2580 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 219:
#line 2589 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 220:
#line 2597 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2601 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 222:
#line 2608 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 223:
#line 2616 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 225:
#line 2629 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 226:
#line 2647 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 227:
#line 2666 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 228:
#line 2667 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 229:
#line 2672 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 230:
#line 2684 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 231:
#line 2700 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 232:
#line 2709 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 233:
#line 2711 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 234:
#line 2725 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 235:
#line 2735 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 236:
#line 2737 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 237:
#line 2753 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 238:
#line 2755 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 239:
#line 2760 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 240:
#line 2762 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 241:
#line 2764 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 242:
#line 2768 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2769 "sql_yacc.yy"
    {}
    break;

  case 244:
#line 2771 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[0].table)))
              MYSQL_YYABORT;
            if ((yyvsp[0].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[0].table)->db.str), &((yyvsp[0].table)->db.length)))
            {
              MYSQL_YYABORT;
            }
          }
    break;

  case 245:
#line 2783 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[-1].table)))
              MYSQL_YYABORT;
            if ((yyvsp[-1].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[-1].table)->db.str), &((yyvsp[-1].table)->db.length)))
            {
              MYSQL_YYABORT;
            }
          }
    break;

  case 246:
#line 2797 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2798 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 248:
#line 2798 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2802 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2804 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 251:
#line 2804 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2806 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 253:
#line 2806 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2811 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 255:
#line 2827 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 256:
#line 2831 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 257:
#line 2841 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2842 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2845 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2846 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2849 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2850 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2853 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2854 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2857 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 266:
#line 2858 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 267:
#line 2861 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 268:
#line 2862 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 269:
#line 2865 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 270:
#line 2868 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 271:
#line 2869 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 279:
#line 2885 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2886 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 281:
#line 2887 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 282:
#line 2888 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 283:
#line 2889 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 284:
#line 2890 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 285:
#line 2891 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 286:
#line 2892 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 287:
#line 2894 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2909 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 289:
#line 2914 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 290:
#line 2915 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 291:
#line 2916 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 292:
#line 2918 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2923 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2928 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 295:
#line 2933 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 298:
#line 2949 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 299:
#line 2950 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 300:
#line 2951 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 301:
#line 2952 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 302:
#line 2957 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2974 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 304:
#line 2990 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 305:
#line 2999 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 306:
#line 3000 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 307:
#line 3001 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 308:
#line 3002 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 309:
#line 3003 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 310:
#line 3004 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 311:
#line 3007 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3008 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 313:
#line 3009 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 314:
#line 3012 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 315:
#line 3013 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 316:
#line 3014 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 317:
#line 3017 "sql_yacc.yy"
    {}
    break;

  case 319:
#line 3021 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 320:
#line 3022 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 321:
#line 3025 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 322:
#line 3026 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 323:
#line 3027 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 324:
#line 3028 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 330:
#line 3043 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3050 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3058 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3066 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3083 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3087 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 339:
#line 3102 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 340:
#line 3103 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 341:
#line 3107 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 342:
#line 3112 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 343:
#line 3120 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 344:
#line 3133 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 345:
#line 3134 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 346:
#line 3135 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 347:
#line 3136 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3138 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 349:
#line 3140 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3142 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 351:
#line 3144 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3146 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3148 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3151 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 355:
#line 3154 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3157 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 357:
#line 3160 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 358:
#line 3162 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 359:
#line 3165 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 360:
#line 3168 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 361:
#line 3169 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 362:
#line 3170 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 363:
#line 3172 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 364:
#line 3184 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 365:
#line 3185 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 366:
#line 3187 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 367:
#line 3190 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 368:
#line 3201 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 369:
#line 3203 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 370:
#line 3205 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 371:
#line 3207 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 372:
#line 3208 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 373:
#line 3209 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 374:
#line 3210 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 375:
#line 3211 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 376:
#line 3213 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 377:
#line 3215 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3217 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 379:
#line 3218 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 380:
#line 3219 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 381:
#line 3220 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 382:
#line 3221 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 383:
#line 3222 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 384:
#line 3224 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 385:
#line 3232 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 386:
#line 3233 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 387:
#line 3234 "sql_yacc.yy"
    { Lex->length= (char*)"21";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 388:
#line 3237 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 389:
#line 3238 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 390:
#line 3239 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 391:
#line 3240 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 392:
#line 3241 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 393:
#line 3245 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3249 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3250 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3254 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3255 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3259 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3260 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3261 "sql_yacc.yy"
    {}
    break;

  case 401:
#line 3262 "sql_yacc.yy"
    {}
    break;

  case 402:
#line 3263 "sql_yacc.yy"
    {}
    break;

  case 403:
#line 3267 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 404:
#line 3268 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 405:
#line 3269 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 406:
#line 3270 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 407:
#line 3271 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 408:
#line 3274 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 409:
#line 3276 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 410:
#line 3277 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 411:
#line 3281 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 412:
#line 3282 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 413:
#line 3283 "sql_yacc.yy"
    {}
    break;

  case 414:
#line 3287 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 415:
#line 3293 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3294 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3297 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3298 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3301 "sql_yacc.yy"
    {}
    break;

  case 420:
#line 3302 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 421:
#line 3303 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 422:
#line 3306 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 423:
#line 3307 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 424:
#line 3310 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3311 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3314 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3315 "sql_yacc.yy"
    {}
    break;

  case 428:
#line 3318 "sql_yacc.yy"
    {}
    break;

  case 430:
#line 3322 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 431:
#line 3323 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 432:
#line 3324 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 433:
#line 3326 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 434:
#line 3327 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 435:
#line 3329 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3335 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 437:
#line 3341 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 438:
#line 3347 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 439:
#line 3352 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 440:
#line 3354 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 441:
#line 3369 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 442:
#line 3370 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 443:
#line 3374 "sql_yacc.yy"
    {}
    break;

  case 444:
#line 3375 "sql_yacc.yy"
    {}
    break;

  case 445:
#line 3380 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 446:
#line 3387 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 447:
#line 3391 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 448:
#line 3392 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 449:
#line 3395 "sql_yacc.yy"
    { (yyval.charset)= NULL; }
    break;

  case 450:
#line 3396 "sql_yacc.yy"
    { (yyval.charset)= (yyvsp[0].charset); }
    break;

  case 451:
#line 3401 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 452:
#line 3409 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 453:
#line 3413 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 454:
#line 3414 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 455:
#line 3418 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 456:
#line 3427 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 457:
#line 3428 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 458:
#line 3432 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 459:
#line 3433 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 460:
#line 3436 "sql_yacc.yy"
    {}
    break;

  case 461:
#line 3437 "sql_yacc.yy"
    {}
    break;

  case 462:
#line 3440 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 463:
#line 3441 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 464:
#line 3442 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 465:
#line 3444 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 466:
#line 3452 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 467:
#line 3453 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 468:
#line 3456 "sql_yacc.yy"
    { }
    break;

  case 469:
#line 3457 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 470:
#line 3460 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 471:
#line 3461 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 472:
#line 3463 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 473:
#line 3471 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 476:
#line 3480 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 477:
#line 3486 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 478:
#line 3491 "sql_yacc.yy"
    {}
    break;

  case 479:
#line 3492 "sql_yacc.yy"
    {}
    break;

  case 480:
#line 3495 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 481:
#line 3496 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 482:
#line 3500 "sql_yacc.yy"
    {}
    break;

  case 483:
#line 3501 "sql_yacc.yy"
    {}
    break;

  case 484:
#line 3504 "sql_yacc.yy"
    {}
    break;

  case 485:
#line 3505 "sql_yacc.yy"
    {}
    break;

  case 486:
#line 3508 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 487:
#line 3509 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 488:
#line 3510 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 489:
#line 3511 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 490:
#line 3512 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 491:
#line 3515 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 492:
#line 3516 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 493:
#line 3517 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 494:
#line 3518 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 495:
#line 3519 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 496:
#line 3522 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 497:
#line 3523 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 498:
#line 3525 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 499:
#line 3536 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 500:
#line 3537 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 501:
#line 3540 "sql_yacc.yy"
    {}
    break;

  case 502:
#line 3541 "sql_yacc.yy"
    {}
    break;

  case 503:
#line 3544 "sql_yacc.yy"
    {}
    break;

  case 505:
#line 3549 "sql_yacc.yy"
    {}
    break;

  case 506:
#line 3550 "sql_yacc.yy"
    {}
    break;

  case 507:
#line 3551 "sql_yacc.yy"
    {}
    break;

  case 508:
#line 3554 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 509:
#line 3555 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 510:
#line 3556 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 511:
#line 3558 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 512:
#line 3570 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 513:
#line 3571 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 514:
#line 3572 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 515:
#line 3575 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 516:
#line 3577 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 517:
#line 3580 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 518:
#line 3583 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 519:
#line 3584 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 520:
#line 3587 "sql_yacc.yy"
    { (yyval.key_part)=new key_part_spec((yyvsp[0].lex_str).str); }
    break;

  case 521:
#line 3589 "sql_yacc.yy"
    {
          int key_part_len= atoi((yyvsp[-1].lex_str).str);
          if (!key_part_len)
          {
            my_error(ER_KEY_PART_0, MYF(0), (yyvsp[-3].lex_str).str);
          }
          (yyval.key_part)=new key_part_spec((yyvsp[-3].lex_str).str,(uint) key_part_len);
        }
    break;

  case 522:
#line 3599 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 523:
#line 3600 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].lex_str).str; }
    break;

  case 524:
#line 3603 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 525:
#line 3604 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 526:
#line 3607 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 527:
#line 3608 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 528:
#line 3616 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex= thd->lex;
	  lex->sql_command= SQLCOM_ALTER_TABLE;
	  lex->name= 0;
	  lex->duplicates= DUP_ERROR; 
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING))
	    MYSQL_YYABORT;
	  lex->col_list.empty();
          lex->select_lex.init_order();
	  lex->select_lex.db=
            ((TABLE_LIST*) lex->select_lex.table_list.first)->db;
          lex->name=0;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.db_type= DB_TYPE_DEFAULT;
	  lex->create_info.default_table_charset= NULL;
	  lex->create_info.row_type= ROW_TYPE_NOT_USED;
          lex->alter_info.reset();
	}
    break;

  case 529:
#line 3637 "sql_yacc.yy"
    {}
    break;

  case 530:
#line 3639 "sql_yacc.yy"
    {
            Lex->create_info.default_table_charset= NULL;
            Lex->create_info.used_fields= 0;
          }
    break;

  case 531:
#line 3644 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            THD *thd= Lex->thd;
	    lex->sql_command=SQLCOM_ALTER_DB;
	    lex->name= (yyvsp[-2].simple_string);
            if (lex->name == NULL && thd->copy_db_to(&lex->name, NULL))
              MYSQL_YYABORT;
	  }
    break;

  case 532:
#line 3653 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "PROCEDURE");
	      MYSQL_YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 533:
#line 3664 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_PROCEDURE;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 534:
#line 3671 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 535:
#line 3682 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_FUNCTION;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 536:
#line 3690 "sql_yacc.yy"
    {
	    THD *thd= YYTHD;
	    LEX *lex= thd->lex;
	    lex->sql_command= SQLCOM_CREATE_VIEW;
	    lex->create_view_mode= VIEW_ALTER;
	    /* first table in list is target VIEW name */
	    lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL, TL_OPTION_UPDATING);
	  }
    break;

  case 537:
#line 3699 "sql_yacc.yy"
    {}
    break;

  case 538:
#line 3703 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 539:
#line 3704 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].lex_str).str; }
    break;

  case 541:
#line 3707 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= DISCARD_TABLESPACE; }
    break;

  case 542:
#line 3708 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= IMPORT_TABLESPACE; }
    break;

  case 545:
#line 3714 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->change=0;
	  lex->alter_info.flags|= ALTER_ADD_COLUMN;
	}
    break;

  case 546:
#line 3721 "sql_yacc.yy"
    { }
    break;

  case 547:
#line 3723 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_INDEX;
	  }
    break;

  case 548:
#line 3727 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_COLUMN | ALTER_ADD_INDEX;
          }
    break;

  case 549:
#line 3731 "sql_yacc.yy"
    {
	     LEX *lex=Lex;
	     lex->change= (yyvsp[0].lex_str).str;
	     lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
	  }
    break;

  case 551:
#line 3738 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            lex->length=lex->dec=0; lex->type=0;
            lex->default_value= lex->on_update_value= 0;
            lex->comment=null_lex_str;
	    lex->charset= NULL;
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN;
          }
    break;

  case 552:
#line 3747 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if (add_field_to_list(lex->thd,(yyvsp[-3].lex_str).str,
                                  (enum enum_field_types) (yyvsp[-1].num),
                                  lex->length,lex->dec,lex->type,
                                  lex->default_value, lex->on_update_value,
                                  &lex->comment,
				  (yyvsp[-3].lex_str).str, &lex->interval_list, lex->charset,
				  lex->uint_geom_type))
	       MYSQL_YYABORT;
          }
    break;

  case 554:
#line 3760 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
                                                               (yyvsp[-1].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_COLUMN;
	  }
    break;

  case 555:
#line 3767 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_DROP_INDEX;
          }
    break;

  case 556:
#line 3771 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
				               primary_key_name));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 557:
#line 3778 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.drop_list.push_back(new Alter_drop(Alter_drop::KEY,
					                       (yyvsp[0].lex_str).str));
	    lex->alter_info.flags|= ALTER_DROP_INDEX;
	  }
    break;

  case 558:
#line 3785 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= DISABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 559:
#line 3791 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->alter_info.keys_onoff= ENABLE;
	    lex->alter_info.flags|= ALTER_KEYS_ONOFF;
          }
    break;

  case 560:
#line 3797 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.alter_list.push_back(new Alter_column((yyvsp[-3].lex_str).str,(yyvsp[0].item)));
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN_DEFAULT;
	  }
    break;

  case 561:
#line 3803 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.alter_list.push_back(new Alter_column((yyvsp[-2].lex_str).str,
                                                                  (Item*) 0));
	    lex->alter_info.flags|= ALTER_CHANGE_COLUMN_DEFAULT;
	  }
    break;

  case 562:
#line 3810 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            THD *thd= lex->thd;
	    lex->select_lex.db=(yyvsp[0].table)->db.str;
            if (lex->select_lex.db == NULL &&
                thd->copy_db_to(&lex->select_lex.db, NULL))
            {
              MYSQL_YYABORT;
            }
            if (check_table_name((yyvsp[0].table)->table.str,(yyvsp[0].table)->table.length) ||
                (yyvsp[0].table)->db.str && check_db_name((yyvsp[0].table)->db.str))
            {
              my_error(ER_WRONG_TABLE_NAME, MYF(0), (yyvsp[0].table)->table.str);
              MYSQL_YYABORT;
            }
	    lex->name= (yyvsp[0].table)->table.str;
	    lex->alter_info.flags|= ALTER_RENAME;
	  }
    break;

  case 563:
#line 3829 "sql_yacc.yy"
    {
	    if (!(yyvsp[-1].charset))
	    {
	      THD *thd= YYTHD;
	      (yyvsp[-1].charset)= thd->variables.collation_database;
	    }
	    (yyvsp[0].charset)= (yyvsp[0].charset) ? (yyvsp[0].charset) : (yyvsp[-1].charset);
	    if (!my_charset_same((yyvsp[-1].charset),(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, (yyvsp[-1].charset)->csname);
	      MYSQL_YYABORT;
	    }
	    LEX *lex= Lex;
	    lex->create_info.table_charset=
	      lex->create_info.default_table_charset= (yyvsp[0].charset);
	    lex->create_info.used_fields|= (HA_CREATE_USED_CHARSET |
					    HA_CREATE_USED_DEFAULT_CHARSET);
	    lex->alter_info.flags|= ALTER_CONVERT;
	  }
    break;

  case 564:
#line 3850 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.flags|= ALTER_OPTIONS;
	  }
    break;

  case 565:
#line 3855 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_FORCE;
	   }
    break;

  case 566:
#line 3859 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->alter_info.flags|= ALTER_ORDER;
	  }
    break;

  case 567:
#line 3865 "sql_yacc.yy"
    {}
    break;

  case 568:
#line 3866 "sql_yacc.yy"
    {}
    break;

  case 569:
#line 3869 "sql_yacc.yy"
    { Lex->ignore= 0;}
    break;

  case 570:
#line 3870 "sql_yacc.yy"
    { Lex->ignore= 1;}
    break;

  case 571:
#line 3874 "sql_yacc.yy"
    { Lex->drop_mode= DROP_DEFAULT; }
    break;

  case 572:
#line 3875 "sql_yacc.yy"
    { Lex->drop_mode= DROP_RESTRICT; }
    break;

  case 573:
#line 3876 "sql_yacc.yy"
    { Lex->drop_mode= DROP_CASCADE; }
    break;

  case 574:
#line 3880 "sql_yacc.yy"
    {}
    break;

  case 575:
#line 3881 "sql_yacc.yy"
    { store_position_for_column((yyvsp[0].lex_str).str); }
    break;

  case 576:
#line 3882 "sql_yacc.yy"
    { store_position_for_column(first_keyword); }
    break;

  case 577:
#line 3885 "sql_yacc.yy"
    {}
    break;

  case 578:
#line 3886 "sql_yacc.yy"
    {}
    break;

  case 579:
#line 3887 "sql_yacc.yy"
    {}
    break;

  case 580:
#line 3888 "sql_yacc.yy"
    {}
    break;

  case 581:
#line 3896 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->sql_command = SQLCOM_SLAVE_START;
	    lex->type = 0;
	    /* We'll use mi structure for UNTIL options */
	    bzero((char*) &lex->mi, sizeof(lex->mi));
            /* If you change this code don't forget to update SLAVE START too */
          }
    break;

  case 582:
#line 3905 "sql_yacc.yy"
    {}
    break;

  case 583:
#line 3907 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            lex->sql_command = SQLCOM_SLAVE_STOP;
	    lex->type = 0;
            /* If you change this code don't forget to update SLAVE STOP too */
          }
    break;

  case 584:
#line 3914 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
           lex->sql_command = SQLCOM_SLAVE_START;
	   lex->type = 0;
	    /* We'll use mi structure for UNTIL options */
	    bzero((char*) &lex->mi, sizeof(lex->mi));
          }
    break;

  case 585:
#line 3922 "sql_yacc.yy"
    {}
    break;

  case 586:
#line 3924 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
           lex->sql_command = SQLCOM_SLAVE_STOP;
	   lex->type = 0;
         }
    break;

  case 587:
#line 3934 "sql_yacc.yy"
    {
          LEX *lex= Lex;
          lex->sql_command= SQLCOM_BEGIN;
          lex->start_transaction_opt= (yyvsp[0].num);
        }
    break;

  case 588:
#line 3942 "sql_yacc.yy"
    { (yyval.num) = 0; }
    break;

  case 589:
#line 3944 "sql_yacc.yy"
    {
           (yyval.num)= MYSQL_START_TRANS_OPT_WITH_CONS_SNAPSHOT;
        }
    break;

  case 590:
#line 3950 "sql_yacc.yy"
    { Lex->slave_thd_opt= 0; }
    break;

  case 591:
#line 3952 "sql_yacc.yy"
    {}
    break;

  case 594:
#line 3961 "sql_yacc.yy"
    {}
    break;

  case 595:
#line 3962 "sql_yacc.yy"
    { Lex->slave_thd_opt|=SLAVE_SQL; }
    break;

  case 596:
#line 3963 "sql_yacc.yy"
    { Lex->slave_thd_opt|=SLAVE_IO; }
    break;

  case 597:
#line 3967 "sql_yacc.yy"
    {}
    break;

  case 598:
#line 3969 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            if ((lex->mi.log_file_name || lex->mi.pos) &&
                (lex->mi.relay_log_name || lex->mi.relay_log_pos) ||
                !((lex->mi.log_file_name && lex->mi.pos) ||
                  (lex->mi.relay_log_name && lex->mi.relay_log_pos)))
