/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1622 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1637 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43821

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  663
/* YYNRULES -- Number of rules. */
#define YYNRULES  2020
/* YYNRULES -- Number of states. */
#define YYNSTATES  3676

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   271,   274,   275,   278,   281,   284,   287,   290,   294,
     298,   300,   302,   304,   307,   311,   315,   316,   321,   322,
     326,   327,   329,   333,   335,   336,   338,   342,   344,   345,
     349,   350,   352,   356,   358,   363,   364,   366,   368,   370,
     371,   375,   378,   382,   383,   387,   388,   394,   400,   401,
     409,   415,   416,   419,   421,   423,   425,   429,   431,   433,
     437,   438,   440,   442,   444,   446,   449,   451,   453,   457,
     458,   461,   462,   465,   466,   470,   471,   477,   479,   481,
     482,   485,   488,   491,   494,   495,   502,   505,   506,   509,
     511,   513,   517,   518,   519,   520,   528,   529,   532,   535,
     537,   539,   540,   541,   550,   551,   558,   560,   563,   565,
     568,   569,   570,   577,   578,   579,   586,   587,   590,   591,
     597,   598,   600,   601,   607,   612,   613,   614,   623,   624,
     632,   634,   636,   638,   640,   642,   645,   648,   651,   656,
     661,   662,   667,   668,   669,   675,   676,   684,   685,   686,
     693,   694,   696,   697,   699,   701,   704,   706,   708,   709,
     711,   713,   716,   718,   719,   723,   724,   726,   728,   731,
     733,   736,   740,   744,   748,   752,   756,   760,   764,   768,
     772,   776,   780,   784,   788,   792,   796,   800,   804,   810,
     812,   814,   818,   823,   828,   832,   837,   842,   844,   846,
     848,   850,   852,   854,   856,   858,   860,   862,   864,   866,
     868,   870,   873,   875,   877,   879,   881,   883,   887,   889,
     891,   894,   897,   904,   912,   921,   924,   927,   928,   930,
     933,   934,   936,   939,   940,   945,   949,   953,   957,   959,
     964,   966,   968,   974,   977,   983,   986,   991,   993,   999,
    1005,  1010,  1014,  1016,  1018,  1021,  1023,  1025,  1028,  1030,
    1032,  1034,  1037,  1041,  1044,  1048,  1051,  1054,  1058,  1062,
    1066,  1067,  1074,  1075,  1082,  1085,  1087,  1089,  1091,  1093,
    1095,  1097,  1099,  1101,  1103,  1105,  1107,  1110,  1113,  1115,
    1118,  1120,  1123,  1127,  1130,  1132,  1134,  1136,  1138,  1140,
    1142,  1144,  1147,  1148,  1152,  1154,  1160,  1161,  1163,  1166,
    1168,  1170,  1172,  1174,  1175,  1179,  1180,  1182,  1183,  1185,
    1188,  1190,  1192,  1195,  1198,  1203,  1205,  1209,  1212,  1214,
    1217,  1220,  1223,  1226,  1228,  1231,  1233,  1235,  1237,  1239,
    1241,  1242,  1245,  1247,  1249,  1251,  1253,  1255,  1256,  1259,
    1261,  1263,  1264,  1266,  1267,  1270,  1272,  1275,  1279,  1282,
    1283,  1285,  1286,  1288,  1290,  1293,  1294,  1296,  1297,  1302,
    1304,  1309,  1313,  1315,  1316,  1318,  1321,  1323,  1327,  1331,
    1334,  1337,  1340,  1342,  1344,  1347,  1350,  1353,  1355,  1358,
    1361,  1364,  1367,  1369,  1371,  1372,  1374,  1376,  1378,  1380,
    1381,  1383,  1385,  1387,  1388,  1391,  1394,  1396,  1398,  1400,
    1405,  1408,  1410,  1415,  1416,  1418,  1419,  1422,  1424,  1428,
    1429,  1436,  1437,  1443,  1444,  1450,  1451,  1457,  1458,  1470,
    1471,  1473,  1474,  1477,  1480,  1482,  1486,  1489,  1493,  1496,
    1501,  1502,  1509,  1510,  1511,  1520,  1525,  1530,  1534,  1538,
    1541,  1544,  1551,  1557,  1561,  1567,  1569,  1571,  1573,  1574,
    1576,  1577,  1579,  1580,  1582,  1584,  1585,  1588,  1590,  1591,
    1593,  1595,  1597,  1598,  1604,  1608,  1609,  1615,  1619,  1623,
    1624,  1628,  1629,  1632,  1634,  1638,  1639,  1641,  1643,  1644,
    1647,  1649,  1653,  1654,  1661,  1662,  1669,  1670,  1676,  1677,
    1679,  1681,  1682,  1689,  1690,  1692,  1694,  1697,  1699,  1701,
    1703,  1704,  1710,  1711,  1717,  1718,  1720,  1722,  1725,  1727,
    1729,  1731,  1733,  1735,  1738,  1739,  1745,  1746,  1748,  1750,
    1751,  1756,  1761,  1765,  1771,  1773,  1777,  1781,  1787,  1789,
    1793,  1796,  1798,  1800,  1801,  1808,  1810,  1814,  1818,  1819,
    1822,  1823,  1828,  1829,  1832,  1834,  1837,  1842,  1845,  1849,
    1850,  1854,  1855,  1856,  1863,  1866,  1868,  1870,  1873,  1876,
    1885,  1890,  1891,  1893,  1896,  1898,  1900,  1902,  1904,  1906,
    1908,  1910,  1912,  1914,  1916,  1918,  1919,  1922,  1927,  1931,
    1933,  1935,  1940,  1941,  1942,  1944,  1946,  1947,  1950,  1953,
    1955,  1957,  1958,  1961,  1965,  1969,  1973,  1976,  1980,  1985,
    1989,  1994,  1998,  2003,  2005,  2009,  2014,  2018,  2022,  2029,
    2031,  2037,  2044,  2050,  2058,  2065,  2074,  2080,  2087,  2092,
    2097,  2103,  2107,  2112,  2114,  2118,  2122,  2126,  2130,  2134,
    2138,  2143,  2148,  2152,  2156,  2160,  2164,  2168,  2172,  2174,
    2176,  2178,  2180,  2182,  2184,  2186,  2188,  2190,  2192,  2194,
    2196,  2198,  2200,  2202,  2204,  2206,  2209,  2211,  2215,  2217,
    2219,  2221,  2223,  2227,  2230,  2233,  2236,  2239,  2243,  2247,
    2253,  2260,  2265,  2270,  2278,  2283,  2286,  2293,  2299,  2306,
    2313,  2318,  2323,  2327,  2332,  2339,  2348,  2355,  2364,  2371,
    2376,  2383,  2388,  2395,  2400,  2405,  2410,  2415,  2422,  2431,
    2434,  2437,  2442,  2445,  2453,  2461,  2465,  2470,  2475,  2482,
    2489,  2494,  2501,  2508,  2515,  2520,  2527,  2532,  2539,  2548,
    2559,  2572,  2579,  2584,  2591,  2598,  2600,  2607,  2612,  2621,
    2632,  2637,  2639,  2643,  2648,  2655,  2662,  2671,  2678,  2685,
    2690,  2697,  2704,  2713,  2718,  2723,  2730,  2735,  2738,  2743,
    2748,  2753,  2760,  2765,  2770,  2774,  2783,  2790,  2795,  2802,
    2806,  2813,  2822,  2827,  2836,  2843,  2852,  2859,  2868,  2871,
    2876,  2881,  2886,  2893,  2902,  2911,  2916,  2924,  2932,  2940,
    2947,  2954,  2961,  2968,  2975,  2982,  2983,  2989,  3000,  3004,
    3009,  3013,  3016,  3019,  3022,  3027,  3034,  3039,  3044,  3051,
    3058,  3065,  3072,  3077,  3084,  3089,  3096,  3101,  3106,  3111,
    3116,  3123,  3128,  3135,  3140,  3147,  3152,  3157,  3164,  3169,
    3176,  3181,  3188,  3193,  3198,  3205,  3210,  3217,  3218,  3222,
    3226,  3227,  3229,  3230,  3233,  3235,  3239,  3244,  3249,  3255,
    3260,  3265,  3270,  3276,  3281,  3282,  3283,  3291,  3302,  3307,
    3313,  3318,  3324,  3329,  3334,  3339,  3344,  3349,  3355,  3356,
    3365,  3366,  3370,  3374,  3376,  3381,  3382,  3384,  3385,  3388,
    3389,  3391,  3392,  3396,  3399,  3403,  3406,  3408,  3411,  3413,
    3416,  3418,  3420,  3422,  3425,  3426,  3428,  3429,  3432,  3434,
    3438,  3440,  3444,  3445,  3448,  3450,  3454,  3455,  3457,  3458,
    3461,  3466,  3472,  3474,  3476,  3478,  3480,  3484,  3488,  3492,
    3493,  3500,  3501,  3508,  3509,  3518,  3523,  3524,  3533,  3534,
    3545,  3552,  3553,  3562,  3563,  3574,  3581,  3583,  3586,  3589,
    3590,  3595,  3596,  3608,  3612,  3619,  3620,  3624,  3625,  3626,
    3632,  3633,  3635,  3636,  3638,  3639,  3642,  3643,  3646,  3649,
    3652,  3653,  3660,  3661,  3663,  3667,  3669,  3671,  3673,  3677,
    3679,  3681,  3683,  3685,  3687,  3689,  3691,  3693,  3695,  3697,
    3699,  3701,  3703,  3705,  3707,  3709,  3711,  3713,  3715,  3717,
    3719,  3721,  3723,  3725,  3727,  3729,  3730,  3732,  3734,  3735,
    3738,  3739,  3741,  3742,  3743,  3747,  3748,  3749,  3753,  3756,
    3757,  3758,  3763,  3768,  3771,  3772,  3775,  3778,  3782,  3786,
    3788,  3791,  3792,  3794,  3795,  3800,  3805,  3808,  3809,  3811,
    3813,  3814,  3816,  3817,  3819,  3822,  3824,  3828,  3832,  3834,
    3836,  3838,  3840,  3841,  3844,  3846,  3848,  3850,  3852,  3854,
    3856,  3858,  3860,  3862,  3864,  3866,  3867,  3868,  3875,  3876,
    3878,  3882,  3884,  3887,  3888,  3891,  3895,  3897,  3900,  3902,
    3903,  3907,  3908,  3914,  3917,  3919,  3920,  3924,  3931,  3932,
    3939,  3944,  3951,  3956,  3961,  3966,  3972,  3977,  3979,  3983,
    3985,  3986,  3989,  3990,  3992,  3993,  3994,  4003,  4004,  4005,
    4012,  4013,  4015,  4017,  4019,  4021,  4023,  4026,  4028,  4030,
    4032,  4036,  4041,  4042,  4046,  4050,  4052,  4055,  4058,  4059,
    4063,  4064,  4070,  4074,  4076,  4080,  4082,  4086,  4088,  4090,
    4091,  4093,  4094,  4099,  4100,  4102,  4106,  4108,  4110,  4112,
    4113,  4114,  4121,  4122,  4123,  4135,  4139,  4141,  4145,  4149,
    4151,  4155,  4156,  4158,  4159,  4164,  4165,  4172,  4173,  4179,
    4180,  4187,  4189,  4193,  4197,  4203,  4204,  4207,  4208,  4211,
    4213,  4215,  4217,  4221,  4222,  4224,  4225,  4229,  4232,  4237,
    4242,  4247,  4252,  4253,  4258,  4265,  4282,  4285,  4288,  4289,
    4296,  4302,  4305,  4308,  4311,  4313,  4319,  4325,  4328,  4331,
    4335,  4338,  4341,  4344,  4348,  4351,  4354,  4357,  4359,  4361,
    4365,  4370,  4374,  4378,  4381,  4384,  4388,  4392,  4396,  4400,
    4404,  4408,  4410,  4412,  4414,  4416,  4417,  4419,  4420,  4423,
    4424,  4426,  4428,  4430,  4431,  4434,  4435,  4438,  4439,  4442,
    4445,  4446,  4451,  4452,  4457,  4459,  4461,  4462,  4464,  4465,
    4467,  4469,  4470,  4475,  4479,  4481,  4482,  4486,  4491,  4494,
    4496,  4498,  4500,  4502,  4504,  4506,  4508,  4510,  4511,  4513,
    4514,  4518,  4522,  4524,  4526,  4528,  4531,  4532,  4536,  4540,
    4543,  4546,  4547,  4552,  4553,  4555,  4557,  4560,  4561,  4566,
    4572,  4573,  4574,  4575,  4576,  4595,  4598,  4599,  4601,  4602,
    4604,  4606,  4607,  4609,  4611,  4612,  4615,  4618,  4620,  4624,
    4629,  4633,  4637,  4638,  4641,  4644,  4646,  4650,  4654,  4655,
    4659,  4660,  4664,  4667,  4671,  4673,  4675,  4678,  4679,  4682,
    4684,  4686,  4689,  4692,  4694,  4696,  4698,  4700,  4702,  4705,
    4708,  4710,  4712,  4714,  4716,  4718,  4720,  4722,  4725,  4728,
    4731,  4734,  4737,  4739,  4741,  4743,  4745,  4747,  4749,  4751,
    4755,  4761,  4763,  4765,  4767,  4769,  4771,  4775,  4780,  4786,
    4788,  4794,  4798,  4801,  4803,  4807,  4810,  4812,  4814,  4816,
    4818,  4820,  4822,  4824,  4826,  4828,  4830,  4832,  4834,  4836,
    4838,  4842,  4845,  4847,  4849,  4851,  4853,  4855,  4857,  4859,
    4861,  4863,  4865,  4867,  4869,  4871,  4873,  4875,  4877,  4879,
    4881,  4883,  4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,
    4901,  4903,  4905,  4907,  4909,  4911,  4913,  4915,  4917,  4919,
    4921,  4923,  4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,
    4941,  4943,  4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,
    4961,  4963,  4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,
    4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,
    5001,  5003,  5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,
    5021,  5023,  5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,
    5041,  5043,  5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,
    5061,  5063,  5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,
    5081,  5083,  5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,
    5101,  5103,  5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,
    5121,  5123,  5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,
    5141,  5143,  5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,
    5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,
    5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,
    5201,  5203,  5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,
    5221,  5223,  5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,
    5241,  5243,  5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,
    5261,  5263,  5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,
    5281,  5283,  5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,
    5301,  5303,  5305,  5307,  5309,  5311,  5313,  5315,  5317,  5319,
    5321,  5323,  5325,  5327,  5329,  5331,  5333,  5335,  5337,  5339,
    5341,  5343,  5345,  5346,  5351,  5352,  5354,  5356,  5360,  5361,
    5364,  5366,  5368,  5370,  5372,  5373,  5375,  5376,  5378,  5380,
    5382,  5383,  5386,  5389,  5392,  5394,  5397,  5402,  5408,  5413,
    5420,  5423,  5427,  5431,  5435,  5441,  5443,  5447,  5451,  5454,
    5457,  5460,  5462,  5464,  5469,  5474,  5476,  5478,  5480,  5482,
    5484,  5485,  5490,  5492,  5494,  5496,  5500,  5504,  5506,  5508,
    5511,  5514,  5515,  5519,  5524,  5528,  5529,  5537,  5539,  5542,
    5544,  5546,  5548,  5550,  5552,  5554,  5555,  5561,  5563,  5565,
    5567,  5569,  5571,  5575,  5582,  5589,  5596,  5604,  5608,  5617,
    5626,  5635,  5636,  5638,  5640,  5643,  5644,  5646,  5648,  5652,
    5653,  5657,  5658,  5662,  5663,  5667,  5668,  5672,  5674,  5676,
    5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,  5694,  5697,
    5700,  5702,  5706,  5709,  5712,  5715,  5718,  5721,  5724,  5727,
    5730,  5731,  5733,  5737,  5739,  5742,  5745,  5748,  5750,  5754,
    5758,  5760,  5762,  5766,  5768,  5772,  5777,  5783,  5785,  5786,
    5790,  5794,  5796,  5798,  5799,  5802,  5805,  5808,  5811,  5812,
    5815,  5818,  5820,  5823,  5826,  5829,  5832,  5835,  5836,  5840,
    5841,  5843,  5844,  5848,  5851,  5852,  5854,  5857,  5858,  5860,
    5865,  5870,  5876,  5879,  5883,  5884,  5886,  5887,  5892,  5893,
    5895,  5897,  5898,  5901,  5904,  5906,  5907,  5909,  5911,  5912,
    5918,  5925,  5926,  5927,  5930,  5933,  5937,  5939,  5941,  5943,
    5945,  5947,  5949,  5951,  5953,  5955,  5957,  5959,  5960,  5964,
    5966,  5969,  5971,  5974,  5978,  5982,  5986,  5987,  5989,  5990,
    5994,  5998,  5999,  6008,  6009,  6013,  6015,  6019,  6020,  6023,
    6027,  6033,  6034,  6038,  6043,  6048,  6049,  6064,  6073,  6081,
    6082,  6083,  6084,  6085,  6086,  6102,  6103,  6104,  6105,  6106,
    6119,  6124,  6129,  6133,  6138,  6142,  6145,  6147,  6151,  6157,
    6159,  6161,  6162,  6164,  6166,  6167,  6170,  6171,  6172,  6176,
    6177
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1170,    -1,   764,    -1,   805,    -1,   795,    -1,   602,    -1,
     585,    -1,   807,    -1,   797,    -1,  1176,    -1,   590,    -1,
     574,    -1,  1014,    -1,  1041,    -1,   970,    -1,   972,    -1,
     578,    -1,  1047,    -1,  1145,    -1,  1136,    -1,   583,    -1,
     978,    -1,  1061,    -1,  1065,    -1,  1128,    -1,   812,    -1,
     820,    -1,   824,    -1,   576,    -1,  1057,    -1,  1179,    -1,
     815,    -1,   800,    -1,   981,    -1,  1053,    -1,   793,    -1,
    1143,    -1,  1177,    -1,  1178,    -1,   832,    -1,  1111,    -1,
    1027,    -1,   782,    -1,   785,    -1,  1025,    -1,  1134,    -1,
    1006,    -1,  1064,    -1,  1225,    -1,   575,   362,  1105,    -1,
     103,    -1,   126,    -1,   362,  1105,   171,   577,    -1,  1102,
      -1,   566,  1107,    -1,    -1,   148,  1105,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1107,    -1,    -1,   198,   584,  1107,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1102,    -1,   282,   142,  1102,    -1,   271,
     142,  1102,    -1,   272,   142,   955,    -1,   267,   142,   955,
      -1,   280,   142,   955,    -1,   276,   142,  1102,    -1,   275,
     142,  1102,    -1,   277,   142,  1102,    -1,   278,   142,  1102,
      -1,   279,   142,  1102,    -1,   589,    -1,   269,   142,  1102,
      -1,   270,   142,   956,    -1,   386,   142,  1102,    -1,   387,
     142,   955,    -1,    -1,    84,   682,   472,   685,  1099,   591,
     669,    -1,    -1,    84,   756,   213,  1105,   757,   337,  1099,
     592,   560,   759,   561,    -1,    -1,    84,    91,   685,  1105,
     593,   679,    -1,    -1,    84,   594,  1192,    -1,    84,   514,
     595,  1161,    -1,    -1,  1105,   567,  1105,    -1,  1105,    -1,
      -1,   597,   599,    -1,    -1,   598,   600,    -1,    67,  1102,
      -1,   235,   450,    -1,   328,   450,    -1,    79,   450,    -1,
     379,   450,    93,    -1,   304,   450,    93,    -1,   601,    -1,
     599,    -1,   118,    -1,   859,   118,    -1,   450,   419,   109,
      -1,   450,   419,   224,    -1,    -1,    47,   596,   603,   604,
      -1,    -1,   560,   605,   561,    -1,    -1,   606,    -1,   606,
     562,   853,    -1,   853,    -1,    -1,   608,    -1,   608,   562,
     610,    -1,   610,    -1,    -1,  1105,   609,   708,    -1,    -1,
     612,    -1,   612,   562,   613,    -1,   613,    -1,   614,   609,
    1105,   708,    -1,    -1,   225,    -1,   350,    -1,   217,    -1,
      -1,   615,   631,   568,    -1,   631,   568,    -1,   616,   631,
     568,    -1,    -1,   617,   618,   568,    -1,    -1,   106,   629,
     619,   708,   630,    -1,   106,  1105,    75,   168,   626,    -1,
      -1,   106,   623,   195,   168,   620,   624,   631,    -1,   106,
    1105,    89,   168,   621,    -1,    -1,   622,   573,    -1,   150,
      -1,    80,    -1,   625,    -1,   624,   562,   625,    -1,   628,
      -1,   955,    -1,   442,   627,  1103,    -1,    -1,   523,    -1,
     626,    -1,  1105,    -1,   443,    -1,   859,   169,    -1,   441,
      -1,  1105,    -1,   629,   562,  1105,    -1,    -1,   108,   853,
      -1,    -1,   632,   573,    -1,    -1,   404,   633,   853,    -1,
      -1,   209,   634,   639,   138,   209,    -1,   644,    -1,   659,
      -1,    -1,   635,   662,    -1,   242,  1106,    -1,   229,  1106,
      -1,   340,  1105,    -1,    -1,   157,   637,  1105,   222,   636,
     638,    -1,    60,  1105,    -1,    -1,   323,   171,    -1,   171,
      -1,  1105,    -1,   638,   562,  1105,    -1,    -1,    -1,    -1,
     640,   853,   547,   641,   616,   642,   643,    -1,    -1,   132,
     639,    -1,   546,   616,    -1,   645,    -1,   648,    -1,    -1,
      -1,   548,   646,   853,   647,   650,   658,   138,   548,    -1,
      -1,   548,   649,   651,   658,   138,   548,    -1,   652,    -1,
     650,   652,    -1,   655,    -1,   651,   655,    -1,    -1,    -1,
     532,   653,   853,   654,   547,   616,    -1,    -1,    -1,   532,
     656,   853,   657,   547,   616,    -1,    -1,   546,   616,    -1,
      -1,  1106,   569,   660,   662,   661,    -1,    -1,  1106,    -1,
      -1,    28,   663,   617,   615,   138,    -1,   263,   616,   138,
     263,    -1,    -1,    -1,   534,   664,   853,   125,   665,   616,
     138,   534,    -1,    -1,   394,   616,   510,   666,   853,   138,
     394,    -1,    27,    -1,     8,    -1,   219,    -1,   511,    -1,
     112,    -1,   560,   670,    -1,   686,   672,    -1,   246,  1099,
      -1,   560,   246,  1099,   561,    -1,   698,   561,   686,   672,
      -1,    -1,   675,   561,   671,  1183,    -1,    -1,    -1,  1074,
     678,   675,   673,  1180,    -1,    -1,  1074,   678,   560,   675,
     561,   674,  1183,    -1,    -1,    -1,   420,   676,   842,   846,
     677,   696,    -1,    -1,    18,    -1,    -1,   680,    -1,   681,
      -1,   680,   681,    -1,   691,    -1,   690,    -1,    -1,   683,
      -1,   684,    -1,   684,   683,    -1,   473,    -1,    -1,   209,
     859,   149,    -1,    -1,   688,    -1,   689,    -1,   689,   687,
      -1,   689,    -1,   689,   688,    -1,   689,   562,   688,    -1,
     140,   998,   692,    -1,   494,   998,   692,    -1,   286,   998,
     956,    -1,   300,   998,   956,    -1,    24,   998,   955,    -1,
     353,   998,  1102,    -1,    67,   998,  1102,    -1,    23,   998,
     956,    -1,   351,   998,   955,    -1,   351,   998,   108,    -1,
      56,   998,   955,    -1,   111,   998,   955,    -1,   413,   998,
     693,    -1,   377,   998,   694,    -1,   374,   998,   955,    -1,
     375,   998,   955,    -1,   503,   998,   560,   974,   561,    -1,
     690,    -1,   691,    -1,   220,   998,   695,    -1,    93,   119,
     998,  1102,    -1,   213,   119,   998,  1102,    -1,    76,   998,
    1102,    -1,   738,   729,   998,   731,    -1,   738,    63,   998,
     737,    -1,  1107,    -1,   108,    -1,   161,    -1,   130,    -1,
      71,    -1,   383,    -1,    70,    -1,   376,    -1,   373,    -1,
     955,    -1,   328,    -1,   160,    -1,   237,    -1,   950,    -1,
     841,   845,    -1,   461,    -1,   381,    -1,   105,    -1,   223,
      -1,   699,    -1,   698,   562,   699,    -1,   700,    -1,   701,
      -1,   706,   702,    -1,   706,   743,    -1,   751,   761,   757,
     560,   759,   561,    -1,   704,   752,   761,   757,   560,   759,
     561,    -1,   704,   166,   232,   761,   560,   759,   561,   743,
      -1,   705,   702,    -1,   704,   703,    -1,    -1,   703,    -1,
      57,   853,    -1,    -1,   705,    -1,    78,   761,    -1,    -1,
    1098,   707,   708,   725,    -1,   716,   723,   720,    -1,   717,
     724,   720,    -1,   163,   718,   720,    -1,    37,    -1,    37,
     560,   331,   561,    -1,    41,    -1,    40,    -1,   712,   560,
     331,   561,   739,    -1,   712,   739,    -1,   713,   560,   331,
     561,   740,    -1,   713,   740,    -1,    32,   560,   331,   561,
      -1,    32,    -1,   714,   560,   331,   561,   739,    -1,   715,
     560,   331,   561,   740,    -1,   524,   560,   331,   561,    -1,
     543,   723,   720,    -1,    97,    -1,   481,    -1,   478,   723,
      -1,    94,    -1,   482,    -1,    39,   723,    -1,   711,    -1,
     290,    -1,   259,    -1,   262,   524,    -1,   262,   714,   739,
      -1,   484,   739,    -1,   477,   723,   739,    -1,   292,   739,
      -1,   260,   739,    -1,   105,   718,   720,    -1,   332,   718,
     720,    -1,   161,   718,   720,    -1,    -1,   141,   709,   560,
     763,   561,   739,    -1,    -1,   426,   710,   560,   763,   561,
     739,    -1,   262,   739,    -1,   424,    -1,   183,    -1,   182,
      -1,   357,    -1,   311,    -1,   250,    -1,   310,    -1,   359,
      -1,   312,    -1,    55,    -1,   319,    -1,   316,    55,    -1,
     712,   528,    -1,   525,    -1,   316,   525,    -1,   333,    -1,
     319,   525,    -1,   316,    55,   528,    -1,   319,   528,    -1,
     223,    -1,   483,    -1,   436,    -1,   291,    -1,    31,    -1,
     381,    -1,   124,    -1,   124,   361,    -1,    -1,   560,   331,
     561,    -1,   719,    -1,   560,   331,   562,   331,   561,    -1,
      -1,   721,    -1,   721,   722,    -1,   722,    -1,   433,    -1,
     509,    -1,   544,    -1,    -1,   560,   331,   561,    -1,    -1,
     719,    -1,    -1,   726,    -1,   726,   727,    -1,   727,    -1,
     330,    -1,   859,   330,    -1,   108,   728,    -1,   337,   511,
     327,   852,    -1,    23,    -1,   424,   108,   523,    -1,   742,
     232,    -1,   504,    -1,   504,   232,    -1,    67,  1102,    -1,
      63,   735,    -1,   327,   852,    -1,  1089,    -1,    55,   426,
      -1,    54,    -1,  1107,    -1,    32,    -1,   730,    -1,   108,
      -1,    -1,   729,   731,    -1,  1107,    -1,    32,    -1,   733,
      -1,   108,    -1,  1107,    -1,    -1,    63,   737,    -1,   735,
      -1,   108,    -1,    -1,   108,    -1,    -1,    20,   740,    -1,
      45,    -1,   502,   740,    -1,   729,   730,   740,    -1,    32,
     741,    -1,    -1,    32,    -1,    -1,    20,    -1,   502,    -1,
     729,   730,    -1,    -1,   364,    -1,    -1,   384,  1099,   744,
     745,    -1,   747,    -1,   560,   746,   561,   747,    -1,   746,
     562,  1105,    -1,  1105,    -1,    -1,   748,    -1,   748,   749,
      -1,   749,    -1,   337,   112,   750,    -1,   337,   511,   750,
      -1,   283,   173,    -1,   283,   352,    -1,   283,   434,    -1,
     401,    -1,    48,    -1,   426,   330,    -1,   328,     5,    -1,
     426,   108,    -1,   753,    -1,   174,   754,    -1,   439,   754,
      -1,   364,   232,    -1,   504,   754,    -1,   232,    -1,   213,
      -1,    -1,   753,    -1,   231,    -1,   213,    -1,   212,    -1,
      -1,   504,    -1,   174,    -1,   439,    -1,    -1,   517,   758,
      -1,   494,   758,    -1,    43,    -1,   415,    -1,   196,    -1,
     759,   562,   760,   948,    -1,   760,   948,    -1,  1105,    -1,
    1105,   560,   331,   561,    -1,    -1,  1098,    -1,    -1,   567,
    1105,    -1,  1087,    -1,   763,   562,  1087,    -1,    -1,    13,
     778,   472,  1099,   765,   771,    -1,    -1,    13,    91,   770,
     766,   680,    -1,    -1,    13,   366,   596,   767,   597,    -1,
      -1,    13,   175,   596,   768,   597,    -1,    -1,    13,  1201,
    1195,  1202,   529,  1099,   769,  1205,    18,  1207,  1210,    -1,
      -1,  1105,    -1,    -1,   121,   471,    -1,   211,   471,    -1,
     773,    -1,   771,   562,   773,    -1,     6,   777,    -1,   772,
     700,   780,    -1,     6,   701,    -1,   772,   560,   698,   561,
      -1,    -1,    52,   777,  1098,   774,   706,   780,    -1,    -1,
      -1,   305,   777,  1098,   775,   708,   725,   776,   780,    -1,
     126,   777,  1098,   779,    -1,   126,   166,   232,   761,    -1,
     126,   364,   232,    -1,   126,   753,  1098,    -1,   120,   231,
      -1,   134,   231,    -1,    13,   777,  1098,   426,   108,  1089,
      -1,    13,   777,  1098,   126,   108,    -1,   391,   781,  1099,
      -1,    81,   485,   729,   731,   736,    -1,   687,    -1,   165,
      -1,   941,    -1,    -1,    66,    -1,    -1,   210,    -1,    -1,
     401,    -1,    48,    -1,    -1,     8,  1105,    -1,   160,    -1,
      -1,   485,    -1,   142,    -1,    18,    -1,    -1,   454,   435,
     787,   783,   791,    -1,   458,   435,   787,    -1,    -1,   435,
     454,   787,   784,   791,    -1,   435,   458,   787,    -1,   454,
     487,   786,    -1,    -1,   535,    77,   437,    -1,    -1,   788,
     789,    -1,   790,    -1,   789,   562,   790,    -1,    -1,   451,
      -1,   388,    -1,    -1,   510,   792,    -1,   589,    -1,   792,
     562,   589,    -1,    -1,   400,  1130,   794,   974,   171,  1102,
      -1,    -1,    26,  1130,   796,   974,   485,  1102,    -1,    -1,
      56,  1130,   798,   974,   799,    -1,    -1,   372,    -1,   153,
      -1,    -1,   392,   814,  1130,   801,   974,   802,    -1,    -1,
     803,    -1,   804,    -1,   804,   803,    -1,   372,    -1,   153,
      -1,   515,    -1,    -1,    14,   814,  1130,   806,   974,    -1,
      -1,    57,  1130,   808,   974,   809,    -1,    -1,   810,    -1,
     811,    -1,   811,   810,    -1,   372,    -1,   156,    -1,   293,
      -1,   153,    -1,    53,    -1,   168,   512,    -1,    -1,   341,
     814,  1130,   813,   974,    -1,    -1,   329,    -1,   252,    -1,
      -1,   391,  1130,   816,   818,    -1,   391,   514,   595,   817,
      -1,  1108,   485,  1108,    -1,   817,   562,  1108,   485,  1108,
      -1,   819,    -1,   818,   562,   819,    -1,  1099,   485,  1099,
      -1,    46,   213,   821,   225,   823,    -1,   822,    -1,   821,
     562,   822,    -1,  1099,   828,    -1,  1105,    -1,   108,    -1,
      -1,   251,   213,   222,    46,   825,   826,    -1,   827,    -1,
     826,   562,   827,    -1,  1099,   828,   831,    -1,    -1,   829,
     830,    -1,    -1,   754,   560,   925,   561,    -1,    -1,   210,
     241,    -1,   833,    -1,   420,   835,    -1,   560,   834,   561,
    1183,    -1,   420,   837,    -1,   560,   834,   561,    -1,    -1,
     837,   836,  1180,    -1,    -1,    -1,   838,   842,   846,   839,
     840,   845,    -1,   944,   950,    -1,   966,    -1,   841,    -1,
     966,   841,    -1,   841,   966,    -1,   171,   898,   933,   938,
     935,   944,   950,   957,    -1,   171,   127,   933,   950,    -1,
      -1,   843,    -1,   843,   844,    -1,   844,    -1,   460,    -1,
     200,    -1,   122,    -1,   449,    -1,   444,    -1,   445,    -1,
     447,    -1,   448,    -1,   446,    -1,    12,    -1,    -1,   168,
     511,    -1,   256,   225,   428,   303,    -1,   846,   562,   847,
      -1,   847,    -1,   554,    -1,   848,   850,   849,   851,    -1,
      -1,    -1,  1093,    -1,   853,    -1,    -1,    18,  1105,    -1,
      18,  1102,    -1,  1105,    -1,  1102,    -1,    -1,   560,   561,
      -1,   853,   857,   853,    -1,   853,   540,   853,    -1,   853,
     858,   853,    -1,   326,   853,    -1,   854,   226,   491,    -1,
     854,   226,   859,   491,    -1,   854,   226,   155,    -1,   854,
     226,   859,   155,    -1,   854,   226,   507,    -1,   854,   226,
     859,   507,    -1,   854,    -1,   854,   226,   330,    -1,   854,
     226,   859,   330,    -1,   854,   143,   855,    -1,   854,   861,
     855,    -1,   854,   861,   862,   560,  1189,   561,    -1,   855,
      -1,   856,   225,   560,  1189,   561,    -1,   856,   859,   225,
     560,  1189,   561,    -1,   856,   225,   560,   853,   561,    -1,
     856,   225,   560,   853,   562,   887,   561,    -1,   856,   859,
     225,   560,   853,   561,    -1,   856,   859,   225,   560,   853,
     562,   887,   561,    -1,   856,   549,   856,    16,   855,    -1,
     856,   859,   549,   856,    16,   855,    -1,   856,   438,   246,
     856,    -1,   856,   246,   864,   937,    -1,   856,   859,   246,
     864,   937,    -1,   856,   385,   856,    -1,   856,   859,   385,
     856,    -1,   856,    -1,   856,   550,   856,    -1,   856,   551,
     856,    -1,   856,   429,   856,    -1,   856,   430,   856,    -1,
     856,   553,   856,    -1,   856,   552,   856,    -1,   856,   553,
     863,   927,    -1,   856,   552,   863,   927,    -1,   856,   554,
     856,    -1,   856,   555,   856,    -1,   856,   556,   856,    -1,
     856,   123,   856,    -1,   856,   306,   856,    -1,   856,   557,
     856,    -1,   864,    -1,   347,    -1,   344,    -1,    16,    -1,
      15,    -1,   326,    -1,   325,    -1,   563,    -1,   325,    -1,
     142,    -1,   180,    -1,   194,    -1,   238,    -1,   265,    -1,
     321,    -1,    12,    -1,    17,    -1,   221,   853,    -1,  1095,
      -1,   864,    63,  1107,    -1,  1090,    -1,  1088,    -1,   877,
      -1,   873,    -1,   864,   346,   864,    -1,   553,   864,    -1,
     552,   864,    -1,   558,   864,    -1,   860,   864,    -1,   560,
    1189,   561,    -1,   560,   853,   561,    -1,   560,   853,   562,
     887,   561,    -1,   414,   560,   853,   562,   887,   561,    -1,
     149,   560,  1189,   561,    -1,   564,  1105,   853,   565,    -1,
     283,   890,     9,   560,   856,   867,   561,    -1,    20,   560,
     853,   561,    -1,    32,   864,    -1,    50,   560,   853,    18,
     885,   561,    -1,   548,   894,   896,   895,   138,    -1,    81,
     560,   853,   562,   885,   561,    -1,    81,   560,   853,   517,
     730,   561,    -1,   108,   560,  1095,   561,    -1,   522,   560,
    1096,   561,    -1,   176,   560,   561,    -1,   177,   560,   853,
     561,    -1,   178,   560,   853,   562,   853,   561,    -1,   179,
     560,   853,   562,   853,   562,   853,   561,    -1,     7,   560,
     853,   562,   853,   561,    -1,     7,   560,   853,   562,   221,
     853,   927,   561,    -1,   394,   560,   853,   562,   853,   561,
      -1,    22,   560,   853,   561,    -1,    22,   560,   853,   562,
     853,   561,    -1,    55,   560,   887,   561,    -1,    55,   560,
     887,   517,   730,   561,    -1,    54,   560,   853,   561,    -1,
      61,   560,   887,   561,    -1,    64,   560,   853,   561,    -1,
      72,   560,   887,   561,    -1,    73,   560,   853,   562,   887,
     561,    -1,    82,   560,   853,   562,   853,   562,   853,   561,
      -1,    87,   852,    -1,    90,   852,    -1,    90,   560,   853,
     561,    -1,    88,   852,    -1,    95,   560,   853,   562,   863,
     927,   561,    -1,    96,   560,   853,   562,   863,   927,   561,
      -1,    91,   560,   561,    -1,    97,   560,   853,   561,    -1,
     102,   560,   853,   561,    -1,   133,   560,   853,   562,   887,
     561,    -1,   266,   560,   853,   562,   887,   561,    -1,   137,
     560,   853,   561,    -1,   137,   560,   853,   562,   853,   561,
      -1,   107,   560,   853,   562,  1103,   561,    -1,   136,   560,
     853,   562,  1103,   561,    -1,   115,   560,   853,   561,    -1,
     115,   560,   853,   562,   853,   561,    -1,   116,   560,   853,
     561,    -1,   116,   560,   853,   562,   853,   561,    -1,   152,
     560,   853,   562,   853,   562,   853,   561,    -1,   152,   560,
     853,   562,   853,   562,   853,   562,   853,   561,    -1,   152,
     560,   853,   562,   853,   562,   853,   562,   853,   562,   853,
     561,    -1,   167,   560,   853,   562,   331,   561,    -1,   172,
     560,   853,   561,    -1,   172,   560,   853,   562,   853,   561,
      -1,   158,   560,   853,   562,   887,   561,    -1,   866,    -1,
     186,   560,   929,   562,   853,   561,    -1,   205,   560,   853,
     561,    -1,   209,   560,   853,   562,   853,   562,   853,   561,
      -1,   219,   560,   853,   562,   853,   562,   853,   562,   853,
     561,    -1,   863,   927,   553,   853,    -1,   863,    -1,   236,
     560,   561,    -1,   236,   560,   853,   561,    -1,   243,   560,
     853,   562,   853,   561,    -1,   253,   560,   853,   562,   853,
     561,    -1,   253,   560,   853,   562,   853,   562,   853,   561,
      -1,   190,   560,   853,   562,   887,   561,    -1,   240,   560,
     853,   562,   887,   561,    -1,   258,   560,   853,   561,    -1,
     258,   560,   853,   562,   853,   561,    -1,   273,   560,   853,
     562,   853,   561,    -1,   273,   560,   853,   562,   853,   562,
     853,   561,    -1,   295,   560,   853,   561,    -1,   299,   560,
     853,   561,    -1,   306,   560,   853,   562,   853,   561,    -1,
     307,   560,   853,   561,    -1,   327,   852,    -1,   327,   560,
     853,   561,    -1,   353,   560,   853,   561,    -1,   336,   560,
     853,   561,    -1,   360,   560,   856,   225,   853,   561,    -1,
     370,   560,   853,   561,    -1,   378,   560,   853,   561,    -1,
     378,   560,   561,    -1,   395,   560,   853,   562,   853,   562,
     853,   561,    -1,   406,   560,   853,   562,   853,   561,    -1,
     409,   560,   853,   561,    -1,   409,   560,   853,   562,   853,
     561,    -1,   412,   560,   561,    -1,   462,   560,   853,   562,
     853,   561,    -1,   462,   560,   853,   562,   221,   853,   927,
     561,    -1,   418,   560,   853,   561,    -1,   464,   560,   853,
     562,   853,   562,   853,   561,    -1,   464,   560,   853,   562,
     853,   561,    -1,   464,   560,   853,   171,   853,   168,   853,
     561,    -1,   464,   560,   853,   171,   853,   561,    -1,   465,
     560,   853,   562,   853,   562,   853,   561,    -1,   469,   852,
      -1,   469,   560,   853,   561,    -1,   481,   560,   853,   561,
      -1,   478,   560,   853,   561,    -1,   478,   560,   853,   562,
     853,   561,    -1,   479,   560,   928,   562,   853,   562,   853,
     561,    -1,   480,   560,   928,   562,   853,   562,   853,   561,
      -1,   490,   560,   853,   561,    -1,   490,   560,   239,   853,
     171,   853,   561,    -1,   490,   560,   486,   853,   171,   853,
     561,    -1,   490,   560,    42,   853,   171,   853,   561,    -1,
     490,   560,   239,   171,   853,   561,    -1,   490,   560,   486,
     171,   853,   561,    -1,   490,   560,    42,   171,   853,   561,
      -1,   490,   560,   853,   171,   853,   561,    -1,   492,   560,
     853,   562,   853,   561,    -1,  1105,   567,  1105,   560,   886,
     561,    -1,    -1,  1101,   560,   865,   868,   561,    -1,   505,
     560,  1086,   562,   331,   562,   331,   562,   887,   561,    -1,
     506,   560,   561,    -1,   506,   560,   853,   561,    -1,   514,
     560,   561,    -1,   518,   852,    -1,   520,   852,    -1,   519,
     852,    -1,   531,   560,   853,   561,    -1,   531,   560,   853,
     562,   853,   561,    -1,   543,   560,   853,   561,    -1,   541,
     560,   853,   561,    -1,   541,   560,   853,   562,   853,   561,
      -1,    29,   560,   955,   562,   853,   561,    -1,   154,   560,
     927,   171,   853,   561,    -1,    79,   560,   853,   562,   853,
     561,    -1,   184,   560,   853,   561,    -1,   184,   560,   853,
     562,   853,   561,    -1,   185,   560,   853,   561,    -1,   185,
     560,   853,   562,   853,   561,    -1,   182,   560,   887,   561,
      -1,   250,   560,   887,   561,    -1,   310,   560,   887,   561,
      -1,   302,   560,   853,   561,    -1,   302,   560,   853,   562,
     853,   561,    -1,   308,   560,   853,   561,    -1,   308,   560,
     853,   562,   853,   561,    -1,   309,   560,   853,   561,    -1,
     309,   560,   853,   562,   853,   561,    -1,   311,   560,   887,
     561,    -1,   312,   560,   887,   561,    -1,   357,   560,   853,
     562,   853,   561,    -1,   356,   560,   853,   561,    -1,   356,
     560,   853,   562,   853,   561,    -1,   358,   560,   853,   561,
      -1,   358,   560,   853,   562,   853,   561,    -1,   359,   560,
     887,   561,    -1,   181,   560,   853,   561,    -1,   181,   560,
     853,   562,   853,   561,    -1,   248,   560,   853,   561,    -1,
     248,   560,   853,   562,   853,   561,    -1,    -1,   535,   371,
     151,    -1,   225,    40,   303,    -1,    -1,   869,    -1,    -1,
     870,   871,    -1,   872,    -1,   871,   562,   872,    -1,   848,
     853,   849,   851,    -1,    25,   560,   883,   561,    -1,    25,
     560,   122,   883,   561,    -1,    35,   560,   883,   561,    -1,
      36,   560,   883,   561,    -1,    38,   560,   883,   561,    -1,
      83,   560,   932,   554,   561,    -1,    83,   560,   883,   561,
      -1,    -1,    -1,    83,   560,   122,   874,   887,   875,   561,
      -1,   193,   560,  1086,   562,   331,   562,   331,   562,   883,
     561,    -1,   301,   560,   883,   561,    -1,   301,   560,   122,
     883,   561,    -1,   287,   560,   883,   561,    -1,   287,   560,
     122,   883,   561,    -1,   456,   560,   883,   561,    -1,   527,
     560,   883,   561,    -1,   457,   560,   883,   561,    -1,   521,
     560,   883,   561,    -1,   466,   560,   883,   561,    -1,   466,
     560,   122,   883,   561,    -1,    -1,   192,   560,   880,   876,
     887,   882,   881,   561,    -1,    -1,   566,   878,   879,    -1,
    1107,   427,   853,    -1,  1107,    -1,   566,  1120,  1107,   762,
      -1,    -1,   122,    -1,    -1,   422,  1087,    -1,    -1,   945,
      -1,    -1,   932,   884,   853,    -1,    32,   723,    -1,    55,
     723,   739,    -1,   319,   723,    -1,   433,    -1,   433,   223,
      -1,   509,    -1,   509,   223,    -1,    97,    -1,   481,    -1,
      94,    -1,   105,   718,    -1,    -1,   887,    -1,    -1,   888,
     889,    -1,   853,    -1,   889,   562,   853,    -1,   891,    -1,
     560,   891,   561,    -1,    -1,   892,   893,    -1,  1095,    -1,
     893,   562,  1095,    -1,    -1,   853,    -1,    -1,   546,   853,
      -1,   532,   853,   547,   853,    -1,   896,   532,   853,   547,
     853,    -1,   909,    -1,   900,    -1,   899,    -1,   897,    -1,
     899,   562,   897,    -1,   897,   908,   897,    -1,   897,   460,
     909,    -1,    -1,   897,   908,   897,   337,   901,   853,    -1,
      -1,   897,   460,   909,   337,   902,   853,    -1,    -1,   897,
     908,   897,   517,   903,   560,   926,   561,    -1,   897,   317,
     230,   909,    -1,    -1,   897,   243,   919,   230,   897,   337,
     904,   853,    -1,    -1,   897,   243,   919,   230,   909,   905,
     517,   560,   926,   561,    -1,   897,   317,   243,   919,   230,
     909,    -1,    -1,   897,   406,   919,   230,   897,   337,   906,
     853,    -1,    -1,   897,   406,   919,   230,   909,   907,   517,
     560,   926,   561,    -1,   897,   317,   406,   919,   230,   909,
      -1,   230,    -1,   215,   230,    -1,    85,   230,    -1,    -1,
     910,  1099,   931,   921,    -1,    -1,   564,  1105,   897,   243,
     348,   230,   897,   337,   911,   853,   565,    -1,   918,   917,
     914,    -1,   560,   917,   912,  1183,   561,   931,    -1,    -1,
     917,   913,   899,    -1,    -1,    -1,   915,   842,   846,   916,
     696,    -1,    -1,   420,    -1,    -1,   348,    -1,    -1,   168,
     230,    -1,    -1,   516,   922,    -1,   165,   922,    -1,   210,
     922,    -1,    -1,   753,   920,   923,   560,   924,   561,    -1,
      -1,   925,    -1,   925,   562,  1105,    -1,  1105,    -1,   364,
      -1,  1105,    -1,   926,   562,  1105,    -1,   928,    -1,    98,
      -1,    99,    -1,   100,    -1,   101,    -1,   202,    -1,   203,
      -1,   204,    -1,   295,    -1,   297,    -1,   298,    -1,   417,
      -1,   542,    -1,   102,    -1,   531,    -1,   205,    -1,   170,
      -1,   299,    -1,   307,    -1,   370,    -1,   418,    -1,   543,
      -1,    97,    -1,   481,    -1,    94,    -1,   478,    -1,    -1,
      18,    -1,   142,    -1,    -1,   930,  1105,    -1,    -1,    12,
      -1,    -1,    -1,   533,   934,   853,    -1,    -1,    -1,   197,
     936,   853,    -1,   146,   864,    -1,    -1,    -1,   191,    44,
     939,   940,    -1,   939,   562,  1094,   948,    -1,  1094,   948,
      -1,    -1,   535,    86,    -1,   535,   408,    -1,   345,    44,
     942,    -1,   942,   562,   943,    -1,   943,    -1,  1096,   948,
      -1,    -1,   945,    -1,    -1,   345,    44,   946,   947,    -1,
     947,   562,  1094,   948,    -1,  1094,   948,    -1,    -1,    19,
      -1,   113,    -1,    -1,   951,    -1,    -1,   951,    -1,   247,
     952,    -1,   953,    -1,   953,   562,   953,    -1,   953,   334,
     953,    -1,  1088,    -1,   497,    -1,   261,    -1,   331,    -1,
      -1,   247,   953,    -1,   331,    -1,   199,    -1,   261,    -1,
     497,    -1,   104,    -1,   162,    -1,   331,    -1,   497,    -1,
     261,    -1,   104,    -1,   162,    -1,    -1,    -1,   366,  1105,
     958,   560,   959,   561,    -1,    -1,   960,    -1,   960,   562,
     961,    -1,   961,    -1,   848,   853,    -1,    -1,   963,   964,
      -1,   964,   562,   965,    -1,   965,    -1,   566,  1107,    -1,
    1107,    -1,    -1,   222,   967,   968,    -1,    -1,   349,  1104,
     969,  1075,  1078,    -1,   128,  1104,    -1,   962,    -1,    -1,
     125,   971,   887,    -1,   126,   977,  1130,   976,   974,   779,
      -1,    -1,   126,   213,  1105,   337,  1099,   973,    -1,   126,
      91,   976,  1105,    -1,   126,   175,   976,  1105,   567,  1105,
      -1,   126,   175,   976,  1105,    -1,   126,   366,   976,   596,
      -1,   126,   514,   595,  1160,    -1,   126,   529,   976,   974,
     779,    -1,   126,   488,   976,   596,    -1,   975,    -1,   974,
     562,   975,    -1,  1099,    -1,    -1,   209,   149,    -1,    -1,
     473,    -1,    -1,    -1,   219,   979,   984,   778,   986,   980,
     988,  1004,    -1,    -1,    -1,   395,   982,   985,   986,   983,
     988,    -1,    -1,   264,    -1,   110,    -1,   200,    -1,  1013,
      -1,   110,    -1,   222,   987,    -1,   987,    -1,   975,    -1,
     991,    -1,   560,   561,   991,    -1,   560,   990,   561,   991,
      -1,    -1,   426,   989,   995,    -1,   990,   562,  1092,    -1,
    1092,    -1,   522,   994,    -1,   523,   994,    -1,    -1,   675,
     992,  1180,    -1,    -1,   560,   675,   561,   993,  1183,    -1,
     994,   562,   999,    -1,   999,    -1,   995,   562,   996,    -1,
     996,    -1,  1096,   997,  1003,    -1,   142,    -1,   427,    -1,
      -1,   997,    -1,    -1,   560,  1000,  1001,   561,    -1,    -1,
    1002,    -1,  1002,   562,  1003,    -1,  1003,    -1,   853,    -1,
     108,    -1,    -1,    -1,   337,   129,  1005,   232,   511,  1011,
      -1,    -1,    -1,   511,  1007,  1013,   778,   898,   426,  1009,
    1008,   933,   944,   954,    -1,  1009,   562,  1010,    -1,  1010,
      -1,  1096,   997,  1003,    -1,  1011,   562,  1012,    -1,  1012,
      -1,  1096,   997,  1003,    -1,    -1,   264,    -1,    -1,   112,
    1015,  1023,  1016,    -1,    -1,   171,  1099,  1017,   933,   944,
     954,    -1,    -1,  1020,  1018,   171,   898,   933,    -1,    -1,
     171,  1020,  1019,   517,   898,   933,    -1,  1021,    -1,  1020,
     562,  1021,    -1,  1105,  1022,   931,    -1,  1105,   567,  1105,
    1022,   931,    -1,    -1,   567,   554,    -1,    -1,  1024,  1023,
      -1,   372,    -1,   264,    -1,   210,    -1,   492,  1026,   975,
      -1,    -1,   472,    -1,    -1,   431,  1028,  1029,    -1,    92,
    1040,    -1,  1036,   470,  1035,  1040,    -1,  1036,   489,  1035,
    1040,    -1,   472,   455,  1035,  1040,    -1,   340,   470,  1035,
    1040,    -1,    -1,   140,   692,  1030,  1032,    -1,  1036,    65,
    1037,  1099,  1035,  1040,    -1,   322,   281,   168,   435,   535,
     269,   142,  1102,    16,   270,   142,   956,    16,   274,   142,
     955,    -1,  1033,   257,    -1,   435,   201,    -1,    -1,    33,
     147,  1038,  1039,  1031,   949,    -1,   755,  1037,  1099,  1035,
     933,    -1,    66,   493,    -1,   472,   493,    -1,  1034,   139,
      -1,   365,    -1,    83,   560,   554,   561,   530,    -1,    83,
     560,   554,   561,   144,    -1,   530,   949,    -1,   144,   949,
      -1,  1119,   455,  1040,    -1,   216,   455,    -1,   313,   455,
      -1,  1036,   368,    -1,  1119,   526,  1040,    -1,   729,  1040,
      -1,    64,  1040,    -1,    30,   257,    -1,   257,    -1,   189,
      -1,   189,   168,  1108,    -1,    84,    91,   685,  1105,    -1,
      84,   472,  1099,    -1,    84,   529,  1099,    -1,   281,   455,
      -1,   435,   455,    -1,    84,   366,   596,    -1,    84,   175,
     596,    -1,   366,   455,  1040,    -1,   175,   455,  1040,    -1,
     366,    62,   596,    -1,   175,    62,   596,    -1,   455,    -1,
     257,    -1,   281,    -1,    32,    -1,    -1,   459,    -1,    -1,
    1037,  1105,    -1,    -1,   173,    -1,   171,    -1,   225,    -1,
      -1,   225,  1102,    -1,    -1,   171,   956,    -1,    -1,   246,
    1102,    -1,   533,   853,    -1,    -1,  1044,  1099,  1042,  1046,
      -1,    -1,  1044,  1045,  1043,   832,    -1,   113,    -1,   114,
      -1,    -1,   153,    -1,    -1,  1087,    -1,  1105,    -1,    -1,
     164,   814,  1048,  1049,    -1,  1049,   562,  1050,    -1,  1050,
      -1,    -1,  1130,  1051,  1052,    -1,   470,   535,   380,   256,
      -1,   371,    46,    -1,   201,    -1,   365,    -1,   257,    -1,
     455,    -1,   435,    -1,   281,    -1,   117,    -1,   399,    -1,
      -1,   974,    -1,    -1,   398,  1054,  1055,    -1,  1055,   562,
    1056,    -1,  1056,    -1,   435,    -1,   281,    -1,   371,    46,
      -1,    -1,   369,  1058,  1059,    -1,  1033,   257,  1060,    -1,
     485,  1102,    -1,    27,   853,    -1,    -1,   233,  1062,  1063,
     853,    -1,    -1,    76,    -1,   371,    -1,   516,  1105,    -1,
      -1,   251,    93,  1066,  1067,    -1,   251,   472,  1099,   171,
     281,    -1,    -1,    -1,    -1,    -1,  1073,  1072,   214,  1104,
    1068,  1074,   222,  1069,   472,  1099,  1070,   732,  1071,  1075,
    1078,  1081,  1082,  1085,    -1,   171,   281,    -1,    -1,   252,
      -1,    -1,    74,    -1,   264,    -1,    -1,   395,    -1,   210,
      -1,    -1,    65,  1076,    -1,  1076,  1077,    -1,  1077,    -1,
     475,    44,  1087,    -1,   343,   135,    44,  1087,    -1,   135,
      44,  1087,    -1,   145,    44,  1087,    -1,    -1,   249,  1079,
      -1,  1079,  1080,    -1,  1080,    -1,   475,    44,  1087,    -1,
     453,    44,  1087,    -1,    -1,   210,   331,   249,    -1,    -1,
     560,  1083,   561,    -1,   560,   561,    -1,  1083,   562,  1084,
      -1,  1084,    -1,  1096,    -1,   566,  1107,    -1,    -1,   426,
    1011,    -1,   476,    -1,   318,    -1,   500,   476,    -1,  1086,
    1103,    -1,  1103,    -1,   199,    -1,    34,    -1,   354,    -1,
    1090,    -1,   553,  1091,    -1,   552,  1091,    -1,  1086,    -1,
    1091,    -1,   330,    -1,   155,    -1,   491,    -1,   199,    -1,
      34,    -1,   500,   199,    -1,   500,    34,    -1,    97,  1086,
      -1,   481,  1086,    -1,   478,  1086,    -1,   331,    -1,   261,
      -1,   497,    -1,   104,    -1,   162,    -1,  1096,    -1,  1093,
      -1,  1105,   567,   554,    -1,  1105,   567,  1105,   567,   554,
      -1,   853,    -1,  1105,    -1,  1097,    -1,  1105,    -1,  1097,
      -1,  1105,   567,  1105,    -1,   567,  1105,   567,  1105,    -1,
    1105,   567,  1105,   567,  1105,    -1,  1105,    -1,  1105,   567,
    1105,   567,  1105,    -1,  1105,   567,  1105,    -1,   567,  1105,
      -1,  1105,    -1,  1105,   567,  1105,    -1,   567,  1105,    -1,
    1105,    -1,   206,    -1,   208,    -1,   476,    -1,   476,    -1,
     476,    -1,  1101,    -1,  1109,    -1,  1101,    -1,  1110,    -1,
    1105,    -1,  1102,    -1,   245,    -1,  1107,    -1,  1107,   566,
    1107,    -1,    88,   852,    -1,  1110,    -1,    20,    -1,    26,
      -1,    28,    -1,    45,    -1,    46,    -1,    54,    -1,    56,
      -1,    60,    -1,    67,    -1,    69,    -1,    79,    -1,   103,
      -1,   125,    -1,   138,    -1,   148,    -1,   164,    -1,   195,
      -1,   198,    -1,   235,    -1,   328,    -1,   340,    -1,   362,
      -1,   392,    -1,   398,    -1,   400,    -1,   407,    -1,   416,
      -1,   419,    -1,   433,    -1,   435,    -1,   454,    -1,   458,
      -1,   492,    -1,   502,    -1,   539,    -1,   512,    -1,     5,
      -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,
      -1,    17,    -1,    23,    -1,    24,    -1,    25,    -1,    30,
      -1,    33,    -1,    37,    -1,    41,    -1,    40,    -1,    43,
      -1,    49,    -1,    51,    -1,    53,    -1,    58,    -1,    59,
      -1,    62,    -1,    64,    -1,    65,    -1,    68,    -1,    70,
      -1,    71,    -1,    74,    -1,    76,    -1,    77,    -1,    86,
      -1,    93,    -1,    94,    -1,    97,    -1,   102,    -1,   109,
      -1,   111,    -1,   117,    -1,   119,    -1,   121,    -1,   128,
      -1,   129,    -1,   130,    -1,   141,    -1,   140,    -1,   139,
      -1,   144,    -1,   146,    -1,   147,    -1,   151,    -1,   153,
      -1,   156,    -1,   169,    -1,   120,    -1,   134,    -1,   173,
      -1,   159,    -1,   160,    -1,   161,    -1,   170,    -1,   183,
      -1,   182,    -1,   186,    -1,   189,    -1,   187,    -1,   196,
      -1,   201,    -1,   205,    -1,   207,    -1,   224,    -1,   211,
      -1,   212,    -1,   227,    -1,   228,    -1,   216,    -1,   220,
      -1,   388,    -1,   237,    -1,   241,    -1,   244,    -1,   250,
      -1,   252,    -1,   255,    -1,   257,    -1,   286,    -1,   281,
      -1,   268,    -1,   272,    -1,   269,    -1,   270,    -1,   282,
      -1,   271,    -1,   274,    -1,   267,    -1,   280,    -1,   276,
      -1,   275,    -1,   277,    -1,   278,    -1,   279,    -1,   284,
      -1,   285,    -1,   288,    -1,   289,    -1,   293,    -1,   294,
      -1,   295,    -1,   296,    -1,   299,    -1,   300,    -1,   305,
      -1,   303,    -1,   307,    -1,   310,    -1,   311,    -1,   312,
      -1,   313,    -1,   315,    -1,   314,    -1,   316,    -1,   319,
      -1,   320,    -1,   323,    -1,   322,    -1,   324,    -1,   333,
      -1,   334,    -1,   336,    -1,   338,    -1,   339,    -1,   351,
      -1,   352,    -1,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,   363,    -1,   365,    -1,   367,    -1,   368,    -1,   370,
      -1,   371,    -1,   372,    -1,   373,    -1,   374,    -1,   375,
      -1,   376,    -1,   377,    -1,   382,    -1,   383,    -1,   386,
      -1,   387,    -1,   390,    -1,   393,    -1,   396,    -1,   399,
      -1,   402,    -1,   403,    -1,   408,    -1,   410,    -1,   411,
      -1,   413,    -1,   414,    -1,   415,    -1,   418,    -1,   424,
      -1,   423,    -1,   425,    -1,   434,    -1,   428,    -1,   432,
      -1,   437,    -1,   438,    -1,   446,    -1,   445,    -1,   448,
      -1,   451,    -1,   455,    -1,   459,    -1,   461,    -1,   462,
      -1,   463,    -1,   467,    -1,   468,    -1,   470,    -1,   471,
      -1,   473,    -1,   474,    -1,   477,    -1,   487,    -1,   489,
      -1,   478,    -1,   479,    -1,   480,    -1,   481,    -1,   493,
      -1,   494,    -1,   495,    -1,   175,    -1,   498,    -1,   499,
      -1,   507,    -1,   510,    -1,   514,    -1,   515,    -1,   526,
      -1,   529,    -1,   523,    -1,   530,    -1,   531,    -1,   536,
      -1,   538,    -1,   543,    -1,    -1,   426,  1113,  1112,  1114,
      -1,    -1,   342,    -1,  1115,    -1,  1114,   562,  1115,    -1,
      -1,  1116,  1121,    -1,  1118,    -1,   187,    -1,   252,    -1,
     425,    -1,    -1,   338,    -1,    -1,   187,    -1,   252,    -1,
     425,    -1,    -1,   187,   567,    -1,   252,   567,    -1,   425,
     567,    -1,  1122,    -1,  1118,  1123,    -1,  1117,  1124,   997,
    1127,    -1,  1117,   487,   227,   244,  1125,    -1,   566,  1107,
     997,   853,    -1,   566,   566,  1120,  1124,   997,  1127,    -1,
     729,   734,    -1,   314,   997,   853,    -1,   314,   731,   736,
      -1,   353,   997,  1126,    -1,   353,   168,  1108,   997,  1126,
      -1,  1105,    -1,  1105,   567,  1105,    -1,   108,   567,  1105,
      -1,   380,   498,    -1,   380,    68,    -1,   393,   380,    -1,
     423,    -1,   476,    -1,   353,   560,   476,   561,    -1,   336,
     560,   476,   561,    -1,   853,    -1,   108,    -1,   337,    -1,
      12,    -1,    32,    -1,    -1,   256,  1130,  1129,  1131,    -1,
     472,    -1,   470,    -1,  1132,    -1,  1131,   562,  1132,    -1,
    1099,   931,  1133,    -1,   380,    -1,   537,    -1,   264,   537,
      -1,   380,   252,    -1,    -1,   508,  1135,  1130,    -1,   195,
    1099,   340,   931,    -1,   195,  1100,    60,    -1,    -1,   195,
    1100,   380,  1137,  1138,   933,   950,    -1,  1139,    -1,  1105,
    1140,    -1,   160,    -1,   323,    -1,   160,    -1,   323,    -1,
     363,    -1,   237,    -1,    -1,  1142,  1141,   560,  1002,   561,
      -1,   142,    -1,   180,    -1,   238,    -1,   194,    -1,   265,
      -1,   405,   595,  1144,    -1,  1148,   337,  1147,  1159,   171,
    1161,    -1,  1148,   337,   175,  1159,   171,  1161,    -1,  1148,
     337,   366,  1159,   171,  1161,    -1,    12,  1149,   562,   188,
     342,   171,  1161,    -1,   188,   595,  1146,    -1,  1148,   337,
    1147,  1159,   485,  1161,  1166,  1167,    -1,  1148,   337,   175,
    1159,   485,  1161,  1166,  1167,    -1,  1148,   337,   366,  1159,
     485,  1161,  1166,  1167,    -1,    -1,   472,    -1,  1150,    -1,
      12,  1149,    -1,    -1,   365,    -1,  1151,    -1,  1150,   562,
    1151,    -1,    -1,   420,  1152,  1163,    -1,    -1,   219,  1153,
    1163,    -1,    -1,   511,  1154,  1163,    -1,    -1,   384,  1155,
    1163,    -1,   112,    -1,   513,    -1,   213,    -1,    13,    -1,
      84,    -1,   126,    -1,   148,    -1,   390,    -1,   432,    -1,
     367,    -1,   159,    -1,   188,   342,    -1,   431,    92,    -1,
     467,    -1,    84,   473,   470,    -1,   256,   470,    -1,   396,
     435,    -1,   396,    59,    -1,    84,   529,    -1,   431,   529,
      -1,    84,   410,    -1,    13,   410,    -1,    84,   514,    -1,
      -1,    16,    -1,  1158,  1156,  1157,    -1,  1158,    -1,   463,
     476,    -1,   228,   476,    -1,    58,   476,    -1,   554,    -1,
    1105,   567,   554,    -1,   554,   567,   554,    -1,  1099,    -1,
    1108,    -1,  1160,   562,  1108,    -1,  1162,    -1,  1161,   562,
    1162,    -1,  1108,   207,    44,   476,    -1,  1108,   207,    44,
     353,   476,    -1,  1108,    -1,    -1,   560,  1164,   561,    -1,
    1164,   562,  1165,    -1,  1165,    -1,  1105,    -1,    -1,   397,
    1157,    -1,   397,   452,    -1,   397,   538,    -1,   397,   324,
      -1,    -1,   535,  1168,    -1,  1168,  1169,    -1,  1169,    -1,
     188,   342,    -1,   285,   955,    -1,   288,   955,    -1,   284,
     955,    -1,   289,   955,    -1,    -1,    28,  1171,  1172,    -1,
      -1,   536,    -1,    -1,    16,   328,    51,    -1,    16,    51,
      -1,    -1,   389,    -1,   328,   389,    -1,    -1,   416,    -1,
      69,  1172,  1173,  1174,    -1,   407,  1172,  1173,  1174,    -1,
     407,  1172,   485,  1175,  1105,    -1,   416,  1105,    -1,   389,
     416,  1105,    -1,    -1,  1181,    -1,    -1,   503,  1187,  1182,
     833,    -1,    -1,  1181,    -1,  1184,    -1,    -1,  1185,  1186,
      -1,   945,   949,    -1,   951,    -1,    -1,   122,    -1,    12,
      -1,    -1,   420,  1190,   835,  1188,  1191,    -1,   560,  1190,
     834,  1188,  1191,   561,    -1,    -1,    -1,  1197,  1193,    -1,
    1196,  1194,    -1,  1198,  1195,  1203,    -1,  1203,    -1,  1211,
      -1,  1220,    -1,  1214,    -1,  1203,    -1,  1211,    -1,  1220,
      -1,  1214,    -1,  1213,    -1,  1196,    -1,  1197,    -1,    -1,
     109,   142,  1108,    -1,  1199,    -1,  1199,  1200,    -1,  1200,
      -1,   347,   395,    -1,    11,   142,   499,    -1,    11,   142,
     294,    -1,    11,   142,   474,    -1,    -1,  1200,    -1,    -1,
     450,   419,   109,    -1,   450,   419,   224,    -1,    -1,  1202,
     529,  1099,  1204,  1205,    18,  1207,  1210,    -1,    -1,   560,
    1206,   561,    -1,  1105,    -1,  1206,   562,  1105,    -1,    -1,
    1208,  1209,    -1,   420,   848,   835,    -1,   560,   848,   834,
     561,  1183,    -1,    -1,   535,    57,   342,    -1,   535,    49,
      57,   342,    -1,   535,   252,    57,   342,    -1,    -1,   488,
     848,   596,   667,   668,   337,   848,  1099,   168,   848,   131,
     414,  1212,   631,    -1,    10,   848,   175,  1105,   403,   697,
     496,  1102,    -1,   848,   175,  1105,   403,   697,   496,  1102,
      -1,    -1,    -1,    -1,    -1,    -1,   848,   175,   596,   560,
    1215,   607,   561,  1216,   403,  1217,   708,  1218,   598,  1219,
     631,    -1,    -1,    -1,    -1,    -1,   366,   848,   596,  1221,
     560,  1222,   611,   561,  1223,   598,  1224,   631,    -1,   539,
    1227,  1226,  1228,    -1,   539,   138,  1226,  1230,    -1,   539,
     362,  1226,    -1,   539,    69,  1226,  1229,    -1,   539,   407,
    1226,    -1,   539,   382,    -1,  1087,    -1,  1087,   562,  1087,
      -1,  1087,   562,  1087,   562,   955,    -1,    28,    -1,   454,
      -1,    -1,   230,    -1,   402,    -1,    -1,   339,   355,    -1,
      -1,    -1,   468,  1231,  1232,    -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1204,  1204,  1218,  1221,  1222,  1227,  1228,  1229,  1230,
    1231,  1232,  1233,  1234,  1235,  1236,  1237,  1238,  1239,  1240,
    1241,  1242,  1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,
    1251,  1252,  1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,
    1271,  1272,  1273,  1277,  1286,  1287,  1292,  1301,  1308,  1318,
    1317,  1328,  1330,  1334,  1335,  1338,  1351,  1350,  1369,  1368,
    1379,  1380,  1383,  1388,  1393,  1398,  1403,  1407,  1412,  1416,
    1420,  1424,  1428,  1433,  1437,  1441,  1457,  1461,  1473,  1472,
    1492,  1491,  1512,  1511,  1524,  1523,  1531,  1539,  1553,  1568,
    1587,  1588,  1592,  1593,  1598,  1600,  1602,  1604,  1606,  1608,
    1610,  1616,  1617,  1618,  1622,  1626,  1634,  1633,  1646,  1648,
    1651,  1653,  1657,  1661,  1668,  1670,  1674,  1675,  1680,  1699,
    1725,  1727,  1731,  1732,  1736,  1762,  1763,  1764,  1765,  1769,
    1770,  1774,  1775,  1780,  1783,  1810,  1809,  1870,  1885,  1884,
    1931,  1957,  1957,  1989,  1990,  1995,  1997,  2002,  2025,  2031,
    2046,  2047,  2051,  2055,  2064,  2069,  2074,  2082,  2097,  2115,
    2116,  2120,  2120,  2172,  2171,  2200,  2199,  2203,  2204,  2206,
    2206,  2217,  2257,  2293,  2311,  2310,  2329,  2348,  2350,  2351,
    2355,  2376,  2399,  2404,  2419,  2399,  2438,  2440,  2441,  2445,
    2446,  2451,  2458,  2450,  2477,  2476,  2492,  2493,  2497,  2498,
    2503,  2508,  2502,  2525,  2530,  2524,  2545,  2555,  2560,  2559,
    2597,  2598,  2603,  2602,  2639,  2651,  2656,  2650,  2682,  2681,
    2704,  2706,  2711,  2713,  2715,  2720,  2721,  2722,  2728,  2737,
    2738,  2738,  2742,  2744,  2743,  2746,  2745,  2751,  2767,  2750,
    2781,  2782,  2785,  2786,  2789,  2790,  2793,  2794,  2797,  2798,
    2801,  2802,  2805,  2808,  2809,  2811,  2813,  2816,  2817,  2820,
    2821,  2822,  2825,  2826,  2827,  2828,  2829,  2830,  2831,  2832,
    2833,  2848,  2854,  2855,  2856,  2857,  2862,  2867,  2872,  2887,
    2888,  2889,  2890,  2891,  2892,  2896,  2913,  2929,  2939,  2940,
    2941,  2942,  2943,  2944,  2947,  2948,  2949,  2952,  2953,  2954,
    2957,  2958,  2961,  2962,  2963,  2964,  2967,  2968,  2972,  2973,
    2977,  2978,  2985,  2993,  3001,  3018,  3022,  3028,  3030,  3034,
    3038,  3039,  3043,  3048,  3047,  3069,  3070,  3071,  3072,  3074,
    3076,  3078,  3080,  3082,  3084,  3087,  3090,  3093,  3096,  3098,
    3101,  3104,  3105,  3106,  3107,  3120,  3121,  3123,  3125,  3137,
    3139,  3141,  3143,  3144,  3145,  3146,  3147,  3148,  3150,  3152,
    3154,  3154,  3156,  3156,  3158,  3159,  3168,  3169,  3170,  3173,
    3174,  3175,  3176,  3177,  3181,  3185,  3186,  3190,  3191,  3195,
    3196,  3197,  3198,  3199,  3203,  3204,  3205,  3206,  3207,  3210,
    3212,  3213,  3217,  3218,  3219,  3222,  3229,  3230,  3233,  3234,
    3237,  3238,  3239,  3242,  3243,  3246,  3247,  3250,  3251,  3254,
    3255,  3258,  3259,  3260,  3261,  3263,  3264,  3270,  3276,  3282,
    3288,  3289,  3305,  3306,  3310,  3311,  3315,  3323,  3327,  3328,
    3331,  3332,  3336,  3345,  3349,  3350,  3353,  3363,  3364,  3368,
    3369,  3372,  3373,  3376,  3377,  3378,  3379,  3388,  3389,  3392,
    3393,  3396,  3397,  3398,  3407,  3409,  3411,  3416,  3415,  3427,
    3428,  3431,  3432,  3436,  3437,  3440,  3441,  3444,  3445,  3446,
    3447,  3448,  3451,  3452,  3453,  3454,  3455,  3458,  3459,  3460,
    3472,  3473,  3476,  3477,  3480,  3481,  3485,  3486,  3487,  3490,
    3491,  3492,  3493,  3506,  3507,  3508,  3511,  3512,  3516,  3519,
    3520,  3523,  3524,  3535,  3536,  3539,  3540,  3543,  3544,  3552,
    3551,  3575,  3574,  3588,  3587,  3606,  3605,  3625,  3623,  3643,
    3644,  3646,  3647,  3648,  3649,  3650,  3653,  3661,  3662,  3666,
    3671,  3670,  3678,  3687,  3677,  3699,  3706,  3710,  3717,  3724,
    3730,  3736,  3742,  3749,  3767,  3788,  3793,  3797,  3804,  3805,
    3808,  3809,  3813,  3814,  3815,  3819,  3820,  3821,  3824,  3825,
    3826,  3827,  3835,  3834,  3845,  3853,  3852,  3862,  3872,  3881,
    3882,  3889,  3889,  3895,  3896,  3900,  3901,  3902,  3906,  3907,
    3924,  3925,  3930,  3929,  3940,  3939,  3950,  3949,  3959,  3960,
    3961,  3966,  3965,  3977,  3978,  3981,  3982,  3985,  3986,  3987,
    3991,  3990,  4003,  4002,  4019,  4020,  4023,  4024,  4027,  4028,
    4029,  4030,  4031,  4032,  4036,  4035,  4047,  4048,  4049,  4054,
    4053,  4059,  4066,  4071,  4079,  4080,  4083,  4095,  4104,  4105,
    4108,  4121,  4122,  4127,  4126,  4136,  4137,  4140,  4153,  4153,
    4163,  4164,  4173,  4174,  4183,  4192,  4194,  4197,  4219,  4223,
    4222,  4244,  4252,  4244,  4258,  4259,  4260,  4261,  4262,  4265,
    4272,  4279,  4281,  4292,  4293,  4296,  4297,  4303,  4304,  4305,
    4306,  4312,  4318,  4324,  4338,  4341,  4343,  4349,  4359,  4360,
    4361,  4374,  4400,  4407,  4414,  4415,  4418,  4419,  4420,  4421,
    4422,  4426,  4427,  4431,  4480,  4485,  4526,  4528,  4530,  4532,
    4534,  4536,  4538,  4540,  4544,  4546,  4548,  4550,  4552,  4554,
    4557,  4561,  4567,  4571,  4577,  4581,  4591,  4593,  4599,  4602,
    4604,  4606,  4607,  4609,  4612,  4614,  4616,  4618,  4620,  4622,
    4624,  4626,  4628,  4630,  4632,  4634,  4636,  4638,  4640,  4643,
    4643,  4644,  4644,  4645,  4645,  4646,  4646,  4648,  4649,  4650,
    4651,  4652,  4653,  4656,  4657,  4661,  4666,  4667,  4674,  4675,
    4676,  4677,  4678,  4680,  4681,  4682,  4683,  4684,  4688,  4689,
    4694,  4699,  4703,  4704,  4708,  4709,  4713,  4720,  4722,  4728,
    4730,  4741,  4743,  4754,  4765,  4776,  4787,  4789,  4791,  4793,
    4795,  4797,  4799,  4801,  4803,  4805,  4807,  4809,  4811,  4817,
    4819,  4821,  4826,  4831,  4833,  4835,  4840,  4842,  4844,  4846,
    4848,  4853,  4854,  4856,  4858,  4860,  4862,  4864,  4866,  4868,
    4870,  4872,  4874,  4876,  4880,  4882,  4892,  4894,  4896,  4898,
    4900,  4903,  4912,  4917,  4922,  4924,  4926,  4928,  4930,  4932,
    4934,  4936,  4941,  4946,  4948,  4950,  4952,  4954,  4956,  4958,
    4964,  4966,  4968,  4970,  4972,  4974,  4976,  4978,  4980,  4981,
    4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,  5009,
    5016,  5018,  5020,  5022,  5024,  5026,  5028,  5030,  5032,  5034,
    5036,  5038,  5040,  5042,  5044,  5059,  5058,  5198,  5202,  5207,
    5209,  5211,  5213,  5215,  5217,  5222,  5224,  5226,  5228,  5230,
    5235,  5239,  5241,  5243,  5245,  5247,  5249,  5253,  5256,  5259,
    5261,  5263,  5265,  5267,  5269,  5271,  5274,  5277,  5279,  5281,
    5283,  5285,  5287,  5290,  5292,  5294,  5296,  5301,  5302,  5303,
    5307,  5308,  5312,  5312,  5318,  5322,  5329,  5360,  5362,  5364,
    5366,  5368,  5370,  5372,  5375,  5377,  5374,  5380,  5382,  5389,
    5391,  5393,  5395,  5397,  5399,  5401,  5403,  5405,  5408,  5407,
    5422,  5421,  5436,  5442,  5448,  5461,  5462,  5466,  5469,  5474,
    5477,  5489,  5488,  5504,  5505,  5506,  5507,  5508,  5509,  5510,
    5511,  5512,  5513,  5514,  5518,  5519,  5523,  5523,  5528,  5529,
    5532,  5533,  5536,  5536,  5541,  5542,  5545,  5546,  5549,  5550,
    5553,  5559,  5569,  5570,  5579,  5584,  5585,  5605,  5607,  5611,
    5609,  5626,  5624,  5642,  5640,  5647,  5656,  5654,  5672,  5671,
    5681,  5692,  5690,  5709,  5708,  5719,  5729,  5730,  5731,  5736,
    5736,  5755,  5753,  5772,  5794,  5842,  5841,  5864,  5882,  5864,
    5889,  5893,  5919,  5920,  5922,  5924,  5927,  5928,  5934,  5941,
    5950,  5949,  5956,  5957,  5961,  5965,  5969,  5975,  5983,  5992,
    5993,  5994,  5995,  5996,  5997,  5998,  5999,  6000,  6001,  6002,
    6003,  6004,  6007,  6008,  6009,  6010,  6011,  6012,  6013,  6014,
    6015,  6019,  6020,  6021,  6022,  6025,  6027,  6028,  6031,  6032,
    6035,  6037,  6041,  6043,  6042,  6056,  6059,  6058,  6073,  6079,
    6092,  6094,  6097,  6099,  6103,  6104,  6117,  6135,  6139,  6140,
    6144,  6157,  6159,  6163,  6162,  6194,  6196,  6200,  6201,  6202,
    6207,  6213,  6217,  6218,  6222,  6226,  6233,  6240,  6249,  6253,
    6254,  6255,  6260,  6264,  6272,  6273,  6274,  6275,  6276,  6277,
    6281,  6282,  6283,  6284,  6285,  6288,  6291,  6290,  6319,  6320,
    6323,  6324,  6327,  6342,  6342,  6352,  6353,  6357,  6369,  6402,
    6401,  6414,  6413,  6422,  6434,  6445,  6444,  6461,  6468,  6468,
    6480,  6487,  6503,  6522,  6534,  6538,  6544,  6554,  6555,  6558,
    6566,  6567,  6571,  6572,  6580,  6589,  6579,  6599,  6606,  6598,
    6616,  6628,  6629,  6630,  6634,  6635,  6638,  6639,  6642,  6651,
    6652,  6653,  6655,  6654,  6664,  6665,  6668,  6669,  6670,  6670,
    6671,  6671,  6675,  6676,  6679,  6681,  6684,  6692,  6693,  6697,
    6698,  6703,  6702,  6715,  6716,  6719,  6724,  6732,  6733,  6736,
    6738,  6738,  6746,  6755,  6745,  6777,  6778,  6781,  6788,  6789,
    6792,  6801,  6802,  6808,  6807,  6821,  6820,  6829,  6828,  6836,
    6835,  6845,  6846,  6849,  6856,  6869,  6870,  6874,  6875,  6878,
    6879,  6880,  6883,  6893,  6895,  6900,  6899,  6913,  6921,  6930,
    6939,  6948,  6958,  6957,  6960,  6970,  6980,  6984,  6989,  6988,
    6993,  7003,  7008,  7014,  7019,  7024,  7026,  7028,  7030,  7032,
    7041,  7043,  7045,  7047,  7056,  7064,  7072,  7074,  7076,  7086,
    7093,  7099,  7107,  7115,  7119,  7123,  7130,  7137,  7147,  7157,
    7167,  7180,  7194,  7207,  7208,  7210,  7212,  7215,  7216,  7219,
    7220,  7223,  7224,  7227,  7228,  7231,  7232,  7234,  7236,  7239,
    7251,  7250,  7265,  7264,  7274,  7275,  7278,  7279,  7283,  7284,
    7285,  7293,  7292,  7304,  7305,  7308,  7308,  7309,  7310,  7311,
    7312,  7313,  7314,  7315,  7316,  7317,  7318,  7321,  7322,  7326,
    7325,  7334,  7335,  7338,  7339,  7340,  7344,  7343,  7353,  7357,
    7361,  7373,  7373,  7381,  7382,  7383,  7388,  7398,  7397,  7413,
    7431,  7442,  7449,  7459,  7430,  7464,  7473,  7474,  7477,  7478,
    7490,  7494,  7495,  7496,  7498,  7500,  7503,  7504,  7507,  7512,
    7519,  7524,  7530,  7532,  7535,  7536,  7539,  7544,  7550,  7552,
    7559,  7560,  7561,  7564,  7566,  7571,  7572,  7577,  7578,  7584,
    7602,  7610,  7615,  7634,  7636,  7647,  7660,  7681,  7682,  7683,
    7692,  7693,  7694,  7699,  7700,  7701,  7702,  7703,  7723,  7742,
    7743,  7744,  7747,  7748,  7749,  7750,  7758,  7773,  7774,  7777,
    7783,  7794,  7797,  7834,  7838,  7846,  7850,  7918,  7933,  7957,
    7958,  7974,  7984,  7987,  7988,  7989,  7993,  7997,  7998,  8023,
    8035,  8048,  8060,  8061,  8070,  8071,  8080,  8081,  8082,  8085,
    8098,  8111,  8125,  8126,  8127,  8128,  8129,  8130,  8131,  8132,
    8133,  8134,  8135,  8136,  8137,  8138,  8139,  8140,  8141,  8142,
    8143,  8144,  8145,  8146,  8147,  8148,  8149,  8150,  8151,  8152,
    8153,  8154,  8155,  8156,  8157,  8158,  8159,  8160,  8161,  8171,
    8172,  8173,  8174,  8175,  8176,  8177,  8178,  8179,  8180,  8181,
    8182,  8183,  8184,  8185,  8186,  8187,  8188,  8189,  8190,  8191,
    8192,  8193,  8194,  8195,  8196,  8197,  8198,  8199,  8200,  8201,
    8202,  8203,  8204,  8205,  8206,  8207,  8208,  8209,  8210,  8211,
    8212,  8213,  8214,  8215,  8216,  8217,  8218,  8219,  8220,  8221,
    8222,  8223,  8224,  8225,  8226,  8227,  8228,  8229,  8230,  8231,
    8232,  8233,  8234,  8235,  8236,  8237,  8238,  8239,  8240,  8241,
    8242,  8243,  8244,  8245,  8246,  8247,  8248,  8249,  8250,  8251,
    8252,  8253,  8254,  8255,  8256,  8257,  8258,  8259,  8260,  8261,
    8262,  8263,  8264,  8265,  8266,  8267,  8268,  8269,  8270,  8271,
    8272,  8273,  8274,  8275,  8276,  8277,  8278,  8279,  8280,  8281,
    8282,  8283,  8284,  8285,  8286,  8287,  8288,  8289,  8290,  8291,
    8292,  8293,  8294,  8295,  8296,  8297,  8298,  8299,  8300,  8301,
    8302,  8303,  8304,  8305,  8306,  8307,  8308,  8309,  8310,  8311,
    8312,  8313,  8314,  8315,  8316,  8317,  8318,  8319,  8320,  8321,
    8322,  8323,  8324,  8325,  8326,  8327,  8328,  8329,  8330,  8331,
    8332,  8333,  8334,  8335,  8336,  8337,  8338,  8339,  8340,  8341,
    8342,  8343,  8344,  8345,  8346,  8347,  8348,  8349,  8350,  8351,
    8352,  8353,  8354,  8355,  8356,  8357,  8358,  8359,  8360,  8361,
    8362,  8363,  8364,  8365,  8366,  8367,  8368,  8369,  8370,  8371,
    8372,  8373,  8374,  8375,  8376,  8377,  8378,  8379,  8380,  8381,
    8382,  8383,  8390,  8389,  8403,  8404,  8407,  8408,  8411,  8411,
    8489,  8490,  8491,  8492,  8496,  8497,  8501,  8502,  8503,  8504,
    8508,  8509,  8510,  8511,  8515,  8516,  8519,  8601,  8614,  8618,
    8623,  8630,  8645,  8658,  8679,  8686,  8724,  8767,  8781,  8782,
    8783,  8784,  8788,  8789,  8796,  8805,  8806,  8807,  8808,  8809,
    8817,  8816,  8832,  8833,  8836,  8837,  8840,  8848,  8849,  8850,
    8851,  8856,  8855,  8876,  8888,  8901,  8900,  8919,  8920,  8924,
    8925,  8929,  8930,  8931,  8932,  8934,  8933,  8944,  8945,  8946,
    8947,  8948,  8954,  8959,  8966,  8979,  8991,  8998,  9003,  9011,
    9024,  9038,  9040,  9043,  9044,  9051,  9053,  9057,  9058,  9061,
    9061,  9062,  9062,  9063,  9063,  9064,  9064,  9065,  9066,  9067,
    9068,  9069,  9070,  9071,  9072,  9073,  9074,  9075,  9076,  9077,
    9078,  9079,  9080,  9081,  9082,  9083,  9084,  9085,  9086,  9087,
    9092,  9093,  9097,  9098,  9102,  9112,  9122,  9135,  9149,  9162,
    9175,  9188,  9189,  9198,  9199,  9208,  9233,  9235,  9242,  9246,
    9249,  9250,  9253,  9274,  9275,  9279,  9283,  9287,  9294,  9295,
    9298,  9299,  9303,  9304,  9310,  9316,  9322,  9332,  9331,  9341,
    9342,  9346,  9347,  9348,  9352,  9353,  9354,  9358,  9359,  9363,
    9373,  9380,  9390,  9399,  9413,  9414,  9419,  9418,  9453,  9454,
    9455,  9459,  9459,  9483,  9484,  9488,  9489,  9490,  9494,  9499,
    9504,  9511,  9532,  9554,  9556,  9558,  9563,  9564,  9565,  9566,
    9570,  9571,  9572,  9573,  9574,  9584,  9585,  9590,  9603,  9616,
    9618,  9620,  9625,  9630,  9632,  9634,  9640,  9641,  9647,  9648,
    9650,  9656,  9655,  9670,  9671,  9675,  9680,  9688,  9688,  9706,
    9715,  9728,  9729,  9731,  9733,  9746,  9744,  9820,  9831,  9849,
    9883,  9891,  9899,  9911,  9845,  9944,  9975,  9984,  9993,  9943,
   10017, 10021, 10025, 10029, 10033, 10037, 10043, 10050, 10057, 10066,
   10067, 10071, 10072, 10073, 10077, 10078, 10082, 10083, 10083, 10088,
   10089
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "sp_a_chistics", "sp_c_chistics", "sp_chistic", "sp_c_chistic",
  "sp_suid", "call", "@8", "opt_sp_cparam_list", "opt_sp_cparams",
  "sp_cparams", "sp_fdparam_list", "sp_fdparams", "sp_init_param",
  "sp_fdparam", "sp_pdparam_list", "sp_pdparams", "sp_pdparam",
  "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1", "sp_decls", "sp_decl",
  "@9", "@10", "sp_cursor_stmt", "@11", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "opt_value", "sp_hcond", "sp_decl_idents",
  "sp_opt_default", "sp_proc_stmt", "@12", "@13", "@14", "@15", "@16",
  "sp_opt_fetch_noise", "sp_fetch_list", "sp_if", "@17", "@18", "@19",
  "sp_elseifs", "case_stmt_specification", "simple_case_stmt", "@20",
  "@21", "searched_case_stmt", "@22", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@23", "@24",
  "searched_when_clause", "@25", "@26", "else_clause_opt",
  "sp_labeled_control", "@27", "sp_opt_label", "sp_unlabeled_control",
  "@28", "@29", "@30", "@31", "trg_action_time", "trg_event", "create2",
  "create2a", "@32", "create3", "@33", "@34", "create_select", "@35",
  "@36", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_type", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "@37",
  "type", "@38", "@39", "spatial_type", "char", "nchar", "varchar",
  "nvarchar", "int_type", "real_type", "float_options", "precision",
  "field_options", "field_opt_list", "field_option", "opt_len",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@40", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@41", "@42", "@43", "@44",
  "@45", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@46", "@47", "@48", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@49", "@50", "start",
  "start_transaction_opts", "slave_thread_opts", "@51",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@52", "backup", "@53", "checksum", "@54",
  "opt_checksum_type", "repair", "@55", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@56", "check", "@57",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@58", "opt_no_write_to_binlog", "rename", "@59", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@60", "preload_list",
  "preload_keys", "cache_keys_spec", "@61", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@62", "select_part2", "@63", "@64", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@65",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@66", "udf_expr_list3", "udf_expr", "sum_expr", "@67",
  "@68", "@69", "variable", "@70", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@71",
  "cast_type", "opt_expr_list", "expr_list", "@72", "expr_list2",
  "ident_list_arg", "ident_list", "@73", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@74", "@75", "@76", "@77", "@78",
  "@79", "@80", "normal_join", "table_factor", "@81", "@82",
  "select_derived", "@83", "select_derived2", "@84", "@85",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@86", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@87", "having_clause", "@88", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@89", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@90", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@91",
  "select_var_list", "select_var_ident", "into", "@92", "into_destination",
  "@93", "do", "@94", "drop", "@95", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@96", "@97", "replace", "@98",
  "@99", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@100", "fields", "insert_values",
  "@101", "@102", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@103", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@104", "update", "@105", "@106",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@107", "single_multi", "@108", "@109",
  "@110", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@111", "show_param", "@112", "@113", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@114", "@115",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@116", "flush_options", "flush_option", "@117",
  "opt_table_list", "reset", "@118", "reset_options", "reset_option",
  "purge", "@119", "purge_options", "purge_option", "kill", "@120",
  "kill_option", "use", "load", "@121", "load_data", "@122", "@123",
  "@124", "@125", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@126", "opt_option", "option_value_list", "option_type_value",
  "@127", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@128",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@129", "handler", "@130", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@131",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@132", "@133", "@134",
  "@135", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@136", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@137",
  "union_opt", "union_order_or_limit", "@138", "order_or_limit",
  "union_option", "take_first_select", "subselect", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "definer_tail",
  "no_definer_tail", "definer_opt", "no_definer", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@139", "view_list_opt",
  "view_list", "view_select", "@140", "view_select_aux",
  "view_check_option", "trigger_tail", "@141", "udf_tail", "sf_tail",
  "@142", "@143", "@144", "@145", "@146", "sp_tail", "@147", "@148",
  "@149", "@150", "xa", "xid", "begin_or_start", "opt_join_or_resume",
  "opt_one_phase", "opt_suspend", "@151", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   600,   601,   601,   603,   602,   604,   604,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     611,   611,   612,   612,   613,   614,   614,   614,   614,   615,
     615,   616,   616,   617,   617,   619,   618,   618,   620,   618,
     618,   622,   621,   623,   623,   624,   624,   625,   626,   626,
     627,   627,   628,   628,   628,   628,   628,   629,   629,   630,
     630,   632,   631,   633,   631,   634,   631,   631,   631,   635,
     631,   631,   631,   631,   636,   631,   631,   637,   637,   637,
     638,   638,   640,   641,   642,   639,   643,   643,   643,   644,
     644,   646,   647,   645,   649,   648,   650,   650,   651,   651,
     653,   654,   652,   656,   657,   655,   658,   658,   660,   659,
     661,   661,   663,   662,   662,   664,   665,   662,   666,   662,
     667,   667,   668,   668,   668,   669,   669,   669,   669,   670,
     671,   670,   672,   673,   672,   674,   672,   676,   677,   675,
     678,   678,   679,   679,   680,   680,   681,   681,   682,   682,
     683,   683,   684,   685,   685,   686,   686,   687,   687,   688,
     688,   688,   689,   689,   689,   689,   689,   689,   689,   689,
     689,   689,   689,   689,   689,   689,   689,   689,   689,   689,
     689,   689,   689,   689,   689,   690,   691,   692,   693,   693,
     693,   693,   693,   693,   694,   694,   694,   695,   695,   695,
     696,   696,   697,   697,   697,   697,   698,   698,   699,   699,
     700,   700,   701,   701,   701,   701,   701,   702,   702,   703,
     704,   704,   705,   707,   706,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     709,   708,   710,   708,   708,   708,   711,   711,   711,   711,
     711,   711,   711,   711,   712,   713,   713,   714,   714,   715,
     715,   715,   715,   715,   716,   716,   716,   716,   716,   717,
     717,   717,   718,   718,   718,   719,   720,   720,   721,   721,
     722,   722,   722,   723,   723,   724,   724,   725,   725,   726,
     726,   727,   727,   727,   727,   727,   727,   727,   727,   727,
     727,   727,   728,   728,   729,   729,   730,   730,   731,   731,
     732,   732,   733,   733,   734,   734,   735,   736,   736,   737,
     737,   738,   738,   739,   739,   739,   739,   739,   739,   740,
     740,   741,   741,   741,   741,   742,   742,   744,   743,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   749,
     749,   749,   750,   750,   750,   750,   750,   751,   751,   751,
     752,   752,   753,   753,   754,   754,   755,   755,   755,   756,
     756,   756,   756,   757,   757,   757,   758,   758,   758,   759,
     759,   760,   760,   761,   761,   762,   762,   763,   763,   765,
     764,   766,   764,   767,   764,   768,   764,   769,   764,   770,
     770,   771,   771,   771,   771,   771,   772,   773,   773,   773,
     774,   773,   775,   776,   773,   773,   773,   773,   773,   773,
     773,   773,   773,   773,   773,   773,   773,   773,   777,   777,
     778,   778,   779,   779,   779,   780,   780,   780,   781,   781,
     781,   781,   783,   782,   782,   784,   782,   782,   785,   786,
     786,   788,   787,   789,   789,   790,   790,   790,   791,   791,
     792,   792,   794,   793,   796,   795,   798,   797,   799,   799,
     799,   801,   800,   802,   802,   803,   803,   804,   804,   804,
     806,   805,   808,   807,   809,   809,   810,   810,   811,   811,
     811,   811,   811,   811,   813,   812,   814,   814,   814,   816,
     815,   815,   817,   817,   818,   818,   819,   820,   821,   821,
     822,   823,   823,   825,   824,   826,   826,   827,   829,   828,
     830,   830,   831,   831,   832,   833,   833,   834,   834,   836,
     835,   838,   839,   837,   840,   840,   840,   840,   840,   841,
     841,   842,   842,   843,   843,   844,   844,   844,   844,   844,
     844,   844,   844,   844,   844,   845,   845,   845,   846,   846,
     846,   847,   848,   849,   850,   850,   851,   851,   851,   851,
     851,   852,   852,   853,   853,   853,   853,   853,   853,   853,
     853,   853,   853,   853,   854,   854,   854,   854,   854,   854,
     855,   855,   855,   855,   855,   855,   855,   855,   855,   855,
     855,   855,   855,   855,   856,   856,   856,   856,   856,   856,
     856,   856,   856,   856,   856,   856,   856,   856,   856,   857,
     857,   858,   858,   859,   859,   860,   860,   861,   861,   861,
     861,   861,   861,   862,   862,   863,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   865,   864,   864,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   866,   866,   866,   866,   866,   866,   866,   866,   866,
     866,   866,   866,   866,   866,   866,   866,   866,   866,   866,
     866,   866,   866,   866,   866,   866,   866,   867,   867,   867,
     868,   868,   870,   869,   871,   871,   872,   873,   873,   873,
     873,   873,   873,   873,   874,   875,   873,   873,   873,   873,
     873,   873,   873,   873,   873,   873,   873,   873,   876,   873,
     878,   877,   879,   879,   879,   880,   880,   881,   881,   882,
     882,   884,   883,   885,   885,   885,   885,   885,   885,   885,
     885,   885,   885,   885,   886,   886,   888,   887,   889,   889,
     890,   890,   892,   891,   893,   893,   894,   894,   895,   895,
     896,   896,   897,   897,   898,   899,   899,   900,   900,   901,
     900,   902,   900,   903,   900,   900,   904,   900,   905,   900,
     900,   906,   900,   907,   900,   900,   908,   908,   908,   910,
     909,   911,   909,   909,   909,   913,   912,   915,   916,   914,
     917,   918,   919,   919,   920,   920,   921,   921,   921,   921,
     923,   922,   924,   924,   925,   925,   925,   926,   926,   927,
     927,   927,   927,   927,   927,   927,   927,   927,   927,   927,
     927,   927,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   929,   929,   929,   929,   930,   930,   930,   931,   931,
     932,   932,   933,   934,   933,   935,   936,   935,   937,   937,
     938,   938,   939,   939,   940,   940,   940,   941,   942,   942,
     943,   944,   944,   946,   945,   947,   947,   948,   948,   948,
     949,   949,   950,   950,   951,   952,   952,   952,   953,   953,
     953,   953,   954,   954,   955,   955,   955,   955,   955,   955,
     956,   956,   956,   956,   956,   957,   958,   957,   959,   959,
     960,   960,   961,   963,   962,   964,   964,   965,   965,   967,
     966,   969,   968,   968,   968,   971,   970,   972,   973,   972,
     972,   972,   972,   972,   972,   972,   972,   974,   974,   975,
     976,   976,   977,   977,   979,   980,   978,   982,   983,   981,
     984,   984,   984,   984,   985,   985,   986,   986,   987,   988,
     988,   988,   989,   988,   990,   990,   991,   991,   992,   991,
     993,   991,   994,   994,   995,   995,   996,   997,   997,   998,
     998,  1000,   999,  1001,  1001,  1002,  1002,  1003,  1003,  1004,
    1005,  1004,  1007,  1008,  1006,  1009,  1009,  1010,  1011,  1011,
    1012,  1013,  1013,  1015,  1014,  1017,  1016,  1018,  1016,  1019,
    1016,  1020,  1020,  1021,  1021,  1022,  1022,  1023,  1023,  1024,
    1024,  1024,  1025,  1026,  1026,  1028,  1027,  1029,  1029,  1029,
    1029,  1029,  1030,  1029,  1029,  1029,  1029,  1029,  1031,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1032,  1032,  1033,  1033,  1034,  1034,  1035,  1035,  1036,
    1036,  1037,  1037,  1038,  1038,  1039,  1039,  1040,  1040,  1040,
    1042,  1041,  1043,  1041,  1044,  1044,  1045,  1045,  1046,  1046,
    1046,  1048,  1047,  1049,  1049,  1051,  1050,  1050,  1050,  1050,
    1050,  1050,  1050,  1050,  1050,  1050,  1050,  1052,  1052,  1054,
    1053,  1055,  1055,  1056,  1056,  1056,  1058,  1057,  1059,  1060,
    1060,  1062,  1061,  1063,  1063,  1063,  1064,  1066,  1065,  1065,
    1068,  1069,  1070,  1071,  1067,  1067,  1072,  1072,  1073,  1073,
    1073,  1074,  1074,  1074,  1075,  1075,  1076,  1076,  1077,  1077,
    1077,  1077,  1078,  1078,  1079,  1079,  1080,  1080,  1081,  1081,
    1082,  1082,  1082,  1083,  1083,  1084,  1084,  1085,  1085,  1086,
    1086,  1086,  1086,  1087,  1087,  1087,  1088,  1089,  1089,  1089,
    1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,  1090,
    1090,  1090,  1091,  1091,  1091,  1091,  1091,  1092,  1092,  1093,
    1093,  1094,  1095,  1095,  1096,  1096,  1097,  1097,  1097,  1098,
    1098,  1098,  1098,  1099,  1099,  1099,  1100,  1101,  1101,  1102,
    1103,  1104,  1105,  1105,  1106,  1106,  1107,  1107,  1107,  1108,
    1108,  1108,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,
    1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,
    1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,
    1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1109,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,  1110,
    1110,  1110,  1112,  1111,  1113,  1113,  1114,  1114,  1116,  1115,
    1117,  1117,  1117,  1117,  1118,  1118,  1119,  1119,  1119,  1119,
    1120,  1120,  1120,  1120,  1121,  1121,  1122,  1122,  1123,  1123,
    1123,  1123,  1123,  1123,  1123,  1124,  1124,  1124,  1125,  1125,
    1125,  1125,  1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,
    1129,  1128,  1130,  1130,  1131,  1131,  1132,  1133,  1133,  1133,
    1133,  1135,  1134,  1136,  1136,  1137,  1136,  1138,  1138,  1139,
    1139,  1140,  1140,  1140,  1140,  1141,  1140,  1142,  1142,  1142,
    1142,  1142,  1143,  1144,  1144,  1144,  1144,  1145,  1146,  1146,
    1146,  1147,  1147,  1148,  1148,  1149,  1149,  1150,  1150,  1152,
    1151,  1153,  1151,  1154,  1151,  1155,  1151,  1151,  1151,  1151,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,
    1156,  1156,  1157,  1157,  1158,  1158,  1158,  1159,  1159,  1159,
    1159,  1160,  1160,  1161,  1161,  1162,  1162,  1162,  1163,  1163,
    1164,  1164,  1165,  1166,  1166,  1166,  1166,  1166,  1167,  1167,
    1168,  1168,  1169,  1169,  1169,  1169,  1169,  1171,  1170,  1172,
    1172,  1173,  1173,  1173,  1174,  1174,  1174,  1175,  1175,  1176,
    1177,  1177,  1178,  1179,  1180,  1180,  1182,  1181,  1183,  1183,
    1183,  1185,  1184,  1186,  1186,  1187,  1187,  1187,  1188,  1189,
    1189,  1190,  1191,  1192,  1192,  1192,  1193,  1193,  1193,  1193,
    1194,  1194,  1194,  1194,  1194,  1195,  1195,  1196,  1197,  1198,
    1198,  1198,  1199,  1200,  1200,  1200,  1201,  1201,  1202,  1202,
    1202,  1204,  1203,  1205,  1205,  1206,  1206,  1208,  1207,  1209,
    1209,  1210,  1210,  1210,  1210,  1212,  1211,  1213,  1213,  1215,
    1216,  1217,  1218,  1219,  1214,  1221,  1222,  1223,  1224,  1220,
    1225,  1225,  1225,  1225,  1225,  1225,  1226,  1226,  1226,  1227,
    1227,  1228,  1228,  1228,  1229,  1229,  1230,  1231,  1230,  1232,
    1232
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       0,     2,     0,     2,     2,     2,     2,     2,     3,     3,
       1,     1,     1,     2,     3,     3,     0,     4,     0,     3,
       0,     1,     3,     1,     0,     1,     3,     1,     0,     3,
       0,     1,     3,     1,     4,     0,     1,     1,     1,     0,
       3,     2,     3,     0,     3,     0,     5,     5,     0,     7,
       5,     0,     2,     1,     1,     1,     3,     1,     1,     3,
       0,     1,     1,     1,     1,     2,     1,     1,     3,     0,
       2,     0,     2,     0,     3,     0,     5,     1,     1,     0,
       2,     2,     2,     2,     0,     6,     2,     0,     2,     1,
       1,     3,     0,     0,     0,     7,     0,     2,     2,     1,
       1,     0,     0,     8,     0,     6,     1,     2,     1,     2,
       0,     0,     6,     0,     0,     6,     0,     2,     0,     5,
       0,     1,     0,     5,     4,     0,     0,     8,     0,     7,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     4,
       0,     4,     0,     0,     5,     0,     7,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     1,
       1,     3,     4,     4,     3,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     2,     6,     7,     8,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     4,     3,     3,     3,     1,     4,
       1,     1,     5,     2,     5,     2,     4,     1,     5,     5,
       4,     3,     1,     1,     2,     1,     1,     2,     1,     1,
       1,     2,     3,     2,     3,     2,     2,     3,     3,     3,
       0,     6,     0,     6,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     3,     1,     5,     0,     1,     2,     1,
       1,     1,     1,     0,     3,     0,     1,     0,     1,     2,
       1,     1,     2,     2,     4,     1,     3,     2,     1,     2,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     0,     1,     0,     2,     1,     2,     3,     2,     0,
       1,     0,     1,     1,     2,     0,     1,     0,     4,     1,
       4,     3,     1,     0,     1,     2,     1,     3,     3,     2,
       2,     2,     1,     1,     2,     2,     2,     1,     2,     2,
       2,     2,     1,     1,     0,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     2,     2,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     0,     2,     1,     3,     0,
       6,     0,     5,     0,     5,     0,     5,     0,    11,     0,
       1,     0,     2,     2,     1,     3,     2,     3,     2,     4,
       0,     6,     0,     0,     8,     4,     4,     3,     3,     2,
       2,     6,     5,     3,     5,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     1,     0,     2,     1,     0,     1,
       1,     1,     0,     5,     3,     0,     5,     3,     3,     0,
       3,     0,     2,     1,     3,     0,     1,     1,     0,     2,
       1,     3,     0,     6,     0,     6,     0,     5,     0,     1,
       1,     0,     6,     0,     1,     1,     2,     1,     1,     1,
       0,     5,     0,     5,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     0,     5,     0,     1,     1,     0,
       4,     4,     3,     5,     1,     3,     3,     5,     1,     3,
       2,     1,     1,     0,     6,     1,     3,     3,     0,     2,
       0,     4,     0,     2,     1,     2,     4,     2,     3,     0,
       3,     0,     0,     6,     2,     1,     1,     2,     2,     8,
       4,     0,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     4,     3,     1,
       1,     4,     0,     0,     1,     1,     0,     2,     2,     1,
       1,     0,     2,     3,     3,     3,     2,     3,     4,     3,
       4,     3,     4,     1,     3,     4,     3,     3,     6,     1,
       5,     6,     5,     7,     6,     8,     5,     6,     4,     4,
       5,     3,     4,     1,     3,     3,     3,     3,     3,     3,
       4,     4,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     3,     1,     1,
       1,     1,     3,     2,     2,     2,     2,     3,     3,     5,
       6,     4,     4,     7,     4,     2,     6,     5,     6,     6,
       4,     4,     3,     4,     6,     8,     6,     8,     6,     4,
       6,     4,     6,     4,     4,     4,     4,     6,     8,     2,
       2,     4,     2,     7,     7,     3,     4,     4,     6,     6,
       4,     6,     6,     6,     4,     6,     4,     6,     8,    10,
      12,     6,     4,     6,     6,     1,     6,     4,     8,    10,
       4,     1,     3,     4,     6,     6,     8,     6,     6,     4,
       6,     6,     8,     4,     4,     6,     4,     2,     4,     4,
       4,     6,     4,     4,     3,     8,     6,     4,     6,     3,
       6,     8,     4,     8,     6,     8,     6,     8,     2,     4,
       4,     4,     6,     8,     8,     4,     7,     7,     7,     6,
       6,     6,     6,     6,     6,     0,     5,    10,     3,     4,
       3,     2,     2,     2,     4,     6,     4,     4,     6,     6,
       6,     6,     4,     6,     4,     6,     4,     4,     4,     4,
       6,     4,     6,     4,     6,     4,     4,     6,     4,     6,
       4,     6,     4,     4,     6,     4,     6,     0,     3,     3,
       0,     1,     0,     2,     1,     3,     4,     4,     5,     4,
       4,     4,     5,     4,     0,     0,     7,    10,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       1,     0,     3,     2,     3,     2,     1,     2,     1,     2,
       1,     1,     1,     2,     0,     1,     0,     2,     1,     3,
       1,     3,     0,     2,     1,     3,     0,     1,     0,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     3,     0,
       6,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     2,     0,
       4,     0,    11,     3,     6,     0,     3,     0,     0,     5,
       0,     1,     0,     1,     0,     2,     0,     2,     2,     2,
       0,     6,     0,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     0,     2,
       0,     1,     0,     0,     3,     0,     0,     3,     2,     0,
       0,     4,     4,     2,     0,     2,     2,     3,     3,     1,
       2,     0,     1,     0,     4,     4,     2,     0,     1,     1,
       0,     1,     0,     1,     2,     1,     3,     3,     1,     1,
       1,     1,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     0,     6,     0,     1,
       3,     1,     2,     0,     2,     3,     1,     2,     1,     0,
       3,     0,     5,     2,     1,     0,     3,     6,     0,     6,
       4,     6,     4,     4,     4,     5,     4,     1,     3,     1,
       0,     2,     0,     1,     0,     0,     8,     0,     0,     6,
       0,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       3,     4,     0,     3,     3,     1,     2,     2,     0,     3,
       0,     5,     3,     1,     3,     1,     3,     1,     1,     0,
       1,     0,     4,     0,     1,     3,     1,     1,     1,     0,
       0,     6,     0,     0,    11,     3,     1,     3,     3,     1,
       3,     0,     1,     0,     4,     0,     6,     0,     5,     0,
       6,     1,     3,     3,     5,     0,     2,     0,     2,     1,
       1,     1,     3,     0,     1,     0,     3,     2,     4,     4,
       4,     4,     0,     4,     6,    16,     2,     2,     0,     6,
       5,     2,     2,     2,     1,     5,     5,     2,     2,     3,
       2,     2,     2,     3,     2,     2,     2,     1,     1,     3,
       4,     3,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     0,     1,     0,     2,     0,
       1,     1,     1,     0,     2,     0,     2,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     0,     1,     0,     1,
       1,     0,     4,     3,     1,     0,     3,     4,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       3,     3,     1,     1,     1,     2,     0,     3,     3,     2,
       2,     0,     4,     0,     1,     1,     2,     0,     4,     5,
       0,     0,     0,     0,    18,     2,     0,     1,     0,     1,
       1,     0,     1,     1,     0,     2,     2,     1,     3,     4,
       3,     3,     0,     2,     2,     1,     3,     3,     0,     3,
       0,     3,     2,     3,     1,     1,     2,     0,     2,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     0,     1,     1,     3,     0,     2,
       1,     1,     1,     1,     0,     1,     0,     1,     1,     1,
       0,     2,     2,     2,     1,     2,     4,     5,     4,     6,
       2,     3,     3,     3,     5,     1,     3,     3,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     0,     3,     4,     3,     0,     7,     1,     2,     1,
       1,     1,     1,     1,     1,     0,     5,     1,     1,     1,
       1,     1,     3,     6,     6,     6,     7,     3,     8,     8,
       8,     0,     1,     1,     2,     0,     1,     1,     3,     0,
       3,     0,     3,     0,     3,     0,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     1,     3,     1,     2,     2,     2,     1,     3,     3,
       1,     1,     3,     1,     3,     4,     5,     1,     0,     3,
       3,     1,     1,     0,     2,     2,     2,     2,     0,     2,
       2,     1,     2,     2,     2,     2,     2,     0,     3,     0,
       1,     0,     3,     2,     0,     1,     2,     0,     1,     4,
       4,     5,     2,     3,     0,     1,     0,     4,     0,     1,
       1,     0,     2,     2,     1,     0,     1,     1,     0,     5,
       6,     0,     0,     2,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     1,
       2,     1,     2,     3,     3,     3,     0,     1,     0,     3,
       3,     0,     8,     0,     3,     1,     3,     0,     2,     3,
       5,     0,     3,     4,     4,     0,    14,     8,     7,     0,
       0,     0,     0,     0,    15,     0,     0,     0,     0,    12,
       4,     4,     3,     4,     3,     2,     1,     3,     5,     1,
       1,     0,     1,     1,     0,     2,     0,     0,     3,     0,
       2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1966,   626,     0,  1907,     0,     0,     0,     0,
       0,  1909,    94,    54,  1253,  1344,  1345,  1175,  1192,     0,
     626,    97,     0,    66,  1194,  1381,     0,     0,   626,     0,
    1376,     0,     0,   626,  1197,  1369,     0,    97,  1909,     0,
     661,  1744,  1275,     0,     0,     0,  1273,  1801,  1242,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   654,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1346,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   529,     0,   561,
       0,     0,  1967,  1957,   628,   627,     0,  1793,  1792,   594,
    1909,     0,  1529,  1530,  1531,  1532,  1533,  1534,  1535,  1493,
    1536,  1537,  1538,  1494,  1495,  1539,  1540,  1541,  1543,  1542,
    1544,  1496,  1497,  1545,  1546,  1547,  1498,  1499,  1548,  1549,
    1500,  1550,  1551,  1552,  1501,  1553,  1502,  1554,  1555,  1556,
    1557,  1558,  1503,  1559,  1560,  1561,  1562,  1563,  1504,  1564,
    1565,  1566,  1567,  1582,  1568,  1505,  1569,  1570,  1571,  1583,
    1506,  1574,  1573,  1572,  1575,  1576,  1577,  1507,  1578,  1579,
    1580,  1585,  1586,  1587,  1508,  1581,  1588,  1584,  1727,  1590,
    1589,  1591,  1593,  1592,  1509,  1594,  1510,  1595,  1596,  1477,
    1597,  1478,  1599,  1600,  1603,  1604,  1598,  1601,  1602,  1511,
    1606,  1607,  1608,  1609,  1610,  1611,  1612,  1622,  1615,  1617,
    1618,  1620,  1616,  1621,  1625,  1624,  1626,  1627,  1628,  1623,
    1614,  1619,  1629,  1630,  1613,  1631,  1632,  1633,  1634,  1635,
    1636,  1637,  1638,  1640,  1639,  1641,  1642,  1643,  1644,  1645,
    1647,  1646,  1648,  1649,  1650,  1652,  1651,  1653,  1512,  1654,
    1655,  1656,  1657,  1658,  1513,  1659,  1660,  1661,  1662,  1663,
    1664,  1514,  1665,  1666,  1667,  1668,  1669,  1670,  1671,  1672,
    1673,  1674,  1675,  1676,  1677,  1678,  1679,  1680,  1605,  1681,
    1515,  1682,  1683,  1516,  1684,  1517,  1685,  1686,  1518,  1687,
    1688,  1689,  1690,  1691,  1692,  1519,  1693,  1520,  1695,  1694,
    1696,  1698,  1699,  1521,  1697,  1522,  1700,  1701,  1703,  1702,
    1704,  1705,  1523,  1706,  1524,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1720,  1721,  1722,  1723,
    1718,  1719,  1525,  1724,  1725,  1726,  1728,  1729,  1526,  1730,
    1731,  1528,  1732,  1733,  1736,  1734,  1735,  1737,  1738,  1739,
    1740,  1527,  1741,   116,  1482,    99,  1483,  1492,     0,   596,
     612,  1910,  1911,   263,   501,   502,   262,   500,    97,  1957,
       0,   259,   260,     0,  1267,   996,  1190,  1190,     0,  1190,
    1193,  1190,    97,  1190,     0,    59,  1351,     0,     0,     0,
       0,  1476,     0,  1200,  1383,  1387,     0,     0,  1790,     0,
       0,     0,     0,    97,   629,     0,  1251,     0,   592,     0,
    1911,  1922,   655,   659,   671,  1745,  1742,  1329,   581,   581,
     581,   579,   581,  1274,     0,     0,  1251,  1386,  2009,     0,
       0,     0,  2005,     0,  2010,     0,   661,     0,     0,     1,
       3,     0,  1579,  1342,  1340,  1473,     0,   521,   530,   525,
     523,     0,     0,  1968,  1955,  1956,   610,     0,  1908,     0,
     638,   648,   118,     0,    68,     0,     0,     0,  1914,     0,
       0,     0,     0,    95,   692,   692,  1957,  1959,  1961,   263,
     261,     0,  1271,  1270,  1269,     0,  1267,  1176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1190,    61,     0,
    1835,  1850,  1851,  1847,  1852,  1853,  1857,     0,  1849,  1841,
       0,  1856,  1845,  1854,     0,  1839,     0,  1855,  1860,  1843,
    1848,  1827,     0,  1833,  1837,  1475,  1095,  1804,  1805,     0,
    1488,  1479,  1487,  1486,    67,  1202,  1203,  1201,   560,  1384,
    1385,     0,  1398,     0,     0,     0,   624,     0,  1324,  1323,
       0,  1377,  1923,     0,     0,   601,  1205,  1252,     0,  1204,
    1374,     0,  1373,  1370,  1372,     0,  1835,  1822,     0,  1917,
    1914,  1924,   684,   677,   676,   679,   680,   683,   681,   682,
     678,   675,   692,   672,   674,  1748,     0,     0,   435,     0,
    1337,     0,     0,     0,  1337,     0,  1130,  1330,     0,  1757,
    1308,   498,   497,     0,   496,  1758,  1307,  1323,     0,     0,
       0,  1294,     0,  1759,     0,  1326,     0,  1130,  1337,     0,
    1276,     0,     0,     0,     0,   575,   585,   577,   572,     0,
     578,   574,  1272,  1189,  1802,   560,  1435,  1434,  1480,  2006,
    1433,  2014,  2016,  2002,  2004,  2011,   657,     0,  1928,    53,
       0,  1348,  1964,  1965,  1963,   451,   100,   100,   519,     0,
       0,     0,     0,     0,  1187,     0,     0,   640,   650,   120,
     117,    98,     0,   598,   614,  1913,     0,     0,  1915,  1919,
     754,   753,     0,    92,   701,  1489,  1887,    96,  1883,  1962,
     692,   692,   692,     0,  1944,     0,  1950,  1951,  1954,  1953,
    1952,     0,  1943,  1946,  1947,  1949,  1948,  1968,  1960,     0,
     503,     0,  1254,  1257,  1261,  1265,  1268,  1530,  1493,     0,
    1538,     0,     0,  1446,     0,     0,     0,     0,  1498,     0,
       0,  1551,     0,     0,  1503,     0,     0,     0,   701,   701,
     701,     0,     0,     0,  1562,  1563,  1455,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1443,     0,  1456,
       0,     0,     0,     0,     0,     0,     0,  1590,     0,     0,
    1591,     0,     0,     0,  1445,  1596,     0,     0,     0,     0,
       0,     0,     0,  1609,     0,     0,  1453,     0,     0,  1002,
       0,  1635,  1637,     0,     0,     0,  1641,     0,     0,  1642,
    1643,  1644,  1430,   756,     0,   701,  1442,  1452,  1656,  1661,
    1436,     0,  1663,     0,  1664,     0,  1669,     0,     0,     0,
       0,     0,     0,  1691,  1693,     0,     0,  1709,     0,     0,
       0,   701,  1429,  1720,  1721,  1722,  1723,     0,  1444,  1525,
    1454,     0,     0,     0,  1732,   701,   701,   701,     0,     0,
       0,  1738,     0,  1741,  1006,     0,     0,     0,     0,   755,
       0,   970,     0,   998,   713,   719,   733,     0,   841,   748,
     835,   771,   770,   997,  1440,   769,   768,  1441,   766,  1463,
    1482,  1462,  1191,  1180,  1182,     0,  1183,  1186,  1881,  1184,
     562,     0,     0,    60,  1365,  1359,  1361,  1364,  1360,     0,
    1366,  1363,  1362,  1793,  1352,  1354,  1355,  1836,  1834,  1868,
    1867,     0,  1869,  1865,  1858,  1888,  1862,  1888,  1864,  1863,
    1888,  1859,  1866,  1888,  1831,     0,  1096,  1097,     0,  1803,
       0,  1474,     0,  1382,  1399,     0,  1400,  1388,  1396,   643,
       0,  1095,  1791,  1794,     0,     0,    56,    57,     0,   631,
       0,   630,   634,     0,     0,     0,  1208,  1198,  1207,  1375,
       0,     0,  1834,  1831,  1918,     0,  1920,  1935,   660,  1925,
     690,   662,   689,     0,   673,  1743,  1746,  1754,  1306,  1333,
     434,     0,     0,  1305,  1291,     0,   263,     0,     0,     0,
       0,  1277,  1282,   297,     0,  1298,  1131,     0,  1337,     0,
    1300,  1313,  1301,     0,  1327,     0,  1337,  1287,  1314,  1327,
    1292,  1297,  1304,  1331,  1332,     0,  1286,  1293,     0,  1302,
    1327,  1327,  1337,  1337,   588,   587,   586,   582,   583,   588,
       0,  1039,     0,     0,  2003,  2017,  2001,  2012,  2013,  2000,
     658,  1929,   656,  1930,     0,  1343,  1341,  1349,  1350,   452,
     451,   254,   257,   256,     0,   526,   524,   451,  1958,     0,
       0,   611,     0,     0,   642,   637,   641,   639,   493,   492,
     495,     0,   649,     0,   121,   123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    69,    70,    83,   600,   599,   597,   622,   621,   619,
       0,   620,   618,   613,   615,   616,  1912,  1916,   264,   451,
       0,  1491,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1945,    88,     0,     0,     0,  1259,  1255,  1265,     0,
       0,     0,  1095,     0,     0,     0,  1100,     0,   785,  1100,
    1100,  1100,     0,     0,   996,   996,     0,   996,     0,     0,
       0,     0,  1100,   809,   812,     0,   810,     0,     0,     0,
       0,     0,  1449,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   996,     0,     0,     0,     0,   975,     0,     0,
       0,     0,   765,     0,     0,     0,     0,   996,     0,     0,
       0,     0,  1002,     0,  1000,     0,  1100,     0,     0,  1100,
       0,     0,     0,     0,     0,   996,   996,   996,   706,     0,
     857,     0,     0,     0,     0,     0,   996,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1100,  1100,     0,
       0,     0,  1100,     0,   878,     0,  1451,     0,     0,     0,
    1450,     0,     0,  1448,  1447,  1431,     0,     0,     0,   901,
     903,   902,  1100,     0,  1100,     0,     0,     0,  1007,     0,
     774,   773,   775,  1941,     0,     0,     0,     0,     0,     0,
     752,   751,   750,   749,     0,     0,     0,   757,     0,   758,
     759,     0,   760,   761,   762,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   776,  1070,  1071,  1072,  1073,  1082,
    1085,  1074,  1075,  1076,  1084,  1077,  1078,  1079,  1086,  1087,
    1088,  1080,  1089,  1083,  1081,  1090,     0,  1069,     0,     0,
       0,  1432,   895,     0,     0,  1178,     0,   564,   563,  1185,
     562,     0,    62,    64,  1358,     0,     0,  1367,  1861,     0,
    1842,  1846,  1840,  1844,     0,     0,  1832,     0,  1838,  1099,
    1586,  1651,     0,  1102,  1807,  1195,  1395,  1397,     0,     0,
    1389,     0,     0,   625,    58,     0,     0,  1378,     0,     0,
       0,     0,   603,  1206,     0,  1371,     0,     0,     0,     0,
       0,  1921,  1937,  1936,  1926,   692,  1121,   693,   695,   694,
    1462,  1748,  1751,  1752,  1755,  1753,     0,  1750,  1749,  1764,
       0,  1335,  1338,  1339,     0,     0,  1316,  1315,  1311,  1312,
       0,  1140,  1141,  1139,  1134,  1135,  1138,  1320,  1318,  1309,
       0,  1337,     0,  1319,  1317,  1337,  1327,     0,  1337,  1337,
    1299,  1303,     0,   576,   585,   573,   580,  1051,  1050,     0,
    1015,     0,  1014,  1013,  1012,     0,  1050,  2007,  2015,  2019,
       0,  1130,  1934,  1932,   255,  1229,  1229,     0,     0,     0,
       0,     0,     0,     0,   101,   110,   558,   558,  1229,  1229,
     558,  1229,  1229,  1229,     0,     0,  1229,     0,     0,   558,
       0,  1229,   556,     0,     0,  1229,  1229,  1229,   558,     0,
    1229,  1229,  1229,  1229,  1229,   568,  1229,  1229,  1229,   555,
     267,   289,   290,   520,     0,   534,   557,  1969,  1970,   527,
     595,  1188,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   623,   617,    93,   451,   702,  1490,     0,  1884,     0,
    1995,     0,     0,    99,  1971,   265,   506,   508,   507,   505,
     504,     0,     0,  1102,     0,  1262,  1039,  1266,  1265,  1263,
       0,     0,     0,  1101,  1100,     0,   981,  1148,  1149,  1145,
    1146,  1144,  1147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   954,     0,   981,
       0,   815,     0,     0,     0,     0,     0,     0,  1462,     0,
       0,     0,     0,     0,  1941,     0,     0,     0,     0,     0,
       0,   792,     0,     0,     0,     0,     0,     0,     0,  1093,
    1091,  1094,  1092,     0,     0,   976,   968,     0,     0,     0,
       0,   842,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1003,  1004,  1100,     0,     0,     0,  1100,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   864,     0,
       0,     0,     0,     0,   869,     0,     0,     0,     0,     0,
       0,     0,  1100,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   898,     0,   900,     0,     0,
    1465,  1464,     0,     0,     0,     0,     0,  1008,   661,     0,
     778,   996,   777,     0,  1760,   971,   973,     0,   704,   703,
     705,   716,   709,   714,   707,   711,     0,   763,  1535,   717,
       0,   745,     0,  1109,   746,   731,   736,   737,     0,     0,
     734,   735,   739,   841,   738,   841,   742,   743,   744,   747,
       0,     0,     0,     0,     0,   767,   772,   999,   942,  1466,
    1181,  1179,  1882,  1177,    65,     0,     0,  1353,  1368,  1356,
    1892,     0,  1891,  1877,  1880,  1473,     0,     0,     0,  1817,
    1811,  1818,  1820,  1814,  1819,  1821,  1812,  1813,  1808,  1815,
    1103,  1132,     0,     0,   644,   645,   648,     0,  1797,  1798,
    1796,  1795,  1380,  1379,     0,   632,   635,   636,   608,   607,
     609,   602,   604,   605,   247,  1212,     0,     0,     0,  1218,
    1199,  1209,   593,     0,     0,     0,     0,     0,   688,  1039,
    1169,   685,   666,  1132,  1122,   665,   696,     0,  1747,     0,
    1718,  1775,     0,     0,     0,     0,     0,  1765,  1334,     0,
    1288,     0,  1310,  1322,  1321,  1283,     0,     0,     0,  1281,
    1328,  1280,  1102,  1327,  1278,  1279,   590,   589,   584,  1050,
    1039,     0,     0,  1036,  1052,     0,  1052,  1039,  1039,     0,
    1039,  1095,  1047,     0,     0,  2018,  1123,  1933,  1227,  1228,
    1230,     0,     0,   104,   107,   105,     0,   106,     0,     0,
     559,   513,   494,   494,   538,     0,   327,   513,   487,   536,
       0,     0,     0,     0,     0,     0,     0,     0,  1229,     0,
     549,   532,     0,     0,     0,     0,   550,     0,   533,  1229,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     571,   570,   569,     0,     0,     0,     0,   268,   451,   330,
       0,   565,   327,   333,  1469,  1973,  1066,     0,  1065,   122,
      76,    72,    84,  1153,  1154,  1152,  1150,  1151,    85,    74,
      75,    79,    78,    80,    81,    82,    77,    73,    86,    87,
      71,     0,  1885,     0,     0,   231,   230,     0,  1989,     0,
    1973,     0,   330,    89,  1401,   266,   269,    90,  1039,  1121,
    1265,  1102,     0,  1095,     0,   784,   799,     0,     0,   947,
       0,     0,   949,   950,   951,     0,   803,     0,   801,   804,
     805,   806,   996,     0,     0,     0,     0,   996,   953,     0,
     811,     0,     0,   816,   817,     0,   790,     0,   824,     0,
     826,     0,   996,     0,   820,     0,   781,     0,     0,   996,
       0,   832,     0,   793,     0,     0,   933,     0,   916,   912,
       0,   914,     0,     0,   996,   996,     0,   837,     0,     0,
     843,   996,     0,   935,     0,   917,     0,   849,     0,   996,
       0,  1001,     0,     0,     0,   960,   853,   854,     0,   958,
     919,     0,     0,   856,   921,     0,   923,     0,   918,   925,
     926,   858,   860,   859,   928,     0,     0,   930,     0,   932,
       0,   862,   863,     0,     0,     0,   867,     0,   996,   872,
     962,   964,     0,     0,     0,     0,     0,   966,   879,   881,
       0,     0,     0,   880,     0,     0,     0,     0,     0,     0,
       0,   885,     0,     0,   899,   965,   791,   963,   904,     0,
     907,     0,   906,     0,     0,     0,     0,  1938,  1938,     0,
     782,     0,     0,     0,     0,     0,  1467,   710,   715,   708,
     712,     0,     0,     0,     0,   729,   728,     0,   741,   740,
       0,  1109,   732,     0,   840,     0,   941,   692,   996,     0,
      63,  1357,  1889,     0,     0,     0,     0,     0,     0,     0,
       0,  1806,  1133,  1239,  1481,  1390,     0,   652,  1799,  1800,
       0,   606,   671,     0,  1231,  1216,  1223,  1217,     0,     0,
       0,  1215,  1458,  1457,  1464,  1924,     0,     0,     0,     0,
    1927,  1102,  1102,  1163,     0,     0,   663,   668,   664,   667,
       0,   691,   700,   699,  1459,  1466,     0,     0,     0,     0,
     437,   439,   438,   447,     0,   436,     0,     0,  1760,     0,
     443,   445,   444,  1770,   442,  1336,  1130,  1296,  1295,  1137,
    1136,     0,  1290,  1337,     0,  1931,  1045,     0,  1038,  1037,
    1053,     0,  1039,  1052,  1052,     0,  1018,  1017,  1243,  1246,
       0,  1016,  1056,  1043,   671,  2008,  2020,     0,   450,   449,
     296,   446,   295,   109,   108,   114,   115,   332,   514,   488,
     489,     0,     0,     0,   494,   326,   513,   325,   328,   503,
       0,   279,   276,   540,   282,   278,   294,     0,     0,   283,
     513,   547,   548,   562,   272,     0,   308,   309,   307,   291,
     274,   275,   542,  1117,  1119,  1127,   281,   280,   277,   286,
     287,   305,   304,   285,   306,   553,   303,   301,   298,   300,
     299,   302,   284,   273,     0,   535,     0,   316,   318,   319,
    1472,     0,   567,   537,     0,   320,   321,     0,     0,     0,
       0,   651,     0,  1886,     0,  1996,   234,   232,   233,     0,
     124,   314,   315,   313,   312,     0,     0,   237,     0,   235,
       0,     0,  1403,  1402,   236,   250,   451,   270,     0,  1102,
    1142,  1258,  1264,     0,     0,     0,   948,   982,     0,   413,
     413,   992,   990,   402,   413,   986,   991,   988,     0,     0,
       0,     0,     0,     0,     0,   955,   952,     0,     0,     0,
    1466,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   979,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   937,
    1005,   961,   959,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   967,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1009,   787,
    1942,  1942,   779,  1761,  1762,  1763,   515,   972,     0,   722,
     996,   720,  1108,   726,     0,     0,   730,     0,   896,     0,
     943,   944,     0,   995,  1468,  1890,  1879,  1878,  1893,  1893,
    1893,     0,  1104,     0,  1196,  1401,   646,     0,   647,   633,
     692,  1213,  1225,     0,  1233,     0,     0,  1210,  1220,     0,
       0,     0,  1219,     0,  1824,  1825,  1823,  1132,  1110,     0,
       0,  1174,     0,  1170,   686,     0,   698,   697,     0,  1777,
       0,  1776,  1788,  1789,  1786,  1787,  1785,  1766,     0,  1772,
    1771,     0,     0,     0,  1782,  1773,     0,     0,  1289,     0,
    1284,   591,     0,  1039,  1052,  1039,  1025,     0,     0,  1039,
    1021,  1019,  1023,     0,  1102,     0,     0,     0,     0,  1040,
     692,  1461,  1124,  1127,   329,   513,   490,   491,   503,     0,
       0,     0,     0,   447,   292,   546,   545,   293,     0,     0,
    1128,  1129,  1120,     0,   539,   330,   566,   467,   398,   347,
     338,   413,   341,   340,   384,   355,   352,   402,   400,   370,
     402,   402,   377,   376,   394,   380,   360,   453,   453,   359,
     397,   453,   381,   379,   383,     0,   385,   402,   390,   378,
     382,   399,   375,   372,   396,   413,   413,   353,   356,   395,
     453,     0,   388,   413,   417,   358,   453,   459,     0,     0,
     413,   415,  1471,  1975,     0,  1977,  1064,     0,   135,   692,
       0,   125,   127,   128,     0,  1977,     0,   240,   265,   251,
       0,   271,     0,  1260,     0,  1256,   765,   796,   800,   909,
       0,   983,   453,     0,   993,   404,   985,   987,   989,   786,
     802,   807,   911,   789,   788,     0,     0,     0,     0,   822,
     825,   827,   818,   823,   821,     0,   910,   834,   831,   833,
     794,     0,   934,   913,   915,   836,   847,   977,   980,     0,
       0,     0,   848,   844,   936,   845,     0,   850,   819,   851,
       0,     0,     0,     0,   920,   855,   922,   924,   929,   927,
     931,   861,   798,     0,   866,   868,   780,   765,   870,     0,
     876,   874,     0,     0,   882,     0,     0,   891,     0,   889,
       0,   890,     0,   892,   893,     0,   905,   908,  1010,     0,
    1939,     0,     0,   974,   718,     0,   724,   996,   721,   727,
     693,   692,   894,     0,  1898,  1898,  1898,  1238,  1237,     0,
    1236,  1240,     0,   653,   248,     0,     0,     0,  1234,  1222,
    1928,  1211,  1214,  1466,  1826,   670,     0,  1105,  1173,  1171,
       0,  1164,  1166,  1168,     0,  1460,     0,     0,  1781,  1767,
     448,     0,     0,     0,     0,  1768,     0,  1095,  1046,     0,
       0,  1012,  1039,  1039,     0,  1012,     0,     0,     0,  1245,
    1121,  1247,  1054,  1058,  1059,  1057,  1048,     0,  1126,     0,
       0,     0,   552,     0,   565,   554,   417,  1118,   288,   317,
     473,     0,     0,   357,   406,   401,     0,   406,   406,   459,
     461,   455,   459,     0,   366,   384,   361,     0,   453,   374,
     365,   386,   389,   391,   393,   406,     0,   453,   354,   363,
       0,   406,   425,     0,     0,     0,   421,     0,   466,     0,
     428,   334,   418,   420,     0,     0,   387,     0,   343,   460,
       0,   345,     0,     0,   406,     0,   416,   406,     0,  1974,
       0,  1981,     0,     0,   138,   136,   137,     0,   131,   133,
     128,     0,  1990,     0,     0,  1988,  1981,   238,  1928,  1401,
       0,   243,     0,  1127,   511,  1143,     0,     0,   984,     0,
       0,   956,   813,   814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   783,     0,     0,     0,     0,
       0,     0,     0,   888,   886,   887,     0,  1011,  1940,   516,
     723,     0,   696,   945,     0,     0,  1897,  1895,     0,  1896,
    1894,  1870,     0,  1829,  1830,  1828,  1816,     0,     0,  1391,
    1132,  1224,  1226,  1232,  1221,     0,  1106,  1121,  1404,  1167,
       0,   687,  1779,  1778,  1780,  1774,     0,     0,     0,     0,
    1044,  1039,  1026,     0,  1030,  1035,  1031,     0,  1022,  1020,
       0,  1142,     0,  1060,  1132,  1127,     0,     0,     0,     0,
       0,     0,     0,     0,   551,  1437,   541,   543,     0,     0,
       0,   468,   469,   474,   476,     0,     0,   410,   411,   412,
     367,   407,   409,     0,   369,   337,   454,   462,   463,     0,
     458,   456,   459,   362,   392,   368,     0,   364,     0,   351,
     431,   430,   701,   423,   433,     0,     0,   429,   419,   427,
     422,     0,     0,     0,     0,   335,     0,   336,  1470,  1976,
       0,   528,   692,   692,  1978,  1987,  1997,   135,     0,     0,
       0,   126,   129,  1972,   241,   239,     0,  1924,    91,     0,
     510,     0,   797,   414,   403,     0,   808,   828,     0,   795,
     978,   969,  1100,   838,     0,   846,   852,   939,   938,   865,
     871,   875,   873,   877,   883,   884,   996,   725,   946,  1876,
    1875,  1874,  1871,     0,     0,     0,     0,     0,     0,  1899,
    1901,  1235,     0,     0,   249,   685,   310,  1114,  1127,     0,
    1132,     0,  1412,  1165,  1784,  1783,  1769,     0,     0,     0,
       0,     0,     0,     0,  1067,  1244,  1055,     0,  1049,  1125,
       0,     0,   322,  1439,  1438,   565,   479,   480,   481,     0,
       0,     0,   472,   475,   346,   339,   408,     0,   517,   464,
     457,     0,   350,   432,   701,   426,   453,   459,   453,   459,
       0,     0,     0,   661,     0,   102,   132,     0,   692,  1991,
     245,   244,  1127,     0,     0,     0,     0,     0,     0,  1872,
    1902,  1905,  1903,  1904,  1906,  1900,     0,     0,   311,     0,
       0,  1111,  1113,  1107,  1155,     0,     0,     0,     0,  1405,
    1407,     0,  1172,     0,  1041,  1027,     0,  1032,     0,  1024,
       0,  1062,     0,   323,   544,   483,     0,   482,     0,   477,
     478,   473,     0,   453,     0,   453,   424,   342,   344,   348,
     349,     0,  1982,     0,  1979,     0,  1998,   134,     0,     0,
    1928,   509,   512,   405,   829,     0,   957,   839,   897,  1241,
    1249,     0,  1392,  1115,  1116,  1127,     0,   669,     0,     0,
       0,     0,  1406,     0,     0,  1413,  1415,     0,     0,     0,
       0,  1068,     0,  1063,   324,   485,   486,   484,   470,   471,
     371,   518,   373,  1983,  1984,  1928,   112,   111,   103,     0,
     171,     0,  1992,   246,     0,     0,     0,   440,  1112,  1156,
    1410,  1411,     0,  1408,     0,     0,  1414,     0,     0,  1029,
    1034,  1061,  1980,   113,     0,   187,   175,     0,     0,     0,
     173,   201,  1999,     0,     0,   177,   199,   200,   178,  1484,
       0,  1485,  1985,   102,   830,  1248,  1250,     0,  1393,     0,
    1409,  1417,  1416,     0,  1042,   186,   189,     0,     0,   192,
     182,   181,   183,     0,     0,     0,   172,   222,   171,   171,
     225,   180,   218,   171,  1993,   441,  1404,   692,     0,   188,
       0,     0,     0,   174,   202,   213,   216,   208,   143,   171,
       0,   171,     0,     0,  1986,   171,  1412,     0,     0,  1159,
    1161,     0,   184,     0,     0,     0,     0,   171,   209,     0,
     139,     0,     0,   141,   228,     0,   220,  1994,  1418,  1162,
    1157,   692,  1285,     0,   176,   193,   210,   216,   206,   214,
     171,     0,     0,   171,     0,   224,   142,     0,   226,   219,
     221,     0,  1420,  1160,   185,   190,   171,     0,   207,     0,
       0,   205,   154,   153,     0,   145,   167,   223,     0,   144,
       0,   171,     0,     0,  1427,     0,   171,   211,     0,   171,
       0,     0,     0,     0,     0,   140,     0,   171,  1419,  1422,
       0,     0,  1424,  1425,     0,  1394,   191,   196,     0,   203,
     171,   148,   168,   169,     0,   151,   229,     0,  1426,  1421,
       0,  1428,   192,   171,   195,   171,     0,     0,   146,   160,
     147,   158,   150,     0,   227,  1423,   197,   171,   171,   166,
     164,   171,   155,   162,   157,     0,   163,   170,   161,     0,
     152,     0,   149,   165,   159,   156
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   966,    58,   518,
     913,  1372,  1373,    59,   412,    60,   692,  1111,  1112,  1113,
      61,  1585,  2448,  1129,   389,   407,  1582,  1075,  3386,  1504,
    3438,  1505,    62,   482,   690,  1093,  1094,  2750,  2751,  3024,
    2752,  3017,  3018,  3019,  3020,  3573,  3529,  3550,  3574,  3612,
    3646,  3652,  3653,  3594,  3661,  3662,  3663,  3669,  3664,  3595,
    3648,  3530,  3473,  3503,  3499,  3474,  3563,  3498,  3584,  3521,
    3522,  3586,  3627,  3644,  3475,  3476,  3504,  3545,  3477,  3505,
    3567,  3526,  3568,  3587,  3628,  3527,  3546,  3590,  3549,  3478,
    3533,  3579,  3511,  3528,  3532,  3601,  3577,  2027,  2429,  2033,
    2439,  3028,  2444,  3207,  3390,  1859,  2252,  3090,  2760,  1573,
    1070,  1071,   390,   391,   392,   490,  2034,  1539,  2035,  2036,
    1541,  1542,  1012,  2402,  2393,  2379,  3254,  2435,  2406,  2407,
    2408,  2409,  2357,  2358,  1945,  1946,  1992,  2417,  2734,  2956,
    2976,  2735,  2736,  2737,  2738,  2739,  2740,  2741,  2774,  2775,
    3150,  3151,  3152,  2771,  3007,  2991,  2992,  2993,  3173,  2963,
    2292,  2293,  3488,  2302,  2303,  2339,  2629,  2340,  1074,  2964,
    3001,  3160,  2994,  2416,  2950,  3141,  3291,  3142,  3143,  3144,
    3369,  1947,  2356,  1090,  1091,   639,   393,  1145,  1589,  3032,
    3033,  2347,  2863,  3297,    63,  1077,   675,   677,   676,  1995,
     467,  1543,  1544,  1545,  2672,  2678,  3285,  1949,   111,  1369,
    2413,  1983,    64,  1049,  1044,    65,   650,   645,   646,  1047,
    1048,  1473,  1907,    66,   585,    67,   477,    68,   485,  1116,
      69,   974,  1851,  1852,  1853,    70,   682,    71,   486,  1123,
    1124,  1125,    72,   964,   116,    73,   574,   969,   971,   972,
      74,   479,   480,  1085,    75,  1399,  1834,  1835,   687,   688,
    1092,  2588,    76,    77,   458,   432,   591,   433,   434,  1426,
    1871,  3255,   602,   603,   604,  2276,   991,   992,   993,  1876,
    1427,  2281,  1131,  2878,   884,   885,   886,  1305,  1306,  2995,
     887,  1315,  1770,   888,   889,  1798,   890,  2823,  2225,  2226,
    2227,  2570,  2571,   891,  2067,  2786,  2105,   892,  1298,  1755,
    1666,  3047,  2807,  1605,  2050,  2468,  2572,   507,   508,   893,
    1223,  1224,  1225,  1683,  1289,  2196,  1747,  1480,  1481,  1482,
    1483,  2927,  2926,  2928,  3269,  3113,  3271,  3117,  1918,  1484,
    1485,  3418,  2315,  2643,  2333,  2334,  3124,  1909,  1486,  2321,
    3123,  2659,  2933,  3277,  3422,  1997,  3273,  1356,  1357,  1663,
     948,   949,  1606,  1831,  2240,  3097,  3259,  2215,  2897,  3257,
    3341,  1546,  2383,  2384,  1873,  1874,  2337,  2662,  2682,  1015,
    3256,  2242,  1454,  1455,  2765,  3651,  2008,  3407,  3489,  3538,
    3539,  3540,  2611,  2612,  2901,  2902,  1875,  2273,  2613,  3098,
      78,   395,    79,  1801,   683,   684,   510,   404,    80,   413,
    1832,    81,   426,  1414,   558,   578,   977,   978,  1860,  2253,
    2260,  1861,  2265,  2890,  2255,  2591,  2592,  1930,  1931,  2256,
    2594,  2887,  2879,  2880,  2584,  3088,    82,   446,  2654,  2328,
    2329,  3399,  3400,   579,    83,   394,   732,  1593,  1150,  1592,
     733,   734,  1152,   505,   506,    84,   444,    85,   437,   640,
    1450,  2306,  1895,   570,   642,  1461,   643,  1462,  1441,  1890,
    1003,    86,   671,   670,    87,   463,  1066,    88,   519,   924,
     925,  1377,  1809,    89,   427,   583,   584,    90,   421,   571,
    1407,    91,   414,   561,    92,    93,   562,   957,  2585,  3253,
    3447,  3516,  1398,   958,  2445,  3262,  3349,  3350,  3352,  3415,
    3416,  3582,  3604,  3621,  3622,  3625,   894,   659,   895,  3134,
     896,   897,  2261,  2262,  2663,   898,  3401,   899,  1993,   653,
     410,   900,   552,   660,  2245,   901,  3480,   705,   706,   376,
     377,    94,   605,   436,   995,   996,   997,  1436,  1437,   644,
    2204,  1438,  1439,  1887,  1882,  2909,  2635,  2627,    95,   565,
     926,   962,   963,  1840,    96,   445,    97,   950,  1393,  1394,
    1828,  2239,  1829,    98,   587,    99,   541,  1387,   542,   928,
     543,   544,   940,   935,   943,   937,  3243,  3080,  3081,  1816,
     909,   707,   708,  1380,  1811,  1812,  2874,  3083,  3249,  3250,
     100,   120,   382,   488,   699,   985,   101,   102,   103,   104,
     988,  1061,  1867,  1062,  1063,  1064,  1493,  1424,  2550,  1296,
    1749,  2860,   493,   722,   714,   473,   474,   475,   496,   497,
     112,   113,   715,   716,  2030,  2420,  2744,  3011,  3012,  3194,
    3191,   717,  3513,   718,   719,  2430,  3200,  3389,  3483,  3535,
     720,  2024,  2748,  3315,  3440,   105,   661,   455,  1059,  1054,
    1056,  1489,  1925
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3232
static const int yypact[] =
{
    2528, -3232,   163,   958,   899, -3232,   129, 42204,    72,   899,
     899,  -161,  1650, -3232, -3232, -3232, -3232, -3232,  3039, 42204,
     958, -3232, 21184, -3232, -3232, -3232,    87,   899,   958, 42204,
   -3232,   136,   873,   958, -3232, -3232,   899, -3232,  -161, 42204,
   -3232,   385, -3232,   940,   -95,   312,   279, -3232, -3232, 42204,
    1892,   382,   774,   813, -3232, -3232,   510, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, 21724, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232,   740, 42204, 42204, -3232,
   42204,   475, -3232,   854, -3232, -3232,   899, -3232, -3232, -3232,
    -161, 21184, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232,   413, -3232, -3232,   613, -3232,
   -3232, -3232,   969,   932, -3232, -3232, -3232, -3232, -3232,   293,
     636, -3232,   840,  1114,  1007, -3232,  1133,  1133, 42204,  1133,
   -3232,  1133, -3232,  1133,   899, -3232, -3232,  3957, 42204,   991,
     154,   -85, 37371,  1038,    91, -3232,  1125, 21184, -3232,   899,
    1179,   200, 42204, -3232, -3232,   899,   160,    -6, -3232,  4213,
     127, -3232, -3232, -3232,  2817, -3232, -3232,  4572, -3232, -3232,
   -3232,   839, -3232, -3232, 21184,   899,  1117, -3232, -3232,   106,
     106,   106, -3232,   106, -3232,   106, -3232,   382,   825, -3232,
   -3232, 42204,   451, -3232, -3232,   826,   -57, -3232, -3232, -3232,
   -3232, 21184,  1258,   957, -3232, -3232, -3232, 21184, -3232,   -24,
   -3232, -3232,   867, 42204, -3232, 21184, 21184,   157,     5,   924,
   42204, 35223,  1035, -3232,   624,   978,   854,  1433, -3232,   932,
   -3232, 42204, -3232, -3232, -3232, 38982,  1007, -3232, 13471,  1299,
   42204, 42204,  1134, 42204, 42204, 35223, 21184,  1133,   937,  1770,
    1100,  1070,  1087, -3232, -3232, -3232, -3232,  1147, -3232, -3232,
    1006, -3232, -3232, -3232,   122, -3232,    58, -3232, -3232, -3232,
   -3232, -3232,  1146,   953, -3232, -3232,    86, -3232, -3232, 42204,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,  1289, -3232,
   -3232, 13471,   211,  1481,  1365, 21184, -3232,  -141, -3232, -3232,
    1293, -3232, -3232, 35223, 21184, -3232, -3232, -3232, 19014, -3232,
   -3232,  1500, -3232,   990, -3232, 21184,  1100, -3232,  1234,  1153,
       5,  1071, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232,  1032,  2817, -3232, -3232,  1341,  1453, -3232,  1178,
     -60,  1116,  1051,   299,   -60, 37371,  1366, -3232,   260, -3232,
    1451, -3232, -3232,  1167, -3232, -3232, -3232,  1173,  1183,  1343,
    1164, -3232,   261, -3232,    66, -3232,  -119,  1366,   -60,   155,
   -3232,  1387,  1513,   371,   551, -3232,   461, -3232, -3232,  1582,
   -3232, -3232, -3232, -3232, -3232,  1289, -3232, -3232, -3232,  1102,
   -3232,  1339,  1213, -3232, -3232,    29, -3232,  1123,   -34, -3232,
     549, 35760, -3232, -3232, -3232,  1583, -3232, -3232, -3232, 35223,
    1274,  1177, 21184,  -151, -3232, 39519, 21184, -3232,   165, 13471,
   -3232, -3232,  3605,   179,   115, -3232,  1647,  1336, -3232, -3232,
   -3232, -3232,  1565, -3232,  1172,  1170,  1542,  1196, -3232, -3232,
   -3232, -3232, -3232,  1589, -3232,  1242, -3232, -3232, -3232, -3232,
   -3232,  1599, -3232, -3232, -3232, -3232, -3232,   957, -3232, 21184,
    -147, 21184, -3232,  1214, -3232,  1224, -3232,  1255,  1257,  1277,
    1279,  1300, 16286, -3232,  1317,  1320,  1329,  1342,  1345,  1353,
    1358,  1370,  1373,  1375,  1389,  1396,  1399,  1419,  1172,  1172,
    1421,  1425,  1428,  1430,   735,  1441, -3232,  1443,  1450,  1455,
    1458,  1472,  1473,  1475,  1477,  1478,  1479, -3232,  1483, -3232,
    1484,  1485,  1487,  1489,  1495,  1501,  1504,  1509,  1511,  1512,
    1514,  1515,  1518,  1519, -3232,  1520,  1523,  1525, 13471,  1535,
    1536,  1541,  1544,  1549,  1559,  1561, -3232,  1568,  1570,  1580,
    1587,  1595,  1598,  1600,  1601,  1602,  1607,  1608,  1612,  1614,
    1617,  1623, -3232, -3232, 13471,  1626, -3232, -3232,  1627,  1630,
   -3232,  1639,  1642,  1644,  1648,  1654,  1655,  1661,  1667,  1674,
    1689,  1696,  1699,  1703,  1704,  1706,  1710,  1711,  1718,  1722,
    1725,  1734, -3232,   862,  1735,  1742,  1042,  1746, -3232,  1747,
   -3232,   121,  1748,  1750,  1752,  1172,  1172,  1172,  1754,  1755,
    1760,  1764,  1765,  1776, 13471, 16286, 16286, 16286,  8967, -3232,
   42204, -3232, 42204,  2552,  3357, -3232,  3261, 16286,  4284,   455,
   -3232, -3232, -3232,  1236,  1328, -3232, -3232, -3232, -3232, -3232,
    1778,  1308, -3232, -3232,  1493, 21184, -3232, -3232, -3232,  1287,
      89, 21184,  1480, -3232, -3232, -3232, -3232, -3232, -3232,  2092,
   -3232, -3232, -3232,  1668,  1581, -3232, -3232, -3232, -3232, -3232,
   -3232,  1679, -3232, -3232, -3232,  1782, -3232,  1782, -3232, -3232,
    1782, -3232, -3232,  1782,   615,  4247, -3232, -3232, 42204, -3232,
   42741, -3232, 19014,  2552, -3232,  2050, -3232, -3232,  1955, -3232,
    2064,   182,  1785, -3232, 21184, 37371, -3232, -3232,    80,  1786,
    1877,  1802, -3232,  1881, 21184, 21184, -3232, -3232, -3232, -3232,
      -6,    36,  1809,   616, -3232, 42204, -3232,   291, -3232, -3232,
   -3232,  1816, -3232, 13471, -3232,  1828, -3232,  1282, -3232,  2149,
   -3232,  1916, 13471, -3232, -3232,  1846,   932, 42204, 42204, 21184,
   21184, -3232, -3232, -3232,   678, -3232, -3232, 42204,   -60, 35223,
   -3232, -3232, -3232,  2233,   155, 42204,   -60, -3232, -3232,   155,
   -3232, -3232, -3232, -3232, -3232, 21184, -3232, -3232,   155, -3232,
     155,   155,   -60,   -60,  1895, -3232, -3232,  1840, -3232,  1895,
    1969,   741,   106,  2053, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232,    74, -3232, -3232, -3232, -3232, -3232,
     118, -3232, -3232, -3232,  1578,  1872,  1872,  1497, -3232,   248,
   21184,  1848,  1916, 21184, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232,  1853, -3232,  1856,  1852,  2552,  2277,  2278,  2279,  2282,
    2284,  2285,  2287,  2294,  2298,  2305,  2306,  2308,  2315,  2316,
    2323,  1883, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
    1954, -3232, -3232, -3232, -3232,  1361, -3232, -3232, -3232,   123,
    1857, -3232, 37371,  2425, 35223,  2299, 42204, 42204, 42204, 21184,
   42204, -3232, -3232,   305,   305,  2138,  1214, -3232,    78, 42204,
    2309, 25499,   120, 13471, 13471, 13471,   905,  1364,  2420,  2473,
    2473,  2473, 13471, 13471, -3232, -3232, 13471, -3232, 13471, 13471,
   13471, 13471,   961, -3232, -3232,  9530, -3232,  1929, 13471, 13471,
    2011, 13471,  1328, 13471, 13471, 22264, 13471, 13471, 13471, 13471,
   13471,   638, 13471,  4284, 13471, 13471, 13471,  1930, 13471, 13471,
   13471, 13471, -3232, 13471, 13471,   275, 13471,  2370,   569, 13471,
   13471, 13471, -3232, 10093, 13471, 13471, 13471, -3232, 13471, 13471,
   13471, 13471, -3232,  2485, -3232, 22264,   996, 13471, 13471,  1122,
   13471, 13471, 13471, 13471, 13471, -3232, -3232, -3232, -3232,  9530,
   -3232, 13471, 13471, 13471, 13471, 13471, -3232, 16286, 13471, 10656,
   13471, 13471, 13471, 13471,  1934, 13471, 13471,  2473,  2473, 13471,
   13471, 13471,  1244,  9530, -3232, 13471,  1328,   663,   663, 13471,
    1328,  7841, 13471, -3232, -3232, -3232,   569, 11219,  1937, -3232,
   -3232, -3232,  2473, 22264,  2473, 13471, 13471, 13471,  2552,  1972,
    2420,  2420,  2420, -3232,  8967,   173,  1944, 13471, 23344,  1942,
   -3232, -3232, -3232, -3232, 13471, 13471, 13471, -3232, 16286, -3232,
   -3232,  1404, -3232, -3232, -3232, 14034, 16286,  1951, 16286, 16286,
   16286, 16286, 16286,  2266, 16286, 16286, 16286, 16286, 16286, 16286,
   16286, 16286, 16286,   706,  2420, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232,  1960, -3232, 37371, 16286,
   13471, -3232, -3232, 42204, 42204, -3232, 35223, -3232, -3232, -3232,
      89, 37371,  1959, -3232, -3232,  2145,  1770, 21184, -3232, 42204,
   -3232, -3232, -3232, -3232, 19554, 19554, -3232, 19554, -3232, -3232,
      82,    92,  2195,  1993, -3232, -3232, -3232, -3232,  2318, 21184,
   -3232,   617, 21184,  1848, -3232, 13471,  1916, -3232, 35223, 35223,
   21184, 21184,   175, -3232,  1066, -3232,  1916,  2341, 19554, 19554,
   19554, -3232, -3232, -3232, -3232, -3232,   804, -3232,  2552, -3232,
    1963, -3232, -3232, -3232, -3232, -3232, 40056,    75, -3232, -3232,
    1916,  2362, -3232,  2552,  1976, 42204, -3232, -3232, -3232, -3232,
      56, -3232, -3232, -3232, -3232,  -128, -3232, -3232, -3232, -3232,
    2108,   -60, 42204, -3232, -3232,   -60,   155, 21184,   -60,   -60,
   -3232, -3232,  1325, -3232,   461, -3232, -3232, -3232, -3232, 42204,
    2886,  2118,  1983, -3232, -3232, 21184, -3232,  1988, -3232,  2383,
    2509,  1366, -3232, -3232, -3232,   311,   311,  1916,  2110,  2111,
    2113,  2114,  2116,  2150, -3232, -3232,  2811,  2504,   311,   311,
    2504,   311,   311,   311,  2087,  2454,   311,  2345,  2106,  1027,
    2348,   311, -3232,  2117,  2476,   311,   311,   311,  2504,  2537,
     311,   311,   311,   311,   311,   218,   311,   311,   311, -3232,
    4756, -3232, -3232,  2036, 20094, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, 40593, -3232, 13471,  1364,  1916,  1916,   836,  1916,
    1364,  1916,  1916,  1916,  1916,  1916,  1364,  1916,  1916,  1364,
    3605, -3232, -3232, -3232,   125, -3232, -3232,   -67, -3232, 42204,
   -3232,  1216,  2040,   397, -3232,  3422, -3232, -3232, -3232, -3232,
   -3232, 21184,  2084,  1993, 25499, -3232,   741, -3232,  2035, -3232,
     196,   336,   181, -3232,  2473,  2042, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,  2044,  2056,  2061,  2067,   245,   539,  -180,
    2073,  1640,  2075,   384,   748,   183,   848, -3232,  2091,  2071,
    1645, -3232,   913,   919,  1658,  1672,   933,  2094,  2099,   206,
     237,  1008,  1074,   257, -3232,  2098,  1089,  2503,  1105,  1130,
     263, -3232,  1729,  1135,  1143,   273,  2122,   277,   282, -3232,
   -3232, -3232, -3232,  2123,  1161, -3232, -3232,   560,  1737,  1169,
    1175, -3232,  1744,  1184,  1186,   292,  2126,  1200,   300,  1207,
    1211,  2127,  2115,  2131, -3232,  2473,  2130,  1771,  1773,  2473,
    2133,   329,  1232,  1790,   352,   425,  2143,  2146,  2153,  1795,
    1804,  1812,   498,  1238,   607,  2157,  3301,  1819, -3232,  1837,
    1252,  1259,  1263,   612, -3232,  1283,  1888,  2158,  2163,  1296,
     286,  1306,  2473,  2164,  1901,   647,  2148,  2165,  1906, 11782,
   12345, 12908,   249,  1319,   566, -3232,  1911, -3232,  2167,  2169,
   -3232,  2099,  2172,   672,   690,  1921, 13471,  -191, -3232,   382,
   -3232, -3232, -3232,   119,   994, -3232,  2244, 42204,  1401,   162,
   -3232, -3232, -3232, -3232, -3232, -3232,   734, -3232,  2124, -3232,
    2151,  2178,  8967,  1019,  2178,  3252,   729,   729, 16286,  2681,
    3275,  3074,   761,  4284,   761,  4284,  2178,  2178,  2178, -3232,
    2176, 16286, 16286, 16286, 13471, -3232,  2420,  2552,  2177,   505,
   -3232, -3232, -3232, -3232, -3232,  1480,  2481, -3232,  1848, -3232,
   -3232,   962, -3232,  2184, -3232,  2185,  2255,  2271,  2275, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232,  1366,  1066,  2269,  2200, -3232, -3232,  2227,  2518, -3232,
   -3232, -3232,  2552, -3232,  2286, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,    16, -3232, -3232,  2216,  2216, 17929, -3232,
   -3232, -3232, -3232,  2435,  2607,  2609,  2610,   549, -3232,   602,
   -3232,   688,  2563,  1366, -3232,  2620, 37908, 26038, -3232,  2229,
    2571,  2232,   311, 33612,   644, 23881, 34149, -3232, -3232,   836,
   -3232,    19, -3232, -3232, -3232, -3232,   678,   678,  2259, -3232,
   -3232, -3232,  1993,   155, -3232, -3232, -3232,  2239, -3232, -3232,
     741,  2573,  2575, -3232,  2459,   856,  2459,   741,   741, 22264,
     741,  1676, -3232,  1364,  2512, -3232, -3232, -3232, -3232, -3232,
   -3232, 36297, 34686, -3232, -3232, -3232,  2717, -3232,  2718,   916,
   -3232, 22804,  1057,  1057, -3232,   491,   503, 22804, -3232, -3232,
   22804,   836,  1364, 22804,  1364,  1916,  1916,  1592,   311,  1364,
   -3232, -3232,  2581,  2582, 22804, 22804, -3232, 37371, -3232,   311,
    1109,   836,   836, 22804, 22264,  2937,  1916,  1364,  1364,  2569,
   -3232, -3232, -3232, 21184,  1926, 37371,  2262, -3232,  4714, 17389,
   42204,   217,   126, -3232,  2248,  2263, -3232,  1096, -3232,  2552,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232,  2343, -3232,  2421,  2265, -3232, -3232,   145, -3232,   912,
    2263, 21184, 16849, -3232,   102, -3232,  3412, -3232,   741,  2483,
      99,  1993,  2280,   120, 14597, -3232, -3232, 13471,  2288, -3232,
   13471, 13471, -3232, -3232, -3232,   172, -3232, 36834, -3232, -3232,
   -3232, -3232, -3232, 13471, 36834,   172, 13471, -3232, -3232,  2291,
   -3232,  2615,  2615, -3232, -3232,  1328, -3232, 42204, -3232, 13471,
   -3232, 13471, -3232,  1328, -3232, 13471, -3232, 13471, 13471, -3232,
    2501, -3232, 13471, -3232, 13471, 13471, -3232, 13471, -3232, -3232,
   13471, -3232, 13471, 13471, -3232, -3232,  2508, -3232, 13471, 13471,
   -3232, -3232, 13471, -3232, 13471, -3232, 13471, -3232, 13471, -3232,
   13471, -3232, 16286, 22264,  2295, -3232, -3232, -3232,  2296, -3232,
   -3232, 13471, 13471, -3232, -3232, 13471, -3232, 13471, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, 13471, 13471, -3232, 13471, -3232,
   13471, -3232, -3232, 13471, 13471, 13471, -3232, 13471, -3232, -3232,
   -3232, -3232, 15160, 13471, 13471, 13471,  2297, -3232, -3232, -3232,
   13471, 13471, 13471, -3232, 13471,   842, 13471,  2532, 13471,  2622,
   13471, -3232, 13471,  2514, -3232, -3232, -3232, -3232, -3232, 13471,
   -3232, 13471, -3232,  1869, 13471, 13471,  2702, -3232, -3232,  2304,
   -3232,  2281,  2292,  2293, 37371, 13471, -3232, -3232, -3232, -3232,
   -3232,   638,   763,  2310, 16286, -3232,  3252, 16286, -3232, -3232,
    8967,  1019,  3252,  2857, -3232,  2311, -3232, -3232,  2314, 42204,
   -3232, -3232, -3232, 42204,  2326, 26577, 35223, 35223, 35223,  2321,
   13471, -3232, -3232,  2546, -3232, -3232, 21184,  2636, -3232, -3232,
   35223, -3232,  2817, 22264, -3232,  2325, -3232,  2325,  -164,  2324,
    1115, -3232, -3232, -3232,  2327,  1071,  2720, 35223, 35223, 35223,
   -3232,  1993,  1993,    96,  2377,  2670, -3232, -3232, -3232, -3232,
   41130, -3232, -3232, -3232, -3232,   669, 42204,  2657, 42204,  8404,
   -3232, -3232, -3232,  2839, 13471, -3232, 35223,   440,   994,   311,
   -3232, -3232, -3232, -3232, -3232, -3232,  1366, -3232, -3232, -3232,
   -3232,  2635, -3232,   -60,  1325,   377, -3232,  3059, -3232, -3232,
   -3232,  2675,   741,  2459,  2459,  2676,  2570,   703,  2347, -3232,
     311,  2886,     7, -3232,  2817, -3232, -3232, 13471, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, 13471,  2678,  2680,  1057, -3232, 22804, -3232, -3232,  -147,
     205, -3232, -3232, -3232, -3232, -3232, -3232, 34686,  1916, -3232,
   22804, -3232, -3232,   143, -3232,  1916, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,  2353, -3232,   707, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, 21184, -3232,  1128, -3232, -3232, -3232,
   -3232, 42204, -3232, -3232, 21184, -3232, -3232,  4017, 42204, 42204,
    2898, -3232, 42204, -3232,   912, -3232, -3232, -3232, -3232,  2585,
   42204, -3232, -3232, -3232, -3232,  2429,  2906, -3232, 21184, -3232,
    2366,  1157, -3232, -3232, -3232,  2912,  4790, -3232,  2371,  1993,
    2685, -3232, -3232, 13471,  1949,  1953, -3232,  2552,  1979,  2376,
    2376, -3232, -3232,  2380,  2376,  2714, -3232,  2724,  2388,  2389,
    2390,  1996,  2391,  2392,  1352, -3232, -3232,  4284,  4284,  2396,
    2393,  2025,  2038,  2401,  2404,  2047,  1369,  2052,  2406,  2409,
    2078,  2090,  1410,  2095,  2109,  2129,  2137,  2412,  2483,  2416,
    1446,  1469,  2413,  2173,  2180,   767,  2202,  2422,   779,  3020,
   -3232, -3232, -3232,  2208,  2260,  2272,  2276,  2301,  2303,  2313,
    2342,  2352,  1486,  2368,  2428,  2423, 13471,  2439,  1633,   792,
    1496, -3232,  2448,  1546,  1550,  2462, 13471,  2491, 13471,  2500,
   13471,  2507,  2519,  2419,  2523,  2567, 13471,  1939,  2552, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232,  2424,  2552,  2433, -3232,
   -3232, -3232,   455, -3232,   835,  2436, -3232, 16286, -3232, 13471,
    2442, -3232,  2437, -3232, -3232, -3232, -3232, -3232,   347,   347,
     347, 15723,  2552,  2876, -3232,   107, -3232,  2765, -3232, -3232,
    1032,  2445, -3232,   311, 15723,  2216,  2592, -3232, -3232,  -164,
   22264, 26038, -3232, 35223,  1196,  1196,  1196,  1366,  2827,  2269,
    2269, -3232, 24418, -3232, -3232,  2591, -3232, -3232, 27116, -3232,
     -37, -3232, -3232, 16286,  1450, -3232,  2552, -3232, 36297, -3232,
    2552,   311,  2461,  2467, -3232, -3232, 41667, 13471, -3232,  2880,
   -3232, -3232,  2468,   741,  2684,   741, -3232,  2798,  2803,   741,
   -3232, -3232, -3232, 22264,  1993, 15723,  1057,  1057,  1057, -3232,
    1032,  2552,  2484,   707,  2552, 22804, -3232, -3232,  -147,  2475,
    2930,  2940, 22804,  2839, -3232, -3232, -3232, -3232,  4017, 22264,
   -3232, -3232, -3232,  1159, -3232, 17389, -3232, -3232, -3232,  2489,
    2494,  2376, -3232, -3232, -3232, -3232, -3232,  2380,  2694, -3232,
    2380,  2380, -3232, -3232, -3232, -3232, -3232,   264,   394, -3232,
   -3232,   264, -3232, -3232, -3232,    84,   769,  2380, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232,  2376,  2376, -3232, -3232, -3232,
     264,  2496, -3232,  2376,  3007, -3232,  1294,    46,  2497,  2498,
    2376,  2502,  2493, -3232,  1166, -3232, -3232,  2555,   545, -3232,
    2510,  2511, -3232, -3232,  1916, -3232,  2515, -3232,  4756, -3232,
     704, -3232, 42204, -3232,   678, -3232,  4284, -3232, -3232, -3232,
    2733, -3232,   264,  2744, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, 13471,  2516,  2517,  2520, -3232,
   -3232, -3232, -3232, -3232, -3232, 13471, -3232, -3232, -3232, -3232,
   -3232, 13471, -3232, -3232, -3232, -3232, -3232,  2661, -3232,  2748,
   13471, 13471, -3232, -3232, -3232, -3232, 13471, -3232, -3232, -3232,
   13471,  3047,  2725,  2530, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, 13471, -3232, -3232, -3232,  4284, -3232, 13471,
   -3232, -3232, 13471, 13471, -3232, 13471, 13471, -3232,  2574, -3232,
    2594, -3232,  2599, -3232, -3232,  2767, -3232, -3232,  2552, 13471,
   -3232,  2539, 42204, -3232, -3232,  2542, -3232, -3232, -3232, -3232,
    2552, -3232, -3232,   222,  2577,  2577,  2577,  1450,  2552,  1194,
   -3232, -3232,  2882, -3232,  1816, 22264, 15723,  2545,  2547, -3232,
     -34, -3232, -3232,  2550,  1196, -3232,  3077,  2926, -3232, -3232,
   37371,  2562, -3232, -3232,  2822, -3232,    76,  2746, -3232, -3232,
   -3232,   440,  2655,  2662,   311,  2552,  1916,  1935,  1983,  2907,
    3457,  2623,   741,   741,  3523,  2624, 13471, 13471,  2586, -3232,
    2483, -3232,  2974, -3232, -3232, -3232,  1816, 13471, -3232,  2587,
    2589, 42204, -3232,  3450,   217, -3232,  3007, -3232, -3232, -3232,
     583,  2814,  2819, -3232,   890, -3232,  2593,   890,   890,  3124,
     307, -3232,  3124, 36834, -3232,  1178, -3232,  2631,   264, -3232,
   -3232,  2633, -3232, -3232, -3232,   890,  2604,   264, -3232, -3232,
    2834,   890, -3232, 37371,  1916,  3270, -3232,  2656, -3232,  3058,
    2938, -3232,  3007, -3232,  2941,  2844, -3232,  2838, -3232, -3232,
    2845, -3232,  2846,  2848,   890,  2849, -3232,   890, 42204, -3232,
   42204,  2647,   777,  1916, -3232, -3232, -3232,  2629,  2632, -3232,
   -3232, 21184, -3232, 42204,  4017, -3232,  2647, -3232,   -34,   102,
    2592, -3232,  1218,   707,  2639, -3232,  2644,  2649, -3232,  1220,
    2611, -3232, -3232, -3232,   884,  2617,   106,  2651,  2654,  2628,
    1552,  2646,  2648,  2881,  3057, -3232,  2652,  2658,  2666,  2690,
    2706,  2738,  2742, -3232, -3232, -3232,  2660,  2552, -3232, -3232,
   -3232,  2668, 37908, -3232,  2741,  2764, -3232, -3232,  2766, -3232,
   -3232,   103,  1454, -3232, -3232, -3232, -3232, 15723,  3009, -3232,
     159, -3232, -3232, -3232, -3232, 13471, -3232,  2483,  3153, -3232,
   24418, -3232, -3232, -3232, -3232, -3232,  2682,  2683,  8404,  3233,
   -3232,   741, -3232,  2739, -3232, -3232, -3232,  2740,  2552,  2552,
   42204,  2685,  3025, -3232,   159,   707, 42204, 42204,  1223,   569,
     569,   569,  1059,  1059, -3232, -3232, -3232, -3232,   803,    45,
   42204, -3232, -3232,   834, -3232,  2697,  2699, -3232, -3232, -3232,
   -3232,   890, -3232,   106, -3232, -3232, -3232, -3232, -3232, 36834,
   -3232, -3232,  3124, -3232, -3232, -3232,   106, -3232,  2708, -3232,
   -3232, -3232,  1172, -3232, -3232,  2943,  2749, -3232, -3232, -3232,
   -3232,  2712,  2730,  2732,  2735, -3232,  2719, -3232, -3232, -3232,
     225, -3232, -3232, -3232, -3232, -3232, -3232,   822, 42204,  3111,
    2891, -3232, -3232, -3232, -3232, -3232,  2736,  1071, -3232, 42204,
   -3232,  2954, -3232, -3232, -3232,  2969, -3232, -3232, 13471, -3232,
   -3232, -3232,  2473, -3232, 13471, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,   232,  2959,  1364,  1364,  1364,  1364,  1454,
   -3232, -3232,  2794,  2835, -3232,   688, -3232,  -169,   707, 13471,
    1366,   770,  3060, -3232, -3232, -3232, -3232,  3036,  3664, 13471,
    2752, 13471,  2753,  1246, -3232, -3232, -3232,  2754, -3232, -3232,
    1270,  1295, -3232, -3232, -3232,   217, -3232, -3232, -3232,   420,
     420,  1303, -3232, -3232, -3232, -3232, -3232,  1321, -3232, -3232,
   -3232,  1367, -3232, -3232,  1172, -3232,   264,  3124,   264,  3124,
    3251,  2968,  3259, -3232,   382, -3232, -3232,  4017, -3232, -3232,
   -3232, -3232,   707,  2757,  2759,   895,  2760,  2750,  2761, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, 22264, 21184, -3232,   290,
   13471, -3232, -3232,  2552,  2957,  3280,  3283,  3193,  3287,   770,
   -3232,  -104, -3232,  3192, -3232,  2552, 42204,  2552, 42204, -3232,
   42204, 40593,  2951, -3232, -3232, -3232,  3331, -3232,   150, -3232,
   -3232,   834, 42204,   264,   106,   264, -3232, -3232, -3232, -3232,
   -3232,  2997, -3232,  2998, -3232,  2777,  3634, -3232,  3210,  4017,
     -34, -3232, -3232, -3232, -3232, 13471, -3232, -3232, -3232,  2780,
   -3232,   311, -3232, -3232, -3232,   707, 42204, -3232,   106,   106,
    3299,   106, -3232,  3303,  3304,  -104, -3232,   836, 13471,  1380,
    1383, -3232,  2784,  2788, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232,   -34, -3232, -3232, -3232,  3234,
   31991,  2942, -3232, -3232,  2758, 22264, 15723,  1592, -3232, -3232,
   -3232, -3232,   106, -3232,   106,   106, -3232,  3339,   149, -3232,
   -3232, -3232, -3232, -3232, 42204,   110, -3232, 43278, 43278, 42204,
   -3232,  2825, -3232,  3852,   167, -3232, -3232, -3232, -3232, -3232,
    2790, -3232, -3232, -3232, -3232, -3232, -3232, 34686, -3232,  2801,
   -3232, -3232, -3232,  3088, -3232, -3232, -3232,  3195, 42204, -3232,
   -3232, -3232, -3232, 13471, 13471,  2831, -3232, -3232, 31991, 31991,
   -3232, -3232, -3232, 31991,  3634, -3232,  3153,  2807,  3222, -3232,
    3147,  3232, 13471,  2552,  2552, -3232,   758, -3232, -3232, 29281,
    2804, 32533, 13471,   167, -3232, 31991,  3060, 13471,  2812,  2815,
   -3232,  1364, -3232,  3169,  2155,  2847, 13471, 31991, -3232,  3245,
    3276,  3122,  2818, -3232,  2821,  1670, 43278, -3232,  3177,  2552,
   -3232, -3232, -3232, 42204, -3232, -3232, -3232,   760, -3232,  2552,
   29823,  2840, 38445, 30365,  2823, -3232, -3232, 13471, -3232, -3232,
   -3232,  3062,  2837, -3232,  2832, -3232, 31991, 13471, -3232,  3262,
    2855, -3232, -3232, -3232,  3208,  2842,  1081, -3232,  2850, -3232,
    2664, 31991,  3157, 18469,  2989, 42204, 27655,  2552,  2868, 31991,
    3249, 42204,  4017,  3258,  3269, -3232,  3026, 30907, -3232, -3232,
   37371,  1386, -3232, -3232, 22264, -3232, -3232,    22,  2872, -3232,
   28197, -3232, -3232,  3319,  2986, -3232, -3232,  2895, -3232, -3232,
   20639,  2780, -3232, 31991, -3232, 31991, 33075, 13471, -3232,  2917,
   -3232, -3232, -3232,  3852, -3232, -3232, -3232, 31449, 28739, -3232,
   -3232, 24955, -3232, -3232, -3232,  3273, -3232,  2552, -3232,  1328,
   -3232, 33075, -3232, -3232, -3232, -3232
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3232, -3232, -3232, -3231, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232,  1625, -3232, -3232, -3232, -3232, -3232,  1873, -1413,
   -3232, -3232, -3232, -3232, -3232,   500,    77,  2770,   -39, -3110,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,   428,
     432, -3232, -3232,   254, -3232, -3232,  -759, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232,  -215,  -176, -3232, -3232, -3232,
   -3232,   493, -3232, -3232, -3232, -3232, -3232, -3232, -3232,  -183,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232,  -103, -3232, -3232,   -63, -3232, -3232,   -97, -3232,
   -3232, -3232,   -62, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232,   443, -3232, -3232, -1823, -3232, -3232, -3232, -3232,
    2344,  -971, -3232,  3082, -3232,  -358,   723,  1947, -1874,  -995,
    -614,  -603,  -609, -3232, -3232, -3232,   358,  1068,  1461,   805,
    1950,  1989,  1505,  1551, -3232, -3232,   837, -3232, -2608, -3232,
   -3232, -3232,   800, -3232,   802, -3232, -3232, -3232, -1250,   772,
    -654, -3232,   363,  -825, -3232,   570, -3232,   525, -3232,  -432,
   -2002, -1896, -3232, -3232, -3232,   535,   852,   893, -3232, -2614,
   -2229, -3232, -3232,   170, -3232, -3232, -3232,   158, -3232,   391,
     246, -3232, -3232, -1453, -1791, -3232, -3232, -2169,  2394, -2011,
     326, -1851, -3232,   373, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,  1553, -3232, -3232, -3232,   319,  -252, -1310,
   -2715, -3232, -3232, -3232, -3232, -3232, -3232,  1141, -3232, -3232,
    2069,  2495, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,  1692, -3232, -3232, -3232, -3232, -3232, -3232,
    2432, -3232, -3232, -3232,  1476, -3232, -3232, -3232, -3232,  2136,
   -3232, -3232,  2862, -3232, -3232, -3232, -3232,  1304,  1723, -3232,
   -3232, -3232,  2890,  1694,  -453, -1721, -3232,  3108, -3232, -3232,
   -3232, -1311, -1902, -3232,  2966,   323, -2276,  2159,  -492,   710,
   -3232,   513,  -742,  4260, -3232, -1267, -1081, -3232, -3232,  -488,
   -3232, -3232, -3232, -1235,  -716, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232,   711, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -1109, -3232,  1524, -3232, -1090, -3232, -3232,
   -3232,  2369, -3232, -3232, -3232, -3232, -3232, -1853, -1380,   950,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -1861,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -1368, -3232, -1606,
   -3232, -3232,  -695, -3232, -3232,   242, -1815, -1169,   731, -3232,
   -3232,  -947,  2434, -1517, -3232, -3232, -3232,  1388, -3232, -3232,
   -3232, -3232, -3232,   935, -1994, -1034, -3232, -3232, -2590,  -626,
   -1802,  -606, -3232, -1809,   490, -1148, -1840, -3232, -3232, -3232,
   -3232,    55, -3232, -3232, -3232,   518,  1762, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232,  -452,  -375,  1730, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232,  2667,  2645,  1792, -3232,
   -3232, -2024, -3232, -3232,  1780, -3232,   755, -1844,  2996,  1046,
   -3232, -3232,  1049, -2587, -3232, -3232, -3232, -3232, -3232, -3232,
     992,    20,   202,  3206, -3232, -3232, -3232, -3232, -3232, -3232,
    2922,  2506, -1388,  3150, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232,  3220, -3232,  -950, -3232,  -455, -3232, -3232,
    -591, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
    2283, -3232, -3232, -3232, -3232, -3232,  2686, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232,  1076,   151, -3232,   316,   134, -3232,
     256, -3232, -3232, -3232,    33, -3232,  -743,  -665,  -989,   691,
   -1724, -1159,  1077,  2687, -2801, -1127, -1264, -1270, -1771,    21,
   -3232,    -7,  -513,  -887,  -587,  2710, -2195,  -392,  -487, -3232,
    1643, -3232, -3232, -3232, -3232,  2252, -3232, -3232, -3232, -3232,
    1381, -3232, -3232, -3232,  1050, -3232,   781,   580, -3232, -3232,
    3244, -3232,  2300, -3232, -3232, -3232, -3232, -3232, -3232, -3232,
   -3232, -3232, -3232, -3232, -3232, -3232, -3232,  2711,  3264,  3110,
   -3232,  2762, -3232, -3232, -3232, -3232, -3232,   454, -3232,   284,
   -3232,  1185,  2572,   595, -3232,  1482,  -573,  -847, -3232,   460,
   -3232, -3232,  1145,  3284,  3120, -3232, -3232, -3232, -3232, -3232,
   -2219,  -583, -3232, -2271, -3232, -3232, -3232, -3232,  1526, -1154,
    2430,  1165, -3232, -3232, -3232,  3225,  3336,  3337, -3232, -3232,
    -102, -3232,  3255,  -280, -3232,  1702, -3232,   979, -3232, -3232,
     713,  3238, -3232, -3232,  3241, -3232, -3232, -3232, -3232, -3232,
    3242, -3232, -3232, -3232, -3232, -3232,  1315, -3232, -3232, -3232,
   -3232, -3232, -3232
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1969
static const short int yytable[] =
{
     374,   702,   713,   721,   667,   638,  1067,  1361,   989,  1613,
    1016,  1031,   374,  1740,  1401,   374,  1173,  1174,  1176,  1739,
     554,  1182,   374,  1011,  1647,  1456,  1158,  2197,   908,  2241,
    1491,  1016,   374,   693,   694,  2259,  2342,  1645,  2289,  2294,
    2297,  1761,   374,   409,  2642,  2450,  2602,  1032,  1769,  2305,
    1614,  1615,  1616,  1948,   967,  2469,  2326,  2317,  1637,  1906,
    1803,  1072,  2472,  1628,   910,  2327,  1964,  2331,  2931,   652,
    2946,  2278,  1073,  2938,  1619,  1620,  2039,  1622,  2999,  1465,
     374, -1473,  1540,  1240,   373, -1809,   970,  2309,  2310, -1098,
    1468,  1469,  1783,  1785,  2969, -1810,  2359,  2970,  1684,  1494,
     374,   374, -1474,   374,   946,  -242, -1873,  1405,   464,  1264,
    1266,  2361,  1656,  1270,   374,  1872,  2979,  1686,  1922,  3242,
    1690,  -522,  2998,  1279,  1280,  1281,  -252,  1676,  -253,   608,
     609,  2380,  2381,   981,  1300,  1301,  3125,  1367,   946,  2971,
     656,   729,   481,   487,  3102,  1696,  1697,  1698,  1717,  1718,
     941,  2349,  2350,  1723,  3642,  1273,  1705,  3289,  3038,  1290,
    1291,  1292,  2447,  2307,  1300,  1301,  1706,   559,  1117,  1848,
    2348,  1334,  2656,  1738,   106,  1742,  2348,  1300,  1301,  2360,
     415,   938,  2363,  2351,  1035,   469,  1001,   470,  1300,  1301,
    2669,  1367,  1078,  2372,  2373,  3507,  1300,  1301,  1300,  1301,
     946,   685,  2382,   976,  2459,  1599,  1896,  1416,   695,  2440,
    2043,  1300,  1301, -1931,   547,   723,  2041,  2657,  1135,  1136,
    1137,  1300,  1301,  1013,  2609,  2411,  1069,  2460,   947,  3136,
    1081,  1069,   568,  1069,  2597,  1771,  1980,   672,  1774,  1775,
    1776,  1777,  3506,  1779,  1780,  1781,  1782,  1784,  1786,  1787,
    1788,  1789,  1300,  1301,   107, -1473,  1854,  2426,  3426,  1057,
    1300,  1301,   947,  2055,  1300,  1301,  2461,  1027,  1118,  2462,
     576,  1119,  1300,  1301,  3310,   580,  3437,  2463,  1300,  1301,
    3074,  3496,  3311,  1120,  2959,   954,  2021,   498,  1300,  1301,
    3074, -1098,  1300,  1301,  3258,  1361,  2960,  1300,  1301,  3092,
     416,  1300,  1301,  1422,   106,   657,   952,  1300,  1301,  2961,
    2325, -1931,  2442,  1893,  2884,  1300,  1301,  2442,   608,   609,
    1274,  1014,  1017,  1025,   947, -1473,  1033,  3157,  1848, -1809,
    1869,  2670,  1114,   697,  1082,   551,  1029,  2057,   108, -1810,
     440,  2194,   121,  2906,  1300,  1301, -1474,  1143,  1586,  3413,
    2590,  1300,  1301,   378,  3163,  2195,  2907,  1547,  1856,  1857,
    1981,   608,   609,  3167,  2427,   581,  3339,  1300,  1301,  1659,
    1144,  3414,  1660,   109,  1030,   381,  3403,  2412,  1088,  1361,
    1034,  2058,   955,  1361,  2936,  2312,  2908,  1487,  1849,  1883,
    1006,   374,   441,  3340,   698,   728,  2596,  1089,  1333,  1300,
    1301,   374,   472,  1051,  3437,   374,  1014,  2000,  1121,  2022,
     374,  1083,  2010,  1423,  2959,   374,  3202,   673,  2016,  1490,
    2180,  2019,  3670, -1473,   577,   965,  2960,  1458,  1884,   582,
    3508,  1058,  2660,  3497,  1897,  1464,  1038,   374,   564,  2961,
    1300,  1301,   674,  3210, -1474,  2610, -1098,  1141,   608,  2965,
    3075,  1470,  1471,  1928,   374,  2637,  1072,  2163,  1492,  1370,
    3075,  2646,   560,  1302,   374,  1667,  1303,  1073,  3365,   987,
     374,  2673,  1548,  1002,  1007,   956,   374,  3312,   374,   374,
    3427,   569,   549,   374,   374,   696,  2655,  1122,  1442,  2272,
    1368,  2464,   678,  1302,   374,  2048,  1303,  2443,   374,  2940,
    3251,  1587,  2443,   374,   374,  2668,   374,   374,   374,   374,
    2414,  1894,  1403,  1300,  1301,  1072,  1902,  1302,  1358,  2675,
    1303,  1028,  1412,  2658,  2451,  1302,  1073,  1302,  1303,   110,
    1303,  1850,  1459,  1734,   548,  3279,  1948,   429,   686,  3405,
    1302,  2316,   374,  1303,  1368,  1540,  3076,  1849,  2351,  2308,
    1302,  1115,   422,  1303,  1300,  1301,  3290,   939,   374,   417,
    2351,  3509, -1098,  2667,  2279,  1406,   374,   374,  3643,  1550,
    3364,   374,  2761,  1404,  3103,  2891,  2124,   976,   374,  1948,
    2128,  1302,   658,  1467,  1303,  2348,   961,   942,  1740,  1302,
     906,   907,  1303,  1302,  2263,   973,  1303,  1275,  1083,  2348,
     976,  1302,  1773,  1494,  1303,  2465,  3000,  1302,   374,  2972,
    1303, -1473,   589,  2166,  2218, -1809,  2219,  1302,  2213,  3094,
    1303,  1302,  1300,  1301,  1303, -1810,  1302,  1300,  1301,  1303,
    1302,  2671, -1474,  1303,   710,  -560,  1302, -1098, -1873,  1303,
     492,  1885,  1496,  1796,  1302,  1594, -1473,  1303,  1445,  1740,
   -1809,  1083,  2043,  2466, -1098,  2330,  2428,  2352,  2449,  1304,
   -1810,  2199,  1300,  1301,   374,  1008,  2042, -1474,  3342,  -331,
    -242, -1873,   374,  1302,  3077,   374,  1303,  1083,   374,   374,
    1302,  2467, -1098,  1303,  2200,  3078,  -522,  1300,  1301,  1304,
    1850,  -252,  3377,  -253,  3379,  3078,  1302,  2216,  3404,  1303,
    2064,  3510,  1304,  1982,  1740,  1300,  1301,   481,  1551,  3387,
    2385,  2222,  2223,  1304,  3494,  1018,  1026,  2647,  2648, -1098,
    1588,  1304,   374,  1304,   374,  -494,  2680,   435,  1302,  2271,
    3156,  1303,  3391,  3161,  1750,  1751,  1304,  1083,  1929,  1039,
    1576,  1083,  2046,  2047,  2873,  2065,  1304,   442,  3366,  2886,
    1142,   443,  1147,  1661,  2607,  2608,  1662,  3204,  2044,  3430,
    3079,  3432,  3014,  1300,  1301,  1339,  2962,  2078,  2079,  1302,
    3015,  1009,  1303,  2259,   459,  2335,  2632,  1304,  1300,  1301,
    1361,  3442,  1300,  1301,  2921,  1304,  1928,  2911,  2925,  1304,
    1384,  1418,  2920,  2633,  1300,  1301,  2924,  1304,  2080,  2081,
    2029,  1359,   456,  1304,  2362,  2895,  2364,  1300,  1301,  3158,
    2181,  2369,  2296,  1304,  2939,  3448,   460,  1304,  2084,  2085,
    2681,  3367,  1304,  1766,  2091,  2092,  1304,  2387,  1010,  2389,
    2390,  2394,  1304,  1340,  2096,  2097,  2477,  2478,  2099,  2100,
    1304,  1040,  1302,  2101,  2102,  1303,  3368,  1361,  2164,  1045,
    1300,  1301,  1316,  2113,  2114,  2353,  2274,  1300,  1301,  3486,
    1041,  2117,  2118,  1300,  1301,  1927,  3138,  -331,  1344,  1304,
    1899, -1347,   461,   374,  1901,   374,  1304,  1904,  1905,  1802,
     987,  1837,   466,  1302,  1316,  1016,  1303,   822,   491,  2207,
    2130,  2131,  1304,  1843,  2348,  3016,  2962,  2045,   374,  1300,
    1301,  2641,   515,  1862,   374,  3345,  1756,  1456,  1456,  1134,
    1300,  1301,  1046,  2134,  2135,  3346,  2634,  1603,  2966,  2732,
    3139,  1844,  1845,   573,  1304,  1808,  1365,  1888,  1300,  1301,
    3128,  1790,  2763,  3300,  1300,  1301,  3121,  3031, -1928,  1451,
    2003,   374,   457,   374,  2275,   374,  2062,   471,  1300,  1301,
    2563,  1302,  1791,  2313,  1303,  3035,  1302,   374,   374,  1303,
    1072,  3162,  1348,   472,   483,  1304,  1795,   374,   374,    40,
    1349,  1073,  2470,  1603,  2332,  1869,  3286,  2475,   374,  1804,
     483,  1385,  1419,  1740,  1933,   487,  2136,  2137,  3321,  2593,
     711,  1302,  2483,  1540,  1303,  2354,  2510,  1838,  2004,  2488,
     374,   374,   374,   374,  3633,  1886,  1042,  -331,  1603,  1452,
     374, -1347,   374,  2536,  2497,  2498,  1302,  2431,   374,  1303,
    1915,  2502,  1477,  1300,  1301,  2345,  1870,  1604,   374,  2507,
    1448,  1449,   830,  1350,  1302,  1319,   658,  1303,  1304,  3014,
    2651,  2509,   658,  2001,  2002,   852,  2009,  3015,  2011,  2012,
    2013,  2014,  2015,   822,  2017,  2018,  1466,  2558,  1293,  2144,
    2145,  3114,  3115,  2676,  2208,  2228,  2565,  1319,  2525,  1180,
    3108,  1929,  2229,   374,   680,  2221,   374,  1043,  3378,  1304,
    3380,  1352,  1358,  1627,  1446,  1447,  2322,  1386,  1386,  1300,
    1301,  1792,  1302,  1940,  1457,  1303,  2452,  2005,   484,  2323,
    2056,  1549,  1463,  3260,  1300,  1301,  -130,  1302,   499,    51,
    1303,  1302,   712,  3347,  1303,  3280,  3281,  3138,  1685,  3443,
    1300,  1301,  2106,  1302,  1854,   374,  1303,   374,  2183,   374,
     374,   374,   374,   374,  1603,  2432,  1302,  2930,  2573,  1303,
    2346,   489,   374,  3140,   374,  1300,  1301,  1304,   555,  1490,
    1300,  1301,  1304, -1968,  1839,  3287,  3613,  3299,  1300,  1301,
    1584,  1477,  1478,   766,  3462,  2214,  1479,  2006,  2147,  2148,
    3614,  3139,  3016,  2156,  2157,  1453,  1300,  1301,   374,  1302,
     822,  2201,  1303,   430,  1300,  1301,  1302,  1304,  2479,  1303,
    1300,  1301,  1302,  1962,  1353,  1303,  2484,  3192,  1644,  1300,
    1301,  1300,  1301,  2932,  2932,  2932,  1355,  3206,  2169,  2170,
     114,   852,  1304,  1580,  1581,  1300,  1301,   502,   374,  3135,
    2652,   779,  1300,  1301,  2025,  2209,  1300,  1301,  1302,  2228,
    1304,  1303,  1948,  2188,  2189,  1180,  2618,  3288,   556,  1302,
    1088,  2210,  1303,  2026,  1689,  3348,  2202,  1300,  1301,   700,
     701,  2190,  2191,  1300,  1301,  1793,  1603,  1302,  3268,  1089,
    1303,  3135,  2324,  1302,  3030,   478,  1303,  1300,  1301,  2376,
    1088,   503,  3500,  3501,  1300,  1301,   374,  1302,  1300,  1301,
    1303,  1327,  1328,  1329,  1330,  1331,  1332,   115,  1304,  1089,
    3525,   374,  3566,  2433,  2973,  1181,  2198,  2974,  1300,  1301,
    2869,  1478,   557,  1304,  3547,  1479,  3547,  1304,  2787,  2788,
    2063,  1300,  1301,   386,  2959,  1329,  1330,  1331,  1332,  1304,
     806,  1300,  1301,  3147,  2559,  2560,  2960,   501,  2815,  2816,
    1740,   546,  1304,  2007,  1300,  1301,  2263,  3193,   852,  2961,
    2819,  2820,   509,   117,   711,   118,  2377,   563,   608,   609,
     567,   374,  1302,  2841,  2842,  1303,   374,   374,  2374,   374,
     822,  3580,  1180,  2282,   374,  1359,  1722,  1300,  1301,   117,
     374,   118,   374,  2434,   649,  1304,  2403,   374,   374,   504,
     374,   577,  1304,  1740,  1300,  1301,   668,   423,  1304,  2330,
     827,  1963,   374,   549,   438,   374,  2866,  2867,   439,  3148,
     679,   374,   374,   374,   374,  1814,  1814,   680,  1814,  1740,
    2066,   374,   374,   374,  1117,  2385,  1300,  1301,  1302,  2203,
    1836,  1303,  1265,   961,  1304,  1300,  1301,   689,   680,   374,
     709,   973,  1847,  1302,  3149,  1304,  1303,  2378,   374,  1814,
    1814,  1814,  2365,  2366,   106,  3217,  3218,  2954,   902,  1302,
    2957,  2958,  1303,  1304,   912,   374,  3394,  3395,  3344,  1304,
     374,  1300,  1301,  2388,  2808,   927,   712,  2975,  1607,  1432,
    2865,   905,   374,  1304,  1302,  2071,   936,  1303,   374,  1302,
     929,  2072,  1303,   944,  1300,  1301,  1854,  1302,  1903,   934,
    1303,  2295,  1855,  2299,  2304,  2075,   406,   930,  2562,   109,
    -531,  1300,  1301,  1506,   419,  1302,  1921, -1968,  1303,   425,
    1507,  1300,  1301,  1302,  1118,   945,  1303,  1119,   852,  1302,
    1508,  1509,  1303,  2232,  2233,  2367,  1608,   959,  1302,  1120,
    1302,  1303,  1381,  1303,  1433,  1382,   960,   374,  1383,  2341,
    2295,  3419,  1180,  3420,  1302,   374,   979,  1303,  1304,  1510,
     968,  1302,   980,  1511,  1303,  1302,   860,  3446,  1303,  1762,
     931,  1300,  1301,  1609,  1512,  1300,  1301,  1300,  1301,   984,
    2082,   983,   374,  1513,   987,  1013,  1302,  3457,  1514,  1303,
     647,   648,  1302,   651,   374,  1303,   990,   374,  1856,  1857,
    1515,  3515,  3384,  1013,  1098,  1099,  1302,  3036,   998,  1303,
     999,   932,  1269,  1302,  1000,  1069,  1303,  1302,  1516,  1004,
    1303,  1005,  2037,  1014,  1304,  1740,   933,  1517,  1518,  1019,
    1434,  2593,  1020,  1519,  1023,  1610,  1858,  1302,  1021,  1304,
    1303,  1520,   608,   609,  1024,  2772,  2083,  1521,  1022,  2776,
    1302,  1495,  3244,  1303,  1036,  1304,   608,   609,  1300,  1301,
    1302,  2087,  1037,  1303,  1121,  1300,  1301,  2421,  2422,  1050,
    1300,  1301,  1522,  1302,  1052,  2295,  1303,  2089,  3057,  1817,
    1304,  1818,  2295,  1300,  1301,  1304,  2599,  2600,  1053, -1098,
    2638,  1055,   989,  1304,  1060,  1300,  1301,  1300,  1301,  2684,
    2685,  1069,  2090,  1079,   946,  1611,  1302,  2094,  1126,  1303,
    1016,  1304,  1864,  1865,  1866,  2095,  1080,  1435,  1523,  1304,
    1524,  1109,  1110,  1302,  1128,  1304,  1303,  1525,  2758,  2685,
    2948,  1083,  2640,  2104,  1304,  1127,  1304,  3009,  3010,   700,
     701,  2108,  1130,  1122,  1763,  2569,  1132,  2109,  3245,  3246,
    1304,   383,  3247,  3248,  1300,  1301,  2111,  1304,  2112,  1133,
     374,  1304,  1300,  1301,  1302,  3086,  3087,  1303,  1134,  1300,
    1301, -1098,  2116,  2589,  1138,   662,   663,  2616,   664,  2119,
     665,  1139,  1304,  2120,  1140,  1456,  1149,  3071,  1304,  3208,
    3209,  3214,  3215,  1526,  3282,  3209,  1300,  1301,  1300,  1301,
    1302,  1151,  1304,  1303,  2132,  3578,  2962,  1527,  1360,  1304,
    2146,  2839,  1528,  1304,   658,  1300,  1301,  3359,  3360,  2631,
    1300,  1301,  2556,  1302,  2153,  1153,  1303,  1154,   947,  1300,
    1301,  2154,  2996,  1304,   384,  2155,  1950,  1300,  1301,  1953,
    1302,  3362,  3209,  1303,  1300,  1301,  1304,  1155,  1965,  1156,
    1302, -1098,  1529,  1303, -1098,  2158,  1304,  1973,  1530,  1366,
    1531,   374,  1300,  1301,  2997,  2674,  3363,  3209,  2162,  1304,
    1157,  1612,  2677,  -499,  3371,  3372,  2953, -1098,  2165,   374,
     374,  1532,  1533, -1098,  1534,  1363,   374,  1159,   374,   374,
    1160,  2182,  3373,  3374,  1300,  1301, -1098,   914,  1535,  1161,
    1302, -1098,  1304,  1303,  1302,  1764,  1302,  1303, -1098,  1303,
    2977,  2978,  1162,  1300,  1301,  1163, -1098,  1158,  2981,  1304,
    1536,  1765,   374,  1164,  2785,  3004,  1300,  1301,  1165, -1098,
     448,  1300,  1301, -1098,   374,   374,  1300,  1301,  3375,  3374,
    1166,  2795, -1098,  1167,   374,  1168,  1300,  1301, -1098,  1497,
     374,  3459,  3360,   374,  3460,  3360,   374,  3639,  3640,  1169,
    1304,  1498,  2683,   946,  1300,  1301,  1170,   374,   374,  1171,
     374,   449,  2934,  2935,  1300,  1301,   374,   374,  1300,  1301,
    3110,   915,  2801,  3283,  3284,  2295,   374,  1302,   374,  1172,
    1303,  1175,   374,   374,  1302,  1177,  1304,  1303,  1178,  1302,
    1179,  1537,  1303, -1098,  1300,  1301,  2396,  2397,  1726,  1727,
    1538,  1183,  1302,  1184,  2395,  1303,  2875,  2876,  2810,  1304,
    1185,  1300,  1301, -1098,  1302,  1186,  1302,  1303,  1187,  1303,
   -1098, -1098,  2898,  2899,   374,   374,  1304,   916,  3084,  3085,
     450,  2811,  1188,  1189,  2398,  1190,  1304,  1191,  1192,  1193,
    1300,  1301, -1098,  1194,  1195,  1196,  1371,  1197,  2833,  1198,
     374,   917,  2437,  1300,  1301,  1199,  2399,   374,  2843,  -531,
    1364,  1200,  1300,  1301,  1201,  -531,  1740,  1300,  1301,  1202,
     374,  1203,  1204,  1302,  1205,  1206,  1303,   947,  1207,  1208,
    1209,  1302, -1098,  1210,  1303,  1211,  1304,  2400,  1302,   385,
    1304,  1303,  1304,  1300,  1301,  1213,  1214,  3331,  3332,  3333,
    3334,  1215, -1098, -1098,  1216,  1300,  1301,  1499,  2845,  1217,
    1300,  1301,  2846,  3326,  3224,  1302,   374,  1302,  1303,  1218,
    1303,  1219,  -258,   386,  1300,  1301, -1098,   511,  1220,   513,
    1221,   514, -1098,   516,  1302,   918, -1098,  1303,  1374,  1302,
    1222,   919,  1303,  1376,  1300,  1301,  3328,  1226,  1302,  1378,
   -1098,  1303,  1300,  1301,   387,  1227,  1302, -1098,  1228,  1303,
    1229,  1230,  1231,  1302,   388, -1098,  1303,  1232,  1233,   920,
    1300,  1301,  1234,  1304,  1235,  1740,  1500,  1236, -1098, -1098,
    1304,  1302, -1098,  1237,  1303,  1304,  1239,  1241,  1300,  1301,
    1242, -1098, -1098, -1098,  2840,  1300,  1301,   374,  1304,  1243,
    1501,  2060,  1244,  1375,  1245,   921,  2070,  1397,  1246, -1098,
    1304, -1098,  1304,  1302,  1247,  1248,  1303,  1300,  1301,  2073,
    2903,  1249,   374,  1300,  1301,   922,   374,  1250,   374,   374,
     374,   374,  1302,  2074,  1251,  1303,  2341, -1098, -1098,   374,
     923,  3025,   118,   374, -1098,  1302,   374,   911,  1303,  1252,
    1302,  1502, -1098,  1303,   451,  1302,  1253,  3021,  1303,  1254,
     374,   374,   374,  1255,  1256,  1302,  1257,  1836,  1303,  1304,
    1258,  1259, -1098,   374,   452,  1300,  1301,  1304,  1260,   374,
   -1098,   374,  1261,  1302,  1304,  1262,  1303,  1300,  1301,   374,
    2093,  1300,  1301,  1302,  1263,  1267,  1303,  1302,  2107,   453,
    1303, -1098,  1268,  3154,  3155,  2110,  1271,  1272,  1276,  2401,
    1277,  1304,  1278,  1304,  1282,  1283,  1300,  1301,  1300,  1301,
    1284,  3165,  1503,  1302,  1285,  1286,  1303,  3169,  1300,  1301,
    1304,  1396,  2126,  1740,  2127,  1304,  1287,  1819,  1362,  3623,
    1302, -1098,  1379,  1303,  1304,  1400,   454,  1402,  1408,   374,
    3185,  2133,  1304,  3187,  1740,  1820,  2141,  1300,  1301,  1304,
     374, -1098,  1409,   374,  1410,  2142,  1411,  1300,  1301,  1302,
    1740,  1417,  1303,  2143,  1440,  1821,  3623,  1304,  1425,  2569,
    2151,  3220,  1302,  1300,  1301,  1303,  1182,  1266,  1270,  1822,
    1431,  1302,   551,  3562,  1303, -1098,  1302,   374,  2152,  1303,
    1444,  1460,  1474,  3109,   374,  1472,  1476,   374,  1488,  1304,
    1083,   374,   374,  1552,  1554,   374,  2546,  1553,  1575,  1555,
    1556,  1557,  1302,   374,  1558,  1303,  1559,  1560,  1304,  1561,
    3303,   374,  1823,  1824,  1302,  2687,  1562,  1303, -1098,  1302,
    1563,  1304,  1303,  1300,  1301,  1570,  1304,  1564,  1565,  2159,
    1566,  1304, -1098,  1302,  1300,  1301,  1303,  1567,  1568,  2756,
    1825,  1304,  2168,  1300,  1301,  1569,  1571,  2173, -1098,  1577,
   -1098,  3171,  2184,  1302,  1579,  1591,  1303,  1300,  1301,  1304,
    1596,  1302,  2192,  1358,  1303,  1603,  2859,  1275,  3298,  1304,
    1631,  1651,  1665,  1304,  1682,  1714, -1098, -1098,  1737,  1302,
    3195,  3298,  1303, -1098,  1746,  1752,  1300,  1301,  3099,  1757,
    2767,  1772,  1778,  1794,  2768,  1300,  1301,  1302,  1826,  1304,
    1303,  1805,  1300,  1301,  1302,  1806,  1830,  1303,  3159,  1863,
    1877,     1,  1833,  1889,  1300,  1301,  1304,  1891,  1300,  1301,
    2769,     2,     3,  1898,  1919,  1920,  1302,  1300,  1301,  1303,
    1923,  1924,  1302,  1926,     4,  1303,     5,  2782,  1827,  2282,
    1934,  1935,  3376,  1936,  1937,  1304,  1938,  1300,  1301,  1939,
    1940,  2295,  1957,  1958,     6,     7,  1960,  1961,  1304,  1966,
       8,  1974,  1300,  1301,     9,    10,  2790,  1304,  1968,  1300,
    1301,  2341,  1304,   374,   374,  1969,   374,    11,  1988,  2791,
    2028,  2038,  2042,  2049,  1302,   374,  2051,  1303,  2794,  1300,
    1301,   374,    12,  2796,  1300,  1301,  1302,  2052,  1304,  1303,
    1302,   374,  2053,  1303,   989,  2069,  1300,  1301,  2054,   374,
    1304,    13,  1300,  1301,  2059,  1304,  2061,  1300,  1301,  2799,
      14,    15,    16,  1300,  1301,  1302,   374,  1302,  1303,  1304,
    1303,  2800,  2068,    17,    18,  2076,  2802,  1302,   374,  2086,
    1303,  1300,  1301,  1300,  1301,   374,  2077,  1300,  1301,  1304,
    2803,  2205,   374,  1607,  2088,  2122,    19,  1304,   374,  1300,
    1301,  1300,  1301,  2098,  -764,  2103,  1302,  2115,  2121,  1303,
    2804,  2125,    20,  2123,  2129,  1304,  1302,  2217,  2805,  1303,
    3313,  3314,  3565,  2538,  2138,  1300,  1301,  2139,  2903,  3431,
    2171,  2211,  1302,  1304,  2140,  1303,    21,   375,  2149,  2160,
    1304,  1300,  1301,    22,  2161,  2167,    23,  2172,  2185,   405,
    2186,  1608,   411,  2187,  2813,  1332,  2220,  2231,  -940,   420,
    2236,  2814,  1304,  3450,  3451,  2244,  3453,    24,  1304,   431,
    3531,  2234,  2235,  1300,  1301,   374,  2237,  1300,  1301,   447,
    2238,    25,  2246,  2817,  2248,  1300,  1301,  2295,  1609,  2824,
    2249,  2250,  1302,  1300,  1301,  1303,  2254,  2266,  2267,    26,
    2268,  2269,  3674,  1302,    27,  1870,  1303,  3490,  3570,  3491,
    3492,  1869,  1302,  2540,  2311,  1303,  2286,   465,  2287,  2288,
    1304,  2314,  3616,  2318,  1316,  2319,  1302,  2320,  2336,  1303,
    2343,  2344,  1304,  2370,  2371,  2418,  1304,   468,   375,  2423,
     375,  2825,  2404,  2419,  2424,  2425,  3388,  3606,  1490,   592,
    1610,   465,  2489,  2826,  1597,  1302,   798,  2827,  1303,  2499,
    2549,  1304,  3617,  1304,  1302,  2543,  2587,  1303,  2553,  2456,
    3630,  1302,  2476,  1304,  1303,   374,  2511,  2512,  2531,  2554,
    2555,  3385,  2828,  1302,  2829,  2552,  1303,  1302,  -330,    28,
    1303,  2561,  2568,  2567,  2830,  -994,  1302,  1940,   374,  1303,
    2576,  2581,  1304,  2583,  3657,  2598,  3658,  2595,  2614,  1941,
      29,  2603,  1304,   374,  2601,  2615,  1302,    30,  3439,  1303,
    1611,  2620,  2628,  2831,  2639,  2645,  2649,  2650,  1304,  2653,
    2665,  1302,  2666,  2832,  1303,  2679,  2745,    31,  1302,    32,
      33,  1303,  2749,    34,  2755,  2754,    35,  2757,    36,  2834,
    2759,  2762,  2764,    37,   374,    38,  2770,  2777,  1302,   593,
    2773,  1303,  2391,  1302,    39,  2392,  1303,  2778,    40,  2779,
    2780,  2781,  2783,  2784,    41,  1302,   374,  2789,  1303,    42,
    2229,  1302,  2792,    43,  1303,  2793,  1302,  2797,  1304,  1303,
    2798,  1911,  1302,  2806,  2812,  1303,   374,  -330,  2809,  1304,
    1316,  2855,    44,  2818,  2836,  1942,    45,  1319,  1304,  2835,
    1302,  2862,  1302,  1303,  2864,  1303,  1302,  2868,  2872,  1303,
    2838,   374,  1304,   374,  2871,  2881,  2883,  2885,  1302,  2844,
    1302,  1303,  1854,  1303,   374,  3487,   374,   594,  2896,  2904,
      46,  2912,  2916,  2847,  1088,  3537,  3439,  2913,  2922,  2917,
    2982,  1304,  2919,  2923,  1302,  2941,    47,  1303,  2942,    48,
    1304,  1607,  3199,  1089,    49,  2386,  2937,  1304,  2943,  2951,
    1302,  3013,  2849,  1303,  2952,  2955,  2980,  3002,  3003,  1304,
    3008,  2851,  3005,  1304,  3037,   374,  1612,    50,  2853,  3537,
    2983,  3022,  1304,  3023,  2984,  3039,  3027,  3041,  3042,  3048,
    2854,  3043,  1302,  3046,  2856,  1303,  1302,  3053,    51,  1303,
    1607,  3055,  1304,   374,  1302,  2295,  3054,  1303,  3066,  1608,
    3068,  1912,  1302,  3070,  3089,  1303,  3093,  1304,   512,  3087,
    1321,  1322,  3082,   374,  1304,  2985,  1913,  2618,   545,   374,
     374,  3095,   553,  3096,  3100,  3101,  3104,   465,  2857,  1914,
     396,  3106,   572,   374,  1304,  3063,  1609,  3111,  3107,  1304,
   -1028, -1033,  3122,  1316,  1911,  3145,  3120,  3126,  1608,  3127,
    3146,  1304,   374,  3153,   465,  3064,  2999,  1304,  3665,  2996,
    3065,  3164,  1304,  1319,  3166,  3168,  3176,  3175,  1304,  3181,
    3177,   669,  3216,  3179,  3180,  -330,  3182,  3183,  3219,  3184,
    3186,   465,  3190,  3665,  3227,  1609,  1304,   465,  1304,  3223,
    3196,   374,  1304,   691,  3197,   465,   465,  1316,  1610,  3211,
     703,   553,   374,  1915,  1304,  3212,  1304,  3225,  3228,  3226,
    3213,   730,  3221,  3229,   397,   735,  3222,  3239,  3261,  3230,
     903,   904,  3236,   375,   375,   553,   465,  3231,  3638,  3237,
    1304,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,  -465,
    3240,  3252,  3241,  3264,  3265,  2821,  1304,  1610,   119,  3267,
    1943,  3232,   398,   379,   380,  3276,  3270,  3272,  3294,   951,
    3295,   595,   596,   597,   598,   599,   600,  3233,  1611,  3302,
    3304,   418,  3305,  3306,  1912,   465,   424,   601,  1304,  3318,
     428,  3215,  1304,   553,   465,  3323,  1321,  1322,   465,  1913,
    1304,  3307,  1916,  3308,  3319,   465,  3309,  3320,  1304,  3234,
    3324,  3330,  2644,  3235,   743,  3336,  3353,  3337,  3381,  3351,
    3382,  3397,  3356,  3358,  3361,  -330,  3383,  1611,  3392,  3484,
    3393,  3396,  3398,  3406,  3408,   553,  1319,  3409,  3410,   374,
     374,  3411,   700,   701,  3417,  2414,  3425,  2986,  3435,  3433,
    3434,  3441,  3445,  3452,  2987,  3461,  1917,  3454,  3455,   374,
    2422,   374,  3463,   374,   374,  3493,  3482,  -204,  3402,  3512,
     476,  3517,  3518,  3525,  3541,   374,  3519,  3129, -1158,  3542,
    3543,  2988,  3553,  3560,   766,  1316,  1915,  3561,  3564,  3566,
    1319,  1068,  3572,  3571,  1316,  3575,  3576,  3581,  3591,   553,
   -1731,  3599,   465,  3602,  3605,  1086,   465,  3603,  1316,   374,
    3608,   -55,  3609,  3610,  3611,   399,  3618,  1325,  1326,  1327,
    1328,  1329,  1330,  1331,  1332,  3624,  3629,  3631,  3615,  3645,
    3636,  2578,  2579,  2580,  1316,   777,  3634,  3647,  3649,  3654,
    2230,  2989,   779,  3479,  1612,  1508,  1509,  3635,   374,   465,
    3668,  1148,  3673,  2020,  3514,  1508,  1509,  1076,  3198,  1321,
    1322,  3316,  2604,  2605,  2606,  3201,  3675,   374,  3650,  3656,
    3479,  3479,   374,  3548,  3588,  1916,  -451,  -451,  1511,   794,
    3589,  3556,  3205,  1574,   500,  -451,  -451,  -451,  1511,  1512,
     374,  3029,  3278,  1612,   743,  -451,  1317,  1987,  1513,  1512,
    2949,   374,  2747,  2441,  1991,  1944,  2355,  2415,  1513,  1307,
    1308,  3479,  3479,  1321,  1322,  1515,  3479,  1318,  2967,  2944,
    2968,  2990,   400,  3006,  3296,  1515,  3137,  3178,  3170,  1917,
    1069,  2910,  3479,  1516,  3479,  2945,  2150,   401,  3479,  3428,
    1069,   806,  3424,  1516,  3293,  3322,  3370,  1309,  1590,  3301,
    3479,  2405,  1911,  1908,  1475,  2251,  1846,  3129,  1087,  3479,
    2586,  1310,  1521,   402,   766,  2822,   374,  1572,  1319,  2247,
    1065,  2270,  1521,  3479,   666,   374,  3479,  1319,   403,   994,
    1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,  3338,  3479,
    3072,  1319,  3073,  1311,  1868,  3238,   700,   701,   822,  2473,
    1297,  1681,  1299,  2918,  3479,  1312,   374,  3172,   374,  3479,
     826,   827,  3479,  3423,   374,   777,  1629,  1319,  1911,  2566,
    3479,  3275,   779,   374,  2947,   465,  3583,   374,  3263,  1395,
    1413,   465,  1313,  3479,  2243,  1524,  1327,  1328,  1329,  1330,
    1331,  1332,  1525,   374,  2277,  1524,  3479,  2257,  3479,   374,
    3091,  2889,  1525,  2888,  3641,  2929,  1320,  3485,   517,   794,
    3479,  3479,   655,  1146,  3479,  1595,   736,   641,  1389,  1807,
    1392,  2882,   465,   566,   374,  3412,  1415,  3536,  2031,   575,
    3558,  3456,  1912,  3655,   465,   553,  3174,  2892,  1314,  2636,
    1429,  1321,  1322,  1878,   465,   465,  2914,  1913,  3266,   654,
    1321,  1322,  3105,   588,  1420,  1421,   982,  3329,  1526,  1323,
    1914,  1497,  1841,  1430,  1321,  1322,  1578,  1388,  1526,  3335,
     986,   806,  1527,  1498,   590,  2575,  2861,   375,   375,   465,
     465,   727,  1527,  1748,  2551,   494,   495,   375,   681,   553,
    1321,  1322,  2436,   724,  3026,   375,   725,   726,  1912,  3203,
       0,     0,     0,     0,     0,   465,   852,     0,  3130,  1911,
       0,  3131,  3436,  1913,     0,     0,     0,     0,     0,     0,
       0,   858,     0,  1530,     0,  1531,  1914,   860,   822,     0,
     861,     0,     0,  1530,  1915,  1531,     0,     0,     0,     0,
     826,   827,     0,     0,     0,     0,  1532,  1533,  2894,  1534,
     465,     0,     0,   465,  3112,     0,  1532,  1533,     0,  1534,
       0,     0,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,
    1324,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,     0,
       0,     0,  3132,  3133,     0,  1536,  1326,  1327,  1328,  1329,
    1330,  1331,  1332,     0,     0,  1536,     0,     0,     0,     0,
    1915,     0,   553,     0,   553,     0,   375,   375,  1583,   465,
     375,  1325,  1326,  1327,  1328,  1329,  1330,  1331,  1332,   735,
    3116,  1598,     0,  1916,     0,     2,     3,     0,     0,  1499,
       0,     0,  1096,  1097,  1098,  1099,  1100,  1101,     4,  1912,
    1102,  1103,  1104,  1105,  1106,  1107,     0,  1108,     0,     0,
       0,     0,     0,     0,  1913,  1638,     0,     0,     6,     7,
       0,     0,     0,     0,     8,     0,  1537,  1914,     9,    10,
       0,     0,     0,     0,     0,  1538,  1537,  1917,     0,     0,
       0,    11,     0,     0,     0,  1538,   852,     0,  3130,  1916,
       0,  3131,     0,  3472,     0,  1638,    12,     0,  1500,     0,
       0,   858,     0,     0,     0,     0,     0,   860,     0,     0,
     861,     0,     0,     0,     0,    13,     0,     0,     0,   700,
     701,     0,  1501,     0,    14,    15,    16,     0,     0,   520,
     521,     0,     0,     0,  2446,     0,     0,    17,    18,     0,
       0,  1915,  2032,  1917,     0,     0,     0,     0,     0,     0,
       0,  1109,  1110,  1741,     0,     0,     0,     0,     0,     0,
      19,  3354,  3132,  3133,     0,     0,  3534,     0,   553,     0,
       0,     0,     0,  1502,     0,     0,    20,     0,     0,     0,
       0,     0,  3552,     0,  3552,     0,     0,     0,  3557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,   522,     0,     0,     0,     0,     0,    22,  2688,  2689,
      23,     0,     0,     0,  2690,     0,  2691,  2692,  2693,     0,
       0,     0,     0,  3552,     0,     0,  3598,     0,   553,   523,
    1916,    24,  2694,  1799,  1800,     0,   553,     0,     0,     0,
       0,   553,     0,   524,  1503,    25,     0,   465,     0,  1810,
       0,     0,     0,     0,  1815,  1815,     0,  1815,     0,  3552,
       0,     0,     0,    26,     0,   525,     0,     0,    27,   465,
    3552,  2695,   465,     0,  2696,     0,   526,     0,   553,   553,
     465,   465,  2697,  3552,  1917,     0,     0,     0,  1815,  1815,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2698,     0,     0,     0,   527,  1881,     0,     0,     0,
    3552,  3552,     0,     0,  3672,  1892,     0,     0,  2699,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     528,     0,  1900,     0,     0,     0,   529,   465,  2700,     0,
    2701,     0,     0,     0,     0,     0,     0,     0,     0,  1910,
       0,     0,     0,    28,     0,   465,     0,     0,     0,  2702,
    2703,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   530,    29,     0,     0,     0,     0,     0,
       0,    30,     0,     0,     0,   586,   521,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2704,    31,     0,    32,    33,     0,     0,    34,     0,     0,
      35,     0,    36,     0,  1994,     0,     0,    37,     0,    38,
     521,     0,  1998,     0,     0,     0,     0,  2705,    39,     0,
       0,     0,    40,     0,     0,     0,  2706,  2707,    41,  2708,
       0,     0,     0,    42,     0,     0,     0,    43,     0,  2023,
       0,     0,     0,     0,     0,     0,     0,   522,     0,     0,
       0,   465,     0,     0,  2040,     0,    44,  2709,  2710,  2711,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   531,   523,     0,  2712,  2713,  2714,
       0,   522,     0,  2715,     0,     0,  2716,     0,     0,   524,
       0,   532,     0,     0,    46,     0,     0,   533,     0,  2717,
    2718,     0,     0,   534,     0,     0,     0,     0,     0,   523,
      47,   525,     0,    48,     0,     0,     0,     0,    49,     0,
       0,     0,   526,   524,  2719,     0,  2720,   535,     0,     0,
       0,     0,  1335,  1336,  1337,  1338,  1339,     0,   536,   537,
       0,    50,     0,     0,     0,   525,     0,     0,  2721,     0,
       0,   527,     0,     0,     0,     0,   526,     0,     0,     0,
       0,     0,    51,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   538,     0,   528,     0,     0,     0,
       0,     0,   529,     0,     0,   527,     0,     0,     0,     0,
       0,  2722,     0,  2723,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2724,  1340,     0,     0,     0,     0,     0,
     528,     0,     0,     0,     0,     0,   529,  2206,   539,   530,
     540,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1341,  1342,  1343,  1344,
       0,     0,  1932,     0,  2725,  2726,     0,     0,  2727,  2728,
    2729,  2730,     0,   530,  1951,  1952,     0,  1954,  1955,  1956,
       0,     0,  1959,     0,     0,     0,     0,  1967,     0,     0,
       0,  1970,  1971,  1972,     0,     0,  1975,  1976,  1977,  1978,
    1979,     0,  1984,  1985,  1986,     0,     0,     0,     0,     0,
       0,  2731,  2732,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2733,     0,     0,     0,     0,     0,     0,     0,  2264,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1345,
     531,  1346,  1347,  1348,     0,     0,  2283,  2285,     0,     0,
       0,  1349,     0,   553,     0,   553,   553,   532,     0,     0,
       0,     0,   606,   533,   568,   607,     0,     0,     0,   534,
       0,     0,     0,     0,   531,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   608,   609,     0,  1741,
       0,   532,     0,   535,     0,     0,   610,   533,   611,     0,
       0,   553,   553,   534,   536,   537,     0,     0,     0,     0,
       0,  1994,     0,     0,  1350,   612,   613,  1994,     0,     0,
    1994,     0,     0,  1994,   614,     0,     0,   535,     0,     0,
       0,     0,     0,     0,  1994,  1994,     0,   553,   536,   537,
     538,     0,     0,  1994,  1741,     0,     0,     0,     0,     0,
       0,     0,     0,   465,     0,   553,     0,     0,     0,  1994,
    2410,  1351,  1352,     0,     0,     0,     0,     0,     0,     0,
       0, -1325,   615,     0,   538,     0,   616,     0,     0,     0,
    1506,     0,     0,     0,   539,     0,   540,  1507,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1508,  1509,     0,
       0,   465,  1994,     0,     0,   617,     0,   618,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   539,   619,
     540,   620,     0,     0,     0,     0,  1510,   553,   883,     0,
    1511,     0,     0,     0,   553,     0,     0,     0,     0,  1508,
    1509,  1512,     0,     0,   621,   622,     0,  2480,   623,     0,
    1513,     0,     0,     0,     0,  1514,     0,     0,     0,     0,
       0,     0,     0,   624,     0,     0,     0,  1515,     0,     0,
    -451,  -451,  1511,  1508,  1509,  1353,     0,     0,     0,  -451,
       0,   953,  1069,  1512,   625,  1516,  1354,  1355,     0,   626,
       0,     0,  1513,  1638,  1517,     0,     0,     0,     0,     0,
    1519,     0,     0,     0,     0,     0,  1511,     0,  1520,  1515,
       0,     0,     0,   627,  1521,     0,     0,  1512,     0,     0,
       0,     0,     0,     0,  1069,     0,  1513,  1516,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1522,
       0,     0,     0,  1515,     0,   628,     0,     0,     0,     0,
       0,     0,     0,     0,   629,     0,  1521,     0,  1069,     0,
       0,  1516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   630,     0,   553,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1524,     0,     0,
    1521,     0,     0,     0,  1525,     0,     0,   631,   632,  2574,
       0,     0,     0,  1810,     0,   951,   553,   553,   553,  1095,
       0,     0,     0,     0,  2368,     0,   465,     0,     0,     0,
     553,     0,     0,  1741,     0,  2375,     0,     0,     0,  1524,
       0,     0,     0,     0,     0,     0,  1525,   553,   553,   553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2617,     0,     0,     0,     0,     0,  2619,   633,  2621,     0,
    1526,     0,     0,  1524,     0,     0,   553,   634,     0,     0,
    1525,     0,     0,     0,  1527,     0,     0,     0,     0,  1528,
       0,     0,     0,     0,     0,     0,     0, -1756,     0,     0,
       0,   635,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1526,     0,   636,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1527,     0,  1212,  1529,
       0,     0,     0,     0,     0,  1530,  1994,  1531,     0,     0,
       0,     0,     0,     0,     0,     0,  1526,   553,     0,     0,
    1994,     0,     0,  3481,  1238,     0,     0,     0,  1532,  1533,
    1527,  1534,     0,     0,     0,     0,     0,     0, -1756,     0,
       0,     0,   637,     0,     0,  1535,     0,  1530,     0,  1531,
    3481,  3481,     0,     0,   465,     0,     0,     0,     0,     0,
       0,  2686,     0,     0,   465,     0,     0,  1536,  2742,  2743,
    1532,  1533,  2746,  1534,  1288,     0,     0,     0,  1295,     0,
    2753,  1530,     0,  1531,     0,     0,     0,     0,   465,     0,
       0,  3481,  3481,     0,     0,     0,  3481,     0,     0,     0,
       0,     0,     0,     0,  1532,  1533,     0,  1534,     0,  1536,
       0,     0,  3481,     0,  3481,     0,     0,     0,  3481,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3481,     0,     0,     0,     0,     0,     0,     0,     0,  3481,
       0,     0,     0,  1536,     0,     0,     0,     0,  1537,     0,
       0,     0,     0,  3481,     0,     0,  3481,  1538,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3481,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3481,     0,     0,     0,     0,  3481,
    1537,     0,  3481,  1428,     0,     0,     0,     0,     0,  1538,
    3481,     0,  1443,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3481,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1537,     0,  3481,     0,  3481,     0,
       0,     0,     0,  1538,     0,     0,     0,     0,     0,     0,
    3481,  3481,     0,     0,  3481,     0,     0,     0,     0,     0,
    2264,  2893,     0,   553,     0,     0,     0,     0,     0,     0,
       0,     0,   553,     0,     0,     0,     0,     0,  2574,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   553,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1741,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1994,     0,     0,     0,     0,
       0,     0,  1994,     0,     0,     0,     0,     0,     0,  1741,
       0,     0,     0,     0,     0,  1994,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1600,  1601,  1602,     0,     0,     0,     0,
       0,     0,  1617,  1618,     0,     0,  1621,     0,  1623,  1624,
    1625,  1626,     0,     0,     0,  1630,     0,     0,  1632,  1633,
       0,  1634,     0,  1635,  1636,     0,  1639,  1640,  1641,  1642,
    1643,     0,  1646,     0,  1648,  1649,  1650,     0,  1652,  1653,
    1654,  1655,     0,  1657,  1658,     0,  1664,     0,     0,  1668,
    1669,  1670,  3034,  1672,  1673,  1674,  1675,     0,  1677,  1678,
    1679,  1680,     0,     0,     0,     0,     0,  1687,  1688,     0,
    1691,  1692,  1693,  1694,  1695,     0,     0,     0,     0,  1699,
       0,  1700,  1701,  1702,  1703,  1704,     0,     0,  1707,  1709,
    1710,  1711,  1712,  1713,     0,  1715,  1716,     0,     0,  1719,
    1720,  1721,     0,  1724,     0,  1725,     0,     0,     0,  1728,
       0,  1732,  1733,     0,     0,     0,     0,  1736,     0,     0,
       0,     0,     0,     0,     0,  1743,  1744,  1745,     0,     0,
       0,     0,     0,     0,  1295,     0,     0,  1753,     0,     0,
       0,     0,     0,     0,  1758,  1759,  1760,     0,     0,     0,
       0,     0,  3069,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1741,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     553,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1797,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3034,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1842,     0,     0,     0,     0,
       0,     0,     0,   553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3188,     0,
    3189,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   465,     0,  2753,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2283,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     553,     0,     0,     0,  1999,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3274,     0,     0,     0,     0,     0,  3034,  3034,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3292,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   553,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3317,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3034,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2175,
    2177,  2179,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2193,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1741,   465,     0,     0,
       0,     0,     0,     0,  2224,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3274,     0,  3274,     0,
    3421,  1998,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3429,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3449,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1741,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3495,     0,     0,     0,     0,  3502,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3520,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3585,     0,     0,     0,     0,     0,     0,
       0,     0,  3596,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2454,     0,     0,  2455,     0,     0,
    2457,  2458,     0,  1741,     0,  3626,     0,     0,     0,     0,
       0,  3632,     0,  2471,     0,     0,  2474,     0,     0,     0,
     553,     0,     0,     0,  1741,     0,     0,     0,     0,  2481,
       0,  2482,     0,     0,     0,  2485,     0,  2486,  2487,     0,
    1741,     0,  2490,     0,  2491,  2492,  3666,  2493,     0,     0,
    2494,     0,  2495,  2496,     0,     0,     0,     0,  2500,  2501,
       0,     0,  2503,     0,  2504,     0,  2505,     0,  2506,     0,
    2508,  3666,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2513,  2514,     0,     0,  2515,     0,  2516,     0,     0,
       0,     0,     0,     0,     0,  2517,  2518,     0,  2519,     0,
    2520,     0,     0,  2521,  2522,  2523,     0,  2524,     0,     0,
       0,     0,  2527,  2528,  2529,  2530,     0,     0,     0,     0,
    2532,  2533,  2534,     0,  2535,     0,  2537,     0,  2539,     0,
    2541,     0,  2542,     0,     0,     0,     0,     0,     0,  2544,
       0,  2545,     0,     0,  2547,  2548,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2557,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2582,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2626,
       0,     0,     0,     0,  2630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2664,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2766,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2837,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2848,     0,  2850,     0,
    2852,     0,     0,     0,     0,     0,  2858,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2870,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2915,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3040,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3044,     0,     0,     0,     0,
       0,  3045,     0,     0,     0,     0,     0,     0,     0,     0,
    3049,  3050,     0,     0,     0,     0,  3051,     0,     0,     0,
    3052,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3056,     0,     0,     0,     0,     0,  3058,
       0,     0,  3059,  3060,     0,  3061,  3062,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3067,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3118,  3119,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2626,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3325,     0,
       0,     0,     0,     0,  3327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3343,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3355,
       0,  3357,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3444,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3458,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3523,  3524,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3544,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3555,     0,     0,     0,     0,  3559,     0,     0,
       0,     0,     0,     0,     0,     0,  3569,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3600,     0,     0,
       0,     0,     0,     0,     0,     0,   122,  3607,   737,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   738,     0,   739,   130,   131,   740,   133,     0,   134,
     741,   135,     0,   742,   136,   743,   744,   745,   137,   746,
       0,   138,   139,  1729,   140,     0,   141,   142,     0,     0,
     143,   747,   144,     0,   145,   748,   749,   147,     0,   148,
     149,   150,   750,   151,     0,   751,   153,  3667,   154,   155,
     156,   157,   158,   752,   753,   159,     0,   160,   161,     0,
     754,     0,   755,   756,   757,     0,     0,   163,   758,   759,
       0,   760,   761,     0,   164,   165,   762,   763,   764,     0,
       0,     0,     0,   765,   168,   766,     0,     0,   767,   768,
     169,     0,   170,     0,     0,     0,   769,   770,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   771,   179,     0,   772,   773,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     774,     0,   188,   775,   189,   776,   777,   190,     0,   778,
     191,   192,   193,   779,     0,   194,     0,     0,   780,     0,
     195,   196,     0,   781,   197,     0,   198,   782,   783,   784,
     785,     0,   786,   787,   200,   788,   789,   790,   202,     0,
     203,   791,     0,   792,   793,     0,   204,   205,     0,   206,
     794,     0,   207,     0,     0,     0,   795,   209,   210,   211,
     796,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     797,   215,   798,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   799,   220,     0,
    1730,   800,   221,     0,   801,   222,     0,     0,     0,   802,
       0,   803,     0,   224,   804,     0,   225,     0,   226,   805,
       0,     0,   806,     0,     0,     0,     0,   807,   227,   228,
     229,   230,   231,   232,   808,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   809,   242,   243,   244,   810,   245,
     246,     0,     0,     0,   247,   248,   811,   250,     0,     0,
     812,   252,   813,   814,   253,     0,   254,   815,   816,   817,
     818,   819,   820,   821,   259,   260,   261,   262,     0,   822,
     263,   264,     0,   265,   266,   267,   823,   824,   825,   268,
       0,   826,   827,     0,   269,   270,     0,   828,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   829,   830,   278,   831,   832,   833,
     834,   835,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   836,   287,   288,   289,   290,   291,   292,   293,   837,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   838,   839,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   840,   308,   309,
     841,   310,   311,   842,   312,   843,   314,   315,     0,   844,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   845,   846,   334,
     335,     0,   336,   847,   338,   848,   849,   850,   339,   340,
     851,   341,   342,     0,   343,   344,     0,   852,   345,   853,
     854,   855,   856,     0,     0,     0,     0,  1731,   350,     0,
     351,   857,   858,   859,   353,   354,   355,     0,   860,   356,
     357,   861,     0,   358,     0,     0,   862,   863,   359,     0,
       0,   360,     0,   361,     0,   864,   363,     0,     0,   865,
     866,   867,   868,   869,   364,     0,     0,   365,   870,     0,
     366,   367,   871,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   872,     0,   873,     0,     0,     0,     0,   874,
       0,     0,     0,   875,   876,     0,     0,     0,     0,   877,
       0,   878,     0,     0,   879,   880,     0,   881,   882,   122,
       0,   737,   124,   125,   126,   127,  2622,     0,     0,     0,
       0,   128,     0,     0,   738,     0,   739,   130,   131,   740,
     133,     0,   134,   741,   135,     0,  2623,   136,   743,   744,
     745,   137,   746,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   747,   144,     0,   145,   748,   749,
     147,     0,   148,   149,   150,   750,   151,     0,   751,   153,
       0,   154,   155,   156,   157,   158,   752,   753,   159,     0,
     160,   161,     0,   754,     0,   755,   756,   757,     0,     0,
     163,   758,   759,     0,   760,   761,     0,   164,   165,   762,
     763,   764,     0,     0,     0,     0,   765,   168,   766,     0,
       0,   767,  2624,   169,     0,   170,     0,     0,     0,   769,
     770,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   771,   179,     0,
     772,   773,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   774,     0,   188,   775,   189,   776,   777,
     190,     0,   778,   191,   192,   193,   779,     0,   194,     0,
       0,   780,     0,   195,   196,     0,   781,   197,     0,   198,
     782,   783,   784,   785,     0,   786,   787,   200,   788,   789,
     790,   202,     0,   203,   791,     0,   792,   793,     0,   204,
     205,     0,   206,   794,     0,   207,     0,     0,     0,   795,
     209,   210,   211,   796,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   797,   215,   798,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     799,   220,     0,     0,   800,   221,     0,   801,   222,     0,
       0,     0,   802,     0,   803,     0,   224,   804,     0,   225,
       0,   226,   805,     0,     0,   806,     0,     0,     0,     0,
     807,   227,   228,   229,   230,   231,   232,   808,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   809,   242,   243,
     244,   810,   245,   246,     0,     0,     0,   247,   248,   811,
     250,     0,     0,   812,   252,   813,   814,   253,     0,   254,
     815,   816,   817,   818,   819,   820,   821,   259,   260,   261,
     262,     0,   822,   263,   264,     0,   265,   266,   267,   823,
     824,   825,   268,     0,   826,   827,     0,   269,   270,     0,
     828,  2625,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   829,   830,   278,
     831,   832,   833,   834,   835,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   836,   287,   288,   289,   290,   291,
     292,   293,   837,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   838,   839,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     840,   308,   309,   841,   310,   311,   842,   312,   843,   314,
     315,     0,   844,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     845,   846,   334,   335,     0,   336,   847,   338,   848,   849,
     850,   339,   340,   851,   341,   342,     0,   343,   344,     0,
     852,   345,   853,   854,   855,   856,     0,     0,     0,     0,
       0,   350,     0,   351,   857,   858,   859,   353,   354,   355,
       0,   860,   356,   357,   861,     0,   358,     0,     0,   862,
     863,   359,     0,     0,   360,     0,   361,     0,   864,   363,
       0,     0,   865,   866,   867,   868,   869,   364,     0,     0,
     365,   870,     0,   366,   367,   871,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   872,     0,   873,     0,     0,
       0,     0,   874,     0,     0,     0,   875,   876,     0,     0,
       0,     0,   877,     0,   878,     0,     0,   879,   880,     0,
     881,   882,   122,     0,   737,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   738,     0,   739,
     130,   131,   740,   133,     0,   134,   741,   135,     0,   742,
     136,   743,   744,   745,   137,   746,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   747,   144,     0,
     145,   748,   749,   147,     0,   148,   149,   150,   750,   151,
       0,   751,   153,     0,   154,   155,   156,   157,   158,   752,
     753,   159,     0,   160,   161,     0,   754,     0,   755,   756,
     757,     0,     0,   163,   758,   759,     0,   760,   761,     0,
     164,   165,   762,   763,   764,     0,     0,     0,     0,   765,
     168,   766,     0,     0,   767,   768,   169,     0,   170,     0,
       0,     0,   769,   770,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     771,   179,     0,   772,   773,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   774,     0,   188,   775,
     189,   776,   777,   190,     0,   778,   191,   192,   193,   779,
       0,   194,     0,     0,   780,     0,   195,   196,     0,   781,
     197,     0,   198,   782,   783,   784,   785,     0,   786,   787,
     200,   788,   789,   790,   202,     0,   203,   791,     0,   792,
     793,     0,   204,   205,     0,   206,   794,     0,   207,     0,
       0,     0,   795,   209,   210,   211,   796,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   797,   215,   798,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   799,   220,     0,     0,   800,   221,     0,
     801,   222,     0,     0,     0,   802,     0,   803,     0,   224,
     804,     0,   225,     0,   226,   805,     0,     0,   806,     0,
       0,     0,     0,   807,   227,   228,   229,   230,   231,   232,
     808,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     809,   242,   243,   244,   810,   245,   246,     0,     0,     0,
     247,   248,   811,   250,     0,     0,   812,   252,   813,   814,
     253,     0,   254,   815,   816,   817,   818,   819,   820,   821,
     259,   260,   261,   262,     0,   822,   263,   264,     0,   265,
     266,   267,   823,   824,   825,   268,     0,   826,   827,     0,
     269,   270,     0,   828,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     829,   830,   278,   831,   832,   833,   834,   835,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   836,   287,   288,
     289,   290,   291,   292,   293,   837,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   838,   839,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   840,   308,   309,   841,   310,   311,   842,
     312,   843,   314,   315,     0,   844,   317,  1293,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   845,   846,   334,   335,     0,   336,   847,
     338,   848,   849,   850,   339,   340,   851,   341,   342,     0,
     343,   344,     0,   852,   345,   853,   854,   855,   856,     0,
       0,     0,     0,     0,   350,     0,   351,   857,   858,   859,
     353,   354,   355,     0,   860,   356,   357,   861,     0,   358,
       0,     0,   862,   863,   359,     0,     0,   360,     0,   361,
       0,   864,   363,     0,     0,   865,   866,   867,   868,   869,
     364,     0,     0,   365,   870,     0,   366,   367,   871,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   872,     0,
     873,     0,     0,     0,     0,   874,     0,     0,     0,   875,
     876,     0,     0,     0,     0,   877,     0,  1294,     0,     0,
     879,   880,     0,   881,   882,   122,     0,   737,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     738,     0,   739,   130,   131,   740,   133,     0,   134,   741,
     135,     0,   742,   136,   743,   744,   745,   137,   746,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     747,   144,     0,   145,   748,   749,   147,     0,   148,   149,
     150,   750,   151,     0,   751,   153,     0,   154,   155,   156,
     157,   158,   752,   753,   159,     0,   160,   161,     0,   754,
       0,   755,   756,   757,     0,     0,   163,   758,   759,     0,
     760,   761,     0,   164,   165,   762,   763,   764,     0,     0,
       0,     0,   765,   168,   766,     0,     0,   767,   768,   169,
       0,   170,     0,     0,     0,   769,   770,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   771,   179,     0,   772,   773,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   774,
       0,   188,   775,   189,   776,   777,   190,     0,   778,   191,
     192,   193,   779,     0,   194,     0,     0,   780,     0,   195,
     196,     0,   781,   197,     0,   198,   782,   783,   784,   785,
       0,   786,   787,   200,   788,   789,   790,   202,     0,   203,
     791,     0,   792,   793,     0,   204,   205,     0,   206,   794,
       0,   207,     0,     0,     0,   795,   209,   210,   211,   796,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   797,
     215,   798,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   799,   220,     0,     0,
     800,   221,     0,   801,   222,     0,     0,     0,   802,     0,
     803,     0,   224,   804,     0,   225,     0,   226,   805,     0,
       0,   806,     0,     0,     0,     0,   807,   227,   228,   229,
     230,   231,   232,   808,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   809,   242,   243,   244,   810,   245,   246,
       0,     0,     0,   247,   248,   811,   250,     0,     0,   812,
     252,   813,   814,   253,     0,   254,   815,   816,   817,   818,
     819,   820,   821,   259,   260,   261,   262,     0,   822,   263,
     264,     0,   265,   266,   267,   823,   824,   825,   268,     0,
     826,   827,     0,   269,   270,     0,   828,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   829,   830,   278,   831,   832,   833,   834,
     835,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     836,   287,   288,   289,   290,   291,   292,   293,   837,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   838,   839,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   840,   308,   309,   841,
     310,   311,   842,   312,   843,   314,   315,     0,   844,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   845,   846,   334,   335,
       0,   336,   847,   338,   848,   849,   850,   339,   340,   851,
     341,   342,     0,   343,   344,     0,   852,   345,   853,   854,
     855,   856,     0,     0,     0,     0,     0,   350,     0,   351,
     857,   858,   859,   353,   354,   355,     0,   860,   356,   357,
     861,     0,   358,     0,     0,   862,   863,   359,     0,     0,
     360,     0,   361,     0,   864,   363,     0,     0,   865,   866,
     867,   868,   869,   364,     0,     0,   365,   870,     0,   366,
     367,   871,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   872,     0,   873,     0,     0,     0,     0,   874,     0,
       0,     0,   875,   876,     0,     0,     0,     0,   877,     0,
     878,  1575,     0,   879,   880,     0,   881,   882,   122,     0,
     737,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   738,     0,   739,   130,   131,   740,   133,
       0,   134,   741,   135,     0,   742,   136,   743,   744,   745,
     137,   746,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   747,   144,     0,   145,   748,   749,   147,
       0,   148,   149,   150,   750,   151,     0,   751,   153,     0,
     154,   155,   156,   157,   158,   752,   753,   159,     0,   160,
     161,     0,   754,     0,   755,   756,   757,     0,     0,   163,
     758,   759,     0,   760,   761,     0,   164,   165,   762,   763,
     764,     0,     0,     0,     0,   765,   168,   766,     0,     0,
     767,   768,   169,     0,   170,     0,     0,     0,   769,   770,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   771,   179,     0,   772,
     773,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   774,     0,   188,   775,   189,   776,   777,   190,
       0,   778,   191,   192,   193,   779,     0,   194,     0,     0,
     780,     0,   195,   196,     0,   781,   197,     0,   198,   782,
     783,   784,   785,     0,   786,   787,   200,   788,   789,   790,
     202,     0,   203,   791,     0,   792,   793,     0,   204,   205,
       0,   206,   794,     0,   207,     0,     0,     0,   795,   209,
     210,   211,   796,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   797,   215,   798,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   799,
     220,     0,     0,   800,   221,     0,   801,   222,     0,     0,
       0,   802,     0,   803,     0,   224,   804,     0,   225,     0,
     226,   805,     0,     0,   806,     0,     0,     0,     0,   807,
     227,   228,   229,   230,   231,   232,   808,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   809,   242,   243,   244,
     810,   245,   246,     0,     0,     0,   247,   248,   811,   250,
       0,     0,   812,   252,   813,   814,   253,     0,   254,   815,
     816,   817,   818,   819,   820,   821,   259,   260,   261,   262,
       0,   822,   263,   264,     0,   265,   266,   267,   823,   824,
     825,   268,     0,   826,   827,     0,   269,   270,     0,   828,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   829,   830,   278,   831,
     832,   833,   834,   835,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   836,   287,   288,   289,   290,   291,   292,
     293,   837,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   838,   839,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   840,
     308,   309,   841,   310,   311,   842,   312,   843,   314,   315,
       0,   844,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   845,
     846,   334,   335,     0,   336,   847,   338,   848,   849,   850,
     339,   340,   851,   341,   342,     0,   343,   344,     0,   852,
     345,   853,   854,   855,   856,     0,     0,     0,     0,     0,
     350,     0,   351,   857,   858,   859,   353,   354,   355,     0,
     860,   356,   357,   861,     0,   358,     0,     0,   862,   863,
     359,     0,     0,   360,     0,   361,     0,   864,   363,     0,
       0,   865,   866,   867,   868,   869,   364,     0,     0,   365,
     870,     0,   366,   367,   871,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   872,     0,   873,     0,     0,     0,
       0,   874,     0,     0,     0,   875,   876,     0,     0,     0,
       0,   877,     0,   878,  1671,     0,   879,   880,     0,   881,
     882,   122,     0,   737,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   738,     0,   739,   130,
     131,   740,   133,     0,   134,   741,   135,     0,   742,   136,
     743,   744,   745,   137,   746,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   747,   144,     0,   145,
     748,   749,   147,     0,   148,   149,   150,   750,   151,     0,
     751,   153,     0,   154,   155,   156,   157,   158,   752,   753,
     159,     0,   160,   161,     0,   754,     0,   755,   756,   757,
       0,     0,   163,   758,   759,     0,   760,   761,     0,   164,
     165,   762,   763,   764,     0,     0,     0,     0,   765,   168,
     766,     0,     0,   767,   768,   169,     0,   170,     0,     0,
       0,   769,   770,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   771,
     179,     0,   772,   773,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   774,     0,   188,   775,   189,
     776,   777,   190,     0,   778,   191,   192,   193,   779,     0,
     194,     0,     0,   780,     0,   195,   196,     0,   781,   197,
       0,   198,   782,   783,   784,   785,     0,   786,   787,   200,
     788,   789,   790,   202,     0,   203,   791,     0,   792,   793,
       0,   204,   205,     0,   206,   794,     0,   207,     0,     0,
       0,   795,   209,   210,   211,   796,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   797,   215,   798,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   799,   220,     0,     0,   800,   221,     0,   801,
     222,     0,     0,     0,   802,     0,   803,     0,   224,   804,
       0,   225,     0,   226,   805,     0,     0,   806,     0,     0,
       0,     0,   807,   227,   228,   229,   230,   231,   232,   808,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   809,
     242,   243,   244,   810,   245,   246,     0,     0,     0,   247,
     248,   811,   250,     0,     0,   812,   252,   813,   814,   253,
       0,   254,   815,   816,   817,   818,   819,   820,   821,   259,
     260,   261,   262,     0,   822,   263,   264,     0,   265,   266,
     267,   823,   824,   825,   268,     0,   826,   827,     0,   269,
     270,     0,   828,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   829,
     830,   278,   831,   832,   833,   834,   835,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   836,   287,   288,   289,
     290,   291,   292,   293,   837,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     838,   839,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   840,   308,   309,   841,   310,   311,   842,   312,
     843,   314,   315,     0,   844,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   845,   846,   334,   335,     0,   336,   847,   338,
     848,   849,   850,   339,   340,   851,   341,   342,     0,   343,
     344,     0,   852,   345,   853,   854,   855,   856,     0,     0,
       0,     0,     0,   350,     0,   351,   857,   858,   859,   353,
     354,   355,     0,   860,   356,   357,   861,     0,   358,     0,
       0,   862,   863,   359,     0,     0,   360,     0,   361,     0,
     864,   363,     0,     0,   865,   866,   867,   868,   869,   364,
       0,     0,   365,   870,     0,   366,   367,   871,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   872,     0,   873,
       0,     0,     0,     0,   874,     0,     0,     0,   875,   876,
       0,     0,     0,     0,   877,     0,   878,  1708,     0,   879,
     880,     0,   881,   882,   122,     0,   737,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   738,
       0,   739,   130,   131,   740,   133,     0,   134,   741,   135,
       0,   742,   136,   743,   744,   745,   137,   746,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   747,
     144,     0,   145,   748,   749,   147,     0,   148,   149,   150,
     750,   151,     0,   751,   153,     0,   154,   155,   156,   157,
     158,   752,   753,   159,     0,   160,   161,     0,   754,     0,
     755,   756,   757,     0,     0,   163,   758,   759,     0,   760,
     761,     0,   164,   165,   762,   763,   764,     0,     0,     0,
       0,   765,   168,   766,     0,     0,   767,   768,   169,     0,
     170,     0,     0,     0,   769,   770,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   771,   179,     0,   772,   773,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   774,     0,
     188,   775,   189,   776,   777,   190,     0,   778,   191,   192,
     193,   779,     0,   194,     0,     0,   780,     0,   195,   196,
       0,   781,   197,     0,   198,   782,   783,   784,   785,     0,
     786,   787,   200,   788,   789,   790,   202,     0,   203,   791,
       0,   792,   793,     0,   204,   205,     0,   206,   794,     0,
     207,     0,     0,     0,   795,   209,   210,   211,   796,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   797,   215,
     798,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   799,   220,     0,     0,   800,
     221,     0,   801,   222,     0,     0,     0,   802,     0,   803,
       0,   224,   804,     0,   225,     0,   226,   805,     0,     0,
     806,     0,     0,     0,     0,   807,   227,   228,   229,   230,
     231,   232,   808,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   809,   242,   243,   244,   810,   245,   246,     0,
       0,     0,   247,   248,   811,   250,     0,     0,   812,   252,
     813,   814,   253,     0,   254,   815,   816,   817,   818,   819,
     820,   821,   259,   260,   261,   262,     0,   822,   263,   264,
       0,   265,   266,   267,   823,   824,   825,   268,     0,   826,
     827,     0,   269,   270,     0,   828,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   829,   830,   278,   831,   832,   833,   834,   835,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   836,
     287,   288,   289,   290,   291,   292,   293,   837,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   838,   839,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   840,   308,   309,   841,   310,
     311,   842,   312,   843,   314,   315,     0,   844,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   845,   846,   334,   335,     0,
     336,   847,   338,   848,   849,   850,   339,   340,   851,   341,
     342,     0,   343,   344,     0,   852,   345,   853,   854,   855,
     856,     0,     0,     0,     0,     0,   350,     0,   351,   857,
     858,   859,   353,   354,   355,     0,   860,   356,   357,   861,
       0,   358,     0,     0,   862,   863,   359,     0,     0,   360,
       0,   361,     0,   864,   363,     0,     0,   865,   866,   867,
     868,   869,   364,     0,     0,   365,   870,     0,   366,   367,
     871,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     872,     0,   873,     0,     0,     0,     0,   874,     0,     0,
       0,   875,   876,     0,     0,     0,     0,   877,     0,   878,
    1735,     0,   879,   880,     0,   881,   882,   122,     0,   737,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   738,     0,   739,   130,   131,   740,   133,     0,
     134,   741,   135,     0,   742,   136,   743,   744,   745,   137,
     746,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   747,   144,     0,   145,   748,   749,   147,     0,
     148,   149,   150,   750,   151,     0,   751,   153,     0,   154,
     155,   156,   157,   158,   752,   753,   159,     0,   160,   161,
       0,   754,     0,   755,   756,   757,     0,     0,   163,   758,
     759,     0,   760,   761,     0,   164,   165,   762,   763,   764,
       0,     0,     0,     0,   765,   168,   766,     0,     0,   767,
     768,   169,     0,   170,     0,     0,     0,   769,   770,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   771,   179,     0,   772,   773,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   774,     0,   188,   775,   189,   776,   777,   190,     0,
     778,   191,   192,   193,   779,     0,   194,     0,     0,   780,
       0,   195,   196,  2174,   781,   197,     0,   198,   782,   783,
     784,   785,     0,   786,   787,   200,   788,   789,   790,   202,
       0,   203,   791,     0,   792,   793,     0,   204,   205,     0,
     206,   794,     0,   207,     0,     0,     0,   795,   209,   210,
     211,   796,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   797,   215,   798,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   799,   220,
       0,     0,   800,   221,     0,   801,   222,     0,     0,     0,
     802,     0,   803,     0,   224,   804,     0,   225,     0,   226,
     805,     0,     0,   806,     0,     0,     0,     0,   807,   227,
     228,   229,   230,   231,   232,   808,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   809,   242,   243,   244,   810,
     245,   246,     0,     0,     0,   247,   248,   811,   250,     0,
       0,   812,   252,   813,   814,   253,     0,   254,   815,   816,
     817,   818,   819,   820,   821,   259,   260,   261,   262,     0,
     822,   263,   264,     0,   265,   266,   267,   823,   824,   825,
     268,     0,   826,   827,     0,   269,   270,     0,   828,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   829,   830,   278,   831,   832,
     833,   834,   835,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   836,   287,   288,   289,   290,   291,   292,   293,
     837,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   838,   839,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   840,   308,
     309,   841,   310,   311,   842,   312,   843,   314,   315,     0,
     844,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   845,   846,
     334,   335,     0,   336,   847,   338,   848,   849,   850,   339,
     340,   851,   341,   342,     0,   343,   344,     0,   852,   345,
     853,   854,   855,   856,     0,     0,     0,     0,     0,   350,
       0,   351,   857,   858,   859,   353,   354,   355,     0,   860,
     356,   357,   861,     0,   358,     0,     0,   862,   863,   359,
       0,     0,   360,     0,   361,     0,   864,   363,     0,     0,
     865,   866,   867,   868,   869,   364,     0,     0,   365,   870,
       0,   366,   367,   871,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   872,     0,   873,     0,     0,     0,     0,
     874,     0,     0,     0,   875,   876,     0,     0,     0,     0,
     877,     0,   878,     0,     0,   879,   880,     0,   881,   882,
     122,     0,   737,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   738,     0,   739,   130,   131,
     740,   133,     0,   134,   741,   135,     0,   742,   136,   743,
     744,   745,   137,   746,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   747,   144,     0,   145,   748,
     749,   147,     0,   148,   149,   150,   750,   151,     0,   751,
     153,     0,   154,   155,   156,   157,   158,   752,   753,   159,
       0,   160,   161,     0,   754,     0,   755,   756,   757,     0,
       0,   163,   758,   759,     0,   760,   761,     0,   164,   165,
     762,   763,   764,     0,     0,     0,     0,   765,   168,   766,
       0,     0,   767,   768,   169,     0,   170,     0,     0,     0,
     769,   770,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   771,   179,
       0,   772,   773,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   774,     0,   188,   775,   189,   776,
     777,   190,     0,   778,   191,   192,   193,   779,     0,   194,
       0,     0,   780,     0,   195,   196,  2176,   781,   197,     0,
     198,   782,   783,   784,   785,     0,   786,   787,   200,   788,
     789,   790,   202,     0,   203,   791,     0,   792,   793,     0,
     204,   205,     0,   206,   794,     0,   207,     0,     0,     0,
     795,   209,   210,   211,   796,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   797,   215,   798,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   799,   220,     0,     0,   800,   221,     0,   801,   222,
       0,     0,     0,   802,     0,   803,     0,   224,   804,     0,
     225,     0,   226,   805,     0,     0,   806,     0,     0,     0,
       0,   807,   227,   228,   229,   230,   231,   232,   808,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   809,   242,
     243,   244,   810,   245,   246,     0,     0,     0,   247,   248,
     811,   250,     0,     0,   812,   252,   813,   814,   253,     0,
     254,   815,   816,   817,   818,   819,   820,   821,   259,   260,
     261,   262,     0,   822,   263,   264,     0,   265,   266,   267,
     823,   824,   825,   268,     0,   826,   827,     0,   269,   270,
       0,   828,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   829,   830,
     278,   831,   832,   833,   834,   835,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   836,   287,   288,   289,   290,
     291,   292,   293,   837,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   838,
     839,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   840,   308,   309,   841,   310,   311,   842,   312,   843,
     314,   315,     0,   844,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   845,   846,   334,   335,     0,   336,   847,   338,   848,
     849,   850,   339,   340,   851,   341,   342,     0,   343,   344,
       0,   852,   345,   853,   854,   855,   856,     0,     0,     0,
       0,     0,   350,     0,   351,   857,   858,   859,   353,   354,
     355,     0,   860,   356,   357,   861,     0,   358,     0,     0,
     862,   863,   359,     0,     0,   360,     0,   361,     0,   864,
     363,     0,     0,   865,   866,   867,   868,   869,   364,     0,
       0,   365,   870,     0,   366,   367,   871,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   872,     0,   873,     0,
       0,     0,     0,   874,     0,     0,     0,   875,   876,     0,
       0,     0,     0,   877,     0,   878,     0,     0,   879,   880,
       0,   881,   882,   122,     0,   737,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   738,     0,
     739,   130,   131,   740,   133,     0,   134,   741,   135,     0,
     742,   136,   743,   744,   745,   137,   746,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   747,   144,
       0,   145,   748,   749,   147,     0,   148,   149,   150,   750,
     151,     0,   751,   153,     0,   154,   155,   156,   157,   158,
     752,   753,   159,     0,   160,   161,     0,   754,     0,   755,
     756,   757,     0,     0,   163,   758,   759,     0,   760,   761,
       0,   164,   165,   762,   763,   764,     0,     0,     0,     0,
     765,   168,   766,     0,     0,   767,   768,   169,     0,   170,
       0,     0,     0,   769,   770,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   771,   179,     0,   772,   773,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   774,     0,   188,
     775,   189,   776,   777,   190,     0,   778,   191,   192,   193,
     779,     0,   194,     0,     0,   780,     0,   195,   196,  2178,
     781,   197,     0,   198,   782,   783,   784,   785,     0,   786,
     787,   200,   788,   789,   790,   202,     0,   203,   791,     0,
     792,   793,     0,   204,   205,     0,   206,   794,     0,   207,
       0,     0,     0,   795,   209,   210,   211,   796,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   797,   215,   798,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   799,   220,     0,     0,   800,   221,
       0,   801,   222,     0,     0,     0,   802,     0,   803,     0,
     224,   804,     0,   225,     0,   226,   805,     0,     0,   806,
       0,     0,     0,     0,   807,   227,   228,   229,   230,   231,
     232,   808,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   809,   242,   243,   244,   810,   245,   246,     0,     0,
       0,   247,   248,   811,   250,     0,     0,   812,   252,   813,
     814,   253,     0,   254,   815,   816,   817,   818,   819,   820,
     821,   259,   260,   261,   262,     0,   822,   263,   264,     0,
     265,   266,   267,   823,   824,   825,   268,     0,   826,   827,
       0,   269,   270,     0,   828,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   829,   830,   278,   831,   832,   833,   834,   835,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   836,   287,
     288,   289,   290,   291,   292,   293,   837,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   838,   839,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   840,   308,   309,   841,   310,   311,
     842,   312,   843,   314,   315,     0,   844,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   845,   846,   334,   335,     0,   336,
     847,   338,   848,   849,   850,   339,   340,   851,   341,   342,
       0,   343,   344,     0,   852,   345,   853,   854,   855,   856,
       0,     0,     0,     0,     0,   350,     0,   351,   857,   858,
     859,   353,   354,   355,     0,   860,   356,   357,   861,     0,
     358,     0,     0,   862,   863,   359,     0,     0,   360,     0,
     361,     0,   864,   363,     0,     0,   865,   866,   867,   868,
     869,   364,     0,     0,   365,   870,     0,   366,   367,   871,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   872,
       0,   873,     0,     0,     0,     0,   874,     0,     0,     0,
     875,   876,     0,     0,     0,     0,   877,     0,   878,     0,
       0,   879,   880,     0,   881,   882,   122,     0,   737,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   738,     0,   739,   130,   131,   740,   133,     0,   134,
     741,   135,     0,   742,   136,   743,   744,   745,   137,   746,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   747,   144,     0,   145,   748,   749,   147,     0,   148,
     149,   150,   750,   151,     0,   751,   153,     0,   154,   155,
     156,   157,   158,   752,   753,   159,     0,   160,   161,     0,
     754,     0,   755,   756,   757,     0,     0,   163,   758,   759,
       0,   760,   761,     0,   164,   165,   762,   763,   764,     0,
       0,     0,     0,   765,   168,   766,     0,     0,   767,   768,
     169,     0,   170,     0,     0,     0,   769,   770,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   771,   179,     0,   772,   773,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     774,     0,   188,   775,   189,   776,   777,   190,     0,   778,
     191,   192,   193,   779,     0,   194,     0,     0,   780,     0,
     195,   196,     0,   781,   197,     0,   198,   782,   783,   784,
     785,     0,   786,   787,   200,   788,   789,   790,   202,     0,
     203,   791,     0,   792,   793,     0,   204,   205,     0,   206,
     794,     0,   207,     0,     0,     0,   795,   209,   210,   211,
     796,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     797,   215,   798,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   799,   220,     0,
       0,   800,   221,     0,   801,   222,     0,     0,     0,   802,
       0,   803,     0,   224,   804,     0,   225,     0,   226,   805,
       0,     0,   806,     0,     0,     0,     0,   807,   227,   228,
     229,   230,   231,   232,   808,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   809,   242,   243,   244,   810,   245,
     246,     0,     0,     0,   247,   248,   811,   250,     0,     0,
     812,   252,   813,   814,   253,     0,   254,   815,   816,   817,
     818,   819,   820,   821,   259,   260,   261,   262,     0,   822,
     263,   264,     0,   265,   266,   267,   823,   824,   825,   268,
       0,   826,   827,     0,   269,   270,     0,   828,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   829,   830,   278,   831,   832,   833,
     834,   835,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   836,   287,   288,   289,   290,   291,   292,   293,   837,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   838,   839,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   840,   308,   309,
     841,   310,   311,   842,   312,   843,   314,   315,     0,   844,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   845,   846,   334,
     335,     0,   336,   847,   338,   848,   849,   850,   339,   340,
     851,   341,   342,     0,   343,   344,     0,   852,   345,   853,
     854,   855,   856,     0,     0,     0,     0,     0,   350,     0,
     351,   857,   858,   859,   353,   354,   355,     0,   860,   356,
     357,   861,     0,   358,     0,     0,   862,   863,   359,     0,
       0,   360,     0,   361,     0,   864,   363,     0,     0,   865,
     866,   867,   868,   869,   364,     0,     0,   365,   870,     0,
     366,   367,   871,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   872,     0,   873,     0,     0,     0,     0,   874,
       0,     0,     0,   875,   876,     0,     0,     0,     0,   877,
       0,   878,     0,     0,   879,   880,     0,   881,   882,   122,
       0,   737,   124,   125,   126,   127,  1767,     0,     0,     0,
       0,  1768,     0,     0,   738,     0,   739,   130,   131,   740,
     133,     0,   134,   741,   135,     0,   742,   136,   743,   744,
     745,   137,   746,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   747,   144,     0,   145,   748,   749,
     147,     0,   148,   149,   150,   750,   151,     0,   751,   153,
       0,   154,   155,   156,   157,   158,   752,   753,   159,     0,
     160,   161,     0,   754,     0,   755,   756,   757,     0,     0,
     163,   758,   759,     0,   760,   761,     0,   164,   165,   762,
     763,   764,     0,     0,     0,     0,   765,   168,   766,     0,
       0,   767,   768,   169,     0,   170,     0,     0,     0,   769,
     770,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   771,   179,     0,
     772,   773,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   774,     0,   188,   775,   189,   776,   777,
     190,     0,   778,   191,   192,   193,   779,     0,   194,     0,
       0,   780,     0,   195,   196,     0,   781,   197,     0,   198,
     782,   783,   784,   785,     0,   786,   787,   200,   788,   789,
     790,   202,     0,   203,   791,     0,   792,   793,     0,   204,
     205,     0,   206,   794,     0,   207,     0,     0,     0,   795,
     209,   210,   211,   796,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   797,   215,   798,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     799,   220,     0,     0,   800,   221,     0,   801,   222,     0,
       0,     0,   802,     0,   803,     0,   224,   804,     0,   225,
       0,   226,   805,     0,     0,   806,     0,     0,     0,     0,
     807,   227,   228,   229,   230,   231,   232,   808,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   809,   242,   243,
     244,   810,   245,   246,     0,     0,     0,   247,   248,   811,
     250,     0,     0,   812,   252,   813,   814,   253,     0,   254,
     815,   816,   817,   818,   819,   820,   821,   259,   260,   261,
     262,     0,   822,   263,   264,     0,   265,   266,   267,   823,
       0,   825,   268,     0,   826,   827,     0,   269,   270,     0,
     828,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   829,   830,   278,
     831,   832,   833,   834,   835,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   836,   287,   288,   289,   290,   291,
     292,   293,   837,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   838,   839,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     840,   308,   309,   841,   310,   311,   842,   312,   843,   314,
     315,     0,   844,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     845,   846,   334,   335,     0,   336,   847,   338,   848,   849,
     850,   339,   340,   851,   341,   342,     0,   343,   344,     0,
     852,   345,   853,   854,   855,   856,     0,     0,     0,     0,
       0,   350,     0,   351,   857,   858,   859,   353,   354,   355,
       0,   860,   356,   357,   861,     0,   358,     0,     0,   862,
     863,   359,     0,     0,   360,     0,   361,     0,   864,   363,
       0,     0,   865,   866,   867,   868,   869,   364,     0,     0,
     365,   870,     0,   366,   367,   871,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   872,     0,   873,     0,     0,
       0,     0,   874,     0,     0,     0,   875,   876,     0,     0,
       0,     0,   877,     0,   878,     0,     0,   879,   880,     0,
     881,   882,   122,     0,   737,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   738,     0,   739,
     130,   131,   740,   133,     0,   134,   741,   135,     0,   742,
     136,   743,   744,   745,   137,   746,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   747,   144,     0,
     145,   748,   749,   147,     0,   148,   149,   150,   750,   151,
       0,   751,   153,     0,   154,   155,   156,   157,   158,   752,
     753,   159,     0,   160,   161,     0,   754,     0,   755,   756,
     757,     0,     0,   163,   758,   759,     0,   760,   761,     0,
     164,   165,   762,   763,   764,     0,     0,     0,     0,   765,
     168,   766,     0,     0,   767,   768,   169,     0,   170,     0,
       0,     0,   769,   770,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     771,   179,     0,   772,   773,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   774,     0,   188,   775,
     189,   776,   777,   190,     0,   778,   191,   192,   193,   779,
       0,   194,     0,     0,   780,     0,   195,   196,     0,   781,
     197,     0,   198,   782,   783,   784,   785,     0,   786,   787,
     200,   788,   789,   790,   202,     0,   203,   791,     0,   792,
     793,     0,   204,   205,     0,   206,   794,     0,   207,     0,
       0,     0,   795,   209,   210,   211,   796,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   797,   215,  2453,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   799,   220,     0,     0,   800,   221,     0,
     801,   222,     0,     0,     0,   802,     0,   803,     0,   224,
     804,     0,   225,     0,   226,   805,     0,     0,   806,     0,
       0,     0,     0,   807,   227,   228,   229,   230,   231,   232,
     808,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     809,   242,   243,   244,   810,   245,   246,     0,     0,     0,
     247,   248,   811,   250,     0,     0,   812,   252,   813,   814,
     253,     0,   254,   815,   816,   817,   818,   819,   820,   821,
     259,   260,   261,   262,     0,   822,   263,   264,     0,   265,
     266,   267,   823,   824,   825,   268,     0,   826,   827,     0,
     269,   270,     0,   828,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     829,   830,   278,   831,   832,   833,   834,   835,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   836,   287,   288,
     289,   290,   291,   292,   293,   837,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   838,   839,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   840,   308,   309,   841,   310,   311,   842,
     312,   843,   314,   315,     0,   844,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   845,   846,   334,   335,     0,   336,   847,
     338,   848,   849,   850,   339,   340,   851,   341,   342,     0,
     343,   344,     0,   852,   345,   853,   854,   855,   856,     0,
       0,     0,     0,     0,   350,     0,   351,   857,   858,   859,
     353,   354,   355,     0,   860,   356,   357,   861,     0,   358,
       0,     0,   862,   863,   359,     0,     0,   360,     0,   361,
       0,   864,   363,     0,     0,   865,   866,   867,   868,   869,
     364,     0,     0,   365,   870,     0,   366,   367,   871,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   872,     0,
     873,     0,     0,     0,     0,   874,     0,     0,     0,   875,
     876,     0,     0,     0,     0,   877,     0,   878,     0,     0,
     879,   880,     0,   881,   882,   122,     0,   737,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     738,     0,   739,   130,   131,   740,   133,     0,   134,   741,
     135,     0,   742,   136,   743,   744,   745,   137,   746,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     747,   144,     0,   145,   748,   749,   147,     0,   148,   149,
     150,   750,   151,     0,   751,   153,     0,   154,   155,   156,
     157,   158,   752,   753,   159,     0,   160,   161,     0,   754,
       0,   755,   756,   757,     0,     0,   163,   758,   759,     0,
     760,   761,     0,   164,   165,   762,   763,   764,     0,     0,
       0,     0,   765,   168,   766,     0,     0,   767,   768,   169,
       0,   170,     0,     0,     0,   769,   770,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   771,   179,     0,   772,   773,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   774,
       0,   188,   775,   189,   776,   777,   190,     0,   778,   191,
     192,   193,   779,     0,   194,     0,     0,   780,     0,   195,
     196,     0,   781,   197,     0,   198,   782,   783,   784,   785,
       0,   786,   787,   200,   788,   789,   790,   202,     0,   203,
     791,     0,   792,   793,     0,   204,   205,     0,   206,   794,
       0,   207,     0,     0,     0,   795,   209,   210,   211,   796,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   797,
     215,  2526,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   799,   220,     0,     0,
     800,   221,     0,   801,   222,     0,     0,     0,   802,     0,
     803,     0,   224,   804,     0,   225,     0,   226,   805,     0,
       0,   806,     0,     0,     0,     0,   807,   227,   228,   229,
     230,   231,   232,   808,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   809,   242,   243,   244,   810,   245,   246,
       0,     0,     0,   247,   248,   811,   250,     0,     0,   812,
     252,   813,   814,   253,     0,   254,   815,   816,   817,   818,
     819,   820,   821,   259,   260,   261,   262,     0,   822,   263,
     264,     0,   265,   266,   267,   823,   824,   825,   268,     0,
     826,   827,     0,   269,   270,     0,   828,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   829,   830,   278,   831,   832,   833,   834,
     835,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     836,   287,   288,   289,   290,   291,   292,   293,   837,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   838,   839,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   840,   308,   309,   841,
     310,   311,   842,   312,   843,   314,   315,     0,   844,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   845,   846,   334,   335,
       0,   336,   847,   338,   848,   849,   850,   339,   340,   851,
     341,   342,     0,   343,   344,     0,   852,   345,   853,   854,
     855,   856,     0,     0,     0,     0,     0,   350,     0,   351,
     857,   858,   859,   353,   354,   355,     0,   860,   356,   357,
     861,     0,   358,     0,     0,   862,   863,   359,     0,     0,
     360,     0,   361,     0,   864,   363,     0,     0,   865,   866,
     867,   868,   869,   364,     0,     0,   365,   870,     0,   366,
     367,   871,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   872,     0,   873,     0,     0,     0,     0,   874,     0,
       0,     0,   875,   876,     0,     0,     0,     0,   877,     0,
     878,     0,     0,   879,   880,     0,   881,   882,   122,     0,
     737,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   738,     0,   739,   130,   131,   740,   133,
       0,   134,   741,   135,     0,   742,   136,   743,   744,   745,
     137,   746,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   747,   144,     0,   145,   748,   749,   147,
       0,   148,   149,   150,   750,   151,     0,   751,   153,     0,
     154,   155,   156,   157,   158,   752,   753,   159,     0,   160,
     161,     0,   754,     0,   755,   756,   757,     0,     0,   163,
     758,   759,     0,   760,   761,     0,   164,   165,   762,   763,
     764,     0,     0,     0,     0,   765,   168,   766,     0,     0,
     767,  2877,   169,     0,   170,     0,     0,     0,   769,   770,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   771,   179,     0,   772,
     773,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   774,     0,   188,   775,   189,   776,   777,   190,
       0,   778,   191,   192,   193,   779,     0,   194,     0,     0,
     780,     0,   195,   196,     0,   781,   197,     0,   198,   782,
     783,   784,   785,     0,   786,   787,   200,   788,   789,   790,
     202,     0,   203,   791,     0,   792,   793,     0,   204,   205,
       0,   206,   794,     0,   207,     0,     0,     0,   795,   209,
     210,   211,   796,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   797,   215,   798,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   799,
     220,     0,     0,   800,   221,     0,   801,   222,     0,     0,
       0,   802,     0,   803,     0,   224,   804,     0,   225,     0,
     226,   805,     0,     0,   806,     0,     0,     0,     0,   807,
     227,   228,   229,   230,   231,   232,   808,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   809,   242,   243,   244,
     810,   245,   246,     0,     0,     0,   247,   248,   811,   250,
       0,     0,   812,   252,   813,   814,   253,     0,   254,   815,
     816,   817,   818,   819,   820,   821,   259,   260,   261,   262,
       0,   822,   263,   264,     0,   265,   266,   267,   823,   824,
     825,   268,     0,   826,   827,     0,   269,   270,     0,   828,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   829,   830,   278,   831,
     832,   833,   834,   835,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   836,   287,   288,   289,   290,   291,   292,
     293,   837,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   838,   839,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   840,
     308,   309,   841,   310,   311,   842,   312,   843,   314,   315,
       0,   844,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   845,
     846,   334,   335,     0,   336,   847,   338,   848,   849,   850,
     339,   340,   851,   341,   342,     0,   343,   344,     0,   852,
     345,   853,   854,   855,   856,     0,     0,     0,     0,     0,
     350,     0,   351,   857,   858,   859,   353,   354,   355,     0,
     860,   356,   357,   861,     0,   358,     0,     0,   862,   863,
     359,     0,     0,   360,     0,   361,     0,   864,   363,     0,
       0,   865,   866,   867,   868,   869,   364,     0,     0,   365,
     870,     0,   366,   367,   871,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   872,     0,   873,     0,     0,     0,
       0,   874,     0,     0,     0,   875,   876,     0,     0,     0,
       0,   877,     0,   878,     0,     0,   879,   880,     0,   881,
     882,   122,     0,   737,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   738,     0,   739,   130,
     131,   740,   133,     0,   134,   741,   135,     0,   742,   136,
     743,   744,   745,   137,   746,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   747,   144,     0,   145,
     748,   749,   147,     0,   148,   149,   150,   750,   151,     0,
     751,   153,     0,   154,   155,   156,   157,   158,   752,   753,
     159,     0,   160,   161,     0,   754,     0,   755,   756,   757,
       0,     0,   163,   758,   759,     0,   760,   761,     0,   164,
     165,   762,   763,   764,     0,     0,     0,     0,   765,   168,
     766,     0,     0,   767,   768,   169,     0,   170,     0,     0,
       0,   769,   770,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   771,
     179,     0,   772,   773,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   774,     0,   188,   775,   189,
     776,   777,   190,     0,   778,   191,   192,   193,   779,     0,
     194,     0,     0,   780,     0,   195,   196,     0,   781,   197,
       0,   198,   782,   783,   784,   785,     0,   786,   787,   200,
     788,   789,   790,   202,     0,   203,   791,     0,   792,   793,
       0,   204,   205,     0,   206,   794,     0,   207,     0,     0,
       0,   795,   209,   210,   211,   796,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   797,   215,   798,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   799,   220,     0,     0,   800,   221,     0,   801,
     222,     0,     0,     0,   802,     0,   803,     0,   224,   804,
       0,   225,     0,   226,   805,     0,     0,   806,     0,     0,
       0,     0,   807,   227,   228,   229,   230,   231,   232,   808,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   809,
     242,   243,   244,   810,   245,   246,     0,     0,     0,   247,
     248,   811,   250,     0,     0,   812,   252,   813,   814,   253,
       0,   254,   815,   816,   817,   818,   819,   820,   821,   259,
     260,   261,   262,     0,   822,   263,   264,     0,   265,   266,
     267,   823,     0,   825,   268,     0,   826,   827,     0,   269,
     270,     0,   828,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   829,
     830,   278,   831,   832,   833,   834,   835,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   836,   287,   288,   289,
     290,   291,   292,   293,   837,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     838,   839,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   840,   308,   309,   841,   310,   311,   842,   312,
     843,   314,   315,     0,   844,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   845,   846,   334,   335,     0,   336,   847,   338,
     848,   849,   850,   339,   340,   851,   341,   342,     0,   343,
     344,     0,   852,   345,   853,   854,   855,   856,     0,     0,
       0,     0,     0,   350,     0,   351,   857,   858,   859,   353,
     354,   355,     0,   860,   356,   357,   861,     0,   358,     0,
       0,   862,   863,   359,     0,     0,   360,     0,   361,     0,
     864,   363,     0,     0,   865,   866,   867,   868,   869,   364,
       0,     0,   365,   870,     0,   366,   367,   871,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   872,     0,   873,
       0,     0,     0,     0,   874,     0,     0,     0,   875,   876,
       0,     0,     0,     0,   877,     0,   878,     0,     0,   879,
     880,     0,   881,   882,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,  1941,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,  1942,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,  1088,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,  1089,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,  2438,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,  1854,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,  1943,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  1990,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,  1941,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,  1942,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,  1088,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,  1089,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,  1943,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  1990,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,  1854,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
    2258,     0,   130,   131,   132,   133,   882,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
    3619,   128,     0,     0,   129,  3620,   882,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,   975,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   408,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,  1813,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   408,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,     0,
       0,     0,     0,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  1989,     0,   128,     0,     0,   129,
       0,  1990,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,     0,     0,     0,     0,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,  3620,   882,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   408,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   462,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   408,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,   882,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,  1990,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   550,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     551,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
    1754,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   550,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   551,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,  2298,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,   550,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   551,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -179,  2900,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,     0,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -179,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -179,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -179,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,     0,  3471,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,  3671,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  1597,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2284,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2577,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2905,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -179,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,  -194,     0,   179,
       0,     0,     0,  -194,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -179,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -179,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -179,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,  -194,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -179,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,  -215,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -179,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -179,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,  -215,
       0,  -179,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,  -215,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -179,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,  -212,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -179,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -179,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,  -212,     0,  -179,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,  -212,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -179,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,  3551,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -179,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -179,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,  -179,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,     0,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -179,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,  -217,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -179,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -179,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,   360,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,  -179,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,     0,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -179,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,  3597,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -179,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -179,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -179,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -179,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,  3637,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -179,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -179,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -179,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,     0,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -179,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,  -198,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -179,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -179,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,  -179,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,     0,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -179,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,     0,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -179,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -179,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,  -179,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,     0,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -179,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,     0,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -179,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -179,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,  3554,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,  -179,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,     0,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,  1607,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,  1608,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,  1609,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,  1610,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
     700,   701,     0,   268,     0,     0,  1611,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,  3659,  3649,  3660,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,  1612,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,  2290,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
    2291,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,  1928,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,   550,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,  1929,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   551,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,  2300,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  2301,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   550,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   551,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,  2290,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,  2291,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   550,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   551,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,   704,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   550,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   551,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,   656,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,   657,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   658,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,  2338,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   550,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   551,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2290,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   550,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     551,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   550,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   551,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,  2280,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   551,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,  3592,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,  3593,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,   731,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  1084,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,  1879,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,  1880,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,  1996,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   551,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,  1879,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,  1390,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,  1391,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,     0,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,     0,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,     0,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,     0,     0,   302,     0,     0,   304,     0,     0,
     306,   307,     0,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,     0,     0,     0,
       0,   372
};

static const short int yycheck[] =
{
       7,   489,   494,   495,   457,   437,   671,   894,   591,  1157,
     616,   637,    19,  1283,   961,    22,   758,   759,   760,  1283,
     412,   764,    29,   614,  1193,  1014,   742,  1748,   515,  1831,
    1064,   637,    39,   485,   486,  1858,  1932,  1191,  1882,  1883,
    1884,  1308,    49,    22,  2315,  2039,  2265,   638,  1315,  1889,
    1159,  1160,  1161,  1506,   567,  2057,  1917,  1910,  1185,  1472,
    1370,   675,  2064,  1172,   516,  1918,  1519,  1920,  2655,   444,
    2678,  1873,   675,  2663,  1164,  1165,  1593,  1167,    32,  1029,
      87,     3,  1077,   825,     7,     3,   573,  1896,  1897,     3,
    1040,  1041,  1327,  1328,  2708,     3,  1947,  2711,  1225,  1070,
     107,   108,     3,   110,    18,     3,     3,    27,    87,   851,
     853,  1951,  1202,   856,   121,  1426,  2730,  1226,  1486,    16,
    1229,     3,  2736,   865,   866,   867,     3,  1217,     3,    54,
      55,  1971,  1972,   585,    15,    16,  2937,    48,    18,    55,
      34,   499,   121,    16,    68,  1235,  1236,  1237,  1257,  1258,
      92,  1942,  1943,  1262,   132,    34,  1246,   112,  2772,   875,
     876,   877,  2036,   144,    15,    16,  1247,    76,    53,   153,
    1941,   887,   165,  1282,    11,  1284,  1947,    15,    16,  1950,
      93,    59,  1953,    57,   639,   108,   246,   110,    15,    16,
    2359,    48,   679,  1964,  1965,    28,    15,    16,    15,    16,
      18,   225,  1973,   578,    32,  1152,   334,   171,    51,  2032,
    1598,    15,    16,   247,    60,   495,  1596,   210,   710,   711,
     712,    15,    16,   615,   128,     8,   108,    55,   142,  2944,
     682,   108,    32,   108,  2258,  1316,    18,   294,  1319,  1320,
    1321,  1322,  3473,  1324,  1325,  1326,  1327,  1328,  1329,  1330,
    1331,  1332,    15,    16,    91,   340,   420,   112,   108,   230,
      15,    16,   142,    18,    15,    16,    94,   201,   153,    97,
     110,   156,    15,    16,    49,   281,  3386,   105,    15,    16,
      58,   171,    57,   168,    20,    74,   353,   389,    15,    16,
      58,   171,    15,    16,  3095,  1182,    32,    15,    16,  2886,
     213,    15,    16,    12,    11,   199,   558,    15,    16,    45,
    1916,   345,   210,   257,  2590,    15,    16,   210,    54,    55,
     199,   247,    62,    62,   142,   247,   171,    20,   153,   247,
     171,   126,   153,   328,   485,   476,   455,   517,   175,   247,
     435,   532,   213,   380,    15,    16,   247,   494,    43,   453,
    2252,    15,    16,   281,  2968,   546,   393,   109,   522,   523,
     142,    54,    55,  2977,   219,   371,   535,    15,    16,    94,
     517,   475,    97,   210,   493,   536,    86,   160,   213,  1266,
     225,   561,   171,  1270,  2660,  1902,   423,  1052,   372,   314,
      91,   398,   487,   562,   389,   497,   560,   232,   886,    15,
      16,   408,   109,   655,  3514,   412,   247,  1555,   293,   476,
     417,   562,  1560,   122,    20,   422,  3024,   474,  1566,   345,
     171,  1569,  3653,   345,   264,   566,    32,  1018,   353,   435,
     263,   402,  2334,   323,   562,  1026,    65,   444,   417,    45,
      15,    16,   499,  3033,   345,   349,   264,   727,    54,    55,
     228,  1042,  1043,   142,   461,  2299,  1070,   171,  1064,   911,
     228,  2322,   371,   344,   471,  1208,   347,  1070,    48,   503,
     477,  2367,   224,   533,   175,   264,   483,   252,   485,   486,
     330,   281,   567,   490,   491,   328,  2330,   372,  1001,  1869,
     401,   319,   471,   344,   501,  1604,   347,   395,   505,  2668,
    3087,   196,   395,   510,   511,  2356,   513,   514,   515,   516,
     384,   455,   964,    15,    16,  1129,  1466,   344,    63,  2370,
     347,   455,   974,   516,  2041,   344,  1129,   344,   347,   366,
     347,   515,  1019,  1276,   380,  3125,  1989,    37,   562,  3340,
     344,  1909,   549,   347,   401,  1540,   324,   372,    57,   530,
     344,   372,   416,   347,    15,    16,   511,   435,   565,   472,
      57,   394,   380,  2354,  1875,   485,   573,   574,   546,  1082,
    3285,   578,  2446,   965,   498,  2599,  1685,   952,   585,  2032,
    1689,   344,   476,  1038,   347,  2356,   565,   529,  1858,   344,
     513,   514,   347,   344,  1858,   574,   347,   476,   562,  2370,
     975,   344,  1318,  1574,   347,   433,   560,   344,   615,   525,
     347,   533,   485,  1722,  1783,   533,  1785,   344,  1772,  2890,
     347,   344,    15,    16,   347,   533,   344,    15,    16,   347,
     344,   426,   533,   347,    10,   472,   344,   517,   535,   347,
     347,   566,  1074,  1359,   344,   567,   568,   347,  1006,  1919,
     568,   562,  2040,   481,   568,  1919,   511,   166,  2038,   540,
     568,  1751,    15,    16,   671,   366,   567,   568,  3258,   166,
     568,   568,   679,   344,   452,   682,   347,   562,   685,   686,
     344,   509,   562,   347,   565,   463,   568,    15,    16,   540,
     515,   568,  3306,   568,  3308,   463,   344,  1778,   408,   347,
     517,   534,   540,   485,  1974,    15,    16,   686,  1083,  3317,
    1974,  1792,  1793,   540,   565,   455,   455,  2323,  2324,   537,
     415,   540,   729,   540,   731,   560,    19,   342,   344,   127,
    2959,   347,  3322,  2962,   561,   562,   540,   562,   427,   368,
    1132,   562,   561,   562,   397,   562,   540,   435,   328,  2593,
     729,   472,   731,   478,  2271,  2272,   481,  3028,   562,  3373,
     538,  3375,   217,    15,    16,   102,   502,   561,   562,   344,
     225,   472,   347,  2596,     0,  1923,   336,   540,    15,    16,
    1667,  3389,    15,    16,  2645,   540,   142,  2631,  2649,   540,
     175,   175,  2645,   353,    15,    16,  2649,   540,   561,   562,
     403,   346,   420,   540,  1952,  2607,  1954,    15,    16,   502,
     561,  1959,   168,   540,  2665,  3405,     3,   540,   561,   562,
     113,   401,   540,  1311,   561,   562,   540,  1975,   529,  1977,
    1978,  1979,   540,   170,   561,   562,  2071,  2072,   561,   562,
     540,   470,   344,   561,   562,   347,   426,  1734,   562,   388,
      15,    16,   123,   561,   562,   364,   168,    15,    16,  3446,
     489,   561,   562,    15,    16,  1491,   283,   364,   205,   540,
    1461,   420,   362,   880,  1465,   882,   540,  1468,  1469,  1366,
     503,   264,   142,   344,   123,  1491,   347,   318,   388,   155,
     561,   562,   540,  1406,  2665,   350,   502,   561,   905,    15,
      16,  2314,   402,  1416,   911,   135,  1298,  1896,  1897,   562,
      15,    16,   451,   561,   562,   145,   476,    12,   524,   525,
     337,  1408,  1409,   423,   540,  1377,   905,  1440,    15,    16,
    2941,   225,  2449,  3162,    15,    16,  2930,  2760,   561,   261,
     104,   948,   560,   950,   256,   952,   562,   472,    15,    16,
    2217,   344,   246,  1903,   347,  2764,   344,   964,   965,   347,
    1574,  2963,   299,   109,   567,   540,  1358,   974,   975,   420,
     307,  1574,  2062,    12,  1921,   171,   173,  2067,   985,  1371,
     567,   366,   366,  2253,  1497,    16,   561,   562,  3207,  2253,
     366,   344,  2082,  1988,   347,   504,  2123,   380,   162,  2089,
    1007,  1008,  1009,  1010,  3612,  1437,   455,   504,    12,   331,
    1017,   560,  1019,   171,  2104,  2105,   344,   105,  1025,   347,
     317,  2111,   420,    15,    16,   109,   222,   122,  1035,  2119,
    1009,  1010,   354,   370,   344,   306,   476,   347,   540,   217,
     337,  2122,   476,  1556,  1557,   476,  1559,   225,  1561,  1562,
    1563,  1564,  1565,   318,  1567,  1568,  1035,  2211,   420,   561,
     562,  2922,  2923,  2373,   330,   560,  2220,   306,  2158,   500,
    2914,   427,   567,  1080,   450,  1791,  1083,   526,  3307,   540,
    3309,   418,    63,   122,  1007,  1008,   230,   472,   472,    15,
      16,   385,   344,    66,  1017,   347,  2043,   261,   485,   243,
     561,  1080,  1025,  3097,    15,    16,   561,   344,   472,   560,
     347,   344,   488,   343,   347,  3126,  3127,   283,   122,  3390,
      15,    16,   562,   344,   420,  1132,   347,  1134,   562,  1136,
    1137,  1138,  1139,  1140,    12,   223,   344,  2654,  2228,   347,
     224,   209,  1149,   560,  1151,    15,    16,   540,   110,   345,
      15,    16,   540,   529,   537,   352,    75,  3159,    15,    16,
    1139,   420,   560,   104,  3435,   146,   564,   331,   561,   562,
      89,   337,   350,   561,   562,   497,    15,    16,  1185,   344,
     318,   187,   347,    38,    15,    16,   344,   540,  2075,   347,
      15,    16,   344,   166,   531,   347,  2083,   420,   560,    15,
      16,    15,    16,  2656,  2657,  2658,   543,  3030,   561,   562,
     252,   476,   540,  1136,  1137,    15,    16,   210,  1225,  2943,
     517,   162,    15,    16,     8,   491,    15,    16,   344,   560,
     540,   347,  2685,   561,   562,   500,   567,   434,   200,   344,
     213,   507,   347,    27,   122,   475,   252,    15,    16,   325,
     326,   561,   562,    15,    16,   549,    12,   344,  3111,   232,
     347,  2985,   406,   344,   560,   120,   347,    15,    16,   160,
     213,   264,  3467,  3468,    15,    16,  1283,   344,    15,    16,
     347,   552,   553,   554,   555,   556,   557,   329,   540,   232,
     532,  1298,   532,   381,   525,   560,  1749,   528,    15,    16,
    2567,   560,   264,   540,   546,   564,   546,   540,  2477,  2478,
     562,    15,    16,   473,    20,   554,   555,   556,   557,   540,
     261,    15,    16,   433,   561,   562,    32,   213,   561,   562,
    2600,   340,   540,   497,    15,    16,  2600,   560,   476,    45,
     561,   562,   209,   470,   366,   472,   237,   222,    54,    55,
     171,  1358,   344,   561,   562,   347,  1363,  1364,  1967,  1366,
     318,  3556,   500,  1876,  1371,   346,   122,    15,    16,   470,
    1377,   472,  1379,   461,   535,   540,  1985,  1384,  1385,   372,
    1387,   264,   540,  2653,    15,    16,   561,   514,   540,  2653,
     331,   364,  1399,   567,   454,  1402,   561,   562,   458,   509,
     142,  1408,  1409,  1410,  1411,  1384,  1385,   450,  1387,  2679,
     562,  1418,  1419,  1420,    53,  2679,    15,    16,   344,   425,
    1399,   347,   560,  1402,   540,    15,    16,   560,   450,  1436,
     395,  1410,  1411,   344,   544,   540,   347,   328,  1445,  1418,
    1419,  1420,  1955,  1956,    11,   561,   562,  2697,   149,   344,
    2700,  2701,   347,   540,   517,  1462,   561,   562,  3260,   540,
    1467,    15,    16,  1976,  2498,   365,   488,  2717,   104,   187,
    2560,   337,  1479,   540,   344,   562,   470,   347,  1485,   344,
     410,   562,   347,   337,    15,    16,   420,   344,  1467,   342,
     347,  1883,   426,  1885,  1886,   562,    20,   410,  2214,   210,
       3,    15,    16,     6,    28,   344,  1485,   529,   347,    33,
      13,    15,    16,   344,   153,   562,   347,   156,   476,   344,
      23,    24,   347,   561,   562,  1957,   162,    46,   344,   168,
     344,   347,   937,   347,   252,   940,   171,  1544,   943,  1931,
    1932,  3356,   500,  3358,   344,  1552,    46,   347,   540,    52,
     257,   344,   562,    56,   347,   344,   497,  3401,   347,   155,
     473,    15,    16,   199,    67,    15,    16,    15,    16,   416,
     562,   337,  1579,    76,   503,  1967,   344,  3417,    81,   347,
     439,   440,   344,   442,  1591,   347,   554,  1594,   522,   523,
      93,  3487,  3313,  1985,   269,   270,   344,  2766,   257,   347,
     147,   514,   560,   344,   426,   108,   347,   344,   111,   493,
     347,   560,  1591,   247,   540,  2885,   529,   120,   121,   168,
     338,  2885,   455,   126,   281,   261,   560,   344,   455,   540,
     347,   134,    54,    55,   470,  2460,   562,   140,   455,  2464,
     344,    63,   188,   347,   257,   540,    54,    55,    15,    16,
     344,   562,   139,   347,   293,    15,    16,   561,   562,    77,
      15,    16,   165,   344,   562,  2057,   347,   562,  2837,  1385,
     540,  1387,  2064,    15,    16,   540,   561,   562,   339,     3,
    2306,   468,  2265,   540,   561,    15,    16,    15,    16,   561,
     562,   108,   562,   419,    18,   331,   344,   562,    51,   347,
    2306,   540,  1418,  1419,  1420,   562,   529,   425,   211,   540,
     213,   386,   387,   344,   149,   540,   347,   220,   561,   562,
     561,   562,  2313,   562,   540,   389,   540,   561,   562,   325,
     326,   562,   560,   372,   330,  2227,   566,   562,   284,   285,
     540,    91,   288,   289,    15,    16,   562,   540,   562,   207,
    1757,   540,    15,    16,   344,   561,   562,   347,   562,    15,
      16,    85,   562,  2250,   175,   450,   451,  2280,   453,   562,
     455,   529,   540,   562,   175,  2764,   562,  2867,   540,   561,
     562,   561,   562,   286,   561,   562,    15,    16,    15,    16,
     344,   567,   540,   347,   562,   125,   502,   300,   562,   540,
     562,   168,   305,   540,   476,    15,    16,   561,   562,  2296,
      15,    16,  2204,   344,   562,   560,   347,   560,   142,    15,
      16,   562,   528,   540,   174,   562,  1507,    15,    16,  1510,
     344,   561,   562,   347,    15,    16,   540,   560,  1519,   560,
     344,   165,   345,   347,   168,   562,   540,  1528,   351,   562,
     353,  1858,    15,    16,   560,  2368,   561,   562,   562,   540,
     560,   497,  2375,   213,   561,   562,  2691,   191,   562,  1876,
    1877,   374,   375,   197,   377,   567,  1883,   560,  1885,  1886,
     560,   562,   561,   562,    15,    16,   210,   117,   391,   560,
     344,   215,   540,   347,   344,   491,   344,   347,   222,   347,
    2725,  2726,   560,    15,    16,   560,   230,  2623,  2733,   540,
     413,   507,  1919,   560,   562,  2740,    15,    16,   560,   243,
      28,    15,    16,   247,  1931,  1932,    15,    16,   561,   562,
     560,   562,   256,   560,  1941,   560,    15,    16,     3,    67,
    1947,   561,   562,  1950,   561,   562,  1953,   561,   562,   560,
     540,    79,  2404,    18,    15,    16,   560,  1964,  1965,   560,
    1967,    69,  2657,  2658,    15,    16,  1973,  1974,    15,    16,
    2917,   201,   562,  3132,  3133,  2367,  1983,   344,  1985,   560,
     347,   560,  1989,  1990,   344,   560,   540,   347,   560,   344,
     560,   494,   347,   317,    15,    16,    70,    71,  1267,  1268,
     503,   560,   344,   560,  1983,   347,  2579,  2580,   562,   540,
     560,    15,    16,   337,   344,   560,   344,   347,   560,   347,
      85,   345,  2609,  2610,  2031,  2032,   540,   257,  2875,  2876,
     138,   562,   560,   560,   108,   560,   540,   560,   560,   560,
      15,    16,   366,   560,   560,   560,   566,   560,   562,   560,
    2057,   281,  2031,    15,    16,   560,   130,  2064,   562,   562,
     567,   560,    15,    16,   560,   568,  3336,    15,    16,   560,
    2077,   560,   560,   344,   560,   560,   347,   142,   560,   560,
     560,   344,   406,   560,   347,   560,   540,   161,   344,   439,
     540,   347,   540,    15,    16,   560,   560,  3245,  3246,  3247,
    3248,   560,   426,   168,   560,    15,    16,   235,   562,   560,
      15,    16,   562,  3222,   562,   344,  2123,   344,   347,   560,
     347,   560,   472,   473,    15,    16,   191,   397,   560,   399,
     560,   401,   197,   403,   344,   365,   460,   347,    46,   344,
     560,   371,   347,   562,    15,    16,  3236,   560,   344,   470,
     215,   347,    15,    16,   504,   560,   344,   222,   560,   347,
     560,   560,   560,   344,   514,   230,   347,   560,   560,   399,
      15,    16,   560,   540,   560,  3445,   304,   560,   243,   503,
     540,   344,   247,   560,   347,   540,   560,   560,    15,    16,
     560,   256,   516,   517,   561,    15,    16,  2204,   540,   560,
     328,   561,   560,   535,   560,   435,   561,   252,   560,   533,
     540,   535,   540,   344,   560,   560,   347,    15,    16,   561,
    2612,   560,  2229,    15,    16,   455,  2233,   560,  2235,  2236,
    2237,  2238,   344,   561,   560,   347,  2628,   561,   562,  2246,
     470,  2754,   472,  2250,   568,   344,  2253,   517,   347,   560,
     344,   379,   317,   347,   362,   344,   560,  2749,   347,   560,
    2267,  2268,  2269,   560,   560,   344,   560,  2246,   347,   540,
     560,   560,   337,  2280,   382,    15,    16,   540,   560,  2286,
     345,  2288,   560,   344,   540,   560,   347,    15,    16,  2296,
     561,    15,    16,   344,   560,   560,   347,   344,   561,   407,
     347,   366,   560,  2957,  2958,   561,   560,   560,   560,   383,
     560,   540,   560,   540,   560,   560,    15,    16,    15,    16,
     560,  2975,   450,   344,   560,   560,   347,  2981,    15,    16,
     540,   281,   561,  3603,   561,   540,   560,   142,   560,  3603,
     344,   406,   560,   347,   540,   281,   454,   562,   562,  2356,
    3004,   561,   540,  3007,  3624,   160,   561,    15,    16,   540,
    2367,   426,   485,  2370,   562,   561,   485,    15,    16,   344,
    3640,   562,   347,   561,   225,   180,  3640,   540,   562,  2871,
     561,  3046,   344,    15,    16,   347,  3129,  3130,  3131,   194,
     562,   344,   476,  3541,   347,   460,   344,  2404,   561,   347,
     554,   168,   562,  2916,  2411,   510,   437,  2414,   355,   540,
     562,  2418,  2419,   560,   562,  2422,   547,   561,   561,   142,
     142,   142,   344,  2430,   142,   347,   142,   142,   540,   142,
    3172,  2438,   237,   238,   344,  2414,   142,   347,   503,   344,
     142,   540,   347,    15,    16,   562,   540,   142,   142,   561,
     142,   540,   517,   344,    15,    16,   347,   142,   142,  2438,
     265,   540,   561,    15,    16,   142,   512,   561,   533,    44,
     535,  2984,   561,   344,   175,   337,   347,    15,    16,   540,
     171,   344,   561,    63,   347,    12,   547,   476,  3153,   540,
     561,   561,   122,   540,     9,   561,   561,   562,   561,   344,
    3013,  3166,   347,   568,   532,   561,    15,    16,  2900,   567,
     561,   560,   246,   553,   561,    15,    16,   344,   323,   540,
     347,   562,    15,    16,   344,   380,   533,   347,  2960,   188,
     567,     3,   214,   171,    15,    16,   540,   561,    15,    16,
     561,    13,    14,   435,   426,   562,   344,    15,    16,   347,
     562,   168,   344,    44,    26,   347,    28,   561,   363,  3072,
     450,   450,  3304,   450,   450,   540,   450,    15,    16,   419,
      66,  2963,   485,   119,    46,    47,   231,   471,   540,   231,
      52,    44,    15,    16,    56,    57,   561,   540,   471,    15,
      16,  2983,   540,  2600,  2601,   119,  2603,    69,   562,   561,
     560,   517,   567,   561,   344,  2612,   562,   347,   561,    15,
      16,  2618,    84,   561,    15,    16,   344,   561,   540,   347,
     344,  2628,   561,   347,  3207,   554,    15,    16,   561,  2636,
     540,   103,    15,    16,   561,   540,   561,    15,    16,   561,
     112,   113,   114,    15,    16,   344,  2653,   344,   347,   540,
     347,   561,   561,   125,   126,   561,   561,   344,  2665,   561,
     347,    15,    16,    15,    16,  2672,   567,    15,    16,   540,
     561,   427,  2679,   104,   171,   560,   148,   540,  2685,    15,
      16,    15,    16,   561,   560,   562,   344,   561,   561,   347,
     561,   561,   164,   562,   561,   540,   344,    16,   561,   347,
    3192,  3193,   547,   171,   561,    15,    16,   561,  3100,  3374,
     562,   560,   344,   540,   561,   347,   188,     7,   561,   561,
     540,    15,    16,   195,   561,   561,   198,   562,   561,    19,
     561,   162,    22,   561,   561,   557,   560,   256,   561,    29,
     485,   561,   540,  3408,  3409,   476,  3411,   219,   540,    39,
    3509,   567,   567,    15,    16,  2762,   485,    15,    16,    49,
     485,   233,   562,   561,   537,    15,    16,  3159,   199,   561,
     252,   485,   344,    15,    16,   347,   560,   342,   171,   251,
     171,   171,  3669,   344,   256,   222,   347,  3452,  3547,  3454,
    3455,   171,   344,   171,   535,   347,   567,    87,   227,   567,
     540,   562,   138,   230,   123,   230,   344,   348,   296,   347,
      93,    93,   540,   232,   232,   567,   540,   107,   108,   476,
     110,   561,   560,   560,   403,   560,  3318,  3586,   345,    12,
     261,   121,   331,   561,   554,   344,   221,   561,   347,   331,
     138,   540,  3601,   540,   344,   331,   210,   347,   567,   561,
    3609,   344,   561,   540,   347,  2862,   561,   561,   561,   567,
     567,  3314,   561,   344,   561,   561,   347,   344,    57,   341,
     347,   561,   561,    16,   561,   561,   344,    66,  2885,   347,
     554,   560,   540,   337,  3643,   561,  3645,   562,   511,    78,
     362,   171,   540,  2900,   567,   225,   344,   369,  3386,   347,
     331,   244,    63,   561,   269,   230,   230,   337,   540,   562,
     232,   344,   232,   561,   347,   562,    18,   389,   344,   391,
     392,   347,   337,   395,    18,   496,   398,   561,   400,   561,
      18,   560,   247,   405,  2941,   407,   560,   223,   344,   122,
     560,   347,   373,   344,   416,   376,   347,   223,   420,   561,
     561,   561,   561,   561,   426,   344,  2963,   561,   347,   431,
     567,   344,   561,   435,   347,   561,   344,   561,   540,   347,
     561,    85,   344,   561,   561,   347,  2983,   166,   562,   540,
     123,   562,   454,   561,   561,   174,   458,   306,   540,   561,
     344,   567,   344,   347,   561,   347,   344,   561,   561,   347,
     561,  3008,   540,  3010,   562,   129,   241,   562,   344,   561,
     344,   347,   420,   347,  3021,  3447,  3023,   200,   191,   428,
     492,   560,   142,   561,   213,  3517,  3514,   560,   230,   561,
      23,   540,   348,   230,   344,   560,   508,   347,   108,   511,
     540,   104,  3021,   232,   516,   108,   562,   540,   108,   560,
     344,   496,   561,   347,   560,   361,   560,   560,   560,   540,
     567,   561,   560,   540,   331,  3072,   497,   539,   561,  3561,
      63,   561,   540,   562,    67,   331,   561,   561,   561,   331,
     561,   561,   344,   422,   561,   347,   344,    40,   560,   347,
     104,   561,   540,  3100,   344,  3487,   371,   347,   331,   162,
     561,   215,   344,   561,   222,   347,   561,   540,   398,   562,
     429,   430,   535,  3120,   540,   108,   230,   567,   408,  3126,
    3127,    44,   412,   197,   562,   303,   380,   417,   561,   243,
      91,   476,   422,  3140,   540,   561,   199,   230,   476,   540,
     517,   517,   168,   123,    85,   331,   560,   560,   162,   560,
     331,   540,  3159,   560,   444,   561,    32,   540,  3646,   528,
     561,   528,   540,   306,   560,   331,   108,   511,   540,   331,
     232,   461,   561,   232,   330,   364,   331,   331,   561,   331,
     331,   471,   535,  3671,   303,   199,   540,   477,   540,   561,
     561,  3198,   540,   483,   562,   485,   486,   123,   261,   560,
     490,   491,  3209,   317,   540,   561,   540,   561,   151,   561,
     561,   501,   561,   561,   175,   505,   562,   476,    65,   561,
     510,   511,   562,   513,   514,   515,   516,   561,  3620,   561,
     540,   550,   551,   552,   553,   554,   555,   556,   557,   232,
     476,   232,   476,   561,   561,   225,   540,   261,     4,    16,
     439,   561,   213,     9,    10,   230,   517,   517,   561,   549,
     561,   444,   445,   446,   447,   448,   449,   561,   331,   561,
     327,    27,   523,   561,   215,   565,    32,   460,   540,   168,
      36,   562,   540,   573,   574,   331,   429,   430,   578,   230,
     540,   561,   406,   561,   403,   585,   561,   561,   540,   561,
     331,   342,   243,   561,    34,   511,   270,   472,    57,   249,
     342,   561,   560,   560,   560,   504,    57,   331,   561,   561,
     561,   561,   561,   366,    44,   615,   306,    44,   135,  3336,
    3337,    44,   325,   326,   142,   384,     5,   330,   561,   342,
     342,   131,   562,    44,   337,   561,   460,    44,    44,  3356,
     562,  3358,   118,  3360,  3361,    16,   414,   532,  3337,   569,
     116,   560,   274,   532,   142,  3372,   171,    97,   561,   222,
     138,   364,   568,   561,   104,   123,   317,   562,   209,   532,
     306,   671,   106,   138,   123,   263,   568,   210,   548,   679,
     569,   568,   682,   331,   562,   685,   686,   560,   123,  3406,
     138,   362,   547,   195,   562,   366,   249,   550,   551,   552,
     553,   554,   555,   556,   557,   426,   548,   168,   568,   547,
     394,  2236,  2237,  2238,   123,   155,   168,   108,   442,   534,
    1805,   424,   162,  3440,   497,    23,    24,   168,  3445,   729,
     523,   731,   169,  1570,  3483,    23,    24,   677,  3020,   429,
     430,  3197,  2267,  2268,  2269,  3023,  3671,  3464,  3634,  3642,
    3467,  3468,  3469,  3526,  3567,   406,    54,    55,    56,   199,
    3567,  3533,  3029,  1129,   392,    63,    54,    55,    56,    67,
    3487,  2758,  3124,   497,    34,    63,   225,  1540,    76,    67,
    2685,  3498,  2424,  2032,  1544,  1506,  1945,  1992,    76,   142,
     143,  3508,  3509,   429,   430,    93,  3513,   246,  2708,  2672,
    2708,   504,   473,  2741,  3151,    93,  2946,  2992,  2983,   460,
     108,  2628,  3529,   111,  3531,  2673,   225,   488,  3535,  3371,
     108,   261,  3362,   111,  3143,  3209,  3290,   180,  1144,  3166,
    3547,  1988,    85,  1474,  1049,  1853,  1410,    97,   686,  3556,
    2246,   194,   140,   514,   104,   535,  3563,  1125,   306,  1836,
     670,  1867,   140,  3570,   456,  3572,  3573,   306,   529,   603,
     550,   551,   552,   553,   554,   555,   556,   557,  3255,  3586,
    2870,   306,  2871,   226,  1425,  3072,   325,   326,   318,  2065,
     880,  1222,   882,  2643,  3601,   238,  3603,   327,  3605,  3606,
     330,   331,  3609,  3361,  3611,   155,  1172,   306,    85,  2221,
    3617,  3121,   162,  3620,  2679,   905,  3561,  3624,  3100,   952,
     975,   911,   265,  3630,  1832,   213,   552,   553,   554,   555,
     556,   557,   220,  3640,  1872,   213,  3643,  1857,  3645,  3646,
    2885,  2595,   220,  2594,  3624,  2653,   385,  3445,   404,   199,
    3657,  3658,   446,   731,  3661,  1149,   506,   437,   948,  1376,
     950,  2585,   952,   419,  3671,  3349,   980,  3516,   246,   425,
    3536,  3415,   215,  3640,   964,   965,  2985,  2600,   321,  2298,
     993,   429,   430,  1431,   974,   975,  2636,   230,  3108,   445,
     429,   430,  2911,   429,   983,   985,   586,  3243,   286,   438,
     243,    67,  1402,   993,   429,   430,  1134,   945,   286,  3249,
     590,   261,   300,    79,   430,  2233,  2551,  1007,  1008,  1009,
    1010,   496,   300,  1293,  2198,   389,   389,  1017,   473,  1019,
     429,   430,  2030,   495,  2755,  1025,   495,   495,   215,  3026,
      -1,    -1,    -1,    -1,    -1,  1035,   476,    -1,   478,    85,
      -1,   481,   118,   230,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   491,    -1,   351,    -1,   353,   243,   497,   318,    -1,
     500,    -1,    -1,   351,   317,   353,    -1,    -1,    -1,    -1,
     330,   331,    -1,    -1,    -1,    -1,   374,   375,  2603,   377,
    1080,    -1,    -1,  1083,   337,    -1,   374,   375,    -1,   377,
      -1,    -1,   550,   551,   552,   553,   554,   555,   556,   557,
     549,   550,   551,   552,   553,   554,   555,   556,   557,    -1,
      -1,    -1,   552,   553,    -1,   413,   551,   552,   553,   554,
     555,   556,   557,    -1,    -1,   413,    -1,    -1,    -1,    -1,
     317,    -1,  1132,    -1,  1134,    -1,  1136,  1137,  1138,  1139,
    1140,   550,   551,   552,   553,   554,   555,   556,   557,  1149,
     337,  1151,    -1,   406,    -1,    13,    14,    -1,    -1,   235,
      -1,    -1,   267,   268,   269,   270,   271,   272,    26,   215,
     275,   276,   277,   278,   279,   280,    -1,   282,    -1,    -1,
      -1,    -1,    -1,    -1,   230,  1185,    -1,    -1,    46,    47,
      -1,    -1,    -1,    -1,    52,    -1,   494,   243,    56,    57,
      -1,    -1,    -1,    -1,    -1,   503,   494,   460,    -1,    -1,
      -1,    69,    -1,    -1,    -1,   503,   476,    -1,   478,   406,
      -1,   481,    -1,  3440,    -1,  1225,    84,    -1,   304,    -1,
      -1,   491,    -1,    -1,    -1,    -1,    -1,   497,    -1,    -1,
     500,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,   325,
     326,    -1,   328,    -1,   112,   113,   114,    -1,    -1,    12,
      13,    -1,    -1,    -1,   562,    -1,    -1,   125,   126,    -1,
      -1,   317,   560,   460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   386,   387,  1283,    -1,    -1,    -1,    -1,    -1,    -1,
     148,   337,   552,   553,    -1,    -1,  3513,    -1,  1298,    -1,
      -1,    -1,    -1,   379,    -1,    -1,   164,    -1,    -1,    -1,
      -1,    -1,  3529,    -1,  3531,    -1,    -1,    -1,  3535,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    84,    -1,    -1,    -1,    -1,    -1,   195,    31,    32,
     198,    -1,    -1,    -1,    37,    -1,    39,    40,    41,    -1,
      -1,    -1,    -1,  3570,    -1,    -1,  3573,    -1,  1358,   112,
     406,   219,    55,  1363,  1364,    -1,  1366,    -1,    -1,    -1,
      -1,  1371,    -1,   126,   450,   233,    -1,  1377,    -1,  1379,
      -1,    -1,    -1,    -1,  1384,  1385,    -1,  1387,    -1,  3606,
      -1,    -1,    -1,   251,    -1,   148,    -1,    -1,   256,  1399,
    3617,    94,  1402,    -1,    97,    -1,   159,    -1,  1408,  1409,
    1410,  1411,   105,  3630,   460,    -1,    -1,    -1,  1418,  1419,
    1420,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   124,    -1,    -1,    -1,   188,  1436,    -1,    -1,    -1,
    3657,  3658,    -1,    -1,  3661,  1445,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     213,    -1,  1462,    -1,    -1,    -1,   219,  1467,   161,    -1,
     163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1479,
      -1,    -1,    -1,   341,    -1,  1485,    -1,    -1,    -1,   182,
     183,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   256,   362,    -1,    -1,    -1,    -1,    -1,
      -1,   369,    -1,    -1,    -1,    12,    13,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   389,    -1,   391,   392,    -1,    -1,   395,    -1,    -1,
     398,    -1,   400,    -1,  1544,    -1,    -1,   405,    -1,   407,
      13,    -1,  1552,    -1,    -1,    -1,    -1,   250,   416,    -1,
      -1,    -1,   420,    -1,    -1,    -1,   259,   260,   426,   262,
      -1,    -1,    -1,   431,    -1,    -1,    -1,   435,    -1,  1579,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,
      -1,  1591,    -1,    -1,  1594,    -1,   454,   290,   291,   292,
     458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   367,   112,    -1,   310,   311,   312,
      -1,    84,    -1,   316,    -1,    -1,   319,    -1,    -1,   126,
      -1,   384,    -1,    -1,   492,    -1,    -1,   390,    -1,   332,
     333,    -1,    -1,   396,    -1,    -1,    -1,    -1,    -1,   112,
     508,   148,    -1,   511,    -1,    -1,    -1,    -1,   516,    -1,
      -1,    -1,   159,   126,   357,    -1,   359,   420,    -1,    -1,
      -1,    -1,    98,    99,   100,   101,   102,    -1,   431,   432,
      -1,   539,    -1,    -1,    -1,   148,    -1,    -1,   381,    -1,
      -1,   188,    -1,    -1,    -1,    -1,   159,    -1,    -1,    -1,
      -1,    -1,   560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   467,    -1,   213,    -1,    -1,    -1,
      -1,    -1,   219,    -1,    -1,   188,    -1,    -1,    -1,    -1,
      -1,   424,    -1,   426,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   436,   170,    -1,    -1,    -1,    -1,    -1,
     213,    -1,    -1,    -1,    -1,    -1,   219,  1757,   511,   256,
     513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   202,   203,   204,   205,
      -1,    -1,  1496,    -1,   477,   478,    -1,    -1,   481,   482,
     483,   484,    -1,   256,  1508,  1509,    -1,  1511,  1512,  1513,
      -1,    -1,  1516,    -1,    -1,    -1,    -1,  1521,    -1,    -1,
      -1,  1525,  1526,  1527,    -1,    -1,  1530,  1531,  1532,  1533,
    1534,    -1,  1536,  1537,  1538,    -1,    -1,    -1,    -1,    -1,
      -1,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1858,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
     367,   297,   298,   299,    -1,    -1,  1876,  1877,    -1,    -1,
      -1,   307,    -1,  1883,    -1,  1885,  1886,   384,    -1,    -1,
      -1,    -1,    30,   390,    32,    33,    -1,    -1,    -1,   396,
      -1,    -1,    -1,    -1,   367,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    54,    55,    -1,  1919,
      -1,   384,    -1,   420,    -1,    -1,    64,   390,    66,    -1,
      -1,  1931,  1932,   396,   431,   432,    -1,    -1,    -1,    -1,
      -1,  1941,    -1,    -1,   370,    83,    84,  1947,    -1,    -1,
    1950,    -1,    -1,  1953,    92,    -1,    -1,   420,    -1,    -1,
      -1,    -1,    -1,    -1,  1964,  1965,    -1,  1967,   431,   432,
     467,    -1,    -1,  1973,  1974,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1983,    -1,  1985,    -1,    -1,    -1,  1989,
    1990,   417,   418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,   140,    -1,   467,    -1,   144,    -1,    -1,    -1,
       6,    -1,    -1,    -1,   511,    -1,   513,    13,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    24,    -1,
      -1,  2031,  2032,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   511,   187,
     513,   189,    -1,    -1,    -1,    -1,    52,  2057,   508,    -1,
      56,    -1,    -1,    -1,  2064,    -1,    -1,    -1,    -1,    23,
      24,    67,    -1,    -1,   212,   213,    -1,  2077,   216,    -1,
      76,    -1,    -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,    -1,    -1,    93,    -1,    -1,
      54,    55,    56,    23,    24,   531,    -1,    -1,    -1,    63,
      -1,   561,   108,    67,   252,   111,   542,   543,    -1,   257,
      -1,    -1,    76,  2123,   120,    -1,    -1,    -1,    -1,    -1,
     126,    -1,    -1,    -1,    -1,    -1,    56,    -1,   134,    93,
      -1,    -1,    -1,   281,   140,    -1,    -1,    67,    -1,    -1,
      -1,    -1,    -1,    -1,   108,    -1,    76,   111,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   165,
      -1,    -1,    -1,    93,    -1,   313,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   322,    -1,   140,    -1,   108,    -1,
      -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   340,    -1,  2204,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   213,    -1,    -1,
     140,    -1,    -1,    -1,   220,    -1,    -1,   365,   366,  2229,
      -1,    -1,    -1,  2233,    -1,  2235,  2236,  2237,  2238,   689,
      -1,    -1,    -1,    -1,  1958,    -1,  2246,    -1,    -1,    -1,
    2250,    -1,    -1,  2253,    -1,  1969,    -1,    -1,    -1,   213,
      -1,    -1,    -1,    -1,    -1,    -1,   220,  2267,  2268,  2269,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2280,    -1,    -1,    -1,    -1,    -1,  2286,   425,  2288,    -1,
     286,    -1,    -1,   213,    -1,    -1,  2296,   435,    -1,    -1,
     220,    -1,    -1,    -1,   300,    -1,    -1,    -1,    -1,   305,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   286,    -1,   472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   300,    -1,   798,   345,
      -1,    -1,    -1,    -1,    -1,   351,  2356,   353,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   286,  2367,    -1,    -1,
    2370,    -1,    -1,  3440,   824,    -1,    -1,    -1,   374,   375,
     300,   377,    -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,
      -1,    -1,   530,    -1,    -1,   391,    -1,   351,    -1,   353,
    3467,  3468,    -1,    -1,  2404,    -1,    -1,    -1,    -1,    -1,
      -1,  2411,    -1,    -1,  2414,    -1,    -1,   413,  2418,  2419,
     374,   375,  2422,   377,   874,    -1,    -1,    -1,   878,    -1,
    2430,   351,    -1,   353,    -1,    -1,    -1,    -1,  2438,    -1,
      -1,  3508,  3509,    -1,    -1,    -1,  3513,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,   375,    -1,   377,    -1,   413,
      -1,    -1,  3529,    -1,  3531,    -1,    -1,    -1,  3535,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3547,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3556,
      -1,    -1,    -1,   413,    -1,    -1,    -1,    -1,   494,    -1,
      -1,    -1,    -1,  3570,    -1,    -1,  3573,   503,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3586,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3601,    -1,    -1,    -1,    -1,  3606,
     494,    -1,  3609,   993,    -1,    -1,    -1,    -1,    -1,   503,
    3617,    -1,  1002,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3630,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   494,    -1,  3643,    -1,  3645,    -1,
      -1,    -1,    -1,   503,    -1,    -1,    -1,    -1,    -1,    -1,
    3657,  3658,    -1,    -1,  3661,    -1,    -1,    -1,    -1,    -1,
    2600,  2601,    -1,  2603,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2612,    -1,    -1,    -1,    -1,    -1,  2618,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2628,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2636,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2653,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2665,    -1,    -1,    -1,    -1,
      -1,    -1,  2672,    -1,    -1,    -1,    -1,    -1,    -1,  2679,
      -1,    -1,    -1,    -1,    -1,  2685,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1153,  1154,  1155,    -1,    -1,    -1,    -1,
      -1,    -1,  1162,  1163,    -1,    -1,  1166,    -1,  1168,  1169,
    1170,  1171,    -1,    -1,    -1,  1175,    -1,    -1,  1178,  1179,
      -1,  1181,    -1,  1183,  1184,    -1,  1186,  1187,  1188,  1189,
    1190,    -1,  1192,    -1,  1194,  1195,  1196,    -1,  1198,  1199,
    1200,  1201,    -1,  1203,  1204,    -1,  1206,    -1,    -1,  1209,
    1210,  1211,  2762,  1213,  1214,  1215,  1216,    -1,  1218,  1219,
    1220,  1221,    -1,    -1,    -1,    -1,    -1,  1227,  1228,    -1,
    1230,  1231,  1232,  1233,  1234,    -1,    -1,    -1,    -1,  1239,
      -1,  1241,  1242,  1243,  1244,  1245,    -1,    -1,  1248,  1249,
    1250,  1251,  1252,  1253,    -1,  1255,  1256,    -1,    -1,  1259,
    1260,  1261,    -1,  1263,    -1,  1265,    -1,    -1,    -1,  1269,
      -1,  1271,  1272,    -1,    -1,    -1,    -1,  1277,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1285,  1286,  1287,    -1,    -1,
      -1,    -1,    -1,    -1,  1294,    -1,    -1,  1297,    -1,    -1,
      -1,    -1,    -1,    -1,  1304,  1305,  1306,    -1,    -1,    -1,
      -1,    -1,  2862,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2885,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2941,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1405,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2963,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2983,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3008,    -1,
    3010,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3021,    -1,  3023,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3072,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3100,    -1,    -1,    -1,  1554,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3120,    -1,    -1,    -1,    -1,    -1,  3126,  3127,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3198,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3209,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1729,
    1730,  1731,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1746,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1772,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3336,  3337,    -1,    -1,
      -1,    -1,    -1,    -1,  1794,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3356,    -1,  3358,    -1,
    3360,  3361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3406,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3445,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3464,    -1,    -1,    -1,    -1,  3469,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3487,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3498,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3563,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2044,    -1,    -1,  2047,    -1,    -1,
    2050,  2051,    -1,  3603,    -1,  3605,    -1,    -1,    -1,    -1,
      -1,  3611,    -1,  2063,    -1,    -1,  2066,    -1,    -1,    -1,
    3620,    -1,    -1,    -1,  3624,    -1,    -1,    -1,    -1,  2079,
      -1,  2081,    -1,    -1,    -1,  2085,    -1,  2087,  2088,    -1,
    3640,    -1,  2092,    -1,  2094,  2095,  3646,  2097,    -1,    -1,
    2100,    -1,  2102,  2103,    -1,    -1,    -1,    -1,  2108,  2109,
      -1,    -1,  2112,    -1,  2114,    -1,  2116,    -1,  2118,    -1,
    2120,  3671,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2131,  2132,    -1,    -1,  2135,    -1,  2137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2145,  2146,    -1,  2148,    -1,
    2150,    -1,    -1,  2153,  2154,  2155,    -1,  2157,    -1,    -1,
      -1,    -1,  2162,  2163,  2164,  2165,    -1,    -1,    -1,    -1,
    2170,  2171,  2172,    -1,  2174,    -1,  2176,    -1,  2178,    -1,
    2180,    -1,  2182,    -1,    -1,    -1,    -1,    -1,    -1,  2189,
      -1,  2191,    -1,    -1,  2194,  2195,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2205,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2240,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2289,
      -1,    -1,    -1,    -1,  2294,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2337,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2453,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2526,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2536,    -1,  2538,    -1,
    2540,    -1,    -1,    -1,    -1,    -1,  2546,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2569,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2637,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2785,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2795,    -1,    -1,    -1,    -1,
      -1,  2801,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2810,  2811,    -1,    -1,    -1,    -1,  2816,    -1,    -1,    -1,
    2820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2833,    -1,    -1,    -1,    -1,    -1,  2839,
      -1,    -1,  2842,  2843,    -1,  2845,  2846,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2859,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2926,  2927,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2937,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3095,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3218,    -1,
      -1,    -1,    -1,    -1,  3224,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3259,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3269,
      -1,  3271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3395,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3418,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3503,  3504,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3522,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3532,    -1,    -1,    -1,    -1,  3537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3546,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3577,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,  3587,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    42,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,  3647,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
     239,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,   337,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,   420,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,   561,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,   171,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,   171,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,   171,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
      -1,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,    -1,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,   246,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,   420,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,   213,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,   232,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,   439,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,   420,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
     561,    -1,    23,    24,    25,    26,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
     561,    17,    -1,    -1,    20,   566,   567,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,   222,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,   554,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   560,    -1,    17,    -1,    -1,    20,
      -1,   567,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   566,   567,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,   567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
     566,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,   566,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,   566,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,    -1,   548,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,   562,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     554,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,   132,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,   546,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,   532,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,   546,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,   532,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,   162,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,   261,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
     325,   326,    -1,   328,    -1,    -1,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,   441,   442,   443,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,   497,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,   142,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,   427,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    32,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    88,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    34,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    18,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,   150,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,   171,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,   364,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    -1,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    -1,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,    -1,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,    -1,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   602,   764,   782,   785,   793,   795,   797,   800,
     805,   807,   812,   815,   820,   824,   832,   833,   970,   972,
     978,   981,  1006,  1014,  1025,  1027,  1041,  1044,  1047,  1053,
    1057,  1061,  1064,  1065,  1111,  1128,  1134,  1136,  1143,  1145,
    1170,  1176,  1177,  1178,  1179,  1225,    11,    91,   175,   210,
     366,   778,  1200,  1201,   252,   329,   814,   470,   472,  1130,
    1171,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   596,  1101,  1105,  1109,  1110,   281,  1130,
    1130,   536,  1172,    91,   174,   439,   473,   504,   514,   594,
     682,   683,   684,   756,  1015,   971,    91,   175,   213,   366,
     473,   488,   514,   529,   977,  1105,   814,   595,   567,  1099,
    1100,  1105,   584,   979,  1062,    93,   213,   472,  1130,   814,
    1105,  1058,   416,   514,  1130,   814,   982,  1054,  1130,   595,
    1172,  1105,   835,   837,   838,   342,  1113,  1028,   454,   458,
     435,   487,   435,   472,  1026,  1135,  1007,  1105,    28,    69,
     138,   362,   382,   407,   454,  1227,   420,   560,   834,     0,
       3,   362,   153,  1045,  1099,  1105,   142,   770,  1105,   596,
     596,   472,   109,  1195,  1196,  1197,  1130,   796,  1172,   821,
     822,  1099,   603,   567,   485,   798,   808,    16,  1173,   209,
     685,   595,   347,  1192,  1196,  1197,  1198,  1199,  1200,   472,
     683,   213,   210,   264,   372,  1023,  1024,   887,   888,   209,
     976,   976,  1105,   976,   976,   595,   976,  1130,   579,  1048,
      12,    13,    84,   112,   126,   148,   159,   188,   213,   219,
     256,   367,   384,   390,   396,   420,   431,   432,   467,   511,
     513,  1146,  1148,  1150,  1151,  1105,   340,    60,   380,   567,
     245,   476,  1102,  1105,  1107,   110,   200,   264,   984,    76,
     371,  1063,  1066,   222,  1099,  1129,  1130,   171,    32,   281,
    1033,  1059,  1105,   595,   816,  1130,   110,   264,   985,  1013,
     281,   371,   435,  1055,  1056,   794,    12,  1144,  1148,   485,
    1173,   836,    12,   122,   200,   444,   445,   446,   447,   448,
     449,   460,   842,   843,   844,  1112,    30,    33,    54,    55,
      64,    66,    83,    84,    92,   140,   144,   173,   175,   187,
     189,   212,   213,   216,   231,   252,   257,   281,   313,   322,
     340,   365,   366,   425,   435,   459,   472,   530,   729,   755,
    1029,  1033,  1034,  1036,  1119,   787,   788,   787,   787,   535,
     786,   787,   975,  1099,  1130,  1013,    34,   199,   476,  1087,
    1103,  1226,  1226,  1226,  1226,  1226,   837,   834,   561,  1105,
    1043,  1042,   294,   474,   499,   766,   768,   767,  1099,   142,
     450,  1202,   806,   974,   975,   225,   562,   828,   829,   560,
     604,  1105,   586,   974,   974,    51,   328,   328,   389,  1174,
     325,   326,   859,  1105,    88,  1107,  1108,  1161,  1162,   395,
      10,   366,   488,   848,  1194,  1202,  1203,  1211,  1213,  1214,
    1220,   848,  1193,  1203,  1211,  1214,  1220,  1195,  1200,   685,
    1105,   171,  1016,  1020,  1021,  1105,  1023,     7,    20,    22,
      25,    29,    32,    34,    35,    36,    38,    50,    54,    55,
      61,    64,    72,    73,    79,    81,    82,    83,    87,    88,
      90,    91,    95,    96,    97,   102,   104,   107,   108,   115,
     116,   133,   136,   137,   149,   152,   154,   155,   158,   162,
     167,   172,   176,   177,   178,   179,   181,   182,   184,   185,
     186,   190,   192,   193,   199,   205,   209,   219,   221,   236,
     240,   243,   248,   250,   253,   258,   261,   266,   273,   283,
     287,   295,   299,   301,   302,   306,   307,   308,   309,   310,
     311,   312,   318,   325,   326,   327,   330,   331,   336,   353,
     354,   356,   357,   358,   359,   360,   370,   378,   394,   395,
     406,   409,   412,   414,   418,   456,   457,   462,   464,   465,
     466,   469,   476,   478,   479,   480,   481,   490,   491,   492,
     497,   500,   505,   506,   514,   518,   519,   520,   521,   522,
     527,   531,   541,   543,   548,   552,   553,   558,   560,   563,
     564,   566,   567,   853,   854,   855,   856,   860,   863,   864,
     866,   873,   877,   889,  1086,  1088,  1090,  1091,  1095,  1097,
    1101,  1105,   149,  1105,  1105,   337,   596,   596,  1108,  1160,
     974,   976,   517,   580,   117,   201,   257,   281,   365,   371,
     399,   435,   455,   470,  1049,  1050,  1130,   365,  1149,   410,
     410,   473,   514,   529,   342,  1153,   470,  1155,    59,   435,
    1152,    92,   529,  1154,   337,   562,    18,   142,   930,   931,
    1137,  1105,   778,   853,    74,   171,   264,  1067,  1073,    46,
     171,  1099,  1131,  1132,   813,   566,   577,  1102,   257,   817,
    1108,   818,   819,  1099,   801,   222,   975,   986,   987,    46,
     562,   974,  1149,   337,   416,  1175,  1174,   503,  1180,  1181,
     554,   846,   847,   848,   844,  1114,  1115,  1116,   257,   147,
     426,   246,   533,  1040,   493,   560,    91,   175,   366,   472,
     529,  1040,   692,  1107,   247,   949,   951,    62,   455,   168,
     455,   455,   455,   281,   470,    62,   455,   201,   455,   455,
     493,   949,  1040,   171,   225,  1037,   257,   139,    65,   368,
     470,   489,   455,   526,   784,   388,   451,   789,   790,   783,
      77,   778,   562,   339,  1229,   468,  1230,   230,   402,  1228,
     561,  1181,  1183,  1184,  1185,   832,  1046,  1087,  1105,   108,
     680,   681,   690,   691,   738,   597,   597,   765,  1108,   419,
     529,   974,   485,   562,   108,   823,  1105,   822,   213,   232,
     753,   754,   830,   605,   606,   853,   267,   268,   269,   270,
     271,   272,   275,   276,   277,   278,   279,   280,   282,   386,
     387,   587,   588,   589,   153,   372,   799,    53,   153,   156,
     168,   293,   372,   809,   810,   811,    51,   389,   149,   593,
     560,   852,   566,   207,   562,   848,   848,   848,   175,   529,
     175,  1203,  1099,   494,   517,   757,  1020,  1099,  1105,   562,
    1018,   567,  1022,   560,   560,   560,   560,   560,   864,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   852,   852,   560,   852,   560,   560,   560,
     500,   560,  1086,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   853,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   890,   891,   892,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   853,   560,
     852,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   852,   560,  1086,   560,   560,   560,
    1086,   560,   560,    34,   199,   476,   560,   560,   560,   852,
     852,   852,   560,   560,   560,   560,   560,   560,   853,   894,
     864,   864,   864,   420,   560,   853,  1189,  1105,   878,  1105,
      15,    16,   344,   347,   540,   857,   858,   142,   143,   180,
     194,   226,   238,   265,   321,   861,   123,   225,   246,   306,
     385,   429,   430,   438,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   859,   864,    98,    99,   100,   101,   102,
     170,   202,   203,   204,   205,   295,   297,   298,   299,   307,
     370,   417,   418,   531,   542,   543,   927,   928,    63,   346,
     562,  1103,   560,   567,   567,  1099,   562,    48,   401,   779,
     974,   566,   581,   582,    46,   535,   562,  1051,   470,   560,
    1163,  1163,  1163,  1163,   175,   366,   472,  1147,  1151,  1105,
     160,   323,  1105,  1138,  1139,   986,   281,   252,  1072,   825,
     281,   931,   562,   974,  1107,    27,   485,  1060,   562,   485,
     562,   485,   974,   987,   983,  1056,   171,   562,   175,   366,
    1147,  1105,    12,   122,  1187,   562,   839,   850,   853,  1093,
    1105,   562,   187,   252,   338,   425,  1117,  1118,  1121,  1122,
     225,  1038,  1102,   853,   554,   685,   596,   596,  1099,  1099,
    1030,   261,   331,   497,   952,   953,  1088,   596,  1040,  1108,
     168,  1035,  1037,   596,  1040,  1035,  1099,  1037,  1035,  1035,
    1040,  1040,   510,   791,   562,   791,   437,   420,   560,   564,
     897,   898,   899,   900,   909,   910,   918,  1087,   355,  1231,
     345,   945,   951,  1186,   681,    63,   729,    67,    79,   235,
     304,   328,   379,   450,   599,   601,     6,    13,    23,    24,
      52,    56,    67,    76,    81,    93,   111,   120,   121,   126,
     134,   140,   165,   211,   213,   220,   286,   300,   305,   345,
     351,   353,   374,   375,   377,   391,   413,   494,   503,   687,
     689,   690,   691,   771,   772,   773,   941,   109,   224,  1099,
    1102,   975,   560,   561,   562,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     562,   512,   810,   679,   680,   561,  1107,    44,  1162,   175,
     596,   596,   596,  1105,  1099,   591,    43,   196,   415,   758,
     758,   337,  1019,  1017,   567,  1021,   171,   554,  1105,   931,
     853,   853,   853,    12,   122,   883,   932,   104,   162,   199,
     261,   331,   497,   955,   883,   883,   883,   853,   853,   887,
     887,   853,   887,   853,   853,   853,   853,   122,   883,   932,
     853,   561,   853,   853,   853,   853,   853,  1095,  1105,   853,
     853,   853,   853,   853,   560,  1189,   853,   927,   853,   853,
     853,   561,   853,   853,   853,   853,   887,   853,   853,    94,
      97,   478,   481,   929,   853,   122,   880,  1086,   853,   853,
     853,   561,   853,   853,   853,   853,   887,   853,   853,   853,
     853,   891,     9,   893,  1095,   122,   883,   853,   853,   122,
     883,   853,   853,   853,   853,   853,   887,   887,   887,   853,
     853,   853,   853,   853,   853,   887,   856,   853,   561,   853,
     853,   853,   853,   853,   561,   853,   853,   883,   883,   853,
     853,   853,   122,   883,   853,   853,   928,   928,   853,    42,
     239,   486,   853,   853,  1086,   561,   853,   561,   883,  1096,
    1097,  1105,   883,   853,   853,   853,   532,   896,  1190,  1190,
     561,   562,   561,   853,   566,   879,  1107,   567,   853,   853,
     853,   855,   155,   330,   491,   507,   859,    12,    17,   855,
     862,   856,   560,   864,   856,   856,   856,   856,   246,   856,
     856,   856,   856,   863,   856,   863,   856,   856,   856,   856,
     225,   246,   385,   549,   553,  1107,   864,   853,   865,  1105,
    1105,   973,  1108,   779,  1107,   562,   380,  1050,   974,  1052,
    1105,  1164,  1165,   554,  1099,  1105,  1159,  1159,  1159,   142,
     160,   180,   194,   237,   238,   265,   323,   363,  1140,  1142,
     533,   933,   980,   214,   826,   827,  1099,   264,   380,   537,
    1133,  1132,   853,  1102,  1108,  1108,   819,  1099,   153,   372,
     515,   802,   803,   804,   420,   426,   522,   523,   560,   675,
     988,   991,  1102,   188,  1159,  1159,  1159,  1182,   847,   171,
     222,   840,   841,   944,   945,   966,   849,   567,  1115,   108,
     487,  1105,  1124,   314,   353,   566,   729,  1123,  1102,   171,
    1039,   561,  1105,   257,   455,  1032,   334,   562,   435,  1040,
    1105,  1040,  1035,  1099,  1040,  1040,   589,   792,   790,   917,
    1105,    85,   215,   230,   243,   317,   406,   460,   908,   426,
     562,  1099,   917,   562,   168,  1232,    44,   949,   142,   427,
     997,   998,   998,  1102,   450,   450,   450,   450,   450,   419,
      66,    78,   174,   439,   701,   704,   705,   751,   753,   777,
     777,   998,   998,   777,   998,   998,   998,   485,   119,   998,
     231,   471,   166,   364,   753,   777,   231,   998,   471,   119,
     998,   998,   998,   777,    44,   998,   998,   998,   998,   998,
      18,   142,   485,   781,   998,   998,   998,   687,   562,   560,
     567,   700,   706,  1098,  1105,   769,   364,   925,  1105,   853,
     955,  1102,  1102,   104,   162,   261,   331,   497,   956,  1102,
     955,  1102,  1102,  1102,  1102,  1102,   955,  1102,  1102,   955,
     588,   353,   476,  1105,  1221,     8,    27,   667,   560,   403,
    1204,   246,   560,   669,   686,   688,   689,  1099,   517,   933,
    1105,   898,   567,  1022,   562,   561,   561,   562,   883,   561,
     884,   562,   561,   561,   561,    18,   561,   517,   561,   561,
     561,   561,   562,   562,   517,   562,   562,   874,   561,   554,
     561,   562,   562,   561,   561,   562,   561,   567,   561,   562,
     561,   562,   562,   562,   561,   562,   561,   562,   171,   562,
     562,   561,   562,   561,   562,   562,   561,   562,   561,   561,
     562,   561,   562,   562,   562,   876,   562,   561,   562,   562,
     561,   562,   562,   561,   562,   561,   562,   561,   562,   562,
     562,   561,   560,   562,   883,   561,   561,   561,   883,   561,
     561,   562,   562,   561,   561,   562,   561,   562,   561,   561,
     561,   561,   561,   561,   561,   562,   562,   561,   562,   561,
     225,   561,   561,   562,   562,   562,   561,   562,   562,   561,
     561,   561,   562,   171,   562,   562,   883,   561,   561,   561,
     562,   562,   562,   561,   171,   853,   171,   853,   171,   853,
     171,   561,   562,   562,   561,   561,   561,   561,   561,   562,
     561,   562,   561,   853,   532,   546,   895,   835,   834,   887,
     565,   187,   252,   425,  1120,   427,  1105,   155,   330,   491,
     507,   560,   853,  1189,   146,   937,   856,    16,   927,   927,
     560,   864,   856,   856,   853,   868,   869,   870,   560,   567,
     582,   256,   561,   562,   567,   567,   485,   485,   485,  1141,
     934,   950,   951,   988,   476,  1104,   562,   828,   537,   252,
     485,   803,   676,   989,   560,   994,   999,   994,   561,   675,
     990,  1092,  1093,  1096,  1105,   992,   342,   171,   171,   171,
     833,   127,   898,   967,   168,   256,   845,   966,   950,   841,
      18,   851,  1102,  1105,   554,  1105,   567,   227,   567,   997,
      32,   108,   730,   731,   997,  1107,   168,   997,   566,  1107,
      32,   108,   733,   734,  1107,   956,  1031,   144,   530,   953,
     953,   535,   933,  1035,   562,   912,   917,   897,   230,   230,
     348,   919,   230,   243,   406,   919,   909,   897,  1009,  1010,
    1096,   897,   931,   914,   915,   955,   296,   946,   108,   735,
     737,  1107,   731,    93,    93,   109,   224,   761,  1098,   754,
     754,    57,   166,   364,   504,   703,   752,   702,   703,   761,
    1098,   956,   955,  1098,   955,  1102,  1102,   729,   998,   955,
     232,   232,  1098,  1098,   692,   998,   160,   237,   328,   695,
     956,   956,  1098,   942,   943,  1096,   108,   955,  1102,   955,
     955,   373,   376,   694,   955,  1099,    70,    71,   108,   130,
     161,   383,   693,   692,   560,   773,   698,   699,   700,   701,
    1105,     8,   160,   780,   384,   702,   743,   707,   567,   560,
    1205,   561,   562,   476,   403,   560,   112,   219,   511,   668,
    1215,   105,   223,   381,   461,   697,  1205,  1099,   246,   670,
     675,   698,   210,   395,   672,  1074,   562,   688,   592,   898,
     944,   933,   931,   221,   853,   853,   561,   853,   853,    32,
      55,    94,    97,   105,   319,   433,   481,   509,   885,   730,
     887,   853,   730,   885,   853,   887,   561,   863,   863,  1103,
    1105,   853,   853,   887,  1103,   853,   853,   853,   887,   331,
     853,   853,   853,   853,   853,   853,   853,   887,   887,   331,
     853,   853,   887,   853,   853,   853,   853,   887,   853,   856,
    1095,   561,   561,   853,   853,   853,   853,   853,   853,   853,
     853,   853,   853,   853,   853,   887,   221,   853,   853,   853,
     853,   561,   853,   853,   853,   853,   171,   853,   171,   853,
     171,   853,   853,   331,   853,   853,   547,   853,   853,   138,
    1188,  1188,   561,   567,   567,   567,  1107,   853,  1189,   561,
     562,   561,   864,   855,   853,  1189,   937,    16,   561,   848,
     871,   872,   886,   887,  1105,  1165,   554,   554,  1161,  1161,
    1161,   560,   853,   337,  1004,  1068,   827,   210,   831,  1108,
     842,   995,   996,  1096,  1000,   562,   560,   991,   561,   561,
     562,   567,  1180,   171,  1161,  1161,  1161,   933,   933,   128,
     349,   962,   963,   968,   511,   225,  1102,  1105,   567,  1105,
     244,  1105,    12,    32,   108,   337,   853,  1127,    63,   736,
     853,  1108,   336,   353,   476,  1126,  1120,   997,   949,   269,
    1040,   589,  1183,   913,   243,   230,   909,   919,   919,   230,
     337,   337,   517,   562,  1008,   997,   165,   210,   516,   921,
     842,   853,   947,  1094,   853,   232,   232,   754,   761,   757,
     126,   426,   774,   731,  1102,   761,   779,  1102,   775,   562,
      19,   113,   948,   974,   561,   562,  1105,  1099,    31,    32,
      37,    39,    40,    41,    55,    94,    97,   105,   124,   141,
     161,   163,   182,   183,   223,   250,   259,   260,   262,   290,
     291,   292,   310,   311,   312,   316,   319,   332,   333,   357,
     359,   381,   424,   426,   436,   477,   478,   481,   482,   483,
     484,   524,   525,   543,   708,   711,   712,   713,   714,   715,
     716,   717,  1105,  1105,  1206,    18,  1105,   697,  1222,   337,
     607,   608,   610,  1105,   496,    18,  1099,   561,   561,    18,
     678,   688,   560,   933,   247,   954,   853,   561,   561,   561,
     560,   723,   723,   560,   718,   719,   723,   223,   223,   561,
     561,   561,   561,   561,   561,   562,   875,   927,   927,   561,
     561,   561,   561,   561,   561,   562,   561,   561,   561,   561,
     561,   562,   561,   561,   561,   561,   561,   882,   945,   562,
     562,   562,   561,   561,   561,   561,   562,   561,   561,   561,
     562,   225,   535,   867,   561,   561,   561,   561,   561,   561,
     561,   561,   561,   562,   561,   561,   561,   853,   561,   168,
     561,   561,   562,   562,   561,   562,   562,   561,   853,   561,
     853,   561,   853,   561,   561,   562,   561,   561,   853,   547,
    1191,  1191,   567,   762,   561,   887,   561,   562,   561,   855,
     853,   562,   561,   397,  1166,  1166,  1166,   108,   853,  1002,
    1003,   129,  1074,   241,   846,   562,   997,  1001,  1002,   999,
     993,   991,  1092,  1105,  1161,   950,   191,   938,  1104,  1104,
     566,   964,   965,  1107,   428,   554,   380,   393,   423,  1125,
     737,   997,   560,   560,  1124,   853,   142,   561,   899,   348,
     897,   909,   230,   230,   897,   909,   902,   901,   903,  1010,
     933,  1003,   753,   922,   922,   922,   846,   562,   948,   761,
     757,   560,   108,   108,   706,   736,   708,   943,   561,   699,
     744,   560,   560,   723,   718,   361,   709,   718,   718,    20,
      32,    45,   502,   729,   739,    55,   524,   712,   714,   739,
     739,    55,   525,   525,   528,   718,   710,   723,   723,   739,
     560,   723,    23,    63,    67,   108,   330,   337,   364,   424,
     504,   725,   726,   727,   742,   859,   528,   560,   739,    32,
     560,   740,   560,   560,   723,   560,   719,   724,   567,   561,
     562,  1207,  1208,   496,   217,   225,   350,   611,   612,   613,
     614,   848,   561,   562,   609,  1102,  1207,   561,   671,   686,
     560,   675,   759,   760,  1105,   953,   927,   331,   739,   331,
     853,   561,   561,   561,   853,   853,   422,   881,   331,   853,
     853,   853,   853,    40,   371,   561,   853,   927,   853,   853,
     853,   853,   853,   561,   561,   561,   331,   853,   561,  1105,
     561,   887,   849,   872,    58,   228,   324,   452,   463,   538,
    1157,  1158,   535,  1167,  1167,  1167,   561,   562,  1005,   222,
     677,   996,  1003,   561,  1183,    44,   197,   935,   969,  1107,
     562,   303,    68,   498,   380,  1126,   476,   476,   997,  1102,
     931,   230,   337,   905,   909,   909,   337,   907,   853,   853,
     560,   944,   168,   920,   916,  1094,   560,   560,   759,    97,
     478,   481,   552,   553,  1089,  1090,   780,   725,   283,   337,
     560,   745,   747,   748,   749,   331,   331,   433,   509,   544,
     720,   721,   722,   560,   720,   720,   740,    20,   502,   729,
     741,   740,   730,   739,   528,   720,   560,   739,   331,   720,
     735,  1102,   327,   728,  1089,   511,   108,   232,   727,   232,
     330,   331,   331,   331,   331,   720,   331,   720,  1105,  1105,
     535,  1210,   420,   560,  1209,  1102,   561,   562,   609,  1099,
    1216,   610,   708,  1210,  1183,   672,   675,   673,   561,   562,
     948,   560,   561,   561,   561,   562,   561,   561,   562,   561,
    1087,   561,   562,   561,   562,   561,   561,   303,   151,   561,
     561,   561,   561,   561,   561,   561,   562,   561,   851,   476,
     476,   476,    16,  1156,   188,   284,   285,   288,   289,  1168,
    1169,  1003,   232,  1069,   696,   841,   950,   939,  1094,   936,
     944,    65,  1075,   965,   561,   561,  1127,    16,   897,   904,
     517,   906,   517,   926,  1105,   954,   230,   923,   696,   948,
     759,   759,   561,  1091,  1091,   776,   173,   352,   434,   112,
     511,   746,  1105,   749,   561,   561,   722,   763,  1087,   730,
     740,   763,   561,   852,   327,   523,   561,   561,   561,   561,
      49,    57,   252,   848,   848,  1223,   613,  1105,   168,   403,
     561,  1180,   760,   331,   331,   853,   883,   853,   887,  1157,
     342,   955,   955,   955,   955,  1169,   511,   472,   845,   535,
     562,   940,   948,   853,   950,   135,   145,   343,   475,  1076,
    1077,   249,  1078,   270,   337,   853,   560,   853,   560,   561,
     562,   560,   561,   561,   780,    48,   328,   401,   426,   750,
     750,   561,   562,   561,   562,   561,   852,   739,   740,   739,
     740,    57,   342,    57,   835,   834,   598,   708,   848,  1217,
     674,   948,   561,   561,   561,   562,   561,   561,   561,  1011,
    1012,  1096,  1099,    86,   408,  1094,   366,   957,    44,    44,
     135,    44,  1077,   453,   475,  1079,  1080,   142,   911,   926,
     926,  1105,   924,   925,   743,     5,   108,   330,   747,  1105,
     739,  1087,   739,   342,   342,   561,   118,   599,   600,   859,
    1224,   131,   708,  1183,   853,   562,   997,  1070,   948,  1105,
    1087,  1087,    44,  1087,    44,    44,  1080,   956,   853,   561,
     561,   561,  1183,   118,    60,   157,   209,   229,   242,   340,
     404,   548,   631,   632,   635,   644,   645,   648,   659,  1101,
    1106,  1110,   414,  1218,   561,  1012,  1003,   729,   732,   958,
    1087,  1087,  1087,    16,   565,  1105,   171,   323,   637,   634,
    1106,  1106,  1105,   633,   646,   649,   573,    28,   263,   394,
     534,   662,   569,  1212,   598,   731,  1071,   560,   274,   171,
    1105,   639,   640,   853,   853,   532,   651,   655,   663,   616,
     631,   616,   664,   660,   631,  1219,  1075,   848,   959,   960,
     961,   142,   222,   138,   853,   647,   656,   546,   655,   658,
     617,   138,   631,   568,   510,   853,   662,   631,  1078,   853,
     561,   562,   955,   636,   209,   547,   532,   650,   652,   853,
     616,   138,   106,   615,   618,   263,   568,   666,   125,   661,
    1106,   210,  1081,   961,   638,  1105,   641,   653,   652,   658,
     657,   548,    80,   150,   623,   629,  1105,   138,   631,   568,
     853,   665,   331,   560,  1082,   562,   616,   853,   138,   547,
     195,   562,   619,    75,    89,   568,   138,   616,   249,   561,
     566,  1083,  1084,  1096,   426,  1085,  1105,   642,   654,   548,
     616,   168,  1105,   708,   168,   168,   394,   138,  1107,   561,
     562,  1011,   132,   546,   643,   547,   620,   108,   630,   442,
     626,   955,   621,   622,   534,  1084,   639,   616,   616,   441,
     443,   624,   625,   626,   628,   859,  1105,   853,   523,   627,
     573,   562,   631,   169,  1103,   625
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1205 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1218 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1278 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1293 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1302 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1309 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1318 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1325 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1339 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1351 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1359 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1369 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1375 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1384 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1389 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1394 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1399 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1404 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1408 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1413 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1417 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1421 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1425 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1429 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1438 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1442 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1458 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1462 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1473 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1490 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1492 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1504 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1512 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1517 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1524 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1530 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1532 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1539 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1554 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1569 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1587 "sql_yacc.yy"
    {}
    break;

  case 101:
#line 1588 "sql_yacc.yy"
    {}
    break;

  case 102:
#line 1592 "sql_yacc.yy"
    {}
    break;

  case 103:
#line 1593 "sql_yacc.yy"
    {}
    break;

  case 104:
#line 1599 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 105:
#line 1601 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 106:
#line 1603 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 107:
#line 1605 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 108:
#line 1607 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 109:
#line 1609 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 110:
#line 1611 "sql_yacc.yy"
    { }
    break;

  case 111:
#line 1616 "sql_yacc.yy"
    { }
    break;

  case 112:
#line 1617 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 113:
#line 1618 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 114:
#line 1623 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 115:
#line 1627 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 116:
#line 1634 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 117:
#line 1642 "sql_yacc.yy"
    {}
    break;

  case 122:
#line 1658 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 123:
#line 1662 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 128:
#line 1680 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 129:
#line 1700 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 134:
#line 1737 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 135:
#line 1762 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 136:
#line 1763 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 137:
#line 1764 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 138:
#line 1765 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 139:
#line 1769 "sql_yacc.yy"
    {}
    break;

  case 141:
#line 1774 "sql_yacc.yy"
    {}
    break;

  case 143:
#line 1780 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 144:
#line 1784 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 145:
#line 1810 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 146:
#line 1819 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 147:
#line 1871 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 148:
#line 1885 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 149:
#line 1900 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL )
                MYSQL_YYABORT;
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    lex->spcont->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 150:
#line 1932 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    if ( i==NULL )
              MYSQL_YYABORT;
            sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 151:
#line 1957 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 152:
#line 1967 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 153:
#line 1989 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 154:
#line 1990 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 155:
#line 1996 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 156:
#line 1998 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 157:
#line 2003 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	    }
	  }
    break;

  case 158:
#line 2026 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 159:
#line 2032 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 160:
#line 2046 "sql_yacc.yy"
    {}
    break;

  case 161:
#line 2047 "sql_yacc.yy"
    {}
    break;

  case 162:
#line 2052 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 163:
#line 2056 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 164:
#line 2065 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 165:
#line 2070 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 166:
#line 2075 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 167:
#line 2083 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 168:
#line 2098 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 169:
#line 2115 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 170:
#line 2116 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 171:
#line 2120 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 172:
#line 2130 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 173:
#line 2172 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 174:
#line 2177 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 175:
#line 2200 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 176:
#line 2202 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 178:
#line 2205 "sql_yacc.yy"
    {}
    break;

  case 179:
#line 2206 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 180:
#line 2212 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 181:
#line 2218 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */

	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 182:
#line 2258 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL)
                MYSQL_YYABORT;
              sp->add_instr(i);
	    }
	  }
    break;

  case 183:
#line 2294 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 184:
#line 2311 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 185:
#line 2328 "sql_yacc.yy"
    { }
    break;

  case 186:
#line 2330 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2356 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 191:
#line 2377 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 192:
#line 2399 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 193:
#line 2404 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 194:
#line 2419 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 195:
#line 2431 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 201:
#line 2451 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 202:
#line 2458 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 203:
#line 2469 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 204:
#line 2477 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 205:
#line 2485 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 210:
#line 2503 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 211:
#line 2508 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 212:
#line 2517 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 213:
#line 2525 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 214:
#line 2530 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 215:
#line 2537 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 216:
#line 2545 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
          }
    break;

  case 218:
#line 2560 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 219:
#line 2578 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 220:
#line 2597 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 221:
#line 2598 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 222:
#line 2603 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 223:
#line 2615 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     (yyvsp[-2].spblock).hndlrs);
              if (hpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(hpop);
            }
	    if ((yyvsp[-2].spblock).curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     (yyvsp[-2].spblock).curs);
              if (cpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(cpop);
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 224:
#line 2641 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
	  }
    break;

  case 225:
#line 2651 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 226:
#line 2656 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 227:
#line 2671 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 228:
#line 2682 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 229:
#line 2687 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            if (i == NULL)
              MYSQL_YYABORT;
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 230:
#line 2705 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 231:
#line 2707 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 232:
#line 2712 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 233:
#line 2714 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 234:
#line 2716 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 235:
#line 2720 "sql_yacc.yy"
    {}
    break;

  case 236:
#line 2721 "sql_yacc.yy"
    {}
    break;

  case 237:
#line 2723 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[0].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 238:
#line 2729 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[-1].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 239:
#line 2737 "sql_yacc.yy"
    {}
    break;

  case 240:
#line 2738 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 241:
#line 2738 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2742 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2744 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 244:
#line 2744 "sql_yacc.yy"
    {}
    break;

  case 245:
#line 2746 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 246:
#line 2746 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2751 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 248:
#line 2767 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 249:
#line 2771 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 250:
#line 2781 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2782 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2785 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2786 "sql_yacc.yy"
    {}
    break;

  case 254:
#line 2789 "sql_yacc.yy"
    {}
    break;

  case 255:
#line 2790 "sql_yacc.yy"
    {}
    break;

  case 256:
#line 2793 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2794 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2797 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 259:
#line 2798 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 260:
#line 2801 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 261:
#line 2802 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 262:
#line 2805 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 263:
#line 2808 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 264:
#line 2809 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 272:
#line 2825 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 273:
#line 2826 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 274:
#line 2827 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 275:
#line 2828 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 276:
#line 2829 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 277:
#line 2830 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 278:
#line 2831 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 279:
#line 2832 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 280:
#line 2834 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 281:
#line 2849 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 282:
#line 2854 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 283:
#line 2855 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 284:
#line 2856 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 285:
#line 2858 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 286:
#line 2863 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 287:
#line 2868 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 288:
#line 2873 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 291:
#line 2889 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 292:
#line 2890 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 293:
#line 2891 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 294:
#line 2892 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 295:
#line 2897 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 296:
#line 2914 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 297:
#line 2930 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 298:
#line 2939 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 299:
#line 2940 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 300:
#line 2941 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 301:
#line 2942 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 302:
#line 2943 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 303:
#line 2944 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 304:
#line 2947 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 305:
#line 2948 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 306:
#line 2949 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 307:
#line 2952 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 308:
#line 2953 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 309:
#line 2954 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 310:
#line 2957 "sql_yacc.yy"
    {}
    break;

  case 312:
#line 2961 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 313:
#line 2962 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 314:
#line 2963 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 315:
#line 2964 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 321:
#line 2979 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 322:
#line 2986 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 323:
#line 2994 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 324:
#line 3002 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 325:
#line 3019 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 326:
#line 3023 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 3038 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 331:
#line 3039 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 332:
#line 3043 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 333:
#line 3048 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 334:
#line 3056 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 335:
#line 3069 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 336:
#line 3070 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 337:
#line 3071 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 338:
#line 3072 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 339:
#line 3074 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 340:
#line 3076 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 341:
#line 3078 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 342:
#line 3080 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 343:
#line 3082 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 344:
#line 3084 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 345:
#line 3087 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 346:
#line 3090 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 347:
#line 3093 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 348:
#line 3096 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 349:
#line 3098 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 350:
#line 3101 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 351:
#line 3104 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 352:
#line 3105 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 353:
#line 3106 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 354:
#line 3108 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 355:
#line 3120 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 356:
#line 3121 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 357:
#line 3123 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 358:
#line 3126 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 359:
#line 3137 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 360:
#line 3139 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 361:
#line 3141 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 362:
#line 3143 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 363:
#line 3144 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 364:
#line 3145 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 365:
#line 3146 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 366:
#line 3147 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 367:
#line 3149 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 368:
#line 3151 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 369:
#line 3153 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 370:
#line 3154 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 371:
#line 3155 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 372:
#line 3156 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 373:
#line 3157 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 374:
#line 3158 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 375:
#line 3160 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 376:
#line 3168 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 377:
#line 3169 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 378:
#line 3170 "sql_yacc.yy"
    { Lex->length= (char*)"25";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 379:
#line 3173 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 380:
#line 3174 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 381:
#line 3175 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 382:
#line 3176 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 383:
#line 3177 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 384:
#line 3181 "sql_yacc.yy"
    {}
    break;

  case 385:
#line 3185 "sql_yacc.yy"
    {}
    break;

  case 386:
#line 3186 "sql_yacc.yy"
    {}
    break;

  case 387:
#line 3190 "sql_yacc.yy"
    {}
    break;

  case 388:
#line 3191 "sql_yacc.yy"
    {}
    break;

  case 389:
#line 3195 "sql_yacc.yy"
    {}
    break;

  case 390:
#line 3196 "sql_yacc.yy"
    {}
    break;

  case 391:
#line 3197 "sql_yacc.yy"
    {}
    break;

  case 392:
#line 3198 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3199 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3203 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 395:
#line 3204 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 396:
#line 3205 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 397:
#line 3206 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 398:
#line 3207 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 399:
#line 3210 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 400:
#line 3212 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 401:
#line 3213 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 402:
#line 3217 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 403:
#line 3218 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 404:
#line 3219 "sql_yacc.yy"
    {}
    break;

  case 405:
#line 3223 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 406:
#line 3229 "sql_yacc.yy"
    {}
    break;

  case 407:
#line 3230 "sql_yacc.yy"
    {}
    break;

  case 408:
#line 3233 "sql_yacc.yy"
    {}
    break;

  case 409:
#line 3234 "sql_yacc.yy"
    {}
    break;

  case 410:
#line 3237 "sql_yacc.yy"
    {}
    break;

  case 411:
#line 3238 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 412:
#line 3239 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 413:
#line 3242 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 414:
#line 3243 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 415:
#line 3246 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3247 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3250 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3251 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3254 "sql_yacc.yy"
    {}
    break;

  case 421:
#line 3258 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 422:
#line 3259 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 423:
#line 3260 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 424:
#line 3262 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 425:
#line 3263 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 426:
#line 3265 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 427:
#line 3271 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 428:
#line 3277 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 429:
#line 3283 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 430:
#line 3288 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 431:
#line 3290 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 432:
#line 3305 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 433:
#line 3306 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 434:
#line 3310 "sql_yacc.yy"
    {}
    break;

  case 435:
#line 3311 "sql_yacc.yy"
    {}
    break;

  case 436:
#line 3316 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 437:
#line 3323 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 438:
#line 3327 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 439:
#line 3328 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 440:
#line 3331 "sql_yacc.yy"
    { (yyval.charset)= NULL; }
    break;

  case 441:
#line 3332 "sql_yacc.yy"
    { (yyval.charset)= (yyvsp[0].charset); }
    break;

  case 442:
#line 3337 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 443:
#line 3345 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 444:
#line 3349 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 445:
#line 3350 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 446:
#line 3354 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 447:
#line 3363 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 448:
#line 3364 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 449:
#line 3368 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 450:
#line 3369 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 451:
#line 3372 "sql_yacc.yy"
    {}
    break;

  case 452:
#line 3373 "sql_yacc.yy"
    {}
    break;

  case 453:
#line 3376 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 454:
#line 3377 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 455:
#line 3378 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 456:
#line 3380 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 457:
#line 3388 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 458:
#line 3389 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 459:
#line 3392 "sql_yacc.yy"
    { }
    break;

  case 460:
#line 3393 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 461:
#line 3396 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 462:
#line 3397 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 463:
#line 3399 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 464:
#line 3407 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 467:
#line 3416 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 468:
#line 3422 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 469:
#line 3427 "sql_yacc.yy"
    {}
    break;

  case 470:
#line 3428 "sql_yacc.yy"
    {}
    break;

  case 471:
#line 3431 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 472:
#line 3432 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 473:
#line 3436 "sql_yacc.yy"
    {}
    break;

  case 474:
#line 3437 "sql_yacc.yy"
    {}
    break;

  case 475:
#line 3440 "sql_yacc.yy"
    {}
    break;

  case 476:
#line 3441 "sql_yacc.yy"
    {}
    break;

  case 477:
#line 3444 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 478:
#line 3445 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 479:
#line 3446 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 480:
#line 3447 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 481:
#line 3448 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 482:
#line 3451 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 483:
#line 3452 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 484:
#line 3453 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 485:
#line 3454 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 486:
#line 3455 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 487:
#line 3458 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 488:
#line 3459 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 489:
#line 3461 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 490:
#line 3472 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 491:
#line 3473 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 492:
#line 3476 "sql_yacc.yy"
    {}
    break;

  case 493:
#line 3477 "sql_yacc.yy"
    {}
    break;

  case 494:
#line 3480 "sql_yacc.yy"
    {}
    break;

  case 496:
#line 3485 "sql_yacc.yy"
    {}
    break;

  case 497:
#line 3486 "sql_yacc.yy"
    {}
    break;

  case 498:
#line 3487 "sql_yacc.yy"
    {}
    break;

  case 499:
#line 3490 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 500:
#line 3491 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 501:
#line 3492 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 502:
#line 3494 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 503:
#line 3506 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 504:
#line 3507 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 505:
#line 3508 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 506:
#line 3511 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 507:
#line 3513 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 508:
#line 3516 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 509:
#line 3519 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 510:
#line 3520 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 511:
#line 3523 "sql_yacc.yy"
    { (yyval.key_part)=new key_part_spec((yyvsp[0].lex_str).str); }
    break;

  case 512:
#line 3525 "sql_yacc.yy"
    {
          int key_part_len= atoi((yyvsp[-1].lex_str).str);
          if (!key_part_len)
          {
            my_error(ER_KEY_PART_0, MYF(0), (yyvsp[-3].lex_str).str);
          }
          (yyval.key_part)=new key_part_spec((yyvsp[-3].lex_str).str,(uint) key_part_len);
        }
    break;

  case 513:
#line 3535 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 514:
#line 3536 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].lex_str).str; }
    break;

  case 515:
#line 3539 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 516:
#line 3540 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 517:
#line 3543 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 518:
#line 3544 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 519:
#line 3552 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex= thd->lex;
	  lex->sql_command= SQLCOM_ALTER_TABLE;
	  lex->name= 0;
	  lex->duplicates= DUP_ERROR; 
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING))
	    MYSQL_YYABORT;
	  lex->col_list.empty();
          lex->select_lex.init_order();
	  lex->select_lex.db=
            ((TABLE_LIST*) lex->select_lex.table_list.first)->db;
          lex->name=0;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.db_type= DB_TYPE_DEFAULT;
	  lex->create_info.default_table_charset= NULL;
	  lex->create_info.row_type= ROW_TYPE_NOT_USED;
          lex->alter_info.reset();
	}
    break;

  case 520:
#line 3573 "sql_yacc.yy"
    {}
    break;

  case 521:
#line 3575 "sql_yacc.yy"
    {
            Lex->create_info.default_table_charset= NULL;
            Lex->create_info.used_fields= 0;
          }
    break;

  case 522:
#line 3580 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_ALTER_DB;
	    lex->name= (yyvsp[-2].simple_string);
            if (lex->name == NULL && lex->copy_db_to(&lex->name, NULL))
              MYSQL_YYABORT;
	  }
    break;

  case 523:
#line 3588 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "PROCEDURE");
	      MYSQL_YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 524:
#line 3599 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_PROCEDURE;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 525:
#line 3606 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_DROP_SP, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
          }
    break;

  case 526:
#line 3617 "sql_yacc.yy"
    {
	    LEX *lex=Lex;

	    lex->sql_command= SQLCOM_ALTER_FUNCTION;
	    lex->spname= (yyvsp[-2].spname);
	  }
    break;

  case 527:
#line 3625 "sql_yacc.yy"
    {
	    THD *thd= YYTHD;
	    LEX *lex= thd->lex;
	    if (lex->sphead)
            {
              my_error(ER_SP_BADSTATEMENT, MYF(0), "ALTER VIEW");
              MYSQL_YYABORT;
            }
	    lex->sql_command= SQLCOM_CREATE_VIEW;
	    lex->create_view_mode= VIEW_ALTER;
	    /* first table in list is target VIEW name */
	    lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL, TL_OPTION_UPDATING);
	  }
    break;

  case 528:
#line 3639 "sql_yacc.yy"
    {}
    break;

  case 529:
#line 3643 "sql_yacc.yy"
    { (yyval.simple_string)= 0; }
    break;

  case 530:
#line 3644 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].lex_str).str; }
    break;

  case 532:
#line 3647 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= DISCARD_TABLESPACE; }
    break;

  case 533:
#line 3648 "sql_yacc.yy"
    { Lex->alter_info.tablespace_op= IMPORT_TABLESPACE; }
    break;

  case 536:
#line 3654 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->change=0;
	  lex->alter_info.flags|= ALTER_ADD_COLUMN;
	}
    break;

  case 537:
#line 3661 "sql_yacc.yy"
    { }
    break;

  case 538:
#line 3663 "sql_yacc.yy"
    {
	    Lex->alter_info.flags|= ALTER_ADD_INDEX;
	