/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= thd->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 415 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1622 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 455 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1637 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43783

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  668
/* YYNRULES -- Number of rules. */
#define YYNRULES  2026
/* YYNRULES -- Number of states. */
#define YYNSTATES  3683

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   271,   274,   275,   278,   281,   284,   287,   290,   294,
     298,   300,   302,   304,   307,   311,   315,   316,   321,   322,
     326,   327,   329,   333,   335,   336,   338,   342,   344,   345,
     349,   350,   352,   356,   358,   363,   364,   366,   368,   370,
     371,   375,   378,   382,   383,   387,   388,   394,   400,   401,
     409,   415,   416,   419,   421,   423,   425,   429,   431,   433,
     437,   438,   440,   442,   444,   446,   449,   451,   453,   457,
     458,   461,   462,   465,   466,   470,   471,   477,   479,   481,
     482,   485,   487,   489,   492,   495,   498,   499,   506,   509,
     510,   513,   515,   517,   521,   522,   523,   524,   532,   533,
     536,   539,   541,   543,   544,   545,   554,   555,   562,   564,
     567,   569,   572,   573,   574,   581,   582,   583,   590,   591,
     594,   595,   601,   602,   604,   605,   611,   612,   615,   616,
     622,   627,   628,   629,   638,   639,   647,   649,   651,   653,
     655,   657,   660,   663,   666,   671,   676,   677,   682,   683,
     684,   690,   691,   699,   700,   701,   708,   709,   711,   712,
     714,   716,   719,   721,   723,   724,   726,   728,   731,   733,
     734,   738,   739,   741,   743,   746,   748,   751,   755,   759,
     763,   767,   771,   775,   779,   783,   787,   791,   795,   799,
     803,   807,   811,   815,   819,   825,   827,   829,   833,   838,
     843,   847,   852,   857,   859,   861,   863,   865,   867,   869,
     871,   873,   875,   877,   879,   881,   883,   885,   888,   890,
     892,   894,   896,   898,   902,   904,   906,   909,   912,   919,
     927,   936,   939,   942,   943,   945,   948,   949,   951,   954,
     955,   960,   964,   968,   972,   974,   979,   981,   983,   989,
     992,   998,  1001,  1006,  1008,  1014,  1020,  1025,  1029,  1031,
    1033,  1036,  1038,  1040,  1043,  1045,  1047,  1049,  1052,  1056,
    1059,  1063,  1066,  1069,  1073,  1077,  1081,  1082,  1089,  1090,
    1097,  1100,  1102,  1104,  1106,  1108,  1110,  1112,  1114,  1116,
    1118,  1120,  1122,  1125,  1128,  1130,  1133,  1135,  1138,  1142,
    1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,  1162,  1163,
    1167,  1169,  1175,  1176,  1178,  1181,  1183,  1185,  1187,  1189,
    1190,  1194,  1195,  1197,  1198,  1200,  1203,  1205,  1207,  1210,
    1213,  1218,  1220,  1224,  1227,  1229,  1232,  1235,  1238,  1241,
    1243,  1246,  1248,  1250,  1252,  1254,  1256,  1257,  1260,  1262,
    1264,  1266,  1268,  1270,  1271,  1274,  1276,  1278,  1279,  1281,
    1282,  1285,  1287,  1290,  1294,  1297,  1298,  1300,  1301,  1303,
    1305,  1308,  1309,  1311,  1312,  1317,  1319,  1324,  1328,  1330,
    1331,  1333,  1336,  1338,  1342,  1346,  1349,  1352,  1355,  1357,
    1359,  1362,  1365,  1368,  1370,  1373,  1376,  1379,  1382,  1384,
    1386,  1387,  1389,  1391,  1393,  1395,  1396,  1398,  1400,  1402,
    1403,  1406,  1409,  1411,  1413,  1415,  1420,  1423,  1425,  1430,
    1431,  1433,  1434,  1437,  1439,  1443,  1444,  1451,  1452,  1458,
    1459,  1465,  1466,  1472,  1473,  1485,  1486,  1488,  1489,  1492,
    1495,  1497,  1501,  1504,  1508,  1511,  1516,  1517,  1524,  1525,
    1526,  1535,  1540,  1545,  1549,  1553,  1556,  1559,  1566,  1572,
    1576,  1582,  1584,  1586,  1588,  1589,  1591,  1592,  1594,  1595,
    1597,  1599,  1600,  1603,  1605,  1606,  1608,  1610,  1612,  1613,
    1619,  1623,  1624,  1630,  1634,  1638,  1639,  1643,  1644,  1647,
    1649,  1653,  1654,  1656,  1658,  1659,  1662,  1664,  1668,  1669,
    1676,  1677,  1684,  1685,  1691,  1692,  1694,  1696,  1697,  1704,
    1705,  1707,  1709,  1712,  1714,  1716,  1718,  1719,  1725,  1726,
    1732,  1733,  1735,  1737,  1740,  1742,  1744,  1746,  1748,  1750,
    1753,  1754,  1760,  1761,  1763,  1765,  1766,  1771,  1776,  1780,
    1786,  1788,  1792,  1796,  1802,  1804,  1808,  1811,  1813,  1815,
    1816,  1823,  1825,  1829,  1833,  1834,  1837,  1838,  1843,  1844,
    1847,  1849,  1852,  1857,  1860,  1864,  1865,  1869,  1870,  1871,
    1878,  1881,  1883,  1885,  1888,  1891,  1900,  1905,  1906,  1908,
    1911,  1913,  1915,  1917,  1919,  1921,  1923,  1925,  1927,  1929,
    1931,  1933,  1934,  1937,  1942,  1946,  1948,  1950,  1955,  1956,
    1957,  1959,  1961,  1962,  1965,  1968,  1970,  1972,  1973,  1976,
    1980,  1984,  1988,  1991,  1995,  2000,  2004,  2009,  2013,  2018,
    2020,  2024,  2029,  2033,  2037,  2044,  2046,  2052,  2059,  2065,
    2073,  2080,  2089,  2095,  2102,  2107,  2112,  2118,  2122,  2127,
    2129,  2133,  2137,  2141,  2145,  2149,  2153,  2158,  2163,  2167,
    2171,  2175,  2179,  2183,  2187,  2189,  2191,  2193,  2195,  2197,
    2199,  2201,  2203,  2205,  2207,  2209,  2211,  2213,  2215,  2217,
    2219,  2221,  2224,  2226,  2230,  2232,  2234,  2236,  2238,  2242,
    2245,  2248,  2251,  2254,  2258,  2262,  2268,  2275,  2280,  2285,
    2293,  2298,  2301,  2308,  2314,  2321,  2328,  2333,  2338,  2342,
    2347,  2354,  2363,  2370,  2379,  2386,  2391,  2398,  2403,  2410,
    2415,  2420,  2425,  2430,  2437,  2446,  2449,  2452,  2457,  2460,
    2468,  2476,  2480,  2485,  2490,  2497,  2504,  2509,  2516,  2523,
    2530,  2535,  2542,  2547,  2554,  2563,  2574,  2587,  2594,  2599,
    2606,  2613,  2615,  2622,  2627,  2636,  2647,  2652,  2654,  2658,
    2663,  2670,  2677,  2686,  2693,  2700,  2705,  2712,  2719,  2728,
    2733,  2738,  2745,  2750,  2753,  2758,  2763,  2768,  2775,  2780,
    2785,  2789,  2798,  2805,  2810,  2817,  2821,  2828,  2837,  2842,
    2851,  2858,  2867,  2874,  2883,  2886,  2891,  2896,  2901,  2908,
    2917,  2926,  2931,  2939,  2947,  2955,  2962,  2969,  2976,  2983,
    2990,  2997,  2998,  3004,  3015,  3019,  3024,  3028,  3031,  3034,
    3037,  3042,  3049,  3054,  3059,  3066,  3073,  3080,  3087,  3092,
    3099,  3104,  3111,  3116,  3121,  3126,  3131,  3138,  3143,  3150,
    3155,  3162,  3167,  3172,  3179,  3184,  3191,  3196,  3203,  3208,
    3213,  3220,  3225,  3232,  3233,  3237,  3241,  3242,  3244,  3245,
    3248,  3250,  3254,  3259,  3264,  3270,  3275,  3280,  3285,  3291,
    3296,  3297,  3298,  3306,  3317,  3322,  3328,  3333,  3339,  3344,
    3349,  3354,  3359,  3364,  3370,  3371,  3380,  3381,  3385,  3389,
    3391,  3396,  3397,  3399,  3400,  3403,  3404,  3406,  3407,  3411,
    3414,  3418,  3421,  3423,  3426,  3428,  3431,  3433,  3435,  3437,
    3440,  3441,  3443,  3444,  3447,  3449,  3453,  3455,  3459,  3460,
    3463,  3465,  3469,  3470,  3472,  3473,  3476,  3481,  3487,  3489,
    3491,  3493,  3495,  3499,  3503,  3507,  3508,  3515,  3516,  3523,
    3524,  3533,  3538,  3539,  3548,  3549,  3560,  3567,  3568,  3577,
    3578,  3589,  3596,  3598,  3601,  3604,  3605,  3610,  3611,  3623,
    3627,  3634,  3635,  3639,  3640,  3641,  3647,  3648,  3650,  3651,
    3653,  3654,  3657,  3658,  3661,  3664,  3667,  3668,  3675,  3676,
    3678,  3682,  3684,  3686,  3688,  3692,  3694,  3696,  3698,  3700,
    3702,  3704,  3706,  3708,  3710,  3712,  3714,  3716,  3718,  3720,
    3722,  3724,  3726,  3728,  3730,  3732,  3734,  3736,  3738,  3740,
    3742,  3744,  3745,  3747,  3749,  3750,  3753,  3754,  3756,  3757,
    3758,  3762,  3763,  3764,  3768,  3771,  3772,  3773,  3778,  3783,
    3786,  3787,  3790,  3793,  3797,  3801,  3803,  3806,  3807,  3809,
    3810,  3815,  3820,  3823,  3824,  3826,  3828,  3829,  3831,  3832,
    3834,  3837,  3839,  3843,  3847,  3849,  3851,  3853,  3855,  3856,
    3859,  3861,  3863,  3865,  3867,  3869,  3871,  3873,  3875,  3877,
    3879,  3881,  3882,  3883,  3890,  3891,  3893,  3897,  3899,  3902,
    3903,  3906,  3910,  3912,  3915,  3917,  3918,  3922,  3923,  3929,
    3932,  3934,  3935,  3939,  3946,  3947,  3954,  3959,  3966,  3971,
    3976,  3981,  3987,  3992,  3994,  3998,  4000,  4001,  4004,  4005,
    4007,  4008,  4009,  4018,  4019,  4020,  4027,  4028,  4030,  4032,
    4034,  4036,  4038,  4041,  4043,  4045,  4047,  4051,  4056,  4057,
    4061,  4065,  4067,  4070,  4073,  4074,  4078,  4079,  4085,  4089,
    4091,  4095,  4097,  4101,  4103,  4105,  4106,  4108,  4109,  4114,
    4115,  4117,  4121,  4123,  4125,  4127,  4128,  4129,  4136,  4137,
    4138,  4150,  4154,  4156,  4160,  4164,  4166,  4170,  4171,  4173,
    4174,  4179,  4180,  4187,  4188,  4194,  4195,  4202,  4204,  4208,
    4212,  4218,  4219,  4222,  4223,  4226,  4228,  4230,  4232,  4236,
    4237,  4239,  4240,  4244,  4247,  4252,  4257,  4262,  4267,  4268,
    4273,  4280,  4297,  4300,  4303,  4304,  4311,  4317,  4320,  4323,
    4326,  4328,  4334,  4340,  4343,  4346,  4350,  4353,  4356,  4359,
    4363,  4366,  4369,  4372,  4374,  4376,  4380,  4385,  4389,  4393,
    4396,  4399,  4403,  4407,  4411,  4415,  4419,  4423,  4425,  4427,
    4429,  4431,  4432,  4434,  4435,  4438,  4439,  4441,  4443,  4445,
    4446,  4449,  4450,  4453,  4454,  4457,  4460,  4461,  4466,  4467,
    4472,  4474,  4476,  4477,  4479,  4480,  4482,  4484,  4485,  4490,
    4494,  4496,  4497,  4501,  4506,  4509,  4511,  4513,  4515,  4517,
    4519,  4521,  4523,  4525,  4526,  4528,  4529,  4533,  4537,  4539,
    4541,  4543,  4546,  4547,  4551,  4555,  4558,  4561,  4562,  4567,
    4568,  4570,  4572,  4575,  4576,  4581,  4587,  4588,  4589,  4590,
    4591,  4610,  4613,  4614,  4616,  4617,  4619,  4621,  4622,  4624,
    4626,  4627,  4630,  4633,  4635,  4639,  4644,  4648,  4652,  4653,
    4656,  4659,  4661,  4665,  4669,  4670,  4674,  4675,  4679,  4682,
    4686,  4688,  4690,  4693,  4694,  4697,  4699,  4701,  4704,  4707,
    4709,  4711,  4713,  4715,  4717,  4720,  4723,  4725,  4727,  4729,
    4731,  4733,  4735,  4737,  4740,  4743,  4746,  4749,  4752,  4754,
    4756,  4758,  4760,  4762,  4764,  4766,  4770,  4776,  4778,  4780,
    4782,  4784,  4786,  4790,  4795,  4801,  4803,  4809,  4813,  4816,
    4818,  4822,  4825,  4827,  4829,  4831,  4833,  4835,  4837,  4839,
    4841,  4843,  4845,  4847,  4849,  4851,  4853,  4857,  4860,  4862,
    4864,  4866,  4868,  4870,  4872,  4874,  4876,  4878,  4880,  4882,
    4884,  4886,  4888,  4890,  4892,  4894,  4896,  4898,  4900,  4902,
    4904,  4906,  4908,  4910,  4912,  4914,  4916,  4918,  4920,  4922,
    4924,  4926,  4928,  4930,  4932,  4934,  4936,  4938,  4940,  4942,
    4944,  4946,  4948,  4950,  4952,  4954,  4956,  4958,  4960,  4962,
    4964,  4966,  4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,
    4984,  4986,  4988,  4990,  4992,  4994,  4996,  4998,  5000,  5002,
    5004,  5006,  5008,  5010,  5012,  5014,  5016,  5018,  5020,  5022,
    5024,  5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,
    5044,  5046,  5048,  5050,  5052,  5054,  5056,  5058,  5060,  5062,
    5064,  5066,  5068,  5070,  5072,  5074,  5076,  5078,  5080,  5082,
    5084,  5086,  5088,  5090,  5092,  5094,  5096,  5098,  5100,  5102,
    5104,  5106,  5108,  5110,  5112,  5114,  5116,  5118,  5120,  5122,
    5124,  5126,  5128,  5130,  5132,  5134,  5136,  5138,  5140,  5142,
    5144,  5146,  5148,  5150,  5152,  5154,  5156,  5158,  5160,  5162,
    5164,  5166,  5168,  5170,  5172,  5174,  5176,  5178,  5180,  5182,
    5184,  5186,  5188,  5190,  5192,  5194,  5196,  5198,  5200,  5202,
    5204,  5206,  5208,  5210,  5212,  5214,  5216,  5218,  5220,  5222,
    5224,  5226,  5228,  5230,  5232,  5234,  5236,  5238,  5240,  5242,
    5244,  5246,  5248,  5250,  5252,  5254,  5256,  5258,  5260,  5262,
    5264,  5266,  5268,  5270,  5272,  5274,  5276,  5278,  5280,  5282,
    5284,  5286,  5288,  5290,  5292,  5294,  5296,  5298,  5300,  5302,
    5304,  5306,  5308,  5310,  5312,  5314,  5316,  5318,  5320,  5322,
    5324,  5326,  5328,  5330,  5332,  5334,  5336,  5338,  5340,  5342,
    5344,  5346,  5348,  5350,  5352,  5354,  5356,  5358,  5360,  5361,
    5366,  5367,  5369,  5371,  5375,  5376,  5379,  5381,  5383,  5385,
    5387,  5388,  5390,  5391,  5393,  5395,  5397,  5398,  5401,  5404,
    5407,  5409,  5412,  5417,  5423,  5428,  5435,  5438,  5442,  5446,
    5450,  5456,  5458,  5462,  5466,  5469,  5472,  5475,  5477,  5479,
    5484,  5489,  5491,  5493,  5495,  5497,  5499,  5500,  5505,  5507,
    5509,  5511,  5515,  5519,  5521,  5523,  5526,  5529,  5530,  5534,
    5539,  5543,  5544,  5552,  5554,  5557,  5559,  5561,  5563,  5565,
    5567,  5569,  5570,  5576,  5578,  5580,  5582,  5584,  5586,  5590,
    5597,  5604,  5611,  5619,  5623,  5632,  5641,  5650,  5651,  5653,
    5655,  5658,  5659,  5661,  5663,  5667,  5668,  5672,  5673,  5677,
    5678,  5682,  5683,  5687,  5689,  5691,  5693,  5695,  5697,  5699,
    5701,  5703,  5705,  5707,  5709,  5712,  5715,  5717,  5721,  5724,
    5727,  5730,  5733,  5736,  5739,  5742,  5745,  5746,  5748,  5752,
    5754,  5757,  5760,  5763,  5765,  5769,  5773,  5775,  5777,  5781,
    5783,  5787,  5792,  5798,  5800,  5801,  5805,  5809,  5811,  5813,
    5814,  5817,  5820,  5823,  5826,  5827,  5830,  5833,  5835,  5838,
    5841,  5844,  5847,  5850,  5851,  5855,  5856,  5858,  5859,  5863,
    5866,  5867,  5869,  5872,  5873,  5875,  5880,  5885,  5891,  5894,
    5898,  5899,  5901,  5902,  5907,  5908,  5910,  5912,  5913,  5916,
    5919,  5921,  5922,  5924,  5926,  5927,  5933,  5940,  5941,  5942,
    5945,  5948,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,
    5968,  5970,  5972,  5974,  5975,  5979,  5981,  5984,  5986,  5989,
    5993,  5997,  6001,  6002,  6004,  6005,  6009,  6013,  6014,  6023,
    6024,  6028,  6030,  6034,  6035,  6038,  6042,  6048,  6049,  6053,
    6058,  6063,  6064,  6079,  6088,  6096,  6097,  6098,  6099,  6100,
    6101,  6117,  6118,  6119,  6120,  6121,  6134,  6139,  6144,  6148,
    6153,  6157,  6160,  6162,  6166,  6172,  6174,  6176,  6177,  6179,
    6181,  6182,  6185,  6186,  6187,  6191,  6192
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1175,    -1,   769,    -1,   810,    -1,   800,    -1,   602,    -1,
     585,    -1,   812,    -1,   802,    -1,  1181,    -1,   590,    -1,
     574,    -1,  1019,    -1,  1046,    -1,   975,    -1,   977,    -1,
     578,    -1,  1052,    -1,  1150,    -1,  1141,    -1,   583,    -1,
     983,    -1,  1066,    -1,  1070,    -1,  1133,    -1,   817,    -1,
     825,    -1,   829,    -1,   576,    -1,  1062,    -1,  1184,    -1,
     820,    -1,   805,    -1,   986,    -1,  1058,    -1,   798,    -1,
    1148,    -1,  1182,    -1,  1183,    -1,   837,    -1,  1116,    -1,
    1032,    -1,   787,    -1,   790,    -1,  1030,    -1,  1139,    -1,
    1011,    -1,  1069,    -1,  1230,    -1,   575,   362,  1110,    -1,
     103,    -1,   126,    -1,   362,  1110,   171,   577,    -1,  1107,
      -1,   566,  1112,    -1,    -1,   148,  1110,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1112,    -1,    -1,   198,   584,  1112,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1107,    -1,   282,   142,  1107,    -1,   271,
     142,  1107,    -1,   272,   142,   960,    -1,   267,   142,   960,
      -1,   280,   142,   960,    -1,   276,   142,  1107,    -1,   275,
     142,  1107,    -1,   277,   142,  1107,    -1,   278,   142,  1107,
      -1,   279,   142,  1107,    -1,   589,    -1,   269,   142,  1107,
      -1,   270,   142,   961,    -1,   386,   142,  1107,    -1,   387,
     142,   960,    -1,    -1,    84,   687,   472,   690,  1104,   591,
     674,    -1,    -1,    84,   761,   213,  1110,   762,   337,  1104,
     592,   560,   764,   561,    -1,    -1,    84,    91,   690,  1110,
     593,   684,    -1,    -1,    84,   594,  1197,    -1,    84,   514,
     595,  1166,    -1,    -1,  1110,   567,  1110,    -1,  1110,    -1,
      -1,   597,   599,    -1,    -1,   598,   600,    -1,    67,  1107,
      -1,   235,   450,    -1,   328,   450,    -1,    79,   450,    -1,
     379,   450,    93,    -1,   304,   450,    93,    -1,   601,    -1,
     599,    -1,   118,    -1,   864,   118,    -1,   450,   419,   109,
      -1,   450,   419,   224,    -1,    -1,    47,   596,   603,   604,
      -1,    -1,   560,   605,   561,    -1,    -1,   606,    -1,   606,
     562,   858,    -1,   858,    -1,    -1,   608,    -1,   608,   562,
     610,    -1,   610,    -1,    -1,  1110,   609,   713,    -1,    -1,
     612,    -1,   612,   562,   613,    -1,   613,    -1,   614,   609,
    1110,   713,    -1,    -1,   225,    -1,   350,    -1,   217,    -1,
      -1,   615,   631,   568,    -1,   631,   568,    -1,   616,   631,
     568,    -1,    -1,   617,   618,   568,    -1,    -1,   106,   629,
     619,   713,   630,    -1,   106,  1110,    75,   168,   626,    -1,
      -1,   106,   623,   195,   168,   620,   624,   631,    -1,   106,
    1110,    89,   168,   621,    -1,    -1,   622,   573,    -1,   150,
      -1,    80,    -1,   625,    -1,   624,   562,   625,    -1,   628,
      -1,   960,    -1,   442,   627,  1108,    -1,    -1,   523,    -1,
     626,    -1,  1110,    -1,   443,    -1,   864,   169,    -1,   441,
      -1,  1110,    -1,   629,   562,  1110,    -1,    -1,   108,   858,
      -1,    -1,   632,   573,    -1,    -1,   404,   633,   858,    -1,
      -1,   209,   634,   639,   138,   209,    -1,   644,    -1,   659,
      -1,    -1,   635,   668,    -1,   662,    -1,   664,    -1,   242,
    1111,    -1,   229,  1111,    -1,   340,  1110,    -1,    -1,   157,
     637,  1110,   222,   636,   638,    -1,    60,  1110,    -1,    -1,
     323,   171,    -1,   171,    -1,  1110,    -1,   638,   562,  1110,
      -1,    -1,    -1,    -1,   640,   858,   547,   641,   616,   642,
     643,    -1,    -1,   132,   639,    -1,   546,   616,    -1,   645,
      -1,   648,    -1,    -1,    -1,   548,   646,   858,   647,   650,
     658,   138,   548,    -1,    -1,   548,   649,   651,   658,   138,
     548,    -1,   652,    -1,   650,   652,    -1,   655,    -1,   651,
     655,    -1,    -1,    -1,   532,   653,   858,   654,   547,   616,
      -1,    -1,    -1,   532,   656,   858,   657,   547,   616,    -1,
      -1,   546,   616,    -1,    -1,  1111,   569,   660,   668,   661,
      -1,    -1,  1111,    -1,    -1,  1111,   569,   663,   666,   661,
      -1,    -1,   665,   666,    -1,    -1,    28,   667,   617,   615,
     138,    -1,   263,   616,   138,   263,    -1,    -1,    -1,   534,
     669,   858,   125,   670,   616,   138,   534,    -1,    -1,   394,
     616,   510,   671,   858,   138,   394,    -1,    27,    -1,     8,
      -1,   219,    -1,   511,    -1,   112,    -1,   560,   675,    -1,
     691,   677,    -1,   246,  1104,    -1,   560,   246,  1104,   561,
      -1,   703,   561,   691,   677,    -1,    -1,   680,   561,   676,
    1188,    -1,    -1,    -1,  1079,   683,   680,   678,  1185,    -1,
      -1,  1079,   683,   560,   680,   561,   679,  1188,    -1,    -1,
      -1,   420,   681,   847,   851,   682,   701,    -1,    -1,    18,
      -1,    -1,   685,    -1,   686,    -1,   685,   686,    -1,   696,
      -1,   695,    -1,    -1,   688,    -1,   689,    -1,   689,   688,
      -1,   473,    -1,    -1,   209,   864,   149,    -1,    -1,   693,
      -1,   694,    -1,   694,   692,    -1,   694,    -1,   694,   693,
      -1,   694,   562,   693,    -1,   140,  1003,   697,    -1,   494,
    1003,   697,    -1,   286,  1003,   961,    -1,   300,  1003,   961,
      -1,    24,  1003,   960,    -1,   353,  1003,  1107,    -1,    67,
    1003,  1107,    -1,    23,  1003,   961,    -1,   351,  1003,   960,
      -1,   351,  1003,   108,    -1,    56,  1003,   960,    -1,   111,
    1003,   960,    -1,   413,  1003,   698,    -1,   377,  1003,   699,
      -1,   374,  1003,   960,    -1,   375,  1003,   960,    -1,   503,
    1003,   560,   979,   561,    -1,   695,    -1,   696,    -1,   220,
    1003,   700,    -1,    93,   119,  1003,  1107,    -1,   213,   119,
    1003,  1107,    -1,    76,  1003,  1107,    -1,   743,   734,  1003,
     736,    -1,   743,    63,  1003,   742,    -1,  1112,    -1,   108,
      -1,   161,    -1,   130,    -1,    71,    -1,   383,    -1,    70,
      -1,   376,    -1,   373,    -1,   960,    -1,   328,    -1,   160,
      -1,   237,    -1,   955,    -1,   846,   850,    -1,   461,    -1,
     381,    -1,   105,    -1,   223,    -1,   704,    -1,   703,   562,
     704,    -1,   705,    -1,   706,    -1,   711,   707,    -1,   711,
     748,    -1,   756,   766,   762,   560,   764,   561,    -1,   709,
     757,   766,   762,   560,   764,   561,    -1,   709,   166,   232,
     766,   560,   764,   561,   748,    -1,   710,   707,    -1,   709,
     708,    -1,    -1,   708,    -1,    57,   858,    -1,    -1,   710,
      -1,    78,   766,    -1,    -1,  1103,   712,   713,   730,    -1,
     721,   728,   725,    -1,   722,   729,   725,    -1,   163,   723,
     725,    -1,    37,    -1,    37,   560,   331,   561,    -1,    41,
      -1,    40,    -1,   717,   560,   331,   561,   744,    -1,   717,
     744,    -1,   718,   560,   331,   561,   745,    -1,   718,   745,
      -1,    32,   560,   331,   561,    -1,    32,    -1,   719,   560,
     331,   561,   744,    -1,   720,   560,   331,   561,   745,    -1,
     524,   560,   331,   561,    -1,   543,   728,   725,    -1,    97,
      -1,   481,    -1,   478,   728,    -1,    94,    -1,   482,    -1,
      39,   728,    -1,   716,    -1,   290,    -1,   259,    -1,   262,
     524,    -1,   262,   719,   744,    -1,   484,   744,    -1,   477,
     728,   744,    -1,   292,   744,    -1,   260,   744,    -1,   105,
     723,   725,    -1,   332,   723,   725,    -1,   161,   723,   725,
      -1,    -1,   141,   714,   560,   768,   561,   744,    -1,    -1,
     426,   715,   560,   768,   561,   744,    -1,   262,   744,    -1,
     424,    -1,   183,    -1,   182,    -1,   357,    -1,   311,    -1,
     250,    -1,   310,    -1,   359,    -1,   312,    -1,    55,    -1,
     319,    -1,   316,    55,    -1,   717,   528,    -1,   525,    -1,
     316,   525,    -1,   333,    -1,   319,   525,    -1,   316,    55,
     528,    -1,   319,   528,    -1,   223,    -1,   483,    -1,   436,
      -1,   291,    -1,    31,    -1,   381,    -1,   124,    -1,   124,
     361,    -1,    -1,   560,   331,   561,    -1,   724,    -1,   560,
     331,   562,   331,   561,    -1,    -1,   726,    -1,   726,   727,
      -1,   727,    -1,   433,    -1,   509,    -1,   544,    -1,    -1,
     560,   331,   561,    -1,    -1,   724,    -1,    -1,   731,    -1,
     731,   732,    -1,   732,    -1,   330,    -1,   864,   330,    -1,
     108,   733,    -1,   337,   511,   327,   857,    -1,    23,    -1,
     424,   108,   523,    -1,   747,   232,    -1,   504,    -1,   504,
     232,    -1,    67,  1107,    -1,    63,   740,    -1,   327,   857,
      -1,  1094,    -1,    55,   426,    -1,    54,    -1,  1112,    -1,
      32,    -1,   735,    -1,   108,    -1,    -1,   734,   736,    -1,
    1112,    -1,    32,    -1,   738,    -1,   108,    -1,  1112,    -1,
      -1,    63,   742,    -1,   740,    -1,   108,    -1,    -1,   108,
      -1,    -1,    20,   745,    -1,    45,    -1,   502,   745,    -1,
     734,   735,   745,    -1,    32,   746,    -1,    -1,    32,    -1,
      -1,    20,    -1,   502,    -1,   734,   735,    -1,    -1,   364,
      -1,    -1,   384,  1104,   749,   750,    -1,   752,    -1,   560,
     751,   561,   752,    -1,   751,   562,  1110,    -1,  1110,    -1,
      -1,   753,    -1,   753,   754,    -1,   754,    -1,   337,   112,
     755,    -1,   337,   511,   755,    -1,   283,   173,    -1,   283,
     352,    -1,   283,   434,    -1,   401,    -1,    48,    -1,   426,
     330,    -1,   328,     5,    -1,   426,   108,    -1,   758,    -1,
     174,   759,    -1,   439,   759,    -1,   364,   232,    -1,   504,
     759,    -1,   232,    -1,   213,    -1,    -1,   758,    -1,   231,
      -1,   213,    -1,   212,    -1,    -1,   504,    -1,   174,    -1,
     439,    -1,    -1,   517,   763,    -1,   494,   763,    -1,    43,
      -1,   415,    -1,   196,    -1,   764,   562,   765,   953,    -1,
     765,   953,    -1,  1110,    -1,  1110,   560,   331,   561,    -1,
      -1,  1103,    -1,    -1,   567,  1110,    -1,  1092,    -1,   768,
     562,  1092,    -1,    -1,    13,   783,   472,  1104,   770,   776,
      -1,    -1,    13,    91,   775,   771,   685,    -1,    -1,    13,
     366,   596,   772,   597,    -1,    -1,    13,   175,   596,   773,
     597,    -1,    -1,    13,  1206,  1200,  1207,   529,  1104,   774,
    1210,    18,  1212,  1215,    -1,    -1,  1110,    -1,    -1,   121,
     471,    -1,   211,   471,    -1,   778,    -1,   776,   562,   778,
      -1,     6,   782,    -1,   777,   705,   785,    -1,     6,   706,
      -1,   777,   560,   703,   561,    -1,    -1,    52,   782,  1103,
     779,   711,   785,    -1,    -1,    -1,   305,   782,  1103,   780,
     713,   730,   781,   785,    -1,   126,   782,  1103,   784,    -1,
     126,   166,   232,   766,    -1,   126,   364,   232,    -1,   126,
     758,  1103,    -1,   120,   231,    -1,   134,   231,    -1,    13,
     782,  1103,   426,   108,  1094,    -1,    13,   782,  1103,   126,
     108,    -1,   391,   786,  1104,    -1,    81,   485,   734,   736,
     741,    -1,   692,    -1,   165,    -1,   946,    -1,    -1,    66,
      -1,    -1,   210,    -1,    -1,   401,    -1,    48,    -1,    -1,
       8,  1110,    -1,   160,    -1,    -1,   485,    -1,   142,    -1,
      18,    -1,    -1,   454,   435,   792,   788,   796,    -1,   458,
     435,   792,    -1,    -1,   435,   454,   792,   789,   796,    -1,
     435,   458,   792,    -1,   454,   487,   791,    -1,    -1,   535,
      77,   437,    -1,    -1,   793,   794,    -1,   795,    -1,   794,
     562,   795,    -1,    -1,   451,    -1,   388,    -1,    -1,   510,
     797,    -1,   589,    -1,   797,   562,   589,    -1,    -1,   400,
    1135,   799,   979,   171,  1107,    -1,    -1,    26,  1135,   801,
     979,   485,  1107,    -1,    -1,    56,  1135,   803,   979,   804,
      -1,    -1,   372,    -1,   153,    -1,    -1,   392,   819,  1135,
     806,   979,   807,    -1,    -1,   808,    -1,   809,    -1,   809,
     808,    -1,   372,    -1,   153,    -1,   515,    -1,    -1,    14,
     819,  1135,   811,   979,    -1,    -1,    57,  1135,   813,   979,
     814,    -1,    -1,   815,    -1,   816,    -1,   816,   815,    -1,
     372,    -1,   156,    -1,   293,    -1,   153,    -1,    53,    -1,
     168,   512,    -1,    -1,   341,   819,  1135,   818,   979,    -1,
      -1,   329,    -1,   252,    -1,    -1,   391,  1135,   821,   823,
      -1,   391,   514,   595,   822,    -1,  1113,   485,  1113,    -1,
     822,   562,  1113,   485,  1113,    -1,   824,    -1,   823,   562,
     824,    -1,  1104,   485,  1104,    -1,    46,   213,   826,   225,
     828,    -1,   827,    -1,   826,   562,   827,    -1,  1104,   833,
      -1,  1110,    -1,   108,    -1,    -1,   251,   213,   222,    46,
     830,   831,    -1,   832,    -1,   831,   562,   832,    -1,  1104,
     833,   836,    -1,    -1,   834,   835,    -1,    -1,   759,   560,
     930,   561,    -1,    -1,   210,   241,    -1,   838,    -1,   420,
     840,    -1,   560,   839,   561,  1188,    -1,   420,   842,    -1,
     560,   839,   561,    -1,    -1,   842,   841,  1185,    -1,    -1,
      -1,   843,   847,   851,   844,   845,   850,    -1,   949,   955,
      -1,   971,    -1,   846,    -1,   971,   846,    -1,   846,   971,
      -1,   171,   903,   938,   943,   940,   949,   955,   962,    -1,
     171,   127,   938,   955,    -1,    -1,   848,    -1,   848,   849,
      -1,   849,    -1,   460,    -1,   200,    -1,   122,    -1,   449,
      -1,   444,    -1,   445,    -1,   447,    -1,   448,    -1,   446,
      -1,    12,    -1,    -1,   168,   511,    -1,   256,   225,   428,
     303,    -1,   851,   562,   852,    -1,   852,    -1,   554,    -1,
     853,   855,   854,   856,    -1,    -1,    -1,  1098,    -1,   858,
      -1,    -1,    18,  1110,    -1,    18,  1107,    -1,  1110,    -1,
    1107,    -1,    -1,   560,   561,    -1,   858,   862,   858,    -1,
     858,   540,   858,    -1,   858,   863,   858,    -1,   326,   858,
      -1,   859,   226,   491,    -1,   859,   226,   864,   491,    -1,
     859,   226,   155,    -1,   859,   226,   864,   155,    -1,   859,
     226,   507,    -1,   859,   226,   864,   507,    -1,   859,    -1,
     859,   226,   330,    -1,   859,   226,   864,   330,    -1,   859,
     143,   860,    -1,   859,   866,   860,    -1,   859,   866,   867,
     560,  1194,   561,    -1,   860,    -1,   861,   225,   560,  1194,
     561,    -1,   861,   864,   225,   560,  1194,   561,    -1,   861,
     225,   560,   858,   561,    -1,   861,   225,   560,   858,   562,
     892,   561,    -1,   861,   864,   225,   560,   858,   561,    -1,
     861,   864,   225,   560,   858,   562,   892,   561,    -1,   861,
     549,   861,    16,   860,    -1,   861,   864,   549,   861,    16,
     860,    -1,   861,   438,   246,   861,    -1,   861,   246,   869,
     942,    -1,   861,   864,   246,   869,   942,    -1,   861,   385,
     861,    -1,   861,   864,   385,   861,    -1,   861,    -1,   861,
     550,   861,    -1,   861,   551,   861,    -1,   861,   429,   861,
      -1,   861,   430,   861,    -1,   861,   553,   861,    -1,   861,
     552,   861,    -1,   861,   553,   868,   932,    -1,   861,   552,
     868,   932,    -1,   861,   554,   861,    -1,   861,   555,   861,
      -1,   861,   556,   861,    -1,   861,   123,   861,    -1,   861,
     306,   861,    -1,   861,   557,   861,    -1,   869,    -1,   347,
      -1,   344,    -1,    16,    -1,    15,    -1,   326,    -1,   325,
      -1,   563,    -1,   325,    -1,   142,    -1,   180,    -1,   194,
      -1,   238,    -1,   265,    -1,   321,    -1,    12,    -1,    17,
      -1,   221,   858,    -1,  1100,    -1,   869,    63,  1112,    -1,
    1095,    -1,  1093,    -1,   882,    -1,   878,    -1,   869,   346,
     869,    -1,   553,   869,    -1,   552,   869,    -1,   558,   869,
      -1,   865,   869,    -1,   560,  1194,   561,    -1,   560,   858,
     561,    -1,   560,   858,   562,   892,   561,    -1,   414,   560,
     858,   562,   892,   561,    -1,   149,   560,  1194,   561,    -1,
     564,  1110,   858,   565,    -1,   283,   895,     9,   560,   861,
     872,   561,    -1,    20,   560,   858,   561,    -1,    32,   869,
      -1,    50,   560,   858,    18,   890,   561,    -1,   548,   899,
     901,   900,   138,    -1,    81,   560,   858,   562,   890,   561,
      -1,    81,   560,   858,   517,   735,   561,    -1,   108,   560,
    1100,   561,    -1,   522,   560,  1101,   561,    -1,   176,   560,
     561,    -1,   177,   560,   858,   561,    -1,   178,   560,   858,
     562,   858,   561,    -1,   179,   560,   858,   562,   858,   562,
     858,   561,    -1,     7,   560,   858,   562,   858,   561,    -1,
       7,   560,   858,   562,   221,   858,   932,   561,    -1,   394,
     560,   858,   562,   858,   561,    -1,    22,   560,   858,   561,
      -1,    22,   560,   858,   562,   858,   561,    -1,    55,   560,
     892,   561,    -1,    55,   560,   892,   517,   735,   561,    -1,
      54,   560,   858,   561,    -1,    61,   560,   892,   561,    -1,
      64,   560,   858,   561,    -1,    72,   560,   892,   561,    -1,
      73,   560,   858,   562,   892,   561,    -1,    82,   560,   858,
     562,   858,   562,   858,   561,    -1,    87,   857,    -1,    90,
     857,    -1,    90,   560,   858,   561,    -1,    88,   857,    -1,
      95,   560,   858,   562,   868,   932,   561,    -1,    96,   560,
     858,   562,   868,   932,   561,    -1,    91,   560,   561,    -1,
      97,   560,   858,   561,    -1,   102,   560,   858,   561,    -1,
     133,   560,   858,   562,   892,   561,    -1,   266,   560,   858,
     562,   892,   561,    -1,   137,   560,   858,   561,    -1,   137,
     560,   858,   562,   858,   561,    -1,   107,   560,   858,   562,
    1108,   561,    -1,   136,   560,   858,   562,  1108,   561,    -1,
     115,   560,   858,   561,    -1,   115,   560,   858,   562,   858,
     561,    -1,   116,   560,   858,   561,    -1,   116,   560,   858,
     562,   858,   561,    -1,   152,   560,   858,   562,   858,   562,
     858,   561,    -1,   152,   560,   858,   562,   858,   562,   858,
     562,   858,   561,    -1,   152,   560,   858,   562,   858,   562,
     858,   562,   858,   562,   858,   561,    -1,   167,   560,   858,
     562,   331,   561,    -1,   172,   560,   858,   561,    -1,   172,
     560,   858,   562,   858,   561,    -1,   158,   560,   858,   562,
     892,   561,    -1,   871,    -1,   186,   560,   934,   562,   858,
     561,    -1,   205,   560,   858,   561,    -1,   209,   560,   858,
     562,   858,   562,   858,   561,    -1,   219,   560,   858,   562,
     858,   562,   858,   562,   858,   561,    -1,   868,   932,   553,
     858,    -1,   868,    -1,   236,   560,   561,    -1,   236,   560,
     858,   561,    -1,   243,   560,   858,   562,   858,   561,    -1,
     253,   560,   858,   562,   858,   561,    -1,   253,   560,   858,
     562,   858,   562,   858,   561,    -1,   190,   560,   858,   562,
     892,   561,    -1,   240,   560,   858,   562,   892,   561,    -1,
     258,   560,   858,   561,    -1,   258,   560,   858,   562,   858,
     561,    -1,   273,   560,   858,   562,   858,   561,    -1,   273,
     560,   858,   562,   858,   562,   858,   561,    -1,   295,   560,
     858,   561,    -1,   299,   560,   858,   561,    -1,   306,   560,
     858,   562,   858,   561,    -1,   307,   560,   858,   561,    -1,
     327,   857,    -1,   327,   560,   858,   561,    -1,   353,   560,
     858,   561,    -1,   336,   560,   858,   561,    -1,   360,   560,
     861,   225,   858,   561,    -1,   370,   560,   858,   561,    -1,
     378,   560,   858,   561,    -1,   378,   560,   561,    -1,   395,
     560,   858,   562,   858,   562,   858,   561,    -1,   406,   560,
     858,   562,   858,   561,    -1,   409,   560,   858,   561,    -1,
     409,   560,   858,   562,   858,   561,    -1,   412,   560,   561,
      -1,   462,   560,   858,   562,   858,   561,    -1,   462,   560,
     858,   562,   221,   858,   932,   561,    -1,   418,   560,   858,
     561,    -1,   464,   560,   858,   562,   858,   562,   858,   561,
      -1,   464,   560,   858,   562,   858,   561,    -1,   464,   560,
     858,   171,   858,   168,   858,   561,    -1,   464,   560,   858,
     171,   858,   561,    -1,   465,   560,   858,   562,   858,   562,
     858,   561,    -1,   469,   857,    -1,   469,   560,   858,   561,
      -1,   481,   560,   858,   561,    -1,   478,   560,   858,   561,
      -1,   478,   560,   858,   562,   858,   561,    -1,   479,   560,
     933,   562,   858,   562,   858,   561,    -1,   480,   560,   933,
     562,   858,   562,   858,   561,    -1,   490,   560,   858,   561,
      -1,   490,   560,   239,   858,   171,   858,   561,    -1,   490,
     560,   486,   858,   171,   858,   561,    -1,   490,   560,    42,
     858,   171,   858,   561,    -1,   490,   560,   239,   171,   858,
     561,    -1,   490,   560,   486,   171,   858,   561,    -1,   490,
     560,    42,   171,   858,   561,    -1,   490,   560,   858,   171,
     858,   561,    -1,   492,   560,   858,   562,   858,   561,    -1,
    1110,   567,  1110,   560,   891,   561,    -1,    -1,  1106,   560,
     870,   873,   561,    -1,   505,   560,  1091,   562,   331,   562,
     331,   562,   892,   561,    -1,   506,   560,   561,    -1,   506,
     560,   858,   561,    -1,   514,   560,   561,    -1,   518,   857,
      -1,   520,   857,    -1,   519,   857,    -1,   531,   560,   858,
     561,    -1,   531,   560,   858,   562,   858,   561,    -1,   543,
     560,   858,   561,    -1,   541,   560,   858,   561,    -1,   541,
     560,   858,   562,   858,   561,    -1,    29,   560,   960,   562,
     858,   561,    -1,   154,   560,   932,   171,   858,   561,    -1,
      79,   560,   858,   562,   858,   561,    -1,   184,   560,   858,
     561,    -1,   184,   560,   858,   562,   858,   561,    -1,   185,
     560,   858,   561,    -1,   185,   560,   858,   562,   858,   561,
      -1,   182,   560,   892,   561,    -1,   250,   560,   892,   561,
      -1,   310,   560,   892,   561,    -1,   302,   560,   858,   561,
      -1,   302,   560,   858,   562,   858,   561,    -1,   308,   560,
     858,   561,    -1,   308,   560,   858,   562,   858,   561,    -1,
     309,   560,   858,   561,    -1,   309,   560,   858,   562,   858,
     561,    -1,   311,   560,   892,   561,    -1,   312,   560,   892,
     561,    -1,   357,   560,   858,   562,   858,   561,    -1,   356,
     560,   858,   561,    -1,   356,   560,   858,   562,   858,   561,
      -1,   358,   560,   858,   561,    -1,   358,   560,   858,   562,
     858,   561,    -1,   359,   560,   892,   561,    -1,   181,   560,
     858,   561,    -1,   181,   560,   858,   562,   858,   561,    -1,
     248,   560,   858,   561,    -1,   248,   560,   858,   562,   858,
     561,    -1,    -1,   535,   371,   151,    -1,   225,    40,   303,
      -1,    -1,   874,    -1,    -1,   875,   876,    -1,   877,    -1,
     876,   562,   877,    -1,   853,   858,   854,   856,    -1,    25,
     560,   888,   561,    -1,    25,   560,   122,   888,   561,    -1,
      35,   560,   888,   561,    -1,    36,   560,   888,   561,    -1,
      38,   560,   888,   561,    -1,    83,   560,   937,   554,   561,
      -1,    83,   560,   888,   561,    -1,    -1,    -1,    83,   560,
     122,   879,   892,   880,   561,    -1,   193,   560,  1091,   562,
     331,   562,   331,   562,   888,   561,    -1,   301,   560,   888,
     561,    -1,   301,   560,   122,   888,   561,    -1,   287,   560,
     888,   561,    -1,   287,   560,   122,   888,   561,    -1,   456,
     560,   888,   561,    -1,   527,   560,   888,   561,    -1,   457,
     560,   888,   561,    -1,   521,   560,   888,   561,    -1,   466,
     560,   888,   561,    -1,   466,   560,   122,   888,   561,    -1,
      -1,   192,   560,   885,   881,   892,   887,   886,   561,    -1,
      -1,   566,   883,   884,    -1,  1112,   427,   858,    -1,  1112,
      -1,   566,  1125,  1112,   767,    -1,    -1,   122,    -1,    -1,
     422,  1092,    -1,    -1,   950,    -1,    -1,   937,   889,   858,
      -1,    32,   728,    -1,    55,   728,   744,    -1,   319,   728,
      -1,   433,    -1,   433,   223,    -1,   509,    -1,   509,   223,
      -1,    97,    -1,   481,    -1,    94,    -1,   105,   723,    -1,
      -1,   892,    -1,    -1,   893,   894,    -1,   858,    -1,   894,
     562,   858,    -1,   896,    -1,   560,   896,   561,    -1,    -1,
     897,   898,    -1,  1100,    -1,   898,   562,  1100,    -1,    -1,
     858,    -1,    -1,   546,   858,    -1,   532,   858,   547,   858,
      -1,   901,   532,   858,   547,   858,    -1,   914,    -1,   905,
      -1,   904,    -1,   902,    -1,   904,   562,   902,    -1,   902,
     913,   902,    -1,   902,   460,   914,    -1,    -1,   902,   913,
     902,   337,   906,   858,    -1,    -1,   902,   460,   914,   337,
     907,   858,    -1,    -1,   902,   913,   902,   517,   908,   560,
     931,   561,    -1,   902,   317,   230,   914,    -1,    -1,   902,
     243,   924,   230,   902,   337,   909,   858,    -1,    -1,   902,
     243,   924,   230,   914,   910,   517,   560,   931,   561,    -1,
     902,   317,   243,   924,   230,   914,    -1,    -1,   902,   406,
     924,   230,   902,   337,   911,   858,    -1,    -1,   902,   406,
     924,   230,   914,   912,   517,   560,   931,   561,    -1,   902,
     317,   406,   924,   230,   914,    -1,   230,    -1,   215,   230,
      -1,    85,   230,    -1,    -1,   915,  1104,   936,   926,    -1,
      -1,   564,  1110,   902,   243,   348,   230,   902,   337,   916,
     858,   565,    -1,   923,   922,   919,    -1,   560,   922,   917,
    1188,   561,   936,    -1,    -1,   922,   918,   904,    -1,    -1,
      -1,   920,   847,   851,   921,   701,    -1,    -1,   420,    -1,
      -1,   348,    -1,    -1,   168,   230,    -1,    -1,   516,   927,
      -1,   165,   927,    -1,   210,   927,    -1,    -1,   758,   925,
     928,   560,   929,   561,    -1,    -1,   930,    -1,   930,   562,
    1110,    -1,  1110,    -1,   364,    -1,  1110,    -1,   931,   562,
    1110,    -1,   933,    -1,    98,    -1,    99,    -1,   100,    -1,
     101,    -1,   202,    -1,   203,    -1,   204,    -1,   295,    -1,
     297,    -1,   298,    -1,   417,    -1,   542,    -1,   102,    -1,
     531,    -1,   205,    -1,   170,    -1,   299,    -1,   307,    -1,
     370,    -1,   418,    -1,   543,    -1,    97,    -1,   481,    -1,
      94,    -1,   478,    -1,    -1,    18,    -1,   142,    -1,    -1,
     935,  1110,    -1,    -1,    12,    -1,    -1,    -1,   533,   939,
     858,    -1,    -1,    -1,   197,   941,   858,    -1,   146,   869,
      -1,    -1,    -1,   191,    44,   944,   945,    -1,   944,   562,
    1099,   953,    -1,  1099,   953,    -1,    -1,   535,    86,    -1,
     535,   408,    -1,   345,    44,   947,    -1,   947,   562,   948,
      -1,   948,    -1,  1101,   953,    -1,    -1,   950,    -1,    -1,
     345,    44,   951,   952,    -1,   952,   562,  1099,   953,    -1,
    1099,   953,    -1,    -1,    19,    -1,   113,    -1,    -1,   956,
      -1,    -1,   956,    -1,   247,   957,    -1,   958,    -1,   958,
     562,   958,    -1,   958,   334,   958,    -1,  1093,    -1,   497,
      -1,   261,    -1,   331,    -1,    -1,   247,   958,    -1,   331,
      -1,   199,    -1,   261,    -1,   497,    -1,   104,    -1,   162,
      -1,   331,    -1,   497,    -1,   261,    -1,   104,    -1,   162,
      -1,    -1,    -1,   366,  1110,   963,   560,   964,   561,    -1,
      -1,   965,    -1,   965,   562,   966,    -1,   966,    -1,   853,
     858,    -1,    -1,   968,   969,    -1,   969,   562,   970,    -1,
     970,    -1,   566,  1112,    -1,  1112,    -1,    -1,   222,   972,
     973,    -1,    -1,   349,  1109,   974,  1080,  1083,    -1,   128,
    1109,    -1,   967,    -1,    -1,   125,   976,   892,    -1,   126,
     982,  1135,   981,   979,   784,    -1,    -1,   126,   213,  1110,
     337,  1104,   978,    -1,   126,    91,   981,  1110,    -1,   126,
     175,   981,  1110,   567,  1110,    -1,   126,   175,   981,  1110,
      -1,   126,   366,   981,   596,    -1,   126,   514,   595,  1165,
      -1,   126,   529,   981,   979,   784,    -1,   126,   488,   981,
     596,    -1,   980,    -1,   979,   562,   980,    -1,  1104,    -1,
      -1,   209,   149,    -1,    -1,   473,    -1,    -1,    -1,   219,
     984,   989,   783,   991,   985,   993,  1009,    -1,    -1,    -1,
     395,   987,   990,   991,   988,   993,    -1,    -1,   264,    -1,
     110,    -1,   200,    -1,  1018,    -1,   110,    -1,   222,   992,
      -1,   992,    -1,   980,    -1,   996,    -1,   560,   561,   996,
      -1,   560,   995,   561,   996,    -1,    -1,   426,   994,  1000,
      -1,   995,   562,  1097,    -1,  1097,    -1,   522,   999,    -1,
     523,   999,    -1,    -1,   680,   997,  1185,    -1,    -1,   560,
     680,   561,   998,  1188,    -1,   999,   562,  1004,    -1,  1004,
      -1,  1000,   562,  1001,    -1,  1001,    -1,  1101,  1002,  1008,
      -1,   142,    -1,   427,    -1,    -1,  1002,    -1,    -1,   560,
    1005,  1006,   561,    -1,    -1,  1007,    -1,  1007,   562,  1008,
      -1,  1008,    -1,   858,    -1,   108,    -1,    -1,    -1,   337,
     129,  1010,   232,   511,  1016,    -1,    -1,    -1,   511,  1012,
    1018,   783,   903,   426,  1014,  1013,   938,   949,   959,    -1,
    1014,   562,  1015,    -1,  1015,    -1,  1101,  1002,  1008,    -1,
    1016,   562,  1017,    -1,  1017,    -1,  1101,  1002,  1008,    -1,
      -1,   264,    -1,    -1,   112,  1020,  1028,  1021,    -1,    -1,
     171,  1104,  1022,   938,   949,   959,    -1,    -1,  1025,  1023,
     171,   903,   938,    -1,    -1,   171,  1025,  1024,   517,   903,
     938,    -1,  1026,    -1,  1025,   562,  1026,    -1,  1110,  1027,
     936,    -1,  1110,   567,  1110,  1027,   936,    -1,    -1,   567,
     554,    -1,    -1,  1029,  1028,    -1,   372,    -1,   264,    -1,
     210,    -1,   492,  1031,   980,    -1,    -1,   472,    -1,    -1,
     431,  1033,  1034,    -1,    92,  1045,    -1,  1041,   470,  1040,
    1045,    -1,  1041,   489,  1040,  1045,    -1,   472,   455,  1040,
    1045,    -1,   340,   470,  1040,  1045,    -1,    -1,   140,   697,
    1035,  1037,    -1,  1041,    65,  1042,  1104,  1040,  1045,    -1,
     322,   281,   168,   435,   535,   269,   142,  1107,    16,   270,
     142,   961,    16,   274,   142,   960,    -1,  1038,   257,    -1,
     435,   201,    -1,    -1,    33,   147,  1043,  1044,  1036,   954,
      -1,   760,  1042,  1104,  1040,   938,    -1,    66,   493,    -1,
     472,   493,    -1,  1039,   139,    -1,   365,    -1,    83,   560,
     554,   561,   530,    -1,    83,   560,   554,   561,   144,    -1,
     530,   954,    -1,   144,   954,    -1,  1124,   455,  1045,    -1,
     216,   455,    -1,   313,   455,    -1,  1041,   368,    -1,  1124,
     526,  1045,    -1,   734,  1045,    -1,    64,  1045,    -1,    30,
     257,    -1,   257,    -1,   189,    -1,   189,   168,  1113,    -1,
      84,    91,   690,  1110,    -1,    84,   472,  1104,    -1,    84,
     529,  1104,    -1,   281,   455,    -1,   435,   455,    -1,    84,
     366,   596,    -1,    84,   175,   596,    -1,   366,   455,  1045,
      -1,   175,   455,  1045,    -1,   366,    62,   596,    -1,   175,
      62,   596,    -1,   455,    -1,   257,    -1,   281,    -1,    32,
      -1,    -1,   459,    -1,    -1,  1042,  1110,    -1,    -1,   173,
      -1,   171,    -1,   225,    -1,    -1,   225,  1107,    -1,    -1,
     171,   961,    -1,    -1,   246,  1107,    -1,   533,   858,    -1,
      -1,  1049,  1104,  1047,  1051,    -1,    -1,  1049,  1050,  1048,
     837,    -1,   113,    -1,   114,    -1,    -1,   153,    -1,    -1,
    1092,    -1,  1110,    -1,    -1,   164,   819,  1053,  1054,    -1,
    1054,   562,  1055,    -1,  1055,    -1,    -1,  1135,  1056,  1057,
      -1,   470,   535,   380,   256,    -1,   371,    46,    -1,   201,
      -1,   365,    -1,   257,    -1,   455,    -1,   435,    -1,   281,
      -1,   117,    -1,   399,    -1,    -1,   979,    -1,    -1,   398,
    1059,  1060,    -1,  1060,   562,  1061,    -1,  1061,    -1,   435,
      -1,   281,    -1,   371,    46,    -1,    -1,   369,  1063,  1064,
      -1,  1038,   257,  1065,    -1,   485,  1107,    -1,    27,   858,
      -1,    -1,   233,  1067,  1068,   858,    -1,    -1,    76,    -1,
     371,    -1,   516,  1110,    -1,    -1,   251,    93,  1071,  1072,
      -1,   251,   472,  1104,   171,   281,    -1,    -1,    -1,    -1,
      -1,  1078,  1077,   214,  1109,  1073,  1079,   222,  1074,   472,
    1104,  1075,   737,  1076,  1080,  1083,  1086,  1087,  1090,    -1,
     171,   281,    -1,    -1,   252,    -1,    -1,    74,    -1,   264,
      -1,    -1,   395,    -1,   210,    -1,    -1,    65,  1081,    -1,
    1081,  1082,    -1,  1082,    -1,   475,    44,  1092,    -1,   343,
     135,    44,  1092,    -1,   135,    44,  1092,    -1,   145,    44,
    1092,    -1,    -1,   249,  1084,    -1,  1084,  1085,    -1,  1085,
      -1,   475,    44,  1092,    -1,   453,    44,  1092,    -1,    -1,
     210,   331,   249,    -1,    -1,   560,  1088,   561,    -1,   560,
     561,    -1,  1088,   562,  1089,    -1,  1089,    -1,  1101,    -1,
     566,  1112,    -1,    -1,   426,  1016,    -1,   476,    -1,   318,
      -1,   500,   476,    -1,  1091,  1108,    -1,  1108,    -1,   199,
      -1,    34,    -1,   354,    -1,  1095,    -1,   553,  1096,    -1,
     552,  1096,    -1,  1091,    -1,  1096,    -1,   330,    -1,   155,
      -1,   491,    -1,   199,    -1,    34,    -1,   500,   199,    -1,
     500,    34,    -1,    97,  1091,    -1,   481,  1091,    -1,   478,
    1091,    -1,   331,    -1,   261,    -1,   497,    -1,   104,    -1,
     162,    -1,  1101,    -1,  1098,    -1,  1110,   567,   554,    -1,
    1110,   567,  1110,   567,   554,    -1,   858,    -1,  1110,    -1,
    1102,    -1,  1110,    -1,  1102,    -1,  1110,   567,  1110,    -1,
     567,  1110,   567,  1110,    -1,  1110,   567,  1110,   567,  1110,
      -1,  1110,    -1,  1110,   567,  1110,   567,  1110,    -1,  1110,
     567,  1110,    -1,   567,  1110,    -1,  1110,    -1,  1110,   567,
    1110,    -1,   567,  1110,    -1,  1110,    -1,   206,    -1,   208,
      -1,   476,    -1,   476,    -1,   476,    -1,  1106,    -1,  1114,
      -1,  1106,    -1,  1115,    -1,  1110,    -1,  1107,    -1,   245,
      -1,  1112,    -1,  1112,   566,  1112,    -1,    88,   857,    -1,
    1115,    -1,    20,    -1,    26,    -1,    28,    -1,    45,    -1,
      46,    -1,    54,    -1,    56,    -1,    60,    -1,    67,    -1,
      69,    -1,    79,    -1,   103,    -1,   125,    -1,   138,    -1,
     148,    -1,   164,    -1,   195,    -1,   198,    -1,   235,    -1,
     328,    -1,   340,    -1,   362,    -1,   392,    -1,   398,    -1,
     400,    -1,   407,    -1,   416,    -1,   419,    -1,   433,    -1,
     435,    -1,   454,    -1,   458,    -1,   492,    -1,   502,    -1,
     539,    -1,   512,    -1,     5,    -1,     7,    -1,     8,    -1,
       9,    -1,    10,    -1,    11,    -1,    17,    -1,    23,    -1,
      24,    -1,    25,    -1,    30,    -1,    33,    -1,    37,    -1,
      41,    -1,    40,    -1,    43,    -1,    49,    -1,    51,    -1,
      53,    -1,    58,    -1,    59,    -1,    62,    -1,    64,    -1,
      65,    -1,    68,    -1,    70,    -1,    71,    -1,    74,    -1,
      76,    -1,    77,    -1,    86,    -1,    93,    -1,    94,    -1,
      97,    -1,   102,    -1,   109,    -1,   111,    -1,   117,    -1,
     119,    -1,   121,    -1,   128,    -1,   129,    -1,   130,    -1,
     141,    -1,   140,    -1,   139,    -1,   144,    -1,   146,    -1,
     147,    -1,   151,    -1,   153,    -1,   156,    -1,   169,    -1,
     120,    -1,   134,    -1,   173,    -1,   159,    -1,   160,    -1,
     161,    -1,   170,    -1,   183,    -1,   182,    -1,   186,    -1,
     189,    -1,   187,    -1,   196,    -1,   201,    -1,   205,    -1,
     207,    -1,   224,    -1,   211,    -1,   212,    -1,   227,    -1,
     228,    -1,   216,    -1,   220,    -1,   388,    -1,   237,    -1,
     241,    -1,   244,    -1,   250,    -1,   252,    -1,   255,    -1,
     257,    -1,   286,    -1,   281,    -1,   268,    -1,   272,    -1,
     269,    -1,   270,    -1,   282,    -1,   271,    -1,   274,    -1,
     267,    -1,   280,    -1,   276,    -1,   275,    -1,   277,    -1,
     278,    -1,   279,    -1,   284,    -1,   285,    -1,   288,    -1,
     289,    -1,   293,    -1,   294,    -1,   295,    -1,   296,    -1,
     299,    -1,   300,    -1,   305,    -1,   303,    -1,   307,    -1,
     310,    -1,   311,    -1,   312,    -1,   313,    -1,   315,    -1,
     314,    -1,   316,    -1,   319,    -1,   320,    -1,   323,    -1,
     322,    -1,   324,    -1,   333,    -1,   334,    -1,   336,    -1,
     338,    -1,   339,    -1,   351,    -1,   352,    -1,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,   363,    -1,   365,    -1,
     367,    -1,   368,    -1,   370,    -1,   371,    -1,   372,    -1,
     373,    -1,   374,    -1,   375,    -1,   376,    -1,   377,    -1,
     382,    -1,   383,    -1,   386,    -1,   387,    -1,   390,    -1,
     393,    -1,   396,    -1,   399,    -1,   402,    -1,   403,    -1,
     408,    -1,   410,    -1,   411,    -1,   413,    -1,   414,    -1,
     415,    -1,   418,    -1,   424,    -1,   423,    -1,   425,    -1,
     434,    -1,   428,    -1,   432,    -1,   437,    -1,   438,    -1,
     446,    -1,   445,    -1,   448,    -1,   451,    -1,   455,    -1,
     459,    -1,   461,    -1,   462,    -1,   463,    -1,   467,    -1,
     468,    -1,   470,    -1,   471,    -1,   473,    -1,   474,    -1,
     477,    -1,   487,    -1,   489,    -1,   478,    -1,   479,    -1,
     480,    -1,   481,    -1,   493,    -1,   494,    -1,   495,    -1,
     175,    -1,   498,    -1,   499,    -1,   507,    -1,   510,    -1,
     514,    -1,   515,    -1,   526,    -1,   529,    -1,   523,    -1,
     530,    -1,   531,    -1,   536,    -1,   538,    -1,   543,    -1,
      -1,   426,  1118,  1117,  1119,    -1,    -1,   342,    -1,  1120,
      -1,  1119,   562,  1120,    -1,    -1,  1121,  1126,    -1,  1123,
      -1,   187,    -1,   252,    -1,   425,    -1,    -1,   338,    -1,
      -1,   187,    -1,   252,    -1,   425,    -1,    -1,   187,   567,
      -1,   252,   567,    -1,   425,   567,    -1,  1127,    -1,  1123,
    1128,    -1,  1122,  1129,  1002,  1132,    -1,  1122,   487,   227,
     244,  1130,    -1,   566,  1112,  1002,   858,    -1,   566,   566,
    1125,  1129,  1002,  1132,    -1,   734,   739,    -1,   314,  1002,
     858,    -1,   314,   736,   741,    -1,   353,  1002,  1131,    -1,
     353,   168,  1113,  1002,  1131,    -1,  1110,    -1,  1110,   567,
    1110,    -1,   108,   567,  1110,    -1,   380,   498,    -1,   380,
      68,    -1,   393,   380,    -1,   423,    -1,   476,    -1,   353,
     560,   476,   561,    -1,   336,   560,   476,   561,    -1,   858,
      -1,   108,    -1,   337,    -1,    12,    -1,    32,    -1,    -1,
     256,  1135,  1134,  1136,    -1,   472,    -1,   470,    -1,  1137,
      -1,  1136,   562,  1137,    -1,  1104,   936,  1138,    -1,   380,
      -1,   537,    -1,   264,   537,    -1,   380,   252,    -1,    -1,
     508,  1140,  1135,    -1,   195,  1104,   340,   936,    -1,   195,
    1105,    60,    -1,    -1,   195,  1105,   380,  1142,  1143,   938,
     955,    -1,  1144,    -1,  1110,  1145,    -1,   160,    -1,   323,
      -1,   160,    -1,   323,    -1,   363,    -1,   237,    -1,    -1,
    1147,  1146,   560,  1007,   561,    -1,   142,    -1,   180,    -1,
     238,    -1,   194,    -1,   265,    -1,   405,   595,  1149,    -1,
    1153,   337,  1152,  1164,   171,  1166,    -1,  1153,   337,   175,
    1164,   171,  1166,    -1,  1153,   337,   366,  1164,   171,  1166,
      -1,    12,  1154,   562,   188,   342,   171,  1166,    -1,   188,
     595,  1151,    -1,  1153,   337,  1152,  1164,   485,  1166,  1171,
    1172,    -1,  1153,   337,   175,  1164,   485,  1166,  1171,  1172,
      -1,  1153,   337,   366,  1164,   485,  1166,  1171,  1172,    -1,
      -1,   472,    -1,  1155,    -1,    12,  1154,    -1,    -1,   365,
      -1,  1156,    -1,  1155,   562,  1156,    -1,    -1,   420,  1157,
    1168,    -1,    -1,   219,  1158,  1168,    -1,    -1,   511,  1159,
    1168,    -1,    -1,   384,  1160,  1168,    -1,   112,    -1,   513,
      -1,   213,    -1,    13,    -1,    84,    -1,   126,    -1,   148,
      -1,   390,    -1,   432,    -1,   367,    -1,   159,    -1,   188,
     342,    -1,   431,    92,    -1,   467,    -1,    84,   473,   470,
      -1,   256,   470,    -1,   396,   435,    -1,   396,    59,    -1,
      84,   529,    -1,   431,   529,    -1,    84,   410,    -1,    13,
     410,    -1,    84,   514,    -1,    -1,    16,    -1,  1163,  1161,
    1162,    -1,  1163,    -1,   463,   476,    -1,   228,   476,    -1,
      58,   476,    -1,   554,    -1,  1110,   567,   554,    -1,   554,
     567,   554,    -1,  1104,    -1,  1113,    -1,  1165,   562,  1113,
      -1,  1167,    -1,  1166,   562,  1167,    -1,  1113,   207,    44,
     476,    -1,  1113,   207,    44,   353,   476,    -1,  1113,    -1,
      -1,   560,  1169,   561,    -1,  1169,   562,  1170,    -1,  1170,
      -1,  1110,    -1,    -1,   397,  1162,    -1,   397,   452,    -1,
     397,   538,    -1,   397,   324,    -1,    -1,   535,  1173,    -1,
    1173,  1174,    -1,  1174,    -1,   188,   342,    -1,   285,   960,
      -1,   288,   960,    -1,   284,   960,    -1,   289,   960,    -1,
      -1,    28,  1176,  1177,    -1,    -1,   536,    -1,    -1,    16,
     328,    51,    -1,    16,    51,    -1,    -1,   389,    -1,   328,
     389,    -1,    -1,   416,    -1,    69,  1177,  1178,  1179,    -1,
     407,  1177,  1178,  1179,    -1,   407,  1177,   485,  1180,  1110,
      -1,   416,  1110,    -1,   389,   416,  1110,    -1,    -1,  1186,
      -1,    -1,   503,  1192,  1187,   838,    -1,    -1,  1186,    -1,
    1189,    -1,    -1,  1190,  1191,    -1,   950,   954,    -1,   956,
      -1,    -1,   122,    -1,    12,    -1,    -1,   420,  1195,   840,
    1193,  1196,    -1,   560,  1195,   839,  1193,  1196,   561,    -1,
      -1,    -1,  1202,  1198,    -1,  1201,  1199,    -1,  1203,  1200,
    1208,    -1,  1208,    -1,  1216,    -1,  1225,    -1,  1219,    -1,
    1208,    -1,  1216,    -1,  1225,    -1,  1219,    -1,  1218,    -1,
    1201,    -1,  1202,    -1,    -1,   109,   142,  1113,    -1,  1204,
      -1,  1204,  1205,    -1,  1205,    -1,   347,   395,    -1,    11,
     142,   499,    -1,    11,   142,   294,    -1,    11,   142,   474,
      -1,    -1,  1205,    -1,    -1,   450,   419,   109,    -1,   450,
     419,   224,    -1,    -1,  1207,   529,  1104,  1209,  1210,    18,
    1212,  1215,    -1,    -1,   560,  1211,   561,    -1,  1110,    -1,
    1211,   562,  1110,    -1,    -1,  1213,  1214,    -1,   420,   853,
     840,    -1,   560,   853,   839,   561,  1188,    -1,    -1,   535,
      57,   342,    -1,   535,    49,    57,   342,    -1,   535,   252,
      57,   342,    -1,    -1,   488,   853,   596,   672,   673,   337,
     853,  1104,   168,   853,   131,   414,  1217,   631,    -1,    10,
     853,   175,  1110,   403,   702,   496,  1107,    -1,   853,   175,
    1110,   403,   702,   496,  1107,    -1,    -1,    -1,    -1,    -1,
      -1,   853,   175,   596,   560,  1220,   607,   561,  1221,   403,
    1222,   713,  1223,   598,  1224,   631,    -1,    -1,    -1,    -1,
      -1,   366,   853,   596,  1226,   560,  1227,   611,   561,  1228,
     598,  1229,   631,    -1,   539,  1232,  1231,  1233,    -1,   539,
     138,  1231,  1235,    -1,   539,   362,  1231,    -1,   539,    69,
    1231,  1234,    -1,   539,   407,  1231,    -1,   539,   382,    -1,
    1092,    -1,  1092,   562,  1092,    -1,  1092,   562,  1092,   562,
     960,    -1,    28,    -1,   454,    -1,    -1,   230,    -1,   402,
      -1,    -1,   339,   355,    -1,    -1,    -1,   468,  1236,  1237,
      -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1204,  1204,  1218,  1221,  1222,  1227,  1228,  1229,  1230,
    1231,  1232,  1233,  1234,  1235,  1236,  1237,  1238,  1239,  1240,
    1241,  1242,  1243,  1244,  1245,  1246,  1247,  1248,  1249,  1250,
    1251,  1252,  1253,  1254,  1255,  1256,  1257,  1258,  1259,  1260,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,
    1271,  1272,  1273,  1277,  1286,  1287,  1292,  1301,  1308,  1318,
    1317,  1328,  1330,  1334,  1335,  1338,  1351,  1350,  1369,  1368,
    1379,  1380,  1383,  1388,  1393,  1398,  1403,  1407,  1412,  1416,
    1420,  1424,  1428,  1433,  1437,  1441,  1457,  1461,  1473,  1472,
    1492,  1491,  1512,  1511,  1524,  1523,  1531,  1539,  1553,  1568,
    1587,  1588,  1592,  1593,  1598,  1600,  1602,  1604,  1606,  1608,
    1610,  1616,  1617,  1618,  1622,  1626,  1634,  1633,  1646,  1648,
    1651,  1653,  1657,  1661,  1668,  1670,  1674,  1675,  1680,  1699,
    1725,  1727,  1731,  1732,  1736,  1762,  1763,  1764,  1765,  1769,
    1770,  1774,  1775,  1780,  1783,  1810,  1809,  1870,  1885,  1884,
    1931,  1957,  1957,  1989,  1990,  1995,  1997,  2002,  2025,  2031,
    2046,  2047,  2051,  2055,  2064,  2069,  2074,  2082,  2097,  2115,
    2116,  2120,  2120,  2172,  2171,  2200,  2199,  2203,  2204,  2206,
    2206,  2217,  2219,  2221,  2271,  2311,  2329,  2328,  2347,  2366,
    2368,  2369,  2373,  2394,  2417,  2422,  2437,  2417,  2456,  2458,
    2459,  2463,  2464,  2469,  2476,  2468,  2495,  2494,  2510,  2511,
    2515,  2516,  2521,  2526,  2520,  2543,  2548,  2542,  2563,  2573,
    2578,  2577,  2613,  2614,  2619,  2618,  2651,  2651,  2666,  2665,
    2702,  2714,  2719,  2713,  2745,  2744,  2767,  2769,  2774,  2776,
    2778,  2783,  2784,  2785,  2791,  2800,  2801,  2801,  2805,  2807,
    2806,  2809,  2808,  2814,  2830,  2813,  2844,  2845,  2848,  2849,
    2852,  2853,  2856,  2857,  2860,  2861,  2864,  2865,  2868,  2871,
    2872,  2874,  2876,  2879,  2880,  2883,  2884,  2885,  2888,  2889,
    2890,  2891,  2892,  2893,  2894,  2895,  2896,  2911,  2917,  2918,
    2919,  2920,  2925,  2930,  2935,  2950,  2951,  2952,  2953,  2954,
    2955,  2959,  2976,  2992,  3002,  3003,  3004,  3005,  3006,  3007,
    3010,  3011,  3012,  3015,  3016,  3017,  3020,  3021,  3024,  3025,
    3026,  3027,  3030,  3031,  3035,  3036,  3040,  3041,  3048,  3056,
    3064,  3081,  3085,  3091,  3093,  3097,  3101,  3102,  3106,  3111,
    3110,  3132,  3133,  3134,  3135,  3137,  3139,  3141,  3143,  3145,
    3147,  3150,  3153,  3156,  3159,  3161,  3164,  3167,  3168,  3169,
    3170,  3183,  3184,  3186,  3188,  3200,  3202,  3204,  3206,  3207,
    3208,  3209,  3210,  3211,  3213,  3215,  3217,  3217,  3219,  3219,
    3221,  3222,  3231,  3232,  3233,  3236,  3237,  3238,  3239,  3240,
    3244,  3248,  3249,  3253,  3254,  3258,  3259,  3260,  3261,  3262,
    3266,  3267,  3268,  3269,  3270,  3273,  3275,  3276,  3280,  3281,
    3282,  3285,  3292,  3293,  3296,  3297,  3300,  3301,  3302,  3305,
    3306,  3309,  3310,  3313,  3314,  3317,  3318,  3321,  3322,  3323,
    3324,  3326,  3327,  3333,  3339,  3345,  3351,  3352,  3368,  3369,
    3373,  3374,  3378,  3386,  3390,  3391,  3394,  3395,  3399,  3408,
    3412,  3413,  3416,  3426,  3427,  3431,  3432,  3435,  3436,  3439,
    3440,  3441,  3442,  3451,  3452,  3455,  3456,  3459,  3460,  3461,
    3470,  3472,  3474,  3479,  3478,  3490,  3491,  3494,  3495,  3499,
    3500,  3503,  3504,  3507,  3508,  3509,  3510,  3511,  3514,  3515,
    3516,  3517,  3518,  3521,  3522,  3523,  3535,  3536,  3539,  3540,
    3543,  3544,  3548,  3549,  3550,  3553,  3554,  3555,  3556,  3569,
    3570,  3571,  3574,  3575,  3579,  3582,  3583,  3586,  3587,  3598,
    3599,  3602,  3603,  3606,  3607,  3615,  3614,  3638,  3637,  3651,
    3650,  3669,  3668,  3688,  3686,  3706,  3707,  3709,  3710,  3711,
    3712,  3713,  3716,  3724,  3725,  3729,  3734,  3733,  3741,  3750,
    3740,  3762,  3769,  3773,  3780,  3787,  3793,  3799,  3805,  3812,
    3830,  3851,  3856,  3860,  3867,  3868,  3871,  3872,  3876,  3877,
    3878,  3882,  3883,  3884,  3887,  3888,  3889,  3890,  3898,  3897,
    3908,  3916,  3915,  3925,  3935,  3944,  3945,  3952,  3952,  3958,
    3959,  3963,  3964,  3965,  3969,  3970,  3987,  3988,  3993,  3992,
    4003,  4002,  4013,  4012,  4022,  4023,  4024,  4029,  4028,  4040,
    4041,  4044,  4045,  4048,  4049,  4050,  4054,  4053,  4066,  4065,
    4082,  4083,  4086,  4087,  4090,  4091,  4092,  4093,  4094,  4095,
    4099,  4098,  4110,  4111,  4112,  4117,  4116,  4122,  4129,  4134,
    4142,  4143,  4146,  4158,  4167,  4168,  4171,  4184,  4185,  4190,
    4189,  4199,  4200,  4203,  4216,  4216,  4226,  4227,  4236,  4237,
    4246,  4255,  4257,  4260,  4290,  4294,  4293,  4315,  4323,  4315,
    4329,  4330,  4331,  4332,  4333,  4336,  4343,  4350,  4352,  4363,
    4364,  4367,  4368,  4374,  4375,  4376,  4377,  4383,  4389,  4395,
    4409,  4412,  4414,  4420,  4430,  4431,  4432,  4445,  4471,  4478,
    4485,  4486,  4489,  4490,  4491,  4492,  4493,  4497,  4498,  4502,
    4551,  4556,  4597,  4599,  4601,  4603,  4605,  4607,  4609,  4611,
    4615,  4617,  4619,  4621,  4623,  4625,  4628,  4632,  4638,  4642,
    4648,  4652,  4662,  4664,  4670,  4673,  4675,  4677,  4678,  4680,
    4683,  4685,  4687,  4689,  4691,  4693,  4695,  4697,  4699,  4701,
    4703,  4705,  4707,  4709,  4711,  4714,  4714,  4715,  4715,  4716,
    4716,  4717,  4717,  4719,  4720,  4721,  4722,  4723,  4724,  4727,
    4728,  4732,  4737,  4738,  4745,  4746,  4747,  4748,  4749,  4751,
    4752,  4753,  4754,  4755,  4759,  4760,  4765,  4770,  4774,  4775,
    4779,  4780,  4784,  4791,  4793,  4799,  4801,  4812,  4814,  4825,
    4836,  4847,  4858,  4860,  4862,  4864,  4866,  4868,  4870,  4872,
    4874,  4876,  4878,  4880,  4882,  4888,  4890,  4892,  4897,  4902,
    4904,  4906,  4911,  4913,  4915,  4917,  4919,  4924,  4925,  4927,
    4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,  4945,  4947,
    4951,  4953,  4963,  4965,  4967,  4969,  4971,  4974,  4983,  4988,
    4993,  4995,  4997,  4999,  5001,  5003,  5005,  5007,  5012,  5017,
    5019,  5021,  5023,  5025,  5027,  5029,  5035,  5037,  5039,  5041,
    5043,  5045,  5047,  5049,  5051,  5052,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5080,  5087,  5089,  5091,  5093,
    5095,  5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,  5113,
    5115,  5130,  5129,  5269,  5273,  5278,  5280,  5282,  5284,  5286,
    5288,  5293,  5295,  5297,  5299,  5301,  5306,  5310,  5312,  5314,
    5316,  5318,  5320,  5324,  5327,  5330,  5332,  5334,  5336,  5338,
    5340,  5342,  5345,  5348,  5350,  5352,  5354,  5356,  5358,  5361,
    5363,  5365,  5367,  5372,  5373,  5374,  5378,  5379,  5383,  5383,
    5389,  5393,  5400,  5431,  5433,  5435,  5437,  5439,  5441,  5443,
    5446,  5448,  5445,  5451,  5453,  5460,  5462,  5464,  5466,  5468,
    5470,  5472,  5474,  5476,  5479,  5478,  5493,  5492,  5507,  5513,
    5519,  5532,  5533,  5537,  5540,  5545,  5548,  5560,  5559,  5575,
    5576,  5577,  5578,  5579,  5580,  5581,  5582,  5583,  5584,  5585,
    5589,  5590,  5594,  5594,  5599,  5600,  5603,  5604,  5607,  5607,
    5612,  5613,  5616,  5617,  5620,  5621,  5624,  5630,  5640,  5641,
    5650,  5655,  5656,  5676,  5678,  5682,  5680,  5697,  5695,  5713,
    5711,  5718,  5727,  5725,  5743,  5742,  5752,  5763,  5761,  5780,
    5779,  5790,  5800,  5801,  5802,  5807,  5807,  5826,  5824,  5843,
    5865,  5913,  5912,  5935,  5953,  5935,  5960,  5964,  5990,  5991,
    5993,  5995,  5998,  5999,  6005,  6012,  6021,  6020,  6027,  6028,
    6032,  6036,  6040,  6046,  6054,  6063,  6064,  6065,  6066,  6067,
    6068,  6069,  6070,  6071,  6072,  6073,  6074,  6075,  6078,  6079,
    6080,  6081,  6082,  6083,  6084,  6085,  6086,  6090,  6091,  6092,
    6093,  6096,  6098,  6099,  6102,  6103,  6106,  6108,  6112,  6114,
    6113,  6127,  6130,  6129,  6144,  6150,  6163,  6165,  6168,  6170,
    6174,  6175,  6188,  6206,  6210,  6211,  6215,  6228,  6230,  6234,
    6233,  6266,  6268,  6272,  6273,  6274,  6279,  6285,  6289,  6290,
    6294,  6298,  6305,  6312,  6321,  6325,  6326,  6327,  6332,  6336,
    6344,  6345,  6346,  6347,  6348,  6349,  6353,  6354,  6355,  6356,
    6357,  6360,  6363,  6362,  6391,  6392,  6395,  6396,  6399,  6414,
    6414,  6425,  6426,  6430,  6442,  6475,  6474,  6487,  6486,  6495,
    6507,  6518,  6517,  6534,  6541,  6541,  6553,  6560,  6576,  6595,
    6607,  6611,  6617,  6627,  6628,  6631,  6639,  6640,  6644,  6645,
    6653,  6662,  6652,  6672,  6679,  6671,  6689,  6701,  6702,  6703,
    6707,  6708,  6711,  6712,  6715,  6724,  6725,  6726,  6728,  6727,
    6737,  6738,  6741,  6742,  6743,  6743,  6744,  6744,  6748,  6749,
    6752,  6754,  6757,  6765,  6766,  6770,  6771,  6776,  6775,  6788,
    6789,  6792,  6797,  6805,  6806,  6809,  6811,  6811,  6819,  6828,
    6818,  6850,  6851,  6854,  6861,  6862,  6865,  6874,  6875,  6881,
    6880,  6894,  6893,  6902,  6901,  6909,  6908,  6918,  6919,  6922,
    6929,  6942,  6943,  6947,  6948,  6951,  6952,  6953,  6956,  6966,
    6968,  6973,  6972,  6986,  6994,  7003,  7012,  7021,  7031,  7030,
    7033,  7043,  7053,  7057,  7062,  7061,  7066,  7076,  7081,  7087,
    7092,  7097,  7099,  7101,  7103,  7105,  7114,  7116,  7118,  7120,
    7129,  7137,  7145,  7147,  7149,  7159,  7166,  7172,  7180,  7188,
    7192,  7196,  7203,  7210,  7220,  7230,  7240,  7253,  7267,  7280,
    7281,  7283,  7285,  7288,  7289,  7292,  7293,  7296,  7297,  7300,
    7301,  7304,  7305,  7307,  7309,  7312,  7324,  7323,  7338,  7337,
    7347,  7348,  7351,  7352,  7356,  7357,  7358,  7366,  7365,  7377,
    7378,  7381,  7381,  7382,  7383,  7384,  7385,  7386,  7387,  7388,
    7389,  7390,  7391,  7394,  7395,  7399,  7398,  7407,  7408,  7411,
    7412,  7413,  7417,  7416,  7426,  7430,  7434,  7446,  7446,  7454,
    7455,  7456,  7461,  7471,  7470,  7486,  7504,  7515,  7522,  7532,
    7503,  7537,  7546,  7547,  7550,  7551,  7563,  7567,  7568,  7569,
    7571,  7573,  7576,  7577,  7580,  7585,  7592,  7597,  7603,  7605,
    7608,  7609,  7612,  7617,  7623,  7625,  7632,  7633,  7634,  7637,
    7639,  7644,  7645,  7650,  7651,  7657,  7675,  7683,  7688,  7707,
    7709,  7720,  7733,  7754,  7755,  7756,  7765,  7766,  7767,  7772,
    7773,  7774,  7775,  7776,  7796,  7815,  7816,  7817,  7820,  7821,
    7822,  7823,  7831,  7846,  7847,  7850,  7856,  7867,  7870,  7907,
    7911,  7919,  7923,  7991,  8006,  8030,  8031,  8047,  8057,  8060,
    8061,  8062,  8066,  8070,  8071,  8096,  8108,  8121,  8133,  8134,
    8143,  8144,  8153,  8154,  8155,  8158,  8171,  8184,  8198,  8199,
    8200,  8201,  8202,  8203,  8204,  8205,  8206,  8207,  8208,  8209,
    8210,  8211,  8212,  8213,  8214,  8215,  8216,  8217,  8218,  8219,
    8220,  8221,  8222,  8223,  8224,  8225,  8226,  8227,  8228,  8229,
    8230,  8231,  8232,  8233,  8234,  8244,  8245,  8246,  8247,  8248,
    8249,  8250,  8251,  8252,  8253,  8254,  8255,  8256,  8257,  8258,
    8259,  8260,  8261,  8262,  8263,  8264,  8265,  8266,  8267,  8268,
    8269,  8270,  8271,  8272,  8273,  8274,  8275,  8276,  8277,  8278,
    8279,  8280,  8281,  8282,  8283,  8284,  8285,  8286,  8287,  8288,
    8289,  8290,  8291,  8292,  8293,  8294,  8295,  8296,  8297,  8298,
    8299,  8300,  8301,  8302,  8303,  8304,  8305,  8306,  8307,  8308,
    8309,  8310,  8311,  8312,  8313,  8314,  8315,  8316,  8317,  8318,
    8319,  8320,  8321,  8322,  8323,  8324,  8325,  8326,  8327,  8328,
    8329,  8330,  8331,  8332,  8333,  8334,  8335,  8336,  8337,  8338,
    8339,  8340,  8341,  8342,  8343,  8344,  8345,  8346,  8347,  8348,
    8349,  8350,  8351,  8352,  8353,  8354,  8355,  8356,  8357,  8358,
    8359,  8360,  8361,  8362,  8363,  8364,  8365,  8366,  8367,  8368,
    8369,  8370,  8371,  8372,  8373,  8374,  8375,  8376,  8377,  8378,
    8379,  8380,  8381,  8382,  8383,  8384,  8385,  8386,  8387,  8388,
    8389,  8390,  8391,  8392,  8393,  8394,  8395,  8396,  8397,  8398,
    8399,  8400,  8401,  8402,  8403,  8404,  8405,  8406,  8407,  8408,
    8409,  8410,  8411,  8412,  8413,  8414,  8415,  8416,  8417,  8418,
    8419,  8420,  8421,  8422,  8423,  8424,  8425,  8426,  8427,  8428,
    8429,  8430,  8431,  8432,  8433,  8434,  8435,  8436,  8437,  8438,
    8439,  8440,  8441,  8442,  8443,  8444,  8445,  8446,  8447,  8448,
    8449,  8450,  8451,  8452,  8453,  8454,  8455,  8456,  8463,  8462,
    8476,  8477,  8480,  8481,  8484,  8484,  8562,  8563,  8564,  8565,
    8569,  8570,  8574,  8575,  8576,  8577,  8581,  8582,  8583,  8584,
    8588,  8589,  8592,  8674,  8687,  8691,  8696,  8703,  8718,  8731,
    8752,  8759,  8797,  8840,  8854,  8855,  8856,  8857,  8861,  8862,
    8869,  8878,  8879,  8880,  8881,  8882,  8890,  8889,  8905,  8906,
    8909,  8910,  8913,  8921,  8922,  8923,  8924,  8929,  8928,  8949,
    8961,  8974,  8973,  8992,  8993,  8997,  8998,  9002,  9003,  9004,
    9005,  9007,  9006,  9017,  9018,  9019,  9020,  9021,  9027,  9032,
    9039,  9052,  9064,  9071,  9076,  9084,  9097,  9111,  9113,  9116,
    9117,  9124,  9126,  9130,  9131,  9134,  9134,  9135,  9135,  9136,
    9136,  9137,  9137,  9138,  9139,  9140,  9141,  9142,  9143,  9144,
    9145,  9146,  9147,  9148,  9149,  9150,  9151,  9152,  9153,  9154,
    9155,  9156,  9157,  9158,  9159,  9160,  9165,  9166,  9170,  9171,
    9175,  9185,  9195,  9208,  9222,  9235,  9248,  9261,  9262,  9271,
    9272,  9281,  9306,  9308,  9315,  9319,  9322,  9323,  9326,  9347,
    9348,  9352,  9356,  9360,  9367,  9368,  9371,  9372,  9376,  9377,
    9383,  9389,  9395,  9405,  9404,  9414,  9415,  9419,  9420,  9421,
    9425,  9426,  9427,  9431,  9432,  9436,  9446,  9453,  9463,  9472,
    9486,  9487,  9492,  9491,  9532,  9533,  9534,  9538,  9538,  9562,
    9563,  9567,  9568,  9569,  9573,  9578,  9583,  9590,  9611,  9633,
    9635,  9637,  9642,  9643,  9644,  9645,  9649,  9650,  9651,  9652,
    9653,  9663,  9664,  9669,  9682,  9695,  9697,  9699,  9704,  9709,
    9711,  9713,  9719,  9720,  9726,  9727,  9729,  9735,  9734,  9749,
    9750,  9754,  9759,  9767,  9767,  9785,  9794,  9807,  9808,  9810,
    9812,  9825,  9823,  9899,  9910,  9928,  9962,  9970,  9978,  9990,
    9924, 10023, 10054, 10063, 10072, 10022, 10096, 10100, 10104, 10108,
   10112, 10116, 10122, 10129, 10136, 10145, 10146, 10150, 10151, 10152,
   10156, 10157, 10161, 10162, 10162, 10167, 10168
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "sp_a_chistics", "sp_c_chistics", "sp_chistic", "sp_c_chistic",
  "sp_suid", "call", "@8", "opt_sp_cparam_list", "opt_sp_cparams",
  "sp_cparams", "sp_fdparam_list", "sp_fdparams", "sp_init_param",
  "sp_fdparam", "sp_pdparam_list", "sp_pdparams", "sp_pdparam",
  "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1", "sp_decls", "sp_decl",
  "@9", "@10", "sp_cursor_stmt", "@11", "sp_handler_type", "sp_hcond_list",
  "sp_hcond_element", "sp_cond", "opt_value", "sp_hcond", "sp_decl_idents",
  "sp_opt_default", "sp_proc_stmt", "@12", "@13", "@14", "@15", "@16",
  "sp_opt_fetch_noise", "sp_fetch_list", "sp_if", "@17", "@18", "@19",
  "sp_elseifs", "case_stmt_specification", "simple_case_stmt", "@20",
  "@21", "searched_case_stmt", "@22", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@23", "@24",
  "searched_when_clause", "@25", "@26", "else_clause_opt",
  "sp_labeled_control", "@27", "sp_opt_label", "sp_labeled_block", "@28",
  "sp_unlabeled_block", "@29", "sp_block_content", "@30",
  "sp_unlabeled_control", "@31", "@32", "@33", "trg_action_time",
  "trg_event", "create2", "create2a", "@34", "create3", "@35", "@36",
  "create_select", "@37", "@38", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_type", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "@39",
  "type", "@40", "@41", "spatial_type", "char", "nchar", "varchar",
  "nvarchar", "int_type", "real_type", "float_options", "precision",
  "field_options", "field_opt_list", "field_option", "opt_len",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@42", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@43", "@44", "@45", "@46",
  "@47", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@48", "@49", "@50", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@51", "@52", "start",
  "start_transaction_opts", "slave_thread_opts", "@53",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@54", "backup", "@55", "checksum", "@56",
  "opt_checksum_type", "repair", "@57", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@58", "check", "@59",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@60", "opt_no_write_to_binlog", "rename", "@61", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@62", "preload_list",
  "preload_keys", "cache_keys_spec", "@63", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@64", "select_part2", "@65", "@66", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@67",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@68", "udf_expr_list3", "udf_expr", "sum_expr", "@69",
  "@70", "@71", "variable", "@72", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@73",
  "cast_type", "opt_expr_list", "expr_list", "@74", "expr_list2",
  "ident_list_arg", "ident_list", "@75", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@76", "@77", "@78", "@79", "@80",
  "@81", "@82", "normal_join", "table_factor", "@83", "@84",
  "select_derived", "@85", "select_derived2", "@86", "@87",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@88", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@89", "having_clause", "@90", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@91", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@92", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@93",
  "select_var_list", "select_var_ident", "into", "@94", "into_destination",
  "@95", "do", "@96", "drop", "@97", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@98", "@99", "replace", "@100",
  "@101", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@102", "fields", "insert_values",
  "@103", "@104", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@105", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@106", "update", "@107", "@108",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@109", "single_multi", "@110", "@111",
  "@112", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@113", "show_param", "@114", "@115", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@116", "@117",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@118", "flush_options", "flush_option", "@119",
  "opt_table_list", "reset", "@120", "reset_options", "reset_option",
  "purge", "@121", "purge_options", "purge_option", "kill", "@122",
  "kill_option", "use", "load", "@123", "load_data", "@124", "@125",
  "@126", "@127", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@128", "opt_option", "option_value_list", "option_type_value",
  "@129", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@130",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@131", "handler", "@132", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@133",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@134", "@135", "@136",
  "@137", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@138", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@139",
  "union_opt", "union_order_or_limit", "@140", "order_or_limit",
  "union_option", "take_first_select", "subselect", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "definer_tail",
  "no_definer_tail", "definer_opt", "no_definer", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@141", "view_list_opt",
  "view_list", "view_select", "@142", "view_select_aux",
  "view_check_option", "trigger_tail", "@143", "udf_tail", "sf_tail",
  "@144", "@145", "@146", "@147", "@148", "sp_tail", "@149", "@150",
  "@151", "@152", "xa", "xid", "begin_or_start", "opt_join_or_resume",
  "opt_one_phase", "opt_suspend", "@153", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   597,   598,   598,   599,   599,   599,   599,   599,   599,
     599,   600,   600,   600,   601,   601,   603,   602,   604,   604,
     605,   605,   606,   606,   607,   607,   608,   608,   609,   610,
     611,   611,   612,   612,   613,   614,   614,   614,   614,   615,
     615,   616,   616,   617,   617,   619,   618,   618,   620,   618,
     618,   622,   621,   623,   623,   624,   624,   625,   626,   626,
     627,   627,   628,   628,   628,   628,   628,   629,   629,   630,
     630,   632,   631,   633,   631,   634,   631,   631,   631,   635,
     631,   631,   631,   631,   631,   631,   636,   631,   631,   637,
     637,   637,   638,   638,   640,   641,   642,   639,   643,   643,
     643,   644,   644,   646,   647,   645,   649,   648,   650,   650,
     651,   651,   653,   654,   652,   656,   657,   655,   658,   658,
     660,   659,   661,   661,   663,   662,   665,   664,   667,   666,
     668,   669,   670,   668,   671,   668,   672,   672,   673,   673,
     673,   674,   674,   674,   674,   675,   676,   675,   677,   678,
     677,   679,   677,   681,   682,   680,   683,   683,   684,   684,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   690,
     690,   691,   691,   692,   692,   693,   693,   693,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   695,   696,   697,   698,   698,   698,   698,   698,   698,
     699,   699,   699,   700,   700,   700,   701,   701,   702,   702,
     702,   702,   703,   703,   704,   704,   705,   705,   706,   706,
     706,   706,   706,   707,   707,   708,   709,   709,   710,   712,
     711,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   714,   713,   715,   713,
     713,   713,   716,   716,   716,   716,   716,   716,   716,   716,
     717,   718,   718,   719,   719,   720,   720,   720,   720,   720,
     721,   721,   721,   721,   721,   722,   722,   722,   723,   723,
     723,   724,   725,   725,   726,   726,   727,   727,   727,   728,
     728,   729,   729,   730,   730,   731,   731,   732,   732,   732,
     732,   732,   732,   732,   732,   732,   732,   732,   733,   733,
     734,   734,   735,   735,   736,   736,   737,   737,   738,   738,
     739,   739,   740,   741,   741,   742,   742,   743,   743,   744,
     744,   744,   744,   744,   744,   745,   745,   746,   746,   746,
     746,   747,   747,   749,   748,   750,   750,   751,   751,   752,
     752,   753,   753,   754,   754,   754,   754,   754,   755,   755,
     755,   755,   755,   756,   756,   756,   757,   757,   758,   758,
     759,   759,   760,   760,   760,   761,   761,   761,   761,   762,
     762,   762,   763,   763,   763,   764,   764,   765,   765,   766,
     766,   767,   767,   768,   768,   770,   769,   771,   769,   772,
     769,   773,   769,   774,   769,   775,   775,   776,   776,   776,
     776,   776,   777,   778,   778,   778,   779,   778,   780,   781,
     778,   778,   778,   778,   778,   778,   778,   778,   778,   778,
     778,   778,   778,   778,   782,   782,   783,   783,   784,   784,
     784,   785,   785,   785,   786,   786,   786,   786,   788,   787,
     787,   789,   787,   787,   790,   791,   791,   793,   792,   794,
     794,   795,   795,   795,   796,   796,   797,   797,   799,   798,
     801,   800,   803,   802,   804,   804,   804,   806,   805,   807,
     807,   808,   808,   809,   809,   809,   811,   810,   813,   812,
     814,   814,   815,   815,   816,   816,   816,   816,   816,   816,
     818,   817,   819,   819,   819,   821,   820,   820,   822,   822,
     823,   823,   824,   825,   826,   826,   827,   828,   828,   830,
     829,   831,   831,   832,   834,   833,   835,   835,   836,   836,
     837,   838,   838,   839,   839,   841,   840,   843,   844,   842,
     845,   845,   845,   845,   845,   846,   846,   847,   847,   848,
     848,   849,   849,   849,   849,   849,   849,   849,   849,   849,
     849,   850,   850,   850,   851,   851,   851,   852,   853,   854,
     855,   855,   856,   856,   856,   856,   856,   857,   857,   858,
     858,   858,   858,   858,   858,   858,   858,   858,   858,   858,
     859,   859,   859,   859,   859,   859,   860,   860,   860,   860,
     860,   860,   860,   860,   860,   860,   860,   860,   860,   860,
     861,   861,   861,   861,   861,   861,   861,   861,   861,   861,
     861,   861,   861,   861,   861,   862,   862,   863,   863,   864,
     864,   865,   865,   866,   866,   866,   866,   866,   866,   867,
     867,   868,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   870,   869,   869,   869,   869,   869,   869,   869,   869,
     869,   869,   869,   869,   869,   869,   869,   871,   871,   871,
     871,   871,   871,   871,   871,   871,   871,   871,   871,   871,
     871,   871,   871,   871,   871,   871,   871,   871,   871,   871,
     871,   871,   871,   872,   872,   872,   873,   873,   875,   874,
     876,   876,   877,   878,   878,   878,   878,   878,   878,   878,
     879,   880,   878,   878,   878,   878,   878,   878,   878,   878,
     878,   878,   878,   878,   881,   878,   883,   882,   884,   884,
     884,   885,   885,   886,   886,   887,   887,   889,   888,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     891,   891,   893,   892,   894,   894,   895,   895,   897,   896,
     898,   898,   899,   899,   900,   900,   901,   901,   902,   902,
     903,   904,   904,   905,   905,   906,   905,   907,   905,   908,
     905,   905,   909,   905,   910,   905,   905,   911,   905,   912,
     905,   905,   913,   913,   913,   915,   914,   916,   914,   914,
     914,   918,   917,   920,   921,   919,   922,   923,   924,   924,
     925,   925,   926,   926,   926,   926,   928,   927,   929,   929,
     930,   930,   930,   931,   931,   932,   932,   932,   932,   932,
     932,   932,   932,   932,   932,   932,   932,   932,   933,   933,
     933,   933,   933,   933,   933,   933,   933,   934,   934,   934,
     934,   935,   935,   935,   936,   936,   937,   937,   938,   939,
     938,   940,   941,   940,   942,   942,   943,   943,   944,   944,
     945,   945,   945,   946,   947,   947,   948,   949,   949,   951,
     950,   952,   952,   953,   953,   953,   954,   954,   955,   955,
     956,   957,   957,   957,   958,   958,   958,   958,   959,   959,
     960,   960,   960,   960,   960,   960,   961,   961,   961,   961,
     961,   962,   963,   962,   964,   964,   965,   965,   966,   968,
     967,   969,   969,   970,   970,   972,   971,   974,   973,   973,
     973,   976,   975,   977,   978,   977,   977,   977,   977,   977,
     977,   977,   977,   979,   979,   980,   981,   981,   982,   982,
     984,   985,   983,   987,   988,   986,   989,   989,   989,   989,
     990,   990,   991,   991,   992,   993,   993,   993,   994,   993,
     995,   995,   996,   996,   997,   996,   998,   996,   999,   999,
    1000,  1000,  1001,  1002,  1002,  1003,  1003,  1005,  1004,  1006,
    1006,  1007,  1007,  1008,  1008,  1009,  1010,  1009,  1012,  1013,
    1011,  1014,  1014,  1015,  1016,  1016,  1017,  1018,  1018,  1020,
    1019,  1022,  1021,  1023,  1021,  1024,  1021,  1025,  1025,  1026,
    1026,  1027,  1027,  1028,  1028,  1029,  1029,  1029,  1030,  1031,
    1031,  1033,  1032,  1034,  1034,  1034,  1034,  1034,  1035,  1034,
    1034,  1034,  1034,  1034,  1036,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,  1034,
    1034,  1034,  1034,  1034,  1034,  1034,  1034,  1037,  1037,  1038,
    1038,  1039,  1039,  1040,  1040,  1041,  1041,  1042,  1042,  1043,
    1043,  1044,  1044,  1045,  1045,  1045,  1047,  1046,  1048,  1046,
    1049,  1049,  1050,  1050,  1051,  1051,  1051,  1053,  1052,  1054,
    1054,  1056,  1055,  1055,  1055,  1055,  1055,  1055,  1055,  1055,
    1055,  1055,  1055,  1057,  1057,  1059,  1058,  1060,  1060,  1061,
    1061,  1061,  1063,  1062,  1064,  1065,  1065,  1067,  1066,  1068,
    1068,  1068,  1069,  1071,  1070,  1070,  1073,  1074,  1075,  1076,
    1072,  1072,  1077,  1077,  1078,  1078,  1078,  1079,  1079,  1079,
    1080,  1080,  1081,  1081,  1082,  1082,  1082,  1082,  1083,  1083,
    1084,  1084,  1085,  1085,  1086,  1086,  1087,  1087,  1087,  1088,
    1088,  1089,  1089,  1090,  1090,  1091,  1091,  1091,  1091,  1092,
    1092,  1092,  1093,  1094,  1094,  1094,  1095,  1095,  1095,  1095,
    1095,  1095,  1095,  1095,  1095,  1095,  1095,  1095,  1096,  1096,
    1096,  1096,  1096,  1097,  1097,  1098,  1098,  1099,  1100,  1100,
    1101,  1101,  1102,  1102,  1102,  1103,  1103,  1103,  1103,  1104,
    1104,  1104,  1105,  1106,  1106,  1107,  1108,  1109,  1110,  1110,
    1111,  1111,  1112,  1112,  1112,  1113,  1113,  1113,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,
    1115,  1115,  1115,  1115,  1115,  1115,  1115,  1115,  1117,  1116,
    1118,  1118,  1119,  1119,  1121,  1120,  1122,  1122,  1122,  1122,
    1123,  1123,  1124,  1124,  1124,  1124,  1125,  1125,  1125,  1125,
    1126,  1126,  1127,  1127,  1128,  1128,  1128,  1128,  1128,  1128,
    1128,  1129,  1129,  1129,  1130,  1130,  1130,  1130,  1131,  1131,
    1131,  1132,  1132,  1132,  1132,  1132,  1134,  1133,  1135,  1135,
    1136,  1136,  1137,  1138,  1138,  1138,  1138,  1140,  1139,  1141,
    1141,  1142,  1141,  1143,  1143,  1144,  1144,  1145,  1145,  1145,
    1145,  1146,  1145,  1147,  1147,  1147,  1147,  1147,  1148,  1149,
    1149,  1149,  1149,  1150,  1151,  1151,  1151,  1152,  1152,  1153,
    1153,  1154,  1154,  1155,  1155,  1157,  1156,  1158,  1156,  1159,
    1156,  1160,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,  1156,
    1156,  1156,  1156,  1156,  1156,  1156,  1161,  1161,  1162,  1162,
    1163,  1163,  1163,  1164,  1164,  1164,  1164,  1165,  1165,  1166,
    1166,  1167,  1167,  1167,  1168,  1168,  1169,  1169,  1170,  1171,
    1171,  1171,  1171,  1171,  1172,  1172,  1173,  1173,  1174,  1174,
    1174,  1174,  1174,  1176,  1175,  1177,  1177,  1178,  1178,  1178,
    1179,  1179,  1179,  1180,  1180,  1181,  1182,  1182,  1183,  1184,
    1185,  1185,  1187,  1186,  1188,  1188,  1188,  1190,  1189,  1191,
    1191,  1192,  1192,  1192,  1193,  1194,  1194,  1195,  1196,  1197,
    1197,  1197,  1198,  1198,  1198,  1198,  1199,  1199,  1199,  1199,
    1199,  1200,  1200,  1201,  1202,  1203,  1203,  1203,  1204,  1205,
    1205,  1205,  1206,  1206,  1207,  1207,  1207,  1209,  1208,  1210,
    1210,  1211,  1211,  1213,  1212,  1214,  1214,  1215,  1215,  1215,
    1215,  1217,  1216,  1218,  1218,  1220,  1221,  1222,  1223,  1224,
    1219,  1226,  1227,  1228,  1229,  1225,  1230,  1230,  1230,  1230,
    1230,  1230,  1231,  1231,  1231,  1232,  1232,  1233,  1233,  1233,
    1234,  1234,  1235,  1236,  1235,  1237,  1237
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       0,     2,     0,     2,     2,     2,     2,     2,     3,     3,
       1,     1,     1,     2,     3,     3,     0,     4,     0,     3,
       0,     1,     3,     1,     0,     1,     3,     1,     0,     3,
       0,     1,     3,     1,     4,     0,     1,     1,     1,     0,
       3,     2,     3,     0,     3,     0,     5,     5,     0,     7,
       5,     0,     2,     1,     1,     1,     3,     1,     1,     3,
       0,     1,     1,     1,     1,     2,     1,     1,     3,     0,
       2,     0,     2,     0,     3,     0,     5,     1,     1,     0,
       2,     1,     1,     2,     2,     2,     0,     6,     2,     0,
       2,     1,     1,     3,     0,     0,     0,     7,     0,     2,
       2,     1,     1,     0,     0,     8,     0,     6,     1,     2,
       1,     2,     0,     0,     6,     0,     0,     6,     0,     2,
       0,     5,     0,     1,     0,     5,     0,     2,     0,     5,
       4,     0,     0,     8,     0,     7,     1,     1,     1,     1,
       1,     2,     2,     2,     4,     4,     0,     4,     0,     0,
       5,     0,     7,     0,     0,     6,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     1,     1,     3,     4,     4,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     6,     7,
       8,     2,     2,     0,     1,     2,     0,     1,     2,     0,
       4,     3,     3,     3,     1,     4,     1,     1,     5,     2,
       5,     2,     4,     1,     5,     5,     4,     3,     1,     1,
       2,     1,     1,     2,     1,     1,     1,     2,     3,     2,
       3,     2,     2,     3,     3,     3,     0,     6,     0,     6,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     2,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     3,
       1,     5,     0,     1,     2,     1,     1,     1,     1,     0,
       3,     0,     1,     0,     1,     2,     1,     1,     2,     2,
       4,     1,     3,     2,     1,     2,     2,     2,     2,     1,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     0,
       2,     1,     2,     3,     2,     0,     1,     0,     1,     1,
       2,     0,     1,     0,     4,     1,     4,     3,     1,     0,
       1,     2,     1,     3,     3,     2,     2,     2,     1,     1,
       2,     2,     2,     1,     2,     2,     2,     2,     1,     1,
       0,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       2,     2,     1,     1,     1,     4,     2,     1,     4,     0,
       1,     0,     2,     1,     3,     0,     6,     0,     5,     0,
       5,     0,     5,     0,    11,     0,     1,     0,     2,     2,
       1,     3,     2,     3,     2,     4,     0,     6,     0,     0,
       8,     4,     4,     3,     3,     2,     2,     6,     5,     3,
       5,     1,     1,     1,     0,     1,     0,     1,     0,     1,
       1,     0,     2,     1,     0,     1,     1,     1,     0,     5,
       3,     0,     5,     3,     3,     0,     3,     0,     2,     1,
       3,     0,     1,     1,     0,     2,     1,     3,     0,     6,
       0,     6,     0,     5,     0,     1,     1,     0,     6,     0,
       1,     1,     2,     1,     1,     1,     0,     5,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     5,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     5,     1,     3,     2,     1,     1,     0,
       6,     1,     3,     3,     0,     2,     0,     4,     0,     2,
       1,     2,     4,     2,     3,     0,     3,     0,     0,     6,
       2,     1,     1,     2,     2,     8,     4,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     4,     3,     1,     1,     4,     0,     0,
       1,     1,     0,     2,     2,     1,     1,     0,     2,     3,
       3,     3,     2,     3,     4,     3,     4,     3,     4,     1,
       3,     4,     3,     3,     6,     1,     5,     6,     5,     7,
       6,     8,     5,     6,     4,     4,     5,     3,     4,     1,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     3,
       3,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     1,     1,     1,     1,     3,     2,
       2,     2,     2,     3,     3,     5,     6,     4,     4,     7,
       4,     2,     6,     5,     6,     6,     4,     4,     3,     4,
       6,     8,     6,     8,     6,     4,     6,     4,     6,     4,
       4,     4,     4,     6,     8,     2,     2,     4,     2,     7,
       7,     3,     4,     4,     6,     6,     4,     6,     6,     6,
       4,     6,     4,     6,     8,    10,    12,     6,     4,     6,
       6,     1,     6,     4,     8,    10,     4,     1,     3,     4,
       6,     6,     8,     6,     6,     4,     6,     6,     8,     4,
       4,     6,     4,     2,     4,     4,     4,     6,     4,     4,
       3,     8,     6,     4,     6,     3,     6,     8,     4,     8,
       6,     8,     6,     8,     2,     4,     4,     4,     6,     8,
       8,     4,     7,     7,     7,     6,     6,     6,     6,     6,
       6,     0,     5,    10,     3,     4,     3,     2,     2,     2,
       4,     6,     4,     4,     6,     6,     6,     6,     4,     6,
       4,     6,     4,     4,     4,     4,     6,     4,     6,     4,
       6,     4,     4,     6,     4,     6,     4,     6,     4,     4,
       6,     4,     6,     0,     3,     3,     0,     1,     0,     2,
       1,     3,     4,     4,     5,     4,     4,     4,     5,     4,
       0,     0,     7,    10,     4,     5,     4,     5,     4,     4,
       4,     4,     4,     5,     0,     8,     0,     3,     3,     1,
       4,     0,     1,     0,     2,     0,     1,     0,     3,     2,
       3,     2,     1,     2,     1,     2,     1,     1,     1,     2,
       0,     1,     0,     2,     1,     3,     1,     3,     0,     2,
       1,     3,     0,     1,     0,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     3,     0,     6,     0,     6,     0,
       8,     4,     0,     8,     0,    10,     6,     0,     8,     0,
      10,     6,     1,     2,     2,     0,     4,     0,    11,     3,
       6,     0,     3,     0,     0,     5,     0,     1,     0,     1,
       0,     2,     0,     2,     2,     2,     0,     6,     0,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     2,     2,     3,     3,     1,     2,     0,     1,     0,
       4,     4,     2,     0,     1,     1,     0,     1,     0,     1,
       2,     1,     3,     3,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     2,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     5,     2,
       1,     0,     3,     6,     0,     6,     4,     6,     4,     4,
       4,     5,     4,     1,     3,     1,     0,     2,     0,     1,
       0,     0,     8,     0,     0,     6,     0,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     3,     4,     0,     3,
       3,     1,     2,     2,     0,     3,     0,     5,     3,     1,
       3,     1,     3,     1,     1,     0,     1,     0,     4,     0,
       1,     3,     1,     1,     1,     0,     0,     6,     0,     0,
      11,     3,     1,     3,     3,     1,     3,     0,     1,     0,
       4,     0,     6,     0,     5,     0,     6,     1,     3,     3,
       5,     0,     2,     0,     2,     1,     1,     1,     3,     0,
       1,     0,     3,     2,     4,     4,     4,     4,     0,     4,
       6,    16,     2,     2,     0,     6,     5,     2,     2,     2,
       1,     5,     5,     2,     2,     3,     2,     2,     2,     3,
       2,     2,     2,     1,     1,     3,     4,     3,     3,     2,
       2,     3,     3,     3,     3,     3,     3,     1,     1,     1,
       1,     0,     1,     0,     2,     0,     1,     1,     1,     0,
       2,     0,     2,     0,     2,     2,     0,     4,     0,     4,
       1,     1,     0,     1,     0,     1,     1,     0,     4,     3,
       1,     0,     3,     4,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     0,     3,     3,     1,     1,
       1,     2,     0,     3,     3,     2,     2,     0,     4,     0,
       1,     1,     2,     0,     4,     5,     0,     0,     0,     0,
      18,     2,     0,     1,     0,     1,     1,     0,     1,     1,
       0,     2,     2,     1,     3,     4,     3,     3,     0,     2,
       2,     1,     3,     3,     0,     3,     0,     3,     2,     3,
       1,     1,     2,     0,     2,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     3,     5,     1,     1,     1,
       1,     1,     3,     4,     5,     1,     5,     3,     2,     1,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     3,     8,     8,     8,     0,     1,     1,
       2,     0,     1,     1,     3,     0,     3,     0,     3,     0,
       3,     0,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     2,     0,     1,     3,     1,
       2,     2,     2,     1,     3,     3,     1,     1,     3,     1,
       3,     4,     5,     1,     0,     3,     3,     1,     1,     0,
       2,     2,     2,     2,     0,     2,     2,     1,     2,     2,
       2,     2,     2,     0,     3,     0,     1,     0,     3,     2,
       0,     1,     2,     0,     1,     4,     4,     5,     2,     3,
       0,     1,     0,     4,     0,     1,     1,     0,     2,     2,
       1,     0,     1,     1,     0,     5,     6,     0,     0,     2,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     2,     1,     2,     3,
       3,     3,     0,     1,     0,     3,     3,     0,     8,     0,
       3,     1,     3,     0,     2,     3,     5,     0,     3,     4,
       4,     0,    14,     8,     7,     0,     0,     0,     0,     0,
      15,     0,     0,     0,     0,    12,     4,     4,     3,     4,
       3,     2,     1,     3,     5,     1,     1,     0,     1,     1,
       0,     2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1972,   632,     0,  1913,     0,     0,     0,     0,
       0,  1915,    94,    54,  1259,  1350,  1351,  1181,  1198,     0,
     632,    97,     0,    66,  1200,  1387,     0,     0,   632,     0,
    1382,     0,     0,   632,  1203,  1375,     0,    97,  1915,     0,
     667,  1750,  1281,     0,     0,     0,  1279,  1807,  1248,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   660,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1352,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   535,     0,   567,
       0,     0,  1973,  1963,   634,   633,     0,  1799,  1798,   600,
    1915,     0,  1535,  1536,  1537,  1538,  1539,  1540,  1541,  1499,
    1542,  1543,  1544,  1500,  1501,  1545,  1546,  1547,  1549,  1548,
    1550,  1502,  1503,  1551,  1552,  1553,  1504,  1505,  1554,  1555,
    1506,  1556,  1557,  1558,  1507,  1559,  1508,  1560,  1561,  1562,
    1563,  1564,  1509,  1565,  1566,  1567,  1568,  1569,  1510,  1570,
    1571,  1572,  1573,  1588,  1574,  1511,  1575,  1576,  1577,  1589,
    1512,  1580,  1579,  1578,  1581,  1582,  1583,  1513,  1584,  1585,
    1586,  1591,  1592,  1593,  1514,  1587,  1594,  1590,  1733,  1596,
    1595,  1597,  1599,  1598,  1515,  1600,  1516,  1601,  1602,  1483,
    1603,  1484,  1605,  1606,  1609,  1610,  1604,  1607,  1608,  1517,
    1612,  1613,  1614,  1615,  1616,  1617,  1618,  1628,  1621,  1623,
    1624,  1626,  1622,  1627,  1631,  1630,  1632,  1633,  1634,  1629,
    1620,  1625,  1635,  1636,  1619,  1637,  1638,  1639,  1640,  1641,
    1642,  1643,  1644,  1646,  1645,  1647,  1648,  1649,  1650,  1651,
    1653,  1652,  1654,  1655,  1656,  1658,  1657,  1659,  1518,  1660,
    1661,  1662,  1663,  1664,  1519,  1665,  1666,  1667,  1668,  1669,
    1670,  1520,  1671,  1672,  1673,  1674,  1675,  1676,  1677,  1678,
    1679,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1611,  1687,
    1521,  1688,  1689,  1522,  1690,  1523,  1691,  1692,  1524,  1693,
    1694,  1695,  1696,  1697,  1698,  1525,  1699,  1526,  1701,  1700,
    1702,  1704,  1705,  1527,  1703,  1528,  1706,  1707,  1709,  1708,
    1710,  1711,  1529,  1712,  1530,  1713,  1714,  1715,  1716,  1717,
    1718,  1719,  1720,  1721,  1722,  1723,  1726,  1727,  1728,  1729,
    1724,  1725,  1531,  1730,  1731,  1732,  1734,  1735,  1532,  1736,
    1737,  1534,  1738,  1739,  1742,  1740,  1741,  1743,  1744,  1745,
    1746,  1533,  1747,   116,  1488,    99,  1489,  1498,     0,   602,
     618,  1916,  1917,   269,   507,   508,   268,   506,    97,  1963,
       0,   265,   266,     0,  1273,  1002,  1196,  1196,     0,  1196,
    1199,  1196,    97,  1196,     0,    59,  1357,     0,     0,     0,
       0,  1482,     0,  1206,  1389,  1393,     0,     0,  1796,     0,
       0,     0,     0,    97,   635,     0,  1257,     0,   598,     0,
    1917,  1928,   661,   665,   677,  1751,  1748,  1335,   587,   587,
     587,   585,   587,  1280,     0,     0,  1257,  1392,  2015,     0,
       0,     0,  2011,     0,  2016,     0,   667,     0,     0,     1,
       3,     0,  1585,  1348,  1346,  1479,     0,   527,   536,   531,
     529,     0,     0,  1974,  1961,  1962,   616,     0,  1914,     0,
     644,   654,   118,     0,    68,     0,     0,     0,  1920,     0,
       0,     0,     0,    95,   698,   698,  1963,  1965,  1967,   269,
     267,     0,  1277,  1276,  1275,     0,  1273,  1182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1196,    61,     0,
    1841,  1856,  1857,  1853,  1858,  1859,  1863,     0,  1855,  1847,
       0,  1862,  1851,  1860,     0,  1845,     0,  1861,  1866,  1849,
    1854,  1833,     0,  1839,  1843,  1481,  1101,  1810,  1811,     0,
    1494,  1485,  1493,  1492,    67,  1208,  1209,  1207,   566,  1390,
    1391,     0,  1404,     0,     0,     0,   630,     0,  1330,  1329,
       0,  1383,  1929,     0,     0,   607,  1211,  1258,     0,  1210,
    1380,     0,  1379,  1376,  1378,     0,  1841,  1828,     0,  1923,
    1920,  1930,   690,   683,   682,   685,   686,   689,   687,   688,
     684,   681,   698,   678,   680,  1754,     0,     0,   441,     0,
    1343,     0,     0,     0,  1343,     0,  1136,  1336,     0,  1763,
    1314,   504,   503,     0,   502,  1764,  1313,  1329,     0,     0,
       0,  1300,     0,  1765,     0,  1332,     0,  1136,  1343,     0,
    1282,     0,     0,     0,     0,   581,   591,   583,   578,     0,
     584,   580,  1278,  1195,  1808,   566,  1441,  1440,  1486,  2012,
    1439,  2020,  2022,  2008,  2010,  2017,   663,     0,  1934,    53,
       0,  1354,  1970,  1971,  1969,   457,   100,   100,   525,     0,
       0,     0,     0,     0,  1193,     0,     0,   646,   656,   120,
     117,    98,     0,   604,   620,  1919,     0,     0,  1921,  1925,
     760,   759,     0,    92,   707,  1495,  1893,    96,  1889,  1968,
     698,   698,   698,     0,  1950,     0,  1956,  1957,  1960,  1959,
    1958,     0,  1949,  1952,  1953,  1955,  1954,  1974,  1966,     0,
     509,     0,  1260,  1263,  1267,  1271,  1274,  1536,  1499,     0,
    1544,     0,     0,  1452,     0,     0,     0,     0,  1504,     0,
       0,  1557,     0,     0,  1509,     0,     0,     0,   707,   707,
     707,     0,     0,     0,  1568,  1569,  1461,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1449,     0,  1462,
       0,     0,     0,     0,     0,     0,     0,  1596,     0,     0,
    1597,     0,     0,     0,  1451,  1602,     0,     0,     0,     0,
       0,     0,     0,  1615,     0,     0,  1459,     0,     0,  1008,
       0,  1641,  1643,     0,     0,     0,  1647,     0,     0,  1648,
    1649,  1650,  1436,   762,     0,   707,  1448,  1458,  1662,  1667,
    1442,     0,  1669,     0,  1670,     0,  1675,     0,     0,     0,
       0,     0,     0,  1697,  1699,     0,     0,  1715,     0,     0,
       0,   707,  1435,  1726,  1727,  1728,  1729,     0,  1450,  1531,
    1460,     0,     0,     0,  1738,   707,   707,   707,     0,     0,
       0,  1744,     0,  1747,  1012,     0,     0,     0,     0,   761,
       0,   976,     0,  1004,   719,   725,   739,     0,   847,   754,
     841,   777,   776,  1003,  1446,   775,   774,  1447,   772,  1469,
    1488,  1468,  1197,  1186,  1188,     0,  1189,  1192,  1887,  1190,
     568,     0,     0,    60,  1371,  1365,  1367,  1370,  1366,     0,
    1372,  1369,  1368,  1799,  1358,  1360,  1361,  1842,  1840,  1874,
    1873,     0,  1875,  1871,  1864,  1894,  1868,  1894,  1870,  1869,
    1894,  1865,  1872,  1894,  1837,     0,  1102,  1103,     0,  1809,
       0,  1480,     0,  1388,  1405,     0,  1406,  1394,  1402,   649,
       0,  1101,  1797,  1800,     0,     0,    56,    57,     0,   637,
       0,   636,   640,     0,     0,     0,  1214,  1204,  1213,  1381,
       0,     0,  1840,  1837,  1924,     0,  1926,  1941,   666,  1931,
     696,   668,   695,     0,   679,  1749,  1752,  1760,  1312,  1339,
     440,     0,     0,  1311,  1297,     0,   269,     0,     0,     0,
       0,  1283,  1288,   303,     0,  1304,  1137,     0,  1343,     0,
    1306,  1319,  1307,     0,  1333,     0,  1343,  1293,  1320,  1333,
    1298,  1303,  1310,  1337,  1338,     0,  1292,  1299,     0,  1308,
    1333,  1333,  1343,  1343,   594,   593,   592,   588,   589,   594,
       0,  1045,     0,     0,  2009,  2023,  2007,  2018,  2019,  2006,
     664,  1935,   662,  1936,     0,  1349,  1347,  1355,  1356,   458,
     457,   260,   263,   262,     0,   532,   530,   457,  1964,     0,
       0,   617,     0,     0,   648,   643,   647,   645,   499,   498,
     501,     0,   655,     0,   121,   123,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    69,    70,    83,   606,   605,   603,   628,   627,   625,
       0,   626,   624,   619,   621,   622,  1918,  1922,   270,   457,
       0,  1497,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1951,    88,     0,     0,     0,  1265,  1261,  1271,     0,
       0,     0,  1101,     0,     0,     0,  1106,     0,   791,  1106,
    1106,  1106,     0,     0,  1002,  1002,     0,  1002,     0,     0,
       0,     0,  1106,   815,   818,     0,   816,     0,     0,     0,
       0,     0,  1455,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1002,     0,     0,     0,     0,   981,     0,     0,
       0,     0,   771,     0,     0,     0,     0,  1002,     0,     0,
       0,     0,  1008,     0,  1006,     0,  1106,     0,     0,  1106,
       0,     0,     0,     0,     0,  1002,  1002,  1002,   712,     0,
     863,     0,     0,     0,     0,     0,  1002,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1106,  1106,     0,
       0,     0,  1106,     0,   884,     0,  1457,     0,     0,     0,
    1456,     0,     0,  1454,  1453,  1437,     0,     0,     0,   907,
     909,   908,  1106,     0,  1106,     0,     0,     0,  1013,     0,
     780,   779,   781,  1947,     0,     0,     0,     0,     0,     0,
     758,   757,   756,   755,     0,     0,     0,   763,     0,   764,
     765,     0,   766,   767,   768,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   782,  1076,  1077,  1078,  1079,  1088,
    1091,  1080,  1081,  1082,  1090,  1083,  1084,  1085,  1092,  1093,
    1094,  1086,  1095,  1089,  1087,  1096,     0,  1075,     0,     0,
       0,  1438,   901,     0,     0,  1184,     0,   570,   569,  1191,
     568,     0,    62,    64,  1364,     0,     0,  1373,  1867,     0,
    1848,  1852,  1846,  1850,     0,     0,  1838,     0,  1844,  1105,
    1592,  1657,     0,  1108,  1813,  1201,  1401,  1403,     0,     0,
    1395,     0,     0,   631,    58,     0,     0,  1384,     0,     0,
       0,     0,   609,  1212,     0,  1377,     0,     0,     0,     0,
       0,  1927,  1943,  1942,  1932,   698,  1127,   699,   701,   700,
    1468,  1754,  1757,  1758,  1761,  1759,     0,  1756,  1755,  1770,
       0,  1341,  1344,  1345,     0,     0,  1322,  1321,  1317,  1318,
       0,  1146,  1147,  1145,  1140,  1141,  1144,  1326,  1324,  1315,
       0,  1343,     0,  1325,  1323,  1343,  1333,     0,  1343,  1343,
    1305,  1309,     0,   582,   591,   579,   586,  1057,  1056,     0,
    1021,     0,  1020,  1019,  1018,     0,  1056,  2013,  2021,  2025,
       0,  1136,  1940,  1938,   261,  1235,  1235,     0,     0,     0,
       0,     0,     0,     0,   101,   110,   564,   564,  1235,  1235,
     564,  1235,  1235,  1235,     0,     0,  1235,     0,     0,   564,
       0,  1235,   562,     0,     0,  1235,  1235,  1235,   564,     0,
    1235,  1235,  1235,  1235,  1235,   574,  1235,  1235,  1235,   561,
     273,   295,   296,   526,     0,   540,   563,  1975,  1976,   533,
     601,  1194,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   629,   623,    93,   457,   708,  1496,     0,  1890,     0,
    2001,     0,     0,    99,  1977,   271,   512,   514,   513,   511,
     510,     0,     0,  1108,     0,  1268,  1045,  1272,  1271,  1269,
       0,     0,     0,  1107,  1106,     0,   987,  1154,  1155,  1151,
    1152,  1150,  1153,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   960,     0,   987,
       0,   821,     0,     0,     0,     0,     0,     0,  1468,     0,
       0,     0,     0,     0,  1947,     0,     0,     0,     0,     0,
       0,   798,     0,     0,     0,     0,     0,     0,     0,  1099,
    1097,  1100,  1098,     0,     0,   982,   974,     0,     0,     0,
       0,   848,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1009,  1010,  1106,     0,     0,     0,  1106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   870,     0,
       0,     0,     0,     0,   875,     0,     0,     0,     0,     0,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   904,     0,   906,     0,     0,
    1471,  1470,     0,     0,     0,     0,     0,  1014,   667,     0,
     784,  1002,   783,     0,  1766,   977,   979,     0,   710,   709,
     711,   722,   715,   720,   713,   717,     0,   769,  1541,   723,
       0,   751,     0,  1115,   752,   737,   742,   743,     0,     0,
     740,   741,   745,   847,   744,   847,   748,   749,   750,   753,
       0,     0,     0,     0,     0,   773,   778,  1005,   948,  1472,
    1187,  1185,  1888,  1183,    65,     0,     0,  1359,  1374,  1362,
    1898,     0,  1897,  1883,  1886,  1479,     0,     0,     0,  1823,
    1817,  1824,  1826,  1820,  1825,  1827,  1818,  1819,  1814,  1821,
    1109,  1138,     0,     0,   650,   651,   654,     0,  1803,  1804,
    1802,  1801,  1386,  1385,     0,   638,   641,   642,   614,   613,
     615,   608,   610,   611,   253,  1218,     0,     0,     0,  1224,
    1205,  1215,   599,     0,     0,     0,     0,     0,   694,  1045,
    1175,   691,   672,  1138,  1128,   671,   702,     0,  1753,     0,
    1724,  1781,     0,     0,     0,     0,     0,  1771,  1340,     0,
    1294,     0,  1316,  1328,  1327,  1289,     0,     0,     0,  1287,
    1334,  1286,  1108,  1333,  1284,  1285,   596,   595,   590,  1056,
    1045,     0,     0,  1042,  1058,     0,  1058,  1045,  1045,     0,
    1045,  1101,  1053,     0,     0,  2024,  1129,  1939,  1233,  1234,
    1236,     0,     0,   104,   107,   105,     0,   106,     0,     0,
     565,   519,   500,   500,   544,     0,   333,   519,   493,   542,
       0,     0,     0,     0,     0,     0,     0,     0,  1235,     0,
     555,   538,     0,     0,     0,     0,   556,     0,   539,  1235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     577,   576,   575,     0,     0,     0,     0,   274,   457,   336,
       0,   571,   333,   339,  1475,  1979,  1072,     0,  1071,   122,
      76,    72,    84,  1159,  1160,  1158,  1156,  1157,    85,    74,
      75,    79,    78,    80,    81,    82,    77,    73,    86,    87,
      71,     0,  1891,     0,     0,   237,   236,     0,  1995,     0,
    1979,     0,   336,    89,  1407,   272,   275,    90,  1045,  1127,
    1271,  1108,     0,  1101,     0,   790,   805,     0,     0,   953,
       0,     0,   955,   956,   957,     0,   809,     0,   807,   810,
     811,   812,  1002,     0,     0,     0,     0,  1002,   959,     0,
     817,     0,     0,   822,   823,     0,   796,     0,   830,     0,
     832,     0,  1002,     0,   826,     0,   787,     0,     0,  1002,
       0,   838,     0,   799,     0,     0,   939,     0,   922,   918,
       0,   920,     0,     0,  1002,  1002,     0,   843,     0,     0,
     849,  1002,     0,   941,     0,   923,     0,   855,     0,  1002,
       0,  1007,     0,     0,     0,   966,   859,   860,     0,   964,
     925,     0,     0,   862,   927,     0,   929,     0,   924,   931,
     932,   864,   866,   865,   934,     0,     0,   936,     0,   938,
       0,   868,   869,     0,     0,     0,   873,     0,  1002,   878,
     968,   970,     0,     0,     0,     0,     0,   972,   885,   887,
       0,     0,     0,   886,     0,     0,     0,     0,     0,     0,
       0,   891,     0,     0,   905,   971,   797,   969,   910,     0,
     913,     0,   912,     0,     0,     0,     0,  1944,  1944,     0,
     788,     0,     0,     0,     0,     0,  1473,   716,   721,   714,
     718,     0,     0,     0,     0,   735,   734,     0,   747,   746,
       0,  1115,   738,     0,   846,     0,   947,   698,  1002,     0,
      63,  1363,  1895,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,  1139,  1245,  1487,  1396,     0,   658,  1805,  1806,
       0,   612,   677,     0,  1237,  1222,  1229,  1223,     0,     0,
       0,  1221,  1464,  1463,  1470,  1930,     0,     0,     0,     0,
    1933,  1108,  1108,  1169,     0,     0,   669,   674,   670,   673,
       0,   697,   706,   705,  1465,  1472,     0,     0,     0,     0,
     443,   445,   444,   453,     0,   442,     0,     0,  1766,     0,
     449,   451,   450,  1776,   448,  1342,  1136,  1302,  1301,  1143,
    1142,     0,  1296,  1343,     0,  1937,  1051,     0,  1044,  1043,
    1059,     0,  1045,  1058,  1058,     0,  1024,  1023,  1249,  1252,
       0,  1022,  1062,  1049,   677,  2014,  2026,     0,   456,   455,
     302,   452,   301,   109,   108,   114,   115,   338,   520,   494,
     495,     0,     0,     0,   500,   332,   519,   331,   334,   509,
       0,   285,   282,   546,   288,   284,   300,     0,     0,   289,
     519,   553,   554,   568,   278,     0,   314,   315,   313,   297,
     280,   281,   548,  1123,  1125,  1133,   287,   286,   283,   292,
     293,   311,   310,   291,   312,   559,   309,   307,   304,   306,
     305,   308,   290,   279,     0,   541,     0,   322,   324,   325,
    1478,     0,   573,   543,     0,   326,   327,     0,     0,     0,
       0,   657,     0,  1892,     0,  2002,   240,   238,   239,     0,
     124,   320,   321,   319,   318,     0,     0,   243,     0,   241,
       0,     0,  1409,  1408,   242,   256,   457,   276,     0,  1108,
    1148,  1264,  1270,     0,     0,     0,   954,   988,     0,   419,
     419,   998,   996,   408,   419,   992,   997,   994,     0,     0,
       0,     0,     0,     0,     0,   961,   958,     0,     0,     0,
    1472,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   985,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   943,
    1011,   967,   965,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   973,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1015,   793,
    1948,  1948,   785,  1767,  1768,  1769,   521,   978,     0,   728,
    1002,   726,  1114,   732,     0,     0,   736,     0,   902,     0,
     949,   950,     0,  1001,  1474,  1896,  1885,  1884,  1899,  1899,
    1899,     0,  1110,     0,  1202,  1407,   652,     0,   653,   639,
     698,  1219,  1231,     0,  1239,     0,     0,  1216,  1226,     0,
       0,     0,  1225,     0,  1830,  1831,  1829,  1138,  1116,     0,
       0,  1180,     0,  1176,   692,     0,   704,   703,     0,  1783,
       0,  1782,  1794,  1795,  1792,  1793,  1791,  1772,     0,  1778,
    1777,     0,     0,     0,  1788,  1779,     0,     0,  1295,     0,
    1290,   597,     0,  1045,  1058,  1045,  1031,     0,     0,  1045,
    1027,  1025,  1029,     0,  1108,     0,     0,     0,     0,  1046,
     698,  1467,  1130,  1133,   335,   519,   496,   497,   509,     0,
       0,     0,     0,   453,   298,   552,   551,   299,     0,     0,
    1134,  1135,  1126,     0,   545,   336,   572,   473,   404,   353,
     344,   419,   347,   346,   390,   361,   358,   408,   406,   376,
     408,   408,   383,   382,   400,   386,   366,   459,   459,   365,
     403,   459,   387,   385,   389,     0,   391,   408,   396,   384,
     388,   405,   381,   378,   402,   419,   419,   359,   362,   401,
     459,     0,   394,   419,   423,   364,   459,   465,     0,     0,
     419,   421,  1477,  1981,     0,  1983,  1070,     0,   135,   698,
       0,   125,   127,   128,     0,  1983,     0,   246,   271,   257,
       0,   277,     0,  1266,     0,  1262,   771,   802,   806,   915,
       0,   989,   459,     0,   999,   410,   991,   993,   995,   792,
     808,   813,   917,   795,   794,     0,     0,     0,     0,   828,
     831,   833,   824,   829,   827,     0,   916,   840,   837,   839,
     800,     0,   940,   919,   921,   842,   853,   983,   986,     0,
       0,     0,   854,   850,   942,   851,     0,   856,   825,   857,
       0,     0,     0,     0,   926,   861,   928,   930,   935,   933,
     937,   867,   804,     0,   872,   874,   786,   771,   876,     0,
     882,   880,     0,     0,   888,     0,     0,   897,     0,   895,
       0,   896,     0,   898,   899,     0,   911,   914,  1016,     0,
    1945,     0,     0,   980,   724,     0,   730,  1002,   727,   733,
     699,   698,   900,     0,  1904,  1904,  1904,  1244,  1243,     0,
    1242,  1246,     0,   659,   254,     0,     0,     0,  1240,  1228,
    1934,  1217,  1220,  1472,  1832,   676,     0,  1111,  1179,  1177,
       0,  1170,  1172,  1174,     0,  1466,     0,     0,  1787,  1773,
     454,     0,     0,     0,     0,  1774,     0,  1101,  1052,     0,
       0,  1018,  1045,  1045,     0,  1018,     0,     0,     0,  1251,
    1127,  1253,  1060,  1064,  1065,  1063,  1054,     0,  1132,     0,
       0,     0,   558,     0,   571,   560,   423,  1124,   294,   323,
     479,     0,     0,   363,   412,   407,     0,   412,   412,   465,
     467,   461,   465,     0,   372,   390,   367,     0,   459,   380,
     371,   392,   395,   397,   399,   412,     0,   459,   360,   369,
       0,   412,   431,     0,     0,     0,   427,     0,   472,     0,
     434,   340,   424,   426,     0,     0,   393,     0,   349,   466,
       0,   351,     0,     0,   412,     0,   422,   412,     0,  1980,
       0,  1987,     0,     0,   138,   136,   137,     0,   131,   133,
     128,     0,  1996,     0,     0,  1994,  1987,   244,  1934,  1407,
       0,   249,     0,  1133,   517,  1149,     0,     0,   990,     0,
       0,   962,   819,   820,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   789,     0,     0,     0,     0,
       0,     0,     0,   894,   892,   893,     0,  1017,  1946,   522,
     729,     0,   702,   951,     0,     0,  1903,  1901,     0,  1902,
    1900,  1876,     0,  1835,  1836,  1834,  1822,     0,     0,  1397,
    1138,  1230,  1232,  1238,  1227,     0,  1112,  1127,  1410,  1173,
       0,   693,  1785,  1784,  1786,  1780,     0,     0,     0,     0,
    1050,  1045,  1032,     0,  1036,  1041,  1037,     0,  1028,  1026,
       0,  1148,     0,  1066,  1138,  1133,     0,     0,     0,     0,
       0,     0,     0,     0,   557,  1443,   547,   549,     0,     0,
       0,   474,   475,   480,   482,     0,     0,   416,   417,   418,
     373,   413,   415,     0,   375,   343,   460,   468,   469,     0,
     464,   462,   465,   368,   398,   374,     0,   370,     0,   357,
     437,   436,   707,   429,   439,     0,     0,   435,   425,   433,
     428,     0,     0,     0,     0,   341,     0,   342,  1476,  1982,
       0,   534,   698,   698,  1984,  1993,  2003,   135,     0,     0,
       0,   126,   129,  1978,   247,   245,     0,  1930,    91,     0,
     516,     0,   803,   420,   409,     0,   814,   834,     0,   801,
     984,   975,  1106,   844,     0,   852,   858,   945,   944,   871,
     877,   881,   879,   883,   889,   890,  1002,   731,   952,  1882,
    1881,  1880,  1877,     0,     0,     0,     0,     0,     0,  1905,
    1907,  1241,     0,     0,   255,   691,   316,  1120,  1133,     0,
    1138,     0,  1418,  1171,  1790,  1789,  1775,     0,     0,     0,
       0,     0,     0,     0,  1073,  1250,  1061,     0,  1055,  1131,
       0,     0,   328,  1445,  1444,   571,   485,   486,   487,     0,
       0,     0,   478,   481,   352,   345,   414,     0,   523,   470,
     463,     0,   356,   438,   707,   432,   459,   465,   459,   465,
       0,     0,     0,   667,     0,   102,   132,     0,   698,  1997,
     251,   250,  1133,     0,     0,     0,     0,     0,     0,  1878,
    1908,  1911,  1909,  1910,  1912,  1906,     0,     0,   317,     0,
       0,  1117,  1119,  1113,  1161,     0,     0,     0,     0,  1411,
    1413,     0,  1178,     0,  1047,  1033,     0,  1038,     0,  1030,
       0,  1068,     0,   329,   550,   489,     0,   488,     0,   483,
     484,   479,     0,   459,     0,   459,   430,   348,   350,   354,
     355,     0,  1988,     0,  1985,     0,  2004,   134,     0,     0,
    1934,   515,   518,   411,   835,     0,   963,   845,   903,  1247,
    1255,     0,  1398,  1121,  1122,  1133,     0,   675,     0,     0,
       0,     0,  1412,     0,     0,  1419,  1421,     0,     0,     0,
       0,  1074,     0,  1069,   330,   491,   492,   490,   476,   477,
     377,   524,   379,  1989,  1990,  1934,   112,   111,   103,     0,
     171,     0,  1998,   252,     0,     0,     0,   446,  1118,  1162,
    1416,  1417,     0,  1414,     0,     0,  1420,     0,     0,  1035,
    1040,  1067,  1986,   113,     0,   189,   175,     0,     0,     0,
     173,   203,  2005,     0,     0,   177,   201,   202,   178,   181,
     182,     0,  1490,     0,  1491,  1991,   102,   836,  1254,  1256,
       0,  1399,     0,  1415,  1423,  1422,     0,  1048,   188,   191,
       0,     0,   194,   184,   183,   185,     0,     0,     0,   172,
     171,   171,   231,   180,   228,   227,   220,   171,  1999,   447,
    1410,   698,     0,   190,     0,     0,     0,   174,   204,   215,
     218,   210,   171,     0,   171,     0,   143,     0,     0,  1992,
     171,  1418,     0,     0,  1165,  1167,     0,   186,     0,     0,
       0,     0,   171,   211,     0,     0,     0,   141,   234,     0,
     139,   222,   222,  2000,  1424,  1168,  1163,   698,  1291,     0,
     176,   195,   212,   218,   208,   216,   171,     0,   230,   142,
       0,   232,     0,   171,     0,   221,   223,   225,     0,  1426,
    1166,   187,   192,   171,     0,   209,     0,     0,   207,     0,
     171,   154,   153,     0,   145,   167,   229,     0,   144,     0,
       0,  1433,     0,   171,   213,     0,   171,     0,   171,     0,
       0,     0,     0,     0,   140,  1425,  1428,     0,     0,  1430,
    1431,     0,  1400,   193,   198,     0,   205,   171,   235,     0,
     148,   168,   169,     0,   151,  1432,  1427,     0,  1434,   194,
     171,   197,   171,   233,     0,     0,   146,   160,   147,   158,
     150,     0,  1429,   199,   171,   171,   166,   164,   171,   155,
     162,   157,     0,   163,   170,   161,     0,   152,     0,   149,
     165,   159,   156
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   966,    58,   518,
     913,  1372,  1373,    59,   412,    60,   692,  1111,  1112,  1113,
      61,  1585,  2448,  1129,   389,   407,  1582,  1075,  3386,  1504,
    3438,  1505,    62,   482,   690,  1093,  1094,  2750,  2751,  3024,
    2752,  3017,  3018,  3019,  3020,  3583,  3532,  3560,  3584,  3621,
    3654,  3660,  3661,  3603,  3668,  3669,  3670,  3676,  3671,  3604,
    3656,  3533,  3473,  3506,  3502,  3474,  3569,  3501,  3591,  3525,
    3526,  3593,  3634,  3651,  3475,  3476,  3507,  3550,  3477,  3508,
    3573,  3530,  3574,  3594,  3635,  3531,  3551,  3597,  3554,  3478,
    3537,  3585,  3479,  3538,  3480,  3481,  3515,  3536,  3513,  3535,
    3600,  3580,  2027,  2429,  2033,  2439,  3028,  2444,  3207,  3390,
    1859,  2252,  3090,  2760,  1573,  1070,  1071,   390,   391,   392,
     490,  2034,  1539,  2035,  2036,  1541,  1542,  1012,  2402,  2393,
    2379,  3254,  2435,  2406,  2407,  2408,  2409,  2357,  2358,  1945,
    1946,  1992,  2417,  2734,  2956,  2976,  2735,  2736,  2737,  2738,
    2739,  2740,  2741,  2774,  2775,  3150,  3151,  3152,  2771,  3007,
    2991,  2992,  2993,  3173,  2963,  2292,  2293,  3491,  2302,  2303,
    2339,  2629,  2340,  1074,  2964,  3001,  3160,  2994,  2416,  2950,
    3141,  3291,  3142,  3143,  3144,  3369,  1947,  2356,  1090,  1091,
     639,   393,  1145,  1589,  3032,  3033,  2347,  2863,  3297,    63,
    1077,   675,   677,   676,  1995,   467,  1543,  1544,  1545,  2672,
    2678,  3285,  1949,   111,  1369,  2413,  1983,    64,  1049,  1044,
      65,   650,   645,   646,  1047,  1048,  1473,  1907,    66,   585,
      67,   477,    68,   485,  1116,    69,   974,  1851,  1852,  1853,
      70,   682,    71,   486,  1123,  1124,  1125,    72,   964,   116,
      73,   574,   969,   971,   972,    74,   479,   480,  1085,    75,
    1399,  1834,  1835,   687,   688,  1092,  2588,    76,    77,   458,
     432,   591,   433,   434,  1426,  1871,  3255,   602,   603,   604,
    2276,   991,   992,   993,  1876,  1427,  2281,  1131,  2878,   884,
     885,   886,  1305,  1306,  2995,   887,  1315,  1770,   888,   889,
    1798,   890,  2823,  2225,  2226,  2227,  2570,  2571,   891,  2067,
    2786,  2105,   892,  1298,  1755,  1666,  3047,  2807,  1605,  2050,
    2468,  2572,   507,   508,   893,  1223,  1224,  1225,  1683,  1289,
    2196,  1747,  1480,  1481,  1482,  1483,  2927,  2926,  2928,  3269,
    3113,  3271,  3117,  1918,  1484,  1485,  3418,  2315,  2643,  2333,
    2334,  3124,  1909,  1486,  2321,  3123,  2659,  2933,  3277,  3422,
    1997,  3273,  1356,  1357,  1663,   948,   949,  1606,  1831,  2240,
    3097,  3259,  2215,  2897,  3257,  3341,  1546,  2383,  2384,  1873,
    1874,  2337,  2662,  2682,  1015,  3256,  2242,  1454,  1455,  2765,
    3659,  2008,  3407,  3492,  3543,  3544,  3545,  2611,  2612,  2901,
    2902,  1875,  2273,  2613,  3098,    78,   395,    79,  1801,   683,
     684,   510,   404,    80,   413,  1832,    81,   426,  1414,   558,
     578,   977,   978,  1860,  2253,  2260,  1861,  2265,  2890,  2255,
    2591,  2592,  1930,  1931,  2256,  2594,  2887,  2879,  2880,  2584,
    3088,    82,   446,  2654,  2328,  2329,  3399,  3400,   579,    83,
     394,   732,  1593,  1150,  1592,   733,   734,  1152,   505,   506,
      84,   444,    85,   437,   640,  1450,  2306,  1895,   570,   642,
    1461,   643,  1462,  1441,  1890,  1003,    86,   671,   670,    87,
     463,  1066,    88,   519,   924,   925,  1377,  1809,    89,   427,
     583,   584,    90,   421,   571,  1407,    91,   414,   561,    92,
      93,   562,   957,  2585,  3253,  3447,  3520,  1398,   958,  2445,
    3262,  3349,  3350,  3352,  3415,  3416,  3589,  3611,  3628,  3629,
    3632,   894,   659,   895,  3134,   896,   897,  2261,  2262,  2663,
     898,  3401,   899,  1993,   653,   410,   900,   552,   660,  2245,
     901,  3483,   705,   706,   376,   377,    94,   605,   436,   995,
     996,   997,  1436,  1437,   644,  2204,  1438,  1439,  1887,  1882,
    2909,  2635,  2627,    95,   565,   926,   962,   963,  1840,    96,
     445,    97,   950,  1393,  1394,  1828,  2239,  1829,    98,   587,
      99,   541,  1387,   542,   928,   543,   544,   940,   935,   943,
     937,  3243,  3080,  3081,  1816,   909,   707,   708,  1380,  1811,
    1812,  2874,  3083,  3249,  3250,   100,   120,   382,   488,   699,
     985,   101,   102,   103,   104,   988,  1061,  1867,  1062,  1063,
    1064,  1493,  1424,  2550,  1296,  1749,  2860,   493,   722,   714,
     473,   474,   475,   496,   497,   112,   113,   715,   716,  2030,
    2420,  2744,  3011,  3012,  3194,  3191,   717,  3517,   718,   719,
    2430,  3200,  3389,  3486,  3540,   720,  2024,  2748,  3315,  3440,
     105,   661,   455,  1059,  1054,  1056,  1489,  1925
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3254
static const int yypact[] =
{
    2438, -3254,   271,    51,  1084, -3254,   128, 42166,    35,  1084,
    1084,  -183,  2859, -3254, -3254, -3254, -3254, -3254,   781, 42166,
      51, -3254, 21146, -3254, -3254, -3254,    45,  1084,    51, 42166,
   -3254,   -55,   828,    51, -3254, -3254,  1084, -3254,  -183, 42166,
   -3254,   147, -3254,   866,   850,     1,   330, -3254, -3254, 42166,
    1750,  -112,   465,   674, -3254, -3254,   375, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, 21686, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254,   789, 42166, 42166, -3254,
   42166,   346, -3254,   729, -3254, -3254,  1084, -3254, -3254, -3254,
    -183, 21146, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254,   399, -3254, -3254,   584, -3254,
   -3254, -3254,  1142,   961, -3254, -3254, -3254, -3254, -3254,   287,
     745, -3254,   756,  1037,   142, -3254,  1088,  1088, 42166,  1088,
   -3254,  1088, -3254,  1088,  1084, -3254, -3254,  3409, 42166,   982,
     110,   -45, 37333,   120,    91, -3254,  1145, 21146, -3254,  1084,
    1228,   389, 42166, -3254, -3254,  1084,   613,   755, -3254,  4221,
     121, -3254, -3254, -3254,  2727, -3254, -3254,  4580, -3254, -3254,
   -3254,   846, -3254, -3254, 21146,  1084,  1126, -3254, -3254,    63,
      63,    63, -3254,    63, -3254,    63, -3254,  -112,   857, -3254,
   -3254, 42166,   314, -3254, -3254,   840,   847, -3254, -3254, -3254,
   -3254, 21146,  1285,   987, -3254, -3254, -3254, 21146, -3254,   -36,
   -3254, -3254,   886, 42166, -3254, 21146, 21146,   157,   -26,   915,
   42166, 35185,  1056, -3254,   456,   798,   729,  1480, -3254,   961,
   -3254, 42166, -3254, -3254, -3254, 38944,   142, -3254, 13433,  1347,
   42166, 42166,  1175, 42166, 42166, 35185, 21146,  1088,  1018,  3543,
    1150,  1120,  1369, -3254, -3254, -3254, -3254,  1253, -3254, -3254,
    1078, -3254, -3254, -3254,   139, -3254,    30, -3254, -3254, -3254,
   -3254, -3254,  1233,  1040, -3254, -3254,   103, -3254, -3254, 42166,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  1389, -3254,
   -3254, 13433,   968,  1558,  1435, 21146, -3254,   670, -3254, -3254,
    1365, -3254, -3254, 35185, 21146, -3254, -3254, -3254, 18976, -3254,
   -3254,  1608, -3254,  1094, -3254, 21146,  1150, -3254,  1325,  1259,
     -26,  1198, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254,  1155,  2727, -3254, -3254,  1450,  1568, -3254,  1298,
      50,  1236,  1161,   748,    50, 37333,  1489, -3254,   195, -3254,
    1594, -3254, -3254,  1331, -3254, -3254, -3254,  1343,  1349,  1525,
    1351, -3254,   205, -3254,    -8, -3254,   787,  1489,    50,  1057,
   -3254,  1556,  1688,   410,   262, -3254,   305, -3254, -3254,  1752,
   -3254, -3254, -3254, -3254, -3254,  1389, -3254, -3254, -3254,  1269,
   -3254,  1505,  1382, -3254, -3254,    54, -3254,  1293,   508, -3254,
     655, 35722, -3254, -3254, -3254,  1725, -3254, -3254, -3254, 35185,
    1437,  1332, 21146,   708, -3254, 39481, 21146, -3254,   -25, 13433,
   -3254, -3254,  4575,    23,   119, -3254,  1816,  1485, -3254, -3254,
   -3254, -3254,  1731, -3254,  1327,  1328,  1689,  1340, -3254, -3254,
   -3254, -3254, -3254,  1734, -3254,  1391, -3254, -3254, -3254, -3254,
   -3254,  1743, -3254, -3254, -3254, -3254, -3254,   987, -3254, 21146,
     573, 21146, -3254,  1371, -3254,  1375, -3254,  1384,  1388,  1396,
    1402,  1415, 16248, -3254,  1417,  1420,  1424,  1425,  1434,  1440,
    1441,  1443,  1446,  1454,  1459,  1470,  1476,  1477,  1327,  1327,
    1496,  1498,  1499,  1501,   506,  1508, -3254,  1511,  1526,  1528,
    1534,  1535,  1536,  1537,  1543,  1546,  1548, -3254,  1549, -3254,
    1550,  1561,  1571,  1573,  1574,  1578,  1580,  1583,  1584,  1585,
    1587,  1589,  1590,  1592, -3254,  1593,  1595,  1598, 13433,  1599,
    1600,  1601,  1605,  1606,  1609,  1611, -3254,  1616,  1617,  1619,
    1620,  1624,  1627,  1631,  1634,  1639,  1649,  1650,  1651,  1655,
    1656,  1659, -3254, -3254, 13433,  1661, -3254, -3254,  1672,  1674,
   -3254,  1675,  1684,  1694,  1697,  1698,  1699,  1704,  1705,  1710,
    1714,  1715,  1718,  1726,  1728,  1732,  1735,  1738,  1739,  1744,
    1748,  1749, -3254,   699,  1754,  1758,   743,  1759, -3254,  1764,
   -3254,    94,  1766,  1769,  1770,  1327,  1327,  1327,  1771,  1777,
    1778,  1783,  1785,  1788, 13433, 16248, 16248, 16248,  8929, -3254,
   42166, -3254, 42166,  1187,  2390, -3254,  4266, 16248,  3943,   437,
   -3254, -3254, -3254,  1373,  1519, -3254, -3254, -3254, -3254, -3254,
    1795,  1394, -3254, -3254,  1403, 21146, -3254, -3254, -3254,  1465,
      81, 21146,  1431, -3254, -3254, -3254, -3254, -3254, -3254,  1970,
   -3254, -3254, -3254,  1510,  1487, -3254, -3254, -3254, -3254, -3254,
   -3254,  1615, -3254, -3254, -3254,  1796, -3254,  1796, -3254, -3254,
    1796, -3254, -3254,  1796,   687,  2881, -3254, -3254, 42166, -3254,
   42703, -3254, 18976,  1187, -3254,  1881, -3254, -3254,  1954, -3254,
    1931,   136,  1729, -3254, 21146, 37333, -3254, -3254,   117,  1741,
    1791,  1790, -3254,  1848, 21146, 21146, -3254, -3254, -3254, -3254,
     755,   -11,  1797,   734, -3254, 42166, -3254,   769, -3254, -3254,
   -3254,  1802, -3254, 13433, -3254,  1803, -3254,   107, -3254,  2133,
   -3254,  1890, 13433, -3254, -3254,  1815,   961, 42166, 42166, 21146,
   21146, -3254, -3254, -3254,   786, -3254, -3254, 42166,    50, 35185,
   -3254, -3254, -3254,  2211,  1057, 42166,    50, -3254, -3254,  1057,
   -3254, -3254, -3254, -3254, -3254, 21146, -3254, -3254,  1057, -3254,
    1057,  1057,    50,    50,  1860, -3254, -3254,  1818, -3254,  1860,
    1945,   621,    63,  2029, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254,   384, -3254, -3254, -3254, -3254, -3254,
     127, -3254, -3254, -3254,  1522,  1844,  1844,  1515, -3254,   198,
   21146,  1824,  1890, 21146, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254,  1828, -3254,  1830,  1832,  1187,  2257,  2259,  2264,  2266,
    2267,  2276,  2282,  2283,  2284,  2297,  2298,  2303,  2305,  2306,
    2312,  1880, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
    1937, -3254, -3254, -3254, -3254,   921, -3254, -3254, -3254,   138,
    1894, -3254, 37333,  2414, 35185,  2286, 42166, 42166, 42166, 21146,
   42166, -3254, -3254,   230,   230,  2128,  1371, -3254,    68, 42166,
    2292, 25461,   134, 13433, 13433, 13433,   780,  1994,  2406,  2460,
    2460,  2460, 13433, 13433, -3254, -3254, 13433, -3254, 13433, 13433,
   13433, 13433,   976, -3254, -3254,  9492, -3254,  1915, 13433, 13433,
    2001, 13433,  1519, 13433, 13433, 22226, 13433, 13433, 13433, 13433,
   13433,   700, 13433,  3943, 13433, 13433, 13433,  1917, 13433, 13433,
   13433, 13433, -3254, 13433, 13433,   364, 13433,  2375,   381, 13433,
   13433, 13433, -3254, 10055, 13433, 13433, 13433, -3254, 13433, 13433,
   13433, 13433, -3254,  2495, -3254, 22226,  1067, 13433, 13433,  1153,
   13433, 13433, 13433, 13433, 13433, -3254, -3254, -3254, -3254,  9492,
   -3254, 13433, 13433, 13433, 13433, 13433, -3254, 16248, 13433, 10618,
   13433, 13433, 13433, 13433,  1947, 13433, 13433,  2460,  2460, 13433,
   13433, 13433,  1192,  9492, -3254, 13433,  1519,  2893,  2893, 13433,
    1519,  7803, 13433, -3254, -3254, -3254,   381, 11181,  1948, -3254,
   -3254, -3254,  2460, 22226,  2460, 13433, 13433, 13433,  1187,  1974,
    2406,  2406,  2406, -3254,  8929,   200,  1950, 13433, 23306,  1953,
   -3254, -3254, -3254, -3254, 13433, 13433, 13433, -3254, 16248, -3254,
   -3254,  1013, -3254, -3254, -3254, 13996, 16248,  1955, 16248, 16248,
   16248, 16248, 16248,  2270, 16248, 16248, 16248, 16248, 16248, 16248,
   16248, 16248, 16248,    72,  2406, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254,  1972, -3254, 37333, 16248,
   13433, -3254, -3254, 42166, 42166, -3254, 35185, -3254, -3254, -3254,
      81, 37333,  1964, -3254, -3254,  2149,  3543, 21146, -3254, 42166,
   -3254, -3254, -3254, -3254, 19516, 19516, -3254, 19516, -3254, -3254,
      90,    95,  3226,  1998, -3254, -3254, -3254, -3254,  2316, 21146,
   -3254,   -63, 21146,  1824, -3254, 13433,  1890, -3254, 35185, 35185,
   21146, 21146,    13, -3254,   934, -3254,  1890,  2350, 19516, 19516,
   19516, -3254, -3254, -3254, -3254, -3254,    84, -3254,  1187, -3254,
    1977, -3254, -3254, -3254, -3254, -3254, 40018,   114, -3254, -3254,
    1890,  2369, -3254,  1187,  1984, 42166, -3254, -3254, -3254, -3254,
     -38, -3254, -3254, -3254, -3254,  -151, -3254, -3254, -3254, -3254,
    2120,    50, 42166, -3254, -3254,    50,  1057, 21146,    50,    50,
   -3254, -3254,   998, -3254,   305, -3254, -3254, -3254, -3254, 42166,
    2819,  2122,  1999, -3254, -3254, 21146, -3254,  2003, -3254,  2392,
    2523,  1489, -3254, -3254, -3254,   292,   292,  1890,  2123,  2124,
    2129,  2135,  2137,  2153, -3254, -3254,  3200,  2512,   292,   292,
    2512,   292,   292,   292,  2103,  2480,   292,  2359,  2130,  1178,
    2373,   292, -3254,  2138,  2494,   292,   292,   292,  2512,  2570,
     292,   292,   292,   292,   292,   132,   292,   292,   292, -3254,
    4387, -3254, -3254,  2055, 20056, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, 40555, -3254, 13433,  1994,  1890,  1890,  1385,  1890,
    1994,  1890,  1890,  1890,  1890,  1890,  1994,  1890,  1890,  1994,
    4575, -3254, -3254, -3254,   140, -3254, -3254,   -90, -3254, 42166,
   -3254,  1322,  2062,   -68, -3254,  3675, -3254, -3254, -3254, -3254,
   -3254, 21146,  2101,  1998, 25461, -3254,   621, -3254,  2056, -3254,
     457,   356,   202, -3254,  2460,  2063, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254,  2068,  2064,  2073,  2074,   374,   750,  -185,
    2076,   839,  2084,   540,   909,   196,   937, -3254,  2087,  2096,
    1172, -3254,   945,  1011,  1707,  1716,  1077,  2091,  2089,   206,
     235,  1089,  1103,   249, -3254,  2100,  1137,  2491,  1146,  1156,
     253, -3254,  1740,  1158,  1185,   265,  2102,   285,   297, -3254,
   -3254, -3254, -3254,  2111,  1206, -3254, -3254,   308,  1745,  1211,
    1219, -3254,  1760,  1256,  1263,   339,  2114,  1272,   354,  1286,
    1290,  2115,  2117,  2118, -3254,  2460,  2127,  1767,  1773,  2460,
    2134,   388,  1301,  1792,   425,   497,  2136,  2140,  2142,  1807,
    1831,  1889,   522,  1303,   545,  2143,  3769,  1906, -3254,  1922,
    1313,  1319,  1337,   575, -3254,  1346,  1949,  2156,  2163,  1353,
     245,  1401,  2460,  2169,  1958,   588,  2121,  2171,  1973, 11744,
   12307, 12870,   833,  1410,   562, -3254,  1995, -3254,  2173,  2193,
   -3254,  2089,  2197,   595,   651,  1997, 13433,   842, -3254,  -112,
   -3254, -3254, -3254,   176,   696, -3254,  2258, 42166,  1097,   116,
   -3254, -3254, -3254, -3254, -3254, -3254,   533, -3254,  2131, -3254,
    2200,  2139,  8929,   663,  2139,  3403,  1486,  1486, 16248,  2768,
    3255,  3328,  1646,  3943,  1646,  3943,  2139,  2139,  2139, -3254,
    2206, 16248, 16248, 16248, 13433, -3254,  2406,  1187,  2208,   706,
   -3254, -3254, -3254, -3254, -3254,  1431,  2514, -3254,  1824, -3254,
   -3254,   979, -3254,  2207, -3254,  2210,  2199,  2293,  2301, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254,  1489,   934,  2315,  2220, -3254, -3254,  2261,  2542, -3254,
   -3254, -3254,  1187, -3254,  2310, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254,    53, -3254, -3254,  2239,  2239, 17891, -3254,
   -3254, -3254, -3254,  2462,  2638,  2641,  2643,   655, -3254,   187,
   -3254,   983,  2594,  1489, -3254,  2648, 37870, 26000, -3254,  2253,
    2595,  2274,   292, 33574,   796, 23843, 34111, -3254, -3254,  1385,
   -3254,    43, -3254, -3254, -3254, -3254,   786,   786,  2288, -3254,
   -3254, -3254,  1998,  1057, -3254, -3254, -3254,  2269, -3254, -3254,
     621,  2604,  2607, -3254,  2496,   802,  2496,   621,   621, 22226,
     621,  1368, -3254,  1994,  2546, -3254, -3254, -3254, -3254, -3254,
   -3254, 36259, 34648, -3254, -3254, -3254,  2753, -3254,  2755,   324,
   -3254, 22766,  1118,  1118, -3254,   123,   266, 22766, -3254, -3254,
   22766,  1385,  1994, 22766,  1994,  1890,  1890,  1520,   292,  1994,
   -3254, -3254,  2618,  2621, 22766, 22766, -3254, 37333, -3254,   292,
     634,  1385,  1385, 22766, 22226,  1787,  1890,  1994,  1994,  2886,
   -3254, -3254, -3254, 21146,  2781, 37333,  2302, -3254,  4412, 17351,
   42166,   707,   137, -3254,  2290,  2323, -3254,  1027, -3254,  1187,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254,  2387, -3254,  2463,  2324, -3254, -3254,   178, -3254,   479,
    2323, 21146, 16811, -3254,   101, -3254,  3474, -3254,   621,  2522,
      86,  1998,  2318,   134, 14559, -3254, -3254, 13433,  2309, -3254,
   13433, 13433, -3254, -3254, -3254,  3063, -3254, 36796, -3254, -3254,
   -3254, -3254, -3254, 13433, 36796,  3063, 13433, -3254, -3254,  2326,
   -3254,  2655,  2655, -3254, -3254,  1519, -3254, 42166, -3254, 13433,
   -3254, 13433, -3254,  1519, -3254, 13433, -3254, 13433, 13433, -3254,
    2557, -3254, 13433, -3254, 13433, 13433, -3254, 13433, -3254, -3254,
   13433, -3254, 13433, 13433, -3254, -3254,  2571, -3254, 13433, 13433,
   -3254, -3254, 13433, -3254, 13433, -3254, 13433, -3254, 13433, -3254,
   13433, -3254, 16248, 22226,  2351, -3254, -3254, -3254,  2354, -3254,
   -3254, 13433, 13433, -3254, -3254, 13433, -3254, 13433, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, 13433, 13433, -3254, 13433, -3254,
   13433, -3254, -3254, 13433, 13433, 13433, -3254, 13433, -3254, -3254,
   -3254, -3254, 15122, 13433, 13433, 13433,  2355, -3254, -3254, -3254,
   13433, 13433, 13433, -3254, 13433,  1898, 13433,  2735, 13433,  2777,
   13433, -3254, 13433,  2586, -3254, -3254, -3254, -3254, -3254, 13433,
   -3254, 13433, -3254,   350, 13433, 13433,  2780, -3254, -3254,  2358,
   -3254,  2353,  2356,  2357, 37333, 13433, -3254, -3254, -3254, -3254,
   -3254,   700,   669,  2360, 16248, -3254,  3403, 16248, -3254, -3254,
    8929,   663,  3403,  2786, -3254,  2364, -3254, -3254,  2367, 42166,
   -3254, -3254, -3254, 42166,  2377, 26539, 35185, 35185, 35185,  2372,
   13433, -3254, -3254,  2596, -3254, -3254, 21146,  2728, -3254, -3254,
   35185, -3254,  2727, 22226, -3254,  2378, -3254,  2378,   785,  2376,
    1032, -3254, -3254, -3254,  2380,  1198,  2772, 35185, 35185, 35185,
   -3254,  1998,  1998,   620,  2433,  2726, -3254, -3254, -3254, -3254,
   41092, -3254, -3254, -3254, -3254,   957, 42166,  2709, 42166,  8366,
   -3254, -3254, -3254,  2892, 13433, -3254, 35185,   911,   696,   292,
   -3254, -3254, -3254, -3254, -3254, -3254,  1489, -3254, -3254, -3254,
   -3254,  2689, -3254,    50,   998,  -184, -3254,  3011, -3254, -3254,
   -3254,  2729,   621,  2496,  2496,  2737,  2633,   659,  2409, -3254,
     292,  2819,   209, -3254,  2727, -3254, -3254, 13433, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, 13433,  2742,  2743,  1118, -3254, 22766, -3254, -3254,   573,
      76, -3254, -3254, -3254, -3254, -3254, -3254, 34648,  1890, -3254,
   22766, -3254, -3254,   133, -3254,  1890, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254,  2418, -3254,  1003, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, 21146, -3254,  1052, -3254, -3254, -3254,
   -3254, 42166, -3254, -3254, 21146, -3254, -3254,  4025, 42166, 42166,
    2961, -3254, 42166, -3254,   479, -3254, -3254, -3254, -3254,  2646,
   42166, -3254, -3254, -3254, -3254,  2485,  2966, -3254, 21146, -3254,
    2424,  1066, -3254, -3254, -3254,  2968,  4666, -3254,  2427,  1998,
    2745, -3254, -3254, 13433,  2007,  2031, -3254,  1187,  2049,  2434,
    2434, -3254, -3254,  2436,  2434,  2779, -3254,  2782,  2447,  2448,
    2451,  2051,  2458,  2461,  1419, -3254, -3254,  3943,  3943,  2465,
    2454,  2058,  2066,  2475,  2476,  2109,  1453,  2113,  2478,  2484,
    2126,  2152,  1458,  2158,  2170,  2174,  2180,  2489,  2522,  2479,
    1467,  1493,  2492,  2192,  2202,   676,  2222,  2498,   764,  3639,
   -3254, -3254, -3254,  2236,  2256,  2295,  2300,  2307,  2320,  2346,
    2361,  2374,  1553,  2401,  2405,  2500, 13433,  2412,  1179,   835,
    1643, -3254,  2417,  1652,  1658,  2421, 13433,  2428, 13433,  2459,
   13433,  2464,  2466,  2490,  2471,  2477, 13433,   801,  1187, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254,  2456,  1187,  2503, -3254,
   -3254, -3254,   437, -3254,   905,  2505, -3254, 16248, -3254, 13433,
    2506, -3254,  2509, -3254, -3254, -3254, -3254, -3254,  -194,  -194,
    -194, 15685,  1187,  2895, -3254,    44, -3254,  2805, -3254, -3254,
    1155,  2511, -3254,   292, 15685,  2239,  2636, -3254, -3254,   785,
   22226, 26000, -3254, 35185,  1340,  1340,  1340,  1489,  2880,  2315,
    2315, -3254, 24380, -3254, -3254,  2647, -3254, -3254, 27078, -3254,
    1029, -3254, -3254, 16248,  1526, -3254,  1187, -3254, 36259, -3254,
    1187,   292,  2516,  2517, -3254, -3254, 41629, 13433, -3254,  2938,
   -3254, -3254,  2525,   621,  2736,   621, -3254,  2860,  2861,   621,
   -3254, -3254, -3254, 22226,  1998, 15685,  1118,  1118,  1118, -3254,
    1155,  1187,  2535,  1003,  1187, 22766, -3254, -3254,   573,  2529,
    2995,  2996, 22766,  2892, -3254, -3254, -3254, -3254,  4025, 22226,
   -3254, -3254, -3254,  1070, -3254, 17351, -3254, -3254, -3254,  2545,
    2547,  2434, -3254, -3254, -3254, -3254, -3254,  2436,  2747, -3254,
    2436,  2436, -3254, -3254, -3254, -3254, -3254,   145,  2845, -3254,
   -3254,   145, -3254, -3254, -3254,    39,  -147,  2436, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254,  2434,  2434, -3254, -3254, -3254,
     145,  2550, -3254,  2434,  3020, -3254,   328,    56,  2551,  2554,
    2434,  2555,  2556, -3254,  1091, -3254, -3254,  2629,   738, -3254,
    2568,  2569, -3254, -3254,  1890, -3254,  2573, -3254,  4387, -3254,
     703, -3254, 42166, -3254,   786, -3254,  3943, -3254, -3254, -3254,
    2807, -3254,   145,  2808, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, 13433,  2580,  2581,  2582, -3254,
   -3254, -3254, -3254, -3254, -3254, 13433, -3254, -3254, -3254, -3254,
   -3254, 13433, -3254, -3254, -3254, -3254, -3254,  2695, -3254,  2813,
   13433, 13433, -3254, -3254, -3254, -3254, 13433, -3254, -3254, -3254,
   13433,  3105,  2775,  2587, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, 13433, -3254, -3254, -3254,  3943, -3254, 13433,
   -3254, -3254, 13433, 13433, -3254, 13433, 13433, -3254,  2527, -3254,
    2538, -3254,  2561, -3254, -3254,  2818, -3254, -3254,  1187, 13433,
   -3254,  2589, 42166, -3254, -3254,  2590, -3254, -3254, -3254, -3254,
    1187, -3254, -3254,   100,  2619,  2619,  2619,  1526,  1187,  1109,
   -3254, -3254,  2933, -3254,  1802, 22226, 15685,  2597,  2599, -3254,
     508, -3254, -3254,  2600,  1340, -3254,  3115,  2972, -3254, -3254,
   37333,  2601, -3254, -3254,  2867, -3254,    67,  2798, -3254, -3254,
   -3254,   911,  2712,  2720,   292,  1187,  1890,  1602,  1999,  2953,
    2097,  2668,   621,   621,  2558,  2677, 13433, 13433,  2639, -3254,
    2522, -3254,  3039, -3254, -3254, -3254,  1802, 13433, -3254,  2650,
    2658, 42166, -3254,  3618,   707, -3254,  3020, -3254, -3254, -3254,
      -6,  2889,  2890, -3254,  -145, -3254,  2662,  -145,  -145,  3198,
     131, -3254,  3198, 36796, -3254,  1298, -3254,  2708,   145, -3254,
   -3254,  2710, -3254, -3254, -3254,  -145,  2675,   145, -3254, -3254,
    2906,  -145, -3254, 37333,  1890,  3418, -3254,  2731, -3254,  3135,
    3012, -3254,  3020, -3254,  3014,  2919, -3254,  2924, -3254, -3254,
    2925, -3254,  2929,  2942,  -145,  2949, -3254,  -145, 42166, -3254,
   42166,  2734,   714,  1890, -3254, -3254, -3254,  2703,  2722, -3254,
   -3254, 21146, -3254, 42166,  4025, -3254,  2734, -3254,   508,   101,
    2636, -3254,  1121,  1003,  2725, -3254,  2732,  2733, -3254,  1127,
    2566, -3254, -3254, -3254,   914,  2592,    63,  2739,  2724,  2616,
    1687,  2625,  2644,  2984,  3137, -3254,  2653,  2741,  2666,  2684,
    2700,  2707,  2711, -3254, -3254, -3254,  2744,  1187, -3254, -3254,
   -3254,  2746, 37870, -3254,  2814,  2821, -3254, -3254,  2834, -3254,
   -3254,    89,  1838, -3254, -3254, -3254, -3254, 15685,  3057, -3254,
     862, -3254, -3254, -3254, -3254, 13433, -3254,  2522,  3230, -3254,
   24380, -3254, -3254, -3254, -3254, -3254,  2754,  2766,  8366,  3298,
   -3254,   621, -3254,  2799, -3254, -3254, -3254,  2817,  1187,  1187,
   42166,  2745,  3114, -3254,   862,  1003, 42166, 42166,  1130,   381,
     381,   381,  1456,  1456, -3254, -3254, -3254, -3254,   817,   154,
   42166, -3254, -3254,   972, -3254,  2774,  2791, -3254, -3254, -3254,
   -3254,  -145, -3254,    63, -3254, -3254, -3254, -3254, -3254, 36796,
   -3254, -3254,  3198, -3254, -3254, -3254,    63, -3254,  2794, -3254,
   -3254, -3254,  1327, -3254, -3254,  3029,  2836, -3254, -3254, -3254,
   -3254,  2800,  2801,  2803,  2806, -3254,  2809, -3254, -3254, -3254,
     819, -3254, -3254, -3254, -3254, -3254, -3254,  1098, 42166,  3192,
    2969, -3254, -3254, -3254, -3254, -3254,  2815,  1198, -3254, 42166,
   -3254,  3044, -3254, -3254, -3254,  3046, -3254, -3254, 13433, -3254,
   -3254, -3254,  2460, -3254, 13433, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254,    82,  3037,  1994,  1994,  1994,  1994,  1838,
   -3254, -3254,  2870,  2913, -3254,   983, -3254,  -205,  1003, 13433,
    1489,   890,  3138, -3254, -3254, -3254, -3254,  3120,  3165, 13433,
    2831, 13433,  2833,  1133, -3254, -3254, -3254,  2838, -3254, -3254,
    1181,  1191, -3254, -3254, -3254,   707, -3254, -3254, -3254,   402,
     402,  1203, -3254, -3254, -3254, -3254, -3254,  1210, -3254, -3254,
   -3254,  1223, -3254, -3254,  1327, -3254,   145,  3198,   145,  3198,
    3339,  3059,  3345, -3254,  -112, -3254, -3254,  4025, -3254, -3254,
   -3254, -3254,  1003,  2844,  2846,   918,  2848,  2713,  2849, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, 22226, 21146, -3254,    93,
   13433, -3254, -3254,  1187,  3045,  3368,  3370,  3280,  3372,   890,
   -3254,   923, -3254,  3276, -3254,  1187, 42166,  1187, 42166, -3254,
   42166, 40555,  3035, -3254, -3254, -3254,  3420, -3254,    97, -3254,
   -3254,   972, 42166,   145,    63,   145, -3254, -3254, -3254, -3254,
   -3254,  3081, -3254,  3085, -3254,  2868,  3191, -3254,  3297,  4025,
     508, -3254, -3254, -3254, -3254, 13433, -3254, -3254, -3254,  2869,
   -3254,   292, -3254, -3254, -3254,  1003, 42166, -3254,    63,    63,
    3386,    63, -3254,  3390,  3391,   923, -3254,  1385, 13433,  1229,
    1248, -3254,  2876,  2877, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254,   508, -3254, -3254, -3254,  3322,
   31953,  3027, -3254, -3254,  2765, 22226, 15685,  1520, -3254, -3254,
   -3254, -3254,    63, -3254,    63,    63, -3254,  3426,   180, -3254,
   -3254, -3254, -3254, -3254, 42166,   628, -3254, 43240, 43240, 42166,
   -3254,  2911, -3254,  3860,   446, -3254, -3254, -3254, -3254, -3254,
   -3254,  3417, -3254,  2879, -3254, -3254, -3254, -3254, -3254, -3254,
   34648, -3254,  2894, -3254, -3254, -3254,  3172, -3254, -3254, -3254,
    3279, 42166, -3254, -3254, -3254, -3254, 13433, 13433,  2921, -3254,
   31953, 31953, -3254, -3254, -3254, -3254,  3427, 31953,  3191, -3254,
    3230,  2897,  3314, -3254,  3237,  3327, 13433,  1187,  1187, -3254,
     882, -3254, 29243,  2898, 32495, 13433, -3254,   446,  3417, -3254,
   31953,  3138, 13433,  2907,  2905, -3254,  1994, -3254,  3260,  1317,
    2940, 13433, 31953, -3254,  3332,  3210,  2908, -3254,  2909,  1367,
    3369, 43240, 43240, -3254,  3264,  1187, -3254, -3254, -3254, 42166,
   -3254, -3254, -3254,   898, -3254,  1187, 29785,  2931, -3254, -3254,
   13433, -3254, 38407, 30327,  2912, -3254, -3254, -3254,  3146,  2926,
   -3254,  2922, -3254, 31953, 13433, -3254,  3343,  2941, -3254,  2075,
   31953, -3254, -3254,  3290,  2927,   997, -3254,  2932, -3254,  3238,
   18431,  3064, 42166, 27617,  1187,  2944, 31953,  3107, 30869,  3331,
   42166,  4025,  3337,  3338, -3254, -3254, -3254, 37333,  1274, -3254,
   -3254, 22226, -3254, -3254,   -13,  2960, -3254, 28159, -3254,  2974,
   -3254, -3254,  3401,  2026, -3254, -3254, -3254, 20601,  2869, -3254,
   31953, -3254, 31953, -3254, 33037, 13433, -3254,  2988, -3254, -3254,
   -3254,  3860, -3254, -3254, 31411, 28701, -3254, -3254, 24917, -3254,
   -3254, -3254,  3344, -3254,  1187, -3254,  1519, -3254, 33037, -3254,
   -3254, -3254, -3254
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3254, -3254, -3254, -3253, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254,  1709, -3254, -3254, -3254, -3254, -3254,  1942, -1403,
   -3254, -3254, -3254, -3254, -3254,   351,    74,  2841,    34, -3100,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,   503,
     509, -3254, -3254,   334, -3254, -3254,  -914, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254,  -144,  -107, -3254, -3254, -3254,
   -3254,  1295, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  -111,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254,   -34, -3254, -3254,    10, -3254, -3254,   -31, -3254,
   -3254,   -19, -3254, -3254, -3254, -3254,     8, -3254,    11, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254,   523, -3254, -3254,
   -1823, -3254, -3254, -3254, -3254,  2422,  -959, -3254,  3161, -3254,
    -392,   800,  2016, -1807, -1009,  -599,  -593,  -928, -3254, -3254,
   -3254,   435,  1136,  1531,   880,  2022,  2071,  1582,  1633, -3254,
   -3254,   907, -3254, -2630, -3254, -3254, -3254,   873, -3254,   875,
   -3254, -3254, -3254,  -746,   843,   -78, -3254,   436,  -443, -3254,
     642, -3254,   598, -3254,  -432, -2004, -1898, -3254, -3254, -3254,
     608,   919,   966, -3254, -2575, -1796, -3254, -3254,   233, -3254,
   -3254, -3254,   225, -3254,   458,   309, -3254, -3254, -1460, -1729,
   -3254, -3254, -2188,  2468, -1881,   393, -1845, -3254,   438, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  1622, -3254,
   -3254, -3254,   525,  -202, -1308, -2645, -3254, -3254, -3254, -3254,
   -3254, -3254,  1022, -3254, -3254,  2141,  2559, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  1763, -3254,
   -3254, -3254, -3254, -3254, -3254,  2482, -3254, -3254, -3254,  1494,
   -3254, -3254, -3254, -3254,  2209, -3254, -3254,  2935, -3254, -3254,
   -3254, -3254,  1372,  1799, -3254, -3254, -3254,  2956,  1765,  -455,
   -1727, -3254,  3171, -3254, -3254, -3254, -1313, -1967, -3254,  3028,
     378, -1436,  2212,  -486,   766, -3254,   566,  -742,  4223, -3254,
   -1271, -1088, -3254, -3254,  -488, -3254, -3254, -3254, -1237,  -713,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254,   771, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -1109, -3254,
    1579, -3254, -1090, -3254, -3254, -3254,  2426, -3254, -3254, -3254,
   -3254, -3254, -1854, -1439,  1006, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -1859, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -1352, -3254, -1612, -3254, -3254,  -819, -3254, -3254,
     289, -1794, -1165,   605, -3254, -3254,  -948,  2474, -1544, -3254,
   -3254, -3254,  1430, -3254, -3254, -3254, -3254, -3254,   974, -1994,
   -1039, -3254, -3254, -2584,  -627, -1795,  -596, -3254, -1810,   534,
   -1146, -1856, -3254, -3254, -3254, -3254,    87, -3254, -3254, -3254,
     556,  1800, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  -459,
    -326,  1241, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254,  2715,  2687,  1827, -3254, -3254, -1931, -3254, -3254,  1806,
   -3254,   779, -1844, -1187,  1074, -3254, -3254,  1079, -2594, -3254,
   -3254, -3254, -3254, -3254, -3254,  1021,    46,   236,  3229, -3254,
   -3254, -3254, -3254, -3254, -3254,  2947,  2531, -1459,  3180, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  3251, -3254,
    -956, -3254,  -356, -3254, -3254,  -583, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254,  2313, -3254, -3254, -3254, -3254,
   -3254,  2716, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,  1105,
     175, -3254,   352,   159, -3254,   290, -3254, -3254, -3254,    55,
   -3254,  -757,  -665,  -984,   721, -2124, -1216,  1107,  2717, -2688,
   -1115, -1260, -1264, -1694,    21, -3254,    -7,  -513,  -891,  -683,
    2718, -1981,  -388,  -501, -3254,  1559, -3254, -3254, -3254, -3254,
    2277, -3254, -3254, -3254, -3254,  1414, -3254, -3254, -3254,  1080,
   -3254,   803,   610, -3254, -3254,  3272, -3254,  2311, -3254, -3254,
   -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254, -3254,
   -3254, -3254,  2738,  3291,  3133, -3254,  2778, -3254, -3254, -3254,
   -3254, -3254,   481, -3254,   319, -3254,   944,  2598,   609, -3254,
    1500,  -648,  -884, -3254,   485, -3254, -3254,   716,  3309,  3150,
   -3254, -3254, -3254, -3254, -3254, -2200,  -587, -3254, -2268, -3254,
   -3254, -3254, -3254,  1552, -1124,  2453,  1190, -3254, -3254, -3254,
    3256,  3358,  3365, -3254, -3254,   -53, -3254,  3282,  -285, -3254,
    1733, -3254,  1001, -3254, -3254,   733,  3266, -3254, -3254,  3269,
   -3254, -3254, -3254, -3254, -3254,  3270, -3254, -3254, -3254, -3254,
   -3254,  1625, -3254, -3254, -3254, -3254, -3254, -3254
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1975
static const short int yytable[] =
{
     374,   702,   667,  1361,   989,   638,  1067,  1182,   713,   721,
    1031,  1613,   374,  1401,   908,   374,  1173,  1174,  1176,  1740,
    1016,  2197,   374,  1739,   554,  1491,   693,   694,  1647,  1158,
    1456,  1011,   374,  2305,  2342,  2259,  2241,  1761,  2289,  2294,
    2297,  1016,   374,   409,  1769,  2450,  1948,  2642,  2946,  2039,
    1614,  1615,  1616,  2469,   967,  1032,  2317,   910,  2326,  1964,
    2472,  2931,  1803,  1628,  2327,  2602,  2331,  1645,  1540,  1906,
    1637, -1479,   970,  1465,  1619,  1620,  1072,  1622,  2278,  2938,
     374,   373,  1073,  1240,  1468,  1469,  2309,  2310,  2999, -1480,
    1783,  1785, -1879, -1815,  2971,  2361,  1266,   656, -1816,  1270,
     374,   374,  2359,   374,  -248,  3242, -1104,   729,   464,  1264,
    1684,  1494,  1656,  1872,   374,  2380,  2381,  1686,   652,  3649,
    1690,   946,   941,  1279,  1280,  1281,   981,  1676,  1273,  1367,
    -528,  1300,  1301,  2969,  1922,  3102,  2970,   487,   415,  2043,
    3074,  -258,   481,  -259,  1405,  1696,  1697,  1698,  1717,  1718,
    1980,  3157,   946,  1723,   946,  2979,  1705,  2041,  3074,  1706,
    1416,  2998,  1290,  1291,  1292,  2959,  1848,   559,   608,   609,
     547,  2669,  1117,  1738,  1334,  1742,  1114,  2960,  1078,  3403,
    2351,  1367,   469,  1896,   470,   608,   609,  2307,  1088,   685,
    2961,  1300,  1301,  1027,  2351,  1300,  1301,  3038,   938,   608,
     609,  1837,  2670,  2873,  1599,  3426,  1848,  1089,   695,  2440,
     723,  1300,  1301,  2349,  2350,  1300,  1301,  1300,  1301,  1893,
    3509,  1300,  1301,  1081,  1135,  1136,  1137,  1013,  1771,  2447,
     555,  1774,  1775,  1776,  1777,  1069,  1779,  1780,  1781,  1782,
    1784,  1786,  1787,  1788,  1789,   947,  1069,  2348,  1069,  3125,
    1300,  1301,   976,  2348,  2442,  1869,  2360,  1017,   416,  2363,
    1300,  1301,   657,  2021,  1300,  1301,  3289,  1025,  1300,  1301,
    2372,  2373,  1118,  1586,  1981,  1119,   947,  3138,   947,  2382,
    1300,  1301,   106,  1035,  1057,  2590,  3437,  1120,  3147,  2352,
    2426,  1361,  3092,  1274,  1432, -1479,  1001,  1790,   106,  3136,
    1300,  1301,   697,   114,  2325, -1104,  1870,  1547,   456,  1932,
    3075,  2442,  1300,  1301,  2271, -1479,   378,  1838,  1791,   987,
     556,  1951,  1952,  2351,  1954,  1955,  1956,  2597,  3075,  1959,
    3339,  3139,  2057, -1480,  1967,  2029,   498, -1815,  1970,  1971,
    1972,   121, -1816,  1975,  1976,  1977,  1978,  1979,  2959,  1984,
    1985,  1986,   502,   381,  1300,  1301,   952,  3340,  2312,  1433,
    2960,   422,   107,   698,  3148,  1300,  1301,  2660,  1134,  1300,
    1301,  1300,  1301,  2961,  2656,  1361,  2058, -1934,  2973,  1361,
     115,  2974,   608,   609,   557,  1849,  2022,  1487,   429,  1300,
    1301,   374,  2055,  3163,  3202,  1115,   472,  2427,  1333,  3149,
   -1104,   374,  3167,  1300,  1301,   374,   503,  3258,  3677,  2000,
     374,  1897,  1121, -1479,  2010,   374,  2163,  1894,  3437,  2657,
    2016,   568,  1548,  2019,  3076,  1849,  1587,  3427,  1883,  1490,
    2272, -1480,  -337,  2345,  1928,  1458,   442,   374,   564,  2443,
    1300,  1301,  1141,  1464,   728,  1434,   108,  1028,   457,  3210,
    3365,  1667,  1370,  1051,   374,  2637,  1058,  1792,  1659,  1470,
    1471,  1660,   560,  2646,   374,   459,   710,  1884,  1492,  2673,
     374,  1072,  1300,  1301,  1839,  1038,   374,  1073,   374,   374,
    2940,   109,  1368,   374,   374,   696,  2655,  2353,  1442,   435,
     548,  1122,   678,  3251,   374,  2048,  2443,  2451,   374,   483,
    1358,  3404,  2671,   374,   374,  1403,   374,   374,   374,   374,
    1902,  2668,  1300,  1301,   504,  1412, -1104,   417,  1459,  1734,
    1302,  2414,   549,  1303,  1302,  2675,   686,  1303,  1850,  1948,
    1072,  1540,  1435,  3650,  1368,  -500,  1073,  1300,  1301,   658,
    1302,  3279,   374,  1303,  1302,  3078,  1302,  1303,  2346,  1303,
    1302,  1083,  3077,  1303,  3140,  1300,  1301,  2316,   374,   942,
    1300,  1301,  2279,  3078,  2972,  3103,   374,   374,  1850,  1550,
    1275,   374,  1948,  2308,   939,  1083,  2124,  1404,   374,  1302,
    2128,  2043,  1303,  1002,  2431,  1083,   961,   906,   907,  1302,
    1300,  1301,  1303,  1302,  1740,   973,  1303,  1302,  2263,  2449,
    1303, -1479,  1406,  1300,  1301,  1773,   589,  1477,   374,  1302,
    1300,  1301,  1303,  2166,  1445,  1494,  3000,  1982,  2218, -1480,
    2219,  1793,  3094, -1815, -1879,  2667,   976,  2354, -1816,  1302,
    -337,  1014,  1303,  3158,   492,  1594, -1479,   110,  3079,  2761,
    3364,  1302,  1496,  1083,  1303,  1588,  1796,  2962,  2213,   976,
    1018, -1104,  3405,  2042, -1480,  1740,  1304, -1879, -1815,  2330,
    1026,  2199,  2348, -1816,   374,  3290,  1300,  1301,  2891,  -248,
     569, -1104,   374, -1104,  3342,   374,  2348,   460,   374,   374,
    1885,  1083,  1467,  1302,  1300,  1301,  1303,  3387,  2207,  2428,
    2216,  1300,  1301,  1045,  1302,  -528, -1104,  1303,  1302,   822,
    1302,  1303,  2432,  1303,  2222,  2223,  -258,   481,  -259,  3510,
    1740,  2647,  2648,  2064,  2385,  2411,  1304,  1042,  1302,  1929,
    1304,  1303,   374,   576,   374,  2658,  1358,  2607,  2608,  1490,
    3366,  3377,  1302,  3379, -1353,  1303,  1304,   461,  3391,   491,
    1304,  2200,  1304,  -566,  1576,  3497,  1304,  1478,  2609,  2886,
    1142,  1479,  1147,   515,   430, -1937,  1046,  1551,  2065,  3442,
    3204,  1750,  1751,  2046,  2047,  1300,  1301,  2078,  2079,  1302,
    -337,  2368,  1303,  2259,   573,  1304,  1361,  2335,  1039,  1300,
    1301,  1422,  2375,  1359,   658,  1304,  2921,  2911,  1043,  1304,
    2925,  2920,  1603,  1304,  2376,  2924,  2080,  2081,  3430,  3499,
    3432,  1302,   443,  3367,  1303,  1304,  2362,  2164,  2364,  2214,
    2084,  2085,  2895,  2369,  2091,  2092,  1300,  1301,   471,  3135,
    2939,  3448,   711,  1766,   822,  1304,  2096,  2097,  3368,  2387,
    2962,  2389,  2390,  2394,  2477,  2478,   478,  1304,   472,  1006,
    3511,  1302,  1661,  1361,  1303,  1662,  2099,  2100,  1300,  1301,
    1300,  1301,  3489, -1937,  1300,  1301,  2996,   852,  2101,  2102,
    2433,  3135,  1384,  2208,  1927,  1802,  1302,  2412,  3310,  1303,
    2106,  2377,   396,   374, -1353,   374,  3311,   577,  1899,  1304,
    1040,  1180,  1901,  2201,  1302,  1904,  1905,  1303,  2997,  1302,
    1304,  1423,  1303,  1843,  1304,  1016,  1304,  2546,   374,  1041,
    2113,  2114,  1604,  1862,   374,  2763,   680,  1844,  1845,  1418,
    1756,  2641,  1456,  1456,  1304,  2117,  2118,  2045,  1808,  1302,
    1300,  1301,  1303,  1007,  1300,  1301,  1365,  1888,  1304,  1300,
    1301,   466,  1302,  1300,  1301,  1303,  3121,  3031,  1928,  1302,
    2434,   374,  1303,   374,   712,   374,  2563,  2313,  2202,  2130,
    2131,  3500,  1300,  1301,  3035,  3014,   397,   374,   374,  3162,
    1300,  1301,  2378,  3015,  2296,  1304,   483,   374,   374,  2610,
    1795,  2348,  2470,  2332,  1117,  1072,  1915,  2475,   374,  1540,
    3512,  1073,   852,  1804,  1933, -1974,  2134,  2135,  1603,  1740,
    3286,  3642,  2483,  2593,   398,  1302,  2651,  1304,  1303,  2488,
     374,   374,   374,   374,  2180,  1886,  1180,  3321,  2510,  1359,
     374,   987,   374,  1302,  2497,  2498,  1303,   822,   374,  2044,
    1302,  2502,  2680,  1303,  2209,  3345,  1300,  1301,   374,  2507,
    1448,  1449,  2322,  1869,  2509,  3346,   580,  1304,   658,  2374,
    2210,  1477,   954,  2001,  2002,  2323,  2009,  1451,  2011,  2012,
    2013,  2014,  2015,  1385,  2017,  2018,  1466,  2403,  2136,  2137,
    3128,   822,  1304,  3114,  3115,  2676,  1181,  1143,  2525,   484,
    3108,  3312,  3622,   374,  1118,    40,   374,  1119,  2221,  1603,
    1304,  1446,  1447,  2144,  2145,  1304,  3623,  2558,  3016,  1120,
    1144,  1457,  1300,  1301,  1302,  2452,  2565,  1303,  1627,  1463,
    1419,  1549,  2062,  3260,  1300,  1301,  2147,  2148,  1302,  1014,
    2930,  1303,  1300,  1301,  1008,  1304,  2681,  1452,  1300,  1301,
    1293,  2203,  3443,  1854,  2183,   374,   581,   374,  1304,   374,
     374,   374,   374,   374,  3192,  1304,  2156,  2157,  2573,   955,
     830,   672,   374,   -55,   374,  1302,   551,   399,  1303,  2169,
    2170,  2274,  1300,  1301,  2884,  3299,  2188,  2189,   487,  1386,
    1584,  1300,  1301,  3156,   711,  1603,  3161,  3462,  1762,  3287,
     489,  1300,  1301,  1300,  1301,   852,  2652,  1302,   374,  1302,
    1303,  1478,  1303,  1302,  2479,  1479,  1303,  1300,  1301,  1685,
     582,  1304,  2484,  1082,  1300,  1301,  2932,  2932,  2932,  1180,
    1300,  1301,  1300,  1301,  1603,  1854,  1386,  3206,  2324,  1304,
    1580,  1581,  2190,  2191,  1121,    51,  1304,   499,   374,   852,
    1009,  1300,  1301,  1929,  2936,  1948,  1300,  1301,  1033,   386,
    2559,  2560,   956,  3347,  1300,  1301,   965,  2815,  2816,  2275,
     700,   701,  1029,  1180,  1940,  3280,  3281,  2632,   680,  1302,
     501,  3288,  1303,  1302,   400,  3138,  1303,  3268,  1302,  1265,
    1644,  1303,  1302,  3030,  2633,  1303,  2228,  1098,  1099,   401,
    1083,  1300,  1301,  2229,  3193,  1689,   374,  1010,  1300,  1301,
    1030,  1302,  1034,  1453,  1303,   440,   712,  1300,  1301,  1302,
    1304,   374,  1303,  1122,  2198,   402,  2869,   509,   117,  -130,
     118,  1300,  1301,  1269,  1304,  1300,  1301,  1856,  1857,  3139,
     403,  2056,  2787,  2788,  1722,  3014,  1300,  1301,  1300,  1301,
     438,   673,   546,  3015,   439,  2819,  2820, -1974,  1300,  1301,
    2025,  1088,  1300,  1301,  1300,  1301,  1740,   441,   700,   701,
    2263,  1304,   423,  1763,  1962,  2596,   674,  2839,  2859,  2026,
    1089,   374,  1300,  1301,  1854,  1302,   374,   374,  1303,   374,
    1855,  1300,  1301,  2282,   374,  3348,  3300,   563,  1300,  1301,
     374, -1104,   374,  1304,  2194,  1304,  3413,   374,   374,  1304,
     374,   649,  1300,  1301,  1109,  1110,   946,  2634,  2195,  1740,
     577,  1088,   374,  2330,  2181,   374,  2841,  2842,  3414,   567,
    2060,   374,   374,   374,   374,  1814,  1814,   549,  1814,  2906,
    1089,   374,   374,   374,  3529,  1740,  1300,  1301,   668,  2385,
    1836,  1302,  2907,   961,  1303,  1300,  1301,   679,  3552,   374,
    3572,   973,  1847,  1302,  1300,  1301,  1303,   680,   374,  1814,
    1814,  1814,  2365,  2366,  3552,  1304,   689,  1302,  3016,  1304,
    1303,   709,  2908, -1104,  1304,   374,  1856,  1857,  1304,  2808,
     374,   647,   648,  2388,   651,  3344,  2866,  2867,  1300,  1301,
    2865,  2063,   374,  1300,  1301,  3217,  3218,  1304,   374,  3394,
    3395,  1302,  1300,  1301,  1303,  1304,  3503,  3504,  1903,  2003,
    1302,   106,  3581,  1303,  1858,  2295,   902,  2299,  2304,  2066,
    1302,  2562,  1302,  1303,  1764,  1303,  1921,  2071,  1300,  1301,
     947,  3378,   905,  3380,   406,   927,  1302,  2228,  -537,  1303,
    1765,  1506,   419,  1302,  2618,  2367,  1303,   425,  1507,  1302,
     929,  1302,  1303, -1104,  1303,   912, -1104,   374,  1508,  1509,
    2232,  2233,  1963,  2341,  2295,   374,  1381,  2004,   936,  1382,
    1302,  1304,  1383,  1303,   117,  1302,   118,  3446,  1303, -1104,
     766,  3457,  3419,  1302,  3420, -1104,  1303,  1510,  1300,  1301,
     944,  1511,   374,  2072,   608,   609,   608,   609, -1104,  1013,
    3586,  3586,  1512, -1104,   374,  1495,  3384,   374,  2421,  2422,
   -1104,  1513,  3519,  2599,  2600,   934,  1514,  1013, -1104,   109,
    1302,  3036,   945,  1303,   959, -1104,   960,  1302,  1515,  1316,
    1303, -1104,  2037,  2684,  2685, -1104,  1302,  1304,   779,  1303,
     946,  1740,   968,  1069, -1104,  2593,  1516,  2758,  2685,  1304,
    1302,  2948,  1083,  1303,  1302,  1517,  1518,  1303,   511,  2075,
     513,  1519,   514,  1304,   516,  1302,  2005,  1302,  1303,  1520,
    1303,  2082,  3009,  3010,   979,  1521,   980,  1302,  1300,  1301,
    1303,  1302,   983,  1302,  1303,  2083,  1303,  1300,  1301,  2295,
    3086,  3087,  3057,  1300,  1301,   984,  2295,  1304,   989,  2638,
    1522,  1302,  3208,  3209,  1303, -1104,  1304, -1104,  3214,  3215,
    1302,  3282,  3209,  1303,  3359,  3360,  1304,  1302,  1304,  2087,
    1303,   987,  1300,  1301,  1817, -1104,  1818,   998,  2089,   990,
    1016,  1302,  1304, -1104,  1303,   999,  2006,   806,  2090,  1304,
    2094,  1005,  1300,  1301,  1000,  1304,  1523,  1304,  1524,  1004,
    2640,  1300,  1301,  2070, -1104,  1525,  1014,  1864,  1865,  1866,
    2840,  2569,  3362,  3209,   947,  1302,  1304,  2095,  1303,  2589,
     374,  1304,  3363,  3209,  1302,  1300,  1301,  1303,   911,  1304,
    1300,  1301,  1019,  1302,  3371,  3372,  1303,  2616,  2104,  1316,
   -1104,  3373,  3374,  2108, -1104,  1300,  1301,  3071,   448,   930,
    1456,  2109,  1300,  1301,  3375,  3374,  1020,   827,  1300,  1301,
    3459,  3360,  1319, -1104, -1104,  2631,  1304,  1302,  1021, -1104,
    1303,  1526,  1302,  1304,  1022,  1303,  1023,  1300,  1301,  3460,
    3360,  1302,  1304,  1036,  1303,  1527,  2556, -1104,  2111,   449,
    1528,  1024,  1300,  1301, -1104,  2112,  1304,  1037, -1104,  1050,
    1304,  1052, -1104,  1069,  2116,  3646,  3647,  1302,  2934,  2935,
    1303,  1304,   931,  1304,  1053, -1104,  1300,  1301,  2119, -1104,
    1055,   374,  2120,  1304,  1060,  2674,  1079,  1304, -1104,  1304,
    1529,  1080,  2677,  2132,  3571,  2146,  1530,  1126,  1531,   374,
     374, -1104,  1726,  1727,  1127,  2153,   374,  1304,   374,   374,
    1128,  2154,  2007,   932, -1104, -1104,  1304,  1130,   450,  1532,
    1533,  1607,  1534,  1304,  1132,  2386,  1133,  1302,   933,  2155,
    1303, -1104,  1134, -1104,  1300,  1301,  1535,  1304,  2158,  1138,
    1158,  1497,   374,  1300,  1301,  2162,  3283,  3284,  1140, -1104,
    1139,  1300,  1301,  1498,   374,   374,  2898,  2899,  1536, -1104,
   -1104,  2875,  2876,  1149,   374,  1360, -1104,  1300,  1301, -1104,
     374,  1304,  1151,   374,  1153,  2683,   374, -1104,  1154,  1608,
    1304,  2954,  1319,   860,  2957,  2958,  1155,   374,   374,  1304,
     374,  1363,  1156,  2165,  1300,  1301,   374,   374, -1104,  3110,
    1364,  2975,  2182,  1300,  1301,  1157,   374,  1159,   374,  2295,
    1160,  2785,   374,   374,  1161,  1162,  1609,  1302,  1300,  1301,
    1303,  3084,  3085,  1304,  1163,   658,  1302,  1371,  1304,  1303,
    1164,  1165,  1302,  1166,  2395,  1303,  1167,  1304, -1104,  1537,
    1300,  1301,  1300,  1301,  1168,  2795,  1374,  2772,  1538,  1169,
    2801,  2776,  1300,  1301,   374,   374,  3244,  1366, -1104,  2810,
    1170,  1302,  1950,  1304,  1303,  1953,  1171,  1172,  1327,  1328,
    1329,  1330,  1331,  1332,  1965,  1375,  1300,  1301,  1610,  1376,
     374,  1302,  2437,  1973,  1303,  2811,  1175,   374,  1177,  1178,
    1302,  1179, -1104,  1303,  1300,  1301,  1300,  1301,  1183,  2536,
     374,  1184,  1740,  1300,  1301,   662,   663,  -537,   664,  1499,
     665,  1300,  1301,  -537,  1302,  1378,  1185,  1303,  1186,  1302,
    1300,  1301,  1303,  1304,  1187,  1188,  1189,  1190,  1607,  3331,
    3332,  3333,  3334,  1191,  1302, -1104,  1192,  1303,  1193,  1194,
    1195,  1302,   451,  3326,  1303,  2833,   374,  1302,  1611, -1104,
    1303,  1196,  3245,  3246,  1300,  1301,  3247,  3248,  1300,  1301,
    1607,  1197,   452,  1198,  1199, -1104,  1302, -1104,  1200,  1303,
    1201,  1300,  1301,  1202,  1203,  1204,  3328,  1205,  1500,  1206,
    1207,  1302,  1208,  1209,  1303,  1210,  1608,   453,  1211,  1213,
    1214,  1215,  1396, -1104, -1104,  1216,  1217,  1300,  1301,  1218,
   -1104,  1219,  1501,  1300,  1301,  1302,  1220,  1221,  1303,  1222,
    1226,  1740,  1911,  1304,  1227,  1300,  1301,  1228,  1608,  1300,
    1301,  1229,  1304,  1609,  1230,  1300,  1301,   374,  1304,  1231,
    1329,  1330,  1331,  1332,   454,  2843,  1397,  1300,  1301,  1232,
    1233,  1234,  1400,  3617,  2845,  1235,  1236,  1300,  1301,  1237,
    2846,  1239,   374,  1502,  2903,  1609,   374,  1304,   374,   374,
     374,   374,  1241,  1302,  1242,  1243,  1303,  1300,  1301,   374,
    2341,  3025,  1302,   374,  1244,  1303,   374,  1304,  2953,  3224,
    1302,  1300,  1301,  1303,  1245,  1610,  1304,  1246,  1247,  1248,
     374,   374,   374,  3021,  1249,  1250,  1302,  1836,  2073,  1303,
    1251,  1300,  1301,   374,  1252,  1253,  1409,  2074,  1254,   374,
    1304,   374,  2977,  2978,  1612,  1304,  1255,  1610,  1256,   374,
    2981,  1402,  1257,  1302,  1503,  1258,  1303,  3004,  1259,  1260,
    1304,  2093,  1302,  1408,  1261,  1303,  2107,  1304,  1262,  1263,
    1300,  1301,  1912,  1304,  1267,  1300,  1301,  1302,  1268,  1271,
    1303,  2110,  1300,  1301,  1272,  1611,  1276,  1913,  2126,  1277,
    1278,  1282,  1304,  1411,  2127,  1300,  1301,  1283,  1284,  1302,
    1914,  1302,  1303,  1285,  1303,  1286,  1740,  1304,  1287,   374,
    3630,  1302,  1410,  2133,  1303,  1362,  1379,  1611,  1440,  1417,
     374,  1300,  1301,   374,  1425,  1431,   551,  1740,  2141,  1444,
    1472,  1304,  1182,  1266,  1270,  1302,  1300,  1301,  1303,  1460,
    1474,  3220,  1476,  1740,  1488,  2569,  1083,  3630,  1552,  1300,
    1301,  1553,  2142,  1302,  1554,  1302,  1303,   374,  1303,  1555,
    3568,  1556,  1302,  3109,   374,  1303,  1557,   374,  1558,  1559,
    1302,   374,   374,  1303,  1915,   374,  1300,  1301,  1560,  1302,
    1300,  1301,  1303,   374,  1561,  1562,  1563,  1300,  1301,  1304,
    3303,   374,  1300,  1301,  3112,  2687,  1300,  1301,  1304,  1564,
    1565,     1,  1570,  1300,  1301,  1566,  1304,  1567,  1568,  1571,
    2143,     2,     3,  1302,  1569,  1575,  1303,  1302,  1577,  2756,
    1303,  1579,  1304,  1596,     4,  1591,     5,  2151,  3657,  1358,
    1302,  3171,  1603,  1303,  1300,  1301,  1631,  1275,  1651,  1300,
    1301,  1300,  1301,  2152,     6,     7,  1300,  1301,  3298,  1304,
       8,  1612,  1300,  1301,     9,    10,  1302,  1665,  1304,  1303,
    3195,  3298,  1302,  1916,  1682,  1303,  1746,    11,  1714,  1737,
    2159,  1752,  3099,  1304,  1302,  1772,  1778,  1303,  1302,  2168,
    1757,  1303,    12,  1612,  1302,  1794,  1805,  1303,  3159,  1806,
    1833,  1830,  1307,  1308,  2173,  1304,  1302,  1304,  1863,  1303,
    1889,    13,  1300,  1301,  1877,  1891,  1302,  1304,  1919,  1303,
      14,    15,    16,  1300,  1301,  1898,  2184,  1917,  2192,  2282,
    1924,  1920,  3376,    17,    18,  1923,  1302,  1926,  2767,  1303,
    1309,  1304,  1939,  1934,  1935,  2295,  1300,  1301,  1940,  1936,
    1302,  1300,  1301,  1303,  1310,  1937,    19,  1938,  1957,  1304,
    1960,  1304,  2768,   374,   374,  2341,   374,  3534,  1304,  1958,
    1302,  1961,    20,  1303,  1966,   374,  1304,  1300,  1301,  1968,
    2769,   374,  2782,  1969,  1974,  1304,  1311,  1988,  2038,  2790,
     989,   374,  2028,  2042,  2049,  2052,    21,  2791,  1312,   374,
    2051,  1300,  1301,    22,  2053,  2054,    23,  2059,  3576,  1302,
    1300,  1301,  1303,  1911,  1302,  2061,   374,  1303,  2068,  1304,
    2069,  1302,  2076,  1304,  1303,  1313,  2077,    24,   374,  1300,
    1301,  2086,  2088,  2098,  1302,   374,  1304,  1303,  1300,  1301,
    2794,    25,   374,  2103,  2796,  2115,  2121,  2122,   374,  3613,
    2123,  1300,  1301,  2171,  2236,  2205,  3618,  2799,  2125,    26,
    1302,  -770,  1304,  1303,    27,  2129,  1332,  2138,  1304,  1300,
    1301,  2139,  3637,  2140,  2149,  1302,  3313,  3314,  1303,  3431,
    1304,  1314,  2903,  2800,  1304,  1300,  1301,  2160,  1302,  2802,
    1304,  1303,  1300,  1301,  2161,   375,  1300,  1301,  1300,  1301,
    2167,  2803,  1304,  2172,  2185,  2804,  3664,   405,  3665,   592,
     411,  2805,  1304,  3450,  3451,  1302,  3453,   420,  1303,  1302,
    1300,  1301,  1303,  2813,  2186,   374,  1302,   431,  2187,  1303,
    2211,  1302,  1304,  2814,  1303,  1302,  2220,   447,  1303,  -946,
    2231,  2295,  1302,  1912,  2234,  1303,  1304,  2235,  2237,    28,
    1300,  1301,  2246,  2817,  2217,  3681,  2238,  3493,  1913,  3494,
    3495,  2244,  1300,  1301,  2249,  2250,  1304,  2824,  2248,  2254,
      29,  1914,  2567,  1302,  2266,   465,  1303,    30,  1302,  2267,
    1302,  1303,  2268,  1303,  2269,  1302,  1870,  2825,  1303,  1869,
    2286,  1302,  2287,  2311,  1303,   468,   375,    31,   375,    32,
      33,  2314,  3388,    34,  2318,  1304,    35,  2319,    36,   465,
    1304,  2288,  2336,    37,  2320,    38,  2343,  1304,  2344,   593,
    2370,  2396,  2397,  2371,    39,   374,  2826,  2418,    40,  3385,
    1304,  2827,  2404,  2423,    41,  2959,  2424,  1490,  2828,    42,
    2456,  1302,  1597,    43,  1303,  1915,   798,  2960,   374,  3154,
    3155,  2829,  1302,  2419,  2425,  1303,  1304,  2476,  2489,  2398,
    2961,  1316,    44,   374,   521,  3116,    45,  3165,  3439,   608,
    2965,  1304,  2499,  3169,  1911,  1302,  2538,  2830,  1303,  1316,
    1302,  2399,  2511,  1303,  1304,  2512,  2531,  2543,  2549,  2552,
    2553,  2561,  2831,  2554,  2555,  2568,  3185,   594, -1000,  3187,
      46,  2576,  2581,  2583,   374,  2832,  1302,  2598,  2587,  1303,
    2595,  1304,  2400,  2603,  2614,  1304,    47,  2601,  2540,    48,
     383,  2615,  1304,  2620,    49,  2628,   374,  1304,  2639,  2645,
    1302,  1304,  2834,  1303,  1916,   522,  2835,  2649,  1304,  1302,
    2650,  2653,  1303,  2838,  2665,  2666,   374,    50,  2844,  2745,
    2679,  2754,  2847,  2749,  2755,  2757,  2759,  2762,  1302,  2849,
    1607,  1303,  2764,   523,  2770,  1339,  2773,  1302,    51,  1304,
    1303,   374,  2777,   374,  1304,  2778,  1304,   524,  2779,  2780,
    1302,  1304,  2781,  1303,   374,  3490,   374,  1304,  1917,  2783,
    2851,  2229,  2784,  2862,  2881,  2853,  2789,  2854,  1302,   525,
    3439,  1303,  2856,   384,  1912,  3542,  2792,  2793,  2857,  2797,
     526,  2809,  3199,  2982,  1302,  2798,  2883,  1303,  1608,  1913,
    2806,  1302,  2855,  2812,  1303,  1302,  1854,  1302,  1303,  2818,
    1303,  2836,  1914,  1340,  2864,   374,  2868,  1304,  2871,   527,
    2872,  2896,  -505,  2885,  1319,  2904,  2912,  2913,  1304,  1302,
    2916,  3542,  1303,  2983,  2919,  1609,  2917,  2984,  3063,  2941,
    2922,  2923,  1319,   374,   528,  2459,  1911,  2937,  1344,  3064,
     529,  1304,  2295,  2942,  2943,  2951,  1304,  2952,  2955,  1302,
    2980,  3002,  1303,   374,  3003,  3005,   512,  3046,  2460,   374,
     374,  1302,  3065,  3008,  1303,  3013,   545,  3216,  2985,  3022,
     553,  3023,  1304,   374,  3027,   465,  1915,   530,  3037,  3039,
     572,  3041,  3042,  3043,  3048,  3053,  3054,  1610,  3055,  3066,
    3068,  3070,   374,  3219,  3082,  3089,  1304,  2461,  3093,  3095,
    2462,  3087,   465,  3100,  2401,  1304,  3672,  2618,  2463,  3096,
    3101,   595,   596,   597,   598,   599,   600,  3223,  3104,   669,
    2578,  2579,  2580,  3111,  1304, -1034,  3225,   601,  3106,   465,
    3672,   374,  1348,  1304, -1039,   465,  3107,  1321,  1322,  3120,
    1349,   691,   374,   465,   465,  3226,  1304,  3122,   703,   553,
    3126,  2604,  2605,  2606,  3229,  1321,  1322,  1611,  3127,   730,
    3145,  3146,  3153,   735,  1304,  1916,  1912,  3231,   903,   904,
    2999,   375,   375,   553,   465,  3166,  2996,  3168,  3164,  3645,
    1304,  1913,  3175,  3176,  3177,  3232,  3179,  1304,   531,  3180,
    1911,  1304,  -471,  1304,  2644,  3181,  3182,  -336,  1497,  2391,
    3183,  3233,  2392,  1350,  3196,   532,  1940,   951,  3234,  3190,
    1498,   533,  3235,  3184,  3397,  1304,   119,   534,  1941,  1917,
    3186,   379,   380,   465,  3197,  3211,  3222,  3227,  3228,  3252,
    3239,   553,   465,  3212,  3213,  3261,   465,  3240,   385,   418,
    3221,   535,  3230,   465,   424,  1304,  3236,  3237,   428,  3436,
    3241,  1352,   536,   537,  3267,  3264,  3270,  1304,  1325,  1326,
    1327,  1328,  1329,  1330,  1331,  1332,  3487,  3265,  1915,   374,
     374,  -264,   386,   553,  3272,  3294,  1325,  1326,  1327,  1328,
    1329,  1330,  1331,  1332,  3276,   700,   701,  2962,   538,   374,
    2986,   374,  3295,   374,   374,  3302,  3304,  2987,  3402,  3305,
    3318,  3306,  3307,   387,  3308,   374,  -336,  3309,  1819,  2966,
    2732,  3215,  3319,   388,  1942,  3323,  3320,  3324,  1316,  3330,
    1912,  3336,  2464,  1612,  2988,  3337,  1820,  3351,   476,  1068,
    3353,  3356,   539,  3358,   540,  1913,  3381,   553,  3361,   374,
     465,  3382,  3383,  1086,   465,  3392,  1821,  3393,  1914,  3396,
    3398,  3406,  3408,  1088,  3409,  3410,  3411,  1916,  3417,  2414,
    1822,   520,   521,  3433,  1353,  3425,  1499,  3434,  3441,  3435,
    3452,  3445,  1089,  3482,  3454,  3455,  1355,  3461,   374,  2422,
    3463,  3485,  3496,  -206,  2989,  3514,  3522,   465,  3516,  1148,
    3523,  1316,   743,  3529,  3521,  -224,  3546,   374, -1164,  3547,
    3482,  3482,   374,  1823,  1824,  3548,  3557,  3567,  3566,  3570,
    3577,  1917,  3572,  3578,  3588,  3582,  3579,  3609, -1737,  3598,
    3608,  3615,  1915,   374,  3612,  3619,  3610,  3625,  3616,  3620,
    3631,  1825,  3636,   522,   374,  1500,  2465,  1508,  1509,  3640,
    3624,  3638,  3354,  3482,  3482,  3643,  3644,  3652,  3653,  3655,
    3482,  3675,  2020,  3680,  2230,  3129,   700,   701,  1076,  1501,
    3518,   523,   766,  3198,  2990,  3482,  1316,  3482,  -457,  -457,
    1511,  3316,  3201,  3482,  3682,   524,  3658,  -457,  3663,  3595,
    3553,  1512,  3596,  3587,  2466,  3482,  3562,  2894,  3561,  1826,
    1513,  1574,  3205,   500,  3482,  3482,  1987,   525,  3029,  3278,
    2747,  1319,   374,  2441,  -336,  2949,  1991,  1515,   526,  3482,
    1502,  1916,  2467,   777,  2415,   374,  3482,  1944,  2355,  2944,
     779,  2967,  1069,  2968,  3006,  1516,  3482,  3296,  3137,  1827,
    3178,  3170,  2945,  3482,  2910,  3424,  3428,   527,  1297,  3370,
    1299,  3293,  3322,   374,  3301,   374,  3482,  1572,  1475,  3482,
    2405,  3482,  1590,   374,  1521,  1908,  2251,   794,  2586,  1846,
     374,  1087,   528,   465,   374,  1917,  1065,   666,   529,   465,
    3482,   994,  2270,  3338,  1319,  2247,  3072,  1868,  3238,  1943,
     374,  1503,  3073,  3482,  2473,  3482,  1629,   374,  1681,  2918,
    3423,  2566,   743,  2947,  3590,  3275,  3263,  3482,  3482,  2243,
     914,  3482,  1413,  2257,  3091,   530,  1389,  1395,  1392,  2889,
     465,   374,  2277,  2888,  2929,   655,   517,  3648,  1146,   806,
    1595,  3488,   465,   553,  1321,  1322,   736,  1524,   641,  1807,
    2882,   566,   465,   465,  1525,  3541,  1415,   575,  1508,  1509,
    3564,  3412,  3662,  1421,  -336,  3456,  3174,  2892,  1878,  1319,
    1429,  1430,  2636,  1841,  3105,  3129,  2914,   654,  3266,   982,
     588,  1420,   766,  1388,  3329,   375,   375,   465,   465,  -457,
    -457,  1511,  1578,  2575,  3335,   375,   822,   553,  -457,   590,
     986,  2861,  1512,   375,   915,  3172,  1748,   494,   826,   827,
    2551,  1513,   727,   465,   495,   681,  3026,  1321,  1322,  3203,
    1526,   724,  1316,  2436,   725,   726,     0,     0,  1515,     0,
       0,     0,     0,   777,  1527,     0,   531,     0,     0,     0,
     779,     0,     0,  1069,     0,     0,  1516,     0,     0,     0,
       0,     0,     0,   532,     0,     0,     0,     0,   465,   533,
     916,   465,     0,     0,     0,   534,  1326,  1327,  1328,  1329,
    1330,  1331,  1332,     0,     0,  1521,     0,   794,     0,     0,
       0,     0,     0,     0,   917,  1530,     0,  1531,     0,   535,
       0,     0,  1321,  1322,     0,     0,     0,     0,     0,     0,
     536,   537,     0,     0,     0,     0,     0,     0,  1532,  1533,
     553,  1534,   553,     0,   375,   375,  1583,   465,   375,     0,
       0,     0,     0,     0,  2821,     0,     0,   735,     0,  1598,
       0,     0,     0,     2,     3,     0,   538,     0,     0,   806,
    1327,  1328,  1329,  1330,  1331,  1332,     4,  1536,  1524,     0,
       0,     0,  1316,     0,   852,  1525,  3130,     0,     0,  3131,
       0,     0,     0,  1638,     0,     0,     6,     7,   918,   858,
       0,     0,     8,     0,   919,   860,     9,    10,   861,     0,
     539,  2031,   540,     0,     0,     0,     0,     0,     0,    11,
       0,     0,     0,     0,     0,     0,   822,     0,     0,     0,
       0,     0,   920,  1638,    12,  1319,     0,     0,   826,   827,
       0,     0,     0,  1325,  1326,  1327,  1328,  1329,  1330,  1331,
    1332,  1526,     0,    13,     0,     0,     0,     0,  1537,     0,
    3132,  3133,    14,    15,    16,  1527,     0,  1538,   921,     0,
       0,     0,     0,     0,     0,    17,    18,     0,     0,     0,
       0,     0,     0,     0,  2150,     0,     0,     0,   922,     0,
       0,  1741,     0,     0,     0,     0,     0,     0,    19,     0,
       0,     0,     0,   923,     0,   118,   553,     0,     0,     0,
       0,     0,     0,     0,    20,     0,  1530,     0,  1531,     0,
       0,     0,     0,     0,     0,     0,  2446,     0,     0,     0,
       0,  1335,  1336,  1337,  1338,  1339,     0,     0,    21,  1532,
    1533,     0,  1534,     0,     0,    22,  2688,  2689,    23,     0,
       0,     0,  2690,     0,  2691,  2692,  2693,     0,  1321,  1322,
       0,     0,     0,     0,     0,  1319,   553,     0,     0,    24,
    2694,  1799,  1800,     0,   553,     0,     0,     0,  1536,   553,
       0,     0,     0,    25,   852,   465,  3130,  1810,     0,  3131,
       0,     0,  1815,  1815,     0,  1815,     0,     0,     0,   858,
       0,    26,     0,  1340,     0,   860,    27,   465,   861,  2695,
     465,     0,  2696,     0,     0,     0,   553,   553,   465,   465,
    2697,     0,     0,     0,     0,     0,  1815,  1815,  1815,     0,
       0,     0,     0,     0,     0,  1341,  1342,  1343,  1344,  2698,
       0,     0,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,  1892,     0,     0,  2699,     0,     0,  1537,
    3132,  3133,     0,     0,  2822,     0,     0,     0,  1538,     0,
    1900,     0,     0,     0,     0,   465,  2700,     0,  2701,  1325,
    1326,  1327,  1328,  1329,  1330,  1331,  1332,  1910,  1321,  1322,
       0,    28,     0,   465,     0,     0,     0,  2702,  2703,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    29,     0,     0,     0,     0,     0,     0,    30,
       0,     0,     0,   586,   521,  2032,     0,     0,  1345,     0,
    1346,  1347,  1348,     0,     0,     0,     0,     0,  2704,    31,
    1349,    32,    33,     0,     0,    34,     0,     0,    35,     0,
      36,     0,  1994,     0,     0,    37,     0,    38,     0,     0,
    1998,     0,     0,     0,     0,  2705,    39,     0,     0,     0,
      40,     0,     0,     0,  2706,  2707,    41,  2708,     0,     0,
       0,    42,     0,     0,     0,    43,     0,  2023,     0,     0,
       0,     0,     0,     0,     0,   522,     0,     0,     0,   465,
       0,     0,  2040,  1350,    44,  2709,  2710,  2711,    45,  1325,
    1326,  1327,  1328,  1329,  1330,  1331,  1332,     0,     0,     0,
       0,     0,     0,   523,     0,  2712,  2713,  2714,     0,     0,
       0,  2715,     0,     0,  2716,     0,     0,   524,     0,     0,
       0,     0,    46,     0,     0,     0,     0,  2717,  2718,     0,
    1351,  1352,     0,     0,     0,     0,     0,     0,    47,   525,
       0,    48,     0,     0,     0,     0,    49,     0,     0,     0,
     526,     0,  2719,     0,  2720,     0,     0,     0,     0,  1316,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,  2721,     0,     0,   527,
    1508,  1509,     0,     0,     0,     0,     0,     0,  1506,     0,
      51,     0,     0,     0,     0,  1507,     0,     0,     0,     0,
       0,     0,     0,     0,   528,  1508,  1509,     0,     0,     0,
     529,  -457,  -457,  1511,     0,     0,     0,     0,     0,  2722,
    -457,  2723,     0,     0,  1512,     0,     0,     0,     0,     0,
       0,  2724,     0,  1513,  1510,     0,     0,     0,  1511,     0,
       0,     0,     0,     0,  1353,  2206,     0,   530,     0,  1512,
    1515,     0,     0,     0,     0,  1354,  1355,     0,  1513,     0,
       0,  1317,     0,  1514,     0,  1069,     0,     0,  1516,     0,
       0,     0,  2725,  2726,     0,  1515,  2727,  2728,  2729,  2730,
       0,     0,  1318,     0,     0,     0,     0,     0,     0,     0,
    1069,     0,     0,  1516,     0,     0,     0,  1521,     0,     0,
       0,     0,  1517,     0,     0,     0,     0,     0,  1519,     0,
       0,     0,     0,     0,     0,     0,  1520,     0,     0,  2731,
    2732,     0,  1521,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2733,     0,
       0,     0,  1319,     0,     0,     0,  2264,  1522,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   531,     0,
       0,   700,   701,     0,  2283,  2285,     0,     0,     0,     0,
    1524,   553,     0,   553,   553,   532,     0,  1525,     0,     0,
     606,   533,   568,   607,     0,     0,     0,   534,     0,     0,
       0,     0,     0,     0,     0,  1524,     0,     0,     0,     0,
       0,     0,  1525,     0,   608,   609,     0,  1741,     0,     0,
       0,   535,     0,     0,   610,     0,   611,     0,     0,   553,
     553,  1320,   536,   537,     0,     0,     0,     0,     0,  1994,
       0,     0,     0,   612,   613,  1994,     0,     0,  1994,     0,
       0,  1994,   614,  1526,     0,     0,     0,     0,     0,     0,
       0,     0,  1994,  1994,     0,   553,     0,  1527,   538,  1508,
    1509,  1994,  1741,     0,     0,  1321,  1322,     0,  1526,     0,
       0,   465,     0,   553,  1323,     0,     0,  1994,  2410,     0,
       0,     0,  1527,     0,     0,     0,     0,  1528,     0, -1331,
     615,     0,  1511,     0,   616,     0,     0,     0,     0,     0,
       0,   883,   539,  1512,   540,  3472,     0,     0,  1530,     0,
    1531,     0,  1513,     0,     0,     0,     0,     0,     0,   465,
    1994,     0,     0,   617,     0,   618,     0,  1529,     0,  1515,
       0,  1532,  1533,  1530,  1534,  1531,     0,   619,     0,   620,
       0,     0,     0,     0,  1069,   553,     0,  1516,     0,     0,
       0,     0,   553,     0,   953,     0,  1532,  1533,     0,  1534,
       0,     0,   621,   622,     0,  2480,   623,     0,     0,     0,
    1536,     0,     0,  1535,     0,     0,  1521,     0,     0,     0,
       0,   624,  3539,     0,     0,  1324,  1325,  1326,  1327,  1328,
    1329,  1330,  1331,  1332,     0,  1536,     0,  3556,     0,  3556,
       0,     0,   625,     0,     0,  3563,     0,   626,     0,     0,
       0,  1638,  1096,  1097,  1098,  1099,  1100,  1101,     0,     0,
    1102,  1103,  1104,  1105,  1106,  1107,     0,  1108,     0,     0,
       0,   627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3556,     0,     0,     0,     0,     0,     0,  3607,  1524,
       0,  1537,     0,     0,     0,     0,  1525,     0,     0,     0,
    1538,     0,     0,   628,     0,     0,     0,     0,     0,     0,
       0,     0,   629,     0,     0,     0,  1537,     0,  3556,     0,
       0,     0,  1095,  3556,     0,  1538,     0,     0,     0,     0,
     630,     0,   553,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3556,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   631,   632,  2574,     0,     0,
       0,  1810,  1526,   951,   553,   553,   553,     0,     0,  3556,
    3556,  1109,  1110,  3679,   465,     0,  1527,     0,   553,     0,
       0,  1741,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   553,   553,   553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2617,  3484,
       0,     0,     0,     0,  2619,   633,  2621,     0,     0,     0,
       0,     0,     0,     0,   553,   634,     0,  1530,     0,  1531,
       0,  1212,     0,     0,     0,     0,  3484,  3484,     0,     0,
       0,     0,     0,     0,     0, -1762,     0,     0,     0,   635,
    1532,  1533,     0,  1534,     0,     0,     0,  1238,     0,     0,
       0,     0,   636,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3484,
    3484,     0,     0,     0,  1994,     0,  3484,     0,     0,  1536,
       0,     0,     0,     0,     0,   553,     0,     0,  1994,     0,
       0,  3484,     0,  3484,     0,     0,     0,  1288,     0,  3484,
       0,  1295,     0,     0,     0,     0, -1762,     0,     0,     0,
     637,  3484,     0,     0,     0,     0,     0,     0,     0,     0,
    3484,  3484,   465,     0,     0,     0,     0,     0,     0,  2686,
       0,     0,   465,     0,     0,  3484,  2742,  2743,     0,     0,
    2746,     0,  3484,     0,     0,     0,     0,     0,  2753,     0,
       0,     0,  3484,     0,     0,     0,   465,     0,     0,  3484,
    1537,     0,     0,     0,     0,     0,     0,     0,     0,  1538,
       0,     0,  3484,     0,     0,  3484,     0,  3484,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3484,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3484,
       0,  3484,     0,     0,     0,     0,  1428,     0,     0,     0,
       0,     0,     0,  3484,  3484,  1443,     0,  3484,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2264,  2893,
       0,   553,     0,     0,     0,     0,     0,     0,     0,     0,
     553,     0,     0,     0,     0,     0,  2574,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   553,     0,     0,     0,
       0,     0,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1741,     0,     0,     0,     0,  1600,  1601,  1602,     0,
       0,     0,     0,  1994,     0,  1617,  1618,     0,     0,  1621,
    1994,  1623,  1624,  1625,  1626,     0,     0,  1741,  1630,     0,
       0,  1632,  1633,  1994,  1634,     0,  1635,  1636,     0,  1639,
    1640,  1641,  1642,  1643,     0,  1646,     0,  1648,  1649,  1650,
       0,  1652,  1653,  1654,  1655,     0,  1657,  1658,     0,  1664,
       0,     0,  1668,  1669,  1670,     0,  1672,  1673,  1674,  1675,
       0,  1677,  1678,  1679,  1680,     0,     0,     0,     0,     0,
    1687,  1688,     0,  1691,  1692,  1693,  1694,  1695,     0,     0,
       0,     0,  1699,     0,  1700,  1701,  1702,  1703,  1704,     0,
       0,  1707,  1709,  1710,  1711,  1712,  1713,     0,  1715,  1716,
    3034,     0,  1719,  1720,  1721,     0,  1724,     0,  1725,     0,
       0,     0,  1728,     0,  1732,  1733,     0,     0,     0,     0,
    1736,     0,     0,     0,     0,     0,     0,     0,  1743,  1744,
    1745,     0,     0,     0,     0,     0,     0,  1295,     0,     0,
    1753,     0,     0,     0,     0,     0,     0,  1758,  1759,  1760,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3069,     0,     0,  1797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1741,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1842,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3034,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   553,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   553,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3188,     0,  3189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   465,
       0,  2753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1999,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2283,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3274,     0,
       0,     0,     0,     0,  3034,  3034,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3292,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3034,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2175,  2177,  2179,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2193,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2224,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1741,   465,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3274,     0,  3274,     0,  3421,  1998,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3429,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3449,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1741,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3498,     0,     0,     0,     0,  3505,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3524,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2454,     0,     0,
    2455,     0,     0,  2457,  2458,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2471,  3592,     0,  2474,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3605,     0,  2481,     0,  2482,     0,     0,     0,  2485,     0,
    2486,  2487,     0,     0,     0,  2490,     0,  2491,  2492,     0,
    2493,     0,     0,  2494,     0,  2495,  2496,     0,  1741,     0,
    3633,  2500,  2501,     0,     0,  2503,     0,  2504,  3641,  2505,
       0,  2506,     0,  2508,     0,   553,     0,     0,     0,  1741,
       0,     0,     0,     0,  2513,  2514,     0,     0,  2515,     0,
    2516,     0,     0,     0,     0,  1741,     0,     0,  2517,  2518,
       0,  2519,  3673,  2520,     0,     0,  2521,  2522,  2523,     0,
    2524,     0,     0,     0,     0,  2527,  2528,  2529,  2530,     0,
       0,     0,     0,  2532,  2533,  2534,  3673,  2535,     0,  2537,
       0,  2539,     0,  2541,     0,  2542,     0,     0,     0,     0,
       0,     0,  2544,     0,  2545,     0,     0,  2547,  2548,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2557,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2564,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2582,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2626,     0,     0,     0,     0,  2630,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2664,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2766,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2837,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2848,
       0,  2850,     0,  2852,     0,     0,     0,     0,     0,  2858,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2870,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2915,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3040,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3044,     0,
       0,     0,     0,     0,  3045,     0,     0,     0,     0,     0,
       0,     0,     0,  3049,  3050,     0,     0,     0,     0,  3051,
       0,     0,     0,  3052,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3056,     0,     0,     0,
       0,     0,  3058,     0,     0,  3059,  3060,     0,  3061,  3062,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3067,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3118,
    3119,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2626,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3325,     0,     0,     0,     0,     0,  3327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3343,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3355,     0,  3357,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3444,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3458,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3527,
    3528,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3549,
       0,     0,     0,     0,     0,     0,     0,     0,  3559,     0,
       0,     0,     0,     0,     0,  3565,     0,     0,     0,     0,
       0,     0,     0,     0,  3575,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3599,     0,     0,     0,     0,   122,     0,
     737,   124,   125,   126,   127,     0,     0,  3614,     0,     0,
     128,     0,     0,   738,     0,   739,   130,   131,   740,   133,
       0,   134,   741,   135,     0,   742,   136,   743,   744,   745,
     137,   746,     0,   138,   139,  1729,   140,     0,   141,   142,
       0,     0,   143,   747,   144,     0,   145,   748,   749,   147,
       0,   148,   149,   150,   750,   151,     0,   751,   153,     0,
     154,   155,   156,   157,   158,   752,   753,   159,  3674,   160,
     161,     0,   754,     0,   755,   756,   757,     0,     0,   163,
     758,   759,     0,   760,   761,     0,   164,   165,   762,   763,
     764,     0,     0,     0,     0,   765,   168,   766,     0,     0,
     767,   768,   169,     0,   170,     0,     0,     0,   769,   770,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   771,   179,     0,   772,
     773,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   774,     0,   188,   775,   189,   776,   777,   190,
       0,   778,   191,   192,   193,   779,     0,   194,     0,     0,
     780,     0,   195,   196,     0,   781,   197,     0,   198,   782,
     783,   784,   785,     0,   786,   787,   200,   788,   789,   790,
     202,     0,   203,   791,     0,   792,   793,     0,   204,   205,
       0,   206,   794,     0,   207,     0,     0,     0,   795,   209,
     210,   211,   796,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   797,   215,   798,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   799,
     220,     0,  1730,   800,   221,     0,   801,   222,     0,     0,
       0,   802,     0,   803,     0,   224,   804,     0,   225,     0,
     226,   805,     0,     0,   806,     0,     0,     0,     0,   807,
     227,   228,   229,   230,   231,   232,   808,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   809,   242,   243,   244,
     810,   245,   246,     0,     0,     0,   247,   248,   811,   250,
       0,     0,   812,   252,   813,   814,   253,     0,   254,   815,
     816,   817,   818,   819,   820,   821,   259,   260,   261,   262,
       0,   822,   263,   264,     0,   265,   266,   267,   823,   824,
     825,   268,     0,   826,   827,     0,   269,   270,     0,   828,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   829,   830,   278,   831,
     832,   833,   834,   835,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   836,   287,   288,   289,   290,   291,   292,
     293,   837,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   838,   839,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   840,
     308,   309,   841,   310,   311,   842,   312,   843,   314,   315,
       0,   844,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   845,
     846,   334,   335,     0,   336,   847,   338,   848,   849,   850,
     339,   340,   851,   341,   342,     0,   343,   344,     0,   852,
     345,   853,   854,   855,   856,     0,     0,     0,     0,  1731,
     350,     0,   351,   857,   858,   859,   353,   354,   355,     0,
     860,   356,   357,   861,     0,   358,     0,     0,   862,   863,
     359,     0,     0,   360,     0,   361,     0,   864,   363,     0,
       0,   865,   866,   867,   868,   869,   364,     0,     0,   365,
     870,     0,   366,   367,   871,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   872,     0,   873,     0,     0,     0,
       0,   874,     0,     0,     0,   875,   876,     0,     0,     0,
       0,   877,     0,   878,     0,     0,   879,   880,     0,   881,
     882,   122,     0,   737,   124,   125,   126,   127,  2622,     0,
       0,     0,     0,   128,     0,     0,   738,     0,   739,   130,
     131,   740,   133,     0,   134,   741,   135,     0,  2623,   136,
     743,   744,   745,   137,   746,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   747,   144,     0,   145,
     748,   749,   147,     0,   148,   149,   150,   750,   151,     0,
     751,   153,     0,   154,   155,   156,   157,   158,   752,   753,
     159,     0,   160,   161,     0,   754,     0,   755,   756,   757,
       0,     0,   163,   758,   759,     0,   760,   761,     0,   164,
     165,   762,   763,   764,     0,     0,     0,     0,   765,   168,
     766,     0,     0,   767,  2624,   169,     0,   170,     0,     0,
       0,   769,   770,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   771,
     179,     0,   772,   773,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   774,     0,   188,   775,   189,
     776,   777,   190,     0,   778,   191,   192,   193,   779,     0,
     194,     0,     0,   780,     0,   195,   196,     0,   781,   197,
       0,   198,   782,   783,   784,   785,     0,   786,   787,   200,
     788,   789,   790,   202,     0,   203,   791,     0,   792,   793,
       0,   204,   205,     0,   206,   794,     0,   207,     0,     0,
       0,   795,   209,   210,   211,   796,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   797,   215,   798,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   799,   220,     0,     0,   800,   221,     0,   801,
     222,     0,     0,     0,   802,     0,   803,     0,   224,   804,
       0,   225,     0,   226,   805,     0,     0,   806,     0,     0,
       0,     0,   807,   227,   228,   229,   230,   231,   232,   808,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   809,
     242,   243,   244,   810,   245,   246,     0,     0,     0,   247,
     248,   811,   250,     0,     0,   812,   252,   813,   814,   253,
       0,   254,   815,   816,   817,   818,   819,   820,   821,   259,
     260,   261,   262,     0,   822,   263,   264,     0,   265,   266,
     267,   823,   824,   825,   268,     0,   826,   827,     0,   269,
     270,     0,   828,  2625,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   829,
     830,   278,   831,   832,   833,   834,   835,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   836,   287,   288,   289,
     290,   291,   292,   293,   837,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     838,   839,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   840,   308,   309,   841,   310,   311,   842,   312,
     843,   314,   315,     0,   844,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   845,   846,   334,   335,     0,   336,   847,   338,
     848,   849,   850,   339,   340,   851,   341,   342,     0,   343,
     344,     0,   852,   345,   853,   854,   855,   856,     0,     0,
       0,     0,     0,   350,     0,   351,   857,   858,   859,   353,
     354,   355,     0,   860,   356,   357,   861,     0,   358,     0,
       0,   862,   863,   359,     0,     0,   360,     0,   361,     0,
     864,   363,     0,     0,   865,   866,   867,   868,   869,   364,
       0,     0,   365,   870,     0,   366,   367,   871,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   872,     0,   873,
       0,     0,     0,     0,   874,     0,     0,     0,   875,   876,
       0,     0,     0,     0,   877,     0,   878,     0,     0,   879,
     880,     0,   881,   882,   122,     0,   737,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   738,
       0,   739,   130,   131,   740,   133,     0,   134,   741,   135,
       0,   742,   136,   743,   744,   745,   137,   746,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   747,
     144,     0,   145,   748,   749,   147,     0,   148,   149,   150,
     750,   151,     0,   751,   153,     0,   154,   155,   156,   157,
     158,   752,   753,   159,     0,   160,   161,     0,   754,     0,
     755,   756,   757,     0,     0,   163,   758,   759,     0,   760,
     761,     0,   164,   165,   762,   763,   764,     0,     0,     0,
       0,   765,   168,   766,     0,     0,   767,   768,   169,     0,
     170,     0,     0,     0,   769,   770,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   771,   179,     0,   772,   773,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   774,     0,
     188,   775,   189,   776,   777,   190,     0,   778,   191,   192,
     193,   779,     0,   194,     0,     0,   780,     0,   195,   196,
       0,   781,   197,     0,   198,   782,   783,   784,   785,     0,
     786,   787,   200,   788,   789,   790,   202,     0,   203,   791,
       0,   792,   793,     0,   204,   205,     0,   206,   794,     0,
     207,     0,     0,     0,   795,   209,   210,   211,   796,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   797,   215,
     798,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   799,   220,     0,     0,   800,
     221,     0,   801,   222,     0,     0,     0,   802,     0,   803,
       0,   224,   804,     0,   225,     0,   226,   805,     0,     0,
     806,     0,     0,     0,     0,   807,   227,   228,   229,   230,
     231,   232,   808,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   809,   242,   243,   244,   810,   245,   246,     0,
       0,     0,   247,   248,   811,   250,     0,     0,   812,   252,
     813,   814,   253,     0,   254,   815,   816,   817,   818,   819,
     820,   821,   259,   260,   261,   262,     0,   822,   263,   264,
       0,   265,   266,   267,   823,   824,   825,   268,     0,   826,
     827,     0,   269,   270,     0,   828,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   829,   830,   278,   831,   832,   833,   834,   835,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   836,
     287,   288,   289,   290,   291,   292,   293,   837,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   838,   839,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   840,   308,   309,   841,   310,
     311,   842,   312,   843,   314,   315,     0,   844,   317,  1293,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   845,   846,   334,   335,     0,
     336,   847,   338,   848,   849,   850,   339,   340,   851,   341,
     342,     0,   343,   344,     0,   852,   345,   853,   854,   855,
     856,     0,     0,     0,     0,     0,   350,     0,   351,   857,
     858,   859,   353,   354,   355,     0,   860,   356,   357,   861,
       0,   358,     0,     0,   862,   863,   359,     0,     0,   360,
       0,   361,     0,   864,   363,     0,     0,   865,   866,   867,
     868,   869,   364,     0,     0,   365,   870,     0,   366,   367,
     871,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     872,     0,   873,     0,     0,     0,     0,   874,     0,     0,
       0,   875,   876,     0,     0,     0,     0,   877,     0,  1294,
       0,     0,   879,   880,     0,   881,   882,   122,     0,   737,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   738,     0,   739,   130,   131,   740,   133,     0,
     134,   741,   135,     0,   742,   136,   743,   744,   745,   137,
     746,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   747,   144,     0,   145,   748,   749,   147,     0,
     148,   149,   150,   750,   151,     0,   751,   153,     0,   154,
     155,   156,   157,   158,   752,   753,   159,     0,   160,   161,
       0,   754,     0,   755,   756,   757,     0,     0,   163,   758,
     759,     0,   760,   761,     0,   164,   165,   762,   763,   764,
       0,     0,     0,     0,   765,   168,   766,     0,     0,   767,
     768,   169,     0,   170,     0,     0,     0,   769,   770,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   771,   179,     0,   772,   773,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   774,     0,   188,   775,   189,   776,   777,   190,     0,
     778,   191,   192,   193,   779,     0,   194,     0,     0,   780,
       0,   195,   196,     0,   781,   197,     0,   198,   782,   783,
     784,   785,     0,   786,   787,   200,   788,   789,   790,   202,
       0,   203,   791,     0,   792,   793,     0,   204,   205,     0,
     206,   794,     0,   207,     0,     0,     0,   795,   209,   210,
     211,   796,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   797,   215,   798,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   799,   220,
       0,     0,   800,   221,     0,   801,   222,     0,     0,     0,
     802,     0,   803,     0,   224,   804,     0,   225,     0,   226,
     805,     0,     0,   806,     0,     0,     0,     0,   807,   227,
     228,   229,   230,   231,   232,   808,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   809,   242,   243,   244,   810,
     245,   246,     0,     0,     0,   247,   248,   811,   250,     0,
       0,   812,   252,   813,   814,   253,     0,   254,   815,   816,
     817,   818,   819,   820,   821,   259,   260,   261,   262,     0,
     822,   263,   264,     0,   265,   266,   267,   823,   824,   825,
     268,     0,   826,   827,     0,   269,   270,     0,   828,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   829,   830,   278,   831,   832,
     833,   834,   835,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   836,   287,   288,   289,   290,   291,   292,   293,
     837,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   838,   839,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   840,   308,
     309,   841,   310,   311,   842,   312,   843,   314,   315,     0,
     844,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   845,   846,
     334,   335,     0,   336,   847,   338,   848,   849,   850,   339,
     340,   851,   341,   342,     0,   343,   344,     0,   852,   345,
     853,   854,   855,   856,     0,     0,     0,     0,     0,   350,
       0,   351,   857,   858,   859,   353,   354,   355,     0,   860,
     356,   357,   861,     0,   358,     0,     0,   862,   863,   359,
       0,     0,   360,     0,   361,     0,   864,   363,     0,     0,
     865,   866,   867,   868,   869,   364,     0,     0,   365,   870,
       0,   366,   367,   871,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   872,     0,   873,     0,     0,     0,     0,
     874,     0,     0,     0,   875,   876,     0,     0,     0,     0,
     877,     0,   878,  1575,     0,   879,   880,     0,   881,   882,
     122,     0,   737,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   738,     0,   739,   130,   131,
     740,   133,     0,   134,   741,   135,     0,   742,   136,   743,
     744,   745,   137,   746,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   747,   144,     0,   145,   748,
     749,   147,     0,   148,   149,   150,   750,   151,     0,   751,
     153,     0,   154,   155,   156,   157,   158,   752,   753,   159,
       0,   160,   161,     0,   754,     0,   755,   756,   757,     0,
       0,   163,   758,   759,     0,   760,   761,     0,   164,   165,
     762,   763,   764,     0,     0,     0,     0,   765,   168,   766,
       0,     0,   767,   768,   169,     0,   170,     0,     0,     0,
     769,   770,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   771,   179,
       0,   772,   773,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   774,     0,   188,   775,   189,   776,
     777,   190,     0,   778,   191,   192,   193,   779,     0,   194,
       0,     0,   780,     0,   195,   196,     0,   781,   197,     0,
     198,   782,   783,   784,   785,     0,   786,   787,   200,   788,
     789,   790,   202,     0,   203,   791,     0,   792,   793,     0,
     204,   205,     0,   206,   794,     0,   207,     0,     0,     0,
     795,   209,   210,   211,   796,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   797,   215,   798,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   799,   220,     0,     0,   800,   221,     0,   801,   222,
       0,     0,     0,   802,     0,   803,     0,   224,   804,     0,
     225,     0,   226,   805,     0,     0,   806,     0,     0,     0,
       0,   807,   227,   228,   229,   230,   231,   232,   808,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   809,   242,
     243,   244,   810,   245,   246,     0,     0,     0,   247,   248,
     811,   250,     0,     0,   812,   252,   813,   814,   253,     0,
     254,   815,   816,   817,   818,   819,   820,   821,   259,   260,
     261,   262,     0,   822,   263,   264,     0,   265,   266,   267,
     823,   824,   825,   268,     0,   826,   827,     0,   269,   270,
       0,   828,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   829,   830,
     278,   831,   832,   833,   834,   835,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   836,   287,   288,   289,   290,
     291,   292,   293,   837,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   838,
     839,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   840,   308,   309,   841,   310,   311,   842,   312,   843,
     314,   315,     0,   844,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   845,   846,   334,   335,     0,   336,   847,   338,   848,
     849,   850,   339,   340,   851,   341,   342,     0,   343,   344,
       0,   852,   345,   853,   854,   855,   856,     0,     0,     0,
       0,     0,   350,     0,   351,   857,   858,   859,   353,   354,
     355,     0,   860,   356,   357,   861,     0,   358,     0,     0,
     862,   863,   359,     0,     0,   360,     0,   361,     0,   864,
     363,     0,     0,   865,   866,   867,   868,   869,   364,     0,
       0,   365,   870,     0,   366,   367,   871,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   872,     0,   873,     0,
       0,     0,     0,   874,     0,     0,     0,   875,   876,     0,
       0,     0,     0,   877,     0,   878,  1671,     0,   879,   880,
       0,   881,   882,   122,     0,   737,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   738,     0,
     739,   130,   131,   740,   133,     0,   134,   741,   135,     0,
     742,   136,   743,   744,   745,   137,   746,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   747,   144,
       0,   145,   748,   749,   147,     0,   148,   149,   150,   750,
     151,     0,   751,   153,     0,   154,   155,   156,   157,   158,
     752,   753,   159,     0,   160,   161,     0,   754,     0,   755,
     756,   757,     0,     0,   163,   758,   759,     0,   760,   761,
       0,   164,   165,   762,   763,   764,     0,     0,     0,     0,
     765,   168,   766,     0,     0,   767,   768,   169,     0,   170,
       0,     0,     0,   769,   770,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   771,   179,     0,   772,   773,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   774,     0,   188,
     775,   189,   776,   777,   190,     0,   778,   191,   192,   193,
     779,     0,   194,     0,     0,   780,     0,   195,   196,     0,
     781,   197,     0,   198,   782,   783,   784,   785,     0,   786,
     787,   200,   788,   789,   790,   202,     0,   203,   791,     0,
     792,   793,     0,   204,   205,     0,   206,   794,     0,   207,
       0,     0,     0,   795,   209,   210,   211,   796,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   797,   215,   798,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   799,   220,     0,     0,   800,   221,
       0,   801,   222,     0,     0,     0,   802,     0,   803,     0,
     224,   804,     0,   225,     0,   226,   805,     0,     0,   806,
       0,     0,     0,     0,   807,   227,   228,   229,   230,   231,
     232,   808,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   809,   242,   243,   244,   810,   245,   246,     0,     0,
       0,   247,   248,   811,   250,     0,     0,   812,   252,   813,
     814,   253,     0,   254,   815,   816,   817,   818,   819,   820,
     821,   259,   260,   261,   262,     0,   822,   263,   264,     0,
     265,   266,   267,   823,   824,   825,   268,     0,   826,   827,
       0,   269,   270,     0,   828,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   829,   830,   278,   831,   832,   833,   834,   835,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   836,   287,
     288,   289,   290,   291,   292,   293,   837,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   838,   839,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   840,   308,   309,   841,   310,   311,
     842,   312,   843,   314,   315,     0,   844,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   845,   846,   334,   335,     0,   336,
     847,   338,   848,   849,   850,   339,   340,   851,   341,   342,
       0,   343,   344,     0,   852,   345,   853,   854,   855,   856,
       0,     0,     0,     0,     0,   350,     0,   351,   857,   858,
     859,   353,   354,   355,     0,   860,   356,   357,   861,     0,
     358,     0,     0,   862,   863,   359,     0,     0,   360,     0,
     361,     0,   864,   363,     0,     0,   865,   866,   867,   868,
     869,   364,     0,     0,   365,   870,     0,   366,   367,   871,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   872,
       0,   873,     0,     0,     0,     0,   874,     0,     0,     0,
     875,   876,     0,     0,     0,     0,   877,     0,   878,  1708,
       0,   879,   880,     0,   881,   882,   122,     0,   737,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   738,     0,   739,   130,   131,   740,   133,     0,   134,
     741,   135,     0,   742,   136,   743,   744,   745,   137,   746,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   747,   144,     0,   145,   748,   749,   147,     0,   148,
     149,   150,   750,   151,     0,   751,   153,     0,   154,   155,
     156,   157,   158,   752,   753,   159,     0,   160,   161,     0,
     754,     0,   755,   756,   757,     0,     0,   163,   758,   759,
       0,   760,   761,     0,   164,   165,   762,   763,   764,     0,
       0,     0,     0,   765,   168,   766,     0,     0,   767,   768,
     169,     0,   170,     0,     0,     0,   769,   770,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   771,   179,     0,   772,   773,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     774,     0,   188,   775,   189,   776,   777,   190,     0,   778,
     191,   192,   193,   779,     0,   194,     0,     0,   780,     0,
     195,   196,     0,   781,   197,     0,   198,   782,   783,   784,
     785,     0,   786,   787,   200,   788,   789,   790,   202,     0,
     203,   791,     0,   792,   793,     0,   204,   205,     0,   206,
     794,     0,   207,     0,     0,     0,   795,   209,   210,   211,
     796,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     797,   215,   798,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   799,   220,     0,
       0,   800,   221,     0,   801,   222,     0,     0,     0,   802,
       0,   803,     0,   224,   804,     0,   225,     0,   226,   805,
       0,     0,   806,     0,     0,     0,     0,   807,   227,   228,
     229,   230,   231,   232,   808,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   809,   242,   243,   244,   810,   245,
     246,     0,     0,     0,   247,   248,   811,   250,     0,     0,
     812,   252,   813,   814,   253,     0,   254,   815,   816,   817,
     818,   819,   820,   821,   259,   260,   261,   262,     0,   822,
     263,   264,     0,   265,   266,   267,   823,   824,   825,   268,
       0,   826,   827,     0,   269,   270,     0,   828,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   829,   830,   278,   831,   832,   833,
     834,   835,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   836,   287,   288,   289,   290,   291,   292,   293,   837,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   838,   839,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   840,   308,   309,
     841,   310,   311,   842,   312,   843,   314,   315,     0,   844,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   845,   846,   334,
     335,     0,   336,   847,   338,   848,   849,   850,   339,   340,
     851,   341,   342,     0,   343,   344,     0,   852,   345,   853,
     854,   855,   856,     0,     0,     0,     0,     0,   350,     0,
     351,   857,   858,   859,   353,   354,   355,     0,   860,   356,
     357,   861,     0,   358,     0,     0,   862,   863,   359,     0,
       0,   360,     0,   361,     0,   864,   363,     0,     0,   865,
     866,   867,   868,   869,   364,     0,     0,   365,   870,     0,
     366,   367,   871,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   872,     0,   873,     0,     0,     0,     0,   874,
       0,     0,     0,   875,   876,     0,     0,     0,     0,   877,
       0,   878,  1735,     0,   879,   880,     0,   881,   882,   122,
       0,   737,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   738,     0,   739,   130,   131,   740,
     133,     0,   134,   741,   135,     0,   742,   136,   743,   744,
     745,   137,   746,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   747,   144,     0,   145,   748,   749,
     147,     0,   148,   149,   150,   750,   151,     0,   751,   153,
       0,   154,   155,   156,   157,   158,   752,   753,   159,     0,
     160,   161,     0,   754,     0,   755,   756,   757,     0,     0,
     163,   758,   759,     0,   760,   761,     0,   164,   165,   762,
     763,   764,     0,     0,     0,     0,   765,   168,   766,     0,
       0,   767,   768,   169,     0,   170,     0,     0,     0,   769,
     770,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   771,   179,     0,
     772,   773,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   774,     0,   188,   775,   189,   776,   777,
     190,     0,   778,   191,   192,   193,   779,     0,   194,     0,
       0,   780,     0,   195,   196,  2174,   781,   197,     0,   198,
     782,   783,   784,   785,     0,   786,   787,   200,   788,   789,
     790,   202,     0,   203,   791,     0,   792,   793,     0,   204,
     205,     0,   206,   794,     0,   207,     0,     0,     0,   795,
     209,   210,   211,   796,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   797,   215,   798,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     799,   220,     0,     0,   800,   221,     0,   801,   222,     0,
       0,     0,   802,     0,   803,     0,   224,   804,     0,   225,
       0,   226,   805,     0,     0,   806,     0,     0,     0,     0,
     807,   227,   228,   229,   230,   231,   232,   808,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   809,   242,   243,
     244,   810,   245,   246,     0,     0,     0,   247,   248,   811,
     250,     0,     0,   812,   252,   813,   814,   253,     0,   254,
     815,   816,   817,   818,   819,   820,   821,   259,   260,   261,
     262,     0,   822,   263,   264,     0,   265,   266,   267,   823,
     824,   825,   268,     0,   826,   827,     0,   269,   270,     0,
     828,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   829,   830,   278,
     831,   832,   833,   834,   835,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   836,   287,   288,   289,   290,   291,
     292,   293,   837,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   838,   839,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     840,   308,   309,   841,   310,   311,   842,   312,   843,   314,
     315,     0,   844,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     845,   846,   334,   335,     0,   336,   847,   338,   848,   849,
     850,   339,   340,   851,   341,   342,     0,   343,   344,     0,
     852,   345,   853,   854,   855,   856,     0,     0,     0,     0,
       0,   350,     0,   351,   857,   858,   859,   353,   354,   355,
       0,   860,   356,   357,   861,     0,   358,     0,     0,   862,
     863,   359,     0,     0,   360,     0,   361,     0,   864,   363,
       0,     0,   865,   866,   867,   868,   869,   364,     0,     0,
     365,   870,     0,   366,   367,   871,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   872,     0,   873,     0,     0,
       0,     0,   874,     0,     0,     0,   875,   876,     0,     0,
       0,     0,   877,     0,   878,     0,     0,   879,   880,     0,
     881,   882,   122,     0,   737,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   738,     0,   739,
     130,   131,   740,   133,     0,   134,   741,   135,     0,   742,
     136,   743,   744,   745,   137,   746,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   747,   144,     0,
     145,   748,   749,   147,     0,   148,   149,   150,   750,   151,
       0,   751,   153,     0,   154,   155,   156,   157,   158,   752,
     753,   159,     0,   160,   161,     0,   754,     0,   755,   756,
     757,     0,     0,   163,   758,   759,     0,   760,   761,     0,
     164,   165,   762,   763,   764,     0,     0,     0,     0,   765,
     168,   766,     0,     0,   767,   768,   169,     0,   170,     0,
       0,     0,   769,   770,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     771,   179,     0,   772,   773,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   774,     0,   188,   775,
     189,   776,   777,   190,     0,   778,   191,   192,   193,   779,
       0,   194,     0,     0,   780,     0,   195,   196,  2176,   781,
     197,     0,   198,   782,   783,   784,   785,     0,   786,   787,
     200,   788,   789,   790,   202,     0,   203,   791,     0,   792,
     793,     0,   204,   205,     0,   206,   794,     0,   207,     0,
       0,     0,   795,   209,   210,   211,   796,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   797,   215,   798,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   799,   220,     0,     0,   800,   221,     0,
     801,   222,     0,     0,     0,   802,     0,   803,     0,   224,
     804,     0,   225,     0,   226,   805,     0,     0,   806,     0,
       0,     0,     0,   807,   227,   228,   229,   230,   231,   232,
     808,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     809,   242,   243,   244,   810,   245,   246,     0,     0,     0,
     247,   248,   811,   250,     0,     0,   812,   252,   813,   814,
     253,     0,   254,   815,   816,   817,   818,   819,   820,   821,
     259,   260,   261,   262,     0,   822,   263,   264,     0,   265,
     266,   267,   823,   824,   825,   268,     0,   826,   827,     0,
     269,   270,     0,   828,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     829,   830,   278,   831,   832,   833,   834,   835,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   836,   287,   288,
     289,   290,   291,   292,   293,   837,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   838,   839,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   840,   308,   309,   841,   310,   311,   842,
     312,   843,   314,   315,     0,   844,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   845,   846,   334,   335,     0,   336,   847,
     338,   848,   849,   850,   339,   340,   851,   341,   342,     0,
     343,   344,     0,   852,   345,   853,   854,   855,   856,     0,
       0,     0,     0,     0,   350,     0,   351,   857,   858,   859,
     353,   354,   355,     0,   860,   356,   357,   861,     0,   358,
       0,     0,   862,   863,   359,     0,     0,   360,     0,   361,
       0,   864,   363,     0,     0,   865,   866,   867,   868,   869,
     364,     0,     0,   365,   870,     0,   366,   367,   871,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   872,     0,
     873,     0,     0,     0,     0,   874,     0,     0,     0,   875,
     876,     0,     0,     0,     0,   877,     0,   878,     0,     0,
     879,   880,     0,   881,   882,   122,     0,   737,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     738,     0,   739,   130,   131,   740,   133,     0,   134,   741,
     135,     0,   742,   136,   743,   744,   745,   137,   746,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     747,   144,     0,   145,   748,   749,   147,     0,   148,   149,
     150,   750,   151,     0,   751,   153,     0,   154,   155,   156,
     157,   158,   752,   753,   159,     0,   160,   161,     0,   754,
       0,   755,   756,   757,     0,     0,   163,   758,   759,     0,
     760,   761,     0,   164,   165,   762,   763,   764,     0,     0,
       0,     0,   765,   168,   766,     0,     0,   767,   768,   169,
       0,   170,     0,     0,     0,   769,   770,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   771,   179,     0,   772,   773,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   774,
       0,   188,   775,   189,   776,   777,   190,     0,   778,   191,
     192,   193,   779,     0,   194,     0,     0,   780,     0,   195,
     196,  2178,   781,   197,     0,   198,   782,   783,   784,   785,
       0,   786,   787,   200,   788,   789,   790,   202,     0,   203,
     791,     0,   792,   793,     0,   204,   205,     0,   206,   794,
       0,   207,     0,     0,     0,   795,   209,   210,   211,   796,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   797,
     215,   798,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   799,   220,     0,     0,
     800,   221,     0,   801,   222,     0,     0,     0,   802,     0,
     803,     0,   224,   804,     0,   225,     0,   226,   805,     0,
       0,   806,     0,     0,     0,     0,   807,   227,   228,   229,
     230,   231,   232,   808,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   809,   242,   243,   244,   810,   245,   246,
       0,     0,     0,   247,   248,   811,   250,     0,     0,   812,
     252,   813,   814,   253,     0,   254,   815,   816,   817,   818,
     819,   820,   821,   259,   260,   261,   262,     0,   822,   263,
     264,     0,   265,   266,   267,   823,   824,   825,   268,     0,
     826,   827,     0,   269,   270,     0,   828,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   829,   830,   278,   831,   832,   833,   834,
     835,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     836,   287,   288,   289,   290,   291,   292,   293,   837,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   838,   839,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   840,   308,   309,   841,
     310,   311,   842,   312,   843,   314,   315,     0,   844,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   845,   846,   334,   335,
       0,   336,   847,   338,   848,   849,   850,   339,   340,   851,
     341,   342,     0,   343,   344,     0,   852,   345,   853,   854,
     855,   856,     0,     0,     0,     0,     0,   350,     0,   351,
     857,   858,   859,   353,   354,   355,     0,   860,   356,   357,
     861,     0,   358,     0,     0,   862,   863,   359,     0,     0,
     360,     0,   361,     0,   864,   363,     0,     0,   865,   866,
     867,   868,   869,   364,     0,     0,   365,   870,     0,   366,
     367,   871,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   872,     0,   873,     0,     0,     0,     0,   874,     0,
       0,     0,   875,   876,     0,     0,     0,     0,   877,     0,
     878,     0,     0,   879,   880,     0,   881,   882,   122,     0,
     737,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   738,     0,   739,   130,   131,   740,   133,
       0,   134,   741,   135,     0,   742,   136,   743,   744,   745,
     137,   746,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   747,   144,     0,   145,   748,   749,   147,
       0,   148,   149,   150,   750,   151,     0,   751,   153,     0,
     154,   155,   156,   157,   158,   752,   753,   159,     0,   160,
     161,     0,   754,     0,   755,   756,   757,     0,     0,   163,
     758,   759,     0,   760,   761,     0,   164,   165,   762,   763,
     764,     0,     0,     0,     0,   765,   168,   766,     0,     0,
     767,   768,   169,     0,   170,     0,     0,     0,   769,   770,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   771,   179,     0,   772,
     773,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   774,     0,   188,   775,   189,   776,   777,   190,
       0,   778,   191,   192,   193,   779,     0,   194,     0,     0,
     780,     0,   195,   196,     0,   781,   197,     0,   198,   782,
     783,   784,   785,     0,   786,   787,   200,   788,   789,   790,
     202,     0,   203,   791,     0,   792,   793,     0,   204,   205,
       0,   206,   794,     0,   207,     0,     0,     0,   795,   209,
     210,   211,   796,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   797,   215,   798,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   799,
     220,     0,     0,   800,   221,     0,   801,   222,     0,     0,
       0,   802,     0,   803,     0,   224,   804,     0,   225,     0,
     226,   805,     0,     0,   806,     0,     0,     0,     0,   807,
     227,   228,   229,   230,   231,   232,   808,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   809,   242,   243,   244,
     810,   245,   246,     0,     0,     0,   247,   248,   811,   250,
       0,     0,   812,   252,   813,   814,   253,     0,   254,   815,
     816,   817,   818,   819,   820,   821,   259,   260,   261,   262,
       0,   822,   263,   264,     0,   265,   266,   267,   823,   824,
     825,   268,     0,   826,   827,     0,   269,   270,     0,   828,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   829,   830,   278,   831,
     832,   833,   834,   835,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   836,   287,   288,   289,   290,   291,   292,
     293,   837,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   838,   839,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   840,
     308,   309,   841,   310,   311,   842,   312,   843,   314,   315,
       0,   844,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   845,
     846,   334,   335,     0,   336,   847,   338,   848,   849,   850,
     339,   340,   851,   341,   342,     0,   343,   344,     0,   852,
     345,   853,   854,   855,   856,     0,     0,     0,     0,     0,
     350,     0,   351,   857,   858,   859,   353,   354,   355,     0,
     860,   356,   357,   861,     0,   358,     0,     0,   862,   863,
     359,     0,     0,   360,     0,   361,     0,   864,   363,     0,
       0,   865,   866,   867,   868,   869,   364,     0,     0,   365,
     870,     0,   366,   367,   871,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   872,     0,   873,     0,     0,     0,
       0,   874,     0,     0,     0,   875,   876,     0,     0,     0,
       0,   877,     0,   878,     0,     0,   879,   880,     0,   881,
     882,   122,     0,   737,   124,   125,   126,   127,  1767,     0,
       0,     0,     0,  1768,     0,     0,   738,     0,   739,   130,
     131,   740,   133,     0,   134,   741,   135,     0,   742,   136,
     743,   744,   745,   137,   746,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   747,   144,     0,   145,
     748,   749,   147,     0,   148,   149,   150,   750,   151,     0,
     751,   153,     0,   154,   155,   156,   157,   158,   752,   753,
     159,     0,   160,   161,     0,   754,     0,   755,   756,   757,
       0,     0,   163,   758,   759,     0,   760,   761,     0,   164,
     165,   762,   763,   764,     0,     0,     0,     0,   765,   168,
     766,     0,     0,   767,   768,   169,     0,   170,     0,     0,
       0,   769,   770,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   771,
     179,     0,   772,   773,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   774,     0,   188,   775,   189,
     776,   777,   190,     0,   778,   191,   192,   193,   779,     0,
     194,     0,     0,   780,     0,   195,   196,     0,   781,   197,
       0,   198,   782,   783,   784,   785,     0,   786,   787,   200,
     788,   789,   790,   202,     0,   203,   791,     0,   792,   793,
       0,   204,   205,     0,   206,   794,     0,   207,     0,     0,
       0,   795,   209,   210,   211,   796,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   797,   215,   798,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   799,   220,     0,     0,   800,   221,     0,   801,
     222,     0,     0,     0,   802,     0,   803,     0,   224,   804,
       0,   225,     0,   226,   805,     0,     0,   806,     0,     0,
       0,     0,   807,   227,   228,   229,   230,   231,   232,   808,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   809,
     242,   243,   244,   810,   245,   246,     0,     0,     0,   247,
     248,   811,   250,     0,     0,   812,   252,   813,   814,   253,
       0,   254,   815,   816,   817,   818,   819,   820,   821,   259,
     260,   261,   262,     0,   822,   263,   264,     0,   265,   266,
     267,   823,     0,   825,   268,     0,   826,   827,     0,   269,
     270,     0,   828,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   829,
     830,   278,   831,   832,   833,   834,   835,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   836,   287,   288,   289,
     290,   291,   292,   293,   837,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     838,   839,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   840,   308,   309,   841,   310,   311,   842,   312,
     843,   314,   315,     0,   844,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   845,   846,   334,   335,     0,   336,   847,   338,
     848,   849,   850,   339,   340,   851,   341,   342,     0,   343,
     344,     0,   852,   345,   853,   854,   855,   856,     0,     0,
       0,     0,     0,   350,     0,   351,   857,   858,   859,   353,
     354,   355,     0,   860,   356,   357,   861,     0,   358,     0,
       0,   862,   863,   359,     0,     0,   360,     0,   361,     0,
     864,   363,     0,     0,   865,   866,   867,   868,   869,   364,
       0,     0,   365,   870,     0,   366,   367,   871,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   872,     0,   873,
       0,     0,     0,     0,   874,     0,     0,     0,   875,   876,
       0,     0,     0,     0,   877,     0,   878,     0,     0,   879,
     880,     0,   881,   882,   122,     0,   737,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   738,
       0,   739,   130,   131,   740,   133,     0,   134,   741,   135,
       0,   742,   136,   743,   744,   745,   137,   746,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   747,
     144,     0,   145,   748,   749,   147,     0,   148,   149,   150,
     750,   151,     0,   751,   153,     0,   154,   155,   156,   157,
     158,   752,   753,   159,     0,   160,   161,     0,   754,     0,
     755,   756,   757,     0,     0,   163,   758,   759,     0,   760,
     761,     0,   164,   165,   762,   763,   764,     0,     0,     0,
       0,   765,   168,   766,     0,     0,   767,   768,   169,     0,
     170,     0,     0,     0,   769,   770,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   771,   179,     0,   772,   773,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   774,     0,
     188,   775,   189,   776,   777,   190,     0,   778,   191,   192,
     193,   779,     0,   194,     0,     0,   780,     0,   195,   196,
       0,   781,   197,     0,   198,   782,   783,   784,   785,     0,
     786,   787,   200,   788,   789,   790,   202,     0,   203,   791,
       0,   792,   793,     0,   204,   205,     0,   206,   794,     0,
     207,     0,     0,     0,   795,   209,   210,   211,   796,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   797,   215,
    2453,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   799,   220,     0,     0,   800,
     221,     0,   801,   222,     0,     0,     0,   802,     0,   803,
       0,   224,   804,     0,   225,     0,   226,   805,     0,     0,
     806,     0,     0,     0,     0,   807,   227,   228,   229,   230,
     231,   232,   808,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   809,   242,   243,   244,   810,   245,   246,     0,
       0,     0,   247,   248,   811,   250,     0,     0,   812,   252,
     813,   814,   253,     0,   254,   815,   816,   817,   818,   819,
     820,   821,   259,   260,   261,   262,     0,   822,   263,   264,
       0,   265,   266,   267,   823,   824,   825,   268,     0,   826,
     827,     0,   269,   270,     0,   828,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   829,   830,   278,   831,   832,   833,   834,   835,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   836,
     287,   288,   289,   290,   291,   292,   293,   837,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   838,   839,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   840,   308,   309,   841,   310,
     311,   842,   312,   843,   314,   315,     0,   844,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   845,   846,   334,   335,     0,
     336,   847,   338,   848,   849,   850,   339,   340,   851,   341,
     342,     0,   343,   344,     0,   852,   345,   853,   854,   855,
     856,     0,     0,     0,     0,     0,   350,     0,   351,   857,
     858,   859,   353,   354,   355,     0,   860,   356,   357,   861,
       0,   358,     0,     0,   862,   863,   359,     0,     0,   360,
       0,   361,     0,   864,   363,     0,     0,   865,   866,   867,
     868,   869,   364,     0,     0,   365,   870,     0,   366,   367,
     871,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     872,     0,   873,     0,     0,     0,     0,   874,     0,     0,
       0,   875,   876,     0,     0,     0,     0,   877,     0,   878,
       0,     0,   879,   880,     0,   881,   882,   122,     0,   737,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   738,     0,   739,   130,   131,   740,   133,     0,
     134,   741,   135,     0,   742,   136,   743,   744,   745,   137,
     746,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   747,   144,     0,   145,   748,   749,   147,     0,
     148,   149,   150,   750,   151,     0,   751,   153,     0,   154,
     155,   156,   157,   158,   752,   753,   159,     0,   160,   161,
       0,   754,     0,   755,   756,   757,     0,     0,   163,   758,
     759,     0,   760,   761,     0,   164,   165,   762,   763,   764,
       0,     0,     0,     0,   765,   168,   766,     0,     0,   767,
     768,   169,     0,   170,     0,     0,     0,   769,   770,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   771,   179,     0,   772,   773,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   774,     0,   188,   775,   189,   776,   777,   190,     0,
     778,   191,   192,   193,   779,     0,   194,     0,     0,   780,
       0,   195,   196,     0,   781,   197,     0,   198,   782,   783,
     784,   785,     0,   786,   787,   200,   788,   789,   790,   202,
       0,   203,   791,     0,   792,   793,     0,   204,   205,     0,
     206,   794,     0,   207,     0,     0,     0,   795,   209,   210,
     211,   796,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   797,   215,  2526,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   799,   220,
       0,     0,   800,   221,     0,   801,   222,     0,     0,     0,
     802,     0,   803,     0,   224,   804,     0,   225,     0,   226,
     805,     0,     0,   806,     0,     0,     0,     0,   807,   227,
     228,   229,   230,   231,   232,   808,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   809,   242,   243,   244,   810,
     245,   246,     0,     0,     0,   247,   248,   811,   250,     0,
       0,   812,   252,   813,   814,   253,     0,   254,   815,   816,
     817,   818,   819,   820,   821,   259,   260,   261,   262,     0,
     822,   263,   264,     0,   265,   266,   267,   823,   824,   825,
     268,     0,   826,   827,     0,   269,   270,     0,   828,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   829,   830,   278,   831,   832,
     833,   834,   835,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   836,   287,   288,   289,   290,   291,   292,   293,
     837,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   838,   839,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   840,   308,
     309,   841,   310,   311,   842,   312,   843,   314,   315,     0,
     844,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   845,   846,
     334,   335,     0,   336,   847,   338,   848,   849,   850,   339,
     340,   851,   341,   342,     0,   343,   344,     0,   852,   345,
     853,   854,   855,   856,     0,     0,     0,     0,     0,   350,
       0,   351,   857,   858,   859,   353,   354,   355,     0,   860,
     356,   357,   861,     0,   358,     0,     0,   862,   863,   359,
       0,     0,   360,     0,   361,     0,   864,   363,     0,     0,
     865,   866,   867,   868,   869,   364,     0,     0,   365,   870,
       0,   366,   367,   871,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   872,     0,   873,     0,     0,     0,     0,
     874,     0,     0,     0,   875,   876,     0,     0,     0,     0,
     877,     0,   878,     0,     0,   879,   880,     0,   881,   882,
     122,     0,   737,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   738,     0,   739,   130,   131,
     740,   133,     0,   134,   741,   135,     0,   742,   136,   743,
     744,   745,   137,   746,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   747,   144,     0,   145,   748,
     749,   147,     0,   148,   149,   150,   750,   151,     0,   751,
     153,     0,   154,   155,   156,   157,   158,   752,   753,   159,
       0,   160,   161,     0,   754,     0,   755,   756,   757,     0,
       0,   163,   758,   759,     0,   760,   761,     0,   164,   165,
     762,   763,   764,     0,     0,     0,     0,   765,   168,   766,
       0,     0,   767,  2877,   169,     0,   170,     0,     0,     0,
     769,   770,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   771,   179,
       0,   772,   773,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   774,     0,   188,   775,   189,   776,
     777,   190,     0,   778,   191,   192,   193,   779,     0,   194,
       0,     0,   780,     0,   195,   196,     0,   781,   197,     0,
     198,   782,   783,   784,   785,     0,   786,   787,   200,   788,
     789,   790,   202,     0,   203,   791,     0,   792,   793,     0,
     204,   205,     0,   206,   794,     0,   207,     0,     0,     0,
     795,   209,   210,   211,   796,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   797,   215,   798,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   799,   220,     0,     0,   800,   221,     0,   801,   222,
       0,     0,     0,   802,     0,   803,     0,   224,   804,     0,
     225,     0,   226,   805,     0,     0,   806,     0,     0,     0,
       0,   807,   227,   228,   229,   230,   231,   232,   808,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   809,   242,
     243,   244,   810,   245,   246,     0,     0,     0,   247,   248,
     811,   250,     0,     0,   812,   252,   813,   814,   253,     0,
     254,   815,   816,   817,   818,   819,   820,   821,   259,   260,
     261,   262,     0,   822,   263,   264,     0,   265,   266,   267,
     823,   824,   825,   268,     0,   826,   827,     0,   269,   270,
       0,   828,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   829,   830,
     278,   831,   832,   833,   834,   835,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   836,   287,   288,   289,   290,
     291,   292,   293,   837,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   838,
     839,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   840,   308,   309,   841,   310,   311,   842,   312,   843,
     314,   315,     0,   844,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   845,   846,   334,   335,     0,   336,   847,   338,   848,
     849,   850,   339,   340,   851,   341,   342,     0,   343,   344,
       0,   852,   345,   853,   854,   855,   856,     0,     0,     0,
       0,     0,   350,     0,   351,   857,   858,   859,   353,   354,
     355,     0,   860,   356,   357,   861,     0,   358,     0,     0,
     862,   863,   359,     0,     0,   360,     0,   361,     0,   864,
     363,     0,     0,   865,   866,   867,   868,   869,   364,     0,
       0,   365,   870,     0,   366,   367,   871,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   872,     0,   873,     0,
       0,     0,     0,   874,     0,     0,     0,   875,   876,     0,
       0,     0,     0,   877,     0,   878,     0,     0,   879,   880,
       0,   881,   882,   122,     0,   737,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   738,     0,
     739,   130,   131,   740,   133,     0,   134,   741,   135,     0,
     742,   136,   743,   744,   745,   137,   746,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   747,   144,
       0,   145,   748,   749,   147,     0,   148,   149,   150,   750,
     151,     0,   751,   153,     0,   154,   155,   156,   157,   158,
     752,   753,   159,     0,   160,   161,     0,   754,     0,   755,
     756,   757,     0,     0,   163,   758,   759,     0,   760,   761,
       0,   164,   165,   762,   763,   764,     0,     0,     0,     0,
     765,   168,   766,     0,     0,   767,   768,   169,     0,   170,
       0,     0,     0,   769,   770,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   771,   179,     0,   772,   773,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   774,     0,   188,
     775,   189,   776,   777,   190,     0,   778,   191,   192,   193,
     779,     0,   194,     0,     0,   780,     0,   195,   196,     0,
     781,   197,     0,   198,   782,   783,   784,   785,     0,   786,
     787,   200,   788,   789,   790,   202,     0,   203,   791,     0,
     792,   793,     0,   204,   205,     0,   206,   794,     0,   207,
       0,     0,     0,   795,   209,   210,   211,   796,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   797,   215,   798,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   799,   220,     0,     0,   800,   221,
       0,   801,   222,     0,     0,     0,   802,     0,   803,     0,
     224,   804,     0,   225,     0,   226,   805,     0,     0,   806,
       0,     0,     0,     0,   807,   227,   228,   229,   230,   231,
     232,   808,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   809,   242,   243,   244,   810,   245,   246,     0,     0,
       0,   247,   248,   811,   250,     0,     0,   812,   252,   813,
     814,   253,     0,   254,   815,   816,   817,   818,   819,   820,
     821,   259,   260,   261,   262,     0,   822,   263,   264,     0,
     265,   266,   267,   823,     0,   825,   268,     0,   826,   827,
       0,   269,   270,     0,   828,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   829,   830,   278,   831,   832,   833,   834,   835,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   836,   287,
     288,   289,   290,   291,   292,   293,   837,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   838,   839,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   840,   308,   309,   841,   310,   311,
     842,   312,   843,   314,   315,     0,   844,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   845,   846,   334,   335,     0,   336,
     847,   338,   848,   849,   850,   339,   340,   851,   341,   342,
       0,   343,   344,     0,   852,   345,   853,   854,   855,   856,
       0,     0,     0,     0,     0,   350,     0,   351,   857,   858,
     859,   353,   354,   355,     0,   860,   356,   357,   861,     0,
     358,     0,     0,   862,   863,   359,     0,     0,   360,     0,
     361,     0,   864,   363,     0,     0,   865,   866,   867,   868,
     869,   364,     0,     0,   365,   870,     0,   366,   367,   871,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   872,
       0,   873,     0,     0,     0,     0,   874,     0,     0,     0,
     875,   876,     0,     0,     0,     0,   877,     0,   878,     0,
       0,   879,   880,     0,   881,   882,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,  1941,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,  1942,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,  1088,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,  1089,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,  2438,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,  1854,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
    1943,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,  1990,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,  1941,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,  1942,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,  1088,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,  1089,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
    1943,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,  1990,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,  1854,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,  2258,     0,   130,   131,   132,   133,   882,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,  3626,   128,     0,     0,   129,  3627,   882,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,   975,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   408,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
    1813,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   408,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,     0,     0,     0,     0,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  1989,     0,   128,     0,
       0,   129,     0,  1990,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,     0,     0,     0,     0,     0,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,  3627,   882,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   408,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   462,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   408,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,   882,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
       0,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,  1990,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   550,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   551,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,  1754,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   550,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   551,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,  2298,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   550,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   551,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -226,  2900,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,     0,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -179,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -179,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -179,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,     0,     0,  3471,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,  3678,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  1597,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2284,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  2577,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  2905,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -226,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,  -196,
       0,   179,     0,     0,     0,  -196,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -179,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -179,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -179,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,  -196,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -226,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,  -217,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -179,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -179,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,  -217,     0,  -179,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,  -217,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -226,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,  -214,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -179,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -179,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,  -214,     0,  -179,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,  -214,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -226,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,  3555,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -179,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -179,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,   360,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,  -179,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,     0,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -226,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,  -219,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -179,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -179,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -179,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -226,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,  3606,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -179,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -179,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -179,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,     0,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -226,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,  3639,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -179,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -179,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,  -179,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,     0,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -226,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,  -200,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -179,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -179,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,  -179,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,     0,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -226,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,     0,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -179,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -179,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,   360,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,  -179,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,     0,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -226,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,     0,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -179,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -179,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,  3558,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -179,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,  1607,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,  1608,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,  1609,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,  1610,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,   700,   701,     0,   268,     0,     0,  1611,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,  3666,  3657,
    3667,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,  1612,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,  2290,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,  2291,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,  1928,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,   550,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,  1929,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     551,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2300,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,  2301,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   550,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   551,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
    2290,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  2291,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,   550,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   551,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,   704,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     550,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   551,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,   656,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,   657,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   658,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  2338,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   550,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   551,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,  2290,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   550,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   551,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   550,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   551,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,  2280,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   551,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,  3601,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,  3602,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,   731,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,  1084,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  1879,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,  1880,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,  1996,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   551,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,  1879,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,  1390,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,  1391,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,     0,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
       0,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,     0,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,     0,     0,   302,     0,     0,   304,
       0,     0,   306,   307,     0,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,     0,
       0,     0,     0,   372
};

static const short int yycheck[] =
{
       7,   489,   457,   894,   591,   437,   671,   764,   494,   495,
     637,  1157,    19,   961,   515,    22,   758,   759,   760,  1283,
     616,  1748,    29,  1283,   412,  1064,   485,   486,  1193,   742,
    1014,   614,    39,  1889,  1932,  1858,  1831,  1308,  1882,  1883,
    1884,   637,    49,    22,  1315,  2039,  1506,  2315,  2678,  1593,
    1159,  1160,  1161,  2057,   567,   638,  1910,   516,  1917,  1519,
    2064,  2655,  1370,  1172,  1918,  2265,  1920,  1191,  1077,  1472,
    1185,     3,   573,  1029,  1164,  1165,   675,  1167,  1873,  2663,
      87,     7,   675,   825,  1040,  1041,  1896,  1897,    32,     3,
    1327,  1328,     3,     3,    55,  1951,   853,    34,     3,   856,
     107,   108,  1947,   110,     3,    16,     3,   499,    87,   851,
    1225,  1070,  1202,  1426,   121,  1971,  1972,  1226,   444,   132,
    1229,    18,    92,   865,   866,   867,   585,  1217,    34,    48,
       3,    15,    16,  2708,  1486,    68,  2711,    16,    93,  1598,
      58,     3,   121,     3,    27,  1235,  1236,  1237,  1257,  1258,
      18,    20,    18,  1262,    18,  2730,  1246,  1596,    58,  1247,
     171,  2736,   875,   876,   877,    20,   153,    76,    54,    55,
      60,  2359,    53,  1282,   887,  1284,   153,    32,   679,    86,
      57,    48,   108,   334,   110,    54,    55,   144,   213,   225,
      45,    15,    16,   201,    57,    15,    16,  2772,    59,    54,
      55,   264,   126,   397,  1152,   108,   153,   232,    51,  2032,
     495,    15,    16,  1942,  1943,    15,    16,    15,    16,   257,
    3473,    15,    16,   682,   710,   711,   712,   615,  1316,  2036,
     110,  1319,  1320,  1321,  1322,   108,  1324,  1325,  1326,  1327,
    1328,  1329,  1330,  1331,  1332,   142,   108,  1941,   108,  2937,
      15,    16,   578,  1947,   210,   171,  1950,    62,   213,  1953,
      15,    16,   199,   353,    15,    16,   112,    62,    15,    16,
    1964,  1965,   153,    43,   142,   156,   142,   283,   142,  1973,
      15,    16,    11,   639,   230,  2252,  3386,   168,   433,   166,
     112,  1182,  2886,   199,   187,   340,   246,   225,    11,  2944,
      15,    16,   328,   252,  1916,   171,   222,   109,   420,  1496,
     228,   210,    15,    16,   127,   247,   281,   380,   246,   503,
     200,  1508,  1509,    57,  1511,  1512,  1513,  2258,   228,  1516,
     535,   337,   517,   247,  1521,   403,   389,   247,  1525,  1526,
    1527,   213,   247,  1530,  1531,  1532,  1533,  1534,    20,  1536,
    1537,  1538,   210,   536,    15,    16,   558,   562,  1902,   252,
      32,   416,    91,   389,   509,    15,    16,  2334,   562,    15,
      16,    15,    16,    45,   165,  1266,   561,   561,   525,  1270,
     329,   528,    54,    55,   264,   372,   476,  1052,    37,    15,
      16,   398,    18,  2968,  3024,   372,   109,   219,   886,   544,
     264,   408,  2977,    15,    16,   412,   264,  3095,  3661,  1555,
     417,   562,   293,   345,  1560,   422,   171,   455,  3518,   210,
    1566,    32,   224,  1569,   324,   372,   196,   330,   314,   345,
    1869,   345,   166,   109,   142,  1018,   435,   444,   417,   395,
      15,    16,   727,  1026,   497,   338,   175,   455,   560,  3033,
      48,  1208,   911,   655,   461,  2299,   402,   385,    94,  1042,
    1043,    97,   371,  2322,   471,     0,    10,   353,  1064,  2367,
     477,  1070,    15,    16,   537,    65,   483,  1070,   485,   486,
    2668,   210,   401,   490,   491,   328,  2330,   364,  1001,   342,
     380,   372,   471,  3087,   501,  1604,   395,  2041,   505,   567,
      63,   408,   426,   510,   511,   964,   513,   514,   515,   516,
    1466,  2356,    15,    16,   372,   974,   380,   472,  1019,  1276,
     344,   384,   567,   347,   344,  2370,   562,   347,   515,  1989,
    1129,  1540,   425,   546,   401,   560,  1129,    15,    16,   476,
     344,  3125,   549,   347,   344,   463,   344,   347,   224,   347,
     344,   562,   452,   347,   560,    15,    16,  1909,   565,   529,
      15,    16,  1875,   463,   525,   498,   573,   574,   515,  1082,
     476,   578,  2032,   530,   435,   562,  1685,   965,   585,   344,
    1689,  2040,   347,   533,   105,   562,   565,   513,   514,   344,
      15,    16,   347,   344,  1858,   574,   347,   344,  1858,  2038,
     347,   533,   485,    15,    16,  1318,   485,   420,   615,   344,
      15,    16,   347,  1722,  1006,  1574,   560,   485,  1783,   533,
    1785,   549,  2890,   533,   535,  2354,   952,   504,   533,   344,
     364,   247,   347,   502,   347,   567,   568,   366,   538,  2446,
    3285,   344,  1074,   562,   347,   415,  1359,   502,  1772,   975,
     455,   517,  3340,   567,   568,  1919,   540,   568,   568,  1919,
     455,  1751,  2356,   568,   671,   511,    15,    16,  2599,   568,
     281,   568,   679,   537,  3258,   682,  2370,     3,   685,   686,
     566,   562,  1038,   344,    15,    16,   347,  3317,   155,   511,
    1778,    15,    16,   388,   344,   568,   562,   347,   344,   318,
     344,   347,   223,   347,  1792,  1793,   568,   686,   568,   263,
    1974,  2323,  2324,   517,  1974,     8,   540,   455,   344,   427,
     540,   347,   729,   110,   731,   516,    63,  2271,  2272,   345,
     328,  3306,   344,  3308,   420,   347,   540,   362,  3322,   388,
     540,   565,   540,   472,  1132,   565,   540,   560,   128,  2593,
     729,   564,   731,   402,    38,   247,   451,  1083,   562,  3389,
    3028,   561,   562,   561,   562,    15,    16,   561,   562,   344,
     504,  1958,   347,  2596,   423,   540,  1667,  1923,   368,    15,
      16,    12,  1969,   346,   476,   540,  2645,  2631,   526,   540,
    2649,  2645,    12,   540,   160,  2649,   561,   562,  3373,   171,
    3375,   344,   472,   401,   347,   540,  1952,   562,  1954,   146,
     561,   562,  2607,  1959,   561,   562,    15,    16,   472,  2943,
    2665,  3405,   366,  1311,   318,   540,   561,   562,   426,  1975,
     502,  1977,  1978,  1979,  2071,  2072,   120,   540,   109,    91,
     394,   344,   478,  1734,   347,   481,   561,   562,    15,    16,
      15,    16,  3446,   345,    15,    16,   528,   476,   561,   562,
     381,  2985,   175,   330,  1491,  1366,   344,   160,    49,   347,
     562,   237,    91,   880,   560,   882,    57,   264,  1461,   540,
     470,   500,  1465,   187,   344,  1468,  1469,   347,   560,   344,
     540,   122,   347,  1406,   540,  1491,   540,   547,   905,   489,
     561,   562,   122,  1416,   911,  2449,   450,  1408,  1409,   175,
    1298,  2314,  1896,  1897,   540,   561,   562,   561,  1377,   344,
      15,    16,   347,   175,    15,    16,   905,  1440,   540,    15,
      16,   142,   344,    15,    16,   347,  2930,  2760,   142,   344,
     461,   948,   347,   950,   488,   952,  2217,  1903,   252,   561,
     562,   323,    15,    16,  2764,   217,   175,   964,   965,  2963,
      15,    16,   328,   225,   168,   540,   567,   974,   975,   349,
    1358,  2665,  2062,  1921,    53,  1574,   317,  2067,   985,  1988,
     534,  1574,   476,  1371,  1497,   529,   561,   562,    12,  2253,
     173,  3621,  2082,  2253,   213,   344,   337,   540,   347,  2089,
    1007,  1008,  1009,  1010,   171,  1437,   500,  3207,  2123,   346,
    1017,   503,  1019,   344,  2104,  2105,   347,   318,  1025,   562,
     344,  2111,    19,   347,   491,   135,    15,    16,  1035,  2119,
    1009,  1010,   230,   171,  2122,   145,   281,   540,   476,  1967,
     507,   420,    74,  1556,  1557,   243,  1559,   261,  1561,  1562,
    1563,  1564,  1565,   366,  1567,  1568,  1035,  1985,   561,   562,
    2941,   318,   540,  2922,  2923,  2373,   560,   494,  2158,   485,
    2914,   252,    75,  1080,   153,   420,  1083,   156,  1791,    12,
     540,  1007,  1008,   561,   562,   540,    89,  2211,   350,   168,
     517,  1017,    15,    16,   344,  2043,  2220,   347,   122,  1025,
     366,  1080,   562,  3097,    15,    16,   561,   562,   344,   247,
    2654,   347,    15,    16,   366,   540,   113,   331,    15,    16,
     420,   425,  3390,   420,   562,  1132,   371,  1134,   540,  1136,
    1137,  1138,  1139,  1140,   420,   540,   561,   562,  2228,   171,
     354,   294,  1149,   362,  1151,   344,   476,   366,   347,   561,
     562,   168,    15,    16,  2590,  3159,   561,   562,    16,   472,
    1139,    15,    16,  2959,   366,    12,  2962,  3435,   155,   352,
     209,    15,    16,    15,    16,   476,   517,   344,  1185,   344,
     347,   560,   347,   344,  2075,   564,   347,    15,    16,   122,
     435,   540,  2083,   485,    15,    16,  2656,  2657,  2658,   500,
      15,    16,    15,    16,    12,   420,   472,  3030,   406,   540,
    1136,  1137,   561,   562,   293,   560,   540,   472,  1225,   476,
     472,    15,    16,   427,  2660,  2685,    15,    16,   171,   473,
     561,   562,   264,   343,    15,    16,   566,   561,   562,   256,
     325,   326,   455,   500,    66,  3126,  3127,   336,   450,   344,
     213,   434,   347,   344,   473,   283,   347,  3111,   344,   560,
     560,   347,   344,   560,   353,   347,   560,   269,   270,   488,
     562,    15,    16,   567,   560,   122,  1283,   529,    15,    16,
     493,   344,   225,   497,   347,   435,   488,    15,    16,   344,
     540,  1298,   347,   372,  1749,   514,  2567,   209,   470,   561,
     472,    15,    16,   560,   540,    15,    16,   522,   523,   337,
     529,   561,  2477,  2478,   122,   217,    15,    16,    15,    16,
     454,   474,   340,   225,   458,   561,   562,   529,    15,    16,
       8,   213,    15,    16,    15,    16,  2600,   487,   325,   326,
    2600,   540,   514,   330,   166,   560,   499,   168,   547,    27,
     232,  1358,    15,    16,   420,   344,  1363,  1364,   347,  1366,
     426,    15,    16,  1876,  1371,   475,  3162,   222,    15,    16,
    1377,     3,  1379,   540,   532,   540,   453,  1384,  1385,   540,
    1387,   535,    15,    16,   386,   387,    18,   476,   546,  2653,
     264,   213,  1399,  2653,   561,  1402,   561,   562,   475,   171,
     561,  1408,  1409,  1410,  1411,  1384,  1385,   567,  1387,   380,
     232,  1418,  1419,  1420,   532,  2679,    15,    16,   561,  2679,
    1399,   344,   393,  1402,   347,    15,    16,   142,   546,  1436,
     532,  1410,  1411,   344,    15,    16,   347,   450,  1445,  1418,
    1419,  1420,  1955,  1956,   546,   540,   560,   344,   350,   540,
     347,   395,   423,    85,   540,  1462,   522,   523,   540,  2498,
    1467,   439,   440,  1976,   442,  3260,   561,   562,    15,    16,
    2560,   562,  1479,    15,    16,   561,   562,   540,  1485,   561,
     562,   344,    15,    16,   347,   540,  3467,  3468,  1467,   104,
     344,    11,   125,   347,   560,  1883,   149,  1885,  1886,   562,
     344,  2214,   344,   347,   491,   347,  1485,   562,    15,    16,
     142,  3307,   337,  3309,    20,   365,   344,   560,     3,   347,
     507,     6,    28,   344,   567,  1957,   347,    33,    13,   344,
     410,   344,   347,   165,   347,   517,   168,  1544,    23,    24,
     561,   562,   364,  1931,  1932,  1552,   937,   162,   470,   940,
     344,   540,   943,   347,   470,   344,   472,  3401,   347,   191,
     104,  3417,  3356,   344,  3358,   197,   347,    52,    15,    16,
     337,    56,  1579,   562,    54,    55,    54,    55,   210,  1967,
    3561,  3562,    67,   215,  1591,    63,  3313,  1594,   561,   562,
     222,    76,  3490,   561,   562,   342,    81,  1985,   230,   210,
     344,  2766,   562,   347,    46,     3,   171,   344,    93,   123,
     347,   243,  1591,   561,   562,   247,   344,   540,   162,   347,
      18,  2885,   257,   108,   256,  2885,   111,   561,   562,   540,
     344,   561,   562,   347,   344,   120,   121,   347,   397,   562,
     399,   126,   401,   540,   403,   344,   261,   344,   347,   134,
     347,   562,   561,   562,    46,   140,   562,   344,    15,    16,
     347,   344,   337,   344,   347,   562,   347,    15,    16,  2057,
     561,   562,  2837,    15,    16,   416,  2064,   540,  2265,  2306,
     165,   344,   561,   562,   347,   317,   540,    85,   561,   562,
     344,   561,   562,   347,   561,   562,   540,   344,   540,   562,
     347,   503,    15,    16,  1385,   337,  1387,   257,   562,   554,
    2306,   344,   540,   345,   347,   147,   331,   261,   562,   540,
     562,   560,    15,    16,   426,   540,   211,   540,   213,   493,
    2313,    15,    16,   561,   366,   220,   247,  1418,  1419,  1420,
     561,  2227,   561,   562,   142,   344,   540,   562,   347,  2250,
    1757,   540,   561,   562,   344,    15,    16,   347,   517,   540,
      15,    16,   168,   344,   561,   562,   347,  2280,   562,   123,
     168,   561,   562,   562,   406,    15,    16,  2867,    28,   410,
    2764,   562,    15,    16,   561,   562,   455,   331,    15,    16,
     561,   562,   306,   191,   426,  2296,   540,   344,   455,   197,
     347,   286,   344,   540,   455,   347,   281,    15,    16,   561,
     562,   344,   540,   257,   347,   300,  2204,   215,   562,    69,
     305,   470,    15,    16,   222,   562,   540,   139,   460,    77,
     540,   562,   230,   108,   562,   561,   562,   344,  2657,  2658,
     347,   540,   473,   540,   339,   243,    15,    16,   562,   247,
     468,  1858,   562,   540,   561,  2368,   419,   540,   256,   540,
     345,   529,  2375,   562,   547,   562,   351,    51,   353,  1876,
    1877,   503,  1267,  1268,   389,   562,  1883,   540,  1885,  1886,
     149,   562,   497,   514,   516,   517,   540,   560,   138,   374,
     375,   104,   377,   540,   566,   108,   207,   344,   529,   562,
     347,   533,   562,   535,    15,    16,   391,   540,   562,   175,
    2623,    67,  1919,    15,    16,   562,  3132,  3133,   175,   317,
     529,    15,    16,    79,  1931,  1932,  2609,  2610,   413,   561,
     562,  2579,  2580,   562,  1941,   562,   568,    15,    16,   337,
    1947,   540,   567,  1950,   560,  2404,  1953,   345,   560,   162,
     540,  2697,   306,   497,  2700,  2701,   560,  1964,  1965,   540,
    1967,   567,   560,   562,    15,    16,  1973,  1974,   366,  2917,
     567,  2717,   562,    15,    16,   560,  1983,   560,  1985,  2367,
     560,   562,  1989,  1990,   560,   560,   199,   344,    15,    16,
     347,  2875,  2876,   540,   560,   476,   344,   566,   540,   347,
     560,   560,   344,   560,  1983,   347,   560,   540,   406,   494,
      15,    16,    15,    16,   560,   562,    46,  2460,   503,   560,
     562,  2464,    15,    16,  2031,  2032,   188,   562,   426,   562,
     560,   344,  1507,   540,   347,  1510,   560,   560,   552,   553,
     554,   555,   556,   557,  1519,   535,    15,    16,   261,   562,
    2057,   344,  2031,  1528,   347,   562,   560,  2064,   560,   560,
     344,   560,   460,   347,    15,    16,    15,    16,   560,   171,
    2077,   560,  3336,    15,    16,   450,   451,   562,   453,   235,
     455,    15,    16,   568,   344,   470,   560,   347,   560,   344,
      15,    16,   347,   540,   560,   560,   560,   560,   104,  3245,
    3246,  3247,  3248,   560,   344,   503,   560,   347,   560,   560,
     560,   344,   362,  3222,   347,   562,  2123,   344,   331,   517,
     347,   560,   284,   285,    15,    16,   288,   289,    15,    16,
     104,   560,   382,   560,   560,   533,   344,   535,   560,   347,
     560,    15,    16,   560,   560,   560,  3236,   560,   304,   560,
     560,   344,   560,   560,   347,   560,   162,   407,   560,   560,
     560,   560,   281,   561,   562,   560,   560,    15,    16,   560,
     568,   560,   328,    15,    16,   344,   560,   560,   347,   560,
     560,  3445,    85,   540,   560,    15,    16,   560,   162,    15,
      16,   560,   540,   199,   560,    15,    16,  2204,   540,   560,
     554,   555,   556,   557,   454,   562,   252,    15,    16,   560,
     560,   560,   281,   138,   562,   560,   560,    15,    16,   560,
     562,   560,  2229,   379,  2612,   199,  2233,   540,  2235,  2236,
    2237,  2238,   560,   344,   560,   560,   347,    15,    16,  2246,
    2628,  2754,   344,  2250,   560,   347,  2253,   540,  2691,   562,
     344,    15,    16,   347,   560,   261,   540,   560,   560,   560,
    2267,  2268,  2269,  2749,   560,   560,   344,  2246,   561,   347,
     560,    15,    16,  2280,   560,   560,   485,   561,   560,  2286,
     540,  2288,  2725,  2726,   497,   540,   560,   261,   560,  2296,
    2733,   562,   560,   344,   450,   560,   347,  2740,   560,   560,
     540,   561,   344,   562,   560,   347,   561,   540,   560,   560,
      15,    16,   215,   540,   560,    15,    16,   344,   560,   560,
     347,   561,    15,    16,   560,   331,   560,   230,   561,   560,
     560,   560,   540,   485,   561,    15,    16,   560,   560,   344,
     243,   344,   347,   560,   347,   560,  3610,   540,   560,  2356,
    3610,   344,   562,   561,   347,   560,   560,   331,   225,   562,
    2367,    15,    16,  2370,   562,   562,   476,  3631,   561,   554,
     510,   540,  3129,  3130,  3131,   344,    15,    16,   347,   168,
     562,  3046,   437,  3647,   355,  2871,   562,  3647,   560,    15,
      16,   561,   561,   344,   562,   344,   347,  2404,   347,   142,
    3546,   142,   344,  2916,  2411,   347,   142,  2414,   142,   142,
     344,  2418,  2419,   347,   317,  2422,    15,    16,   142,   344,
      15,    16,   347,  2430,   142,   142,   142,    15,    16,   540,
    3172,  2438,    15,    16,   337,  2414,    15,    16,   540,   142,
     142,     3,   562,    15,    16,   142,   540,   142,   142,   512,
     561,    13,    14,   344,   142,   561,   347,   344,    44,  2438,
     347,   175,   540,   171,    26,   337,    28,   561,   442,    63,
     344,  2984,    12,   347,    15,    16,   561,   476,   561,    15,
      16,    15,    16,   561,    46,    47,    15,    16,  3153,   540,
      52,   497,    15,    16,    56,    57,   344,   122,   540,   347,
    3013,  3166,   344,   406,     9,   347,   532,    69,   561,   561,
     561,   561,  2900,   540,   344,   560,   246,   347,   344,   561,
     567,   347,    84,   497,   344,   553,   562,   347,  2960,   380,
     214,   533,   142,   143,   561,   540,   344,   540,   188,   347,
     171,   103,    15,    16,   567,   561,   344,   540,   426,   347,
     112,   113,   114,    15,    16,   435,   561,   460,   561,  3072,
     168,   562,  3304,   125,   126,   562,   344,    44,   561,   347,
     180,   540,   419,   450,   450,  2963,    15,    16,    66,   450,
     344,    15,    16,   347,   194,   450,   148,   450,   485,   540,
     231,   540,   561,  2600,  2601,  2983,  2603,  3511,   540,   119,
     344,   471,   164,   347,   231,  2612,   540,    15,    16,   471,
     561,  2618,   561,   119,    44,   540,   226,   562,   517,   561,
    3207,  2628,   560,   567,   561,   561,   188,   561,   238,  2636,
     562,    15,    16,   195,   561,   561,   198,   561,  3552,   344,
      15,    16,   347,    85,   344,   561,  2653,   347,   561,   540,
     554,   344,   561,   540,   347,   265,   567,   219,  2665,    15,
      16,   561,   171,   561,   344,  2672,   540,   347,    15,    16,
     561,   233,  2679,   562,   561,   561,   561,   560,  2685,  3593,
     562,    15,    16,   562,   485,   427,  3600,   561,   561,   251,
     344,   560,   540,   347,   256,   561,   557,   561,   540,    15,
      16,   561,  3616,   561,   561,   344,  3192,  3193,   347,  3374,
     540,   321,  3100,   561,   540,    15,    16,   561,   344,   561,
     540,   347,    15,    16,   561,     7,    15,    16,    15,    16,
     561,   561,   540,   562,   561,   561,  3650,    19,  3652,    12,
      22,   561,   540,  3408,  3409,   344,  3411,    29,   347,   344,
      15,    16,   347,   561,   561,  2762,   344,    39,   561,   347,
     560,   344,   540,   561,   347,   344,   560,    49,   347,   561,
     256,  3159,   344,   215,   567,   347,   540,   567,   485,   341,
      15,    16,   562,   561,    16,  3676,   485,  3452,   230,  3454,
    3455,   476,    15,    16,   252,   485,   540,   561,   537,   560,
     362,   243,    16,   344,   342,    87,   347,   369,   344,   171,
     344,   347,   171,   347,   171,   344,   222,   561,   347,   171,
     567,   344,   227,   535,   347,   107,   108,   389,   110,   391,
     392,   562,  3318,   395,   230,   540,   398,   230,   400,   121,
     540,   567,   296,   405,   348,   407,    93,   540,    93,   122,
     232,    70,    71,   232,   416,  2862,   561,   567,   420,  3314,
     540,   561,   560,   476,   426,    20,   403,   345,   561,   431,
     561,   344,   554,   435,   347,   317,   221,    32,  2885,  2957,
    2958,   561,   344,   560,   560,   347,   540,   561,   331,   108,
      45,   123,   454,  2900,    13,   337,   458,  2975,  3386,    54,
      55,   540,   331,  2981,    85,   344,   171,   561,   347,   123,
     344,   130,   561,   347,   540,   561,   561,   331,   138,   561,
     567,   561,   561,   567,   567,   561,  3004,   200,   561,  3007,
     492,   554,   560,   337,  2941,   561,   344,   561,   210,   347,
     562,   540,   161,   171,   511,   540,   508,   567,   171,   511,
      91,   225,   540,   244,   516,    63,  2963,   540,   269,   230,
     344,   540,   561,   347,   406,    84,   561,   230,   540,   344,
     337,   562,   347,   561,   232,   232,  2983,   539,   561,    18,
     562,   496,   561,   337,    18,   561,    18,   560,   344,   561,
     104,   347,   247,   112,   560,   102,   560,   344,   560,   540,
     347,  3008,   223,  3010,   540,   223,   540,   126,   561,   561,
     344,   540,   561,   347,  3021,  3447,  3023,   540,   460,   561,
     561,   567,   561,   567,   129,   561,   561,   561,   344,   148,
    3518,   347,   561,   174,   215,  3521,   561,   561,   561,   561,
     159,   562,  3021,    23,   344,   561,   241,   347,   162,   230,
     561,   344,   562,   561,   347,   344,   420,   344,   347,   561,
     347,   561,   243,   170,   561,  3072,   561,   540,   562,   188,
     561,   191,   213,   562,   306,   428,   560,   560,   540,   344,
     142,  3567,   347,    63,   348,   199,   561,    67,   561,   560,
     230,   230,   306,  3100,   213,    32,    85,   562,   205,   561,
     219,   540,  3490,   108,   108,   560,   540,   560,   361,   344,
     560,   560,   347,  3120,   560,   560,   398,   422,    55,  3126,
    3127,   344,   561,   567,   347,   496,   408,   561,   108,   561,
     412,   562,   540,  3140,   561,   417,   317,   256,   331,   331,
     422,   561,   561,   561,   331,    40,   371,   261,   561,   331,
     561,   561,  3159,   561,   535,   222,   540,    94,   561,    44,
      97,   562,   444,   562,   383,   540,  3654,   567,   105,   197,
     303,   444,   445,   446,   447,   448,   449,   561,   380,   461,
    2236,  2237,  2238,   230,   540,   517,   561,   460,   476,   471,
    3678,  3198,   299,   540,   517,   477,   476,   429,   430,   560,
     307,   483,  3209,   485,   486,   561,   540,   168,   490,   491,
     560,  2267,  2268,  2269,   561,   429,   430,   331,   560,   501,
     331,   331,   560,   505,   540,   406,   215,   561,   510,   511,
      32,   513,   514,   515,   516,   560,   528,   331,   528,  3627,
     540,   230,   511,   108,   232,   561,   232,   540,   367,   330,
      85,   540,   232,   540,   243,   331,   331,    57,    67,   373,
     331,   561,   376,   370,   561,   384,    66,   549,   561,   535,
      79,   390,   561,   331,   561,   540,     4,   396,    78,   460,
     331,     9,    10,   565,   562,   560,   562,   303,   151,   232,
     476,   573,   574,   561,   561,    65,   578,   476,   439,    27,
     561,   420,   561,   585,    32,   540,   562,   561,    36,   118,
     476,   418,   431,   432,    16,   561,   517,   540,   550,   551,
     552,   553,   554,   555,   556,   557,   561,   561,   317,  3336,
    3337,   472,   473,   615,   517,   561,   550,   551,   552,   553,
     554,   555,   556,   557,   230,   325,   326,   502,   467,  3356,
     330,  3358,   561,  3360,  3361,   561,   327,   337,  3337,   523,
     168,   561,   561,   504,   561,  3372,   166,   561,   142,   524,
     525,   562,   403,   514,   174,   331,   561,   331,   123,   342,
     215,   511,   319,   497,   364,   472,   160,   249,   116,   671,
     270,   560,   511,   560,   513,   230,    57,   679,   560,  3406,
     682,   342,    57,   685,   686,   561,   180,   561,   243,   561,
     561,   366,    44,   213,    44,   135,    44,   406,   142,   384,
     194,    12,    13,   342,   531,     5,   235,   342,   131,   561,
      44,   562,   232,  3440,    44,    44,   543,   561,  3445,   562,
     118,   414,    16,   532,   424,    28,   274,   729,   569,   731,
     171,   123,    34,   532,   560,    28,   142,  3464,   561,   222,
    3467,  3468,  3469,   237,   238,   138,   568,   562,   561,   209,
     138,   460,   532,   263,   210,   106,   568,   331,   569,   548,
     568,   138,   317,  3490,   562,   195,   560,   249,   547,   562,
     426,   265,   548,    84,  3501,   304,   433,    23,    24,   168,
     568,   394,   337,  3510,  3511,   168,   168,   547,   534,   108,
    3517,   523,  1570,   169,  1805,    97,   325,   326,   677,   328,
    3486,   112,   104,  3020,   504,  3532,   123,  3534,    54,    55,
      56,  3197,  3023,  3540,  3678,   126,  3643,    63,  3649,  3573,
    3530,    67,  3573,  3562,   481,  3552,  3538,  2603,  3537,   323,
      76,  1129,  3029,   392,  3561,  3562,  1540,   148,  2758,  3124,
    2424,   306,  3569,  2032,   364,  2685,  1544,    93,   159,  3576,
     379,   406,   509,   155,  1992,  3582,  3583,  1506,  1945,  2672,
     162,  2708,   108,  2708,  2741,   111,  3593,  3151,  2946,   363,
    2992,  2983,  2673,  3600,  2628,  3362,  3371,   188,   880,  3290,
     882,  3143,  3209,  3610,  3166,  3612,  3613,  1125,  1049,  3616,
    1988,  3618,  1144,  3620,   140,  1474,  1853,   199,  2246,  1410,
    3627,   686,   213,   905,  3631,   460,   670,   456,   219,   911,
    3637,   603,  1867,  3255,   306,  1836,  2870,  1425,  3072,   439,
    3647,   450,  2871,  3650,  2065,  3652,  1172,  3654,  1222,  2643,
    3361,  2221,    34,  2679,  3567,  3121,  3100,  3664,  3665,  1832,
     117,  3668,   975,  1857,  2885,   256,   948,   952,   950,  2595,
     952,  3678,  1872,  2594,  2653,   446,   404,  3631,   731,   261,
    1149,  3445,   964,   965,   429,   430,   506,   213,   437,  1376,
    2585,   419,   974,   975,   220,  3520,   980,   425,    23,    24,
    3541,  3349,  3647,   985,   504,  3415,  2985,  2600,  1431,   306,
     993,   993,  2298,  1402,  2911,    97,  2636,   445,  3108,   586,
     429,   983,   104,   945,  3243,  1007,  1008,  1009,  1010,    54,
      55,    56,  1134,  2233,  3249,  1017,   318,  1019,    63,   430,
     590,  2551,    67,  1025,   201,   327,  1293,   389,   330,   331,
    2198,    76,   496,  1035,   389,   473,  2755,   429,   430,  3026,
     286,   495,   123,  2030,   495,   495,    -1,    -1,    93,    -1,
      -1,    -1,    -1,   155,   300,    -1,   367,    -1,    -1,    -1,
     162,    -1,    -1,   108,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,   384,    -1,    -1,    -1,    -1,  1080,   390,
     257,  1083,    -1,    -1,    -1,   396,   551,   552,   553,   554,
     555,   556,   557,    -1,    -1,   140,    -1,   199,    -1,    -1,
      -1,    -1,    -1,    -1,   281,   351,    -1,   353,    -1,   420,
      -1,    -1,   429,   430,    -1,    -1,    -1,    -1,    -1,    -1,
     431,   432,    -1,    -1,    -1,    -1,    -1,    -1,   374,   375,
    1132,   377,  1134,    -1,  1136,  1137,  1138,  1139,  1140,    -1,
      -1,    -1,    -1,    -1,   225,    -1,    -1,  1149,    -1,  1151,
      -1,    -1,    -1,    13,    14,    -1,   467,    -1,    -1,   261,
     552,   553,   554,   555,   556,   557,    26,   413,   213,    -1,
      -1,    -1,   123,    -1,   476,   220,   478,    -1,    -1,   481,
      -1,    -1,    -1,  1185,    -1,    -1,    46,    47,   365,   491,
      -1,    -1,    52,    -1,   371,   497,    56,    57,   500,    -1,
     511,   246,   513,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    -1,   318,    -1,    -1,    -1,
      -1,    -1,   399,  1225,    84,   306,    -1,    -1,   330,   331,
      -1,    -1,    -1,   550,   551,   552,   553,   554,   555,   556,
     557,   286,    -1,   103,    -1,    -1,    -1,    -1,   494,    -1,
     552,   553,   112,   113,   114,   300,    -1,   503,   435,    -1,
      -1,    -1,    -1,    -1,    -1,   125,   126,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   225,    -1,    -1,    -1,   455,    -1,
      -1,  1283,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,
      -1,    -1,    -1,   470,    -1,   472,  1298,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   164,    -1,   351,    -1,   353,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   562,    -1,    -1,    -1,
      -1,    98,    99,   100,   101,   102,    -1,    -1,   188,   374,
     375,    -1,   377,    -1,    -1,   195,    31,    32,   198,    -1,
      -1,    -1,    37,    -1,    39,    40,    41,    -1,   429,   430,
      -1,    -1,    -1,    -1,    -1,   306,  1358,    -1,    -1,   219,
      55,  1363,  1364,    -1,  1366,    -1,    -1,    -1,   413,  1371,
      -1,    -1,    -1,   233,   476,  1377,   478,  1379,    -1,   481,
      -1,    -1,  1384,  1385,    -1,  1387,    -1,    -1,    -1,   491,
      -1,   251,    -1,   170,    -1,   497,   256,  1399,   500,    94,
    1402,    -1,    97,    -1,    -1,    -1,  1408,  1409,  1410,  1411,
     105,    -1,    -1,    -1,    -1,    -1,  1418,  1419,  1420,    -1,
      -1,    -1,    -1,    -1,    -1,   202,   203,   204,   205,   124,
      -1,    -1,    -1,    -1,  1436,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1445,    -1,    -1,   141,    -1,    -1,   494,
     552,   553,    -1,    -1,   535,    -1,    -1,    -1,   503,    -1,
    1462,    -1,    -1,    -1,    -1,  1467,   161,    -1,   163,   550,
     551,   552,   553,   554,   555,   556,   557,  1479,   429,   430,
      -1,   341,    -1,  1485,    -1,    -1,    -1,   182,   183,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,    -1,    -1,    -1,    -1,    -1,    -1,   369,
      -1,    -1,    -1,    12,    13,   560,    -1,    -1,   295,    -1,
     297,   298,   299,    -1,    -1,    -1,    -1,    -1,   223,   389,
     307,   391,   392,    -1,    -1,   395,    -1,    -1,   398,    -1,
     400,    -1,  1544,    -1,    -1,   405,    -1,   407,    -1,    -1,
    1552,    -1,    -1,    -1,    -1,   250,   416,    -1,    -1,    -1,
     420,    -1,    -1,    -1,   259,   260,   426,   262,    -1,    -1,
      -1,   431,    -1,    -1,    -1,   435,    -1,  1579,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,    -1,  1591,
      -1,    -1,  1594,   370,   454,   290,   291,   292,   458,   550,
     551,   552,   553,   554,   555,   556,   557,    -1,    -1,    -1,
      -1,    -1,    -1,   112,    -1,   310,   311,   312,    -1,    -1,
      -1,   316,    -1,    -1,   319,    -1,    -1,   126,    -1,    -1,
      -1,    -1,   492,    -1,    -1,    -1,    -1,   332,   333,    -1,
     417,   418,    -1,    -1,    -1,    -1,    -1,    -1,   508,   148,
      -1,   511,    -1,    -1,    -1,    -1,   516,    -1,    -1,    -1,
     159,    -1,   357,    -1,   359,    -1,    -1,    -1,    -1,   123,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   539,
      -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,    -1,   188,
      23,    24,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,
     560,    -1,    -1,    -1,    -1,    13,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,    23,    24,    -1,    -1,    -1,
     219,    54,    55,    56,    -1,    -1,    -1,    -1,    -1,   424,
      63,   426,    -1,    -1,    67,    -1,    -1,    -1,    -1,    -1,
      -1,   436,    -1,    76,    52,    -1,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    -1,   531,  1757,    -1,   256,    -1,    67,
      93,    -1,    -1,    -1,    -1,   542,   543,    -1,    76,    -1,
      -1,   225,    -1,    81,    -1,   108,    -1,    -1,   111,    -1,
      -1,    -1,   477,   478,    -1,    93,   481,   482,   483,   484,
      -1,    -1,   246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     108,    -1,    -1,   111,    -1,    -1,    -1,   140,    -1,    -1,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,   126,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,   524,
     525,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,   306,    -1,    -1,    -1,  1858,   165,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   367,    -1,
      -1,   325,   326,    -1,  1876,  1877,    -1,    -1,    -1,    -1,
     213,  1883,    -1,  1885,  1886,   384,    -1,   220,    -1,    -1,
      30,   390,    32,    33,    -1,    -1,    -1,   396,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   213,    -1,    -1,    -1,    -1,
      -1,    -1,   220,    -1,    54,    55,    -1,  1919,    -1,    -1,
      -1,   420,    -1,    -1,    64,    -1,    66,    -1,    -1,  1931,
    1932,   385,   431,   432,    -1,    -1,    -1,    -1,    -1,  1941,
      -1,    -1,    -1,    83,    84,  1947,    -1,    -1,  1950,    -1,
      -1,  1953,    92,   286,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1964,  1965,    -1,  1967,    -1,   300,   467,    23,
      24,  1973,  1974,    -1,    -1,   429,   430,    -1,   286,    -1,
      -1,  1983,    -1,  1985,   438,    -1,    -1,  1989,  1990,    -1,
      -1,    -1,   300,    -1,    -1,    -1,    -1,   305,    -1,   139,
     140,    -1,    56,    -1,   144,    -1,    -1,    -1,    -1,    -1,
      -1,   508,   511,    67,   513,  3440,    -1,    -1,   351,    -1,
     353,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,  2031,
    2032,    -1,    -1,   173,    -1,   175,    -1,   345,    -1,    93,
      -1,   374,   375,   351,   377,   353,    -1,   187,    -1,   189,
      -1,    -1,    -1,    -1,   108,  2057,    -1,   111,    -1,    -1,
      -1,    -1,  2064,    -1,   561,    -1,   374,   375,    -1,   377,
      -1,    -1,   212,   213,    -1,  2077,   216,    -1,    -1,    -1,
     413,    -1,    -1,   391,    -1,    -1,   140,    -1,    -1,    -1,
      -1,   231,  3517,    -1,    -1,   549,   550,   551,   552,   553,
     554,   555,   556,   557,    -1,   413,    -1,  3532,    -1,  3534,
      -1,    -1,   252,    -1,    -1,  3540,    -1,   257,    -1,    -1,
      -1,  2123,   267,   268,   269,   270,   271,   272,    -1,    -1,
     275,   276,   277,   278,   279,   280,    -1,   282,    -1,    -1,
      -1,   281,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3576,    -1,    -1,    -1,    -1,    -1,    -1,  3583,   213,
      -1,   494,    -1,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     503,    -1,    -1,   313,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   322,    -1,    -1,    -1,   494,    -1,  3613,    -1,
      -1,    -1,   689,  3618,    -1,   503,    -1,    -1,    -1,    -1,
     340,    -1,  2204,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3637,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   365,   366,  2229,    -1,    -1,
      -1,  2233,   286,  2235,  2236,  2237,  2238,    -1,    -1,  3664,
    3665,   386,   387,  3668,  2246,    -1,   300,    -1,  2250,    -1,
      -1,  2253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2267,  2268,  2269,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2280,  3440,
      -1,    -1,    -1,    -1,  2286,   425,  2288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2296,   435,    -1,   351,    -1,   353,
      -1,   798,    -1,    -1,    -1,    -1,  3467,  3468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
     374,   375,    -1,   377,    -1,    -1,    -1,   824,    -1,    -1,
      -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3510,
    3511,    -1,    -1,    -1,  2356,    -1,  3517,    -1,    -1,   413,
      -1,    -1,    -1,    -1,    -1,  2367,    -1,    -1,  2370,    -1,
      -1,  3532,    -1,  3534,    -1,    -1,    -1,   874,    -1,  3540,
      -1,   878,    -1,    -1,    -1,    -1,   526,    -1,    -1,    -1,
     530,  3552,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3561,  3562,  2404,    -1,    -1,    -1,    -1,    -1,    -1,  2411,
      -1,    -1,  2414,    -1,    -1,  3576,  2418,  2419,    -1,    -1,
    2422,    -1,  3583,    -1,    -1,    -1,    -1,    -1,  2430,    -1,
      -1,    -1,  3593,    -1,    -1,    -1,  2438,    -1,    -1,  3600,
     494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   503,
      -1,    -1,  3613,    -1,    -1,  3616,    -1,  3618,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3637,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3650,
      -1,  3652,    -1,    -1,    -1,    -1,   993,    -1,    -1,    -1,
      -1,    -1,    -1,  3664,  3665,  1002,    -1,  3668,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2600,  2601,
      -1,  2603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2612,    -1,    -1,    -1,    -1,    -1,  2618,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2628,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2636,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2653,    -1,    -1,    -1,    -1,  1153,  1154,  1155,    -1,
      -1,    -1,    -1,  2665,    -1,  1162,  1163,    -1,    -1,  1166,
    2672,  1168,  1169,  1170,  1171,    -1,    -1,  2679,  1175,    -1,
      -1,  1178,  1179,  2685,  1181,    -1,  1183,  1184,    -1,  1186,
    1187,  1188,  1189,  1190,    -1,  1192,    -1,  1194,  1195,  1196,
      -1,  1198,  1199,  1200,  1201,    -1,  1203,  1204,    -1,  1206,
      -1,    -1,  1209,  1210,  1211,    -1,  1213,  1214,  1215,  1216,
      -1,  1218,  1219,  1220,  1221,    -1,    -1,    -1,    -1,    -1,
    1227,  1228,    -1,  1230,  1231,  1232,  1233,  1234,    -1,    -1,
      -1,    -1,  1239,    -1,  1241,  1242,  1243,  1244,  1245,    -1,
      -1,  1248,  1249,  1250,  1251,  1252,  1253,    -1,  1255,  1256,
    2762,    -1,  1259,  1260,  1261,    -1,  1263,    -1,  1265,    -1,
      -1,    -1,  1269,    -1,  1271,  1272,    -1,    -1,    -1,    -1,
    1277,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1285,  1286,
    1287,    -1,    -1,    -1,    -1,    -1,    -1,  1294,    -1,    -1,
    1297,    -1,    -1,    -1,    -1,    -1,    -1,  1304,  1305,  1306,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2862,    -1,    -1,  1360,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2900,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1405,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2941,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2983,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3008,    -1,  3010,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3021,
      -1,  3023,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1554,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3072,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3120,    -1,
      -1,    -1,    -1,    -1,  3126,  3127,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3140,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3159,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3198,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3209,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1729,  1730,  1731,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1746,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1772,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1794,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3336,  3337,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3356,    -1,  3358,    -1,  3360,  3361,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3406,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3445,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3464,    -1,    -1,    -1,    -1,  3469,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3490,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2044,    -1,    -1,
    2047,    -1,    -1,  2050,  2051,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2063,  3569,    -1,  2066,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3582,    -1,  2079,    -1,  2081,    -1,    -1,    -1,  2085,    -1,
    2087,  2088,    -1,    -1,    -1,  2092,    -1,  2094,  2095,    -1,
    2097,    -1,    -1,  2100,    -1,  2102,  2103,    -1,  3610,    -1,
    3612,  2108,  2109,    -1,    -1,  2112,    -1,  2114,  3620,  2116,
      -1,  2118,    -1,  2120,    -1,  3627,    -1,    -1,    -1,  3631,
      -1,    -1,    -1,    -1,  2131,  2132,    -1,    -1,  2135,    -1,
    2137,    -1,    -1,    -1,    -1,  3647,    -1,    -1,  2145,  2146,
      -1,  2148,  3654,  2150,    -1,    -1,  2153,  2154,  2155,    -1,
    2157,    -1,    -1,    -1,    -1,  2162,  2163,  2164,  2165,    -1,
      -1,    -1,    -1,  2170,  2171,  2172,  3678,  2174,    -1,  2176,
      -1,  2178,    -1,  2180,    -1,  2182,    -1,    -1,    -1,    -1,
      -1,    -1,  2189,    -1,  2191,    -1,    -1,  2194,  2195,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2205,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2220,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2240,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2289,    -1,    -1,    -1,    -1,  2294,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2337,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2453,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2526,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2536,
      -1,  2538,    -1,  2540,    -1,    -1,    -1,    -1,    -1,  2546,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2569,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2637,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2785,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2795,    -1,
      -1,    -1,    -1,    -1,  2801,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2810,  2811,    -1,    -1,    -1,    -1,  2816,
      -1,    -1,    -1,  2820,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2833,    -1,    -1,    -1,
      -1,    -1,  2839,    -1,    -1,  2842,  2843,    -1,  2845,  2846,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2926,
    2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2937,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3095,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3218,    -1,    -1,    -1,    -1,    -1,  3224,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3269,    -1,  3271,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3395,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3506,
    3507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3526,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3535,    -1,
      -1,    -1,    -1,    -1,    -1,  3542,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3551,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3580,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,  3594,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    42,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,  3655,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,   239,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,   486,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,   337,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,   420,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,   171,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,   171,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,   171,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,    -1,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,    -1,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,   174,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,   213,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,   246,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   567,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,   174,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,   213,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,   567,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,   561,    -1,    23,    24,    25,    26,   567,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,   561,    17,    -1,    -1,    20,   566,   567,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,   222,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
     554,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   560,    -1,    17,    -1,
      -1,    20,    -1,   567,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,    -1,    -1,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,   566,   567,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,   567,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,   566,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,   566,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,   566,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,    -1,   548,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,   562,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   554,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,   132,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,   546,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,   532,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,   532,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,   546,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,    -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,   162,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,   261,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,   325,   326,    -1,   328,    -1,    -1,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,   441,   442,
     443,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,   497,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,   142,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,   427,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    88,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    32,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    18,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,   150,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,   171,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,   364,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      -1,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,    -1,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,    -1,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   602,   769,   787,   790,   798,   800,   802,   805,
     810,   812,   817,   820,   825,   829,   837,   838,   975,   977,
     983,   986,  1011,  1019,  1030,  1032,  1046,  1049,  1052,  1058,
    1062,  1066,  1069,  1070,  1116,  1133,  1139,  1141,  1148,  1150,
    1175,  1181,  1182,  1183,  1184,  1230,    11,    91,   175,   210,
     366,   783,  1205,  1206,   252,   329,   819,   470,   472,  1135,
    1176,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   596,  1106,  1110,  1114,  1115,   281,  1135,
    1135,   536,  1177,    91,   174,   439,   473,   504,   514,   594,
     687,   688,   689,   761,  1020,   976,    91,   175,   213,   366,
     473,   488,   514,   529,   982,  1110,   819,   595,   567,  1104,
    1105,  1110,   584,   984,  1067,    93,   213,   472,  1135,   819,
    1110,  1063,   416,   514,  1135,   819,   987,  1059,  1135,   595,
    1177,  1110,   840,   842,   843,   342,  1118,  1033,   454,   458,
     435,   487,   435,   472,  1031,  1140,  1012,  1110,    28,    69,
     138,   362,   382,   407,   454,  1232,   420,   560,   839,     0,
       3,   362,   153,  1050,  1104,  1110,   142,   775,  1110,   596,
     596,   472,   109,  1200,  1201,  1202,  1135,   801,  1177,   826,
     827,  1104,   603,   567,   485,   803,   813,    16,  1178,   209,
     690,   595,   347,  1197,  1201,  1202,  1203,  1204,  1205,   472,
     688,   213,   210,   264,   372,  1028,  1029,   892,   893,   209,
     981,   981,  1110,   981,   981,   595,   981,  1135,   579,  1053,
      12,    13,    84,   112,   126,   148,   159,   188,   213,   219,
     256,   367,   384,   390,   396,   420,   431,   432,   467,   511,
     513,  1151,  1153,  1155,  1156,  1110,   340,    60,   380,   567,
     245,   476,  1107,  1110,  1112,   110,   200,   264,   989,    76,
     371,  1068,  1071,   222,  1104,  1134,  1135,   171,    32,   281,
    1038,  1064,  1110,   595,   821,  1135,   110,   264,   990,  1018,
     281,   371,   435,  1060,  1061,   799,    12,  1149,  1153,   485,
    1178,   841,    12,   122,   200,   444,   445,   446,   447,   448,
     449,   460,   847,   848,   849,  1117,    30,    33,    54,    55,
      64,    66,    83,    84,    92,   140,   144,   173,   175,   187,
     189,   212,   213,   216,   231,   252,   257,   281,   313,   322,
     340,   365,   366,   425,   435,   459,   472,   530,   734,   760,
    1034,  1038,  1039,  1041,  1124,   792,   793,   792,   792,   535,
     791,   792,   980,  1104,  1135,  1018,    34,   199,   476,  1092,
    1108,  1231,  1231,  1231,  1231,  1231,   842,   839,   561,  1110,
    1048,  1047,   294,   474,   499,   771,   773,   772,  1104,   142,
     450,  1207,   811,   979,   980,   225,   562,   833,   834,   560,
     604,  1110,   586,   979,   979,    51,   328,   328,   389,  1179,
     325,   326,   864,  1110,    88,  1112,  1113,  1166,  1167,   395,
      10,   366,   488,   853,  1199,  1207,  1208,  1216,  1218,  1219,
    1225,   853,  1198,  1208,  1216,  1219,  1225,  1200,  1205,   690,
    1110,   171,  1021,  1025,  1026,  1110,  1028,     7,    20,    22,
      25,    29,    32,    34,    35,    36,    38,    50,    54,    55,
      61,    64,    72,    73,    79,    81,    82,    83,    87,    88,
      90,    91,    95,    96,    97,   102,   104,   107,   108,   115,
     116,   133,   136,   137,   149,   152,   154,   155,   158,   162,
     167,   172,   176,   177,   178,   179,   181,   182,   184,   185,
     186,   190,   192,   193,   199,   205,   209,   219,   221,   236,
     240,   243,   248,   250,   253,   258,   261,   266,   273,   283,
     287,   295,   299,   301,   302,   306,   307,   308,   309,   310,
     311,   312,   318,   325,   326,   327,   330,   331,   336,   353,
     354,   356,   357,   358,   359,   360,   370,   378,   394,   395,
     406,   409,   412,   414,   418,   456,   457,   462,   464,   465,
     466,   469,   476,   478,   479,   480,   481,   490,   491,   492,
     497,   500,   505,   506,   514,   518,   519,   520,   521,   522,
     527,   531,   541,   543,   548,   552,   553,   558,   560,   563,
     564,   566,   567,   858,   859,   860,   861,   865,   868,   869,
     871,   878,   882,   894,  1091,  1093,  1095,  1096,  1100,  1102,
    1106,  1110,   149,  1110,  1110,   337,   596,   596,  1113,  1165,
     979,   981,   517,   580,   117,   201,   257,   281,   365,   371,
     399,   435,   455,   470,  1054,  1055,  1135,   365,  1154,   410,
     410,   473,   514,   529,   342,  1158,   470,  1160,    59,   435,
    1157,    92,   529,  1159,   337,   562,    18,   142,   935,   936,
    1142,  1110,   783,   858,    74,   171,   264,  1072,  1078,    46,
     171,  1104,  1136,  1137,   818,   566,   577,  1107,   257,   822,
    1113,   823,   824,  1104,   806,   222,   980,   991,   992,    46,
     562,   979,  1154,   337,   416,  1180,  1179,   503,  1185,  1186,
     554,   851,   852,   853,   849,  1119,  1120,  1121,   257,   147,
     426,   246,   533,  1045,   493,   560,    91,   175,   366,   472,
     529,  1045,   697,  1112,   247,   954,   956,    62,   455,   168,
     455,   455,   455,   281,   470,    62,   455,   201,   455,   455,
     493,   954,  1045,   171,   225,  1042,   257,   139,    65,   368,
     470,   489,   455,   526,   789,   388,   451,   794,   795,   788,
      77,   783,   562,   339,  1234,   468,  1235,   230,   402,  1233,
     561,  1186,  1188,  1189,  1190,   837,  1051,  1092,  1110,   108,
     685,   686,   695,   696,   743,   597,   597,   770,  1113,   419,
     529,   979,   485,   562,   108,   828,  1110,   827,   213,   232,
     758,   759,   835,   605,   606,   858,   267,   268,   269,   270,
     271,   272,   275,   276,   277,   278,   279,   280,   282,   386,
     387,   587,   588,   589,   153,   372,   804,    53,   153,   156,
     168,   293,   372,   814,   815,   816,    51,   389,   149,   593,
     560,   857,   566,   207,   562,   853,   853,   853,   175,   529,
     175,  1208,  1104,   494,   517,   762,  1025,  1104,  1110,   562,
    1023,   567,  1027,   560,   560,   560,   560,   560,   869,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   857,   857,   560,   857,   560,   560,   560,
     500,   560,  1091,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   858,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   895,   896,   897,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   858,   560,
     857,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   857,   560,  1091,   560,   560,   560,
    1091,   560,   560,    34,   199,   476,   560,   560,   560,   857,
     857,   857,   560,   560,   560,   560,   560,   560,   858,   899,
     869,   869,   869,   420,   560,   858,  1194,  1110,   883,  1110,
      15,    16,   344,   347,   540,   862,   863,   142,   143,   180,
     194,   226,   238,   265,   321,   866,   123,   225,   246,   306,
     385,   429,   430,   438,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   864,   869,    98,    99,   100,   101,   102,
     170,   202,   203,   204,   205,   295,   297,   298,   299,   307,
     370,   417,   418,   531,   542,   543,   932,   933,    63,   346,
     562,  1108,   560,   567,   567,  1104,   562,    48,   401,   784,
     979,   566,   581,   582,    46,   535,   562,  1056,   470,   560,
    1168,  1168,  1168,  1168,   175,   366,   472,  1152,  1156,  1110,
     160,   323,  1110,  1143,  1144,   991,   281,   252,  1077,   830,
     281,   936,   562,   979,  1112,    27,   485,  1065,   562,   485,
     562,   485,   979,   992,   988,  1061,   171,   562,   175,   366,
    1152,  1110,    12,   122,  1192,   562,   844,   855,   858,  1098,
    1110,   562,   187,   252,   338,   425,  1122,  1123,  1126,  1127,
     225,  1043,  1107,   858,   554,   690,   596,   596,  1104,  1104,
    1035,   261,   331,   497,   957,   958,  1093,   596,  1045,  1113,
     168,  1040,  1042,   596,  1045,  1040,  1104,  1042,  1040,  1040,
    1045,  1045,   510,   796,   562,   796,   437,   420,   560,   564,
     902,   903,   904,   905,   914,   915,   923,  1092,   355,  1236,
     345,   950,   956,  1191,   686,    63,   734,    67,    79,   235,
     304,   328,   379,   450,   599,   601,     6,    13,    23,    24,
      52,    56,    67,    76,    81,    93,   111,   120,   121,   126,
     134,   140,   165,   211,   213,   220,   286,   300,   305,   345,
     351,   353,   374,   375,   377,   391,   413,   494,   503,   692,
     694,   695,   696,   776,   777,   778,   946,   109,   224,  1104,
    1107,   980,   560,   561,   562,   142,   142,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     562,   512,   815,   684,   685,   561,  1112,    44,  1167,   175,
     596,   596,   596,  1110,  1104,   591,    43,   196,   415,   763,
     763,   337,  1024,  1022,   567,  1026,   171,   554,  1110,   936,
     858,   858,   858,    12,   122,   888,   937,   104,   162,   199,
     261,   331,   497,   960,   888,   888,   888,   858,   858,   892,
     892,   858,   892,   858,   858,   858,   858,   122,   888,   937,
     858,   561,   858,   858,   858,   858,   858,  1100,  1110,   858,
     858,   858,   858,   858,   560,  1194,   858,   932,   858,   858,
     858,   561,   858,   858,   858,   858,   892,   858,   858,    94,
      97,   478,   481,   934,   858,   122,   885,  1091,   858,   858,
     858,   561,   858,   858,   858,   858,   892,   858,   858,   858,
     858,   896,     9,   898,  1100,   122,   888,   858,   858,   122,
     888,   858,   858,   858,   858,   858,   892,   892,   892,   858,
     858,   858,   858,   858,   858,   892,   861,   858,   561,   858,
     858,   858,   858,   858,   561,   858,   858,   888,   888,   858,
     858,   858,   122,   888,   858,   858,   933,   933,   858,    42,
     239,   486,   858,   858,  1091,   561,   858,   561,   888,  1101,
    1102,  1110,   888,   858,   858,   858,   532,   901,  1195,  1195,
     561,   562,   561,   858,   566,   884,  1112,   567,   858,   858,
     858,   860,   155,   330,   491,   507,   864,    12,    17,   860,
     867,   861,   560,   869,   861,   861,   861,   861,   246,   861,
     861,   861,   861,   868,   861,   868,   861,   861,   861,   861,
     225,   246,   385,   549,   553,  1112,   869,   858,   870,  1110,
    1110,   978,  1113,   784,  1112,   562,   380,  1055,   979,  1057,
    1110,  1169,  1170,   554,  1104,  1110,  1164,  1164,  1164,   142,
     160,   180,   194,   237,   238,   265,   323,   363,  1145,  1147,
     533,   938,   985,   214,   831,   832,  1104,   264,   380,   537,
    1138,  1137,   858,  1107,  1113,  1113,   824,  1104,   153,   372,
     515,   807,   808,   809,   420,   426,   522,   523,   560,   680,
     993,   996,  1107,   188,  1164,  1164,  1164,  1187,   852,   171,
     222,   845,   846,   949,   950,   971,   854,   567,  1120,   108,
     487,  1110,  1129,   314,   353,   566,   734,  1128,  1107,   171,
    1044,   561,  1110,   257,   455,  1037,   334,   562,   435,  1045,
    1110,  1045,  1040,  1104,  1045,  1045,   589,   797,   795,   922,
    1110,    85,   215,   230,   243,   317,   406,   460,   913,   426,
     562,  1104,   922,   562,   168,  1237,    44,   954,   142,   427,
    1002,  1003,  1003,  1107,   450,   450,   450,   450,   450,   419,
      66,    78,   174,   439,   706,   709,   710,   756,   758,   782,
     782,  1003,  1003,   782,  1003,  1003,  1003,   485,   119,  1003,
     231,   471,   166,   364,   758,   782,   231,  1003,   471,   119,
    1003,  1003,  1003,   782,    44,  1003,  1003,  1003,  1003,  1003,
      18,   142,   485,   786,  1003,  1003,  1003,   692,   562,   560,
     567,   705,   711,  1103,  1110,   774,   364,   930,  1110,   858,
     960,  1107,  1107,   104,   162,   261,   331,   497,   961,  1107,
     960,  1107,  1107,  1107,  1107,  1107,   960,  1107,  1107,   960,
     588,   353,   476,  1110,  1226,     8,    27,   672,   560,   403,
    1209,   246,   560,   674,   691,   693,   694,  1104,   517,   938,
    1110,   903,   567,  1027,   562,   561,   561,   562,   888,   561,
     889,   562,   561,   561,   561,    18,   561,   517,   561,   561,
     561,   561,   562,   562,   517,   562,   562,   879,   561,   554,
     561,   562,   562,   561,   561,   562,   561,   567,   561,   562,
     561,   562,   562,   562,   561,   562,   561,   562,   171,   562,
     562,   561,   562,   561,   562,   562,   561,   562,   561,   561,
     562,   561,   562,   562,   562,   881,   562,   561,   562,   562,
     561,   562,   562,   561,   562,   561,   562,   561,   562,   562,
     562,   561,   560,   562,   888,   561,   561,   561,   888,   561,
     561,   562,   562,   561,   561,   562,   561,   562,   561,   561,
     561,   561,   561,   561,   561,   562,   562,   561,   562,   561,
     225,   561,   561,   562,   562,   562,   561,   562,   562,   561,
     561,   561,   562,   171,   562,   562,   888,   561,   561,   561,
     562,   562,   562,   561,   171,   858,   171,   858,   171,   858,
     171,   561,   562,   562,   561,   561,   561,   561,   561,   562,
     561,   562,   561,   858,   532,   546,   900,   840,   839,   892,
     565,   187,   252,   425,  1125,   427,  1110,   155,   330,   491,
     507,   560,   858,  1194,   146,   942,   861,    16,   932,   932,
     560,   869,   861,   861,   858,   873,   874,   875,   560,   567,
     582,   256,   561,   562,   567,   567,   485,   485,   485,  1146,
     939,   955,   956,   993,   476,  1109,   562,   833,   537,   252,
     485,   808,   681,   994,   560,   999,  1004,   999,   561,   680,
     995,  1097,  1098,  1101,  1110,   997,   342,   171,   171,   171,
     838,   127,   903,   972,   168,   256,   850,   971,   955,   846,
      18,   856,  1107,  1110,   554,  1110,   567,   227,   567,  1002,
      32,   108,   735,   736,  1002,  1112,   168,  1002,   566,  1112,
      32,   108,   738,   739,  1112,   961,  1036,   144,   530,   958,
     958,   535,   938,  1040,   562,   917,   922,   902,   230,   230,
     348,   924,   230,   243,   406,   924,   914,   902,  1014,  1015,
    1101,   902,   936,   919,   920,   960,   296,   951,   108,   740,
     742,  1112,   736,    93,    93,   109,   224,   766,  1103,   759,
     759,    57,   166,   364,   504,   708,   757,   707,   708,   766,
    1103,   961,   960,  1103,   960,  1107,  1107,   734,  1003,   960,
     232,   232,  1103,  1103,   697,  1003,   160,   237,   328,   700,
     961,   961,  1103,   947,   948,  1101,   108,   960,  1107,   960,
     960,   373,   376,   699,   960,  1104,    70,    71,   108,   130,
     161,   383,   698,   697,   560,   778,   703,   704,   705,   706,
    1110,     8,   160,   785,   384,   707,   748,   712,   567,   560,
    1210,   561,   562,   476,   403,   560,   112,   219,   511,   673,
    1220,   105,   223,   381,   461,   702,  1210,  1104,   246,   675,
     680,   703,   210,   395,   677,  1079,   562,   693,   592,   903,
     949,   938,   936,   221,   858,   858,   561,   858,   858,    32,
      55,    94,    97,   105,   319,   433,   481,   509,   890,   735,
     892,   858,   735,   890,   858,   892,   561,   868,   868,  1108,
    1110,   858,   858,   892,  1108,   858,   858,   858,   892,   331,
     858,   858,   858,   858,   858,   858,   858,   892,   892,   331,
     858,   858,   892,   858,   858,   858,   858,   892,   858,   861,
    1100,   561,   561,   858,   858,   858,   858,   858,   858,   858,
     858,   858,   858,   858,   858,   892,   221,   858,   858,   858,
     858,   561,   858,   858,   858,   858,   171,   858,   171,   858,
     171,   858,   858,   331,   858,   858,   547,   858,   858,   138,
    1193,  1193,   561,   567,   567,   567,  1112,   858,  1194,   561,
     562,   561,   869,   860,   858,  1194,   942,    16,   561,   853,
     876,   877,   891,   892,  1110,  1170,   554,   554,  1166,  1166,
    1166,   560,   858,   337,  1009,  1073,   832,   210,   836,  1113,
     847,  1000,  1001,  1101,  1005,   562,   560,   996,   561,   561,
     562,   567,  1185,   171,  1166,  1166,  1166,   938,   938,   128,
     349,   967,   968,   973,   511,   225,  1107,  1110,   567,  1110,
     244,  1110,    12,    32,   108,   337,   858,  1132,    63,   741,
     858,  1113,   336,   353,   476,  1131,  1125,  1002,   954,   269,
    1045,   589,  1188,   918,   243,   230,   914,   924,   924,   230,
     337,   337,   517,   562,  1013,  1002,   165,   210,   516,   926,
     847,   858,   952,  1099,   858,   232,   232,   759,   766,   762,
     126,   426,   779,   736,  1107,   766,   784,  1107,   780,   562,
      19,   113,   953,   979,   561,   562,  1110,  1104,    31,    32,
      37,    39,    40,    41,    55,    94,    97,   105,   124,   141,
     161,   163,   182,   183,   223,   250,   259,   260,   262,   290,
     291,   292,   310,   311,   312,   316,   319,   332,   333,   357,
     359,   381,   424,   426,   436,   477,   478,   481,   482,   483,
     484,   524,   525,   543,   713,   716,   717,   718,   719,   720,
     721,   722,  1110,  1110,  1211,    18,  1110,   702,  1227,   337,
     607,   608,   610,  1110,   496,    18,  1104,   561,   561,    18,
     683,   693,   560,   938,   247,   959,   858,   561,   561,   561,
     560,   728,   728,   560,   723,   724,   728,   223,   223,   561,
     561,   561,   561,   561,   561,   562,   880,   932,   932,   561,
     561,   561,   561,   561,   561,   562,   561,   561,   561,   561,
     561,   562,   561,   561,   561,   561,   561,   887,   950,   562,
     562,   562,   561,   561,   561,   561,   562,   561,   561,   561,
     562,   225,   535,   872,   561,   561,   561,   561,   561,   561,
     561,   561,   561,   562,   561,   561,   561,   858,   561,   168,
     561,   561,   562,   562,   561,   562,   562,   561,   858,   561,
     858,   561,   858,   561,   561,   562,   561,   561,   858,   547,
    1196,  1196,   567,   767,   561,   892,   561,   562,   561,   860,
     858,   562,   561,   397,  1171,  1171,  1171,   108,   858,  1007,
    1008,   129,  1079,   241,   851,   562,  1002,  1006,  1007,  1004,
     998,   996,  1097,  1110,  1166,   955,   191,   943,  1109,  1109,
     566,   969,   970,  1112,   428,   554,   380,   393,   423,  1130,
     742,  1002,   560,   560,  1129,   858,   142,   561,   904,   348,
     902,   914,   230,   230,   902,   914,   907,   906,   908,  1015,
     938,  1008,   758,   927,   927,   927,   851,   562,   953,   766,
     762,   560,   108,   108,   711,   741,   713,   948,   561,   704,
     749,   560,   560,   728,   723,   361,   714,   723,   723,    20,
      32,    45,   502,   734,   744,    55,   524,   717,   719,   744,
     744,    55,   525,   525,   528,   723,   715,   728,   728,   744,
     560,   728,    23,    63,    67,   108,   330,   337,   364,   424,
     504,   730,   731,   732,   747,   864,   528,   560,   744,    32,
     560,   745,   560,   560,   728,   560,   724,   729,   567,   561,
     562,  1212,  1213,   496,   217,   225,   350,   611,   612,   613,
     614,   853,   561,   562,   609,  1107,  1212,   561,   676,   691,
     560,   680,   764,   765,  1110,   958,   932,   331,   744,   331,
     858,   561,   561,   561,   858,   858,   422,   886,   331,   858,
     858,   858,   858,    40,   371,   561,   858,   932,   858,   858,
     858,   858,   858,   561,   561,   561,   331,   858,   561,  1110,
     561,   892,   854,   877,    58,   228,   324,   452,   463,   538,
    1162,  1163,   535,  1172,  1172,  1172,   561,   562,  1010,   222,
     682,  1001,  1008,   561,  1188,    44,   197,   940,   974,  1112,
     562,   303,    68,   498,   380,  1131,   476,   476,  1002,  1107,
     936,   230,   337,   910,   914,   914,   337,   912,   858,   858,
     560,   949,   168,   925,   921,  1099,   560,   560,   764,    97,
     478,   481,   552,   553,  1094,  1095,   785,   730,   283,   337,
     560,   750,   752,   753,   754,   331,   331,   433,   509,   544,
     725,   726,   727,   560,   725,   725,   745,    20,   502,   734,
     746,   745,   735,   744,   528,   725,   560,   744,   331,   725,
     740,  1107,   327,   733,  1094,   511,   108,   232,   732,   232,
     330,   331,   331,   331,   331,   725,   331,   725,  1110,  1110,
     535,  1215,   420,   560,  1214,  1107,   561,   562,   609,  1104,
    1221,   610,   713,  1215,  1188,   677,   680,   678,   561,   562,
     953,   560,   561,   561,   561,   562,   561,   561,   562,   561,
    1092,   561,   562,   561,   562,   561,   561,   303,   151,   561,
     561,   561,   561,   561,   561,   561,   562,   561,   856,   476,
     476,   476,    16,  1161,   188,   284,   285,   288,   289,  1173,
    1174,  1008,   232,  1074,   701,   846,   955,   944,  1099,   941,
     949,    65,  1080,   970,   561,   561,  1132,    16,   902,   909,
     517,   911,   517,   931,  1110,   959,   230,   928,   701,   953,
     764,   764,   561,  1096,  1096,   781,   173,   352,   434,   112,
     511,   751,  1110,   754,   561,   561,   727,   768,  1092,   735,
     745,   768,   561,   857,   327,   523,   561,   561,   561,   561,
      49,    57,   252,   853,   853,  1228,   613,  1110,   168,   403,
     561,  1185,   765,   331,   331,   858,   888,   858,   892,  1162,
     342,   960,   960,   960,   960,  1174,   511,   472,   850,   535,
     562,   945,   953,   858,   955,   135,   145,   343,   475,  1081,
    1082,   249,  1083,   270,   337,   858,   560,   858,   560,   561,
     562,   560,   561,   561,   785,    48,   328,   401,   426,   755,
     755,   561,   562,   561,   562,   561,   857,   744,   745,   744,
     745,    57,   342,    57,   840,   839,   598,   713,   853,  1222,
     679,   953,   561,   561,   561,   562,   561,   561,   561,  1016,
    1017,  1101,  1104,    86,   408,  1099,   366,   962,    44,    44,
     135,    44,  1082,   453,   475,  1084,  1085,   142,   916,   931,
     931,  1110,   929,   930,   748,     5,   108,   330,   752,  1110,
     744,  1092,   744,   342,   342,   561,   118,   599,   600,   864,
    1229,   131,   713,  1188,   858,   562,  1002,  1075,   953,  1110,
    1092,  1092,    44,  1092,    44,    44,  1085,   961,   858,   561,
     561,   561,  1188,   118,    60,   157,   209,   229,   242,   340,
     404,   548,   631,   632,   635,   644,   645,   648,   659,   662,
     664,   665,  1106,  1111,  1115,   414,  1223,   561,  1017,  1008,
     734,   737,   963,  1092,  1092,  1092,    16,   565,  1110,   171,
     323,   637,   634,  1111,  1111,  1110,   633,   646,   649,   573,
     263,   394,   534,   668,    28,   666,   569,  1217,   598,   736,
    1076,   560,   274,   171,  1110,   639,   640,   858,   858,   532,
     651,   655,   616,   631,   616,   669,   667,   660,   663,   631,
    1224,  1080,   853,   964,   965,   966,   142,   222,   138,   858,
     647,   656,   546,   655,   658,   138,   631,   568,   510,   858,
     617,   668,   666,   631,  1083,   858,   561,   562,   960,   636,
     209,   547,   532,   650,   652,   858,   616,   138,   263,   568,
     671,   125,   106,   615,   618,   661,  1111,   661,   210,  1086,
     966,   638,  1110,   641,   653,   652,   658,   657,   548,   858,
     670,    80,   150,   623,   629,  1110,   138,   631,   568,   331,
     560,  1087,   562,   616,   858,   138,   547,   138,   616,   195,
     562,   619,    75,    89,   568,   249,   561,   566,  1088,  1089,
    1101,   426,  1090,  1110,   642,   654,   548,   616,   394,   138,
     168,  1110,   713,   168,   168,  1112,   561,   562,  1016,   132,
     546,   643,   547,   534,   620,   108,   630,   442,   626,   960,
     621,   622,  1089,   639,   616,   616,   441,   443,   624,   625,
     626,   628,   864,  1110,   858,   523,   627,   573,   562,   631,
     169,  1108,   625
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1205 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1218 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1278 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1293 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1302 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1309 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1318 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1325 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1339 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1351 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1359 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1369 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1375 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1384 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1389 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1394 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1399 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1404 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1408 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1413 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1417 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1421 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1425 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1429 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1438 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1442 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1458 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1462 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1473 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 89:
#line 1490 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1492 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1504 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1512 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1517 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1524 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1530 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1532 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1539 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1554 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str), true);
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1569 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str), false);
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1587 "sql_yacc.yy"
    {}
    break;

  case 101:
#line 1588 "sql_yacc.yy"
    {}
    break;

  case 102:
#line 1592 "sql_yacc.yy"
    {}
    break;

  case 103:
#line 1593 "sql_yacc.yy"
    {}
    break;

  case 104:
#line 1599 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 105:
#line 1601 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 106:
#line 1603 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 107:
#line 1605 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 108:
#line 1607 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 109:
#line 1609 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 110:
#line 1611 "sql_yacc.yy"
    { }
    break;

  case 111:
#line 1616 "sql_yacc.yy"
    { }
    break;

  case 112:
#line 1617 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 113:
#line 1618 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 114:
#line 1623 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 115:
#line 1627 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 116:
#line 1634 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 117:
#line 1642 "sql_yacc.yy"
    {}
    break;

  case 122:
#line 1658 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 123:
#line 1662 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 128:
#line 1680 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 129:
#line 1700 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 134:
#line 1737 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 135:
#line 1762 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 136:
#line 1763 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 137:
#line 1764 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 138:
#line 1765 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 139:
#line 1769 "sql_yacc.yy"
    {}
    break;

  case 141:
#line 1774 "sql_yacc.yy"
    {}
    break;

  case 143:
#line 1780 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 144:
#line 1784 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 145:
#line 1810 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 146:
#line 1819 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 147:
#line 1871 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 148:
#line 1885 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 149:
#line 1900 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL )
                MYSQL_YYABORT;
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    lex->spcont->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 150:
#line 1932 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    if ( i==NULL )
              MYSQL_YYABORT;
            sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 151:
#line 1957 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 152:
#line 1967 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 153:
#line 1989 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 154:
#line 1990 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 155:
#line 1996 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 156:
#line 1998 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 157:
#line 2003 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	    }
	  }
    break;

  case 158:
#line 2026 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 159:
#line 2032 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 160:
#line 2046 "sql_yacc.yy"
    {}
    break;

  case 161:
#line 2047 "sql_yacc.yy"
    {}
    break;

  case 162:
#line 2052 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 163:
#line 2056 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 164:
#line 2065 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 165:
#line 2070 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 166:
#line 2075 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 167:
#line 2083 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 168:
#line 2098 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 169:
#line 2115 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 170:
#line 2116 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 171:
#line 2120 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 172:
#line 2130 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= thd->m_lip;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 173:
#line 2172 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 174:
#line 2177 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 175:
#line 2200 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 176:
#line 2202 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 178:
#line 2205 "sql_yacc.yy"
    {}
    break;

  case 179:
#line 2206 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 180:
#line 2212 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 181:
#line 2218 "sql_yacc.yy"
    {}
    break;

  case 182:
#line 2220 "sql_yacc.yy"
    {}
    break;

  case 183:
#line 2222 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;
              /*
                When jumping to a BEGIN-END block end, the target jump
                points to the block hpop/cpop cleanup instructions,
                so we should exclude the block context here.
                When jumping to something else (i.e., SP_LAB_ITER),
                there are no hpop/cpop at the jump destination,
                so we should include the block context here for cleanup.
              */
              bool exclusive= (lab->type == SP_LAB_BEGIN);

	      n= ctx->diff_handlers(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 184:
#line 2272 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL)
                MYSQL_YYABORT;
              sp->add_instr(i);
	    }
	  }
    break;

  case 185:
#line 2312 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 186:
#line 2329 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 187:
#line 2346 "sql_yacc.yy"
    { }
    break;

  case 188:
#line 2348 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 192:
#line 2374 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 193:
#line 2395 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 194:
#line 2417 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 195:
#line 2422 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 196:
#line 2437 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 197:
#line 2449 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 203:
#line 2469 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 204:
#line 2476 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 205:
#line 2487 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 206:
#line 2495 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 207:
#line 2503 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 212:
#line 2521 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 213:
#line 2526 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 214:
#line 2535 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 215:
#line 2543 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 216:
#line 2548 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 217:
#line 2555 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 218:
#line 2563 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
          }
    break;

  case 220:
#line 2578 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 221:
#line 2596 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

	    if ((yyvsp[0].lex_str).str)
	    {
	      if (my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lab);
	  }
    break;

  case 222:
#line 2613 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 223:
#line 2614 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 224:
#line 2619 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *ctx= lex->spcont;
            sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

            if (lab)
            {
              my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
              MYSQL_YYABORT;
            }

            lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
                                         lex->sphead->instructions());
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 225:
#line 2635 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

            if ((yyvsp[0].lex_str).str)
            {
              if (my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
              {
                my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
                MYSQL_YYABORT;
              }
            }
          }
    break;

  case 226:
#line 2651 "sql_yacc.yy"
    { /* Unlabeled blocks get a secret label. */
            LEX *lex= Lex;
            uint ip= lex->sphead->instructions();
            sp_label_t *lab= lex->spcont->push_label((char *)"", ip);
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 227:
#line 2658 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->spcont->pop_label();
          }
    break;

  case 228:
#line 2666 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 229:
#line 2675 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     (yyvsp[-2].spblock).hndlrs);
              if (hpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(hpop);
            }
	    if ((yyvsp[-2].spblock).curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     (yyvsp[-2].spblock).curs);
              if (cpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(cpop);
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 230:
#line 2704 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
	  }
    break;

  case 231:
#line 2714 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 232:
#line 2719 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 233:
#line 2734 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 234:
#line 2745 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 235:
#line 2750 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            if (i == NULL)
              MYSQL_YYABORT;
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 236:
#line 2768 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 237:
#line 2770 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 238:
#line 2775 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 239:
#line 2777 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 240:
#line 2779 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 241:
#line 2783 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2784 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2786 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[0].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 244:
#line 2792 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[-1].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 245:
#line 2800 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2801 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 247:
#line 2801 "sql_yacc.yy"
    {}
    break;

  case 248:
#line 2805 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2807 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 250:
#line 2807 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2809 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 252:
#line 2809 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2814 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 254:
#line 2830 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 255:
#line 2834 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 256:
#line 2844 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2845 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2848 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2849 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2852 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2853 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2856 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2857 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2860 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 265:
#line 2861 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 266:
#line 2864 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 267:
#line 2865 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 268:
#line 2868 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 269:
#line 2871 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 270:
#line 2872 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 278:
#line 2888 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 279:
#line 2889 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2890 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 281:
#line 2891 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 282:
#line 2892 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 283:
#line 2893 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 284:
#line 2894 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 285:
#line 2895 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 286:
#line 2897 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 287:
#line 2912 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2917 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 289:
#line 2918 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 290:
#line 2919 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 291:
#line 2921 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 292:
#line 2926 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2931 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2936 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 297:
#line 2952 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 298:
#line 2953 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 299:
#line 2954 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 300:
#line 2955 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 301:
#line 2960 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 302:
#line 2977 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 2993 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 304:
#line 3002 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 305:
#line 3003 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 306:
#line 3004 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 307:
#line 3005 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 308:
#line 3006 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 309:
#line 3007 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 310:
#line 3010 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 311:
#line 3011 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3012 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 313:
#line 3015 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 314:
#line 3016 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 315:
#line 3017 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 316:
#line 3020 "sql_yacc.yy"
    {}
    break;

  case 318:
#line 3024 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 319:
#line 3025 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 320:
#line 3026 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 321:
#line 3027 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 327:
#line 3042 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 328:
#line 3049 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 329:
#line 3057 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 3065 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3082 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3086 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 336:
#line 3101 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 337:
#line 3102 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 338:
#line 3106 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 339:
#line 3111 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 340:
#line 3119 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 341:
#line 3132 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 342:
#line 3133 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 343:
#line 3134 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 344:
#line 3135 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 345:
#line 3137 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 346:
#line 3139 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 347:
#line 3141 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 348:
#line 3143 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 349:
#line 3145 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 350:
#line 3147 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 351:
#line 3150 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 352:
#line 3153 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3156 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 354:
#line 3159 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 355:
#line 3161 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 356:
#line 3164 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 357:
#line 3167 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 358:
#line 3168 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 359:
#line 3169 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 360:
#line 3171 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 361:
#line 3183 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 362:
#line 3184 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 363:
#line 3186 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 364:
#line 3189 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 365:
#line 3200 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 366:
#line 3202 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 367:
#line 3204 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 368:
#line 3206 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 369:
#line 3207 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 370:
#line 3208 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 371:
#line 3209 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 372:
#line 3210 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 373:
#line 3212 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 374:
#line 3214 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 375:
#line 3216 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 376:
#line 3217 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 377:
#line 3218 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 378:
#line 3219 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 379:
#line 3220 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 380:
#line 3221 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 381:
#line 3223 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 382:
#line 3231 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 383:
#line 3232 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 384:
#line 3233 "sql_yacc.yy"
    { Lex->length= (char*)"25";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 385:
#line 3236 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 386:
#line 3237 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 387:
#line 3238 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 388:
#line 3239 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 389:
#line 3240 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 390:
#line 3244 "sql_yacc.yy"
    {}
    break;

  case 391:
#line 3248 "sql_yacc.yy"
    {}
    break;

  case 392:
#line 3249 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3253 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3254 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3258 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3259 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3260 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3261 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3262 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3266 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 401:
#line 3267 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 402:
#line 3268 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 403:
#line 3269 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 404:
#line 3270 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 405:
#line 3273 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 406:
#line 3275 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 407:
#line 3276 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 408:
#line 3280 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 409:
#line 3281 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 410:
#line 3282 "sql_yacc.yy"
    {}
    break;

  case 411:
#line 3286 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 412:
#line 3292 "sql_yacc.yy"
    {}
    break;

  case 413:
#line 3293 "sql_yacc.yy"
    {}
    break;

  case 414:
#line 3296 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3297 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3300 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3301 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 418:
#line 3302 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 419:
#line 3305 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 420:
#line 3306 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 421:
#line 3309 "sql_yacc.yy"
    {}
    break;

  case 422:
#line 3310 "sql_yacc.yy"
    {}
    break;

  case 423:
#line 3313 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3314 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3317 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3321 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 428:
#line 3322 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 429:
#line 3323 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 430:
#line 3325 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 431:
#line 3326 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 432:
#line 3328 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 433:
#line 3334 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 434:
#line 3340 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 435:
#line 3346 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3351 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 437:
#line 3353 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 438:
#line 3368 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 439:
#line 3369 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 440:
#line 3373 "sql_yacc.yy"
    {}
    break;

  case 441:
#line 3374 "sql_yacc.yy"
    {}
    break;

  case 442:
#line 3379 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 443:
#line 3386 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 444:
#line 3390 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 445:
#line 3391 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 446:
#line 3394 "sql_yacc.yy"
    { (yyval.charset)= NULL; }
    break;

  case 447:
#line 3395 "sql_yacc.yy"
    { (yyval.charset)= (yyvsp[0].charset); }
    break;

  case 448:
#line 3400 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 449:
#line 3408 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 450:
#line 3412 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 451:
#line 3413 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 452:
#line 3417 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 453:
#line 3426 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 454:
#line 3427 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 455:
#line 3431 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 456:
#line 3432 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 457:
#line 3435 "sql_yacc.yy"
    {}
    break;

  case 458:
#line 3436 "sql_yacc.yy"
    {}
    break;

  case 459:
#line 3439 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 460:
#line 3440 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 461:
#line 3441 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 462:
#line 3443 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 463:
#line 3451 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 464:
#line 3452 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 465:
#line 3455 "sql_yacc.yy"
    { }
    break;

  case 466:
#line 3456 "sql_yacc.yy"
    { Lex->type|= BINCMP_FLAG; }
    break;

  case 467:
#line 3459 "sql_yacc.yy"
    { Lex->charset= NULL; }
    break;

  case 468:
#line 3460 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 469:
#line 3462 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 470:
#line 3470 "sql_yacc.yy"
    { Lex->charset=(yyvsp[0].charset); }
    break;

  case 473:
#line 3479 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->fk_delete_opt= lex->fk_update_opt= lex->fk_match_option= 0;
	  lex->ref_list.empty();
	}
    break;

  case 474:
#line 3485 "sql_yacc.yy"
    {
	  (yyval.table)=(yyvsp[-2].table);
	}
    break;

  case 475:
#line 3490 "sql_yacc.yy"
    {}
    break;

  case 476:
#line 3491 "sql_yacc.yy"
    {}
    break;

  case 477:
#line 3494 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 478:
#line 3495 "sql_yacc.yy"
    { Lex->ref_list.push_back(new key_part_spec((yyvsp[0].lex_str).str)); }
    break;

  case 479:
#line 3499 "sql_yacc.yy"
    {}
    break;

  case 480:
#line 3500 "sql_yacc.yy"
    {}
    break;

  case 481:
#line 3503 "sql_yacc.yy"
    {}
    break;

  case 482:
#line 3504 "sql_yacc.yy"
    {}
    break;

  case 483:
#line 3507 "sql_yacc.yy"
    { Lex->fk_delete_opt= (yyvsp[0].num); }
    break;

  case 484:
#line 3508 "sql_yacc.yy"
    { Lex->fk_update_opt= (yyvsp[0].num); }
    break;

  case 485:
#line 3509 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_FULL; }
    break;

  case 486:
#line 3510 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_PARTIAL; }
    break;

  case 487:
#line 3511 "sql_yacc.yy"
    { Lex->fk_match_option= foreign_key::FK_MATCH_SIMPLE; }
    break;

  case 488:
#line 3514 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_RESTRICT; }
    break;

  case 489:
#line 3515 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_CASCADE; }
    break;

  case 490:
#line 3516 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_SET_NULL; }
    break;

  case 491:
#line 3517 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_NO_ACTION; }
    break;

  case 492:
#line 3518 "sql_yacc.yy"
    { (yyval.num)= (int) foreign_key::FK_OPTION_DEFAULT;  }
    break;

  case 493:
#line 3521 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 494:
#line 3522 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT; }
    break;

  case 495:
#line 3524 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
	    my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 496:
#line 3535 "sql_yacc.yy"
    { (yyval.key_type)= Key::PRIMARY; }
    break;

  case 497:
#line 3536 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 498:
#line 3539 "sql_yacc.yy"
    {}
    break;

  case 499:
#line 3540 "sql_yacc.yy"
    {}
    break;

  case 500:
#line 3543 "sql_yacc.yy"
    {}
    break;

  case 502:
#line 3548 "sql_yacc.yy"
    {}
    break;

  case 503:
#line 3549 "sql_yacc.yy"
    {}
    break;

  case 504:
#line 3550 "sql_yacc.yy"
    {}
    break;

  case 505:
#line 3553 "sql_yacc.yy"
    { (yyval.key_type)= Key::MULTIPLE; }
    break;

  case 506:
#line 3554 "sql_yacc.yy"
    { (yyval.key_type)= Key::UNIQUE; }
    break;

  case 507:
#line 3555 "sql_yacc.yy"
    { (yyval.key_type)= Key::FULLTEXT;}
    break;

  case 508:
#line 3557 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
	    (yyval.key_type)= Key::SPATIAL;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
	    MYSQL_YYABORT;
#endif
	  }
    break;

  case 509:
#line 3569 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_UNDEF; }
    break;

  case 510:
#line 3570 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 511:
#line 3571 "sql_yacc.yy"
    { (yyval.key_alg)= (yyvsp[0].key_alg); }
    break;

  case 512:
#line 3574 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_BTREE; }
    break;

  case 513:
#line 3576 "sql_yacc.yy"
    {
	    (yyval.key_alg)= HA_KEY_ALG_RTREE;
	  }
    break;

  case 514:
#line 3579 "sql_yacc.yy"
    { (yyval.key_alg)= HA_KEY_ALG_HASH; }
    break;

  case 515:
#line 3582 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 516:
#line 3583 "sql_yacc.yy"
    { Lex->col_list.push_back((yyvsp[-1].key_part)); }
    break;

  case 517:
#line 3586 "sql_yacc.yy"
    { (yyval.key_part)=new key_part_spec((yyvsp[0].lex_str).str); }
    break;

  case 518:
#line 3588 "sql_yacc.yy"
    {
          int key_part_len= atoi((yyvsp[-1].lex_str).str);
          if (!key_part_len)
          {
            my_error(ER_KEY_PART_0, MYF(0), (yyvsp[-3].lex_str).str);
          }
          (yyval.key_part)=new key_part_spec((yyvsp[-3].lex_str).str,(uint) key_part_len);
        }
    break;

  case 519:
#line 3598 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 520:
#line 3599 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].lex_str).str; }
    break;

  case 521:
#line 3602 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 522:
#line 3603 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 523:
#line 3606 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 524:
#line 3607 "sql_yacc.yy"
    { Lex->interval_list.push_back((yyvsp[0].string)); }
    break;

  case 525:
#line 3615 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex= thd->lex;
	  lex->sql_command= SQLCOM_ALTER_TABLE;
	  lex->name= 0;
	  lex->duplicates= DUP_ERROR; 
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING))
	    MYSQL_YYABORT;
	  lex->col_list.empty();
          lex->select_lex.init_order();
	  lex->select_lex.db=
            ((TABLE_LIST*) lex->select_lex.table_list.first)->db;
          lex->name=0;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.db_type= DB_TYPE_DEFAULT;
	  lex->create_info.default_table_charset= NULL;
	  lex->create_info.row_type= ROW_TYPE_NOT_USED;
          lex->alter_info.reset();
	}
    break;

  case 526:
#line 3636 "sql_yacc.yy"
    {}
    break;

  case 527:
#line 3638 "sql_yacc.yy"
    {
            Lex->create_info.default_table_charset= NULL;
            Lex->create_info.used_fields= 0;
          }
    break;

  case 528:
#line 3643 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_ALTER_DB;
	    lex->name= (yyvsp[-2].simple_string);
            if (lex->name == NULL && lex->copy_db_to(&lex->name, NULL))
              MYSQL_YYABORT;
	  }
    break;