/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
/* Tokens.  */
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? yytext : ""),
                  lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 416 "sql_yacc.yy"
{
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
}
/* Line 193 of yacc.c.  */
#line 1643 "sql_yacc.cc"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 456 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 216 of yacc.c.  */
#line 1659 "sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   43915

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  672
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2035
/* YYNRULES -- Number of states.  */
#define YYNSTATES  3683

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   568,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   566,
       2,     2,     2,     2,   567,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   119,   121,
     123,   128,   130,   133,   134,   139,   140,   143,   147,   149,
     152,   153,   157,   158,   164,   166,   170,   174,   178,   182,
     186,   190,   194,   198,   202,   206,   210,   214,   216,   220,
     224,   228,   232,   233,   241,   242,   254,   255,   262,   263,
     267,   272,   273,   277,   279,   280,   283,   284,   287,   290,
     293,   296,   299,   303,   307,   309,   311,   313,   316,   320,
     324,   325,   330,   331,   335,   336,   338,   342,   344,   345,
     347,   351,   353,   354,   358,   359,   361,   365,   367,   372,
     373,   375,   377,   379,   380,   384,   387,   391,   392,   396,
     397,   403,   409,   410,   418,   424,   425,   428,   430,   432,
     434,   438,   440,   442,   446,   447,   449,   451,   453,   455,
     458,   460,   462,   466,   467,   470,   471,   474,   475,   479,
     480,   486,   488,   490,   491,   494,   496,   498,   501,   504,
     507,   508,   515,   518,   519,   522,   524,   526,   530,   531,
     532,   533,   541,   542,   545,   548,   550,   552,   553,   554,
     563,   564,   571,   573,   576,   578,   581,   582,   583,   590,
     591,   592,   599,   600,   603,   604,   610,   611,   613,   614,
     620,   621,   624,   625,   631,   636,   637,   638,   647,   648,
     656,   658,   660,   662,   664,   666,   669,   672,   675,   680,
     685,   686,   691,   692,   693,   699,   700,   708,   709,   710,
     717,   718,   720,   721,   723,   725,   728,   730,   732,   733,
     735,   737,   740,   742,   743,   747,   748,   750,   752,   755,
     757,   760,   764,   768,   772,   776,   780,   784,   788,   792,
     796,   800,   804,   808,   812,   816,   820,   824,   828,   834,
     836,   838,   842,   847,   852,   856,   861,   866,   868,   870,
     872,   874,   876,   878,   880,   882,   884,   886,   888,   890,
     892,   894,   897,   899,   901,   903,   905,   907,   911,   913,
     915,   918,   921,   929,   938,   947,   950,   953,   954,   956,
     959,   960,   962,   965,   966,   971,   975,   979,   983,   985,
     988,   990,   992,   996,   999,  1003,  1006,  1009,  1011,  1015,
    1019,  1022,  1026,  1028,  1030,  1033,  1035,  1037,  1040,  1042,
    1044,  1046,  1049,  1053,  1056,  1060,  1063,  1066,  1070,  1074,
    1078,  1079,  1086,  1087,  1094,  1097,  1099,  1101,  1103,  1105,
    1107,  1109,  1111,  1113,  1115,  1117,  1119,  1122,  1125,  1127,
    1130,  1132,  1135,  1139,  1142,  1144,  1146,  1148,  1150,  1152,
    1154,  1156,  1159,  1160,  1162,  1164,  1170,  1171,  1173,  1176,
    1178,  1180,  1182,  1184,  1185,  1187,  1191,  1195,  1199,  1203,
    1204,  1206,  1207,  1209,  1212,  1214,  1216,  1219,  1222,  1227,
    1229,  1233,  1236,  1238,  1241,  1244,  1247,  1250,  1252,  1255,
    1257,  1259,  1261,  1263,  1265,  1266,  1269,  1271,  1273,  1275,
    1277,  1279,  1280,  1283,  1285,  1287,  1288,  1290,  1291,  1294,
    1296,  1299,  1303,  1306,  1307,  1309,  1310,  1312,  1314,  1317,
    1318,  1320,  1321,  1326,  1328,  1333,  1337,  1339,  1340,  1342,
    1345,  1347,  1351,  1355,  1358,  1361,  1364,  1366,  1368,  1371,
    1374,  1377,  1379,  1382,  1385,  1388,  1391,  1393,  1395,  1396,
    1398,  1400,  1402,  1404,  1405,  1407,  1409,  1411,  1412,  1415,
    1418,  1420,  1422,  1424,  1429,  1432,  1434,  1439,  1440,  1442,
    1443,  1446,  1448,  1452,  1453,  1460,  1461,  1467,  1468,  1474,
    1475,  1481,  1482,  1494,  1495,  1497,  1498,  1501,  1504,  1506,
    1510,  1513,  1517,  1520,  1525,  1526,  1533,  1534,  1535,  1544,
    1549,  1554,  1558,  1562,  1565,  1568,  1575,  1581,  1585,  1591,
    1593,  1595,  1597,  1598,  1600,  1601,  1603,  1604,  1606,  1608,
    1609,  1612,  1614,  1615,  1617,  1619,  1621,  1622,  1628,  1632,
    1633,  1639,  1643,  1647,  1648,  1652,  1653,  1656,  1658,  1662,
    1663,  1665,  1667,  1668,  1671,  1673,  1677,  1678,  1685,  1686,
    1693,  1694,  1700,  1701,  1703,  1705,  1706,  1713,  1714,  1716,
    1718,  1721,  1723,  1725,  1727,  1728,  1734,  1735,  1741,  1742,
    1744,  1746,  1749,  1751,  1753,  1755,  1757,  1759,  1762,  1763,
    1769,  1770,  1772,  1774,  1775,  1780,  1785,  1789,  1795,  1797,
    1801,  1805,  1811,  1813,  1817,  1820,  1822,  1824,  1825,  1832,
    1834,  1838,  1842,  1843,  1846,  1847,  1852,  1853,  1856,  1858,
    1861,  1866,  1869,  1873,  1874,  1878,  1879,  1880,  1887,  1890,
    1892,  1894,  1897,  1900,  1909,  1914,  1915,  1917,  1920,  1922,
    1924,  1926,  1928,  1930,  1932,  1934,  1936,  1938,  1940,  1942,
    1943,  1946,  1951,  1955,  1957,  1959,  1964,  1965,  1966,  1968,
    1970,  1971,  1974,  1977,  1979,  1981,  1982,  1985,  1989,  1993,
    1997,  2000,  2004,  2009,  2013,  2018,  2022,  2027,  2029,  2033,
    2038,  2042,  2046,  2053,  2055,  2061,  2068,  2074,  2082,  2089,
    2098,  2104,  2111,  2116,  2121,  2127,  2131,  2136,  2138,  2142,
    2146,  2150,  2154,  2158,  2162,  2167,  2172,  2176,  2180,  2184,
    2188,  2192,  2196,  2198,  2200,  2202,  2204,  2206,  2208,  2210,
    2212,  2214,  2216,  2218,  2220,  2222,  2224,  2226,  2228,  2230,
    2233,  2235,  2239,  2241,  2243,  2245,  2247,  2251,  2254,  2257,
    2260,  2263,  2267,  2271,  2277,  2284,  2289,  2294,  2302,  2307,
    2310,  2317,  2323,  2330,  2337,  2342,  2347,  2351,  2356,  2363,
    2372,  2379,  2388,  2395,  2400,  2407,  2412,  2419,  2424,  2429,
    2434,  2439,  2446,  2455,  2458,  2461,  2466,  2469,  2477,  2485,
    2489,  2494,  2499,  2506,  2513,  2518,  2525,  2532,  2539,  2544,
    2551,  2556,  2563,  2572,  2583,  2596,  2603,  2608,  2615,  2622,
    2624,  2631,  2636,  2645,  2656,  2661,  2663,  2667,  2672,  2679,
    2686,  2695,  2702,  2709,  2714,  2721,  2728,  2737,  2742,  2747,
    2754,  2759,  2762,  2767,  2772,  2777,  2784,  2789,  2794,  2798,
    2807,  2814,  2819,  2826,  2830,  2837,  2846,  2851,  2860,  2867,
    2876,  2883,  2892,  2895,  2900,  2905,  2910,  2917,  2926,  2935,
    2940,  2948,  2956,  2964,  2971,  2978,  2985,  2992,  2999,  3006,
    3007,  3013,  3024,  3028,  3033,  3037,  3040,  3043,  3046,  3051,
    3058,  3063,  3068,  3075,  3082,  3089,  3096,  3101,  3108,  3113,
    3120,  3125,  3130,  3135,  3140,  3147,  3152,  3159,  3164,  3171,
    3176,  3181,  3188,  3193,  3200,  3205,  3212,  3217,  3222,  3229,
    3234,  3241,  3242,  3246,  3250,  3251,  3253,  3254,  3257,  3259,
    3263,  3268,  3273,  3279,  3284,  3289,  3294,  3300,  3305,  3306,
    3307,  3315,  3326,  3331,  3337,  3342,  3348,  3353,  3358,  3363,
    3368,  3373,  3379,  3380,  3389,  3390,  3394,  3398,  3400,  3405,
    3406,  3408,  3409,  3412,  3413,  3415,  3416,  3420,  3423,  3427,
    3430,  3432,  3435,  3437,  3440,  3442,  3444,  3446,  3449,  3450,
    3452,  3453,  3456,  3458,  3462,  3464,  3468,  3469,  3472,  3474,
    3478,  3479,  3481,  3482,  3485,  3490,  3496,  3498,  3500,  3502,
    3504,  3508,  3512,  3516,  3517,  3524,  3525,  3532,  3533,  3542,
    3547,  3548,  3557,  3558,  3569,  3576,  3577,  3586,  3587,  3598,
    3605,  3607,  3610,  3613,  3614,  3619,  3620,  3632,  3636,  3643,
    3644,  3648,  3649,  3650,  3656,  3657,  3659,  3660,  3662,  3663,
    3666,  3667,  3670,  3673,  3676,  3677,  3684,  3685,  3687,  3691,
    3693,  3695,  3697,  3701,  3703,  3705,  3707,  3709,  3711,  3713,
    3715,  3717,  3719,  3721,  3723,  3725,  3727,  3729,  3731,  3733,
    3735,  3737,  3739,  3741,  3743,  3745,  3747,  3749,  3751,  3753,
    3755,  3756,  3758,  3760,  3761,  3764,  3765,  3767,  3768,  3769,
    3773,  3774,  3775,  3779,  3782,  3783,  3784,  3789,  3794,  3797,
    3798,  3801,  3804,  3808,  3812,  3814,  3817,  3818,  3820,  3821,
    3826,  3831,  3834,  3835,  3837,  3839,  3840,  3842,  3843,  3845,
    3848,  3850,  3854,  3858,  3860,  3862,  3864,  3866,  3867,  3870,
    3872,  3874,  3876,  3878,  3880,  3882,  3884,  3886,  3888,  3890,
    3892,  3893,  3894,  3901,  3902,  3904,  3908,  3910,  3913,  3914,
    3917,  3921,  3923,  3926,  3928,  3929,  3933,  3934,  3940,  3943,
    3945,  3946,  3950,  3957,  3958,  3965,  3970,  3977,  3982,  3987,
    3992,  3998,  4003,  4005,  4009,  4011,  4012,  4015,  4016,  4018,
    4019,  4020,  4029,  4030,  4031,  4038,  4039,  4041,  4043,  4045,
    4047,  4049,  4052,  4054,  4056,  4058,  4062,  4067,  4068,  4072,
    4076,  4078,  4081,  4084,  4085,  4089,  4090,  4096,  4100,  4102,
    4106,  4108,  4112,  4114,  4116,  4117,  4119,  4120,  4125,  4126,
    4128,  4132,  4134,  4136,  4138,  4139,  4140,  4147,  4148,  4149,
    4161,  4165,  4167,  4171,  4175,  4177,  4181,  4182,  4184,  4185,
    4190,  4191,  4198,  4199,  4205,  4206,  4213,  4215,  4219,  4223,
    4229,  4230,  4233,  4234,  4237,  4239,  4241,  4243,  4247,  4248,
    4250,  4251,  4255,  4258,  4263,  4268,  4273,  4278,  4279,  4284,
    4291,  4308,  4311,  4314,  4315,  4322,  4328,  4331,  4334,  4337,
    4339,  4345,  4351,  4354,  4357,  4361,  4364,  4367,  4370,  4374,
    4377,  4380,  4383,  4385,  4387,  4391,  4396,  4400,  4404,  4407,
    4410,  4414,  4418,  4422,  4426,  4430,  4434,  4436,  4438,  4440,
    4442,  4443,  4445,  4446,  4449,  4450,  4452,  4454,  4456,  4457,
    4460,  4461,  4464,  4465,  4468,  4471,  4472,  4477,  4478,  4483,
    4485,  4487,  4488,  4490,  4491,  4493,  4495,  4496,  4501,  4505,
    4507,  4508,  4512,  4517,  4520,  4522,  4524,  4526,  4528,  4530,
    4532,  4534,  4536,  4537,  4539,  4540,  4544,  4548,  4550,  4552,
    4554,  4557,  4558,  4562,  4566,  4569,  4572,  4573,  4578,  4579,
    4581,  4583,  4586,  4587,  4592,  4598,  4599,  4600,  4601,  4602,
    4621,  4624,  4625,  4627,  4628,  4630,  4632,  4633,  4635,  4637,
    4638,  4641,  4644,  4646,  4650,  4655,  4659,  4663,  4664,  4667,
    4670,  4672,  4676,  4680,  4681,  4685,  4686,  4690,  4693,  4697,
    4699,  4701,  4704,  4705,  4708,  4710,  4712,  4715,  4718,  4720,
    4722,  4724,  4726,  4728,  4731,  4734,  4736,  4738,  4740,  4742,
    4744,  4746,  4748,  4751,  4754,  4757,  4760,  4763,  4765,  4767,
    4769,  4771,  4773,  4775,  4777,  4781,  4787,  4789,  4791,  4793,
    4795,  4797,  4801,  4806,  4812,  4814,  4820,  4824,  4827,  4829,
    4833,  4836,  4838,  4840,  4842,  4844,  4846,  4848,  4850,  4852,
    4854,  4856,  4858,  4860,  4862,  4864,  4868,  4871,  4873,  4875,
    4877,  4879,  4881,  4883,  4885,  4887,  4889,  4891,  4893,  4895,
    4897,  4899,  4901,  4903,  4905,  4907,  4909,  4911,  4913,  4915,
    4917,  4919,  4921,  4923,  4925,  4927,  4929,  4931,  4933,  4935,
    4937,  4939,  4941,  4943,  4945,  4947,  4949,  4951,  4953,  4955,
    4957,  4959,  4961,  4963,  4965,  4967,  4969,  4971,  4973,  4975,
    4977,  4979,  4981,  4983,  4985,  4987,  4989,  4991,  4993,  4995,
    4997,  4999,  5001,  5003,  5005,  5007,  5009,  5011,  5013,  5015,
    5017,  5019,  5021,  5023,  5025,  5027,  5029,  5031,  5033,  5035,
    5037,  5039,  5041,  5043,  5045,  5047,  5049,  5051,  5053,  5055,
    5057,  5059,  5061,  5063,  5065,  5067,  5069,  5071,  5073,  5075,
    5077,  5079,  5081,  5083,  5085,  5087,  5089,  5091,  5093,  5095,
    5097,  5099,  5101,  5103,  5105,  5107,  5109,  5111,  5113,  5115,
    5117,  5119,  5121,  5123,  5125,  5127,  5129,  5131,  5133,  5135,
    5137,  5139,  5141,  5143,  5145,  5147,  5149,  5151,  5153,  5155,
    5157,  5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,
    5177,  5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,
    5197,  5199,  5201,  5203,  5205,  5207,  5209,  5211,  5213,  5215,
    5217,  5219,  5221,  5223,  5225,  5227,  5229,  5231,  5233,  5235,
    5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,  5253,  5255,
    5257,  5259,  5261,  5263,  5265,  5267,  5269,  5271,  5273,  5275,
    5277,  5279,  5281,  5283,  5285,  5287,  5289,  5291,  5293,  5295,
    5297,  5299,  5301,  5303,  5305,  5307,  5309,  5311,  5313,  5315,
    5317,  5319,  5321,  5323,  5325,  5327,  5329,  5331,  5333,  5335,
    5337,  5339,  5341,  5343,  5345,  5347,  5349,  5351,  5353,  5355,
    5357,  5359,  5361,  5363,  5365,  5367,  5369,  5371,  5372,  5377,
    5378,  5380,  5382,  5386,  5387,  5390,  5392,  5394,  5396,  5398,
    5399,  5401,  5402,  5404,  5406,  5408,  5409,  5412,  5415,  5418,
    5420,  5423,  5428,  5434,  5439,  5446,  5449,  5453,  5457,  5461,
    5467,  5469,  5473,  5477,  5480,  5483,  5486,  5488,  5490,  5495,
    5500,  5502,  5504,  5506,  5508,  5510,  5511,  5516,  5518,  5520,
    5522,  5526,  5530,  5532,  5534,  5537,  5540,  5541,  5545,  5550,
    5554,  5555,  5563,  5565,  5568,  5570,  5572,  5574,  5576,  5578,
    5580,  5581,  5587,  5589,  5591,  5593,  5595,  5597,  5601,  5608,
    5615,  5622,  5630,  5634,  5643,  5652,  5661,  5662,  5664,  5666,
    5669,  5670,  5672,  5674,  5678,  5679,  5683,  5684,  5688,  5689,
    5693,  5694,  5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,
    5714,  5716,  5718,  5720,  5723,  5726,  5728,  5732,  5735,  5738,
    5741,  5744,  5747,  5750,  5753,  5756,  5757,  5759,  5763,  5765,
    5768,  5771,  5774,  5776,  5780,  5784,  5786,  5788,  5792,  5794,
    5798,  5803,  5809,  5811,  5812,  5816,  5820,  5822,  5824,  5825,
    5828,  5831,  5834,  5837,  5838,  5841,  5844,  5846,  5849,  5852,
    5855,  5858,  5861,  5862,  5866,  5867,  5869,  5870,  5874,  5877,
    5878,  5880,  5883,  5884,  5886,  5891,  5896,  5902,  5905,  5909,
    5910,  5912,  5913,  5918,  5919,  5921,  5923,  5924,  5927,  5930,
    5932,  5933,  5935,  5937,  5938,  5944,  5951,  5952,  5953,  5956,
    5959,  5963,  5965,  5967,  5969,  5971,  5973,  5975,  5977,  5979,
    5981,  5983,  5985,  5986,  5990,  5992,  5995,  5997,  6000,  6004,
    6008,  6012,  6013,  6015,  6016,  6020,  6024,  6025,  6034,  6035,
    6039,  6041,  6045,  6046,  6049,  6053,  6059,  6060,  6064,  6069,
    6074,  6075,  6090,  6099,  6107,  6108,  6109,  6110,  6111,  6112,
    6128,  6129,  6130,  6131,  6132,  6145,  6150,  6155,  6159,  6164,
    6168,  6171,  6173,  6177,  6183,  6185,  6187,  6188,  6190,  6192,
    6193,  6196,  6197,  6198,  6202,  6203
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     571,     0,    -1,     3,    -1,    -1,   574,   572,   566,   573,
      -1,   574,     3,    -1,    -1,     3,    -1,   575,    -1,  1179,
      -1,   772,    -1,   813,    -1,   803,    -1,   604,    -1,   587,
      -1,   815,    -1,   805,    -1,  1185,    -1,   592,    -1,   576,
      -1,  1023,    -1,  1050,    -1,   979,    -1,   981,    -1,   580,
      -1,  1056,    -1,  1154,    -1,  1145,    -1,   585,    -1,   987,
      -1,  1070,    -1,  1074,    -1,  1137,    -1,   820,    -1,   828,
      -1,   832,    -1,   578,    -1,  1066,    -1,  1188,    -1,   823,
      -1,   808,    -1,   990,    -1,  1062,    -1,   801,    -1,  1152,
      -1,  1186,    -1,  1187,    -1,   840,    -1,  1120,    -1,  1036,
      -1,   790,    -1,   793,    -1,  1034,    -1,  1143,    -1,  1015,
      -1,  1073,    -1,  1234,    -1,   577,   362,  1114,    -1,   103,
      -1,   126,    -1,   362,  1114,   171,   579,    -1,  1111,    -1,
     567,  1116,    -1,    -1,   148,  1114,   581,   582,    -1,    -1,
     517,   583,    -1,   583,   562,   584,    -1,   584,    -1,   567,
    1116,    -1,    -1,   198,   586,  1116,    -1,    -1,    52,   281,
     485,   588,   589,    -1,   590,    -1,   589,   562,   590,    -1,
     268,   142,  1111,    -1,   282,   142,  1111,    -1,   271,   142,
    1111,    -1,   272,   142,   964,    -1,   267,   142,   964,    -1,
     280,   142,   964,    -1,   276,   142,  1111,    -1,   275,   142,
    1111,    -1,   277,   142,  1111,    -1,   278,   142,  1111,    -1,
     279,   142,  1111,    -1,   591,    -1,   269,   142,  1111,    -1,
     270,   142,   965,    -1,   386,   142,  1111,    -1,   387,   142,
     964,    -1,    -1,    84,   689,   472,   692,  1108,   593,   676,
      -1,    -1,    84,   764,   213,  1114,   765,   337,  1108,   594,
     560,   767,   561,    -1,    -1,    84,    91,   692,  1114,   595,
     686,    -1,    -1,    84,   596,  1201,    -1,    84,   514,   597,
    1170,    -1,    -1,  1114,   568,  1114,    -1,  1114,    -1,    -1,
     599,   601,    -1,    -1,   600,   602,    -1,    67,  1111,    -1,
     235,   450,    -1,   328,   450,    -1,    79,   450,    -1,   379,
     450,    93,    -1,   304,   450,    93,    -1,   603,    -1,   601,
      -1,   118,    -1,   867,   118,    -1,   450,   419,   109,    -1,
     450,   419,   224,    -1,    -1,    47,   598,   605,   606,    -1,
      -1,   560,   607,   561,    -1,    -1,   608,    -1,   608,   562,
     861,    -1,   861,    -1,    -1,   610,    -1,   610,   562,   612,
      -1,   612,    -1,    -1,  1114,   611,   715,    -1,    -1,   614,
      -1,   614,   562,   615,    -1,   615,    -1,   616,   611,  1114,
     715,    -1,    -1,   225,    -1,   350,    -1,   217,    -1,    -1,
     617,   633,   566,    -1,   633,   566,    -1,   618,   633,   566,
      -1,    -1,   619,   620,   566,    -1,    -1,   106,   631,   621,
     715,   632,    -1,   106,  1114,    75,   168,   628,    -1,    -1,
     106,   625,   195,   168,   622,   626,   633,    -1,   106,  1114,
      89,   168,   623,    -1,    -1,   624,   575,    -1,   150,    -1,
      80,    -1,   627,    -1,   626,   562,   627,    -1,   630,    -1,
     964,    -1,   442,   629,  1112,    -1,    -1,   523,    -1,   628,
      -1,  1114,    -1,   443,    -1,   867,   169,    -1,   441,    -1,
    1114,    -1,   631,   562,  1114,    -1,    -1,   108,   861,    -1,
      -1,   634,   575,    -1,    -1,   404,   635,   861,    -1,    -1,
     209,   636,   641,   138,   209,    -1,   646,    -1,   661,    -1,
      -1,   637,   670,    -1,   664,    -1,   666,    -1,   242,  1115,
      -1,   229,  1115,    -1,   340,  1114,    -1,    -1,   157,   639,
    1114,   222,   638,   640,    -1,    60,  1114,    -1,    -1,   323,
     171,    -1,   171,    -1,  1114,    -1,   640,   562,  1114,    -1,
      -1,    -1,    -1,   642,   861,   547,   643,   618,   644,   645,
      -1,    -1,   132,   641,    -1,   546,   618,    -1,   647,    -1,
     650,    -1,    -1,    -1,   548,   648,   861,   649,   652,   660,
     138,   548,    -1,    -1,   548,   651,   653,   660,   138,   548,
      -1,   654,    -1,   652,   654,    -1,   657,    -1,   653,   657,
      -1,    -1,    -1,   532,   655,   861,   656,   547,   618,    -1,
      -1,    -1,   532,   658,   861,   659,   547,   618,    -1,    -1,
     546,   618,    -1,    -1,  1115,   569,   662,   670,   663,    -1,
      -1,  1115,    -1,    -1,  1115,   569,   665,   668,   663,    -1,
      -1,   667,   668,    -1,    -1,    28,   669,   619,   617,   138,
      -1,   263,   618,   138,   263,    -1,    -1,    -1,   534,   671,
     861,   125,   672,   618,   138,   534,    -1,    -1,   394,   618,
     510,   673,   861,   138,   394,    -1,    27,    -1,     8,    -1,
     219,    -1,   511,    -1,   112,    -1,   560,   677,    -1,   693,
     679,    -1,   246,  1108,    -1,   560,   246,  1108,   561,    -1,
     705,   561,   693,   679,    -1,    -1,   682,   561,   678,  1192,
      -1,    -1,    -1,  1083,   685,   682,   680,  1189,    -1,    -1,
    1083,   685,   560,   682,   561,   681,  1192,    -1,    -1,    -1,
     420,   683,   850,   854,   684,   703,    -1,    -1,    18,    -1,
      -1,   687,    -1,   688,    -1,   687,   688,    -1,   698,    -1,
     697,    -1,    -1,   690,    -1,   691,    -1,   691,   690,    -1,
     473,    -1,    -1,   209,   867,   149,    -1,    -1,   695,    -1,
     696,    -1,   696,   694,    -1,   696,    -1,   696,   695,    -1,
     696,   562,   695,    -1,   140,  1007,   699,    -1,   494,  1007,
     699,    -1,   286,  1007,   965,    -1,   300,  1007,   965,    -1,
      24,  1007,   964,    -1,   353,  1007,  1111,    -1,    67,  1007,
    1111,    -1,    23,  1007,   965,    -1,   351,  1007,   964,    -1,
     351,  1007,   108,    -1,    56,  1007,   964,    -1,   111,  1007,
     964,    -1,   413,  1007,   700,    -1,   377,  1007,   701,    -1,
     374,  1007,   964,    -1,   375,  1007,   964,    -1,   503,  1007,
     560,  1061,   561,    -1,   697,    -1,   698,    -1,   220,  1007,
     702,    -1,    93,   119,  1007,  1111,    -1,   213,   119,  1007,
    1111,    -1,    76,  1007,  1111,    -1,   746,   737,  1007,   739,
      -1,   746,    63,  1007,   745,    -1,  1116,    -1,   108,    -1,
     161,    -1,   130,    -1,    71,    -1,   383,    -1,    70,    -1,
     376,    -1,   373,    -1,   964,    -1,   328,    -1,   160,    -1,
     237,    -1,   959,    -1,   849,   853,    -1,   461,    -1,   381,
      -1,   105,    -1,   223,    -1,   706,    -1,   705,   562,   706,
      -1,   707,    -1,   708,    -1,   713,   709,    -1,   713,   751,
      -1,   759,   769,   765,   560,   767,   561,   765,    -1,   711,
     760,   769,   765,   560,   767,   561,   765,    -1,   711,   166,
     232,   769,   560,   767,   561,   751,    -1,   712,   709,    -1,
     711,   710,    -1,    -1,   710,    -1,    57,   861,    -1,    -1,
     712,    -1,    78,   769,    -1,    -1,  1107,   714,   715,   733,
      -1,   723,   730,   727,    -1,   724,   732,   727,    -1,   163,
     725,   727,    -1,    37,    -1,    37,   731,    -1,    41,    -1,
      40,    -1,   719,   731,   747,    -1,   719,   747,    -1,   720,
     731,   748,    -1,   720,   748,    -1,    32,   731,    -1,    32,
      -1,   721,   731,   747,    -1,   722,   731,   748,    -1,   524,
     731,    -1,   543,   730,   727,    -1,    97,    -1,   481,    -1,
     478,   730,    -1,    94,    -1,   482,    -1,    39,   730,    -1,
     718,    -1,   290,    -1,   259,    -1,   262,   524,    -1,   262,
     721,   747,    -1,   484,   747,    -1,   477,   730,   747,    -1,
     292,   747,    -1,   260,   747,    -1,   105,   725,   727,    -1,
     332,   725,   727,    -1,   161,   725,   727,    -1,    -1,   141,
     716,   560,   771,   561,   747,    -1,    -1,   426,   717,   560,
     771,   561,   747,    -1,   262,   747,    -1,   424,    -1,   183,
      -1,   182,    -1,   357,    -1,   311,    -1,   250,    -1,   310,
      -1,   359,    -1,   312,    -1,    55,    -1,   319,    -1,   316,
      55,    -1,   719,   528,    -1,   525,    -1,   316,   525,    -1,
     333,    -1,   319,   525,    -1,   316,    55,   528,    -1,   319,
     528,    -1,   223,    -1,   483,    -1,   436,    -1,   291,    -1,
      31,    -1,   381,    -1,   124,    -1,   124,   361,    -1,    -1,
     731,    -1,   726,    -1,   560,   331,   562,   331,   561,    -1,
      -1,   728,    -1,   728,   729,    -1,   729,    -1,   433,    -1,
     509,    -1,   544,    -1,    -1,   731,    -1,   560,   261,   561,
      -1,   560,   497,   561,    -1,   560,   104,   561,    -1,   560,
     331,   561,    -1,    -1,   726,    -1,    -1,   734,    -1,   734,
     735,    -1,   735,    -1,   330,    -1,   867,   330,    -1,   108,
     736,    -1,   337,   511,   327,   860,    -1,    23,    -1,   424,
     108,   523,    -1,   750,   232,    -1,   504,    -1,   504,   232,
      -1,    67,  1111,    -1,    63,   743,    -1,   327,   860,    -1,
    1098,    -1,    55,   426,    -1,    54,    -1,  1116,    -1,    32,
      -1,   738,    -1,   108,    -1,    -1,   737,   739,    -1,  1116,
      -1,    32,    -1,   741,    -1,   108,    -1,  1116,    -1,    -1,
      63,   745,    -1,   743,    -1,   108,    -1,    -1,   108,    -1,
      -1,    20,   748,    -1,    45,    -1,   502,   748,    -1,   737,
     738,   748,    -1,    32,   749,    -1,    -1,    32,    -1,    -1,
      20,    -1,   502,    -1,   737,   738,    -1,    -1,   364,    -1,
      -1,   384,  1108,   752,   753,    -1,   755,    -1,   560,   754,
     561,   755,    -1,   754,   562,  1114,    -1,  1114,    -1,    -1,
     756,    -1,   756,   757,    -1,   757,    -1,   337,   112,   758,
      -1,   337,   511,   758,    -1,   283,   173,    -1,   283,   352,
      -1,   283,   434,    -1,   401,    -1,    48,    -1,   426,   330,
      -1,   328,     5,    -1,   426,   108,    -1,   761,    -1,   174,
     762,    -1,   439,   762,    -1,   364,   232,    -1,   504,   762,
      -1,   232,    -1,   213,    -1,    -1,   761,    -1,   231,    -1,
     213,    -1,   212,    -1,    -1,   504,    -1,   174,    -1,   439,
      -1,    -1,   517,   766,    -1,   494,   766,    -1,    43,    -1,
     415,    -1,   196,    -1,   767,   562,   768,   957,    -1,   768,
     957,    -1,  1114,    -1,  1114,   560,   331,   561,    -1,    -1,
    1107,    -1,    -1,   568,  1114,    -1,  1096,    -1,   771,   562,
    1096,    -1,    -1,    13,   786,   472,  1108,   773,   779,    -1,
      -1,    13,    91,   778,   774,   687,    -1,    -1,    13,   366,
     598,   775,   599,    -1,    -1,    13,   175,   598,   776,   599,
      -1,    -1,    13,  1210,  1204,  1211,   529,  1108,   777,  1214,
      18,  1216,  1219,    -1,    -1,  1114,    -1,    -1,   121,   471,
      -1,   211,   471,    -1,   781,    -1,   779,   562,   781,    -1,
       6,   785,    -1,   780,   707,   788,    -1,     6,   708,    -1,
     780,   560,   705,   561,    -1,    -1,    52,   785,  1107,   782,
     713,   788,    -1,    -1,    -1,   305,   785,  1107,   783,   715,
     733,   784,   788,    -1,   126,   785,  1107,   787,    -1,   126,
     166,   232,   769,    -1,   126,   364,   232,    -1,   126,   761,
    1107,    -1,   120,   231,    -1,   134,   231,    -1,    13,   785,
    1107,   426,   108,  1098,    -1,    13,   785,  1107,   126,   108,
      -1,   391,   789,  1108,    -1,    81,   485,   737,   739,   744,
      -1,   694,    -1,   165,    -1,   950,    -1,    -1,    66,    -1,
      -1,   210,    -1,    -1,   401,    -1,    48,    -1,    -1,     8,
    1114,    -1,   160,    -1,    -1,   485,    -1,   142,    -1,    18,
      -1,    -1,   454,   435,   795,   791,   799,    -1,   458,   435,
     795,    -1,    -1,   435,   454,   795,   792,   799,    -1,   435,
     458,   795,    -1,   454,   487,   794,    -1,    -1,   535,    77,
     437,    -1,    -1,   796,   797,    -1,   798,    -1,   797,   562,
     798,    -1,    -1,   451,    -1,   388,    -1,    -1,   510,   800,
      -1,   591,    -1,   800,   562,   591,    -1,    -1,   400,  1139,
     802,   983,   171,  1111,    -1,    -1,    26,  1139,   804,   983,
     485,  1111,    -1,    -1,    56,  1139,   806,   983,   807,    -1,
      -1,   372,    -1,   153,    -1,    -1,   392,   822,  1139,   809,
     983,   810,    -1,    -1,   811,    -1,   812,    -1,   812,   811,
      -1,   372,    -1,   153,    -1,   515,    -1,    -1,    14,   822,
    1139,   814,   983,    -1,    -1,    57,  1139,   816,   983,   817,
      -1,    -1,   818,    -1,   819,    -1,   819,   818,    -1,   372,
      -1,   156,    -1,   293,    -1,   153,    -1,    53,    -1,   168,
     512,    -1,    -1,   341,   822,  1139,   821,   983,    -1,    -1,
     329,    -1,   252,    -1,    -1,   391,  1139,   824,   826,    -1,
     391,   514,   597,   825,    -1,  1117,   485,  1117,    -1,   825,
     562,  1117,   485,  1117,    -1,   827,    -1,   826,   562,   827,
      -1,  1108,   485,  1108,    -1,    46,   213,   829,   225,   831,
      -1,   830,    -1,   829,   562,   830,    -1,  1108,   836,    -1,
    1114,    -1,   108,    -1,    -1,   251,   213,   222,    46,   833,
     834,    -1,   835,    -1,   834,   562,   835,    -1,  1108,   836,
     839,    -1,    -1,   837,   838,    -1,    -1,   762,   560,   933,
     561,    -1,    -1,   210,   241,    -1,   841,    -1,   420,   843,
      -1,   560,   842,   561,  1192,    -1,   420,   845,    -1,   560,
     842,   561,    -1,    -1,   845,   844,  1189,    -1,    -1,    -1,
     846,   850,   854,   847,   848,   853,    -1,   953,   959,    -1,
     975,    -1,   849,    -1,   975,   849,    -1,   849,   975,    -1,
     171,   906,   942,   947,   944,   953,   959,   966,    -1,   171,
     127,   942,   959,    -1,    -1,   851,    -1,   851,   852,    -1,
     852,    -1,   460,    -1,   200,    -1,   122,    -1,   449,    -1,
     444,    -1,   445,    -1,   447,    -1,   448,    -1,   446,    -1,
      12,    -1,    -1,   168,   511,    -1,   256,   225,   428,   303,
      -1,   854,   562,   855,    -1,   855,    -1,   554,    -1,   856,
     858,   857,   859,    -1,    -1,    -1,  1102,    -1,   861,    -1,
      -1,    18,  1114,    -1,    18,  1111,    -1,  1114,    -1,  1111,
      -1,    -1,   560,   561,    -1,   861,   865,   861,    -1,   861,
     540,   861,    -1,   861,   866,   861,    -1,   326,   861,    -1,
     862,   226,   491,    -1,   862,   226,   867,   491,    -1,   862,
     226,   155,    -1,   862,   226,   867,   155,    -1,   862,   226,
     507,    -1,   862,   226,   867,   507,    -1,   862,    -1,   862,
     226,   330,    -1,   862,   226,   867,   330,    -1,   862,   143,
     863,    -1,   862,   869,   863,    -1,   862,   869,   870,   560,
    1198,   561,    -1,   863,    -1,   864,   225,   560,  1198,   561,
      -1,   864,   867,   225,   560,  1198,   561,    -1,   864,   225,
     560,   861,   561,    -1,   864,   225,   560,   861,   562,   895,
     561,    -1,   864,   867,   225,   560,   861,   561,    -1,   864,
     867,   225,   560,   861,   562,   895,   561,    -1,   864,   549,
     864,    16,   863,    -1,   864,   867,   549,   864,    16,   863,
      -1,   864,   438,   246,   864,    -1,   864,   246,   872,   946,
      -1,   864,   867,   246,   872,   946,    -1,   864,   385,   864,
      -1,   864,   867,   385,   864,    -1,   864,    -1,   864,   550,
     864,    -1,   864,   551,   864,    -1,   864,   429,   864,    -1,
     864,   430,   864,    -1,   864,   553,   864,    -1,   864,   552,
     864,    -1,   864,   553,   871,   935,    -1,   864,   552,   871,
     935,    -1,   864,   554,   864,    -1,   864,   555,   864,    -1,
     864,   556,   864,    -1,   864,   123,   864,    -1,   864,   306,
     864,    -1,   864,   557,   864,    -1,   872,    -1,   347,    -1,
     344,    -1,    16,    -1,    15,    -1,   326,    -1,   325,    -1,
     563,    -1,   325,    -1,   142,    -1,   180,    -1,   194,    -1,
     238,    -1,   265,    -1,   321,    -1,    12,    -1,    17,    -1,
     221,   861,    -1,  1104,    -1,   872,    63,  1116,    -1,  1099,
      -1,  1097,    -1,   885,    -1,   881,    -1,   872,   346,   872,
      -1,   553,   872,    -1,   552,   872,    -1,   558,   872,    -1,
     868,   872,    -1,   560,  1198,   561,    -1,   560,   861,   561,
      -1,   560,   861,   562,   895,   561,    -1,   414,   560,   861,
     562,   895,   561,    -1,   149,   560,  1198,   561,    -1,   564,
    1114,   861,   565,    -1,   283,   898,     9,   560,   864,   875,
     561,    -1,    20,   560,   861,   561,    -1,    32,   872,    -1,
      50,   560,   861,    18,   893,   561,    -1,   548,   902,   904,
     903,   138,    -1,    81,   560,   861,   562,   893,   561,    -1,
      81,   560,   861,   517,   738,   561,    -1,   108,   560,  1104,
     561,    -1,   522,   560,  1105,   561,    -1,   176,   560,   561,
      -1,   177,   560,   861,   561,    -1,   178,   560,   861,   562,
     861,   561,    -1,   179,   560,   861,   562,   861,   562,   861,
     561,    -1,     7,   560,   861,   562,   861,   561,    -1,     7,
     560,   861,   562,   221,   861,   935,   561,    -1,   394,   560,
     861,   562,   861,   561,    -1,    22,   560,   861,   561,    -1,
      22,   560,   861,   562,   861,   561,    -1,    55,   560,   895,
     561,    -1,    55,   560,   895,   517,   738,   561,    -1,    54,
     560,   861,   561,    -1,    61,   560,   895,   561,    -1,    64,
     560,   861,   561,    -1,    72,   560,   895,   561,    -1,    73,
     560,   861,   562,   895,   561,    -1,    82,   560,   861,   562,
     861,   562,   861,   561,    -1,    87,   860,    -1,    90,   860,
      -1,    90,   560,   861,   561,    -1,    88,   860,    -1,    95,
     560,   861,   562,   871,   935,   561,    -1,    96,   560,   861,
     562,   871,   935,   561,    -1,    91,   560,   561,    -1,    97,
     560,   861,   561,    -1,   102,   560,   861,   561,    -1,   133,
     560,   861,   562,   895,   561,    -1,   266,   560,   861,   562,
     895,   561,    -1,   137,   560,   861,   561,    -1,   137,   560,
     861,   562,   861,   561,    -1,   107,   560,   861,   562,  1112,
     561,    -1,   136,   560,   861,   562,  1112,   561,    -1,   115,
     560,   861,   561,    -1,   115,   560,   861,   562,   861,   561,
      -1,   116,   560,   861,   561,    -1,   116,   560,   861,   562,
     861,   561,    -1,   152,   560,   861,   562,   861,   562,   861,
     561,    -1,   152,   560,   861,   562,   861,   562,   861,   562,
     861,   561,    -1,   152,   560,   861,   562,   861,   562,   861,
     562,   861,   562,   861,   561,    -1,   167,   560,   861,   562,
     331,   561,    -1,   172,   560,   861,   561,    -1,   172,   560,
     861,   562,   861,   561,    -1,   158,   560,   861,   562,   895,
     561,    -1,   874,    -1,   186,   560,   938,   562,   861,   561,
      -1,   205,   560,   861,   561,    -1,   209,   560,   861,   562,
     861,   562,   861,   561,    -1,   219,   560,   861,   562,   861,
     562,   861,   562,   861,   561,    -1,   871,   935,   553,   861,
      -1,   871,    -1,   236,   560,   561,    -1,   236,   560,   861,
     561,    -1,   243,   560,   861,   562,   861,   561,    -1,   253,
     560,   861,   562,   861,   561,    -1,   253,   560,   861,   562,
     861,   562,   861,   561,    -1,   190,   560,   861,   562,   895,
     561,    -1,   240,   560,   861,   562,   895,   561,    -1,   258,
     560,   861,   561,    -1,   258,   560,   861,   562,   861,   561,
      -1,   273,   560,   861,   562,   861,   561,    -1,   273,   560,
     861,   562,   861,   562,   861,   561,    -1,   295,   560,   861,
     561,    -1,   299,   560,   861,   561,    -1,   306,   560,   861,
     562,   861,   561,    -1,   307,   560,   861,   561,    -1,   327,
     860,    -1,   327,   560,   861,   561,    -1,   353,   560,   861,
     561,    -1,   336,   560,   861,   561,    -1,   360,   560,   864,
     225,   861,   561,    -1,   370,   560,   861,   561,    -1,   378,
     560,   861,   561,    -1,   378,   560,   561,    -1,   395,   560,
     861,   562,   861,   562,   861,   561,    -1,   406,   560,   861,
     562,   861,   561,    -1,   409,   560,   861,   561,    -1,   409,
     560,   861,   562,   861,   561,    -1,   412,   560,   561,    -1,
     462,   560,   861,   562,   861,   561,    -1,   462,   560,   861,
     562,   221,   861,   935,   561,    -1,   418,   560,   861,   561,
      -1,   464,   560,   861,   562,   861,   562,   861,   561,    -1,
     464,   560,   861,   562,   861,   561,    -1,   464,   560,   861,
     171,   861,   168,   861,   561,    -1,   464,   560,   861,   171,
     861,   561,    -1,   465,   560,   861,   562,   861,   562,   861,
     561,    -1,   469,   860,    -1,   469,   560,   861,   561,    -1,
     481,   560,   861,   561,    -1,   478,   560,   861,   561,    -1,
     478,   560,   861,   562,   861,   561,    -1,   479,   560,   936,
     562,   861,   562,   861,   561,    -1,   480,   560,   936,   562,
     861,   562,   861,   561,    -1,   490,   560,   861,   561,    -1,
     490,   560,   239,   861,   171,   861,   561,    -1,   490,   560,
     486,   861,   171,   861,   561,    -1,   490,   560,    42,   861,
     171,   861,   561,    -1,   490,   560,   239,   171,   861,   561,
      -1,   490,   560,   486,   171,   861,   561,    -1,   490,   560,
      42,   171,   861,   561,    -1,   490,   560,   861,   171,   861,
     561,    -1,   492,   560,   861,   562,   861,   561,    -1,  1114,
     568,  1114,   560,   894,   561,    -1,    -1,  1110,   560,   873,
     876,   561,    -1,   505,   560,  1095,   562,   331,   562,   331,
     562,   895,   561,    -1,   506,   560,   561,    -1,   506,   560,
     861,   561,    -1,   514,   560,   561,    -1,   518,   860,    -1,
     520,   860,    -1,   519,   860,    -1,   531,   560,   861,   561,
      -1,   531,   560,   861,   562,   861,   561,    -1,   543,   560,
     861,   561,    -1,   541,   560,   861,   561,    -1,   541,   560,
     861,   562,   861,   561,    -1,    29,   560,   964,   562,   861,
     561,    -1,   154,   560,   935,   171,   861,   561,    -1,    79,
     560,   861,   562,   861,   561,    -1,   184,   560,   861,   561,
      -1,   184,   560,   861,   562,   861,   561,    -1,   185,   560,
     861,   561,    -1,   185,   560,   861,   562,   861,   561,    -1,
     182,   560,   895,   561,    -1,   250,   560,   895,   561,    -1,
     310,   560,   895,   561,    -1,   302,   560,   861,   561,    -1,
     302,   560,   861,   562,   861,   561,    -1,   308,   560,   861,
     561,    -1,   308,   560,   861,   562,   861,   561,    -1,   309,
     560,   861,   561,    -1,   309,   560,   861,   562,   861,   561,
      -1,   311,   560,   895,   561,    -1,   312,   560,   895,   561,
      -1,   357,   560,   861,   562,   861,   561,    -1,   356,   560,
     861,   561,    -1,   356,   560,   861,   562,   861,   561,    -1,
     358,   560,   861,   561,    -1,   358,   560,   861,   562,   861,
     561,    -1,   359,   560,   895,   561,    -1,   181,   560,   861,
     561,    -1,   181,   560,   861,   562,   861,   561,    -1,   248,
     560,   861,   561,    -1,   248,   560,   861,   562,   861,   561,
      -1,    -1,   535,   371,   151,    -1,   225,    40,   303,    -1,
      -1,   877,    -1,    -1,   878,   879,    -1,   880,    -1,   879,
     562,   880,    -1,   856,   861,   857,   859,    -1,    25,   560,
     891,   561,    -1,    25,   560,   122,   891,   561,    -1,    35,
     560,   891,   561,    -1,    36,   560,   891,   561,    -1,    38,
     560,   891,   561,    -1,    83,   560,   941,   554,   561,    -1,
      83,   560,   891,   561,    -1,    -1,    -1,    83,   560,   122,
     882,   895,   883,   561,    -1,   193,   560,  1095,   562,   331,
     562,   331,   562,   891,   561,    -1,   301,   560,   891,   561,
      -1,   301,   560,   122,   891,   561,    -1,   287,   560,   891,
     561,    -1,   287,   560,   122,   891,   561,    -1,   456,   560,
     891,   561,    -1,   527,   560,   891,   561,    -1,   457,   560,
     891,   561,    -1,   521,   560,   891,   561,    -1,   466,   560,
     891,   561,    -1,   466,   560,   122,   891,   561,    -1,    -1,
     192,   560,   888,   884,   895,   890,   889,   561,    -1,    -1,
     567,   886,   887,    -1,  1116,   427,   861,    -1,  1116,    -1,
     567,  1129,  1116,   770,    -1,    -1,   122,    -1,    -1,   422,
    1096,    -1,    -1,   954,    -1,    -1,   941,   892,   861,    -1,
      32,   730,    -1,    55,   730,   747,    -1,   319,   730,    -1,
     433,    -1,   433,   223,    -1,   509,    -1,   509,   223,    -1,
      97,    -1,   481,    -1,    94,    -1,   105,   725,    -1,    -1,
     895,    -1,    -1,   896,   897,    -1,   861,    -1,   897,   562,
     861,    -1,   899,    -1,   560,   899,   561,    -1,    -1,   900,
     901,    -1,  1104,    -1,   901,   562,  1104,    -1,    -1,   861,
      -1,    -1,   546,   861,    -1,   532,   861,   547,   861,    -1,
     904,   532,   861,   547,   861,    -1,   917,    -1,   908,    -1,
     907,    -1,   905,    -1,   907,   562,   905,    -1,   905,   916,
     905,    -1,   905,   460,   917,    -1,    -1,   905,   916,   905,
     337,   909,   861,    -1,    -1,   905,   460,   917,   337,   910,
     861,    -1,    -1,   905,   916,   905,   517,   911,   560,   934,
     561,    -1,   905,   317,   230,   917,    -1,    -1,   905,   243,
     927,   230,   905,   337,   912,   861,    -1,    -1,   905,   243,
     927,   230,   917,   913,   517,   560,   934,   561,    -1,   905,
     317,   243,   927,   230,   917,    -1,    -1,   905,   406,   927,
     230,   905,   337,   914,   861,    -1,    -1,   905,   406,   927,
     230,   917,   915,   517,   560,   934,   561,    -1,   905,   317,
     406,   927,   230,   917,    -1,   230,    -1,   215,   230,    -1,
      85,   230,    -1,    -1,   918,  1108,   940,   929,    -1,    -1,
     564,  1114,   905,   243,   348,   230,   905,   337,   919,   861,
     565,    -1,   926,   925,   922,    -1,   560,   925,   920,  1192,
     561,   940,    -1,    -1,   925,   921,   907,    -1,    -1,    -1,
     923,   850,   854,   924,   703,    -1,    -1,   420,    -1,    -1,
     348,    -1,    -1,   168,   230,    -1,    -1,   516,   930,    -1,
     165,   930,    -1,   210,   930,    -1,    -1,   761,   928,   931,
     560,   932,   561,    -1,    -1,   933,    -1,   933,   562,  1114,
      -1,  1114,    -1,   364,    -1,  1114,    -1,   934,   562,  1114,
      -1,   937,    -1,    98,    -1,    99,    -1,   100,    -1,   101,
      -1,   202,    -1,   203,    -1,   204,    -1,   297,    -1,   298,
      -1,   417,    -1,   542,    -1,   937,    -1,   170,    -1,   102,
      -1,   531,    -1,   205,    -1,   299,    -1,   307,    -1,   370,
      -1,   418,    -1,   295,    -1,   543,    -1,    97,    -1,   481,
      -1,    94,    -1,   478,    -1,    -1,    18,    -1,   142,    -1,
      -1,   939,  1114,    -1,    -1,    12,    -1,    -1,    -1,   533,
     943,   861,    -1,    -1,    -1,   197,   945,   861,    -1,   146,
     872,    -1,    -1,    -1,   191,    44,   948,   949,    -1,   948,
     562,  1103,   957,    -1,  1103,   957,    -1,    -1,   535,    86,
      -1,   535,   408,    -1,   345,    44,   951,    -1,   951,   562,
     952,    -1,   952,    -1,  1105,   957,    -1,    -1,   954,    -1,
      -1,   345,    44,   955,   956,    -1,   956,   562,  1103,   957,
      -1,  1103,   957,    -1,    -1,    19,    -1,   113,    -1,    -1,
     960,    -1,    -1,   960,    -1,   247,   961,    -1,   962,    -1,
     962,   562,   962,    -1,   962,   334,   962,    -1,  1097,    -1,
     497,    -1,   261,    -1,   331,    -1,    -1,   247,   962,    -1,
     331,    -1,   199,    -1,   261,    -1,   497,    -1,   104,    -1,
     162,    -1,   331,    -1,   497,    -1,   261,    -1,   104,    -1,
     162,    -1,    -1,    -1,   366,  1114,   967,   560,   968,   561,
      -1,    -1,   969,    -1,   969,   562,   970,    -1,   970,    -1,
     856,   861,    -1,    -1,   972,   973,    -1,   973,   562,   974,
      -1,   974,    -1,   567,  1116,    -1,  1116,    -1,    -1,   222,
     976,   977,    -1,    -1,   349,  1113,   978,  1084,  1087,    -1,
     128,  1113,    -1,   971,    -1,    -1,   125,   980,   895,    -1,
     126,   986,  1139,   985,   983,   787,    -1,    -1,   126,   213,
    1114,   337,  1108,   982,    -1,   126,    91,   985,  1114,    -1,
     126,   175,   985,  1114,   568,  1114,    -1,   126,   175,   985,
    1114,    -1,   126,   366,   985,   598,    -1,   126,   514,   597,
    1169,    -1,   126,   529,   985,   983,   787,    -1,   126,   488,
     985,   598,    -1,   984,    -1,   983,   562,   984,    -1,  1108,
      -1,    -1,   209,   149,    -1,    -1,   473,    -1,    -1,    -1,
     219,   988,   993,   786,   995,   989,   997,  1013,    -1,    -1,
      -1,   395,   991,   994,   995,   992,   997,    -1,    -1,   264,
      -1,   110,    -1,   200,    -1,  1022,    -1,   110,    -1,   222,
     996,    -1,   996,    -1,   984,    -1,  1000,    -1,   560,   561,
    1000,    -1,   560,   999,   561,  1000,    -1,    -1,   426,   998,
    1004,    -1,   999,   562,  1101,    -1,  1101,    -1,   522,  1003,
      -1,   523,  1003,    -1,    -1,   682,  1001,  1189,    -1,    -1,
     560,   682,   561,  1002,  1192,    -1,  1003,   562,  1008,    -1,
    1008,    -1,  1004,   562,  1005,    -1,  1005,    -1,  1105,  1006,
    1012,    -1,   142,    -1,   427,    -1,    -1,  1006,    -1,    -1,
     560,  1009,  1010,   561,    -1,    -1,  1011,    -1,  1011,   562,
    1012,    -1,  1012,    -1,   861,    -1,   108,    -1,    -1,    -1,
     337,   129,  1014,   232,   511,  1020,    -1,    -1,    -1,   511,
    1016,  1022,   786,   906,   426,  1018,  1017,   942,   953,   963,
      -1,  1018,   562,  1019,    -1,  1019,    -1,  1105,  1006,  1012,
      -1,  1020,   562,  1021,    -1,  1021,    -1,  1105,  1006,  1012,
      -1,    -1,   264,    -1,    -1,   112,  1024,  1032,  1025,    -1,
      -1,   171,  1108,  1026,   942,   953,   963,    -1,    -1,  1029,
    1027,   171,   906,   942,    -1,    -1,   171,  1029,  1028,   517,
     906,   942,    -1,  1030,    -1,  1029,   562,  1030,    -1,  1114,
    1031,   940,    -1,  1114,   568,  1114,  1031,   940,    -1,    -1,
     568,   554,    -1,    -1,  1033,  1032,    -1,   372,    -1,   264,
      -1,   210,    -1,   492,  1035,   984,    -1,    -1,   472,    -1,
      -1,   431,  1037,  1038,    -1,    92,  1049,    -1,  1045,   470,
    1044,  1049,    -1,  1045,   489,  1044,  1049,    -1,   472,   455,
    1044,  1049,    -1,   340,   470,  1044,  1049,    -1,    -1,   140,
     699,  1039,  1041,    -1,  1045,    65,  1046,  1108,  1044,  1049,
      -1,   322,   281,   168,   435,   535,   269,   142,  1111,    16,
     270,   142,   965,    16,   274,   142,   964,    -1,  1042,   257,
      -1,   435,   201,    -1,    -1,    33,   147,  1047,  1048,  1040,
     958,    -1,   763,  1046,  1108,  1044,   942,    -1,    66,   493,
      -1,   472,   493,    -1,  1043,   139,    -1,   365,    -1,    83,
     560,   554,   561,   530,    -1,    83,   560,   554,   561,   144,
      -1,   530,   958,    -1,   144,   958,    -1,  1128,   455,  1049,
      -1,   216,   455,    -1,   313,   455,    -1,  1045,   368,    -1,
    1128,   526,  1049,    -1,   737,  1049,    -1,    64,  1049,    -1,
      30,   257,    -1,   257,    -1,   189,    -1,   189,   168,  1117,
      -1,    84,    91,   692,  1114,    -1,    84,   472,  1108,    -1,
      84,   529,  1108,    -1,   281,   455,    -1,   435,   455,    -1,
      84,   366,   598,    -1,    84,   175,   598,    -1,   366,   455,
    1049,    -1,   175,   455,  1049,    -1,   366,    62,   598,    -1,
     175,    62,   598,    -1,   455,    -1,   257,    -1,   281,    -1,
      32,    -1,    -1,   459,    -1,    -1,  1046,  1114,    -1,    -1,
     173,    -1,   171,    -1,   225,    -1,    -1,   225,  1111,    -1,
      -1,   171,   965,    -1,    -1,   246,  1111,    -1,   533,   861,
      -1,    -1,  1053,  1108,  1051,  1055,    -1,    -1,  1053,  1054,
    1052,   840,    -1,   113,    -1,   114,    -1,    -1,   153,    -1,
      -1,  1096,    -1,  1114,    -1,    -1,   164,   822,  1057,  1058,
      -1,  1058,   562,  1059,    -1,  1059,    -1,    -1,  1139,  1060,
    1061,    -1,   470,   535,   380,   256,    -1,   371,    46,    -1,
     201,    -1,   365,    -1,   257,    -1,   455,    -1,   435,    -1,
     281,    -1,   117,    -1,   399,    -1,    -1,   983,    -1,    -1,
     398,  1063,  1064,    -1,  1064,   562,  1065,    -1,  1065,    -1,
     435,    -1,   281,    -1,   371,    46,    -1,    -1,   369,  1067,
    1068,    -1,  1042,   257,  1069,    -1,   485,  1111,    -1,    27,
     861,    -1,    -1,   233,  1071,  1072,   861,    -1,    -1,    76,
      -1,   371,    -1,   516,  1114,    -1,    -1,   251,    93,  1075,
    1076,    -1,   251,   472,  1108,   171,   281,    -1,    -1,    -1,
      -1,    -1,  1082,  1081,   214,  1113,  1077,  1083,   222,  1078,
     472,  1108,  1079,   740,  1080,  1084,  1087,  1090,  1091,  1094,
      -1,   171,   281,    -1,    -1,   252,    -1,    -1,    74,    -1,
     264,    -1,    -1,   395,    -1,   210,    -1,    -1,    65,  1085,
      -1,  1085,  1086,    -1,  1086,    -1,   475,    44,  1096,    -1,
     343,   135,    44,  1096,    -1,   135,    44,  1096,    -1,   145,
      44,  1096,    -1,    -1,   249,  1088,    -1,  1088,  1089,    -1,
    1089,    -1,   475,    44,  1096,    -1,   453,    44,  1096,    -1,
      -1,   210,   331,   249,    -1,    -1,   560,  1092,   561,    -1,
     560,   561,    -1,  1092,   562,  1093,    -1,  1093,    -1,  1105,
      -1,   567,  1116,    -1,    -1,   426,  1020,    -1,   476,    -1,
     318,    -1,   500,   476,    -1,  1095,  1112,    -1,  1112,    -1,
     199,    -1,    34,    -1,   354,    -1,  1099,    -1,   553,  1100,
      -1,   552,  1100,    -1,  1095,    -1,  1100,    -1,   330,    -1,
     155,    -1,   491,    -1,   199,    -1,    34,    -1,   500,   199,
      -1,   500,    34,    -1,    97,  1095,    -1,   481,  1095,    -1,
     478,  1095,    -1,   331,    -1,   261,    -1,   497,    -1,   104,
      -1,   162,    -1,  1105,    -1,  1102,    -1,  1114,   568,   554,
      -1,  1114,   568,  1114,   568,   554,    -1,   861,    -1,  1114,
      -1,  1106,    -1,  1114,    -1,  1106,    -1,  1114,   568,  1114,
      -1,   568,  1114,   568,  1114,    -1,  1114,   568,  1114,   568,
    1114,    -1,  1114,    -1,  1114,   568,  1114,   568,  1114,    -1,
    1114,   568,  1114,    -1,   568,  1114,    -1,  1114,    -1,  1114,
     568,  1114,    -1,   568,  1114,    -1,  1114,    -1,   206,    -1,
     208,    -1,   476,    -1,   476,    -1,   476,    -1,  1110,    -1,
    1118,    -1,  1110,    -1,  1119,    -1,  1114,    -1,  1111,    -1,
     245,    -1,  1116,    -1,  1116,   567,  1116,    -1,    88,   860,
      -1,  1119,    -1,    20,    -1,    26,    -1,    28,    -1,    45,
      -1,    46,    -1,    54,    -1,    56,    -1,    60,    -1,    67,
      -1,    69,    -1,    79,    -1,   103,    -1,   125,    -1,   138,
      -1,   148,    -1,   164,    -1,   195,    -1,   198,    -1,   235,
      -1,   328,    -1,   340,    -1,   362,    -1,   392,    -1,   398,
      -1,   400,    -1,   407,    -1,   416,    -1,   419,    -1,   433,
      -1,   435,    -1,   454,    -1,   458,    -1,   492,    -1,   502,
      -1,   539,    -1,   512,    -1,     5,    -1,     7,    -1,     8,
      -1,     9,    -1,    10,    -1,    11,    -1,    17,    -1,    23,
      -1,    24,    -1,    25,    -1,    30,    -1,    33,    -1,    37,
      -1,    41,    -1,    40,    -1,    43,    -1,    49,    -1,    51,
      -1,    53,    -1,    58,    -1,    59,    -1,    62,    -1,    64,
      -1,    65,    -1,    68,    -1,    70,    -1,    71,    -1,    74,
      -1,    76,    -1,    77,    -1,    86,    -1,    93,    -1,    94,
      -1,    97,    -1,   102,    -1,   109,    -1,   111,    -1,   117,
      -1,   119,    -1,   121,    -1,   128,    -1,   129,    -1,   130,
      -1,   141,    -1,   140,    -1,   139,    -1,   144,    -1,   146,
      -1,   147,    -1,   151,    -1,   153,    -1,   156,    -1,   169,
      -1,   120,    -1,   134,    -1,   173,    -1,   159,    -1,   160,
      -1,   161,    -1,   170,    -1,   183,    -1,   182,    -1,   186,
      -1,   189,    -1,   187,    -1,   196,    -1,   201,    -1,   205,
      -1,   207,    -1,   224,    -1,   211,    -1,   212,    -1,   227,
      -1,   228,    -1,   216,    -1,   220,    -1,   388,    -1,   237,
      -1,   241,    -1,   244,    -1,   250,    -1,   252,    -1,   255,
      -1,   257,    -1,   286,    -1,   281,    -1,   268,    -1,   272,
      -1,   269,    -1,   270,    -1,   282,    -1,   271,    -1,   274,
      -1,   267,    -1,   280,    -1,   276,    -1,   275,    -1,   277,
      -1,   278,    -1,   279,    -1,   284,    -1,   285,    -1,   288,
      -1,   289,    -1,   293,    -1,   294,    -1,   295,    -1,   296,
      -1,   299,    -1,   300,    -1,   305,    -1,   303,    -1,   307,
      -1,   310,    -1,   311,    -1,   312,    -1,   313,    -1,   315,
      -1,   314,    -1,   316,    -1,   319,    -1,   320,    -1,   323,
      -1,   322,    -1,   324,    -1,   333,    -1,   334,    -1,   336,
      -1,   338,    -1,   339,    -1,   351,    -1,   352,    -1,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,   363,    -1,   365,
      -1,   367,    -1,   368,    -1,   370,    -1,   371,    -1,   372,
      -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,   377,
      -1,   382,    -1,   383,    -1,   386,    -1,   387,    -1,   390,
      -1,   393,    -1,   396,    -1,   399,    -1,   402,    -1,   403,
      -1,   408,    -1,   410,    -1,   411,    -1,   413,    -1,   414,
      -1,   415,    -1,   418,    -1,   424,    -1,   423,    -1,   425,
      -1,   434,    -1,   428,    -1,   432,    -1,   437,    -1,   438,
      -1,   446,    -1,   445,    -1,   448,    -1,   451,    -1,   455,
      -1,   459,    -1,   461,    -1,   462,    -1,   463,    -1,   467,
      -1,   468,    -1,   470,    -1,   471,    -1,   473,    -1,   474,
      -1,   477,    -1,   487,    -1,   489,    -1,   478,    -1,   479,
      -1,   480,    -1,   481,    -1,   493,    -1,   494,    -1,   495,
      -1,   175,    -1,   498,    -1,   499,    -1,   507,    -1,   510,
      -1,   514,    -1,   515,    -1,   526,    -1,   529,    -1,   523,
      -1,   530,    -1,   531,    -1,   536,    -1,   538,    -1,   543,
      -1,    -1,   426,  1122,  1121,  1123,    -1,    -1,   342,    -1,
    1124,    -1,  1123,   562,  1124,    -1,    -1,  1125,  1130,    -1,
    1127,    -1,   187,    -1,   252,    -1,   425,    -1,    -1,   338,
      -1,    -1,   187,    -1,   252,    -1,   425,    -1,    -1,   187,
     568,    -1,   252,   568,    -1,   425,   568,    -1,  1131,    -1,
    1127,  1132,    -1,  1126,  1133,  1006,  1136,    -1,  1126,   487,
     227,   244,  1134,    -1,   567,  1116,  1006,   861,    -1,   567,
     567,  1129,  1133,  1006,  1136,    -1,   737,   742,    -1,   314,
    1006,   861,    -1,   314,   739,   744,    -1,   353,  1006,  1135,
      -1,   353,   168,  1117,  1006,  1135,    -1,  1114,    -1,  1114,
     568,  1114,    -1,   108,   568,  1114,    -1,   380,   498,    -1,
     380,    68,    -1,   393,   380,    -1,   423,    -1,   476,    -1,
     353,   560,   476,   561,    -1,   336,   560,   476,   561,    -1,
     861,    -1,   108,    -1,   337,    -1,    12,    -1,    32,    -1,
      -1,   256,  1139,  1138,  1140,    -1,   472,    -1,   470,    -1,
    1141,    -1,  1140,   562,  1141,    -1,  1108,   940,  1142,    -1,
     380,    -1,   537,    -1,   264,   537,    -1,   380,   252,    -1,
      -1,   508,  1144,  1139,    -1,   195,  1108,   340,   940,    -1,
     195,  1109,    60,    -1,    -1,   195,  1109,   380,  1146,  1147,
     942,   959,    -1,  1148,    -1,  1114,  1149,    -1,   160,    -1,
     323,    -1,   160,    -1,   323,    -1,   363,    -1,   237,    -1,
      -1,  1151,  1150,   560,  1011,   561,    -1,   142,    -1,   180,
      -1,   238,    -1,   194,    -1,   265,    -1,   405,   597,  1153,
      -1,  1157,   337,  1156,  1168,   171,  1170,    -1,  1157,   337,
     175,  1168,   171,  1170,    -1,  1157,   337,   366,  1168,   171,
    1170,    -1,    12,  1158,   562,   188,   342,   171,  1170,    -1,
     188,   597,  1155,    -1,  1157,   337,  1156,  1168,   485,  1170,
    1175,  1176,    -1,  1157,   337,   175,  1168,   485,  1170,  1175,
    1176,    -1,  1157,   337,   366,  1168,   485,  1170,  1175,  1176,
      -1,    -1,   472,    -1,  1159,    -1,    12,  1158,    -1,    -1,
     365,    -1,  1160,    -1,  1159,   562,  1160,    -1,    -1,   420,
    1161,  1172,    -1,    -1,   219,  1162,  1172,    -1,    -1,   511,
    1163,  1172,    -1,    -1,   384,  1164,  1172,    -1,   112,    -1,
     513,    -1,   213,    -1,    13,    -1,    84,    -1,   126,    -1,
     148,    -1,   390,    -1,   432,    -1,   367,    -1,   159,    -1,
     188,   342,    -1,   431,    92,    -1,   467,    -1,    84,   473,
     470,    -1,   256,   470,    -1,   396,   435,    -1,   396,    59,
      -1,    84,   529,    -1,   431,   529,    -1,    84,   410,    -1,
      13,   410,    -1,    84,   514,    -1,    -1,    16,    -1,  1167,
    1165,  1166,    -1,  1167,    -1,   463,   476,    -1,   228,   476,
      -1,    58,   476,    -1,   554,    -1,  1114,   568,   554,    -1,
     554,   568,   554,    -1,  1108,    -1,  1117,    -1,  1169,   562,
    1117,    -1,  1171,    -1,  1170,   562,  1171,    -1,  1117,   207,
      44,   476,    -1,  1117,   207,    44,   353,   476,    -1,  1117,
      -1,    -1,   560,  1173,   561,    -1,  1173,   562,  1174,    -1,
    1174,    -1,  1114,    -1,    -1,   397,  1166,    -1,   397,   452,
      -1,   397,   538,    -1,   397,   324,    -1,    -1,   535,  1177,
      -1,  1177,  1178,    -1,  1178,    -1,   188,   342,    -1,   285,
     964,    -1,   288,   964,    -1,   284,   964,    -1,   289,   964,
      -1,    -1,    28,  1180,  1181,    -1,    -1,   536,    -1,    -1,
      16,   328,    51,    -1,    16,    51,    -1,    -1,   389,    -1,
     328,   389,    -1,    -1,   416,    -1,    69,  1181,  1182,  1183,
      -1,   407,  1181,  1182,  1183,    -1,   407,  1181,   485,  1184,
    1114,    -1,   416,  1114,    -1,   389,   416,  1114,    -1,    -1,
    1190,    -1,    -1,   503,  1196,  1191,   841,    -1,    -1,  1190,
      -1,  1193,    -1,    -1,  1194,  1195,    -1,   954,   958,    -1,
     960,    -1,    -1,   122,    -1,    12,    -1,    -1,   420,  1199,
     843,  1197,  1200,    -1,   560,  1199,   842,  1197,  1200,   561,
      -1,    -1,    -1,  1206,  1202,    -1,  1205,  1203,    -1,  1207,
    1204,  1212,    -1,  1212,    -1,  1220,    -1,  1229,    -1,  1223,
      -1,  1212,    -1,  1220,    -1,  1229,    -1,  1223,    -1,  1222,
      -1,  1205,    -1,  1206,    -1,    -1,   109,   142,  1117,    -1,
    1208,    -1,  1208,  1209,    -1,  1209,    -1,   347,   395,    -1,
      11,   142,   499,    -1,    11,   142,   294,    -1,    11,   142,
     474,    -1,    -1,  1209,    -1,    -1,   450,   419,   109,    -1,
     450,   419,   224,    -1,    -1,  1211,   529,  1108,  1213,  1214,
      18,  1216,  1219,    -1,    -1,   560,  1215,   561,    -1,  1114,
      -1,  1215,   562,  1114,    -1,    -1,  1217,  1218,    -1,   420,
     856,   843,    -1,   560,   856,   842,   561,  1192,    -1,    -1,
     535,    57,   342,    -1,   535,    49,    57,   342,    -1,   535,
     252,    57,   342,    -1,    -1,   488,   856,   598,   674,   675,
     337,   856,  1108,   168,   856,   131,   414,  1221,   633,    -1,
      10,   856,   175,  1114,   403,   704,   496,  1111,    -1,   856,
     175,  1114,   403,   704,   496,  1111,    -1,    -1,    -1,    -1,
      -1,    -1,   856,   175,   598,   560,  1224,   609,   561,  1225,
     403,  1226,   715,  1227,   600,  1228,   633,    -1,    -1,    -1,
      -1,    -1,   366,   856,   598,  1230,   560,  1231,   613,   561,
    1232,   600,  1233,   633,    -1,   539,  1236,  1235,  1237,    -1,
     539,   138,  1235,  1239,    -1,   539,   362,  1235,    -1,   539,
      69,  1235,  1238,    -1,   539,   407,  1235,    -1,   539,   382,
      -1,  1096,    -1,  1096,   562,  1096,    -1,  1096,   562,  1096,
     562,   964,    -1,    28,    -1,   454,    -1,    -1,   230,    -1,
     402,    -1,    -1,   339,   355,    -1,    -1,    -1,   468,  1240,
    1241,    -1,    -1,   168,   296,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1207,  1207,  1220,  1219,  1244,  1251,  1253,  1257,  1258,
    1263,  1264,  1265,  1266,  1267,  1268,  1269,  1270,  1271,  1272,
    1273,  1274,  1275,  1276,  1277,  1278,  1279,  1280,  1281,  1282,
    1283,  1284,  1285,  1286,  1287,  1288,  1289,  1290,  1291,  1292,
    1293,  1294,  1295,  1296,  1297,  1298,  1299,  1300,  1301,  1302,
    1303,  1304,  1305,  1306,  1307,  1308,  1309,  1313,  1322,  1323,
    1328,  1337,  1344,  1354,  1353,  1364,  1366,  1370,  1371,  1374,
    1387,  1386,  1405,  1404,  1415,  1416,  1419,  1424,  1429,  1434,
    1439,  1443,  1448,  1452,  1456,  1460,  1464,  1469,  1473,  1477,
    1493,  1497,  1509,  1508,  1528,  1527,  1550,  1549,  1562,  1561,
    1569,  1577,  1591,  1608,  1628,  1629,  1633,  1634,  1639,  1641,
    1643,  1645,  1647,  1649,  1651,  1657,  1658,  1659,  1663,  1667,
    1675,  1674,  1687,  1689,  1692,  1694,  1698,  1702,  1709,  1711,
    1715,  1716,  1721,  1740,  1766,  1768,  1772,  1773,  1777,  1803,
    1804,  1805,  1806,  1810,  1811,  1815,  1816,  1821,  1824,  1851,
    1850,  1920,  1935,  1934,  1983,  2009,  2009,  2041,  2042,  2047,
    2049,  2054,  2077,  2085,  2102,  2103,  2107,  2111,  2120,  2127,
    2134,  2144,  2159,  2177,  2178,  2182,  2182,  2234,  2233,  2262,
    2261,  2265,  2266,  2268,  2268,  2279,  2281,  2283,  2333,  2373,
    2391,  2390,  2409,  2428,  2430,  2431,  2435,  2456,  2479,  2484,
    2499,  2479,  2518,  2520,  2521,  2525,  2526,  2531,  2538,  2530,
    2557,  2556,  2572,  2573,  2577,  2578,  2583,  2588,  2582,  2605,
    2610,  2604,  2625,  2635,  2640,  2639,  2675,  2676,  2681,  2680,
    2713,  2713,  2728,  2727,  2764,  2776,  2781,  2775,  2807,  2806,
    2829,  2831,  2836,  2838,  2840,  2845,  2846,  2847,  2853,  2862,
    2863,  2863,  2867,  2869,  2868,  2871,  2870,  2876,  2892,  2875,
    2906,  2907,  2910,  2911,  2914,  2915,  2918,  2919,  2922,  2923,
    2926,  2927,  2930,  2933,  2934,  2936,  2938,  2941,  2942,  2945,
    2946,  2947,  2950,  2951,  2952,  2953,  2954,  2955,  2956,  2957,
    2958,  2973,  2979,  2980,  2981,  2982,  2987,  2992,  2997,  3012,
    3013,  3014,  3015,  3016,  3017,  3021,  3038,  3054,  3064,  3065,
    3066,  3067,  3068,  3069,  3072,  3073,  3074,  3077,  3078,  3079,
    3082,  3083,  3086,  3087,  3088,  3089,  3092,  3093,  3097,  3098,
    3102,  3103,  3110,  3120,  3130,  3151,  3155,  3161,  3163,  3167,
    3171,  3172,  3176,  3181,  3180,  3202,  3203,  3204,  3205,  3207,
    3208,  3210,  3212,  3213,  3215,  3217,  3220,  3222,  3225,  3226,
    3228,  3230,  3231,  3232,  3233,  3246,  3247,  3249,  3251,  3263,
    3265,  3267,  3269,  3270,  3271,  3272,  3273,  3274,  3276,  3278,
    3280,  3280,  3282,  3282,  3284,  3285,  3294,  3295,  3296,  3299,
    3300,  3301,  3302,  3303,  3307,  3311,  3312,  3316,  3317,  3321,
    3322,  3323,  3324,  3325,  3329,  3330,  3331,  3332,  3333,  3336,
    3338,  3339,  3343,  3344,  3345,  3348,  3355,  3356,  3359,  3360,
    3363,  3364,  3365,  3368,  3369,  3372,  3373,  3374,  3375,  3378,
    3379,  3382,  3383,  3386,  3387,  3390,  3391,  3392,  3393,  3395,
    3396,  3402,  3408,  3414,  3420,  3421,  3437,  3443,  3447,  3448,
    3452,  3460,  3464,  3465,  3468,  3469,  3473,  3482,  3486,  3487,
    3490,  3500,  3501,  3505,  3506,  3509,  3510,  3513,  3514,  3515,
    3516,  3525,  3526,  3529,  3530,  3533,  3534,  3535,  3544,  3546,
    3548,  3553,  3552,  3564,  3565,  3568,  3575,  3586,  3587,  3590,
    3591,  3594,  3595,  3596,  3597,  3598,  3601,  3602,  3603,  3604,
    3605,  3608,  3609,  3610,  3622,  3623,  3626,  3627,  3630,  3631,
    3635,  3636,  3637,  3640,  3641,  3642,  3643,  3656,  3657,  3658,
    3661,  3662,  3666,  3669,  3670,  3673,  3679,  3693,  3694,  3697,
    3698,  3701,  3702,  3710,  3709,  3733,  3732,  3746,  3745,  3764,
    3763,  3783,  3781,  3801,  3802,  3804,  3805,  3806,  3807,  3808,
    3811,  3819,  3820,  3824,  3829,  3828,  3836,  3845,  3835,  3857,
    3866,  3870,  3879,  3888,  3894,  3900,  3909,  3918,  3936,  3957,
    3962,  3966,  3973,  3974,  3977,  3978,  3982,  3983,  3984,  3988,
    3989,  3990,  3993,  3994,  3995,  3996,  4004,  4003,  4014,  4022,
    4021,  4031,  4041,  4050,  4051,  4058,  4058,  4064,  4065,  4069,
    4070,  4071,  4075,  4076,  4093,  4094,  4099,  4098,  4109,  4108,
    4119,  4118,  4128,  4129,  4130,  4135,  4134,  4146,  4147,  4150,
    4151,  4154,  4155,  4156,  4160,  4159,  4172,  4171,  4188,  4189,
    4192,  4193,  4196,  4197,  4198,  4199,  4200,  4201,  4205,  4204,
    4216,  4217,  4218,  4223,  4222,  4228,  4235,  4240,  4248,  4249,
    4252,  4264,  4273,  4274,  4277,  4290,  4291,  4296,  4295,  4305,
    4306,  4309,  4322,  4322,  4332,  4333,  4342,  4343,  4352,  4361,
    4363,  4366,  4396,  4400,  4399,  4421,  4429,  4421,  4435,  4436,
    4437,  4438,  4439,  4442,  4449,  4456,  4458,  4469,  4470,  4473,
    4474,  4480,  4481,  4482,  4483,  4489,  4495,  4501,  4515,  4518,
    4520,  4526,  4536,  4537,  4538,  4552,  4578,  4583,  4588,  4589,
    4592,  4593,  4594,  4595,  4596,  4600,  4601,  4605,  4656,  4663,
    4706,  4712,  4718,  4724,  4730,  4736,  4742,  4748,  4752,  4758,
    4764,  4770,  4776,  4782,  4785,  4791,  4801,  4807,  4815,  4821,
    4831,  4837,  4845,  4855,  4861,  4870,  4876,  4885,  4888,  4894,
    4900,  4906,  4912,  4918,  4924,  4930,  4936,  4942,  4948,  4954,
    4960,  4966,  4972,  4975,  4975,  4976,  4976,  4977,  4977,  4978,
    4978,  4980,  4981,  4982,  4983,  4984,  4985,  4988,  4989,  4993,
    4998,  4999,  5008,  5009,  5010,  5011,  5012,  5018,  5020,  5026,
    5032,  5038,  5044,  5045,  5052,  5059,  5065,  5067,  5076,  5082,
    5088,  5095,  5101,  5107,  5113,  5126,  5132,  5145,  5158,  5171,
    5184,  5190,  5196,  5202,  5208,  5214,  5220,  5226,  5232,  5238,
    5244,  5250,  5257,  5265,  5272,  5279,  5286,  5293,  5299,  5305,
    5312,  5318,  5324,  5331,  5337,  5344,  5350,  5356,  5362,  5368,
    5374,  5380,  5386,  5392,  5398,  5404,  5410,  5416,  5425,  5432,
    5445,  5451,  5457,  5463,  5469,  5476,  5487,  5494,  5501,  5507,
    5513,  5519,  5526,  5533,  5539,  5545,  5552,  5559,  5565,  5571,
    5577,  5583,  5590,  5597,  5605,  5611,  5617,  5623,  5630,  5637,
    5643,  5649,  5658,  5664,  5671,  5677,  5683,  5689,  5695,  5701,
    5707,  5713,  5719,  5728,  5737,  5743,  5749,  5755,  5761,  5767,
    5773,  5779,  5785,  5791,  5797,  5803,  5809,  5815,  5821,  5838,
    5837,  5980,  5986,  5993,  5999,  6006,  6013,  6020,  6027,  6038,
    6044,  6050,  6059,  6065,  6072,  6081,  6083,  6085,  6087,  6089,
    6091,  6095,  6098,  6101,  6103,  6105,  6107,  6109,  6111,  6113,
    6116,  6119,  6121,  6123,  6125,  6127,  6129,  6132,  6134,  6136,
    6138,  6143,  6144,  6145,  6149,  6150,  6154,  6154,  6165,  6169,
    6176,  6207,  6213,  6219,  6225,  6231,  6237,  6246,  6253,  6255,
    6252,  6262,  6268,  6279,  6285,  6291,  6297,  6303,  6309,  6315,
    6321,  6327,  6334,  6333,  6350,  6349,  6364,  6372,  6380,  6393,
    6394,  6398,  6403,  6409,  6412,  6426,  6425,  6441,  6442,  6443,
    6444,  6445,  6446,  6447,  6448,  6449,  6450,  6451,  6455,  6456,
    6460,  6460,  6470,  6471,  6474,  6475,  6478,  6478,  6488,  6489,
    6492,  6493,  6496,  6497,  6500,  6508,  6518,  6519,  6528,  6533,
    6534,  6554,  6556,  6560,  6558,  6575,  6573,  6591,  6589,  6596,
    6605,  6603,  6621,  6620,  6630,  6641,  6639,  6658,  6657,  6668,
    6678,  6679,  6680,  6685,  6685,  6704,  6702,  6721,  6743,  6791,
    6790,  6813,  6831,  6813,  6838,  6842,  6868,  6869,  6871,  6873,
    6876,  6877,  6883,  6890,  6899,  6898,  6905,  6906,  6910,  6919,
    6928,  6939,  6950,  6962,  6963,  6964,  6965,  6966,  6967,  6968,
    6969,  6970,  6971,  6972,  6973,  6976,  6977,  6996,  6997,  6998,
    6999,  7000,  7001,  7002,  7003,  7004,  7008,  7009,  7010,  7011,
    7014,  7016,  7017,  7020,  7021,  7029,  7031,  7035,  7037,  7036,
    7050,  7053,  7052,  7067,  7073,  7088,  7090,  7093,  7095,  7099,
    7100,  7113,  7131,  7135,  7136,  7140,  7153,  7155,  7159,  7158,
    7191,  7193,  7197,  7198,  7199,  7204,  7210,  7214,  7215,  7219,
    7223,  7230,  7237,  7246,  7250,  7256,  7262,  7272,  7276,  7284,
    7285,  7286,  7287,  7288,  7289,  7293,  7294,  7295,  7296,  7297,
    7300,  7303,  7302,  7332,  7333,  7336,  7337,  7340,  7355,  7355,
    7366,  7367,  7371,  7390,  7423,  7422,  7435,  7434,  7443,  7455,
    7466,  7465,  7482,  7489,  7489,  7503,  7510,  7528,  7549,  7561,
    7565,  7571,  7581,  7582,  7585,  7593,  7594,  7598,  7599,  7607,
    7616,  7606,  7626,  7633,  7625,  7643,  7655,  7656,  7657,  7661,
    7662,  7665,  7666,  7669,  7678,  7679,  7680,  7682,  7681,  7691,
    7692,  7695,  7696,  7697,  7697,  7698,  7698,  7702,  7703,  7706,
    7708,  7711,  7719,  7720,  7724,  7725,  7730,  7729,  7742,  7743,
    7746,  7751,  7759,  7760,  7768,  7770,  7770,  7778,  7787,  7777,
    7809,  7810,  7813,  7820,  7821,  7824,  7833,  7834,  7840,  7839,
    7853,  7852,  7861,  7860,  7868,  7867,  7877,  7878,  7881,  7891,
    7907,  7908,  7912,  7913,  7916,  7917,  7918,  7921,  7931,  7933,
    7938,  7937,  7951,  7959,  7968,  7977,  7986,  7996,  7995,  7998,
    8008,  8018,  8022,  8027,  8026,  8031,  8041,  8046,  8052,  8057,
    8062,  8064,  8066,  8068,  8070,  8079,  8081,  8083,  8085,  8094,
    8102,  8110,  8112,  8114,  8124,  8131,  8137,  8145,  8153,  8157,
    8161,  8168,  8175,  8185,  8195,  8205,  8218,  8232,  8245,  8246,
    8248,  8250,  8253,  8254,  8257,  8258,  8261,  8262,  8265,  8266,
    8269,  8270,  8272,  8274,  8281,  8293,  8292,  8307,  8306,  8316,
    8317,  8320,  8321,  8325,  8326,  8327,  8342,  8341,  8353,  8354,
    8357,  8357,  8358,  8359,  8360,  8361,  8362,  8363,  8364,  8365,
    8366,  8367,  8370,  8371,  8375,  8374,  8383,  8384,  8387,  8388,
    8389,  8393,  8392,  8402,  8406,  8410,  8422,  8422,  8430,  8431,
    8432,  8437,  8447,  8446,  8462,  8480,  8491,  8495,  8505,  8479,
    8510,  8519,  8520,  8523,  8524,  8536,  8540,  8541,  8542,  8544,
    8546,  8549,  8550,  8553,  8558,  8565,  8570,  8576,  8578,  8581,
    8582,  8585,  8590,  8596,  8598,  8605,  8606,  8607,  8610,  8612,
    8617,  8618,  8627,  8628,  8634,  8657,  8667,  8674,  8693,  8701,
    8713,  8728,  8749,  8750,  8751,  8760,  8761,  8762,  8769,  8775,
    8781,  8787,  8793,  8817,  8840,  8841,  8842,  8845,  8852,  8859,
    8863,  8871,  8886,  8887,  8890,  8898,  8911,  8914,  8954,  8958,
    8968,  8972,  9042,  9059,  9085,  9086,  9102,  9112,  9115,  9121,
    9127,  9136,  9146,  9147,  9175,  9190,  9206,  9221,  9222,  9233,
    9234,  9245,  9246,  9247,  9250,  9263,  9275,  9289,  9290,  9291,
    9292,  9293,  9294,  9295,  9296,  9297,  9298,  9299,  9300,  9301,
    9302,  9303,  9304,  9305,  9306,  9307,  9308,  9309,  9310,  9311,
    9312,  9313,  9314,  9315,  9316,  9317,  9318,  9319,  9320,  9321,
    9322,  9323,  9324,  9325,  9335,  9336,  9337,  9338,  9339,  9340,
    9341,  9342,  9343,  9344,  9345,  9346,  9347,  9348,  9349,  9350,
    9351,  9352,  9353,  9354,  9355,  9356,  9357,  9358,  9359,  9360,
    9361,  9362,  9363,  9364,  9365,  9366,  9367,  9368,  9369,  9370,
    9371,  9372,  9373,  9374,  9375,  9376,  9377,  9378,  9379,  9380,
    9381,  9382,  9383,  9384,  9385,  9386,  9387,  9388,  9389,  9390,
    9391,  9392,  9393,  9394,  9395,  9396,  9397,  9398,  9399,  9400,
    9401,  9402,  9403,  9404,  9405,  9406,  9407,  9408,  9409,  9410,
    9411,  9412,  9413,  9414,  9415,  9416,  9417,  9418,  9419,  9420,
    9421,  9422,  9423,  9424,  9425,  9426,  9427,  9428,  9429,  9430,
    9431,  9432,  9433,  9434,  9435,  9436,  9437,  9438,  9439,  9440,
    9441,  9442,  9443,  9444,  9445,  9446,  9447,  9448,  9449,  9450,
    9451,  9452,  9453,  9454,  9455,  9456,  9457,  9458,  9459,  9460,
    9461,  9462,  9463,  9464,  9465,  9466,  9467,  9468,  9469,  9470,
    9471,  9472,  9473,  9474,  9475,  9476,  9477,  9478,  9479,  9480,
    9481,  9482,  9483,  9484,  9485,  9486,  9487,  9488,  9489,  9490,
    9491,  9492,  9493,  9494,  9495,  9496,  9497,  9498,  9499,  9500,
    9501,  9502,  9503,  9504,  9505,  9506,  9507,  9508,  9509,  9510,
    9511,  9512,  9513,  9514,  9515,  9516,  9517,  9518,  9519,  9520,
    9521,  9522,  9523,  9524,  9525,  9526,  9527,  9528,  9529,  9530,
    9531,  9532,  9533,  9534,  9535,  9536,  9537,  9538,  9539,  9540,
    9541,  9542,  9543,  9544,  9545,  9546,  9547,  9554,  9553,  9567,
    9568,  9571,  9572,  9575,  9575,  9653,  9654,  9655,  9656,  9660,
    9661,  9665,  9666,  9667,  9668,  9672,  9673,  9674,  9675,  9679,
    9680,  9683,  9765,  9784,  9794,  9802,  9815,  9830,  9847,  9871,
    9881,  9919,  9962,  9976,  9977,  9978,  9979,  9983,  9984,  9993,
   10004, 10005, 10006, 10012, 10018, 10031, 10030, 10046, 10047, 10050,
   10051, 10054, 10062, 10063, 10064, 10065, 10070, 10069, 10090, 10102,
   10115, 10114, 10136, 10137, 10141, 10142, 10146, 10147, 10148, 10149,
   10151, 10150, 10161, 10162, 10163, 10164, 10165, 10171, 10176, 10183,
   10196, 10208, 10215, 10220, 10228, 10241, 10255, 10257, 10260, 10261,
   10268, 10270, 10274, 10275, 10278, 10278, 10279, 10279, 10280, 10280,
   10281, 10281, 10282, 10283, 10284, 10285, 10286, 10287, 10288, 10289,
   10290, 10291, 10292, 10293, 10294, 10295, 10296, 10297, 10298, 10299,
   10300, 10301, 10302, 10303, 10304, 10309, 10310, 10314, 10315, 10319,
   10329, 10339, 10352, 10366, 10379, 10392, 10405, 10406, 10415, 10416,
   10425, 10452, 10454, 10461, 10465, 10468, 10469, 10472, 10500, 10501,
   10505, 10509, 10513, 10520, 10521, 10524, 10525, 10529, 10530, 10536,
   10542, 10548, 10558, 10557, 10567, 10568, 10572, 10573, 10574, 10578,
   10579, 10580, 10584, 10585, 10589, 10599, 10606, 10616, 10625, 10639,
   10640, 10645, 10644, 10685, 10686, 10687, 10691, 10691, 10715, 10716,
   10720, 10721, 10722, 10726, 10731, 10736, 10743, 10764, 10786, 10788,
   10790, 10795, 10796, 10797, 10798, 10802, 10803, 10804, 10805, 10806,
   10816, 10817, 10822, 10835, 10848, 10850, 10852, 10857, 10862, 10864,
   10866, 10872, 10873, 10879, 10880, 10882, 10888, 10887, 10902, 10903,
   10907, 10914, 10924, 10924, 10942, 10951, 10964, 10965, 10967, 10969,
   10982, 10980, 11046, 11057, 11075, 11104, 11108, 11116, 11128, 11071,
   11158, 11182, 11187, 11196, 11157, 11217, 11221, 11225, 11229, 11233,
   11237, 11243, 11250, 11257, 11266, 11267, 11271, 11272, 11273, 11277,
   11278, 11282, 11283, 11283, 11288, 11289
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'",
  "'.'", "':'", "$accept", "query", "@1", "opt_end_of_input",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "@2", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "@3", "change", "@4",
  "master_defs", "master_def", "master_file_def", "create", "@5", "@6",
  "@7", "@8", "clear_privileges", "sp_name", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@9",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@10", "@11", "sp_cursor_stmt",
  "@12", "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "opt_value", "sp_hcond", "sp_decl_idents", "sp_opt_default",
  "sp_proc_stmt", "@13", "@14", "@15", "@16", "@17", "sp_opt_fetch_noise",
  "sp_fetch_list", "sp_if", "@18", "@19", "@20", "sp_elseifs",
  "case_stmt_specification", "simple_case_stmt", "@21", "@22",
  "searched_case_stmt", "@23", "simple_when_clause_list",
  "searched_when_clause_list", "simple_when_clause", "@24", "@25",
  "searched_when_clause", "@26", "@27", "else_clause_opt",
  "sp_labeled_control", "@28", "sp_opt_label", "sp_labeled_block", "@29",
  "sp_unlabeled_block", "@30", "sp_block_content", "@31",
  "sp_unlabeled_control", "@32", "@33", "@34", "trg_action_time",
  "trg_event", "create2", "create2a", "@35", "create3", "@36", "@37",
  "create_select", "@38", "@39", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_type", "field_list",
  "field_list_item", "column_def", "key_def", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "@40",
  "type", "@41", "@42", "spatial_type", "char", "nchar", "varchar",
  "nvarchar", "int_type", "real_type", "float_options", "precision",
  "field_options", "field_opt_list", "field_option", "opt_field_length",
  "field_length", "opt_precision", "opt_attribute", "opt_attribute_list",
  "attribute", "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@43", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@44", "@45", "@46", "@47",
  "@48", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@49", "@50", "@51", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@52", "@53", "start",
  "start_transaction_opts", "slave_thread_opts", "@54",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@55", "backup", "@56", "checksum", "@57",
  "opt_checksum_type", "repair", "@58", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@59", "check", "@60",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@61", "opt_no_write_to_binlog", "rename", "@62", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@63", "preload_list",
  "preload_keys", "cache_keys_spec", "@64", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@65", "select_part2", "@66", "@67", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "bool_pri", "predicate", "bit_expr", "or", "and", "not", "not2",
  "comp_op", "all_or_any", "interval_expr", "simple_expr", "@68",
  "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@69", "udf_expr_list3", "udf_expr", "sum_expr", "@70",
  "@71", "@72", "variable", "@73", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@74",
  "cast_type", "opt_expr_list", "expr_list", "@75", "expr_list2",
  "ident_list_arg", "ident_list", "@76", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@77", "@78", "@79", "@80", "@81",
  "@82", "@83", "normal_join", "table_factor", "@84", "@85",
  "select_derived", "@86", "select_derived2", "@87", "@88",
  "get_select_lex", "select_derived_init", "opt_outer", "opt_for_join",
  "opt_key_definition", "key_usage_list", "@89", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_stamp",
  "interval_time_st", "date_time_type", "table_alias", "opt_table_alias",
  "opt_all", "where_clause", "@90", "having_clause", "@91", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@92", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@93", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@94",
  "select_var_list", "select_var_ident", "into", "@95", "into_destination",
  "@96", "do", "@97", "drop", "@98", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@99", "@100", "replace", "@101",
  "@102", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@103", "fields", "insert_values",
  "@104", "@105", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@106", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@107", "update", "@108", "@109",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@110", "single_multi", "@111", "@112",
  "@113", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@114", "show_param", "@115", "@116", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@117", "@118",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@119", "flush_options", "flush_option", "@120",
  "opt_table_list", "reset", "@121", "reset_options", "reset_option",
  "purge", "@122", "purge_options", "purge_option", "kill", "@123",
  "kill_option", "use", "load", "@124", "load_data", "@125", "@126",
  "@127", "@128", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@129", "opt_option", "option_value_list", "option_type_value",
  "@130", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@131",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@132", "handler", "@133", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@134",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@135", "@136", "@137",
  "@138", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@139", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@140",
  "union_opt", "union_order_or_limit", "@141", "order_or_limit",
  "union_option", "take_first_select", "subselect", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "definer_tail",
  "no_definer_tail", "definer_opt", "no_definer", "definer",
  "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@142", "view_list_opt",
  "view_list", "view_select", "@143", "view_select_aux",
  "view_check_option", "trigger_tail", "@144", "udf_tail", "sf_tail",
  "@145", "@146", "@147", "@148", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "xa", "xid", "begin_or_start", "opt_join_or_resume",
  "opt_one_phase", "opt_suspend", "@154", "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   570,   571,   572,   571,   571,   573,   573,   574,   574,
     575,   575,   575,   575,   575,   575,   575,   575,   575,   575,
     575,   575,   575,   575,   575,   575,   575,   575,   575,   575,
     575,   575,   575,   575,   575,   575,   575,   575,   575,   575,
     575,   575,   575,   575,   575,   575,   575,   575,   575,   575,
     575,   575,   575,   575,   575,   575,   575,   576,   577,   577,
     578,   579,   579,   581,   580,   582,   582,   583,   583,   584,
     586,   585,   588,   587,   589,   589,   590,   590,   590,   590,
     590,   590,   590,   590,   590,   590,   590,   590,   591,   591,
     591,   591,   593,   592,   594,   592,   595,   592,   596,   592,
     592,   597,   598,   598,   599,   599,   600,   600,   601,   601,
     601,   601,   601,   601,   601,   602,   602,   602,   603,   603,
     605,   604,   606,   606,   607,   607,   608,   608,   609,   609,
     610,   610,   611,   612,   613,   613,   614,   614,   615,   616,
     616,   616,   616,   617,   617,   618,   618,   619,   619,   621,
     620,   620,   622,   620,   620,   624,   623,   625,   625,   626,
     626,   627,   628,   628,   629,   629,   630,   630,   630,   630,
     630,   631,   631,   632,   632,   634,   633,   635,   633,   636,
     633,   633,   633,   637,   633,   633,   633,   633,   633,   633,
     638,   633,   633,   639,   639,   639,   640,   640,   642,   643,
     644,   641,   645,   645,   645,   646,   646,   648,   649,   647,
     651,   650,   652,   652,   653,   653,   655,   656,   654,   658,
     659,   657,   660,   660,   662,   661,   663,   663,   665,   664,
     667,   666,   669,   668,   670,   671,   672,   670,   673,   670,
     674,   674,   675,   675,   675,   676,   676,   676,   676,   677,
     678,   677,   679,   680,   679,   681,   679,   683,   684,   682,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   689,
     690,   690,   691,   692,   692,   693,   693,   694,   694,   695,
     695,   695,   696,   696,   696,   696,   696,   696,   696,   696,
     696,   696,   696,   696,   696,   696,   696,   696,   696,   696,
     696,   696,   696,   696,   696,   697,   698,   699,   700,   700,
     700,   700,   700,   700,   701,   701,   701,   702,   702,   702,
     703,   703,   704,   704,   704,   704,   705,   705,   706,   706,
     707,   707,   708,   708,   708,   708,   708,   709,   709,   710,
     711,   711,   712,   714,   713,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   715,
     716,   715,   717,   715,   715,   715,   718,   718,   718,   718,
     718,   718,   718,   718,   719,   720,   720,   721,   721,   722,
     722,   722,   722,   722,   723,   723,   723,   723,   723,   724,
     724,   724,   725,   725,   725,   726,   727,   727,   728,   728,
     729,   729,   729,   730,   730,   731,   731,   731,   731,   732,
     732,   733,   733,   734,   734,   735,   735,   735,   735,   735,
     735,   735,   735,   735,   735,   735,   736,   736,   737,   737,
     738,   738,   739,   739,   740,   740,   741,   741,   742,   742,
     743,   744,   744,   745,   745,   746,   746,   747,   747,   747,
     747,   747,   747,   748,   748,   749,   749,   749,   749,   750,
     750,   752,   751,   753,   753,   754,   754,   755,   755,   756,
     756,   757,   757,   757,   757,   757,   758,   758,   758,   758,
     758,   759,   759,   759,   760,   760,   761,   761,   762,   762,
     763,   763,   763,   764,   764,   764,   764,   765,   765,   765,
     766,   766,   766,   767,   767,   768,   768,   769,   769,   770,
     770,   771,   771,   773,   772,   774,   772,   775,   772,   776,
     772,   777,   772,   778,   778,   779,   779,   779,   779,   779,
     780,   781,   781,   781,   782,   781,   783,   784,   781,   781,
     781,   781,   781,   781,   781,   781,   781,   781,   781,   781,
     781,   781,   785,   785,   786,   786,   787,   787,   787,   788,
     788,   788,   789,   789,   789,   789,   791,   790,   790,   792,
     790,   790,   793,   794,   794,   796,   795,   797,   797,   798,
     798,   798,   799,   799,   800,   800,   802,   801,   804,   803,
     806,   805,   807,   807,   807,   809,   808,   810,   810,   811,
     811,   812,   812,   812,   814,   813,   816,   815,   817,   817,
     818,   818,   819,   819,   819,   819,   819,   819,   821,   820,
     822,   822,   822,   824,   823,   823,   825,   825,   826,   826,
     827,   828,   829,   829,   830,   831,   831,   833,   832,   834,
     834,   835,   837,   836,   838,   838,   839,   839,   840,   841,
     841,   842,   842,   844,   843,   846,   847,   845,   848,   848,
     848,   848,   848,   849,   849,   850,   850,   851,   851,   852,
     852,   852,   852,   852,   852,   852,   852,   852,   852,   853,
     853,   853,   854,   854,   854,   855,   856,   857,   858,   858,
     859,   859,   859,   859,   859,   860,   860,   861,   861,   861,
     861,   861,   861,   861,   861,   861,   861,   861,   862,   862,
     862,   862,   862,   862,   863,   863,   863,   863,   863,   863,
     863,   863,   863,   863,   863,   863,   863,   863,   864,   864,
     864,   864,   864,   864,   864,   864,   864,   864,   864,   864,
     864,   864,   864,   865,   865,   866,   866,   867,   867,   868,
     868,   869,   869,   869,   869,   869,   869,   870,   870,   871,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   873,
     872,   872,   872,   872,   872,   872,   872,   872,   872,   872,
     872,   872,   872,   872,   872,   874,   874,   874,   874,   874,
     874,   874,   874,   874,   874,   874,   874,   874,   874,   874,
     874,   874,   874,   874,   874,   874,   874,   874,   874,   874,
     874,   875,   875,   875,   876,   876,   878,   877,   879,   879,
     880,   881,   881,   881,   881,   881,   881,   881,   882,   883,
     881,   881,   881,   881,   881,   881,   881,   881,   881,   881,
     881,   881,   884,   881,   886,   885,   887,   887,   887,   888,
     888,   889,   889,   890,   890,   892,   891,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   894,   894,
     896,   895,   897,   897,   898,   898,   900,   899,   901,   901,
     902,   902,   903,   903,   904,   904,   905,   905,   906,   907,
     907,   908,   908,   909,   908,   910,   908,   911,   908,   908,
     912,   908,   913,   908,   908,   914,   908,   915,   908,   908,
     916,   916,   916,   918,   917,   919,   917,   917,   917,   921,
     920,   923,   924,   922,   925,   926,   927,   927,   928,   928,
     929,   929,   929,   929,   931,   930,   932,   932,   933,   933,
     933,   934,   934,   935,   935,   935,   935,   935,   935,   935,
     935,   935,   935,   935,   935,   936,   936,   937,   937,   937,
     937,   937,   937,   937,   937,   937,   938,   938,   938,   938,
     939,   939,   939,   940,   940,   941,   941,   942,   943,   942,
     944,   945,   944,   946,   946,   947,   947,   948,   948,   949,
     949,   949,   950,   951,   951,   952,   953,   953,   955,   954,
     956,   956,   957,   957,   957,   958,   958,   959,   959,   960,
     961,   961,   961,   962,   962,   962,   962,   963,   963,   964,
     964,   964,   964,   964,   964,   965,   965,   965,   965,   965,
     966,   967,   966,   968,   968,   969,   969,   970,   972,   971,
     973,   973,   974,   974,   976,   975,   978,   977,   977,   977,
     980,   979,   981,   982,   981,   981,   981,   981,   981,   981,
     981,   981,   983,   983,   984,   985,   985,   986,   986,   988,
     989,   987,   991,   992,   990,   993,   993,   993,   993,   994,
     994,   995,   995,   996,   997,   997,   997,   998,   997,   999,
     999,  1000,  1000,  1001,  1000,  1002,  1000,  1003,  1003,  1004,
    1004,  1005,  1006,  1006,  1007,  1007,  1009,  1008,  1010,  1010,
    1011,  1011,  1012,  1012,  1013,  1014,  1013,  1016,  1017,  1015,
    1018,  1018,  1019,  1020,  1020,  1021,  1022,  1022,  1024,  1023,
    1026,  1025,  1027,  1025,  1028,  1025,  1029,  1029,  1030,  1030,
    1031,  1031,  1032,  1032,  1033,  1033,  1033,  1034,  1035,  1035,
    1037,  1036,  1038,  1038,  1038,  1038,  1038,  1039,  1038,  1038,
    1038,  1038,  1038,  1040,  1038,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1038,  1041,  1041,  1042,  1042,
    1043,  1043,  1044,  1044,  1045,  1045,  1046,  1046,  1047,  1047,
    1048,  1048,  1049,  1049,  1049,  1051,  1050,  1052,  1050,  1053,
    1053,  1054,  1054,  1055,  1055,  1055,  1057,  1056,  1058,  1058,
    1060,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,  1059,
    1059,  1059,  1061,  1061,  1063,  1062,  1064,  1064,  1065,  1065,
    1065,  1067,  1066,  1068,  1069,  1069,  1071,  1070,  1072,  1072,
    1072,  1073,  1075,  1074,  1074,  1077,  1078,  1079,  1080,  1076,
    1076,  1081,  1081,  1082,  1082,  1082,  1083,  1083,  1083,  1084,
    1084,  1085,  1085,  1086,  1086,  1086,  1086,  1087,  1087,  1088,
    1088,  1089,  1089,  1090,  1090,  1091,  1091,  1091,  1092,  1092,
    1093,  1093,  1094,  1094,  1095,  1095,  1095,  1095,  1096,  1096,
    1096,  1097,  1098,  1098,  1098,  1099,  1099,  1099,  1099,  1099,
    1099,  1099,  1099,  1099,  1099,  1099,  1099,  1100,  1100,  1100,
    1100,  1100,  1101,  1101,  1102,  1102,  1103,  1104,  1104,  1105,
    1105,  1106,  1106,  1106,  1107,  1107,  1107,  1107,  1108,  1108,
    1108,  1109,  1110,  1110,  1111,  1112,  1113,  1114,  1114,  1115,
    1115,  1116,  1116,  1116,  1117,  1117,  1117,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,  1118,
    1118,  1118,  1118,  1118,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,  1119,
    1119,  1119,  1119,  1119,  1119,  1119,  1119,  1121,  1120,  1122,
    1122,  1123,  1123,  1125,  1124,  1126,  1126,  1126,  1126,  1127,
    1127,  1128,  1128,  1128,  1128,  1129,  1129,  1129,  1129,  1130,
    1130,  1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1132,
    1133,  1133,  1133,  1134,  1134,  1134,  1134,  1135,  1135,  1135,
    1136,  1136,  1136,  1136,  1136,  1138,  1137,  1139,  1139,  1140,
    1140,  1141,  1142,  1142,  1142,  1142,  1144,  1143,  1145,  1145,
    1146,  1145,  1147,  1147,  1148,  1148,  1149,  1149,  1149,  1149,
    1150,  1149,  1151,  1151,  1151,  1151,  1151,  1152,  1153,  1153,
    1153,  1153,  1154,  1155,  1155,  1155,  1156,  1156,  1157,  1157,
    1158,  1158,  1159,  1159,  1161,  1160,  1162,  1160,  1163,  1160,
    1164,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1165,  1165,  1166,  1166,  1167,
    1167,  1167,  1168,  1168,  1168,  1168,  1169,  1169,  1170,  1170,
    1171,  1171,  1171,  1172,  1172,  1173,  1173,  1174,  1175,  1175,
    1175,  1175,  1175,  1176,  1176,  1177,  1177,  1178,  1178,  1178,
    1178,  1178,  1180,  1179,  1181,  1181,  1182,  1182,  1182,  1183,
    1183,  1183,  1184,  1184,  1185,  1186,  1186,  1187,  1188,  1189,
    1189,  1191,  1190,  1192,  1192,  1192,  1194,  1193,  1195,  1195,
    1196,  1196,  1196,  1197,  1198,  1198,  1199,  1200,  1201,  1201,
    1201,  1202,  1202,  1202,  1202,  1203,  1203,  1203,  1203,  1203,
    1204,  1204,  1205,  1206,  1207,  1207,  1207,  1208,  1209,  1209,
    1209,  1210,  1210,  1211,  1211,  1211,  1213,  1212,  1214,  1214,
    1215,  1215,  1217,  1216,  1218,  1218,  1219,  1219,  1219,  1219,
    1221,  1220,  1222,  1222,  1224,  1225,  1226,  1227,  1228,  1223,
    1230,  1231,  1232,  1233,  1229,  1234,  1234,  1234,  1234,  1234,
    1234,  1235,  1235,  1235,  1236,  1236,  1237,  1237,  1237,  1238,
    1238,  1239,  1240,  1239,  1241,  1241
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     1,     1,
       4,     1,     2,     0,     4,     0,     2,     3,     1,     2,
       0,     3,     0,     5,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     3,     3,
       3,     3,     0,     7,     0,    11,     0,     6,     0,     3,
       4,     0,     3,     1,     0,     2,     0,     2,     2,     2,
       2,     2,     3,     3,     1,     1,     1,     2,     3,     3,
       0,     4,     0,     3,     0,     1,     3,     1,     0,     1,
       3,     1,     0,     3,     0,     1,     3,     1,     4,     0,
       1,     1,     1,     0,     3,     2,     3,     0,     3,     0,
       5,     5,     0,     7,     5,     0,     2,     1,     1,     1,
       3,     1,     1,     3,     0,     1,     1,     1,     1,     2,
       1,     1,     3,     0,     2,     0,     2,     0,     3,     0,
       5,     1,     1,     0,     2,     1,     1,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       0,     2,     0,     5,     4,     0,     0,     8,     0,     7,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     4,
       0,     4,     0,     0,     5,     0,     7,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     1,
       1,     3,     4,     4,     3,     4,     4,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     3,     1,     1,
       2,     2,     7,     8,     8,     2,     2,     0,     1,     2,
       0,     1,     2,     0,     4,     3,     3,     3,     1,     2,
       1,     1,     3,     2,     3,     2,     2,     1,     3,     3,
       2,     3,     1,     1,     2,     1,     1,     2,     1,     1,
       1,     2,     3,     2,     3,     2,     2,     3,     3,     3,
       0,     6,     0,     6,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     2,
       1,     2,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     0,     1,     1,     5,     0,     1,     2,     1,
       1,     1,     1,     0,     1,     3,     3,     3,     3,     0,
       1,     0,     1,     2,     1,     1,     2,     2,     4,     1,
       3,     2,     1,     2,     2,     2,     2,     1,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     0,     1,     0,     2,     1,
       2,     3,     2,     0,     1,     0,     1,     1,     2,     0,
       1,     0,     4,     1,     4,     3,     1,     0,     1,     2,
       1,     3,     3,     2,     2,     2,     1,     1,     2,     2,
       2,     1,     2,     2,     2,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     0,     2,     2,
       1,     1,     1,     4,     2,     1,     4,     0,     1,     0,
       2,     1,     3,     0,     6,     0,     5,     0,     5,     0,
       5,     0,    11,     0,     1,     0,     2,     2,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       2,     1,     0,     1,     1,     1,     0,     5,     3,     0,
       5,     3,     3,     0,     3,     0,     2,     1,     3,     0,
       1,     1,     0,     2,     1,     3,     0,     6,     0,     6,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     0,     5,     0,     1,
       1,     2,     1,     1,     1,     1,     1,     2,     0,     5,
       0,     1,     1,     0,     4,     4,     3,     5,     1,     3,
       3,     5,     1,     3,     2,     1,     1,     0,     6,     1,
       3,     3,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     0,     3,     0,     0,     6,     2,     1,
       1,     2,     2,     8,     4,     0,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     4,     3,     1,     1,     4,     0,     0,     1,     1,
       0,     2,     2,     1,     1,     0,     2,     3,     3,     3,
       2,     3,     4,     3,     4,     3,     4,     1,     3,     4,
       3,     3,     6,     1,     5,     6,     5,     7,     6,     8,
       5,     6,     4,     4,     5,     3,     4,     1,     3,     3,
       3,     3,     3,     3,     4,     4,     3,     3,     3,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     3,     2,     2,     2,
       2,     3,     3,     5,     6,     4,     4,     7,     4,     2,
       6,     5,     6,     6,     4,     4,     3,     4,     6,     8,
       6,     8,     6,     4,     6,     4,     6,     4,     4,     4,
       4,     6,     8,     2,     2,     4,     2,     7,     7,     3,
       4,     4,     6,     6,     4,     6,     6,     6,     4,     6,
       4,     6,     8,    10,    12,     6,     4,     6,     6,     1,
       6,     4,     8,    10,     4,     1,     3,     4,     6,     6,
       8,     6,     6,     4,     6,     6,     8,     4,     4,     6,
       4,     2,     4,     4,     4,     6,     4,     4,     3,     8,
       6,     4,     6,     3,     6,     8,     4,     8,     6,     8,
       6,     8,     2,     4,     4,     4,     6,     8,     8,     4,
       7,     7,     7,     6,     6,     6,     6,     6,     6,     0,
       5,    10,     3,     4,     3,     2,     2,     2,     4,     6,
       4,     4,     6,     6,     6,     6,     4,     6,     4,     6,
       4,     4,     4,     4,     6,     4,     6,     4,     6,     4,
       4,     6,     4,     6,     4,     6,     4,     4,     6,     4,
       6,     0,     3,     3,     0,     1,     0,     2,     1,     3,
       4,     4,     5,     4,     4,     4,     5,     4,     0,     0,
       7,    10,     4,     5,     4,     5,     4,     4,     4,     4,
       4,     5,     0,     8,     0,     3,     3,     1,     4,     0,
       1,     0,     2,     0,     1,     0,     3,     2,     3,     2,
       1,     2,     1,     2,     1,     1,     1,     2,     0,     1,
       0,     2,     1,     3,     1,     3,     0,     2,     1,     3,
       0,     1,     0,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     3,     0,     6,     0,     6,     0,     8,     4,
       0,     8,     0,    10,     6,     0,     8,     0,    10,     6,
       1,     2,     2,     0,     4,     0,    11,     3,     6,     0,
       3,     0,     0,     5,     0,     1,     0,     1,     0,     2,
       0,     2,     2,     2,     0,     6,     0,     1,     3,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     0,     2,     0,     1,     0,     0,     3,
       0,     0,     3,     2,     0,     0,     4,     4,     2,     0,
       2,     2,     3,     3,     1,     2,     0,     1,     0,     4,
       4,     2,     0,     1,     1,     0,     1,     0,     1,     2,
       1,     3,     3,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     0,     6,     0,     1,     3,     1,     2,     0,     2,
       3,     1,     2,     1,     0,     3,     0,     5,     2,     1,
       0,     3,     6,     0,     6,     4,     6,     4,     4,     4,
       5,     4,     1,     3,     1,     0,     2,     0,     1,     0,
       0,     8,     0,     0,     6,     0,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     3,     4,     0,     3,     3,
       1,     2,     2,     0,     3,     0,     5,     3,     1,     3,
       1,     3,     1,     1,     0,     1,     0,     4,     0,     1,
       3,     1,     1,     1,     0,     0,     6,     0,     0,    11,
       3,     1,     3,     3,     1,     3,     0,     1,     0,     4,
       0,     6,     0,     5,     0,     6,     1,     3,     3,     5,
       0,     2,     0,     2,     1,     1,     1,     3,     0,     1,
       0,     3,     2,     4,     4,     4,     4,     0,     4,     6,
      16,     2,     2,     0,     6,     5,     2,     2,     2,     1,
       5,     5,     2,     2,     3,     2,     2,     2,     3,     2,
       2,     2,     1,     1,     3,     4,     3,     3,     2,     2,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       0,     1,     0,     2,     0,     1,     1,     1,     0,     2,
       0,     2,     0,     2,     2,     0,     4,     0,     4,     1,
       1,     0,     1,     0,     1,     1,     0,     4,     3,     1,
       0,     3,     4,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     0,     3,     3,     1,     1,     1,
       2,     0,     3,     3,     2,     2,     0,     4,     0,     1,
       1,     2,     0,     4,     5,     0,     0,     0,     0,    18,
       2,     0,     1,     0,     1,     1,     0,     1,     1,     0,
       2,     2,     1,     3,     4,     3,     3,     0,     2,     2,
       1,     3,     3,     0,     3,     0,     3,     2,     3,     1,
       1,     2,     0,     2,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     5,     1,     1,     1,     1,
       1,     3,     4,     5,     1,     5,     3,     2,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     0,
       1,     1,     3,     0,     2,     1,     1,     1,     1,     0,
       1,     0,     1,     1,     1,     0,     2,     2,     2,     1,
       2,     4,     5,     4,     6,     2,     3,     3,     3,     5,
       1,     3,     3,     2,     2,     2,     1,     1,     4,     4,
       1,     1,     1,     1,     1,     0,     4,     1,     1,     1,
       3,     3,     1,     1,     2,     2,     0,     3,     4,     3,
       0,     7,     1,     2,     1,     1,     1,     1,     1,     1,
       0,     5,     1,     1,     1,     1,     1,     3,     6,     6,
       6,     7,     3,     8,     8,     8,     0,     1,     1,     2,
       0,     1,     1,     3,     0,     3,     0,     3,     0,     3,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     3,     2,     2,     2,
       2,     2,     2,     2,     2,     0,     1,     3,     1,     2,
       2,     2,     1,     3,     3,     1,     1,     3,     1,     3,
       4,     5,     1,     0,     3,     3,     1,     1,     0,     2,
       2,     2,     2,     0,     2,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     2,     2,     1,
       0,     1,     1,     0,     5,     6,     0,     0,     2,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     1,     2,     1,     2,     3,     3,
       3,     0,     1,     0,     3,     3,     0,     8,     0,     3,
       1,     3,     0,     2,     3,     5,     0,     3,     4,     4,
       0,    14,     8,     7,     0,     0,     0,     0,     0,    15,
       0,     0,     0,     0,    12,     4,     4,     3,     4,     3,
       2,     1,     3,     5,     1,     1,     0,     1,     1,     0,
       2,     0,     0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,     2,  1981,   640,     0,  1922,     0,     0,     0,     0,
       0,  1924,    98,    58,  1268,  1359,  1360,  1190,  1207,     0,
     640,   101,     0,    70,  1209,  1396,     0,     0,   640,     0,
    1391,     0,     0,   640,  1212,  1384,     0,   101,  1924,     0,
     675,  1759,  1290,     0,     0,     0,  1288,  1816,  1257,     0,
       0,     0,     0,     3,     8,    19,     0,    36,    24,    28,
      14,    18,    13,    10,    50,    51,    43,    12,    16,    40,
      11,    15,    33,    39,    34,    35,    47,   668,    22,    23,
      29,    41,    54,    20,    52,    49,    21,  1361,    25,    42,
      37,    30,    55,    31,    48,    32,    53,    27,    44,    26,
       9,    17,    45,    46,    38,    56,     0,   543,     0,   575,
       0,     0,  1982,  1972,   642,   641,     0,  1808,  1807,   608,
    1924,     0,  1544,  1545,  1546,  1547,  1548,  1549,  1550,  1508,
    1551,  1552,  1553,  1509,  1510,  1554,  1555,  1556,  1558,  1557,
    1559,  1511,  1512,  1560,  1561,  1562,  1513,  1514,  1563,  1564,
    1515,  1565,  1566,  1567,  1516,  1568,  1517,  1569,  1570,  1571,
    1572,  1573,  1518,  1574,  1575,  1576,  1577,  1578,  1519,  1579,
    1580,  1581,  1582,  1597,  1583,  1520,  1584,  1585,  1586,  1598,
    1521,  1589,  1588,  1587,  1590,  1591,  1592,  1522,  1593,  1594,
    1595,  1600,  1601,  1602,  1523,  1596,  1603,  1599,  1742,  1605,
    1604,  1606,  1608,  1607,  1524,  1609,  1525,  1610,  1611,  1492,
    1612,  1493,  1614,  1615,  1618,  1619,  1613,  1616,  1617,  1526,
    1621,  1622,  1623,  1624,  1625,  1626,  1627,  1637,  1630,  1632,
    1633,  1635,  1631,  1636,  1640,  1639,  1641,  1642,  1643,  1638,
    1629,  1634,  1644,  1645,  1628,  1646,  1647,  1648,  1649,  1650,
    1651,  1652,  1653,  1655,  1654,  1656,  1657,  1658,  1659,  1660,
    1662,  1661,  1663,  1664,  1665,  1667,  1666,  1668,  1527,  1669,
    1670,  1671,  1672,  1673,  1528,  1674,  1675,  1676,  1677,  1678,
    1679,  1529,  1680,  1681,  1682,  1683,  1684,  1685,  1686,  1687,
    1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1620,  1696,
    1530,  1697,  1698,  1531,  1699,  1532,  1700,  1701,  1533,  1702,
    1703,  1704,  1705,  1706,  1707,  1534,  1708,  1535,  1710,  1709,
    1711,  1713,  1714,  1536,  1712,  1537,  1715,  1716,  1718,  1717,
    1719,  1720,  1538,  1721,  1539,  1722,  1723,  1724,  1725,  1726,
    1727,  1728,  1729,  1730,  1731,  1732,  1735,  1736,  1737,  1738,
    1733,  1734,  1540,  1739,  1740,  1741,  1743,  1744,  1541,  1745,
    1746,  1543,  1747,  1748,  1751,  1749,  1750,  1752,  1753,  1754,
    1755,  1542,  1756,   120,  1497,   103,  1498,  1507,     0,   610,
     626,  1925,  1926,   273,   515,   516,   272,   514,   101,  1972,
       0,   269,   270,     0,  1282,  1010,  1205,  1205,     0,  1205,
    1208,  1205,   101,  1205,     0,    63,  1366,     0,     0,     0,
       0,  1491,     0,  1215,  1398,  1402,     0,     0,  1805,     0,
       0,     0,     0,   101,   643,     0,  1266,     0,   606,     0,
    1926,  1937,   669,   673,   685,  1760,  1757,  1344,   595,   595,
     595,   593,   595,  1289,     0,     0,  1266,  1401,  2024,     0,
       0,     0,  2020,     0,  2025,     0,   675,     0,     0,     1,
       5,     0,     0,  1594,  1357,  1355,  1488,     0,   535,   544,
     539,   537,     0,     0,  1983,  1970,  1971,   624,     0,  1923,
       0,   652,   662,   122,     0,    72,     0,     0,     0,  1929,
       0,     0,     0,     0,    99,   706,   706,  1972,  1974,  1976,
     273,   271,     0,  1286,  1285,  1284,     0,  1282,  1191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1205,    65,
       0,  1850,  1865,  1866,  1862,  1867,  1868,  1872,     0,  1864,
    1856,     0,  1871,  1860,  1869,     0,  1854,     0,  1870,  1875,
    1858,  1863,  1842,     0,  1848,  1852,  1490,  1110,  1819,  1820,
       0,  1503,  1494,  1502,  1501,    71,  1217,  1218,  1216,   574,
    1399,  1400,     0,  1413,     0,     0,     0,   638,     0,  1339,
    1338,     0,  1392,  1938,     0,     0,   615,  1220,  1267,     0,
    1219,  1389,     0,  1388,  1385,  1387,     0,  1850,  1837,     0,
    1932,  1929,  1939,   698,   691,   690,   693,   694,   697,   695,
     696,   692,   689,   706,   686,   688,  1763,     0,     0,   449,
       0,  1352,     0,     0,     0,  1352,     0,  1145,  1345,     0,
    1772,  1323,   512,   511,     0,   510,  1773,  1322,  1338,     0,
       0,     0,  1309,     0,  1774,     0,  1341,     0,  1145,  1352,
       0,  1291,     0,     0,     0,     0,   589,   599,   591,   586,
       0,   592,   588,  1287,  1204,  1817,   574,  1450,  1449,  1495,
    2021,  1448,  2029,  2031,  2017,  2019,  2026,   671,     0,  1943,
       6,    57,     0,  1363,  1979,  1980,  1978,   465,   104,   104,
     533,     0,     0,     0,     0,     0,  1202,     0,     0,   654,
     664,   124,   121,   102,     0,   612,   628,  1928,     0,     0,
    1930,  1934,   768,   767,     0,    96,   715,  1504,  1902,   100,
    1898,  1977,   706,   706,   706,     0,  1959,     0,  1965,  1966,
    1969,  1968,  1967,     0,  1958,  1961,  1962,  1964,  1963,  1983,
    1975,     0,   517,     0,  1269,  1272,  1276,  1280,  1283,  1545,
    1508,     0,  1553,     0,     0,  1461,     0,     0,     0,     0,
    1513,     0,     0,  1566,     0,     0,  1518,     0,     0,     0,
     715,   715,   715,     0,     0,     0,  1577,  1578,  1470,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1458,
       0,  1471,     0,     0,     0,     0,     0,     0,     0,  1605,
       0,     0,  1606,     0,     0,     0,  1460,  1611,     0,     0,
       0,     0,     0,     0,     0,  1624,     0,     0,  1468,     0,
       0,  1016,     0,  1650,  1652,     0,     0,     0,  1656,     0,
       0,  1657,  1658,  1659,  1445,   770,     0,   715,  1457,  1467,
    1671,  1676,  1451,     0,  1678,     0,  1679,     0,  1684,     0,
       0,     0,     0,     0,     0,  1706,  1708,     0,     0,  1724,
       0,     0,     0,   715,  1444,  1735,  1736,  1737,  1738,     0,
    1459,  1540,  1469,     0,     0,     0,  1747,   715,   715,   715,
       0,     0,     0,  1753,     0,  1756,  1020,     0,     0,     0,
       0,   769,     0,   984,     0,  1012,   727,   733,   747,     0,
     855,   762,   849,   785,   784,  1011,  1455,   783,   782,  1456,
     780,  1478,  1497,  1477,  1206,  1195,  1197,     0,  1198,  1201,
    1896,  1199,   576,     0,     0,    64,  1380,  1374,  1376,  1379,
    1375,     0,  1381,  1378,  1377,  1808,  1367,  1369,  1370,  1851,
    1849,  1883,  1882,     0,  1884,  1880,  1873,  1903,  1877,  1903,
    1879,  1878,  1903,  1874,  1881,  1903,  1846,     0,  1111,  1112,
       0,  1818,     0,  1489,     0,  1397,  1414,     0,  1415,  1403,
    1411,   657,     0,  1110,  1806,  1809,     0,     0,    60,    61,
       0,   645,     0,   644,   648,     0,     0,     0,  1223,  1213,
    1222,  1390,     0,     0,  1849,  1846,  1933,     0,  1935,  1950,
     674,  1940,   704,   676,   703,     0,   687,  1758,  1761,  1769,
    1321,  1348,   448,     0,     0,  1320,  1306,     0,   273,     0,
       0,     0,     0,  1292,  1297,   307,     0,  1313,  1146,     0,
    1352,     0,  1315,  1328,  1316,     0,  1342,     0,  1352,  1302,
    1329,  1342,  1307,  1312,  1319,  1346,  1347,     0,  1301,  1308,
       0,  1317,  1342,  1342,  1352,  1352,   602,   601,   600,   596,
     597,   602,     0,  1053,     0,     0,  2018,  2032,  2016,  2027,
    2028,  2015,   672,  1944,   670,  1945,     0,     7,     4,  1358,
    1356,  1364,  1365,   466,   465,   264,   267,   266,     0,   540,
     538,   465,  1973,     0,     0,   625,     0,     0,   656,   651,
     655,   653,   507,   506,   509,     0,   663,     0,   125,   127,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    73,    74,    87,   614,   613,
     611,   636,   635,   633,     0,   634,   632,   627,   629,   630,
    1927,  1931,   274,   465,     0,  1506,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1960,    92,     0,     0,     0,
    1274,  1270,  1280,     0,     0,     0,  1110,     0,     0,     0,
    1115,     0,   799,  1115,  1115,  1115,     0,     0,  1010,  1010,
       0,  1010,     0,     0,     0,     0,  1115,   823,   826,     0,
     824,     0,     0,     0,     0,     0,  1464,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1010,     0,     0,     0,
       0,   989,     0,     0,     0,     0,   779,     0,     0,     0,
       0,  1010,     0,     0,     0,     0,  1016,     0,  1014,     0,
    1115,     0,     0,  1115,     0,     0,     0,     0,     0,  1010,
    1010,  1010,   720,     0,   871,     0,     0,     0,     0,     0,
    1010,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1115,  1115,     0,     0,     0,  1115,     0,   892,     0,
    1466,     0,     0,     0,  1465,     0,     0,  1463,  1462,  1446,
       0,     0,     0,   915,   917,   916,  1115,     0,  1115,     0,
       0,     0,  1021,     0,   788,   787,   789,  1956,     0,     0,
       0,     0,     0,     0,   766,   765,   764,   763,     0,     0,
       0,   771,     0,   772,   773,     0,   774,   775,   776,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   790,  1084,
    1085,  1086,  1087,  1097,  1088,  1089,  1090,  1099,  1104,  1091,
    1092,  1100,  1101,  1102,  1093,  1103,  1098,  1094,  1105,     0,
    1083,     0,     0,     0,  1447,   909,     0,     0,  1193,     0,
     578,   577,  1200,   576,     0,    66,    68,  1373,     0,     0,
    1382,  1876,     0,  1857,  1861,  1855,  1859,     0,     0,  1847,
       0,  1853,  1114,  1601,  1666,     0,  1117,  1822,  1210,  1410,
    1412,     0,     0,  1404,     0,     0,   639,    62,     0,     0,
    1393,     0,     0,     0,     0,   617,  1221,     0,  1386,     0,
       0,     0,     0,     0,  1936,  1952,  1951,  1941,   706,  1136,
     707,   709,   708,  1477,  1763,  1766,  1767,  1770,  1768,     0,
    1765,  1764,  1779,     0,  1350,  1353,  1354,     0,     0,  1331,
    1330,  1326,  1327,     0,  1155,  1156,  1154,  1149,  1150,  1153,
    1335,  1333,  1324,     0,  1352,     0,  1334,  1332,  1352,  1342,
       0,  1352,  1352,  1314,  1318,     0,   590,   599,   587,   594,
    1065,  1064,     0,  1029,     0,  1028,  1027,  1026,     0,  1064,
    2022,  2030,  2034,     0,  1145,  1949,  1947,   265,  1244,  1244,
       0,     0,     0,     0,     0,     0,     0,   105,   114,   572,
     572,  1244,  1244,   572,  1244,  1244,  1244,     0,     0,  1244,
       0,     0,   572,     0,  1244,   570,     0,     0,  1244,  1244,
    1244,   572,     0,  1244,  1244,  1244,  1244,  1244,   582,  1244,
    1244,  1244,   569,   277,   299,   300,   534,     0,   548,   571,
    1984,  1985,   541,   609,  1203,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   637,   631,    97,   465,   716,  1505,
       0,  1899,     0,  2010,     0,     0,   103,  1986,   275,   520,
     522,   521,   519,   518,     0,     0,  1117,     0,  1277,  1053,
    1281,  1280,  1278,     0,     0,     0,  1116,  1115,     0,   995,
    1163,  1164,  1160,  1161,  1159,  1162,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     968,     0,   995,     0,   829,     0,     0,     0,     0,     0,
       0,  1477,     0,     0,     0,     0,     0,  1956,     0,     0,
       0,     0,     0,     0,   806,     0,     0,     0,     0,     0,
       0,     0,  1108,  1106,  1109,  1107,     0,     0,   990,   982,
       0,     0,     0,     0,   856,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1017,  1018,  1115,     0,
       0,     0,  1115,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   878,     0,     0,     0,     0,     0,   883,     0,     0,
       0,     0,     0,     0,     0,  1115,     0,     0,     0,  1096,
       0,  1095,     0,     0,     0,     0,     0,     0,     0,     0,
     912,     0,   914,     0,     0,  1480,  1479,     0,     0,     0,
       0,     0,  1022,   675,     0,   792,  1010,   791,     0,  1775,
     985,   987,     0,   718,   717,   719,   730,   723,   728,   721,
     725,     0,   777,  1550,   731,     0,   759,     0,  1124,   760,
     745,   750,   751,     0,     0,   748,   749,   753,   855,   752,
     855,   756,   757,   758,   761,     0,     0,     0,     0,     0,
     781,   786,  1013,   956,  1481,  1196,  1194,  1897,  1192,    69,
       0,     0,  1368,  1383,  1371,  1907,     0,  1906,  1892,  1895,
    1488,     0,     0,     0,  1832,  1826,  1833,  1835,  1829,  1834,
    1836,  1827,  1828,  1823,  1830,  1118,  1147,     0,     0,   658,
     659,   662,     0,  1812,  1813,  1811,  1810,  1395,  1394,     0,
     646,   649,   650,   622,   621,   623,   616,   618,   619,   257,
    1227,     0,     0,     0,  1233,  1214,  1224,   607,     0,     0,
       0,     0,     0,   702,  1053,  1184,   699,   680,  1147,  1137,
     679,   710,     0,  1762,     0,  1733,  1790,     0,     0,     0,
       0,     0,  1780,  1349,     0,  1303,     0,  1325,  1337,  1336,
    1298,     0,     0,     0,  1296,  1343,  1295,  1117,  1342,  1293,
    1294,   604,   603,   598,  1064,  1053,     0,     0,  1050,  1066,
       0,  1066,  1053,  1053,     0,  1053,  1110,  1061,     0,     0,
    2033,  1138,  1948,  1242,  1243,  1245,     0,     0,   108,   111,
     109,     0,   110,     0,     0,   573,   527,   508,   508,   552,
       0,   337,   527,   501,   550,     0,     0,     0,     0,     0,
       0,     0,     0,  1244,     0,   563,   546,     0,     0,     0,
       0,   564,     0,   547,  1244,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   585,   584,   583,     0,     0,
       0,     0,   278,   465,   340,     0,   579,   337,   343,  1484,
    1988,  1080,     0,  1079,   126,    80,    76,    88,  1168,  1169,
    1167,  1165,  1166,    89,    78,    79,    83,    82,    84,    85,
      86,    81,    77,    90,    91,    75,     0,  1900,     0,     0,
     241,   240,     0,  2004,     0,  1988,     0,   340,    93,  1416,
     276,   279,    94,  1053,  1136,  1280,  1117,     0,  1110,     0,
     798,   813,     0,     0,   961,     0,     0,   963,   964,   965,
       0,   817,     0,   815,   818,   819,   820,  1010,     0,     0,
       0,     0,  1010,   967,     0,   825,     0,     0,   830,   831,
       0,   804,     0,   838,     0,   840,     0,  1010,     0,   834,
       0,   795,     0,     0,  1010,     0,   846,     0,   807,     0,
       0,   947,     0,   930,   926,     0,   928,     0,     0,  1010,
    1010,     0,   851,     0,     0,   857,  1010,     0,   949,     0,
     931,     0,   863,     0,  1010,     0,  1015,     0,     0,     0,
     974,   867,   868,     0,   972,   933,     0,     0,   870,   935,
       0,   937,     0,   932,   939,   940,   872,   874,   873,   942,
       0,     0,   944,     0,   946,     0,   876,   877,     0,     0,
       0,   881,     0,  1010,   886,   976,   978,     0,     0,     0,
       0,     0,   980,   893,   895,     0,     0,     0,   894,     0,
       0,     0,     0,     0,     0,     0,   899,     0,     0,   913,
     979,   805,   977,   918,     0,   921,     0,   920,     0,     0,
       0,     0,  1953,  1953,     0,   796,     0,     0,     0,     0,
       0,  1482,   724,   729,   722,   726,     0,     0,     0,     0,
     743,   742,     0,   755,   754,     0,  1124,   746,     0,   854,
       0,   955,   706,  1010,     0,    67,  1372,  1904,     0,     0,
       0,     0,     0,     0,     0,     0,  1821,  1148,  1254,  1496,
    1405,     0,   666,  1814,  1815,     0,   620,   685,     0,  1246,
    1231,  1238,  1232,     0,     0,     0,  1230,  1473,  1472,  1479,
    1939,     0,     0,     0,     0,  1942,  1117,  1117,  1178,     0,
       0,   677,   682,   678,   681,     0,   705,   714,   713,  1474,
    1481,     0,     0,     0,     0,   451,   453,   452,   461,     0,
     450,     0,     0,  1775,     0,   457,   459,   458,  1785,   456,
    1351,  1145,  1311,  1310,  1152,  1151,     0,  1305,  1352,     0,
    1946,  1059,     0,  1052,  1051,  1067,     0,  1053,  1066,  1066,
       0,  1032,  1031,  1258,  1261,     0,  1030,  1070,  1057,   685,
    2023,  2035,     0,   464,   463,   306,   460,   305,   113,   112,
     118,   119,   342,   528,   502,   503,     0,     0,     0,   508,
     336,   527,   335,   338,   517,     0,   289,   286,   554,   292,
     288,   304,     0,     0,   293,   527,   561,   562,   576,   282,
       0,   318,   319,   317,   301,   284,   285,   556,  1132,  1134,
    1142,   291,   290,   287,   296,   297,   315,   314,   295,   316,
     567,   313,   311,   308,   310,   309,   312,   294,   283,  1382,
     549,     0,   326,   328,   329,  1487,     0,   581,   551,     0,
     330,   331,     0,     0,     0,     0,   665,     0,  1901,     0,
    2011,   244,   242,   243,     0,   128,   324,   325,   323,   322,
       0,     0,   247,     0,   245,     0,     0,  1418,  1417,   246,
     260,   465,   280,     0,  1117,  1157,  1273,  1279,     0,     0,
       0,   962,   996,     0,   423,   423,  1006,  1004,   412,   423,
    1000,  1005,  1002,     0,     0,     0,     0,     0,     0,     0,
     969,   966,     0,     0,     0,  1481,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   993,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   951,  1019,   975,   973,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   981,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1023,   801,  1957,  1957,   793,  1776,  1777,
    1778,   529,   986,     0,   736,  1010,   734,  1123,   740,     0,
       0,   744,     0,   910,     0,   957,   958,     0,  1009,  1483,
    1905,  1894,  1893,  1908,  1908,  1908,     0,  1119,     0,  1211,
    1416,   660,     0,   661,   647,   706,  1228,  1240,     0,  1248,
       0,     0,  1225,  1235,     0,     0,     0,  1234,     0,  1839,
    1840,  1838,  1147,  1125,     0,     0,  1189,     0,  1185,   700,
       0,   712,   711,     0,  1792,     0,  1791,  1803,  1804,  1801,
    1802,  1800,  1781,     0,  1787,  1786,     0,     0,     0,  1797,
    1788,     0,     0,  1304,     0,  1299,   605,     0,  1053,  1066,
    1053,  1039,     0,     0,  1053,  1035,  1033,  1037,     0,  1117,
       0,     0,     0,     0,  1054,   706,  1476,  1139,  1142,   339,
     527,   504,   505,   517,     0,     0,     0,     0,   461,   302,
     560,   559,   303,     0,     0,  1143,  1144,  1135,     0,   553,
     340,   580,   481,   408,   357,   348,   423,   351,   350,   394,
     365,   362,   412,   410,   380,   412,   412,   387,   386,   404,
     390,   370,   467,   467,   369,   407,   467,   391,   389,   393,
       0,   395,   412,   400,   388,   392,   409,   385,   382,   406,
     423,   423,   363,   366,   405,   467,     0,   398,   423,   431,
     368,   467,   473,     0,     0,   423,   429,  1486,  1990,     0,
    1992,  1078,     0,   139,   706,     0,   129,   131,   132,     0,
    1992,     0,   250,   275,   261,     0,   281,     0,  1275,     0,
    1271,   779,   810,   814,   923,     0,   997,   424,   467,     0,
    1007,   414,   413,   999,  1001,  1003,   800,   816,   821,   925,
     803,   802,     0,     0,     0,     0,   836,   839,   841,   832,
     837,   835,     0,   924,   848,   845,   847,   808,     0,   948,
     927,   929,   850,   861,   991,   994,     0,     0,     0,   862,
     858,   950,   859,     0,   864,   833,   865,     0,     0,     0,
       0,   934,   869,   936,   938,   943,   941,   945,   875,   812,
       0,   880,   882,   794,   779,   884,     0,   890,   888,     0,
       0,   896,     0,     0,   905,     0,   903,     0,   904,     0,
     906,   907,     0,   919,   922,  1024,     0,  1954,     0,     0,
     988,   732,     0,   738,  1010,   735,   741,   707,   706,   908,
       0,  1913,  1913,  1913,  1253,  1252,     0,  1251,  1255,     0,
     667,   258,     0,     0,     0,  1249,  1237,  1943,  1226,  1229,
    1481,  1841,   684,     0,  1120,  1188,  1186,     0,  1179,  1181,
    1183,     0,  1475,     0,     0,  1796,  1782,   462,     0,     0,
       0,     0,  1783,     0,  1110,  1060,     0,     0,  1026,  1053,
    1053,     0,  1026,     0,     0,     0,  1260,  1136,  1262,  1068,
    1072,  1073,  1071,  1062,     0,  1141,     0,     0,     0,   566,
       0,   579,   568,   431,  1133,   298,   327,   487,   356,   349,
     367,   416,   411,     0,   416,   416,   473,   475,   469,   473,
       0,   376,   394,   371,     0,   467,   384,   375,   396,   399,
     401,   403,   416,     0,   467,   364,   373,   360,   416,   439,
       0,     0,     0,   435,     0,   480,     0,   442,   344,   432,
     434,     0,     0,   397,   467,   353,   474,   473,   355,   467,
     473,   416,     0,   430,   416,     0,  1989,     0,  1996,     0,
       0,   142,   140,   141,     0,   135,   137,   132,     0,  2005,
       0,     0,  2003,  1996,   248,  1943,  1416,     0,   253,     0,
    1142,   525,  1158,     0,     0,     0,     0,     0,   998,     0,
       0,   970,   827,   828,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   797,     0,     0,     0,     0,
       0,     0,     0,   902,   900,   901,     0,  1025,  1955,   530,
     737,     0,   710,   959,     0,     0,  1912,  1910,     0,  1911,
    1909,  1885,     0,  1844,  1845,  1843,  1831,     0,     0,  1406,
    1147,  1239,  1241,  1247,  1236,     0,  1121,  1136,  1419,  1182,
       0,   701,  1794,  1793,  1795,  1789,     0,     0,     0,     0,
    1058,  1053,  1040,     0,  1044,  1049,  1045,     0,  1036,  1034,
       0,  1157,     0,  1074,  1147,  1142,     0,     0,     0,     0,
       0,     0,     0,     0,   565,  1452,   555,   557,     0,     0,
       0,   482,   483,   488,   490,   420,   421,   422,   377,   417,
     419,     0,   379,   347,   468,   476,   477,     0,   472,   470,
     473,   372,   402,   378,     0,   374,   361,   445,   444,   715,
     437,   447,     0,     0,   443,   433,   441,   436,   352,   354,
     358,   359,   345,     0,   346,  1485,  1991,     0,   542,   706,
     706,  1993,  2002,  2012,   139,     0,     0,     0,   130,   133,
    1987,   251,   249,     0,  1939,    95,     0,   524,     0,   811,
     427,   425,   428,   426,     0,   822,   842,     0,   809,   992,
     983,  1115,   852,     0,   860,   866,   953,   952,   879,   885,
     889,   887,   891,   897,   898,  1010,   739,   960,  1891,  1890,
    1889,  1886,     0,     0,     0,     0,     0,     0,  1914,  1916,
    1250,     0,     0,   259,   699,   320,  1129,  1142,     0,  1147,
       0,  1427,  1180,  1799,  1798,  1784,     0,     0,     0,     0,
       0,     0,     0,  1081,  1259,  1069,     0,  1063,  1140,     0,
       0,   517,  1454,  1453,   579,   493,   494,   495,     0,     0,
       0,   486,   489,   418,     0,   531,   478,   471,     0,   446,
     715,   440,     0,     0,     0,   675,     0,   106,   136,     0,
     706,  2006,   255,   254,  1142,     0,     0,     0,     0,     0,
       0,  1887,  1917,  1920,  1918,  1919,  1921,  1915,     0,     0,
     321,     0,     0,  1126,  1128,  1122,  1170,     0,     0,     0,
       0,  1420,  1422,     0,  1187,     0,  1055,  1041,     0,  1046,
       0,  1038,     0,  1076,     0,   517,   332,   558,   497,     0,
     496,     0,   491,   492,   487,     0,   467,     0,   467,   438,
       0,  1997,     0,  1994,     0,  2013,   138,     0,     0,  1943,
     523,   526,   415,   843,     0,   971,   853,   911,  1256,  1264,
       0,  1407,  1130,  1131,  1142,     0,   683,     0,     0,     0,
       0,  1421,     0,     0,  1428,  1430,     0,     0,     0,     0,
    1082,     0,  1077,   334,   333,   499,   500,   498,   484,   485,
     381,   532,   383,  1998,  1999,  1943,   116,   115,   107,     0,
     175,     0,  2007,   256,     0,     0,     0,   454,  1127,  1171,
    1425,  1426,     0,  1423,     0,     0,  1429,     0,     0,  1043,
    1048,  1075,  1995,   117,     0,   193,   179,     0,     0,     0,
     177,   207,  2014,     0,     0,   181,   205,   206,   182,   185,
     186,     0,  1499,     0,  1500,  2000,   106,   844,  1263,  1265,
       0,  1408,     0,  1424,  1432,  1431,     0,  1056,   192,   195,
       0,     0,   198,   188,   187,   189,     0,     0,     0,   176,
     175,   175,   235,   184,   232,   231,   224,   175,  2008,   455,
    1419,   706,     0,   194,     0,     0,     0,   178,   208,   219,
     222,   214,   175,     0,   175,     0,   147,     0,     0,  2001,
     175,  1427,     0,     0,  1174,  1176,     0,   190,     0,     0,
       0,     0,   175,   215,     0,     0,     0,   145,   238,     0,
     143,   226,   226,  2009,  1433,  1177,  1172,   706,  1300,     0,
     180,   199,   216,   222,   212,   220,   175,     0,   234,   146,
       0,   236,     0,   175,     0,   225,   227,   229,     0,  1435,
    1175,   191,   196,   175,     0,   213,     0,     0,   211,     0,
     175,   158,   157,     0,   149,   171,   233,     0,   148,     0,
       0,  1442,     0,   175,   217,     0,   175,     0,   175,     0,
       0,     0,     0,     0,   144,  1434,  1437,     0,     0,  1439,
    1440,     0,  1409,   197,   202,     0,   209,   175,   239,     0,
     152,   172,   173,     0,   155,  1441,  1436,     0,  1443,   198,
     175,   201,   175,   237,     0,     0,   150,   164,   151,   162,
     154,     0,  1438,   203,   175,   175,   170,   168,   175,   159,
     166,   161,     0,   167,   174,   165,     0,   156,     0,   153,
     169,   163,   160
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    52,   461,  1068,    53,    54,    55,    56,    57,   968,
      58,   519,   915,  1375,  1376,    59,   412,    60,   694,  1115,
    1116,  1117,    61,  1588,  2453,  1133,   389,   407,  1585,  1079,
    3385,  1507,  3438,  1508,    62,   483,   692,  1097,  1098,  2755,
    2756,  3031,  2757,  3024,  3025,  3026,  3027,  3583,  3532,  3560,
    3584,  3621,  3654,  3660,  3661,  3603,  3668,  3669,  3670,  3676,
    3671,  3604,  3656,  3533,  3473,  3506,  3502,  3474,  3569,  3501,
    3591,  3525,  3526,  3593,  3634,  3651,  3475,  3476,  3507,  3550,
    3477,  3508,  3573,  3530,  3574,  3594,  3635,  3531,  3551,  3597,
    3554,  3478,  3537,  3585,  3479,  3538,  3480,  3481,  3515,  3536,
    3513,  3535,  3600,  3580,  2032,  2434,  2038,  2444,  3035,  2449,
    3214,  3389,  1864,  2257,  3100,  2765,  1576,  1074,  1075,   390,
     391,   392,   491,  2039,  1542,  2040,  2041,  1544,  1545,  1014,
    2407,  2398,  2384,  3263,  2440,  2411,  2412,  2413,  2414,  2362,
    2363,  1950,  1951,  1997,  2422,  2739,  2963,  2983,  2740,  2741,
    2742,  2743,  2744,  2745,  2746,  2780,  2781,  3158,  3159,  3160,
    2776,  2777,  3014,  2998,  2999,  3000,  3180,  2970,  2297,  2298,
    3491,  2307,  2308,  2344,  2634,  2345,  1078,  2971,  3008,  3168,
    3001,  2421,  2957,  3151,  3300,  3152,  3153,  3154,  3372,  1952,
    2361,  1094,  1095,   640,   393,  1149,  1592,  3039,  3040,  2352,
    2870,  3304,    63,  1081,   677,   679,   678,  2000,   468,  1546,
    1547,  1548,  2677,  2683,  3294,  1954,   111,  1372,  2418,  1988,
      64,  1051,  1046,    65,   651,   646,   647,  1049,  1050,  1476,
    1912,    66,   586,    67,   478,    68,   486,  1120,    69,   976,
    1856,  1857,  1858,    70,   684,    71,   487,  1127,  1128,  1129,
      72,   966,   116,    73,   575,   971,   973,   974,    74,   480,
     481,  1089,    75,  1402,  1839,  1840,   689,   690,  1096,  2593,
      76,    77,   458,   432,   592,   433,   434,  1429,  1876,  3264,
     603,   604,   605,  2281,   993,   994,   995,  1881,  1430,  2286,
    1135,  2885,   886,   887,   888,  1309,  1310,  3002,   889,  1319,
    1775,   890,   891,  1803,   892,  2830,  2230,  2231,  2232,  2575,
    2576,   893,  2072,  2793,  2110,   894,  1302,  1760,  1669,  3057,
    2814,  1608,  2055,  2473,  2577,   508,   509,   895,  1227,  1228,
    1229,  1686,  1293,  2201,  1752,  1483,  1484,  1485,  1486,  2934,
    2933,  2935,  3278,  3123,  3280,  3127,  1923,  1487,  1488,  3417,
    2320,  2648,  2338,  2339,  3134,  1914,  1489,  2326,  3133,  2664,
    2940,  3286,  3421,  2002,  3282,  1359,  1730,  1360,  1666,   950,
     951,  1609,  1836,  2245,  3107,  3268,  2220,  2904,  3266,  3343,
    1549,  2388,  2389,  1878,  1879,  2342,  2667,  2687,  1017,  3265,
    2247,  1457,  1458,  2770,  3659,  2013,  3406,  3492,  3543,  3544,
    3545,  2616,  2617,  2908,  2909,  1880,  2278,  2618,  3108,    78,
     395,    79,  1806,  1813,   686,   511,   404,    80,   413,  1837,
      81,   426,  1417,   559,   579,   979,   980,  1865,  2258,  2265,
    1866,  2270,  2897,  2260,  2596,  2597,  1935,  1936,  2261,  2599,
    2894,  2886,  2887,  2589,  3098,    82,   446,  2659,  2333,  2334,
    3398,  3399,   580,    83,   394,   734,  1596,  1154,  1595,   735,
     736,  1156,   506,   507,    84,   444,    85,   437,   641,  1453,
    2311,  1900,   571,   643,  1464,   644,  1465,  1444,  1895,  1005,
      86,   673,   672,    87,   464,  1070,    88,   520,   926,   927,
    1380,  1814,    89,   427,   584,   585,    90,   421,   572,  1410,
      91,   414,   562,    92,    93,   563,   959,  2590,  3262,  3447,
    3520,  1401,   960,  2450,  3271,  3351,  3352,  3354,  3414,  3415,
    3589,  3611,  3628,  3629,  3632,   896,   660,   897,  3144,   898,
     899,  2266,  2267,  2668,   900,  3400,   901,  1998,   654,   410,
     902,   553,   661,  2250,   903,  3483,   707,   708,   376,   377,
      94,   606,   436,   997,   998,   999,  1439,  1440,   645,  2209,
    1441,  1442,  1892,  1887,  2916,  2640,  2632,    95,   566,   928,
     964,   965,  1845,    96,   445,    97,   952,  1396,  1397,  1833,
    2244,  1834,    98,   588,    99,   542,  1390,   543,   930,   544,
     545,   942,   937,   945,   939,  3252,  3090,  3091,  1821,   911,
     709,   710,  1383,  1816,  1817,  2881,  3093,  3258,  3259,   100,
     120,   382,   489,   701,   987,   101,   102,   103,   104,   990,
    1063,  1872,  1064,  1065,  1066,  1496,  1427,  2555,  1300,  1754,
    2867,   494,   724,   716,   474,   475,   476,   497,   498,   112,
     113,   717,   718,  2035,  2425,  2749,  3018,  3019,  3201,  3198,
     719,  3517,   720,   721,  2435,  3207,  3388,  3486,  3540,   722,
    2029,  2753,  3317,  3440,   105,   662,   455,  1061,  1056,  1058,
    1492,  1930
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3141
static const int yypact[] =
{
    3646, -3141,   172,   686,  1075, -3141,   128, 42298,    71,  1075,
    1075,  -166,  2443, -3141, -3141, -3141, -3141, -3141,  2477, 42298,
     686, -3141, 21281, -3141, -3141, -3141,   238,  1075,   686, 42298,
   -3141,   316,  1023,   686, -3141, -3141,  1075, -3141,  -166, 42298,
   -3141,   156, -3141,  -118,   817,   327,    51, -3141, -3141, 42298,
     778,  -142,   795,   891, -3141, -3141,   600, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, 21818, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  1067, 42298, 42298, -3141,
   42298,   519, -3141,  1063, -3141, -3141,  1075, -3141, -3141, -3141,
    -166, 21281, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,   564, -3141, -3141,   789, -3141,
   -3141, -3141,  1299,  1091, -3141, -3141, -3141, -3141, -3141,   352,
     866, -3141,   854,  1187,    40, -3141,  1138,  1138, 42298,  1138,
   -3141,  1138, -3141,  1138,  1075, -3141, -3141,  2954, 42298,  1032,
     343,  -115, 37465,   807,   359, -3141,  1223, 21281, -3141,  1075,
    1258,   234, 42298, -3141, -3141,  1075,   155,   676, -3141,  3602,
     142, -3141, -3141, -3141,  1324, -3141, -3141,  4992, -3141, -3141,
   -3141,   930, -3141, -3141, 21281,  1075,  1210, -3141, -3141,   106,
     106,   106, -3141,   106, -3141,   106, -3141,  -142,   917, -3141,
   -3141,   922, 42298,   459, -3141, -3141,   932,   626, -3141, -3141,
   -3141, -3141, 21281,  1381,  1079, -3141, -3141, -3141, 21281, -3141,
     -25, -3141, -3141,   976, 42298, -3141, 21281, 21281,   411,   514,
    1052, 42298, 35317,  1167, -3141,   332,  1263,  1063,  1555, -3141,
    1091, -3141, 42298, -3141, -3141, -3141, 39076,    40, -3141, 13577,
    1400, 42298, 42298,  1231, 42298, 42298, 35317, 21281,  1138,  1053,
    2843,  1209,  1166,  -122, -3141, -3141, -3141, -3141,  1236, -3141,
   -3141,  1114, -3141, -3141, -3141,   119, -3141,    44, -3141, -3141,
   -3141, -3141, -3141,  1251,  1034, -3141, -3141,   110, -3141, -3141,
   42298, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  1398,
   -3141, -3141, 13577,   226,  1564,  1447, 21281, -3141,  -144, -3141,
   -3141,  1368, -3141, -3141, 35317, 21281, -3141, -3141, -3141, 19120,
   -3141, -3141,  1581, -3141,  1068, -3141, 21281,  1209, -3141,  1297,
    1229,   514,  1136, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  1105,  1324, -3141, -3141,  1405,  1523, -3141,
    1253,   -47,  1190,  1125,   342,   -47, 37465,  1451, -3141,   220,
   -3141,  1519, -3141, -3141,  1248, -3141, -3141, -3141,  1274,  1286,
    1410,  1241, -3141,   246, -3141,   544, -3141,   652,  1451,   -47,
     893, -3141,  1488,  1608,   398,   511, -3141,   -70, -3141, -3141,
    1677, -3141, -3141, -3141, -3141, -3141,  1398, -3141, -3141, -3141,
    1212, -3141,  1443,  1325, -3141, -3141,    50, -3141,  1234,   727,
    1794, -3141,   479, 35854, -3141, -3141, -3141,  1693, -3141, -3141,
   -3141, 35317,  1380,  1276, 21281,   658, -3141, 39613, 21281, -3141,
     -24, 13577, -3141, -3141,  4076,   154,  1986, -3141,  1752,  1425,
   -3141, -3141, -3141, -3141,  1670, -3141,  1266,  1271,  1616,  1278,
   -3141, -3141, -3141, -3141, -3141,  1674, -3141,  1316, -3141, -3141,
   -3141, -3141, -3141,  1682, -3141, -3141, -3141, -3141, -3141,  1079,
   -3141, 21281,  -155, 21281, -3141,  1298, -3141,  1303, -3141,  1304,
    1330,  1332,  1345,  1350, 16397, -3141,  1352,  1355,  1362,  1366,
    1372,  1375,  1382,  1384,  1387,  1397,  1408,  1413,  1422,  1429,
    1266,  1266,  1433,  1437,  1452,  1454,   736,  1459, -3141,  1465,
    1471,  1473,  1478,  1482,  1498,  1503,  1507,  1513,  1517, -3141,
    1521, -3141,  1533,  1534,  1541,  1558,  1559,  1560,  1562,  1565,
    1566,  1567,  1570,  1571,  1572,  1573, -3141,  1574,  1577,  1585,
   13577,  1586,  1590,  1593,  1597,  1599,  1601,  1603, -3141,  1604,
    1605,  1606,  1607,  1615,  1619,  1623,  1629,  1638,  1639,  1640,
    1645,  1648,  1654,  1659, -3141, -3141, 13577,  1663, -3141, -3141,
    1666,  1668, -3141,  1679,  1681,  1683,  1686,  1697,  1700,  1702,
    1703,  1704,  1710,  1711,  1714,  1716,  1717,  1720,  1723,  1729,
    1731,  1732,  1733,  1735, -3141,   990,  1737,  1738,  1200,  1739,
   -3141,  1746, -3141,   136,  1747,  1751,  1755,  1266,  1266,  1266,
    1756,  1761,  1765,  1766,  1772,  1778, 13577, 16397, 16397, 16397,
    9065, -3141, 42298, -3141, 42298,  1712,  3081, -3141,  4926, 16397,
    4575,   387, -3141, -3141, -3141,  1423,  1390, -3141, -3141, -3141,
   -3141, -3141,  1779,  1339, -3141, -3141,  1360, 21281, -3141, -3141,
   -3141,  1487,    33, 21281,  1320, -3141, -3141, -3141, -3141, -3141,
   -3141,  1914, -3141, -3141, -3141,  1580,  1547, -3141, -3141, -3141,
   -3141, -3141, -3141,  1671, -3141, -3141, -3141,  1780, -3141,  1780,
   -3141, -3141,  1780, -3141, -3141,  1780,    -8,  3869, -3141, -3141,
   42298, -3141, 42835, -3141, 19120,  1712, -3141,  1843, -3141, -3141,
    1916, -3141,  1895,   302,  1750, -3141, 21281, 37465, -3141, -3141,
      61,  1768,  1823,  1781, -3141,  1838, 21281, 21281, -3141, -3141,
   -3141, -3141,   676,    58,  1785,    29, -3141, 42298, -3141,   265,
   -3141, -3141, -3141,  1787, -3141, 13577, -3141,  1789, -3141,   738,
   -3141,  1992, -3141,  1865, 13577, -3141, -3141,  1788,  1091, 42298,
   42298, 21281, 21281, -3141, -3141, -3141,   -10, -3141, -3141, 42298,
     -47, 35317, -3141, -3141, -3141,  2201,   893, 42298,   -47, -3141,
   -3141,   893, -3141, -3141, -3141, -3141, -3141, 21281, -3141, -3141,
     893, -3141,   893,   893,   -47,   -47,  1852, -3141, -3141,  1808,
   -3141,  1852,  1936,   722,   106,  2019, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,    45, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,   101, -3141, -3141, -3141,  1489,  2749,
    2749,  1641, -3141,   716, 21281,  1813,  1865, 21281, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,  1817, -3141,  1819,  1816,  1712,
    2240,  2242,  2249,  2257,  2258,  2263,  2264,  2266,  2268,  2271,
    2273,  2277,  2279,  2281,  2282,  1833, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,  1917, -3141, -3141, -3141, -3141,  1349,
   -3141, -3141, -3141,   104,  1870, -3141, 37465,  2382, 35317,  2259,
   42298, 42298, 42298, 21281, 42298, -3141, -3141,   126,   126,  2095,
    1298, -3141,    82, 42298,  2272, 25593,    93, 13577, 13577, 13577,
     796,  2672,  2374,  2427,  2427,  2427, 13577, 13577, -3141, -3141,
   13577, -3141, 13577, 13577, 13577, 13577,  1115, -3141, -3141,  9629,
   -3141,  1886, 13577, 13577,  1972, 13577,  1390, 13577, 13577, 22355,
   13577, 13577, 13577, 13577, 13577,   589, 13577,  4575, 13577, 13577,
   13577,  1890, 13577, 13577, 13577, 13577, -3141, 13577, 13577,   280,
   13577,  2333,   779, 13577, 13577, 13577, -3141, 10193, 13577, 13577,
   13577, -3141, 13577, 13577, 13577, 13577, -3141,  2447, -3141, 22355,
    1159, 13577, 13577,  1201, 13577, 13577, 13577, 13577, 13577, -3141,
   -3141, -3141, -3141,  9629, -3141, 13577, 13577, 13577, 13577, 13577,
   -3141, 16397, 13577, 10757, 13577, 13577, 13577, 13577,  1897, 13577,
   13577,  2427,  2427, 13577, 13577, 13577,  1207,  9629, -3141, 13577,
    1390,  2503,  2503, 13577,  1390,  7937, 13577, -3141, -3141, -3141,
     779, 11321,  1900, -3141, -3141, -3141,  2427, 22355,  2427, 13577,
   13577, 13577,  1712,  1930,  2374,  2374,  2374, -3141,  9065,   150,
    1902, 13577, 23429,  1901, -3141, -3141, -3141, -3141, 13577, 13577,
   13577, -3141, 16397, -3141, -3141,   188, -3141, -3141, -3141, 14141,
   16397,  1905, 16397, 16397, 16397, 16397, 16397,  2220, 16397, 16397,
   16397, 16397, 16397, 16397, 16397, 16397, 16397,   542,  2374, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  1919,
   -3141, 37465, 16397, 13577, -3141, -3141, 42298, 42298, -3141, 35317,
   -3141, -3141, -3141,    33, 37465,  1911, -3141, -3141,  2102,  2843,
   21281, -3141, 42298, -3141, -3141, -3141, -3141, 19657, 19657, -3141,
   19657, -3141, -3141,    86,    91,  3390,  1944, -3141, -3141, -3141,
   -3141,  2274, 21281, -3141,   -46, 21281,  1813, -3141, 13577,  1865,
   -3141, 35317, 35317, 21281, 21281,   289, -3141,   803, -3141,  1865,
    2297, 19657, 19657, 19657, -3141, -3141, -3141, -3141, -3141,  1012,
   -3141,  1712, -3141,  1918, -3141, -3141, -3141, -3141, -3141, 40150,
     205, -3141, -3141,  1865,  2322, -3141,  1712,  1933, 42298, -3141,
   -3141, -3141, -3141,     5, -3141, -3141, -3141, -3141,  -104, -3141,
   -3141, -3141, -3141,  2062,   -47, 42298, -3141, -3141,   -47,   893,
   21281,   -47,   -47, -3141, -3141,  1245, -3141,   -70, -3141, -3141,
   -3141, -3141, 42298,  1426,  2079,  1940, -3141, -3141, 21281, -3141,
    1945, -3141,  2342,  2468,  1451, -3141, -3141, -3141,    39,    39,
    1865,  2071,  2074,  2077,  2078,  2080,  2107, -3141, -3141,  2902,
    2463,    39,    39,  2463,    39,    39,    39,  2052,  2420,    39,
    2314,  2084,  1235,  2319,    39, -3141,  2087,  2432,    39,    39,
      39,  2463,  2510,    39,    39,    39,    39,    39,   177,    39,
      39,    39, -3141,  4745, -3141, -3141,  1998, 20196, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, 40687, -3141, 13577,  2672,  1865,
    1865,   849,  1865,  2672,  1865,  1865,  1865,  1865,  1865,  2672,
    1865,  1865,  2672,  4076, -3141, -3141, -3141,   107, -3141, -3141,
     -63, -3141, 42298, -3141,   756,  2009,   -86, -3141,  4188, -3141,
   -3141, -3141, -3141, -3141, 21281,  2053,  1944, 25593, -3141,   722,
   -3141,  2003, -3141,   393,   287,   208, -3141,  2427,  2015, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  2018,  2016,  2021,  2023,
     145,   830,   852,  2027,   966,  2034,   433,   850,   239,   914,
   -3141,  2035,  2055,  1319, -3141,  1001,  1011,  1657,  1748,  1027,
    2057,  2059,   231,   256,  1093,  1106,   260, -3141,  2060,  1140,
    2460,  1142,  1150,   279, -3141,  1770,  1152,  1154,   294,  2082,
     296,   298, -3141, -3141, -3141, -3141,  2073,  1225, -3141, -3141,
    -123,  1796,  1254,  1256, -3141,  1805,  1260,  1262,   312,  2089,
    1269,   350,  1273,  1275,  2093,  2081,  2099, -3141,  2427,  2094,
    1857,  1885,  2427,  2098,   406,  1277,  1893,   534,   554,  2108,
    2117,  2118,  1898,  1909,  1938,   577,  1296,   590,  2120,  2961,
    1943, -3141,  1975,  1306,  1327,  1337,   614, -3141,  1371,  2006,
    2121,  2124,  1412,   198,  1436,  2427,  2128,  2032,   653, -3141,
    2106, -3141,  2135,  2045, 11885, 12449, 13013,   254,  1444,   463,
   -3141,  2054, -3141,  2152,  2153, -3141,  2059,  2160,   677,   687,
    2067, 13577,   819, -3141,  -142, -3141, -3141, -3141,   123,   615,
   -3141,  2212, 42298,  1440,   160, -3141, -3141, -3141, -3141, -3141,
   -3141,   740, -3141,  2164, -3141,  2165,  2171,  9065,   723,  2171,
    2919,  2649,  2649, 16397,  2541,  2987,  2967,   645,  4575,   645,
    4575,  2171,  2171,  2171, -3141,  2169, 16397, 16397, 16397, 13577,
   -3141,  2374,  1712,  2161,   628, -3141, -3141, -3141, -3141, -3141,
    1320,  2482, -3141,  1813, -3141, -3141,  1021, -3141,  2175, -3141,
    2179,  2245,  2261,  2265, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  1451,   803,  2276,  2191,
   -3141, -3141,  2217,  2506, -3141, -3141, -3141,  1712, -3141,  2278,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,    24, -3141,
   -3141,  2202,  2202, 18035, -3141, -3141, -3141, -3141,  2422,  2594,
    2597,  2600,   479, -3141,   227, -3141,   696,  2545,  1451, -3141,
    2602, 38002, 26132, -3141,  2210,  2542,  2214,    39, 33706,   720,
   23969, 34243, -3141, -3141,   849, -3141,   109, -3141, -3141, -3141,
   -3141,   -10,   -10,  2250, -3141, -3141, -3141,  1944,   893, -3141,
   -3141, -3141,  2215, -3141, -3141,   722,  2550,  2562, -3141,  2446,
     607,  2446,   722,   722, 22355,   722,  1510, -3141,  2672,  2505,
   -3141, -3141, -3141, -3141, -3141, -3141, 36391, 34780, -3141, -3141,
   -3141,  2715, -3141,  2718,   992, -3141, 22892,   694,   694, -3141,
     210,   322, 22892, -3141, -3141, 22892,   849,  2672, 22892,  2672,
    1865,  1865,  1655,    39,  2672, -3141, -3141,  2581,  2583, 22892,
   22892, -3141, 37465, -3141,    39,   108,   849,   849, 22892, 22355,
    1100,  1865,  2672,  2672,  1088, -3141, -3141, -3141, 21281,   253,
   37465,  2262, -3141,  4488, 17498, 42298,   776,   303, -3141,  2251,
    2270, -3141,  1134, -3141,  1712, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  2350, -3141,  2421,  2275,
   -3141, -3141,   167, -3141,   879,  2270, 21281, 16961, -3141,    88,
   -3141,  3511, -3141,   722,  2486,    83,  1944,  2283,    93, 14705,
   -3141, -3141, 13577,  2280, -3141, 13577, 13577, -3141, -3141, -3141,
    2654, -3141, 36928, -3141, -3141, -3141, -3141, -3141, 13577, 36928,
    2654, 13577, -3141, -3141,  2284, -3141,  2611,  2611, -3141, -3141,
    1390, -3141, 42298, -3141, 13577, -3141, 13577, -3141,  1390, -3141,
   13577, -3141, 13577, 13577, -3141,  2502, -3141, 13577, -3141, 13577,
   13577, -3141, 13577, -3141, -3141, 13577, -3141, 13577, 13577, -3141,
   -3141,  2509, -3141, 13577, 13577, -3141, -3141, 13577, -3141, 13577,
   -3141, 13577, -3141, 13577, -3141, 13577, -3141, 16397, 22355,  2287,
   -3141, -3141, -3141,  2288, -3141, -3141, 13577, 13577, -3141, -3141,
   13577, -3141, 13577, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   13577, 13577, -3141, 13577, -3141, 13577, -3141, -3141, 13577, 13577,
   13577, -3141, 13577, -3141, -3141, -3141, -3141, 15269, 13577, 13577,
   13577,  2290, -3141, -3141, -3141, 13577, 13577, 13577, -3141, 13577,
     270, 13577,   881, 13577,  1673, 13577, -3141, 13577,  2513, -3141,
   -3141, -3141, -3141, -3141, 13577, -3141, 13577, -3141,   187, 13577,
   13577,  2698, -3141, -3141,  2291, -3141,  2286,  2292,  2299, 37465,
   13577, -3141, -3141, -3141, -3141, -3141,   589,   702,  2295, 16397,
   -3141,  2919, 16397, -3141, -3141,  9065,   723,  2919,  2682, -3141,
    2296, -3141, -3141,  2305, 42298, -3141, -3141, -3141, 42298,  2315,
   26671, 35317, 35317, 35317,  2308, 13577, -3141, -3141,  2533, -3141,
   -3141, 21281,  2662, -3141, -3141, 35317, -3141,  1324, 22355, -3141,
    2321, -3141,  2321,   948,  2316,  1175, -3141, -3141, -3141,  2323,
    1136,  2710, 35317, 35317, 35317, -3141,  1944,  1944,    94,  2375,
    2669, -3141, -3141, -3141, -3141, 41224, -3141, -3141, -3141, -3141,
     760, 42298,  2643, 42298,  8501, -3141, -3141, -3141,  2834, 13577,
   -3141, 35317,   517,   615,    39, -3141, -3141, -3141, -3141, -3141,
   -3141,  1451, -3141, -3141, -3141, -3141,  2629, -3141,   -47,  1245,
    -177, -3141,  1691, -3141, -3141, -3141,  2674,   722,  2446,  2446,
    2677,  2565,   568,  2346, -3141,    39,  1426,   -13, -3141,  1324,
   -3141, -3141, 13577, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, 13577,  2678,  2679,   694,
   -3141, 22892, -3141, -3141,  -155,    80, -3141, -3141, -3141, -3141,
   -3141, -3141, 34780,  1865, -3141, 22892, -3141, -3141,   132, -3141,
    1865, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  2351, -3141,
     991, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, 21281,
   -3141,  1228, -3141, -3141, -3141, -3141, 42298, -3141, -3141, 21281,
   -3141, -3141,  4631, 42298, 42298,  2894, -3141, 42298, -3141,   879,
   -3141, -3141, -3141, -3141,  2577, 42298, -3141, -3141, -3141, -3141,
    2423,  2900, -3141, 21281, -3141,  2361,  1301, -3141, -3141, -3141,
    2906,  4890, -3141,  2365,  1944,  2680, -3141, -3141, 13577,  2083,
    2097, -3141,  1712,  2113,  2366,  2366, -3141, -3141,  2369,  2366,
    2707, -3141,  2709,  2376,  2377,  2378,  2132,  2383,  2385,  1504,
   -3141, -3141,  4575,  4575,  2391,  2367,  2140,  2154,  2393,  2397,
    2156,  1506,  2162,  2400,  2401,  2170,  2172,  1538,  2176,  2178,
    2194,  2196,  2403,  2486,  2407,  1544,  1549,  2411,  2200,  2205,
     704,  2209,  2413,   706,  2858, -3141, -3141, -3141,  2234,  2239,
    2243,  2253,  2285,  2289,  2298,  2302,  2313,  1576,  2318,  2340,
    2414, 13577,  2344,  1763,   877,  1596, -3141,  2348,  1620,  1622,
    2356, 13577,  2388, 13577,  2437, 13577,  2452,  2459,  2416,  2465,
    2474, 13577,  1191,  1712, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  2368,  1712,  2424, -3141, -3141, -3141,   387, -3141,   907,
    2425, -3141, 16397, -3141, 13577,  2428, -3141,  2433, -3141, -3141,
   -3141, -3141, -3141,   235,   235,   235, 15833,  1712,  2853, -3141,
     -22, -3141,  2748, -3141, -3141,  1105,  2431, -3141,    39, 15833,
    2202,  2580, -3141, -3141,   948, 22355, 26132, -3141, 35317,  1278,
    1278,  1278,  1451,  2806,  2276,  2276, -3141, 24509, -3141, -3141,
    2573, -3141, -3141, 27210, -3141,  1069, -3141, -3141, 16397,  1471,
   -3141,  1712, -3141, 36391, -3141,  1712,    39,  2442,  2449, -3141,
   -3141, 41761, 13577, -3141,  2869, -3141, -3141,  2451,   722,  2670,
     722, -3141,  2787,  2789,   722, -3141, -3141, -3141, 22355,  1944,
   15833,   694,   694,   694, -3141,  1105,  1712,  2462,   991,  1712,
   22892, -3141, -3141,  -155,  2469,  2914,  2917, 22892,  2834, -3141,
   -3141, -3141, -3141,  4631, 22355, -3141, -3141, -3141,  2478, -3141,
   17498, -3141, -3141, -3141,  2366,  2366,  2366, -3141, -3141, -3141,
   -3141, -3141,  2369,  2684, -3141,  2369,  2369, -3141, -3141, -3141,
   -3141, -3141,   261,  1526, -3141, -3141,   261, -3141, -3141, -3141,
      60,   979,  2369, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
    2366,  2366, -3141, -3141, -3141,   261,  2366, -3141,  2366,  2964,
   -3141,   229,   105,  2366,  2366,  2366,  2470,  2472, -3141,  1308,
   -3141, -3141,  2547,    74, -3141,  2480,  2485, -3141, -3141,  1865,
   -3141,  2489, -3141,  4745, -3141,   683, -3141, 42298, -3141,   -10,
   -3141,  4575, -3141, -3141, -3141,   467, -3141, -3141,   261,   647,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, 13577,  2491,  2493,  2495, -3141, -3141, -3141, -3141,
   -3141, -3141, 13577, -3141, -3141, -3141, -3141, -3141, 13577, -3141,
   -3141, -3141, -3141, -3141,  2637, -3141,  2730, 13577, 13577, -3141,
   -3141, -3141, -3141, 13577, -3141, -3141, -3141, 13577,  3022,  2692,
    2504, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   13577, -3141, -3141, -3141,  4575, -3141, 13577, -3141, -3141, 13577,
   13577, -3141, 13577, 13577, -3141,  2476, -3141,  2517, -3141,  2546,
   -3141, -3141,  2736, -3141, -3141,  1712, 13577, -3141,  2508, 42298,
   -3141, -3141,  2512, -3141, -3141, -3141, -3141,  1712, -3141, -3141,
     855,  2535,  2535,  2535,  1471,  1712,  1317, -3141, -3141,  2849,
   -3141,  1787, 22355, 15833,  2520,  2523, -3141,   727, -3141, -3141,
    2514,  1278, -3141,  3045,  2904, -3141, -3141, 37465,  2543, -3141,
   -3141,  2801, -3141,    65,  2726, -3141, -3141, -3141,   517,  2638,
    2641,    39,  1712,  1865,  2105,  1940,  2878,  2910,  2601,   722,
     722,  2911,  2605, 13577, 13577,  2561, -3141,  2486, -3141,  2951,
   -3141, -3141, -3141,  1787, 13577, -3141,  2571,  2572, 42298, -3141,
    3338,   776, -3141,  2964, -3141, -3141, -3141,   552, -3141, -3141,
   -3141,   800, -3141,  2579,   800,   800,  3101,   162, -3141,  3101,
   36928, -3141,  1253, -3141,  2617,   261, -3141, -3141,  2619, -3141,
   -3141, -3141,   800,  2590,   261, -3141, -3141, -3141,   800, -3141,
   37465,  1865,  3265, -3141,  2640, -3141,  3044,  2923, -3141,  2964,
   -3141,  2939,  2844, -3141,   261, -3141, -3141,  3101, -3141,   261,
    3101,   800,  2846, -3141,   800, 42298, -3141, 42298,  2646,   742,
    1865, -3141, -3141, -3141,  2614,  2616, -3141, -3141, 21281, -3141,
   42298,  4631, -3141,  2646, -3141,   727,    88,  2580, -3141,  1336,
     991,  2622, -3141,  2626,  2628,  2630,  2633,  2634, -3141,  1342,
    2548, -3141, -3141, -3141,   970,  2559,   106,  2650,  2621,  2576,
    1633,  2587,  2596,  2912,  3062, -3141,  2598,  2656,  2604,  2609,
    2632,  2660,  2689, -3141, -3141, -3141,  2657,  1712, -3141, -3141,
   -3141,  2659, 38002, -3141,  2742,  2750, -3141, -3141,  2755, -3141,
   -3141,   118,  1545, -3141, -3141, -3141, -3141, 15833,  3009, -3141,
    1010, -3141, -3141, -3141, -3141, 13577, -3141,  2486,  3178, -3141,
   24509, -3141, -3141, -3141, -3141, -3141,  2688,  2695,  8501,  3229,
   -3141,   722, -3141,  2740, -3141, -3141, -3141,  2741,  1712,  1712,
   42298,  2680,  3023, -3141,  1010,   991, 42298, 42298,  1357,   779,
     779,   779,   867,   867, -3141, -3141, -3141, -3141,   771,    36,
   42298, -3141, -3141,  1000, -3141, -3141, -3141, -3141, -3141,   800,
   -3141,   106, -3141, -3141, -3141, -3141, -3141, 36928, -3141, -3141,
    3101, -3141, -3141, -3141,   106, -3141, -3141, -3141, -3141,  1266,
   -3141, -3141,  2935,  2746, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  2702, -3141, -3141, -3141,   926, -3141, -3141,
   -3141, -3141, -3141, -3141,   811, 42298,  3103,  2873, -3141, -3141,
   -3141, -3141, -3141,  2716,  1136, -3141, 42298, -3141,  2950, -3141,
   -3141, -3141, -3141, -3141,  2955, -3141, -3141, 13577, -3141, -3141,
   -3141,  2427, -3141, 13577, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,   121,  2953,  2672,  2672,  2672,  2672,  1545, -3141,
   -3141,  2781,  2824, -3141,   696, -3141,  -198,   991, 13577,  1451,
     698,  3048, -3141, -3141, -3141, -3141,  3030,  3122, 13577,  2743,
   13577,  2745,  1376, -3141, -3141, -3141,  2752, -3141, -3141,  1388,
    1394,  -155, -3141, -3141,   776, -3141, -3141, -3141,   996,   996,
    1417, -3141, -3141, -3141,  1434, -3141, -3141, -3141,  1438, -3141,
    1266, -3141,  3245,  2966,  3249, -3141,  -142, -3141, -3141,  4631,
   -3141, -3141, -3141, -3141,   991,  2759,  2761,   972,  2762,  2704,
    2763, -3141, -3141, -3141, -3141, -3141, -3141, -3141, 22355, 21281,
   -3141,   112, 13577, -3141, -3141,  1712,  2943,  3266,  3285,  3195,
    3291,   698, -3141,   913, -3141,  3194, -3141,  1712, 42298,  1712,
   42298, -3141, 42298, 40687,  2973,  -155, -3141, -3141, -3141,  3334,
   -3141,   413, -3141, -3141,  1000, 42298,   261,   106,   261, -3141,
    3003, -3141,  3016, -3141,  2798,  3079, -3141,  3233,  4631,   727,
   -3141, -3141, -3141, -3141, 13577, -3141, -3141, -3141,  2804, -3141,
      39, -3141, -3141, -3141,   991, 42298, -3141,   106,   106,  3323,
     106, -3141,  3329,  3331,   913, -3141,   849, 13577,  1449,  1462,
   -3141,  2815,  2816, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,   727, -3141, -3141, -3141,  3259,
   32085,  2965, -3141, -3141,  2711, 22355, 15833,  1655, -3141, -3141,
   -3141, -3141,   106, -3141,   106,   106, -3141,  3364,   131, -3141,
   -3141, -3141, -3141, -3141, 42298,   673, -3141, 43372, 43372, 42298,
   -3141,  2850, -3141,  4084,    10, -3141, -3141, -3141, -3141, -3141,
   -3141,  3353, -3141,  2818, -3141, -3141, -3141, -3141, -3141, -3141,
   34780, -3141,  2829, -3141, -3141, -3141,  3118, -3141, -3141, -3141,
    3223, 42298, -3141, -3141, -3141, -3141, 13577, 13577,  2863, -3141,
   32085, 32085, -3141, -3141, -3141, -3141,  3371, 32085,  3079, -3141,
    3178,  2839,  3261, -3141,  3179,  3280, 13577,  1712,  1712, -3141,
     853, -3141, 29375,  2856, 32627, 13577, -3141,    10,  3353, -3141,
   32085,  3048, 13577,  2862,  2857, -3141,  2672, -3141,  3215,  1195,
    2893, 13577, 32085, -3141,  3288,  3165,  2864, -3141,  2860,  2049,
    3325, 43372, 43372, -3141,  3222,  1712, -3141, -3141, -3141, 42298,
   -3141, -3141, -3141,   864, -3141,  1712, 29917,  2886, -3141, -3141,
   13577, -3141, 38539, 30459,  2870, -3141, -3141, -3141,  3106,  2880,
   -3141,  2881, -3141, 32085, 13577, -3141,  3306,  2898, -3141,  1690,
   32085, -3141, -3141,  3251,  2885,  1184, -3141,  2882, -3141,  3201,
   18574,  3025, 42298, 27749,  1712,  2905, 32085,  3060, 31001,  3295,
   42298,  4631,  3298,  3309, -3141, -3141, -3141, 37465,  1474, -3141,
   -3141, 22355, -3141, -3141,    18,  2931, -3141, 28291, -3141,  2945,
   -3141, -3141,  3372,  2076, -3141, -3141, -3141, 20735,  2804, -3141,
   32085, -3141, 32085, -3141, 33169, 13577, -3141,  2958, -3141, -3141,
   -3141,  4084, -3141, -3141, 31543, 28833, -3141, -3141, 25049, -3141,
   -3141, -3141,  3313, -3141,  1712, -3141,  1390, -3141, 33169, -3141,
   -3141, -3141, -3141
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3141, -3141, -3141, -3141, -3141, -2729, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,  1675, -3141, -3141, -3141, -3141, -3141,
    1913, -1415, -3141, -3141, -3141, -3141, -3141,   718,    46,  2805,
       1, -3140, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,   461,   460, -3141, -3141,   285, -3141, -3141,  -289, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141,  -187,  -151, -3141,
   -3141, -3141, -3141,   443, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  -154, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141,   -77, -3141, -3141,   -33, -3141, -3141,
     -75, -3141, -3141,   -60, -3141, -3141, -3141, -3141,   -32, -3141,
     -30, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,   469,
   -3141, -3141, -1811, -3141, -3141, -3141, -3141,  2398,  -944, -3141,
    3116, -3141,  -371,   746,  1987, -1900, -1014,  -605,  -601, -1622,
   -3141, -3141, -3141,   402,  1117,  1511,   857,  2002,  2042,  1556,
    1602, -3141, -3141,   880, -3141, -2615, -3141, -3141, -3141,   845,
   -3141,   846, -3141, -3141, -3141, -1045,   814, -1632, -3141,   404,
     595,  1268, -3141,   608, -3141,   565, -3141,  -432, -2014, -1904,
   -3141, -3141, -3141,   578,   894,   940, -3141, -2629, -1713, -3141,
   -3141,   215, -3141, -3141, -3141,   206, -3141,   428,   286, -3141,
   -3141, -1472, -1737, -3141, -3141, -2302,  2440, -2690,   373, -1859,
   -3141,   416, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  1598, -3141, -3141, -3141,    92,  -262, -1319, -2764, -3141,
   -3141, -3141, -3141, -3141, -3141,  1284, -3141, -3141,  2123,  2551,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141,  1736, -3141, -3141, -3141, -3141, -3141, -3141,  2479, -3141,
   -3141, -3141,  1356, -3141, -3141, -3141, -3141,  2185, -3141, -3141,
    2913, -3141, -3141, -3141, -3141,  1359,  1771, -3141, -3141, -3141,
    2944,  1745,  -451, -1722, -3141,  3151, -3141, -3141, -3141, -1332,
   -1476, -3141,  3014,   357, -2306,  2195,  -493,   748, -3141,   547,
    -744,  4357, -3141, -1274, -1092, -3141, -3141,  -486, -3141, -3141,
   -3141, -1253,  -734, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
     753, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -1135, -3141,  1563, -3141, -1049, -3141, -3141, -3141,  2406,
   -3141, -3141, -3141, -3141, -3141, -1876, -1481,   978, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -1851, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -1325, -3141, -1748, -3141, -3141,
    -622, -3141, -3141,   271, -1803, -1177,  2363,   781, -3141, -3141,
    -949,  2461, -1535, -3141, -3141, -3141,  1415, -3141, -3141, -3141,
   -3141, -3141,   952, -1988, -1031, -3141, -3141, -2595,  -612, -1796,
    -592, -3141, -1827,   507, -1152, -1860, -3141, -3141, -3141, -3141,
      72, -3141, -3141, -3141,   532,  1767, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  -230,  -352,  1347, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141,  2694,  2676,  1809, -3141, -3141,
   -1915, -3141, -3141,  1792, -3141,   770, -1823,  2415,  1064, -3141,
   -3141,  1066, -2597, -3141, -3141, -3141, -3141, -3141, -3141,  1005,
      35,   222,  3224, -3141, -3141, -3141, -3141, -3141, -3141,  2940,
    2524, -1469,  3169, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141,  3241, -3141,  -973, -3141,  -505, -3141, -3141,  -588,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,  2300,
   -3141,  1279, -3141, -3141, -3141,  2700, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141,  1090,   163, -3141,   333,   144, -3141,   273,
   -3141, -3141, -3141,    42, -3141,  -753,  -666,  -992,   699, -2625,
   -1063,  1085,  2699, -2748, -1130, -1266, -1264, -1784,    21, -3141,
      -7,  -478,  -885,  -529,  2768, -2137,  -411,  -497, -3141,   909,
   -3141, -3141, -3141, -3141,  2267, -3141, -3141, -3141, -3141,  1392,
   -3141, -3141, -3141,  1055, -3141,   782,   579, -3141, -3141,  3152,
   -3141,  2294, -3141, -3141, -3141, -3141, -3141, -3141, -3141, -3141,
   -3141, -3141, -3141, -3141, -3141, -3141,  2719,  3276,  3119, -3141,
    2760, -3141, -3141, -3141, -3141, -3141,   456, -3141,   420, -3141,
   -1843,  2574,   491, -3141,  1472,  -494,  -795, -3141,   451, -3141,
   -3141,  1030,  3281,  3125, -3141, -3141, -3141, -3141, -3141, -2213,
    -584, -3141, -2276, -3141, -3141, -3141, -3141,  1514, -1159,  2426,
    1163, -3141, -3141, -3141,  3228,  3332,  3337, -3141, -3141,   737,
   -3141,  3253,  -303, -3141,  1694, -3141,   973, -3141, -3141,   705,
    3236, -3141, -3141,  3243, -3141, -3141, -3141, -3141, -3141,  3244,
   -3141, -3141, -3141, -3141, -3141,  1552, -3141, -3141, -3141, -3141,
   -3141, -3141
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1984
static const yytype_int16 yytable[] =
{
     374,   555,   715,   723,   704,   639,   668,  1071,   991,  1616,
    1162,  1364,   374,  1186,  1404,   374,  1177,  1178,  1180,   910,
    1650,  1744,   374,  1745,  1459,  1018,  1033,  1013,  1617,  1618,
    1619,  2202,   374,  2347,  2310,  1494,  1648,  1953,  1766,  2322,
    2246,  1631,   374,   409,  2647,  1774,  1018,  2332,  2474,  2336,
    1969,  1034,  2264,   373,  1808,  2477,  2455,  2607,  1468,  1640,
    1911,  2044,  2674,  2938,  2294,  2299,  2302,  1543,  2953,  1471,
    1472,  2331,  1076,  2945,  2314,  2315,  1077,   972,  1788,  1790,
     374,  1370,  2283,  1244,  2976, -1488, -1489,  2977,  1408, -1824,
     969,  -252,   653,  2364, -1825,  1689,  2366,  1877,  1693,  1687,
     374,   374,  1270,   374,  -536,  1274,  2986,  -262,   465,  1268,
    -263,   948,  3005, -1113,   374,  2978,  2385,  2386,  2046,  1622,
    1623, -1888,  1625,  1283,  1284,  1285,  1720,  1721,   948,   731,
    1497,  1726,  2048,  3112,  3251,  1037,   943,  3006,  1304,  1305,
     657,  2452,   482,  1294,  1295,  1296,  1304,  1305,  3298,  3048,
    3649,  1743,  2661,  1747,   470,  1338,   471,  1659,   488,  1709,
    1304,  1305,  2353,  2060,  1927,  1304,  1305,  1387,  2353,  1589,
    1277,  2365,  1679,  2330,  2368,  1304,  1305,  1853,   940,  3084,
    1370,  1933,  3165,   106,  1082,  2377,  2378,  3146,  2447,  1092,
    1699,  1700,  1701,   725,  2387,  1985,  3135,  2662,  3402,  1003,
     687,  1708,  1304,  1305,  1421,  1015,  2675,  1602,  1093,  1073,
    2354,  2355,  1073,  1304,  1305,  1073,   609,   610,  1842,  1139,
    1140,  1141,  2614,  1304,  1305, -1488,  2445,   978,  1776,  1419,
    1901,  1779,  1780,  1781,  1782,   949,  1784,  1785,  1786,  1787,
    1789,  1791,  1792,  1793,  1794,  3437,  1304,  1305,   685,  2966,
     503,  1454,   949,  2312,  1304,  1305,   695,   696,  3138,   609,
     610,  2967,  1898,   107, -1113,   577,   569,  2356,  2381,  1304,
    1305,  1304,  1305,  3510,  2968,  1304,  1305,  1425,   456,  2431,
    1059,  2966,  1019,   609,   610,  1304,  1305,   912,   932,  2891,
    2026,  3021,  1016,  2967,  1304,  1305,  3102,   954,  2447,  3022,
     956,  1364,  1304,  1305,   504,   658,  2968,  1118,  1027,  1304,
    1305,  1304,  1305,  1304,  1305,   609,   610,  2034,  1047,  1986,
     948,  1455,  1590,  2401,  2402,  3145,   989,  1304,  1305, -1488,
   -1489,   415,   552, -1824,  1843,  1278,   438,  3341, -1825,  1147,
     439,   121,   712,  1767,   832,  2382,  3171,   108,  2602,  3085,
    2379,   933,   378,   659,  2276,  3175,   983,  3267,  1388,  2943,
    2356,  2403,  1148,   106,  3342,  1304,  1305,  3145,  2408,  2168,
     381,  2947,  2317,  2448,  1662,  3188,  2357,  1663,  3437,  2356,
    3190,  1048,   109,  2404, -1943,  1364,  2432,  1426,  1490,  1364,
    1493,   374,   934,  2277,  1053,  1422,  1854,   957,  2583,  2584,
    2585,   374,  1337,   548,  3511,   374,  2005,   935,  1304,  1305,
     374,  2015,   505,  2027,  2405,   374,  3209,  2021,   457,   578,
    2024,  1304,  1305,   967,  3023,  2185,  1145, -1488, -1489,  2609,
    2610,  2611,  1461,  1008,  1371,   560,  2383,   374,   565,  2111,
    1467,  2541,  1853,  2615,   949,  3217,  3289,  3290,  1304,  1305,
    1361,   416,  1060,   550,  1085,   374,  1473,  1474,  1902,  1670,
    1899,   473,   697,  1040,  1389,   374,  1934,  1306,  2678,  1076,
    1307,   374,  2053,  1077,  1495,  1306,  2651,   374,  1307,   374,
     374,  2642,   484,  2448,   374,   374,  1004,  1456,  -341,  1306,
     958,  1844,  1307,   680,  1306,   374,  1907,  1307,   435,   374,
    3260,  1389,  2673,  2663,   374,   374,  2676,   374,   374,   374,
     374,  2456,  2660,   702,   703,   570,  2680,  1009,  1768,  1888,
    3403,  3426,  1953,   443,  1462,  1445,  1119,  1739,  1076,  1543,
    3367,  1306,  1077,  1371,  1307,  1470,  -508,   688,   110,  1855,
    3288,  1591,  1306,   374,  3512,  1307,  1409,  3299,  2284,  1304,
    1305,  2766,  1306,  2129,   941,  1307,  1407,  2133,  1889,   374,
     908,   909,  2454,  3113,  3650,  1953, -1113,   374,   374,  1304,
    1305,  3044,   374,   944,  2358,  1306,  2048,  2353,  1307,   374,
    2652,  2653,   659,  1306,  3088,  2979,  1307,   963,  1778,  2321,
    2171,  2353,  1304,  1305,  3404,  1087,   975,  2268,  1306,  1745,
    1306,  1307,   978,  1307,  1306,  1304,  1305,  1307,  1553,   374,
   -1113,  2223,  1279,  2224,  1306, -1488, -1489,  1307,  2218, -1824,
    1087,  3104,  2672,  1306, -1825,   978,  1307,   590,  1801,  1304,
    1305,  1306,  2880,  1497,  1307,  -134,  2406,  1448,  1306,  2313,
    1306,  1307,  1306,  1307,  -574,  1307,  1499,  1480, -1488, -1489,
    1597,  2047, -1824, -1888,  -252, -1113,  1306, -1825,  2335,  1307,
    1745,  1854,  1987,  1308,  3166,  2775,   374,  -536,  1304,  1305,
    -262,  1308,  3344,  -263,   374,  1020, -1113,   374,  2433,  1769,
     374,   374, -1113,  1373, -1888,  1308,  -341,  2419,  2205,  2898,
    1308,  2221,  1304,  1305,  1306,  1770,  3497,  1307,   713,   493,
    1308,  1028,  1304,  1305,  3386,  2227,  2228,  2204,  1010,   482,
     417,  1755,  1756,  2390,  2359,  1745,  1087,  1304,  1305,  1304,
    1305,  1304,  1305,   549,   374,  1579,   374,  1308,  3045,  3390,
     561,  2969,   422,  1362,  2551,  1554,  1406,  1306,  1308,   698,
    1307,  2612,  2613,  3427,  3509,  1029,  1415,  3430,  1308,  3432,
    1306,  3044,  1146,  1307,  1151,   429,  2069,  3003,  1664,  3211,
    2169,  1665,   442,  2969,  2030,  2901,  1041,  1795,  1320,  2051,
    2052,  1308,  1890,  3442,  2927,  2893,  2340,  1306,  2931,  1308,
    1307,  2595,   682,  2031,  2416,  1364,  1361,  1481,  1796,  2775,
    2264,  1482,  2083,  2084,  1308,   459,  1308,  1138,  3046,  2928,
    1308,  2070,  2206,  2932,  1855,  2367,   448,  2369,  1606,  3448,
    1308,  2946,  2374,  2918,  1011,  2186,  2902,  2085,  2086,  1308,
     714,  2089,  2090,  2482,  2483,  1550,  -341,  1308,  2392,  1771,
    2394,  2395,  2399,  3347,  1308,  3148,  1308,  2327,  1308, -1113,
    2096,  2097,   699,  3348,  3499,  1304,  1305,   449,  2050,  3489,
    2328,  1087,  1308,  2637,  1364,  2101,  2102,  2104,  2105,  2106,
    2107, -1983,  1933,  2665,  2279,  1304,  1305,  2207,  1042,  2219,
    2638,  1012,  1807,  2118,  2119,   374,  1904,   374,  1306, -1362,
    1906,  1307,  1932,  1909,  1910,  1920,  2353,  1043,  2301,  3149,
    1308,  1761,  1304,  1305,   460,  2212,  1304,  1305,  1306,    40,
     374,  1307,  1018,   700,  2646,  2656,   374,  1092,  3045,  1459,
    1459,  2122,  2123,  3084,  1849,  1850,   450,   556,  1607,  2768,
     674,  1306,  1304,  1305,  1307,  1435,  1093,  1797,  1368,  1304,
    1305,  1848,  3677,  1308,  1306,  2318,  2417,  1307,   114,   659,
    1551,  1867,  3042,   374,  3295,   374,  1308,   374,  2568,  3131,
    1800,  1323,  2280,  2008,  3038,  2049,  3170,   581,  1306,   374,
     374,  1307,   462,  1809,  3047,  1893,  1044,  2135,  2136,   374,
     374,   768,  1076,  1308, -1946,  3312,  1077,  2337,  3049,  1543,
     374,  1304,  1305,  3313,  2436,  1304,  1305,  1304,  1305,  3366,
    1436,   472,  2598,  2639,  1745,  2067,  3500,  1306,  2515,  1030,
    1307,  3323,   374,   374,   374,   374,  3642,   557,  1891,  1297,
    2685,  2009,   374,  2329,   374,   115,  1304,  1305,  2475, -1362,
     374,  1306,  1938,  2480,  1307,  2188,  1304,  1305,  3021,   781,
     374,  1306,  1451,  1452,  1307,  2514,  3022,  1045,  2488,    51,
    2208,  3349,  1304,  1305,  3368,  2493,  1306,   582,  1306,  1307,
    1306,  1307,  2543,  1307,   824,  1449,  1450,  2563,  1469,  2681,
    2502,  2503,  2226,  3424,  1035,  1460,  2570,  2507,   430,  1362,
    2213,   558, -1946,  1466,  1308,  2512,  1437,   374,  3124,  3125,
     374,  2006,  2007,  3085,  2014,  2657,  2016,  2017,  2018,  2019,
    2020,  1798,  2022,  2023,  1308,  2139,  2140,   824,  3118,  2457,
     675,  2350,  2437,  1859,  2686,  1552,   492,  1031,  1304,  1305,
    2010,   583,  3150,  3443,  2530,  2141,  2142,  1308,  1036,  3269,
     516,  1304,  1305,  3296,  2937,   676,   499,  1606,   808,   374,
    1308,   374,   484,   374,   374,   374,   374,   374,  2149,  2150,
     451,   574,  1480,  1086,  3047,  1032,   374,  1934,   374,  1647,
     479,  2152,  2153,  3306,  1308,  1304,  1305,  1304,  1305,  3462,
     452,  3023,  3199,  1438,  1587,  1304,  1305,  1304,  1305,  1304,
    1305,  1606,   473,  3350,  1306,  2161,  2162,  1307,  3314,  3086,
    2011,  1874,   374,  1874,  2578,   453,  1583,  1584,  2233,  2939,
    2939,  2939,  1610,  1308,  1306,  2484,  2234,  1307,   829,  1333,
    1334,  1335,  1336,  2489,  1610,  3297,  1304,  1305,  2391,   467,
    1304,  1305,   854,  1606,  2174,  2175,  2351,  1308,  1953,  1606,
    1087,  1306,   374,  1859,  1307,  1306,  3213,  1308,  1307,  1860,
     989,  2214,   454,  3155,  1875,   730,  1184,  1630,  2193,  2194,
    1304,  1305,  1308,  3037,  1308,  3277,  1308,  2215,  2195,  2196,
    1611,  1306,   440,  3164,  1307,   854,  3169,  1016,  1306,  3622,
    2438,  1307,  1611,  2564,  2565,  2822,  2823,  2826,  2827,  1304,
    1305,  1304,  1305,  3623,   485,  1304,  1305,  1304,  1305,  1184,
     374,  1688,  1481,  3148,  1304,  1305,  1482,  1612,  1304,  1305,
    1304,  1305,  1304,  1305,  3189,   374,  1185,  3191,  2876,  1612,
     490,  1945,  3200,  2203,   441,  2794,  2795,  3087,   824,  3156,
    1306,  1304,  1305,  1307,  1306,   488,  1306,  1307,  3088,  1307,
    2233,  1304,  1305,  1692,  3369,  1861,  1862,   386,  2623,  1725,
    3503,  3504,  3162,  3163,  1304,  1305,   593,  3149,   500,  2268,
    2439,  1745,  1304,  1305,  3157,  1306,  2012,   510,  1307,  1613,
    3173,  2199,  1304,  1305,   374,  1306,  3176,  1493,  1307,   374,
     374,  1613,   374,  1863,   862,  2200,  3412,   374,  1859,  2062,
    1308,  1306,   547,   374,  1307,   374,   406,   702,   703,  3192,
     374,   374,  3194,   374,   419,  3529,  1304,  1305,  3413,   425,
    1308,  2061,  2335,  3089,  1745,   374,  3572,  3370,   374,  3552,
     502,  1967,  1121,  2287,   374,   374,   374,   374,  1819,  1819,
    3552,  1819,  2068,  2063,   374,   374,   374,  1308,  2390,  1614,
    1745,  1308,  3371,  1841,  3586,  3586,   963,  1304,  1305,   568,
    1384,  1614,   374,  1385,   975,  1852,  1386,  1306,  2848,  2849,
    1307,   374,  1819,  1819,  1819,   564,   594,  1308,  1092,  2913,
    1306,  1304,  1305,  1307,  1308,  1304,  1305,  3307,   374,  1304,
    1305,  2396,  2914,   374,  2397,   650,   854,  1093,  2873,  2874,
    1861,  1862,  2815,  3346,   578,   374,  2071,  2300,   669,  2304,
    2309,   374,  2370,  2371,  1306,  2567,  1306,  1307,   670,  1307,
    1184,  1908,  2915,   117,  1306,   118,  1306,  1307,  1306,  1307,
     550,  1307,  1122,  2393,  2980,  1123,  1308,  2981,  2601,  1926,
    1308,  1916,  1308, -1113,  1102,  1103,  2872,  1124,   824,  1304,
    1305,  1304,  1305,   681,   595,  2346,  2300,  2065,   948,   682,
    2372,  3226,  3227,  3393,  3394,  1306,   691,   423,  1307,  1306,
     374,  1308,  1307,   609,   610,   117,  2966,   118,   374,   904,
    1269,  1308,  1498,  1304,  1305,  3418,  3457,  3419,  2967,  1304,
    1305,  1015,   711,  2076,  1304,  1305,   106,  1308,   907,  1306,
     914,  2968,  1307,  2077,   929,   374,   931,  3446,   936,  1015,
     609,  2972,  2237,  2238,   938,  1615,  3519,   374,   946,  2080,
     374,  1304,  1305,  3383,  3043, -1113,   947,  1615,  1306,  1968,
    1306,  1307,  1955,  1307,  1306,  1958,  1306,  1307,   109,  1307,
     961,  1304,  1305,  1306,  1970,  2042,  1307,  1306,   962,  1306,
    1307,  1306,  1307,  1978,  1307,   970,  2598,   981,  1745,   713,
     982,  1113,  1114,  1308,   985,  1304,  1305,  1304,  1305,   989,
    1306,  1917,  1125,  1307,  -545,   986,  1308,  1509,  1304,  1305,
    1306,  2300,   949,  1307,  1510,  2087,  1918,  2961,  2300,   992,
    2964,  2965,  1000,  1306,  1511,  1512,  1307,  3067,  2088,  1919,
    1001,  1306,  1304,  1305,  1307, -1113,   854,  2982, -1113,  1002,
    1308,  1306,  1308,  1006,  1307,  1007,   991,  1021,  1304,  1305,
    1308,  1025,  1308,  1513,  1308,  2426,  2427,  1514,  1016,  2643,
    1184, -1113,  2092,  1022,  2094,  1304,  1305, -1113,  1515,   609,
     610,  1026,  2095,   682,  2099,  1306,  2100,  1516,  1307,  1018,
   -1113,  1126,  1517,   648,   649, -1113,   652,  1304,  1305,  1023,
    2645,  1308, -1113,  3253,  1518,  1308,  2604,  2605,  2866,  2574,
   -1113,  1024,  3571,  1920,   512,  1038,   514,  1039,   515,  1073,
     517,   714,  1519, -1113,  1052,   374,  1306, -1113,  2594,  1307,
    1273,  1520,  1521,  1304,  1305,  1308, -1113,  1522,   596,   597,
     598,   599,   600,   601,  1054,  1523,  1916,  1459,  1304,  1305,
    1306,  1524,  1055,  1307,   602,  1304,  1305,  2109,  1306,  2689,
    2690,  1307, -1983,  1057,  1308,  1062,  1308,  1067,  2561,  1083,
    1308,  1073,  1308,  1130,  2636,  1084,  1525,  2621,  1822,  1308,
    1823,  1304,  1305,  1308,  1131,  1308,  2113,  1308,  2114,  1132,
    1304,  1305,  2116,  1137,  2117,  3081,  1134, -1113,  3617,  3254,
    3255,  2121,  1921,  3256,  3257,  2124,  1308,  2125,  1136,  2137,
    1138,  1869,  1870,  1871,  2545,  1143,  1308, -1113,  1306,  1142,
    1306,  1307,  1526,  1307,  1527, -1113,   374,  1144,  2151,  1308,
    1153,  1528,  2763,  2690,  1157,   913,   659,  1308,  2158,  3016,
    3017,  1155,  1304,  1305,   374,   374, -1113,  1308,  3096,  3097,
    2075,   374,  1306,   374,   374,  1307,  1922,  1374,  1306,  2159,
    1158,  1307,  1159,  1306,  1162,  2679,  1307,  3215,  3216,  2160,
    1304,  1305,  2682,  3222,  3224,  1160,  1917,  1366,  1304,  1305,
    1161,  1308,  1163,  1304,  1305,  1164, -1113,   374,  3291,  3216,
    1306,  1918,  1165,  1307,  1304,  1305,  1166,  1529,  1367,   374,
     374,  2846,  1167,  2163,  2649,  1168, -1113,  3361,  3362,   374,
    1306,  1530,  1169,  1307,  1170,   374,  1531,  1171,   374,  3364,
    3216,   374,  1308,  1304,  1305,  3365,  3216,  1172,  1304,  1305,
    1377,  2300,   374,   374,  1306,   374,  1306,  1307,  1173,  1307,
   -1113,   374,   374,  1174,  2167,  3120,  1308,  1306,  3374,  3375,
    1307,   374,  1175,   374,  1308,  1363,  1532,   374,   374,  1176,
    1304,  1305,  1533,  1179,  1534,  3376,  3377,  1181,  2170,  3378,
    3377,  1306,   663,   664,  1307,   665,  2187,   666,  1920,  2400,
    3459,  3362,  1182, -1113,  1183,  1535,  1536,  1306,  1537,  1187,
    1307,  1304,  1305,  3460,  3362,  1188, -1113, -1113,  2969,   374,
     374,  1189,  1538,  1190,  1306,  3646,  3647,  1307,  1191,  1121,
    2941,  2942,  1192, -1113,  1308, -1113,  1308,  1304,  1305,  1369,
    2973,  2737,  1731,  1731,  1539,   374,  1306,  2442,  1193,  1307,
    1304,  1305,   374,  1194,  1304,  1305,  2792,  1195,  2802,  1304,
    1305, -1113, -1113,  1196,  1745,   374, -1113,  1197,  1308,  3292,
    3293,  1198,  1304,  1305,  1308,  2905,  2906,  3094,  3095,  1308,
    2882,  2883,  1306,  1199,  1200,  1307,  3328,  1921,  1304,  1305,
    2808,  1201,  3333,  3334,  3335,  3336,  2817,  1306, -1113,  1379,
    1307,  2818,  1304,  1305,  1306,  1378,  1308,  1307,  1202,  1203,
    1204,   374,  1205,   948,  1399,  1206,  1207,  1208,  1304,  1305,
    1209,  1210,  1211,  1212,  1213,  1540,  1308,  1214,  2840,  1122,
    1306,  1381,  1123,  1307,  1541,  1215,  1217,  1304,  1305,  1306,
    1218,  1922,  1307,  1219,  1124,  1304,  1305,  1220,  2850,  1221,
    1308,  1222,  1308,  1223,  1224,  1225,  1226,  1230,  1400,  1304,
    1305,  1304,  1305,  1308,  3581,  1231,  1403,  1304,  1305,  1232,
    1610,  1745,  2852,  1233,  2853,  1304,  1305,  1304,  1305,  1234,
   -1113,  1304,  1305,  1304,  1305,  3233,  3330,  1308,  1235,  1236,
    1237,  1306,   374,  -545,  1307,  1238,  2910,  -545,  1239,  1304,
    1305,  1304,  1305,  1308,  1240,  1304,  1305,  1443,  2078,  1241,
    1304,  1305,  2346,  1243,  1304,  1305,  1245,   374,  1246,  1306,
    1308,   374,  1307,   374,   374,   374,   374,  1306,  1611,  1247,
    1307,  1248,  1306,  1249,   374,  1307,  1250,   949,   374,  1304,
    1305,   374,  1308,  1306,  1304,  1305,  1307,  1251,  1304,  1305,
    1252,  3028,  1253,  1254,  1255,   374,   374,   374,  1304,  1305,
    1256,  1257,  1841, -1113,  1258,  1612,  1259,  1260,   374,  1125,
    1261,  3032,  1306,  1262,   374,  1307,   374,  1306,  1308,  1263,
    1307,  1264,  1265,  1266,   374,  1267, -1113,  1271,  1272,  1275,
    1304,  1305, -1113,  1308,  1304,  1305,  1276,  1280,  1412,  2079,
    1308,  1281,  1405,  1304,  1305,  1282,  1286,  1304,  1305,  1306,
   -1113,  1287,  1307,  1414,  2847,  1288,  1289, -1113,  1304,  1305,
    1411,  2098,  1290,  1304,  1305, -1113,  1308,  1613,  1291,  1365,
    1382,   552,  1447,  1413,  3630,  1308,  1745,  1420, -1113,  1428,
    1306,  1434, -1113,  1307,   374,  1304,  1305,  2112,  1126,  1304,
    1305, -1113,  1475,  1304,  1305,   374,  2115,  1745,   374,  1463,
    1477,  1304,  1305,  1479,  1491,  1087,  1306,  1555,  1557,  1307,
    1556,  3630,  1558,  1745,  1559,  2574,  1186,  1270,  1274,  1306,
    3229,  1560,  1307,  1306,  3568,  1573,  1307,  1308,  1306,  1561,
    1562,  1307,   374,  1304,  1305,  1563,  1564,  1614,  1565,   374,
    1566,  1306,   374,  1567,  1307,  1568,   374,   374,  2131,  1569,
     374,  1570, -1113,  1571,  1572,  1308,  1580,  1306,   374,  1574,
    1307,  1578,  1594,  1308,  1582,  3309,   374,  1361,  1308,  1606,
    2692,  1306, -1113,  1599,  1307,  3119,  2132,  1634,  1279,  1308,
   -1113,  1654,  1304,  1305,  2138,  1668,  1685,  1306,  1717,  2146,
    1307,  1742,  1751,  1757,  2761,  1777,  1783,  1304,  1305,  1762,
    2147, -1113,  1799,  1810,  1304,  1305,  1306,  1835,  1308,  1307,
    1304,  1305,  1811,  1308,  1306,  1868,  1882,  1307,  1838,  1304,
    1305,  1304,  1305,  1894,  1896,  3305,  3109,  1903,  1306,  2148,
    1306,  1307,  1925,  1307,  2156,  1924,  1306,  1928,  3305,  1307,
    1929, -1113,  1931,  3178,  1306,  1308,  1306,  1307,  3657,  1307,
    1306,  1939,  1306,  1307,  1940,  1307,  1944,  1941,  1942,  1945,
    1943, -1113,  1304,  1305,   383,  3167,  2157,  1962,  1306,  1963,
    1306,  1307,  3202,  1307,  1306,  1965,  1308,  1307,  1087,  1306,
    1971,  1974,  1307,  1306,  1979,  1966,  1307,  2222,  1973,  2300,
    1993,  1304,  1305,  1304,  1305, -1113,  3379,  2164,   396,  2033,
    2043,  2047,  1308,  1615,  1304,  1305,  2054,  2057,  1306,  2346,
    2056,  1307,  2058,  1306,  2059,  1308,  1307,  1306,  2064,  1308,
    1307,  1304,  1305,  2173,  1308,  2066,  2073,  1306,   374,   374,
    1307,   374,  1304,  1305,  2287,  1343,  2178,  1308, -1113,  2074,
     374,  1304,  1305,  1304,  1305,  2189,   374,   384,  2081,  1304,
    1305,  2091, -1113,  1308,  1304,  1305,   374,  2082,  2197,  1306,
     991,  2093,  1307,  1306,   374,  2108,  1307,  1308, -1113,  2210,
   -1113,  2127,  1306,  2103,  2772,  1307,  1306,  1304,  1305,  1307,
    2120,   374,   397,  1308,  2126,  2130,  -513,  1306,  2773,  2134,
    1307,  2128,  1306,   374,  1320,  1307, -1113, -1113,  2176,  2143,
     374, -1113,  1308,  1729,  2774,  1304,  1305,   374,  2144,  2145,
    1308,  2154,  2165,   374,  1306,  2166,  2464,  1307,  1306,  2172,
     398,  1307,  1306,  2789,  1308,  1307,  1308,  2177,  2572,  2910,
    1306,  2797,  1308,  1307,  1304,  1305,  3315,  3316,  1347,  2465,
    1308,  3431,  1308,  2190,  2191,  2798,  1308,  2801,  1308,  1304,
    1305,  2192,  -954,  2803,  -778,  2216,  1304,  1305,  1336,  2225,
    2241,  2806,  1306,  2807,  1308,  1307,  1308,  2809,  2236,  2810,
    1308,  3450,  3451,  2239,  3453,  1308,  2242,  2240,  2466,  1308,
    2243,  2467,  2249,  2251,  2253,  2811,  2300,  2812,  2254,  2468,
     374,  2820,  2259,  2255,  2271,  2272,  2821,  1875,  2273,  2292,
    2824,  2274,  1320,  1874,  1308,   375,  1610,  2319,  2291,  1308,
    2323,  1306,  2293,  1308,  1307,  2316,  3493,   405,  3494,  3495,
     411,  3681,  2324,  1308,  2325,  2831,  1306,   420,  1348,  1307,
    2832,  2341,  1351,  1306,  2833,  1320,  1307,   431,  2348,  1306,
    1352,  2349,  1307,  2375,  2834,  2376,  1500,   447,  1306,  2423,
    1306,  1307,  2409,  1307,  2429,  1308,  2428,  3387,  1501,  1308,
    2424,  1493,   800,  2494,  1611,  2430,  2554,  1600,  1308,   -59,
    2504,  2461,  1308,   399,  2548,  2481,  2835,  1323,  2516,  2517,
    2836,  2536,  2557,  1308,  2558,   466,  2566,  2573,  1308,  2837,
    2559,  1306,   374,  2838,  1307,  3384, -1008,  2560,  2586,  2581,
    2588,  1612,  2592,  1353,  2839,   469,   375,  2603,   375,  2841,
    1308,  2608,   385,  2600,  1308,   374,  2619,  2625,  1308,   466,
    1306,  2606,  1306,  1307,  2620,  1307,  1308,  2633,  2644,  3439,
     374,  2842,  2655,  1306,  2650,  2845,  1307,  2654,  2658,  2851,
    2670,  2671,  2750,  2684,  2754,  -268,   386,  2854,  2760,  2759,
    1306,  1355,  2762,  1307,  2764,  2767,  2775,  2769,  1308,  2779,
    2784,  1306,  2785,  1613,  1307,  2234,  2869,  2786,  2787,  2788,
    1306,   374,  1306,  1307,  2790,  1307,  2791,   387,  1306,  2856,
     400,  1307,  2796,  1306,  2799,  1323,  1307,   388,  2800,  -340,
     916,  2804,  2805,   374,  2813,   401,   521,   522,  1945,  2816,
    1325,  1326,  2819,  2469,  2825,  2843,  1306,  1308,  2862,  1307,
    1946,  1320,  2888,   374,  1502,  2871,  2875,  2989,  1323,  2890,
    2878,   402,  1308,  2892,  2879,  1916,  1916,  2903,  2858,  1308,
    1859,  2911,  2919,  1614,  1306,  1308,   403,  1307,   374,  2920,
     374,  2923,  2924,  2860,  1308,  3490,  1308,  2929,  2926,  2930,
    2861,   374,  2949,   374,  2944,  2950,  2863,  2990,  3542,  2948,
    3012,  2991,  3439,  1306,  1356,  2864,  1307,  3073,   523,  2955,
    3015,  3029,  1320,  3020,   917,  2962,  1358,  3030,  1306,  3206,
    3034,  1307,  3051,  1503,  3052,  1306,  3053,  1308,  1307,  3056,
    2778,  3058,  3063,  3064,  2783,  3065,   524,  3076,  -340,  3078,
    3092,  3099,  2992,  3080,  3542,   374,  1947,  1504,  3074,  2300,
     525,  3103,  2623,  2828,  1320,  3097,  1308,  2470,  1308,  3105,
    1320,  1329,  1330,  1331,  1332,  1333,  1334,  1335,  1336,  1308,
     918,  3106,   526,   374,  3111,  3110,  3114,  3075,  3121,  3225,
    1320,  1325,  1326,   527,  3116,  1092,  1308,  3117, -1042,  3132,
    3228,  3130, -1047,   374,   919,  1917,  1917,  1308,  1505,   374,
     374,  3136,  3137,  3006,  1093,  2471,  1308,  3232,  1308,  3161,
    1918,  1918,   528,   374,  1308,  3003,  1500,  3172,  3234,  1308,
    3174,  3182,  3183,  1919,  1919,  3184,   119,  3235,  1501,  3238,
     374,   379,   380,  2472,  1323,  3240,   513,   529,  3672,  1615,
    3241,  3186,  1308,   530,  3187,  3203,   546,  3193,  3204,   418,
     554,  3197,  3218,  3231,   424,   466,  2155,  3219,   428,  3220,
     573,  3221,  3672,  3242,  3222,  3223,  -479,  3436,   374,  1506,
    1308,  1331,  1332,  1333,  1334,  1335,  1336,  1916,   920,   374,
     531,  3230,   466,  3237,   921,  3236,  3645,  3239,  3248,  3245,
    3246,  3243,  3534,  1311,  1312,  1323,  3249,  1920,  1920,  1308,
     671,  3250,  1329,  1330,  1331,  1332,  1333,  1334,  1335,  1336,
     466,  3261,   922,  3270,  1308,  3276,   466,  3122,  3126,  3273,
    3244,  1308,   693,  3285,   466,   466,  3274,  3279,  3281,   705,
     554,  1313,  3310,  3576,  3224,  3396,  -340,  1323,   477,  3311,
     732,  3320,  3487,  1323,   737,  1314,  3321,  3322,   923,   905,
     906,  3325,   375,   375,   554,   466,  3326,  1325,  1326,   702,
     703,  2960,  3338,  1323,  2993,  3332,  3339,  3353,   924,   745,
    3355,  2994,  3380,  3358,  3613,  3360,  3382,  1315,  3381,  3405,
    3407,  3618,  3363,   925,  1502,   118,  1921,  1921,   953,  1316,
    3391,   532,  3392,  3395,  3397,  2984,  2985,  3637,  2995,  3408,
    3409,   374,   374,  2988,   466,  3410,  3416,  1917,   533,  3425,
    3011,  1948,   554,   466,   534,  3433,  1317,   466,  1325,  1326,
     535,   374,  1918,   374,   466,   374,   374,  2419,  3434,  3435,
    3401,  3664,  3139,  3665,  3441,  1919,  3445,  3452,   374,   768,
    1922,  1922,   745,  3454,   536,  3455,  3461,  3463,  2427,  3485,
    3496,  3514,  -210,  1503,   554,   537,   538,  3516,  2996,  3521,
    1325,  1326,  3522,  2829,  3523,  3529,  1325,  1326,   374,  -228,
   -1173,  3547,  1318,  3546,   702,   703,  -340,  1504,  1329,  1330,
    1331,  1332,  1333,  1334,  1335,  1336,  1325,  1326,  3548,  3567,
     779,   539,  3557,  3566,  3570,  3572,  3577,   781,  3578, -1746,
    3579,  3582,  3588,  3482,  3598,  3139,  3608,  3609,   374,  1920,
    3610,  1072,   768,  3612,  3615,  3616,  3619,  3620,  3624,   554,
    3625,  3631,   466,  3636,  3638,  1090,   466,   374,  1505,  3356,
    3482,  3482,   374,  3640,   796,   540,  3643,   541,  2997,  1329,
    1330,  1331,  1332,  1333,  1334,  1335,  1336,  3644,  3652,  3653,
    3655,  3675,  3680,   374,  1080,  2235,  2025,  3518,  3205,  3318,
    3208,  3682,  3658,   779,   374,  3663,  3595,  3553,  3596,   466,
     781,  1152,  3587,  3482,  3482,  3212,  3562,  3561,   501,  3036,
    3482,  1329,  1330,  1331,  1332,  1333,  1334,  1335,  1336,  1331,
    1332,  1333,  1334,  1335,  1336,  3482,   808,  3482,  1921,  1506,
    1992,  1577,  1824,  3482,  1511,  1512,  3287,   796,  1330,  1331,
    1332,  1333,  1334,  1335,  1336,  3482,  2752,  2956,  2446,  1996,
    1825,  1949,  2360,  2420,  3482,  3482,   518,  2951,  2974,  2975,
    3013,  3147,   374,  3303,  3185,  -465,  -465,  1514,  3177,  3482,
    1826,   567,  2952,  2917,  -465,   374,  3482,   576,  1515,  3423,
    3428,  3302,  1922,   824,  1827,  3373,  3482,  1516,  1593,  3324,
    3308,  2410,  3179,  3482,  2256,   828,   829,   655,  1851,   808,
    1913,  1091,  1478,   374,  1518,   374,  3482,   667,  1575,  3482,
    2591,  3482,  2252,   374,   587,   522,  1069,  2275,   996,  1073,
     374,  3340,  1519,  1873,   374,  3082,  2925,  1828,  1829,  3247,
    3482,  3083,  1684,  2478,  3422,  1732,  2954,  1632,  3284,  3590,
     374,  2571,  3272,  3482,  2282,  3482,  2248,   374,  1398,     1,
    1301,  1524,  1303,  1416,  2262,  1830,   824,  3482,  3482,     2,
       3,  3482,  3101,  2936,  2896,  2895,  3648,  3488,   828,   829,
     656,   374,     4,  1150,     5,   466,   738,  1598,   642,  1812,
    2889,   466,  1418,  3541,  3411,  3564,   523,  3456,  2688,  3662,
    2899,  3181,     6,     7,  1432,  2641,  2921,  3275,     8,  1846,
    3115,  1883,     9,    10,  1423,   589,   984,  1391,  3331,  3337,
    2580,   591,  1581,  1831,   524,    11,   988,  2556,  1392,  2868,
    1395,   495,   466,  1753,  1527,   729,   496,   683,   525,  2441,
      12,  1528,   726,  3033,   466,   554,  2782,     0,  3210,   727,
     728,   854,     0,  3140,   466,   466,  3141,     0,     0,    13,
     526,     0,     0,  1832,     0,  1424,   860,     0,    14,    15,
      16,   527,   862,  1433,     0,   863,     0,     0,     0,     0,
       0,    17,    18,     0,     0,     0,     0,   375,   375,   466,
     466,     0,     0,     0,     0,     0,     0,   375,     0,   554,
     528,     0,     0,     0,    19,   375,     0,  1529,     0,     0,
       0,     0,     0,     0,     0,   466,     0,     0,     0,     0,
      20,  1530,     0,     0,   854,   529,  3140,  3142,  3143,  3141,
       0,   530,     0,     0,     0,     0,     0,     0,     0,   860,
       0,     0,     0,     0,    21,   862,     0,     0,   863,     0,
       0,    22,     0,     0,    23,     0,     0,     0,     0,     0,
       0,     0,   466,     0,     0,   466,     0,     0,   531,     0,
       0,     0,  1533,     0,  1534,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    25,
       0,     0,   522,  3472,     0,  1535,  1536,     0,  1537,     0,
    3142,  3143,     0,     0,     0,     0,     0,    26,     0,     0,
       0,     0,    27,     0,   554,     0,   554,     0,   375,   375,
    1586,   466,   375,     0,  1937,     0,     0,     0,     0,     0,
       0,   737,     0,  1601,  1539,     0,  1956,  1957,     0,  1959,
    1960,  1961,     0,     0,  1964,     0,     0,     0,     0,  1972,
       0,     0,     0,  1975,  1976,  1977,     0,     0,  1980,  1981,
    1982,  1983,  1984,   523,  1989,  1990,  1991,  1641,     0,     0,
    3539,     0,  2958,  2959,     0,     0,     0,     0,     0,   532,
    2782,     0,     0,  2782,  2782,  3556,     0,  3556,     0,     0,
       0,   524,     0,  3563,     0,     0,   533,    28,     0,     0,
    2782,     0,   534,     0,     0,   525,     0,  1641,   535,     0,
       0,     0,     0,     0,  2987,  1540,     0,     0,    29,  3004,
    3007,  3009,  3010,     0,  1541,    30,     0,   526,     0,  3556,
       0,     0,   536,     0,     0,     0,  3607,     0,   527,     0,
       0,     0,     0,   537,   538,    31,     0,    32,    33,     0,
       0,    34,     0,     0,    35,     0,    36,     0,     0,     0,
       0,    37,     0,    38,     0,  1746,  3556,   528,     0,     0,
       0,  3556,    39,     0,     0,     0,    40,     0,     0,   539,
     554,     0,    41,  2451,     0,     0,     0,    42,     0,     0,
    3556,    43,   529,     0,     0,     0,     0,     0,   530,     0,
       0,     0,     0,     0,     0,     0,     0,     2,     3,     0,
      44,     0,     0,     0,    45,     0,     0,  3556,  3556,     0,
       4,  3679,     0,   540,     0,   541,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   531,     0,     0,     0,   554,
       6,     7,     0,     0,  1804,  1805,     8,   554,    46,     0,
       9,    10,   554,     0,     0,     0,     0,     0,   466,     0,
    1815,     0,     0,    11,    47,  1820,  1820,    48,  1820,     0,
       0,     0,    49,     0,     0,     0,     0,     0,    12,     0,
     466,     0,     0,   466,     0,     0,     0,     0,     0,   554,
     554,   466,   466,     0,     0,    50,     0,    13,     0,  1820,
    1820,  1820,     0,     0,     0,     0,    14,    15,    16,     0,
       0,     0,     0,     0,     0,     0,    51,  1886,     0,    17,
      18,  1511,  1512,     0,     0,     0,  1897,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    19,  1905,     0,     0,   532,     0,   466,     0,
       0,     0,  -465,  -465,  1514,     0,     0,     0,    20,     0,
    1915,  -465,     0,   533,     0,  1515,   466,     0,     0,   534,
       0,     0,     0,     0,  1516,   535,     0,     0,     0,     0,
       0,     0,    21,     0,     0,     0,     0,     0,     0,    22,
       0,  1518,    23,     0,     0,     0,     0,     0,     0,   536,
       0,     0,     0,     0,     0,     0,  1073,     0,     0,  1519,
     537,   538,     0,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1999,     0,    25,     0,     0,
       0,     0,     0,  2003,     0,     0,     0,     0,  1524,     0,
       0,     0,     0,     0,     0,    26,   539,     0,     0,     0,
      27,     0,     0,  1100,  1101,  1102,  1103,  1104,  1105,  3484,
    2028,  1106,  1107,  1108,  1109,  1110,  1111,     0,  1112,     0,
       0,     0,   466,     0,     0,  2045,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3484,  3484,  2373,     0,
     540,     0,   541,     0,     0,     0,     0,     0,     0,  2380,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1527,     0,     0,     0,     0,     0,     0,  1528,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3484,
    3484,     0,     0,     0,     0,    28,  3484,     0,     0,     0,
       0,     0,     0,     0,  2036,     0,     0,     0,     0,     0,
       0,  3484,     0,  3484,     0,     0,    29,     0,     0,  3484,
       0,     0,     0,    30,     0,     0,     0,     0,     0,     0,
       0,  3484,  1113,  1114,     0,     0,     0,     0,     0,     0,
    3484,  3484,     0,    31,  1529,    32,    33,     0,     0,    34,
       0,     0,    35,     0,    36,  3484,     0,     0,  1530,    37,
       0,    38,  3484,     0,  1509,     0,     0,     0,     0,     0,
      39,  1510,  3484,     0,    40,     0,     0,     0,     0,  3484,
      41,  1511,  1512,     0,     0,    42,     0,     0,     0,    43,
       0,     0,  3484,     0,     0,  3484,     0,  3484,     0,     0,
    2211,     0,     0,     0,     0,     0,     0,     0,    44,  1533,
    1513,  1534,    45,     0,  1514,     0,  3484,     0,     0,     0,
       0,     0,     0,     0,     0,  1515,     0,     0,     0,  3484,
       0,  3484,  1535,  1536,  1516,  1537,     0,     0,     0,  1517,
       0,     0,     0,  3484,  3484,     0,    46,  3484,     0,     0,
       0,  1518,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,    48,  1073,     0,     0,  1519,
      49,  1539,     0,     0,     0,     0,     0,     0,  1520,     0,
       0,     0,     0,     0,  1522,     0,     0,     0,     0,     0,
       0,     0,  1523,    50,     0,     0,     0,     0,  1524,     0,
       0,  2269,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    51,     0,     0,     0,     0,  2288,
    2290,     0,     0,  1525,     0,     0,   554,     0,   554,   554,
       0,     0,  2693,  2694,     0,     0,     0,     0,  2695,     0,
    2696,  2697,  2698,  1339,  1340,  1341,  1342,  1343,     0,     0,
       0,     0,  1540,     0,     0,     0,  2699,     0,     0,     0,
       0,  1541,  1746,     0,     0,     0,     0,     0,     0,     0,
       0,  1527,     0,     0,   554,   554,     0,     0,  1528,     0,
       0,     0,     0,     0,  1999,     0,     0,     0,     0,     0,
    1999,     0,     0,  1999,     0,  2700,  1999,     0,  2701,     0,
       0,     0,     0,     0,     0,     0,  2702,  1999,  1999,     0,
     554,     0,     0,     0,     0,     0,  1999,  1746,  2037,     0,
       0,     0,     0,     0,     0,  2703,   466,     0,   554,     0,
       0,     0,  1999,  2415,     0,     0,     0,     0,  1511,  1512,
       0,     0,  2704,     0,  1529,     0,     0,  1344,  1345,  1346,
    1347,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,  2705,  1531,  2706,     0,     0,     0,     0,  -465,
    -465,  1514,     0,     0,   466,  1999,     0,     0,  -465,     0,
       0,     0,  1515,  2707,  2708,     0,     0,     0,     0,     0,
       0,  1516,     0,     0,     0,     0,     0,     0,     0,     0,
     554,     0,     0,  1532,     0,     0,     0,   554,  1518,  1533,
       0,  1534,     0,     0,     0,     0,     0,     0,     0,     0,
    2485,     0,     0,  1073,  2709,     0,  1519,     0,     0,     0,
       0,     0,  1535,  1536,     0,  1537,   885,     0,     0,     0,
    1348,     0,  1349,  1350,  1351,     0,     0,     0,     0,  1538,
       0,  2710,  1352,     0,     0,  1524,     0,     0,     0,     0,
    2711,  2712,     0,  2713,     0,     0,  1641,     0,     0,     0,
       0,  1539,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1511,  1512,     0,     0,     0,     0,   955,
       0,  2714,  2715,  2716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2717,  2718,  2719,     0,  1353,  1514,  2720,     0,     0,
    2721,     0,     0,     0,     0,     0,     0,  1515,  1527,     0,
       0,     0,     0,  2722,  2723,  1528,  1516,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   554,     0,     0,
       0,     0,  1540,  1518,     0,     0,     0,     0,  2724,     0,
    2725,  1541,  1354,  1355,     0,     0,     0,     0,  1073,     0,
       0,  1519,  2579,     0,     0,     0,  1815,     0,   953,   554,
     554,   554,  2726,     0,     0,     0,     0,     0,     0,   466,
       0,     0,   607,   554,   569,   608,  1746,     0,     0,     0,
    1524,  1529,     0,     0,     0,     0,     0,     0,     0,     0,
     554,   554,   554,     0,     0,  1530,   609,   610,  1099,  1320,
       0,     0,     0,  2622,     0,  2727,   611,  2728,   612,  2624,
       0,  2626,     0,     0,     0,     0,     0,  2729,     0,   554,
       0,     0,     0,     0,     0,   613,   614,     0,     0,     0,
       0,     0,     0,     0,   615,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1533,     0,  1534,     0,
       0,     0,     0,  1527,     0,     0,  1356,     0,  2730,  2731,
    1528,     0,  2732,  2733,  2734,  2735,     0,  1357,  1358,  1535,
    1536,     0,  1537,     0,     0,     0,     0,     0,     0,  1999,
       0, -1340,   616,     0,     0,     0,   617,     0,     0,     0,
     554,     0,     0,  1999,     0,     0,     0,     0,     0,     0,
       0,  1321,     0,     0,     0,  2736,  2737,  1216,  1539,     0,
       0,     0,     0,     0,     0,   618,     0,   619,     0,     0,
       0,     0,  1322,     0,  2738,     0,  1529,   466,     0,   620,
       0,   621,     0,  1242,  2691,     0,     0,   466,     0,     0,
    1530,  2747,  2748,     0,     0,  2751,     0,     0,     0,     0,
       0,     0,     0,  2758,   622,   623,     0,     0,   624,     0,
       0,   466,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   625,     0,     0,     0,     0,     0,     0,
       0,     0,  1323,  1292,     0,     0,     0,  1299,     0,  1540,
       0,  1533,     0,  1534,   626,     0,     0,     0,  1541,   627,
       0,   702,   703,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1535,  1536,     0,  1537,     0,     0,
       0,     0,     0,   628,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1539,     0,   629,     0,     0,     0,     0,
       0,  1324,     0,     0,   630,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   631,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1431,     0,     0,  1325,  1326,   632,   633,     0,
       0,  1446,     0,     0,  1327,     0,     0,     0,     0,     0,
       0,     0,     0,  2269,  2900,     0,   554,     0,     0,     0,
       0,     0,     0,     0,  1540,   554,     0,     0,     0,     0,
       0,  2579,     0,  1541,     0,     0,     0,     0,     0,     0,
       0,   554,     0,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,     0,     0,     0,     0,     0,   634,     0,     0,
       0,     0,     0,     0,     0,     0,  1746,   635,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1999,     0,
       0,     0,     0,     0,     0,  1999,     0, -1771,     0,     0,
       0,   636,  1746,     0,     0,     0,     0,     0,  1999,     0,
       0,     0,     0,     0,   637,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1328,  1329,  1330,  1331,  1332,
    1333,  1334,  1335,  1336,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1603,  1604,  1605,     0, -1771,     0,
       0,     0,   638,  1620,  1621,     0,     0,  1624,     0,  1626,
    1627,  1628,  1629,     0,     0,  3041,  1633,     0,     0,  1635,
    1636,     0,  1637,     0,  1638,  1639,     0,  1642,  1643,  1644,
    1645,  1646,     0,  1649,     0,  1651,  1652,  1653,     0,  1655,
    1656,  1657,  1658,     0,  1660,  1661,     0,  1667,     0,     0,
    1671,  1672,  1673,     0,  1675,  1676,  1677,  1678,     0,  1680,
    1681,  1682,  1683,     0,     0,     0,     0,     0,  1690,  1691,
       0,  1694,  1695,  1696,  1697,  1698,     0,     0,     0,     0,
    1702,     0,  1703,  1704,  1705,  1706,  1707,     0,     0,  1710,
    1712,  1713,  1714,  1715,  1716,     0,  1718,  1719,     0,     0,
    1722,  1723,  1724,     0,  1727,     0,  1728,     0,     0,     0,
    1733,     0,  1737,  1738,     0,     0,     0,  3079,  1741,     0,
       0,     0,     0,     0,     0,     0,  1748,  1749,  1750,     0,
       0,     0,     0,     0,     0,  1299,     0,     0,  1758,     0,
    1746,     0,     0,     0,     0,  1763,  1764,  1765,     0,     0,
       0,     0,     0,     0,     0,   554,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3041,     0,     0,     0,
    1802,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   554,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   554,     0,
       0,     0,     0,     0,     0,  1847,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3195,     0,  3196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   466,     0,  2758,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   554,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3283,     0,
       0,     0,     0,     0,  3041,  3041,     0,     0,     0,     0,
       0,     0,     0,     0,  2004,     0,     0,     0,  3301,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   554,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3319,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3041,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2180,  2182,  2184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1746,   466,  2198,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3283,     0,  3283,     0,
    3420,  2003,     0,     0,  2217,     0,     0,     0,     0,     0,
       0,     0,     0,  3429,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2229,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3449,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1746,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3498,     0,     0,     0,     0,  3505,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   554,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3524,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3592,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3605,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1746,     0,
    3633,     0,     0,     0,     0,     0,     0,     0,  3641,     0,
       0,     0,     0,     0,     0,   554,     0,     0,     0,  1746,
       0,     0,     0,     0,     0,     0,  2459,     0,     0,  2460,
       0,     0,  2462,  2463,     0,  1746,     0,     0,     0,     0,
       0,     0,  3673,     0,     0,  2476,     0,     0,  2479,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2486,     0,  2487,     0,     0,  3673,  2490,     0,  2491,
    2492,     0,     0,     0,  2495,     0,  2496,  2497,     0,  2498,
       0,     0,  2499,     0,  2500,  2501,     0,     0,     0,     0,
    2505,  2506,     0,     0,  2508,     0,  2509,     0,  2510,     0,
    2511,     0,  2513,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2518,  2519,     0,     0,  2520,     0,  2521,
       0,     0,     0,     0,     0,     0,     0,  2522,  2523,     0,
    2524,     0,  2525,     0,     0,  2526,  2527,  2528,     0,  2529,
       0,     0,     0,     0,  2532,  2533,  2534,  2535,     0,     0,
       0,     0,  2537,  2538,  2539,     0,  2540,     0,  2542,     0,
    2544,     0,  2546,     0,  2547,     0,     0,     0,     0,     0,
       0,  2549,     0,  2550,     0,     0,  2552,  2553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2569,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2587,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2631,     0,     0,     0,     0,  2635,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2666,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2669,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2771,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2844,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2855,     0,
    2857,     0,  2859,     0,     0,     0,     0,     0,  2865,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2877,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2922,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3050,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3054,
       0,     0,     0,     0,     0,  3055,     0,     0,     0,     0,
       0,     0,     0,     0,  3059,  3060,     0,     0,     0,     0,
    3061,     0,     0,     0,  3062,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3066,     0,     0,
       0,     0,     0,  3068,     0,     0,  3069,  3070,     0,  3071,
    3072,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3077,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3128,  3129,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2666,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2666,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2631,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3327,     0,     0,     0,     0,     0,
    3329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3345,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3357,     0,  3359,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2666,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3444,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3458,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3527,  3528,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3549,     0,     0,     0,     0,     0,     0,
       0,     0,  3559,     0,     0,     0,     0,     0,     0,  3565,
       0,     0,     0,     0,     0,     0,     0,     0,  3575,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3599,     0,     0,
       0,     0,   122,     0,   739,   124,   125,   126,   127,     0,
       0,  3614,     0,     0,   128,     0,     0,   740,     0,   741,
     130,   131,   742,   133,     0,   134,   743,   135,     0,   744,
     136,   745,   746,   747,   137,   748,     0,   138,   139,  1734,
     140,     0,   141,   142,     0,     0,   143,   749,   144,     0,
     145,   750,   751,   147,     0,   148,   149,   150,   752,   151,
       0,   753,   153,     0,   154,   155,   156,   157,   158,   754,
     755,   159,  3674,   160,   161,     0,   756,     0,   757,   758,
     759,     0,     0,   163,   760,   761,     0,   762,   763,     0,
     164,   165,   764,   765,   766,     0,     0,     0,     0,   767,
     168,   768,     0,     0,   769,   770,   169,     0,   170,     0,
       0,     0,   771,   772,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     773,   179,     0,   774,   775,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   776,     0,   188,   777,
     189,   778,   779,   190,     0,   780,   191,   192,   193,   781,
       0,   194,     0,     0,   782,     0,   195,   196,     0,   783,
     197,     0,   198,   784,   785,   786,   787,     0,   788,   789,
     200,   790,   791,   792,   202,     0,   203,   793,     0,   794,
     795,     0,   204,   205,     0,   206,   796,     0,   207,     0,
       0,     0,   797,   209,   210,   211,   798,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   799,   215,   800,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   801,   220,     0,  1735,   802,   221,     0,
     803,   222,     0,     0,     0,   804,     0,   805,     0,   224,
     806,     0,   225,     0,   226,   807,     0,     0,   808,     0,
       0,     0,     0,   809,   227,   228,   229,   230,   231,   232,
     810,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     811,   242,   243,   244,   812,   245,   246,     0,     0,     0,
     247,   248,   813,   250,     0,     0,   814,   252,   815,   816,
     253,     0,   254,   817,   818,   819,   820,   821,   822,   823,
     259,   260,   261,   262,     0,   824,   263,   264,     0,   265,
     266,   267,   825,   826,   827,   268,     0,   828,   829,     0,
     269,   270,     0,   830,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     831,   832,   278,   833,   834,   835,   836,   837,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   838,   287,   288,
     289,   290,   291,   292,   293,   839,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   840,   841,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   842,   308,   309,   843,   310,   311,   844,
     312,   845,   314,   315,     0,   846,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   847,   848,   334,   335,     0,   336,   849,
     338,   850,   851,   852,   339,   340,   853,   341,   342,     0,
     343,   344,     0,   854,   345,   855,   856,   857,   858,     0,
       0,     0,     0,  1736,   350,     0,   351,   859,   860,   861,
     353,   354,   355,     0,   862,   356,   357,   863,     0,   358,
       0,     0,   864,   865,   359,     0,     0,   360,     0,   361,
       0,   866,   363,     0,     0,   867,   868,   869,   870,   871,
     364,     0,     0,   365,   872,     0,   366,   367,   873,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   874,     0,
     875,     0,     0,     0,     0,   876,     0,     0,     0,   877,
     878,     0,     0,     0,     0,   879,     0,   880,     0,     0,
     881,   882,     0,     0,   883,   884,   122,     0,   739,   124,
     125,   126,   127,  2627,     0,     0,     0,     0,   128,     0,
       0,   740,     0,   741,   130,   131,   742,   133,     0,   134,
     743,   135,     0,  2628,   136,   745,   746,   747,   137,   748,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   749,   144,     0,   145,   750,   751,   147,     0,   148,
     149,   150,   752,   151,     0,   753,   153,     0,   154,   155,
     156,   157,   158,   754,   755,   159,     0,   160,   161,     0,
     756,     0,   757,   758,   759,     0,     0,   163,   760,   761,
       0,   762,   763,     0,   164,   165,   764,   765,   766,     0,
       0,     0,     0,   767,   168,   768,     0,     0,   769,  2629,
     169,     0,   170,     0,     0,     0,   771,   772,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   773,   179,     0,   774,   775,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     776,     0,   188,   777,   189,   778,   779,   190,     0,   780,
     191,   192,   193,   781,     0,   194,     0,     0,   782,     0,
     195,   196,     0,   783,   197,     0,   198,   784,   785,   786,
     787,     0,   788,   789,   200,   790,   791,   792,   202,     0,
     203,   793,     0,   794,   795,     0,   204,   205,     0,   206,
     796,     0,   207,     0,     0,     0,   797,   209,   210,   211,
     798,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     799,   215,   800,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   801,   220,     0,
       0,   802,   221,     0,   803,   222,     0,     0,     0,   804,
       0,   805,     0,   224,   806,     0,   225,     0,   226,   807,
       0,     0,   808,     0,     0,     0,     0,   809,   227,   228,
     229,   230,   231,   232,   810,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   811,   242,   243,   244,   812,   245,
     246,     0,     0,     0,   247,   248,   813,   250,     0,     0,
     814,   252,   815,   816,   253,     0,   254,   817,   818,   819,
     820,   821,   822,   823,   259,   260,   261,   262,     0,   824,
     263,   264,     0,   265,   266,   267,   825,   826,   827,   268,
       0,   828,   829,     0,   269,   270,     0,   830,  2630,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   831,   832,   278,   833,   834,   835,
     836,   837,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   838,   287,   288,   289,   290,   291,   292,   293,   839,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   840,   841,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   842,   308,   309,
     843,   310,   311,   844,   312,   845,   314,   315,     0,   846,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   847,   848,   334,
     335,     0,   336,   849,   338,   850,   851,   852,   339,   340,
     853,   341,   342,     0,   343,   344,     0,   854,   345,   855,
     856,   857,   858,     0,     0,     0,     0,     0,   350,     0,
     351,   859,   860,   861,   353,   354,   355,     0,   862,   356,
     357,   863,     0,   358,     0,     0,   864,   865,   359,     0,
       0,   360,     0,   361,     0,   866,   363,     0,     0,   867,
     868,   869,   870,   871,   364,     0,     0,   365,   872,     0,
     366,   367,   873,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   874,     0,   875,     0,     0,     0,     0,   876,
       0,     0,     0,   877,   878,     0,     0,     0,     0,   879,
       0,   880,     0,     0,   881,   882,     0,     0,   883,   884,
     122,     0,   739,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   740,     0,   741,   130,   131,
     742,   133,     0,   134,   743,   135,     0,   744,   136,   745,
     746,   747,   137,   748,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   749,   144,     0,   145,   750,
     751,   147,     0,   148,   149,   150,   752,   151,     0,   753,
     153,     0,   154,   155,   156,   157,   158,   754,   755,   159,
       0,   160,   161,     0,   756,     0,   757,   758,   759,     0,
       0,   163,   760,   761,     0,   762,   763,     0,   164,   165,
     764,   765,   766,     0,     0,     0,     0,   767,   168,   768,
       0,     0,   769,   770,   169,     0,   170,     0,     0,     0,
     771,   772,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   773,   179,
       0,   774,   775,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   776,     0,   188,   777,   189,   778,
     779,   190,     0,   780,   191,   192,   193,   781,     0,   194,
       0,     0,   782,     0,   195,   196,     0,   783,   197,     0,
     198,   784,   785,   786,   787,     0,   788,   789,   200,   790,
     791,   792,   202,     0,   203,   793,     0,   794,   795,     0,
     204,   205,     0,   206,   796,     0,   207,     0,     0,     0,
     797,   209,   210,   211,   798,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   799,   215,   800,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   801,   220,     0,     0,   802,   221,     0,   803,   222,
       0,     0,     0,   804,     0,   805,     0,   224,   806,     0,
     225,     0,   226,   807,     0,     0,   808,     0,     0,     0,
       0,   809,   227,   228,   229,   230,   231,   232,   810,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   811,   242,
     243,   244,   812,   245,   246,     0,     0,     0,   247,   248,
     813,   250,     0,     0,   814,   252,   815,   816,   253,     0,
     254,   817,   818,   819,   820,   821,   822,   823,   259,   260,
     261,   262,     0,   824,   263,   264,     0,   265,   266,   267,
     825,   826,   827,   268,     0,   828,   829,     0,   269,   270,
       0,   830,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   831,   832,
     278,   833,   834,   835,   836,   837,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   838,   287,   288,   289,   290,
     291,   292,   293,   839,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   840,
     841,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   842,   308,   309,   843,   310,   311,   844,   312,   845,
     314,   315,     0,   846,   317,  1297,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   847,   848,   334,   335,     0,   336,   849,   338,   850,
     851,   852,   339,   340,   853,   341,   342,     0,   343,   344,
       0,   854,   345,   855,   856,   857,   858,     0,     0,     0,
       0,     0,   350,     0,   351,   859,   860,   861,   353,   354,
     355,     0,   862,   356,   357,   863,     0,   358,     0,     0,
     864,   865,   359,     0,     0,   360,     0,   361,     0,   866,
     363,     0,     0,   867,   868,   869,   870,   871,   364,     0,
       0,   365,   872,     0,   366,   367,   873,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   874,     0,   875,     0,
       0,     0,     0,   876,     0,     0,     0,   877,   878,     0,
       0,     0,     0,   879,     0,  1298,     0,     0,   881,   882,
       0,     0,   883,   884,   122,     0,   739,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   740,
       0,   741,   130,   131,   742,   133,     0,   134,   743,   135,
       0,   744,   136,   745,   746,   747,   137,   748,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   749,
     144,     0,   145,   750,   751,   147,     0,   148,   149,   150,
     752,   151,     0,   753,   153,     0,   154,   155,   156,   157,
     158,   754,   755,   159,     0,   160,   161,     0,   756,     0,
     757,   758,   759,     0,     0,   163,   760,   761,     0,   762,
     763,     0,   164,   165,   764,   765,   766,     0,     0,     0,
       0,   767,   168,   768,     0,     0,   769,   770,   169,     0,
     170,     0,     0,     0,   771,   772,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   773,   179,     0,   774,   775,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   776,     0,
     188,   777,   189,   778,   779,   190,     0,   780,   191,   192,
     193,   781,     0,   194,     0,     0,   782,     0,   195,   196,
       0,   783,   197,     0,   198,   784,   785,   786,   787,     0,
     788,   789,   200,   790,   791,   792,   202,     0,   203,   793,
       0,   794,   795,     0,   204,   205,     0,   206,   796,     0,
     207,     0,     0,     0,   797,   209,   210,   211,   798,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   799,   215,
     800,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   801,   220,     0,     0,   802,
     221,     0,   803,   222,     0,     0,     0,   804,     0,   805,
       0,   224,   806,     0,   225,     0,   226,   807,     0,     0,
     808,     0,     0,     0,     0,   809,   227,   228,   229,   230,
     231,   232,   810,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   811,   242,   243,   244,   812,   245,   246,     0,
       0,     0,   247,   248,   813,   250,     0,     0,   814,   252,
     815,   816,   253,     0,   254,   817,   818,   819,   820,   821,
     822,   823,   259,   260,   261,   262,     0,   824,   263,   264,
       0,   265,   266,   267,   825,   826,   827,   268,     0,   828,
     829,     0,   269,   270,     0,   830,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   831,   832,   278,   833,   834,   835,   836,   837,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   838,
     287,   288,   289,   290,   291,   292,   293,   839,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   840,   841,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   842,   308,   309,   843,   310,
     311,   844,   312,   845,   314,   315,     0,   846,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   847,   848,   334,   335,     0,
     336,   849,   338,   850,   851,   852,   339,   340,   853,   341,
     342,     0,   343,   344,     0,   854,   345,   855,   856,   857,
     858,     0,     0,     0,     0,     0,   350,     0,   351,   859,
     860,   861,   353,   354,   355,     0,   862,   356,   357,   863,
       0,   358,     0,     0,   864,   865,   359,     0,     0,   360,
       0,   361,     0,   866,   363,     0,     0,   867,   868,   869,
     870,   871,   364,     0,     0,   365,   872,     0,   366,   367,
     873,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     874,     0,   875,     0,     0,     0,     0,   876,     0,     0,
       0,   877,   878,     0,     0,     0,     0,   879,     0,   880,
    1578,     0,   881,   882,     0,     0,   883,   884,   122,     0,
     739,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   740,     0,   741,   130,   131,   742,   133,
       0,   134,   743,   135,     0,   744,   136,   745,   746,   747,
     137,   748,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   749,   144,     0,   145,   750,   751,   147,
       0,   148,   149,   150,   752,   151,     0,   753,   153,     0,
     154,   155,   156,   157,   158,   754,   755,   159,     0,   160,
     161,     0,   756,     0,   757,   758,   759,     0,     0,   163,
     760,   761,     0,   762,   763,     0,   164,   165,   764,   765,
     766,     0,     0,     0,     0,   767,   168,   768,     0,     0,
     769,   770,   169,     0,   170,     0,     0,     0,   771,   772,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   773,   179,     0,   774,
     775,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   776,     0,   188,   777,   189,   778,   779,   190,
       0,   780,   191,   192,   193,   781,     0,   194,     0,     0,
     782,     0,   195,   196,     0,   783,   197,     0,   198,   784,
     785,   786,   787,     0,   788,   789,   200,   790,   791,   792,
     202,     0,   203,   793,     0,   794,   795,     0,   204,   205,
       0,   206,   796,     0,   207,     0,     0,     0,   797,   209,
     210,   211,   798,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   799,   215,   800,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   801,
     220,     0,     0,   802,   221,     0,   803,   222,     0,     0,
       0,   804,     0,   805,     0,   224,   806,     0,   225,     0,
     226,   807,     0,     0,   808,     0,     0,     0,     0,   809,
     227,   228,   229,   230,   231,   232,   810,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   811,   242,   243,   244,
     812,   245,   246,     0,     0,     0,   247,   248,   813,   250,
       0,     0,   814,   252,   815,   816,   253,     0,   254,   817,
     818,   819,   820,   821,   822,   823,   259,   260,   261,   262,
       0,   824,   263,   264,     0,   265,   266,   267,   825,   826,
     827,   268,     0,   828,   829,     0,   269,   270,     0,   830,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   831,   832,   278,   833,
     834,   835,   836,   837,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   838,   287,   288,   289,   290,   291,   292,
     293,   839,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   840,   841,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   842,
     308,   309,   843,   310,   311,   844,   312,   845,   314,   315,
       0,   846,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   847,
     848,   334,   335,     0,   336,   849,   338,   850,   851,   852,
     339,   340,   853,   341,   342,     0,   343,   344,     0,   854,
     345,   855,   856,   857,   858,     0,     0,     0,     0,     0,
     350,     0,   351,   859,   860,   861,   353,   354,   355,     0,
     862,   356,   357,   863,     0,   358,     0,     0,   864,   865,
     359,     0,     0,   360,     0,   361,     0,   866,   363,     0,
       0,   867,   868,   869,   870,   871,   364,     0,     0,   365,
     872,     0,   366,   367,   873,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   874,     0,   875,     0,     0,     0,
       0,   876,     0,     0,     0,   877,   878,     0,     0,     0,
       0,   879,     0,   880,  1674,     0,   881,   882,     0,     0,
     883,   884,   122,     0,   739,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   740,     0,   741,
     130,   131,   742,   133,     0,   134,   743,   135,     0,   744,
     136,   745,   746,   747,   137,   748,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   749,   144,     0,
     145,   750,   751,   147,     0,   148,   149,   150,   752,   151,
       0,   753,   153,     0,   154,   155,   156,   157,   158,   754,
     755,   159,     0,   160,   161,     0,   756,     0,   757,   758,
     759,     0,     0,   163,   760,   761,     0,   762,   763,     0,
     164,   165,   764,   765,   766,     0,     0,     0,     0,   767,
     168,   768,     0,     0,   769,   770,   169,     0,   170,     0,
       0,     0,   771,   772,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     773,   179,     0,   774,   775,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   776,     0,   188,   777,
     189,   778,   779,   190,     0,   780,   191,   192,   193,   781,
       0,   194,     0,     0,   782,     0,   195,   196,     0,   783,
     197,     0,   198,   784,   785,   786,   787,     0,   788,   789,
     200,   790,   791,   792,   202,     0,   203,   793,     0,   794,
     795,     0,   204,   205,     0,   206,   796,     0,   207,     0,
       0,     0,   797,   209,   210,   211,   798,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   799,   215,   800,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   801,   220,     0,     0,   802,   221,     0,
     803,   222,     0,     0,     0,   804,     0,   805,     0,   224,
     806,     0,   225,     0,   226,   807,     0,     0,   808,     0,
       0,     0,     0,   809,   227,   228,   229,   230,   231,   232,
     810,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     811,   242,   243,   244,   812,   245,   246,     0,     0,     0,
     247,   248,   813,   250,     0,     0,   814,   252,   815,   816,
     253,     0,   254,   817,   818,   819,   820,   821,   822,   823,
     259,   260,   261,   262,     0,   824,   263,   264,     0,   265,
     266,   267,   825,   826,   827,   268,     0,   828,   829,     0,
     269,   270,     0,   830,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     831,   832,   278,   833,   834,   835,   836,   837,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   838,   287,   288,
     289,   290,   291,   292,   293,   839,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   840,   841,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   842,   308,   309,   843,   310,   311,   844,
     312,   845,   314,   315,     0,   846,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   847,   848,   334,   335,     0,   336,   849,
     338,   850,   851,   852,   339,   340,   853,   341,   342,     0,
     343,   344,     0,   854,   345,   855,   856,   857,   858,     0,
       0,     0,     0,     0,   350,     0,   351,   859,   860,   861,
     353,   354,   355,     0,   862,   356,   357,   863,     0,   358,
       0,     0,   864,   865,   359,     0,     0,   360,     0,   361,
       0,   866,   363,     0,     0,   867,   868,   869,   870,   871,
     364,     0,     0,   365,   872,     0,   366,   367,   873,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   874,     0,
     875,     0,     0,     0,     0,   876,     0,     0,     0,   877,
     878,     0,     0,     0,     0,   879,     0,   880,  1711,     0,
     881,   882,     0,     0,   883,   884,   122,     0,   739,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   740,     0,   741,   130,   131,   742,   133,     0,   134,
     743,   135,     0,   744,   136,   745,   746,   747,   137,   748,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   749,   144,     0,   145,   750,   751,   147,     0,   148,
     149,   150,   752,   151,     0,   753,   153,     0,   154,   155,
     156,   157,   158,   754,   755,   159,     0,   160,   161,     0,
     756,     0,   757,   758,   759,     0,     0,   163,   760,   761,
       0,   762,   763,     0,   164,   165,   764,   765,   766,     0,
       0,     0,     0,   767,   168,   768,     0,     0,   769,   770,
     169,     0,   170,     0,     0,     0,   771,   772,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   773,   179,     0,   774,   775,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     776,     0,   188,   777,   189,   778,   779,   190,     0,   780,
     191,   192,   193,   781,     0,   194,     0,     0,   782,     0,
     195,   196,     0,   783,   197,     0,   198,   784,   785,   786,
     787,     0,   788,   789,   200,   790,   791,   792,   202,     0,
     203,   793,     0,   794,   795,     0,   204,   205,     0,   206,
     796,     0,   207,     0,     0,     0,   797,   209,   210,   211,
     798,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     799,   215,   800,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   801,   220,     0,
       0,   802,   221,     0,   803,   222,     0,     0,     0,   804,
       0,   805,     0,   224,   806,     0,   225,     0,   226,   807,
       0,     0,   808,     0,     0,     0,     0,   809,   227,   228,
     229,   230,   231,   232,   810,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   811,   242,   243,   244,   812,   245,
     246,     0,     0,     0,   247,   248,   813,   250,     0,     0,
     814,   252,   815,   816,   253,     0,   254,   817,   818,   819,
     820,   821,   822,   823,   259,   260,   261,   262,     0,   824,
     263,   264,     0,   265,   266,   267,   825,   826,   827,   268,
       0,   828,   829,     0,   269,   270,     0,   830,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   831,   832,   278,   833,   834,   835,
     836,   837,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   838,   287,   288,   289,   290,   291,   292,   293,   839,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   840,   841,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   842,   308,   309,
     843,   310,   311,   844,   312,   845,   314,   315,     0,   846,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   847,   848,   334,
     335,     0,   336,   849,   338,   850,   851,   852,   339,   340,
     853,   341,   342,     0,   343,   344,     0,   854,   345,   855,
     856,   857,   858,     0,     0,     0,     0,     0,   350,     0,
     351,   859,   860,   861,   353,   354,   355,     0,   862,   356,
     357,   863,     0,   358,     0,     0,   864,   865,   359,     0,
       0,   360,     0,   361,     0,   866,   363,     0,     0,   867,
     868,   869,   870,   871,   364,     0,     0,   365,   872,     0,
     366,   367,   873,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   874,     0,   875,     0,     0,     0,     0,   876,
       0,     0,     0,   877,   878,     0,     0,     0,     0,   879,
       0,   880,  1740,     0,   881,   882,     0,     0,   883,   884,
     122,     0,   739,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   740,     0,   741,   130,   131,
     742,   133,     0,   134,   743,   135,     0,   744,   136,   745,
     746,   747,   137,   748,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   749,   144,     0,   145,   750,
     751,   147,     0,   148,   149,   150,   752,   151,     0,   753,
     153,     0,   154,   155,   156,   157,   158,   754,   755,   159,
       0,   160,   161,     0,   756,     0,   757,   758,   759,     0,
       0,   163,   760,   761,     0,   762,   763,     0,   164,   165,
     764,   765,   766,     0,     0,     0,     0,   767,   168,   768,
       0,     0,   769,   770,   169,     0,   170,     0,     0,     0,
     771,   772,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   773,   179,
       0,   774,   775,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   776,     0,   188,   777,   189,   778,
     779,   190,     0,   780,   191,   192,   193,   781,     0,   194,
       0,     0,   782,     0,   195,   196,  2179,   783,   197,     0,
     198,   784,   785,   786,   787,     0,   788,   789,   200,   790,
     791,   792,   202,     0,   203,   793,     0,   794,   795,     0,
     204,   205,     0,   206,   796,     0,   207,     0,     0,     0,
     797,   209,   210,   211,   798,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   799,   215,   800,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   801,   220,     0,     0,   802,   221,     0,   803,   222,
       0,     0,     0,   804,     0,   805,     0,   224,   806,     0,
     225,     0,   226,   807,     0,     0,   808,     0,     0,     0,
       0,   809,   227,   228,   229,   230,   231,   232,   810,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   811,   242,
     243,   244,   812,   245,   246,     0,     0,     0,   247,   248,
     813,   250,     0,     0,   814,   252,   815,   816,   253,     0,
     254,   817,   818,   819,   820,   821,   822,   823,   259,   260,
     261,   262,     0,   824,   263,   264,     0,   265,   266,   267,
     825,   826,   827,   268,     0,   828,   829,     0,   269,   270,
       0,   830,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   831,   832,
     278,   833,   834,   835,   836,   837,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   838,   287,   288,   289,   290,
     291,   292,   293,   839,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   840,
     841,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   842,   308,   309,   843,   310,   311,   844,   312,   845,
     314,   315,     0,   846,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   847,   848,   334,   335,     0,   336,   849,   338,   850,
     851,   852,   339,   340,   853,   341,   342,     0,   343,   344,
       0,   854,   345,   855,   856,   857,   858,     0,     0,     0,
       0,     0,   350,     0,   351,   859,   860,   861,   353,   354,
     355,     0,   862,   356,   357,   863,     0,   358,     0,     0,
     864,   865,   359,     0,     0,   360,     0,   361,     0,   866,
     363,     0,     0,   867,   868,   869,   870,   871,   364,     0,
       0,   365,   872,     0,   366,   367,   873,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   874,     0,   875,     0,
       0,     0,     0,   876,     0,     0,     0,   877,   878,     0,
       0,     0,     0,   879,     0,   880,     0,     0,   881,   882,
       0,     0,   883,   884,   122,     0,   739,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   740,
       0,   741,   130,   131,   742,   133,     0,   134,   743,   135,
       0,   744,   136,   745,   746,   747,   137,   748,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   749,
     144,     0,   145,   750,   751,   147,     0,   148,   149,   150,
     752,   151,     0,   753,   153,     0,   154,   155,   156,   157,
     158,   754,   755,   159,     0,   160,   161,     0,   756,     0,
     757,   758,   759,     0,     0,   163,   760,   761,     0,   762,
     763,     0,   164,   165,   764,   765,   766,     0,     0,     0,
       0,   767,   168,   768,     0,     0,   769,   770,   169,     0,
     170,     0,     0,     0,   771,   772,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   773,   179,     0,   774,   775,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   776,     0,
     188,   777,   189,   778,   779,   190,     0,   780,   191,   192,
     193,   781,     0,   194,     0,     0,   782,     0,   195,   196,
    2181,   783,   197,     0,   198,   784,   785,   786,   787,     0,
     788,   789,   200,   790,   791,   792,   202,     0,   203,   793,
       0,   794,   795,     0,   204,   205,     0,   206,   796,     0,
     207,     0,     0,     0,   797,   209,   210,   211,   798,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   799,   215,
     800,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   801,   220,     0,     0,   802,
     221,     0,   803,   222,     0,     0,     0,   804,     0,   805,
       0,   224,   806,     0,   225,     0,   226,   807,     0,     0,
     808,     0,     0,     0,     0,   809,   227,   228,   229,   230,
     231,   232,   810,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   811,   242,   243,   244,   812,   245,   246,     0,
       0,     0,   247,   248,   813,   250,     0,     0,   814,   252,
     815,   816,   253,     0,   254,   817,   818,   819,   820,   821,
     822,   823,   259,   260,   261,   262,     0,   824,   263,   264,
       0,   265,   266,   267,   825,   826,   827,   268,     0,   828,
     829,     0,   269,   270,     0,   830,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   831,   832,   278,   833,   834,   835,   836,   837,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   838,
     287,   288,   289,   290,   291,   292,   293,   839,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   840,   841,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   842,   308,   309,   843,   310,
     311,   844,   312,   845,   314,   315,     0,   846,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   847,   848,   334,   335,     0,
     336,   849,   338,   850,   851,   852,   339,   340,   853,   341,
     342,     0,   343,   344,     0,   854,   345,   855,   856,   857,
     858,     0,     0,     0,     0,     0,   350,     0,   351,   859,
     860,   861,   353,   354,   355,     0,   862,   356,   357,   863,
       0,   358,     0,     0,   864,   865,   359,     0,     0,   360,
       0,   361,     0,   866,   363,     0,     0,   867,   868,   869,
     870,   871,   364,     0,     0,   365,   872,     0,   366,   367,
     873,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     874,     0,   875,     0,     0,     0,     0,   876,     0,     0,
       0,   877,   878,     0,     0,     0,     0,   879,     0,   880,
       0,     0,   881,   882,     0,     0,   883,   884,   122,     0,
     739,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   740,     0,   741,   130,   131,   742,   133,
       0,   134,   743,   135,     0,   744,   136,   745,   746,   747,
     137,   748,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   749,   144,     0,   145,   750,   751,   147,
       0,   148,   149,   150,   752,   151,     0,   753,   153,     0,
     154,   155,   156,   157,   158,   754,   755,   159,     0,   160,
     161,     0,   756,     0,   757,   758,   759,     0,     0,   163,
     760,   761,     0,   762,   763,     0,   164,   165,   764,   765,
     766,     0,     0,     0,     0,   767,   168,   768,     0,     0,
     769,   770,   169,     0,   170,     0,     0,     0,   771,   772,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   773,   179,     0,   774,
     775,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   776,     0,   188,   777,   189,   778,   779,   190,
       0,   780,   191,   192,   193,   781,     0,   194,     0,     0,
     782,     0,   195,   196,  2183,   783,   197,     0,   198,   784,
     785,   786,   787,     0,   788,   789,   200,   790,   791,   792,
     202,     0,   203,   793,     0,   794,   795,     0,   204,   205,
       0,   206,   796,     0,   207,     0,     0,     0,   797,   209,
     210,   211,   798,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   799,   215,   800,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   801,
     220,     0,     0,   802,   221,     0,   803,   222,     0,     0,
       0,   804,     0,   805,     0,   224,   806,     0,   225,     0,
     226,   807,     0,     0,   808,     0,     0,     0,     0,   809,
     227,   228,   229,   230,   231,   232,   810,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   811,   242,   243,   244,
     812,   245,   246,     0,     0,     0,   247,   248,   813,   250,
       0,     0,   814,   252,   815,   816,   253,     0,   254,   817,
     818,   819,   820,   821,   822,   823,   259,   260,   261,   262,
       0,   824,   263,   264,     0,   265,   266,   267,   825,   826,
     827,   268,     0,   828,   829,     0,   269,   270,     0,   830,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   831,   832,   278,   833,
     834,   835,   836,   837,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   838,   287,   288,   289,   290,   291,   292,
     293,   839,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   840,   841,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   842,
     308,   309,   843,   310,   311,   844,   312,   845,   314,   315,
       0,   846,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   847,
     848,   334,   335,     0,   336,   849,   338,   850,   851,   852,
     339,   340,   853,   341,   342,     0,   343,   344,     0,   854,
     345,   855,   856,   857,   858,     0,     0,     0,     0,     0,
     350,     0,   351,   859,   860,   861,   353,   354,   355,     0,
     862,   356,   357,   863,     0,   358,     0,     0,   864,   865,
     359,     0,     0,   360,     0,   361,     0,   866,   363,     0,
       0,   867,   868,   869,   870,   871,   364,     0,     0,   365,
     872,     0,   366,   367,   873,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   874,     0,   875,     0,     0,     0,
       0,   876,     0,     0,     0,   877,   878,     0,     0,     0,
       0,   879,     0,   880,     0,     0,   881,   882,     0,     0,
     883,   884,   122,     0,   739,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   740,     0,   741,
     130,   131,   742,   133,     0,   134,   743,   135,     0,   744,
     136,   745,   746,   747,   137,   748,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   749,   144,     0,
     145,   750,   751,   147,     0,   148,   149,   150,   752,   151,
       0,   753,   153,     0,   154,   155,   156,   157,   158,   754,
     755,   159,     0,   160,   161,     0,   756,     0,   757,   758,
     759,     0,     0,   163,   760,   761,     0,   762,   763,     0,
     164,   165,   764,   765,   766,     0,     0,     0,     0,   767,
     168,   768,     0,     0,   769,   770,   169,     0,   170,     0,
       0,     0,   771,   772,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     773,   179,     0,   774,   775,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   776,     0,   188,   777,
     189,   778,   779,   190,     0,   780,   191,   192,   193,   781,
       0,   194,     0,     0,   782,     0,   195,   196,     0,   783,
     197,     0,   198,   784,   785,   786,   787,     0,   788,   789,
     200,   790,   791,   792,   202,     0,   203,   793,     0,   794,
     795,     0,   204,   205,     0,   206,   796,     0,   207,     0,
       0,     0,   797,   209,   210,   211,   798,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   799,   215,   800,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   801,   220,     0,     0,   802,   221,     0,
     803,   222,     0,     0,     0,   804,     0,   805,     0,   224,
     806,     0,   225,     0,   226,   807,     0,     0,   808,     0,
       0,     0,     0,   809,   227,   228,   229,   230,   231,   232,
     810,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     811,   242,   243,   244,   812,   245,   246,     0,     0,     0,
     247,   248,   813,   250,     0,     0,   814,   252,   815,   816,
     253,     0,   254,   817,   818,   819,   820,   821,   822,   823,
     259,   260,   261,   262,     0,   824,   263,   264,     0,   265,
     266,   267,   825,   826,   827,   268,     0,   828,   829,     0,
     269,   270,     0,   830,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     831,   832,   278,   833,   834,   835,   836,   837,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   838,   287,   288,
     289,   290,   291,   292,   293,   839,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   840,   841,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   842,   308,   309,   843,   310,   311,   844,
     312,   845,   314,   315,     0,   846,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   847,   848,   334,   335,     0,   336,   849,
     338,   850,   851,   852,   339,   340,   853,   341,   342,     0,
     343,   344,     0,   854,   345,   855,   856,   857,   858,     0,
       0,     0,     0,     0,   350,     0,   351,   859,   860,   861,
     353,   354,   355,     0,   862,   356,   357,   863,     0,   358,
       0,     0,   864,   865,   359,     0,     0,   360,     0,   361,
       0,   866,   363,     0,     0,   867,   868,   869,   870,   871,
     364,     0,     0,   365,   872,     0,   366,   367,   873,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   874,     0,
     875,     0,     0,     0,     0,   876,     0,     0,     0,   877,
     878,     0,     0,     0,     0,   879,     0,   880,     0,     0,
     881,   882,     0,     0,   883,   884,   122,     0,   739,   124,
     125,   126,   127,  1772,     0,     0,     0,     0,  1773,     0,
       0,   740,     0,   741,   130,   131,   742,   133,     0,   134,
     743,   135,     0,   744,   136,   745,   746,   747,   137,   748,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   749,   144,     0,   145,   750,   751,   147,     0,   148,
     149,   150,   752,   151,     0,   753,   153,     0,   154,   155,
     156,   157,   158,   754,   755,   159,     0,   160,   161,     0,
     756,     0,   757,   758,   759,     0,     0,   163,   760,   761,
       0,   762,   763,     0,   164,   165,   764,   765,   766,     0,
       0,     0,     0,   767,   168,   768,     0,     0,   769,   770,
     169,     0,   170,     0,     0,     0,   771,   772,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   773,   179,     0,   774,   775,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     776,     0,   188,   777,   189,   778,   779,   190,     0,   780,
     191,   192,   193,   781,     0,   194,     0,     0,   782,     0,
     195,   196,     0,   783,   197,     0,   198,   784,   785,   786,
     787,     0,   788,   789,   200,   790,   791,   792,   202,     0,
     203,   793,     0,   794,   795,     0,   204,   205,     0,   206,
     796,     0,   207,     0,     0,     0,   797,   209,   210,   211,
     798,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     799,   215,   800,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   801,   220,     0,
       0,   802,   221,     0,   803,   222,     0,     0,     0,   804,
       0,   805,     0,   224,   806,     0,   225,     0,   226,   807,
       0,     0,   808,     0,     0,     0,     0,   809,   227,   228,
     229,   230,   231,   232,   810,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   811,   242,   243,   244,   812,   245,
     246,     0,     0,     0,   247,   248,   813,   250,     0,     0,
     814,   252,   815,   816,   253,     0,   254,   817,   818,   819,
     820,   821,   822,   823,   259,   260,   261,   262,     0,   824,
     263,   264,     0,   265,   266,   267,   825,     0,   827,   268,
       0,   828,   829,     0,   269,   270,     0,   830,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   831,   832,   278,   833,   834,   835,
     836,   837,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   838,   287,   288,   289,   290,   291,   292,   293,   839,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   840,   841,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   842,   308,   309,
     843,   310,   311,   844,   312,   845,   314,   315,     0,   846,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   847,   848,   334,
     335,     0,   336,   849,   338,   850,   851,   852,   339,   340,
     853,   341,   342,     0,   343,   344,     0,   854,   345,   855,
     856,   857,   858,     0,     0,     0,     0,     0,   350,     0,
     351,   859,   860,   861,   353,   354,   355,     0,   862,   356,
     357,   863,     0,   358,     0,     0,   864,   865,   359,     0,
       0,   360,     0,   361,     0,   866,   363,     0,     0,   867,
     868,   869,   870,   871,   364,     0,     0,   365,   872,     0,
     366,   367,   873,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   874,     0,   875,     0,     0,     0,     0,   876,
       0,     0,     0,   877,   878,     0,     0,     0,     0,   879,
       0,   880,     0,     0,   881,   882,     0,     0,   883,   884,
     122,     0,   739,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   740,     0,   741,   130,   131,
     742,   133,     0,   134,   743,   135,     0,   744,   136,   745,
     746,   747,   137,   748,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   749,   144,     0,   145,   750,
     751,   147,     0,   148,   149,   150,   752,   151,     0,   753,
     153,     0,   154,   155,   156,   157,   158,   754,   755,   159,
       0,   160,   161,     0,   756,     0,   757,   758,   759,     0,
       0,   163,   760,   761,     0,   762,   763,     0,   164,   165,
     764,   765,   766,     0,     0,     0,     0,   767,   168,   768,
       0,     0,   769,   770,   169,     0,   170,     0,     0,     0,
     771,   772,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   773,   179,
       0,   774,   775,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   776,     0,   188,   777,   189,   778,
     779,   190,     0,   780,   191,   192,   193,   781,     0,   194,
       0,     0,   782,     0,   195,   196,     0,   783,   197,     0,
     198,   784,   785,   786,   787,     0,   788,   789,   200,   790,
     791,   792,   202,     0,   203,   793,     0,   794,   795,     0,
     204,   205,     0,   206,   796,     0,   207,     0,     0,     0,
     797,   209,   210,   211,   798,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   799,   215,  2458,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   801,   220,     0,     0,   802,   221,     0,   803,   222,
       0,     0,     0,   804,     0,   805,     0,   224,   806,     0,
     225,     0,   226,   807,     0,     0,   808,     0,     0,     0,
       0,   809,   227,   228,   229,   230,   231,   232,   810,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   811,   242,
     243,   244,   812,   245,   246,     0,     0,     0,   247,   248,
     813,   250,     0,     0,   814,   252,   815,   816,   253,     0,
     254,   817,   818,   819,   820,   821,   822,   823,   259,   260,
     261,   262,     0,   824,   263,   264,     0,   265,   266,   267,
     825,   826,   827,   268,     0,   828,   829,     0,   269,   270,
       0,   830,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   831,   832,
     278,   833,   834,   835,   836,   837,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   838,   287,   288,   289,   290,
     291,   292,   293,   839,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   840,
     841,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   842,   308,   309,   843,   310,   311,   844,   312,   845,
     314,   315,     0,   846,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   847,   848,   334,   335,     0,   336,   849,   338,   850,
     851,   852,   339,   340,   853,   341,   342,     0,   343,   344,
       0,   854,   345,   855,   856,   857,   858,     0,     0,     0,
       0,     0,   350,     0,   351,   859,   860,   861,   353,   354,
     355,     0,   862,   356,   357,   863,     0,   358,     0,     0,
     864,   865,   359,     0,     0,   360,     0,   361,     0,   866,
     363,     0,     0,   867,   868,   869,   870,   871,   364,     0,
       0,   365,   872,     0,   366,   367,   873,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   874,     0,   875,     0,
       0,     0,     0,   876,     0,     0,     0,   877,   878,     0,
       0,     0,     0,   879,     0,   880,     0,     0,   881,   882,
       0,     0,   883,   884,   122,     0,   739,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   740,
       0,   741,   130,   131,   742,   133,     0,   134,   743,   135,
       0,   744,   136,   745,   746,   747,   137,   748,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   749,
     144,     0,   145,   750,   751,   147,     0,   148,   149,   150,
     752,   151,     0,   753,   153,     0,   154,   155,   156,   157,
     158,   754,   755,   159,     0,   160,   161,     0,   756,     0,
     757,   758,   759,     0,     0,   163,   760,   761,     0,   762,
     763,     0,   164,   165,   764,   765,   766,     0,     0,     0,
       0,   767,   168,   768,     0,     0,   769,   770,   169,     0,
     170,     0,     0,     0,   771,   772,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   773,   179,     0,   774,   775,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   776,     0,
     188,   777,   189,   778,   779,   190,     0,   780,   191,   192,
     193,   781,     0,   194,     0,     0,   782,     0,   195,   196,
       0,   783,   197,     0,   198,   784,   785,   786,   787,     0,
     788,   789,   200,   790,   791,   792,   202,     0,   203,   793,
       0,   794,   795,     0,   204,   205,     0,   206,   796,     0,
     207,     0,     0,     0,   797,   209,   210,   211,   798,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   799,   215,
    2531,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   801,   220,     0,     0,   802,
     221,     0,   803,   222,     0,     0,     0,   804,     0,   805,
       0,   224,   806,     0,   225,     0,   226,   807,     0,     0,
     808,     0,     0,     0,     0,   809,   227,   228,   229,   230,
     231,   232,   810,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   811,   242,   243,   244,   812,   245,   246,     0,
       0,     0,   247,   248,   813,   250,     0,     0,   814,   252,
     815,   816,   253,     0,   254,   817,   818,   819,   820,   821,
     822,   823,   259,   260,   261,   262,     0,   824,   263,   264,
       0,   265,   266,   267,   825,   826,   827,   268,     0,   828,
     829,     0,   269,   270,     0,   830,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   831,   832,   278,   833,   834,   835,   836,   837,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   838,
     287,   288,   289,   290,   291,   292,   293,   839,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   840,   841,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   842,   308,   309,   843,   310,
     311,   844,   312,   845,   314,   315,     0,   846,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   847,   848,   334,   335,     0,
     336,   849,   338,   850,   851,   852,   339,   340,   853,   341,
     342,     0,   343,   344,     0,   854,   345,   855,   856,   857,
     858,     0,     0,     0,     0,     0,   350,     0,   351,   859,
     860,   861,   353,   354,   355,     0,   862,   356,   357,   863,
       0,   358,     0,     0,   864,   865,   359,     0,     0,   360,
       0,   361,     0,   866,   363,     0,     0,   867,   868,   869,
     870,   871,   364,     0,     0,   365,   872,     0,   366,   367,
     873,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     874,     0,   875,     0,     0,     0,     0,   876,     0,     0,
       0,   877,   878,     0,     0,     0,     0,   879,     0,   880,
       0,     0,   881,   882,     0,     0,   883,   884,   122,     0,
     739,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   740,     0,   741,   130,   131,   742,   133,
       0,   134,   743,   135,     0,   744,   136,   745,   746,   747,
     137,   748,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   749,   144,     0,   145,   750,   751,   147,
       0,   148,   149,   150,   752,   151,     0,   753,   153,     0,
     154,   155,   156,   157,   158,   754,   755,   159,     0,   160,
     161,     0,   756,     0,   757,   758,   759,     0,     0,   163,
     760,   761,     0,   762,   763,     0,   164,   165,   764,   765,
     766,     0,     0,     0,     0,   767,   168,   768,     0,     0,
     769,  2884,   169,     0,   170,     0,     0,     0,   771,   772,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   773,   179,     0,   774,
     775,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   776,     0,   188,   777,   189,   778,   779,   190,
       0,   780,   191,   192,   193,   781,     0,   194,     0,     0,
     782,     0,   195,   196,     0,   783,   197,     0,   198,   784,
     785,   786,   787,     0,   788,   789,   200,   790,   791,   792,
     202,     0,   203,   793,     0,   794,   795,     0,   204,   205,
       0,   206,   796,     0,   207,     0,     0,     0,   797,   209,
     210,   211,   798,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   799,   215,   800,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   801,
     220,     0,     0,   802,   221,     0,   803,   222,     0,     0,
       0,   804,     0,   805,     0,   224,   806,     0,   225,     0,
     226,   807,     0,     0,   808,     0,     0,     0,     0,   809,
     227,   228,   229,   230,   231,   232,   810,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   811,   242,   243,   244,
     812,   245,   246,     0,     0,     0,   247,   248,   813,   250,
       0,     0,   814,   252,   815,   816,   253,     0,   254,   817,
     818,   819,   820,   821,   822,   823,   259,   260,   261,   262,
       0,   824,   263,   264,     0,   265,   266,   267,   825,   826,
     827,   268,     0,   828,   829,     0,   269,   270,     0,   830,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   831,   832,   278,   833,
     834,   835,   836,   837,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   838,   287,   288,   289,   290,   291,   292,
     293,   839,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   840,   841,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   842,
     308,   309,   843,   310,   311,   844,   312,   845,   314,   315,
       0,   846,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   847,
     848,   334,   335,     0,   336,   849,   338,   850,   851,   852,
     339,   340,   853,   341,   342,     0,   343,   344,     0,   854,
     345,   855,   856,   857,   858,     0,     0,     0,     0,     0,
     350,     0,   351,   859,   860,   861,   353,   354,   355,     0,
     862,   356,   357,   863,     0,   358,     0,     0,   864,   865,
     359,     0,     0,   360,     0,   361,     0,   866,   363,     0,
       0,   867,   868,   869,   870,   871,   364,     0,     0,   365,
     872,     0,   366,   367,   873,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   874,     0,   875,     0,     0,     0,
       0,   876,     0,     0,     0,   877,   878,     0,     0,     0,
       0,   879,     0,   880,     0,     0,   881,   882,     0,     0,
     883,   884,   122,     0,   739,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   740,     0,   741,
     130,   131,   742,   133,     0,   134,   743,   135,     0,   744,
     136,   745,   746,   747,   137,   748,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   749,   144,     0,
     145,   750,   751,   147,     0,   148,   149,   150,   752,   151,
       0,   753,   153,     0,   154,   155,   156,   157,   158,   754,
     755,   159,     0,   160,   161,     0,   756,     0,   757,   758,
     759,     0,     0,   163,   760,   761,     0,   762,   763,     0,
     164,   165,   764,   765,   766,     0,     0,     0,     0,   767,
     168,   768,     0,     0,   769,   770,   169,     0,   170,     0,
       0,     0,   771,   772,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     773,   179,     0,   774,   775,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   776,     0,   188,   777,
     189,   778,   779,   190,     0,   780,   191,   192,   193,   781,
       0,   194,     0,     0,   782,     0,   195,   196,     0,   783,
     197,     0,   198,   784,   785,   786,   787,     0,   788,   789,
     200,   790,   791,   792,   202,     0,   203,   793,     0,   794,
     795,     0,   204,   205,     0,   206,   796,     0,   207,     0,
       0,     0,   797,   209,   210,   211,   798,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   799,   215,   800,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   801,   220,     0,     0,   802,   221,     0,
     803,   222,     0,     0,     0,   804,     0,   805,     0,   224,
     806,     0,   225,     0,   226,   807,     0,     0,   808,     0,
       0,     0,     0,   809,   227,   228,   229,   230,   231,   232,
     810,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     811,   242,   243,   244,   812,   245,   246,     0,     0,     0,
     247,   248,   813,   250,     0,     0,   814,   252,   815,   816,
     253,     0,   254,   817,   818,   819,   820,   821,   822,   823,
     259,   260,   261,   262,     0,   824,   263,   264,     0,   265,
     266,   267,   825,     0,   827,   268,     0,   828,   829,     0,
     269,   270,     0,   830,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     831,   832,   278,   833,   834,   835,   836,   837,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   838,   287,   288,
     289,   290,   291,   292,   293,   839,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   840,   841,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   842,   308,   309,   843,   310,   311,   844,
     312,   845,   314,   315,     0,   846,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   847,   848,   334,   335,     0,   336,   849,
     338,   850,   851,   852,   339,   340,   853,   341,   342,     0,
     343,   344,     0,   854,   345,   855,   856,   857,   858,     0,
       0,     0,     0,     0,   350,     0,   351,   859,   860,   861,
     353,   354,   355,     0,   862,   356,   357,   863,     0,   358,
       0,     0,   864,   865,   359,     0,     0,   360,     0,   361,
       0,   866,   363,     0,     0,   867,   868,   869,   870,   871,
     364,     0,     0,   365,   872,     0,   366,   367,   873,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   874,     0,
     875,     0,     0,     0,     0,   876,     0,     0,     0,   877,
     878,     0,     0,     0,     0,   879,     0,   880,     0,     0,
     881,   882,     0,     0,   883,   884,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,  1946,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,  1947,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,  1092,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,  1093,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,  2443,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,  1859,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
    1948,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,  1995,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,  1946,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,  1947,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,  1092,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
    1093,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,  1948,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,  1995,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,  1859,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,  2263,   130,   131,   132,
     133,     0,   134,   884,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,     0,   372,     0,     0,
       0,     0,     0,     0,     0,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  3626,     0,   128,     0,     0,
     129,  3627,   884,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,   977,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,   408,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  1818,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,   408,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,  1994,     0,   130,   131,
     132,   133,     0,   134,  1995,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,     0,
       0,     0,     0,     0,     0,     0,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,  3627,   884,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,   408,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   463,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,   408,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,   884,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
    1995,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   551,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   552,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  1759,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   551,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   552,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,  2303,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,   551,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   552,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,     0,   372,     0,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,  2907,  -230,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,     0,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -183,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,  -183,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,     0,     0,  3471,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,  3678,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,   122,     0,   123,
     124,   125,   126,   127,     0,     0,     0,  1600,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,     0,   372,   122,     0,   123,   124,
     125,   126,   127,     0,     0,     0,  2289,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,     0,   372,   122,     0,   123,   124,   125,
     126,   127,     0,     0,     0,  2582,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,     0,   372,   122,     0,   123,   124,   125,   126,
     127,     0,     0,     0,  2912,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -230,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,  -200,     0,   179,     0,     0,     0,  -200,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -183,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,  -183,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,  -200,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -230,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,  -221,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -183,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,  -221,     0,  -183,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,  -221,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,  -218,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -183,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -183,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,   360,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,  -218,     0,  -183,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,  -218,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,  3555,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -183,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -183,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -183,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -230,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,  -223,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -183,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -183,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -183,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,     0,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,   130,   131,   132,     0,     0,  -230,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,     0,     0,     0,     0,   143,     0,
     144,     0,   145,     0,     0,     0,     0,   148,   149,  3464,
       0,   151,     0,   152,   153,     0,     0,   155,     0,   157,
     158,     0,     0,   159,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,     0,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,  3606,   181,   182,
     183,     0,     0,   184,     0,   185,   186,     0,     0,     0,
     188,     0,   189,     0,     0,   190,  3465,     0,   191,   192,
     193,     0,     0,     0,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,  3466,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,  3467,     0,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
     221,  3468,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,  -183,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,     0,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,  3469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,     0,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,     0,   301,  -183,     0,   302,     0,     0,   304,     0,
       0,   306,   307,  3470,     0,     0,     0,   309,     0,   310,
     311,     0,   312,   313,   314,     0,     0,   316,     0,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,     0,   324,     0,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,     0,   333,     0,     0,     0,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,     0,   353,   354,   355,     0,     0,   356,   357,     0,
       0,     0,     0,     0,     0,     0,   359,     0,     0,   360,
       0,     0,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,  -183,     0,   369,     0,   370,     0,     0,
       0,     0,   372,     0,     0,     0,   122,  3471,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,   130,   131,   132,     0,     0,  -230,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,     0,     0,     0,     0,
     143,     0,   144,     0,   145,     0,     0,     0,     0,   148,
     149,  3464,     0,   151,     0,   152,   153,     0,     0,   155,
       0,   157,   158,     0,     0,   159,     0,   160,   161,     0,
       0,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,     0,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,  3639,
     181,   182,   183,     0,     0,   184,     0,   185,   186,     0,
       0,     0,   188,     0,   189,     0,     0,   190,  3465,     0,
     191,   192,   193,     0,     0,     0,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,     0,   205,     0,     0,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
    3466,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
    3467,     0,     0,     0,     0,     0,     0,     0,   220,     0,
       0,     0,   221,  3468,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,  -183,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,     0,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,  3469,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,     0,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,     0,   301,  -183,     0,   302,     0,     0,
     304,     0,     0,   306,   307,  3470,     0,     0,     0,   309,
       0,   310,   311,     0,   312,   313,   314,     0,     0,   316,
       0,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,     0,   324,     0,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,     0,   333,     0,     0,     0,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,     0,   353,   354,   355,     0,     0,   356,
     357,     0,     0,     0,     0,     0,     0,     0,   359,     0,
       0,   360,     0,     0,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,  -183,     0,   369,     0,   370,
       0,     0,     0,     0,   372,     0,     0,     0,   122,  3471,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,     0,     0,     0,   130,   131,   132,     0,
       0,  -230,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,     0,     0,
       0,     0,   143,     0,   144,     0,   145,     0,     0,     0,
       0,   148,   149,  3464,     0,   151,     0,   152,   153,     0,
       0,   155,     0,   157,   158,     0,     0,   159,     0,   160,
     161,     0,     0,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,     0,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,  -204,   181,   182,   183,     0,     0,   184,     0,   185,
     186,     0,     0,     0,   188,     0,   189,     0,     0,   190,
    3465,     0,   191,   192,   193,     0,     0,     0,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,  3466,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,  3467,     0,     0,     0,     0,     0,     0,     0,
     220,     0,     0,     0,   221,  3468,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,  -183,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,     0,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,  3469,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,     0,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,     0,   301,  -183,     0,   302,
       0,     0,   304,     0,     0,   306,   307,  3470,     0,     0,
       0,   309,     0,   310,   311,     0,   312,   313,   314,     0,
       0,   316,     0,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,     0,   324,     0,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,     0,   333,     0,
       0,     0,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,     0,   353,   354,   355,     0,
       0,   356,   357,     0,     0,     0,     0,     0,     0,     0,
     359,     0,     0,   360,     0,     0,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,  -183,     0,   369,
       0,   370,     0,     0,     0,     0,   372,     0,     0,     0,
     122,  3471,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,   130,   131,
     132,     0,     0,  -230,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
       0,     0,     0,     0,   143,     0,   144,     0,   145,     0,
       0,     0,     0,   148,   149,  3464,     0,   151,     0,   152,
     153,     0,     0,   155,     0,   157,   158,     0,     0,   159,
       0,   160,   161,     0,     0,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,     0,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
       0,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,     0,   181,   182,   183,     0,     0,   184,
       0,   185,   186,     0,     0,     0,   188,     0,   189,     0,
       0,   190,  3465,     0,   191,   192,   193,     0,     0,     0,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,  3466,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,  3467,     0,     0,     0,     0,     0,
       0,     0,   220,     0,     0,     0,   221,  3468,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,  -183,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,     0,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,  3469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,     0,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,     0,   301,  -183,
       0,   302,     0,     0,   304,     0,     0,   306,   307,  3470,
       0,     0,     0,   309,     0,   310,   311,     0,   312,   313,
     314,     0,     0,   316,     0,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,     0,   324,
       0,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,     0,
     333,     0,     0,     0,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,     0,   353,   354,
     355,     0,     0,   356,   357,     0,     0,     0,     0,     0,
       0,     0,   359,     0,     0,   360,     0,     0,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,  -183,
       0,   369,     0,   370,     0,     0,     0,     0,   372,     0,
       0,     0,   122,  3471,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,  -230,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,  3464,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,     0,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,  3465,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,  3466,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,  3467,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,  3468,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
    -183,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,  3469,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,  -183,     0,   302,     0,     0,   304,     0,     0,   306,
     307,  3470,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,  3558,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,  -183,     0,   369,     0,   370,     0,     0,     0,     0,
     372,     0,     0,     0,   122,  3471,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,  1610,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,  1611,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,  1612,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
    1613,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,   702,   703,     0,   268,     0,     0,
    1614,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
    3666,  3657,  3667,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,  1615,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,  2295,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,  2296,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,  1933,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   551,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,  1934,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   552,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2305,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,  2306,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   551,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   552,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,  2295,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  2296,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   551,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   552,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,   706,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   551,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   552,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,   657,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,   658,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     659,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,  2343,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   551,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   552,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
    2295,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,   551,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   552,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     551,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   552,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
    2285,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   552,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,  3601,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,  3602,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,     0,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,   733,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,  1088,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,  1884,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,  1885,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,  2001,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
     552,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,  1884,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,  1393,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,  1394,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
       0,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,     0,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
       0,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,     0,     0,   302,     0,
       0,   304,     0,     0,   306,   307,     0,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,     0,     0,     0,     0,   372
};

static const yytype_int16 yycheck[] =
{
       7,   412,   495,   496,   490,   437,   457,   673,   592,  1161,
     744,   896,    19,   766,   963,    22,   760,   761,   762,   516,
    1197,  1287,    29,  1287,  1016,   617,   638,   615,  1163,  1164,
    1165,  1753,    39,  1937,  1894,  1066,  1195,  1509,  1312,  1915,
    1836,  1176,    49,    22,  2320,  1319,   638,  1923,  2062,  1925,
    1522,   639,  1863,     7,  1373,  2069,  2044,  2270,  1031,  1189,
    1475,  1596,  2364,  2660,  1887,  1888,  1889,  1081,  2683,  1042,
    1043,  1922,   677,  2668,  1901,  1902,   677,   574,  1331,  1332,
      87,    48,  1878,   827,  2713,     3,     3,  2716,    27,     3,
     568,     3,   444,  1952,     3,  1230,  1956,  1429,  1233,  1229,
     107,   108,   855,   110,     3,   858,  2735,     3,    87,   853,
       3,    18,  2741,     3,   121,    55,  1976,  1977,  1599,  1168,
    1169,     3,  1171,   867,   868,   869,  1261,  1262,    18,   500,
    1074,  1266,  1601,    68,    16,   640,    92,    32,    15,    16,
      34,  2041,   121,   877,   878,   879,    15,    16,   112,  2778,
     132,  1286,   165,  1288,   108,   889,   110,  1206,    16,  1251,
      15,    16,  1946,    18,  1489,    15,    16,   175,  1952,    43,
      34,  1955,  1221,  1921,  1958,    15,    16,   153,    59,    58,
      48,   142,    20,    11,   681,  1969,  1970,  2951,   210,   213,
    1239,  1240,  1241,   496,  1978,    18,  2944,   210,    86,   246,
     225,  1250,    15,    16,   175,   616,   126,  1156,   232,   108,
    1947,  1948,   108,    15,    16,   108,    54,    55,   264,   712,
     713,   714,   128,    15,    16,   340,  2037,   579,  1320,   171,
     334,  1323,  1324,  1325,  1326,   142,  1328,  1329,  1330,  1331,
    1332,  1333,  1334,  1335,  1336,  3385,    15,    16,   478,    20,
     210,   261,   142,   144,    15,    16,   486,   487,  2948,    54,
      55,    32,   257,    91,   171,   110,    32,    57,   160,    15,
      16,    15,    16,   263,    45,    15,    16,    12,   420,   112,
     230,    20,    62,    54,    55,    15,    16,   517,   410,  2595,
     353,   217,   247,    32,    15,    16,  2893,   559,   210,   225,
      74,  1186,    15,    16,   264,   199,    45,   153,    62,    15,
      16,    15,    16,    15,    16,    54,    55,   403,   388,   142,
      18,   331,   196,    70,    71,  2950,   503,    15,    16,   247,
     247,    93,   476,   247,   380,   199,   454,   535,   247,   494,
     458,   213,    10,   155,   354,   237,  2975,   175,  2263,   228,
    1972,   473,   281,   476,   127,  2984,   586,  3105,   366,  2665,
      57,   108,   517,    11,   562,    15,    16,  2992,  1990,   171,
     536,  2673,  1907,   395,    94,  3004,   166,    97,  3518,    57,
    3009,   451,   210,   130,   561,  1270,   219,   122,  1054,  1274,
     345,   398,   514,  1874,   656,   366,   372,   171,  2241,  2242,
    2243,   408,   888,    60,   394,   412,  1558,   529,    15,    16,
     417,  1563,   372,   476,   161,   422,  3031,  1569,   560,   264,
    1572,    15,    16,   567,   350,   171,   729,   345,   345,  2272,
    2273,  2274,  1020,    91,   401,    76,   328,   444,   417,   562,
    1028,   171,   153,   349,   142,  3040,  3136,  3137,    15,    16,
      63,   213,   402,   568,   684,   462,  1044,  1045,   562,  1212,
     455,   109,    51,    65,   472,   472,   427,   344,  2372,  1074,
     347,   478,  1607,  1074,  1066,   344,  2327,   484,   347,   486,
     487,  2304,   568,   395,   491,   492,   533,   497,   166,   344,
     264,   537,   347,   472,   344,   502,  1469,   347,   342,   506,
    3097,   472,  2361,   516,   511,   512,   426,   514,   515,   516,
     517,  2046,  2335,   325,   326,   281,  2375,   175,   330,   314,
     408,   108,  1994,   472,  1021,  1003,   372,  1280,  1133,  1543,
    3294,   344,  1133,   401,   347,  1040,   560,   562,   366,   515,
    3135,   415,   344,   550,   534,   347,   485,   511,  1880,    15,
      16,  2451,   344,  1688,   435,   347,   967,  1692,   353,   566,
     514,   515,  2043,   498,   546,  2037,   264,   574,   575,    15,
      16,   104,   579,   529,   364,   344,  2045,  2361,   347,   586,
    2328,  2329,   476,   344,   463,   525,   347,   566,  1322,  1914,
    1725,  2375,    15,    16,  3342,   562,   575,  1863,   344,  1863,
     344,   347,   954,   347,   344,    15,    16,   347,  1086,   616,
     517,  1788,   476,  1790,   344,   533,   533,   347,  1777,   533,
     562,  2897,  2359,   344,   533,   977,   347,   485,  1362,    15,
      16,   344,   397,  1577,   347,   561,   383,  1008,   344,   530,
     344,   347,   344,   347,   472,   347,  1078,   420,   566,   566,
     568,   568,   566,   535,   566,   562,   344,   566,  1924,   347,
    1924,   372,   485,   540,   502,   560,   673,   566,    15,    16,
     566,   540,  3267,   566,   681,   455,   566,   684,   511,   491,
     687,   688,   380,   913,   566,   540,   364,   384,   565,  2604,
     540,  1783,    15,    16,   344,   507,   565,   347,   366,   347,
     540,   455,    15,    16,  3319,  1797,  1798,  1756,   366,   688,
     472,   561,   562,  1979,   504,  1979,   562,    15,    16,    15,
      16,    15,    16,   380,   731,  1136,   733,   540,   261,  3324,
     371,   502,   416,   346,   547,  1087,   966,   344,   540,   328,
     347,  2276,  2277,   330,  3473,   201,   976,  3376,   540,  3378,
     344,   104,   731,   347,   733,    37,   517,   528,   478,  3035,
     562,   481,   435,   502,     8,  2608,   368,   225,   123,   561,
     562,   540,   567,  3388,  2650,  2598,  1928,   344,  2654,   540,
     347,  2257,   450,    27,     8,  1670,    63,   560,   246,   560,
    2601,   564,   561,   562,   540,     0,   540,   562,   331,  2650,
     540,   562,   187,  2654,   515,  1957,    28,  1959,    12,  3404,
     540,  2670,  1964,  2636,   472,   561,  2612,   561,   562,   540,
     488,   561,   562,  2076,  2077,   109,   504,   540,  1980,  1315,
    1982,  1983,  1984,   135,   540,   283,   540,   230,   540,   537,
     561,   562,   328,   145,   171,    15,    16,    69,   561,  3446,
     243,   562,   540,   336,  1739,   561,   562,   561,   562,   561,
     562,   529,   142,  2339,   168,    15,    16,   252,   470,   146,
     353,   529,  1369,   561,   562,   882,  1464,   884,   344,   420,
    1468,   347,  1494,  1471,  1472,   317,  2670,   489,   168,   337,
     540,  1302,    15,    16,     3,   155,    15,    16,   344,   420,
     907,   347,  1494,   389,  2319,   337,   913,   213,   261,  1901,
    1902,   561,   562,    58,  1411,  1412,   138,   110,   122,  2454,
     294,   344,    15,    16,   347,   187,   232,   385,   907,    15,
      16,  1409,  3661,   540,   344,  1908,   160,   347,   252,   476,
     224,  1419,  2769,   950,   173,   952,   540,   954,  2222,  2937,
    1361,   306,   256,   104,  2765,   562,  2970,   281,   344,   966,
     967,   347,   362,  1374,   497,  1443,   455,   561,   562,   976,
     977,   104,  1577,   540,   247,    49,  1577,  1926,   331,  1993,
     987,    15,    16,    57,   105,    15,    16,    15,    16,  3291,
     252,   472,  2258,   476,  2258,   562,   323,   344,  2128,   455,
     347,  3214,  1009,  1010,  1011,  1012,  3621,   200,  1440,   420,
      19,   162,  1019,   406,  1021,   329,    15,    16,  2067,   560,
    1027,   344,  1500,  2072,   347,   562,    15,    16,   217,   162,
    1037,   344,  1011,  1012,   347,  2127,   225,   526,  2087,   560,
     425,   343,    15,    16,    48,  2094,   344,   371,   344,   347,
     344,   347,   171,   347,   318,  1009,  1010,  2216,  1037,  2378,
    2109,  2110,  1796,  3365,   171,  1019,  2225,  2116,    38,   346,
     330,   264,   345,  1027,   540,  2124,   338,  1084,  2929,  2930,
    1087,  1559,  1560,   228,  1562,   517,  1564,  1565,  1566,  1567,
    1568,   549,  1570,  1571,   540,   561,   562,   318,  2921,  2048,
     474,   109,   223,   420,   113,  1084,   388,   455,    15,    16,
     261,   435,   560,  3389,  2163,   561,   562,   540,   225,  3107,
     402,    15,    16,   352,  2659,   499,   389,    12,   261,  1136,
     540,  1138,   568,  1140,  1141,  1142,  1143,  1144,   561,   562,
     362,   423,   420,   485,   497,   493,  1153,   427,  1155,   560,
     120,   561,   562,  3167,   540,    15,    16,    15,    16,  3435,
     382,   350,   420,   425,  1143,    15,    16,    15,    16,    15,
      16,    12,   109,   475,   344,   561,   562,   347,   252,   324,
     331,   171,  1189,   171,  2233,   407,  1140,  1141,   560,  2661,
    2662,  2663,   104,   540,   344,  2080,   568,   347,   331,   554,
     555,   556,   557,  2088,   104,   434,    15,    16,   108,   142,
      15,    16,   476,    12,   561,   562,   224,   540,  2690,    12,
     562,   344,  1229,   420,   347,   344,  3037,   540,   347,   426,
     503,   491,   454,   433,   222,   498,   500,   122,   561,   562,
      15,    16,   540,   560,   540,  3121,   540,   507,   561,   562,
     162,   344,   435,  2966,   347,   476,  2969,   247,   344,    75,
     381,   347,   162,   561,   562,   561,   562,   561,   562,    15,
      16,    15,    16,    89,   485,    15,    16,    15,    16,   500,
    1287,   122,   560,   283,    15,    16,   564,   199,    15,    16,
      15,    16,    15,    16,  3007,  1302,   560,  3010,  2572,   199,
     209,    66,   560,  1754,   487,  2482,  2483,   452,   318,   509,
     344,    15,    16,   347,   344,    16,   344,   347,   463,   347,
     560,    15,    16,   122,   328,   522,   523,   473,   568,   122,
    3467,  3468,  2964,  2965,    15,    16,    12,   337,   472,  2605,
     461,  2605,    15,    16,   544,   344,   497,   209,   347,   261,
    2982,   532,    15,    16,  1361,   344,  2988,   345,   347,  1366,
    1367,   261,  1369,   560,   497,   546,   453,  1374,   420,   517,
     540,   344,   340,  1380,   347,  1382,    20,   325,   326,  3011,
    1387,  1388,  3014,  1390,    28,   532,    15,    16,   475,    33,
     540,   561,  2658,   538,  2658,  1402,   532,   401,  1405,   546,
     213,   166,    53,  1881,  1411,  1412,  1413,  1414,  1387,  1388,
     546,  1390,   562,   561,  1421,  1422,  1423,   540,  2684,   331,
    2684,   540,   426,  1402,  3561,  3562,  1405,    15,    16,   171,
     939,   331,  1439,   942,  1413,  1414,   945,   344,   561,   562,
     347,  1448,  1421,  1422,  1423,   222,   122,   540,   213,   380,
     344,    15,    16,   347,   540,    15,    16,  3170,  1465,    15,
      16,   373,   393,  1470,   376,   535,   476,   232,   561,   562,
     522,   523,  2503,  3269,   264,  1482,   562,  1888,   561,  1890,
    1891,  1488,  1960,  1961,   344,  2219,   344,   347,   566,   347,
     500,  1470,   423,   470,   344,   472,   344,   347,   344,   347,
     568,   347,   153,  1981,   525,   156,   540,   528,   560,  1488,
     540,    85,   540,     3,   269,   270,  2565,   168,   318,    15,
      16,    15,    16,   142,   200,  1936,  1937,   561,    18,   450,
    1962,   561,   562,   561,   562,   344,   560,   514,   347,   344,
    1547,   540,   347,    54,    55,   470,    20,   472,  1555,   149,
     560,   540,    63,    15,    16,  3358,  3416,  3360,    32,    15,
      16,  1972,   395,   562,    15,    16,    11,   540,   337,   344,
     517,    45,   347,   562,   365,  1582,   410,  3400,   342,  1990,
      54,    55,   561,   562,   470,   497,  3490,  1594,   337,   562,
    1597,    15,    16,  3315,  2771,    85,   562,   497,   344,   364,
     344,   347,  1510,   347,   344,  1513,   344,   347,   210,   347,
      46,    15,    16,   344,  1522,  1594,   347,   344,   171,   344,
     347,   344,   347,  1531,   347,   257,  2892,    46,  2892,   366,
     562,   386,   387,   540,   337,    15,    16,    15,    16,   503,
     344,   215,   293,   347,     3,   416,   540,     6,    15,    16,
     344,  2062,   142,   347,    13,   562,   230,  2702,  2069,   554,
    2705,  2706,   257,   344,    23,    24,   347,  2844,   562,   243,
     147,   344,    15,    16,   347,   165,   476,  2722,   168,   426,
     540,   344,   540,   493,   347,   560,  2270,   168,    15,    16,
     540,   281,   540,    52,   540,   561,   562,    56,   247,  2311,
     500,   191,   562,   455,   562,    15,    16,   197,    67,    54,
      55,   470,   562,   450,   562,   344,   562,    76,   347,  2311,
     210,   372,    81,   439,   440,   215,   442,    15,    16,   455,
    2318,   540,   222,   188,    93,   540,   561,   562,   547,  2232,
     230,   455,   547,   317,   397,   257,   399,   139,   401,   108,
     403,   488,   111,   243,    77,  1762,   344,   247,  2255,   347,
     560,   120,   121,    15,    16,   540,   256,   126,   444,   445,
     446,   447,   448,   449,   562,   134,    85,  2769,    15,    16,
     344,   140,   339,   347,   460,    15,    16,   562,   344,   561,
     562,   347,   529,   468,   540,   561,   540,     3,  2209,   419,
     540,   108,   540,    51,  2301,   529,   165,  2285,  1388,   540,
    1390,    15,    16,   540,   389,   540,   562,   540,   562,   149,
      15,    16,   562,   207,   562,  2874,   560,   317,   138,   284,
     285,   562,   406,   288,   289,   562,   540,   562,   567,   562,
     562,  1421,  1422,  1423,   171,   529,   540,   337,   344,   175,
     344,   347,   211,   347,   213,   345,  1863,   175,   562,   540,
     562,   220,   561,   562,   560,   518,   476,   540,   562,   561,
     562,   568,    15,    16,  1881,  1882,   366,   540,   561,   562,
     561,  1888,   344,  1890,  1891,   347,   460,   567,   344,   562,
     560,   347,   560,   344,  2628,  2373,   347,   561,   562,   562,
      15,    16,  2380,   561,   562,   560,   215,   568,    15,    16,
     560,   540,   560,    15,    16,   560,   406,  1924,   561,   562,
     344,   230,   560,   347,    15,    16,   560,   286,   568,  1936,
    1937,   168,   560,   562,   243,   560,   426,   561,   562,  1946,
     344,   300,   560,   347,   560,  1952,   305,   560,  1955,   561,
     562,  1958,   540,    15,    16,   561,   562,   560,    15,    16,
      46,  2372,  1969,  1970,   344,  1972,   344,   347,   560,   347,
     460,  1978,  1979,   560,   562,  2924,   540,   344,   561,   562,
     347,  1988,   560,  1990,   540,   562,   345,  1994,  1995,   560,
      15,    16,   351,   560,   353,   561,   562,   560,   562,   561,
     562,   344,   450,   451,   347,   453,   562,   455,   317,  1988,
     561,   562,   560,   503,   560,   374,   375,   344,   377,   560,
     347,    15,    16,   561,   562,   560,   516,   517,   502,  2036,
    2037,   560,   391,   560,   344,   561,   562,   347,   560,    53,
    2662,  2663,   560,   533,   540,   535,   540,    15,    16,   562,
     524,   525,  1271,  1272,   413,  2062,   344,  2036,   560,   347,
      15,    16,  2069,   560,    15,    16,   562,   560,   562,    15,
      16,   561,   562,   560,  3338,  2082,   566,   560,   540,  3142,
    3143,   560,    15,    16,   540,  2614,  2615,  2882,  2883,   540,
    2584,  2585,   344,   560,   560,   347,  3231,   406,    15,    16,
     562,   560,  3254,  3255,  3256,  3257,   562,   344,     3,   562,
     347,   562,    15,    16,   344,   535,   540,   347,   560,   560,
     560,  2128,   560,    18,   281,   560,   560,   560,    15,    16,
     560,   560,   560,   560,   560,   494,   540,   560,   562,   153,
     344,   470,   156,   347,   503,   560,   560,    15,    16,   344,
     560,   460,   347,   560,   168,    15,    16,   560,   562,   560,
     540,   560,   540,   560,   560,   560,   560,   560,   252,    15,
      16,    15,    16,   540,   125,   560,   281,    15,    16,   560,
     104,  3445,   562,   560,   562,    15,    16,    15,    16,   560,
      85,    15,    16,    15,    16,   562,  3245,   540,   560,   560,
     560,   344,  2209,   562,   347,   560,  2617,   566,   560,    15,
      16,    15,    16,   540,   560,    15,    16,   225,   561,   560,
      15,    16,  2633,   560,    15,    16,   560,  2234,   560,   344,
     540,  2238,   347,  2240,  2241,  2242,  2243,   344,   162,   560,
     347,   560,   344,   560,  2251,   347,   560,   142,  2255,    15,
      16,  2258,   540,   344,    15,    16,   347,   560,    15,    16,
     560,  2754,   560,   560,   560,  2272,  2273,  2274,    15,    16,
     560,   560,  2251,   168,   560,   199,   560,   560,  2285,   293,
     560,  2759,   344,   560,  2291,   347,  2293,   344,   540,   560,
     347,   560,   560,   560,  2301,   560,   191,   560,   560,   560,
      15,    16,   197,   540,    15,    16,   560,   560,   485,   561,
     540,   560,   562,    15,    16,   560,   560,    15,    16,   344,
     215,   560,   347,   485,   561,   560,   560,   222,    15,    16,
     562,   561,   560,    15,    16,   230,   540,   261,   560,   560,
     560,   476,   554,   562,  3610,   540,  3610,   562,   243,   562,
     344,   562,   247,   347,  2361,    15,    16,   561,   372,    15,
      16,   256,   510,    15,    16,  2372,   561,  3631,  2375,   168,
     562,    15,    16,   437,   355,   562,   344,   560,   562,   347,
     561,  3647,   142,  3647,   142,  2878,  3139,  3140,  3141,   344,
    3056,   142,   347,   344,  3546,   562,   347,   540,   344,   142,
     142,   347,  2409,    15,    16,   142,   142,   331,   142,  2416,
     142,   344,  2419,   142,   347,   142,  2423,  2424,   561,   142,
    2427,   142,   317,   142,   142,   540,    44,   344,  2435,   512,
     347,   561,   337,   540,   175,  3179,  2443,    63,   540,    12,
    2419,   344,   337,   171,   347,  2923,   561,   561,   476,   540,
     345,   561,    15,    16,   561,   122,     9,   344,   561,   561,
     347,   561,   532,   561,  2443,   560,   246,    15,    16,   568,
     561,   366,   553,   562,    15,    16,   344,   533,   540,   347,
      15,    16,   380,   540,   344,   188,   568,   347,   214,    15,
      16,    15,    16,   171,   561,  3161,  2907,   435,   344,   561,
     344,   347,   562,   347,   561,   426,   344,   562,  3174,   347,
     168,   406,    44,  2991,   344,   540,   344,   347,   442,   347,
     344,   450,   344,   347,   450,   347,   419,   450,   450,    66,
     450,   426,    15,    16,    91,  2967,   561,   485,   344,   119,
     344,   347,  3020,   347,   344,   231,   540,   347,   562,   344,
     231,   119,   347,   344,    44,   471,   347,    16,   471,  2970,
     562,    15,    16,    15,    16,   460,  3310,   561,    91,   560,
     517,   568,   540,   497,    15,    16,   561,   561,   344,  2990,
     562,   347,   561,   344,   561,   540,   347,   344,   561,   540,
     347,    15,    16,   561,   540,   561,   561,   344,  2605,  2606,
     347,  2608,    15,    16,  3082,   102,   561,   540,   503,   554,
    2617,    15,    16,    15,    16,   561,  2623,   174,   561,    15,
      16,   561,   517,   540,    15,    16,  2633,   568,   561,   344,
    3214,   171,   347,   344,  2641,   562,   347,   540,   533,   427,
     535,   560,   344,   561,   561,   347,   344,    15,    16,   347,
     561,  2658,   175,   540,   561,   561,   213,   344,   561,   561,
     347,   562,   344,  2670,   123,   347,   561,   562,   562,   561,
    2677,   566,   540,   170,   561,    15,    16,  2684,   561,   561,
     540,   561,   561,  2690,   344,   561,    32,   347,   344,   561,
     213,   347,   344,   561,   540,   347,   540,   562,    16,  3110,
     344,   561,   540,   347,    15,    16,  3199,  3200,   205,    55,
     540,  3377,   540,   561,   561,   561,   540,   561,   540,    15,
      16,   561,   561,   561,   560,   560,    15,    16,   557,   560,
     485,   561,   344,   561,   540,   347,   540,   561,   256,   561,
     540,  3407,  3408,   568,  3410,   540,   485,   568,    94,   540,
     485,    97,   476,   562,   537,   561,  3167,   561,   252,   105,
    2767,   561,   560,   485,   342,   171,   561,   222,   171,   227,
     561,   171,   123,   171,   540,     7,   104,   562,   568,   540,
     230,   344,   568,   540,   347,   535,  3452,    19,  3454,  3455,
      22,  3676,   230,   540,   348,   561,   344,    29,   295,   347,
     561,   296,   299,   344,   561,   123,   347,    39,    93,   344,
     307,    93,   347,   232,   561,   232,    67,    49,   344,   568,
     344,   347,   560,   347,   403,   540,   476,  3320,    79,   540,
     560,   345,   221,   331,   162,   560,   138,   554,   540,   362,
     331,   561,   540,   366,   331,   561,   561,   306,   561,   561,
     561,   561,   561,   540,   568,    87,   561,   561,   540,   561,
     568,   344,  2869,   561,   347,  3316,   561,   568,   560,   554,
     337,   199,   210,   370,   561,   107,   108,   561,   110,   561,
     540,   171,   439,   562,   540,  2892,   511,   244,   540,   121,
     344,   568,   344,   347,   225,   347,   540,    63,   269,  3385,
    2907,   561,   337,   344,   230,   561,   347,   230,   562,   561,
     232,   232,    18,   562,   337,   472,   473,   561,    18,   496,
     344,   418,   561,   347,    18,   560,   560,   247,   540,   560,
     223,   344,   223,   261,   347,   568,   568,   561,   561,   561,
     344,  2948,   344,   347,   561,   347,   561,   504,   344,   561,
     473,   347,   561,   344,   561,   306,   347,   514,   561,    57,
     117,   561,   561,  2970,   561,   488,    12,    13,    66,   562,
     429,   430,   561,   319,   561,   561,   344,   540,   562,   347,
      78,   123,   129,  2990,   235,   561,   561,    23,   306,   241,
     562,   514,   540,   562,   561,    85,    85,   191,   561,   540,
     420,   428,   560,   331,   344,   540,   529,   347,  3015,   560,
    3017,   142,   561,   561,   540,  3447,   540,   230,   348,   230,
     561,  3028,   108,  3030,   562,   108,   561,    63,  3521,   560,
     560,    67,  3518,   344,   531,   561,   347,   561,    84,   561,
     568,   561,   123,   496,   201,   361,   543,   562,   344,  3028,
     561,   347,   561,   304,   561,   344,   561,   540,   347,   422,
    2465,   331,    40,   371,  2469,   561,   112,   331,   166,   561,
     535,   222,   108,   561,  3567,  3082,   174,   328,   561,  3490,
     126,   561,   568,   225,   123,   562,   540,   433,   540,    44,
     123,   550,   551,   552,   553,   554,   555,   556,   557,   540,
     257,   197,   148,  3110,   303,   562,   380,   561,   230,   561,
     123,   429,   430,   159,   476,   213,   540,   476,   517,   168,
     561,   560,   517,  3130,   281,   215,   215,   540,   379,  3136,
    3137,   560,   560,    32,   232,   481,   540,   561,   540,   560,
     230,   230,   188,  3150,   540,   528,    67,   528,   561,   540,
     560,   511,   108,   243,   243,   232,     4,   561,    79,   561,
    3167,     9,    10,   509,   306,   561,   398,   213,  3654,   497,
     561,   232,   540,   219,   330,   561,   408,   331,   562,    27,
     412,   535,   560,   562,    32,   417,   225,   561,    36,   561,
     422,   561,  3678,   561,   561,   561,   232,   118,  3205,   450,
     540,   552,   553,   554,   555,   556,   557,    85,   365,  3216,
     256,   561,   444,   151,   371,   303,  3627,   561,   476,   562,
     561,   561,  3511,   142,   143,   306,   476,   317,   317,   540,
     462,   476,   550,   551,   552,   553,   554,   555,   556,   557,
     472,   232,   399,    65,   540,    16,   478,   337,   337,   561,
     561,   540,   484,   230,   486,   487,   561,   517,   517,   491,
     492,   180,   327,  3552,   562,   561,   364,   306,   116,   523,
     502,   168,   561,   306,   506,   194,   403,   561,   435,   511,
     512,   331,   514,   515,   516,   517,   331,   429,   430,   325,
     326,  2696,   511,   306,   330,   342,   472,   249,   455,    34,
     270,   337,    57,   560,  3593,   560,    57,   226,   342,   366,
      44,  3600,   560,   470,   235,   472,   406,   406,   550,   238,
     561,   367,   561,   561,   561,  2730,  2731,  3616,   364,    44,
     135,  3338,  3339,  2738,   566,    44,   142,   215,   384,     5,
    2745,   439,   574,   575,   390,   342,   265,   579,   429,   430,
     396,  3358,   230,  3360,   586,  3362,  3363,   384,   342,   561,
    3339,  3650,    97,  3652,   131,   243,   562,    44,  3375,   104,
     460,   460,    34,    44,   420,    44,   561,   118,   562,   414,
      16,    28,   532,   304,   616,   431,   432,   569,   424,   560,
     429,   430,   274,   535,   171,   532,   429,   430,  3405,    28,
     561,   222,   321,   142,   325,   326,   504,   328,   550,   551,
     552,   553,   554,   555,   556,   557,   429,   430,   138,   562,
     155,   467,   566,   561,   209,   532,   138,   162,   263,   569,
     566,   106,   210,  3440,   548,    97,   566,   331,  3445,   317,
     560,   673,   104,   562,   138,   547,   195,   562,   566,   681,
     249,   426,   684,   548,   394,   687,   688,  3464,   379,   337,
    3467,  3468,  3469,   168,   199,   511,   168,   513,   504,   550,
     551,   552,   553,   554,   555,   556,   557,   168,   547,   534,
     108,   523,   169,  3490,   679,  1810,  1573,  3486,  3027,  3204,
    3030,  3678,  3643,   155,  3501,  3649,  3573,  3530,  3573,   731,
     162,   733,  3562,  3510,  3511,  3036,  3538,  3537,   392,  2763,
    3517,   550,   551,   552,   553,   554,   555,   556,   557,   552,
     553,   554,   555,   556,   557,  3532,   261,  3534,   406,   450,
    1543,  1133,   142,  3540,    23,    24,  3134,   199,   551,   552,
     553,   554,   555,   556,   557,  3552,  2429,  2690,  2037,  1547,
     160,  1509,  1950,  1997,  3561,  3562,   404,  2677,  2713,  2713,
    2746,  2953,  3569,  3159,  2999,    54,    55,    56,  2990,  3576,
     180,   419,  2678,  2633,    63,  3582,  3583,   425,    67,  3364,
    3374,  3153,   460,   318,   194,  3299,  3593,    76,  1148,  3216,
    3174,  1993,   327,  3600,  1858,   330,   331,   445,  1413,   261,
    1477,   688,  1051,  3610,    93,  3612,  3613,   456,  1129,  3616,
    2251,  3618,  1841,  3620,    12,    13,   672,  1872,   604,   108,
    3627,  3264,   111,  1428,  3631,  2877,  2648,   237,   238,  3082,
    3637,  2878,  1226,  2070,  3363,  1272,  2684,  1176,  3131,  3567,
    3647,  2226,  3110,  3650,  1877,  3652,  1837,  3654,   954,     3,
     882,   140,   884,   977,  1862,   265,   318,  3664,  3665,    13,
      14,  3668,  2892,  2658,  2600,  2599,  3631,  3445,   330,   331,
     446,  3678,    26,   733,    28,   907,   507,  1153,   437,  1379,
    2590,   913,   982,  3520,  3351,  3541,    84,  3414,  2409,  3647,
    2605,  2992,    46,    47,   995,  2303,  2641,  3118,    52,  1405,
    2918,  1434,    56,    57,   985,   429,   587,   947,  3252,  3258,
    2238,   430,  1138,   323,   112,    69,   591,  2203,   950,  2556,
     952,   389,   954,  1297,   213,   497,   389,   474,   126,  2035,
      84,   220,   496,  2760,   966,   967,  2468,    -1,  3033,   496,
     496,   476,    -1,   478,   976,   977,   481,    -1,    -1,   103,
     148,    -1,    -1,   363,    -1,   987,   491,    -1,   112,   113,
     114,   159,   497,   995,    -1,   500,    -1,    -1,    -1,    -1,
      -1,   125,   126,    -1,    -1,    -1,    -1,  1009,  1010,  1011,
    1012,    -1,    -1,    -1,    -1,    -1,    -1,  1019,    -1,  1021,
     188,    -1,    -1,    -1,   148,  1027,    -1,   286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1037,    -1,    -1,    -1,    -1,
     164,   300,    -1,    -1,   476,   213,   478,   552,   553,   481,
      -1,   219,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   491,
      -1,    -1,    -1,    -1,   188,   497,    -1,    -1,   500,    -1,
      -1,   195,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1084,    -1,    -1,  1087,    -1,    -1,   256,    -1,
      -1,    -1,   351,    -1,   353,   219,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,
      -1,    -1,    13,  3440,    -1,   374,   375,    -1,   377,    -1,
     552,   553,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,
      -1,    -1,   256,    -1,  1136,    -1,  1138,    -1,  1140,  1141,
    1142,  1143,  1144,    -1,  1499,    -1,    -1,    -1,    -1,    -1,
      -1,  1153,    -1,  1155,   413,    -1,  1511,  1512,    -1,  1514,
    1515,  1516,    -1,    -1,  1519,    -1,    -1,    -1,    -1,  1524,
      -1,    -1,    -1,  1528,  1529,  1530,    -1,    -1,  1533,  1534,
    1535,  1536,  1537,    84,  1539,  1540,  1541,  1189,    -1,    -1,
    3517,    -1,  2694,  2695,    -1,    -1,    -1,    -1,    -1,   367,
    2702,    -1,    -1,  2705,  2706,  3532,    -1,  3534,    -1,    -1,
      -1,   112,    -1,  3540,    -1,    -1,   384,   341,    -1,    -1,
    2722,    -1,   390,    -1,    -1,   126,    -1,  1229,   396,    -1,
      -1,    -1,    -1,    -1,  2736,   494,    -1,    -1,   362,  2741,
    2742,  2743,  2744,    -1,   503,   369,    -1,   148,    -1,  3576,
      -1,    -1,   420,    -1,    -1,    -1,  3583,    -1,   159,    -1,
      -1,    -1,    -1,   431,   432,   389,    -1,   391,   392,    -1,
      -1,   395,    -1,    -1,   398,    -1,   400,    -1,    -1,    -1,
      -1,   405,    -1,   407,    -1,  1287,  3613,   188,    -1,    -1,
      -1,  3618,   416,    -1,    -1,    -1,   420,    -1,    -1,   467,
    1302,    -1,   426,   562,    -1,    -1,    -1,   431,    -1,    -1,
    3637,   435,   213,    -1,    -1,    -1,    -1,    -1,   219,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    13,    14,    -1,
     454,    -1,    -1,    -1,   458,    -1,    -1,  3664,  3665,    -1,
      26,  3668,    -1,   511,    -1,   513,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   256,    -1,    -1,    -1,  1361,
      46,    47,    -1,    -1,  1366,  1367,    52,  1369,   492,    -1,
      56,    57,  1374,    -1,    -1,    -1,    -1,    -1,  1380,    -1,
    1382,    -1,    -1,    69,   508,  1387,  1388,   511,  1390,    -1,
      -1,    -1,   516,    -1,    -1,    -1,    -1,    -1,    84,    -1,
    1402,    -1,    -1,  1405,    -1,    -1,    -1,    -1,    -1,  1411,
    1412,  1413,  1414,    -1,    -1,   539,    -1,   103,    -1,  1421,
    1422,  1423,    -1,    -1,    -1,    -1,   112,   113,   114,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   560,  1439,    -1,   125,
     126,    23,    24,    -1,    -1,    -1,  1448,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,  1465,    -1,    -1,   367,    -1,  1470,    -1,
      -1,    -1,    54,    55,    56,    -1,    -1,    -1,   164,    -1,
    1482,    63,    -1,   384,    -1,    67,  1488,    -1,    -1,   390,
      -1,    -1,    -1,    -1,    76,   396,    -1,    -1,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,   195,
      -1,    93,   198,    -1,    -1,    -1,    -1,    -1,    -1,   420,
      -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,   111,
     431,   432,    -1,   219,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1547,    -1,   233,    -1,    -1,
      -1,    -1,    -1,  1555,    -1,    -1,    -1,    -1,   140,    -1,
      -1,    -1,    -1,    -1,    -1,   251,   467,    -1,    -1,    -1,
     256,    -1,    -1,   267,   268,   269,   270,   271,   272,  3440,
    1582,   275,   276,   277,   278,   279,   280,    -1,   282,    -1,
      -1,    -1,  1594,    -1,    -1,  1597,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3467,  3468,  1963,    -1,
     511,    -1,   513,    -1,    -1,    -1,    -1,    -1,    -1,  1974,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   213,    -1,    -1,    -1,    -1,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3510,
    3511,    -1,    -1,    -1,    -1,   341,  3517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   246,    -1,    -1,    -1,    -1,    -1,
      -1,  3532,    -1,  3534,    -1,    -1,   362,    -1,    -1,  3540,
      -1,    -1,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3552,   386,   387,    -1,    -1,    -1,    -1,    -1,    -1,
    3561,  3562,    -1,   389,   286,   391,   392,    -1,    -1,   395,
      -1,    -1,   398,    -1,   400,  3576,    -1,    -1,   300,   405,
      -1,   407,  3583,    -1,     6,    -1,    -1,    -1,    -1,    -1,
     416,    13,  3593,    -1,   420,    -1,    -1,    -1,    -1,  3600,
     426,    23,    24,    -1,    -1,   431,    -1,    -1,    -1,   435,
      -1,    -1,  3613,    -1,    -1,  3616,    -1,  3618,    -1,    -1,
    1762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   454,   351,
      52,   353,   458,    -1,    56,    -1,  3637,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,  3650,
      -1,  3652,   374,   375,    76,   377,    -1,    -1,    -1,    81,
      -1,    -1,    -1,  3664,  3665,    -1,   492,  3668,    -1,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   508,    -1,    -1,   511,   108,    -1,    -1,   111,
     516,   413,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,   126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   134,   539,    -1,    -1,    -1,    -1,   140,    -1,
      -1,  1863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   560,    -1,    -1,    -1,    -1,  1881,
    1882,    -1,    -1,   165,    -1,    -1,  1888,    -1,  1890,  1891,
      -1,    -1,    31,    32,    -1,    -1,    -1,    -1,    37,    -1,
      39,    40,    41,    98,    99,   100,   101,   102,    -1,    -1,
      -1,    -1,   494,    -1,    -1,    -1,    55,    -1,    -1,    -1,
      -1,   503,  1924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   213,    -1,    -1,  1936,  1937,    -1,    -1,   220,    -1,
      -1,    -1,    -1,    -1,  1946,    -1,    -1,    -1,    -1,    -1,
    1952,    -1,    -1,  1955,    -1,    94,  1958,    -1,    97,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   105,  1969,  1970,    -1,
    1972,    -1,    -1,    -1,    -1,    -1,  1978,  1979,   560,    -1,
      -1,    -1,    -1,    -1,    -1,   124,  1988,    -1,  1990,    -1,
      -1,    -1,  1994,  1995,    -1,    -1,    -1,    -1,    23,    24,
      -1,    -1,   141,    -1,   286,    -1,    -1,   202,   203,   204,
     205,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,    -1,   161,   305,   163,    -1,    -1,    -1,    -1,    54,
      55,    56,    -1,    -1,  2036,  2037,    -1,    -1,    63,    -1,
      -1,    -1,    67,   182,   183,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2062,    -1,    -1,   345,    -1,    -1,    -1,  2069,    93,   351,
      -1,   353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2082,    -1,    -1,   108,   223,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   374,   375,    -1,   377,   509,    -1,    -1,    -1,
     295,    -1,   297,   298,   299,    -1,    -1,    -1,    -1,   391,
      -1,   250,   307,    -1,    -1,   140,    -1,    -1,    -1,    -1,
     259,   260,    -1,   262,    -1,    -1,  2128,    -1,    -1,    -1,
      -1,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    23,    24,    -1,    -1,    -1,    -1,   562,
      -1,   290,   291,   292,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   310,   311,   312,    -1,   370,    56,   316,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,    -1,    67,   213,    -1,
      -1,    -1,    -1,   332,   333,   220,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2209,    -1,    -1,
      -1,    -1,   494,    93,    -1,    -1,    -1,    -1,   357,    -1,
     359,   503,   417,   418,    -1,    -1,    -1,    -1,   108,    -1,
      -1,   111,  2234,    -1,    -1,    -1,  2238,    -1,  2240,  2241,
    2242,  2243,   381,    -1,    -1,    -1,    -1,    -1,    -1,  2251,
      -1,    -1,    30,  2255,    32,    33,  2258,    -1,    -1,    -1,
     140,   286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2272,  2273,  2274,    -1,    -1,   300,    54,    55,   691,   123,
      -1,    -1,    -1,  2285,    -1,   424,    64,   426,    66,  2291,
      -1,  2293,    -1,    -1,    -1,    -1,    -1,   436,    -1,  2301,
      -1,    -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,    -1,   353,    -1,
      -1,    -1,    -1,   213,    -1,    -1,   531,    -1,   477,   478,
     220,    -1,   481,   482,   483,   484,    -1,   542,   543,   374,
     375,    -1,   377,    -1,    -1,    -1,    -1,    -1,    -1,  2361,
      -1,   139,   140,    -1,    -1,    -1,   144,    -1,    -1,    -1,
    2372,    -1,    -1,  2375,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   225,    -1,    -1,    -1,   524,   525,   800,   413,    -1,
      -1,    -1,    -1,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,   246,    -1,   543,    -1,   286,  2409,    -1,   187,
      -1,   189,    -1,   826,  2416,    -1,    -1,  2419,    -1,    -1,
     300,  2423,  2424,    -1,    -1,  2427,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2435,   212,   213,    -1,    -1,   216,    -1,
      -1,  2443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   306,   876,    -1,    -1,    -1,   880,    -1,   494,
      -1,   351,    -1,   353,   252,    -1,    -1,    -1,   503,   257,
      -1,   325,   326,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   374,   375,    -1,   377,    -1,    -1,
      -1,    -1,    -1,   281,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   413,    -1,   313,    -1,    -1,    -1,    -1,
      -1,   385,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   995,    -1,    -1,   429,   430,   365,   366,    -1,
      -1,  1004,    -1,    -1,   438,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2605,  2606,    -1,  2608,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   494,  2617,    -1,    -1,    -1,    -1,
      -1,  2623,    -1,   503,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2633,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2641,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2658,   435,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2670,    -1,
      -1,    -1,    -1,    -1,    -1,  2677,    -1,   455,    -1,    -1,
      -1,   459,  2684,    -1,    -1,    -1,    -1,    -1,  2690,    -1,
      -1,    -1,    -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   549,   550,   551,   552,   553,
     554,   555,   556,   557,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1157,  1158,  1159,    -1,   526,    -1,
      -1,    -1,   530,  1166,  1167,    -1,    -1,  1170,    -1,  1172,
    1173,  1174,  1175,    -1,    -1,  2767,  1179,    -1,    -1,  1182,
    1183,    -1,  1185,    -1,  1187,  1188,    -1,  1190,  1191,  1192,
    1193,  1194,    -1,  1196,    -1,  1198,  1199,  1200,    -1,  1202,
    1203,  1204,  1205,    -1,  1207,  1208,    -1,  1210,    -1,    -1,
    1213,  1214,  1215,    -1,  1217,  1218,  1219,  1220,    -1,  1222,
    1223,  1224,  1225,    -1,    -1,    -1,    -1,    -1,  1231,  1232,
      -1,  1234,  1235,  1236,  1237,  1238,    -1,    -1,    -1,    -1,
    1243,    -1,  1245,  1246,  1247,  1248,  1249,    -1,    -1,  1252,
    1253,  1254,  1255,  1256,  1257,    -1,  1259,  1260,    -1,    -1,
    1263,  1264,  1265,    -1,  1267,    -1,  1269,    -1,    -1,    -1,
    1273,    -1,  1275,  1276,    -1,    -1,    -1,  2869,  1281,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1289,  1290,  1291,    -1,
      -1,    -1,    -1,    -1,    -1,  1298,    -1,    -1,  1301,    -1,
    2892,    -1,    -1,    -1,    -1,  1308,  1309,  1310,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2907,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2948,    -1,    -1,    -1,
    1363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2970,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2990,    -1,
      -1,    -1,    -1,    -1,    -1,  1408,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3015,    -1,  3017,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3028,    -1,  3030,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3082,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3130,    -1,
      -1,    -1,    -1,    -1,  3136,  3137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1557,    -1,    -1,    -1,  3150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3167,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3205,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3216,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1734,  1735,  1736,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3338,  3339,  1751,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3358,    -1,  3360,    -1,
    3362,  3363,    -1,    -1,  1777,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3375,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1799,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3405,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3445,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3464,    -1,    -1,    -1,    -1,  3469,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3490,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3501,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3569,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3582,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3610,    -1,
    3612,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3620,    -1,
      -1,    -1,    -1,    -1,    -1,  3627,    -1,    -1,    -1,  3631,
      -1,    -1,    -1,    -1,    -1,    -1,  2049,    -1,    -1,  2052,
      -1,    -1,  2055,  2056,    -1,  3647,    -1,    -1,    -1,    -1,
      -1,    -1,  3654,    -1,    -1,  2068,    -1,    -1,  2071,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2084,    -1,  2086,    -1,    -1,  3678,  2090,    -1,  2092,
    2093,    -1,    -1,    -1,  2097,    -1,  2099,  2100,    -1,  2102,
      -1,    -1,  2105,    -1,  2107,  2108,    -1,    -1,    -1,    -1,
    2113,  2114,    -1,    -1,  2117,    -1,  2119,    -1,  2121,    -1,
    2123,    -1,  2125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2136,  2137,    -1,    -1,  2140,    -1,  2142,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2150,  2151,    -1,
    2153,    -1,  2155,    -1,    -1,  2158,  2159,  2160,    -1,  2162,
      -1,    -1,    -1,    -1,  2167,  2168,  2169,  2170,    -1,    -1,
      -1,    -1,  2175,  2176,  2177,    -1,  2179,    -1,  2181,    -1,
    2183,    -1,  2185,    -1,  2187,    -1,    -1,    -1,    -1,    -1,
      -1,  2194,    -1,  2196,    -1,    -1,  2199,  2200,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2210,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2245,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2294,    -1,    -1,    -1,    -1,  2299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2342,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2458,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2531,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2541,    -1,
    2543,    -1,  2545,    -1,    -1,    -1,    -1,    -1,  2551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2574,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2642,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2792,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2802,
      -1,    -1,    -1,    -1,    -1,  2808,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2817,  2818,    -1,    -1,    -1,    -1,
    2823,    -1,    -1,    -1,  2827,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2840,    -1,    -1,
      -1,    -1,    -1,  2846,    -1,    -1,  2849,  2850,    -1,  2852,
    2853,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2866,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2933,  2934,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2944,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3227,    -1,    -1,    -1,    -1,    -1,
    3233,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3268,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3278,    -1,  3280,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3342,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3394,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3417,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3506,  3507,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3526,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3535,    -1,    -1,    -1,    -1,    -1,    -1,  3542,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3580,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,  3594,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    42,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,  3655,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,   239,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,    -1,   567,   568,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,   337,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,    -1,   567,   568,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,   420,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,    -1,   567,   568,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,   563,   564,    -1,    -1,   567,   568,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,   561,    -1,   563,   564,    -1,    -1,
     567,   568,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,    -1,
     563,   564,    -1,    -1,   567,   568,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,   561,    -1,   563,   564,    -1,    -1,   567,   568,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,   171,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,    -1,   567,   568,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
     171,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,    -1,   567,   568,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,   171,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,    -1,
     567,   568,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,    -1,   567,   568,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,    -1,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,    -1,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,    -1,   567,   568,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,    -1,   567,   568,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,    -1,   567,   568,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,    -1,
     567,   568,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,    -1,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,    -1,   567,   568,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,   174,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,   213,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,   232,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,   246,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,   420,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
     439,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,   568,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    78,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,   213,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,   568,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,   420,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,   561,    23,    24,    25,
      26,    -1,    28,   568,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   561,    -1,    17,    -1,    -1,
      20,   567,   568,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,   222,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,   568,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,   568,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   560,    -1,    23,    24,
      25,    26,    -1,    28,   568,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,   567,   568,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,   568,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,   568,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,   568,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
     568,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,    -1,   543,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,   567,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,    -1,   548,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,   562,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,   554,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,    -1,   543,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,   554,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,   132,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,   546,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,   532,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,   546,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,   532,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,   546,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,
      51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,
     161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,
      -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,
     411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,
      -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,
      -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,
     159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
     229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,
     399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,
      -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,   418,
      -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,
      -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,
      -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
     157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,
      -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,
      -1,   408,    -1,   410,   411,    -1,   413,   414,   415,    -1,
      -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,
      -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,
      -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,
       5,   548,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,
      -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
      -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,   394,
      -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,
      -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,
     415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,
      -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,
     455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,
      -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,
      -1,    -1,     5,   548,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
     263,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543,    -1,    -1,    -1,     5,   548,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,   162,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
     261,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,   325,   326,    -1,   328,    -1,    -1,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
     441,   442,   443,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,   497,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    32,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,   142,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,   427,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    88,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      18,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,   150,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,    -1,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,   171,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,   364,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      -1,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    -1,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,    -1,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,    -1,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   574,   575,   576,   577,   578,   580,   585,
     587,   592,   604,   772,   790,   793,   801,   803,   805,   808,
     813,   815,   820,   823,   828,   832,   840,   841,   979,   981,
     987,   990,  1015,  1023,  1034,  1036,  1050,  1053,  1056,  1062,
    1066,  1070,  1073,  1074,  1120,  1137,  1143,  1145,  1152,  1154,
    1179,  1185,  1186,  1187,  1188,  1234,    11,    91,   175,   210,
     366,   786,  1209,  1210,   252,   329,   822,   470,   472,  1139,
    1180,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   598,  1110,  1114,  1118,  1119,   281,  1139,
    1139,   536,  1181,    91,   174,   439,   473,   504,   514,   596,
     689,   690,   691,   764,  1024,   980,    91,   175,   213,   366,
     473,   488,   514,   529,   986,  1114,   822,   597,   568,  1108,
    1109,  1114,   586,   988,  1071,    93,   213,   472,  1139,   822,
    1114,  1067,   416,   514,  1139,   822,   991,  1063,  1139,   597,
    1181,  1114,   843,   845,   846,   342,  1122,  1037,   454,   458,
     435,   487,   435,   472,  1035,  1144,  1016,  1114,    28,    69,
     138,   362,   382,   407,   454,  1236,   420,   560,   842,     0,
       3,   572,   362,   153,  1054,  1108,  1114,   142,   778,  1114,
     598,   598,   472,   109,  1204,  1205,  1206,  1139,   804,  1181,
     829,   830,  1108,   605,   568,   485,   806,   816,    16,  1182,
     209,   692,   597,   347,  1201,  1205,  1206,  1207,  1208,  1209,
     472,   690,   213,   210,   264,   372,  1032,  1033,   895,   896,
     209,   985,   985,  1114,   985,   985,   597,   985,  1139,   581,
    1057,    12,    13,    84,   112,   126,   148,   159,   188,   213,
     219,   256,   367,   384,   390,   396,   420,   431,   432,   467,
     511,   513,  1155,  1157,  1159,  1160,  1114,   340,    60,   380,
     568,   245,   476,  1111,  1114,  1116,   110,   200,   264,   993,
      76,   371,  1072,  1075,   222,  1108,  1138,  1139,   171,    32,
     281,  1042,  1068,  1114,   597,   824,  1139,   110,   264,   994,
    1022,   281,   371,   435,  1064,  1065,   802,    12,  1153,  1157,
     485,  1182,   844,    12,   122,   200,   444,   445,   446,   447,
     448,   449,   460,   850,   851,   852,  1121,    30,    33,    54,
      55,    64,    66,    83,    84,    92,   140,   144,   173,   175,
     187,   189,   212,   213,   216,   231,   252,   257,   281,   313,
     322,   340,   365,   366,   425,   435,   459,   472,   530,   737,
     763,  1038,  1042,  1043,  1045,  1128,   795,   796,   795,   795,
     535,   794,   795,   984,  1108,  1139,  1022,    34,   199,   476,
    1096,  1112,  1235,  1235,  1235,  1235,  1235,   845,   842,   561,
     566,  1114,  1052,  1051,   294,   474,   499,   774,   776,   775,
    1108,   142,   450,  1211,   814,   983,   984,   225,   562,   836,
     837,   560,   606,  1114,   588,   983,   983,    51,   328,   328,
     389,  1183,   325,   326,   867,  1114,    88,  1116,  1117,  1170,
    1171,   395,    10,   366,   488,   856,  1203,  1211,  1212,  1220,
    1222,  1223,  1229,   856,  1202,  1212,  1220,  1223,  1229,  1204,
    1209,   692,  1114,   171,  1025,  1029,  1030,  1114,  1032,     7,
      20,    22,    25,    29,    32,    34,    35,    36,    38,    50,
      54,    55,    61,    64,    72,    73,    79,    81,    82,    83,
      87,    88,    90,    91,    95,    96,    97,   102,   104,   107,
     108,   115,   116,   133,   136,   137,   149,   152,   154,   155,
     158,   162,   167,   172,   176,   177,   178,   179,   181,   182,
     184,   185,   186,   190,   192,   193,   199,   205,   209,   219,
     221,   236,   240,   243,   248,   250,   253,   258,   261,   266,
     273,   283,   287,   295,   299,   301,   302,   306,   307,   308,
     309,   310,   311,   312,   318,   325,   326,   327,   330,   331,
     336,   353,   354,   356,   357,   358,   359,   360,   370,   378,
     394,   395,   406,   409,   412,   414,   418,   456,   457,   462,
     464,   465,   466,   469,   476,   478,   479,   480,   481,   490,
     491,   492,   497,   500,   505,   506,   514,   518,   519,   520,
     521,   522,   527,   531,   541,   543,   548,   552,   553,   558,
     560,   563,   564,   567,   568,   861,   862,   863,   864,   868,
     871,   872,   874,   881,   885,   897,  1095,  1097,  1099,  1100,
    1104,  1106,  1110,  1114,   149,  1114,  1114,   337,   598,   598,
    1117,  1169,   983,   985,   517,   582,   117,   201,   257,   281,
     365,   371,   399,   435,   455,   470,  1058,  1059,  1139,   365,
    1158,   410,   410,   473,   514,   529,   342,  1162,   470,  1164,
      59,   435,  1161,    92,   529,  1163,   337,   562,    18,   142,
     939,   940,  1146,  1114,   786,   861,    74,   171,   264,  1076,
    1082,    46,   171,  1108,  1140,  1141,   821,   567,   579,  1111,
     257,   825,  1117,   826,   827,  1108,   809,   222,   984,   995,
     996,    46,   562,   983,  1158,   337,   416,  1184,  1183,   503,
    1189,  1190,   554,   854,   855,   856,   852,  1123,  1124,  1125,
     257,   147,   426,   246,   533,  1049,   493,   560,    91,   175,
     366,   472,   529,  1049,   699,  1116,   247,   958,   960,    62,
     455,   168,   455,   455,   455,   281,   470,    62,   455,   201,
     455,   455,   493,   958,  1049,   171,   225,  1046,   257,   139,
      65,   368,   470,   489,   455,   526,   792,   388,   451,   797,
     798,   791,    77,   786,   562,   339,  1238,   468,  1239,   230,
     402,  1237,   561,  1190,  1192,  1193,  1194,     3,   573,   840,
    1055,  1096,  1114,   108,   687,   688,   697,   698,   746,   599,
     599,   773,  1117,   419,   529,   983,   485,   562,   108,   831,
    1114,   830,   213,   232,   761,   762,   838,   607,   608,   861,
     267,   268,   269,   270,   271,   272,   275,   276,   277,   278,
     279,   280,   282,   386,   387,   589,   590,   591,   153,   372,
     807,    53,   153,   156,   168,   293,   372,   817,   818,   819,
      51,   389,   149,   595,   560,   860,   567,   207,   562,   856,
     856,   856,   175,   529,   175,  1212,  1108,   494,   517,   765,
    1029,  1108,  1114,   562,  1027,   568,  1031,   560,   560,   560,
     560,   560,   872,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   860,   860,   560,
     860,   560,   560,   560,   500,   560,  1095,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   861,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   898,   899,   900,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   861,   560,   860,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   860,   560,
    1095,   560,   560,   560,  1095,   560,   560,    34,   199,   476,
     560,   560,   560,   860,   860,   860,   560,   560,   560,   560,
     560,   560,   861,   902,   872,   872,   872,   420,   560,   861,
    1198,  1114,   886,  1114,    15,    16,   344,   347,   540,   865,
     866,   142,   143,   180,   194,   226,   238,   265,   321,   869,
     123,   225,   246,   306,   385,   429,   430,   438,   549,   550,
     551,   552,   553,   554,   555,   556,   557,   867,   872,    98,
      99,   100,   101,   102,   202,   203,   204,   205,   295,   297,
     298,   299,   307,   370,   417,   418,   531,   542,   543,   935,
     937,    63,   346,   562,  1112,   560,   568,   568,  1108,   562,
      48,   401,   787,   983,   567,   583,   584,    46,   535,   562,
    1060,   470,   560,  1172,  1172,  1172,  1172,   175,   366,   472,
    1156,  1160,  1114,   160,   323,  1114,  1147,  1148,   995,   281,
     252,  1081,   833,   281,   940,   562,   983,  1116,    27,   485,
    1069,   562,   485,   562,   485,   983,   996,   992,  1065,   171,
     562,   175,   366,  1156,  1114,    12,   122,  1196,   562,   847,
     858,   861,  1102,  1114,   562,   187,   252,   338,   425,  1126,
    1127,  1130,  1131,   225,  1047,  1111,   861,   554,   692,   598,
     598,  1108,  1108,  1039,   261,   331,   497,   961,   962,  1097,
     598,  1049,  1117,   168,  1044,  1046,   598,  1049,  1044,  1108,
    1046,  1044,  1044,  1049,  1049,   510,   799,   562,   799,   437,
     420,   560,   564,   905,   906,   907,   908,   917,   918,   926,
    1096,   355,  1240,   345,   954,   960,  1195,   688,    63,   737,
      67,    79,   235,   304,   328,   379,   450,   601,   603,     6,
      13,    23,    24,    52,    56,    67,    76,    81,    93,   111,
     120,   121,   126,   134,   140,   165,   211,   213,   220,   286,
     300,   305,   345,   351,   353,   374,   375,   377,   391,   413,
     494,   503,   694,   696,   697,   698,   779,   780,   781,   950,
     109,   224,  1108,  1111,   984,   560,   561,   562,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   142,   562,   512,   818,   686,   687,   561,  1116,
      44,  1171,   175,   598,   598,   598,  1114,  1108,   593,    43,
     196,   415,   766,   766,   337,  1028,  1026,   568,  1030,   171,
     554,  1114,   940,   861,   861,   861,    12,   122,   891,   941,
     104,   162,   199,   261,   331,   497,   964,   891,   891,   891,
     861,   861,   895,   895,   861,   895,   861,   861,   861,   861,
     122,   891,   941,   861,   561,   861,   861,   861,   861,   861,
    1104,  1114,   861,   861,   861,   861,   861,   560,  1198,   861,
     935,   861,   861,   861,   561,   861,   861,   861,   861,   895,
     861,   861,    94,    97,   478,   481,   938,   861,   122,   888,
    1095,   861,   861,   861,   561,   861,   861,   861,   861,   895,
     861,   861,   861,   861,   899,     9,   901,  1104,   122,   891,
     861,   861,   122,   891,   861,   861,   861,   861,   861,   895,
     895,   895,   861,   861,   861,   861,   861,   861,   895,   864,
     861,   561,   861,   861,   861,   861,   861,   561,   861,   861,
     891,   891,   861,   861,   861,   122,   891,   861,   861,   170,
     936,   937,   936,   861,    42,   239,   486,   861,   861,  1095,
     561,   861,   561,   891,  1105,  1106,  1114,   891,   861,   861,
     861,   532,   904,  1199,  1199,   561,   562,   561,   861,   567,
     887,  1116,   568,   861,   861,   861,   863,   155,   330,   491,
     507,   867,    12,    17,   863,   870,   864,   560,   872,   864,
     864,   864,   864,   246,   864,   864,   864,   864,   871,   864,
     871,   864,   864,   864,   864,   225,   246,   385,   549,   553,
    1116,   872,   861,   873,  1114,  1114,   982,  1117,   787,  1116,
     562,   380,  1059,   983,  1061,  1114,  1173,  1174,   554,  1108,
    1114,  1168,  1168,  1168,   142,   160,   180,   194,   237,   238,
     265,   323,   363,  1149,  1151,   533,   942,   989,   214,   834,
     835,  1108,   264,   380,   537,  1142,  1141,   861,  1111,  1117,
    1117,   827,  1108,   153,   372,   515,   810,   811,   812,   420,
     426,   522,   523,   560,   682,   997,  1000,  1111,   188,  1168,
    1168,  1168,  1191,   855,   171,   222,   848,   849,   953,   954,
     975,   857,   568,  1124,   108,   487,  1114,  1133,   314,   353,
     567,   737,  1132,  1111,   171,  1048,   561,  1114,   257,   455,
    1041,   334,   562,   435,  1049,  1114,  1049,  1044,  1108,  1049,
    1049,   591,   800,   798,   925,  1114,    85,   215,   230,   243,
     317,   406,   460,   916,   426,   562,  1108,   925,   562,   168,
    1241,    44,   958,   142,   427,  1006,  1007,  1007,  1111,   450,
     450,   450,   450,   450,   419,    66,    78,   174,   439,   708,
     711,   712,   759,   761,   785,   785,  1007,  1007,   785,  1007,
    1007,  1007,   485,   119,  1007,   231,   471,   166,   364,   761,
     785,   231,  1007,   471,   119,  1007,  1007,  1007,   785,    44,
    1007,  1007,  1007,  1007,  1007,    18,   142,   485,   789,  1007,
    1007,  1007,   694,   562,   560,   568,   707,   713,  1107,  1114,
     777,   364,   933,  1114,   861,   964,  1111,  1111,   104,   162,
     261,   331,   497,   965,  1111,   964,  1111,  1111,  1111,  1111,
    1111,   964,  1111,  1111,   964,   590,   353,   476,  1114,  1230,
       8,    27,   674,   560,   403,  1213,   246,   560,   676,   693,
     695,   696,  1108,   517,   942,  1114,   906,   568,  1031,   562,
     561,   561,   562,   891,   561,   892,   562,   561,   561,   561,
      18,   561,   517,   561,   561,   561,   561,   562,   562,   517,
     562,   562,   882,   561,   554,   561,   562,   562,   561,   561,
     562,   561,   568,   561,   562,   561,   562,   562,   562,   561,
     562,   561,   562,   171,   562,   562,   561,   562,   561,   562,
     562,   561,   562,   561,   561,   562,   561,   562,   562,   562,
     884,   562,   561,   562,   562,   561,   562,   562,   561,   562,
     561,   562,   561,   562,   562,   562,   561,   560,   562,   891,
     561,   561,   561,   891,   561,   561,   562,   562,   561,   561,
     562,   561,   562,   561,   561,   561,   561,   561,   561,   561,
     562,   562,   561,   562,   561,   225,   561,   561,   562,   562,
     562,   561,   562,   562,   561,   561,   561,   562,   171,   562,
     562,   891,   561,   561,   561,   562,   562,   562,   561,   171,
     861,   171,   861,   171,   861,   171,   561,   562,   562,   561,
     561,   561,   561,   561,   562,   561,   562,   561,   861,   532,
     546,   903,   843,   842,   895,   565,   187,   252,   425,  1129,
     427,  1114,   155,   330,   491,   507,   560,   861,  1198,   146,
     946,   864,    16,   935,   935,   560,   872,   864,   864,   861,
     876,   877,   878,   560,   568,   584,   256,   561,   562,   568,
     568,   485,   485,   485,  1150,   943,   959,   960,   997,   476,
    1113,   562,   836,   537,   252,   485,   811,   683,   998,   560,
    1003,  1008,  1003,   561,   682,   999,  1101,  1102,  1105,  1114,
    1001,   342,   171,   171,   171,   841,   127,   906,   976,   168,
     256,   853,   975,   959,   849,    18,   859,  1111,  1114,   554,
    1114,   568,   227,   568,  1006,    32,   108,   738,   739,  1006,
    1116,   168,  1006,   567,  1116,    32,   108,   741,   742,  1116,
     965,  1040,   144,   530,   962,   962,   535,   942,  1044,   562,
     920,   925,   905,   230,   230,   348,   927,   230,   243,   406,
     927,   917,   905,  1018,  1019,  1105,   905,   940,   922,   923,
     964,   296,   955,   108,   743,   745,  1116,   739,    93,    93,
     109,   224,   769,  1107,   762,   762,    57,   166,   364,   504,
     710,   760,   709,   710,   769,  1107,   965,   964,  1107,   964,
    1111,  1111,   737,  1007,   964,   232,   232,  1107,  1107,   699,
    1007,   160,   237,   328,   702,   965,   965,  1107,   951,   952,
    1105,   108,   964,  1111,   964,   964,   373,   376,   701,   964,
    1108,    70,    71,   108,   130,   161,   383,   700,   699,   560,
     781,   705,   706,   707,   708,  1114,     8,   160,   788,   384,
     709,   751,   714,   568,   560,  1214,   561,   562,   476,   403,
     560,   112,   219,   511,   675,  1224,   105,   223,   381,   461,
     704,  1214,  1108,   246,   677,   682,   705,   210,   395,   679,
    1083,   562,   695,   594,   906,   953,   942,   940,   221,   861,
     861,   561,   861,   861,    32,    55,    94,    97,   105,   319,
     433,   481,   509,   893,   738,   895,   861,   738,   893,   861,
     895,   561,   871,   871,  1112,  1114,   861,   861,   895,  1112,
     861,   861,   861,   895,   331,   861,   861,   861,   861,   861,
     861,   861,   895,   895,   331,   861,   861,   895,   861,   861,
     861,   861,   895,   861,   864,  1104,   561,   561,   861,   861,
     861,   861,   861,   861,   861,   861,   861,   861,   861,   861,
     895,   221,   861,   861,   861,   861,   561,   861,   861,   861,
     861,   171,   861,   171,   861,   171,   861,   861,   331,   861,
     861,   547,   861,   861,   138,  1197,  1197,   561,   568,   568,
     568,  1116,   861,  1198,   561,   562,   561,   872,   863,   861,
    1198,   946,    16,   561,   856,   879,   880,   894,   895,  1114,
    1174,   554,   554,  1170,  1170,  1170,   560,   861,   337,  1013,
    1077,   835,   210,   839,  1117,   850,  1004,  1005,  1105,  1009,
     562,   560,  1000,   561,   561,   562,   568,  1189,   171,  1170,
    1170,  1170,   942,   942,   128,   349,   971,   972,   977,   511,
     225,  1111,  1114,   568,  1114,   244,  1114,    12,    32,   108,
     337,   861,  1136,    63,   744,   861,  1117,   336,   353,   476,
    1135,  1129,  1006,   958,   269,  1049,   591,  1192,   921,   243,
     230,   917,   927,   927,   230,   337,   337,   517,   562,  1017,
    1006,   165,   210,   516,   929,   850,   861,   956,  1103,   861,
     232,   232,   762,   769,   765,   126,   426,   782,   739,  1111,
     769,   787,  1111,   783,   562,    19,   113,   957,  1061,   561,
     562,  1114,  1108,    31,    32,    37,    39,    40,    41,    55,
      94,    97,   105,   124,   141,   161,   163,   182,   183,   223,
     250,   259,   260,   262,   290,   291,   292,   310,   311,   312,
     316,   319,   332,   333,   357,   359,   381,   424,   426,   436,
     477,   478,   481,   482,   483,   484,   524,   525,   543,   715,
     718,   719,   720,   721,   722,   723,   724,  1114,  1114,  1215,
      18,  1114,   704,  1231,   337,   609,   610,   612,  1114,   496,
      18,  1108,   561,   561,    18,   685,   695,   560,   942,   247,
     963,   861,   561,   561,   561,   560,   730,   731,   730,   560,
     725,   726,   731,   730,   223,   223,   561,   561,   561,   561,
     561,   561,   562,   883,   935,   935,   561,   561,   561,   561,
     561,   561,   562,   561,   561,   561,   561,   561,   562,   561,
     561,   561,   561,   561,   890,   954,   562,   562,   562,   561,
     561,   561,   561,   562,   561,   561,   561,   562,   225,   535,
     875,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     562,   561,   561,   561,   861,   561,   168,   561,   561,   562,
     562,   561,   562,   562,   561,   861,   561,   861,   561,   861,
     561,   561,   562,   561,   561,   861,   547,  1200,  1200,   568,
     770,   561,   895,   561,   562,   561,   863,   861,   562,   561,
     397,  1175,  1175,  1175,   108,   861,  1011,  1012,   129,  1083,
     241,   854,   562,  1006,  1010,  1011,  1008,  1002,  1000,  1101,
    1114,  1170,   959,   191,   947,  1113,  1113,   567,   973,   974,
    1116,   428,   554,   380,   393,   423,  1134,   745,  1006,   560,
     560,  1133,   861,   142,   561,   907,   348,   905,   917,   230,
     230,   905,   917,   910,   909,   911,  1019,   942,  1012,   761,
     930,   930,   930,   854,   562,   957,   769,   765,   560,   108,
     108,   713,   744,   715,   952,   561,   706,   752,   731,   731,
     730,   725,   361,   716,   725,   725,    20,    32,    45,   502,
     737,   747,    55,   524,   719,   721,   747,   747,    55,   525,
     525,   528,   725,   717,   730,   730,   747,   731,   730,    23,
      63,    67,   108,   330,   337,   364,   424,   504,   733,   734,
     735,   750,   867,   528,   731,   747,    32,   731,   748,   731,
     731,   730,   560,   726,   732,   568,   561,   562,  1216,  1217,
     496,   217,   225,   350,   613,   614,   615,   616,   856,   561,
     562,   611,  1111,  1216,   561,   678,   693,   560,   682,   767,
     768,  1114,   962,   935,   104,   261,   331,   497,   747,   331,
     861,   561,   561,   561,   861,   861,   422,   889,   331,   861,
     861,   861,   861,    40,   371,   561,   861,   935,   861,   861,
     861,   861,   861,   561,   561,   561,   331,   861,   561,  1114,
     561,   895,   857,   880,    58,   228,   324,   452,   463,   538,
    1166,  1167,   535,  1176,  1176,  1176,   561,   562,  1014,   222,
     684,  1005,  1012,   561,  1192,    44,   197,   944,   978,  1116,
     562,   303,    68,   498,   380,  1135,   476,   476,  1006,  1111,
     940,   230,   337,   913,   917,   917,   337,   915,   861,   861,
     560,   953,   168,   928,   924,  1103,   560,   560,   767,    97,
     478,   481,   552,   553,  1098,  1099,   788,   733,   283,   337,
     560,   753,   755,   756,   757,   433,   509,   544,   727,   728,
     729,   560,   727,   727,   748,    20,   502,   737,   749,   748,
     738,   747,   528,   727,   560,   747,   727,   743,  1111,   327,
     736,  1098,   511,   108,   232,   735,   232,   330,   747,   748,
     747,   748,   727,   331,   727,  1114,  1114,   535,  1219,   420,
     560,  1218,  1111,   561,   562,   611,  1108,  1225,   612,   715,
    1219,  1192,   679,   682,   680,   561,   562,   957,   560,   561,
     561,   561,   561,   561,   562,   561,   561,   562,   561,  1096,
     561,   562,   561,   562,   561,   561,   303,   151,   561,   561,
     561,   561,   561,   561,   561,   562,   561,   859,   476,   476,
     476,    16,  1165,   188,   284,   285,   288,   289,  1177,  1178,
    1012,   232,  1078,   703,   849,   959,   948,  1103,   945,   953,
      65,  1084,   974,   561,   561,  1136,    16,   905,   912,   517,
     914,   517,   934,  1114,   963,   230,   931,   703,   957,   767,
     767,   561,  1100,  1100,   784,   173,   352,   434,   112,   511,
     754,  1114,   757,   729,   771,  1096,   738,   748,   771,   860,
     327,   523,    49,    57,   252,   856,   856,  1232,   615,  1114,
     168,   403,   561,  1189,   768,   331,   331,   861,   891,   861,
     895,  1166,   342,   964,   964,   964,   964,  1178,   511,   472,
     853,   535,   562,   949,   957,   861,   959,   135,   145,   343,
     475,  1085,  1086,   249,  1087,   270,   337,   861,   560,   861,
     560,   561,   562,   560,   561,   561,   765,   788,    48,   328,
     401,   426,   758,   758,   561,   562,   561,   562,   561,   860,
      57,   342,    57,   843,   842,   600,   715,   856,  1226,   681,
     957,   561,   561,   561,   562,   561,   561,   561,  1020,  1021,
    1105,  1108,    86,   408,  1103,   366,   966,    44,    44,   135,
      44,  1086,   453,   475,  1088,  1089,   142,   919,   934,   934,
    1114,   932,   933,   751,   765,     5,   108,   330,   755,  1114,
     747,  1096,   747,   342,   342,   561,   118,   601,   602,   867,
    1233,   131,   715,  1192,   861,   562,  1006,  1079,   957,  1114,
    1096,  1096,    44,  1096,    44,    44,  1089,   965,   861,   561,
     561,   561,  1192,   118,    60,   157,   209,   229,   242,   340,
     404,   548,   633,   634,   637,   646,   647,   650,   661,   664,
     666,   667,  1110,  1115,  1119,   414,  1227,   561,  1021,  1012,
     737,   740,   967,  1096,  1096,  1096,    16,   565,  1114,   171,
     323,   639,   636,  1115,  1115,  1114,   635,   648,   651,   575,
     263,   394,   534,   670,    28,   668,   569,  1221,   600,   739,
    1080,   560,   274,   171,  1114,   641,   642,   861,   861,   532,
     653,   657,   618,   633,   618,   671,   669,   662,   665,   633,
    1228,  1084,   856,   968,   969,   970,   142,   222,   138,   861,
     649,   658,   546,   657,   660,   138,   633,   566,   510,   861,
     619,   670,   668,   633,  1087,   861,   561,   562,   964,   638,
     209,   547,   532,   652,   654,   861,   618,   138,   263,   566,
     673,   125,   106,   617,   620,   663,  1115,   663,   210,  1090,
     970,   640,  1114,   643,   655,   654,   660,   659,   548,   861,
     672,    80,   150,   625,   631,  1114,   138,   633,   566,   331,
     560,  1091,   562,   618,   861,   138,   547,   138,   618,   195,
     562,   621,    75,    89,   566,   249,   561,   567,  1092,  1093,
    1105,   426,  1094,  1114,   644,   656,   548,   618,   394,   138,
     168,  1114,   715,   168,   168,  1116,   561,   562,  1020,   132,
     546,   645,   547,   534,   622,   108,   632,   442,   628,   964,
     623,   624,  1093,   641,   618,   618,   441,   443,   626,   627,
     628,   630,   867,  1114,   861,   523,   629,   575,   562,   633,
     169,  1112,   627
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1208 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            if (!thd->bootstrap &&
              (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
            {
              my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
              MYSQL_YYABORT;
            }
            thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
            YYLIP->found_semicolon= NULL;
          }
    break;

  case 3:
#line 1220 "sql_yacc.yy"
    {
            Lex_input_stream *lip = YYLIP;

            if ((YYTHD->client_capabilities & CLIENT_MULTI_QUERIES) &&
                ! lip->stmt_prepare_mode &&
                ! (lip->ptr >= lip->end_of_query))
            {
              /*
                We found a well formed query, and multi queries are allowed:
                - force the parser to stop after the ';'
                - mark the start of the next query for the next invocation
                  of the parser.
              */
              lip->next_state= MY_LEX_END;
              lip->found_semicolon= lip->ptr;
            }
            else
            {
              /* Single query, terminated. */
              lip->found_semicolon= NULL;
            }
          }
    break;

  case 5:
#line 1245 "sql_yacc.yy"
    {
            /* Single query, not terminated. */
            YYLIP->found_semicolon= NULL;
          }
    break;

  case 57:
#line 1314 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(3) - (3)].lex_str);
        }
    break;

  case 60:
#line 1329 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[(2) - (4)].lex_str);
        }
    break;

  case 61:
#line 1338 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(1) - (1)].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 62:
#line 1345 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[(2) - (2)].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 63:
#line 1354 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[(2) - (2)].lex_str);
        }
    break;

  case 64:
#line 1361 "sql_yacc.yy"
    {}
    break;

  case 69:
#line 1375 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[(2) - (2)].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 70:
#line 1387 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 71:
#line 1395 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 72:
#line 1405 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 73:
#line 1411 "sql_yacc.yy"
    {}
    break;

  case 76:
#line 1420 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 77:
#line 1425 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 78:
#line 1430 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 79:
#line 1435 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 80:
#line 1440 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[(3) - (3)].ulong_num);
       }
    break;

  case 81:
#line 1444 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[(3) - (3)].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 82:
#line 1449 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 83:
#line 1453 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 84:
#line 1457 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 85:
#line 1461 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 86:
#line 1465 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[(3) - (3)].lex_str).str;
	 }
    break;

  case 88:
#line 1474 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[(3) - (3)].lex_str).str;
       }
    break;

  case 89:
#line 1478 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[(3) - (3)].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 90:
#line 1494 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[(3) - (3)].lex_str).str;
         }
    break;

  case 91:
#line 1498 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[(3) - (3)].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 92:
#line 1509 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[(5) - (5)].table), NULL,
						 TL_OPTION_UPDATING,
						 TL_WRITE))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[(2) - (5)].num) | (yyvsp[(4) - (5)].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	}
    break;

  case 93:
#line 1526 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 94:
#line 1528 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[(7) - (7)].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 95:
#line 1540 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[(2) - (11)].key_type), (yyvsp[(4) - (11)].lex_str).str, (yyvsp[(5) - (11)].key_alg), 0, lex->col_list);
            if (key == NULL)
              MYSQL_YYABORT;

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 96:
#line 1550 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 97:
#line 1555 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[(4) - (6)].lex_str).str;
            lex->create_info.options=(yyvsp[(3) - (6)].num);
	  }
    break;

  case 98:
#line 1562 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 99:
#line 1568 "sql_yacc.yy"
    {}
    break;

  case 100:
#line 1570 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 101:
#line 1577 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 102:
#line 1592 "sql_yacc.yy"
    {
            if (!(yyvsp[(1) - (3)].lex_str).str || check_db_name((yyvsp[(1) - (3)].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[(3) - (3)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[(1) - (3)].lex_str), (yyvsp[(3) - (3)].lex_str), true);
            if ((yyval.spname) == NULL)
              MYSQL_YYABORT;
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 103:
#line 1609 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            LEX_STRING db;

	    if (check_routine_name((yyvsp[(1) - (1)].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (lex->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[(1) - (1)].lex_str), false);
            if ((yyval.spname) == NULL)
              MYSQL_YYABORT;
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 104:
#line 1628 "sql_yacc.yy"
    {}
    break;

  case 105:
#line 1629 "sql_yacc.yy"
    {}
    break;

  case 106:
#line 1633 "sql_yacc.yy"
    {}
    break;

  case 107:
#line 1634 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1640 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[(2) - (2)].lex_str); }
    break;

  case 109:
#line 1642 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 110:
#line 1644 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 111:
#line 1646 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 112:
#line 1648 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 113:
#line 1650 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 114:
#line 1652 "sql_yacc.yy"
    { }
    break;

  case 115:
#line 1657 "sql_yacc.yy"
    { }
    break;

  case 116:
#line 1658 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 117:
#line 1659 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 118:
#line 1664 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 119:
#line 1668 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 120:
#line 1675 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[(2) - (2)].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[(2) - (2)].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 121:
#line 1683 "sql_yacc.yy"
    {}
    break;

  case 126:
#line 1699 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(3) - (3)].item));
	  }
    break;

  case 127:
#line 1703 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[(1) - (1)].item));
	  }
    break;

  case 132:
#line 1721 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 133:
#line 1741 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(1) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(1) - (3)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(3) - (3)].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(3) - (3)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 138:
#line 1778 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (4)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[(3) - (4)].lex_str),
                                                     (enum enum_field_types)(yyvsp[(4) - (4)].num),
                                                     (sp_param_mode_t)(yyvsp[(1) - (4)].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[(4) - (4)].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 139:
#line 1803 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 140:
#line 1804 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 141:
#line 1805 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 142:
#line 1806 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 143:
#line 1810 "sql_yacc.yy"
    {}
    break;

  case 145:
#line 1815 "sql_yacc.yy"
    {}
    break;

  case 147:
#line 1821 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 148:
#line 1825 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[(2) - (3)].spblock).vars || (yyvsp[(2) - (3)].spblock).conds) && ((yyvsp[(1) - (3)].spblock).curs || (yyvsp[(1) - (3)].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[(2) - (3)].spblock).curs && (yyvsp[(1) - (3)].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[(1) - (3)].spblock).vars + (yyvsp[(2) - (3)].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[(1) - (3)].spblock).conds + (yyvsp[(2) - (3)].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[(1) - (3)].spblock).hndlrs + (yyvsp[(2) - (3)].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[(1) - (3)].spblock).curs + (yyvsp[(2) - (3)].spblock).curs;
	  }
    break;

  case 149:
#line 1851 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
            lex->spcont->declare_var_boundary((yyvsp[(2) - (2)].num));
          }
    break;

  case 150:
#line 1860 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            if (pctx == 0)
            {
              MYSQL_YYABORT;
            }
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[(4) - (5)].num);
            Item *dflt_value_item= (yyvsp[(5) - (5)].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              if (dflt_value_item == NULL)
                MYSQL_YYABORT;
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[(2) - (5)].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              sp_instr_set *is= new sp_instr_set(lex->sphead->instructions(),
                                                 pctx,
                                                 var_idx,
                                                 dflt_value_item,
                                                 var_type,
                                                 lex,
                                                 (i == num_vars - 1));
              if (is == NULL)
                MYSQL_YYABORT;

              lex->sphead->add_instr(is);
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[(2) - (5)].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 151:
#line 1921 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[(2) - (5)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[(2) - (5)].lex_str), (yyvsp[(5) - (5)].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 152:
#line 1935 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            lex->spcont= lex->spcont->push_context(LABEL_HANDLER_SCOPE);

	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[(2) - (4)].num),
	                              ctx->current_var_count());
            if (i == NULL)
              MYSQL_YYABORT;

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 153:
#line 1952 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[(2) - (7)].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
              if (i == NULL )
                MYSQL_YYABORT;
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);

            lex->spcont= ctx->pop_context();

	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[(6) - (7)].num);
	    lex->spcont->add_handlers((yyvsp[(6) - (7)].num));
	  }
    break;

  case 154:
#line 1984 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[(2) - (5)].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[(2) - (5)].lex_str).str);
	      delete (yyvsp[(5) - (5)].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[(5) - (5)].lex),
                                  ctx->current_cursor_count());
	    if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[(2) - (5)].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 155:
#line 2009 "sql_yacc.yy"
    {
	    if(Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 156:
#line 2019 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 157:
#line 2041 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 158:
#line 2042 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 159:
#line 2048 "sql_yacc.yy"
    { (yyval.num)= 1; }
    break;

  case 160:
#line 2050 "sql_yacc.yy"
    { (yyval.num)+= 1; }
    break;

  case 161:
#line 2055 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont->parent_context();

	    if (ctx->find_handler((yyvsp[(1) - (1)].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[(1) - (1)].spcondtype));
	      ctx->push_handler((yyvsp[(1) - (1)].spcondtype));
	    }
	  }
    break;

  case 162:
#line 2078 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[(1) - (1)].ulong_num);
	  }
    break;

  case 163:
#line 2086 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[(3) - (3)].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[(3) - (3)].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 164:
#line 2102 "sql_yacc.yy"
    {}
    break;

  case 165:
#line 2103 "sql_yacc.yy"
    {}
    break;

  case 166:
#line 2108 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[(1) - (1)].spcondtype);
	  }
    break;

  case 167:
#line 2112 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[(1) - (1)].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 168:
#line 2121 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 169:
#line 2128 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 170:
#line 2135 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
            if ((yyval.spcondtype) == NULL)
              YYABORT;
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 171:
#line 2145 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(1) - (1)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(1) - (1)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 172:
#line 2160 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[(3) - (3)].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[(3) - (3)].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[(1) - (3)].num) + 1;
	  }
    break;

  case 173:
#line 2177 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 174:
#line 2178 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[(2) - (2)].item); }
    break;

  case 175:
#line 2182 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= YYLIP;

	    if (lex->sphead->reset_lex(thd))
              MYSQL_YYABORT;
	    lex->sphead->m_tmp_query= lip->tok_start;
	  }
    break;

  case 176:
#line 2192 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
	    LEX *lex= thd->lex;
            Lex_input_stream *lip= YYLIP;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i= new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);
              if (i == NULL)
                MYSQL_YYABORT;
              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lip->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lip->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(thd->mem_root,
                                           sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(thd);
          }
    break;

  case 177:
#line 2234 "sql_yacc.yy"
    {
            if(Lex->sphead->reset_lex(YYTHD))
               MYSQL_YYABORT;
          }
    break;

  case 178:
#line 2239 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[(3) - (3)].item),
                                      sp->m_return_field_def.sql_type, lex);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 179:
#line 2262 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 180:
#line 2264 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 182:
#line 2267 "sql_yacc.yy"
    {}
    break;

  case 183:
#line 2268 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 184:
#line 2274 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 185:
#line 2280 "sql_yacc.yy"
    {}
    break;

  case 186:
#line 2282 "sql_yacc.yy"
    {}
    break;

  case 187:
#line 2284 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;
              /*
                When jumping to a BEGIN-END block end, the target jump
                points to the block hpop/cpop cleanup instructions,
                so we should exclude the block context here.
                When jumping to something else (i.e., SP_LAB_ITER),
                there are no hpop/cpop at the jump destination,
                so we should include the block context here for cleanup.
              */
              bool exclusive= (lab->type == SP_LAB_BEGIN);

	      n= ctx->diff_handlers(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, exclusive);
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx);
              if (i == NULL)
                MYSQL_YYABORT;
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 188:
#line 2334 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(2) - (2)].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_hpop *hpop= new sp_instr_hpop(ip++, ctx, n);
                if (hpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(hpop);
              }
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
              {
                sp_instr_cpop *cpop= new sp_instr_cpop(ip++, ctx, n);
                if (cpop == NULL)
                  MYSQL_YYABORT;
	        sp->add_instr(cpop);
              }
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              if (i == NULL)
                MYSQL_YYABORT;
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2374 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2391 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(3) - (4)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(3) - (4)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2408 "sql_yacc.yy"
    { }
    break;

  case 192:
#line 2410 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[(2) - (2)].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[(2) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	  }
    break;

  case 196:
#line 2436 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(1) - (1)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:
#line 2457 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[(3) - (3)].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[(3) - (3)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2479 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 199:
#line 2484 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[(2) - (3)].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:
#line 2499 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);
            if (i == NULL)
              MYSQL_YYABORT;
	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:
#line 2511 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:
#line 2531 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            if (lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 208:
#line 2538 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[(3) - (3)].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2549 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:
#line 2557 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:
#line 2565 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:
#line 2583 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 217:
#line 2588 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2597 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 219:
#line 2605 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT; /* For expr $3 */
          }
    break;

  case 220:
#line 2610 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[(3) - (3)].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2617 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 222:
#line 2625 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            if (i == NULL)
              MYSQL_YYABORT;
            sp->add_instr(i);
          }
    break;

  case 224:
#line 2640 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:
#line 2658 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

	    if ((yyvsp[(5) - (5)].lex_str).str)
	    {
	      if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lab);
	  }
    break;

  case 226:
#line 2675 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 227:
#line 2676 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[(1) - (1)].lex_str); }
    break;

  case 228:
#line 2681 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *ctx= lex->spcont;
            sp_label_t *lab= ctx->find_label((yyvsp[(1) - (2)].lex_str).str);

            if (lab)
            {
              my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[(1) - (2)].lex_str).str);
              MYSQL_YYABORT;
            }

            lab= lex->spcont->push_label((yyvsp[(1) - (2)].lex_str).str,
                                         lex->sphead->instructions());
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 229:
#line 2697 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_label_t *lab= lex->spcont->pop_label();

            if ((yyvsp[(5) - (5)].lex_str).str)
            {
              if (my_strcasecmp(system_charset_info, (yyvsp[(5) - (5)].lex_str).str, lab->name) != 0)
              {
                my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[(5) - (5)].lex_str).str);
                MYSQL_YYABORT;
              }
            }
          }
    break;

  case 230:
#line 2713 "sql_yacc.yy"
    { /* Unlabeled blocks get a secret label. */
            LEX *lex= Lex;
            uint ip= lex->sphead->instructions();
            sp_label_t *lab= lex->spcont->push_label((char *)"", ip);
            lab->type= SP_LAB_BEGIN;
          }
    break;

  case 231:
#line 2720 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            lex->spcont->pop_label();
          }
    break;

  case 232:
#line 2728 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    lex->spcont= lex->spcont->push_context(LABEL_DEFAULT_SCOPE);
	  }
    break;

  case 233:
#line 2737 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[(3) - (5)].spblock).hndlrs)
            {
              sp_instr_hpop *hpop= new sp_instr_hpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).hndlrs);
              if (hpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(hpop);
            }
	    if ((yyvsp[(3) - (5)].spblock).curs)
            {
              sp_instr_cpop *cpop= new sp_instr_cpop(sp->instructions(), ctx,
                                                     (yyvsp[(3) - (5)].spblock).curs);
              if (cpop == NULL)
                MYSQL_YYABORT;
	      sp->add_instr(cpop);
            }
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 234:
#line 2766 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
	  }
    break;

  case 235:
#line 2776 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 236:
#line 2781 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[(3) - (4)].item), lex);
            if (i == NULL)
              MYSQL_YYABORT;
	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 237:
#line 2796 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);
            if (i == NULL)
              MYSQL_YYABORT;
	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 238:
#line 2807 "sql_yacc.yy"
    {
            if (Lex->sphead->reset_lex(YYTHD))
              MYSQL_YYABORT;
          }
    break;

  case 239:
#line 2812 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[(5) - (7)].item), lab->ip,
                                                               lex);
            if (i == NULL)
              MYSQL_YYABORT;
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 240:
#line 2830 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 241:
#line 2832 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 242:
#line 2837 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 243:
#line 2839 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 244:
#line 2841 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 245:
#line 2845 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2846 "sql_yacc.yy"
    {}
    break;

  case 247:
#line 2848 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(2) - (2)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 248:
#line 2854 "sql_yacc.yy"
    {
            Lex->create_info.options|= HA_LEX_CREATE_TABLE_LIKE;
            if (!Lex->select_lex.add_table_to_list(YYTHD, (yyvsp[(3) - (4)].table), NULL, 0, TL_READ))
              MYSQL_YYABORT;
          }
    break;

  case 249:
#line 2862 "sql_yacc.yy"
    {}
    break;

  case 250:
#line 2863 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 251:
#line 2863 "sql_yacc.yy"
    {}
    break;

  case 252:
#line 2867 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2869 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 254:
#line 2869 "sql_yacc.yy"
    {}
    break;

  case 255:
#line 2871 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 256:
#line 2871 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2876 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 258:
#line 2892 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 259:
#line 2896 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 260:
#line 2906 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2907 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2910 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2911 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2914 "sql_yacc.yy"
    {}
    break;

  case 265:
#line 2915 "sql_yacc.yy"
    {}
    break;

  case 266:
#line 2918 "sql_yacc.yy"
    {}
    break;

  case 267:
#line 2919 "sql_yacc.yy"
    {}
    break;

  case 268:
#line 2922 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 269:
#line 2923 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (1)].num);}
    break;

  case 270:
#line 2926 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (1)].num); }
    break;

  case 271:
#line 2927 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 272:
#line 2930 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 273:
#line 2933 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 274:
#line 2934 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 282:
#line 2950 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 283:
#line 2951 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[(3) - (3)].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 284:
#line 2952 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 285:
#line 2953 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 286:
#line 2954 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 287:
#line 2955 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[(3) - (3)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 288:
#line 2956 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[(3) - (3)].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 289:
#line 2957 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[(3) - (3)].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 290:
#line 2959 "sql_yacc.yy"
    {
            switch((yyvsp[(3) - (3)].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 291:
#line 2974 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 292:
#line 2979 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 293:
#line 2980 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[(3) - (3)].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 294:
#line 2981 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[(3) - (3)].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 295:
#line 2983 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 296:
#line 2988 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 297:
#line 2993 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 298:
#line 2998 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 301:
#line 3014 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[(3) - (3)].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 302:
#line 3015 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[(4) - (4)].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 303:
#line 3016 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[(4) - (4)].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 304:
#line 3017 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[(3) - (3)].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[(3) - (3)].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 305:
#line 3022 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[(4) - (4)].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 306:
#line 3039 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[(4) - (4)].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[(4) - (4)].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[(4) - (4)].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[(4) - (4)].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 307:
#line 3055 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[(1) - (1)].lex_str).str,(yyvsp[(1) - (1)].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[(1) - (1)].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 308:
#line 3064 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 309:
#line 3065 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 310:
#line 3066 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 311:
#line 3067 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 312:
#line 3068 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 313:
#line 3069 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 314:
#line 3072 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 315:
#line 3073 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 316:
#line 3074 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[(1) - (1)].ulong_num);}
    break;

  case 317:
#line 3077 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 318:
#line 3078 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 319:
#line 3079 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 320:
#line 3082 "sql_yacc.yy"
    {}
    break;

  case 322:
#line 3086 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 323:
#line 3087 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 324:
#line 3088 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 325:
#line 3089 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 331:
#line 3104 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3111 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[(1) - (7)].key_type), (yyvsp[(2) - (7)].simple_string), (yyvsp[(7) - (7)].key_alg) ? (yyvsp[(7) - (7)].key_alg) : (yyvsp[(3) - (7)].key_alg), 0, lex->col_list);
            if (key == NULL)
              MYSQL_YYABORT;
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3121 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[(3) - (8)].simple_string) ? (yyvsp[(3) - (8)].simple_string):(yyvsp[(1) - (8)].simple_string);
            Key *key= new Key((yyvsp[(2) - (8)].key_type), key_name, (yyvsp[(4) - (8)].key_alg), 0, lex->col_list);
            if (key == NULL)
              MYSQL_YYABORT;
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3131 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[(4) - (8)].simple_string) ? (yyvsp[(4) - (8)].simple_string) : (yyvsp[(1) - (8)].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[(8) - (8)].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            if (key == NULL)
              MYSQL_YYABORT;
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            if (key == NULL)
              MYSQL_YYABORT;
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 335:
#line 3152 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 336:
#line 3156 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 340:
#line 3171 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 341:
#line 3172 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[(1) - (1)].simple_string); }
    break;

  case 342:
#line 3176 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[(2) - (2)].simple_string); }
    break;

  case 343:
#line 3181 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 344:
#line 3189 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[(1) - (4)].lex_str).str,
				(enum enum_field_types) (yyvsp[(3) - (4)].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 345:
#line 3202 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 346:
#line 3203 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[(1) - (3)].num); }
    break;

  case 347:
#line 3204 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 348:
#line 3205 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 349:
#line 3207 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 350:
#line 3208 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 351:
#line 3210 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 352:
#line 3212 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 353:
#line 3213 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 354:
#line 3215 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 355:
#line 3217 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 356:
#line 3220 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 357:
#line 3222 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 358:
#line 3225 "sql_yacc.yy"
    { (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 359:
#line 3226 "sql_yacc.yy"
    { (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 360:
#line 3228 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 361:
#line 3230 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 362:
#line 3231 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 363:
#line 3232 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 364:
#line 3234 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 365:
#line 3246 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 366:
#line 3247 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 367:
#line 3249 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 368:
#line 3252 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[(1) - (1)].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 369:
#line 3263 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 370:
#line 3265 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 371:
#line 3267 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 372:
#line 3269 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 373:
#line 3270 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 374:
#line 3271 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 375:
#line 3272 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 376:
#line 3273 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 377:
#line 3275 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3277 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 379:
#line 3279 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 380:
#line 3280 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 381:
#line 3281 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 382:
#line 3282 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 383:
#line 3283 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 384:
#line 3284 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 385:
#line 3286 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 386:
#line 3294 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 387:
#line 3295 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 388:
#line 3296 "sql_yacc.yy"
    { Lex->length= (c