/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ErrorHandler;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.ErrorDialog;

public class AjdeErrorHandler
implements ErrorHandler {
    public void handleWarning(String message) {
        JOptionPane.showMessageDialog(AjdeUIManager.getDefault().getRootFrame(), message, "AJDE Warning", 2);
    }

    public void handleError(String errorMessage) {
        this.handleError(errorMessage, null);
    }

    public void handleError(String message, Throwable t) {
        String stack = this.getStackTraceAsString(t);
        Ajde.getDefault().logEvent("Error: " + stack);
        ErrorDialog errorDialog = new ErrorDialog(AjdeUIManager.getDefault().getRootFrame(), "AJDE Error", t, message, stack);
        ((Component)errorDialog).setVisible(true);
    }

    private String getStackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        if (t != null) {
            t.printStackTrace(new PrintWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        return "<no stack trace available>";
    }
}

