/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.boot;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.internal.boot.OldPlatformConfiguration;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.osgi.service.environment.Constants;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class BootLoader
implements Constants {
    public static boolean CONFIGURATION_DEBUG = false;
    public static final String PI_BOOT = "org.eclipse.core.boot";
    private static final String[] ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86"};
    private static final String[] OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
    private static final String[] WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    static /* synthetic */ Class class$0;

    private BootLoader() {
    }

    public static String[] getCommandLineArgs() {
        return InternalPlatform.getDefault().getAppArgs();
    }

    public static IPlatformConfiguration getCurrentPlatformConfiguration() {
        ServiceReference configFactorySR;
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.update.configurator.IPlatformConfigurationFactory;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configFactorySR = context.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException();
        }
        IPlatformConfigurationFactory configFactory = (IPlatformConfigurationFactory)context.getService(configFactorySR);
        if (configFactory == null) {
            throw new IllegalStateException();
        }
        org.eclipse.update.configurator.IPlatformConfiguration currentConfig = configFactory.getCurrentPlatformConfiguration();
        context.ungetService(configFactorySR);
        return new OldPlatformConfiguration(currentConfig);
    }

    public static URL getInstallURL() {
        return InternalPlatform.getDefault().getInstallURL();
    }

    public static String getNL() {
        return InternalPlatform.getDefault().getEnvironmentInfoService().getNL();
    }

    public static String getOS() {
        return InternalPlatform.getDefault().getEnvironmentInfoService().getOS();
    }

    public static String getOSArch() {
        return InternalPlatform.getDefault().getEnvironmentInfoService().getOSArch();
    }

    public static IPlatformConfiguration getPlatformConfiguration(URL url) throws IOException {
        ServiceReference configFactorySR;
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.update.configurator.IPlatformConfigurationFactory;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configFactorySR = context.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException();
        }
        IPlatformConfigurationFactory configFactory = (IPlatformConfigurationFactory)context.getService(configFactorySR);
        if (configFactory == null) {
            throw new IllegalStateException();
        }
        org.eclipse.update.configurator.IPlatformConfiguration config = configFactory.getPlatformConfiguration(url);
        context.ungetService(configFactorySR);
        return new OldPlatformConfiguration(config);
    }

    public static String getWS() {
        return InternalPlatform.getDefault().getEnvironmentInfoService().getWS();
    }

    public static String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public static String[] knownOSValues() {
        return OS_LIST;
    }

    public static String[] knownWSValues() {
        return WS_LIST;
    }

    public static boolean inDebugMode() {
        return System.getProperty("osgi.debug") != null;
    }

    public static boolean inDevelopmentMode() {
        return System.getProperty("osgi.dev") != null;
    }

    public static boolean isRunning() {
        return InternalPlatform.getDefault().isRunning();
    }

    public static URL[] getPluginPath(URL pluginPathLocation) {
        return InternalPlatform.getDefault().getPluginPath(pluginPathLocation);
    }
}

