/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;

public class MethodInfo
extends ClassFileStruct
implements IBinaryMethod,
AttributeNamesConstants,
Comparable {
    private char[][] exceptionNames;
    private int[] constantPoolOffsets;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private int accessFlags;
    private char[] name;
    private char[] signature;
    private int attributeBytes;
    private static final char[][] noException = CharOperation.NO_CHAR_CHAR;

    public MethodInfo(byte[] classFileBytes, int[] offsets, int offset) {
        super(classFileBytes, offset);
        this.constantPoolOffsets = offsets;
        this.accessFlags = -1;
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public char[][] getArgumentNames() {
        return null;
    }

    public char[][] getExceptionTypeNames() {
        if (this.exceptionNames == null) {
            this.readExceptionAttributes();
        }
        return this.exceptionNames;
    }

    public char[] getMethodDescriptor() {
        if (this.signature == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.signature = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.signature;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readDeprecatedAndSyntheticAttributes();
            if (this.isDeprecated) {
                this.accessFlags |= 0x100000;
            }
            if (this.isSynthetic) {
                this.accessFlags |= 0x20000;
            }
        }
        return this.accessFlags;
    }

    public char[] getSelector() {
        if (this.name == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.name;
    }

    public boolean isClinit() {
        char[] selector = this.getSelector();
        return selector[0] == '<' && selector.length == 8;
    }

    public boolean isConstructor() {
        char[] selector = this.getSelector();
        return selector[0] == '<' && selector.length == 6;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x20000) != 0;
    }

    private void readDeprecatedAndSyntheticAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.DeprecatedName)) {
                this.isDeprecated = true;
            } else if (CharOperation.equals(attributeName, AttributeNamesConstants.SyntheticName)) {
                this.isSynthetic = true;
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
    }

    private void readExceptionAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.ExceptionsName)) {
                int entriesNumber = this.u2At(readOffset + 6);
                readOffset += 8;
                if (entriesNumber == 0) {
                    this.exceptionNames = noException;
                } else {
                    this.exceptionNames = new char[entriesNumber][];
                    int j = 0;
                    while (j < entriesNumber) {
                        utf8Offset = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset + 1)] - this.structOffset;
                        this.exceptionNames[j] = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
                        readOffset += 2;
                        ++j;
                    }
                }
            } else {
                readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            }
            ++i;
        }
        if (this.exceptionNames == null) {
            this.exceptionNames = noException;
        }
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public String toString() {
        int modifiers = this.getModifiers();
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        return buffer.append("{").append(String.valueOf((modifiers & 0x100000) != 0 ? "deprecated " : "") + ((modifiers & 1) == 1 ? "public " : "") + ((modifiers & 2) == 2 ? "private " : "") + ((modifiers & 4) == 4 ? "protected " : "") + ((modifiers & 8) == 8 ? "static " : "") + ((modifiers & 0x10) == 16 ? "final " : "") + ((modifiers & 0x40) == 64 ? "volatile " : "") + ((modifiers & 0x80) == 128 ? "transient " : "")).append(this.getSelector()).append(this.getMethodDescriptor()).append("}").toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof MethodInfo)) {
            throw new ClassCastException();
        }
        MethodInfo otherMethod = (MethodInfo)o;
        int result = new String(this.getSelector()).compareTo(new String(otherMethod.getSelector()));
        if (result != 0) {
            return result;
        }
        return new String(this.getMethodDescriptor()).compareTo(new String(otherMethod.getMethodDescriptor()));
    }

    void initialize() {
        this.getModifiers();
        this.getSelector();
        this.getMethodDescriptor();
        this.getExceptionTypeNames();
        this.reset();
    }

    protected void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }
}

