/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        IIndex[] indexes = this.getIndexes(progressMonitor);
        try {
            int max = indexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.search(indexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            Object var6_7 = null;
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block9: {
                Object var6_8 = null;
                if (progressMonitor == null) break block9;
                progressMonitor.done();
            }
            throw throwable;
        }
    }

    public IIndex[] getIndexes(IProgressMonitor progressMonitor) {
        IPath[] indexPathes = this.participant.selectIndexes(this.pattern, this.scope);
        int length = indexPathes.length;
        IIndex[] indexes = new IIndex[length];
        int count = 0;
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        int i = 0;
        while (i < length) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IIndex index = indexManager.getIndex(indexPathes[i], true, false);
            if (index != null) {
                indexes[count++] = index;
            }
            ++i;
        }
        if (count != length) {
            IIndex[] iIndexArray = indexes;
            indexes = new IIndex[count];
            System.arraycopy(iIndexArray, 0, indexes, 0, count);
        }
        this.areIndexesReady = true;
        return indexes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean search(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        ReadWriteMonitor monitor = indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                block12: {
                    monitor.enterRead();
                    if (!index.hasChanged()) break block12;
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            indexManager.saveIndex(index);
                        }
                        catch (IOException e) {
                            Object var6_8 = null;
                            monitor.exitWriteEnterRead();
                            Object var8_11 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    {
                        Object var6_10 = null;
                        monitor.exitWriteEnterRead();
                    }
                }
                long start = System.currentTimeMillis();
                this.pattern.findIndexMatches(index, this.requestor, this.participant, this.scope, progressMonitor);
                this.executionTime += System.currentTimeMillis() - start;
                Object var8_12 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException e) {
                Object var8_13 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

