/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] exclusionPatterns;
    IProject project;

    public RemoveFolderFromIndex(IPath folderPath, char[][] exclusionPatterns, IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.exclusionPatterns = exclusionPatterns;
        this.project = project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                int max;
                monitor.enterRead();
                String[] paths = index.queryInDocumentNames(this.folderPath.toString());
                int i = 0;
                int n = max = paths == null ? 0 : paths.length;
                while (i < max) {
                    String documentPath = paths[i];
                    if (this.exclusionPatterns == null || !Util.isExcluded(new Path(documentPath), this.exclusionPatterns)) {
                        this.manager.remove(documentPath, this.containerPath);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:");
                    e.printStackTrace();
                }
                Object var8_9 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            monitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.containerPath;
    }
}

