/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;

public abstract class AndPattern
extends SearchPattern {
    public AndPattern(int patternKind, int matchRule) {
        super(patternKind, matchRule);
    }

    protected void findIndexMatches(IndexInput input, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor, char[] queryKey, char[] category) throws IOException {
        char[] pattern;
        EntryResult[] entries;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        long[] possibleRefs = null;
        int maxRefs = -1;
        this.resetQuery();
        SearchPattern indexRecord = null;
        while ((entries = input.queryEntries(pattern = CharOperation.concat(category, queryKey = this.encodeIndexKey()), 1)) != null) {
            int numFiles = input.getNumFiles();
            long[] references = null;
            int referencesLength = -1;
            int i = 0;
            int max = entries.length;
            while (i < max) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                char[] word = entry.getWord();
                char[] indexKey = CharOperation.subarray(word, category.length, word.length);
                indexRecord = this.getIndexRecord();
                indexRecord.decodeIndexKey(indexKey);
                if (this.isMatchingIndexRecord()) {
                    int[] fileReferences = entry.getFileReferences();
                    int j = 0;
                    int refLength = fileReferences.length;
                    while (j < refLength) {
                        int fileReference = fileReferences[j];
                        int vectorIndex = fileReference / 64;
                        if (references == null) {
                            referencesLength = numFiles / 64 + 1;
                            references = new long[referencesLength];
                        }
                        long mask = 1L << fileReference % 64;
                        int n = vectorIndex;
                        references[n] = references[n] | mask;
                        ++j;
                    }
                }
                ++i;
            }
            if (references == null) {
                return;
            }
            if (possibleRefs == null) {
                possibleRefs = references;
                maxRefs = numFiles;
            } else {
                int possibleLength = possibleRefs.length;
                int i2 = 0;
                int length = references.length;
                while (i2 < length) {
                    if (i2 < possibleLength) {
                        int n = i2;
                        possibleRefs[n] = possibleRefs[n] & references[i2];
                    } else {
                        possibleRefs[i2] = 0L;
                    }
                    ++i2;
                }
                while (--possibleLength >= 0 && possibleRefs[possibleLength] == 0L) {
                }
                if (possibleLength == -1) {
                    return;
                }
            }
            if (this.hasNextQuery()) continue;
        }
        if (possibleRefs != null) {
            int[] refs = new int[maxRefs];
            int refsLength = 0;
            int reference = 1;
            while (reference <= maxRefs) {
                int vectorIndex = reference / 64;
                if ((possibleRefs[vectorIndex] & 1L << reference % 64) != 0L) {
                    refs[refsLength++] = reference;
                }
                ++reference;
            }
            int[] nArray = refs;
            refs = new int[refsLength];
            System.arraycopy(nArray, 0, refs, 0, refsLength);
            int i = 0;
            while (i < refsLength) {
                String documentPath;
                IndexedFile file;
                int reference2 = refs[i];
                if (reference2 != -1 && (file = input.getIndexedFile(reference2)) != null && scope.encloses(documentPath = IndexedFile.convertPath(file.getPath())) && !requestor.acceptIndexMatch(documentPath, indexRecord, participant)) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
        }
    }

    protected abstract boolean hasNextQuery();

    protected abstract void resetQuery();
}

