

#include "myx_grt_private.h"
#include "myx_util_functions.h"



/*
  grt::DictValue getVersion(const grt::DictValue &params)
  {
    Value res;
    grt::BaseListValue args;
    
    args.insert(params);
    
    res= call_function("getVersion", args);
    if (!grt::DictValue::can_wrap(res))
      throw InvalidFunctionReturn("Sample", "getVersion", res);
    
    return grt::DictValue::cast_from(res);
  };
  
  grt::ListValue<grt::StringValue> getSchemata(const grt::DictValue &params)
  {
  };
  
  db_mysql_Catalog reverseEngineer(const grt::DictValue &params, 
                                   const grt::ListValue<grt::StringValue> &schemanames,
                                   int tables_only)
  {
  };
  
  grt::ListValue<db_CharacterSet> getCharacterSets(const grt::DictValue &params)
  {
  };
}
*/
  
static const char *module_wrapper_head=
  "// Automatically generated GRT module wrapper. Do not edit.\n\n";


static const char *module_base_template_h=
  "class %module_class_name% : public %parent_module_class_name% {\n"
  "protected:\n"
  "  %module_class_name%(grt::GRT *grt, const std::string &name= \"%module_name%\")\n"
  "  : %parent_module_class_name%(grt, name) {};\n"
  "\n"
  "public:\n"
  "  static std::string static_get_name() { return \"%module_name%\"; };\n"
  "  static %module_class_name%* get(grt::GRT *grt)\n"
  "  {\n"
  "    %module_class_name% *module= grt->get_module(\"%module_name%\");\n"
  "    if (!module)\n"
  "    {\n"
  "      module= new %module_class_name%(grt);\n"
  "      grt->register_module(module);\n"
  "    }\n"
  "    return module;\n"
  "  };\n";


static const char *module_base_template_f=
  "};\n";


static const char *module_function_template_void=
  "  void %function_name%(%args%)\n"
  "  {\n"
  "    ListValue args;\n"
  "    %make_args%\n"
  "    call_function(\"%function_name%\", args);\n"
  "  };\n";


static const char *module_function_template_int=
  "  int %function_name%(%args%)\n"
  "  {\n"
  "    ListValue args;\n"
  "    %make_args%\n"
  "    Value ret= call_function(\"%function_name%\", args);\n"
  "    if (ret.is_valid())\n"
  "       throw FunctionCallError(static_get_name(), \"%function_name%\");\n"
  "    if (!IntValue::can_take(ret))\n"
  "       throw InvalidFunctionReturn(static_get_name(), \"%function_name%\", ret);\n"
  "    return (int)IntValue(ret);\n"
  "  };\n";

static const char *module_function_template_double=
  "  double %function_name%(%args%)\n"
  "  {\n"
  "    ListValue args;\n"
  "    %make_args%\n"
  "    Value ret= call_function(\"%function_name%\", args);\n"
  "    if (ret.is_valid())\n"
  "       throw FunctionCallError(static_get_name(), \"%function_name%\");\n"
  "    if (!DoubleValue::can_take(ret))\n"
  "       throw InvalidFunctionReturn(static_get_name(), \"%function_name%\", ret);\n"
  "    return (double)DoubleValue(ret);\n"
  "  };\n";

static const char *module_function_template_string=
  "  std::string %function_name%(%args%)\n"
  "  {\n"
  "    ListValue args;\n"
  "    %make_args%\n"
  "    Value ret= call_function(\"%function_name%\", args);\n"
  "    if (ret.is_valid())\n"
  "       throw FunctionCallError(static_get_name(), \"%function_name%\");\n"
  "    if (!StringValue::can_take(ret))\n"
  "       throw InvalidFunctionReturn(static_get_name(), \"%function_name%\", ret);\n"
  "    return (std::string)StringValue(ret);\n"
  "  };\n";


static const char *module_function_template=
  "  %return_type% %function_name%(%args%)\n"
  "    ListValue args;\n"
  "    %make_args%\n"
  "    Value ret= call_function(\"%function_name%\", args);\n"
  "    if (ret.is_valid())\n"
  "       throw FunctionCallError(static_get_name(), \"%function_name%\");\n"
  "    if (!%return_type%::can_take(ret))\n"
  "       throw InvalidFunctionReturn(static_get_name(), \"%function_name%\", ret);\n"
  "    return %return_type%(ret);\n";



static char *get_type_str(MYX_GRT_VALUE_TYPE type, char *struct_name,
                          MYX_GRT_VALUE_TYPE content_type, char *content_struct_name)
{
  switch (type)
  {
  case MYX_INT_VALUE: return g_strdup("IntValue");
  case MYX_REAL_VALUE: return g_strdup("DoubleValue"); 
  case MYX_STRING_VALUE: return g_strdup("StringValue"); 
  case MYX_LIST_VALUE:
    switch (content_type)
    {
    case MYX_INT_VALUE: return g_strdup("ListValue<IntValue>"); 
    case MYX_REAL_VALUE: return g_strdup("ListValue<DoubleValue>"); 
    case MYX_STRING_VALUE: return g_strdup("ListValue<StringValue>");
    case MYX_OBJECT_VALUE:
      if (content_struct_name)
      {
        char *ptr= str_g_subst(content_struct_name, ".", "_");
        char *ret= g_strdup_printf("ListValue<%s>", ptr);
        g_free(ptr);
        return ret;
      }
      else
        return g_strdup("ListValue<ObjectValue>");
    default: return g_strdup("ListValue");
    }
    break;
  case MYX_DICT_VALUE: return g_strdup("DictValue");
  case MYX_OBJECT_VALUE:
    if (struct_name)
    {
      char *ptr= str_g_subst(struct_name, ".", "_");
      char *ret= g_strdup(struct_name);
      g_free(ptr);
      return ret;
    }
    else
      return g_strdup("ObjectValue");
  }
  return NULL;
}


static void export_module_function(FILE *f, MYX_GRT_FUNCTION *function)
{
  char *arglist= NULL;
  int i;
  const char *func_template= module_function_template;
  char *code;
  char *return_type= NULL;
  char **args;
  char **make_args;

  return_type= get_type_str(function->return_type, function->return_struct_name,
                            function->return_content_type, function->return_content_struct_name);
  
  switch (function->return_type)
  {
  case MYX_INT_VALUE: func_template= module_function_template_int; break;
  case MYX_REAL_VALUE: func_template= module_function_template_double; break;
  case MYX_STRING_VALUE: func_template= module_function_template_string; break;
  case MYX_LIST_VALUE:
  case MYX_DICT_VALUE:
  case MYX_OBJECT_VALUE: func_template= module_function_template; break;
  default: func_template= module_function_template_void; break;
  }

  args= g_new0(char*, function->params_num);
  make_args= g_new0(char*, function->params_num);
  
  for (i= 0; i < function->params_num; i++)
  {
    MYX_GRT_FUNCTION_PARAM *param= function->params+i;
    const char *proto_arg_type= NULL;
    char *arg_type= NULL;
    char buf[40];
    const char *arg_name;
    
    arg_type= get_type_str(param->type, param->struct_name,
                           param->content_type, param->content_struct_name);
    
    switch (param->type)
    {
    case MYX_INT_VALUE: proto_arg_type= "int"; break;
    case MYX_REAL_VALUE: proto_arg_type= "double"; break;
    case MYX_STRING_VALUE: proto_arg_type= "const std::string &"; break;
    case MYX_LIST_VALUE:
    case MYX_DICT_VALUE:
    case MYX_OBJECT_VALUE:
      break;
    default: g_warning("invalid parameter type found in module function %s",
                       function->name);
    }
    
    if (!param->name)
    {
      sprintf(buf, "param%i", i);
      arg_name= buf;
    }
    else
      arg_name= param->name;

    if (proto_arg_type)
    {
      args[i]= g_strdup_printf("%s %s", proto_arg_type, arg_name);
      make_args[i]= g_strdup_printf("    args.insert(%s(%s));", 
                                    arg_type, arg_name);
    }
    else
    {
      args[i]= g_strdup_printf("const %s& %s", arg_type, arg_name);
      make_args[i]= g_strdup_printf("    args.insert(%s);", arg_name);
    }
    g_free(arg_type);
  }

  {
    char *args_j= g_strjoinv(", ", args);
    char *make_args_j= g_strjoinv("\n", make_args);
    g_strfreev(args);
    g_strfreev(make_args);
  
    code= str_g_subst(func_template, "%return_type%", return_type);
    code= str_g_replace(code, "%function_name%", function->name);
    code= str_g_replace(code, "%args%", args_j);
    code= str_g_replace(code, "%make_args%", make_args_j);

    fprintf(f, "%s", code);

    g_free(code);
    g_free(args_j);
    g_free(make_args_j);
    g_free(return_type);
  }
}


MYX_GRT_ERROR myx_grt_modules_export_wrapper(MYX_GRT_MODULE **modules, int count,
                                             const char *path)
{
  FILE *f= fopen(path, "w+");
  int i;
  
  if (!f)
    return MYX_GRT_CANT_OPEN_FILE;

  fprintf(f, "%s", module_wrapper_head);
  
  for (i= 0; i < count; i++)
  {
    MYX_GRT_MODULE *module= modules[i];
    char *code;
    int j;
    char *tmp;
    
    code= str_g_subst(module_base_template_h, "%module_name%", module->name);

    tmp= g_strdup_printf("%sModule", module->name);
    code= str_g_replace(code, "%module_class_name%", tmp);
    g_free(tmp);

    if (module->extends)
    {
      tmp= g_strdup_printf("%sModule", module->extends);
      code= str_g_replace(code, "%parent_module_class_name%", tmp);
      g_free(tmp);
    }
    else
      code= str_g_replace(code, "%parent_module_class_name%", "grt::Module");

    fprintf(f, "%s", code);


    for (j= 0; j < module->functions_num; j++)
    {
      export_module_function(f, module->functions+j);
    }

    fprintf(f, "%s", module_base_template_f);
  }
  
  return MYX_GRT_NO_ERROR;
}





