
#include "myx_grt_public_interface.h"

static int generate_classes(const char *structs_file, const char *output_path_param)
{
  MYX_GRT_STRUCTS *gstructs;
  MYX_GRT_ERROR error;
  char *filename= g_path_get_basename(structs_file);

  // Check that the struct file begins with "structs."
  if ((!str_beginswith(filename, "structs.")) || (!str_endswith(filename, ".xml")))
  {
    fprintf(stdout, "ERROR: The structs file has to begin with \"structs.\" and "
            "end with \".xml\" but is named %s.\n", filename);
    g_free(filename);
    return -1;
  }

  // Load structs
  gstructs= myx_grt_struct_load_list(structs_file, &error);
  if ((!gstructs) || (error != MYX_GRT_NO_ERROR))
  {
    fprintf(stdout, "ERROR (%d): Cannot load structs from %s.\n", error, structs_file);
    g_free(filename);
    return -1;
  }
  else
  {
    {
      error= myx_grt_struct_export_cpp_classes(gstructs, output_path_param);

      if (error != MYX_GRT_NO_ERROR)
      {
        fprintf(stdout, "ERROR (%d): Cannot generate c++ class files in %s.\n", error, output_path_param);
        return -1;
      }
    }
  }
  return 0;
}


int main(int argc, char **argv)
{
  generate_classes(argv[1], argv[2]);
}
