#include "testgrt.h"


BEGIN_TEST_DATA_CLASS(grt_value)
  GRT grt;
END_TEST_DATA_CLASS


TEST_MODULE(grt_value, "GRT: values");


/*
 * For each simple value type test:
 * 
 * - create value
 * - get value content
 * - destroy value
 * - reference counting (initial should be 1 etc)
 * - test duplication
 */

TEST_FUNCTION(1)
{
  IntValue iv(1234);
  int i;
  
  i= iv;
  ensure_equals("IntValue to int", i, 1234);
  
  ensure_equals("IntValue refcount", myx_grt_value_get_current_reference_count(iv.grt_value()), 1);

  IntValue iv2(iv);
  ensure("IntValue copy constr", iv2.grt_value() == iv.grt_value());
  ensure_equals("IntValue refcount+1", myx_grt_value_get_current_reference_count(iv.grt_value()), 2);

  IntValue iv3;
  ensure("empty constructor", iv3.grt_value() == 0);
  
  iv3= iv;
  ensure("IntValue assign value", iv3.grt_value()==iv.grt_value());

  iv3= 5;
  ensure_equals("IntValue assign immediate", (int)iv3, 5);
  
  iv3= iv3+10;
  ensure_equals("IntValue assign", (int)iv3, 15);
  
  iv2= 0;
  ensure_equals("IntValue refcount-1", myx_grt_value_get_current_reference_count(iv.grt_value()), 1);

  StringValue s("hi");
  bool fail= false;
  ensure_equals("IntValue can_wrap", iv.can_wrap(s), false);
  try {
    iv.cast_from(s);
  }
  catch (...)
  {
    fail= true;
  };
  ensure("IntValue bad assign", fail==true);
}


TEST_FUNCTION(5)
{
  DoubleValue iv(1234.5678);
  double i;
  
  i= iv;
  ensure_equals("DoubleValue to double", i, 1234.5678);
  
  DoubleValue iv2(iv);
  ensure("DoubleValue copy constr", iv2.grt_value() == iv.grt_value());
  ensure_equals("DoubleValue refcount+1", myx_grt_value_get_current_reference_count(iv.grt_value()), 2);

  DoubleValue iv3;
  ensure("empty constructor", iv3.grt_value() == 0);
  
  iv3= iv;
  ensure("DoubleValue assign value", iv3.grt_value()==iv.grt_value());

  iv3= 1.5;
  ensure_equals("DoubleValue assign immediate", (double)iv3, 1.5);
  
  iv3= iv3+10;
  ensure_equals("DoubleValue assign", (double)iv3, 11.5);
}


TEST_FUNCTION(10)
{
  StringValue iv("hello");
  std::string s;
  
  s= iv;
  ensure_equals("StringValue to string", s, "hello");
  
  StringValue iv2(iv);
  ensure("StringValue copy constr", iv2.grt_value() == iv.grt_value());
  ensure_equals("StringValue refcount+1", myx_grt_value_get_current_reference_count(iv.grt_value()), 2);

  StringValue iv3;
  ensure("empty constructor", iv3.grt_value() == 0);
  
  iv3= iv;
  ensure("StringValue assign value", iv3.grt_value()==iv.grt_value());

  iv3= std::string("test");
  ensure_equals("StringValue assign immediate", (std::string)iv3, "test");
  
  iv3= (std::string)iv + " world";
  ensure_equals("StringValue assign", (std::string)iv3, "hello world");
}


TEST_FUNCTION(20)
{
  // set/get value by path
  
  
}


/*
 * For list test:
 * 
 * - create untyped list
 * - add values to list end
 * - insert value in random order
 * - remove values from list
 * - get back inserted values
 * - set new item
 * - check refcount of inserted values
 * - count items
 * - destroy value
 * - create typed list
 * - test duplication
 */


/*
 * For dict test:
 * 
 * - create untyped dict
 * - put stuff in it
 * - remove stuff
 * - overwrite stuff
 * - destroy
 * - duplication
 */


END_TESTS
