unit ModelProperties;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TntStdCtrls, MyxBaseForm, Grt;

type
  TModelPropertiesForm = class(TMyxBaseForm)
    TntGroupBox1: TTntGroupBox;
    CancelBtn: TTntButton;
    TntLabel1: TTntLabel;
    ModelNameEd: TTntEdit;
    ProjectNameEd: TTntEdit;
    TntLabel2: TTntLabel;
    TntLabel3: TTntLabel;
    VersionEd: TTntEdit;
    TntLabel4: TTntLabel;
    AuthorEd: TTntEdit;
    CreatedEd: TTntEdit;
    TntLabel5: TTntLabel;
    ChangedEd: TTntEdit;
    TntLabel6: TTntLabel;
    TntLabel7: TTntLabel;
    DescMemo: TTntMemo;
    OkBtn: TTntButton;
    procedure FormCreate(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  PropPath = '/workbench/model/properties';

implementation

{$R *.dfm}

// -----------------------------------------------------------------------------

procedure TModelPropertiesForm.FormCreate(Sender: TObject);

begin
  ModelNameEd.Text := Grt.GlobalAsString[PropPath + '/modelName'];
  ProjectNameEd.Text := Grt.GlobalAsString[PropPath + '/project'];
  VersionEd.Text := Grt.GlobalAsString[PropPath + '/version'];
  AuthorEd.Text := Grt.GlobalAsString[PropPath + '/author'];
  CreatedEd.Text := Grt.GlobalAsString[PropPath + '/dateCreated'];
  ChangedEd.Text := Grt.GlobalAsString[PropPath + '/dateChanged'];
  DescMemo.Lines.Text := Grt.GlobalAsString[PropPath + '/description'];
end;

// -----------------------------------------------------------------------------

procedure TModelPropertiesForm.OkBtnClick(Sender: TObject);

begin
  Grt.GlobalAsString[PropPath + '/modelName'] := ModelNameEd.Text;
  Grt.GlobalAsString[PropPath + '/project'] := ProjectNameEd.Text;
  Grt.GlobalAsString[PropPath + '/version'] := VersionEd.Text;
  Grt.GlobalAsString[PropPath + '/author'] := AuthorEd.Text;
  Grt.GlobalAsString[PropPath + '/description'] := DescMemo.Lines.Text;

  Close;
end;

// -----------------------------------------------------------------------------

procedure TModelPropertiesForm.CancelBtnClick(Sender: TObject);

begin
  Close;
end;

// -----------------------------------------------------------------------------

end.
