


#include "MYXMySQLResultSetSource.h"



MYXResultSetSource *open_connection()
{
  MYXMySQLResultSetSource *source= new MYXMySQLResultSetSource();
  
  if (!source->connect("localhost", 3661, "root", ""))
    g_error("can't connect to localhost");

  return source;
}



void test_query(MYXResultSetSource *source)
{
  source->push_schema("test");
  
  if (!source->execute("select * from foo"))
    g_error("error executing query");


  std::vector<MYXResultSetSource::ColumnInfo> cols= source->get_columns();

  const char *values[cols.size()];
  size_t lengths[cols.size()];

  while (source->next())
  {
    source->get_row(values, lengths);
    
    for (unsigned int i= 0; i < cols.size(); i++)
    {
      g_message("%s %s", cols[i].name, values[i]);
    }
    g_message("========");
  }
}




int main()
{
  MYXResultSetSource *source= open_connection();
  
  test_query(source);
  
  
}
